/*!
 * Font Awesome Pro 6.0.0-beta1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};

  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {}

  var _ref = _WINDOW.navigator || {},
      _ref$userAgent = _ref.userAgent,
      userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e) {
      return false;
    }
  }();

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);

      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }

      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  var w = WINDOW || {};
  if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
  if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
  if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;

      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }

      return acc;
    }, {});
  }

  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
        skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);

    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }
    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll easy the upgrade process for our users by automatically defining
     * this as well.
     */


    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", "M160 80c61.76 0 112 50.24 112 112V320c0 61.76-50.24 112-112 112S48 381.8 48 320V192C48 130.2 98.24 80 160 80zM160 32.01c-88.37 0-160 71.63-160 160v127.1c0 88.37 71.63 160 160 160c88.37 0 160-71.63 160-160V192C320 103.6 248.4 32.01 160 32.01z"],
    "1": [256, 512, [], "31", "M256 456c0 13.25-10.75 24-24 24h-208C10.75 480 0 469.3 0 456s10.75-24 24-24h80V98.95L36.58 140.4C25.3 147.4 10.53 143.9 3.563 132.6C-3.391 121.3 .1406 106.5 11.42 99.56l104-64c7.391-4.562 16.7-4.734 24.28-.5156C147.3 39.3 152 47.31 152 56V432h80C245.3 432 256 442.8 256 456z"],
    "2": [320, 512, [], "32", "M296 480h-272c-9.922 0-18.81-6.109-22.39-15.36s-1.078-19.75 6.266-26.42l205.8-186.7c41.23-35.58 46-95.23 11.3-136.2c-17.31-20.45-41.73-32.88-68.75-35.02c-27.2-2.172-53.39 6.391-73.84 24L43.34 139c-9.906 8.812-25.12 7.891-33.88-2c-8.812-9.906-7.906-25.08 2-33.88l39.34-34.97c30.52-26.28 69.3-39.02 109.2-35.72c39.88 3.141 75.97 21.55 101.6 51.83c51.08 60.31 43.84 151.5-16.12 203.2L86.19 432H296c13.25 0 24 10.75 24 24S309.3 480 296 480z"],
    "3": [320, 512, [], "33", "M188.3 480H98.14c-44.03 0-82.98-28.06-96.91-69.84c-4.188-12.58 2.594-26.17 15.17-30.36c12.61-4.234 26.17 2.609 30.36 15.17C54.16 417.1 74.8 432 98.14 432h90.17C234.5 432 272 394.5 272 348.3c0-46.16-37.55-83.7-83.69-83.7H88c-9.797 0-18.61-5.953-22.27-15.03C62.08 240.5 64.31 230.1 71.36 223.3L220.4 80H24C10.75 80 0 69.25 0 56S10.75 32 24 32h256c9.797 0 18.61 5.953 22.27 15.03c3.656 9.094 1.422 19.48-5.625 26.27L147.6 216.6h40.72C260.9 216.6 320 275.7 320 348.3C320 420.9 260.9 480 188.3 480z"],
    "4": [384, 512, [], "34", "M384 328c0 13.25-10.75 24-24 24l-39.1 .001L320 456c0 13.25-10.75 24-24 24s-24-10.75-24-24V352H24c-8.422 0-16.22-4.406-20.56-11.62c-4.344-7.203-4.594-16.17-.6406-23.61l144-272C153 33.08 167.6 28.62 179.2 34.8c11.7 6.188 16.17 20.72 9.969 32.44L63.86 304H272V152C272 138.8 282.8 128 296 128S320 138.8 320 152V304h40C373.3 304 384 314.8 384 328z"],
    "5": [320, 512, [], "35", "M187.7 480H105.7c-47.47 0-89.47-30.27-104.5-75.31c-4.203-12.58 2.594-26.17 15.17-30.36c12.56-4.219 26.17 2.609 30.36 15.17C55.25 414.9 78.94 432 105.7 432h81.95C234.2 432 272 394.2 272 347.7S234.2 263.4 187.7 263.4H24c-7.094 0-13.81-3.125-18.38-8.562C1.063 249.4-.8594 242.3 .3594 235.3l32-183.4C34.36 40.39 44.35 32 56 32H264C277.3 32 288 42.75 288 56S277.3 80 264 80H76.17L52.55 215.4h135.1C260.6 215.4 320 274.7 320 347.7S260.6 480 187.7 480z"],
    "6": [320, 512, [], "36", "M0 320c0 88.22 71.78 160 160 160s160-71.78 160-160S248.2 160 160 160C154.5 160 149.2 161.1 143.9 161.6l74.64-90.35c8.438-10.22 7-25.34-3.219-33.78C210.8 33.8 205.4 32 200 32c-6.906 0-13.75 2.969-18.5 8.719C37.81 214.7 0 244.4 0 320zM272 320c0 61.75-50.25 112-112 112S48 381.8 48 320S98.25 208 160 208S272 258.3 272 320z"],
    "7": [320, 512, [], "37", "M55.98 480c-4.203 0-8.469-1.094-12.33-3.422c-11.38-6.812-15.06-21.56-8.234-32.92L253.6 80H24C10.75 80 0 69.25 0 56S10.75 32 24 32h272c8.641 0 16.62 4.656 20.89 12.17c4.25 7.531 4.141 16.77-.3125 24.17l-240 400C72.08 475.8 64.13 480 55.98 480z"],
    "8": [320, 512, [], "38", "M259.7 250.2C286.6 227.4 304 193.9 304 156C304 87.63 248.4 32 180 32h-40C71.63 32 16 87.63 16 156c0 37.88 17.43 71.42 44.28 94.18C24.33 271.9 0 311 0 356C0 424.4 55.63 480 124 480h72C264.4 480 320 424.4 320 356C320 311 295.7 271.9 259.7 250.2zM140 80h40C221.9 80 256 114.1 256 156S221.9 232 180 232h-40C98.09 232 64 197.9 64 156S98.09 80 140 80zM196 432h-72c-41.91 0-76-34.09-76-76S82.09 280 124 280h72c41.91 0 76 34.09 76 76S237.9 432 196 432z"],
    "9": [320, 512, [], "39", "M320 192c0-88.22-71.78-160-160-160s-160 71.78-160 160S71.78 352 160 352c5.525 0 10.75-1.082 16.14-1.631L101.5 440.7c-8.438 10.22-7 25.34 3.219 33.78C109.2 478.2 114.6 480 120 480c6.906 0 13.75-2.969 18.5-8.719C282.2 297.3 320 267.6 320 192zM48 192c0-61.75 50.25-112 112-112s112 50.25 112 112S221.8 304 160 304S48 253.8 48 192z"],
    "360-degrees": [640, 512, [], "e2dc", "M496 64c-44.13 0-79.1 35.89-79.1 80v224c0 44.11 35.87 80 79.1 80s79.1-35.89 79.1-80v-224C576 99.89 540.1 64 496 64zM528 368c0 17.64-14.34 32-32 32s-32-14.36-32-32v-224c0-17.64 14.34-32 32-32s32 14.36 32 32V368zM304 192C292.6 192 281.8 194.5 272 198.8V196.7c0-36.77 23.19-70.05 60.5-86.84c12.09-5.453 17.47-19.66 12.03-31.73c-5.438-12.09-19.75-17.44-31.72-12.05C258 90.77 224 140.8 224 196.7L224 368c0 44.11 35.87 80 79.1 80s79.1-35.89 79.1-80l.0001-96C384 227.9 348.1 192 304 192zM336 368c0 17.64-14.34 32-32 32s-32-14.36-32-32v-96c0-17.64 14.34-32 32-32s32 14.36 32 32V368zM608 0c-17.67 0-31.1 14.33-31.1 32s14.33 32 31.1 32S640 49.67 640 32S625.7 0 608 0zM98.75 208.1l65.72-107.6C169 93.11 169.2 83.83 164.9 76.27C160.7 68.69 152.7 64 144 64H24C10.75 64 0 74.75 0 88S10.75 112 24 112h77.22L35.53 219.5C31 226.9 30.81 236.2 35.06 243.7C39.31 251.3 47.31 256 56 256h39.03C122 256 144 277.1 144 304.1v46.09C144 378 122 400 95.03 400c-16.41 0-31.62-8.156-40.72-21.8l-10.34-15.52c-7.344-11.03-22.22-14.02-33.28-6.656c-11.03 7.359-14 22.25-6.656 33.28l10.34 15.52C32.41 431.9 62.56 448 95.03 448C148.5 448 192 404.5 192 351V304.1C192 252.7 150.5 210 98.75 208.1z"],
    "a": [384, 512, [97], "41", "M382.1 446.7l-168-400c-7.469-17.81-36.78-17.81-44.25 0l-168 400c-5.141 12.22 .6094 26.3 12.83 31.42c12.25 5.156 26.3-.6094 31.42-12.83l33.79-80.45h224.2l33.79 80.45C341.7 474.5 350.6 480 360 480c3.094 0 6.25-.5938 9.281-1.875C381.5 473 387.3 458.9 382.1 446.7zM100.1 336.8L192 117.1l91.92 218.9H100.1z"],
    "abacus": [576, 512, [63040], "1f9ee", "M512 32H64c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64v-320C576 60.65 547.3 32 512 32zM128 264H112C103.2 264 96 271.2 96 280v16c0 8.836 7.164 16 16 16H128v24H112C103.2 336 96 343.2 96 352v16c0 8.836 7.164 16 16 16L128 384v48H64c-8.837 0-16-7.163-16-16V240H128V264zM128 128L112 128C103.2 128 96 135.2 96 144V160c0 8.836 7.164 16 16 16H128v32H48V96c0-8.837 7.163-16 16-16h64V128zM256 264H240C231.2 264 224 271.2 224 280v16c0 8.836 7.164 16 16 16H256v24H240C231.2 336 224 343.2 224 352v16c0 8.836 7.164 16 16 16L256 384v48H160V384l16 .0002c8.836 0 16-7.164 16-16V352c0-8.836-7.164-16-16-16H160V312h16c8.836 0 16-7.164 16-16v-16c0-8.836-7.164-16-16-16H160V240h96V264zM256 128L240 128C231.2 128 224 135.2 224 144V160c0 8.836 7.164 16 16 16H256v32H160v-32h16C184.8 176 192 168.8 192 160V144c0-8.836-7.164-15.1-16-15.1L160 128V80h96V128zM416 336h-16c-8.836 0-16 7.164-16 16v16c0 8.836 7.164 16 16 16L416 384v48h-128V384l16 .0002c8.836 0 16-7.164 16-16V352c0-8.836-7.164-16-16-16H288V312h16c8.836 0 16-7.164 16-16v-16c0-8.836-7.164-16-16-16H288V240h128V336zM416 128l-16 .0002C391.2 128 384 135.2 384 144V160c0 8.836 7.164 16 16 16H416v32h-128v-32h16C312.8 176 320 168.8 320 160V144c0-8.836-7.164-15.1-16-15.1L288 128V80h128V128zM512 432h-64V384l16 .0002c8.836 0 16-7.164 16-16V352c0-8.836-7.164-16-16-16H448v-96h80V416C528 424.8 520.8 432 512 432zM528 208H448v-32h16C472.8 176 480 168.8 480 160V144c0-8.836-7.164-15.1-16-15.1L448 128V80h64c8.837 0 16 7.163 16 16V208z"],
    "accent-grave": [192, 512, [], "60", "M40.3 90.61l67.69 115.4c6.688 11.43 18.84 18.03 31.51 18.03c4.164 0 8.381-.7115 12.48-2.2c16.59-6.018 26.48-22.99 23.49-40.31l-22.57-131.7c-3.045-17.81-13.79-33.2-29.45-42.25c-8.891-5.154-18.84-7.542-28.8-7.544c-25.06-.002-50.22 15.12-58.1 39.39C29.5 56.36 31.18 75.03 40.3 90.61zM80.77 55.77C82.28 51.61 88.75 48 94.65 48c1.316 .002 3.203 .1875 4.73 1.072c3.385 1.955 5.57 5.074 6.209 8.809l11.9 69.42L81.71 66.32C79.82 63.09 79.48 59.33 80.77 55.77z"],
    "acorn": [448, 512, [], "f6ae", "M447.1 160C447.1 107 404.1 64.04 352 64.04l-96.2 .0015c3.699-7.031 9.035-14.94 17.16-23.07c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0C218.3 27.79 208.7 48.57 204.2 64.04L96 64.04c-52.99 0-95.98 42.99-95.1 95.97L0 192c0 17.67 14.33 32 32 32l16 .0003C48 397.9 176.1 457.1 224 480c33.04-16.06 176-70.88 176-255.1L416 224c17.67 0 32-14.33 32-32L447.1 160zM224 426.6C135.1 383.4 96 302.3 96 224h256C352 298.8 316.7 381.6 224 426.6zM400 176H48l.002-15.98C48.01 133.6 69.54 112 96 112h256c26.46 0 47.99 21.52 48 47.96V176z"],
    "address-book": [512, 512, [62138, "contact-book"], "f2b9", "M272 288h-64C163.8 288 128 323.8 128 368C128 376.8 135.2 384 144 384h192c8.836 0 16-7.164 16-16C352 323.8 316.2 288 272 288zM240 256c35.35 0 64-28.65 64-64s-28.65-64-64-64c-35.34 0-64 28.65-64 64S204.7 256 240 256zM496 320H480v96h16c8.836 0 16-7.164 16-16v-64C512 327.2 504.8 320 496 320zM496 64H480v96h16C504.8 160 512 152.8 512 144v-64C512 71.16 504.8 64 496 64zM496 192H480v96h16C504.8 288 512 280.8 512 272v-64C512 199.2 504.8 192 496 192zM384 0H96C60.65 0 32 28.65 32 64v384c0 35.35 28.65 64 64 64h288c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM400 448c0 8.836-7.164 16-16 16H96c-8.836 0-16-7.164-16-16V64c0-8.838 7.164-16 16-16h288c8.836 0 16 7.162 16 16V448z"],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M208 256c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C144 227.3 172.7 256 208 256zM464 232h-96c-13.25 0-24 10.75-24 24s10.75 24 24 24h96c13.25 0 24-10.75 24-24S477.3 232 464 232zM240 288h-64C131.8 288 96 323.8 96 368C96 376.8 103.2 384 112 384h192c8.836 0 16-7.164 16-16C320 323.8 284.2 288 240 288zM464 152h-96c-13.25 0-24 10.75-24 24s10.75 24 24 24h96c13.25 0 24-10.75 24-24S477.3 152 464 152zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V416z"],
    "air-conditioner": [576, 512, [], "f8f4", "M464 128h-352C103.2 128 96 135.2 96 144V160c0 8.836 7.164 16 16 16h352C472.8 176 480 168.8 480 160V144C480 135.2 472.8 128 464 128zM512 .0002H64c-35.2 0-64 28.8-64 64V192c0 35.2 28.8 64 64 64h448c35.2 0 64-28.8 64-64V64C576 28.8 547.2 .0002 512 .0002zM528 192c0 8.672-7.326 16-16 16H64C55.33 208 48 200.7 48 192V64c0-8.672 7.328-16 16-16h448c8.674 0 16 7.328 16 16V192zM208 424c0 22.06-17.94 40-40 40S128 446.1 128 424c0-16.38 9.812-30.94 25.02-37.09c12.28-4.969 18.2-18.97 13.23-31.25c-4.984-12.28-18.92-18.16-31.27-13.25C101.6 355.9 80 387.1 80 424c0 48.53 39.47 88 88 88s88-39.47 88-88V288H208V424zM441 310.4c-12.34-4.906-26.28 .9687-31.27 13.25c-4.969 12.28 .9531 26.28 13.23 31.25C438.2 361.1 448 375.6 448 392c0 22.06-17.94 40-40 40s-40-17.94-40-40V288H320v104c0 48.53 39.47 88 88 88s88-39.47 88-88C496 355.1 474.4 323.9 441 310.4z"],
    "airplay": [576, 512, [], "e089", "M488 32H88C39.47 32 0 71.47 0 120v208C0 376.5 39.47 416 88 416c13.25 0 24-10.75 24-24S101.3 368 88 368c-22.06 0-40-17.94-40-40v-208c0-22.06 17.94-40 40-40h400c22.06 0 40 17.94 40 40v208c0 22.06-17.94 40-40 40c-13.25 0-24 10.75-24 24S474.8 416 488 416c48.53 0 88-39.47 88-88v-208C576 71.47 536.5 32 488 32zM321.9 286.1c-18.62-18.75-49.13-18.75-67.88 0l-112 112C112 428.2 133.3 480 176 480h223.9c42.63 0 64.25-51.77 33.88-81.9L321.9 286.1zM176 431.1l111.1-112l112 112H176z"],
    "alarm-clock": [512, 512, [62286], "23f0", "M95.1 0c-53.02 0-96 42.98-96 96c0 18.95 5.671 36.5 15.15 51.38l145.9-121.6C143.9 9.914 121.2 0 95.1 0zM415.1 0c-25.19 0-47.93 9.914-65.06 25.79l145.9 121.6C506.3 132.5 511.1 114.9 511.1 96C511.1 42.98 469 0 415.1 0zM256 64C132.3 64 32 164.3 32 288c0 53.21 18.63 102 49.62 140.4l-42.59 42.59C34.34 475.7 32 481.9 32 488C32 500.8 42.3 512 56 512c6.141 0 12.28-2.344 16.97-7.031l42.59-42.59C153.1 493.4 202.8 512 256 512s102-18.63 140.4-49.62l42.59 42.59C443.7 509.7 449.9 512 456 512c13.71 0 24-11.21 24-24c0-6.141-2.344-12.28-7.031-16.97l-42.59-42.59c30.99-38.43 49.62-87.23 49.62-140.4C479.1 164.3 379.7 64 256 64zM256 464c-97.05 0-176-78.95-176-176S158.1 112 256 112s176 78.95 176 176S353 464 256 464zM280 292V184c0-13.25-10.75-24-24-24S232 170.8 232 184V304c0 7.562 3.563 14.66 9.594 19.19l64 48C309.9 374.4 314.1 376 319.1 376c13.2 0 24.02-10.66 24.02-23.98c0-7.297-3.315-14.5-9.597-19.2L280 292z"],
    "alarm-exclamation": [512, 512, [], "f843", "M95.1 0c-53.02 0-96 42.97-96 95.99c0 18.95 5.738 36.41 15.22 51.29l145.1-121.6C144.1 9.805 121.2 0 95.1 0zM255.1 63.1C132.3 63.1 32 164.3 32 287.1c0 53.21 18.63 102 49.62 140.5l-42.59 42.59C34.34 475.7 32 481.9 32 488C32 501.7 43.21 512 56 512c6.141 0 12.28-2.344 16.97-7.031l42.59-42.59C153.1 493.4 202.8 512 256 512s102-18.63 140.4-49.62l42.59 42.59C443.7 509.7 449.9 512 456 512c12.79 0 24-10.3 24-24c0-6.141-2.344-12.28-7.031-16.97l-42.59-42.59c30.99-38.43 49.62-87.25 49.62-140.5C480 164.3 379.7 63.1 255.1 63.1zM256 464c-97.05 0-176-78.95-176-176S158.1 112 256 112s176 78.95 176 176S353 464 256 464zM415.1 0c-25.19 0-47.98 9.805-65.1 25.68l145.9 121.6c9.477-14.88 15.22-32.34 15.22-51.29C511.1 42.97 469 0 415.1 0zM256 352c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S273.7 352 256 352zM255.1 320C269.2 320 280 309.3 280 296v-112C280 170.8 269.2 160 255.1 160S232 170.8 232 184v112C232 309.3 242.7 320 255.1 320z"],
    "alarm-plus": [512, 512, [], "f844", "M95.1 0c-53.02 0-96 42.97-96 95.99c0 18.95 5.738 36.41 15.22 51.29l145.1-121.6C144.1 9.805 121.2 0 95.1 0zM328 264h-48v-48C280 202.8 269.3 192 256 192S232 202.8 232 216v48h-48C170.8 264 160 274.8 160 288s10.75 24 24 24h48v48C232 373.3 242.8 384 256 384s24-10.75 24-24v-48h48C341.3 312 352 301.3 352 288S341.3 264 328 264zM255.1 63.1C132.3 63.1 32 164.3 32 287.1c0 53.21 18.63 102 49.62 140.5l-42.59 42.59C34.34 475.7 32 481.9 32 488C32 500.8 42.3 512 56 512c6.141 0 12.28-2.344 16.97-7.031l42.59-42.59C153.1 493.4 202.8 512 256 512s102-18.63 140.4-49.62l42.59 42.59C443.7 509.7 449.9 512 456 512c13.71 0 24-11.21 24-24c0-6.141-2.344-12.28-7.031-16.97l-42.59-42.59c30.99-38.43 49.62-87.25 49.62-140.5C479.1 164.3 379.7 63.1 255.1 63.1zM256 464c-97.05 0-176-78.95-176-176S158.1 112 256 112s176 78.95 176 176S353 464 256 464zM415.1 0c-25.19 0-47.98 9.805-65.1 25.68l145.9 121.6c9.477-14.88 15.22-32.34 15.22-51.29C511.1 42.97 469 0 415.1 0z"],
    "alarm-snooze": [512, 512, [], "f845", "M95.1 0c-53.02 0-96 42.97-96 95.99c0 18.95 5.738 36.41 15.22 51.29l145.1-121.6C144.1 9.805 121.2 0 95.1 0zM256 63.1c-123.7 0-224 100.3-224 223.1c0 53.21 18.63 102 49.62 140.5l-42.59 42.59C34.34 475.7 32 481.9 32 488C32 500.8 42.3 512 56 512c6.141 0 12.28-2.344 16.97-7.031l42.59-42.59C153.1 493.4 202.8 512 256 512s102-18.63 140.4-49.62l42.59 42.59C443.7 509.7 449.9 512 456 512c13.71 0 24-11.21 24-24c0-6.141-2.344-12.28-7.031-16.97l-42.59-42.59C461.4 390 480 341.2 480 287.1C480 164.3 379.7 63.1 256 63.1zM256 464c-97.05 0-176-78.95-176-176S158.1 112 256 112s176 78.95 176 176S353 464 256 464zM415.1 0c-25.19 0-47.98 9.805-65.1 25.68l145.9 121.6c9.477-14.88 15.22-32.34 15.22-51.29C511.1 42.97 469 0 415.1 0zM313.6 336H248.3l83.98-105c3.473-4.348 5.262-9.659 5.262-15.01C337.6 197.3 320.5 192 313.6 192H198.4c-13.25 0-24 10.75-24 24s10.75 24 24 24h65.25l-83.98 105c-3.473 4.348-5.262 9.659-5.262 15.01C174.4 378.7 191.5 384 198.4 384h115.2c13.25 0 24-10.75 24-24S326.8 336 313.6 336z"],
    "album": [448, 512, [63647], "1f4bd", "M224 112c-79.54 0-144 64.46-144 144s64.46 144 144 144s144-64.46 144-144S303.5 112 224 112zM224 288c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S241.6 288 224 288zM384 32H64c-35.2 0-64 28.8-64 64v320c0 35.2 28.8 64 64 64h320c35.2 0 64-28.8 64-64v-320C448 60.8 419.2 32 384 32zM400 416c0 8.672-7.326 16-16 16H64c-8.674 0-16-7.328-16-16V96c0-8.674 7.326-16 16-16h320c8.674 0 16 7.326 16 16V416z"],
    "album-collection": [512, 512, [], "f8a0", "M480 24c0-13.25-10.75-24-24-24H55.97C42.72 0 31.97 10.75 31.97 24V48h448.1V24zM496 104c0-13.25-10.75-24-24-24H39.97c-13.25 0-24 10.75-24 24V128h480.1V104zM256 437.8c74.41 0 137.7-43.02 141.5-98.77c3.948-58.91-59.31-109.2-141.5-109.2s-145.5 50.32-141.5 109.2C118.3 394.8 181.6 437.8 256 437.8zM256 320c16.63 0 30 10.12 29.88 22.12c-.1231 12-13.5 21.75-29.88 21.75c-16.38 0-29.75-9.625-29.88-21.75C225.1 330 239.4 320 256 320zM480 160H31.97C7.704 160-1.012 181.8 .0918 194.9l23.6 258.9C26.7 486.8 54.34 512 87.44 512h337.1c33.1 0 60.74-25.23 63.74-58.19l23.6-258.9C513 181.8 504.1 160 480 160zM440.5 449.5C439.7 457.7 432.9 464 424.6 464H87.44c-8.329 0-15.18-6.254-15.94-14.55L49.49 208h413L440.5 449.5z"],
    "alicorn": [640, 512, [], "f6b0", "M480 96c0-8.875-7.124-16-16-16c-8.877 0-15.92 7.125-15.92 16s7.125 16 16 16S480 104.9 480 96zM632 48h-86.41l-2.258-2.75c15.99-5.371 29.11-18.73 32.62-35.59C577 4.688 573.1 0 567.1 0h-135.9c-68.39 0-125.9 48-140.4 112H265.8c-39.02 0-78.06-13.54-104.8-41.95C157.1 65.87 152.1 64 147.2 64C137.4 64 128 71.63 128 83c0 86.13 59.76 162.8 140 183.3c10.13 2.625 20-5.125 20-15.62V234.3c0-6.91-4.403-13.24-11.06-15.11C239.6 208.7 207.9 181.4 190.5 145.8C213.9 155.1 239.4 160 265.8 160h70.26V144c0-53.02 42.99-96 96.02-96h51.39l44.63 54.25v65.38c0 4.744-3.014 8.961-7.502 10.5l-31.01 10.62c-1.5 .5-9.75 3-16.5-3.75L448.1 160h-32.01l-.0049 80c0 26.12-12.62 49-32 63.63l-.0277 160.4L336.1 464V320L196.2 288.9L167.5 369L191.5 464H150l-21.13-87.88C127.6 370.8 127.8 365.3 129.3 360l22.75-76.75C128.5 273.8 112 250.9 112 224c0-15 5.124-28.62 13.75-39.5c-8.877-14.25-15.63-29.75-20.63-46.13C97.27 144.9 89.89 152 84.01 160.4C37.38 162.5 0 200.9 0 248v48C0 309.3 10.75 320 24 320s24-10.75 24-24l-.0037-48c0-13.25 6.876-24.37 16.75-31.62c-.125 2.5-.7524 5-.7524 7.625c0 30.12 11.88 58.12 32.14 78.62l-12.88 43.75c-3.999 13.25-4.374 27.38-1.125 40.88L106.3 487.5C109.8 501.9 122.6 512 137.4 512h74.76c20.85 0 36.13-19.62 31.02-39.84l-25.52-100.8L227 345l61.01 13.5L288.1 480c0 17.6 14.4 32 32 32h80.01c17.6 0 32.01-14.4 32.01-32v-155.6c20-22.5 31.26-51.13 32.01-81.63V234.4c21 7 38.38 .75 41.01-.125l30.1-10.62c23.94-8.203 40.01-30.71 40.01-56V102.5c0-5.104-1.03-10.08-2.579-14.86l62.87-25C643 58.25 639.9 48 632 48z"],
    "alien": [448, 512, [63733], "1f47d", "M224 .0001c-123.8 0-224 87.1-224 232.5c0 111.7 134.3 224.5 194.9 269.9c17.25 12.88 41 12.88 58.25 0C313.8 456.1 448 344.2 448 232.5C448 87.1 347.8 .0001 224 .0001zM223.6 463.8C113.6 381.7 48 295.2 48 232.5c0-110.4 70.75-184.5 176-184.5s176 74.12 176 184.5C400 295.2 334.4 381.7 223.6 463.8zM129.9 223.1H97.75c-8.75 0-16 7.125-16 15.1c.125 44.12 35.88 79.1 80 79.1h32c8.875 0 16-7.125 16-16C209.9 259.9 173.1 223.1 129.9 223.1zM352 224l-30.25-.0137c-44.13 0-80 35.87-80 79.99c.125 8.875 7.375 16 16.12 16l31.88-.0004c44.25 0 80-35.87 80.13-79.1C369.9 231.1 360.9 224 352 224z"],
    "alien-8bit": [576, 512, [63734, "alien-monster"], "1f47e", "M560 128L544 128c-8.875 0-16 7.125-16 16v96L480 240V176c0-8.875-7.125-16-16-16L432 160V96h32C472.9 96 480 88.88 480 80v-32C480 39.12 472.9 32 464 32L448 32c-8.875 0-16 7.125-16 15.1V64h-32C391.1 64 384 71.12 384 80V128H192V80C192 71.12 184.9 64 176 64h-32V48c0-8.875-7.125-15.1-16-15.1L112 32C103.1 32 96 39.12 96 48v32C96 88.88 103.1 96 112 96h32v64l-32 .0002c-8.875 0-16 7.125-16 16V240L48 240v-96C48 135.1 40.88 128 32 128L16 128c-8.875 0-16 7.125-16 15.1v128c0 8.875 7.125 16 16 16H64v80c0 8.875 7.125 16 16 16l48 0v80c0 8.875 7.125 16 16 16l96 0c8.875 0 16-7.125 16-15.1V448c0-8.875-7.125-15.1-16-15.1h-64v-48h224v48h-64c-8.875 0-16 7.125-16 15.1v16c0 8.875 7.125 15.1 16 15.1l96 0c8.875 0 16-7.125 16-16v-80l48 0c8.875 0 16-7.125 16-16v-80h48c8.875 0 16-7.125 16-16v-128C576 135.1 568.9 128 560 128zM464 336h-352V288h32V208H192v-32h192v32h48V288h32V336zM240 224l-32 .0004C199.1 224 192 231.1 192 240V288c0 8.875 7.125 16 16 16L240 304C248.9 304 256 296.9 256 288V240C256 231.1 248.9 224 240 224zM368 224L336 224C327.1 224 320 231.1 320 240V288c0 8.875 7.125 16 16 16l32 .0004C376.9 304 384 296.9 384 288V240C384 231.1 376.9 224 368 224z"],
    "align-center": [448, 512, [], "f037", "M119.1 88h208C341.3 88 352 77.25 352 64S341.3 40 328 40H119.1C106.7 40 96 50.75 96 64S106.7 88 119.1 88zM424 424H23.1C10.75 424 0 434.7 0 448S10.75 472 23.1 472H424c13.25 0 24-10.75 24-23.1S437.3 424 424 424zM328 344C341.3 344 352 333.3 352 320S341.3 296 328 296H119.1C106.7 296 96 306.7 96 320S106.7 344 119.1 344H328zM424 168H23.1C10.75 168 0 178.7 0 192S10.75 216 23.1 216H424c13.25 0 24-10.75 24-23.1S437.3 168 424 168z"],
    "align-justify": [448, 512, [], "f039", "M424 296H23.1C10.75 296 0 306.7 0 320S10.75 344 23.1 344H424c13.25 0 24-10.75 24-23.1S437.3 296 424 296zM424 424H23.1C10.75 424 0 434.7 0 448S10.75 472 23.1 472H424c13.25 0 24-10.75 24-23.1S437.3 424 424 424zM424 168H23.1C10.75 168 0 178.7 0 192S10.75 216 23.1 216H424c13.25 0 24-10.75 24-23.1S437.3 168 424 168zM424 40H23.1C10.75 40 0 50.75 0 64S10.75 88 23.1 88H424c13.25 0 24-10.75 24-23.1S437.3 40 424 40z"],
    "align-left": [448, 512, [], "f036", "M20.87 88h246.3C278.7 88 288 78.65 288 67.13V60.87C288 49.35 278.7 40 267.1 40H20.87C9.346 40 0 49.35 0 60.87V67.13C0 78.65 9.346 88 20.87 88zM20.87 344h246.3C278.7 344 288 334.7 288 323.1V316.9C288 305.3 278.7 296 267.1 296H20.87C9.346 296 0 305.3 0 316.9v6.25C0 334.7 9.346 344 20.87 344zM424 168H23.1C10.75 168 0 178.7 0 192S10.75 216 23.1 216H424c13.25 0 24-10.75 24-23.1S437.3 168 424 168zM424 424H23.1C10.75 424 0 434.7 0 448S10.75 472 23.1 472H424c13.25 0 24-10.75 24-23.1S437.3 424 424 424z"],
    "align-right": [448, 512, [], "f038", "M424 424H23.1C10.75 424 0 434.7 0 448S10.75 472 23.1 472H424c13.25 0 24-10.75 24-23.1S437.3 424 424 424zM427.1 296H180.9C169.3 296 160 305.3 160 316.9v6.25C160 334.7 169.3 344 180.9 344h246.3C438.7 344 448 334.7 448 323.1V316.9C448 305.3 438.7 296 427.1 296zM427.1 40H180.9C169.3 40 160 49.35 160 60.87V67.13C160 78.65 169.3 88 180.9 88h246.3C438.7 88 448 78.65 448 67.13V60.87C448 49.35 438.7 40 427.1 40zM424 168H23.1C10.75 168 0 178.7 0 192S10.75 216 23.1 216H424c13.25 0 24-10.75 24-23.1S437.3 168 424 168z"],
    "align-slash": [640, 512, [], "f846", "M120 344h195.5l-61.24-48H120c-13.25 0-24 10.75-24 24C95.1 333.3 106.7 344 120 344zM120 424c-13.25 0-24 10.75-24 24C95.1 461.3 106.7 472 120 472h358.9l-61.24-48H120zM630.8 469.1L471.2 344H520c13.25 0 24-10.75 24-23.1C544 306.7 533.3 296 520 296h-110l-102.1-80H520c13.25 0 24-10.75 24-23.1C544 178.7 533.3 168 520 168H246.6l-102.1-80H520c13.25 0 24-10.75 24-23.1C544 50.74 533.3 40 520 40H120c-9.018 0-16.58 5.178-20.68 12.53L38.81 5.116C34.41 1.679 29.19 0 24.03 0C16.91 0 9.84 3.158 5.121 9.189C-3.066 19.63-1.248 34.71 9.189 42.89l591.1 463.1c10.5 8.203 25.57 6.333 33.69-4.073C643.1 492.4 641.2 477.3 630.8 469.1z"],
    "alt": [640, 512, [], "e08a", "M416 424c0 13.26 10.75 24 24 24h176c13.25 0 24-10.74 24-24c0-13.25-10.75-24-24-24h-176C426.7 400 416 410.7 416 424zM640 88C640 74.75 629.3 64 616 64h-129.5c-26.69 0-51.59 11.88-68.41 32.59l-233.6 288.6C176.9 394.6 165.6 400 153.5 400H24C10.75 400 0 410.8 0 424S10.75 448 24 448h129.5c26.69 0 51.59-11.88 68.41-32.59l233.6-288.6C463.1 117.4 474.4 112 486.5 112H616C629.3 112 640 101.3 640 88z"],
    "amp-guitar": [512, 512, [], "f8a1", "M384 336c8.875 0 16-7.125 16-16S392.9 304 384 304s-16 7.125-16 16S375.1 336 384 336zM320 336c8.875 0 16-7.125 16-16S328.9 304 320 304s-16 7.125-16 16S311.1 336 320 336zM416 384c8.875 0 16-7.125 16-16S424.9 352 416 352s-16 7.125-16 16S407.1 384 416 384zM352 384c8.875 0 16-7.125 16-16S360.9 352 352 352s-16 7.125-16 16S343.1 384 352 384zM128 400c-8.875 0-16 7.125-16 16s7.125 16 16 16s16-7.125 16-16S136.9 400 128 400zM192 400c-8.875 0-16 7.125-16 16s7.125 16 16 16s16-7.125 16-16S200.9 400 192 400zM288 384c8.875 0 16-7.125 16-16S296.9 352 288 352s-16 7.125-16 16S279.1 384 288 384zM384 400c-8.875 0-16 7.125-16 16s7.125 16 16 16s16-7.125 16-16S392.9 400 384 400zM320 400c-8.875 0-16 7.125-16 16s7.125 16 16 16s16-7.125 16-16S328.9 400 320 400zM256 400c-8.875 0-16 7.125-16 16s7.125 16 16 16s16-7.125 16-16S264.9 400 256 400zM256 336c8.875 0 16-7.125 16-16S264.9 304 256 304S240 311.1 240 320S247.1 336 256 336zM192 152c-13.25 0-24 10.75-24 24S178.8 200 192 200S216 189.3 216 176S205.3 152 192 152zM112 152c-13.25 0-24 10.75-24 24S98.75 200 112 200S136 189.3 136 176S125.3 152 112 152zM448 80h-45.5C377.8 52.75 321.5 0 256 0S134.3 52.75 109.5 80H64c-35.35 0-64 28.65-64 64V448c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V144C512 108.7 483.3 80 448 80zM256 48c26.88 0 53.1 14.75 76.25 32h-152.5C201.1 62.75 229.1 48 256 48zM464 448c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V272h416V448zM464 224h-416V144C48 135.2 55.16 128 64 128h384c8.836 0 16 7.162 16 16V224zM96 384c8.875 0 16-7.125 16-16S104.9 352 96 352s-16 7.125-16 16S87.13 384 96 384zM192 336c8.875 0 16-7.125 16-16S200.9 304 192 304S176 311.1 176 320S183.1 336 192 336zM224 384c8.875 0 16-7.125 16-16S232.9 352 224 352s-16 7.125-16 16S215.1 384 224 384zM128 336c8.875 0 16-7.125 16-16S136.9 304 128 304S112 311.1 112 320S119.1 336 128 336zM160 384c8.875 0 16-7.125 16-16S168.9 352 160 352s-16 7.125-16 16S151.1 384 160 384zM320 152c-13.25 0-24 10.75-24 24S306.8 200 320 200s24-10.75 24-24S333.3 152 320 152zM400 152c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S413.3 152 400 152z"],
    "ampersand": [384, 512, [], "26", "M360 480c-6.25 0-12.5-2.422-17.19-7.266l-60.47-62.14l-14.69 22.48c-19.19 29.38-51.44 46.93-86.56 46.93L103.7 480C46.55 480 0 433.5 0 376.4c0-32.88 15.81-64.11 42.34-83.56l73.19-53.67L79.22 201.8C59.09 181.2 48 153.9 48 125C48 73.73 89.72 32 141 32h53.94C246.3 32 288 73.73 288 125c0 29.55-14.22 57.59-38.03 75.03L188.4 245.2l86.56 88.98l64.94-99.33c7.281-11.06 22.19-14.19 33.22-6.953c11.09 7.266 14.22 22.14 6.969 33.23l-70.84 108.3l67.94 69.83c9.25 9.5 9.062 24.69-.4375 33.94C372.1 477.7 366 480 360 480zM149.3 273.9L70.72 331.5C56.5 341.9 48 358.7 48 376.4C48 407 72.97 432 103.7 432h77.25c18.88 0 36.28-9.406 46.56-25.19l20.59-31.47L149.3 273.9zM141 80C116.2 80 96 100.2 96 125c0 16.28 6.25 31.66 17.59 43.3l41 42.14l67-49.13C233.1 152.9 240 139.3 240 125C240 100.2 219.8 80 194.1 80H141z"],
    "anchor": [576, 512, [61757], "2693", "M567.6 309.8l-56-48c-9-7.719-22.25-7.719-31.25 0l-56 48c-10.06 8.625-11.22 23.78-2.594 33.84c8.625 10.03 23.75 11.22 33.84 2.594l15.91-13.64C469.1 405.4 409.4 464 336 464h-24V256h48C373.3 256 384 245.3 384 232S373.3 208 360 208h-48V155.9C344.4 145.7 368 115.8 368 80c0-44.18-35.82-80-79.1-80C243.8 0 208 35.82 208 80c0 35.76 23.62 65.69 56 75.93V208h-48C202.8 208 192 218.8 192 232S202.8 256 216 256h48v208H240c-73.42 0-133.1-58.6-135.5-131.4l15.91 13.64C124.9 350.1 130.5 352 135.1 352c6.766 0 13.48-2.844 18.23-8.375c8.625-10.06 7.469-25.22-2.594-33.84l-56-48c-9-7.719-22.25-7.719-31.25 0l-56 48c-10.06 8.625-11.22 23.78-2.594 33.84c8.609 10.03 23.75 11.22 33.84 2.594l16.58-14.21C58.36 431.6 139.9 512 240 512h95.1c100.1 0 181.6-80.4 183.8-179.1l16.58 14.21C540.9 350.1 546.5 352 551.1 352c6.766 0 13.48-2.844 18.23-8.375C578.8 333.6 577.7 318.4 567.6 309.8zM288 48c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S270.4 48 288 48zM495.5 312L496 311.6L496.5 312H495.5z"],
    "angel": [640, 512, [], "f779", "M603.7 453.1l-38.16-78.63c-6.625-13.5-6.625-29.62 0-43.13c16.25-33.37 26.37-37.59 26.37-75.34c0-51.13-46.87-96-100.4-96c-25.12 0-48.84 10-66.34 28.12L352.6 261.5c-10.25-3.375-21.33-5.453-32.58-5.453s-22.18 2.042-32.43 5.417L214.1 188.3c-17.62-18-41.31-28.19-66.44-28.19c-53.5 0-100.3 45.06-100.3 96.19c0 37.88 10.12 42 26.37 75.25c6.625 13.5 6.625 29.62 0 43.13l-38.34 78.5C21.79 482.9 45.57 512 72.57 512h494.1C595.2 512 617.7 482.1 603.7 453.1zM84.32 464l33.37-68.63c12.1-26.62 12.1-58.5 0-85.13c-5.375-11.12-9.875-18.87-13.5-25C97.07 272.8 96.13 271.2 96.13 256c0-24.75 25.5-48 52.37-48c12.12 0 23.56 4.938 32.19 13.81L245.8 287.5C238.6 295 232.1 303.6 227.4 313.2L152.1 464H84.32zM205.8 464l64.62-129.2C279.9 315.8 298.9 304 320.1 304c21.12 0 40.12 11.75 49.62 30.75L434.3 464H205.8zM487.9 464L412.6 313.2C407.7 303.5 401.5 295 394.2 287.5l65.19-65.75C468.1 212.8 479.4 208 491.6 208c26.1 0 52.37 23.25 52.37 48c0 15.25-.875 16.75-8.125 29.25c-3.5 6.125-7.1 13.88-13.5 25c-12.87 26.63-12.87 58.5 0 85.13L555.7 464H487.9zM240 144c0 44.25 35.75 80 79.1 80s79.1-35.75 79.1-80S364.2 64 320 64S240 99.75 240 144zM352 144c0 17.62-14.37 32-31.1 32s-31.1-14.38-31.1-32s14.37-32 31.1-32S352 126.4 352 144zM208.8 137.2c.875-13 3.872-25.23 8.872-36.61C206.6 94.64 200.1 87.62 200.1 80c0-22.12 53.62-40 119.1-40c66.25 0 119.1 17.88 119.1 40c0 7.625-6.75 14.64-17.63 20.64c4.875 11.38 8 23.61 8.75 36.61C461 122.8 479.1 102.5 479.1 80c0-44.25-71.63-80-159.1-80S160 35.75 160 80C160 102.5 178.8 122.8 208.8 137.2z"],
    "angle": [448, 512, [], "e08c", "M315.5 400h48.89c-6.318-43.29-20.84-83.96-42.02-120.3l-41.1 24.66C298.1 333.4 309.6 365.7 315.5 400zM208.9 221.9c20.58 16.14 39.22 34.59 54.76 55.66l41.31-24.79c-20.43-28.48-45.42-53.3-73.55-74.18L208.9 221.9zM424 432H63.53l189.8-364.9c6.109-11.77 1.531-26.25-10.22-32.37C231.3 28.6 216.8 33.16 210.7 44.94l-208 400c-3.859 7.438-3.562 16.34 .7813 23.53C7.84 475.6 15.61 480 23.1 480H424c13.25 0 24-10.75 24-24S437.3 432 424 432z"],
    "angle-90": [448, 512, [], "e08d", "M315.5 400h48.89c-6.318-43.29-20.84-83.96-42.02-120.3l-41.1 24.66C298.1 333.4 309.6 365.7 315.5 400zM263.6 277.6l41.31-24.79c-21.5-29.97-47.75-56.22-77.72-77.72L202.4 216.4C225.8 233.6 246.4 254.2 263.6 277.6zM424 432H48V56C48 42.75 37.25 32 24 32S0 42.75 0 56v400C0 469.3 10.75 480 24 480h400c13.25 0 24-10.75 24-24S437.3 432 424 432zM200.3 157.7C163.1 136.5 123.3 121.1 80 115.7v48.89c34.26 5.869 66.62 17.41 95.68 34.23L200.3 157.7z"],
    "angle-down": [384, 512, [61703], "2304", "M360.5 217.5l-152 143.1C203.9 365.8 197.9 368 192 368s-11.88-2.188-16.5-6.562L23.5 217.5C13.87 208.3 13.47 193.1 22.56 183.5C31.69 173.8 46.94 173.5 56.5 182.6L192 310.9l135.5-128.4c9.562-9.094 24.75-8.75 33.94 .9375C370.5 193.1 370.1 208.3 360.5 217.5z"],
    "angle-left": [256, 512, [61700], "2039", "M166.5 424.5l-143.1-152c-4.375-4.625-6.562-10.56-6.562-16.5c0-5.938 2.188-11.88 6.562-16.5l143.1-152c9.125-9.625 24.31-10.03 33.93-.9375c9.688 9.125 10.03 24.38 .9375 33.94l-128.4 135.5l128.4 135.5c9.094 9.562 8.75 24.75-.9375 33.94C190.9 434.5 175.7 434.1 166.5 424.5z"],
    "angle-right": [256, 512, [61701], "203a", "M89.45 87.5l143.1 152c4.375 4.625 6.562 10.56 6.562 16.5c0 5.937-2.188 11.87-6.562 16.5l-143.1 152C80.33 434.1 65.14 434.5 55.52 425.4c-9.688-9.125-10.03-24.38-.9375-33.94l128.4-135.5l-128.4-135.5C45.49 110.9 45.83 95.75 55.52 86.56C65.14 77.47 80.33 77.87 89.45 87.5z"],
    "angle-up": [384, 512, [61702], "2303", "M23.5 294.5l152-143.1C180.1 146.2 186.1 144 192 144s11.88 2.188 16.5 6.562l152 143.1c9.625 9.125 10.03 24.31 .9375 33.93c-9.125 9.688-24.38 10.03-33.94 .9375l-135.5-128.4l-135.5 128.4c-9.562 9.094-24.75 8.75-33.94-.9375C13.47 318.9 13.87 303.7 23.5 294.5z"],
    "angles-down": [384, 512, ["angle-double-down"], "f103", "M328 270.1L192 391.8L55.1 270.1c-4.563-4.094-10.28-6.125-16-6.125c-6.594 0-13.16 2.687-17.88 7.1C13.28 281.9 14.12 297.1 23.99 305.9l152 135.1c9.125 8.187 22.88 8.187 32 0l152-135.1c9.875-8.812 10.72-23.1 1.875-33.87C353.1 262.1 337.8 261.3 328 270.1zM175.1 249.9c9.125 8.187 22.88 8.187 32 0l152-135.1c9.875-8.812 10.72-23.1 1.875-33.87c-8.813-9.906-24.03-10.72-33.88-1.875L192 199.8L55.1 78.13c-4.563-4.094-10.28-6.125-16-6.125c-6.594 0-13.16 2.687-17.88 7.1C13.28 89.88 14.12 105.1 23.99 113.9L175.1 249.9z"],
    "angles-left": [448, 512, [61696, "angle-double-left"], "ab", "M213.9 388L92.23 252l121.6-136c4.094-4.563 6.125-10.28 6.125-16c0-6.594-2.687-13.16-7.1-17.88C202.1 73.28 186.9 74.12 178.1 83.99L42.14 235.1c-8.187 9.125-8.187 22.88 0 32l135.1 152c8.812 9.875 23.1 10.72 33.87 1.875C221.9 413.1 222.7 397.8 213.9 388zM234.1 235.1c-8.187 9.125-8.187 22.88 0 32l135.1 152c8.812 9.875 23.1 10.72 33.87 1.875c9.906-8.813 10.72-24.03 1.875-33.88L284.2 252l121.6-136c4.094-4.563 6.125-10.28 6.125-16c0-6.594-2.687-13.16-7.1-17.88c-9.874-8.844-25.06-8-33.87 1.875L234.1 235.1z"],
    "angles-right": [448, 512, [61697, "angle-double-right"], "bb", "M238.1 115.1L359.8 252l-121.6 136c-4.094 4.563-6.125 10.28-6.125 16c0 6.594 2.687 13.16 7.1 17.88c9.874 8.844 25.06 8 33.87-1.875l135.1-152c8.187-9.125 8.187-22.88 0-32l-135.1-152c-8.812-9.875-23.1-10.72-33.87-1.875C230.1 90.93 229.3 106.2 238.1 115.1zM217.9 268c8.187-9.125 8.187-22.88 0-32L81.88 83.99C73.07 74.12 57.88 73.28 48 82.12C38.1 90.93 37.29 106.2 46.13 115.1L167.8 252l-121.6 136c-4.094 4.563-6.125 10.28-6.125 16c0 6.594 2.687 13.16 7.1 17.88c9.874 8.844 25.06 8 33.87-1.875L217.9 268z"],
    "angles-up": [384, 512, ["angle-double-up"], "f102", "M55.1 241.9L192 120.2l136 121.6c4.563 4.094 10.28 6.125 16 6.125c6.594 0 13.16-2.687 17.88-7.1c8.844-9.874 8-25.06-1.875-33.87L208 70.14c-9.125-8.187-22.88-8.187-32 0L23.99 206.1C14.12 214.9 13.28 230.1 22.12 240C30.93 249.9 46.15 250.7 55.1 241.9zM208 262.1c-9.125-8.187-22.88-8.187-32 0l-152 135.1c-9.875 8.812-10.72 23.1-1.875 33.87c8.813 9.906 24.03 10.72 33.88 1.875L192 312.2l136 121.6c4.563 4.094 10.28 6.125 16 6.125c6.594 0 13.16-2.687 17.88-7.1c8.844-9.874 8-25.06-1.875-33.87L208 262.1z"],
    "ankh": [320, 512, [63044], "2625", "M296 272h-68.88c29.38-36.38 54.75-87.88 54.75-134.9C281.9 53 227.4 0 160 0S38.12 53 38.12 137.1c0 47 25.38 98.5 54.75 134.9H23.1C10.75 272 0 282.7 0 295.1S10.75 320 23.1 320H136v168C136 501.3 146.7 512 160 512s24-10.75 24-23.1V320h112C309.3 320 320 309.3 320 296S309.3 272 296 272zM160 48c44.25 0 73.88 35.88 73.88 89.12c0 53.88-49.63 119.5-73.88 133.4C135.8 256.6 86.12 191 86.12 137.1C86.12 83.88 115.8 48 160 48z"],
    "aperture": [512, 512, [], "e2df", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM435.9 152H251.4l56.16-97.27C362.2 68.74 408.2 104.3 435.9 152zM320.7 256l-32.33 56H223.7L191.3 256l32.33-56h64.67L320.7 256zM256 48L163.6 208L107.4 110.7C145.2 72.07 197.8 48 256 48zM76 152.2L168.2 312H55.88C50.87 294.2 48 275.4 48 256C48 218.2 58.3 182.8 76 152.2zM76.14 360h184.5l-56.16 97.27C149.8 443.3 103.8 407.7 76.14 360zM256 464l92.38-160l56.19 97.31C366.8 439.9 314.2 464 256 464zM435.1 359.8L343.8 200h112.4C461.1 217.8 464 236.6 464 256C464 293.8 453.7 329.2 435.1 359.8z"],
    "apostrophe": [192, 512, [], "27", "M96 32C42.98 32 0 74.98 0 128s42.98 96 96 96c17.58 0 33.83-5.068 48-13.31V232c0 39.7-32.31 72-72 72h-16C42.75 304 32 314.8 32 328S42.75 352 56 352h16C138.2 352 192 298.2 192 232V128C192 74.98 149 32 96 32zM96 176C69.53 176 48 154.5 48 128S69.53 80 96 80s48 21.53 48 48S122.5 176 96 176z"],
    "apple-core": [384, 512, [], "e08f", "M190.4 112c18.75 0 52.13-3.25 73.26-24.38c30.51-30.62 23.75-87 23.75-87S281.9 0 273.6 0c-18.75 0-52.13 3.25-73.26 24.38c-30.5 30.62-23.75 87-23.75 87S181.1 112 190.4 112zM287.1 304c0-60.89 30.92-114.5 77.93-146.1c-15.96-14.96-35-24.79-56.29-28.48c-5.32-.9258-11.05-1.348-17.04-1.348c-32.9 0-73.95 12.73-100.6 25.1C165.3 140.8 124.4 128 91.43 128c-6.008-.002-11.74 .4219-17.09 1.348c-21.3 3.684-40.29 13.53-56.27 28.49C65.06 189.5 95.1 243.1 95.1 304c0 60.87-30.92 114.5-77.88 146.1C45.24 486.5 83.68 512 135.2 512c13.38 0 27.63-4 42.26-12c4.502-2.438 9.502-3.656 14.5-3.656c4.1 0 10 1.219 14.5 3.656c14.63 8 28.88 12 42.26 12c51.55 0 89.99-25.46 117.1-61.89C318.9 418.5 287.1 364.9 287.1 304zM248.7 464c-3.67 0-9.984-1.061-19.39-6.207c-11.41-6.182-24.33-9.449-37.36-9.449S166 451.6 154.5 457.9C145.2 462.9 138.9 464 135.2 464c-17.2 0-32.66-4.131-46.63-12.53C123.9 411.1 143.1 358.1 143.1 304c0-46.13-14.13-90.28-39.55-127.1c22.71 2.703 49.5 11.51 67.34 19.8l20.21 9.383l20.21-9.383c17.84-8.281 44.62-17.09 67.34-19.8C254.1 213.7 239.1 257.9 239.1 304c0 54.96 20.06 107.1 55.39 147.5C281.4 459.9 265.9 464 248.7 464z"],
    "apple-whole": [448, 512, [127823, 62929, "apple-alt"], "1f34e", "M415.3 177.6c-18.5-26.5-44.01-43.12-73.64-48.25c-34.51-6-86.14 9.125-117.6 23.75C192.5 138.5 140.1 123.4 106.4 129.4C76.73 134.5 51.35 151.1 32.72 177.6C4.841 217.5-6.536 280.1 3.716 337.1C18.97 421.8 69.98 512 167.2 512c13.38 0 27.63-4 42.26-12c9.001-4.875 20-4.875 29 0C253.1 508 267.4 512 280.8 512c97.27 0 148.3-90.25 163.5-174.9C454.5 280.1 443.2 217.5 415.3 177.6zM397 328.6C393 351.2 368.3 464 280.8 464c-5.251 0-11.88-2.125-19.25-6.125c-11.63-6.25-24.5-9.5-37.51-9.5s-25.88 3.25-37.51 9.5C179.1 461.9 172.5 464 167.2 464c-87.51 0-112.3-112.8-116.3-135.4C42.97 284.2 51.47 234.6 72.1 205.1c11.13-16 25.38-25.5 42.38-28.5c12.63-2.125 53.88 0 109.5 30.75c55.63-30.75 97.02-32.88 109.5-30.75c17 3 31.25 12.5 42.38 28.5C396.5 234.6 405 284.2 397 328.6zM222.4 112c18.75 0 52.13-3.25 73.26-24.38c30.5-30.62 23.75-86.1 23.75-86.1S313.9 0 305.6 0c-18.75 0-52.13 3.25-73.26 24.38c-30.5 30.62-23.75 87-23.75 87S213.1 112 222.4 112z"],
    "archway": [576, 512, [], "f557", "M552 48C565.3 48 576 37.25 576 24S565.3 0 552 0h-528C10.75 0 0 10.75 0 23.1S10.75 48 23.1 48H32v416H23.1C10.75 464 0 474.7 0 487.1S10.75 512 23.1 512H176C184.8 512 192 504.8 192 496l0-172.8C191.1 274.4 227.1 230.9 275.5 224.8C334.1 217.4 384 262.9 384 320v176c0 8.837 7.163 16 16 16h152c13.25 0 24-10.75 24-23.1S565.3 464 552 464H544v-416H552zM496 48v40h-416V48H496zM432 464V320c0-79.38-64.63-144-144-144S144 240.6 144 320v144h-64V136h416V464H432z"],
    "arrow-down": [384, 512, [61539], "2193", "M377.4 296.6l-168 176C204.8 477.3 198.6 480 192 480s-12.84-2.688-17.38-7.438l-168-176C-2.5 286.1-2.156 271.8 7.438 262.6c9.5-9.156 24.75-8.812 33.94 .8125L168 396.1V56.02c0-13.25 10.75-24.01 23.1-24.01S216 42.77 216 56.02v340.1l126.6-132.7c9.156-9.625 24.41-9.969 33.94-.8125C386.2 271.8 386.5 286.1 377.4 296.6z"],
    "arrow-down-1-9": [512, 512, ["sort-numeric-asc", "sort-numeric-down"], "f162", "M352 175.1c-13.25 0-24 10.75-24 24s10.75 24.01 23.1 24.01L432 223.1c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-120c0-8.656-4.656-16.62-12.19-20.88c-7.531-4.312-16.78-4.094-24.16 .2813l-40 24c-11.38 6.844-15.06 21.56-8.25 32.94c6.812 11.34 21.5 15.06 32.94 8.25l3.656-2.219v77.63H352zM392 256c-48.6 0-88 39.4-88 88c0 42.05 29.55 77.1 68.98 85.81l-15.54 19c-8.406 10.25-6.906 25.38 3.375 33.75C365.3 486.2 370.6 488 376 488c6.938 0 13.84-3 18.56-8.812C465.1 392.1 480 382.5 480 344C480 295.4 440.6 256 392 256zM421.3 370.8l-1.443 1.762C412.6 379.6 402.8 384 392 384c-22.06 0-40-17.95-40-40S369.9 304 392 304s40 17.95 40 40C432 354.4 427.8 363.7 421.3 370.8zM206.4 335.1L152 394.9V56.02C152 42.76 141.3 32 128 32S104 42.76 104 56.02v338.9l-54.37-58.95c-4.719-5.125-11.16-7.719-17.62-7.719c-5.812 0-11.66 2.094-16.28 6.375c-9.75 8.977-10.34 24.18-1.344 33.94l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0l95.1-104.1c9-9.758 8.406-24.96-1.344-33.94C230.5 325.5 215.3 326.2 206.4 335.1z"],
    "arrow-down-9-1": [512, 512, ["sort-numeric-desc", "sort-numeric-down-alt"], "f886", "M206.4 335.1L152 394.9V56.02C152 42.76 141.3 32 128 32S104 42.76 104 56.02v338.9l-54.37-58.95c-4.719-5.125-11.16-7.719-17.62-7.719c-5.812 0-11.66 2.094-16.28 6.375c-9.75 8.977-10.34 24.18-1.344 33.94l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0l95.1-104.1c9-9.758 8.406-24.96-1.344-33.94C230.5 325.5 215.3 326.2 206.4 335.1zM432 432H416V312c0-8.656-4.656-16.62-12.19-20.88c-7.531-4.312-16.78-4.094-24.16 .2813l-40 24c-11.38 6.844-15.06 21.56-8.25 32.94c6.812 11.34 21.5 15.06 32.94 8.25l3.656-2.219V432h-16c-13.25 0-24 10.75-24 24S338.8 480 352 480H432c13.25 0 24-10.75 24-24S445.3 432 432 432zM372.1 205.8l-15.54 19c-8.406 10.25-6.906 25.38 3.375 33.75C365.3 262.2 370.6 264 376 264c6.938 0 13.84-3 18.56-8.812C465.1 168.1 480 158.5 480 120c0-48.6-39.4-88-88-88s-88 39.4-88 88C303.1 162.1 333.5 197.1 372.1 205.8zM392 80c22.06 0 40 17.95 40 40c0 10.4-4.223 19.7-10.75 26.82l-1.443 1.762C412.6 155.6 402.8 160 392 160c-22.06 0-40-17.95-40-40S369.9 80 392 80z"],
    "arrow-down-a-z": [512, 512, ["sort-alpha-asc", "sort-alpha-down"], "f15d", "M439.1 432H377.1l81.87-105.3c5.625-7.25 6.656-17.06 2.625-25.28C457.5 293.2 449.1 288 439.1 288h-111.1c-13.25 0-23.1 10.75-23.1 24s10.75 24 23.1 24h62.94L309.1 441.3c-5.623 7.25-6.654 17.06-2.625 25.28C310.5 474.8 318.8 480 327.1 480h111.1c13.25 0 23.1-10.75 23.1-24S453.2 432 439.1 432zM477.5 189.3l-71.1-144c-8.123-16.31-34.81-16.31-42.94 0l-71.1 144c-5.938 11.84-1.125 26.25 10.75 32.19c11.9 5.938 26.25 1.156 32.19-10.75L338.8 200h90.34l5.359 10.72C438.7 219.2 447.2 224 456 224c3.594 0 7.25-.8125 10.69-2.531C478.6 215.5 483.4 201.1 477.5 189.3zM362.8 152l21.17-42.34L405.2 152H362.8zM206.4 335.1L152 394.9V56.02c0-13.27-10.75-24.02-24-24.02S104 42.76 104 56.02v338.9l-54.37-58.95c-4.719-5.125-11.16-7.719-17.62-7.719c-5.812 0-11.66 2.094-16.28 6.375c-9.75 8.977-10.34 24.18-1.344 33.94l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0l95.1-104.1c9-9.758 8.406-24.96-1.344-33.94C230.5 325.5 215.3 326.2 206.4 335.1z"],
    "arrow-down-arrow-up": [448, 512, ["sort-alt"], "f883", "M206.4 335.1L152 394.9V56.02C152 42.76 141.3 32 128 32S104 42.76 104 56.02v338.9l-54.37-58.95c-4.719-5.125-11.16-7.719-17.62-7.719c-5.812 0-11.66 2.094-16.28 6.375c-9.75 8.977-10.34 24.18-1.344 33.94l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0l95.1-104.1c9-9.758 8.406-24.96-1.344-33.94C230.5 325.5 215.3 326.2 206.4 335.1zM433.6 143.4l-95.1-104.1c-9.062-9.82-26.19-9.82-35.25 0L206.4 143.4c-9 9.758-8.406 24.96 1.344 33.94c4.623 4.281 10.47 6.375 16.28 6.375c6.469 0 12.91-2.594 17.62-7.719L296 117.1v338.9C296 469.2 306.8 480 320 480s24-10.76 24-24.02V117.1l54.37 58.95c8.938 9.758 24.12 10.41 33.9 1.344C442 168.4 442.6 153.2 433.6 143.4z"],
    "arrow-down-big-small": [512, 512, ["sort-size-down"], "f88c", "M480 32h-160c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32V64C512 46.33 497.7 32 480 32zM464 208h-128v-128h128V208zM416 320h-96c-17.6 0-32 14.4-32 32v96c0 17.6 14.4 32 32 32h96c17.6 0 32-14.4 32-32v-96C448 334.4 433.6 320 416 320zM400 432h-64v-64h64V432zM206.4 335.1L152 394.9V56.02C152 42.76 141.3 32 128 32S104 42.76 104 56.02v338.9l-54.37-58.95c-4.719-5.125-11.16-7.719-17.62-7.719c-5.812 0-11.66 2.094-16.28 6.375c-9.75 8.977-10.34 24.18-1.344 33.94l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0l95.1-104.1c9-9.758 8.406-24.96-1.344-33.94C230.5 325.5 215.3 326.2 206.4 335.1z"],
    "arrow-down-from-dotted-line": [448, 512, [], "e090", "M224 95.1c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S206.3 95.1 224 95.1zM416 95.1c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S398.3 95.1 416 95.1zM320 95.1c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S302.3 95.1 320 95.1zM128 95.1c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S110.3 95.1 128 95.1zM32 95.1c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S14.33 95.1 32 95.1zM206.5 472.7c9.062 9.699 25.88 9.699 34.94 0l128-136.2c9.094-9.672 8.625-24.88-1.031-33.96c-9.625-9.109-24.81-8.672-33.91 1.031L248 395.6v-211.6c0-13.27-10.75-24.04-24-24.04S200 170.8 200 184v211.6l-86.53-92.05C108.8 298.6 102.4 296 96 296c-5.906 0-11.81 2.16-16.44 6.543c-9.656 9.074-10.12 24.29-1.031 33.96L206.5 472.7z"],
    "arrow-down-from-line": [384, 512, [62277, "arrow-from-top"], "21a7", "M24 80.03h336c13.25 0 24-10.76 24-24.02S373.3 32 360 32h-336c-13.25 0-24 10.76-24 24.02S10.75 80.03 24 80.03zM302.5 303.7L216 395.7V152.1c0-13.26-10.75-24.05-24-24.05S168 138.8 168 152.1v243.6l-86.53-91.97C76.75 298.7 70.38 296.2 64 296.2c-5.906 0-11.81 2.158-16.44 6.536c-9.656 9.069-10.12 24.27-1.031 33.93l127.1 136.1c9.062 9.694 25.88 9.694 34.94 0l128-136.1c9.094-9.663 8.625-24.86-1.031-33.93C326.8 293.6 311.6 294 302.5 303.7z"],
    "arrow-down-left": [320, 512, [], "e091", "M312.1 136.1L81.94 368H264c13.25 0 24 10.75 24 24S277.3 416 264 416h-240C10.75 416 0 405.3 0 392v-240C0 138.8 10.75 128 24 128S48 138.8 48 152v182.1l231-231c9.375-9.375 24.56-9.375 33.94 0S322.3 127.6 312.1 136.1z"],
    "arrow-down-left-and-arrow-up-right-to-center": [512, 512, [], "e092", "M286.8 238.1C289.8 239.4 292.9 240 296 240h144c13.25 0 23.94-10.69 23.94-23.94S453.3 192 440 192h-86.06l135-135c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L320 158.1V72c0-13.25-10.81-23.94-24.06-23.94S272 58.75 272 72v144c0 3.133 .6406 6.25 1.855 9.18C276.3 231 280.1 235.7 286.8 238.1zM225.2 273.9C222.2 272.6 219.1 272 216 272h-144c-13.25 0-23.94 10.69-23.94 23.94S58.75 320 72 320h86.06l-135 135c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L192 353.9V440c0 13.25 10.81 23.94 24.06 23.94S240 453.3 240 440v-144c0-3.133-.6406-6.25-1.855-9.18C235.7 280.1 231 276.3 225.2 273.9z"],
    "arrow-down-long": [320, 512, ["long-arrow-down"], "f175", "M7.031 335C11.72 330.3 17.84 328 24 328s12.28 2.344 16.97 7.031L136 430.1V24C136 10.75 146.8 0 160 0s24 10.75 24 24v406.1l95.03-95.03c9.375-9.375 24.56-9.375 33.94 0s9.375 24.56 0 33.94l-136 136c-9.375 9.375-24.56 9.375-33.94 0l-136-136C-2.344 359.6-2.344 344.4 7.031 335z"],
    "arrow-down-right": [320, 512, [], "e093", "M320 152v240c0 13.25-10.75 24-24 24h-240C42.75 416 32 405.3 32 392s10.75-24 24-24h182.1L7.031 136.1c-9.375-9.375-9.375-24.56 0-33.94s24.56-9.375 33.94 0L272 334.1V152C272 138.8 282.8 128 296 128S320 138.8 320 152z"],
    "arrow-down-short-wide": [576, 512, ["sort-amount-desc", "sort-amount-down-alt"], "f884", "M312 96h48c13.25 0 23.1-10.75 23.1-24S373.2 48 360 48h-48C298.8 48 288 58.75 288 72S298.8 96 312 96zM312 224h111.1c13.25 0 24-10.75 24-24s-10.75-24-24-24H312C298.8 176 288 186.8 288 200S298.8 224 312 224zM551.1 432H312c-13.25 0-24 10.75-24 24S298.8 480 312 480h239.1c13.25 0 24-10.75 24-24S565.2 432 551.1 432zM312 352h175.1c13.25 0 24-10.75 24-24s-10.75-24-24-24H312C298.8 304 288 314.8 288 328S298.8 352 312 352zM206.4 335.1L152 394.9V56.02C152 42.76 141.3 32 128 32S104 42.76 104 56.02v338.9l-54.37-58.95c-4.719-5.125-11.16-7.719-17.62-7.719c-5.812 0-11.66 2.094-16.28 6.375c-9.75 8.977-10.34 24.18-1.344 33.94l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0l95.1-104.1c9-9.758 8.406-24.96-1.344-33.94C230.5 325.5 215.3 326.2 206.4 335.1z"],
    "arrow-down-small-big": [512, 512, ["sort-size-down-alt"], "f88d", "M320 192h96c17.6 0 32-14.4 32-32V64c0-17.6-14.4-32-32-32h-96c-17.6 0-32 14.4-32 32v96C288 177.6 302.4 192 320 192zM336 80h64v64h-64V80zM480 256h-160c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32V288C512 270.3 497.7 256 480 256zM464 432h-128v-128h128V432zM206.4 335.1L152 394.9V56.02C152 42.76 141.3 32 128 32S104 42.76 104 56.02v338.9l-54.37-58.95c-4.719-5.125-11.16-7.719-17.62-7.719c-5.812 0-11.66 2.094-16.28 6.375c-9.75 8.977-10.34 24.18-1.344 33.94l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0l95.1-104.1c9-9.758 8.406-24.96-1.344-33.94C230.5 325.5 215.3 326.2 206.4 335.1z"],
    "arrow-down-square-triangle": [512, 512, ["sort-shapes-down-alt"], "f889", "M448 32h-128c-17.67 0-31.1 14.33-31.1 32v128c0 17.67 14.33 32 31.1 32h128c17.67 0 32-14.33 32-32V64C480 46.33 465.7 32 448 32zM432 176h-96v-96h96V176zM492.1 438.9l-83.13-137.1c-5.375-8.625-14.84-13.76-24.97-13.76c-10.13 0-19.53 5.136-24.91 13.76l-83.25 137.1c-11 18.25 2.749 41.13 25 41.13h166.3C489.4 480 503.1 457.1 492.1 438.9zM336.3 432l47.75-78.88L431.8 432H336.3zM241.6 368.6c9-9.758 8.406-24.96-1.344-33.93c-4.623-4.281-10.47-6.379-16.28-6.379c-6.469 0-12.91 2.598-17.62 7.723L152 394.9V56.02c0-13.26-10.75-24.02-24-24.02S104 42.76 104 56.02v338.9l-54.37-58.95c-8.938-9.758-24.12-10.41-33.9-1.344c-9.75 8.977-10.34 24.18-1.344 33.93l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0L241.6 368.6z"],
    "arrow-down-to-bracket": [448, 512, [], "e094", "M352 512H96c-53.02 0-96-42.98-96-96v-72C0 330.7 10.75 320 24 320c13.26 0 24 10.75 24 24V416c0 26.4 21.6 48 48 48h256c26.4 0 48-21.6 48-48v-72c0-13.25 10.75-24 24-24c13.26 0 24 10.75 24 24V416C448 469 405 512 352 512zM240.4 345.5l136-128c9.688-9.094 10.12-24.28 1.031-33.91c-9.062-9.656-24.25-10.12-33.91-1.031L248 272.4V24C248 10.75 237.3 0 224 0S200 10.75 200 24v248.4L104.4 182.5C94.78 173.4 79.59 173.9 70.53 183.6C66.16 188.2 64 194.1 64 200c0 6.375 2.531 12.75 7.562 17.47l136 128C216.8 354.2 231.2 354.2 240.4 345.5z"],
    "arrow-down-to-dotted-line": [448, 512, [], "e095", "M224 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S241.7 416 224 416zM32 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S49.67 416 32 416zM128 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S145.7 416 128 416zM320 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S337.7 416 320 416zM416 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S433.7 416 416 416zM206.5 360.7c9.062 9.699 25.88 9.699 34.94 0l128-136.2c9.094-9.672 8.625-24.88-1.031-33.96c-9.625-9.109-24.81-8.672-33.91 1.031L248 283.6v-211.6c0-13.27-10.75-24.04-24-24.04S200 58.76 200 72.04v211.6l-86.53-92.05C108.8 186.6 102.4 184 96 184c-5.906 0-11.81 2.16-16.44 6.543C69.91 199.6 69.44 214.8 78.53 224.5L206.5 360.7z"],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", "M360 431.1H24c-13.25 0-24 10.76-24 24.02C0 469.2 10.75 480 24 480h336c13.25 0 24-10.76 24-24.02C384 442.7 373.3 431.1 360 431.1zM302.5 207.7L216 299.7v-243.6C216 42.76 205.3 32 192 32S168 42.76 168 56.02v243.6L81.47 207.7C76.75 202.6 70.38 200.1 64 200.1c-5.906 0-11.81 2.158-16.44 6.536c-9.656 9.069-10.12 24.27-1.031 33.93l128 136.1c9.062 9.694 25.88 9.694 34.94 0l128-136.1c9.094-9.663 8.625-24.86-1.031-33.93C326.8 197.5 311.6 197.1 302.5 207.7z"],
    "arrow-down-to-square": [512, 512, [], "e096", "M416 128h-40C362.7 128 352 138.7 352 152c0 13.25 10.75 24 24 24H416c8.836 0 16 7.164 16 16v256c0 8.836-7.164 16-16 16H96c-8.836 0-16-7.164-16-16V192c0-8.836 7.164-16 16-16h40C149.3 176 160 165.3 160 152C160 138.7 149.3 128 136 128H96C60.65 128 32 156.7 32 192v256c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V192C480 156.7 451.3 128 416 128zM143.7 238.6C133.1 247.6 133.4 262.8 142.4 272.6l96 104.1c9.062 9.82 26.19 9.82 35.25 0l96-104.1c9-9.758 8.406-24.95-1.344-33.93c-9.781-9.07-24.97-8.414-33.91 1.344L280 298.9V24.02C280 10.76 269.3 0 256 0S232 10.76 232 24.02v274.9l-54.38-58.95C172.9 234.8 166.5 232.3 160 232.3C154.2 232.3 148.3 234.3 143.7 238.6z"],
    "arrow-down-triangle-square": [512, 512, ["sort-shapes-down"], "f888", "M448 288h-128c-17.67 0-31.1 14.33-31.1 32V448c0 17.67 14.33 32 31.1 32h128c17.67 0 32-14.33 32-32v-127.1C480 302.3 465.7 288 448 288zM432 432h-96v-96h96V432zM492.1 182.9l-83.13-137.1c-5.375-8.625-14.84-13.78-24.97-13.78c-10.13 0-19.53 5.153-24.91 13.78l-83.25 137.1c-11 18.25 2.749 41.12 25 41.12h166.3C489.4 224 503.1 201.1 492.1 182.9zM336.3 176l47.75-78.88L431.8 176H336.3zM241.6 368.6c9-9.758 8.406-24.96-1.344-33.93c-4.623-4.281-10.47-6.379-16.28-6.379c-6.469 0-12.91 2.598-17.62 7.723L152 394.9V56.02c0-13.26-10.75-24.02-24-24.02S104 42.76 104 56.02v338.9l-54.37-58.95c-8.938-9.758-24.12-10.41-33.9-1.344c-9.75 8.977-10.34 24.18-1.344 33.93l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0L241.6 368.6z"],
    "arrow-down-wide-short": [576, 512, ["sort-amount-asc", "sort-amount-down"], "f160", "M360 432h-48c-13.25 0-24 10.75-24 24S298.8 480 312 480h48c13.25 0 23.1-10.75 23.1-24S373.2 432 360 432zM423.1 304H312C298.8 304 288 314.8 288 328S298.8 352 312 352h111.1c13.25 0 24-10.75 24-24S437.2 304 423.1 304zM487.1 176H312C298.8 176 288 186.8 288 200S298.8 224 312 224h175.1c13.25 0 24-10.75 24-24S501.2 176 487.1 176zM551.1 48H312C298.8 48 288 58.75 288 72S298.8 96 312 96h239.1c13.25 0 24-10.75 24-24S565.2 48 551.1 48zM206.4 335.1L152 394.9V56.02C152 42.76 141.3 32 128 32S104 42.76 104 56.02v338.9l-54.37-58.95c-4.719-5.125-11.16-7.719-17.62-7.719c-5.812 0-11.66 2.094-16.28 6.375c-9.75 8.977-10.34 24.18-1.344 33.94l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0l95.1-104.1c9-9.758 8.406-24.96-1.344-33.94C230.5 325.5 215.3 326.2 206.4 335.1z"],
    "arrow-down-z-a": [512, 512, ["sort-alpha-desc", "sort-alpha-down-alt"], "f881", "M327.1 80h62.94L309.1 185.2c-5.623 7.25-6.654 17.06-2.625 25.28c4.031 8.25 12.41 13.47 21.56 13.47h111.1c13.25 0 23.1-10.75 23.1-24s-10.75-24-23.1-24H377.1l81.87-105.2c5.625-7.25 6.656-17.06 2.625-25.28C457.5 37.22 449.1 32 439.1 32h-111.1c-13.25 0-23.1 10.75-23.1 24S314.7 80 327.1 80zM477.5 445.3l-71.1-144c-8.123-16.3-34.81-16.3-42.94 0l-71.1 144c-5.938 11.84-1.125 26.25 10.75 32.19c11.9 5.938 26.25 1.156 32.19-10.75l5.359-10.72h90.34l5.359 10.72c4.219 8.438 12.69 13.28 21.5 13.28c3.594 0 7.25-.8125 10.69-2.531C478.6 471.5 483.4 457.1 477.5 445.3zM362.8 407.1l21.17-42.34l21.17 42.34H362.8zM206.4 335.1L152 394.9V56.02c0-13.27-10.75-24.02-24-24.02S104 42.76 104 56.02v338.9l-54.37-58.95c-4.719-5.125-11.16-7.719-17.62-7.719c-5.812 0-11.66 2.094-16.28 6.375c-9.75 8.977-10.34 24.18-1.344 33.94l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0l95.1-104.1c9-9.758 8.406-24.96-1.344-33.94C230.5 325.5 215.3 326.2 206.4 335.1z"],
    "arrow-left": [448, 512, [61536], "2190", "M447.1 256c0 13.25-10.76 24.01-24.01 24.01H83.9l132.7 126.6c9.625 9.156 9.969 24.41 .8125 33.94c-9.156 9.594-24.34 9.938-33.94 .8125l-176-168C2.695 268.9 .0078 262.6 .0078 256S2.695 243.2 7.445 238.6l176-168C193 61.51 208.2 61.85 217.4 71.45c9.156 9.5 8.812 24.75-.8125 33.94l-132.7 126.6h340.1C437.2 232 447.1 242.8 447.1 256z"],
    "arrow-left-from-line": [448, 512, [62276, "arrow-from-right"], "21a4", "M399.1 88v336c0 13.25 10.76 24 24.02 24S448 437.3 448 424V88C448 74.75 437.2 64 423.1 64S399.1 74.75 399.1 88zM176.3 366.5L84.28 280h243.6c13.26 0 24.05-10.75 24.05-24S341.2 232 327.9 232h-243.6l91.98-86.53C181.3 140.8 183.8 134.4 183.8 128c0-5.906-2.158-11.81-6.536-16.44C168.2 101.9 153 101.4 143.4 110.5l-136.1 128c-9.694 9.062-9.694 25.88 0 34.94l136.1 128c9.663 9.094 24.86 8.625 33.93-1.031C186.4 390.8 185.1 375.6 176.3 366.5z"],
    "arrow-left-long": [512, 512, ["long-arrow-left"], "f177", "M176.1 103C181.7 107.7 184 113.8 184 120S181.7 132.3 176.1 136.1L81.94 232H488C501.3 232 512 242.8 512 256s-10.75 24-24 24H81.94l95.03 95.03c9.375 9.375 9.375 24.56 0 33.94s-24.56 9.375-33.94 0l-136-136c-9.375-9.375-9.375-24.56 0-33.94l136-136C152.4 93.66 167.6 93.66 176.1 103z"],
    "arrow-left-to-line": [448, 512, [62270, "arrow-to-left"], "21e4", "M48.03 424V88c0-13.25-10.76-24-24.02-24S0 74.75 0 88v336C0 437.3 10.76 448 24.02 448S48.03 437.3 48.03 424zM272.3 366.5L180.3 280h243.6C437.2 280 448 269.3 448 256s-10.76-23.1-24.02-23.1H180.3l91.98-86.53c5.035-4.719 7.568-11.09 7.568-17.47c0-5.906-2.158-11.81-6.536-16.44c-9.069-9.656-24.27-10.12-33.93-1.031l-136.1 128c-9.694 9.062-9.694 25.87 0 34.94l136.1 128c9.663 9.094 24.86 8.625 33.93-1.031C282.5 390.8 282 375.6 272.3 366.5z"],
    "arrow-pointer": [320, 512, ["mouse-pointer"], "f245", "M311.9 279.5L39.87 37.99C35.41 34.03 29.75 32 24.01 32C20.67 32 17.31 32.69 14.12 34.11C5.531 38.01 0 46.52 0 56.02v370.3c0 10.12 6.281 19.18 15.72 22.67c2.703 .9903 5.5 1.478 8.281 1.478c6.906 0 13.64-3.002 18.28-8.504l83.48-98.81l58.25 123.1c5.697 12.04 20.01 17.15 31.98 11.42c11.97-5.731 17.06-20.14 11.36-32.18l-58.58-123.8h127.2c9.984 0 18.92-6.209 22.45-15.61C321.1 296.7 319.4 286.1 311.9 279.5zM121.7 273.4l-73.69 87.23V109.6l184.5 163.8H121.7z"],
    "arrow-right": [448, 512, [61537], "2192", "M264.6 70.63l176 168c4.75 4.531 7.438 10.81 7.438 17.38s-2.688 12.84-7.438 17.38l-176 168c-9.594 9.125-24.78 8.781-33.94-.8125c-9.156-9.5-8.812-24.75 .8125-33.94l132.7-126.6H24.01c-13.25 0-24.01-10.76-24.01-24.01s10.76-23.99 24.01-23.99h340.1l-132.7-126.6C221.8 96.23 221.5 80.98 230.6 71.45C239.8 61.85 254.1 61.51 264.6 70.63z"],
    "arrow-right-arrow-left": [512, 512, [61676, "exchange"], "21c4", "M488 344H79.24l74.29-79.63C162.6 254.7 162.1 239.5 152.4 230.5C142.7 221.4 127.5 221.9 118.5 231.6l-112 120c-8.625 9.219-8.625 23.53 0 32.75l112 120C123.2 509.4 129.6 512 136 512c5.875 0 11.75-2.125 16.38-6.469c9.688-9.031 10.22-24.22 1.156-33.91L79.24 392H488c13.25 0 24-10.75 24-24S501.3 344 488 344zM24 168h408.8l-74.29 79.63c-9.062 9.688-8.531 24.88 1.156 33.91c9.656 9.094 24.88 8.562 33.91-1.156l112-120c8.625-9.219 8.625-23.53 0-32.75l-112-120C388.8 2.562 382.4 0 376 0c-5.875 0-11.75 2.125-16.38 6.469c-9.688 9.031-10.22 24.22-1.156 33.91L432.8 120H24C10.75 120 0 130.8 0 144S10.75 168 24 168z"],
    "arrow-right-from-bracket": [512, 512, ["sign-out"], "f08b", "M192 456C192 469.3 181.3 480 168 480H96c-53.02 0-96-42.98-96-96V128c0-53.02 42.98-96 96-96h72C181.3 32 192 42.74 192 56C192 69.25 181.3 80 168 80H96C69.6 80 48 101.6 48 128v256c0 26.4 21.6 48 48 48h72C181.3 432 192 442.7 192 456zM505.5 239.6l-127.1-136c-9.094-9.688-24.28-10.12-33.91-1.031c-9.656 9.062-10.12 24.25-1.031 33.91L432.4 232H183.1C170.7 232 160 242.8 160 256s10.75 24 23.1 24h248.4l-89.92 95.56c-9.094 9.656-8.625 24.84 1.031 33.91C348.2 413.8 354.1 416 359.1 416c6.375 0 12.75-2.531 17.47-7.562l127.1-136C514.2 263.2 514.2 248.8 505.5 239.6z"],
    "arrow-right-from-line": [448, 512, [62275, "arrow-from-left"], "21a6", "M48.03 424V88c0-13.25-10.76-24-24.02-24S0 74.75 0 88v336c0 13.25 10.76 24 24.02 24S48.03 437.3 48.03 424zM271.7 145.5L363.7 232H120.1C106.8 232 96.03 242.8 96.03 256S106.8 280 120.1 280h243.6l-91.98 86.53C266.7 371.3 264.2 377.6 264.2 384c0 5.906 2.158 11.81 6.536 16.44c9.069 9.656 24.27 10.12 33.93 1.031l136.1-128c9.694-9.062 9.694-25.88 0-34.94l-136.1-128c-9.663-9.094-24.86-8.625-33.93 1.031C261.6 121.2 262 136.4 271.7 145.5z"],
    "arrow-right-long": [512, 512, ["long-arrow-right"], "f178", "M335 408.1C330.3 404.3 328 398.2 328 392s2.344-12.28 7.031-16.97L430.1 280H24C10.75 280 0 269.2 0 255.1C0 242.7 10.75 232 24 232h406.1l-95.03-95.03c-9.375-9.375-9.375-24.56 0-33.94s24.56-9.375 33.94 0l136 136c9.375 9.375 9.375 24.56 0 33.94l-136 136C359.6 418.3 344.4 418.3 335 408.1z"],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", "M512 128v256c0 53.02-42.98 96-96 96h-72C330.7 480 320 469.3 320 456c0-13.26 10.75-24 24-24H416c26.4 0 48-21.6 48-48V128c0-26.4-21.6-48-48-48h-72C330.7 80 320 69.25 320 56C320 42.74 330.7 32 344 32H416C469 32 512 74.98 512 128zM345.5 239.6l-128-136C208.4 93.88 193.2 93.44 183.6 102.5C173.9 111.6 173.4 126.8 182.5 136.4L272.4 232H24C10.75 232 0 242.8 0 256s10.75 24 24 24h248.4l-89.92 95.56c-9.094 9.656-8.625 24.84 1.031 33.91C188.2 413.8 194.1 416 200 416c6.375 0 12.75-2.531 17.47-7.562l128-136C354.2 263.2 354.2 248.8 345.5 239.6z"],
    "arrow-right-to-line": [448, 512, [62272, "arrow-to-right"], "21e5", "M399.1 88v336c0 13.25 10.76 24 24.02 24C437.2 448 448 437.3 448 424V88C448 74.75 437.2 64 423.1 64C410.7 64 399.1 74.75 399.1 88zM175.7 145.5l91.98 86.53h-243.6C10.76 232 0 242.8 0 256s10.76 24 24.02 24h243.6l-91.98 86.53C170.6 371.3 168.1 377.6 168.1 384c0 5.906 2.158 11.81 6.536 16.44c9.069 9.656 24.27 10.12 33.93 1.031l136.1-128c9.694-9.062 9.694-25.87 0-34.94l-136.1-128C198.9 101.4 183.7 101.9 174.6 111.6C165.5 121.2 165.1 136.4 175.7 145.5z"],
    "arrow-rotate-left": [512, 512, [61666, "arrow-left-rotate", "arrow-rotate-back", "arrow-rotate-backward", "undo"], "21ba", "M40 16C53.25 16 64 26.75 64 40v102.1C103.7 75.57 176.3 32.11 256.1 32.11C379.6 32.11 480 132.5 480 256s-100.4 223.9-223.9 223.9c-52.31 0-103.3-18.33-143.5-51.77c-10.19-8.5-11.56-23.62-3.062-33.81c8.5-10.22 23.66-11.56 33.81-3.062C174.9 417.5 214.9 432 256 432c97.03 0 176-78.97 176-176S353 80 256 80c-66.54 0-126.8 38.28-156.5 96H200C213.3 176 224 186.8 224 200S213.3 224 200 224h-160C26.75 224 16 213.3 16 200v-160C16 26.75 26.75 16 40 16z"],
    "arrow-rotate-right": [512, 512, [61470, "arrow-right-rotate", "arrow-rotate-forward", "redo"], "21bb", "M496 40v160C496 213.3 485.3 224 472 224h-160C298.8 224 288 213.3 288 200s10.75-24 24-24h100.5C382.8 118.3 322.5 80 256 80C158.1 80 80 158.1 80 256s78.97 176 176 176c41.09 0 81.09-14.47 112.6-40.75c10.16-8.5 25.31-7.156 33.81 3.062c8.5 10.19 7.125 25.31-3.062 33.81c-40.16 33.44-91.17 51.77-143.5 51.77C132.4 479.9 32 379.5 32 256s100.4-223.9 223.9-223.9c79.85 0 152.4 43.46 192.1 109.1V40c0-13.25 10.75-24 24-24S496 26.75 496 40z"],
    "arrow-trend-down": [576, 512, [], "e097", "M576 216v176c0 13.25-10.75 24-24 24h-176C362.8 416 352 405.3 352 392s10.75-24 24-24h118.1L320 193.9L208.1 304.1C204.3 309.7 198.1 312 192 312S179.7 309.7 175 304.1l-168-168C2.344 132.3 0 126.1 0 120C0 106.3 11.21 96 24 96c6.141 0 12.28 2.344 16.97 7.031L192 254.1l111-111C307.7 138.3 313.9 136 320 136s12.28 2.344 16.97 7.031L528 334.1V216C528 202.8 538.8 192 552 192S576 202.8 576 216z"],
    "arrow-trend-up": [576, 512, [], "e098", "M576 120v176C576 309.3 565.3 320 552 320S528 309.3 528 296V177.9l-191 191C332.3 373.7 326.1 376 320 376s-12.28-2.344-16.97-7.031L192 257.9l-151 151C36.28 413.7 30.16 416 24 416C5.205 416 0 398.8 0 392c0-6.141 2.344-12.28 7.031-16.97l168-168C179.7 202.3 185.9 200 192 200s12.28 2.344 16.97 7.031L320 318.1L494.1 144H376C362.8 144 352 133.3 352 120S362.8 96 376 96h176C565.3 96 576 106.8 576 120z"],
    "arrow-turn-down": [384, 512, ["level-down"], "f149", "M336.1 376.1l-128 128C204.3 509.7 198.2 512 191.1 512s-12.28-2.344-16.97-7.031l-128-128c-9.375-9.375-9.375-24.56 0-33.94s24.56-9.375 33.94 0L168 430.1V48h-144C10.75 48 0 37.25 0 24S10.75 0 24 0H192c13.25 0 24 10.75 24 24v406.1l87.03-87.03c9.375-9.375 24.56-9.375 33.94 0S346.3 367.6 336.1 376.1z"],
    "arrow-turn-down-left": [512, 512, [], "e2e1", "M135 432.1l-128-128C2.344 300.3 0 294.2 0 288s2.344-12.28 7.031-16.97l128-128c9.375-9.375 24.56-9.375 33.94 0s9.375 24.56 0 33.94L81.94 264H464v-208C464 42.75 474.8 32 488 32S512 42.75 512 56V288c0 13.25-10.75 24-24 24H81.94l87.03 87.03c9.375 9.375 9.375 24.56 0 33.94S144.4 442.3 135 432.1z"],
    "arrow-turn-up": [384, 512, ["level-up"], "f148", "M336.1 168.1c-9.375 9.375-24.56 9.375-33.94 0L216 81.94V488c0 13.25-10.75 24-24 24H24C10.75 512 0 501.3 0 488s10.75-24 24-24h144V81.94L80.97 168.1c-9.375 9.375-24.56 9.375-33.94 0s-9.375-24.56 0-33.94l128-128C179.7 2.344 185.8 0 192 0s12.28 2.344 16.97 7.031l128 128C346.3 144.4 346.3 159.6 336.1 168.1z"],
    "arrow-up": [384, 512, [61538], "2191", "M6.625 215.5l168-176C179.2 34.7 185.4 32.02 192 32.02s12.84 2.688 17.38 7.438l168 176c9.125 9.594 8.781 24.78-.8125 33.94c-9.5 9.156-24.75 8.812-33.94-.8125L216 115.9V456c0 13.25-10.75 23.1-23.1 23.1S168 469.3 168 456V115.9l-126.6 132.7C32.22 258.2 16.97 258.5 7.438 249.4C-2.156 240.2-2.5 225 6.625 215.5z"],
    "arrow-up-1-9": [512, 512, ["sort-numeric-up"], "f163", "M352 175.1c-13.25 0-24 10.75-24 24s10.75 24.01 23.1 24.01L432 223.1c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-120c0-8.656-4.656-16.62-12.19-20.88c-7.531-4.312-16.78-4.094-24.16 .2813l-40 24c-11.38 6.844-15.06 21.56-8.25 32.94c6.812 11.34 21.5 15.06 32.94 8.25l3.656-2.219v77.63H352zM392 256c-48.6 0-88 39.4-88 88c0 42.05 29.55 77.1 68.98 85.81l-15.54 19c-8.406 10.25-6.906 25.38 3.375 33.75C365.3 486.2 370.6 488 376 488c6.938 0 13.84-3 18.56-8.812C465.1 392.1 480 382.5 480 344C480 295.4 440.6 256 392 256zM421.3 370.8l-1.443 1.762C412.6 379.6 402.8 384 392 384c-22.06 0-40-17.95-40-40S369.9 304 392 304s40 17.95 40 40C432 354.4 427.8 363.7 421.3 370.8zM145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.93C20.35 181.7 26.19 183.8 32 183.8c6.469 0 12.91-2.598 17.62-7.723L104 117.1v338.9c0 13.26 10.75 24.02 24 24.02S152 469.2 152 455.1V117.1l54.37 58.95C215.3 185.8 230.5 186.5 240.3 177.4c9.75-8.977 10.34-24.18 1.344-33.93L145.6 39.37z"],
    "arrow-up-9-1": [512, 512, ["sort-numeric-up-alt"], "f887", "M372.1 205.8l-15.54 19c-8.406 10.25-6.906 25.38 3.375 33.75C365.3 262.2 370.6 264 376 264c6.938 0 13.84-3 18.56-8.812C465.1 168.1 480 158.5 480 120c0-48.6-39.4-88-88-88s-88 39.4-88 88C303.1 162.1 333.5 197.1 372.1 205.8zM392 80c22.06 0 40 17.95 40 40c0 10.4-4.223 19.7-10.75 26.82l-1.443 1.762C412.6 155.6 402.8 160 392 160c-22.06 0-40-17.95-40-40S369.9 80 392 80zM145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.93C20.35 181.7 26.19 183.8 32 183.8c6.469 0 12.91-2.598 17.62-7.723L104 117.1v338.9c0 13.26 10.75 24.02 24 24.02S152 469.2 152 455.1V117.1l54.37 58.95C215.3 185.8 230.5 186.5 240.3 177.4c9.75-8.977 10.34-24.18 1.344-33.93L145.6 39.37zM432 432H416V312c0-8.656-4.656-16.62-12.19-20.88c-7.531-4.312-16.78-4.094-24.16 .2813l-40 24c-11.38 6.844-15.06 21.56-8.25 32.94c6.812 11.34 21.5 15.06 32.94 8.25l3.656-2.219V432h-16c-13.25 0-24 10.75-24 24S338.8 480 352 480H432c13.25 0 24-10.75 24-24S445.3 432 432 432z"],
    "arrow-up-a-z": [512, 512, ["sort-alpha-up"], "f15e", "M477.5 189.1l-71.1-144.1c-8.123-16.32-34.81-16.32-42.94 0l-71.1 144.1c-5.938 11.86-1.125 26.27 10.75 32.21c11.9 5.941 26.25 1.16 32.19-10.76l5.359-10.73h90.34l5.359 10.73c4.219 8.441 12.69 13.29 21.5 13.29c3.594 0 7.25-.8125 10.69-2.535C478.6 215.3 483.4 200.9 477.5 189.1zM362.8 151.8l21.17-42.38l21.17 42.38H362.8zM439.1 431.1H377.1l81.87-105.3c5.625-7.258 6.656-17.08 2.625-25.3c-4.031-8.258-12.41-13.48-21.56-13.48h-111.1c-13.25 0-23.1 10.76-23.1 24.02s10.75 24.02 23.1 24.02h62.94L309.1 441.2c-5.623 7.258-6.654 17.08-2.625 25.3C310.5 474.8 318.8 480 327.1 480h111.1c13.25 0 23.1-10.76 23.1-24.02S453.2 431.1 439.1 431.1zM145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.94C20.35 181.7 26.19 183.8 32 183.8c6.469 0 12.91-2.594 17.62-7.719L104 117.1v338.9C104 469.2 114.8 480 128 480S152 469.2 152 455.1V117.1l54.37 58.95C215.3 185.8 230.5 186.5 240.3 177.4C250 168.4 250.6 153.2 241.6 143.4L145.6 39.37z"],
    "arrow-up-arrow-down": [448, 512, ["sort-up-down"], "e099", "M240.3 177.4c9.75-8.977 10.34-24.18 1.344-33.94L145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.94C20.35 181.7 26.19 183.8 32 183.8c6.469 0 12.91-2.594 17.62-7.719L104 117.1v338.9C104 469.2 114.8 480 128 480s24-10.76 24-24.02V117.1l54.37 58.95C215.3 185.8 230.5 186.5 240.3 177.4zM432.3 334.6c-9.779-9.07-24.97-8.414-33.9 1.344L344 394.9V56.02C344 42.76 333.3 32 320 32s-24 10.76-24 24.02v338.9l-54.37-58.95c-4.719-5.125-11.16-7.719-17.62-7.719c-5.812 0-11.66 2.094-16.28 6.375c-9.75 8.977-10.34 24.18-1.344 33.94l95.1 104.1c9.062 9.82 26.19 9.82 35.25 0l95.1-104.1C442.6 358.8 442 343.6 432.3 334.6z"],
    "arrow-up-big-small": [512, 512, ["sort-size-up"], "f88e", "M416 320h-96c-17.6 0-32 14.4-32 32v96c0 17.6 14.4 32 32 32h96c17.6 0 32-14.4 32-32v-96C448 334.4 433.6 320 416 320zM400 432h-64v-64h64V432zM480 32h-160c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32V64C512 46.33 497.7 32 480 32zM464 208h-128v-128h128V208zM145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.94C20.35 181.7 26.19 183.8 32 183.8c6.469 0 12.91-2.594 17.62-7.719L104 117.1v338.9C104 469.2 114.8 480 128 480s24-10.76 24-24.02V117.1l54.37 58.95C215.3 185.8 230.5 186.5 240.3 177.4C250 168.4 250.6 153.2 241.6 143.4L145.6 39.37z"],
    "arrow-up-from-bracket": [448, 512, [], "e09a", "M424 320c13.25 0 24 10.75 24 24V416c0 53.02-42.98 96-96 96H96c-53.02 0-96-42.98-96-96v-72C0 330.7 10.74 320 24 320c13.25 0 24 10.75 24 24V416c0 26.4 21.6 48 48 48h256c26.4 0 48-21.6 48-48v-72C400 330.7 410.7 320 424 320zM207.6 6.539l-136 127.1C61.88 143.6 61.44 158.8 70.53 168.4c9.062 9.656 24.25 10.12 33.91 1.031L200 79.56v248.4C200 341.3 210.8 352 224 352s24-10.75 24-23.1V79.56l95.56 89.92c9.656 9.094 24.84 8.625 33.91-1.031C381.8 163.8 384 157.9 384 152c0-6.375-2.531-12.75-7.562-17.47l-136-127.1C231.2-2.18 216.8-2.18 207.6 6.539z"],
    "arrow-up-from-dotted-line": [448, 512, [], "e09b", "M224 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S241.7 416 224 416zM32 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S49.67 416 32 416zM128 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S145.7 416 128 416zM320 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S337.7 416 320 416zM416 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S433.7 416 416 416zM241.5 39.27c-9.062-9.699-25.88-9.699-34.94 0l-128 136.2C69.44 185.2 69.91 200.4 79.56 209.4c9.625 9.109 24.81 8.672 33.91-1.031L200 116.4v211.6C200 341.2 210.8 352 224 352s24-10.77 24-24.04v-211.6l86.53 92.05C339.3 213.4 345.6 215.1 352 215.1c5.906 0 11.81-2.16 16.44-6.543c9.656-9.074 10.12-24.29 1.031-33.96L241.5 39.27z"],
    "arrow-up-from-line": [384, 512, [62274, "arrow-from-bottom"], "21a5", "M360 431.1H24c-13.25 0-24 10.76-24 24.02C0 469.2 10.75 480 24 480h336c13.25 0 24-10.76 24-24.02C384 442.7 373.3 431.1 360 431.1zM81.47 208.3L168 116.3v243.6c0 13.26 10.75 24.05 24 24.05s24-10.79 24-24.05V116.3l86.53 91.98C307.3 213.3 313.6 215.8 320 215.8c5.906 0 11.81-2.158 16.44-6.536c9.656-9.068 10.12-24.27 1.031-33.93l-128-136.1c-9.062-9.694-25.88-9.694-34.94 0l-128 136.1C37.44 185 37.91 200.2 47.56 209.3C57.19 218.4 72.38 217.1 81.47 208.3z"],
    "arrow-up-from-square": [512, 512, [], "e09c", "M416 159.9l-8-.1648c-13.25 0-24 10.75-24 24.02c0 13.26 10.75 24.02 24 24.02H416c8.836 0 16 7.169 16 16.01v224.2c0 8.842-7.164 16.01-16 16.01H96c-8.836 0-16-7.169-16-16.01V223.8c0-8.842 7.164-16.01 16-16.01h8c13.25 0 24-10.75 24-24.02c0-13.27-10.75-24.02-24-24.02L96 159.9c-35.35 0-64 28.51-64 63.88v224.2C32 483.3 60.65 512 96 512h320c35.35 0 64-28.68 64-64.04V223.8C480 188.4 451.3 159.9 416 159.9zM160 151.8c6.47 0 12.91-2.614 17.62-7.752L232 85.08v234.8c0 13.26 10.75 24.02 24 24.02s24-10.76 24-24.02V85.08l54.38 58.95C339.1 149.2 345.5 151.7 352 151.7c13.23 0 24-10.77 24-24.05c0-5.83-2.108-11.64-6.376-16.26l-96-104.1C269.1 2.455 262.5-.0002 256-.0002S242.9 2.455 238.4 7.365l-96 104.1C138.1 116.1 135.1 121.9 135.1 127.7C135.1 141.1 146.9 151.8 160 151.8z"],
    "arrow-up-left": [320, 512, [], "e09d", "M312.1 408.1C308.3 413.7 302.1 416 296 416s-12.28-2.344-16.97-7.031L48 177.9V360C48 373.3 37.25 384 24 384S0 373.3 0 360v-240C0 106.8 10.75 96 24 96h240C277.3 96 288 106.8 288 120S277.3 144 264 144H81.94l231 231C322.3 384.4 322.3 399.6 312.1 408.1z"],
    "arrow-up-left-from-circle": [512, 512, [], "e09e", "M312 336c6.156 0 12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L81.94 48H192c13.25 0 24-10.75 24-24S205.3 0 192 0H24C10.75 0 0 10.75 0 24V192c0 13.25 10.75 24 24 24S48 205.3 48 192V81.94l247 247C299.7 333.7 305.8 336 312 336zM288 64c-13.25 0-24 10.75-24 24S274.8 112 288 112c97.03 0 176 78.97 176 176s-78.97 176-176 176S112 385 112 288c0-13.25-10.75-24-24-24S64 274.8 64 288c0 123.5 100.5 224 224 224s224-100.5 224-224S411.5 64 288 64z"],
    "arrow-up-long": [320, 512, ["long-arrow-up"], "f176", "M312.1 176.1C308.3 181.7 302.2 184 296 184s-12.28-2.344-16.97-7.031L184 81.94V488c0 13.25-10.75 24-24 24s-24-10.75-24-24V81.94L40.97 176.1c-9.375 9.375-24.56 9.375-33.94 0s-9.375-24.56 0-33.94l136-136c9.375-9.375 24.56-9.375 33.94 0l136 136C322.3 152.4 322.3 167.6 312.1 176.1z"],
    "arrow-up-right": [320, 512, [], "e09f", "M320 120v240c0 13.25-10.75 24-24 24s-24-10.75-24-24V177.9l-231 231C36.28 413.7 30.14 416 24 416s-12.28-2.344-16.97-7.031c-9.375-9.375-9.375-24.56 0-33.94L238.1 144H56C42.75 144 32 133.3 32 120S42.75 96 56 96h240C309.3 96 320 106.8 320 120z"],
    "arrow-up-right-and-arrow-down-left-from-center": [512, 512, [], "e0a0", "M497.2 1.852C494.2 .6406 491.1 0 488 0h-143.1C330.8 0 320 10.75 320 24s10.75 24 24 24h86.06l-135 135c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L464 81.94V168C464 181.3 474.8 192 488 192S512 181.2 512 167.1V24c0-3.133-.6406-6.25-1.855-9.18C507.7 8.957 503 4.285 497.2 1.852zM14.83 510.1C17.76 511.4 20.88 512 24 512h143.1C181.2 512 192 501.3 192 488S181.3 464 168 464H81.94l135-135c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L48 430.1V344C48 330.8 37.25 320 24 320S0 330.8 0 344V488c0 3.133 .6406 6.25 1.855 9.18C4.289 503 8.965 507.7 14.83 510.1z"],
    "arrow-up-right-from-square": [512, 512, ["external-link"], "f08e", "M392 320c-13.25 0-24 10.75-24 24v112c0 4.406-3.594 8-8 8h-304c-4.406 0-8-3.594-8-8v-304c0-4.406 3.594-8 8-8h112C181.3 144 192 133.3 192 120S181.3 96 168 96h-112C25.13 96 0 121.1 0 152v304C0 486.9 25.13 512 56 512h304c30.88 0 56-25.12 56-56v-112C416 330.8 405.3 320 392 320zM488 0H320c-13.25 0-24 10.75-24 24S306.8 48 320 48h110.1L183 295c-9.375 9.375-9.375 24.56 0 33.94C187.7 333.7 193.8 336 200 336s12.28-2.344 16.97-7.031L464 81.94V192c0 13.25 10.75 24 24 24S512 205.3 512 192V24C512 10.75 501.3 0 488 0z"],
    "arrow-up-short-wide": [576, 512, ["sort-amount-up-alt"], "f885", "M312 95.7h48c13.25 0 23.1-10.76 23.1-24.02c0-13.26-10.75-24.02-23.1-24.02h-48c-13.25 0-24 10.76-24 24.02C288 84.95 298.8 95.7 312 95.7zM312 351.9h175.1c13.25 0 24-10.76 24-24.02s-10.75-24.02-24-24.02H312c-13.25 0-24 10.76-24 24.02S298.8 351.9 312 351.9zM312 223.8h111.1c13.25 0 24-10.76 24-24.02s-10.75-24.02-24-24.02H312c-13.25 0-24 10.76-24 24.02S298.8 223.8 312 223.8zM551.1 431.1H312c-13.25 0-24 10.76-24 24.02S298.8 480 312 480h239.1c13.25 0 24-10.76 24-24.02S565.2 431.1 551.1 431.1zM145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.94C20.35 181.7 26.19 183.8 32 183.8c6.469 0 12.91-2.594 17.62-7.719L104 117.1v338.9C104 469.2 114.8 480 128 480S152 469.2 152 455.1V117.1l54.37 58.95C215.3 185.8 230.5 186.5 240.3 177.4C250 168.4 250.6 153.2 241.6 143.4L145.6 39.37z"],
    "arrow-up-small-big": [512, 512, ["sort-size-up-alt"], "f88f", "M480 256h-160c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32V288C512 270.3 497.7 256 480 256zM464 432h-128v-128h128V432zM320 192h96c17.6 0 32-14.4 32-32V64c0-17.6-14.4-32-32-32h-96c-17.6 0-32 14.4-32 32v96C288 177.6 302.4 192 320 192zM336 80h64v64h-64V80zM145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.94C20.35 181.7 26.19 183.8 32 183.8c6.469 0 12.91-2.594 17.62-7.719L104 117.1v338.9C104 469.2 114.8 480 128 480s24-10.76 24-24.02V117.1l54.37 58.95C215.3 185.8 230.5 186.5 240.3 177.4C250 168.4 250.6 153.2 241.6 143.4L145.6 39.37z"],
    "arrow-up-square-triangle": [512, 512, ["sort-shapes-up-alt"], "f88b", "M320 224h128c17.67 0 32-14.33 32-32V64c0-17.67-14.33-32-32-32h-128c-17.67 0-31.1 14.33-31.1 32v128C288 209.7 302.3 224 320 224zM336 80h96v96h-96V80zM492.1 438.9l-83.13-137.1c-5.375-8.625-14.84-13.76-24.97-13.76c-10.13 0-19.53 5.136-24.91 13.76l-83.25 137.1c-11 18.25 2.749 41.13 25 41.13h166.3C489.4 480 503.1 457.1 492.1 438.9zM336.3 432l47.75-78.88L431.8 432H336.3zM145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.93c9.779 9.07 24.97 8.414 33.9-1.344L104 117.1v338.9C104 469.2 114.8 480 128 480s24-10.76 24-24.02V117.1l54.37 58.95c4.719 5.125 11.16 7.723 17.62 7.723c5.812 0 11.66-2.098 16.28-6.379c9.75-8.977 10.34-24.18 1.344-33.93L145.6 39.37z"],
    "arrow-up-to-dotted-line": [448, 512, [], "e0a1", "M224 95.1c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S206.3 95.1 224 95.1zM416 95.1c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S398.3 95.1 416 95.1zM320 95.1c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S302.3 95.1 320 95.1zM128 95.1c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S110.3 95.1 128 95.1zM32 95.1c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S14.33 95.1 32 95.1zM241.5 151.3c-9.062-9.699-25.88-9.699-34.94 0l-128 136.2c-9.094 9.672-8.625 24.88 1.031 33.96c9.625 9.109 24.81 8.672 33.91-1.031L200 228.4v211.6C200 453.2 210.8 464 224 464s24-10.77 24-24.04v-211.6l86.53 92.05C339.3 325.4 345.6 327.1 352 327.1c5.906 0 11.81-2.16 16.44-6.543c9.656-9.074 10.12-24.29 1.031-33.96L241.5 151.3z"],
    "arrow-up-to-line": [384, 512, ["arrow-to-top"], "f341", "M24 80.03h336c13.25 0 24-10.76 24-24.02S373.3 32 360 32H24C10.75 32 0 42.76 0 56.02S10.75 80.03 24 80.03zM81.47 304.2L168 212.1v243.8C168 469.2 178.8 480 192 480s24-10.77 24-24.04V212.1l86.53 92.05C307.3 309.2 313.6 311.7 320 311.7c5.906 0 11.81-2.16 16.44-6.541c9.656-9.076 10.12-24.29 1.031-33.96l-128-136.2c-9.062-9.702-25.88-9.702-34.94 0L46.53 271.2C37.44 280.9 37.91 296.1 47.56 305.2C57.19 314.3 72.38 313.9 81.47 304.2z"],
    "arrow-up-triangle-square": [512, 512, ["sort-shapes-up"], "f88a", "M448 288h-128c-17.67 0-31.1 14.33-31.1 32V448c0 17.67 14.33 32 31.1 32h128c17.67 0 32-14.33 32-32v-127.1C480 302.3 465.7 288 448 288zM432 432h-96v-96h96V432zM492.1 182.9l-83.13-137.1c-5.375-8.625-14.84-13.78-24.97-13.78c-10.13 0-19.53 5.153-24.91 13.78l-83.25 137.1c-11 18.25 2.749 41.12 25 41.12h166.3C489.4 224 503.1 201.1 492.1 182.9zM336.3 176l47.75-78.88L431.8 176H336.3zM145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.93c9.779 9.07 24.97 8.414 33.9-1.344L104 117.1v338.9C104 469.2 114.8 480 128 480s24-10.76 24-24.02V117.1l54.37 58.95c4.719 5.125 11.16 7.723 17.62 7.723c5.812 0 11.66-2.098 16.28-6.379c9.75-8.977 10.34-24.18 1.344-33.93L145.6 39.37z"],
    "arrow-up-wide-short": [576, 512, ["sort-amount-up"], "f161", "M551.1 47.67H312c-13.25 0-24 10.76-24 24.02c0 13.26 10.75 24.02 24 24.02h239.1c13.25 0 24-10.76 24-24.02C575.1 58.43 565.2 47.67 551.1 47.67zM360 431.1h-48c-13.25 0-24 10.76-24 24.02S298.8 480 312 480h48c13.25 0 23.1-10.76 23.1-24.02S373.2 431.1 360 431.1zM423.1 303.9H312c-13.25 0-24 10.76-24 24.02s10.75 24.02 24 24.02h111.1c13.25 0 24-10.76 24-24.02S437.2 303.9 423.1 303.9zM487.1 175.8H312c-13.25 0-24 10.76-24 24.02s10.75 24.02 24 24.02h175.1c13.25 0 24-10.76 24-24.02S501.2 175.8 487.1 175.8zM145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.94C20.35 181.7 26.19 183.8 32 183.8c6.469 0 12.91-2.594 17.62-7.719L104 117.1v338.9C104 469.2 114.8 480 128 480S152 469.2 152 455.1V117.1l54.37 58.95C215.3 185.8 230.5 186.5 240.3 177.4C250 168.4 250.6 153.2 241.6 143.4L145.6 39.37z"],
    "arrow-up-z-a": [512, 512, ["sort-alpha-up-alt"], "f882", "M327.1 80h62.94L309.1 185.2c-5.623 7.25-6.654 17.06-2.625 25.28c4.031 8.25 12.41 13.47 21.56 13.47h111.1c13.25 0 23.1-10.75 23.1-24s-10.75-24-23.1-24H377.1l81.87-105.2c5.625-7.25 6.656-17.06 2.625-25.28C457.5 37.22 449.1 32 439.1 32h-111.1c-13.25 0-23.1 10.75-23.1 24S314.7 80 327.1 80zM477.5 445.3l-71.1-143.1c-8.123-16.31-34.81-16.31-42.94 0l-71.1 143.1c-5.938 11.84-1.125 26.25 10.75 32.19c11.9 5.938 26.25 1.156 32.19-10.75l5.359-10.72h90.34l5.359 10.72c4.219 8.438 12.69 13.28 21.5 13.28c3.594 0 7.25-.8125 10.69-2.531C478.6 471.5 483.4 457.1 477.5 445.3zM362.8 407.1l21.17-42.34l21.17 42.34H362.8zM145.6 39.37c-9.062-9.82-26.19-9.82-35.25 0L14.38 143.4c-9 9.758-8.406 24.96 1.344 33.94C20.35 181.7 26.19 183.8 32 183.8c6.469 0 12.91-2.594 17.62-7.719L104 117.1v338.9C104 469.2 114.8 480 128 480S152 469.2 152 455.1V117.1l54.37 58.95C215.3 185.8 230.5 186.5 240.3 177.4C250 168.4 250.6 153.2 241.6 143.4L145.6 39.37z"],
    "arrows-cross": [448, 512, [], "e0a2", "M424 32h-143.1C266.8 32 256 42.75 256 56s10.75 24 24 24h86.06L7.031 439c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L400 113.9V200C400 213.3 410.8 224 424 224S448 213.2 448 199.1V56C448 42.84 437.2 32 424 32zM167.4 233.4l33.94-33.94L40.97 39.03c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L167.4 233.4zM424 288c-13.25 0-24 10.75-24 24v86.06l-119.4-119.4l-33.94 33.94L366.1 432H280c-13.25 0-24 10.75-24 24S266.8 480 280 480H424c13.16 0 24-10.81 24-24V312C448 298.8 437.3 288 424 288z"],
    "arrows-from-dotted-line": [448, 512, [], "e0a3", "M224 223.1c-17.67 0-32 14.33-32 32S206.3 287.1 224 287.1s32-14.33 32-32S241.7 223.1 224 223.1zM32 223.1c-17.67 0-32 14.33-32 32S14.33 287.1 32 287.1s32-14.33 32-32S49.67 223.1 32 223.1zM152 119.1c6.141 0 12.28-2.344 16.97-7.031L200 81.91v86.07c0 13.25 10.75 24 24 24s24-10.75 24-24V81.91l31.03 31.03C283.7 117.6 289.8 119.1 296 119.1c18.79 0 24-17.2 24-23.1c0-6.141-2.344-12.28-7.031-16.97l-72-72.01C234.9 .9766 227.7 0 223.1 0c-3.682 0-10.94 .9687-16.97 7l-72 72.01C130.3 83.7 128 89.84 128 95.98C128 109.7 139.2 119.1 152 119.1zM416 223.1c-17.67 0-32 14.33-32 32S398.3 287.1 416 287.1s32-14.33 32-32S433.7 223.1 416 223.1zM320 223.1c-17.67 0-32 14.33-32 32S302.3 287.1 320 287.1s32-14.33 32-32S337.7 223.1 320 223.1zM160 255.1c0-17.67-14.33-32-32-32S96 238.3 96 255.1S110.3 287.1 128 287.1S160 273.7 160 255.1zM296 391.1c-6.141 0-12.28 2.344-16.97 7.031L248 430.1v-86.06c0-13.25-10.75-24-24-24s-24 10.75-24 24v86.06l-31.03-31.03C164.3 394.3 158.1 391.1 152 391.1c-12.82 0-24 10.33-24 24c0 6.141 2.344 12.28 7.031 16.97l72 72.01C209.6 507.5 215.5 512 224 512s14.4-4.461 16.97-7.031l72-72.01C317.7 428.3 320 422.1 320 415.1C320 402.3 308.8 391.1 296 391.1z"],
    "arrows-from-line": [448, 512, [], "e0a4", "M296 391.1c-6.141 0-12.28 2.344-16.97 7.031L248 430.1v-86.06c0-13.25-10.75-24-24-24s-24 10.75-24 24v86.06l-31.03-31.03C164.3 394.3 158.1 391.1 152 391.1c-12.82 0-24 10.33-24 24c0 6.141 2.344 12.28 7.031 16.97l72 72.01C209.6 507.5 215.5 512 224 512s14.4-4.461 16.97-7.031l72-72.01C317.7 428.3 320 422.1 320 415.1C320 402.3 308.8 391.1 296 391.1zM152 119.1c6.141 0 12.28-2.344 16.97-7.031L200 81.91v86.07c0 13.25 10.75 24 24 24s24-10.75 24-24V81.91l31.03 31.03C283.7 117.6 289.8 119.1 296 119.1c18.79 0 24-17.2 24-23.1c0-6.141-2.344-12.28-7.031-16.97l-72-72.01C234.9 .9766 227.7 0 223.1 0C220.3 0 213.1 .9687 207 7l-72 72.01C130.3 83.7 128 89.84 128 95.98C128 109.7 139.2 119.1 152 119.1zM424 232H24C10.75 232 0 242.7 0 255.1S10.75 280 24 280h400c13.25 0 24-10.76 24-24.01S437.3 232 424 232z"],
    "arrows-left-right": [512, 512, ["arrows-h"], "f07e", "M512 256c0 6.688-2.812 13.09-7.719 17.62l-104 96C395.7 373.9 389.8 376 384 376c-6.469 0-12.91-2.594-17.62-7.719c-9-9.75-8.406-24.94 1.344-33.91L426.6 280H85.38l58.91 54.38c9.75 8.969 10.34 24.16 1.344 33.91C140.9 373.4 134.5 376 128 376c-5.812 0-11.66-2.094-16.28-6.375l-104-96C2.813 269.1 0 262.7 0 256s2.812-13.09 7.719-17.62l104-96C121.5 133.3 136.7 134 145.6 143.7c9 9.75 8.406 24.94-1.344 33.91L85.38 232h341.3l-58.91-54.38c-9.75-8.969-10.34-24.16-1.344-33.91C375.3 134 390.5 133.3 400.3 142.4l104 96C509.2 242.9 512 249.3 512 256z"],
    "arrows-maximize": [448, 512, ["expand-arrows"], "f31d", "M400 200V113.9L257.9 256L400 398.1V312C400 298.8 410.8 288 424 288S448 298.8 448 312v144c0 3.125-.6387 6.238-1.854 9.172c-2.432 5.863-7.104 10.54-12.96 12.97C430.2 479.4 427.1 480 424 480h-144C266.8 480 256 469.3 256 456s10.75-24 24-24h86.06L224 289.9L81.94 432H168C181.3 432 192 442.8 192 456S181.3 480 168 480h-144c-3.125 0-6.238-.6406-9.172-1.852c-5.863-2.434-10.54-7.105-12.97-12.97C.6406 462.3 0 459.1 0 456v-144C0 298.8 10.75 288 24 288S48 298.8 48 312v86.06L190.1 256L48 113.9V200C48 213.3 37.25 224 24 224S0 213.3 0 200v-144c0-3.125 .6387-6.238 1.854-9.172c2.432-5.863 7.104-10.54 12.96-12.97C17.75 32.64 20.87 32 24 32h144C181.3 32 192 42.75 192 56S181.3 80 168 80H81.94L224 222.1L366.1 80H280C266.8 80 256 69.25 256 56S266.8 32 280 32h144c3.125 0 6.238 .6406 9.172 1.852c5.863 2.434 10.54 7.105 12.97 12.97C447.4 49.75 448 52.87 448 56v144C448 213.3 437.3 224 424 224S400 213.3 400 200z"],
    "arrows-minimize": [512, 512, ["compress-arrows"], "e0a5", "M200 32C186.8 32 176 42.75 176 56v86.06L56.97 23.03c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L142.1 176H56C42.75 176 32 186.8 32 200s10.8 24.06 24.05 24.06L200 224c3.135 0 6.248-.6406 9.182-1.855c5.861-2.434 10.53-7.109 12.96-12.97C223.4 206.2 224 203.1 224 200l.0549-143.9C224.1 42.81 213.3 32 200 32zM302.8 222.1C305.8 223.4 308.9 224 312 224l143.9 .0576C469.2 224.1 480 213.3 480 200S469.3 176 456 176h-86.06l119-119c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L336 142.1V56C336 42.75 325.3 32 312 32s-24.05 10.81-24.05 24.06L288 200c0 3.133 .6406 6.25 1.855 9.18C292.3 215 296.1 219.7 302.8 222.1zM369.9 336H456c13.25 0 24-10.75 24-24s-10.81-24.06-24.06-24.06L312 288c-3.135 0-6.248 .6406-9.182 1.855c-5.861 2.434-10.53 7.109-12.96 12.97C288.6 305.8 288 308.9 288 312l-.0567 143.9C287.9 469.2 298.8 480 312 480s24-10.75 24-24v-86.06l119 119c9.375 9.375 24.56 9.375 33.94 0s9.375-24.56 0-33.94L369.9 336zM209.2 289.9C206.2 288.6 203.1 288 200 288L56.06 287.9C42.81 287.9 32 298.8 32 312s10.75 24 24 24h86.06l-119 119c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L176 369.9V456C176 469.3 186.8 480 200 480s24.06-10.81 24.06-24.06L224 312c0-3.133-.6406-6.25-1.855-9.18C219.7 296.1 215 292.3 209.2 289.9z"],
    "arrows-repeat": [512, 512, ["repeat-alt"], "f364", "M488 232c-13.25 0-24 10.75-24 24c0 57.34-46.66 104-104 104H145.9l63.03-63.03c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0l-104 104c-9.375 9.375-9.375 24.56 0 33.94l104 104C179.7 509.7 185.8 512 192 512s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L145.9 408H360c83.81 0 152-68.19 152-152C512 242.7 501.3 232 488 232zM152 152h214.1l-63.03 63.03c-9.375 9.375-9.375 24.56 0 33.94C307.7 253.7 313.8 256 320 256s12.28-2.344 16.97-7.031l104-104c9.375-9.375 9.375-24.56 0-33.94l-104-104c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L366.1 104H152C68.19 104 0 172.2 0 255.1C0 269.2 10.75 280 24 280S48 269.3 48 256C48 198.7 94.66 152 152 152z"],
    "arrows-repeat-1": [512, 512, ["repeat-1-alt"], "f366", "M488 232c-13.25 0-24 10.75-24 24c0 57.34-46.66 104-104 104h-272c-13.33 0-23.99 10.88-23.99 24c0 3.649 .9775 10.93 7.021 16.97l104 104C179.7 509.7 185.8 512 191.1 512C210.8 512 216 494.8 216 488c0-6.141-2.344-12.28-7.031-16.97L145.9 408H360c83.81 0 152-68.19 152-152C512 242.7 501.3 232 488 232zM152 152h272c13.33 0 23.99-10.88 23.99-24c0-3.649-.9775-10.93-7.021-16.97l-104-104C332.3 2.344 326.1 0 320 0C306.3 0 296 11.21 296 24c0 6.141 2.344 12.28 7.031 16.97L366.1 104H152C68.19 104 0 172.2 0 255.1C0 269.2 10.75 280 24 280S48 269.3 48 256C48 198.7 94.66 152 152 152zM264 328c13.25 0 24-10.75 24-24V216c0-9.132-7.215-24.01-24.01-24.01c-3.67 0-7.335 .8282-10.71 2.539l-32 16C212.9 214.7 207.1 223.2 207.1 232c0 12.52 10.1 24.01 23.97 24.01c2.681 0 5.399-.4545 8.047-1.403V304C240 317.3 250.8 328 264 328z"],
    "arrows-retweet": [640, 512, ["retweet-alt"], "f361", "M328 368h-176V145.9l63.03 63.03C219.7 213.7 225.8 216 232 216s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94l-104-104c-9.375-9.375-24.56-9.375-33.94 0l-104 104c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L104 145.9V392C104 405.3 114.8 416 128 416h200c13.25 0 24-10.75 24-24S341.3 368 328 368zM632.1 303c-9.375-9.375-24.56-9.375-33.94 0L536 366.1V120C536 106.8 525.3 96 512 96H312C298.8 96 288 106.8 288 120S298.8 144 312 144h176v222.1l-63.03-63.03C420.3 298.3 414.2 296 408 296s-12.28 2.344-16.97 7.031c-9.375 9.375-9.375 24.56 0 33.94l104 104c9.375 9.375 24.56 9.375 33.94 0l104-104C642.3 327.6 642.3 312.4 632.1 303z"],
    "arrows-rotate": [512, 512, [61473, "refresh", "sync"], "1f5d8", "M454.7 288.1c-12.78-3.75-26.06 3.594-29.75 16.31C403.3 379.9 333.8 432 255.1 432c-66.53 0-126.8-38.28-156.5-96h100.4c13.25 0 24-10.75 24-24S213.2 288 199.9 288h-160c-13.25 0-24 10.75-24 24v160c0 13.25 10.75 24 24 24s24-10.75 24-24v-102.1C103.7 436.4 176.1 480 255.1 480c99 0 187.4-66.31 215.1-161.3C474.8 305.1 467.4 292.7 454.7 288.1zM472 16C458.8 16 448 26.75 448 40v102.1C408.3 75.55 335.8 32 256 32C157 32 68.53 98.31 40.91 193.3C37.19 206 44.5 219.3 57.22 223c12.84 3.781 26.09-3.625 29.75-16.31C108.7 132.1 178.2 80 256 80c66.53 0 126.8 38.28 156.5 96H312C298.8 176 288 186.8 288 200S298.8 224 312 224h160c13.25 0 24-10.75 24-24v-160C496 26.75 485.3 16 472 16z"],
    "arrows-to-dotted-line": [448, 512, [], "e0a6", "M32 224C14.33 224 0 238.3 0 256s14.33 32 32 32s32-14.33 32-32S49.67 224 32 224zM192 256c0 17.67 14.33 32 32 32s32-14.33 32-32s-14.33-32-32-32S192 238.3 192 256zM207 184.1C209.6 187.5 215.5 192 224 192s14.4-4.461 16.97-7.031l72-72C317.7 108.3 320 102.1 320 96c0-13.71-11.21-24-24-24c-6.141 0-12.28 2.344-16.97 7.031L248 110.1V24C248 10.75 237.3 0 224 0S200 10.75 200 24v86.06L168.1 79.03C164.3 74.34 158.1 72 152 72C138.3 72 128 83.21 128 96c0 6.141 2.344 12.28 7.031 16.97L207 184.1zM320 224c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S337.7 224 320 224zM416 224c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S433.7 224 416 224zM240.1 327C234.9 321 227.7 320 224 320c-3.682 0-10.94 .9902-16.97 7.021l-72 72C130.3 403.7 128 409.9 128 416c0 13.71 11.21 24 24 24c6.141 0 12.28-2.344 16.97-7.031L200 401.9V488C200 501.3 210.8 512 224 512s24-10.75 24-24v-86.06l31.03 31.03C283.7 437.7 289.8 440 296 440c18.79 0 24-17.2 24-24c0-6.141-2.344-12.28-7.031-16.97L240.1 327zM160 256c0-17.67-14.33-32-32-32S96 238.3 96 256s14.33 32 32 32S160 273.7 160 256z"],
    "arrows-to-line": [448, 512, [], "e0a7", "M207 184.1C209.6 187.5 215.5 192 224 192s14.4-4.461 16.97-7.031l72-72C317.7 108.3 320 102.1 320 96c0-13.71-11.21-24-24-24c-6.141 0-12.28 2.344-16.97 7.031L248 110.1V24C248 10.75 237.3 0 224 0S200 10.75 200 24v86.06L168.1 79.03C164.3 74.34 158.1 72 152 72C138.3 72 128 83.21 128 96c0 6.141 2.344 12.28 7.031 16.97L207 184.1zM240.1 327C234.9 321 227.7 320 224 320c-3.682 0-10.94 .9906-16.97 7.022l-72 72C130.3 403.7 128 409.9 128 416c0 13.71 11.21 24 24 24c6.141 0 12.28-2.344 16.97-7.031L200 401.9V488C200 501.3 210.8 512 224 512s24-10.75 24-24v-86.06l31.03 31.03C283.7 437.7 289.8 440 296 440c18.79 0 24-17.2 24-24c0-6.141-2.344-12.28-7.031-16.97L240.1 327zM424 232H24C10.75 232 0 242.7 0 255.1S10.75 280 24 280h400c13.25 0 24-10.76 24-24.01S437.3 232 424 232z"],
    "arrows-up-down": [256, 512, ["arrows-v"], "f07d", "M127.1 511.1c-6.688 0-13.09-2.812-17.62-7.719l-96-104c-4.281-4.625-6.375-10.47-6.375-16.28c0-6.469 2.594-12.91 7.719-17.62c9.75-9 24.94-8.406 33.91 1.344l54.38 58.91V85.37L49.62 144.3C40.65 154 25.47 154.6 15.72 145.6C10.59 140.9 7.998 134.5 7.998 127.1c0-5.812 2.094-11.66 6.375-16.28l96-104c4.531-4.906 10.94-7.719 17.62-7.719s13.09 2.812 17.62 7.719l96 104c9.031 9.781 8.375 24.97-1.344 33.91c-9.75 9-24.94 8.406-33.91-1.344l-54.38-58.91v341.3l54.38-58.91c8.969-9.75 24.16-10.34 33.91-1.344c9.719 8.969 10.38 24.12 1.344 33.91l-96 104C141.1 509.2 134.7 511.1 127.1 511.1z"],
    "arrows-up-down-left-right": [512, 512, ["arrows"], "f047", "M512 255.1c0 6.755-2.844 13.09-7.844 17.62l-88 80.05C411.5 357.8 405.8 359.9 400 359.9c-13.27 0-24-10.76-24-24c0-6.534 2.647-13.04 7.844-17.78l42.07-38.28H280v146l38.25-42.1c4.715-5.2 11.21-7.849 17.74-7.849c13.23 0 24.01 10.71 24.01 24.03c0 5.765-2.061 11.55-6.25 16.15l-80 88.06C269.2 509.2 262.8 512 256 512s-13.22-2.846-17.75-7.849l-80-88.06c-4.189-4.603-6.25-10.39-6.25-16.15c0-13.38 10.83-24.03 23.1-24.03c6.526 0 13.02 2.649 17.75 7.849L232 425.9V279.8H86.09l42.07 38.28c5.196 4.735 7.844 11.24 7.844 17.78c0 13.22-10.71 24-24 24c-5.781 0-11.53-2.064-16.16-6.254l-88-80.05C2.844 269.1 0 262.7 0 255.1c0-6.755 2.844-13.37 7.844-17.9l88-80.05C100.5 153.8 106.2 151.8 112 151.8c13.26 0 23.99 10.74 23.99 23.99c0 6.534-2.647 13.04-7.844 17.78L86.09 231.8H232V85.8L193.8 127.9C189 133.1 182.5 135.7 175.1 135.7c-13.16 0-23.1-10.66-23.1-24.03c0-5.765 2.061-11.55 6.25-16.15l80-88.06C242.8 2.502 249.4 0 256 0s13.22 2.502 17.75 7.505l80 88.06c4.189 4.603 6.25 10.39 6.25 16.15c0 13.35-10.81 24.03-24 24.03c-6.531 0-13.03-2.658-17.75-7.849L280 85.8v146h145.9l-42.07-38.28c-5.196-4.735-7.844-11.24-7.844-17.78c0-13.25 10.74-23.99 23.98-23.99c5.759 0 11.55 2.061 16.18 6.242l88 80.05C509.2 242.6 512 249.2 512 255.1z"],
    "asterisk": [448, 512, [10033, 61545], "2a", "M417.1 368c-4.437 7.688-12.5 12-20.81 12c-4.062 0-8.188-1.031-11.97-3.219L248 297.6V456c0 13.25-10.75 24-23.1 24S200 469.3 200 456V297.6l-137.2 79.22C59 378.1 54.88 380 50.81 380c-8.312 0-16.37-4.312-20.81-12c-6.625-11.47-2.687-26.16 8.781-32.78L176 256l-137.2-79.22C27.31 170.2 23.38 155.5 29.1 144C36.59 132.6 51.28 128.5 62.78 135.2L200 214.4V56C200 42.75 210.8 32 224 32S248 42.75 248 56v158.4l137.2-79.22C396.8 128.5 411.4 132.6 417.1 144c6.625 11.47 2.688 26.16-8.781 32.78L271.1 256l137.2 79.22C420.7 341.8 424.6 356.5 417.1 368z"],
    "at": [512, 512, [129664, 61946], "40", "M263.4 16.12C198.2 14.06 136.2 38.14 89.31 83.67C42.03 129.5 16 191.2 16 257.2c0 118.6 87.89 221.1 204.5 238.5C221.7 495.9 222.8 496 224 496c11.69 0 21.92-8.547 23.7-20.45c1.953-13.11-7.078-25.33-20.19-27.28C134.3 434.3 64 352.2 64 257.2c0-52.94 20.86-102.3 58.73-139.1c37.53-36.41 86.25-55.83 139.2-54.03C364.5 67.2 448 157.9 448 266.3v19.05c0 24.45-19.73 44.36-44 44.36S360 309.8 360 285.3V168.7c0-13.25-10.75-23.1-24-23.1c-11.92 0-21.38 8.855-23.24 20.25C294.4 151.9 272.2 144 248 144c-61.75 0-112 50.25-112 111.1s50.25 111.1 112 111.1c30.75 0 58.62-12.48 78.88-32.62c16.41 25.4 44.77 42.32 77.12 42.32c50.73 0 92-41.44 92-92.36V266.3C496 132.2 391.6 19.1 263.4 16.12zM248 320c-35.3 0-64-28.7-64-63.1c0-35.29 28.7-63.1 64-63.1s64 28.7 64 63.1C312 291.3 283.3 320 248 320z"],
    "atom": [512, 512, [62930], "269b", "M256 224C238.3 224 223.1 238.4 223.1 256S238.3 288 256 288c17.62 0 32-14.38 32-32C287.9 238.4 273.6 224 256 224zM471.2 128c-15.62-27.75-49.62-41.38-93.11-41.38c-9.499 .125-18.87 .75-28.25 2C327.1 34.38 293.5 0 256 0S184.9 34.38 162.1 88.62c-9.374-1.25-18.75-1.875-28.25-2C90.39 86.62 56.4 100.2 40.78 128c-18.75 33.5-6.499 80.62 27.62 128c-34.12 47.38-46.37 94.5-27.62 128c15.62 27.75 49.62 41.38 93.11 41.38c9.499-.125 18.87-.75 28.25-2C184.9 477.6 218.5 512 256 512s71.12-34.38 93.86-88.63c9.374 1.25 18.75 1.875 28.25 2c43.49 0 77.49-13.62 93.11-41.38c18.75-33.5 6.499-80.63-27.62-128C477.7 208.6 489.1 161.5 471.2 128zM256 48c14.37 0 32.12 18.12 47.12 50C287.1 102.4 271.4 107.8 256 114.1c-15.37-6.375-31.12-11.76-47.12-16.14C223.9 66.12 241.6 48 256 48zM133.9 377.4c-26.5 0-46.74-6.625-52.74-17.38c-7.124-12.75-.5-37.63 18.62-66.63C111.4 305.2 123.8 316.5 136.8 327c2.25 16.5 5.374 33 9.624 49.13C142.3 376.4 137.9 377.4 133.9 377.4zM136.8 185C123.8 195.5 111.4 206.8 99.77 218.6C80.65 189.6 74.02 164.8 81.15 152c5.999-10.75 26.25-17.38 52.74-17.38c3.1 0 8.374 1 12.5 1.25C142.1 152 139 168.5 136.8 185zM256 464c-14.37 0-32.12-18.12-47.12-49.1C224.9 409.6 240.6 404.2 256 397.9c15.37 6.375 31.12 11.76 47.12 16.14C288.1 445.9 270.4 464 256 464zM256 352c-52.99 0-95.99-43-95.99-96S203 160 256 160s95.99 43 95.99 96S308.1 352 256 352zM430.9 360c-5.999 10.75-26.25 17.38-52.74 17.38c-3.1 0-8.374-1-12.5-1.25C369.9 360 372.1 343.5 375.2 327c12.1-10.5 25.37-21.75 36.1-33.63C431.4 322.4 437.1 347.2 430.9 360zM412.2 218.6C400.6 206.8 388.2 195.5 375.2 185C372.1 168.5 369.9 152 365.6 135.9c4.125-.25 8.499-1.25 12.5-1.25c26.5 0 46.74 6.625 52.74 17.38C437.1 164.8 431.4 189.6 412.2 218.6z"],
    "atom-simple": [448, 512, ["atom-alt"], "f5d3", "M397.9 255.9c53.63 83.37 66.75 161.2 27.13 200.7c-61.13 60.1-182.8-15.25-201-26.1c-18.12 11.62-140 87.99-201 26.1c-39.5-39.5-26.5-117.4 27.12-200.7C-3.52 172.4-16.52 94.66 22.98 55.03c39.63-39.5 117.5-26.5 201 27.12c83.5-53.62 161.4-66.75 201-27.12S451.5 172.4 397.9 255.9zM80.73 213.3c29.5-37.25 63.37-70.99 100.7-100.6C139.6 88.66 79.36 66.78 56.98 89.03C40.23 105.8 46.36 153.7 80.73 213.3zM181.5 398.9c-37.38-29.37-71.25-63.12-100.7-100.5c-34.38 59.62-40.5 107.6-23.75 124.2C73.73 439.4 121.7 433.3 181.5 398.9zM338.1 255.9c-32.5-43.1-71.25-82.87-115-115.4c-43.88 32.5-82.62 71.37-115 115.4c34 45.62 70 81.37 115 114.7C269.4 337 305.2 301.1 338.1 255.9zM255.1 255.1c0 17.62-14.25 32-32 32c-17.75 0-32-14.38-32-32c0-17.75 14.25-32.03 32-32.03C241.7 223.9 255.1 238.2 255.1 255.1zM367.2 298.4c-29.5 37.37-63.37 71.12-100.7 100.5c59.75 34.37 107.7 40.5 124.5 23.75C407.7 406 401.6 358 367.2 298.4zM266.5 112.7c37.38 29.5 71.25 63.37 100.7 100.6c34.38-59.62 40.5-107.5 23.75-124.2C368.7 66.78 308.6 88.53 266.5 112.7z"],
    "audio-description": [576, 512, [], "f29e", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V416zM213.5 173.3c-8.125-16.25-34.81-16.25-42.94 0l-72 144c-5.938 11.86-1.125 26.27 10.75 32.2c11.88 5.969 26.28 1.125 32.19-10.73L150.8 320H233.2l9.367 18.73C246.8 347.1 255.2 352 264 352c3.594 0 7.25-.8125 10.69-2.531c11.88-5.938 16.69-20.34 10.75-32.2L213.5 173.3zM170.8 280L192 237.7L213.2 280H170.8zM384 160h-56c-13.25 0-24 10.75-24 24v144c0 13.25 10.75 24 24 24H384c52.94 0 96-43.06 96-96S436.9 160 384 160zM384 304h-32v-96h32c26.47 0 48 21.53 48 48S410.5 304 384 304z"],
    "audio-description-slash": [640, 512, [], "e0a8", "M96 432c-8.822 0-16-7.178-16-16V159.4L32 121.8l0 294.2c0 35.35 28.65 64 64 64l393.1 .0002L427.8 432H96zM173 232.3L130.5 317.3c-5.937 11.86-1.125 26.27 10.75 32.2c11.88 5.969 26.28 1.125 32.19-10.73l9.367-18.73h82.33l9.367 18.73c4.219 8.406 12.69 13.27 21.5 13.27c3.594 0 7.25-.8125 10.69-2.531c3.125-1.562 5.686-3.76 7.766-6.295l-80.6-63.17H202.8l8.741-17.48L173 232.3zM630.8 469.1l-30.73-24.09c4.623-8.785 7.922-18.37 7.922-29.02L608 96c0-35.35-28.65-64-64-64L96 32c-6.646 0-12.96 1.176-18.96 3.073L38.81 5.111C28.34-3.061 13.32-1.249 5.121 9.189C-3.051 19.63-1.233 34.72 9.189 42.89l591.1 463.1C605.6 510.3 610.8 512 615.1 512c7.125 0 14.16-3.161 18.9-9.193C643.1 492.4 641.2 477.3 630.8 469.1zM419.7 303.6l-35.68-27.97V208h32c26.47 0 48 21.53 48 48C464 281.2 444.4 301.7 419.7 303.6zM560 413.6l-95.78-75.08c28.44-16.68 47.78-47.24 47.78-82.53c0-52.94-43.06-96-96-96h-56c-13.25 0-24 10.75-24 24v54.04L134.4 80H544c8.822 0 16 7.178 16 16V413.6z"],
    "austral-sign": [448, 512, [], "e0a9", "M424 319.5h-63.09l-20.16-48.14H424c13.25 0 24-10.78 24-24.07c0-13.29-10.75-24.07-24-24.07h-103.4l-74.46-177.8c-7.469-17.87-36.78-17.87-44.25 0L127.4 223.2H24c-13.25 0-24 10.78-24 24.07c0 13.29 10.75 24.07 24 24.07h83.25L87.09 319.5H24c-13.25 0-24 10.92-24 24.21s10.75 23.93 24 23.93h42.93l-33.05 78.94c-5.141 12.25 .6094 26.37 12.83 31.51c12.23 5.187 26.3-.6112 31.42-12.87l40.87-97.59h210l40.87 97.59c3.859 9.215 12.77 14.75 22.14 14.75c3.094 0 6.25-.5955 9.281-1.881c12.22-5.14 17.97-19.26 12.83-31.51l-33.05-78.94H424c13.25 0 24-10.64 24-23.93S437.3 319.5 424 319.5zM224 116.9l44.53 106.3h-89.05L224 116.9zM139.2 319.5l20.16-48.14h129.4l20.16 48.14H139.2z"],
    "avocado": [512, 512, [], "e0aa", "M512 142.3c0-72.05-56.44-142.3-140.5-142.3c-39.21 0-78.71 15.73-108.1 45.17C232.4 76.31 192.1 97.3 150.6 108.9C115.4 118.6 .0005 170.8 .0005 306.7c0 113.8 92.76 205.3 205.1 205.3c52.37 0 104.7-20.04 144.7-60.13c67.65-67.87 42.56-130 115.1-203.7l4.357-4.371C498 215.8 512 179.1 512 142.3zM463.1 142.3c0 25.29-10.03 49.74-27.9 67.67l-4.357 4.371C334.2 312.2 366.7 464 205.1 464c-68.51 0-157.1-55.16-157.1-157.3c0-73.22 50.04-133.6 115.3-151.5C295.8 118.9 291.1 48 371.5 48C429.8 48 463.1 97.93 463.1 142.3zM247 191.1c-60.51 0-119.1 58.66-119.1 119.3c0 28.31 17.39 72.66 72.49 72.66c60.51 0 119.1-58.66 119.1-119.3C319.5 236.3 302.1 191.1 247 191.1z"],
    "award": [384, 512, [], "f559", "M334.6 312c8.174-5.266 17.02-12.56 23.64-23.1c10.58-18.27 9.528-36.67 8.917-47.69c-.0234-.4102-.0508-.8184-.0781-1.229c.1602-.2363 .3184-.4746 .4766-.7129C373.7 229.1 383.1 213.5 383.1 192s-10.27-37.09-16.4-46.41c-.1543-.2363-.3105-.4707-.4668-.7031c.0273-.4082 .0547-.8145 .0762-1.223c.6133-11.01 1.663-29.42-8.907-47.68c-10.63-18.38-27.22-26.74-37.12-31.71c-.3145-.1582-.6309-.3125-.9453-.4687c-.1562-.3164-.3125-.6328-.4707-.9492c-4.971-9.898-13.32-26.49-31.71-37.13c-10.8-6.25-23.06-9.267-37.54-9.267c-3.32 0-6.729 .1641-10.14 .3535c-.4121 .0215-.8262 .0469-1.24 .0703c-.2363-.1582-.4727-.3164-.7109-.4727C229.1 10.27 213.5 0 192 0C170.5 0 154.9 10.27 145.6 16.4C145.4 16.56 145.1 16.71 144.9 16.87C144.5 16.84 144.1 16.82 143.7 16.79C140.2 16.61 136.8 16.44 133.5 16.44c-14.47 0-26.72 3.012-37.52 9.262C77.59 36.34 69.24 52.93 64.27 62.83c-.1582 .3145-.3125 .6289-.4668 .9434c-.3145 .1543-.6309 .3086-.9453 .4668C52.96 69.21 36.37 77.56 25.72 95.95C15.15 114.2 16.19 132.6 16.81 143.6c.0215 .4082 .0488 .8184 .0762 1.225C16.72 145.1 16.57 145.3 16.41 145.6C10.27 154.9 .0008 170.5 .0008 192c0 21.5 10.27 37.09 16.41 46.41C16.56 238.6 16.72 238.9 16.87 239.1C16.85 239.5 16.82 239.9 16.8 240.3C16.18 251.3 15.13 269.7 25.7 288c6.84 11.81 16.05 19.24 24.44 24.52l-48.42 120.7c-3.25 8.188-1.781 17.48 3.875 24.25c4.619 5.512 11.39 8.621 18.39 8.621c1.572 0 3.156-.1523 4.732-.4727l45.19-9.035l21.43 42.27C99.46 507 107.6 512 116.7 512c.3438 0 .6641-.0117 1.008-.0273c9.5-.375 17.65-6.082 21.24-14.88L184.6 384h15.65l44.8 113.1c3.594 8.797 11.74 14.5 21.24 14.88C266.6 511.1 266.1 512 267.3 512c9.094 0 17.23-4.973 21.35-13.14l21.43-42.28l45.19 9.035c1.576 .3203 3.16 .4727 4.732 .4727c7.008 0 13.77-3.109 18.39-8.621c5.656-6.766 7.125-16.06 3.875-24.25L334.6 312zM316.7 264c-6.07 10.49-22.54 13.14-31.05 21.66c-8.508 8.51-11.17 24.97-21.66 31.04c-3.916 2.266-8.58 2.832-13.51 2.832c-4.916 0-10.09-.5645-15.04-.5645c-3.188 0-6.283 .2344-9.156 1.002C214.9 323 204.4 336 192 336c-12.38 0-22.9-12.95-34.32-16.01C154.8 319.2 151.7 318.1 148.5 318.1c-4.945 0-10.11 .5605-15.02 .5605c-4.932 0-9.602-.5664-13.52-2.834C109.5 310.6 106.8 294.2 98.31 285.7C89.8 277.2 73.34 274.5 67.27 264C61.29 253.7 67.16 238.1 64.01 226.3C60.96 214.9 48 204.4 48 192c0-12.38 12.96-22.9 16.01-34.32c3.154-11.81-2.711-27.37 3.277-37.71C73.36 109.5 89.82 106.8 98.34 98.31c8.51-8.508 11.17-24.97 21.66-31.04c3.916-2.266 8.58-2.832 13.51-2.832c4.916 0 10.09 .5645 15.04 .5645c3.188 0 6.283-.2344 9.156-1.002C169.1 60.95 179.6 48 192 48c12.39 0 22.9 12.95 34.32 16.01c2.877 .7695 5.977 1.004 9.17 1.004c4.945 0 10.11-.5605 15.02-.5605c4.932 0 9.604 .5664 13.52 2.834c10.49 6.068 13.14 22.54 21.66 31.05c8.508 8.512 24.97 11.17 31.04 21.66c5.982 10.34 .1152 25.9 3.27 37.71C323.1 169.1 336 179.6 336 192c0 12.38-12.95 22.9-16.01 34.32C316.8 238.1 322.7 253.7 316.7 264zM192 128C156.7 128 128 156.6 128 192c0 35.33 28.65 64 64 64s64-28.67 64-64C256 156.6 227.3 128 192 128z"],
    "award-simple": [384, 512, [], "e0ab", "M384 192c0-21.5-10.27-37.09-16.4-46.41c-.1543-.2363-.3105-.4707-.4668-.7031c.0273-.4082 .0547-.8145 .0762-1.223c.6133-11.01 1.66-29.42-8.91-47.69c-10.63-18.38-27.22-26.73-37.12-31.71c-.3145-.1582-.6309-.3125-.9453-.4687c-.1562-.3164-.3125-.6328-.4707-.9492c-4.971-9.898-13.31-26.48-31.7-37.13c-10.8-6.25-23.07-9.271-37.54-9.271c-3.32 0-6.729 .1641-10.14 .3535c-.4121 .0215-.8262 .0469-1.24 .0703c-.2363-.1582-.4727-.3164-.7109-.4727C229.1 10.27 213.5 0 192 0C170.5 0 154.9 10.27 145.6 16.4C145.4 16.56 145.1 16.71 144.9 16.87C144.5 16.84 144.1 16.82 143.7 16.79C140.2 16.61 136.8 16.44 133.5 16.44c-14.47 0-26.72 3.016-37.52 9.266c-18.39 10.64-26.74 27.22-31.71 37.12c-.1582 .3145-.3125 .6289-.4668 .9434c-.3145 .1543-.6309 .3086-.9453 .4668C52.96 69.21 36.37 77.55 25.73 95.95C15.15 114.2 16.19 132.6 16.81 143.6c.0215 .4082 .0488 .8184 .0762 1.225C16.72 145.1 16.57 145.3 16.41 145.6C10.27 154.9 0 170.5 0 192c0 21.5 10.27 37.09 16.41 46.41C16.56 238.6 16.72 238.9 16.87 239.1C16.85 239.5 16.82 239.9 16.8 240.3C16.18 251.3 15.13 269.8 25.71 288c10.65 18.39 27.23 26.74 37.12 31.71c.3164 .1582 .6328 .3145 .9492 .4687c.1543 .3184 .3105 .6348 .4687 .9512c4.971 9.896 13.32 26.48 31.7 37.12c.8105 .4687 1.758 .5944 2.587 1.028l-27.79 133.4c-2.727 13.09 10.86 23.55 22.82 17.57L192 461.1l98.44 49.22c11.96 5.98 25.54-4.48 22.82-17.57l-27.79-133.4c.8145-.4277 1.756-.5534 2.555-1.016c18.4-10.64 26.74-27.23 31.72-37.13c.1562-.3125 .3105-.625 .4648-.9375c.3125-.1543 .627-.3086 .9414-.4668c9.898-4.973 26.49-13.32 37.13-31.71c10.58-18.27 9.531-36.68 8.92-47.69c-.0234-.4102-.0508-.8184-.0781-1.229c.1602-.2363 .3184-.4746 .4766-.7129C373.7 229.1 384 213.5 384 192zM319.1 226.3c-3.154 11.81 2.711 27.37-3.275 37.71c-6.07 10.49-22.54 13.14-31.05 21.66c-8.508 8.51-11.17 24.97-21.66 31.04c-3.916 2.266-8.58 2.832-13.51 2.832c-4.916 0-10.09-.5645-15.04-.5645c-3.188 0-6.283 .2344-9.156 1.002C214.9 323 204.4 336 192 336c-12.38 0-22.9-12.95-34.32-16.01C154.8 319.2 151.7 318.1 148.5 318.1c-4.945 0-10.11 .5605-15.02 .5605c-4.932 0-9.602-.5664-13.52-2.834C109.5 310.6 106.8 294.2 98.31 285.7C89.8 277.2 73.34 274.5 67.27 264C61.29 253.7 67.16 238.1 64.01 226.3C60.96 214.9 48 204.4 48 192c0-12.38 12.96-22.9 16.01-34.32c3.154-11.81-2.711-27.37 3.277-37.71C73.36 109.5 89.82 106.8 98.34 98.31c8.51-8.508 11.17-24.97 21.66-31.04c3.916-2.266 8.58-2.832 13.51-2.832c4.916 0 10.09 .5645 15.04 .5645c3.188 0 6.283-.2344 9.156-1.002C169.1 60.95 179.6 48 192 48c12.39 0 22.9 12.95 34.32 16.01c2.877 .7695 5.977 1.004 9.17 1.004c4.945 0 10.11-.5605 15.02-.5605c4.932 0 9.604 .5664 13.52 2.834c10.49 6.068 13.14 22.54 21.66 31.05c8.508 8.512 24.97 11.17 31.04 21.66c5.982 10.34 .1152 25.9 3.27 37.71C323.1 169.1 336 179.6 336 192C336 204.4 323 214.9 319.1 226.3zM192 128C156.7 128 128 156.6 128 192c0 35.33 28.65 64 64 64s64-28.67 64-64C256 156.6 227.3 128 192 128z"],
    "axe": [640, 512, [63154], "1fa93", "M9.373 434.7c-12.5 12.5-12.5 32.76 0 45.26l22.63 22.63C38.26 508.9 46.45 512 54.64 512s16.38-3.125 22.63-9.375l231.2-231.2L240.6 203.6L9.373 434.7zM525.7 160l-52.94-52.94l29.82-29.82c12.5-12.5 12.5-32.76-.0001-45.26l-22.62-22.62C473.8 3.124 465.6 0 457.4 0s-16.38 3.124-22.63 9.374l-29.82 29.82l-29.81-29.81c-6.25-6.25-14.44-9.375-22.63-9.375s-16.38 3.125-22.63 9.375L233.4 105.9C220.9 118.4 220.9 138.6 233.4 151.1l150.6 150.6L384 416l31.1-.0032C539.7 416 640 315.7 640 192V160L525.7 160zM432 367.3V281.9L278.6 128.5l73.87-73.85L505.9 208h85.41C583.7 292.3 516.3 359.6 432 367.3z"],
    "axe-battle": [512, 512, [], "f6b3", "M512 176.4c-3.75-68-31.25-128.9-73.5-171.6C435.3 1.5 431.4 0 427.6 0c-7.125 0-13.83 5.104-15.83 13.6C407 33.23 381.1 120 280 120v-64c0-13.26-10.75-23.1-24-23.1S232 42.74 232 56v64c-100 0-126.2-86.89-130.1-106.4C99.03 5.105 92.19 0 85.06 0C81.31 0 77.5 1.479 74.25 4.729C28.75 50.85 0 117.6 0 192s28.75 141.1 74.25 187.3C77.5 382.5 81.31 384 85.06 384c7.125 0 13.97-5.105 15.97-13.61C105.8 350.9 132 264 232 264v224C232 501.3 242.7 512 256 512s24-10.75 24-24v-224c101.1 0 127 86.77 131.8 106.4C413.8 378.9 420.5 384 427.6 384c3.75 0 7.625-1.5 10.88-4.75C480.8 336.5 508.3 275.6 512 207.6L496.8 192L512 176.4zM232 216c-70.75 0-123.3 33.88-155.1 87.5C58.25 270.6 48.13 232 48.13 192s10.12-78.63 28.75-111.5C108.6 133.9 161.1 168 232 168V216zM461.1 225.3C458.1 253.5 449.1 280 435.9 303.5C404.4 250.5 352.4 216 280 216v-48c71.13 0 123.8-33.38 155.9-87.5c13.25 23.5 22.25 50 26.12 78.25L429.5 192L461.1 225.3z"],
    "b": [320, 512, [98], "42", "M250.1 244.9C273.4 222.4 288 190.9 288 156C288 87.63 232.4 32 164 32H24C10.75 32 0 42.75 0 56v400C0 469.3 10.75 480 24 480h172C264.4 480 320 424.4 320 356C320 307.1 291.3 265.1 250.1 244.9zM48 80h116c41.91 0 76 34.09 76 76S205.9 232 164 232H48V80zM196 432H48V280h148c41.91 0 76 34.09 76 76S237.9 432 196 432z"],
    "baby": [448, 512, [], "f77c", "M359.7 216.2l42.8-30c14.5-10.1 18-30.1 7.799-44.6c-10.1-14.5-30.1-18-44.6-7.801l-42.8 30C264 205.1 184 205.1 125.1 163.8l-42.8-30c-14.5-10.2-34.5-6.6-44.6 7.801C27.5 156.1 31 176 45.5 186.2l42.8 30c17.4 12.2 36.2 21.4 55.6 28.5v86.26L95.1 396c-9.102 11.4-9.301 27.5-.6016 39.2l48 64C148.8 507.6 158.4 512 168.1 512c6.701 0 13.4-2.1 19.2-6.4c14.2-10.6 17-30.7 6.4-44.8l-33.1-44.2l18.3-22.9c11.3 9 25.2 14.2 39.8 14.2h10.1c14.6 0 28.5-5.201 39.8-14.2l18.3 22.9l-33.1 44.2c-10.6 14.1-7.799 34.2 6.4 44.8C266.9 509.9 273.6 512 280.3 512c9.799 0 19.3-4.4 25.6-12.8l48-64c8.799-11.7 8.5-27.8-.6016-39.2l-48.1-65.25V244.7C323.6 237.6 342.3 228.4 359.7 216.2zM272.1 333l-29.06 29.08C239.2 365.9 234.2 368 228.9 368H219.3c-5.359 0-10.36-2.078-14.11-5.875l-29.08-29.08V312h96V333zM224 159.1c44.2 0 79.99-35.8 79.99-79.1C303.1 35.8 268.2 0 224 0C179.8 0 144 35.8 144 79.1C144 124.2 179.8 159.1 224 159.1z"],
    "baby-carriage": [512, 512, ["carriage-baby"], "f77d", "M488 95.94h-32c-30.93 0-56 25.08-56 56.01v40.01h-106.8L189.1 28.18C179.9 13.68 164.8 3.68 147.2 .8044C130.1-1.946 112.9 2.43 99.75 12.81C41.12 59.69-.25 138.7 0 215.1c.25 50.13 17.62 99.52 60.25 138.8c-39.24 10.1-67.16 48.98-58.75 92.92c5.961 31.12 30.86 56.49 61.93 62.69C114.1 520.6 160 481.7 160 431.1c0-8.876-1.75-17.25-4.375-25.25C177.2 412.7 200.3 415.1 224 415.1s46.88-3.256 68.38-9.257c-5.806 17.7-7.332 37.23 4.895 59.95c14.37 26.71 41.59 45.74 71.91 45.3C412.9 511.4 448 475.9 448 431.1c0-37.26-25.75-68.38-60.25-77.26C425 320.4 448 274.6 448 223.1V151.1c0-4.401 3.6-8.023 8-8.023h32c13.2 0 24-10.78 24-23.98S501.2 95.94 488 95.94zM80 463.1c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S97.62 463.1 80 463.1zM400 431.1c0 17.63-14.38 32-32 32s-32-14.38-32-32s14.38-32 32-32S400 414.4 400 431.1zM224 367.1c-90.38 0-165.2-56.13-174.9-128h349.8C389.2 311.8 314.4 367.1 224 367.1z"],
    "backpack": [448, 512, [62932], "1f392", "M320 80h-8V56C312 25.12 286.9 0 256 0H192C161.1 0 136 25.12 136 56V80H128c-70.75 0-128 57.25-128 128V448c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V208C448 137.2 390.8 80 320 80zM184 56C184 51.62 187.6 48 192 48h64c4.375 0 8 3.625 8 8V80h-80V56zM320 464H128v-64h192V464zM320 352H128v-32c0-17.62 14.38-32 32-32h128c17.62 0 32 14.38 32 32V352zM400 448c0 8.875-7.125 16-16 16h-16V320c0-44.13-35.88-80-80-80H160c-44.12 0-80 35.88-80 80v144H64c-8.875 0-16-7.125-16-16V208C48 163.9 83.88 128 128 128h192c44.13 0 80 35.88 80 80V448zM304 160H143.1C135.1 160 128 167.1 128 175.1V192c0 8.875 7.125 16 16 16h160C312.9 208 320 200.9 320 192V176C320 167.1 312.9 160 304 160z"],
    "backward": [512, 512, [61514], "23ea", "M223.8 64c-7.002 0-14.15 2.305-20.29 7.406L11.44 231.4c-15.25 12.87-15.25 36.37 0 49.24l192 159.1C209.6 445.7 216.8 448 223.8 448c16.5 0 32.22-12.81 32.22-32.03v-319.9C255.1 76.81 240.3 64 223.8 64zM207.1 381.9L56.88 256l151.1-125.9V381.9zM495.4 67.95c-10.25-5.625-22.69-5.172-32.53 1.062l-163.7 104.2c-11.19 7.109-14.5 21.95-7.375 33.14c7.094 11.19 21.94 14.48 33.13 7.359L464 125.2v261.7l-139.1-88.52c-11.19-7.125-26.03-3.828-33.13 7.359c-7.125 11.19-3.812 26.03 7.375 33.14l163.7 104.2c5.219 3.344 11.11 5.023 17.08 5.023c5.281 0 10.7-1.32 15.48-3.945C505.6 438.4 512 427.7 512 415.1V96.03C512 84.34 505.6 73.58 495.4 67.95z"],
    "backward-fast": [512, 512, [61513, "fast-backward"], "23ee", "M479.8 64c-7 0-14.14 2.307-20.29 7.406L288 227.9V96.03C288 76.81 272.3 64 255.8 64c-7 0-14.14 2.307-20.29 7.406L64 227.9V88.03c0-13.25-10.74-24-24-24c-13.25 0-24 10.74-24 23.1v335.9c0 13.26 10.75 24 24 24c13.26 0 24-10.74 24-24V285.2l171.5 155.3C241.6 445.7 248.8 448 255.8 448C272.3 448 288 435.2 288 415.1V285.2l171.5 155.3C465.6 445.7 472.8 448 479.8 448C496.3 448 512 435.2 512 415.1V96.03C512 76.81 496.3 64 479.8 64zM240 379.9L103.8 256.5L240 132.3V379.9zM464 379.9l-136.2-123.4L464 132.3V379.9z"],
    "backward-step": [320, 512, ["step-backward"], "f048", "M32 88v336C32 437.3 42.75 448 56 448s24-10.75 24-24V318.2l173.4 123.9C258.9 446 265.4 448 272 448c5 0 10.03-1.156 14.66-3.531c10.66-5.5 17.34-16.48 17.34-28.48V96.01c0-12-6.687-22.98-17.34-28.48c-4.619-2.357-9.648-3.529-14.66-3.529c-6.549 .002-13.07 2.002-18.59 5.967L80 193.8V88C80 74.75 69.25 64 56 64S32 74.75 32 88zM80 252.8L256 127.1v257.8L80 259.2V252.8z"],
    "bacon": [576, 512, [63461], "1f953", "M564.7 99.68l-77.83-86.8C479.4 4.459 469 0 458.5 0c-5.193 0-10.42 1.1-15.34 3.36l-92.75 42.99c-51.13 23.69-93.34 64.03-122.1 116.6L207.7 200.7c-27.11 49.56-66.8 87.5-114.8 109.8l-68.88 31.94c-11.86 5.486-20.28 16.52-23.09 30.23c-2.938 14.35 .9062 29.18 10.31 39.65l77.83 86.8C96.64 507.5 106.1 512 117.5 512c5.188 0 10.41-1.11 15.33-3.375l92.75-42.99c51.13-23.69 93.34-64.03 122.1-116.6l20.66-37.76c27.11-49.56 66.8-87.5 114.8-109.8l68.88-31.94c11.86-5.484 20.28-16.52 23.09-30.23C577.1 124.1 574.1 110.1 564.7 99.68zM113.1 354c57.34-26.61 104.6-71.65 136.7-130.3l20.66-37.76c23.81-43.53 58.46-76.77 100.2-96.1l85.36-39.57l22.27 24.84L408.2 107.6C355.6 132 312.1 173.5 282.5 227.6L261.9 265.4c-26.28 48.05-64.7 84.81-111.2 106.3l-78.69 36.46l-22.21-24.77L113.1 354zM462.9 157.1c-57.34 26.61-104.6 71.65-136.7 130.3l-20.66 37.76c-23.81 43.54-58.46 76.77-100.2 96.11l-85.36 39.57l-25.62-28.57l69.81-32.35c52.7-24.42 96.19-65.92 125.8-120l20.66-37.75c26.28-48.03 64.7-84.8 111.1-106.3l78.9-36.59l25.56 28.5L462.9 157.1z"],
    "bacteria": [640, 512, [], "e059", "M191.1 128c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16c8.836 0 16-7.164 16-16C207.1 135.2 200.8 128 191.1 128zM111.1 224c-8.836 0-15.1 7.163-15.1 15.1S103.2 256 111.1 256c8.838 0 16-7.164 16-16S120.8 224 111.1 224zM399.1 384c-8.836 0-15.1 7.163-15.1 15.1s7.162 16 15.1 16c8.838 0 16-7.164 16-16S408.8 384 399.1 384zM613.8 231.3l13.46-3.98c9.439-2.781 14.81-12.65 12-22.04c-3.039-10.21-13.57-14.52-22.14-11.95l-13.59 4.02c-7.914-14.22-19.88-25.9-34.76-33.47l3.58-13.71c2.469-9.477-3.248-19.15-12.77-21.62c-10.36-2.639-19.46 4.046-21.72 12.71l-3.517 13.47c-2.512-.1016-23.41-2.252-46.96 12.3L477.6 157.1c-3.777-3.873-15.44-9.781-25.19-.3691c-7.063 6.822-7.225 18.04-.3711 25.07l9.821 10.07c-6.217 9.375-10.83 19.99-12.8 31.79c-.8184 4.883-2.369 9.469-3.76 14.13L436.2 233.5C427.4 229.4 416.8 233.1 412.6 242c-4.186 8.854-.3599 19.42 8.546 23.58l9.27 4.336c-9.199 13.67-21.15 25.2-35.11 34.03l-4.11-9.279c-3.922-8.822-14.33-13.05-23.49-9.074c-9 3.959-13.08 14.42-9.115 23.39l4.041 9.127c-3.791 1.021-7.46 2.33-11.39 2.982c-12.86 2.131-24.33 7.33-34.29 14.38l-10.47-9.436C299.5 319.7 288.1 319.7 281.3 327.3c-6.611 7.262-6.055 18.47 1.24 25.04l10.51 9.479c-8.004 13.9-11.92 30.04-10.67 46.93l-13.63 4.035c-9.428 2.793-14.8 12.66-11.99 22.05c2.783 9.385 12.69 14.71 22.15 11.94l13.57-4.019c8.117 14.52 20.26 26.11 34.85 33.52l-3.549 13.56c-2.48 9.479 3.224 19.16 12.75 21.62c9.566 2.482 19.25-3.221 21.72-12.69l3.484-13.31c7.436 .2715 19.21-.0664 48.59-8.465l3.97 11.11c3.305 9.223 13.5 14.11 22.75 10.76c9.266-3.277 14.1-13.41 10.81-22.65l-3.908-10.94c15.31-6.527 29.83-14.45 43.61-23.41l7.063 9.42c5.891 7.838 17.05 9.443 24.93 3.602c7.885-5.863 9.496-16.97 3.617-24.82l-6.992-9.324c12.62-10.66 24.22-22.44 34.81-35.12l9.504 6.912c7.932 5.795 19.08 4.076 24.89-3.855c5.811-7.906 4.07-19-3.874-24.77l-9.482-6.898c8.859-13.8 16.59-28.38 22.99-43.68l11.07 3.795c9.334 3.188 19.44-1.719 22.64-10.99c3.213-9.258-1.739-19.35-11.04-22.53l-11.18-3.832c2.625-9.467 4.951-19.06 6.6-28.91C614.2 244.2 614.2 237.7 613.8 231.3zM369.8 439.5c-1.982 .334-3.988 .502-5.963 .502c-17.31 0-32.52-12.94-35.38-30.11c-1.58-9.484 .627-19.02 6.215-26.84c5.586-7.82 13.88-12.1 23.38-14.58c70.95-11.83 126.6-67.45 138.4-138.4c2.904-17.44 17.79-30.09 35.4-30.09c1.99 0 3.996 .168 6.029 .5078c9.48 1.578 17.78 6.756 23.37 14.58c5.588 7.824 7.795 17.35 6.213 26.84C550.6 343.2 471.2 422.6 369.8 439.5zM272.3 226.4c9-3.957 13.08-14.42 9.115-23.39L277.4 193.9c3.791-1.021 7.46-2.329 11.39-2.983c12.86-2.131 24.33-7.328 34.29-14.38l10.47 9.435c6.969 6.301 18.28 6.326 25.15-1.236c6.609-7.26 6.053-18.47-1.24-25.04l-10.51-9.478c8.004-13.9 11.92-30.04 10.67-46.93l13.63-4.038c9.428-2.793 14.8-12.66 11.99-22.05c-2.781-9.385-12.69-14.71-22.15-11.94l-13.57 4.02c-8.115-14.52-20.26-26.11-34.85-33.52l3.547-13.56C318.7 12.73 313 3.04 303.5 .5811c-9.566-2.482-19.25 3.22-21.72 12.69L278.3 26.58C270.8 26.31 259.1 26.65 229.7 35.05L225.7 23.93C222.4 14.71 212.2 9.827 202.1 13.17C193.7 16.45 188.9 26.59 192.2 35.82l3.908 10.94c-15.31 6.525-29.84 14.45-43.61 23.41L145.4 60.76C139.5 52.92 128.3 51.32 120.5 57.16C112.6 63.02 110.1 74.13 116.8 81.98l6.992 9.325c-12.62 10.66-24.22 22.44-34.81 35.12L79.52 119.5c-7.932-5.795-19.08-4.074-24.89 3.855C48.82 131.3 50.56 142.4 58.51 148.1l9.482 6.899C59.13 168.8 51.4 183.4 45 198.7L33.93 194.9C24.6 191.7 14.5 196.6 11.3 205.9C8.086 215.2 13.04 225.3 22.34 228.4L33.52 232.3C30.89 241.7 28.57 251.3 26.92 261.2c-1.107 6.609-1.166 13.11-.7051 19.51L12.75 284.7C3.309 287.4-2.061 297.3 .7441 306.7c3.039 10.21 13.57 14.52 22.14 11.95l13.59-4.019c7.914 14.22 19.88 25.9 34.76 33.47l-3.578 13.71c-1.865 7.158 1.902 22.19 17.26 22.19c7.92 0 15.14-5.287 17.23-13.28l3.516-13.47c2.512 .1016 23.42 2.248 46.96-12.3l9.734 9.982c3.777 3.873 15.44 9.781 25.19 .3691c7.062-6.822 7.225-18.04 .3711-25.07l-9.821-10.07c6.217-9.375 10.83-19.99 12.8-31.79c.8164-4.883 2.367-9.471 3.76-14.13L203.8 278.5C212.6 282.6 223.2 278.9 227.4 269.1C231.6 261.1 227.8 250.6 218.9 246.4L209.6 242.1C218.8 228.4 230.8 216.9 244.7 208l4.11 9.278C252.8 226.2 263.3 230.3 272.3 226.4zM143.5 281.9C142.4 288.4 132.4 316.6 102.1 311.5C92.59 309.9 84.29 304.7 78.71 296.9c-5.588-7.824-7.795-17.36-6.213-26.84C89.37 168.8 168.8 89.38 270.2 72.48c29.75-4.994 40.21 22.8 41.34 29.61c3.258 19.52-9.859 38.13-29.6 41.42C210.1 155.3 155.3 210.1 143.5 281.9z"],
    "bacterium": [576, 512, [], "e05a", "M543 102.9c-3.711-12.51-16.92-19.61-29.53-15.92l-18.1 5.362c-10.82-19.36-27.01-34.81-46.47-44.69l4.729-18.08c3.309-12.64-4.299-25.55-16.99-28.83c-12.76-3.309-25.67 4.295-28.96 16.92L403 35.44c-7.357-.2676-14.85 .1934-22.38 1.457c-14.47 2.4-28.54 5.869-42.41 9.828l-5.295-14.82c-4.406-12.3-17.1-18.81-30.34-14.34c-12.35 4.371-18.8 17.88-14.41 30.2l5.211 14.59C273 71.05 253.6 81.62 235.3 93.57L225.9 81.01C217.1 70.56 203.1 68.42 192.6 76.21C182.1 84.03 179.9 98.83 187.8 109.3l9.324 12.43C180.3 135.9 164.8 151.7 150.7 168.6L138 159.3C127.5 151.6 112.6 153.9 104.8 164.5c-7.748 10.54-5.428 25.33 5.164 33.03l12.64 9.198C110.8 225.1 100.5 244.5 92.01 264.9L77.25 259.9C64.8 255.6 51.33 262.2 47.06 274.5C42.78 286.9 49.38 300.3 61.78 304.6L76.69 309.7c-3.502 12.62-6.604 25.41-8.801 38.54c-1.477 8.812-1.555 17.48-.9414 26.01l-17.95 5.308c-12.59 3.709-19.74 16.87-16 29.38c3.062 10.28 12.51 16.91 22.75 16.91c2.242 0 4.514-.3066 6.771-.9844l18.13-5.359c10.55 18.97 26.51 34.53 46.35 44.63l-4.772 18.28c-3.293 12.63 4.33 25.53 17.02 28.83C141.2 511.8 143.2 512 145.2 512c10.56 0 20.19-7.049 22.98-17.7L172.9 476.3c1.482 .0586 2.99 .3711 4.465 .3711c21.06 0 41.01-6.182 58.15-16.77l12.98 13.31c4.654 4.771 10.84 7.172 17.04 7.172c5.969 0 11.92-2.217 16.54-6.68c9.416-9.096 9.633-24.06 .4941-33.43l-13.09-13.43c8.289-12.5 14.44-26.66 17.07-42.38c1.09-6.512 2.889-12.75 4.744-18.96l12.4 5.803c3.264 1.523 6.695 2.246 10.08 2.246c8.922 0 17.46-5.018 21.51-13.59c5.582-11.8 .4785-25.89-11.4-31.45l-12.36-5.781c12.27-18.23 28.19-33.6 46.82-45.38l5.481 12.37c3.928 8.834 12.63 14.1 21.75 14.1c3.201 0 6.449-.6465 9.572-2c11.1-5.279 17.44-19.22 12.15-31.18L401.9 258.5c5.053-1.361 9.956-3.085 15.2-3.958c17.15-2.84 32.44-9.771 45.71-19.17l13.95 12.58c4.547 4.109 10.25 6.125 15.94 6.125c6.463 0 12.91-2.617 17.6-7.773c8.814-9.68 8.072-24.62-1.654-33.38l-14.02-12.64c10.67-18.53 15.89-40.05 14.23-62.57l18.17-5.381C539.6 128.6 546.7 115.4 543 102.9zM452.1 181.2c-9.934 13.91-24.69 23.11-41.56 25.92C322.7 221.8 253.8 290.7 239.1 378.5c-5.164 30.1-31.65 53.5-62.98 53.5c-3.539 0-7.104-.2969-10.67-.8945c-16.86-2.807-31.62-12.01-41.55-25.92c-9.936-13.91-13.86-30.85-11.05-47.72c23.63-141.8 134.8-252.1 276.7-276.6c3.516-.5918 7.086-.8906 10.62-.8906c30.8 0 57.86 23 62.95 53.51C465.9 150.4 462 167.3 452.1 181.2zM192 288c-17.67 0-31.1 14.33-31.1 31.1s14.33 31.1 31.1 31.1s31.1-14.33 31.1-31.1S209.7 288 192 288zM272 184c-13.25 0-23.92 10.74-23.92 23.1c0 13.25 10.67 24 23.92 24c13.26 0 23.1-10.75 23.1-23.1C295.1 194.7 285.3 184 272 184z"],
    "badge": [512, 512, [], "f335", "M256 512c-36.25 0-68.25-18.62-86.75-46.75c-33 6.875-68.63-2.5-94.25-28.25c-25.62-25.62-35.12-61.38-28.25-94.25C18.75 324.2 0 292.2 0 256s18.62-68.25 46.75-86.75C39.88 136.5 49.25 100.6 75 75c25.62-25.62 61.38-35.12 94.25-28.25C187.8 18.75 219.8 0 256 0s68.25 18.75 86.75 46.75C375.5 39.88 411.4 49.25 437 75c25.62 25.62 35.13 61.38 28.25 94.25C493.3 187.6 512 219.5 512 256c0 36.25-18.62 68.25-46.75 86.75c6.875 32.75-2.5 68.62-28.25 94.25c-25.62 25.62-61.25 35.13-94.25 28.25C324.2 493.2 292.4 512 256 512zM194.8 403.8C201.2 421.2 210.8 464 256 464c43.88 0 53.5-39.63 61.25-60.25c30.5 13.87 57.75 27.37 85.75-.625c30.1-31 9.75-65.88 .75-85.88c17.37-6.5 60.12-15.87 60.12-61.12c0-43.88-39.63-53.5-60.12-61.25C411.4 178 435 141.1 403 109.1c-31-31-65.88-9.875-85.75-.75C310.8 90.75 301.2 48 256 48c-43.88 0-53.5 39.62-61.25 60.25C177.9 100.5 141 76.88 109 108.9C77.1 139.9 99.25 174.8 108.2 194.8C90.75 201.2 48 210.8 48 256c0 43.88 39.62 53.5 60.25 61.25C100.5 334.1 76.88 371 108.9 403C139.9 434 173.8 413.4 194.8 403.8z"],
    "badge-check": [576, 512, [], "f336", "M543.8 256c0-36.5-18.86-68.38-46.86-86.75c6.875-32.88-2.517-68.63-28.14-94.25c-25.62-25.75-61.61-35.13-94.36-28.25C355.1 18.75 324.1 0 287.8 0S219.5 18.75 200.1 46.75C168.1 39.88 132.5 49.38 106.8 75C81.09 100.6 71.61 136.5 78.48 169.3C50.36 187.8 31.84 219.8 31.84 256s18.64 68.25 46.64 86.75C71.61 375.6 81.21 411.4 106.8 437c25.62 25.75 61.14 35.13 94.14 28.25C219.5 493.4 251.6 512 287.8 512c36.38 0 68.14-18.75 86.64-46.75c33 6.875 68.73-2.625 94.36-28.25c25.75-25.62 35.02-61.5 28.14-94.25C525.1 324.3 543.8 292.3 543.8 256zM435.5 317.3c9 20 30.25 54.88-.75 85.88c-28 28-55.25 14.5-85.75 .625C341.2 424.4 331.6 464 287.7 464c-45.25 0-54.75-42.75-61.25-60.25C205.5 413.4 171.6 434 140.6 403c-32-32-8.375-68.88-.625-85.75C119.4 309.5 79.73 299.9 79.73 256c0-45.25 42.75-54.75 60.25-61.25c-9-20-30.25-54.88 .75-85.88c32-32 68.88-8.375 85.75-.625C234.2 87.63 243.9 48 287.7 48c45.25 0 54.75 42.75 61.25 60.38c19.88-9.125 54.75-30.25 85.75 .75c32 32 8.375 68.88 .75 85.75c20.5 7.75 60.13 17.38 60.13 61.25C495.6 301.4 452.9 310.8 435.5 317.3zM384.1 183c9.375 9.375 9.375 24.56 0 33.94l-112 112C268.3 333.7 262.1 336 256 336s-12.28-2.344-16.97-7.031l-48-48c-9.375-9.375-9.375-24.56 0-33.94s24.56-9.375 33.94 0L256 278.1l95.03-95.03C360.4 173.7 375.6 173.7 384.1 183z"],
    "badge-dollar": [576, 512, [], "f645", "M543.8 256c0-36.5-18.86-68.38-46.86-86.75c6.875-32.88-2.517-68.63-28.14-94.25c-25.62-25.75-61.61-35.13-94.36-28.25C355.1 18.75 324.1 0 287.8 0S219.5 18.75 200.1 46.75C168.1 39.88 132.5 49.38 106.8 75C81.09 100.6 71.61 136.5 78.48 169.3C50.36 187.8 31.84 219.8 31.84 256s18.64 68.25 46.64 86.75C71.61 375.6 81.21 411.4 106.8 437c25.62 25.75 61.14 35.13 94.14 28.25C219.5 493.4 251.6 512 287.8 512c36.38 0 68.14-18.75 86.64-46.75c33 6.875 68.73-2.625 94.36-28.25c25.75-25.62 35.02-61.5 28.14-94.25C525.1 324.3 543.8 292.3 543.8 256zM435.5 317.3c9 20 30.25 54.88-.75 85.88c-28 28-55.25 14.5-85.75 .625C341.2 424.4 331.6 464 287.7 464c-45.25 0-54.75-42.75-61.25-60.25C205.5 413.4 171.6 434 140.6 403c-32-32-8.375-68.88-.625-85.75C119.4 309.5 79.73 299.9 79.73 256c0-45.25 42.75-54.75 60.25-61.25c-9-20-30.25-54.88 .75-85.88c32-32 68.88-8.375 85.75-.625C234.2 87.63 243.9 48 287.7 48c45.25 0 54.75 42.75 61.25 60.38c19.88-9.125 54.75-30.25 85.75 .75c32 32 8.375 68.88 .75 85.75c20.5 7.75 60.13 17.38 60.13 61.25C495.6 301.4 452.9 310.8 435.5 317.3zM359 303.9c-4.117 23.87-21.75 40.01-47.03 45.72V360c0 13.25-10.75 24-24 24s-24-10.75-24-24v-11.41c-9.498-2.219-18.9-5.25-27.38-8.307l-4.656-1.656c-12.47-4.438-19.03-18.16-14.59-30.64C221.8 295.5 235.5 289 248 293.4l4.875 1.75C261.7 298.3 271.7 301.9 279.3 303c17.09 2.672 31.25-.6094 32.38-7.359c.8125-4.75 1.312-7.578-30.34-16.64l-6.5-1.875C256.7 271.8 208.4 257.6 216.1 208.1C221.1 184.3 238.7 168.2 264 162.5V152C264 138.8 274.8 128 288 128s24 10.75 24 24v11.24c5.908 1.365 12.23 3.096 19.84 5.727c12.53 4.344 19.16 18 14.84 30.53c-4.344 12.52-17.97 19.19-30.53 14.84c-8.281-2.875-14.72-4.641-19.66-5.422c-16.88-2.688-31.06 .625-32.22 7.391C263.6 220.4 263 223.6 288.4 231.1l6.188 1.797C320.1 240.2 367.7 253.8 359 303.9z"],
    "badge-percent": [576, 512, [], "f646", "M223.8 224c17.62 0 31.1-14.38 31.1-32S241.4 160 223.8 160s-32 14.38-32 32S206.2 224 223.8 224zM543.8 256c0-36.5-18.86-68.38-46.86-86.75c6.875-32.88-2.517-68.63-28.14-94.25c-25.62-25.75-61.61-35.13-94.36-28.25C355.1 18.75 324.1 0 287.8 0S219.5 18.75 200.1 46.75C168.1 39.88 132.5 49.38 106.8 75C81.09 100.6 71.61 136.5 78.48 169.3C50.36 187.8 31.84 219.8 31.84 256s18.64 68.25 46.64 86.75C71.61 375.6 81.21 411.4 106.8 437c25.62 25.75 61.14 35.13 94.14 28.25C219.5 493.4 251.6 512 287.8 512c36.38 0 68.14-18.75 86.64-46.75c33 6.875 68.73-2.625 94.36-28.25c25.75-25.62 35.02-61.5 28.14-94.25C525.1 324.3 543.8 292.3 543.8 256zM435.5 317.3c9 20 30.25 54.88-.75 85.88c-28 28-55.25 14.5-85.75 .625C341.2 424.4 331.6 464 287.7 464c-45.25 0-54.75-42.75-61.25-60.25C205.5 413.4 171.6 434 140.6 403c-32-32-8.375-68.88-.625-85.75C119.4 309.5 79.73 299.9 79.73 256c0-45.25 42.75-54.75 60.25-61.25c-9-20-30.25-54.88 .75-85.88c32-32 68.88-8.375 85.75-.625C234.2 87.63 243.9 48 287.7 48c45.25 0 54.75 42.75 61.25 60.38c19.88-9.125 54.75-30.25 85.75 .75c32 32 8.375 68.88 .75 85.75c20.5 7.75 60.13 17.38 60.13 61.25C495.6 301.4 452.9 310.8 435.5 317.3zM351.8 288c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S369.4 288 351.8 288zM368.1 175c-9.375-9.375-24.56-9.375-33.94 0l-128 128c-9.375 9.375-9.375 24.56 0 33.94C211.7 341.7 217.8 344 224 344s12.28-2.344 16.97-7.031l128-128C378.3 199.6 378.3 184.4 368.1 175z"],
    "badge-sheriff": [512, 512, [], "f8a2", "M439.9 320c-1.124 0-2.124 .5-3.248 .625L398.2 256l38.48-64.62C437.8 191.5 438.8 192 439.9 192c19.99 .125 36.98-14.62 39.73-34.38c2.748-19.87-9.494-38.62-28.73-44.12C431.6 108.1 411.3 117.8 403.3 136h-76.45l-41.35-69.5C292.1 59.25 295.9 49.88 295.1 40C295.1 17.88 278.1 0 256 0S216 17.88 216 40C216.1 49.88 219.9 59.38 226.6 66.62L185.3 136h-76.58C100.7 117.6 80.36 108.1 61.12 113.5s-31.48 24.25-28.73 44C35.13 177.4 52.12 192 72.11 192C73.23 192 74.23 191.5 75.36 191.4L113.8 256L75.36 320.6C74.23 320.6 73.23 320 72.11 320c-19.99 0-36.98 14.62-39.73 34.5c-2.748 19.75 9.494 38.63 28.73 44S100.7 394.4 108.7 376h76.45l41.35 69.5C219.9 452.8 216.1 462.1 216 472C216 494.1 233.9 512 256 512s39.98-17.88 39.98-40c-.1249-9.875-3.873-19.38-10.62-26.62L326.7 376h76.58c7.995 18.38 28.36 27.88 47.6 22.5c19.24-5.375 31.48-24.25 28.73-44C476.9 334.6 459.9 320 439.9 320zM312.1 328c-8.37 0-16.24 4.5-20.49 11.75l-36.6 61.37l-36.48-61.37C215.1 332.5 207.3 328 198.8 328H126.8l35.48-59.63c4.497-7.625 4.497-16.1 0-24.62L126.8 184h72.21c8.37 0 16.24-4.5 20.49-11.75l36.6-61.37l36.48 61.37C296.9 179.5 304.7 184 313.2 184h71.96l-35.48 59.62c-4.497 7.625-4.497 17 0 24.62L385.2 328H312.1zM256 208C229.5 208 208 229.5 208 256S229.5 304 256 304s47.97-21.5 47.97-48S282.5 208 256 208z"],
    "badger-honey": [640, 512, [63156], "1f9a1", "M622.3 142.5C596.6 127.1 579.5 116 551.6 97.12c-14.25-9.625-29.75-18-44.87-24.62c-13.38-5.75-27.38-8.479-41.25-8.479c-19.12 0-38.12 5.255-55.5 15.26C392.9 89.03 373.1 96.02 355 96.02H128c-70.75 0-128 57.26-128 128v15.95c0 8.875 7.125 16 16 16h20c7.125 30.38 23.88 55.89 45.1 73.14l-12.37 33c-6.25 16.88-7.375 34.88-2 55.25l13.62 34.25C86.38 468.4 101.8 480 119.5 480h63.12c12.25 0 24-5.25 31.75-14.75c8-9.875 10.75-22.75 7.75-35l-12.75-34.12L231.1 352h55.12l19.13 95.88C309.1 466.5 325.6 480 344.6 480h62.62c11.75 0 23.13-4.875 30.88-13.62c8.125-9.5 11.5-22 9.125-34.25l-25.5-127.3c53-31.75 91.12-46.84 119.4-54.59L560 287.1l23-46.12c22.5-2.75 33-2.75 40.88-19C631.1 207.8 640 187.2 640 175.3C640 161.4 633.1 148.6 622.3 142.5zM128 144h227c25.62 0 52.25-7.75 78.88-23.25C444 115 454.9 112 465.5 112c7.625 0 15.12 1.5 22.12 4.625c24.5 10.5 33.63 18.62 48.5 27.38l-76.17-.0505c-31.75 0-61.46 13.05-93.08 28.43l-100.6 61C257 237.8 247.3 240 237.5 240L192 240.1c-37 0-71.75-44.06-78.62-94.68C118.1 144.5 123 144 128 144zM584.6 193.4c-98.63 12.25-162.9 55.5-216.5 87.75C376.9 325.5 373 305.8 398.2 432h-47.12l-25.5-128H201.2l-44.13 89.5L171.5 432H125.1l-11.75-29.25c-2.5-11.63-.75-18.88 1.125-23.75l24.75-66.13L111.4 291.1c-14-10.88-24.25-27.25-28.62-46L74.12 208H49.62c4.25-20.75 16.62-38.38 33.5-49.88C94.12 216.6 135.6 272 192 272h45.5c14.75 0 29-3.25 44-10.5l100.6-61.12C408.9 187.5 435 176 460 176h16.75C478.8 185 486.4 192 496 192s17.25-7 19.25-16h80.38C592.3 181.2 586.6 188.9 584.6 193.4z"],
    "badminton": [640, 512, [], "e33a", "M511.1 399.1L512 431.1h96l-.0031-32.02c0-26.51-21.49-48.01-48-48.01S511.1 373.5 511.1 399.1zM544 495.1c0 8.844 7.153 16 15.1 16s16-7.159 16-16l.1181-47.97l-32.23 .0273L544 495.1zM575.1 155.9c0-118.8-102.8-155.9-160.6-155.9c-100.1 0-229.6 85.81-229.6 220.1c0 29.23 7.266 57.54 22.34 82.25l-68.01 54.45c-7.625-6.672-17.24-10.24-26.88-10.24c-8.396 0-16.81 2.704-23.94 8.416l-68.21 54.44c-.8922 .7094-21.09 15.4-21.09 43.88c0 12.64 4.221 24.8 12.25 34.9l2.219 2.781C25.53 504.8 41.83 512 58.32 512c12.21 0 24.52-3.969 34.82-12.19l68.21-54.44c14.59-11.66 15.05-27.68 15.05-30.28c0-.1723-.002-.2857-.002-.3351c0-7.332-2.37-14.32-6.115-20.65l69.11-55.34c.0918-.0742 .127-.1855 .2168-.2598c29.54 24.69 67.72 37.32 108.3 37.32C438.6 375.8 575.1 297.5 575.1 155.9zM62.75 462.3c-1.454 1.189-3.198 1.764-4.94 1.764c-2.377 0-4.749-1.07-6.372-3.108l-2.219-2.75c-1.455-1.831-1.762-3.742-1.762-5.072c0-3.418 2.121-5.492 3.012-6.209l62.03-49.47l12.25 15.38L62.75 462.3zM528.3 156.3c0 45.36-24.35 94.99-68.73 130.4c-34.59 27.56-74.85 41.37-111.8 41.37c-38.56 0-114.2-22.5-114.2-108.3c0-81.44 81.94-171.7 180.4-171.7h1.904C484.2 48.86 528.3 95.64 528.3 156.3zM624 495.1c0-1.671-.2634-3.371-.8185-5.043l-14.31-42.94l-32.75 .0325c0 .0096 0 0 0 0s0 .0018 0 0c0-.0069 0 0 0 0s0-.0096 0 0c0 1.637 .1519 3.394 .6954 5.031l15.1 48.01c2.25 6.688 8.5 10.94 15.19 10.94C616.1 511.1 624 504.7 624 495.1zM496.8 490.9c-.5552 1.672-.8185 3.372-.8185 5.043c0 8.709 7.03 16.02 16 16.02c6.688 0 12.94-4.251 15.19-10.94l16-48.01c.5435-1.636 .6954-3.366 .6954-5.003c0-.0096 0 0 0 0s0-.0069 0 0c0 .0018 0 0 0 0s0 .0096 0 0l-32.75-.0598L496.8 490.9z"],
    "bag-shopping": [448, 512, ["shopping-bag"], "f290", "M416 160h-72V120C344 53.83 290.2 0 224 0S104 53.83 104 120V160H32C14.33 160 0 174.3 0 192v240C0 476.2 35.82 512 80 512h288c44.18 0 80-35.82 80-80V192C448 174.3 433.7 160 416 160zM152 120C152 80.3 184.3 48 224 48s72 32.3 72 72V160h-144V120zM400 432c0 17.64-14.36 32-32 32h-288c-17.64 0-32-14.36-32-32v-224h56v56C104 277.3 114.8 288 128 288s24-10.75 24-24V208h144v56C296 277.3 306.8 288 320 288s24-10.75 24-24V208h56V432z"],
    "bags-shopping": [576, 512, [63559], "1f6cd", "M512 256H256c-35.35 0-64 28.65-64 64v128c0 35.35 28.65 64 64 64h256c35.35 0 64-28.65 64-64v-128C576 284.7 547.3 256 512 256zM480 351.1c0 52.94-43.06 96-96 96S288 404.9 288 352v-8c0-13.25 10.75-23.1 24-23.1S336 330.8 336 344V352c0 26.47 21.53 48 48 48s48-21.53 48-48v-8c0-13.25 10.75-23.1 24-23.1S480 330.8 480 344V351.1zM48 416V224c0-8.822 7.178-16 16-16h320c8.822 0 16 7.178 16 16H448c0-35.35-28.65-64-64-64l-64 0V96c0-52.94-43.06-96-96-96S128 43.06 128 96v64L64 160C28.65 160 0 188.7 0 224v192c0 35.35 28.65 64 64 64h96v-48H64C55.18 432 48 424.8 48 416zM176 96c0-26.47 21.53-48 48-48S272 69.53 272 96v64h-96V96z"],
    "bahai": [512, 512, [], "f666", "M496.3 202.5l-110-15.38l41.88-104.4c5.251-13.13-4.936-25.54-16.94-25.54c-3.125 0-6.565 .9121-9.69 2.912L307.5 120l-34.13-107.1C270.6 4.25 263.4 0 255.1 0C248.6 0 241.4 4.25 238.6 12.88L204.5 120L110.5 60.12c-3.125-2-6.524-2.887-9.649-2.887c-12 0-22.32 12.39-16.95 25.51l41.85 104.4L15.71 202.5C-1.792 205-5.917 228.8 9.71 237.2l98.14 52.63l-74.51 83.5c-10.88 12.25-1.657 31 13.35 31c1.375 0 2.657-.25 4.032-.5l108.6-23.63l-4.126 112.5C154.7 504.4 164.1 512 173.6 512c5.126 0 10.38-2.25 14.25-7.25l68.13-88.88l68.23 88.88C328.1 509.8 333.2 512 338.4 512c9.501 0 18.88-7.625 18.38-19.25l-4.032-112.5l108.5 23.63c1.375 .25 2.733 .4707 4.108 .4707c15 0 24.15-18.72 13.27-30.97l-74.51-83.5l98.14-52.72C517.9 228.7 513.8 205 496.3 202.5zM369 322l14 15.75l-79.89-17.38l3 82.75L256 337.8l-50.13 65.37l3-82.75l-79.89 17.38l54.76-61.5L111.6 237.5l80.89-11.38L161.7 149.4l69.14 44.12L256 114.6l25.13 78.88l69.14-44.12l-30.75 76.75l80.89 11.38l-72.14 38.75L369 322z"],
    "baht-sign": [320, 512, [], "e0ac", "M261.4 237.3C277.9 218.9 288 194.6 288 168C288 110.7 241.3 64 184 64h-16V24C168 10.75 157.3 0 144 0S120 10.75 120 24V64h-96C10.75 64 0 74.75 0 88v336c0 12.53 9.625 22.94 22.12 23.94c7.874 .5938 20.62 .8438 36.78 .8438c17.1 0 38.08-.3496 61.09-.7031V488C120 501.3 130.8 512 144 512s24-10.75 24-24v-40.6c14.14-.2148 28.2-.418 41.63-.5605C270.5 446.2 320 396.2 320 335.4C320 293.1 296.3 256.2 261.4 237.3zM184 112c30.88 0 56 25.12 56 56S214.9 224 184 224h-16V112H184zM48 112h72V224H48V112zM48 400.8V272h72v128.1C92.66 400.5 66.61 400.8 48 400.8zM209.1 398.8c-13.27 .1406-27.16 .3398-41.13 .5508V272h40.56C243.5 272 272 300.5 272 335.4C272 370 243.8 398.5 209.1 398.8z"],
    "ball-pile": [576, 512, [], "f77e", "M480 320c-10.41 0-20.3 2.081-29.68 5.174C468.5 307.7 480 283.3 480 256c0-53-43-96-96-96c-10.41 0-20.3 2.081-29.68 5.174C372.6 147.7 384 123.2 384 96c0-53-43-96-96-96S192 43 192 96c0 27.19 11.4 51.67 29.68 69.17C212.3 162.1 202.5 160 192 160C139 160 96 203 96 256c0 27.19 11.4 51.67 29.68 69.17C116.3 322.1 106.5 320 96 320c-53 0-96 43-96 96s43 96 96 96s96-43 96-96c0-27.19-11.4-51.67-29.68-69.17C171.7 349.9 181.5 352 192 352s20.3-2.081 29.68-5.174C203.4 364.3 192 388.8 192 416c0 53 43 96 96 96s96-43 96-96c0-27.19-11.4-51.67-29.68-69.17C363.7 349.9 373.5 352 384 352s20.3-2.081 29.68-5.174C395.4 364.3 384 388.8 384 416c0 53 43 96 96 96s96-43 96-96S533 320 480 320zM288 48c26.5 0 48 21.5 48 48S314.5 144 288 144S240 122.5 240 96S261.5 48 288 48zM317.7 325.2C308.3 322.1 298.5 320 288 320s-20.3 2.081-29.68 5.174C276.5 307.7 288 283.3 288 256S276.6 204.3 258.3 186.8C267.7 189.9 277.5 192 288 192s20.3-2.081 29.68-5.174C299.4 204.3 288 228.8 288 256S299.4 307.7 317.7 325.2zM96 464c-26.5 0-48-21.5-48-48s21.5-48 48-48s48 21.5 48 48S122.5 464 96 464zM192 304C165.5 304 144 282.5 144 256S165.5 208 192 208S240 229.5 240 256S218.5 304 192 304zM288 464c-26.5 0-48-21.5-48-48s21.5-48 48-48s48 21.5 48 48S314.5 464 288 464zM384 304c-26.5 0-48-21.5-48-48s21.5-48 48-48s48 21.5 48 48S410.5 304 384 304zM480 464c-26.5 0-48-21.5-48-48s21.5-48 48-48s48 21.5 48 48S506.5 464 480 464z"],
    "balloon": [384, 512, [], "e2e3", "M184 80C126.7 80 80 126.7 80 184c0 13.25 10.75 24 24 24S128 197.3 128 184C128 153.1 153.1 128 184 128c13.25 0 24-10.75 24-24S197.3 80 184 80zM384 192c0-105.9-86.13-192-192-192S0 86.13 0 192c0 77.22 86.33 182.1 147.1 226.6l-32.1 57.78c-4.156 7.438-4.031 16.5 .2813 23.81C119.6 507.5 127.5 512 136 512h112c8.5 0 16.38-4.5 20.69-11.84c4.312-7.312 4.438-16.38 .2813-23.81l-32.1-57.78C297.7 374.1 384 269.2 384 192zM192 391.3C162.3 378 48 266.8 48 192c0-79.41 64.59-144 144-144s144 64.59 144 144C336 266.8 221.7 378 192 391.3z"],
    "balloons": [640, 512, [], "e2e4", "M521.6 428.9C572.4 388.1 640 299.8 640 232.8C640 139.7 568.2 64 480 64c-54.09 0-101.8 28.63-130.8 72.11C350.9 146.8 352 157.7 352 168.8c0 30.95-11.31 63.97-27.87 95.5C326.8 275.1 330.8 286.3 336 297.9c19.9 44.04 64.79 100.1 102.4 131.1l-25.01 47.9c-3.875 7.438-3.594 16.34 .75 23.53S426.3 512 434.7 512h90.69c8.406 0 16.19-4.375 20.53-11.56s4.625-16.09 .75-23.53L521.6 428.9zM480 400.5c-19.31-11.69-74.5-65.31-100.3-122.4C371.9 260.9 368 245.6 368 232.8C368 166.2 418.3 112 480 112s112 54.19 112 120.8C592 294.6 506.7 384.6 480 400.5zM480 152c-39.69 0-72 32.31-72 72c0 13.25 10.75 24 24 24S456 237.3 456 224c0-13.22 10.78-24 24-24c13.25 0 24-10.75 24-24S493.3 152 480 152zM160 88C120.3 88 88 120.3 88 160c0 13.25 10.75 24 24 24S136 173.3 136 160c0-13.22 10.78-24 24-24c13.25 0 24-10.75 24-24S173.3 88 160 88zM320 168.8C320 75.72 248.2 0 160 0S0 75.72 0 168.8c0 67.03 67.64 156.1 118.4 196.1l-25.04 47.96c-3.875 7.438-3.594 16.34 .75 23.53S106.3 448 114.7 448h90.69c8.406 0 16.19-4.375 20.53-11.56s4.625-16.09 .75-23.53l-25.04-47.96C252.4 324.1 320 235.8 320 168.8zM160 336.5c-26.66-15.84-112-105.9-112-167.7C48 102.2 98.25 48 160 48s112 54.19 112 120.8C272 230.7 186.7 320.7 160 336.5z"],
    "ballot": [448, 512, [], "f732", "M128 352H96c-8.836 0-16 7.164-16 16v32C80 408.8 87.16 416 96 416h32c8.836 0 16-7.164 16-16v-32C144 359.2 136.8 352 128 352zM128 224H96C87.16 224 80 231.2 80 240v32C80 280.8 87.16 288 96 288h32c8.836 0 16-7.164 16-16v-32C144 231.2 136.8 224 128 224zM128 96H96C87.16 96 80 103.2 80 112v32C80 152.8 87.16 160 96 160h32c8.836 0 16-7.164 16-16v-32C144 103.2 136.8 96 128 96zM384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V64c0-8.824 7.178-16 16-16h320c8.822 0 16 7.176 16 16V448zM344 104h-144C186.8 104 176 114.8 176 128s10.75 24 24 24h144c13.25 0 24-10.75 24-24S357.3 104 344 104zM344 232h-144C186.8 232 176 242.8 176 256s10.75 24 24 24h144c13.25 0 24-10.75 24-24S357.3 232 344 232zM344 360h-144c-13.25 0-24 10.75-24 24s10.75 24 24 24h144c13.25 0 24-10.75 24-24S357.3 360 344 360z"],
    "ballot-check": [448, 512, [], "f733", "M128 352H96c-8.836 0-16 7.164-16 16v32C80 408.8 87.16 416 96 416h32c8.836 0 16-7.164 16-16v-32C144 359.2 136.8 352 128 352zM96 160h32c8.836 0 16-7.164 16-16v-32C144 103.2 136.8 96 128 96H96C87.16 96 80 103.2 80 112v32C80 152.8 87.16 160 96 160zM344 360h-144c-13.25 0-24 10.75-24 24s10.75 24 24 24h144c13.25 0 24-10.75 24-24S357.3 360 344 360zM171.3 220.7c-6.25-6.25-16.38-6.25-22.62 0L112 257.4L99.31 244.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l24 24C103.8 294.4 107.9 296 112 296s8.188-1.562 11.31-4.688l48-48C177.6 237.1 177.6 226.9 171.3 220.7zM344 232h-112C218.8 232 208 242.8 208 256s10.75 24 24 24h112c13.25 0 24-10.75 24-24S357.3 232 344 232zM384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V64c0-8.824 7.178-16 16-16h320c8.822 0 16 7.176 16 16V448zM344 104h-144C186.8 104 176 114.8 176 128s10.75 24 24 24h144c13.25 0 24-10.75 24-24S357.3 104 344 104z"],
    "ban": [512, 512, [61534, "cancel"], "1f6ab", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM48 256c0-48.71 16.95-93.47 45.11-128.1l291.9 291.9C349.5 447 304.7 464 256 464C141.3 464 48 370.7 48 256zM418.9 384.1L127 93.11C162.5 64.95 207.3 48 256 48c114.7 0 208 93.31 208 208C464 304.7 447 349.5 418.9 384.1z"],
    "ban-bug": [512, 512, ["debug"], "f7f9", "M143.1 304c1.062 0 2.125-.0938 3.156-.3125l29.85-5.97c1.148 9.354 3.82 18.14 7.906 26.21L160.1 338.1c-7.688 4.375-10.34 14.16-5.969 21.83C157.1 365.1 162.5 368 168 368c2.719 0 5.438-.6719 7.938-2.109l29.15-16.66C218.1 360.8 236.5 368 256 368c6.562 0 12.81-1.081 18.89-2.608L174.1 265.5l-34.11 6.822C132.2 274 126.6 282.5 128.3 291.1C129.8 298.8 136.5 304 143.1 304zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208c0-48.71 16.95-93.47 45.11-128.1l291.9 291.9C349.5 447 304.7 464 256 464zM418.9 384.1l-84.41-84.41c.1621-1.004 .6074-1.898 .7324-2.914l29.65 6.051c13.28 2.816 18.28-9.877 18.81-12.55c1.75-8.672-3.875-17.09-12.56-18.83L336 265.3V246.8l35.13-7.097c8.688-1.734 14.31-10.16 12.56-18.83c-1.75-8.703-10.56-14.36-18.81-12.55l-29.85 5.964c-.002-.0078 .002 .0078 0 0c-.5625-4.578-1.493-9.015-2.795-13.32c-.0566-.1855-.1152-.3691-.1719-.5547c-1.328-4.277-2.942-8.388-4.937-12.33c-.002-.0039 .002 .0039 0 0l24.82-14.19c7.688-4.375 10.34-14.16 5.969-21.83c-4.438-7.734-14.28-10.31-21.84-5.953l-29.15 16.66C293 151.2 275.5 144 256 144c-21.61 0-40.77 9.008-55.07 22.99L127 93.11C162.5 64.95 207.3 48 256 48c114.7 0 208 93.31 208 208C464 304.7 447 349.5 418.9 384.1z"],
    "ban-parking": [512, 512, ["parking-circle-slash"], "f616", "M184 384c13.25 0 24-10.75 24-24V320h10.19L160 261.8V360C160 373.3 170.8 384 184 384zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208c0-48.71 16.95-93.47 45.11-128.1l291.9 291.9C349.5 447 304.7 464 256 464zM209.9 176H272C298.5 176 320 197.5 320 224c0 16.83-8.742 31.6-21.89 40.18L209.9 176zM418.9 384.1L332.2 298.3C353.1 280.8 368 254.1 368 224c0-52.94-43.06-96-96-96H184C177.9 128 172.4 130.5 168.2 134.3L127 93.11C162.5 64.95 207.3 48 256 48c114.7 0 208 93.31 208 208C464 304.7 447 349.5 418.9 384.1z"],
    "ban-smoking": [512, 512, [62797, "smoking-ban"], "1f6ad", "M112 320h106.3L122.2 224H112C103.2 224 96 231.2 96 240v64C96 312.8 103.2 320 112 320zM320.6 128C305 128 292 116.8 289.3 102.1C288.5 98.5 285.2 96 281.5 96h-16.25c-5 0-8.625 4.5-8 9.375C261.9 136.2 288.5 160 320.6 160C336.2 160 349.2 171.2 352 185.9C352.8 189.5 356 192 359.8 192h16.17c5 0 8.708-4.5 7.958-9.375C379.2 151.8 352.8 128 320.6 128zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.8 0-208-93.25-208-208c0-48.75 17-93.5 45.13-129l291.9 291.9C349.5 447 304.8 464 256 464zM289.9 256H384v32h-62.13L289.9 256zM418.9 385L353.9 320H400c8.75 0 16-7.25 16-16v-64C416 231.2 408.8 224 400 224h-142.1L127 93.12C162.5 65 207.3 48 256 48c114.8 0 208 93.25 208 208C464 304.8 447 349.5 418.9 385z"],
    "banana": [576, 512, [], "e2e5", "M293.3 146.4c0 51.19-12.77 69.4-12.77 80.76c0 13.15 10.75 23.91 24.04 23.91c10.1 0 19.46-6.406 22.78-16.51c4.207-12.82 13.98-43.75 13.98-88.14c0-51.31-13.34-83.79-13.34-88.68c0-5.878 5.104-9.955 8.524-9.955c4.266 0 71.47 60.86 71.47 167.2c0 18.26-1.852 28.59-1.852 32.08c0 4.617 3.758 23.9 24.03 23.9c26.98 0 25.83-31.53 25.83-56.07C456 106.2 387.9 0 336.5 0C307.6 0 280.1 24.25 280.1 57.97C280.1 78 293.3 95.45 293.3 146.4zM575.1 390.5c0-3.695-.8637-7.445-2.687-10.96l-15.12-29.17c-21.05-40.62-63.08-64.65-106.9-64.65c-13.43 0-27.02 2.257-40.22 6.984l-84.84 30.34L297.6 294.6C274.4 271.4 243.7 259.5 212.8 259.5c-23.72 0-47.57 6.985-68.29 21.25L106.3 307.1C99.61 311.7 95.1 319.2 95.1 326.8c0 14.96 12.7 23.92 24.04 23.92c4.695 0 9.443-1.379 13.61-4.269l38.13-26.29c12.43-8.543 26.71-12.72 40.91-12.72c10.64 0 21.24 2.344 30.97 6.949c-50.62 62.37-128.3 100.1-211.4 100.1C14.42 414.4 0 428.8 0 446.5v31.45c0 17.72 14.66 32.09 32.46 32.09l28.98 .0009c68.41 0 286.5 25.73 363.9-171.6c9.021-3.227 17.95-4.722 26.53-4.722c27.65 0 51.7 15.53 63.7 38.63l15.12 29.17c3.484 6.737 11.74 13.01 21.41 13.01C564.1 414.5 575.1 404.6 575.1 390.5z"],
    "bandage": [640, 512, [62562, "band-aid"], "1fa79", "M576 96H64C28.8 96 0 124.8 0 160v192c0 35.2 28.8 64 64 64h512c35.2 0 64-28.8 64-64V160C640 124.8 611.2 96 576 96zM80 368c-17.67 0-32-14.33-32-32v-160c0-17.67 14.33-32 32-32H192v224H80zM272 280c13.25 0 24 10.75 24 24s-10.75 24-24 24S248 317.2 248 304S258.8 280 272 280zM248 208c0-13.25 10.75-24 24-24S296 194.8 296 208S285.2 232 272 232S248 221.2 248 208zM344 304c0-13.25 10.75-24 24-24s24 10.75 24 24s-10.75 24-24 24S344 317.2 344 304zM368 232c-13.25 0-24-10.75-24-24s10.75-24 24-24s24 10.75 24 24S381.2 232 368 232zM592 328c0 22.09-17.91 40-40 40H448v-224h112c17.67 0 32 14.33 32 32V328z"],
    "bangladeshi-taka-sign": [384, 512, [], "e2e6", "M384 264v32c0 101.5-82.53 184-184 184h-32c-48.53 0-88-39.47-88-88V224H24C10.75 224 0 213.3 0 200S10.75 176 24 176H80V120c0-22.06-17.94-40-40-40h-16C10.75 80 0 69.25 0 56S10.75 32 24 32h16C88.53 32 128 71.47 128 120V176h40C181.3 176 192 186.8 192 200S181.3 224 168 224H128v168c0 22.06 17.94 40 40 40h32c75 0 136-61 136-136v-32C336 241.9 318.1 224 296 224h-16C266.8 224 256 213.3 256 200s10.75-24 24-24h16C344.5 176 384 215.5 384 264z"],
    "banjo": [512, 512, [63651], "1fa95", "M502.6 38.1l-29.63-29.62c-12.5-12.5-32.75-12.5-45.25 0l-46.25 46.38c-3.875 3.875-6.75 8.5-8.5 13.75L355.2 123l-62.88 62.88C270.6 169.6 245.4 159 218.8 154.6l-.6384-.5C218.1 139.8 206.5 128 192 128C177.5 128 165.8 139.8 165.8 154.1L165.7 154.6c-26.25 4-50.87 14.23-72.24 29.86C83.24 174.9 66.88 174.9 56.88 184.9c-9.876 10-10.25 26-.625 36.37C40.75 242.6 30.76 267.6 26.64 293.7L26.25 293.8C11.75 293.8 0 305.5 0 320c0 14.38 11.75 26.12 26.25 26.12l.3792 .02c4.125 26.12 14.36 50.99 29.86 72.36c-7.001 6.5-10.12 16.62-7.743 25.87c2.375 9.25 9.625 16.5 18.88 18.87c9.251 2.375 19.13-.4999 25.63-7.5c21.38 15.5 46.37 25.54 72.63 29.54v.4616C165.9 500.2 177.5 512 192 512c14.5 0 26.13-11.75 26.13-26.25v-.4616c26.25-4 51.01-14.28 72.38-29.78c6.501 7 16.62 10.12 25.87 7.743c9.251-2.375 16.5-9.625 18.88-18.87c2.375-9.25-.4995-19.13-7.5-25.62c15.5-21.38 25.49-46.48 29.62-72.61l.3821-.02c14.5 0 26.25-11.75 26.25-26.12c0-14.5-11.75-26.25-26.25-26.25l-.3885-.0508C353.1 266.8 342.4 241.5 326.2 219.8l63.01-63l53.35-17.75c5.125-1.75 9.875-4.625 13.75-8.5L502.6 84.17C515 71.67 515.1 51.5 502.6 38.1zM192 440c-66.26 0-120-53.75-120-120s53.75-120 120-120s120 53.75 120 120C311.9 386.2 258.3 439.9 192 440zM150.6 308.8c-6.251-6.25-16.38-6.25-22.63 0L116.6 320c-6.251 6.25-6.251 16.38 0 22.62l52.75 52.62c6.251 6.25 16.38 6.25 22.63 0L203.3 384c6.251-6.25 6.251-16.38 0-22.62L150.6 308.8z"],
    "bank": [512, 512, ["institution", "university"], "f19c", "M488 464H24C10.8 464 0 474.8 0 488C0 501.2 10.8 512 24 512h464c13.2 0 24-10.8 24-24C512 474.8 501.2 464 488 464zM456 432c13.2 0 24-10.8 24-24c0-13.2-10.8-24-24-24H56C42.8 384 32 394.8 32 408c0 13.2 10.8 24 24 24H456zM497.2 97.81l-232-96c-5.875-2.438-12.47-2.438-18.34 0l-232 96C5.844 101.5 0 110.3 0 120v64C0 197.3 10.75 208 24 208H64V352h48V208h64V352H224V208h64V352h48V208h64V352H448V208h40C501.3 208 512 197.3 512 184v-64C512 110.3 506.2 101.5 497.2 97.81zM464 160h-162.9C302.8 154.1 304 149.6 304 144C304 117.5 282.5 96 256 96S208 117.5 208 144c0 5.641 1.15 10.97 2.938 16H48V136L256 49.97l208 86.06V160z"],
    "barcode": [512, 512, [], "f02a", "M111.1 32c-8.799 0-15.1 7.201-15.1 15.1v416C95.1 472.8 103.2 480 111.1 480c8.799 0 16-7.201 16-15.1V47.1C127.1 39.2 120.8 32 111.1 32zM24 32C10.8 32 0 42.8 0 55.1v400C0 469.2 10.8 480 23.1 480S48 469.2 48 456V55.1C48 42.8 37.2 32 24 32zM415.1 32C407.2 32 400 39.2 400 47.1V464C400 472.8 407.2 480 415.1 480s15.1-7.199 15.1-15.1V47.1C431.1 39.2 424.8 32 415.1 32zM296 32c-13.2 0-24 10.8-24 23.1V456C272 469.2 282.8 480 296 480S320 469.2 320 456v-400C320 42.8 309.2 32 296 32zM488 32c-13.2 0-24 10.8-24 23.1V456C464 469.2 474.8 480 488 480c13.2 0 24-10.8 24-24v-400C512 42.8 501.2 32 488 32zM184 32C170.8 32 160 42.8 160 55.1v400C160 469.2 170.8 480 183.1 480C197.2 480 208 469.2 208 456V55.1C208 42.8 197.2 32 184 32z"],
    "barcode-read": [576, 512, [], "f464", "M136 0H32C14.33 0 0 14.33 0 32v104C0 149.3 10.75 160 24 160S48 149.3 48 136V48h88C149.3 48 160 37.25 160 24S149.3 0 136 0zM136 464H48v-88C48 362.8 37.25 352 24 352S0 362.8 0 376V480c0 17.67 14.33 32 32 32h104C149.3 512 160 501.3 160 488S149.3 464 136 464zM552 352c-13.25 0-24 10.75-24 24v88h-88c-13.25 0-24 10.75-24 24S426.8 512 440 512H544c17.67 0 32-14.33 32-32v-104C576 362.8 565.3 352 552 352zM544 0h-104C426.8 0 416 10.75 416 24s10.75 24 24 24h88v88C528 149.3 538.8 160 552 160S576 149.3 576 136V32C576 14.33 561.7 0 544 0zM120 384c13.2 0 24-10.8 24-23.1V151.1C144 138.8 133.2 128 120 128c-13.2 0-24 10.8-24 23.1v208C96.01 373.2 106.8 384 120 384zM480 368V143.1C480 135.2 472.8 128 464 128c-8.799 0-15.1 7.2-15.1 15.1v224C448 376.8 455.2 384 464 384C472.8 384 480 376.8 480 368zM416 151.1C416 138.8 405.2 128 392 128s-24 10.8-24 23.1v208c0 13.2 10.8 23.1 23.1 23.1s24-10.8 24-23.1V151.1zM192 128C183.2 128 176 135.2 176 143.1v224C176 376.8 183.2 384 192 384c8.799 0 15.1-7.199 15.1-15.1V143.1C208 135.2 200.8 128 192 128zM264 128c-13.2 0-24 10.8-24 23.1v208C240 373.2 250.8 384 264 384s23.98-10.8 23.98-24V151.1C288 138.8 277.2 128 264 128z"],
    "barcode-scan": [640, 512, [], "f465", "M616 232h-592C10.75 232 0 242.7 0 255.1C0 269.3 10.75 280 23.1 280h592C629.3 280 640 269.3 640 256C640 242.8 629.3 232 616 232zM272 55.1C272 42.8 261.2 32 248 32C234.8 32 224 42.8 224 55.1V192h48V55.1zM384 55.1C384 42.8 373.2 32 360 32S336 42.8 336 55.1V192H384V55.1zM191.1 47.1C191.1 39.2 184.8 32 175.1 32c-8.799 0-15.1 7.201-15.1 15.1V192h31.1L191.1 47.1zM495.1 47.1C495.1 39.2 488.8 32 479.1 32S464 39.2 464 47.1V192h31.1V47.1zM112 55.1C112 42.8 101.2 32 88 32S64 42.8 64 55.1V192h48V55.1zM576 55.1C576 42.8 565.2 32 552 32c-13.2 0-24 10.8-24 23.1V192H576V55.1zM464 464C464 472.8 471.2 480 479.1 480s15.1-7.199 15.1-15.1V320H464V464zM528 456C528 469.2 538.8 480 552 480c13.2 0 24-10.8 24-24V320h-48V456zM64 456C64 469.2 74.8 480 87.1 480S112 469.2 112 456V320H64V456zM336 456C336 469.2 346.8 480 360 480S384 469.2 384 456V320h-48V456zM224 456C224 469.2 234.8 480 247.1 480C261.2 480 272 469.2 272 456V320H224V456zM159.1 464C159.1 472.8 167.2 480 175.1 480c8.799 0 16-7.201 16-15.1L191.1 320H159.1V464z"],
    "bars": [448, 512, ["navicon"], "f0c9", "M424 392H23.1C10.8 392 0 402.8 0 415.1C0 429.2 10.8 440 23.1 440H424c13.2 0 24-10.8 24-23.1C448 402.8 437.2 392 424 392zM424 72H23.1C10.8 72 0 82.8 0 95.1S10.8 120 23.1 120H424c13.2 0 24-10.8 24-23.1S437.2 72 424 72zM424 232H23.1C10.8 232 0 242.8 0 256c0 13.2 10.8 24 23.1 24H424C437.2 280 448 269.2 448 256S437.2 232 424 232z"],
    "bars-filter": [448, 512, [], "e0ad", "M264 392H183.1C170.8 392 160 402.8 160 415.1C160 429.2 170.8 440 183.1 440h80C277.2 440 288 429.2 288 416C288 402.8 277.2 392 264 392zM424 72H23.1C10.8 72 0 82.8 0 95.1S10.8 120 23.1 120H424c13.2 0 24-10.8 24-23.1S437.2 72 424 72zM360 232H87.1C74.8 232 64 242.8 64 255.1C64 269.2 74.8 280 87.1 280h272C373.2 280 384 269.2 384 256C384 242.8 373.2 232 360 232z"],
    "bars-progress": [512, 512, ["tasks-alt"], "f828", "M488 32H24C10.75 32 0 44 0 59v74C0 148 10.75 160 24 160h464C501.3 160 512 148 512 133v-74C512 44 501.3 32 488 32zM464 112H352v-32h112V112zM488 352H24C10.75 352 0 364 0 379v74C0 468 10.75 480 24 480h464c13.25 0 24-12 24-27v-74C512 364 501.3 352 488 352zM464 432H288v-32h176V432zM488 192H24C10.75 192 0 204 0 219v74C0 308 10.75 320 24 320h464C501.3 320 512 308 512 293v-74C512 204 501.3 192 488 192zM464 272H160v-32h304V272z"],
    "bars-sort": [448, 512, [], "e0ae", "M168 392H23.1C10.8 392 0 402.8 0 415.1C0 429.2 10.8 440 23.1 440H168C181.2 440 192 429.2 192 416C192 402.8 181.2 392 168 392zM424 72H23.1C10.8 72 0 82.8 0 95.1S10.8 120 23.1 120H424c13.2 0 24-10.8 24-23.1S437.2 72 424 72zM296 232H23.1C10.8 232 0 242.8 0 255.1C0 269.2 10.8 280 23.1 280h272C309.2 280 320 269.2 320 256C320 242.8 309.2 232 296 232z"],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", "M424 392H23.1C10.8 392 0 402.8 0 415.1C0 429.2 10.8 440 23.1 440H424C437.2 440 448 429.2 448 416C448 402.8 437.2 392 424 392zM424 72H23.1C10.8 72 0 82.8 0 95.1S10.8 120 23.1 120H424C437.2 120 448 109.2 448 96S437.2 72 424 72zM488 232H87.1C74.8 232 64 242.8 64 256c0 13.2 10.8 24 23.1 24H488C501.2 280 512 269.2 512 256S501.2 232 488 232z"],
    "baseball": [512, 512, [129358, 62515, "baseball-ball"], "26be", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM296.2 460c.2572-10.46 .4785-9.2 .4785-11.59c0-9.1-7.065-23.92-23.93-23.92c-12.19 0-22.93 9.427-23.97 21.99c-.4824 5.68-.709 11.39-.7246 17.09c-108.3-4.133-195.5-91.28-199.6-199.6c.0576-.0001 2.753 .0141 4.242 .0141c13.51 0 36.8-1.172 36.8-24.77c0-20.41-19.61-24.03-24.02-24.03c-2.217 0-2.762 .2998-7.163 .2998c-1.799 0-6.237-.0479-6.242-.0479c16.33-82.37 81.41-147.3 163.8-163.5c-.2805 11.19-.537 10.04-.537 12.56c0 9.258 7.257 23.97 24.03 23.97c12.34 0 22.81-9.469 23.88-21.97c.5156-6.031 .7715-12.06 .7871-18.12C372.5 52.56 459.7 140 463.6 248.5C461.1 248.5 458.6 248.5 456 248.5c-4.246 0-8.501 .1193-12.77 .5449c-12.38 1.203-21.65 11.63-21.65 23.82c0 9.07 6.946 24.1 23.5 24.1c2.526 0 3.033-.3976 8.46-.3976c1.867 0 6.401 .0441 6.405 .0441C443.6 378.9 378.6 443.8 296.2 460zM246.2 128.9c0-6.546-5.204-24-23.93-24c-9.054 0-17.78 5.135-21.86 13.91c-38.11 82.29-94.79 70.25-94.79 103c0 18.71 17.12 24 24.04 24C161.7 245.8 246.2 163.6 246.2 128.9zM381.5 266.6c-32.27 0-116.1 82.71-116.1 117.5c0 6.58 5.254 24 24 24c9.094 0 17.78-5.188 21.81-14.03c37.75-82.56 94.25-70.68 94.25-103.4C405.5 271.9 388.4 266.6 381.5 266.6z"],
    "baseball-bat-ball": [640, 512, [], "f432", "M512 320c-52.88 0-96 43.13-96 96s43.13 96 96 96s96-43.13 96-96S564.9 320 512 320zM511.1 464c-26.51 0-48.02-21.51-48.02-48.02s21.51-48.03 48.02-48.03c26.51 0 48.02 21.52 48.02 48.03S538.5 464 511.1 464zM640 98.65c0-15.41-4.592-30.84-14.41-44.24L608.8 32.41c-15.95-21.76-39.98-32.41-64.11-32.41c-16.91 0-33.87 5.23-48.14 15.53L308.7 152.2c-48 34.63-92 73.27-130.1 117.8c-54.75 62.64-106 101.3-135.5 122.5c-4.816-5.524-11.56-8.4-18.36-8.4c-5.205 0-10.45 1.683-14.89 5.15c-5.882 4.735-8.965 11.73-8.965 18.78c0 5.23 1.7 10.48 5.215 14.85l64 80.02c4.592 5.758 11.65 9.008 18.89 9.008c5.178 0 10.45-1.662 14.99-5.258c5.74-4.654 8.641-11.38 8.641-18.21c0-4.173-1.084-8.382-3.266-12.18c29.12-21 81.88-56.63 155.1-88.02c54.75-23 106.5-52.13 154.6-86.89l185.9-135.4C627.3 149.8 640 124.2 640 98.65zM589.2 101.3c0 9.955-4.579 19.95-13.27 26.98l-185.1 135.6c-75 52.76-136.4 76.02-161.6 87.64L202.1 314.5c18.88-20.25 59.75-69.26 134.8-123.4l187.9-136.3c5.76-4.16 12.84-6.386 19.94-6.386c9.538 0 19.11 4.018 25.56 12.76l13 21.51C587.3 88.31 589.2 94.81 589.2 101.3z"],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", "M552 192l-136.5-.0046l-56.65-175.4c-4.062-12.59-17.58-19.53-30.22-15.47c-12.61 4.078-19.53 17.59-15.47 30.22l51.81 160.6H211L262.8 31.38c4.062-12.62-2.859-26.14-15.47-30.22C234.8-2.885 221.2 4.036 217.2 16.63L160.5 191.1L24 192c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1h18.85l45.6 214.9C95.47 488 125.1 512 158.9 512h258.2c33.8 0 63.42-23.1 70.44-57.06l45.6-214.9H552c13.25 0 24-10.75 24-23.1C576 202.8 565.3 192 552 192zM440.6 444.1c-2.328 11.03-12.2 19.03-23.47 19.03H158.9c-11.27 0-21.14-7.1-23.47-19.03L91.94 240h53.16l-7.943 24.62C133.1 277.3 140 290.8 152.6 294.8C155.1 295.6 157.6 296 160 296c10.14 0 19.56-6.469 22.84-16.62l12.7-39.37h184.9l12.7 39.37C396.4 289.5 405.9 296 416 296c2.438 0 4.922-.375 7.375-1.156c12.61-4.078 19.53-17.59 15.47-30.22l-7.943-24.62h53.16L440.6 444.1zM224 319.1v87.1c0 8.844-7.156 15.1-16 15.1S192 416.8 192 407.1V319.1c0-8.844 7.156-15.1 16-15.1S224 311.2 224 319.1zM304 319.1v87.1c0 8.844-7.156 15.1-16 15.1s-16-7.156-16-15.1V319.1c0-8.844 7.156-15.1 16-15.1S304 311.2 304 319.1zM384 319.1v87.1c0 8.844-7.156 15.1-16 15.1S352 416.8 352 407.1V319.1c0-8.844 7.156-15.1 16-15.1S384 311.2 384 319.1z"],
    "basket-shopping-simple": [576, 512, ["shopping-basket-alt"], "e0af", "M552 192l-136.5-.0046l-56.65-175.4c-4.062-12.59-17.58-19.53-30.22-15.47c-12.61 4.078-19.53 17.59-15.47 30.22l51.81 160.6H211L262.8 31.38c4.062-12.62-2.859-26.14-15.47-30.22C234.8-2.885 221.2 4.036 217.2 16.63L160.5 191.1L24 192c-13.25 0-24 10.75-24 23.1C0 229.3 10.75 240 24 240h18.85l45.6 214.9C95.47 488 125.1 512 158.9 512h258.2c33.8 0 63.42-23.1 70.44-57.06L533.1 240H552C565.3 240 576 229.3 576 216C576 202.8 565.3 192 552 192zM440.6 444.1c-2.328 11.03-12.2 19.03-23.47 19.03H158.9c-11.27 0-21.14-7.1-23.47-19.03L91.94 240h53.16l-7.943 24.63C133.1 277.3 140 290.8 152.6 294.8C155.1 295.6 157.6 296 160 296c10.14 0 19.56-6.469 22.84-16.62L195.5 240h184.9l12.7 39.38C396.4 289.5 405.9 296 416 296c2.438 0 4.922-.375 7.375-1.156c12.61-4.078 19.53-17.59 15.47-30.22L430.9 240h53.16L440.6 444.1z"],
    "basketball": [512, 512, [62516, "basketball-ball"], "1f3c0", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM464 256c0 .1816-.0273 .3574-.0273 .5391C461.3 256.4 458.7 256 456 256c-46.5 0-89.24 16.09-123.3 42.81L289.9 256l128.1-128.1C447 162.5 464 207.3 464 256zM304 456c0-33.25 11.04-63.79 29.22-88.84l51.73 51.73c-23.4 18.56-50.85 32.11-80.81 39.25C304.1 457.4 304 456.7 304 456zM384.1 93.11L256 222.1L213.2 179.3C239.9 145.2 256 102.5 256 56c0-2.705-.4336-5.293-.5391-7.973C255.6 48.03 255.8 48 256 48C304.7 48 349.5 64.95 384.1 93.11zM127 93.11c23.4-18.56 50.85-32.11 80.81-39.25C207.9 54.58 208 55.27 208 56c0 33.25-11.04 63.79-29.22 88.84L127 93.11zM93.11 127L144.8 178.8C119.8 196.1 89.25 208 56 208c-.7285 0-1.422-.1367-2.148-.1465C60.99 177.9 74.54 150.4 93.11 127zM48 256c0-.1816 .0273-.3574 .0273-.5391C50.71 255.6 53.29 256 56 256c46.5 0 89.24-16.09 123.3-42.81L222.1 256l-128.1 128.1C64.95 349.5 48 304.7 48 256zM127 418.9L256 289.9l42.81 42.81C272.1 366.8 256 409.5 256 456c0 2.705 .4336 5.293 .5391 7.973C256.4 463.1 256.2 464 256 464C207.3 464 162.5 447 127 418.9zM418.9 384.1l-51.73-51.73C392.2 315 422.7 304 456 304c.7285 0 1.422 .1367 2.148 .1465C451 334.1 437.5 361.6 418.9 384.1z"],
    "basketball-hoop": [640, 512, [], "f435", "M320 0C102.1 0 0 169.8 0 208.1v118c0 25.43 15.05 48.44 38.35 58.63l84.6 37.01l-6.441-55.21l-58.92-25.78C51.76 338.3 48 332.5 48 326.1V208.1C48 182.4 145.9 48 320 48c175.9 0 272 135.1 272 160.1v118c0 6.357-3.764 12.11-9.586 14.66l-58.92 25.78l-6.441 55.21l84.6-37.01C624.9 374.6 640 351.6 640 326.1V208.1C640 167.8 534.1 0 320 0zM528 264C528 250.7 517.3 240 504 240H135.1C122.7 240 112 250.7 112 263.1S122.7 288 135.1 288h7.67l24.46 206.6c.3141 2.636 3.943 17.43 19.87 17.43c5.375 0 10.66-2.152 14.5-6.125l51.5-53.42l51.5 53.42C309.3 509.8 314.5 512 320 512s10.72-2.217 14.5-6.129l51.5-53.42l51.5 53.42C441.3 509.8 446.6 512 452 512c15.93 0 19.56-14.79 19.88-17.43L496.3 288h7.67C517.3 288 528 277.3 528 264zM357.3 288L320 326.7L282.7 288H357.3zM187.1 314.1L183.1 288h35.15L187.1 314.1zM202.9 448.2L196.3 392.6l30.08 31.2L202.9 448.2zM253.1 395.2L208.1 348.5l42.34-35.76l41.09 42.63L253.1 395.2zM320 463.7L281.6 423.8L320 383.1l38.41 39.85L320 463.7zM347.6 355.4l41.09-42.63l42.34 35.76l-45.02 46.71L347.6 355.4zM437.1 448.2l-23.5-24.38l30.08-31.2L437.1 448.2zM452.9 314.1L420.9 288h35.15L452.9 314.1zM480 208V168C480 145.9 462.1 128 440 128h-240C177.9 128 160 145.9 160 168V208h48v-32h224v32H480z"],
    "bat": [640, 512, [], "f6b5", "M638.6 287.2L568.2 129.8c-5.375-12.38-17.75-19.5-30.62-19.5c-5.75 0-11.75 1.5-17.12 4.625l-104.9 60.37L383.1 64l-58.12 48H314.1L255.1 64L224.4 175.2L119.5 114.9c-5.25-3-11.12-4.625-17.12-4.625c-12.87 0-25.25 7.125-30.62 19.5L1.375 287.2c-4.875 11 3.879 22.38 15.25 22.38c1.75 0 3.496-.25 5.371-.875L38.5 303.5c6.75-2.25 13.87-3.375 20.1-3.375c21.87 0 42.87 10.38 55.5 28.5L153.4 384l12.37-11.88c12.1-12.5 30.12-18.75 46.1-18.75c20.12 0 40.12 8.75 53.37 25.62L319.1 448l53.87-69c13.25-16.88 33.25-25.62 53.37-25.62c16.87 0 33.1 6.25 46.1 18.75L486.6 384l38.37-55.38c12.62-18.12 33.62-28.5 55.5-28.5c6.1 0 14.12 1.125 20.1 3.375l16.5 5.25c1.875 .4999 3.625 .875 5.375 .875C634.7 309.6 643.5 298.2 638.6 287.2zM485.6 301.2l-10.12 14.5c-14.1-6.75-31.37-10.38-48.25-10.38c-36.12 0-69.37 16.12-91.25 44.13L320 370L304 349.5c-21.87-28-55.12-44.13-91.25-44.13c-16.87 0-33.37 3.625-48.25 10.38l-10.12-14.5c-19.5-28-50.75-45.75-84.1-48.62l39.5-88.5l144.9 83.5L282.1 147.8L296.9 160h46.25l14.75-12.25l28.37 99.87l144.9-83.5l39.5 88.5C536.4 255.5 505.1 273.2 485.6 301.2z"],
    "bath": [512, 512, [62157, "bathtub"], "1f6c1", "M488 256.1H80V69.36c0-8.623 5.25-16.37 13.12-19.62c8-3.25 17.12-1.5 23.12 4.623l3.162 3.162C106.4 84.63 110.9 117.1 133.4 140.5l14.84 14.85c-5.936 9.285-5.281 21.56 2.834 29.67C155.7 189.7 161.9 192 168 192s12.28-2.344 16.97-7.031l96-96c9.375-9.375 9.375-24.56 0-33.94c-4.562-4.562-10.44-6.768-16.36-6.766c-4.609 0-9.246 1.334-13.31 3.932L236.5 37.35C213.1 14.86 180.5 10.42 153.4 23.49L151.9 22.01C136.4 6.529 114.8-2.289 93.04 .5156C57.11 5.158 32 35.21 32 69.36v186.7L24 256.1c-13.25 0-24 10.71-24 23.96s10.75 24.02 24 24.02H32v79.96c0 27.12 11.75 52.97 32 71.09v32.9C64 501.3 74.75 512 88 512s24-10.74 24-23.99v-9.623c5.25 1 10.62 1.495 16 1.62h256c5.375-.125 10.75-.6198 16-1.62v9.623C400 501.3 410.7 512 424 512S448 501.3 448 488v-32.9c20.25-18.12 32-43.97 32-71.09V304.1h8c13.25 0 24-10.77 24-24.02S501.3 256.1 488 256.1zM202.5 71.29l14.13 14.13L181.4 120.6L167.3 106.5C157.6 96.8 157.6 81 167.3 71.29C177 61.57 192.8 61.55 202.5 71.29zM432 384c0 26.49-21.5 47.99-48 47.99H128c-26.5 0-48-21.49-48-47.99V304.1h352V384z"],
    "battery-bolt": [576, 512, [], "f376", "M48 352V160c0-8.822 7.178-16 16-16h106.6L212.9 96H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h73.87l17.29-48H64C55.18 368 48 360.8 48 352zM544 192V160c0-35.35-28.65-64-64-64h-73.87l-17.29 48H480c8.822 0 16 7.178 16 16v192c0 8.822-7.178 16-16 16h-106.6L331.1 416H480c35.35 0 64-28.65 64-64v-32c17.67 0 32-14.33 32-32V224C576 206.3 561.7 192 544 192zM397.9 246.1C393.1 237.5 385.4 232 376 232h-69.84l60.44-167.9c3.906-10.84-.4687-22.92-10.38-28.78c-9.906-5.844-22.59-3.875-30.25 4.797l-176 200C143.8 247.2 142.3 257.3 146.1 265.9C149.1 274.5 158.6 280 168 280h69.84l-60.44 167.9c-3.906 10.84 .4687 22.92 10.38 28.78C191.6 478.9 195.8 480 200 480c6.688 0 13.31-2.812 18.03-8.141l176-200C400.3 264.8 401.8 254.7 397.9 246.1z"],
    "battery-empty": [576, 512, ["battery-0"], "f244", "M544 192V160c0-35.35-28.65-64-64-64H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h416c35.35 0 64-28.65 64-64v-32c17.67 0 32-14.33 32-32V224C576 206.3 561.7 192 544 192zM496 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V160c0-8.822 7.178-16 16-16h416c8.822 0 16 7.178 16 16V352z"],
    "battery-exclamation": [576, 512, [], "e0b0", "M48 352V160c0-8.822 7.178-16 16-16h136V96H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h128c0-18.06 6.197-34.59 16.32-48H64C55.18 368 48 360.8 48 352zM544 192V160c0-35.35-28.65-64-64-64h-136v48H480c8.822 0 16 7.178 16 16v192c0 8.822-7.178 16-16 16h-144.3C345.8 381.4 352 397.9 352 416h128c35.35 0 64-28.65 64-64v-32c17.67 0 32-14.33 32-32V224C576 206.3 561.7 192 544 192zM272 336c13.26 0 24-10.75 24-24v-224C296 74.74 285.3 64 272 64S248 74.74 248 88v224C248 325.3 258.7 336 272 336zM272 384c-17.64 0-32 14.35-32 32C240 433.6 254.4 448 272 448s32-14.36 32-31.1C304 398.4 289.6 384 272 384z"],
    "battery-full": [576, 512, [62016, "battery", "battery-5"], "1f50b", "M96 320h352V192H96V320zM544 192V160c0-35.35-28.65-64-64-64H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h416c35.35 0 64-28.65 64-64v-32c17.67 0 32-14.33 32-32V224C576 206.3 561.7 192 544 192zM496 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V160c0-8.822 7.178-16 16-16h416c8.822 0 16 7.178 16 16V352z"],
    "battery-half": [576, 512, ["battery-3"], "f242", "M96 320h192V192H96V320zM544 192V160c0-35.35-28.65-64-64-64H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h416c35.35 0 64-28.65 64-64v-32c17.67 0 32-14.33 32-32V224C576 206.3 561.7 192 544 192zM496 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V160c0-8.822 7.178-16 16-16h416c8.822 0 16 7.178 16 16V352z"],
    "battery-low": [576, 512, ["battery-1"], "e0b1", "M96 320h48V192H96V320zM544 192V160c0-35.35-28.65-64-64-64H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h416c35.35 0 64-28.65 64-64v-32c17.67 0 32-14.33 32-32V224C576 206.3 561.7 192 544 192zM496 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V160c0-8.822 7.178-16 16-16h416c8.822 0 16 7.178 16 16V352z"],
    "battery-quarter": [576, 512, ["battery-2"], "f243", "M96 320h96V192H96V320zM544 192V160c0-35.35-28.65-64-64-64H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h416c35.35 0 64-28.65 64-64v-32c17.67 0 32-14.33 32-32V224C576 206.3 561.7 192 544 192zM496 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V160c0-8.822 7.178-16 16-16h416c8.822 0 16 7.178 16 16V352z"],
    "battery-slash": [640, 512, [], "f377", "M630.8 469.1l-82.38-64.58C565.1 392.1 576 373.8 576 352l.0247-31.1c17.67 0 31.1-14.33 31.1-32V224c0-17.67-14.33-32-31.1-32L576 160c0-35.35-28.65-64-64-64H154.8L38.81 5.12C34.41 1.682 29.19 .0105 24.03 .0105c-7.125 0-14.19 3.156-18.91 9.187c-8.188 10.44-6.375 25.53 4.062 33.7l591.1 463.1c10.5 8.203 25.56 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1zM528 352c0 8.822-7.178 16-16 16h-10.18l-285.8-224H512c8.822 0 16 7.178 16 16V352zM96 368c-8.822 0-16-7.178-16-16V160c0-.1875 .1016-.3398 .1074-.5254l-39.5-30.97c-5.318 9.332-8.583 19.99-8.583 31.5v192c0 35.35 28.65 64 63.1 64L407.4 416l-61.25-48H96z"],
    "battery-three-quarters": [576, 512, ["battery-4"], "f241", "M96 320h256V192H96V320zM544 192V160c0-35.35-28.65-64-64-64H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h416c35.35 0 64-28.65 64-64v-32c17.67 0 32-14.33 32-32V224C576 206.3 561.7 192 544 192zM496 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V160c0-8.822 7.178-16 16-16h416c8.822 0 16 7.178 16 16V352z"],
    "bed": [640, 512, [62006], "1f6cc", "M168 304C216.5 304 256 264.5 256 216S216.5 128 168 128S80 167.5 80 216S119.5 304 168 304zM168 176c21.1 0 40 18 40 40C208 238 189.1 256 168 256C145.1 256 128 238 128 216C128 194 145.1 176 168 176zM528 128h-224C295.2 128 288 135.2 288 144v192H48v-280C48 42.75 37.25 32 24 32S0 42.75 0 55.1V456C0 469.3 10.75 480 23.1 480S48 469.3 48 456V384h544v72C592 469.3 602.7 480 616 480S640 469.3 640 456V240C640 178.1 589.9 128 528 128zM592 336h-256v-160h192c35.25 0 64 28.75 64 64V336z"],
    "bed-bunk": [576, 512, [], "f8f8", "M152 144C191.8 144 224 111.8 224 72S191.8 0 152 0S80 32.25 80 72S112.2 144 152 144zM152 48c13.25 0 24 10.75 24 24S165.2 96 152 96S128 85.25 128 72S138.8 48 152 48zM464 0h-192C263.2 0 256 7.163 256 16V160H48v-136C48 10.75 37.25 0 24 0S0 10.75 0 23.1V488C0 501.3 10.75 512 23.1 512S48 501.3 48 488V464h480v24C528 501.3 538.7 512 552 512S576 501.3 576 488V128C576 50.12 525.9 0 464 0zM528 416h-224V304h160c35.38 0 64 28.62 64 64V416zM528 276.2C509.3 263.1 486.9 256 464 256h-192C263.1 256 256 263.1 256 272V416H48V208h480V276.2zM528 160h-224V48h160c35.38 0 64 28.62 64 64V160zM152 400C191.8 400 224 367.8 224 328S191.8 256 152 256S80 288.2 80 328S112.2 400 152 400zM152 304c13.25 0 24 10.75 24 24S165.2 352 152 352S128 341.2 128 328S138.8 304 152 304z"],
    "bed-empty": [640, 512, [63737], "1f6cf", "M528 160h-480V56C48 42.74 37.25 32 24 32S0 42.74 0 56v400C0 469.3 10.75 480 24 480s24-10.75 24-24V384h544v72c0 13.25 10.75 24 24 24S640 469.3 640 456V272C640 210.1 589.9 160 528 160zM592 336h-544v-128h480c35.25 0 64 28.75 64 64V336z"],
    "bed-front": [512, 512, ["bed-alt"], "f8f7", "M80 160c0-17.6 14.4-32 32-32h96c17.6 0 32 14.4 32 32v32h32V160c0-17.6 14.4-32 32-32h96c17.6 0 32 14.4 32 32v32H480V96c0-35.2-28.8-64-64-64H96C60.8 32 32 60.8 32 96v96h48V160zM448 224H64C28.65 224 0 252.7 0 288v168C0 469.3 10.75 480 23.1 480S48 469.3 48 456V416h416v40C464 469.3 474.7 480 488 480S512 469.3 512 456V288C512 252.7 483.3 224 448 224zM464 368h-416V288c0-8.875 7.125-16 16-16h384c8.875 0 16 7.125 16 16V368z"],
    "bed-pulse": [640, 512, ["procedures"], "f487", "M216 95.98h121.8l41.19 75.51C383.1 179.2 391.2 184 400 184L400.7 184c9.031-.2813 17.14-5.587 21-13.78l49.45-105.1l23.86 23.85C499.5 93.45 505.6 95.98 512 95.98h104c13.25 0 24-10.74 24-23.99s-10.75-24.02-24-24.02h-94.06l-40.97-40.98c-5.516-5.532-13.38-7.908-21.09-6.689c-7.703 1.344-14.27 6.405-17.59 13.47l-43.86 93.21l-25.36-46.51C368.9 52.79 360.8 47.98 352 47.98H216c-13.25 0-24 10.76-24 24.02S202.8 95.98 216 95.98zM168 336C216.5 336 256 296.5 256 248S216.5 160 168 160S80 199.5 80 248S119.5 336 168 336zM168 208c21.1 0 40 18 40 40S189.1 288 168 288C145.1 288 128 270 128 248S145.1 208 168 208zM528 160h-40c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24h40c35.2 0 64 28.8 64 64v96h-256V184C336 170.7 325.3 160 312 160S288 170.7 288 184v184H48V88C48 74.74 37.25 64 24 64S0 74.74 0 88v400C0 501.3 10.75 512 24 512s24-10.75 24-24V416h544v72c0 13.25 10.75 24 24 24S640 501.3 640 488V272C640 210.1 589.9 160 528 160z"],
    "bee": [576, 512, [], "e0b2", "M448 95.1c-27.73 0-55.34 9.451-80.73 22.73C367.5 116.4 368 114.3 368 111.1c0-20.4-7.832-38.84-20.4-52.97l31.71-31.71c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-34.99 34.99C311.4 34.88 300.1 31.1 288 31.1S264.6 34.88 254.3 39.68L219.3 4.688c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L228.4 58.99C215.8 73.12 208 91.6 208 111.1c0 2.342 .4805 4.438 .6777 6.727C183.3 105.4 155.7 95.1 128 95.1C57.34 95.1 0 146.1 0 207.1C0 269.8 57.28 320 127.1 320C134.8 320 141.8 319.2 148.7 318.2C162.5 417.7 288 512 288 512s125.5-94.34 139.3-193.8C434.2 319.2 441.1 320 448 320c70.66 0 128-50.13 128-111.1C576 146.2 518.7 95.99 448 95.1zM195.6 304h184.8c-.4375 10.4-3.008 21.14-7.146 32H202.7C198.6 325.1 196 314.4 195.6 304zM207.2 256c4.152-7.475 8.984-14.61 15.2-20.82C239.9 217.7 263.2 208 287.9 208s48.18 9.652 65.7 27.18C359.9 241.4 364.7 248.5 368.8 256H207.2zM151.2 268.6C143.4 270.6 135.6 272 127.1 272C83.87 272 48 243.3 48 207.1C48 172.7 83.87 144 127.1 144c29.16 0 61.19 16.16 89.06 35.83C184.3 199 160.1 230.7 151.2 268.6zM288 449.1C269.4 431.9 247.4 408.9 229.5 384h116.9C328.6 408.9 306.6 431.9 288 449.1zM448 272c-7.586 0-15.38-1.363-23.23-3.367c-8.891-37.93-33.12-69.59-65.79-88.8C386.9 160.2 418.8 144 448 144c44.08 0 80 28.69 80 64.04C528 243.3 492.1 272 448 272z"],
    "beer-mug": [512, 512, ["beer-foam"], "e0b3", "M423.1 156.7h-40V144.1c13.61-18.82 19.01-42.45 14.25-65.9c-6.141-30.26-28.99-54.6-58.18-62.04c-21.27-5.447-43.1-2.119-61.4 9.354c-3.735 2.371-5.641 .5332-6.36-.1562C237.3-8.461 178.6-8.43 143.7 25.32C142.1 26.02 141.1 27.84 137.3 25.49C118.9 14.03 97.15 10.7 75.9 16.15C46.69 23.59 23.84 47.93 17.7 78.19C12.94 101.6 18.34 125.3 31.95 144.1V432c0 44.18 35.82 80 80.01 80h192c39.44 0 72.03-28.59 78.61-66.14l76.66-34.39C491.3 397.5 512 365.8 512 330.8V244.7C512 196.1 472.6 156.7 423.1 156.7zM335.1 432c0 17.67-14.33 32-32 32H111.1c-17.68 0-32-14.33-32-32V174.1c20.49 4.258 42.44 1.004 60.16-11.18c.6563 .0781 2.094 .6113 3.516 1.994C161.1 182.7 183.1 192 207.1 192c24.02 0 46.84-9.309 64.3-26.23c1.641-1.57 3.25-2.041 3.25-2.182c17.78 12.33 39.85 15.64 60.44 11.37V432zM344.3 117.5c-10.13 12.46-28.6 15.33-41.48 6.404c-19.36-13.47-45.6-10.52-63.84 7.141c-16.97 16.42-45.06 16.42-62.06 0C166.4 120.8 153.1 115.5 139.1 115.5c-9.438 0-18.77 2.762-26.88 8.381c-12.86 8.914-31.33 6.027-41.48-6.404C64.97 109.3 62.52 98.77 64.74 87.83C67.15 75.96 76.58 65.71 87.7 62.89c10.89-2.73 19.18 .4082 24.18 3.531c21.29 13.28 47.43 10.75 65.09-6.357c16.94-16.38 45.04-16.42 62.04 .0313c17.71 17.09 43.84 19.56 65.04 6.326c5.047-3.123 13.35-6.277 24.21-3.531c11.1 2.824 20.54 13.07 22.94 24.94C353.4 98.77 350.1 109.3 344.3 117.5zM463.1 330.8c0 15.89-9.407 30.28-23.97 36.66L383.1 392V204.7h40c22.06 0 40 17.94 40 40V330.8zM159.1 240l-.0274 168c0 8.844-7.157 16-16 16s-16-7.156-16-16L127.1 240c0-8.844 7.157-16 16-16C152.8 224 159.1 231.2 159.1 240zM223.1 240l-.0224 168c0 8.844-7.157 16-16 16s-16-7.156-16-16L191.1 240c0-8.844 7.157-16 16-16S223.1 231.2 223.1 240zM287.1 240l-.0174 168c0 8.844-7.157 16-16 16s-16-7.156-16-16L255.1 240c0-8.844 7.157-16 16-16S287.1 231.2 287.1 240z"],
    "beer-mug-empty": [512, 512, ["beer"], "f0fc", "M424 96H384V64c0-17.67-14.33-32-32-32H64C46.33 32 32 46.33 32 64v336C32 444.2 67.82 480 112 480h192c44.18 0 80-35.82 80-80v-16.08l75.26-33.15C491.3 336.8 512 305.1 512 270.1V184C512 135.4 472.6 96 424 96zM336 400c0 17.67-14.33 32-32 32h-192c-17.67 0-32-14.33-32-32v-320h256V400zM464 270.1c0 15.89-9.406 30.28-23.97 36.66L384 331.3V144h40c22.06 0 40 17.94 40 40V270.1zM128 368v-224C128 135.2 135.2 128 144 128S160 135.2 160 144v224C160 376.8 152.8 384 144 384S128 376.8 128 368zM192 368v-224C192 135.2 199.2 128 208 128S224 135.2 224 144v224C224 376.8 216.8 384 208 384S192 376.8 192 368zM256 368v-224C256 135.2 263.2 128 272 128S288 135.2 288 144v224c0 8.844-7.156 16-16 16S256 376.8 256 368z"],
    "bell": [448, 512, [61683, 61602], "1f514", "M439.4 362.3C420.1 341.5 383.9 310.2 383.9 208c0-77.75-54.38-139.9-127.9-155.1V32c0-17.62-14.38-32-32-32S192 14.38 192 32v20.88C118.5 68.12 64.13 130.2 64.13 208c0 102.2-36.25 133.5-55.5 154.3C2.625 368.8 0 376.5 0 384c.125 16.38 13 32 32.13 32h383.8c19.12 0 32-15.62 32.13-32C448 376.5 445.4 368.8 439.4 362.3zM67.5 368C88.75 340 112 293.6 112 208.6V208C112 146.1 162.1 96 224 96s112 50.12 112 112v.625C336 293.6 359.2 340 380.5 368H67.5zM223.1 512C259.4 512 288 483.4 288 448H160C160 483.4 188.6 512 223.1 512z"],
    "bell-concierge": [512, 512, [62818, "concierge-bell"], "1f6ce", "M488 400h-464C10.75 400 0 410.7 0 423.1C0 437.3 10.75 448 23.1 448h464c13.25 0 24-10.75 24-23.1C512 410.7 501.3 400 488 400zM80 352c0-97 79-176 176-176s176 79 176 176v16H480V352c0-112.9-83.5-205.9-192-221.5V112h24c13.25 0 24-10.75 24-24C336 74.74 325.3 64 311.1 64h-112C186.7 64 176 74.74 176 88c0 13.25 10.75 24 24 24H224v18.5C115.5 146.1 32 239.1 32 352v16h48V352z"],
    "bell-exclamation": [448, 512, [], "f848", "M223.1 512C259.4 512 288 483.3 288 448H160C160 483.3 188.6 512 223.1 512zM439.4 362.3c-19.38-20.71-55.5-51.68-55.5-153.7c0-77.6-54.38-139.6-127.9-154.8V32.94c.375-11.6-5.75-22.58-15.75-28.44c-10-5.988-22.5-5.988-32.5 0C197.6 10.35 191.6 21.33 192 32.94v20.83C118.5 68.99 64.13 130.1 64.13 208.6c0 102.1-36.13 133-55.5 153.7C3 368.2 0 375.1 0 384.1c.125 16.34 13 31.98 32.13 31.98h383.8c19.12 0 32-15.64 32.13-31.98C448 375.1 445 368.2 439.4 362.3zM67.5 368.3C88.75 340.3 112 294.1 112 209.2V208.6C112 146.8 162.1 96.81 224 96.81s112 50.03 112 111.8v.6238c0 84.96 23.25 131.1 44.5 159.1H67.5zM224 255.5c13.25 0 24-10.73 24-23.95V151.7c0-13.22-10.78-23.85-24.03-23.85S200 138.5 200 151.7v79.84C200 244.8 210.8 255.5 224 255.5zM224 287.5c-17.67 0-32 14.3-32 31.94s14.33 31.94 32 31.94s32-14.3 32-31.94S241.7 287.5 224 287.5z"],
    "bell-on": [640, 512, [63738], "1f56d", "M521 100.8c4.125 0 8.25-1.123 12-3.244l55.38-31.94c11.25-6.737 14.88-21.21 8.375-32.44c-6.5-11.35-21-15.35-32.38-8.982L509 56.14c-9.5 5.365-14 16.47-11.25 26.95C500.6 93.57 510.1 100.8 521 100.8zM112 192.6c0-13.22-10.75-23.95-24-23.95h-64c-13.25 0-24 10.73-24 23.95s10.75 23.95 24 23.95h64C101.2 216.6 112 205.8 112 192.6zM51.62 65.62l55.5 31.94c7.375 4.491 16.63 4.616 24.25 .3742C138.9 93.57 143.5 85.58 143.5 76.97C143.4 68.24 138.6 60.26 131.1 56.14L75.62 24.2C68.25 19.71 59 19.59 51.38 23.83C43.88 28.19 39.25 36.18 39.25 44.79C39.38 53.52 44.12 61.5 51.62 65.62zM616 168.7h-64c-13.25 0-24 10.73-24 23.95s10.75 23.95 24 23.95h64c13.25 0 24-10.73 24-23.95S629.3 168.7 616 168.7zM479.9 208.6c0-77.6-54.38-139.6-127.9-154.8V32.94c.375-11.6-5.75-22.58-15.75-28.44c-10-5.988-22.5-5.988-32.5 0C293.6 10.35 287.6 21.33 288 32.94v20.83C214.5 68.99 160.1 130.1 160.1 208.6c0 102.1-36.12 133-55.5 153.7C99 368.2 96 375.1 96 384.1c.125 16.34 13 31.98 32.13 31.98h383.8c19.12 0 32-15.64 32.13-31.98c0-8.109-3-15.88-8.625-21.74C516 341.6 479.9 310.6 479.9 208.6zM163.5 368.3C184.8 340.3 208 294.1 208 209.2V208.6C208 146.8 258.1 96.81 320 96.81s112 50.03 112 111.8v.6238c0 84.96 23.25 131.1 44.5 159.1H163.5zM319.1 512C355.4 512 384 483.3 384 448H256C256 483.3 284.6 512 319.1 512z"],
    "bell-plus": [448, 512, [], "f849", "M223.1 512C259.4 512 288 483.3 288 448H160C160 483.3 188.6 512 223.1 512zM439.4 362.3c-19.38-20.71-55.5-51.68-55.5-153.7c0-77.6-54.38-139.6-127.9-154.8V32.94c.375-11.61-5.75-22.59-15.75-28.45c-10-5.992-22.5-5.992-32.5 0C197.6 10.35 191.6 21.33 192 32.94v20.83C118.5 68.99 64.13 130.1 64.13 208.6c0 102-36.13 133-55.5 153.7C3 368.2 0 375.1 0 384.1c.125 16.34 13 31.98 32.13 31.98h383.8c19.12 0 32-15.64 32.13-31.98C448 375.1 445 368.2 439.4 362.3zM67.5 368.3C88.75 340.3 112 294.1 112 209.2V208.6c0-61.76 50.13-111.8 112-111.8s112 50.02 112 111.8v.625c0 84.96 23.25 131.1 44.5 159.1H67.5zM280 216l-32-.0009V184c0-13.25-10.75-24-24-24S200 170.8 200 184v31.1l-32 .0009c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 24 24 24l32-.0007v32c0 13.25 10.75 23.1 24 23.1s24-10.75 24-23.1V264l32 .0007c13.25 0 24-10.75 24-24C304 226.8 293.3 216 280 216z"],
    "bell-school": [512, 512, [], "f5d5", "M464 352c-26.51 0-48 21.49-48 48c0 16.43 8.286 30.86 20.87 39.52C430.8 453.9 416.5 464 400 464h-50.29C351.1 458.9 352 453.6 352 448v-90.16c48.31-46.47 74.41-115.1 60.08-190.6c-15.71-81.77-81.52-147.8-163.3-163.4C116.2-21.38 0 79.91 0 208c0 58.75 24.62 111.1 64 149.8V448c0 35.2 28.8 64 64 64h272c42.2 0 77.49-29.83 85.99-69.52C501.4 434.5 512 418.5 512 400C512 373.5 490.5 352 464 352zM304 448c0 8.836-7.164 16-16 16H128c-8.836 0-16-7.164-16-16v-55.63C140.8 407.4 173.4 416 208 416s67.25-8.625 96-23.62V448zM251.5 362.2c-121.6 32.23-229.9-76.07-197.7-197.7C67.91 111.1 111.1 67.91 164.5 53.75c121.6-32.23 229.9 76.07 197.7 197.7C348.1 304.9 304.9 348.1 251.5 362.2zM226.8 113.8C159.2 100.9 100.1 159.2 113.8 226.8c7.133 37.56 37.86 68.28 75.42 75.41c67.61 12.84 125.8-45.4 113-113C295.1 151.6 264.4 120.9 226.8 113.8zM208 256C181.5 256 160 234.5 160 208S181.5 160 208 160S256 181.5 256 208S234.5 256 208 256z"],
    "bell-school-slash": [640, 512, [], "f5d6", "M630.8 469.1l-60.48-47.41c3.414-6.543 5.672-13.79 5.672-21.71c0-26.51-21.49-47.1-47.1-47.1c-12.06 0-22.95 4.609-31.38 11.95l-51.97-40.74c29.1-43.36 42.56-98.02 31.43-155.9c-15.71-81.77-81.52-147.8-163.3-163.4C236.1-10.71 165.6 17.45 119.3 68.17L38.81 5.117C28.34-3.054 13.32-1.247 5.115 9.19C-3.057 19.63-1.234 34.72 9.188 42.89l591.1 463.1C605.6 510.3 610.8 512 615.1 512c7.125 0 14.17-3.159 18.9-9.19C643.1 492.4 641.2 477.3 630.8 469.1zM317.2 223.3l-70.99-55.64c7.467-4.789 16.24-7.691 25.76-7.691c26.5 0 47.1 21.5 47.1 47.1C320 213.4 318.9 218.5 317.2 223.3zM426.2 251.5c-4.027 15.2-10.5 29.49-18.85 42.54L356 253.7c10.25-18.64 14.69-40.92 10.21-64.52c-7.133-37.56-37.86-68.28-75.42-75.41c-32.19-6.113-62.07 4.055-83.3 23.54l-51.28-40.19c19.55-20.58 44.45-36 72.32-43.38C350.2 21.52 458.5 129.8 426.2 251.5zM464 463.1L413.7 464C415.1 458.9 416 453.6 416 448v-25.71l-83.84-65.71c-5.455 2.156-10.98 4.164-16.7 5.676c-114.6 30.38-217.3-64.11-201.8-176.9L71.82 152.5C66.91 170.2 64 188.7 64 207.1c0 58.75 24.62 111.1 63.1 149.8L128 448c0 35.2 28.8 64 64 64l272-.002c17.73 0 34.07-5.498 47.89-14.56l-43.51-34.1C466.9 463.5 465.5 463.1 464 463.1zM368 448c0 8.836-7.164 16-16 16H192c-8.836 0-16-7.164-16-16v-55.63c28.75 15 61.38 23.62 96 23.62S339.3 407.4 368 392.4V448z"],
    "bell-slash": [640, 512, [61942, 61943], "1f515", "M630.8 469.1l-90.65-71.05c2.205-4.418 3.805-9.09 3.842-14.06c0-7.5-2.625-15.25-8.625-21.75c-19.25-20.75-55.5-51.1-55.5-154.2c0-77.75-54.37-139.9-127.9-155.1V32c0-17.62-14.38-32-32-32s-31.1 14.38-31.1 32V52.88c-42.7 8.859-78.5 33.78-101.2 68.22L38.81 5.117C28.34-3.054 13.32-1.247 5.115 9.19c-8.172 10.44-6.349 25.53 4.073 33.7L601.2 506.9C605.6 510.3 610.8 512 615.1 512c7.125 0 14.17-3.159 18.9-9.19C643.1 492.4 641.2 477.3 630.8 469.1zM224.7 150.8C244.1 118.1 279.2 96 320 96c61.88 0 112 50.13 112 112v.625c0 55.46 9.949 94.28 22.73 122.5L224.7 150.8zM319.1 512c35.38 0 64-28.62 64-63.1H256C256 483.4 284.6 512 319.1 512zM163.5 368c16.79-22.12 34.64-56.07 41.47-111.1L159.5 221.3c-3.148 91.16-36.56 121.2-54.9 140.1c-6 6.5-8.625 14.25-8.625 21.75c.125 16.38 12.1 31.1 32.12 31.1L407.1 416l-61.24-48H163.5z"],
    "bells": [640, 512, [], "f77f", "M241.1 253.9c-27.87-76.61 4.999-160.6 73.75-199.7c-8.5-5.621-17.5-10.5-27.5-14.12C218.1 14.91 142.5 50.66 117.3 119.8C116.5 121.9 102.6 160.3 101.9 162.4c-29.12 80.11-66.37 94.36-87.37 104.1c-20.12 10.37-19.5 40.62 2.1 48.87l243.2 88.49c8.498-19.12 19.5-45.49-3.25-108.1L241.1 253.9zM138.1 444.2c27.62 10 57.5-.3723 73.74-23.25l-115.4-41.99C94.26 406.9 110.4 434.1 138.1 444.2zM501.9 476.2c27.62-10.12 43.87-37.24 41.62-65.24l-115.4 41.99C444.4 475.7 474.2 486.2 501.9 476.2zM625.6 299.4c-20.1-10.62-58.37-24.88-87.37-104.1c-.875-2.125-14.75-40.5-15.5-42.62c-19.75-54.07-70.87-87.74-125.3-87.74c-15.16 0-30.58 2.63-45.65 8.126C282.6 97.25 246.9 173.8 272.1 242.1c.75 2.121 14.75 40.37 15.62 42.62c29.12 80.11 9.625 114.9 .5 136.6c-7.615 17.7 6.032 37.05 24.27 37.05c3.018 0 6.157-.5301 9.351-1.682l300.6-109.4C642.1 340.7 647.3 310.6 625.6 299.4zM347.6 397.2c6.029-28.89 6.381-69.96-15-128.8c-1.322-3.484-14.19-38.64-15.34-41.85c-7.807-21.41-6.805-44.57 2.82-65.22c9.625-20.64 26.71-36.3 48.15-44.09c9.461-3.449 19.29-5.199 29.21-5.199c35.72 0 67.97 22.58 80.07 55.69c.1152 .3281 12.21 33.92 15.63 42.98c21.12 58.35 47.69 89.47 70.92 107.7L347.6 397.2z"],
    "bench-tree": [640, 512, [], "e2e7", "M360 352h-32V318.4C341.7 314.8 352 302.8 352 288V224c0-17.67-14.33-32-32-32H64C46.33 192 32 206.3 32 224v64c0 14.83 10.3 26.76 24 30.38V352h-32C10.75 352 0 362.8 0 376s10.75 24 24 24H32v88C32 501.3 42.75 512 56 512s24-10.75 24-24V400h224v88c0 13.25 10.75 24 24 24S352 501.3 352 488V400h8c13.25 0 24-10.75 24-24S373.3 352 360 352zM280 352h-176v-32h176V352zM304 272h-224v-32h224V272zM606.5 111.1C607.3 106.2 608 101.2 608 96c0-53.02-42.98-96-96-96s-96 42.98-96 96c0 5.174 .7363 10.15 1.523 15.11C397.3 125.6 384 149.2 384 176C384 220.2 419.8 256 464 256h24v232c0 13.25 10.75 24 24 24s24-10.75 24-24V256h24C604.2 256 640 220.2 640 176C640 149.2 626.7 125.6 606.5 111.1zM560 208h-96c-17.64 0-32-14.36-32-32c0-10.3 4.924-19.74 13.51-25.9c14.75-10.59 22.27-28.6 19.42-46.53C464.6 101.2 464 97.73 464 96c0-26.47 21.53-48 48-48s48 21.53 48 48c0 1.729-.5586 5.244-.9277 7.572c-2.852 17.93 4.664 35.94 19.42 46.53C587.1 156.3 592 165.7 592 176C592 193.6 577.6 208 560 208z"],
    "bezier-curve": [640, 512, [], "f55b", "M576 176c35.38 0 64-28.62 64-64s-28.62-64-64-64c-26.75 0-49.67 16.62-59.17 40H400V64c0-17.62-14.38-32-32-32h-96c-17.62 0-32 14.38-32 32v24H123.2C113.7 64.62 90.75 48 64 48c-35.38 0-64 28.62-64 64s28.62 64 64 64c26.75 0 49.67-16.62 59.17-40H203C138.6 173.8 94.25 241.5 88.75 320H64c-17.62 0-32 14.38-32 32v96c0 17.62 14.38 32 32 32h96c17.62 0 32-14.38 32-32v-96c0-17.62-14.38-32-32-32H136.8c5.875-66.75 47.5-123.4 105.5-150.5C246.4 182.4 257.8 192 272 192h96c14.25 0 25.62-9.625 29.75-22.5c58 27.12 99.62 83.75 105.5 150.5H480c-17.62 0-32 14.38-32 32v96c0 17.62 14.38 32 32 32h96c17.62 0 32-14.38 32-32v-96c0-17.62-14.38-32-32-32h-24.75c-5.5-78.5-49.88-146.2-114.3-184h79.83C526.3 159.4 549.3 176 576 176zM560 110.4L560.6 108C562.5 101 568.8 96 576 96c8.875 0 16 7.125 16 16S584.9 128 576 128c-7.25 0-13.5-5-15.38-12L560 113.6V110.4zM80 113.6L79.38 116C77.5 123 71.25 128 64 128C55.12 128 48 120.9 48 112S55.12 96 64 96c7.25 0 13.5 5 15.38 12L80 110.4V113.6zM144 368v64h-64v-64H144zM352 144H288v-64h64V144zM560 368v64h-64v-64H560z"],
    "bicycle": [640, 512, [61958], "1f6b2", "M512 224c-13.91 0-27.06 2.779-39.6 6.885l-98.44-182.1C368.4 38.44 357.6 32 345.8 32H310.6c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24h25.69l34.59 64H221L194.2 106.1C189.7 99.78 182.4 96 174.6 96h-56c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24h43.59l22.02 31.1L157.7 228.1C148.1 225.7 138.3 224 128 224c-70.69 0-128 57.31-128 128c0 70.69 57.31 128 128 128c65.21 0 118.4-48.95 126.4-112h48.19c8.482 0 16.33-4.48 20.65-11.78l84.79-143.5l22.38 41.41C402.3 277.6 384 312.5 384 352c0 70.69 57.31 128 128 128s128-57.31 128-128C640 281.3 582.7 224 512 224zM128 432c-44.11 0-80-35.89-80-80S83.89 272 128 272c2.523 0 4.891 .5508 7.35 .7871L105.1 333.3c-3.719 7.438-3.312 16.28 1.062 23.36C110.5 363.7 118.3 368 126.6 368h79.8C198.9 404.5 166.6 432 128 432zM165.4 320l50.24-100.5L286.8 320H165.4zM314.7 276.3L255 192h109.5L314.7 276.3zM512 432c-44.18 0-80-35.82-80-80c0-21.65 8.682-41.22 22.66-55.63l36.16 67.07c4.344 8.031 12.6 12.6 21.13 12.6c3.859 0 7.76-.9167 11.39-2.885c11.67-6.297 16.03-20.86 9.714-32.52l-36.18-67.11C501.8 272.6 506.8 272 512 272c44.18 0 80 35.82 80 80C592 396.2 556.2 432 512 432z"],
    "binary": [384, 512, [], "e33b", "M248 224h112C373.3 224 384 213.3 384 200S373.3 176 360 176h-32V24c0-7.062-3.094-13.75-8.5-18.31c-5.375-4.562-12.53-6.5-19.44-5.359l-48 8c-13.09 2.172-21.91 14.55-19.75 27.62c2.188 13.08 14.81 21.83 27.62 19.72L280 52.33V176h-32C234.8 176 224 186.8 224 200S234.8 224 248 224zM136 464h-32V312c0-7.062-3.094-13.75-8.5-18.31C90.16 289.1 83 287.2 76.06 288.3l-48 8C14.97 298.5 6.156 310.9 8.313 323.1c2.188 13.06 14.81 21.89 27.62 19.72L56 340.3V464h-32C10.75 464 0 474.8 0 488S10.75 512 24 512h112C149.3 512 160 501.3 160 488S149.3 464 136 464zM312 288h-48C224.3 288 192 320.3 192 360v80c0 39.7 32.31 72 72 72h48c39.69 0 72-32.3 72-72v-80C384 320.3 351.7 288 312 288zM336 440c0 13.23-10.78 24-24 24h-48c-13.22 0-24-10.77-24-24v-80c0-13.23 10.78-24 24-24h48c13.22 0 24 10.77 24 24V440zM192 72C192 32.3 159.7 0 120 0h-48C32.31 0 0 32.3 0 72v80C0 191.7 32.31 224 72 224h48C159.7 224 192 191.7 192 152V72zM144 152c0 13.23-10.78 24-24 24h-48C58.78 176 48 165.2 48 152v-80c0-13.23 10.78-24 24-24h48c13.22 0 24 10.77 24 24V152z"],
    "binary-circle-check": [640, 512, [], "e33c", "M192 72.01c0-39.7-32.31-71.1-72-71.1h-48c-39.69 0-72 32.3-72 71.1v79.1c0 39.7 32.31 71.1 72 71.1h48c39.69 0 72-32.3 72-71.1V72.01zM144 152c0 13.23-10.78 23.1-24 23.1h-48c-13.22 0-24-10.77-24-23.1V72.01c0-13.23 10.78-23.1 24-23.1h48c13.22 0 24 10.77 24 23.1V152zM248 224h112c13.25 0 24-10.75 24-23.1S373.3 176 360 176h-32V24.01c0-7.281-3.312-14.17-8.969-18.72C313.3 .7131 306-.8944 298.9 .715L250.8 11.26c-12.94 2.875-21.09 15.69-18.22 28.62c2.875 12.92 15.62 21.05 28.66 18.22L280 53.93v122.1h-32c-13.25 0-24 10.75-24 23.1S234.8 224 248 224zM136 464h-32V312c0-7.281-3.312-14.17-8.969-18.72C89.31 288.7 81.98 287.1 74.86 288.7L26.78 299.3C13.84 302.1 5.688 314.9 8.562 327.9c2.875 12.92 15.66 21.06 28.66 18.22L56 341.9v122.1h-32c-13.25 0-24 10.75-24 23.1C0 501.3 10.75 512 24 512h112C149.3 512 160 501.3 160 488C160 474.8 149.3 464 136 464zM496 224C416.5 224 352 288.5 352 368S416.5 512 496 512C575.5 512 640 447.5 640 368S575.5 224 496 224zM563.3 341.1l-74.66 74.66c-3.125 3.125-7.219 4.687-11.31 4.687s-8.188-1.563-11.31-4.687l-37.34-37.33c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0l26.03 26.02L540.7 319.4c6.25-6.25 16.38-6.25 22.62 0S569.6 335.7 563.3 341.1zM312 464h-48c-13.22 0-24-10.77-24-23.1v-79.1c0-13.23 10.78-23.1 24-23.1h48c3.871 0 7.391 1.135 10.63 2.771c2.725-16.2 7.654-31.61 14.49-45.1C329.3 289.8 320.9 288 312 288h-48c-39.69 0-72 32.3-72 71.1v79.1C192 479.7 224.3 512 264 512h48c21.82 0 41.17-9.969 54.38-25.35c-12.44-13.58-22.79-29.06-30.51-46.02C335.5 453.6 324.1 464 312 464z"],
    "binary-lock": [640, 512, [], "e33d", "M607.1 320L608 272c0-44.11-35.88-80-80-80s-80 35.89-80 80v47.1c-17.68 0-32 14.33-32 32.01v127.1C416 497.7 430.3 512 448 512h159.1C625.7 512 640 497.7 640 479.1v-127.1C640 334.3 625.7 320 607.1 320zM560 320h-64V272c0-17.64 14.34-31.1 32-31.1s32 14.36 32 31.1V320zM192 72.01c0-39.7-32.31-71.1-72-71.1h-48c-39.69 0-72 32.3-72 71.1v79.1c0 39.7 32.31 71.1 72 71.1h48c39.69 0 72-32.3 72-71.1V72.01zM144 152c0 13.23-10.78 23.1-24 23.1h-48c-13.22 0-24-10.77-24-23.1V72.01c0-13.23 10.78-23.1 24-23.1h48c13.22 0 24 10.77 24 23.1V152zM360 176h-32V24.01c0-7.281-3.312-14.17-8.969-18.72C313.3 .7131 305.1-.8944 298.9 .715L250.8 11.26c-12.94 2.875-21.09 15.69-18.22 28.62c2.875 12.92 15.69 21.05 28.66 18.22L280 53.93v122.1h-32c-13.25 0-24 10.75-24 23.1s10.75 23.1 24 23.1h112c13.25 0 24-10.75 24-23.1S373.3 176 360 176zM312 288h-48c-39.69 0-72 32.3-72 71.1v79.1C192 479.7 224.3 512 264 512h48c39.69 0 72-32.3 72-71.1v-79.1C384 320.3 351.7 288 312 288zM336 440c0 13.23-10.78 23.1-24 23.1h-48c-13.22 0-24-10.77-24-23.1v-79.1c0-13.23 10.78-23.1 24-23.1h48c13.22 0 24 10.77 24 23.1V440zM136 464h-32V312c0-7.281-3.312-14.17-8.969-18.72C89.34 288.7 81.95 287.1 74.86 288.7L26.78 299.3C13.84 302.1 5.688 314.9 8.562 327.9c2.875 12.92 15.62 21.06 28.66 18.22L56 341.9v122.1h-32c-13.25 0-24 10.75-24 23.1C0 501.3 10.75 512 24 512h112C149.3 512 160 501.3 160 488C160 474.8 149.3 464 136 464z"],
    "binary-slash": [640, 512, [], "e33e", "M630.8 469.1L512 375.1V360c0-39.7-32.31-71.1-72-71.1l-40.22 .0208L295.1 205.1C310.2 192.8 320 173.6 320 152v-79.1c0-39.7-32.31-71.1-72-71.1h-48c-39.69 0-72 32.3-72 71.1v3.003L38.82 5.111C34.41 1.673 29.19 .0004 24.04 .0004c-7.123 0-14.19 3.156-18.91 9.187c-8.188 10.44-6.371 25.53 4.067 33.7L128 136l112.3 87.1l104.6 81.1l40.09 31.42L464 399.4l48 37.62l89.18 69.9c10.5 8.203 25.57 6.328 33.69-4.079C643.1 492.4 641.2 477.3 630.8 469.1zM272 152c0 10.74-7.223 19.52-16.96 22.57L176 112.6V72.01c0-13.23 10.78-24 24-24h48c13.22 0 24 10.77 24 24V152zM376 224h112c13.25 0 24-10.75 24-24s-10.75-24-24-24h-32V24.01c0-7.281-3.312-14.17-8.969-18.72c-5.719-4.578-13.02-6.186-20.17-4.576l-48.08 10.54c-12.94 2.875-21.09 15.69-18.22 28.62c2.875 12.92 15.66 21.05 28.66 18.22L408 53.93v122.1h-32c-13.25 0-24 10.75-24 24S362.8 224 376 224zM440 464h-48c-13.22 0-24-10.77-24-24v-54.88l-46.83-36.7C320.6 352.2 320 356 320 360V440c0 39.7 32.31 72 72 72h48c22.52 0 42.41-10.61 55.62-26.85l-37.73-29.57C453.5 460.6 447.2 464 440 464zM264 464h-32V312c0-7.281-3.312-14.17-8.969-18.72C217.3 288.7 209.1 287.1 202.9 288.7L154.8 299.3c-12.94 2.875-21.09 15.69-18.22 28.62c2.875 12.92 15.69 21.06 28.66 18.22L184 341.9V464h-32C138.8 464 128 474.8 128 488S138.8 512 152 512h112C277.3 512 288 501.3 288 488S277.3 464 264 464z"],
    "binoculars": [512, 512, [], "f1e5", "M416 80h-96v-32C320 39.2 327.2 32 336 32h64C408.8 32 416 39.2 416 48V80zM192 48C192 39.2 184.8 32 176 32h-64C103.2 32 96 39.2 96 48v32h96V48zM512 432c.2253 26.44-21.15 48-47.59 48H336c-26.51 0-48-21.49-48-48V288H224v144C224 458.5 202.5 480 176 480H47.59C21.15 480-.2254 458.4 0 432l.375-44c3.374-129.7 60.96-150.1 63.5-243.9c.4767-17.61 14.38-32.1 32-32.1L191.1 112C209.7 112 224 126.3 224 144V160h64V144c0-17.67 14.33-32 32-32l96.12 .0001c17.62 0 31.53 14.49 32 32.1C450.7 237.9 508.3 258.3 511.6 388L512 432zM176 160H111.1C107.4 205 92.75 236.6 79.75 264.8c-15.38 33-29.88 64.25-31.5 124.5L48 432.4L176 432V160zM464 432l-.375-43.63c-1.5-59.38-16-90.63-31.38-123.6C419.3 236.6 404.6 205 400.9 160H336v272H464z"],
    "biohazard": [576, 512, [63360], "2623", "M287.1 112c18.63 0 36.25 3.748 52.88 9.621c13.25-10.37 23.44-24.42 29.44-40.8C345 69.98 317.3 63.94 288.1 63.94c-29.13 0-56.91 5.962-82.16 16.84c5.877 16.5 16.31 30.5 29.57 40.75C251.1 115.8 269.5 112 287.1 112zM387.8 396.1c4.125 15.1 12.39 30.53 24.39 42.4c47.5-35.49 79.23-90.62 83.1-153.4c-7.125-2-14.61-3.02-22.11-3.02c-9.25 0-18 1.875-26.63 4.623C442.5 330.1 420.6 369.7 387.8 396.1zM163.8 438.5c12-11.87 20.28-26.34 24.4-42.34c-32.88-26.37-54.88-65.23-58.88-109.5C120.8 283.9 112.1 282.1 102.8 282.1c-7.5 0-15.12 1-22.5 3.125C84.45 347.1 116.3 403.1 163.8 438.5zM575.5 283.5c-13.13-39.12-39.5-71.98-74.13-92.35c-17.5-10.37-36.25-16.62-55.25-19.87c6-17.74 10-36.49 10-56.24c0-40.99-14.5-80.73-41-112.2c-2.5-3-6.625-3.625-10-1.75c-3.25 1.875-4.75 5.998-3.625 9.748c4.5 13.75 6.625 26.24 6.625 38.49c0 67.73-53.76 122.8-120 122.8s-120-55.11-120-122.8c0-12.12 2.25-24.74 6.625-38.49c1.125-3.75-.375-7.873-3.625-9.748c-3.375-1.875-7.502-1.25-10 1.75C134.7 34.3 120.1 74.04 120.1 115c0 19.75 3.875 38.49 10 56.24C111.2 174.5 92.32 180.8 74.82 191.1c-34.63 20.49-61.01 53.23-74.38 92.35c-1.25 3.748 .25 7.748 3.5 9.748c3.375 1.998 7.5 1.373 10-1.5c9.377-10.87 19-19.12 29.25-25.12c57.25-33.87 130.8-13.75 163.9 44.99c33.13 58.61 13.38 133.1-43.88 167.8c-10.25 6.123-22 10.37-35.88 13.37c-3.627 .875-6.377 4.248-6.377 8.123c.125 3.998 2.75 7.248 6.502 7.998c39.75 7.748 80.63 .7515 115.3-19.74c18-10.5 32.88-24.49 45.25-39.99c12.38 15.5 27.38 29.49 45.38 39.99c34.5 20.5 75.51 27.49 115.1 19.74c3.875-.75 6.375-4 6.5-7.998c0-3.875-2.625-7.248-6.375-8.123c-13.88-2.875-25.63-7.248-35.75-13.37c-57.38-33.87-77.01-109.2-44-167.8c33.13-58.73 106.6-78.85 164-44.99c10.12 6.123 19.75 14.24 29.13 25.12c2.5 2.873 6.752 3.498 10 1.5C575.4 291.2 576.9 287.2 575.5 283.5zM287.1 320.1c-26.5 0-48-21.49-48-47.99c0-26.49 21.5-47.99 48-47.99c26.5 0 48.01 21.5 48.01 47.99C335.1 298.6 314.5 320.1 287.1 320.1z"],
    "bitcoin-sign": [320, 512, [], "e0b4", "M261.4 237.3C277.9 218.9 288 194.6 288 168c0-51.87-38.28-94.62-88-102.4V24C200 10.75 189.3 0 176 0S152 10.75 152 24V64h-48V24C104 10.75 93.25 0 80 0S56 10.75 56 24V64h-32C10.75 64 0 74.75 0 88v336c0 12.53 9.625 22.94 22.12 23.94C29.5 448.5 41.28 448.7 56 448.8V488C56 501.3 66.75 512 80 512s24-10.75 24-24v-39.61l48-.7344V488c0 13.25 10.75 24 24 24s24-10.75 24-24v-41.03c3.182-.0391 6.504-.0898 9.625-.123C270.5 446.2 320 396.2 320 335.4C320 293.1 296.3 256.2 261.4 237.3zM48 112h136c30.88 0 56 25.12 56 56S214.9 224 184 224H48V112zM209.1 398.8C188.5 399.1 72.25 400.8 48 400.8V272h160.6C243.5 272 272 300.5 272 335.4C272 370 243.8 398.5 209.1 398.8z"],
    "blanket": [448, 512, [], "f498", "M448 120C448 71.47 408.5 32 360 32h-272C39.47 32 0 71.47 0 120v248C0 429.8 50.25 480 112 480h312c13.25 0 24-10.75 24-24s-10.75-24-24-24H112c-35.3 0-64-28.72-64-64s28.7-64 64-64h268c11.03 0 20 8.969 20 20s-8.969 20-20 20H120C106.8 344 96 354.8 96 368s10.75 24 24 24h260c37.5 0 68-30.5 68-68c0-.9121-.2344-1.762-.2695-2.666C447.8 320.9 448 320.5 448 320V120zM380 256H112c-23.82 0-45.83 7.604-64 20.33V120c0-22.06 17.94-40 40-40h272c22.06 0 40 17.94 40 40v139.3C393.6 257.4 387 256 380 256z"],
    "blender": [512, 512, [], "f517", "M425.9 330L512 0H48C21.5 0 0 21.5 0 48v160C0 234.5 21.5 256 48 256h102.3l6.125 71C121 341.1 96 375.6 96 416l.0001 64c0 17.62 14.38 32 32 32h320c17.62 0 32-14.38 32-32L480 416C480 378.1 457.9 345.6 425.9 330zM48 208v-160h84.12l14 160H48zM449.9 48L437.4 96H304C295.2 96 288 103.2 288 111.1S295.2 128 304 128h125l-16.75 64H304C295.2 192 288 199.2 288 207.1C288 216.8 295.2 224 304 224h100l-25.12 96H204L180.4 48H449.9zM432 464h-288V416c0-26.5 21.5-48 48-48h192c26.5 0 48 21.5 48 48V464zM288 392c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S301.2 392 288 392z"],
    "blender-phone": [576, 512, [], "f6b6", "M351.1 392c-13.25 0-24 10.75-24 24s10.75 24 24 24c13.25 0 24-10.75 24-24S365.2 392 351.1 392zM115.7 122.6c7.5 .75 14.5-3.499 17.25-10.25l25.75-63.25c3.127-7.375 .2499-15.87-6.625-20.12L112.9 4.887C98.49-3.863 80.11-.4889 68.99 12.01C-23.64 115.6-23.01 271.5 70.99 374.5c9.875 10.75 29.13 12.5 41.75 4.75l39.38-24.12c6.875-4.25 9.627-12.75 6.625-20.12L132.1 271.7C130.2 264.1 123.2 260.7 115.7 261.5l-45 4.374c-17.25-46.88-17.63-99.74 0-147.6L115.7 122.6zM489.9 330L576 .008L191.1 .006l28.37 326.1c-35.38 14.12-60.38 48.62-60.38 88.1l.0068 63.1c0 17.62 14.37 31.1 31.1 31.1L511.1 512c17.62 0 32-14.37 32-31.1L544 416C544 378.1 521.9 345.6 489.9 330zM513.9 48.01l-12.5 48l-133.4-.0049c-8.801 0-16 7.199-16 16c0 8.799 7.199 15.1 16 15.1l125 .0039l-16.75 64l-108.3-.0039c-8.801 0-16 7.2-16 15.1c0 8.801 7.199 16 16 16l100 .0029l-25.12 95.1H267.1L244.4 48.01H513.9zM495.1 464H207.1v-47.1c0-26.5 21.5-48 48-48h192c26.5 0 48 21.5 48 48V464z"],
    "blinds": [512, 512, [], "f8fb", "M494.8 432.4c-4.219-12.56-17.72-19.31-30.37-15.19c-12.56 4.219-19.38 17.78-15.19 30.38L454.7 464H57.32l5.469-16.41c4.188-12.59-2.625-26.16-15.19-30.38c-12.69-4.125-26.15 2.625-30.37 15.19l-16 48c-2.438 7.312-1.188 15.38 3.312 21.62S16.29 512 24.01 512h463.1c7.719 0 14.97-3.719 19.47-9.969s5.75-14.31 3.312-21.62L494.8 432.4zM494.8 304.4C490.6 291.8 477.1 285.1 464.4 289.2c-12.56 4.219-19.38 17.78-15.19 30.38L454.7 336H57.32l5.469-16.41C66.97 307 60.16 293.4 47.6 289.2C34.91 285.1 21.44 291.8 17.22 304.4l-16 48c-2.438 7.312-1.188 15.38 3.312 21.62S16.29 384 24.01 384h463.1c7.719 0 14.97-3.719 19.47-9.969s5.75-14.31 3.312-21.62L494.8 304.4zM494.2 46.74C504.4 43.95 511.1 35.04 511.1 24c0-13.25-10.75-24-24-24H24.01c-13.25 0-24 10.75-24 24c0 11.04 7.619 19.95 17.77 22.74l-16.55 49.66C-1.213 103.7 .0371 111.8 4.537 118S16.29 128 24.01 128H144v36.41C116.1 174.3 96 200.7 96 232c0 39.76 32.24 72 71.1 72C207.8 304 240 271.8 240 232c0-31.3-20.1-57.67-47.1-67.59V48h252l10.67 32H224V128h263.1c7.719 0 14.97-3.719 19.47-9.969s5.75-14.31 3.312-21.62L494.2 46.74zM57.32 80l10.67-32H144v32H57.32zM168 256c-13.23 0-24-10.77-24-24s10.77-24 24-24s24 10.77 24 24S181.2 256 168 256zM494.8 176.4C490.6 163.8 477.1 157.1 464.4 161.2c-12.56 4.219-19.38 17.78-15.19 30.38L454.7 208H268.9C270.8 215.7 272 223.7 272 232S270.8 248.3 268.9 256h219c7.719 0 14.97-3.719 19.47-9.969s5.75-14.31 3.312-21.62L494.8 176.4zM47.6 161.2C34.91 157.2 21.44 163.8 17.22 176.4l-16 48C-1.213 231.7 .0371 239.8 4.537 246S16.29 256 24.01 256h43.01c-1.836-7.736-3.016-15.7-3.016-24s1.221-16.26 3.057-24H57.32l5.469-16.41C66.97 179 60.16 165.4 47.6 161.2z"],
    "blinds-open": [512, 512, [], "f8fc", "M488 464H24C10.75 464 0 474.8 0 488S10.75 512 24 512h464c13.25 0 24-10.75 24-24S501.3 464 488 464zM488 160H224v48h264C501.3 208 512 197.3 512 184S501.3 160 488 160zM24 160C10.75 160 0 170.8 0 184S10.75 208 24 208H144v32c0 1.471 .584 2.75 .8379 4.148C116.5 253.8 96 280.4 96 312C96 351.8 128.2 384 168 384S240 351.8 240 312c0-31.61-20.51-58.17-48.84-67.85C191.4 242.8 192 241.5 192 240v-192h296C501.3 48 512 37.25 512 24S501.3 0 488 0H24C10.75 0 0 10.75 0 24S10.75 48 24 48H144V160H24zM168 288C181.2 288 192 298.8 192 312S181.2 336 168 336S144 325.2 144 312S154.8 288 168 288zM488 320h-216.8c-1.359 17.58-6.773 33.96-15.79 48H488c13.25 0 24-10.75 24-24S501.3 320 488 320zM24 368h56.6C71.58 353.1 66.17 337.6 64.81 320H24C10.75 320 0 330.8 0 344S10.75 368 24 368z"],
    "blinds-raised": [512, 512, [], "f8fd", "M494.2 46.74C504.4 43.95 511.1 35.04 511.1 24c0-13.25-10.75-24-23.1-24H24.01C10.76 0 .006 10.75 .006 24c0 11.04 7.619 19.95 17.77 22.74L1.225 96.41C-1.213 103.7 .0372 111.8 4.537 118s11.75 9.938 19.47 9.938L144 128v80H57.32l5.469-16.41C66.97 179 60.16 165.4 47.6 161.2C34.82 157.2 21.44 163.8 17.22 176.4l-15.1 48C-1.213 231.7 .0372 239.8 4.537 246S16.29 256 24.01 256h119.1v116.4C116.1 382.3 96 408.7 96 440c0 39.76 32.24 72 71.1 72s71.1-32.24 71.1-72c0-31.3-20.1-57.67-47.1-67.59V48h252l10.67 32H224V128l263.1-.0313c7.719 0 14.97-3.688 19.47-9.938c4.5-6.25 5.75-14.31 3.312-21.62L494.2 46.74zM57.32 80l10.67-32h76.02v32H57.32zM168 464c-13.23 0-23.1-10.77-23.1-24S154.8 416 168 416s23.1 10.77 23.1 24S181.2 464 168 464zM494.8 176.4c-4.219-12.56-17.72-19.28-30.37-15.19c-12.56 4.219-19.37 17.78-15.19 30.38L454.7 208H224V256h263.1c7.719 0 14.97-3.719 19.47-9.969c4.5-6.25 5.75-14.31 3.312-21.62L494.8 176.4z"],
    "block-quote": [512, 512, [], "e0b5", "M488 120C501.3 120 512 109.3 512 96s-10.75-24-24-24H24C10.75 72 0 82.75 0 96s10.75 24 24 24H488zM24 224C10.75 224 0 234.7 0 248v176C0 437.3 10.75 448 24 448s24-10.75 24-24v-176C48 234.7 37.25 224 24 224zM488 232H152C138.7 232 128 242.7 128 256s10.75 24 24 24h336C501.3 280 512 269.3 512 256S501.3 232 488 232zM488 392H152C138.7 392 128 402.7 128 416s10.75 24 24 24h336c13.25 0 24-10.75 24-24S501.3 392 488 392z"],
    "blog": [512, 512, [], "f781", "M216.1 .0803C204-1.045 192.6 9.798 192 23.05C191.5 36.3 201.7 47.48 214.1 48.01c131.8 5.531 243.5 117.2 249 249c.5468 12.91 11.17 22.1 23.97 22.1c.3281 0 .6718 0 1.016-.0313c13.25-.5312 23.53-11.72 22.98-24.97C505.4 138.9 373.1 6.611 216.1 .0803zM217.6 96.1c-12.95-.6249-24.66 9.157-25.52 22.37C191.2 131.7 201.2 143.1 214.4 143.1c79.53 5.187 148.4 74.09 153.6 153.6c.8281 12.69 11.39 22.43 23.94 22.43c.5156 0 1.047-.0313 1.578-.0625c13.22-.8437 23.25-12.28 22.39-25.5C409.3 191.7 320.3 102.8 217.6 96.1zM143.1 224H119.1c-13.25 0-23.1 10.75-23.1 23.1c0 13.25 10.75 23.1 23.1 23.1h23.1c52.94 0 95.1 43.06 95.1 95.99S196.9 464 143.1 464s-95.1-43.06-95.1-95.99V120c0-13.25-10.75-24.01-23.1-24.01S0 106.8 0 120v247.1C0 447.4 64.59 512 143.1 512s143.1-64.59 143.1-143.1S223.4 224 143.1 224z"],
    "blueberries": [512, 512, [], "e2e8", "M208 284H180V256c0-11.05-8.969-20-20-20S140 244.1 140 256v28H112c-11.03 0-20 8.953-20 20s8.969 20 20 20h28V352c0 11.05 8.969 20 20 20S180 363 180 352v-28H208c11.03 0 20-8.953 20-20S219 284 208 284zM336 0C244 0 169.2 70.78 161.4 160.7C71.05 168.2 0 243.7 0 336C0 433.2 78.8 512 176 512c92.28 0 167.8-71.05 175.3-161.4C441.2 342.8 512 267.1 512 176C512 78.8 433.2 0 336 0zM176 464c-70.58 0-128-57.42-128-128s57.42-128 128-128s128 57.42 128 128S246.6 464 176 464zM416 128h-32v32c0 8.844-7.156 16-16 16S352 168.8 352 160V128h-32c-8.844 0-16-7.156-16-16S311.2 96 320 96h32V64c0-8.844 7.156-16 16-16S384 55.16 384 64v32h32c8.844 0 16 7.156 16 16S424.8 128 416 128z"],
    "bluetooth": [320, 512, [], "f293", "M196.1 256l114.6-97.75C316.9 153.7 320 147 320 140s-3.094-13.68-8.438-18.25l-136-115.1c-7.092-6.094-17.12-7.5-25.62-3.531C141.4 6.141 136 14.64 136 24.02v179.1L39.56 121.8c-10-8.594-25.16-7.406-33.81 2.688C-2.873 134.5-1.654 149.7 8.439 158.3l114.6 97.75l-114.6 97.75c-10.09 8.594-11.31 23.75-2.688 33.81c8.625 10.09 23.78 11.31 33.81 2.688L136 308V488c0 9.375 5.438 17.88 13.94 21.78C153.2 511.3 156.6 512 160 512c5.594 0 11.16-1.969 15.56-5.75l136-115.1C316.9 385.7 320 379 320 372s-3.094-13.69-8.438-18.25L196.1 256zM184 76.01l75.03 63.1l-75.03 64V76.01zM184 436V308l75.03 63.1L184 436z"],
    "bold": [384, 512, [], "f032", "M303.8 241.7c2.084-1.838 4.41-3.307 6.385-5.303c22.72-22.91 35.03-53.31 34.72-85.59C344.3 85.31 290.4 32 224.9 32H24C10.75 32 0 42.75 0 56S10.75 80 24 80H48v352H24C10.75 432 0 442.8 0 456S10.75 480 24 480h216c70.59 0 128-57.41 128-128C368 304.8 341.1 263.9 303.8 241.7zM224.9 80c39.31 0 71.59 32 72 71.31c.1875 19.34-7.219 37.56-20.84 51.34C262.5 216.4 244.3 224 224.9 224H96V80H224.9zM240 432H96v-160h144c44.13 0 80 35.88 80 80.01S284.1 432 240 432z"],
    "bolt": [384, 512, [61671, "flash"], "26a1", "M381.1 244.8c-4.687-12.48-16.62-20.75-29.97-20.75l-111.5 .0076l76.88-179.4c5.906-13.73 1.5-29.72-10.59-38.5c-12.06-8.781-28.62-8.091-39.87 1.799L10.95 231.9c-10.03 8.781-13.59 22.86-8.906 35.33C6.728 279.7 18.66 288 32.01 288L143.5 288l-76.88 179.4c-5.906 13.73-1.5 29.72 10.59 38.5C82.82 509.1 89.41 512 96 512c7.531 0 15.06-2.656 21.06-7.922l255.1-223.1C383.1 271.3 386.6 257.2 381.1 244.8zM203.1 148.8l-32.22 75.22H117.2L203.1 148.8zM180.9 363.2l32.22-75.22h53.75L180.9 363.2z"],
    "bolt-auto": [576, 512, [], "e0b6", "M381.1 244.8c-4.688-12.48-16.62-20.75-29.97-20.75l-111.5 .0079l76.88-179.4c5.906-13.73 1.5-29.72-10.59-38.5c-12.06-8.781-28.62-8.091-39.87 1.799L10.95 231.9C.9162 240.7-2.647 254.8 2.041 267.3c4.688 12.48 16.62 20.75 29.97 20.75l111.5 .0063l-76.88 179.4c-5.906 13.73-1.5 29.72 10.59 38.5C82.82 509.1 89.41 512 96 512c7.531 0 15.06-2.656 21.06-7.922l255.1-223.1C383.1 271.3 386.6 257.2 381.1 244.8zM117.2 224l85.96-75.22L170.9 224H117.2zM180.9 363.2l32.22-75.21h53.75L180.9 363.2zM573.5 477.3l-88-176c-8.125-16.25-34.81-16.25-42.94 0l-88 176c-5.938 11.86-1.125 26.27 10.75 32.2c11.88 5.953 26.28 1.125 32.19-10.73l13.84-27.68C412.9 471.4 414.3 472 416 472h96c1.664 0 3.121-.625 4.689-.9473l13.84 27.68C534.8 507.1 543.2 512 552 512c3.594 0 7.25-.8125 10.69-2.531C574.6 503.5 579.4 489.1 573.5 477.3zM434.8 424L464 365.7L493.2 424H434.8z"],
    "bolt-lightning": [384, 512, [], "e0b7", "M381.2 172.8C377.1 164.9 368.9 160 360 160h-156.6l50.84-127.1c2.969-7.375 2.062-15.78-2.406-22.38S239.1 0 232 0h-176C43.97 0 33.81 8.906 32.22 20.84l-32 240C-.7179 267.7 1.376 274.6 5.938 279.8C10.5 285 17.09 288 24 288h146.3l-41.78 194.1c-2.406 11.22 3.469 22.56 14 27.09C145.6 511.4 148.8 512 152 512c7.719 0 15.22-3.75 19.81-10.44l208-304C384.8 190.2 385.4 180.7 381.2 172.8zM201 373.9l22.47-104.8c1.531-7.094-.25-14.47-4.812-20.12C214.1 243.3 207.3 240 200 240H51.41l25.59-192h119.6L145.7 175.1C142.8 182.5 143.7 190.9 148.1 197.5S160 208 168 208h146.5L201 373.9z"],
    "bolt-slash": [640, 512, [], "e0b8", "M154.8 218L138.9 231.9C128.9 240.7 125.4 254.8 130 267.3C134.7 279.7 146.7 288 160 288l84.1 .0063L154.8 218zM194.6 467.4c-5.906 13.73-1.5 29.72 10.59 38.5C210.8 509.1 217.4 512 224 512c7.531 0 15.06-2.656 21.06-7.922l129.8-113.6L264.6 304.1L194.6 467.4zM630.8 469.1l-182.4-142.1L501.1 280.1c10.03-8.781 13.59-22.86 8.904-35.33C505.3 232.3 493.3 224 479.1 224l-111.5 .0078l76.88-179.4c5.906-13.73 1.5-29.72-10.59-38.5c-12.06-8.781-28.62-8.091-39.87 1.799L228.4 153.7L38.81 5.109C34.41 1.672 29.19 0 24.03 0C16.91 0 9.846 3.156 5.127 9.188C-3.061 19.62-1.248 34.72 9.189 42.89l591.1 463.1c10.5 8.203 25.56 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1zM303.7 212.7L279.6 193.9l51.5-45.06L303.7 212.7z"],
    "bomb": [512, 512, [61922], "1f4a3", "M390.5 144.1l12.83-12.83c6.25-6.25 6.25-16.37 0-22.62C400.2 105.5 396.1 104 392 104s-8.154 1.535-11.28 4.66L367.9 121.5l-35.24-35.17c-4.215-4.215-9.736-6.322-15.26-6.322s-11.05 2.107-15.26 6.322l-22.58 22.58C257.2 100.7 233.2 96 208 96C93.13 96 0 189.1 0 304S93.13 512 208 512S416 418.9 416 304c0-25.18-4.703-49.21-12.9-71.55l22.58-22.58c8.428-8.428 8.428-22.09 0-30.52L390.5 144.1zM369.2 198.5l-21.69 21.69l10.56 28.79C364.6 267 368 285.5 368 304c0 88.22-71.78 160-160 160s-160-71.78-160-160s71.78-160 160-160c18.49 0 36.1 3.352 55.01 9.963l28.79 10.56l25.58-25.59L373.1 194.6L369.2 198.5zM224 176c-79.41 0-144 64.59-144 144c0 8.844 7.156 16 16 16s16-7.156 16-16c0-61.75 50.25-112 112-112c8.844 0 16-7.156 16-16S232.8 176 224 176zM509.1 59.21l-39.73-16.57L452.8 2.918c-1.955-3.932-7.654-3.803-9.543 0l-16.57 39.72l-39.73 16.57c-3.916 1.959-3.785 7.649 0 9.543l39.73 16.57l16.57 39.72c1.875 3.773 7.574 3.959 9.543 0l16.57-39.72l39.73-16.57C512.9 66.86 513 61.17 509.1 59.21z"],
    "bone": [576, 512, [62935], "1f9b4", "M576 189.7V185.9c0-42.54-30.56-79.58-72.66-88.05c-45.97-9.096-91.81 15.44-107.1 57.76c-2.25 6.345-8.719 12.32-13.31 12.32H193c-4.594 0-11.12-6.095-13.53-12.88c-15-41.79-61.09-66.3-106.8-57.2C30.56 106.4 0 143.4 0 185.9v3.72c0 26.16 11.94 50.14 32.13 66.33C11.91 272.2 0 296.2 0 322.3v3.72c0 42.54 30.56 79.58 72.66 88.05c6.469 1.282 12.91 1.907 19.28 1.907c38.91 0 74.69-23.29 87.78-59.67c2.25-6.345 8.719-12.32 13.31-12.32h189.9c4.625 0 11.12 6.095 13.53 12.88c15.03 41.79 61.09 66.39 106.8 57.2C545.4 405.6 576 368.6 576 326v-3.72c0-26.13-11.91-50.07-32.16-66.33C564.1 239.7 576 215.8 576 189.7zM528 189.7c0 14.69-9.094 28.01-23.88 34.82c-12.5 5.845-20.25 17.94-20.25 31.51s7.75 25.66 20.25 31.51C518.8 294.2 528 307.6 528 322.3v3.72c0 19.75-14.34 37.01-34.09 40.98c-22.78 4.72-45.19-6.783-52.28-26.54c-7.594-21.41-29.19-44.48-58.66-44.48H193c-29.44 0-51 22.94-58.72 44.63c-7 19.6-29.47 30.98-52.22 26.38C62.34 363 48 345.8 48 326v-3.72c0-14.69 9.094-28.01 23.88-34.82c12.5-5.845 20.25-17.94 20.25-31.51s-7.75-25.66-20.41-31.6C57.09 217.7 48 204.3 48 189.7V185.9c0-19.75 14.34-37.01 34.09-40.98c3.375-.6877 6.719-1 10.03-1c19.03 0 36.22 10.72 42.25 27.54c7.624 21.44 29.22 44.48 58.66 44.48h189.9c29.44 0 51-22.94 58.72-44.63c7-19.6 29.44-31.04 52.22-26.38C513.7 148.9 528 166.2 528 185.9V189.7z"],
    "bone-break": [640, 512, [], "f5d8", "M407.1 159.1c6.156 0 12.28-2.344 16.97-7.031l47.1-47.1c9.374-9.374 9.374-24.56 0-33.94s-24.56-9.374-33.94 0l-47.1 47.1c-9.374 9.374-9.374 24.56 0 33.94C395.7 157.7 401.8 159.1 407.1 159.1zM319.1 127.1c13.25 0 23.1-10.75 23.1-24V23.1C343.1 10.75 333.2 0 319.1 0S295.1 10.75 295.1 23.1v79.1C295.1 117.2 306.7 127.1 319.1 127.1zM215 152.1C219.7 157.7 225.8 159.1 231.1 159.1s12.28-2.344 16.97-7.031c9.374-9.374 9.374-24.56 0-33.94L200.1 71.03c-9.374-9.374-24.56-9.374-33.94 0c-9.374 9.374-9.374 24.56 0 33.94L215 152.1zM582.5 198.4c-43.65-16.5-93.56 .25-116.3 39.18c-2.937 5.062-9.406 7.655-14.41 7.093l-78.49-17.56c-12.97-3.031-25.75 5.218-28.65 18.15s5.218 25.78 18.15 28.65l79.87 17.84c25.81 4.187 52.15-7.843 65.15-30.25c10.94-18.72 35.65-26.5 57.75-18.25c18.62 7.062 29.47 26.31 25.78 45.68l-.7187 3.781c-2.844 14.94-14.69 26.93-31.06 31.37c-13.44 3.781-23.19 14.5-25.47 27.1c-2.25 13.31 3.312 26.43 14.75 34.37c13.06 8.874 19.47 23.4 16.69 37.1l-.6562 3.593c-3.843 20.06-21.72 35.12-42.56 35.87c-22.22 .125-42.72-13.44-46.43-33.31l-.1875-1.312c-3.1-25.53-24.5-45.59-49.12-49.53l-106.5-26.22l-104.6 25.84c-26.53 4.312-47.03 24.37-50.97 49.65l-.3125 1.781c-3.812 19.75-23.65 34.28-46.4 33.06c-20.81-.7187-38.68-15.78-42.5-35.72l-.7187-3.812c-2.75-14.5 3.656-29.03 16.91-38.03c11.25-7.812 16.81-20.94 14.56-34.25c-2.281-13.5-12.03-24.22-25.62-28.03c-16.22-4.406-28.06-16.4-30.9-31.4L48.73 289c-3.718-19.47 7.124-38.71 25.78-45.78c21.97-8.218 46.78-.4687 57.78 18.37C145.2 283.9 171.3 296.2 198.7 291.5l78.49-17.56c12.94-2.875 21.06-15.72 18.15-28.65c-2.875-12.94-15.75-21.15-28.65-18.15L189.6 244.4C182.9 245.5 176.7 242.6 173.7 237.3C151.1 198.6 101.1 181.9 57.54 198.4c-40.5 15.28-64.03 57.15-55.96 99.68l.7187 3.656c4.937 25.93 21.4 47.71 44.68 60.37c-16.94 19.53-24.5 45.62-19.65 71.12l.7187 3.843c7.968 41.84 44.97 73.3 87.93 74.8c46.75 2.625 88.59-30.28 95.71-74.52l.2187-1.219c1.031-4.687 5.531-8.437 13.06-9.718l95.02-23.4l96.93 23.78c5.687 .9374 10.09 4.625 11.22 9.686l.1562 .8749c6.937 43.09 46.15 74.62 92.02 74.62c1.219 0 2.437-.0312 3.656-.0625c42.1-1.531 79.99-32.1 87.99-74.96l.6562-3.625c4.875-25.59-2.687-51.74-19.59-71.24c23.28-12.65 39.75-34.4 44.65-60.28l.7499-3.812C646.5 255.5 622.9 213.7 582.5 198.4z"],
    "bong": [512, 512, [], "f55c", "M467.1 211.7l-41.35-41.45c-9.353-9.375-24.54-9.384-33.9-.0201c-9.356 9.356-9.468 24.64-.112 33.99l3.746 3.747l-39.37 39.38c-11.5-11.38-24.5-21.25-38.63-29.5V47.75h8.121c13.13 0 23.88-10.75 23.88-23.88c0-13.19-10.7-23.88-23.89-23.86L118.2 .2457C105 .2604 94.35 10.95 94.35 24.13c0 13.19 10.69 23.88 23.88 23.88h8.121v169.9c-57.38 33.25-95.1 95.12-95.1 166.1c0 43.07 14.29 82.87 38.35 114.9c5.382 7.158 16.94 13.14 25.9 13.14h255.4c9.024 0 20.68-6.02 26.1-13.24c24.01-31.98 38.28-71.74 38.28-114.8c0-36.13-10.12-69.75-27.5-98.63l43.5-43.37l3.715 3.715c9.369 9.369 24.66 9.327 33.97-.094C477.3 236.2 477.3 221.1 467.1 211.7zM150.4 259.4l24-13.88v-197.5h96v197.5l24 13.88c24.75 14.38 44 35.75 56.5 60.63h-257C106.4 295.1 125.6 273.8 150.4 259.4z"],
    "book": [448, 512, [61485], "1f4d4", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM152 160h176C341.3 160 352 149.3 352 136S341.3 112 328 112h-176C138.8 112 128 122.8 128 136S138.8 160 152 160zM152 240h176C341.3 240 352 229.3 352 216S341.3 192 328 192h-176C138.8 192 128 202.8 128 216S138.8 240 152 240z"],
    "book-arrow-right": [640, 512, [], "e0b9", "M424 288c-13.25 0-24 10.74-24 24V352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.67 14.33-32 32-32h320v56C400 117.3 410.7 128 424 128S448 117.3 448 104V48C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80v352C0 476.2 35.82 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352V312C448 298.7 437.3 288 424 288zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM632.1 191l-80-80c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L558.1 184H280C266.8 184 256 194.8 256 208s10.75 24 24 24h278.1l-39.03 39.03C514.3 275.7 512 281.8 512 288s2.344 12.28 7.031 16.97c9.375 9.375 24.56 9.375 33.94 0l80-80C642.3 215.6 642.3 200.4 632.1 191z"],
    "book-arrow-up": [448, 512, [], "e0ba", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.82 0 0 35.82 0 80v352C0 476.2 35.82 512 80 512h72c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24H80c-17.64 0-32-14.34-32-32s14.36-32 32-32h72c13.25 0 24-10.75 24-24C176 362.7 165.3 352 152 352H80c-11.38 0-22.2 2.375-32 6.688V80c0-17.67 14.33-32 32-32h320V352h-72c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24h40v64h-40c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24h96c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM336.1 248.1c9.375-9.375 9.375-24.56 0-33.94l-80-80c-9.375-9.375-24.56-9.375-33.94 0l-80 80c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L216 209.9V488c0 13.25 10.75 24 24 24s24-10.75 24-24V209.9l39.03 39.03C307.7 253.7 313.8 256 320 256S332.3 253.7 336.1 248.1z"],
    "book-atlas": [448, 512, ["atlas"], "f558", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM232 80C165.8 80 112 133.8 112 200S165.8 320 232 320S352 266.3 352 200S298.3 80 232 80zM145.6 216h34.63C181.6 239.6 185.1 261 192.5 278.3C168.5 266 150.6 243.4 145.6 216zM180.3 184H145.6c5-27.38 22.75-50 46.88-62.25C185.1 139 181.6 160.4 180.3 184zM232 285.8C225.1 277.4 214.5 253.4 212 216h40C249.5 253.4 238.9 277.4 232 285.8zM212 184c2.5-37.38 13.12-61.38 20-69.75C238.9 122.6 249.5 146.6 252 184H212zM271.5 278.3C277.1 261 282.4 239.6 283.8 216h34.63C313.4 243.4 295.5 266 271.5 278.3zM283.8 184c-1.375-23.62-5.75-45-12.25-62.25C295.6 134 313.4 156.6 318.4 184H283.8z"],
    "book-bible": [448, 512, ["bible"], "f647", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM160 208L208 208v96c0 8.875 7.125 16 16 16l32 .0002c8.875 0 16-7.127 16-16v-96L320 208c8.875 0 16-7.129 16-16V160c0-8.875-7.125-15.1-16-15.1L272 144V96c0-8.875-7.125-15.99-16-15.99h-32C215.1 80.01 208 87.13 208 96v48L160 144C151.1 144 144 151.1 144 160v32C144 200.9 151.1 208 160 208z"],
    "book-blank": [448, 512, [128215, 128216, 128217, 62937, "book-alt"], "1f4d5", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352z"],
    "book-bookmark": [448, 512, [], "e0bb", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32H192v159.1c0 13.41 15.52 20.88 25.1 12.49L272 176l54 44.46C336.5 228.8 352 221.4 352 207.1V48h48V352z"],
    "book-circle-arrow-right": [640, 512, [], "e0bc", "M348.6 464H80c-17.64 0-32-14.34-32-32s14.36-32 32-32h243C321.1 389.6 320 378.9 320 368c0-5.4 .3281-10.72 .8047-16H80c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320v172.6c14.63-9.553 30.78-16.93 48-21.8V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h315C376.6 499.1 360.9 482.8 348.6 464zM496 224C416.5 224 352 288.5 352 368s64.46 144 144 144s144-64.46 144-144S575.5 224 496 224zM571.3 379.3l-56 56C512.2 438.4 508.1 440 504 440s-8.188-1.562-11.31-4.688c-6.25-6.25-6.25-16.38 0-22.62L521.4 384H432c-8.836 0-15.1-7.164-15.1-16S423.2 352 432 352h89.38l-28.69-28.69c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0l56 56C577.6 362.9 577.6 373.1 571.3 379.3z"],
    "book-circle-arrow-up": [640, 512, [], "e0bd", "M348.6 464H80c-17.64 0-32-14.34-32-32s14.36-32 32-32h243C321.1 389.6 320 378.9 320 368c0-5.4 .3281-10.72 .8047-16H80c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320v172.6c14.63-9.553 30.78-16.93 48-21.8V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h315C376.6 499.1 360.9 482.8 348.6 464zM496 224C416.5 224 352 288.5 352 367.1S416.5 512 496 512s144-64.46 144-144S575.5 224 496 224zM563.3 371.3c-6.25 6.25-16.38 6.25-22.62 0L512 342.6V432c0 8.836-7.164 15.1-16 15.1S480 440.8 480 432v-89.38l-28.69 28.69c-6.25 6.25-16.38 6.25-22.62 0s-6.25-16.38 0-22.62l56-56c6.25-6.25 16.38-6.25 22.62 0l56 56C566.4 351.8 568 355.9 568 360S566.4 368.2 563.3 371.3z"],
    "book-copy": [576, 512, [], "e0be", "M576 256V48C576 21.53 554.5 0 528 0h-256C227.9 0 192 35.88 192 80v256C192 380.1 227.9 416 272 416h280c13.25 0 24-10.75 24-24s-10.75-24-24-24H544V301.1C562.6 294.4 576 276.8 576 256zM496 368h-224c-17.64 0-32-14.34-32-32s14.36-32 32-32h224V368zM528 256h-256c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h256V256zM360 464H352l0-16H304v16h-224c-17.64 0-32-14.34-32-32s14.36-32 32-32h100.3c-9.805-13.99-16.16-30.36-18.72-48H80c-11.38 0-22.2 2.375-32 6.688V176c0-17.66 14.36-32 32-32H160V96H80C35.89 96 0 131.9 0 176v256C0 476.1 35.89 512 80 512h280c13.25 0 24-10.75 24-24S373.3 464 360 464z"],
    "book-font": [448, 512, [], "e0bf", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM141.3 301.5c11.89 5.938 26.27 1.156 32.2-10.75L190.8 256h98.34l17.36 34.72C310.7 299.2 319.2 304 328 304c3.609 0 7.266-.8125 10.72-2.531c11.86-5.938 16.66-20.34 10.73-32.19l-88-176c-8.125-16.31-34.81-16.31-42.94 0l-88 176C124.6 281.1 129.4 295.5 141.3 301.5zM240 157.7L265.2 208H214.8L240 157.7z"],
    "book-heart": [448, 512, [], "f499", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM230.1 299.9c5.496 5.504 14.24 5.504 19.74 0l84.72-85.56c24.62-25.02 23.12-66.17-4.502-89.19C306.2 105.1 270.5 108.7 248.5 130.9l-8.623 8.762l-8.619-8.762C209.4 108.7 173.8 105.1 149.8 125.1C122.3 148.1 120.8 189.3 145.4 214.3L230.1 299.9z"],
    "book-journal-whills": [448, 512, ["journal-whills"], "f66a", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM149.3 230.5C151.5 232.4 152.4 235.3 151.9 238.1c-.5 2.75-2.625 5.125-5.25 6C143.9 245 140.9 244.5 138.8 242.5l-20-17.5C130.5 279.3 180.4 320 240 320s109.5-40.75 121.3-95l-20 17.5c-3.25 3-8.375 2.625-11.25-.75C328.8 240.3 328.1 238.5 328 236.5c.125-2.25 1.125-4.375 2.75-6l33.13-29c0-.375 .125-.75 .125-1.125c0-10.75-1.625-21.5-4.625-31.88l-17.75 17.75c-3.125 3-8.188 3.125-11.31 0S327.3 178 330.4 174.9L353 152.1c-11.12-23.75-29.62-43.25-52.88-55.63C298.6 95.63 296.6 96 295.4 97.25C294.8 98.13 294.4 99 294.3 100c.125 .75 .25 1.5 .625 2.125C301.1 111.8 304.5 123 304.5 134.4c0 14.38-5.125 27.88-15 39.13c-1.125 1.375-1.25 3.5-.25 5c11.5 16.38 13.88 37.5 6.5 56.13c-7.25 18.62-23.5 32.38-43.13 36.5H252V243.4l6.375 6.25c2 2.125 4.875 2.875 7.75 2.125C268.9 251 271 248.9 271.8 246.1s-.125-5.75-2.125-7.75L259.3 228H272c4.375 0 8-3.625 8-8s-3.625-8-8-8h-12.75l10.38-10.38c3.125-3.125 3.125-8.125 0-11.25s-8.125-3.125-11.25 0L252 196.8V100c0-6.625-5.375-12-12-12s-12 5.375-12 12v96.75L221.6 190.4c-3.125-3.125-8.125-3.125-11.25 0s-3.125 8.125 0 11.25L220.6 212H208c-4.375 0-8 3.625-8 8s3.625 8 8 8h12.62L210.4 238.4c-3.125 3.125-3.125 8.125 0 11.25s8.125 3.125 11.25 0L228 243.3v27.88h-.625C207.8 267 191.6 253.3 184.3 234.6s-5-39.75 6.5-56.13c1-1.625 .875-3.625-.25-5c-9.875-11.25-15-24.75-15-39.13c0-11.38 3.375-22.62 9.625-32.25c.8746-1.5 .75-3.5-.5-4.875S181.4 95.63 179.8 96.5C156.6 108.9 138.1 128.4 127 152.1l22.62 22.75c3.125 3.125 3.125 8.25 0 11.38s-8.125 3-11.25-.125L120.6 168.5C117.6 178.9 116 189.6 116 200.4c0 .375 .125 .75 .125 1.125L149.3 230.5z"],
    "book-medical": [448, 512, [], "f7e6", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM160 223.1l48-.002v48C208 280.8 215.2 288 224 288l32-.0031c8.801 0 16-7.198 16-15.1v-48l48-.002c8.801 0 16-7.199 16-15.1V175.1c0-8.801-7.199-15.1-16-15.1h-48V111.1c0-8.801-7.199-16-16-16L224 96C215.2 96 208 103.2 208 111.1V160H160C151.2 160 144 167.2 144 175.1V208C144 216.8 151.2 223.1 160 223.1z"],
    "book-open": [576, 512, [128366, 62744], "1f4d6", "M540.9 56.77C493.8 39.74 449.6 31.58 410.9 32.02C352.2 32.96 308.3 50 288 59.74C267.7 50 223.9 32.98 165.2 32.04C125.8 31.35 82.18 39.72 35.1 56.77C14.02 64.41 0 84.67 0 107.2v292.1c0 16.61 7.594 31.95 20.84 42.08c13.73 10.53 31.34 13.91 48.2 9.344c118.1-32 202 22.92 205.5 25.2C278.6 478.6 283.3 480 287.1 480s9.37-1.359 13.43-4.078c3.516-2.328 87.59-57.21 205.5-25.25c16.92 4.563 34.5 1.188 48.22-9.344C568.4 431.2 576 415.9 576 399.2V107.2C576 84.67 561.1 64.41 540.9 56.77zM264 416.8c-27.86-11.61-69.84-24.13-121.4-24.13c-26.39 0-55.28 3.281-86.08 11.61C53.19 405.3 50.84 403.9 50 403.2C48 401.7 48 399.8 48 399.2V107.2c0-2.297 1.516-4.531 3.594-5.282c40.95-14.8 79.61-22.36 112.8-21.84C211.3 80.78 246.8 93.75 264 101.5V416.8zM528 399.2c0 .5938 0 2.422-2 3.969c-.8438 .6407-3.141 2.063-6.516 1.109c-90.98-24.6-165.4-5.032-207.5 12.53v-315.3c17.2-7.782 52.69-20.74 99.59-21.47c32.69-.5157 71.88 7.047 112.8 21.84C526.5 102.6 528 104.9 528 107.2V399.2z"],
    "book-open-cover": [640, 512, ["book-open-alt"], "e0c0", "M600.2 32.97L592 35.03v368.1L320 463.6l-272-60.45V35.03L39.76 32.97C19.56 27.92 0 43.19 0 64.01v351.1c0 15 10.42 27.98 25.06 31.24l288 63.1c4.572 1.016 9.311 1.016 13.88 0l288-63.1C629.6 443.1 640 431 640 416V64.01C640 43.19 620.4 27.92 600.2 32.97zM97.97 375.2l216 56C315.9 431.8 317.1 432 320 432s4.062-.25 6.031-.7813l216-56C552.6 372.5 560 362.9 560 352V24c0-7.125-3.156-13.91-8.656-18.44c-5.5-4.562-12.66-6.469-19.72-5.156L320 39.59L108.4 .4062C101.3-.9062 94.16 1 88.66 5.562C83.16 10.09 80 16.88 80 24V352C80 362.9 87.41 372.5 97.97 375.2zM344 83.96L512 52.84v280.6l-168 43.56V83.96zM128 52.84l168 31.12v293L128 333.4V52.84z"],
    "book-open-reader": [512, 512, ["book-reader"], "f5da", "M459.9 192c-.625 0-1.375 0-2 .125C408 194.9 317.4 205.1 256 239.6c-61.38-34.5-152-44.75-201.9-47.5C53.5 192 52.75 192 52.12 192C31.75 192 0 206.4 0 242.2v177.1C0 447 21.25 469 48.38 470.4c34.38 1.875 120.5 9.125 177 37.5C230.8 510.6 236.5 512 242.4 512h27.12c5.75 0 11.75-1.375 17.12-4.125c56.5-28.38 142.6-35.63 177-37.5C490.8 469 512 447 512 420.2V242.2C512 206.4 480.3 192 459.9 192zM232 458.4c-60.62-25.75-138.1-33.62-181.1-35.88C49.12 422.4 48 421.2 48 420.2L47.5 241.9C48.25 241 50.88 240.1 51.38 240C87.25 242 176.5 250.1 232 281.2V458.4zM464 420.2c0 1-1.125 2.125-2.875 2.25c-42.88 2.25-120.4 10.12-181.1 36V281.2C335.4 250.2 424.1 242.1 459.9 240C461.4 240.1 463.8 241.1 464 242.2V420.2zM256 192c53 0 96-43 96-96s-43-96-96-96S160 43 160 96S203 192 256 192zM256 48c26.5 0 48 21.5 48 48S282.5 144 256 144S208 122.5 208 96S229.5 48 256 48z"],
    "book-quran": [448, 512, ["quran"], "f687", "M368 0h-320C21.53 0 0 21.53 0 48V352c0 20.83 13.42 38.43 32 45.05V464H24C10.75 464 0 474.8 0 488S10.75 512 24 512H368c44.11 0 80-35.88 80-80v-352C448 35.88 412.1 0 368 0zM368 464h-288v-64h288c17.64 0 32 14.34 32 32S385.6 464 368 464zM400 358.7C390.2 354.4 379.4 352 368 352h-320V48h320c17.64 0 32 14.34 32 32V358.7zM304.1 172l-12.75-25.88c-1.376-2.75-5.376-2.75-6.75 0L271.9 172l-28.62 4.25c-3.125 .375-4.375 4.125-2.125 6.375l20.75 20.12L257 231.3c-.5 3 2.625 5.375 5.375 4L288 221.8l25.62 13.5c2.75 1.375 5.875-.875 5.375-4l-4.875-28.5l20.75-20.12c2.25-2.25 1-6-2.125-6.375L304.1 172zM248.4 270.9L244.9 271c-39.13 0-71-31.88-71-71s31.88-71 71-71l3.5 .125c6.375 0 12-4.625 13.38-10.88c1.25-6.625-2.25-13.12-8.625-15.62C241.3 98.25 229 96 216.6 96c-57.25 0-104 46.63-104 104s46.63 104 104 104c12.38 0 24.62-2.25 36.13-6.5c5.5-1.875 9.249-7.125 9.249-13C261.1 277 255.9 270.9 248.4 270.9z"],
    "book-section": [448, 512, ["book-law"], "e0c1", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM228.9 286.9C219.4 285.7 208.1 281.1 198.1 278.7L192.9 277C184.3 274.3 175.5 278.9 172.8 287.3C170.1 295.8 174.7 304.8 183.1 307.5L188.2 309.1c11.28 3.688 24.09 7.875 36.34 9.531c6.594 .9219 12.91 1.375 18.91 1.375c34.5 0 58.75-15 63.66-40.7c3.766-19.76-3.5-32.58-14.96-41.59c7.691-6.637 13-15.07 14.96-25.27c8.188-42.97-34.73-53.92-63.11-61.27l-6.734-1.906C204.3 140.5 202.8 134.7 204.4 126.7c2.188-11.41 21.81-17.11 46.63-13.64c7.969 1.125 17.09 3.812 23.22 5.734c8.531 2.625 17.41-2.109 20.06-10.52c2.625-8.438-2.094-17.41-10.5-20.05c-11.5-3.578-20.47-5.75-28.28-6.859C211 75.11 178.7 90.52 172.9 120.7c-3.781 19.83 3.82 32.73 14.94 41.61C180.2 168.9 174.9 177.4 172.9 187.5c-8.094 42.48 35.22 54 56.06 59.55l6.938 1.812c36.44 9.422 41.66 14.12 39.69 24.42C273.5 284.8 253.8 290.5 228.9 286.9zM275.6 206.5c-1.859 9.682-14.38 12.88-22.17 13.98c-3.25-.8965-16.23-4.295-16.23-4.295C204.3 207.4 202.8 201.5 204.4 193.5c1.859-9.701 14.44-12.9 22.22-13.99c.7695 .207 9.328 2.602 9.328 2.602C272.4 191.6 277.6 196.2 275.6 206.5z"],
    "book-skull": [448, 512, ["book-dead"], "f6b7", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM191.1 194.9L191.1 208c0 8.875 7.11 16 15.98 16h64c8.875 0 16-7.125 16-16V194.9c19.38-11.62 32.02-30 32.02-50.88c0-35.38-35.88-64-80-64s-80 28.62-80 64C159.1 164.9 172.6 183.3 191.1 194.9zM271.1 128c8.875 0 16.02 7.125 16.02 16S280.8 160 271.1 160s-16-7.125-16-16S263.1 128 271.1 128zM207.1 128c8.875 0 16 7.125 16 16s-7.125 16-16 16s-16-7.125-16-16S199.1 128 207.1 128zM128.8 309.1C131.1 315.8 137.3 320 144 320c1.672 0 3.375-.25 5.062-.8125L240 288.9l90.94 30.31C332.6 319.8 334.3 320 336 320c6.703 0 12.94-4.25 15.17-10.94c2.797-8.375-1.734-17.44-10.11-20.25L290.6 272l50.44-16.81c8.375-2.812 12.91-11.88 10.11-20.25C348.4 226.6 339.4 222 330.9 224.8L240 255.1L149.1 224.8C140.6 222 131.6 226.6 128.8 234.9c-2.797 8.375 1.734 17.44 10.11 20.25L189.4 272L138.9 288.8C130.6 291.6 126 300.7 128.8 309.1z"],
    "book-sparkles": [448, 512, ["book-spells"], "f6b8", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352h-320c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM159.1 144l12.42 29.78C173 175 174.6 176 175.1 176s2.965-.9922 3.574-2.219L191.1 144L221.8 131.6C222.1 130.1 223.1 129.4 223.1 128c0-1.367-1-2.969-2.217-3.578L191.1 112L179.6 82.22C178.1 80.99 177.4 80 175.1 80S173 80.99 172.4 82.22L159.1 112L130.2 124.4C128.1 125 128 126.6 128 128c0 1.359 .9922 2.969 2.211 3.578L159.1 144zM208 239.1c.0117 2.266 1.67 4.965 3.693 5.973l49.38 20.59l.4004 .4492l20.56 49.3c1.012 2.035 3.672 3.68 5.944 3.695c2.279 0 4.965-1.652 5.98-3.695l20.7-49.64l49.64-20.7C366.3 244.9 368 242.3 368 240c0-2.281-1.652-4.945-3.682-5.961L314.7 213.3l-20.7-49.64c-1.016-2.043-3.698-3.693-5.977-3.693c-2.271 .0156-4.935 1.662-5.947 3.693l-20.72 49.63L211.7 234C209.7 235 208 237.7 208 239.1z"],
    "book-tanakh": [448, 512, ["tanakh"], "f827", "M306.6 200l27.62-46.38C338 147.5 338 139.8 334.5 133.5s-10.25-10.12-17.38-10.12h-56.38L233 77.13C229.5 71.13 223 67.5 216 67.5S202.4 71.13 198.8 77.25L171.1 123.5H114.9C107.6 123.4 101 127.3 97.38 133.6c-3.625 6.125-3.5 13.88 .25 20L125.4 200L97.75 246.4C94 252.5 94 260.3 97.5 266.5s10.25 10.12 17.38 10.12h56.38L199 322.9c3.5 6 10 9.625 17 9.625c7.125 0 13.62-3.75 17.25-9.75l27.62-46.25h56.25c7.25 .125 13.88-3.75 17.5-10.12c3.625-6.125 3.5-13.88-.25-20L306.6 200zM310 147.4l-17.38 29.25l-17.5-29.12L310 147.4zM216 95.38l16.75 28.12H199.1L216 95.38zM122 147.5h34.88l-17.5 29.12L122 147.5zM122 252.5l17.5-29.12L157 252.5H122zM216 304.6L199.3 276.5h33.5L216 304.6zM247.1 252.5H184.9L153.4 200l31.5-52.5h62.25L278.6 200L247.1 252.5zM275.1 252.5l17.5-29.12L310 252.5H275.1zM368 0h-320C21.53 0 0 21.53 0 48V352c0 20.83 13.42 38.43 32 45.05V464H24C10.75 464 0 474.8 0 488S10.75 512 24 512H368c44.11 0 80-35.88 80-80v-352C448 35.88 412.1 0 368 0zM368 464h-288v-64h288c17.64 0 32 14.34 32 32S385.6 464 368 464zM400 358.7C390.2 354.4 379.4 352 368 352h-320V48h320c17.64 0 32 14.34 32 32V358.7z"],
    "book-user": [448, 512, [], "f7e7", "M448 352V48C448 21.53 426.5 0 400 0h-320C35.89 0 0 35.88 0 80v352C0 476.1 35.89 512 80 512h344c13.25 0 24-10.75 24-24s-10.75-24-24-24H416v-66.95C434.6 390.4 448 372.8 448 352zM368 464h-288c-17.64 0-32-14.34-32-32s14.36-32 32-32h288V464zM400 352H352v-16C352 291.8 316.2 256 272 256h-64C163.8 256 128 291.8 128 336V352H80c-11.38 0-22.2 2.375-32 6.688V80c0-17.66 14.36-32 32-32h320V352zM240 224c35.35 0 64-28.66 64-64s-28.65-64-64-64s-64 28.66-64 64S204.7 224 240 224z"],
    "bookmark": [384, 512, [61486, 61591], "1f516", "M336 0h-288C21.49 0 0 21.49 0 48v431.9c0 24.7 26.79 40.08 48.12 27.64L192 423.6l143.9 83.93C357.2 519.1 384 504.6 384 479.9V48C384 21.49 362.5 0 336 0zM336 452L192 368l-144 84V54C48 50.63 50.63 48 53.1 48h276C333.4 48 336 50.63 336 54V452z"],
    "bookmark-slash": [640, 512, [], "e0c2", "M630.8 469.1L512 375.1V48C512 21.49 490.5 0 464 0h-288C149.5 0 128 21.49 128 48v27.01L38.81 5.111C28.35-3.061 13.32-1.249 5.121 9.189C-3.051 19.63-1.233 34.72 9.189 42.89L601.2 506.9C605.6 510.3 610.8 512 615.1 512c7.125 0 14.16-3.161 18.89-9.193C643.1 492.4 641.2 477.3 630.8 469.1zM464 338.4l-288-225.7V54C176 50.63 178.6 48 181.1 48h276C461.4 48 464 50.63 464 54V338.4zM320 368l-144 84V234.2L128 196.6v283.4c0 24.7 26.79 40.08 48.12 27.64L320 423.6l143.9 83.93c16.62 9.695 36.39 2.383 44.38-12.96l-83.71-65.6L320 368z"],
    "books": [512, 512, [62939], "1f4da", "M510.4 435.4l-107.7-399.9C396.9 14.08 377.5 0 356.4 0c-4.111 0-8.294 .5313-12.46 1.641l-61.82 16.48c-5.885 1.57-11.14 4.258-15.78 7.633C258.3 10.51 242.4 0 224 0H160C151.2 0 143.1 2.531 136 6.656C128.9 2.531 120.8 0 112 0h-64C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h64c8.787 0 16.92-2.531 24-6.656C143.1 509.5 151.2 512 160 512h64c26.51 0 48-21.49 48-48V165.3l83.8 311.3C361.6 497.9 380.9 512 402.1 512c4.111 0 8.293-.5313 12.46-1.641l61.82-16.48C502 487 517.2 460.8 510.4 435.4zM224 48V96L160 96L160 48H224zM160 144h64v224H160V144zM112 368h-64v-224h64V368zM112 48V96h-64V48H112zM48 464V416h64v48H48zM160 464l.0011-47.1L224 416v48H160zM294.4 64.5l61.83-16.48l12.47 45.91L306.8 110.4L294.4 64.5zM319.3 156.6l61.91-16.51l58.04 215.3l-61.91 16.51L319.3 156.6zM402.2 464.1l-12.41-46.04l61.91-16.51l12.38 45.94L402.2 464.1z"],
    "books-medical": [576, 512, [], "f7e8", "M79.1 352h31.1c8.836 0 16-7.164 16-16L127.1 288h47.1c8.836 0 16-7.165 16-16v-32c0-8.836-7.165-15.1-16-15.1H127.1l.0006-47.1c0-8.836-7.165-15.1-16-15.1H79.1c-8.836 0-15.1 7.163-15.1 15.1L63.1 224H16c-8.836 0-16 7.163-16 15.1v32c0 8.836 7.164 16 16 16h47.1L63.1 336C63.1 344.8 71.16 352 79.1 352zM574.4 435.4l-107.7-399.9C460.9 14.08 441.5 0 420.4 0c-4.111 0-8.294 .5313-12.46 1.641l-61.82 16.48c-5.885 1.57-11.14 4.258-15.78 7.633C322.3 10.51 306.4 0 288 0H224C215.2 0 207.1 2.531 200 6.656C192.9 2.531 184.8 0 176 0h-64C85.49 0 64 21.49 64 48v56C64 117.3 74.75 128 88 128S112 117.3 112 104V48h64v120C176 181.3 186.7 192 200 192S224 181.3 224 168V144h64v224H224v-24C224 330.7 213.3 320 200 320S176 330.7 176 344v120h-64v-56C112 394.7 101.3 384 88 384S64 394.7 64 408v56C64 490.5 85.49 512 112 512h64c8.787 0 16.92-2.531 24-6.656C207.1 509.5 215.2 512 224 512h64c26.51 0 48-21.49 48-48V165.3l83.8 311.3C425.6 497.9 444.9 512 466.1 512c4.111 0 8.293-.5313 12.46-1.641l61.91-16.51C565.1 487.1 581.2 460.8 574.4 435.4zM288 464H224L224 416H288V464zM288 96H224L224 48h64V96zM358.4 64.5l61.83-16.48l12.47 45.91L370.8 110.4L358.4 64.5zM383.3 156.6l61.91-16.51l58.04 215.3l-61.91 16.51L383.3 156.6zM466.2 464.1l-12.41-46.04l61.91-16.51l12.38 45.94L466.2 464.1z"],
    "boombox": [640, 512, [63653], "1f4fe", "M592 162.3V88C592 39.47 552.5 0 504 0H136C87.47 0 48 39.47 48 88v74.26C20.44 169.4 0 194.2 0 224v224c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V224C640 194.2 619.6 169.4 592 162.3zM96 88C96 65.94 113.9 48 136 48h368C526.1 48 544 65.94 544 88V160h-96V144C448 135.2 440.8 128 432 128h-32C391.2 128 384 135.2 384 144V160h-32V144C352 135.2 344.8 128 336 128h-32C295.2 128 288 135.2 288 144V160H256V144C256 135.2 248.8 128 240 128h-32C199.2 128 192 135.2 192 144V160H96V88zM592 448c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V224c0-8.822 7.178-16 16-16h512c8.822 0 16 7.178 16 16V448zM176 240c-53.02 0-96 42.98-96 96s42.98 96 96 96s96-42.98 96-96S229 240 176 240zM176 384C149.5 384 128 362.5 128 336S149.5 288 176 288S224 309.5 224 336S202.5 384 176 384zM464 240c-53.02 0-96 42.98-96 96s42.98 96 96 96s96-42.98 96-96S517 240 464 240zM464 384c-26.47 0-48-21.53-48-48S437.5 288 464 288S512 309.5 512 336S490.5 384 464 384z"],
    "boot": [512, 512, [63362], "1f97e", "M414.1 263.7L352 248V144c17.75 0 32-14.25 32-32v-64C384 21.49 362.5 0 336 0h-288C21.49 0 0 21.49 0 48v418.7c0 8.373 3.418 16.55 9.322 22.49L32 512h64l32-32l32 32h64l32-32l32 32h64l32-32l32 32h64l22.63-22.67C508.6 483.3 512 475.2 512 466.7V388C512 329.2 472 278 414.1 263.7zM48 48h288V96h-288V48zM464 416h-416V144h256V192h-64C231.2 192 224 199.2 224 207.1S231.2 224 240 224h64v32h-64C231.2 256 224 263.2 224 272S231.2 288 239.1 288h74.13l89.25 22.25C439.1 319.2 464 351.1 464 387.9V416z"],
    "boot-heeled": [512, 512, [], "e33f", "M456 464v-56.45c0-24.24-13.7-46.4-35.38-57.24l-121.2-60.62C277.7 278.8 264 256.7 264 232.4V32c0-17.67-14.33-32-32-32H40.01C20.76 0 5.865 16.87 8.252 35.97l24.43 161.5C37.5 235.1 33.63 275.1 21.35 311.1C12.51 338.5 8 366.3 8 394.2V488C8 501.3 18.75 512 32 512h80c13.25 0 24-10.75 24-24V480c0-2.875-.5-5.625-1.438-8.156l112.5 33.72C261.3 509.8 275.9 512 290.8 512H456c13.25 0 24-10.75 24-24S469.3 464 456 464zM260.9 459.6l-134.8-40.41C119.1 417.1 111.9 416 104.5 416H56v-21.8c0-22.84 3.662-45.4 10.88-67.06c14.46-43.37 19.1-90.27 13.43-135.6L58.13 48H104v184C104 245.3 114.8 256 128 256s24-10.75 24-24V48h64v184.4c0 42.7 23.72 81.08 61.91 100.2l121.2 60.62C404.6 395.1 408 401.5 408 407.6V464h-117.2C280.6 464 270.6 462.5 260.9 459.6z"],
    "booth-curtain": [512, 512, [], "f734", "M0 56v432C0 501.3 10.75 512 24 512s24-10.75 24-24V56c0-4.406 3.594-8 8-8H112V0H56C25.13 0 0 25.12 0 56zM456 0H144v400c0 35.28 28.7 64 64 64c15.21 0 29.01-5.555 40-14.45C258.1 458.4 272.8 464 288 464s29.01-5.555 40-14.45C338.1 458.4 352.8 464 368 464s29.01-5.555 40-14.45C418.1 458.4 432.8 464 448 464c5.557 0 10.86-.9336 16-2.271V488c0 13.25 10.75 24 24 24S512 501.3 512 488V56C512 25.12 486.9 0 456 0zM224 400C224 408.8 216.8 416 208 416S192 408.8 192 400v-352h32V400zM304 400c0 8.812-7.172 16-16 16s-16-7.188-16-16v-352h32V400zM384 400c0 8.812-7.172 16-16 16S352 408.8 352 400v-352h32V400zM464 400c0 8.812-7.172 16-16 16s-16-7.188-16-16v-352h24c4.406 0 8 3.594 8 8V400z"],
    "border-all": [448, 512, [], "f84c", "M384 32H64C28.8 32 0 60.8 0 96v320c0 35.2 28.8 64 64 64h320c35.2 0 64-28.8 64-64V96C448 60.8 419.2 32 384 32zM200 432H64c-8.836 0-16-7.164-16-16V280h152V432zM200 232H48V96c0-8.838 7.164-16 16-16h136V232zM400 416c0 8.836-7.164 16-16 16h-136V280h152V416zM400 232h-152V80H384c8.836 0 16 7.162 16 16V232z"],
    "border-bottom": [448, 512, [], "f84d", "M312 280h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C296 272.8 303.2 280 312 280zM312 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C296 80.84 303.2 88 312 88zM216 184h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C200 176.8 207.2 184 216 184zM216 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C200 80.84 207.2 88 216 88zM408 184h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C392 176.8 399.2 184 408 184zM408 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C392 80.84 399.2 88 408 88zM408 280h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C392 272.8 399.2 280 408 280zM408 376h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C392 368.8 399.2 376 408 376zM120 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C104 80.84 111.2 88 120 88zM24 280h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 272.8 15.16 280 24 280zM24 376h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 368.8 15.16 376 24 376zM24 184h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 176.8 15.16 184 24 184zM432 432h-416C7.125 432 0 439.1 0 448v16C0 472.9 7.125 480 16 480h416c8.875 0 16-7.125 16-16V448C448 439.1 440.9 432 432 432zM216 376h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C200 368.8 207.2 376 216 376zM216 280h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C200 272.8 207.2 280 216 280zM120 280h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C104 272.8 111.2 280 120 280zM24 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 80.84 15.16 88 24 88z"],
    "border-bottom-right": [448, 512, ["border-style-alt"], "f854", "M216 184h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C200 176.8 207.2 184 216 184zM216 280h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C200 272.8 207.2 280 216 280zM216 376h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C200 368.8 207.2 376 216 376zM312 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C296 80.84 303.2 88 312 88zM216 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C200 80.84 207.2 88 216 88zM312 280h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C296 272.8 303.2 280 312 280zM24 184h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 176.8 15.16 184 24 184zM24 280h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 272.8 15.16 280 24 280zM120 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C104 80.84 111.2 88 120 88zM24 376h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 368.8 15.16 376 24 376zM24 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 80.84 15.16 88 24 88zM120 280h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C104 272.8 111.2 280 120 280zM432 32H416c-8.875 0-16 7.125-16 16V416c0 8.836-7.164 16-16 16H16C7.125 432 0 439.1 0 448v16C0 472.9 7.125 480 16 480H384c35.35 0 64-28.65 64-64V48C448 39.13 440.9 32 432 32z"],
    "border-center-h": [448, 512, [], "f89c", "M24 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 80.84 15.16 88 24 88zM40 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 431.2 48.84 424 40 424zM24 184h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 176.8 15.16 184 24 184zM120 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C104 80.84 111.2 88 120 88zM216 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C200 80.84 207.2 88 216 88zM408 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C392 80.84 399.2 88 408 88zM408 184h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C392 176.8 399.2 184 408 184zM312 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C296 80.84 303.2 88 312 88zM216 184h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C200 176.8 207.2 184 216 184zM424 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 431.2 432.8 424 424 424zM424 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 335.2 432.8 328 424 328zM328 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 431.2 336.8 424 328 424zM136 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 431.2 144.8 424 136 424zM232 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 335.2 240.8 328 232 328zM40 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 335.2 48.84 328 40 328zM232 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 431.2 240.8 424 232 424zM432 232h-416C7.125 232 0 239.1 0 248v16c0 8.875 7.125 16 16 16h416c8.875 0 16-7.125 16-16v-16C448 239.1 440.9 232 432 232z"],
    "border-center-v": [448, 512, [], "f89d", "M136 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 431.2 144.8 424 136 424zM136 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 239.2 144.8 232 136 232zM40 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 47.16 48.84 40 40 40zM136 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 47.16 144.8 40 136 40zM40 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 335.2 48.84 328 40 328zM40 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 143.2 48.84 136 40 136zM40 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 239.2 48.84 232 40 232zM40 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 431.2 48.84 424 40 424zM424 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 431.2 432.8 424 424 424zM424 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 335.2 432.8 328 424 328zM424 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 239.2 432.8 232 424 232zM424 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 143.2 432.8 136 424 136zM424 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 47.16 432.8 40 424 40zM328 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 47.16 336.8 40 328 40zM328 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 431.2 336.8 424 328 424zM328 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 239.2 336.8 232 328 232zM232 32h-16c-8.875 0-16 7.125-16 16v416c0 8.875 7.125 16 16 16h16c8.875 0 16-7.125 16-16v-416C248 39.13 240.9 32 232 32z"],
    "border-inner": [448, 512, [], "f84e", "M24 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 80.84 15.16 88 24 88zM40 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 431.2 48.84 424 40 424zM24 184h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C8 176.8 15.16 184 24 184zM408 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C392 80.84 399.2 88 408 88zM408 184h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C392 176.8 399.2 184 408 184zM312 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C296 80.84 303.2 88 312 88zM120 88h16c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16C104 80.84 111.2 88 120 88zM424 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 431.2 432.8 424 424 424zM424 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 335.2 432.8 328 424 328zM328 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 431.2 336.8 424 328 424zM40 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 335.2 48.84 328 40 328zM136 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 431.2 144.8 424 136 424zM432 232h-184V48c0-8.875-7.125-16-16-16h-16c-8.875 0-16 7.125-16 16v184H16C7.125 232 0 239.1 0 248v16c0 8.875 7.125 16 16 16h184v184c0 8.875 7.125 16 16 16h16c8.875 0 16-7.125 16-16V280h184c8.875 0 16-7.125 16-16v-16C448 239.1 440.9 232 432 232z"],
    "border-left": [448, 512, [], "f84f", "M232 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 431.2 240.8 424 232 424zM232 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 335.2 240.8 328 232 328zM232 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 143.2 240.8 136 232 136zM136 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 47.16 144.8 40 136 40zM136 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 431.2 144.8 424 136 424zM232 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 47.16 240.8 40 232 40zM136 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 239.2 144.8 232 136 232zM232 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 239.2 240.8 232 232 232zM424 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 143.2 432.8 136 424 136zM424 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 335.2 432.8 328 424 328zM424 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 239.2 432.8 232 424 232zM424 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 47.16 432.8 40 424 40zM424 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 431.2 432.8 424 424 424zM328 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 239.2 336.8 232 328 232zM328 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 47.16 336.8 40 328 40zM328 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 431.2 336.8 424 328 424zM32 32H16C7.125 32 0 39.13 0 48v416C0 472.9 7.125 480 16 480H32c8.875 0 16-7.125 16-16v-416C48 39.13 40.88 32 32 32z"],
    "border-none": [448, 512, [], "f850", "M136 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 239.2 144.8 232 136 232zM232 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 335.2 240.8 328 232 328zM136 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 47.16 144.8 40 136 40zM40 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 47.16 48.84 40 40 40zM232 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 431.2 240.8 424 232 424zM136 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 431.2 144.8 424 136 424zM40 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 143.2 48.84 136 40 136zM40 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 335.2 48.84 328 40 328zM40 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 431.2 48.84 424 40 424zM40 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 239.2 48.84 232 40 232zM424 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 143.2 432.8 136 424 136zM424 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 431.2 432.8 424 424 424zM232 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 239.2 240.8 232 232 232zM424 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 239.2 432.8 232 424 232zM328 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 47.16 336.8 40 328 40zM424 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 47.16 432.8 40 424 40zM424 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 335.2 432.8 328 424 328zM232 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 47.16 240.8 40 232 40zM328 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 239.2 336.8 232 328 232zM232 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 143.2 240.8 136 232 136zM328 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 431.2 336.8 424 328 424z"],
    "border-outer": [448, 512, [], "f851", "M136 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 239.2 144.8 232 136 232zM232 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 335.2 240.8 328 232 328zM232 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 239.2 240.8 232 232 232zM328 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 239.2 336.8 232 328 232zM232 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 143.2 240.8 136 232 136zM384 32H64C28.8 32 0 60.8 0 96v320c0 35.2 28.8 64 64 64h320c35.2 0 64-28.8 64-64V96C448 60.8 419.2 32 384 32zM400 416c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V96c0-8.838 7.164-16 16-16h320c8.836 0 16 7.162 16 16V416z"],
    "border-right": [448, 512, [], "f852", "M136 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 239.2 144.8 232 136 232zM40 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 47.16 48.84 40 40 40zM136 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 431.2 144.8 424 136 424zM136 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 47.16 144.8 40 136 40zM40 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 431.2 48.84 424 40 424zM40 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 335.2 48.84 328 40 328zM40 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 143.2 48.84 136 40 136zM40 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 239.2 48.84 232 40 232zM232 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 431.2 240.8 424 232 424zM328 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 239.2 336.8 232 328 232zM328 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 431.2 336.8 424 328 424zM328 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 47.16 336.8 40 328 40zM232 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 335.2 240.8 328 232 328zM232 40h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 47.16 240.8 40 232 40zM232 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 239.2 240.8 232 232 232zM232 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 143.2 240.8 136 232 136zM432 32H416c-8.875 0-16 7.125-16 16v416c0 8.875 7.125 16 16 16h16c8.875 0 16-7.125 16-16v-416C448 39.13 440.9 32 432 32z"],
    "border-top": [448, 512, [], "f855", "M136 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 431.2 144.8 424 136 424zM232 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 335.2 240.8 328 232 328zM136 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 239.2 144.8 232 136 232zM232 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 431.2 240.8 424 232 424zM40 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 143.2 48.84 136 40 136zM40 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 431.2 48.84 424 40 424zM40 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 239.2 48.84 232 40 232zM40 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C56 335.2 48.84 328 40 328zM424 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 239.2 432.8 232 424 232zM424 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 431.2 432.8 424 424 424zM424 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 335.2 432.8 328 424 328zM424 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 143.2 432.8 136 424 136zM232 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 239.2 240.8 232 232 232zM328 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 239.2 336.8 232 328 232zM232 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 143.2 240.8 136 232 136zM328 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 431.2 336.8 424 328 424zM432 32h-416C7.125 32 0 39.13 0 48V64c0 8.875 7.125 16 16 16h416C440.9 80 448 72.88 448 64V48C448 39.13 440.9 32 432 32z"],
    "border-top-left": [448, 512, ["border-style"], "f853", "M232 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 239.2 240.8 232 232 232zM328 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 431.2 336.8 424 328 424zM232 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 143.2 240.8 136 232 136zM136 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 431.2 144.8 424 136 424zM232 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 431.2 240.8 424 232 424zM136 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C152 239.2 144.8 232 136 232zM232 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C248 335.2 240.8 328 232 328zM424 136h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 143.2 432.8 136 424 136zM328 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C344 239.2 336.8 232 328 232zM424 232h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 239.2 432.8 232 424 232zM424 328h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 335.2 432.8 328 424 328zM424 424h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C440 431.2 432.8 424 424 424zM432 32H64C28.65 32 0 60.65 0 96v368C0 472.9 7.125 480 16 480H32c8.875 0 16-7.125 16-16V96c0-8.838 7.164-16 16-16h368C440.9 80 448 72.88 448 64V48C448 39.13 440.9 32 432 32z"],
    "bow-arrow": [512, 512, [63161], "1f3f9", "M145.7 286.9l34.01-34.08L80.11 153.4c33.88-24.5 74.38-37.88 116.9-37.88c34 0 66.75 8.5 95.75 24.38l35-34.88c-38.88-24.25-83.75-37.5-130.8-37.5c-55.38 0-107.9 18.25-151.1 51.63L38.6 111.9c-3.125-3.125-7.219-4.688-11.31-4.688s-8.188 1.563-11.31 4.688L4.708 123.3c-3.123 3.123-4.685 7.227-4.685 11.33c0 4.112 1.565 8.225 4.692 11.35L145.7 286.9zM512 15.64c0-8.961-7.497-15.64-15.72-15.64c-.9825 0-2.065 .0972-3.053 .29l-128.6 25.75c-7.885 1.529-12.61 8.417-12.61 15.47c0 3.907 1.449 7.875 4.612 10.99l34.5 34.5L140.5 337.2l-49.76-16.26C89.84 320.6 87.5 319.9 84.23 319.9c-4.147 0-9.677 1.181-14.5 6.006l-63.75 63.39C1.902 393.4 0 398.6 0 403.7c0 8.368 5.1 16.57 14.1 19.52l55.63 18.63l18.5 55.5c3 9 11.25 14.13 19.63 14.13c5.125 0 10.38-2 14.38-6L185.1 441.8c3.93-3.931 6.01-9.201 6.01-14.58c0-2.149-.3317-4.315-1.01-6.42L174.4 371.4l250.6-250.5l34.5 34.47c3.161 3.205 7.113 4.639 11.01 4.639c7.039 0 13.88-4.751 15.49-12.64l25.72-128.6C511.9 17.66 512 16.71 512 15.64zM116.2 454.9l-14.88-44.75l-44.88-14.88l33-32.88l44.75 14.88l15 44.75L116.2 454.9zM455.6 94.92l-38.63-38.63l48.25-9.625L455.6 94.92zM407.1 183.9l-35 34.88C388.2 248.1 396.1 280.9 396.1 315.3c0 42.5-13.38 82.88-37.88 116.6l-100.3-100L224.1 365.8l141.7 141.5c3.125 3.125 7.22 4.687 11.31 4.687s8.188-1.562 11.31-4.687l11.26-11.25c3.125-3.125 4.688-7.219 4.688-11.31s-1.563-8.188-4.688-11.31l-7.25-7.25c33.38-43.13 51.63-95.5 51.63-150.9C444.1 268.1 431.6 222.9 407.1 183.9z"],
    "bowl-chopsticks": [512, 512, [], "e2e9", "M14.71 127.1c1.84 0-26.02 4.596 477.2-80.24C504.1 45.63 512 35.29 512 24.08c0-14.41-11.93-24.01-23.98-24.01c-3.727 0 27.4-6.23-476.3 98.77C4.854 100.3 0 106.4 0 113.2C0 122.1 7.361 127.1 14.71 127.1zM479.1 223.1H32c-17.62 0-32 14.39-32 32.19c0 95.69 51.5 179 127.1 223.8c0 17.67 14.33 32 32 32h191.1c17.67 0 32-14.33 32-32c76.5-44.81 127.1-128.1 127.1-223.8C511.1 238.4 497.6 223.1 479.1 223.1zM359.7 438.6c-9.928 5.816-17.27 14.89-20.99 25.42H173.3c-3.723-10.53-11.07-19.6-20.99-25.42C92.47 403.6 53.74 340.7 48.59 272h414.8C458.3 340.7 419.5 403.6 359.7 438.6zM487.6 128.8L15.74 143.5C6.969 143.8 0 150.1 0 159.8C0 168.7 7.275 176 16.25 176h472.1C501.4 176 512 165.4 512 152.4C512 139 500.1 128.3 487.6 128.8z"],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", "M479.1 223.1L192 224V40C192 26.74 181.3 16 168 16S144 26.74 144 40V224h-32V56C112 42.74 101.3 32 88 32C74.74 32 64 42.74 64 56v31.95L11.75 98.84C4.854 100.3 0 106.4 0 113.2C0 122.1 7.361 127.1 14.71 127.1c.9121 0-5.301 1.1 49.29-8.09V142L15.74 143.5C6.969 143.8 0 150.1 0 159.8C0 168.7 7.275 176 16.25 176H64V224L32 223.1c-17.62 0-32 14.39-32 32.19c0 95.69 51.5 179 127.1 223.8c0 17.67 14.33 32 32 32h191.1c17.67 0 32-14.33 32-32c76.5-44.81 127.1-128.1 127.1-223.8C511.1 238.4 497.6 223.1 479.1 223.1zM359.7 438.6c-9.928 5.816-17.27 14.89-20.99 25.42H173.3c-3.723-10.53-11.07-19.6-20.99-25.42C92.47 403.6 53.74 340.7 48.59 272h414.8C458.3 340.7 419.5 403.6 359.7 438.6zM512 24.08c0-14.41-11.93-24.01-23.98-24.01c-3.096 0 17.55-4.234-264 54.51V92.89l267.9-45.18C504.1 45.62 512 35.29 512 24.08zM487.6 128.8L224 137V176h264.4C501.4 176 512 165.4 512 152.4C512 139 500.1 128.3 487.6 128.8z"],
    "bowl-hot": [512, 512, ["soup"], "f823", "M480 192H32c-17.62 0-32 14.37-32 31.1c0 94.75 51.5 177.1 128 221.5v34.5c0 17.62 14.38 31.1 32 31.1h192c17.62 0 32-14.37 32-31.1v-34.5c76.5-44.38 128-126.7 128-221.5C512 206.4 497.6 192 480 192zM336 417.8v46.25h-160v-46.25c-67.5-39.13-120.3-87-127.4-177.8h414.8C456.4 328.9 405.4 377.6 336 417.8zM171.9 100.7C184.3 107.1 192 121.4 192 136c0 13.25 10.75 23.89 24 23.89S240 148.1 240 135.7c0-31.34-16.81-60.64-43.91-76.45C183.7 52.03 176 38.63 176 24.28c0-13.25-10.75-24.14-24-24.14S128 11.03 128 24.28C128 55.63 144.8 84.92 171.9 100.7zM283.9 100.7C296.3 107.1 304 121.4 304 136c0 13.25 10.75 23.86 24 23.86S352 148.1 352 135.7c0-31.34-16.81-60.64-43.91-76.45C295.7 52.03 288 38.63 288 24.28c0-13.25-10.75-24.18-24-24.18S240 11.03 240 24.28C240 55.63 256.8 84.92 283.9 100.7z"],
    "bowl-rice": [512, 512, [], "e2eb", "M480 192H32C14.38 192 0 206.4 0 224c0 94.75 51.5 177.1 128 221.5V480c0 17.62 14.38 32 32 32h192c17.62 0 32-14.38 32-32v-34.5C460.5 401.1 512 318.8 512 224C512 206.4 497.6 192 480 192zM359.9 403.1C345.1 412.6 336 428.4 336 445.5V464h-160v-18.5c0-17.12-9.111-32.93-23.92-41.52C92.55 369.4 53.93 307.6 48.63 240h414.7C458.1 307.6 419.4 369.4 359.9 403.1zM52.84 159.8c12.94 1.67 25.19-7.562 26.94-20.81C81.9 122.8 97.03 110.6 112.8 110.5c1.031 .1575 2.844 .2836 4.156 .3151c10.81 0 20.31-7.31 23.16-17.86C145.6 72.76 171.9 61.51 192.6 73.18c11.5 6.396 25.75 2.458 32.34-8.822c12.5-21.33 49.56-21.33 62.06 0c6.594 11.28 20.84 15.2 32.34 8.822c20.78-11.7 47.1-.4411 52.5 19.74c2.844 10.55 13.78 17.68 24.63 17.68c17.94 .1103 33.56 12.02 35.72 28.39C433.8 151.1 444.1 160 455.1 160c1.062 0 2.125-.063 3.188-.2048c13.13-1.764 22.38-13.93 20.63-27.17c-4.563-34.78-31.88-62.15-68-68.72c-17.34-32.89-58.35-51.66-96.5-40.96c-31-30.59-87.56-30.59-118.6 0C158.8 12.41 117.9 30.82 100.5 63.43C65.09 69.45 36.84 97.19 32.21 132.6C30.46 145.9 39.71 158 52.84 159.8z"],
    "bowling-ball": [512, 512, [], "f436", "M240 176c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S257.7 176 240 176zM144 144c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S161.7 144 144 144zM240 80c-17.67 0-32.05 14.33-32.05 32s14.37 32 32.05 32s31.95-14.33 31.95-32S257.7 80 240 80zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "bowling-ball-pin": [576, 512, [], "e0c3", "M122.7 224C107.9 224 96 235.9 96 250.7C96 265.5 107.9 277.3 122.7 277.3c14.75 0 26.67-11.88 26.67-26.67C149.3 235.9 137.4 224 122.7 224zM197.3 266.7c-14.75 0-26.67 11.88-26.67 26.67S182.6 320 197.3 320C212.1 320 224 308.1 224 293.3S212.1 266.7 197.3 266.7zM197.3 178.7c-14.75 0-26.67 11.88-26.67 26.67S182.6 232 197.3 232C212.1 232 224 220.1 224 205.3S212.1 178.7 197.3 178.7zM529.3 186c0-18.47 20-43.1 20-90.99c0-62.29-42.89-94.96-85.26-95.05c-42.36 0-85.4 32.65-85.4 95.05c0 46.97 20 72.66 20 90.99c0 8.293-1.801 17.1-4.25 26.12C360.5 143.4 289.9 96 208 96C93.13 96 0 189.1 0 304S93.13 512 208 512c64.5 0 122.1-29.36 160.3-75.45C383.7 477.3 398.1 512 439.7 512h48.76C560.8 512 576 372.3 576 354C576 290.5 529.3 232.6 529.3 186zM208 464c-88.22 0-160-71.78-160-160s71.78-160 160-160s160 71.78 160 160S296.2 464 208 464zM463.9 47.86c18.71 0 37.46 15.8 37.46 47.19c0 26.54-8.686 41.75-15.62 64.98h-43.44c-6.928-23.22-15.62-38.44-15.62-64.98C426.7 63.52 445.3 47.86 463.9 47.86zM497.7 457.8C495.8 461.7 492.3 464 488.4 464h-48.76c-3.922 0-7.395-2.293-9.814-7.195c-10.66-21.57-22.98-47.63-27.62-78.84C410.1 354.1 416 330.1 416 304c0-3.875-.3711-7.652-.5801-11.47c12.08-30.12 24.35-55.83 29.21-84.5h38.73C492.2 260.2 528 308.8 528 354C528 396.2 511.6 429.6 497.7 457.8z"],
    "bowling-pins": [512, 512, [], "f437", "M449.3 186c0-18.45 20-43.99 20-90.99c0-62.29-43.01-94.96-85.38-95.05c-42.36 0-85.28 32.65-85.28 95.05c0 46.98 20 72.66 20 90.99c0 46.74-46.67 104-46.67 167.1C272 372.4 287.3 512 359.7 512h48.76C480.8 512 496 372.3 496 354C496 290.5 449.3 232.6 449.3 186zM383.9 47.86c18.71 0 37.46 15.8 37.46 47.19c0 26.54-8.699 41.8-15.62 64.98h-43.44c-6.921-23.2-15.62-38.44-15.62-64.98C346.7 63.52 365.3 47.86 383.9 47.86zM417.7 457.8C415.8 461.7 412.3 464 408.4 464h-48.76c-3.922 0-7.395-2.293-9.814-7.195C336.5 429.9 320 396.4 320 354c0-45.15 35.77-93.76 44.63-145.1h38.73C412.2 260.2 448 308.8 448 354C448 396.2 431.6 429.6 417.7 457.8zM193.3 186c0-18.45 20-43.99 20-90.99c0-62.29-43.01-94.96-85.38-95.05c-42.36 0-85.28 32.65-85.28 95.05c0 46.98 20 72.66 20 90.99C62.67 232.8 16 290.1 16 354C16 372.4 31.31 512 103.7 512h48.76C224.8 512 240 372.3 240 354C240 290.5 193.3 232.6 193.3 186zM127.9 47.86c18.71 0 37.46 15.8 37.46 47.19c0 26.54-8.699 41.8-15.62 64.98H106.3C99.36 136.8 90.67 121.6 90.67 95.05C90.67 63.52 109.3 47.86 127.9 47.86zM161.7 457.8C159.8 461.7 156.3 464 152.4 464H103.7c-3.922 0-7.395-2.293-9.814-7.195C80.55 429.9 64 396.4 64 354c0-45.15 35.77-93.76 44.63-145.1h38.73C156.2 260.2 192 308.8 192 354C192 396.2 175.6 429.6 161.7 457.8z"],
    "box": [448, 512, [62566], "1f4e6", "M439.8 145.4l-45.43-80.76C383 44.47 361.7 32 338.6 32H109.4c-23.12 0-44.45 12.47-55.78 32.62L8.219 145.4C2.83 154.1 0 165.8 0 176.8V416c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V176.8C448 165.8 445.2 154.1 439.8 145.4zM352.5 88.15l39.67 70.52h-145.2V80h91.55C344.3 80 349.7 83.13 352.5 88.15zM95.48 88.15C98.31 83.13 103.7 80 109.4 80h89.59v78.67H55.82L95.48 88.15zM384 432H64c-8.822 0-16-7.178-16-16V206.7h352V416C400 424.8 392.8 432 384 432z"],
    "box-archive": [512, 512, ["archive"], "f187", "M464 32h-416C21.49 32 0 53.49 0 80v64C0 161.6 14.4 176 31.1 176L32 416c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V176c17.6 0 32-14.4 32-31.1V80C512 53.49 490.5 32 464 32zM416 432H96c-8.837 0-16-7.163-16-16V176h352V416C432 424.8 424.8 432 416 432zM464 128h-416V80h416V128zM183.1 272h144C341.3 272 352 261.3 352 248C352 234.7 341.3 224 328 224H183.1C170.7 224 160 234.7 160 247.1C160 261.3 170.7 272 183.1 272z"],
    "box-ballot": [576, 512, [63285], "1f5f3", "M520 160H480v48h40c4.406 0 8 3.594 8 8V320h-480V216c0-4.406 3.594-8 8-8H96V160H56C25.13 160 0 185.1 0 216v240C0 486.9 25.13 512 56 512h464c30.88 0 56-25.12 56-56v-240C576 185.1 550.9 160 520 160zM528 456c0 4.406-3.594 8-8 8H56c-4.406 0-8-3.594-8-8V368h480V456zM160 256h256c17.67 0 32-14.33 32-32V32c0-17.67-14.33-32-32-32H160C142.3 0 128 14.33 128 32v192C128 241.7 142.3 256 160 256zM176 48h224v160h-224V48z"],
    "box-check": [448, 512, [], "f467", "M183 376.1C187.7 381.7 193.9 384 200 384s12.28-2.344 16.97-7.031l96-96c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L200 326.1L168.1 295c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L183 376.1zM439.8 145.4l-45.43-80.76C383 44.47 361.7 32 338.6 32H109.4c-23.12 0-44.45 12.47-55.78 32.62L8.219 145.4C2.83 154.1 0 165.8 0 176.8V416c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V176.8C448 165.8 445.2 154.1 439.8 145.4zM247 80h91.55c5.771 0 11.12 3.125 13.95 8.154l39.67 70.52h-145.2V80zM95.48 88.15C98.31 83.13 103.7 80 109.4 80h89.59v78.67H55.82L95.48 88.15zM400 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V206.7h352V416z"],
    "box-circle-check": [576, 512, [], "e0c4", "M432 224C352.5 224 288 288.5 288 368s64.46 144 144 144C511.5 512 576 447.5 576 368S511.5 224 432 224zM499.3 341.1l-74.66 74.66c-3.125 3.125-7.219 4.688-11.31 4.688s-8.188-1.562-11.31-4.688l-37.34-37.33c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0l26.03 26.02l63.34-63.34c6.25-6.25 16.38-6.25 22.62 0S505.6 335.7 499.3 341.1zM64 432c-8.822 0-16-7.178-16-16V206.7h313.7C383.3 197.3 407 192 432 192c5.402 0 10.72 .3301 16 .8066V176.8c0-10.99-2.83-21.8-8.219-31.38l-45.43-80.76C383 44.47 361.7 32 338.6 32H109.4c-23.12 0-44.45 12.47-55.78 32.62L8.219 145.4C2.83 154.1 0 165.8 0 176.8V416c0 35.35 28.65 64 64 64h232.2c-11.78-14.26-21.2-30.48-28.05-48H64zM247 80h91.55c5.771 0 11.12 3.125 13.95 8.154l39.67 70.52h-145.2V80zM95.48 88.15C98.31 83.13 103.7 80 109.4 80h89.59v78.67H55.82L95.48 88.15z"],
    "box-dollar": [448, 512, ["box-usd"], "f4a0", "M439.8 145.4l-45.43-80.76C383 44.47 361.7 32 338.6 32H109.4c-23.12 0-44.45 12.47-55.78 32.62L8.219 145.4C2.83 154.1 0 165.8 0 176.8V416c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V176.8C448 165.8 445.2 154.1 439.8 145.4zM247 80h91.55c5.771 0 11.12 3.125 13.95 8.154l39.67 70.52h-145.2V80zM95.48 88.15C98.31 83.13 103.7 80 109.4 80h89.59v78.67H55.82L95.48 88.15zM400 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V206.7h352V416zM216.1 358.6C210.8 357.7 203 354.9 196.1 352.4l-3.703-1.328C184.1 348.1 174.1 352.5 172 360.8c-2.953 8.328 1.406 17.47 9.734 20.42l3.547 1.266c7.045 2.543 14.91 5.148 22.75 6.783L208 400c0 8.844 7.167 16 16.01 16s15.99-7.156 15.99-16l.0104-10.39c19.35-3.846 33.11-15.41 36.19-33.22c6.281-36.3-27.65-46.02-47.86-51.8L223.6 303.2C201.1 296.9 202.5 293.6 203.3 289.1c1.328-7.703 14.8-9.766 27.64-7.703c4.922 .7656 10.36 2.469 15.52 4.25c8.281 2.828 17.47-1.547 20.34-9.906c2.891-8.344-1.547-17.45-9.906-20.34c-5.6-1.934-11.33-3.35-16.88-4.52V240c0-8.844-7.156-16-16-16s-16 7.156-16 16v10.07C188.5 253.9 174.9 265.7 171.8 283.6c-6.203 35.89 28.14 45.98 42.8 50.28l5.083 1.474c25.41 7.281 25.98 10.01 25.03 15.54C243.3 358.6 229.7 360.7 216.1 358.6z"],
    "box-heart": [448, 512, [], "f49d", "M142.9 325.3c-21-20.75-19.88-55.13 3.75-74.25c23.75-19.25 54.75-10.25 70 4.75l7.375 7.375l7.375-7.375c15.75-15.38 46.5-23.88 70-4.75c23.62 19.12 24.88 53.5 3.75 74.25l-72.63 71.25c-4.625 4.625-12.25 4.625-17 0L142.9 325.3zM448 176.8V416c0 35.35-28.65 64-64 64H64c-35.35 0-64-28.65-64-64V176.8C0 165.8 2.83 154.1 8.219 145.4l45.43-80.76C64.98 44.47 86.31 32 109.4 32h229.1c23.12 0 44.45 12.47 55.78 32.62l45.43 80.76C445.2 154.1 448 165.8 448 176.8zM247 158.7h145.2l-39.67-70.52C349.7 83.13 344.3 80 338.6 80h-91.55V158.7zM55.82 158.7h143.2V80H109.4c-5.771 0-11.12 3.125-13.95 8.154L55.82 158.7zM400 206.7h-352V416c0 8.822 7.178 16 16 16h320c8.822 0 16-7.178 16-16V206.7z"],
    "box-open": [640, 512, [], "f49e", "M228.3 216.1L320 64L69.77 32.13C62.9 31.26 56.24 34.77 53.24 41.02L1.755 143.8C-2.87 153.1 2.039 164.1 11.79 166.8l197.1 56.53C216.8 225.4 224.4 222.4 228.3 216.1zM638.3 143.8l-51.49-102.8c-3-6.25-9.757-9.758-16.63-8.883L320 64l91.74 152.1c3.752 6.25 11.38 9.261 18.51 7.261l197.9-56.51C638 164 642.8 153 638.3 143.8zM528 380.8l-184 45.77V192c0-13.25-10.75-24-24-24S296 178.8 296 192v234.6L112 380.8V230.2L64 216.5v176.1c0 14.67 9.1 27.35 24.25 30.83l216.1 53.82C309.5 479.4 314.8 480 319.1 480s10.34-.6224 15.4-1.865l216.4-53.82C565.1 420.7 576 408 576 393.5V216.5l-48 13.63V380.8z"],
    "box-open-full": [640, 512, ["box-full"], "f49c", "M228.3 344.1l91.73-152.1l-250.2-31.87C62.9 159.3 56.24 162.8 53.24 169L1.755 271.8C-2.87 281.1 2.038 292.1 11.79 294.8l197.1 56.53C216.8 353.4 224.4 350.4 228.3 344.1zM528 412.8l-184 45.77V320c0-13.25-10.75-24-24-24S296 306.8 296 320v138.6L112 412.8v-54.6L64 344.5v80.99c0 14.67 9.1 27.35 24.25 30.83l216.1 53.82C309.5 511.4 314.8 512 319.1 512s10.34-.6224 15.4-1.865l216.4-53.82C565.1 452.7 576 440 576 425.5v-80.99l-48 13.63V412.8zM638.3 271.8L586.8 169c-3-6.25-9.757-9.758-16.63-8.883l-250.2 31.87l91.74 152.1c3.752 6.25 11.38 9.261 18.51 7.261l197.9-56.51C638 292 642.8 281 638.3 271.8zM194.3 143.8C192.9 138.7 192 133.5 192 128.1c0-35.3 28.75-64.03 64-64.03s64 28.73 64 64.03c0 11.27-3.125 21.5-8.25 30.77l8.25 1.001l155.3-19.76l35.75-98.3c2.1-8.389-1.25-17.51-9.625-20.51l-55.5-20.26c-8.252-3.006-17.5 1.243-20.5 9.63l-41.63 114.4C382 55.71 325.8 0 256 0C185.3 0 128 57.19 128 128c0 2.504 .627 4.892 .752 7.396L194.3 143.8z"],
    "box-taped": [448, 512, ["box-alt"], "f49a", "M439.8 145.4l-45.43-80.76C383 44.47 361.7 32 338.6 32H109.4c-23.12 0-44.45 12.47-55.78 32.62L8.219 145.4C2.83 154.1 0 165.8 0 176.8V416c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V176.8C448 165.8 445.2 154.1 439.8 145.4zM352.5 88.15l39.67 70.52h-104.5L266.2 80h72.39C344.3 80 349.7 83.13 352.5 88.15zM95.48 88.15C98.31 83.13 103.7 80 109.4 80h72.39L160.4 158.7H55.82L95.48 88.15zM400 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V206.7H160V256c0 17.67 14.31 32 31.98 32H256c17.67 0 32-14.33 32-32V206.7h112V416z"],
    "box-tissue": [512, 512, [], "e05b", "M133.3 320h245.3c10.44 0 19.69-6.75 22.86-16.69l61.33-192C465.2 104 463.9 96.03 459.4 89.84C454.9 83.66 447.7 80 440 80h-104.8c-18.7 0-35.22-11.66-41.09-29.03C286.2 27.72 264.8 0 207.5 0H72C64.7 0 57.81 3.312 53.25 9C48.7 14.72 46.98 22.16 48.59 29.28l61.33 272C112.4 312.2 122.1 320 133.3 320zM207.5 48c34.88 0 39.22 12.84 41.08 18.34C261.1 103.2 295.8 128 335.2 128h71.98l-46 144H152.5l-50.5-224H207.5zM460.3 224.4L445.1 272H456c4.406 0 8 3.594 8 8v88h-416V280c0-4.406 3.594-8 8-8h14.52L59.69 224H56C25.13 224 0 249.1 0 280v176C0 486.9 25.13 512 56 512h400c30.88 0 56-25.12 56-56v-176C512 250.6 489.2 226.7 460.3 224.4zM464 456c0 4.406-3.594 8-8 8H56c-4.406 0-8-3.594-8-8V416h416V456z"],
    "boxes-stacked": [576, 512, [62625, "boxes", "boxes-alt"], "f468", "M208 224h160C394.5 224 416 202.5 416 176v-128C416 21.49 394.5 0 368 0h-160C181.5 0 160 21.49 160 48v128C160 202.5 181.5 224 208 224zM208 48H256v64L288 96l32 16v-64h48v128h-160V48zM208 288h-160C21.49 288 0 309.5 0 336v128C0 490.5 21.49 512 48 512h160C234.5 512 256 490.5 256 464v-128C256 309.5 234.5 288 208 288zM208 464h-160v-128H96v64L128 384l32 16v-64h48V464zM528 288h-160C341.5 288 320 309.5 320 336v128c0 26.51 21.49 48 48 48h160c26.51 0 48-21.49 48-48v-128C576 309.5 554.5 288 528 288zM528 464h-160v-128H416v64l32-16l32 16v-64h48V464z"],
    "boxing-glove": [512, 512, [62520, "glove-boxing"], "1f94a", "M417.6 130.1c-.4668-.207-1.096-.2874-1.577-.4671c-.0033-.0006 0 0 0 0s.0893 .0149 0 0c.0394 .0065 0 0 0 0s.0176 .0029 0 0c.0088 .0015-.0033-.0006 0 0L415.1 96c0-52.94-43.06-96-95.1-96H127.1C75.06 0 32.01 43.06 32.01 96L32 288c0 27.41 11.56 52.87 31.1 71.14L64 448c0 35.3 28.7 64 64 64h192c35.3 0 64-28.7 64-64v-57.38l63.19-63.19C468.3 306.3 480 278.2 480 248.2V208C480 169.9 453.2 138.1 417.6 130.1zM432 248.2c0 16.98-6.746 33.27-18.75 45.28L336 370.7V448c0 8.837-7.163 16-16 16H128c-8.837 0-16-7.163-16-16v-110.3l-16.01-14.31C85.81 314.3 80 301.3 80 287.7V96c0-26.51 21.49-48 48-48h192c26.51 0 48 21.49 48 48v32h-24c-37.22 0-68.92 23.29-81.77 56L227.1 183.1C175 183.1 144.9 152 128 152c-13.45 0-24.03 10.87-24.03 23.96C104 206.4 182.8 232 233.7 232h23.93C265.2 272.9 300.9 304 344 304c13.25 0 24-10.75 24-24S357.3 256 344 256c-22.06 0-40-17.94-40-40s17.94-40 40-40h56c17.67 0 32 14.33 32 32V248.2zM288 359.1c0-8.791-7.17-15.98-16.03-15.98c-3.056 0-6.137 .875-8.85 2.691L224 372.8l-39.13-26.09c-2.707-1.812-5.785-2.683-8.838-2.683c-8.862 0-16.04 7.164-16.04 15.97c0 5.172 2.505 10.25 7.126 13.34L195.2 392l-28.03 18.69c-4.621 3.087-7.126 8.167-7.126 13.34C159.1 432.8 167.1 440 176 440c3.062 0 6.156-.875 8.875-2.688L224 411.2l39.13 26.09C265.8 439.1 268.9 440 272 440c8.876 0 16-7.224 16-15.97c0-5.172-2.505-10.25-7.126-13.34L252.8 392l28.03-18.69C285.5 370.2 288 365.1 288 359.1z"],
    "bracket-curly": [256, 512, ["bracket-curly-left"], "7b", "M200 32H120C89.07 32 64 57.07 64 88v77.5c0 10.56-4.197 20.7-11.67 28.17L7 239C2.5 243.5 0 249.6 0 256c0 6.375 2.5 12.5 7 17l45.33 45.33C59.8 325.8 64 335.9 64 346.5V424C64 454.9 89.07 480 120 480h80C213.3 480 224 469.3 224 456S213.3 432 200 432H120c-4.4 0-8-3.6-8-8v-77.5c0-23.44-9.337-45.91-25.95-62.45L57.88 256l28.18-28.05C102.7 211.4 112 188.9 112 165.5V88c0-4.4 3.6-8 8-8h80C213.3 80 224 69.25 224 56S213.3 32 200 32z"],
    "bracket-curly-right": [256, 512, [], "7d", "M32 55.1C32 69.25 42.75 80 55.1 80H136c4.4 0 8 3.6 8 8v77.5c0 23.44 9.337 45.91 25.95 62.45L198.1 256l-28.18 28.05C153.3 300.6 144 323.1 144 346.5V424c0 4.4-3.6 8-8 8H55.1C42.75 432 32 442.7 32 455.1S42.75 480 55.1 480H136c30.93 0 56-25.07 56-56v-77.5c0-10.56 4.197-20.7 11.67-28.17L249 273C253.5 268.5 256 262.4 256 256c0-6.375-2.5-12.5-7-17l-45.33-45.33C196.2 186.2 192 176.1 192 165.5V88C192 57.07 166.9 32 136 32H55.1C42.75 32 32 42.75 32 55.1z"],
    "bracket-round": [192, 512, ["parenthesis"], "28", "M156.6 468.3c-4.5 7.5-12.47 11.69-20.62 11.69c-4.156 0-8.375-1.094-12.22-3.375c-5.031-3-123.7-75.31-123.7-220.6s118.7-217.6 123.7-220.6c11.44-6.781 26.12-3 32.91 8.344c6.781 11.38 3.031 26.09-8.344 32.91c-4.625 2.813-100.3 62.25-100.3 179.4c0 117.5 96.25 176.9 100.3 179.4C159.7 442.2 163.3 456.1 156.6 468.3z"],
    "bracket-round-right": [192, 512, [], "29", "M43.66 435.4c4.094-2.469 100.3-61.91 100.3-179.4c0-117.1-95.65-176.6-100.3-179.4C32.35 69.81 28.6 55.09 35.38 43.72C42.16 32.37 56.85 28.59 68.28 35.37C73.32 38.37 192 110.7 192 256s-118.7 217.6-123.7 220.6c-3.844 2.281-8.062 3.375-12.22 3.375c-8.156 0-16.12-4.188-20.62-11.69C28.66 456.1 32.35 442.2 43.66 435.4z"],
    "bracket-square": [192, 512, ["bracket", "bracket-left"], "5b", "M120 32H32C14.4 32 0 46.4 0 64v384c0 17.6 14.4 32 32 32h88c13.25 0 24-10.75 24-23.1S133.3 432 120 432H48v-352h72C133.3 80 144 69.25 144 56S133.3 32 120 32z"],
    "bracket-square-right": [192, 512, [], "5d", "M48 55.1C48 69.25 58.75 80 71.1 80H144v352H71.1C58.75 432 48 442.7 48 455.1S58.75 480 72 480H160c17.6 0 32-14.4 32-32V64c0-17.6-14.4-32-32-32H72C58.75 32 48 42.75 48 55.1z"],
    "brackets-curly": [576, 512, [], "f7ea", "M200 32H120C89.07 32 64 57.07 64 88v77.5c0 10.56-4.197 20.7-11.67 28.17L7 239C2.5 243.5 0 249.6 0 256c0 6.375 2.5 12.5 7 17l45.33 45.33C59.8 325.8 64 335.9 64 346.5V424C64 454.9 89.07 480 120 480h80C213.3 480 224 469.3 224 456S213.3 432 200 432H120c-4.4 0-8-3.6-8-8v-77.5c0-23.44-9.337-45.91-25.95-62.45L57.88 256l28.18-28.05C102.7 211.4 112 188.9 112 165.5V88c0-4.4 3.6-8 8-8h80C213.3 80 224 69.25 224 56S213.3 32 200 32zM569 239l-45.33-45.33C516.2 186.2 512 176.1 512 165.5V88C512 57.07 486.9 32 456 32h-80C362.7 32 352 42.75 352 55.1S362.7 80 375.1 80H456c4.4 0 8 3.6 8 8v77.5c0 23.37 9.284 45.78 25.81 62.31L517.1 256l-28.19 28.19C473.3 300.7 464 323.1 464 346.5V424c0 4.4-3.6 8-8 8h-80C362.7 432 352 442.7 352 455.1S362.7 480 375.1 480H456c30.93 0 56-25.07 56-56v-77.5c0-10.56 4.197-20.7 11.67-28.17L569 273C573.5 268.5 576 262.4 576 256C576 249.6 573.5 243.5 569 239z"],
    "brackets-round": [512, 512, ["parentheses"], "e0c5", "M148.3 76.62c11.38-6.813 15.12-21.53 8.344-32.91c-6.781-11.34-21.5-15.13-32.91-8.344C118.7 38.37 0 110.7 0 256s118.7 217.6 123.7 220.6c3.844 2.281 8.062 3.375 12.22 3.375c8.156 0 16.12-4.188 20.62-11.69c6.781-11.34 3.094-26.06-8.219-32.91C144.3 432.9 48 373.5 48 255.1C48 138.9 143.7 79.44 148.3 76.62zM388.3 35.37c-11.38-6.781-26.03-3-32.84 8.313c-6.781 11.34-3.094 26.06 8.219 32.91C367.8 79.06 464 138.5 464 255.1s-96.25 176.9-100.3 179.4c-11.38 6.781-15.12 21.5-8.344 32.91c4.5 7.531 12.47 11.72 20.66 11.72c4.156 0 8.406-1.094 12.25-3.375C393.3 473.6 512 401.3 512 256S393.3 38.37 388.3 35.37z"],
    "brackets-square": [448, 512, ["brackets"], "f7e9", "M120 32H32C14.4 32 0 46.4 0 64v384c0 17.6 14.4 32 32 32h88C133.3 480 144 469.3 144 456S133.3 432 120 432H48v-352h72C133.3 80 144 69.25 144 56S133.3 32 120 32zM416 32h-88C314.7 32 304 42.75 304 55.1S314.7 80 327.1 80H400v352h-72C314.7 432 304 442.7 304 455.1S314.7 480 327.1 480H416c17.6 0 32-14.4 32-32V64C448 46.4 433.6 32 416 32z"],
    "braille": [640, 512, [], "f2a1", "M80 48c-35.38 0-64 28.62-64 64s28.62 64 64 64s64-28.62 64-64S115.4 48 80 48zM80 128C71.18 128 64 120.8 64 112S71.18 96 80 96S96 103.2 96 112S88.82 128 80 128zM80 208c-35.38 0-64 28.62-64 64s28.62 64 64 64s64-28.62 64-64S115.4 208 80 208zM80 288C71.18 288 64 280.8 64 272S71.18 256 80 256S96 263.2 96 272S88.82 288 80 288zM592 144c17.62 0 32-14.38 32-32s-14.38-32-32-32s-32 14.38-32 32S574.4 144 592 144zM80 400c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S97.63 400 80 400zM240 400c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S257.6 400 240 400zM432 400c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S449.6 400 432 400zM240 240c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S257.6 240 240 240zM592 240c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S609.6 240 592 240zM432 48c-35.38 0-64 28.62-64 64s28.62 64 64 64s64-28.62 64-64S467.4 48 432 48zM432 128C423.2 128 416 120.8 416 112S423.2 96 432 96S448 103.2 448 112S440.8 128 432 128zM592 400c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S609.6 400 592 400zM240 48c-35.38 0-64 28.62-64 64s28.62 64 64 64s64-28.62 64-64S275.4 48 240 48zM240 128C231.2 128 224 120.8 224 112S231.2 96 240 96S256 103.2 256 112S248.8 128 240 128zM432 240c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S449.6 240 432 240z"],
    "brain": [512, 512, [62940], "1f9e0", "M512 296c0-27.52-9.83-53.08-26.87-72.85C487 215.7 488 207.9 488 200c0-32.44-16.08-61.29-41.1-78.64c-4.381-28.76-21.49-53.51-45.96-67.91C387.5 22.06 356.3 0 320 0c-25.19 0-47.94 10.64-64 27.66C239.9 10.64 217.2 0 192 0C155.7 0 124.5 22.06 111.1 53.46C86.6 67.86 69.48 92.61 65.1 121.4C40.08 138.7 24 167.6 24 200c0 7.879 .9805 15.65 2.867 23.15C9.832 242.9 0 268.5 0 296c0 29.66 11.89 57.62 32.02 78.19C32.01 374.8 32 375.4 32 376c0 47.12 34.13 86.43 78.96 94.5C127.3 495.6 155.6 512 188 512c26.91 0 51.16-11.62 68-30.1C272.8 500.4 297.1 512 324 512c32.42 0 60.7-16.38 77.04-41.49C445.9 462.4 480 423.1 480 376c0-.6035-.0059-1.197-.0176-1.801C500.1 353.6 512 325.7 512 296zM232 419.1C232 444.3 212.3 464 188 464c-23.94 0-43.32-19.14-43.89-42.95C139 422.9 133.7 424 128 424c-26.51 0-48-21.49-48-48c0-7.93 2.105-15.3 5.51-21.89C63.42 344 48 321.9 48 296c0-27.24 17.08-50.34 41.06-59.59C78.71 227.6 72 214.7 72 200c0-24.83 18.92-45.02 43.09-47.51C113.2 147.3 112 141.8 112 136c0-23.83 17.4-43.45 40.16-47.21C152.2 88.51 152 88.28 152 88C152 65.91 169.9 48 192 48s40 17.91 40 40V419.1zM426.5 354.1C429.9 360.7 432 368.1 432 376c0 26.51-21.49 48-48 48c-5.68 0-11.05-1.16-16.11-2.971C367.3 444.9 347.9 464 324 464c-24.3 0-44-19.7-44-44V88C280 65.91 297.9 48 320 48s40 17.91 40 40c0 .2793-.1543 .5098-.1602 .7891C382.6 92.55 400 112.2 400 136c0 5.822-1.193 11.33-3.092 16.49C421.1 154.1 440 175.2 440 200c0 14.65-6.707 27.61-17.06 36.42C446.9 245.7 464 268.8 464 296C464 321.9 448.6 344 426.5 354.1z"],
    "brain-arrow-curved-right": [640, 512, ["mind-share"], "f677", "M634.9 339.8L538.9 244.6c-10.12-10-26.1-2.625-26.1 12.13V304h-79.87c-5.624 0-11.25-.125-16.1 .75c-47.12 7-85.61 44.5-93.36 91.5c-7.874 46.75 13.25 89.5 48.24 113c9.749 6.5 21.62-3.25 17.75-14.5c-8.999-26.5-5.499-94.63 60.37-94.63h63.99v47.12c0 14.88 16.87 22.25 26.1 12.25l95.99-95.25C641.7 357.6 641.7 346.4 634.9 339.8zM289.1 391c1.25-8 3.375-15.75 6.125-23.25V82C296.1 63.25 311.3 48 330.2 48c15.5 0 29.12 10.5 32.1 25.62l4.749 18.88l22.87-1.25c16.5 .125 31.87 15.5 31.87 34.13c0 4.375-.375 5.375-5.499 27.25l18.1 7.625c13.62 5.625 42.62 30.25 24.1 66l-9.874 20l19.5 11.25c3.5 2 6.249 4.5 8.874 6.875l.1458-7.727c0-22 14.35-40.4 34.1-46.52C514.1 208.4 514.7 206.8 514.7 205c0-33-16.75-62.1-43.74-80.62c-.375-39.62-29.37-72.75-67.49-79.75C389.8 17.75 361.7 0 330.2 0C307.5 0 286.8 9.25 271.1 24.12C256.5 8.625 235.6 0 213.7 0C182.2 0 154.1 17.75 140.4 44.88C102.2 51.88 73.24 85 72.87 124.8C45.74 142.2 29.25 172.2 29.25 205.2c0 7.75 .9999 15.5 2.875 23C11.87 246.2 0 272.2 0 299.5c0 33 16.75 63 43.74 80.63c.4999 47.5 38.5 86.12 85.74 88.25C145.4 495.1 174.4 512 206.2 512c25.1 0 49.24-11.25 65.62-28.75c13.37 14.38 31.5 24 51.87 27.25C295.7 478.2 282.7 434.6 289.1 391zM247.7 422.8C247.7 445.6 229.2 464 206.3 464c-32.87 0-39.5-29.5-45.62-47.63l-20.25 3.375c-23.1 4-48.49-15.25-48.49-40.5c0-2.75 4.749-27.37 4.749-27.37l-18.25-7.5C41.62 329.2 37.25 278.2 72.99 257.8l19.5-11.13L82.61 226.5C64.99 190.8 93.99 166 107.7 160.4L126.6 152.8c-4.999-22-5.499-22.88-5.499-27.25c0-18.75 15.25-34 31.87-34.12l22.87 1.25l4.874-18.87c3.874-15.13 17.37-25.63 32.87-25.63c18.87 0 34.12 15.12 34.12 34V422.8z"],
    "brain-circuit": [512, 512, [], "e0c6", "M512 296c0-27.52-9.83-53.08-26.87-72.85C487 215.7 488 207.9 488 200c0-32.44-16.08-61.29-41.1-78.64c-4.381-28.76-21.49-53.51-45.96-67.91C387.5 22.06 356.3 0 320 0c-25.19 0-47.94 10.64-64 27.66C239.9 10.64 217.2 0 192 0C155.7 0 124.5 22.06 111.1 53.46C86.6 67.86 69.48 92.61 65.1 121.4C40.08 138.7 24 167.6 24 200c0 7.879 .9805 15.65 2.867 23.15C9.832 242.9 0 268.5 0 296c0 29.66 11.89 57.62 32.02 78.19C32.01 374.8 32 375.4 32 376c0 47.12 34.13 86.43 78.96 94.5C127.3 495.6 155.6 512 188 512c26.91 0 51.16-11.62 68-30.1C272.8 500.4 297.1 512 324 512c32.42 0 60.7-16.38 77.04-41.49C445.9 462.4 480 423.1 480 376c0-.6035-.0059-1.197-.0176-1.801C500.1 353.6 512 325.7 512 296zM232 144H212.6C206.4 129.9 192.4 120 176 120C153.9 120 136 137.9 136 160S153.9 200 176 200c16.38 0 30.38-9.9 36.57-24H232v64H176C149.5 240 128 261.5 128 288v19.43C113.9 313.6 104 327.6 104 344C104 366.1 121.9 384 144 384s40-17.91 40-40c0-16.38-9.9-30.38-24-36.57V288c0-8.828 7.172-16 16-16h56v147.1C232 444.3 212.3 464 188 464c-23.94 0-43.32-19.14-43.89-42.95C139 422.9 133.7 424 128 424c-26.51 0-48-21.49-48-48c0-7.93 2.105-15.3 5.51-21.89C63.42 344 48 321.9 48 296c0-27.24 17.08-50.34 41.06-59.59C78.71 227.6 72 214.7 72 200c0-24.83 18.92-45.02 43.09-47.51C113.2 147.3 112 141.8 112 136c0-23.83 17.4-43.45 40.16-47.21C152.2 88.51 152 88.28 152 88C152 65.91 169.9 48 192 48s40 17.91 40 40V144zM192 160c0 8.822-7.178 16-16 16S160 168.8 160 160s7.178-16 16-16S192 151.2 192 160zM160 344c0 8.822-7.178 16-16 16S128 352.8 128 344s7.178-16 16-16S160 335.2 160 344zM426.5 354.1C429.9 360.7 432 368.1 432 376c0 26.51-21.49 48-48 48c-5.68 0-11.05-1.16-16.11-2.971C367.3 444.9 347.9 464 324 464c-24.3 0-44-19.7-44-44V360h35.43C321.6 374.1 335.6 384 352 384c22.09 0 40-17.91 40-40S374.1 304 352 304c-16.38 0-30.38 9.9-36.57 24H280V272h24C330.5 272 352 250.5 352 224V196.6C366.1 190.4 376 176.4 376 160c0-22.09-17.91-40-40-40S296 137.9 296 160c0 16.38 9.9 30.38 24 36.57V224c0 8.828-7.172 16-16 16h-24V88C280 65.91 297.9 48 320 48s40 17.91 40 40c0 .2793-.1543 .5098-.1602 .7891C382.6 92.55 400 112.2 400 136c0 5.822-1.193 11.33-3.092 16.49C421.1 154.1 440 175.2 440 200c0 14.65-6.707 27.61-17.06 36.42C446.9 245.7 464 268.8 464 296C464 321.9 448.6 344 426.5 354.1zM336 344c0-8.822 7.178-16 16-16s16 7.178 16 16s-7.178 16-16 16S336 352.8 336 344zM320 160c0-8.822 7.178-16 16-16S352 151.2 352 160s-7.178 16-16 16S320 168.8 320 160z"],
    "brake-warning": [640, 512, [], "e0c7", "M319.1 288c13.25 0 23.1-10.75 23.1-24v-112c0-13.25-10.75-24-23.1-24S295.1 138.8 295.1 152v112C295.1 277.3 306.7 288 319.1 288zM320 320C302.4 320 288 334.4 288 352c0 17.75 14.39 32 32.02 32S352 369.8 352 352C352 334.4 337.6 320 320 320zM320 32C196.3 32 96 132.3 96 256c0 123.7 100.3 224 224 224c123.7 0 224-100.3 224-224C544 132.3 443.7 32 320 32zM320 432c-97.05 0-176-78.95-176-176S222.1 80 320 80s176 78.95 176 176S417 432 320 432zM83.94 75.83C72.72 68.61 57.91 71.88 50.75 83C17.56 134.5 0 194.4 0 256s17.56 121.5 50.75 173C55.34 436.1 63.06 440 70.97 440c4.438 0 8.938-1.234 12.97-3.828C95.09 429 98.28 414.1 91.13 403C62.91 359.2 48 308.4 48 256s14.91-103.2 43.13-147C98.28 97.86 95.09 83 83.94 75.83zM589.3 83c-7.156-11.12-22-14.39-33.19-7.172C544.9 83 541.7 97.86 548.9 109C577.1 152.8 592 203.6 592 256s-14.91 103.2-43.13 147c-7.156 11.14-3.969 26 7.188 33.17C560.1 438.8 564.6 440 569 440c7.906 0 15.62-3.875 20.22-11C622.4 377.5 640 317.6 640 256S622.4 134.5 589.3 83z"],
    "bread-loaf": [640, 512, [63467], "1f35e", "M400 32h-160C107.5 32 0 103.6 0 192c0 35.38 26.88 64 60 64H64v192c0 17.62 14.38 32 32 32h448c17.62 0 32-14.38 32-32V256h4C613.1 256 640 227.4 640 192C640 103.6 532.5 32 400 32zM420 208H368v224h-256v-224H60C54.25 208 48 201.6 48 192c0-59.62 89.75-112 192-112s192 52.38 192 112C432 201.6 425.8 208 420 208z"],
    "bread-slice": [512, 512, [], "f7ec", "M256 32C132.4 32 0 96.29 0 192c0 35.29 26.92 64 60 64H64v176C64 458.5 85.49 480 112 480h288c26.51 0 48-21.49 48-48V256h4C485.1 256 512 227.3 512 192C512 96.29 379.6 32 256 32zM452 208H400v224h-288v-224H60C54.25 208 48 201.6 48 192c0-59.63 105.8-112 208-112s208 52.38 208 112C464 201.6 457.8 208 452 208z"],
    "briefcase": [512, 512, [61617], "1f4bc", "M448 96h-64V64c0-35.35-28.65-64-64-64H192C156.7 0 128 28.65 128 64v32H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM192 48h128c8.837 0 16 7.163 16 16v32h-160V64C176 55.16 183.2 48 192 48zM64 144h384c8.8 0 16 7.2 16 16v96h-416V160C48 151.2 55.2 144 64 144zM448 432H64c-8.8 0-16-7.2-16-16V304H192V320c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V304h144V416C464 424.8 456.8 432 448 432z"],
    "briefcase-arrow-right": [512, 512, [], "e2f2", "M296.1 191c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L302.1 264H152C138.8 264 128 274.8 128 288s10.75 24 24 24h150.1l-39.03 39.03C258.3 355.7 256 361.8 256 368s2.344 12.28 7.031 16.97c9.375 9.375 24.56 9.375 33.94 0l80-80c9.375-9.375 9.375-24.56 0-33.94L296.1 191zM448 96h-64V64c0-35.35-28.65-64-64-64H192C156.7 0 128 28.65 128 64v32H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM176 64c0-8.838 7.164-16 16-16h128c8.836 0 16 7.162 16 16v32h-160V64zM464 416c0 8.799-7.199 16-16 16H64c-8.801 0-16-7.201-16-16V160c0-8.801 7.199-16 16-16h384c8.801 0 16 7.199 16 16V416z"],
    "briefcase-blank": [512, 512, [], "e0c8", "M448 96h-64V64c0-35.35-28.65-64-64-64H192C156.7 0 128 28.65 128 64v32H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM176 64c0-8.838 7.164-16 16-16h128c8.836 0 16 7.162 16 16v32h-160V64zM464 416c0 8.799-7.199 16-16 16H64c-8.801 0-16-7.201-16-16V160c0-8.801 7.199-16 16-16h384c8.801 0 16 7.199 16 16V416z"],
    "briefcase-clock": [640, 512, ["business-time"], "f64a", "M496 224C416.5 224 352 288.5 352 368s64.47 144 144 144s144-64.47 144-144S575.5 224 496 224zM544 384h-48c-8.844 0-16-7.156-16-16v-64C480 295.2 487.2 288 496 288S512 295.2 512 304V352h32c8.844 0 16 7.156 16 16S552.8 384 544 384zM64 432c-8.801 0-16-7.201-16-16V304H192V320c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V304h12.18c6.85-17.52 16.27-33.74 28.05-48H48V160c0-8.801 7.199-16 16-16h384c8.801 0 16 7.199 16 16v35.05C474.4 193.1 485.1 192 496 192c5.402 0 10.72 .3301 16 .8066V160c0-35.35-28.65-64-64-64h-64V64c0-35.35-28.65-64-64-64H192C156.7 0 128 28.65 128 64v32H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h296.2c-11.78-14.26-21.2-30.48-28.05-48H64zM176 64c0-8.838 7.164-16 16-16h128c8.836 0 16 7.162 16 16v32h-160V64z"],
    "briefcase-medical": [512, 512, [], "f469", "M448 96h-64V64c0-35.35-28.65-64-64-64H192C156.7 0 128 28.65 128 64v32H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM176 64c0-8.838 7.164-16 16-16h128c8.836 0 16 7.162 16 16v32h-160V64zM464 416c0 8.799-7.199 16-16 16H64c-8.801 0-16-7.201-16-16V160c0-8.801 7.199-16 16-16h384c8.801 0 16 7.199 16 16V416zM336 256H288V208C288 199.2 280.8 192 272 192h-32C231.2 192 224 199.2 224 208V256H176C167.2 256 160 263.2 160 272v32C160 312.8 167.2 320 176 320H224v48C224 376.8 231.2 384 240 384h32c8.836 0 16-7.164 16-16V320h48c8.836 0 16-7.164 16-16v-32C352 263.2 344.8 256 336 256z"],
    "brightness": [512, 512, [], "e0c9", "M488 232h-64c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24h64C501.3 280 512 269.3 512 256C512 242.7 501.3 232 488 232zM112 256c0-13.26-10.75-24-24-24h-64C10.75 232 0 242.7 0 256c0 13.25 10.75 24 24 24h64C101.3 280 112 269.3 112 256zM391.8 357.8c-9.371-9.371-24.57-9.371-33.94 .0023s-9.368 24.57 .0047 33.94l45.25 45.26c9.371 9.371 24.57 9.37 33.95-.0016c9.373-9.373 9.366-24.57-.0047-33.94L391.8 357.8zM120.2 154.2c9.371 9.373 24.57 9.371 33.94-.0016c9.375-9.373 9.368-24.57-.0047-33.94L108.9 74.98C99.55 65.61 84.35 65.61 74.98 74.98C65.6 84.35 65.61 99.55 74.98 108.9L120.2 154.2zM120.2 357.8l-45.26 45.26c-9.371 9.371-9.376 24.57-.0047 33.94c9.373 9.373 24.57 9.373 33.95 .0016l45.25-45.26c9.373-9.371 9.38-24.57 .0047-33.94C144.8 348.5 129.6 348.5 120.2 357.8zM391.8 154.2l45.26-45.25c9.371-9.373 9.378-24.57 .0047-33.94s-24.58-9.375-33.95-.0016l-45.25 45.25c-9.373 9.373-9.378 24.57-.0047 33.94C367.2 163.5 382.4 163.5 391.8 154.2zM256 400c-13.25 0-24 10.75-24 24v64C232 501.3 242.7 512 256 512c13.26 0 24-10.75 24-24v-64C280 410.7 269.3 400 256 400zM256 112c13.26 0 24-10.75 24-24v-64C280 10.75 269.3 0 256 0C242.7 0 232 10.75 232 24v64C232 101.3 242.7 112 256 112zM256 160C202.1 160 160 202.1 160 256c0 53.02 42.98 96 96 96s96-42.98 96-96C352 202.1 309 160 256 160zM256 304C229.5 304 208 282.5 208 256S229.5 208 256 208s48 21.53 48 48S282.5 304 256 304z"],
    "brightness-low": [448, 512, [], "e0ca", "M329.4 361.4c-12.5 12.5-12.51 32.75 0 45.26c12.51 12.51 32.76 12.5 45.25 0s12.51-32.75 0-45.26C362.1 348.9 341.9 348.9 329.4 361.4zM224 112c17.67 0 32-14.31 32-32s-14.33-32-32-32s-32 14.31-32 32S206.3 112 224 112zM374.6 150.6c12.51-12.51 12.5-32.76 0-45.25s-32.75-12.51-45.25 0c-12.51 12.51-12.5 32.76 0 45.25C341.9 163.1 362.1 163.1 374.6 150.6zM80 256c0-17.67-14.31-32-32-32s-32 14.33-32 32s14.31 32 32 32S80 273.7 80 256zM118.6 150.6c12.5-12.5 12.51-32.75 0-45.25c-12.51-12.51-32.76-12.5-45.25 0s-12.51 32.75 0 45.25C85.88 163.1 106.1 163.1 118.6 150.6zM400 224c-17.69 0-32 14.33-32 32s14.31 32 32 32s32-14.33 32-32S417.7 224 400 224zM73.37 361.4c-12.51 12.51-12.5 32.76 0 45.26s32.75 12.51 45.25 0c12.51-12.51 12.5-32.76 0-45.26C106.1 348.9 85.88 348.9 73.37 361.4zM224 400c-17.67 0-32 14.31-32 32s14.33 32 32 32s32-14.31 32-32S241.7 400 224 400zM224 160C170.1 160 128 202.1 128 256c0 53.02 42.98 96 96 96s96-42.98 96-96C320 202.1 277 160 224 160zM224 304C197.5 304 176 282.5 176 256S197.5 208 224 208s48 21.53 48 48S250.5 304 224 304z"],
    "bring-forward": [512, 512, [], "f856", "M352 288V64c0-35.35-28.65-64-64-64H64C28.65 0 0 28.65 0 64v224c0 35.35 28.65 64 64 64h224C323.3 352 352 323.3 352 288zM448 160h-64v48h64c8.822 0 16 7.178 16 16v224c0 8.822-7.178 16-16 16H224c-8.822 0-16-7.178-16-16v-64H160v64c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64V224C512 188.7 483.3 160 448 160z"],
    "bring-front": [640, 512, [], "f857", "M480 352V160c0-35.35-28.65-64-64-64H224C188.7 96 160 124.7 160 160v192c0 35.35 28.65 64 64 64h192C451.3 416 480 387.3 480 352zM48 48h160V64H256V48C256 21.6 234.4 0 208 0h-160C21.6 0 0 21.6 0 48v160C0 234.4 21.6 256 48 256H128V208H48V48zM592 256H512v48h80v160h-160V448H384v16c0 26.4 21.6 48 48 48h160c26.4 0 48-21.6 48-48v-160C640 277.6 618.4 256 592 256z"],
    "broom": [640, 512, [62746], "1f9f9", "M634.9 9.24c-8.172-10.44-23.25-12.34-33.69-4.125L368.1 187.3l-39.39-49.48C323.8 131.8 314.7 131.8 309.8 137.9l-57.61 73.12C221.1 211.8 148.2 217.6 100.2 255.8C38.24 305 0 511.3 0 511.3c15.12 .75 212.3 7.5 272.2-39.1c47.62-37.1 69.99-107.5 77.73-137.6l84.23-39.5c6.1-3.375 9.123-12.37 4.375-18.37l-40.57-50.96l232.8-181.9C641.2 34.77 643.1 19.68 634.9 9.24zM242.2 433.8c-16.5 13.12-74.23 28.5-182.7 30.12c4.748-19.12 10.12-38.12 15.75-56.37l45.37-35.1c4.1-3.875 1.125-11.87-4.998-10.62l-26.12 5.5c13.37-35.25 27.74-62.1 40.74-73.37c26.99-21.5 71.24-30.1 109.6-33.5l59.86 74.1C290.3 365.8 271.7 410.4 242.2 433.8zM365.7 273.3l-35.49 16.5L290.4 239.9l24.25-30.75c2.375-2.1 6.998-3.125 9.373 0L367.8 264C370.2 267 369.2 271.5 365.7 273.3z"],
    "browser": [512, 512, [62334], "1f5d4", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM464 416c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V160h416V416z"],
    "browsers": [576, 512, [], "e0cb", "M512 0H160C124.7 0 96 28.65 96 64v288c0 35.35 28.65 64 64 64h352c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM528 352c0 8.824-7.178 16-16 16H160c-8.822 0-16-7.176-16-16V128h384V352zM48 432V96C21.49 96 0 117.5 0 144V448c0 35.34 28.65 64 64 64h368c26.51 0 48-21.49 48-48H80C62.33 464 48 449.7 48 432z"],
    "brush": [384, 512, [], "f55d", "M352 0H32C14.38 0 0 14.38 0 32v288c0 35.38 28.62 64 64 64h64v64c0 35.38 28.62 64 64 64s64-28.62 64-64v-64h64c35.38 0 64-28.62 64-64V32C384 14.38 369.6 0 352 0zM192 472c-13.25 0-24-10.75-24-24s10.75-24 24-24s24 10.75 24 24S205.3 472 192 472zM48 48H96v96C96 152.8 103.2 160 112 160S128 152.8 128 144v-96h64v56c0 8.844 7.156 16 16 16S224 112.8 224 104V48h112V288h-288V48z"],
    "bug": [512, 512, [], "f188", "M488 264H400V196.8l71.19-58.24c10.28-8.375 11.78-23.5 3.375-33.75c-8.375-10.31-23.53-11.78-33.75-3.375L369.2 160H142.8L71.19 101.4C61.03 93.06 45.81 94.5 37.44 104.8C29.03 115.1 30.53 130.2 40.81 138.6L112 196.8V264H24C10.75 264 0 274.8 0 288s10.75 24 24 24H112v24c0 18.38 3.783 35.81 10.08 51.98l-83.05 83.05c-9.375 9.375-9.375 24.56 0 33.94C43.72 509.7 49.84 512 56 512s12.28-2.344 16.97-7.031l74.89-74.89C174.3 460.4 212.7 480 256 480s81.72-19.6 108.1-49.93l74.89 74.89C443.7 509.7 449.8 512 456 512s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94l-83.05-83.05C396.2 371.8 400 354.4 400 336V312h88C501.3 312 512 301.3 512 288S501.3 264 488 264zM352 336c0 44.6-30.71 81.86-72 92.59V280C280 266.8 269.3 256 256 256S232 266.8 232 280v148.6C190.7 417.9 160 380.6 160 336V209.2C160.5 208.7 161.1 208.5 161.5 208h188.1C350.9 208.5 351.5 208.7 352 209.2V336zM184 128C197.3 128 208 117.3 208 104V96c0-26.47 21.53-48 48-48s48 21.53 48 48v8C304 117.3 314.8 128 328 128S352 117.3 352 104V96c0-52.94-43.06-96-96-96S160 43.06 160 96v8C160 117.3 170.8 128 184 128z"],
    "building": [384, 512, [61869, 61687], "1f3e2", "M96 244C96 250.6 101.4 256 108 256h40C154.6 256 160 250.6 160 244v-40C160 197.4 154.6 192 148 192h-40C101.4 192 96 197.4 96 204V244zM160 340v-40C160 293.4 154.6 288 148 288h-40C101.4 288 96 293.4 96 300v40C96 346.6 101.4 352 108 352h40C154.6 352 160 346.6 160 340zM108 160h40C154.6 160 160 154.6 160 148v-40C160 101.4 154.6 96 148 96h-40C101.4 96 96 101.4 96 108v40C96 154.6 101.4 160 108 160zM320 0H64C28.65 0 0 28.65 0 64v424C0 501.3 10.75 512 24 512s24-10.75 24-24V64c0-8.838 7.164-16 16-16h256c8.836 0 16 7.162 16 16v424c0 13.25 10.75 24 24 24S384 501.3 384 488V64C384 28.65 355.3 0 320 0zM276 96h-40C229.4 96 224 101.4 224 108v40C224 154.6 229.4 160 236 160h40C282.6 160 288 154.6 288 148v-40C288 101.4 282.6 96 276 96zM276 192h-40C229.4 192 224 197.4 224 204v40C224 250.6 229.4 256 236 256h40C282.6 256 288 250.6 288 244v-40C288 197.4 282.6 192 276 192zM276 288h-40C229.4 288 224 293.4 224 300v40C224 346.6 229.4 352 236 352h40C282.6 352 288 346.6 288 340v-40C288 293.4 282.6 288 276 288zM191.2 384C157.6 384.5 144 415.4 144 434.1V488C144 501.3 154.7 512 168 512h48c13.26 0 24-10.75 24-24v-54.57C240 406.6 218 383.6 191.2 384z"],
    "buildings": [512, 512, [], "e0cc", "M308 192h-40C261.4 192 256 197.4 256 204v40C256 250.6 261.4 256 268 256h40C314.6 256 320 250.6 320 244v-40C320 197.4 314.6 192 308 192zM308 288h-40C261.4 288 256 293.4 256 300v40C256 346.6 261.4 352 268 352h40C314.6 352 320 346.6 320 340v-40C320 293.4 314.6 288 308 288zM148 224h-40C101.4 224 96 229.4 96 236v40C96 282.6 101.4 288 108 288h40C154.6 288 160 282.6 160 276v-40C160 229.4 154.6 224 148 224zM308 96h-40C261.4 96 256 101.4 256 108v40C256 154.6 261.4 160 268 160h40C314.6 160 320 154.6 320 148v-40C320 101.4 314.6 96 308 96zM148 320h-40C101.4 320 96 325.4 96 332v40C96 378.6 101.4 384 108 384h40C154.6 384 160 378.6 160 372v-40C160 325.4 154.6 320 148 320zM404 96h-40C357.4 96 352 101.4 352 108v40C352 154.6 357.4 160 364 160h40C410.6 160 416 154.6 416 148v-40C416 101.4 410.6 96 404 96zM448 0H224C188.7 0 160 28.65 160 64v64H64C28.65 128 0 156.7 0 192v296C0 501.3 10.75 512 24 512s24-10.75 24-24V192c0-8.838 7.164-16 16-16h144V64c0-8.838 7.164-16 16-16h224c8.836 0 16 7.162 16 16v424c0 13.25 10.75 24 24 24S512 501.3 512 488V64C512 28.65 483.3 0 448 0zM404 192h-40C357.4 192 352 197.4 352 204v40C352 250.6 357.4 256 364 256h40C410.6 256 416 250.6 416 244v-40C416 197.4 410.6 192 404 192zM404 288h-40C357.4 288 352 293.4 352 300v40C352 346.6 357.4 352 364 352h40C410.6 352 416 346.6 416 340v-40C416 293.4 410.6 288 404 288z"],
    "bullhorn": [512, 512, [128363, 61601], "1f4e2", "M480 184.9V32c0-8.75-6.969-32-32-32c-7.125 0-14.19 2.375-19.97 7.031L343 75.06C300.3 109.2 246.7 128 192 128H64C28.66 128 0 156.7 0 192v96c0 35.34 28.66 64 64 64h17.65c-10.76 77.8 34.54 143.3 36.81 146.5C124.6 507 133.6 512 143.1 512H192c12.94 0 24.62-9.078 29.56-23.04c4.969-13.96 2.219-30-6.938-40.69C214.2 447.8 174.3 398.6 185.1 352H192c54.66 0 108.3 18.81 150.1 52.94L428 472.1C432.8 476.8 441.8 480 448 480c24.91 0 32-22.78 32-32V295.1C499.1 284 512 263.6 512 240S499.1 195.1 480 184.9zM64 304C55.18 304 48 296.8 48 288V192c0-8.822 7.178-16 16-16h128v128H64zM432 414.7l-59.06-47.25C334.4 336.6 288.4 316.2 240 308.1V171.9c48.36-8.178 94.38-28.54 132.1-59.39L432 65.33V414.7z"],
    "bullseye": [512, 512, [], "f140", "M256 96C167.8 96 96 167.8 96 256s71.78 160 160 160s160-71.78 160-160S344.2 96 256 96zM256 368c-61.75 0-112-50.25-112-112S194.3 144 256 144s112 50.25 112 112S317.8 368 256 368zM256 192C220.7 192 192 220.7 192 256s28.72 64 64 64s64-28.72 64-64S291.3 192 256 192zM256 272C247.2 272 240 264.8 240 256S247.2 240 256 240s16 7.188 16 16S264.8 272 256 272zM256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256S397.2 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "bullseye-arrow": [512, 512, [63048], "1f3af", "M509.6 220.8c-1.812-13.16-14.03-22.31-27.03-20.53c-13.16 1.812-22.34 13.91-20.53 27.03C463.3 236.8 464 246.4 464 256c0 114.7-93.31 208-208 208S48 370.7 48 256S141.3 48 256 48c9.562 0 19.25 .6562 28.75 1.969c12.94 1.844 25.22-7.406 27.03-20.53s-7.375-25.22-20.53-27.03C279.6 .8125 267.8 0 256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256C512 244.3 511.2 232.4 509.6 220.8zM256 144c13.25 0 24-10.75 24-24S269.3 96 256 96C167.8 96 96 167.8 96 256s71.78 160 160 160s160-71.78 160-160c0-13.25-10.75-24-24-24S368 242.8 368 256c0 61.75-50.25 112-112 112S144 317.8 144 256S194.3 144 256 144zM247 231c-9.375 9.375-9.375 24.56 0 33.94C251.7 269.7 257.9 272 264 272s12.28-2.344 16.97-7.031l85.72-85.71l62.17 12.43c1.047 .2031 2.094 .3119 3.141 .3119c4.203 0 8.281-1.656 11.31-4.687l64-64c4.172-4.172 5.703-10.3 4-15.95c-1.703-5.641-6.391-9.891-12.17-11.05l-67.14-16.31l-16.31-67.14c-1.158-5.781-5.408-10.47-11.05-12.17c-5.688-1.719-11.78-.1719-15.95 4l-64 64c-3.781 3.781-5.422 9.203-4.375 14.45l12.44 62.18L247 231z"],
    "bullseye-pointer": [512, 512, [], "f649", "M256 0C128.8 0 19.78 94.88 2.406 220.7c-1.812 13.12 7.375 25.25 20.5 27.06c13.16 1.875 25.25-7.375 27.06-20.5C64.06 125.1 152.7 48 256 48c114.7 0 208 93.31 208 208c0 103.3-77.06 191.9-179.3 206c-13.12 1.812-22.31 13.94-20.5 27.06c1.656 12.03 11.94 20.72 23.75 20.72c1.094 0 2.188-.0625 3.312-.2187C417.1 492.2 512 383.2 512 256C512 114.8 397.2 0 256 0zM308.7 354.9c-11.69 6.25-16.09 20.78-9.844 32.47c4.312 8.094 12.59 12.69 21.19 12.69c3.812 0 7.688-.9062 11.28-2.844C383.6 369.3 416 315.2 416 256c0-88.22-71.78-160-160-160C196.8 96 142.7 128.4 114.8 180.7C108.6 192.4 112.1 206.9 124.7 213.2C136.4 219.5 150.9 215 157.1 203.3C176.7 166.7 214.6 144 256 144c61.75 0 112 50.25 112 112C368 297.4 345.3 335.3 308.7 354.9zM267.3 244.7C263.2 240.6 257.2 239.1 251.6 240.6l-224 64C21.09 306.5 16.45 312.2 16.03 318.1c-.4219 6.766 3.438 13.06 9.672 15.72l74.44 31.91l-90.77 90.77c-12.49 12.5-12.5 32.75-.002 45.25c12.49 12.5 32.76 12.5 45.25 0l90.77-90.76l31.91 74.44C179.8 492.2 185.6 496 192 496c.3281 0 .6719-.0156 1.016-.0313c6.75-.4219 12.52-5.062 14.38-11.58l64-224C272.1 254.8 271.4 248.8 267.3 244.7z"],
    "burger": [512, 512, ["hamburger"], "f805", "M351.1 176c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S343.1 176 351.1 176zM255.1 144c8.875 0 16-7.125 16-16s-7.125-16-15.1-16S239.1 119.1 239.1 128S247.1 144 255.1 144zM512 288c0-23.25-10.38-45.38-28.12-60.38c.5-.5 .875-1 1.25-1.5C499.4 203 499.6 174 485.8 150.8C442.3 78.75 352.2 32.13 255.1 32C159.9 32.13 69.75 78.75 26.25 150.8C12.37 174 12.62 203 26.87 226.1c.375 .5 .75 1 1.25 1.5C-5.379 255.9-9.504 306 18.75 339.4c4.375 5.25 9.5 9.875 15 13.75c-.625 2.75-1.625 5.5-1.625 8.5v34.63C32.12 442.5 69.62 480 115.7 480h280.6C442.6 480 480 442.5 480.1 396.3v-34.63c0-3-1.125-5.75-1.75-8.5C499.5 338.1 512 313.9 512 288zM67.37 175.5C102.2 117.6 176.4 80.13 256 80c79.75 .125 153.7 37.63 188.7 95.5c4.5 7.75 4.5 17.5-.25 25.25c-2.875 4.625-7.375 7.375-12.25 7.375H79.62c-4.75 0-9.25-2.75-12.12-7.375C62.87 193 62.75 183.3 67.37 175.5zM432 396.3C432 416 416 432 396.2 432H115.6c-19.62 0-35.63-16-35.63-35.75v-25.5H432V396.3zM432 320H79.1c-17.62 0-32-14.38-32-32s14.38-32 32-32H432c17.62 0 32 14.38 32 32S449.6 320 432 320zM159.1 176c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S151.1 176 159.1 176z"],
    "burger-cheese": [512, 512, [63473, "cheeseburger"], "1f354", "M351.1 176c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S343.1 176 351.1 176zM255.1 144c8.875 0 16-7.125 16-16s-7.125-16-15.1-16S239.1 119.1 239.1 128S247.1 144 255.1 144zM512 288c0-23.25-10.38-45.38-28.12-60.38c.5-.5 .875-1 1.25-1.5C499.4 203 499.6 174 485.8 150.8C442.3 78.75 352.2 32.13 255.1 32C159.9 32.13 69.75 78.75 26.25 150.8C12.37 174 12.62 203 26.87 226.1c.375 .5 .75 1 1.25 1.5C-5.381 255.9-9.506 306 18.75 339.4c4.375 5.25 9.5 9.875 15 13.75c-.625 2.75-1.625 5.5-1.625 8.5v34.63C32.12 442.5 69.62 480 115.7 480h280.6C442.6 480 480 442.5 480.1 396.3v-34.63c0-3-1.125-5.75-1.75-8.5C499.5 338.1 512 313.9 512 288zM67.37 175.5C102.2 117.6 176.4 80.13 256 80c79.75 .125 153.7 37.63 188.7 95.5c4.5 7.75 4.5 17.5-.25 25.25c-2.875 4.625-7.375 7.375-12.25 7.375H79.62c-4.75 0-9.25-2.75-12.12-7.375C62.87 193 62.75 183.3 67.37 175.5zM432 396.3C432 416 416 432 396.2 432H115.6c-19.62 0-35.63-16-35.63-35.75v-25.5H432V396.3zM432 320H79.1c-17.62 0-32-14.38-32-32s14.38-32 32-32h144l95.1 48L416 256h16c17.62 0 32 14.38 32 32S449.6 320 432 320zM159.1 176c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S151.1 176 159.1 176z"],
    "burger-fries": [640, 512, [], "e0cd", "M98.5 463.1L65.25 314.1C97.13 337.9 141.8 351.1 192 351.1c13.18 0 25.91-1.084 38.19-2.947c1.598-3.754 2.896-7.633 5.139-11.09c-3.297-12.63-3.686-25.63-2.146-38.42C220.2 302.3 206.5 303.1 192 303.1c-64.62 0-118.1-30-126.8-69c-1.5-6.75-8.25-10.1-15.25-10.1L15.1 223.1c-4.875 0-9.522 2.281-12.52 6.031s-4.104 8.716-3.104 13.47l54.13 243.5C57.75 501.6 70.73 512 85.73 512h182.7c-13.8-13.08-24.07-29.54-30.15-48H98.5zM128 258.5v-225.4l-3.75-20c-1-5.5-4.75-10-10-12c-5.125-1.998-11-1.248-15.38 2.125l-28.5 21.63C65.5 28.47 63.13 34.6 64.25 40.6l36.88 197.1C106.5 245.4 115.6 252.6 128 258.5zM50 191.1c3.625 0 7.001 1 10.37 1.75L40.38 86.6L20.63 80.73C15.25 79.1 9.504 80.35 5.379 83.98C1.254 87.73-.7461 93.23 .2539 98.73l16.25 93.26H50zM224 268.7V31.97c0-6-3.375-11.62-8.875-14.25l-32-16C178.3-.7773 172.3-.5273 167.6 2.346C162.9 5.223 160 10.47 160 15.97v252.8C181.1 273.1 202.9 273.1 224 268.7zM383.8 98.73c1-5.5-1-11-5.125-14.62c-4.125-3.75-9.875-5-15.25-3.375l-17.25 5.125L328.2 188.2c13.52-6.766 27.87-12.31 42.84-16.73L383.8 98.73zM291.8 210.7L319.8 50.72c1-5.5-1-11-5.125-14.63C310.5 32.35 304.8 31.1 299.4 32.72L265.1 42.97C260.9 44.22 258 47.47 256 51.22L255.1 245.9C266.1 232.1 278.1 221.2 291.8 210.7zM447.1 296c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S439.1 296 447.1 296zM528 312c8.875 0 16-7.125 16-16s-7.125-16-16-16S512 287.1 512 296S519.1 312 528 312zM367.1 312c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S359.1 312 367.1 312zM640 376c0-12.88-6.5-23.88-16-31.25c12.25-23.75 10.25-52.38-5.125-74.25C585.5 222.9 518.4 192 447.1 192c-70.38 0-137.4 30.88-170.9 78.5C261.7 292.4 259.7 321 271.1 344.8C262.5 352.1 256 363.1 256 376c0 11 4.623 21.5 12.62 28.87C265.6 412.3 263.1 420.1 263.1 428c0 46.38 37.63 84 84 84H548c46.38 0 84-37.63 84-84c0-7.875-1.625-15.75-4.625-23.12C635.4 397.5 640 387 640 376zM316.5 298c22.75-32.38 72.84-57.1 131.5-57.1c58.63 0 108.8 25.62 131.7 57.1c5.125 7.375 5.75 17 1.625 25S568.9 336 559.9 336h-223.8c-9 0-17.25-5-21.38-13S311.2 305.4 316.5 298zM548 464h-200c-19.88 0-36-16.12-36-36c0-6.625 5.375-12 12-12H572c6.625 0 12 5.375 12 12C584 447.9 567.9 464 548 464z"],
    "burger-glass": [640, 512, [], "e0ce", "M96.76 464c-8.463 0-15.6-6.494-16.24-14.78L61.75 208h231.2L292.8 210c14.97-11.22 31.76-20.74 49.88-28.42l9.27-147.6C353.1 15.57 338.4 0 319.9 0H32.11C13.38 0-1.348 15.88 .0977 34.47l32.56 418.5C35.25 486.3 63.18 512 96.76 512h164.8c2.117 0 4.129-.3965 6.195-.5957C254.3 498.4 244.3 482.2 238.3 464H96.76zM49.3 48h253.7L295.9 160H58.01L49.3 48zM528 312c8.875 0 16-7.125 16-16s-7.125-16-16-16S512 287.1 512 296S519.1 312 528 312zM640 376c0-12.88-6.5-23.88-16-31.25c12.25-23.75 10.25-52.38-5.125-74.25C585.5 222.9 518.4 192 447.1 192c-70.38 0-137.4 30.88-170.9 78.5C261.7 292.4 259.7 321 271.1 344.8C262.5 352.1 255.1 363.1 255.1 376c0 11 4.624 21.5 12.62 28.88C265.6 412.3 263.1 420.1 263.1 428c0 46.38 37.63 84 84 84H548c46.38 0 84-37.63 84-84c0-7.875-1.625-15.75-4.625-23.12C635.4 397.5 640 387 640 376zM316.5 298c22.75-32.38 72.84-58 131.5-58c58.63 0 108.8 25.63 131.7 58c5.125 7.375 5.75 17 1.625 25S568.9 336 559.9 336h-223.8c-9 0-17.25-5-21.38-13S311.2 305.4 316.5 298zM548 464h-200c-19.88 0-36-16.12-36-36c0-6.625 5.375-12 12-12H572c6.625 0 12 5.375 12 12C584 447.9 567.9 464 548 464zM447.1 296c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S439.1 296 447.1 296zM367.1 312c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S359.1 312 367.1 312z"],
    "burger-soda": [640, 512, [], "f858", "M110.5 464l-28.75-288H328C341.3 176 352 165.3 352 152C352 138.7 341.3 128 328 128L206.8 127.1l20-80L264 48C277.3 48 288 37.25 288 24C288 10.74 277.3 0 264 0L220.5-.001c-18.32 0-34.29 12.47-38.75 30.24l-24.5 97.76L24 128C10.75 128 0 138.7 0 152C0 165.3 10.75 176 24 176h9.5l30.5 306.2c1.25 16.88 15.12 29.88 31.1 29.75L268.4 512c-13.8-13.08-24.07-29.54-30.15-48H110.5zM528 312c8.875 0 16-7.125 16-16s-7.125-16-16-16S512 287.1 512 296S519.1 312 528 312zM448 296c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S439.1 296 448 296zM368 312c8.875 0 16-7.125 16-16s-7.125-16-16-16S352 287.1 352 296S359.1 312 368 312zM640 376c0-12.88-6.5-23.88-16-31.25c12.25-23.75 10.25-52.38-5.125-74.25C585.5 222.9 518.4 192 448 192S310.6 222.9 277.1 270.5C261.8 292.4 259.8 321 272 344.8C262.5 352.1 256 363.1 256 376c0 11 4.625 21.5 12.62 28.88C265.6 412.3 264 420.1 264 428C264 474.4 301.6 512 348 512h200c46.38 0 84-37.63 84-84c0-7.875-1.625-15.75-4.625-23.12C635.4 397.5 640 387 640 376zM316.5 298c22.75-32.38 72.84-58 131.5-58S556.8 265.6 579.6 298c5.125 7.375 5.75 17 1.625 25S568.9 336 559.9 336h-223.8c-9 0-17.25-5-21.38-13S311.3 305.4 316.5 298zM548 464h-200c-19.88 0-36-16.12-36-36C312 421.4 317.4 416 324 416h248c6.625 0 12 5.375 12 12C584 447.9 567.9 464 548 464z"],
    "burrito": [512, 512, [63469], "1f32f", "M511.1 123c0-32.5-21.25-61.13-52.25-70.76c-6.25-20.38-21.05-37-40.55-45.75c-19.5-8.75-41.75-8.625-61.13 .25c-40.75-17.88-88.22 .7671-105.1 41.52L33.94 266.6c-45.25 45.25-45.25 118.8 0 164l47.5 47.5c45.25 45.25 118.7 45.25 163.9-.0011l218.3-218.1c40.75-17.75 59.39-65.26 41.52-106C509.7 144.3 511.1 133.7 511.1 123zM163.4 464.1c-18 0-35.38-7.125-48-19.88l-47.63-47.63c-8.125-8.25-14-18.38-17-29.63c19.75 6 40.38 9 61.13 9.125c92.13 0 170.8-58.13 201.8-139.5c32.88-7.5 67.13-5 98.63 6.875l-200.8 200.8C198.8 456.9 181.6 464.1 163.4 464.1zM268.3 99.92c7.625 19.13 11.5 39.5 11.63 60.13c0 92.63-75.38 168-168 168c-19.25-.125-38.38-3.5-56.5-10.13c3.25-6.375 7.375-12.38 12.38-17.5L268.3 99.92z"],
    "bus": [576, 512, [61959], "1f68d", "M520 128H512V80C512 35.25 412.8 0 288 0S64 35.25 64 80V128H56C42.75 128 32 138.8 32 152v80C32 245.3 42.75 256 56 256H64v160c0 17.62 14.38 32 32 32v32c0 17.62 14.38 32 32 32s32-14.38 32-32v-32h256v32c0 17.62 14.38 32 32 32s32-14.38 32-32v-32c17.62 0 32-14.38 32-32V256h8C533.3 256 544 245.3 544 232v-80C544 138.8 533.3 128 520 128zM112 160h152v64H112V160zM464 400h-352v-128h352V400zM464 224h-152V160h152V224zM464 112h-96c0-17.62-14.38-32-32-32h-96c-17.62 0-32 14.38-32 32h-96V85.38C126.1 71.63 188.8 48 288 48s161.9 23.62 176 37.38V112zM176 368c17.62 0 32-14.38 32-32s-14.38-32-32-32s-32 14.38-32 32S158.4 368 176 368zM400 368c17.62 0 32-14.38 32-32s-14.38-32-32-32s-32 14.38-32 32S382.4 368 400 368z"],
    "bus-school": [576, 512, [], "f5dd", "M176 304c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S193.6 304 176 304zM528 232v-80C528 138.8 517.3 128 504 128H496V80C496 35.25 403.9 0 288 0S80 35.25 80 80V128H72C58.75 128 48 138.8 48 152v80C48 245.3 58.75 256 72 256C76.77 256 48 275.2 48 320v64c0 29.86 20.45 54.62 48 61.75V480c0 17.62 14.38 32 32 32s32-14.38 32-32v-32h256v32c0 17.62 14.38 32 32 32s32-14.38 32-32v-34.25c27.55-7.131 48-31.89 48-61.75v-64c0-47.32-29.68-64-24-64C517.3 256 528 245.3 528 232zM128 84.38C140.3 71.13 197 48 288 48s147.8 23.12 160 36.38V112h-80c0-17.62-14.38-32-32-32h-96c-17.62 0-32 14.38-32 32H128V84.38zM448 160v64h-144V160H448zM128 160h144v64H128V160zM480 384c0 8.875-7.125 16-16 16h-352C103.1 400 96 392.9 96 384v-64c0-26.5 21.5-48 48-48h288c26.5 0 48 21.5 48 48V384zM400 304c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S417.6 304 400 304z"],
    "bus-simple": [448, 512, ["bus-alt"], "f55e", "M336 368c17.62 0 32-14.38 32-32s-14.38-32-32-32s-32 14.38-32 32S318.4 368 336 368zM112 368c17.62 0 32-14.38 32-32s-14.38-32-32-32s-32 14.38-32 32S94.38 368 112 368zM448 80C448 35.25 348.8 0 224 0S0 35.25 0 80V416c0 17.62 14.38 32 32 32v32c0 17.62 14.38 32 32 32s32-14.38 32-32v-32h256v32c0 17.62 14.38 32 32 32s32-14.38 32-32v-32c17.62 0 32-14.38 32-32V80zM400 400h-352v-128h352V400zM400 224h-352V160h352V224zM400 112h-352V85.38C62.13 71.63 124.8 48 224 48s161.9 23.62 176 37.38V112z"],
    "c": [384, 512, [99], "43", "M220.8 480c-138.1 0-220.7-116.1-220.7-223.1C.0961 149.4 82.89 32 220.8 32c0 0-.0156 0 0 0c94.95 0 163.2 62.45 163.2 82.57c0 9.143-7.111 24.02-24 24.02C335.8 138.6 312 80 220.8 80C112.8 80 48.04 171.1 48.04 256c0 83.45 64.67 176 172.8 176c91.1 0 115.1-58.58 139.2-58.58c9.122 0 24.01 7.079 24.01 24.01C384 417.2 316.3 480 220.8 480z"],
    "cabinet-filing": [448, 512, [63051], "1f5c4", "M384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM384 464H64c-8.837 0-16-7.163-16-16V280h352V448C400 456.8 392.8 464 384 464zM400 232h-352V64c0-8.837 7.163-16 16-16h320c8.837 0 16 7.163 16 16V232zM128 168h16c8.875 0 16-7.125 16-16V144h128v8c0 8.875 7.125 16 16 16H320c8.875 0 16-7.125 16-16V128c0-17.62-14.38-32-32-32h-160c-17.62 0-32 14.38-32 32v24C112 160.9 119.1 168 128 168zM128 408h16c8.875 0 16-7.125 16-16V384h128v8c0 8.875 7.125 16 16 16H320c8.875 0 16-7.125 16-16V368c0-17.62-14.38-32-32-32h-160c-17.62 0-32 14.38-32 32v24C112 400.9 119.1 408 128 408z"],
    "cable-car": [512, 512, [], "e0cf", "M511.1 57.63c-3.5-12.77-16.72-20.27-29.5-16.77l-464 128C4.842 172.4-2.658 185.6 .8734 198.4C3.811 209 13.47 216 23.1 216c2.094 0 4.25-.2813 6.375-.8594l201.6-55.62V224H95.99C60.65 224 31.99 252.7 31.99 288v160c0 35.35 28.65 64 63.1 64h319.1c35.35 0 63.1-28.65 63.1-64V288c0-35.35-28.65-64-63.1-64h-135.1V146.3l214.4-59.14C507.2 83.61 514.7 70.39 511.1 57.63zM79.99 288c0-8.822 7.187-16 16.01-16h72V352h-88L79.99 288zM432 448c0 8.822-7.178 16-16 16H95.1c-8.822 0-16-7.178-16-16v-48h352V448zM344 272h72c8.822 0 15.99 7.178 15.99 16l.008 64h-88V272zM296 272V352H215.1V272H296zM191.1 96c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32S159.1 46.33 159.1 64C159.1 81.67 174.3 96 191.1 96zM287.1 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32c-17.67 0-32 14.33-32 32C255.1 49.67 270.3 64 287.1 64z"],
    "cactus": [512, 512, [63655], "1f335", "M240 130c-8.875 0-16 7.125-16 16c0 8.75 7.125 16 16 16s16-7.25 16-16C256 137.1 248.9 130 240 130zM272 354c-8.875 0-16 7.125-16 16c0 8.75 7.125 16 16 16s16-7.25 16-16C288 361.1 280.9 354 272 354zM464 224c-26.5 0-48 21.5-48 47.1v63.1c0 8.875-7.125 15.1-16 15.1H352V101.4c0-52-38.88-98.5-90.88-101.2C259.4 .0047 257.8 0 256.1 0C203.1 0 160 43 160 96v127.1L112 224c-8.875 0-16-7.125-16-15.1V144c0-26.5-21.5-47.1-48-47.1S0 117.5 0 144v63.1c0 61.88 50.12 111.1 112 111.1H160v159.1C160 497.6 174.4 512 192 512h128c17.62 0 32-14.37 32-31.1v-31.1h48c61.88 0 112-50.12 112-111.1V272C512 245.5 490.5 224 464 224zM304 464h-96V96c0-26.5 21.5-48 48-48l2.625 .125C283.6 49.38 304 73.38 304 101.4V464z"],
    "cake-candles": [448, 512, [61949, "birthday-cake"], "1f382", "M383.1 223.1L376 224V168c0-13.25-10.75-24-24-24s-24 10.75-24 24V224h-80V168c0-13.25-10.75-24-24-24S200 154.8 200 168V224h-80V168C120 154.8 109.3 144 96 144S72 154.8 72 168V224L64 223.1c-35.35 0-64 28.65-64 63.1v192C0 497.7 14.33 512 32 512h384c17.67 0 32-14.33 32-32V287.1C448 252.6 419.3 223.1 383.1 223.1zM400 464h-352v-71.57c18.12-2.906 34.43-10.33 48-19.1c17.34 11.19 39.64 21.37 64 21.37s46.66-10.19 64-21.37c17.34 11.19 39.64 21.37 64 21.37s46.66-10.19 64-21.37c13.46 8.68 29.94 16.68 48 19.82V464zM400 343.8c-13.47-4.363-25.79-12.82-33.05-18.58c-8.75-6.969-21.16-6.969-29.91 0C326.1 333.2 307.2 346.7 288 346.7s-38.97-13.47-49.05-21.48c-8.75-6.969-21.16-6.969-29.91 0C198.1 333.2 179.2 346.7 160 346.7s-38.97-13.47-49.05-21.48c-8.75-6.969-21.16-6.969-29.91 0C73.79 330.1 61.47 339.4 48 343.8V288c0-8.822 7.178-16 16-16h320c8.822 0 16 7.178 16 16V343.8zM352 111.1c22.09 0 40-17.88 40-39.97S352 0 352 0s-40 49.91-40 72S329.9 111.1 352 111.1zM224 111.1c22.09 0 40-17.88 40-39.97S224 0 224 0S184 49.91 184 72S201.9 111.1 224 111.1zM96 111.1c22.09 0 40-17.88 40-39.97S96 0 96 0S56 49.91 56 72S73.91 111.1 96 111.1z"],
    "calculator": [384, 512, [61932], "1f5a9", "M192 344c13.26 0 24-10.75 24-24S205.3 296 192 296S168 306.7 168 320S178.7 344 192 344zM192 256c13.26 0 24-10.75 24-24S205.3 208 192 208S168 218.7 168 232S178.7 256 192 256zM280 344c13.26 0 24-10.75 24-24s-10.74-24-24-24S256 306.7 256 320S266.7 344 280 344zM280 256c13.26 0 24-10.75 24-24S293.3 208 280 208S256 218.7 256 232S266.7 256 280 256zM280 432c13.26 0 24-10.75 24-24S293.3 384 280 384S256 394.7 256 408S266.7 432 280 432zM104 432h80c13.26 0 24-10.75 24-24S197.3 384 184 384h-80c-13.26 0-24 10.75-24 24S90.74 432 104 432zM320 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h256c35.35 0 64-28.65 64-64V64C384 28.65 355.3 0 320 0zM336 448c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V176h288V448zM336 128h-288V64c0-8.838 7.164-16 16-16h256c8.836 0 16 7.162 16 16V128zM104 256C117.3 256 128 245.3 128 232S117.3 208 104 208S80 218.7 80 232S90.74 256 104 256zM104 344C117.3 344 128 333.3 128 320S117.3 296 104 296S80 306.7 80 320S90.74 344 104 344z"],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", "M168.1 343c-9.375-9.375-24.56-9.375-33.94 0L112 366.1l-23.03-23.03c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L78.06 400l-23.03 23.03c-9.375 9.375-9.375 24.56 0 33.94C59.72 461.7 65.84 464 72 464s12.28-2.344 16.97-7.031L112 433.9l23.03 23.03C139.7 461.7 145.8 464 152 464s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L145.9 400l23.03-23.03C178.3 367.6 178.3 352.4 168.1 343zM64 134.9h96c13.25 0 24-10.75 24-24s-10.75-24-24-24H64c-13.25 0-24 10.75-24 24S50.75 134.9 64 134.9zM344 136.1h32v32c0 13.25 10.75 23.92 24 23.92s24-10.67 24-23.92v-32h32c13.25 0 24-10.83 24-24.08s-10.75-23.92-24-23.92h-32v-32c0-13.25-10.75-24.08-24-24.08s-24 10.83-24 24.08v32h-32c-13.25 0-24 10.67-24 23.92S330.8 136.1 344 136.1zM488 232h-208v-208C280 10.75 269.3 0 256 0S232 10.75 232 24v208h-208C10.75 232 0 242.8 0 256s10.75 24 24 24h208v208C232 501.3 242.8 512 256 512s24-10.75 24-24v-208h208C501.3 280 512 269.3 512 256S501.3 232 488 232zM448 416h-96.06C338.7 416 328 426.8 328 440S338.8 464 352 464h96c13.25 0 24-10.75 24-24S461.3 416 448 416zM448 336h-96c-13.25 0-24 10.75-24 24S338.7 384 351.1 384h96.06C461.3 384 472 373.3 472 360S461.3 336 448 336z"],
    "calendar": [448, 512, [128198, 61747], "1f4c5", "M384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM384 464H64c-8.822 0-16-7.176-16-16V192h352v256C400 456.8 392.8 464 384 464z"],
    "calendar-arrow-down": [448, 512, ["calendar-download"], "e0d0", "M207 424.1C211.7 429.7 217.9 432 224 432s12.28-2.344 16.97-7.031l80-80c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L248 350.1V248C248 234.8 237.3 224 224 224S200 234.8 200 248v102.1L160.1 311c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L207 424.1zM384 64h-40V24C344 10.75 333.3 0 320 0s-24 10.75-24 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448z"],
    "calendar-arrow-up": [448, 512, ["calendar-upload"], "e0d1", "M160.1 344.1L200 305.9V408c0 13.25 10.75 24 24 24s24-10.75 24-24V305.9l39.03 39.03c9.375 9.375 24.56 9.375 33.94 0s9.375-24.56 0-33.94l-80-80C236.3 226.3 230.1 224 224 224S211.7 226.3 207 231l-80 80c-9.375 9.375-9.375 24.56 0 33.94S151.6 354.3 160.1 344.1zM384 64h-40V24C344 10.75 333.3 0 320 0s-24 10.75-24 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448z"],
    "calendar-check": [448, 512, [], "f274", "M183 408.1c4.5 4.5 10.62 7.031 16.97 7.031c.3125 0 .625 0 .9062-.0313c6.688-.25 12.97-3.281 17.31-8.344l96-112c8.625-10.06 7.469-25.22-2.594-33.84c-10.03-8.594-25.19-7.469-33.84 2.594l-79.13 92.34l-29.69-29.69c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L183 408.1zM384 64h-40V24C344 10.75 333.3 0 320 0s-24 10.75-24 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448z"],
    "calendar-clock": [576, 512, ["calendar-time"], "e0d2", "M432 224C352.4 224 288 288.4 288 368s64.38 144 144 144S576 447.6 576 368S511.6 224 432 224zM480 384h-54.25C420.4 384 416 379.6 416 374.3V304C416 295.2 423.2 288 432 288C440.8 288 448 295.2 448 304V352h32c8.838 0 16 7.164 16 16S488.8 384 480 384zM284.6 464H64c-8.822 0-16-7.176-16-16V192H448V128c0-35.35-28.65-64-64-64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h267C312.6 499.1 296.9 482.8 284.6 464z"],
    "calendar-day": [448, 512, [], "f783", "M384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448zM112 384h96c8.75 0 16-7.25 16-16v-96C224 263.3 216.8 256 208 256h-96C103.3 256 96 263.3 96 272v96C96 376.8 103.3 384 112 384z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 192v104h-152V192H400zM200 192v104H48V192H200zM48 448v-104h152v120H64C55.18 464 48 456.8 48 448zM384 464h-136v-120h152V448C400 456.8 392.8 464 384 464z"],
    "calendar-exclamation": [448, 512, [], "f334", "M224 432c17.67 0 32-14.33 32-32s-14.33-32-32-32c-17.67 0-32 14.33-32 32S206.3 432 224 432zM224 336c13.25 0 24-10.75 24-24v-64C248 234.8 237.3 224 224 224S200 234.8 200 248v64C200 325.3 210.8 336 224 336zM384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448z"],
    "calendar-heart": [448, 512, [], "e0d3", "M215.9 412.6c4.486 4.59 11.62 4.59 16.12 0l69.16-71.3c20.09-20.84 18.87-55.14-3.676-74.32c-19.48-16.68-48.65-13.65-66.61 4.789L223.9 279L216.9 271.7C199 253.3 169.9 250.3 150.4 266.9c-22.44 19.18-23.66 53.48-3.572 74.32L215.9 412.6zM384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448z"],
    "calendar-image": [448, 512, [], "e0d4", "M384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448zM145.7 326.6l-46.67 64c-3.549 4.863-4.064 11.31-1.334 16.68C100.5 412.6 105.1 416 112 416h224c5.9 0 11.32-3.246 14.11-8.449c2.783-5.203 2.479-11.52-.7949-16.43l-85.33-128C261 258.7 256 256 250.7 256s-10.35 2.672-13.31 7.125l-53.5 80.26l-12.26-16.81C168.6 322.4 163.8 320 158.7 320S148.8 322.4 145.7 326.6zM128 288c17.62 0 32-14.38 32-32S145.6 224 128 224S96 238.4 96 256S110.4 288 128 288z"],
    "calendar-lines": [448, 512, ["calendar-note"], "e0d5", "M384 64h-40V24C344 10.75 333.3 0 320 0s-24 10.75-24 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448zM120 304h208C341.3 304 352 293.3 352 280S341.3 256 328 256h-208C106.8 256 96 266.8 96 280S106.8 304 120 304zM120 400h112c13.25 0 24-10.75 24-24S245.3 352 232 352h-112C106.8 352 96 362.8 96 376S106.8 400 120 400z"],
    "calendar-minus": [448, 512, [], "f272", "M384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448zM143.1 351.1h160c13.26 0 23.1-10.74 23.1-23.1s-10.74-23.1-23.1-23.1H143.1C130.7 304 120 314.7 120 328C120 341.3 130.7 351.1 143.1 351.1z"],
    "calendar-pen": [448, 512, ["calendar-edit"], "f333", "M296.5 295.5l-48.01-48.01l18.23-18.23c7.029-7.031 18.44-7.031 25.47 0l22.54 22.53c7.029 7.031 7.029 18.44 0 25.47L296.5 295.5zM135.2 415.9l47.61-9.52c2.322-.4687 4.455-1.609 6.131-3.281l90.58-90.57L231.5 264.5l-90.58 90.57c-1.676 1.68-2.818 3.812-3.281 6.133l-9.521 47.61C127.3 413 130.1 416.7 135.2 415.9zM448 128v320c0 35.35-28.65 64-64 64H64c-35.35 0-64-28.65-64-64V128c0-35.35 28.65-64 64-64h40V24C104 10.75 114.8 0 128 0S152 10.75 152 24V64h144V24c0-13.25 10.75-24 24-24S344 10.75 344 24V64H384C419.3 64 448 92.65 448 128zM400 192h-352v256c0 8.824 7.178 16 16 16h320c8.822 0 16-7.176 16-16V192z"],
    "calendar-plus": [448, 512, [], "f271", "M384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448zM143.1 351.1H200v56C200 421.3 210.7 432 224 432c13.26 0 23.1-10.74 23.1-23.1V351.1h56c13.26 0 23.1-10.74 23.1-23.1s-10.74-23.1-23.1-23.1H247.1V247.1C247.1 234.7 237.3 224 224 224S200 234.7 200 247.1V304H143.1C130.7 304 120 314.7 120 328C120 341.3 130.7 351.1 143.1 351.1z"],
    "calendar-range": [448, 512, [], "e0d6", "M216 312h112C341.3 312 352 301.3 352 288s-10.74-24-23.1-24H215.1C202.7 264 192 274.7 192 288C192 301.3 202.7 312 216 312zM341.3 352h-42.67C292.8 352 288 356.8 288 362.7v42.67C288 411.2 292.8 416 298.7 416h42.67C347.2 416 352 411.2 352 405.3v-42.67C352 356.8 347.2 352 341.3 352zM106.7 320h42.67C155.2 320 160 315.2 160 309.3V266.7C160 260.8 155.2 256 149.3 256H106.7C100.8 256 96 260.8 96 266.7v42.67C96 315.2 100.8 320 106.7 320zM384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448zM120 408h112C245.3 408 256 397.3 256 384s-10.74-24-23.1-24H119.1C106.7 360 96 370.7 96 384C96 397.3 106.7 408 120 408z"],
    "calendar-star": [448, 512, [], "f736", "M171.8 353.1l-8.592 50.06c-1.604 9.051 7.904 15.81 15.92 11.57l44.79-23.71l44.79 23.71c8.018 4.238 17.53-2.633 16.04-11.57l-8.707-50.06l36.32-35.4c6.529-6.297 2.979-17.41-6.072-18.79l-50.06-7.332L233.7 246.2c-4.01-8.133-15.69-8.246-19.7 0L191.6 291.6L141.4 298.9C132.5 300.3 128.9 311.3 135.3 317.7L171.8 353.1zM384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448z"],
    "calendar-week": [448, 512, [], "f784", "M112 352h224c8.75 0 16-7.25 16-16l.0003-64c0-8.75-7.25-16-16-16h-224C103.3 256 96 263.3 96 272L96 336C96 344.8 103.3 352 112 352zM384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448z"],
    "calendar-xmark": [448, 512, ["calendar-times"], "f273", "M384 64h-40V24c0-13.25-10.75-24-23.1-24S296 10.75 296 24V64h-144V24C152 10.75 141.3 0 128 0S104 10.75 104 24V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V192h352V448zM143 408.1c9.374 9.374 24.56 9.38 33.94 0L224 361.9l47.03 47.03c9.374 9.374 24.56 9.38 33.94 0c9.375-9.375 9.375-24.56 0-33.94L257.9 328l47.03-47.03c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L224 294.1L176.1 247c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L190.1 328l-47.03 47.03C133.7 384.4 133.7 399.6 143 408.1z"],
    "calendars": [512, 512, [], "e0d7", "M448 64h-40V24c0-13.25-10.75-23.1-23.1-23.1S360 10.75 360 24V64h-112V24c0-13.25-10.75-23.1-23.1-23.1S200 10.75 200 24V64H160C124.7 64 96 92.65 96 128v224c0 35.35 28.65 64 64 64h288c35.35 0 64-28.65 64-64V128C512 92.65 483.3 64 448 64zM464 352c0 8.824-7.178 16-16 16H160c-8.822 0-16-7.176-16-16V192h320V352zM392 512h-272C53.83 512 0 458.2 0 392v-208C0 170.8 10.75 160 24 160S48 170.8 48 184v208c0 39.7 32.3 72 72 72h272c13.25 0 24 10.75 24 24S405.3 512 392 512z"],
    "camcorder": [576, 512, [63656, "video-handheld"], "1f4f9", "M312 240H104C90.75 240 80 250.8 80 264S90.75 288 104 288h208c13.25 0 24-10.75 24-24S325.3 240 312 240zM557.6 182.3c-11.53-7.406-25.88-8.391-38.28-2.688L416 227V224c0-35.35-28.65-64-64-64L96 159.1V120C96 97.94 113.9 80 136 80h160C309.3 80 320 69.25 320 56S309.3 32 296 32h-160C87.47 32 48 71.47 48 120l.0003 42.26C20.44 169.4 .0002 194.2 .0002 223.1l-.0001 191.1c0 35.35 28.65 63.1 64 63.1L352 480c35.35 0 64-28.65 64-64v-3.016l103.3 47.36c5.344 2.453 11.03 3.672 16.69 3.672c7.531 0 15.02-2.141 21.59-6.359C569.1 450.3 576 437.7 576 423.1V216C576 202.3 569.1 189.8 557.6 182.3zM368 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V224c0-8.822 7.178-16 16-16h288c8.822 0 16 7.178 16 16V416zM528 411.5l-112-51.33V279.8l112-51.33V411.5z"],
    "camera": [512, 512, [62258, "camera-alt"], "f030", "M448 96h-72l-8.457-22.51C358.2 48.51 334.3 32 307.6 32H204.4C177.7 32 153.9 48.51 144.5 73.45L136 96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V160c0-8.822 7.178-16 16-16h105.2l20.19-53.64C191.7 84.16 197.8 80 204.4 80h103.3c6.631 0 12.65 4.172 14.98 10.38L342.7 144H448c8.822 0 16 7.178 16 16V416zM256 176C194.1 176 144 226.1 144 288c0 61.86 50.14 112 112 112s112-50.14 112-112C368 226.1 317.9 176 256 176zM256 352c-35.29 0-64-28.71-64-64c0-35.29 28.71-64 64-64s64 28.71 64 64C320 323.3 291.3 352 256 352z"],
    "camera-cctv": [576, 512, ["cctv"], "f8ac", "M517.5 168.6L139.2 2.266C135.4 .7323 131.3 0 127.4 0C116.2 0 105.4 5.882 99.62 16.14l-95.37 166.9C-.5001 191.3-1.25 201 1.999 209.9C5.25 218.8 12.25 225.8 21.12 229l164.3 67.98L143.4 408H48v-32C48 362.7 37.25 352 24 352S0 362.7 0 376v112C0 501.3 10.75 512 24 512s24-10.75 24-24v-32H160c9.1 0 19-6.25 22.5-15.5l47.2-125.2l75.67 31.31c3.588 1.309 7.327 1.96 11.05 1.96c5.871 0 11.7-1.62 16.83-4.835l189.2-118.4C544.7 211.5 541.7 178.3 517.5 168.6zM314.9 298.6L54.94 191.1l79.21-138.6l337.2 148.3L314.9 298.6zM574.9 283.1c-1.625-4.25-4.875-7.5-8.1-9.375l-35.37-15.5l-138.4 86.5l119.5 52.51c8.5 3.748 18.46-.1317 22.21-8.632l40.74-92.62C576.4 291.9 576.5 287.3 574.9 283.1z"],
    "camera-movie": [576, 512, [127910, 63657], "1f3a5", "M557.6 262.4c-11.53-7.41-25.88-8.396-38.28-2.689l-83.95 38.5C423.7 282.4 405.1 272 384 272H24C10.75 272 0 282.7 0 296C0 309.3 10.75 320 24 320h42.26C64.93 325.1 64 330.4 64 336l.0002 111.1c0 35.35 28.65 63.1 64 63.1L384 512c26.38 0 49.01-15.98 58.8-38.77l76.53 35.1C524.7 510.8 530.4 512 536 512c7.531 0 15.02-2.143 21.59-6.363C569.1 498.2 576 485.6 576 471.9V296.1C576 282.4 569.1 269.8 557.6 262.4zM400 448c0 8.822-7.178 16-16 16H128c-8.822 0-16-7.178-16-16v-112C112 327.2 119.2 320 128 320l256-.0068c8.822 0 16 7.185 16 16.01L400 448zM528 459.5L448 422.8v-77.56l80-36.69V459.5zM152 240h192c66.28 0 120-53.73 120-120C464 53.72 410.3 0 344 0c-39.44 0-74.13 19.28-96 48.66C226.1 19.28 191.4 0 152 0C85.73 0 32 53.72 32 120C32 186.3 85.73 240 152 240zM344 48C383.7 48 416 80.3 416 120S383.7 192 344 192S272 159.7 272 120S304.3 48 344 48zM152 48C191.7 48 224 80.3 224 120S191.7 192 152 192S80 159.7 80 120S112.3 48 152 48z"],
    "camera-polaroid": [576, 512, [], "f8aa", "M288 128C243.9 128 208 163.9 208 208S243.9 288 288 288s80-35.88 80-80C367.9 163.9 332.1 128.1 288 128zM288 240c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S305.6 240 288 240zM565.3 335.1L512 256L512 96c0-35.35-28.65-64-64-64H128C92.65 32 64 60.65 64 96l.0001 160l-53.26 79.95C3.736 346.5 0 358.8 0 371.4V416c0 35.2 28.8 64 64 64h448c35.2 0 64-28.8 64-64v-44.57C576 358.8 572.3 346.5 565.3 335.1zM112 270.5V96c0-8.837 7.163-16 16-16h320c8.837 0 16 7.163 16 16v174.5L507.6 336H68.38L112 270.5zM512 432H64c-8.837 0-16-7.163-16-16v-32h480v32C528 424.8 520.8 432 512 432zM424 112h-32C387.6 112 384 115.6 384 120v32C384 156.4 387.6 160 392 160h32c4.375 0 8-3.625 8-8v-32C432 115.6 428.4 112 424 112z"],
    "camera-retro": [512, 512, [61571], "1f4f7", "M448 32h-176.9c-9.938 0-19.73 2.311-28.62 6.757L192 64H160V48C160 39.16 152.8 32 144 32h-64C71.16 32 64 39.16 64 48V64C28.65 64 0 92.65 0 128v288c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM464 416c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V240h84.53C129.9 250.3 128 260.9 128 272c0 70.69 57.31 128 128 128c70.69 0 128-57.31 128-128c0-11.12-1.861-21.71-4.525-32H464V416zM176 272C176 227.9 211.9 192 256 192s80 35.89 80 80c0 44.11-35.89 80-80 80S176 316.1 176 272zM464 192h-108.8C331.7 162.1 296.3 144 256 144C215.8 144 180.3 162.1 156.8 192H48V128c0-8.838 7.164-16 16-16h139.3L272 80H448c8.836 0 16 7.162 16 16V192z"],
    "camera-rotate": [512, 512, [], "e0d8", "M448 96h-72l-8.457-22.51C358.2 48.51 334.3 32 307.6 32H204.4C177.7 32 153.9 48.51 144.5 73.45L136 96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V160c0-8.822 7.178-16 16-16h105.2l20.19-53.64C191.7 84.16 197.8 80 204.4 80h103.3c6.631 0 12.65 4.172 14.98 10.38L342.7 144H448c8.822 0 16 7.178 16 16V416zM346.9 187.7l-14.76 14.77C311.2 183.8 284.6 173 256 173c-35.64 0-68.69 16.12-90.64 44.22C157.2 227.7 159 242.8 169.5 250.9C179.9 259.1 195 257.2 203.2 246.8c22.5-28.79 67.17-32.26 95.08-10.48l-14.61 14.62C275.9 258.6 281.3 271.7 292.1 272h67.36C364.2 271.9 368 268 368 263.3V196.4C368 185.4 354.7 179.9 346.9 187.7zM308.8 329.2c-22.5 28.79-67.17 32.26-95.08 10.48l14.61-14.62C236.1 317.4 230.7 304.3 219.9 304H152.6C147.8 304.1 144 307.1 144 312.7v66.87c0 11.02 13.33 16.54 21.12 8.74l14.76-14.77C200.8 392.2 227.4 403 256 403c35.64 0 68.69-16.12 90.64-44.22c8.172-10.45 6.312-25.53-4.125-33.69C332.1 316.9 317 318.8 308.8 329.2z"],
    "camera-security": [448, 512, ["camera-home"], "f8fe", "M384 0h-320c-35.35 0-64 28.65-64 64v288c0 35.35 28.65 64 64 64h41.37l-37.62 59.11c-4.703 7.391-5 16.77-.7813 24.44C71.17 507.2 79.25 512 88.02 512h271.1c8.766 0 16.84-4.766 21.05-12.45c4.219-7.672 3.922-17.05-.7813-24.44L342.6 416h41.37c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM131.7 464L162.3 416h123.5l30.55 48H131.7zM400 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V64c0-8.822 7.178-16 16-16h320c8.822 0 16 7.178 16 16V352zM224 96c-61.86 0-112 50.14-112 112s50.14 112 112 112s112-50.14 112-112S285.9 96 224 96zM224 272c-35.29 0-64-28.71-64-64s28.71-64 64-64c35.29 0 64 28.71 64 64S259.3 272 224 272z"],
    "camera-slash": [640, 512, [], "e0d9", "M128 432c-8.822 0-16-7.178-16-16V184.5L65.23 147.8C64.46 151.8 64 155.8 64 160v256c0 35.35 28.65 64 64 64h361.1l-61.24-48H128zM630.8 469.1l-55.93-43.84C575.3 422.2 576 419.2 576 416V160c0-35.35-28.65-64-64-64h-72l-8.457-22.51C422.2 48.51 398.3 32 371.6 32H268.4C241.7 32 217.9 48.51 208.5 73.45L200 96H154.8L38.81 5.109C34.41 1.672 29.19 0 24.03 0c-7.125 0-14.19 3.156-18.91 9.187c-8.188 10.44-6.375 25.53 4.062 33.7l591.1 463.1c10.5 8.203 25.56 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1zM318.3 224.2C318.9 224.2 319.4 224 320 224c30.64 0 56.27 21.67 62.5 50.48L318.3 224.2zM528 388.5l-98.77-77.41C430.9 303.6 432 295.1 432 288c0-61.86-50.14-112-112-112c-17.51 0-33.96 4.145-48.62 11.39L216 144H233.2l20.19-53.64C255.7 84.16 261.8 80 268.4 80h103.3c6.631 0 12.65 4.172 14.98 10.38L406.7 144H512c8.822 0 16 7.178 16 16V388.5zM370.8 387.3l-45.69-35.81C323.4 351.6 321.7 352 320 352c-31.82 0-58.07-23.41-62.97-53.86L211.3 262.3C209.3 270.6 208 279.1 208 288c0 61.86 50.14 112 112 112C338.4 400 355.5 395.1 370.8 387.3z"],
    "camera-viewfinder": [512, 512, [], "e0da", "M112 176V352c0 17.67 14.33 32 32 32h224c17.67 0 32-14.33 32-32V176c0-17.67-14.33-32-32-32h-36l-6.188-16.44C322.3 118.2 313.4 112 303.4 112H208.6c-10 0-19 6.188-22.5 15.56L180 144H144C126.3 144 112 158.3 112 176zM160 192h53.34l11.92-32h61.47l12.05 32H352v144H160V192zM136 464H48v-88C48 362.7 37.25 352 24 352S0 362.7 0 375.1V480c0 17.67 14.33 32 32 32h104C149.3 512 160 501.3 160 488S149.3 464 136 464zM23.1 160C37.25 160 48 149.3 48 136V48h88C149.3 48 160 37.25 160 24S149.3 0 136 0H32C14.33 0 0 14.33 0 32v104C0 149.3 10.75 160 23.1 160zM480 0h-104C362.7 0 352 10.75 352 23.1S362.7 48 375.1 48H464v88C464 149.3 474.7 160 488 160S512 149.3 512 136V32C512 14.33 497.7 0 480 0zM488 352c-13.25 0-24 10.75-24 23.1V464h-88C362.7 464 352 474.7 352 487.1S362.7 512 375.1 512H480c17.67 0 32-14.33 32-32v-104C512 362.7 501.3 352 488 352zM256 224C233.9 224 216 241.9 216 264C216 286.1 233.9 304 256 304c22.08 0 40-17.92 40-40C296 241.9 278.1 224 256 224z"],
    "camera-web": [448, 512, ["webcam"], "f832", "M224 96C157.7 96 104 149.7 104 216c0 66.27 53.73 120 120 120c66.28 0 120-53.73 120-120C344 149.7 290.3 96 224 96zM224 288C184.3 288 152 255.7 152 216S184.2 144 223.9 144S296 176.3 296 216S263.7 288 224 288zM347.8 392.9C403.5 353.8 440 289.2 440 216c0-119.3-96.71-215.1-216-215.1c-119.3 0-216 96.71-216 215.1c0 73.22 36.52 137.8 92.25 176.9l-63.13 80.29c-5.656 7.219-6.719 17.05-2.719 25.31C38.44 506.8 46.81 512 56 512h336c9.188 0 17.56-5.25 21.59-13.52c4-8.266 2.938-18.09-2.719-25.31L347.8 392.9zM105.4 464l37.61-47.84C168 426.3 195.3 432 224 432s55.96-5.705 80.98-15.84L342.6 464H105.4zM224 384c-92.63 0-168-75.37-168-168C56 123.4 131.4 48 224 48c92.64 0 168 75.36 168 168C392 308.6 316.6 384 224 384z"],
    "camera-web-slash": [640, 512, ["webcam-slash"], "f833", "M630.8 469.1l-145.7-114.2C516.8 317.4 536 268.1 536 216c0-119.3-96.71-215.1-216-215.1c-71.71 0-134.8 35.3-174 89.09l-107.1-83.97C28.35-3.058 13.33-1.246 5.122 9.191c-8.172 10.44-6.354 25.53 4.068 33.7l591.1 463.1C605.6 510.3 610.8 512 615.1 512c7.125 0 14.16-3.161 18.9-9.193C643.1 492.4 641.2 477.3 630.8 469.1zM371.7 265.1L259.2 177.8C271.9 157.6 294.3 143.1 319.9 143.1C359.6 143.1 392 176.3 392 216C392 235.4 384.2 253.1 371.7 265.1zM409.5 295.6C428.4 274.5 440 246.7 440 216c0-66.28-53.73-120-120-120c-41.05 0-76.86 20.89-98.45 52.34L184 118.9C214.3 76.16 263.7 48 320 48c92.64 0 168 75.36 168 168c0 41.77-15.62 79.7-40.99 109L409.5 295.6zM201.4 464l37.61-47.84C264 426.3 291.3 432 320 432c30.47 0 59.43-6.383 85.72-17.77l-45.48-35.65c-12.96 3.215-26.3 5.412-40.24 5.412C227.4 383.1 152 308.6 152 216c0-.2012 .0586-.3848 .0586-.5859L107.2 180.3C105.3 191.9 104 203.8 104 216c0 73.22 36.52 137.8 92.25 176.9l-63.13 80.29c-5.656 7.219-6.719 17.05-2.719 25.31C134.4 506.8 142.8 512 152 512h378.5l-61.24-48H201.4z"],
    "campfire": [512, 512, [], "f6ba", "M256 320c79.5 0 144-64.5 144-144c0-33.25-33.38-102-80-144c-13.38 12-25.5 24.75-36.13 37.5C266.4 46 244.6 22.25 220 0c-63.12 57-108 131.3-108 176C112 255.5 176.5 320 256 320zM220.2 67.88c9.125 10 17.62 20.25 25.12 30.38l36.25 48.5l36.87-43.88C339.9 133.3 351.1 165.1 351.1 176c0 52.88-42.1 96-95.1 96c-52.87 0-95.1-43.13-95.1-96C159.1 156.6 180.7 112.6 220.2 67.88zM496.1 465.4L326.5 404l169.7-61.44c12.47-4.5 18.94-18.28 14.41-30.72c-4.5-12.5-18.28-18.88-30.72-14.41L256 378.5L32.16 297.4C19.76 292.1 5.947 299.3 1.447 311.8c-4.531 12.44 1.938 26.22 14.41 30.72L185.5 404l-169.7 61.44c-12.47 4.5-18.94 18.28-14.41 30.72C4.979 505.9 14.2 512 24.01 512c2.719 0 5.469-.4687 8.156-1.438L256 429.5l223.8 81.05C482.5 511.5 485.3 512 487.1 512c9.811 0 19.03-6.062 22.56-15.84C515.1 483.7 508.6 469.9 496.1 465.4z"],
    "campground": [576, 512, [63163], "26fa", "M562.8 415.2l-243.9-302l59.81-74.06c8.344-10.31 6.75-25.44-3.562-33.75c-10.38-8.344-25.44-6.688-33.75 3.563L288 74.93L234.7 8.901C226.4-1.381 211.3-3.006 200.9 5.338C190.6 13.65 189 28.78 197.3 39.09l59.81 74.06L13.19 415.2C4.688 425.7 0 438.1 0 452.5C0 485.3 26.69 512 59.47 512h457.1C549.3 512 576 485.3 576 452.5C576 438.1 571.3 425.7 562.8 415.2zM185.1 463.1L288 327.1l102 136H185.1zM516.5 463.1h-66.54l-142.8-190.4c-9.062-12.06-29.31-12.06-38.38 0l-142.8 190.4H59.47C53.16 463.1 48 458.8 48 452.5c0-2.594 .9062-5.156 2.531-7.188L288 151.3l237.4 293.1C527.1 447.4 528 449.9 528 452.5C528 458.8 522.8 463.1 516.5 463.1z"],
    "candle-holder": [448, 512, [63164], "1f56f", "M372 368.1c-23.54 1.27-44.8 16.06-57.18 36.13C300.9 426.8 302.3 446.7 308.4 464H272v-192C272 245.6 250.4 224 224 224H96C69.6 224 48 245.6 48 272v192H24C10.75 464 0 474.7 0 488C0 501.3 10.75 512 24 512h348.7c34.79 0 67.07-23.22 73.8-57.35C455.9 407.1 418.4 365.6 372 368.1zM224 464H96v-192h32v56C128 341.3 138.8 352 152 352s24-10.75 24-24V272H224V464zM376 464c-13.25 0-24-10.75-24-24S362.8 416 376 416s24 10.75 24 24S389.3 464 376 464zM160 191.1c45.88 0 77.1-32.62 77.1-79.25C237.1 82.75 205.4 37.88 160 0C114.4 38 81.1 82.88 81.1 112.8C81.1 159.4 114.1 191.1 160 191.1zM160 66.13C180 88.25 189.8 106.1 189.1 112.8C190.4 124.4 186.1 144 160 144S129.1 124.4 129.1 113C130.5 106.3 140 88.25 160 66.13z"],
    "candy-cane": [512, 512, [], "f786", "M497.1 95.38C469.2 36.62 411.4 0 346.4 0c-29.88 0-59.25 8.125-85 23.5L235.7 38.88c-21.88 13-29 41.37-16 63.13L250.6 153.5c12.13 20.25 39.88 29.75 63.13 15.88l25.75-15.37c16-9.625 30.13 14.62 14.38 24L22.43 375c-10.63 6.25-18 16.38-21 28.25c-3 12-1.25 24.38 5.125 34.88l30.75 51.5C45.68 503.4 60.68 512 76.8 512c8.375 0 16.38-2.25 23.63-6.5L426.2 311.9C501.8 266.6 533.1 171.5 497.1 95.38zM212.3 383.2L155.9 351.5l64.25-38.25l56.38 31.88L212.3 383.2zM324.2 316.8L267.7 285l59.5-35.25l56.25 31.62L324.2 316.8zM395.1 128.1c-3.25-4.125-6.875-7.875-10.88-10.88v-63c30 10 55.25 31.63 69.5 61.75c1.875 3.875 2.875 8 4.25 12.12H395.1zM336.1 48.75v56.62c-15.88 2.875-19.38 6.25-45.13 22l-28.88-48.25C289.7 62.62 304.7 51.5 336.1 48.75zM108.3 379.8l56.5 31.87L77.68 463.5l-29-48.25L108.3 379.8zM426.6 250.6l-51.88-29.25C392.7 210.8 403.9 198.2 407.7 176h55.38C459.9 203.5 447.2 229.9 426.6 250.6z"],
    "candy-corn": [640, 512, [], "f6bd", "M479.1 0c-165.8 1.625-164.5 39.5-157.9 72.5c30.38 151.5 94.01 343.5 157.8 343.5c63.75-.125 127.6-191.9 158-343.5C644.5 39.5 645.8 1.625 479.1 0zM479.9 365.6c-12-10.25-29.25-39.63-47.5-84.13c31.25-1.875 64-1.875 95.26 0C509.3 326.1 492 355.4 479.9 365.6zM591 63c-3.25 16.25-6.75 31.88-10.25 47.13c-63.75-8-137.8-8-201.5 0c-3.5-15.25-7-30.88-10.25-47.13c-.125-.625-.25-1.25-.375-1.75C378.9 57 407.6 48.75 479.1 48c72.38 .75 101.1 9 111.4 13.25C591.3 61.75 591.1 62.38 591 63zM84.97 205.8c-116.1 118.5-88.35 144.4-60.47 162.1c128.6 85.63 309.5 176.4 354.5 131.3c44.88-45.25-45.39-225.9-131.1-354.6C229.2 117.5 203.4 89.77 84.97 205.8zM91.61 354.9c-13.25-8.25-26.75-16.75-40.63-26c-.5-.375-1-.75-1.502-1c4.252-10.25 18.75-36.38 69.38-88.13C170.6 189.1 196.7 174.6 206.1 170.4c.25 .5 .625 1 1 1.5c9.25 13.88 17.75 27.38 26 40.63C183.2 251.9 130.1 304.1 91.61 354.9zM317.6 371.3c18.62 44.5 27.12 77.38 25.75 93.13c-15.75 1.25-48.63-7.25-93.13-25.75C271.1 415.3 294.2 392 317.6 371.3z"],
    "cannabis": [576, 512, [], "f55f", "M523.4 326.9c-2.25-1.156-16.91-8.625-39.5-15.94c44.47-64.09 58.53-126.1 59.19-130c2.781-12.66-1-25.81-10.78-35.84c-9.375-8.844-24.75-12.06-34.44-9.969c-.6562 .125-57.41 11.66-119.4 50.53c-10.06-87.56-49.16-153.9-58.25-168.3C305.9-4.438 270.5-5.062 255.3 18C246.6 31.91 207.5 98.19 197.5 185.8c-60-37.47-115.1-49.88-118.3-50.34L70.5 134.4c-9.969 0-19.5 3.812-27.28 11.19c-9.281 9.281-13.12 22.5-10.31 35.34C33.56 184 47.63 246.9 92.09 311C69.5 318.3 54.81 325.8 52.5 326.1C39.84 333.6 32 346.7 32 360.9c0 14.38 7.906 27.41 20.16 33.78C52.69 395 100.1 420.6 164 425.5c-.7813 2.188-1.25 3.656-1.406 4.188c-4.562 13.78-1 28.75 9.156 38.94c10.03 10.16 24.81 13.94 38.59 9.75C215.5 476.8 240.1 463.4 264 449.1v39.86c0 13.25 10.75 24 24 24s24-10.75 24-24v-39.86c23.85 14.27 48.45 27.69 53.63 29.24C369.4 479.5 373.2 480 376.1 480c10.12 0 19.88-3.906 26.84-11c10.41-10.06 14.19-25.5 9.938-38.25c-.25-.875-.8438-2.688-1.781-5.281c63.94-4.875 111.3-30.47 111.4-30.53C536.1 388.3 544 375.3 544 360.9C544 346.7 536.2 333.6 523.4 326.9zM391.3 378.3c-5.344 0-10.47-.125-15.28-.25l-40.47-1c0 0 21 40.88 22.09 43.19c-11.78-6.656-26.38-15.22-40.72-24.41L312 392.6V311.1C312 298.7 301.3 288 288 288S264 298.7 264 311.1v80.62l-4.938 3.16c-14.47 9.281-29.25 17.91-40.78 24.47c1.094-2.281 2.281-4.719 3.594-7.219L240.5 377c0 0-50.5 1.25-55.84 1.25c-37.53 0-70.38-9.719-90.16-17.28c10.94-4.094 25.88-8.906 43.38-12.38l40.41-8L151.4 309.4C111.8 263.4 92.13 211.8 84.19 186.5c24.72 7.562 74.59 26.09 119.8 62.69l39.09 31.62V226.6c0-76.41 29.94-141.5 44.88-169.3c15.03 27.97 44.88 93 44.88 169.3v54.22l39.09-31.62c46.09-37.28 96.34-55.69 119.9-62.94C484 211.5 464.3 263.2 424.6 309.4l-26.88 31.19l40.41 8c17.53 3.5 32.47 8.281 43.41 12.41C461.8 368.5 428.9 378.3 391.3 378.3z"],
    "capsules": [576, 512, [], "f46b", "M553.8 301l-133.1-179.5c-37-49.59-107.2-59.79-156.7-22.79C244.1 112.8 231 131.8 224 152.6L223.9 143.9C223.9 82.07 173.8 32 111.1 32S-.0021 82.08-.0021 143.1L-.0028 368c0 61.88 50.13 112 112 112s112-50.13 112-112L224 223c3.688 11.31 8.75 22.34 16.26 32.4l133.1 179.5c37 49.59 107.2 59.79 156.7 22.79C580.6 420.7 590.8 350.6 553.8 301zM176 256h-128V144c0-84.75 128-84.75 128 0V256zM345.7 316.5L278.7 226.7c-50.68-67.92 51.91-144.5 102.6-76.55L448.3 239.9L345.7 316.5z"],
    "car": [512, 512, [61881, "automobile"], "1f698", "M112 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C144 270.3 129.7 256 112 256zM400 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C432 270.3 417.7 256 400 256zM462.9 188.7l-40.56-101.4C408.9 53.72 376.9 32 340.7 32H171.3C135.1 32 103.1 53.72 89.63 87.33L49.06 188.7C19.91 205.2 0 236.1 0 272V448c0 17.67 14.33 32 32 32s32-14.33 32-32v-48h384V448c0 17.67 14.33 32 32 32s32-14.33 32-32V272C512 236.1 492.1 205.2 462.9 188.7zM134.2 105.1C140.3 89.88 154.9 80 171.3 80h169.3c16.45 0 31.03 9.875 37.14 25.14L406.2 176H105.8L134.2 105.1zM464 352h-416V272C48 245.5 69.55 224 96.01 224h319.1C442.5 224 464 245.5 464 272V352z"],
    "car-battery": [512, 512, ["battery-car"], "f5df", "M448 96h-16V80C432 71.13 424.9 64 416 64h-96c-8.875 0-16 7.125-16 16V96h-96V80C208 71.13 200.9 64 192 64H96C87.13 64 80 71.13 80 80V96H64C28.8 96 0 124.8 0 160v224C0 419.2 28.8 448 63.1 448H448c35.2 0 64-28.8 64-63.1V160C512 124.8 483.2 96 448 96zM464 384c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V160c0-8.838 7.164-16 16-16h384c8.836 0 16 7.162 16 16V384zM416 224h-32V192c0-8.836-7.164-16-16-16S352 183.2 352 192v32h-32c-8.836 0-16 7.164-16 16S311.2 256 320 256h32v32c0 8.836 7.164 16 16 16S384 296.8 384 288V256h32c8.836 0 16-7.164 16-16S424.8 224 416 224zM192 224H96C87.16 224 80 231.2 80 240S87.16 256 96 256h96c8.836 0 16-7.164 16-16S200.8 224 192 224z"],
    "car-bolt": [512, 512, [], "e341", "M320 192L284.3 192l33.45-55.77c3.906-6.5 2.703-14.84-2.859-19.98c-5.578-5.156-14.02-5.688-20.16-1.266l-112 80C177 199 174.6 206.3 176.8 212.9C178.9 219.5 185 224 192 224L227.7 224L194.3 279.8C190.4 286.3 191.6 294.6 197.1 299.8C200.2 302.6 204.1 304 208 304c3.25 0 6.5-.9844 9.297-2.984l112-80c5.656-4.031 8.062-11.28 5.938-17.91C333.1 196.5 326.1 192 320 192zM112 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C144 270.3 129.7 256 112 256zM400 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C432 270.3 417.7 256 400 256zM462.9 188.7l-40.56-101.4C408.9 53.72 376.9 32 340.7 32H171.3C135.1 32 103.1 53.72 89.63 87.33L49.06 188.7C19.91 205.2 0 236.1 0 272V448c0 17.67 14.33 32 32 32s32-14.33 32-32v-48h384V448c0 17.67 14.33 32 32 32s32-14.33 32-32V272C512 236.1 492.1 205.2 462.9 188.7zM464 352h-416V272C48 245.5 69.55 224 96.01 224H136V176H105.8l28.34-70.86C140.3 89.88 154.9 80 171.3 80h169.3c16.45 0 31.03 9.875 37.14 25.14L406.2 176H368V224h47.99C442.5 224 464 245.5 464 272V352z"],
    "car-building": [640, 512, [], "f859", "M144 192h-32C103.2 192 96 199.2 96 208v32C96 248.8 103.2 256 112 256h32C152.8 256 160 248.8 160 240v-32C160 199.2 152.8 192 144 192zM144 288h-32C103.2 288 96 295.2 96 304v32C96 344.8 103.2 352 112 352h32C152.8 352 160 344.8 160 336v-32C160 295.2 152.8 288 144 288zM208 96C199.2 96 192 103.2 192 112v32C192 152.8 199.2 160 208 160h32C248.8 160 256 152.8 256 144v-32C256 103.2 248.8 96 240 96H208zM144 96h-32C103.2 96 96 103.2 96 112v32C96 152.8 103.2 160 112 160h32C152.8 160 160 152.8 160 144v-32C160 103.2 152.8 96 144 96zM304 56v48C304 117.3 314.8 128 328 128S352 117.3 352 104v-48C352 25.12 326.9 0 296 0h-240C25.12 0 0 25.12 0 56v400C0 469.3 10.75 480 24 480s24-10.75 24-24V56c0-4.406 3.594-8 8-8h240C300.4 48 304 51.59 304 56zM256 212.1V208C256 199.2 248.8 192 240 192h-32C199.2 192 192 199.2 192 208v32C192 248.8 199.2 256 208 256h30.44L256 212.1zM602.4 284.4l-31.82-79.54C559.7 177.6 533.7 160 504.4 160H359.6c-29.33 0-55.33 17.6-66.23 44.83l-31.82 79.55C238.9 301.1 224 329.2 224 360V480c0 17.67 14.33 32 32 32s32-14.33 32-32v-32h288v32c0 17.67 14.33 32 32 32s32-14.33 32-32v-120C640 329.2 625.1 301.1 602.4 284.4zM337.9 222.7C341.5 213.8 350 208 359.6 208h144.8c9.598 0 18.1 5.76 21.67 14.66L542.6 264h-221.2L337.9 222.7zM592 400h-320v-40c0-26.47 21.53-48 48-48h224c26.47 0 48 21.53 48 48V400zM528 336c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C552 346.7 541.3 336 528 336zM336 336c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C360 346.7 349.3 336 336 336z"],
    "car-bump": [576, 512, [], "f5e0", "M355.9 183.5c-15.68 6.479-23.14 24.44-16.66 40.13c6.477 15.68 24.44 23.15 40.12 16.67c15.68-6.477 23.14-24.45 16.66-40.13C389.6 184.5 371.6 177 355.9 183.5zM100.4 289.1c-15.68 6.479-23.14 24.44-16.66 40.13c6.475 15.68 24.44 23.15 40.12 16.67c15.68-6.477 23.14-24.45 16.67-40.13C134.1 290.1 116.1 282.6 100.4 289.1zM110.6 434.5l340.7-140.8l17.59 42.6c6.477 15.68 24.44 23.15 40.12 16.67c15.68-6.479 23.14-24.45 16.67-40.13l-64.5-156.2c-13.15-31.84-42.14-51.97-74.04-55.91l-73.15-75.13c-24.24-24.9-60.66-32.42-92.77-19.15L70.96 68.54C38.85 81.8 18.35 112.8 18.75 147.6l1.174 104.9c-19.82 25.31-26.16 60.04-13.02 91.87l62.32 148.7c6.475 15.68 24.44 23.15 40.12 16.67c15.68-6.479 23.14-24.45 16.67-40.13L110.6 434.5zM88.55 111.1l150.2-62.07c14.6-6.031 31.15-2.611 42.17 8.697l51.12 52.49L65.63 220.3L64.81 147.1C64.64 131.3 73.95 117.2 88.55 111.1zM78.81 397.7l-29.32-70.1c-9.699-23.49 1.516-50.49 24.1-60.19l283.9-117.3c23.48-9.701 50.48 1.516 60.18 25l29.32 70.1L78.81 397.7zM568.3 470.4l-44.83-41.38c-40.5-37.38-110.4-37.38-150.9 0l-44.83 41.38c-9.734 9-10.34 24.17-1.359 33.92c9.016 9.766 24.19 10.31 33.92 1.359l44.83-41.38c22.38-20.69 63.41-20.69 85.78 0l44.83 41.38C540.3 509.9 546.2 512 552 512c6.453 0 12.91-2.594 17.64-7.719C578.6 494.5 578 479.4 568.3 470.4z"],
    "car-bus": [640, 512, [], "f85a", "M48 328.4V224.1h203.2l12.42-31.04c2.418-6.033 5.498-11.61 8.877-16.95H216V48.7c68.53 3.988 120 24.6 120 50.4v31.97c7.65-1.781 15.5-2.984 23.62-2.984L384 128V99.1C384 25.99 280.6 0 192 0S0 25.99 0 99.1v229.3c.125 30.87 25.12 55.86 56 55.86L64 384.1v31.93C64 433.7 78.38 448 96 448s32-14.31 32-31.93v-31.98l64 .0446v-31.73c0-5.373 .375-10.75 1.125-15.99H56C51.63 336.4 48 332.8 48 328.4zM48 99.1c0-25.79 51.47-46.41 120-50.4v127.4H48V99.1zM602.4 284.4l-31.82-79.54C559.7 177.6 533.7 160 504.4 160H359.6c-29.33 0-55.33 17.6-66.23 44.83l-31.82 79.55C238.9 301.1 224 329.2 224 360V480c0 17.67 14.33 32 32 32s32-14.33 32-32v-32h288v32c0 17.67 14.33 32 32 32s32-14.33 32-32v-120C640 329.2 625.1 301.1 602.4 284.4zM337.9 222.7C341.5 213.8 350 208 359.6 208h144.8c9.598 0 18.1 5.76 21.67 14.66L542.6 264h-221.2L337.9 222.7zM592 400h-320v-40c0-26.47 21.53-48 48-48h224c26.47 0 48 21.53 48 48V400zM336 336c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C360 346.7 349.3 336 336 336zM528 336c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C552 346.7 541.3 336 528 336zM80 280c0 13.25 10.75 23.1 24 23.1S128 293.3 128 280c0-13.25-10.75-23.99-24-23.99S80 266.8 80 280z"],
    "car-circle-bolt": [640, 512, [], "e342", "M496 224C416.5 224 352 288.5 352 368s64.46 144 144 144s144-64.46 144-144S575.5 224 496 224zM555.4 377.4l-86.67 68C466.6 447.2 463.9 448 461.3 448c-2.703 0-5.406-.9062-7.625-2.734c-4.344-3.578-5.625-9.703-3.062-14.72L476.4 380H444c-5.109 0-9.672-3.25-11.34-8.078c-1.672-4.844-.0938-10.2 3.938-13.36l86.67-68c4.422-3.5 10.67-3.422 15.03 .1719c4.344 3.578 5.625 9.703 3.062 14.72L515.6 356H548c5.109 0 9.672 3.25 11.34 8.078C561 368.9 559.4 374.3 555.4 377.4zM80 288c0 17.67 14.33 32 32 32s32-14.33 32-32c0-17.67-14.33-32-32-32S80 270.3 80 288zM320.8 352H48V272C48 245.5 69.55 224 96.01 224h298.1c22.12-15.55 47.98-26.02 75.97-30.02c-2.613-1.836-5.238-3.664-8.031-5.242l-40.56-101.4C408.9 53.72 376.9 32 340.7 32H171.3C135.1 32 103.1 53.72 89.63 87.33L49.06 188.7C19.91 205.2 0 236.1 0 272V448c0 17.67 14.33 32 32 32s32-14.33 32-32v-48h259C321.1 389.6 320 378.9 320 368C320 362.6 320.3 357.3 320.8 352zM134.2 105.1C140.3 89.88 154.9 80 171.3 80h169.3c16.45 0 31.03 9.875 37.14 25.14L406.2 176H105.8L134.2 105.1z"],
    "car-crash": [640, 512, [], "f5e1", "M102.4 200.9L71.39 192.3l26.22-18.11c12.83-8.875 16.81-26.44 9.094-39.95L94.28 112.5l23.55 7.281c15.09 4.688 31.34-3.266 37.02-17.92l12.52-31.98l4.266 6.844c7 11.27 21.8 14.7 33.05 7.703c11.27-7 14.7-21.8 7.703-33.05L190.8 16.55C185.6 6.406 175.3 0 163.8 0c-12.55 0-23.61 7.562-28.16 19.25L116.2 68.97l-50.5-15.59C53.75 49.75 40.97 53.59 33.14 63.31C25.28 73.08 24.22 86.44 30.42 97.34l26.55 46.59L13.16 174.2c-10.3 7.062-15.17 19.52-12.39 31.7c2.766 12.19 12.52 21.31 22.11 22.64l66.69 18.56C91.72 247.7 93.88 248 96.02 248c10.5 0 20.16-6.953 23.11-17.56C122.7 217.7 115.2 204.4 102.4 200.9zM539.6 289.1c-15.68-6.477-33.64 .9844-40.12 16.67c-6.475 15.68 .9863 33.65 16.67 40.13c15.68 6.479 33.64-.9844 40.12-16.67C562.7 313.5 555.3 295.6 539.6 289.1zM620.1 252.5l1.174-104.9c.3926-34.75-20.11-65.79-52.21-79.05l-150.2-62.07c-32.11-13.27-68.53-5.748-92.77 19.15L252.9 100.7C220.1 104.7 191.1 124.8 178.8 156.7L114.3 312.8c-6.477 15.68 .9844 33.65 16.67 40.13c15.68 6.477 33.64-.9863 40.12-16.67l17.59-42.6l340.7 140.8l-15.41 35.07c-6.475 15.68 .9844 33.65 16.67 40.13c15.68 6.479 33.64-.9863 40.12-16.67l62.32-148.7C646.2 312.5 639.9 277.8 620.1 252.5zM359 57.76c11.02-11.31 27.57-14.73 42.17-8.697l150.2 62.07c14.6 6.031 23.91 20.14 23.74 35.93L574.4 220.3L307.9 110.3L359 57.76zM590.5 326.7l-29.32 70.1L192.1 245.2l29.32-70.1C231.1 150.8 258.1 139.5 281.6 149.2l283.9 117.3C588.1 276.2 600.2 303.2 590.5 326.7zM284.1 183.5C268.4 177 250.4 184.5 243.9 200.2C237.5 215.9 244.9 233.8 260.6 240.3c15.68 6.479 33.64-.9863 40.12-16.67C307.2 207.1 299.7 189.1 284.1 183.5z"],
    "car-garage": [640, 512, [], "f5e2", "M224 336c-13.25 0-24 10.74-24 24C200 373.3 210.7 384 224 384s24-10.75 24-24C248 346.7 237.3 336 224 336zM416 336c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 346.7 429.3 336 416 336zM490.4 284.4l-31.82-79.54C447.7 177.6 421.7 160 392.4 160H247.6C218.3 160 192.3 177.6 181.4 204.8l-31.82 79.56C126.9 301.1 112 329.2 112 360V480c0 17.67 14.33 32 32 32s32-14.33 32-32v-32h288v32c0 17.67 14.33 32 32 32s32-14.33 32-32v-120C528 329.2 513.1 301.1 490.4 284.4zM225.9 222.7C229.5 213.8 238 208 247.6 208h144.8c9.598 0 18.1 5.76 21.66 14.66L430.6 264H209.4L225.9 222.7zM480 400H160v-40c0-26.47 21.53-48 48-48h224c26.47 0 48 21.53 48 48V400zM640 184c0-8.528-4.559-16.78-12.6-21.12l-295.9-159.9c-3.547-1.922-7.623-2.962-11.55-2.962S311.1 1.042 308.4 2.964L12.59 162.9C4.556 167.2-.0032 175.5-.0032 184c0 12.48 10.06 23.1 24.04 23.1c3.85 0 7.754-.931 11.37-2.894l284.6-153.7l284.6 153.7C608.2 207.1 612.1 208 615.1 208C630.1 208 640 196.4 640 184z"],
    "car-mirrors": [576, 512, [], "e343", "M144 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C176 270.3 161.7 256 144 256zM432 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C464 270.3 449.7 256 432 256zM544 160h-60.56l-29.07-72.67C440.9 53.72 408.9 32 372.7 32H203.3C167.1 32 135.1 53.72 121.6 87.33L92.56 160H32C14.33 160 0 174.3 0 192c0 17.67 14.33 32 32 32h13.13C36.83 238.1 32 254.4 32 272V448c0 17.67 14.33 32 32 32s32-14.33 32-32v-48h384V448c0 17.67 14.33 32 32 32s32-14.33 32-32V272c0-17.57-4.832-33.92-13.13-48H544c17.67 0 32-14.33 32-32C576 174.3 561.7 160 544 160zM166.2 105.1C172.3 89.88 186.9 80 203.3 80h169.3c16.45 0 31.03 9.875 37.14 25.14L438.2 176H137.8L166.2 105.1zM496 352h-416V272C80 245.5 101.5 224 128 224h319.1C474.5 224 496 245.5 496 272V352z"],
    "car-rear": [512, 512, ["car-alt"], "f5de", "M462.9 188.7l-40.56-101.4C408.9 53.72 376.9 32 340.7 32H171.3C135.1 32 103.1 53.72 89.63 87.33L49.06 188.7C19.91 205.2 0 236.1 0 272l.0247 64c0 23.63 12.95 44.04 31.1 55.12V448c0 17.67 14.32 32 31.1 32S96 465.7 96 448v-48h320V448c0 17.67 14.33 32 32 32c17.67 0 31.1-14.33 31.1-32v-56.88C499.1 380 512 359.6 512 336v-64C512 236.1 492.1 205.2 462.9 188.7zM134.2 105.1C140.3 89.88 154.9 80 171.3 80h169.3c16.45 0 31.03 9.875 37.14 25.14L406.2 176H105.8L134.2 105.1zM448 352h-128v-32c0-17.67-14.33-32-32-32H224c-17.67 0-32 14.33-32 32v32H64c-8.822 0-16-7.178-16-16v-32h40c13.25 0 24-10.75 24-24S101.3 256 88 256H50.95C57.57 237.4 75.17 224 96 224h320c20.83 0 38.43 13.42 45.05 32H424c-13.26 0-24 10.75-24 24s10.74 24 24 24h40v32C464 344.8 456.8 352 448 352z"],
    "car-side": [640, 512, [62948], "1f697", "M520 224l-108.7-135.9C399.1 72.85 380.7 64 361.3 64H155.4c-26.25 0-49.75 15.88-59.5 40.25L48 226.3C20.5 233.4 0 258.3 0 288v112c0 17.67 14.33 32 32 32h33.61C73.27 477.4 112.5 512 160 512s86.73-34.64 94.39-80h131.2C393.3 477.4 432.5 512 480 512s86.73-34.64 94.39-80H608c17.67 0 32-14.33 32-32v-56C640 277.7 586.3 224 520 224zM272 112h89.25c4.914 0 9.492 2.201 12.56 6.039L458.5 224H272V112zM140.4 122.1C142.9 115.1 148.8 112 155.4 112H224V224H100.4L140.4 122.1zM160 464c-26.51 0-48-21.49-48-48s21.49-48 48-48s48 21.49 48 48S186.5 464 160 464zM480 464c-26.51 0-48-21.49-48-48s21.49-48 48-48s48 21.49 48 48S506.5 464 480 464zM592 384h-21.88C556.9 346.8 521.7 320 480 320s-76.9 26.8-90.12 64H250.1C236.9 346.8 201.7 320 160 320s-76.9 26.8-90.12 64H48V288c0-8.838 7.164-16 16-16h456c39.76 0 72 32.23 72 72V384z"],
    "car-side-bolt": [640, 512, [], "e344", "M352 224H313.9l28.44-56.84c3.344-6.672 1.625-14.77-4.125-19.5c-5.812-4.766-14.06-4.891-19.94-.3438l-104 80C208.8 231.5 206.7 238.7 208.8 245.2C211.1 251.6 217.2 256 224 256h38.13L233.7 312.8c-3.344 6.672-1.625 14.77 4.125 19.5C240.8 334.8 244.4 336 248 336c3.438 0 6.875-1.109 9.75-3.312l104-80c5.438-4.188 7.594-11.36 5.406-17.84C364.9 228.4 358.8 224 352 224zM520 224l-108.7-135.9C399.1 72.85 380.7 64 361.3 64H155.4c-26.25 0-49.75 15.88-59.5 40.25L48 226.3C20.5 233.4 0 258.3 0 288v112c0 17.67 14.33 32 32 32h33.61C73.27 477.4 112.5 512 160 512s86.73-34.64 94.39-80h131.2C393.3 477.4 432.5 512 480 512s86.73-34.64 94.39-80H608c17.67 0 32-14.33 32-32v-56C640 277.7 586.3 224 520 224zM160 464c-26.51 0-48-21.49-48-48s21.49-48 48-48s48 21.49 48 48S186.5 464 160 464zM480 464c-26.51 0-48-21.49-48-48s21.49-48 48-48s48 21.49 48 48S506.5 464 480 464zM592 384h-21.88C556.9 346.8 521.7 320 480 320s-76.9 26.8-90.12 64H250.1C236.9 346.8 201.7 320 160 320s-76.9 26.8-90.12 64H48V288c0-8.837 7.163-16 16-16h72C149.3 272 160 261.3 160 248S149.3 224 136 224H100.4l39.99-101.9C142.9 115.1 148.8 112 155.4 112h205.9c4.887 0 9.509 2.222 12.56 6.039L458.5 224H439.1C426.7 224 416 234.7 416 247.1S426.7 272 439.1 272H520c39.76 0 72 32.24 72 72V384z"],
    "car-tilt": [640, 512, [], "f5e5", "M616 464h-96.37l49.46-119.8c13.15-31.83 6.807-66.55-13.02-91.85l1.174-104.8c.3945-34.74-20.11-65.77-52.21-79.03l-150.2-62.06C322.7-6.799 286.3 .7168 262 25.61L188.9 100.7C156.1 104.7 127.1 124.8 114.8 156.6L50.33 312.8C43.86 328.4 51.32 346.4 67 352.9c15.68 6.477 33.64-.9863 40.12-16.66l17.59-42.59l340.7 140.7L453.2 464H24C10.75 464 0 474.7 0 488C0 501.3 10.75 512 24 512h592c13.25 0 24-10.75 24-24C640 474.7 629.3 464 616 464zM295 57.75c11.02-11.31 27.57-14.72 42.17-8.695l150.2 62.06c14.6 6.029 23.91 20.13 23.74 35.92l-.8184 73.26L243.9 110.2L295 57.75zM128.1 245.2l29.32-70.98C167.1 150.7 194.1 139.5 217.6 149.2l283.9 117.3c23.48 9.699 34.7 36.7 24.1 60.18l-29.32 70.98L128.1 245.2zM475.6 289c-15.68-6.477-33.64 .9824-40.12 16.66c-6.475 15.68 .9863 33.64 16.67 40.12c15.68 6.475 33.64-.9863 40.12-16.67C498.7 313.4 491.3 295.5 475.6 289zM220.1 183.5C204.4 176.1 186.4 184.4 179.9 200.1s.9863 33.64 16.66 40.12c15.68 6.477 33.64-.9863 40.12-16.67S235.7 189.9 220.1 183.5z"],
    "car-wash": [448, 512, [], "f5e6", "M384 127.1c23.5 0 42.63-19.09 42.63-42.59C426.6 61.75 384 0 384 0s-42.63 61.75-42.63 85.38C341.4 108.9 360.5 127.1 384 127.1zM64 127.1c23.5 0 42.63-19.09 42.63-42.59C106.6 61.75 64 0 64 0S21.38 61.75 21.38 85.38C21.38 108.9 40.5 127.1 64 127.1zM224 127.1c23.5 0 42.63-19.1 42.63-42.6C266.6 61.75 224 .0062 224 .0062S181.4 61.75 181.4 85.38C181.4 108.9 200.5 127.1 224 127.1zM394.4 284.4l-31.82-79.54C351.7 177.6 325.7 160 296.4 160H151.6C122.3 160 96.28 177.6 85.38 204.8l-31.82 79.56C30.88 301.1 16 329.2 16 360V480c0 17.67 14.33 32 32 32s32-14.33 32-32v-32h288v32c0 17.67 14.33 32 32 32s32-14.33 32-32v-120C432 329.2 417.1 301.1 394.4 284.4zM129.9 222.7C133.5 213.8 142 208 151.6 208h144.8c9.598 0 18.1 5.76 21.66 14.66L334.6 264H113.4L129.9 222.7zM384 400H64v-40c0-26.47 21.53-48 48-48h224c26.47 0 48 21.53 48 48V400zM128 336c-13.25 0-24 10.74-24 24C104 373.3 114.7 384 128 384s24-10.75 24-24C152 346.7 141.3 336 128 336zM320 336c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 346.7 333.3 336 320 336z"],
    "car-wrench": [512, 512, ["car-mechanic"], "f5e3", "M426.4 284.4l-31.82-79.54C383.7 177.6 357.7 160 328.4 160H183.6C154.3 160 128.3 177.6 117.4 204.8l-31.82 79.56C62.88 301.1 48 329.2 48 360V480c0 17.67 14.33 32 32 32s32-14.33 32-32v-32h288v32c0 17.67 14.33 32 32 32s32-14.33 32-32v-120C464 329.2 449.1 301.1 426.4 284.4zM161.9 222.7C165.5 213.8 174 208 183.6 208h144.8c9.598 0 18.1 5.76 21.66 14.66L366.6 264H145.4L161.9 222.7zM416 400H96v-40c0-26.47 21.53-48 48-48h224c26.47 0 48 21.53 48 48V400zM505.9 111.1H447.8l-21.37-31.1l21.37-31.1h58.14c4.619 0 7.619-5.048 5.246-9.001C497.2 15.66 471.7 0 442.4 0c-32.79 0-60.59 19.86-73.01 48H142.8C131.9 23.19 108.6 4.574 80.9 .7793c-33.87-4.641-64.28 11.89-80.05 38.19c-2.381 3.965 .6094 9.034 5.24 9.034H64.22l21.37 31.1L64.22 112H6.078c-4.619 0-7.619 5.047-5.246 9.002C14.82 144.3 40.33 160 69.57 160c32.79 0 60.59-19.86 73.01-47.1h226.6c10.97 24.81 34.23 43.43 61.94 47.22c33.87 4.641 64.28-11.89 80.05-38.19C513.5 117.1 510.5 111.1 505.9 111.1zM160 336c-13.25 0-24 10.74-24 24C136 373.3 146.7 384 160 384s24-10.75 24-24C184 346.7 173.3 336 160 336zM352 336c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C376 346.7 365.3 336 352 336z"],
    "caravan": [640, 512, [], "f8ff", "M616 368H576V192c0-88.37-71.63-160-160-160H96C42.98 32 0 74.98 0 128v192c0 53 43 96 96 96c0 53 43 96 96 96s96-43 96-96h328c13.25 0 24-10.75 24-23.1S629.3 368 616 368zM192 464c-26.5 0-48-21.5-48-48s21.5-48 48-48s48 21.5 48 48S218.5 464 192 464zM432 240C423.1 240 416 247.1 416 256c0 8.875 7.125 16 16 16v96h-64v-192h64V240zM528 368H480V168C480 145.9 462.1 128 440 128h-80C337.9 128 320 145.9 320 168v200H274.8C257.1 339.4 227.5 320 192 320s-66 19.38-82.75 48H96c-26.5 0-48-21.5-48-48V128c0-26.5 21.5-48 48-48h320c61.88 .125 111.9 50.13 112 112V368zM256 128H128C110.4 128 96 142.4 96 160v64c0 17.62 14.38 32 32 32h128c17.62 0 32-14.38 32-32V160C288 142.4 273.6 128 256 128z"],
    "caravan-simple": [640, 512, ["caravan-alt"], "e000", "M416 128h-64c-17.62 0-32 14.38-32 32v64c0 17.62 14.38 32 32 32h64c17.62 0 32-14.38 32-32V160C448 142.4 433.6 128 416 128zM616 368H576V192c0-88.37-71.63-160-160-160H96C42.98 32 0 74.98 0 128v192c0 53 43 96 96 96c0 53 43 96 96 96s96-43 96-96h328c13.25 0 24-10.75 24-23.1S629.3 368 616 368zM192 464c-26.5 0-48-21.5-48-48s21.5-48 48-48s48 21.5 48 48S218.5 464 192 464zM528 368H274.8C257.1 339.4 227.5 320 192 320s-66 19.38-82.75 48H96c-26.5 0-48-21.5-48-48V128c0-26.5 21.5-48 48-48h320c61.88 .125 111.9 50.13 112 112V368zM256 128H128C110.4 128 96 142.4 96 160v64c0 17.62 14.38 32 32 32h128c17.62 0 32-14.38 32-32V160C288 142.4 273.6 128 256 128z"],
    "caret-down": [320, 512, [], "f0d7", "M271.1 176H48.08c-42.63 0-64.25 51.77-33.88 81.9l111.9 112c18.63 18.76 49.13 18.76 67.88 0l112-112C335.1 227.8 314.7 176 271.1 176zM159.1 336L47.96 224H271.1L159.1 336z"],
    "caret-left": [256, 512, [], "f0d9", "M208 368V144c0-42.63-51.76-64.13-82.01-33.88l-112 111.9c-18.63 18.75-18.63 49.25 0 68l112 111.9C156.2 432 208 410.7 208 368zM47.98 256l112-112v224L47.98 256z"],
    "caret-right": [256, 512, [], "f0da", "M48 143.1v224c0 42.63 51.76 64.13 82.01 33.88l112-111.9c18.63-18.75 18.63-49.25 0-68l-112-111.9C99.76 79.97 48 101.3 48 143.1zM208 255.1L96.01 367.1V143.1L208 255.1z"],
    "caret-up": [320, 512, [], "f0d8", "M47.97 336h224c42.63 0 64.13-51.76 33.88-82.01l-111.9-112c-18.75-18.63-49.25-18.63-68 0l-111.9 112C-16.03 284.2 5.342 336 47.97 336zM159.1 175.1l112 112H47.97L159.1 175.1z"],
    "carrot": [512, 512, [63367], "1f955", "M369.7 142.3C392.4 94.77 380.6 38.38 334.3 0c-44.49 36.88-56.61 90.02-37.37 136.2c-13.1-4.876-28.26-8.05-42.51-8.05c-47.99 0-94.11 26.75-116.6 72.76l-135.4 277.5c-2.999 6.252-3.287 13.9-.0378 20.53C6.468 507.2 14.72 512 23.34 512c3.374 0 6.85-.7753 10.35-2.401l277.5-135.5c24.1-12.25 46.43-32.63 59.55-59.63c15.75-32.13 16.89-67.64 6.142-98.89C422.8 234.3 475.3 221.8 512 177.7C473.4 131.3 417.1 119.5 369.7 142.3zM327.7 293.4c-8.124 16.5-20.1 29.51-37.49 37.51l-57.36 28.01l-23.87-23.88c-9.373-9.377-24.62-9.377-33.87 0c-9.373 9.377-9.373 24.63 0 33.88l12.12 12.25l-110.4 54.01l96.11-196.9l33.99 34.76c4.749 4.751 10.75 7.002 16.1 7.002c6.249 0 12.25-2.251 16.1-7.002c9.373-9.377 9.373-24.63 0-33.88L199.3 198.3C214.2 184.5 233.3 176.2 254.4 176.2c12.37 0 24.37 2.751 35.74 8.252c19.5 9.627 34.24 26.26 41.37 46.89C338.5 251.8 337.2 273.9 327.7 293.4z"],
    "cars": [640, 512, [], "f85b", "M88 200C88 213.3 98.75 224 112 224s24-10.75 24-24c0-13.26-10.75-24-24-24S88 186.7 88 200zM244.8 240H48V200c0-26.47 21.53-48 48-48h197.6C311.8 136.9 334.8 128 359.6 128h22.58c-1.318-1.137-2.373-2.551-3.75-3.617l-31.82-79.54C335.7 17.6 309.7 0 280.4 0H135.6C106.3 0 80.28 17.6 69.38 44.83l-31.82 79.55C14.88 141.1 0 169.2 0 200V320c0 17.67 14.33 32 32 32s32-14.33 32-32V288h150.9C220.6 279.7 227.1 271.9 234.8 265L244.8 240zM113.9 62.66C117.5 53.76 126 48 135.6 48h144.8c9.598 0 18.1 5.76 21.67 14.66L318.6 104H97.41L113.9 62.66zM336 336c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C360 346.7 349.3 336 336 336zM528 336c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C552 346.7 541.3 336 528 336zM602.4 284.4l-31.82-79.54C559.7 177.6 533.7 160 504.4 160H359.6c-29.33 0-55.33 17.6-66.23 44.83l-31.82 79.55C238.9 301.1 224 329.2 224 360V480c0 17.67 14.33 32 32 32s32-14.33 32-32v-32h288v32c0 17.67 14.33 32 32 32s32-14.33 32-32v-120C640 329.2 625.1 301.1 602.4 284.4zM337.9 222.7C341.5 213.8 350 208 359.6 208h144.8c9.598 0 18.1 5.76 21.67 14.66L542.6 264h-221.2L337.9 222.7zM592 400h-320v-40c0-26.47 21.53-48 48-48h224c26.47 0 48 21.53 48 48V400z"],
    "cart-arrow-down": [576, 512, [], "f218", "M303 200.1C307.7 205.7 313.9 208 320 208s12.28-2.344 16.97-7.031l64-64c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L344 126.1V24C344 10.75 333.3 0 320 0s-24 10.75-24 24v102.1L272.1 103c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L303 200.1zM569.5 44.73C563.4 36.64 554.1 32 543.1 32H472C458.7 32 448 42.74 448 56c0 13.25 10.75 24 24 24h50.77l-45.72 160H161.6L119.6 19.51C117.4 8.189 107.5 0 96 0H23.1C10.74 0 0 10.74 0 23.1C0 37.25 10.74 48 23.1 48h52.14l60.28 316.5C138.6 375.8 148.5 384 160 384H488c13.25 0 24-10.75 24-23.1C512 346.7 501.3 336 488 336H179.9L170.7 288h318.4c14.28 0 26.85-9.479 30.77-23.21l54.86-191.1C577.5 63.05 575.6 52.83 569.5 44.73zM176 416c-26.51 0-47.1 21.49-47.1 48S149.5 512 176 512s47.1-21.49 47.1-48S202.5 416 176 416zM463.1 416c-26.51 0-47.1 21.49-47.1 48s21.49 48 47.1 48s47.1-21.49 47.1-48S490.5 416 463.1 416z"],
    "cart-flatbed": [640, 512, ["dolly-flatbed"], "f474", "M616 399.1H144V64c0-35.2-28.8-64-64-64H24C10.8 0 0 10.8 0 23.1c0 13.2 10.8 23.1 24 23.1h48c13.25 0 24 10.75 24 24v343.1c0 17.6 14.4 31.1 31.1 31.1l34.92 .0023C161.1 453 160 458.4 160 464C160 490.5 181.5 512 208 512S256 490.5 256 464c0-5.643-1.128-10.97-2.917-16h197.9c-1.789 5.029-2.928 10.36-2.928 16C448 490.5 469.5 512 496 512c26.51 0 48.01-21.49 48.01-47.1c0-5.643-1.118-10.97-2.907-16L616 447.1c13.2 0 24-10.8 24-23.1C640 410.8 629.2 399.1 616 399.1zM256 352h288c35.35 0 64-28.66 64-64V96c0-35.35-28.65-63.1-64-63.1H256c-35.35 0-64 28.65-64 63.1v191.1C192 323.3 220.7 352 256 352zM240 96C240 87.18 247.2 80 256 80l80-.0016v111.1l64-31.1l64 31.1V80L544 80c8.822 0 16 7.178 16 15.1v191.1c0 8.822-7.178 15.1-16 15.1H256c-8.822 0-16-7.178-16-15.1V96z"],
    "cart-flatbed-boxes": [640, 512, ["dolly-flatbed-alt"], "f475", "M616 399.1H144V64c0-35.2-28.8-64-64-64H24C10.8 0 0 10.8 0 24C0 37.2 10.8 48 24 48h48C85.25 48 96 58.74 96 72v343.1c0 17.6 14.4 32 32 32l34.92 .0026C161.1 453 160 458.4 160 464C160 490.5 181.5 512 208 512S256 490.5 256 464c0-5.643-1.128-10.97-2.917-16h197.9c-1.789 5.029-2.928 10.36-2.928 16c0 26.51 21.48 48 47.99 48c26.51 0 48.01-21.49 48.01-48c0-5.643-1.118-10.97-2.907-16L616 447.1c13.2 0 24-10.8 24-23.1C640 410.8 629.2 399.1 616 399.1zM256 352h112c15.12 0 29.04-5.271 40-14.07C418.1 346.7 432.9 352 448 352h96c35.29 0 64-28.71 64-64V240c0-30.63-21.63-56.3-50.42-62.55C559.2 171.9 560 166 560 160V112c0-35.29-28.71-64-64-64H448c-10.97 0-21.31 2.775-30.35 7.662C405.9 41.23 388 32 368 32H256C220.7 32 192 60.71 192 96v192C192 323.3 220.7 352 256 352zM432 112C432 103.2 439.2 96 448 96h48C504.8 96 512 103.2 512 112V160c0 8.822-7.178 16-16 16H448c-8.822 0-16-7.178-16-16V112zM432 240C432 231.2 439.2 224 448 224h96c8.822 0 16 7.178 16 16V288c0 8.822-7.178 16-16 16h-96c-8.822 0-16-7.178-16-16V240zM240 96c0-8.822 7.178-16 16-16h112C376.8 80 384 87.18 384 96v192c0 8.822-7.178 16-16 16H256C247.2 304 240 296.8 240 288V96z"],
    "cart-flatbed-empty": [640, 512, ["dolly-flatbed-empty"], "f476", "M616 399.1H144V64c0-35.2-28.8-64-64-64H24C10.8 0 0 10.8 0 24C0 37.2 10.8 48 24 48h48C85.25 48 96 58.74 96 72v343.1c0 17.6 14.4 32 32 32l34.92 .0026C161.1 453 160 458.4 160 464C160 490.5 181.5 512 208 512S256 490.5 256 464c0-5.643-1.128-10.97-2.917-16h197.9c-1.789 5.029-2.928 10.36-2.928 16c0 26.51 21.48 48 47.99 48c26.51 0 48.01-21.49 48.01-48c0-5.643-1.118-10.97-2.907-16L616 447.1c13.2 0 24-10.8 24-23.1C640 410.8 629.2 399.1 616 399.1z"],
    "cart-flatbed-suitcase": [640, 512, ["luggage-cart"], "f59d", "M256 352h288c35.2 0 64-28.8 64-64V160c0-35.2-28.8-64-64-64h-48V64c0-35.35-28.65-64-64-64h-64c-35.35 0-64 28.65-64 64v32H256C220.8 96 192 124.8 192 160v128C192 323.2 220.8 352 256 352zM512 144h32c8.836 0 16 7.162 16 16v128c0 8.836-7.164 16-16 16h-32V144zM352 64c0-8.838 7.164-16 16-16h64C440.8 48 448 55.16 448 64v32h-96V64zM336 144h128v160h-128V144zM240 160c0-8.838 7.164-16 16-16h32v160H256C247.2 304 240 296.8 240 288V160zM616 399.1H144V64c0-35.2-28.8-64-64-64H24C10.8 0 0 10.8 0 24C0 37.2 10.8 48 24 48h48C85.25 48 96 58.74 96 72v343.1c0 17.6 14.4 32 32 32l34.9 .0026C161.1 453 160 458.4 160 464C160 490.5 181.5 512 208 512S256 490.5 256 464c0-5.643-1.114-10.97-2.903-16h197.9C449.2 453 448.1 458.4 448.1 464c0 26.51 21.48 48 47.99 48s48.01-21.49 48.01-48c0-5.643-1.1-10.97-2.889-16L616 447.1c13.2 0 24-10.8 24-23.1C640 410.8 629.2 399.1 616 399.1z"],
    "cart-minus": [576, 512, [], "e0db", "M176 416c-26.51 0-47.1 21.49-47.1 48S149.5 512 176 512s47.1-21.49 47.1-48S202.5 416 176 416zM256 152h128c13.25 0 24-10.75 24-24S397.3 104 384 104H256C242.8 104 232 114.8 232 128S242.8 152 256 152zM463.1 416c-26.51 0-47.1 21.49-47.1 48s21.49 48 47.1 48s47.1-21.49 47.1-48S490.5 416 463.1 416zM569.5 44.73C563.4 36.64 554.1 32 543.1 32H472C458.7 32 448 42.74 448 56c0 13.25 10.75 24 24 24h50.77l-45.72 160H161.6L119.6 19.51C117.4 8.189 107.5 0 96 0H23.1C10.74 0 0 10.74 0 23.1C0 37.25 10.74 48 23.1 48h52.14l60.28 316.5C138.6 375.8 148.5 384 160 384H488c13.25 0 24-10.75 24-23.1C512 346.7 501.3 336 488 336H179.9L170.7 288h318.4c14.29 0 26.85-9.479 30.77-23.21l54.86-191.1C577.5 63.05 575.6 52.83 569.5 44.73z"],
    "cart-plus": [576, 512, [], "f217", "M256 152h40V192c0 13.25 10.75 24 24 24S344 205.3 344 192V152H384c13.25 0 24-10.75 24-24S397.3 104 384 104h-40V64c0-13.25-10.75-24-24-24S296 50.75 296 64v40H256C242.8 104 232 114.8 232 128S242.8 152 256 152zM569.5 44.73C563.4 36.64 554.1 32 543.1 32H472C458.7 32 448 42.74 448 56c0 13.25 10.75 24 24 24h50.77l-45.72 160H161.6L119.6 19.51C117.4 8.189 107.5 0 96 0H23.1C10.74 0 0 10.74 0 23.1C0 37.25 10.74 48 23.1 48h52.14l60.28 316.5C138.6 375.8 148.5 384 160 384H488c13.25 0 24-10.75 24-23.1C512 346.7 501.3 336 488 336H179.9L170.7 288h318.4c14.28 0 26.85-9.479 30.77-23.21l54.86-191.1C577.5 63.05 575.6 52.83 569.5 44.73zM176 416c-26.51 0-47.1 21.49-47.1 48S149.5 512 176 512s47.1-21.49 47.1-48S202.5 416 176 416zM463.1 416c-26.51 0-47.1 21.49-47.1 48s21.49 48 47.1 48s47.1-21.49 47.1-48S490.5 416 463.1 416z"],
    "cart-shopping": [576, 512, [61562, "shopping-cart"], "1f6d2", "M175.1 416c-26.51 0-47.1 21.49-47.1 48S149.5 512 175.1 512s47.1-21.49 47.1-48S202.5 416 175.1 416zM463.1 416c-26.51 0-47.1 21.49-47.1 48s21.49 48 47.1 48s47.1-21.49 47.1-48S490.5 416 463.1 416zM569.5 44.73c-6.109-8.094-15.42-12.73-25.56-12.73H121.1L119.6 19.51C117.4 8.189 107.5 0 96 0H23.1C10.75 0 0 10.74 0 23.1C0 37.25 10.75 48 23.1 48h52.14l60.28 316.5C138.6 375.8 148.5 384 160 384H488c13.25 0 24-10.75 24-23.1C512 346.7 501.3 336 488 336H179.9L170.7 288h318.4c14.28 0 26.84-9.479 30.77-23.21l54.86-191.1C577.5 63.05 575.6 52.83 569.5 44.73zM477 240H161.6l-30.47-160h391.7L477 240z"],
    "cart-shopping-fast": [640, 512, [], "e0dc", "M239.1 416c-26.51 0-47.1 21.49-47.1 48S213.5 512 239.1 512s47.1-21.49 47.1-48S266.5 416 239.1 416zM527.1 416c-26.51 0-47.1 21.49-47.1 48s21.49 48 47.1 48s48-21.49 48-48S554.5 416 527.1 416zM633.5 44.73C627.4 36.64 618.1 32 607.1 32H185.1L183.6 19.51C181.4 8.19 171.5 0 160 0H87.1C74.75 0 64 10.74 64 23.1C64 37.25 74.75 48 87.1 48h52.14l60.28 316.5C202.6 375.8 212.5 384 224 384H552c13.25 0 24-10.75 24-23.1C576 346.7 565.3 336 552 336H243.9L234.7 288h318.4c14.28 0 26.84-9.474 30.76-23.21l54.86-191.1C641.5 63.05 639.6 52.83 633.5 44.73zM541 240H225.6l-30.47-160h391.7L541 240zM24 144h80C117.3 144 128 133.3 128 120C128 106.7 117.3 96 104 96h-80C10.75 96 0 106.7 0 120C0 133.3 10.75 144 24 144zM24 224h96C133.3 224 144 213.3 144 200c0-13.26-10.74-24-24-24h-96C10.75 176 0 186.7 0 200C0 213.3 10.75 224 24 224zM136 256h-112C10.75 256 0 266.7 0 280C0 293.3 10.75 304 24 304h112C149.3 304 160 293.3 160 280C160 266.7 149.3 256 136 256z"],
    "cart-xmark": [576, 512, [], "e0dd", "M257.8 190.2c9.369 9.369 24.57 9.369 33.94 0L320 161.9l28.29 28.28c9.369 9.369 24.57 9.369 33.94 0s9.369-24.57 0-33.94L353.9 128l28.29-28.29c9.369-9.369 9.369-24.57 0-33.94s-24.57-9.369-33.94 0L320 94.06l-28.28-28.29c-9.369-9.369-24.57-9.369-33.94 0s-9.369 24.57 0 33.94L286.1 128L257.8 156.3C248.4 165.7 248.4 180.9 257.8 190.2zM176 416c-26.51 0-47.1 21.49-47.1 48S149.5 512 176 512s47.1-21.49 47.1-48S202.5 416 176 416zM463.1 416c-26.51 0-47.1 21.49-47.1 48s21.49 48 47.1 48s47.1-21.49 47.1-48S490.5 416 463.1 416zM569.5 44.73C563.4 36.64 554.1 32 543.1 32H472C458.7 32 448 42.74 448 56c0 13.25 10.75 24 24 24h50.77l-45.72 160H161.6L119.6 19.51C117.4 8.189 107.5 0 96 0H23.1C10.74 0 0 10.74 0 23.1C0 37.25 10.74 48 23.1 48h52.14l60.28 316.5C138.6 375.8 148.5 384 160 384H488c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24H179.9L170.7 288h318.4c14.29 0 26.85-9.479 30.77-23.21l54.86-191.1C577.5 63.05 575.6 52.83 569.5 44.73z"],
    "cash-register": [512, 512, [], "f788", "M232.1 256c0-8.75-7.188-16-15.94-16h-16C191.4 240 184.1 247.3 184.1 256l.0625 16c0 8.75 7.25 16 16 16h16c8.75 0 16-7.25 16-16L232.1 256zM168.1 304h-16c-8.75 0-16 7.25-16 16l-.0625 16c0 8.75 7.312 16 16.06 16h16c8.75 0 15.94-7.25 15.94-16L184.1 320C184.1 311.3 176.9 304 168.1 304zM264.1 304h-16c-8.75 0-16 7.25-16 16l-.0625 16c0 8.75 7.312 16 16.06 16h16c8.75 0 15.94-7.25 15.94-16l.0625-16C280.1 311.3 272.9 304 264.1 304zM136.1 256c0-8.75-7.188-16-15.94-16h-16C95.38 240 88.06 247.3 88.06 256l.0625 16c0 8.75 7.25 16 16 16h16c8.75 0 16-7.25 16-16L136.1 256zM511.3 378.8L487.9 215c-4.512-31.52-31.5-54.93-63.34-54.93l-224.4 .0566v-32L288.1 128.1c17.6 0 32.01-14.4 32.01-32V32c0-17.6-14.4-32-32-32h-224c-17.6 0-32 14.4-32 32v63.96c0 17.6 14.4 32 32 32L152.1 128v32L87.61 159.1C55.77 159.1 28.74 183.4 24.22 214.9l-23.58 164.6C.2168 382.5 0 385.5 0 388.5V480c0 17.67 14.33 32 31.1 32H479.1c17.67 0 31.1-14.33 31.1-32L512 387.9C512 384.8 511.7 381.8 511.3 378.8zM80.12 80v-32h191.1v32H80.12zM71.74 221.7C72.86 213.8 79.67 207.9 87.59 207.9l336.1 .0918c7.908 0 14.71 5.904 15.84 13.73L463.6 384H48.49L71.74 221.7zM464 464h-416v-32h416V464zM328.1 256c0-8.75-7.188-16-15.94-16h-16c-8.75 0-16.06 7.25-16.06 16l.0625 16c0 8.75 7.25 16 16 16h16c8.75 0 16-7.25 16-16L328.1 256zM408.1 240h-16c-8.75 0-16.06 7.25-16.06 16l.0625 16c0 8.75 7.25 16 16 16h16c8.75 0 16-7.25 16-16L424.1 256C424.1 247.3 416.9 240 408.1 240zM360.1 304h-16c-8.75 0-16 7.25-16 16l-.0625 16c0 8.75 7.312 16 16.06 16h16c8.75 0 15.94-7.25 15.94-16l.0625-16C376.1 311.3 368.9 304 360.1 304z"],
    "cassette-betamax": [576, 512, ["betamax"], "f8a4", "M352 384h112c17.62 0 32-14.38 32-32V240c0-17.62-14.38-32-32-32H352c-17.62 0-32 14.38-32 32V352C320 369.6 334.4 384 352 384zM368 256H448v80h-80V256zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V160h480V416zM184 400c57.44 0 104-46.56 104-104S241.4 192 184 192S80 238.6 80 296S126.6 400 184 400zM184 240c30.88 0 56 25.12 56 56S214.9 352 184 352S128 326.9 128 296S153.1 240 184 240zM184 320C197.3 320 208 309.3 208 296c0-13.26-10.74-24-24-24C170.7 272 160 282.7 160 296C160 309.3 170.7 320 184 320z"],
    "cassette-tape": [576, 512, [63659], "1f5ad", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM157 432L176.3 384h223.5l19.21 48H157zM528 416c0 8.822-7.178 16-16 16h-43.99l2.268-.9062l-32-80C434.6 341.1 425.8 336 416 336H160c-9.812 0-18.62 5.969-22.28 15.09l-32 80L107.1 432H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V416zM400 160h-224c-35.35 0-64 28.65-64 64c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64C464 188.7 435.3 160 400 160zM176 240C167.2 240 160 232.8 160 224s7.178-16 16-16S192 215.2 192 224S184.8 240 176 240zM338.3 240H237.7C239.1 234.9 240 229.6 240 224S239.1 213.1 237.7 208h100.5C336.9 213.1 336 218.4 336 224S336.9 234.9 338.3 240zM400 240C391.2 240 384 232.8 384 224s7.178-16 16-16S416 215.2 416 224S408.8 240 400 240z"],
    "cassette-vhs": [576, 512, [63724, "vhs"], "1f4fc", "M184 384h208C440.6 384 480 344.6 480 296S440.6 208 392 208h-208C135.4 208 96 247.4 96 296S135.4 384 184 384zM400 264c17.62 0 32 14.38 32 32s-14.38 32-32 32V264zM224 256h128v80H224V256zM176 264v64c-17.62 0-32-14.38-32-32S158.4 264 176 264zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V160h480V416z"],
    "castle": [640, 512, [], "e0de", "M616 160c-13.25 0-24 10.74-24 24V224L512 224V24C512 10.74 501.3 0 488 0S464 10.74 464 24V64l-64 .0097V24C400 10.74 389.3 0 376 0S352 10.74 352 24V64H288V24C288 10.74 277.3 0 264 0S240 10.74 240 24v40.01L176 64V24C176 10.74 165.3 0 152 0S128 10.74 128 24v200L48 224V184C48 170.7 37.25 160 24 160S0 170.7 0 184V448c0 35.35 28.65 64 64 64l223.9 .0234c.082 0-.082 0 0 0h64.23c.082 0-.082 0 0 0L576 512c35.35 0 64-28.65 64-64V184C640 170.7 629.3 160 616 160zM176 112h288V224h-288V112zM592 448c0 8.836-7.164 16-16 16h-192v-79.99c0-35.35-28.65-64-64-64s-64 28.65-64 64V464H64c-8.836 0-16-7.164-16-16V272h544V448z"],
    "cat": [576, 512, [63166], "1f408", "M416 128c-8.875 0-16 7.125-16 16s7.125 16 16 16s16-7.125 16-16S424.9 128 416 128zM547.5 4.125C541.4 1.375 534.8 0 528 0c-11.62 0-23.12 4.25-32.13 12.38L456.2 48h-16.5l-39.63-35.62c-14.13-12.75-34.37-15.88-51.63-8.25C331.1 11.88 320 29 320 48V160c0 4.25 .875 8.25 1.25 12.38l-47 7.125C206.8 189.8 149.6 225.9 112 277V184C112 135.5 72.5 96 24 96C10.75 96 0 106.8 0 120c0 13.35 10.87 24.13 24.16 24.01C46.69 143.8 64 164.4 64 186.9L64 399.2C64 472.8 103.4 512 152 512h184c8.875 0 16-7.125 16-15.1C352 478.4 337.6 464 320 464h-16.12c-.125-7.375-.75-14.62-1.876-21.75L384 394V464c0 26.4 21.6 48 48 48h32c26.4 0 48-21.6 48-48V270.2C550.1 248 576 207.1 576 160V48C576 29 564.9 11.88 547.5 4.125zM464 464h-32v-98c0-11.5-6.125-22.12-16.12-27.75c-9.876-5.75-22.12-5.625-32.12 .125L287.5 395.1c-12.12-25-30.25-46.88-53.5-63.13c-7.499-5.25-18.12-2.25-22.5 5.75L204 351.1c-4 7.25-2.5 16.5 4.125 21.38C237.3 393.6 255 427.5 255.8 464H152c-22 0-40-17.1-40-39.1c0-99.25 71.25-182.1 169.5-197l53.5-8.125C356.4 259.8 398.8 288 448 288c5.5 0 10.75-1 16-1.625V464zM528 160c0 44.12-35.88 80-80 80s-80-35.87-80-79.99V48L421.4 96h53.25L528 48V160zM464 144C464 152.9 471.1 160 480 160s16-7.125 16-15.1S488.9 128 480 128S464 135.1 464 144z"],
    "cat-space": [640, 512, [], "e001", "M202.6 85.36l16.6 39.65c.875 1.875 2.763 2.986 4.763 2.986s3.875-1.111 4.75-2.986L245.3 85.36l39.65-16.6c1.875-.875 2.992-2.756 2.992-4.756s-1.117-3.882-2.992-4.757L245.3 42.64L228.7 2.986C227.9 1.111 225.1 .0001 223.1 .0001S220.1 1.111 219.2 2.986L202.6 42.64L162.1 59.24c-1.875 .875-2.98 2.757-2.98 4.757S161.1 67.88 162.1 68.76L202.6 85.36zM463.1 0c-97.25 0-176 78.75-176 176c0 1.375 .125 2.625 .25 3.875C221.6 190.6 165.2 226.4 127.1 277V184c0-48.63-39.38-88-88-88C31.35 96 23.35 100.6 19.1 108.3C14.85 115.8 14.97 125 19.47 132.4C23.85 139.8 31.97 144.3 40.6 144c22.38-.625 39.38 20.5 39.38 42.88v212.4c0 73.5 39.38 112.8 88 112.8h184c4.25 0 8.375-1.625 11.38-4.625S367.1 500.3 367.1 496c0-17.62-14.38-32-32-32H319.8c-.125-7.25-.75-14.62-1.875-21.88l82-48.13V464c0 26.4 21.6 48 48 48h32c26.4 0 48-21.6 48-48v-124.1c65.5-25.62 112-89.25 112-163.9C639.1 78.75 561.2 0 463.1 0zM463.1 48c26.12 0 51.63 8.125 73 23L495.1 112h-64l-41-41C412.3 56.13 437.8 48 463.1 48zM519.1 176C519.1 184.9 512.8 192 503.1 192s-15.99-7.125-15.99-16s7.13-15.1 16-15.1c4.25 0 8.355 1.625 11.36 4.625S519.1 171.8 519.1 176zM439.1 176C439.1 184.9 432.8 192 423.1 192s-15.99-7.125-15.99-16s7.13-15.1 16-15.1c4.25 0 8.355 1.625 11.36 4.625S439.1 171.8 439.1 176zM303.3 395.1c-12-25.38-30.5-47-53.38-63.13c-7.5-5.25-18.12-2.25-22.5 5.75l-7.5 13.38c-4 7.125-2.5 16.5 4.125 21.38C253.3 393.9 270.1 427.8 271.7 464H167.1c-22.12 0-40-17.88-40-40c0-98.63 70.38-181 167.6-196.6c15.62 50.88 53.38 92 102.8 111.9L303.3 395.1zM479.1 464h-32l-.0146-98c0-5.375-1.375-10.5-4-15.25c12 1.5 24 1.625 36 .5L479.1 464zM463.1 304c-70.63-.125-127.9-57.38-128-128c0-32.13 12.38-61.25 32-83.75V176c0 53 43 96 96 96s96.01-42.1 96.01-95.1l-.0146-83.75c19.62 22.5 32 51.63 32 83.75C591.8 246.6 534.6 303.9 463.1 304z"],
    "cauldron": [448, 512, [], "f6bf", "M160 64c17.62 0 32-14.38 32-32S177.6 0 160 0S128 14.38 128 32S142.4 64 160 64zM424 208C437.3 208 448 197.3 448 184C448 170.7 437.3 160 424 160H24C10.75 160 0 170.7 0 184C0 197.3 10.75 208 24 208h20.96C16.94 252.1 0 300.7 0 340c0 32.24 11.82 62.32 32 88.13V488C32 501.3 42.75 512 56 512s24-10.75 24-24v-16.44C118.1 496.8 169.2 512 224 512s105-15.25 144-40.44V488c0 13.25 10.75 24 24 24S416 501.3 416 488v-59.87c20.18-25.81 32-55.9 32-88.13c0-39.31-16.94-87.92-44.96-132H424zM224 464c-97.03 0-176-55.63-176-124c0-35.65 21.46-88.83 55.39-132h241.2C378.5 251.2 400 304.3 400 340C400 408.4 321 464 224 464zM272 128C298.5 128 320 106.5 320 80S298.5 32 272 32S224 53.5 224 80S245.5 128 272 128z"],
    "cedi-sign": [320, 512, [], "e0df", "M278.1 352.2c-21.55 21.66-49.22 34.5-79 38.18V121.6c29.78 3.68 57.45 16.52 79 38.18c9.393 9.406 24.57 9.406 33.96 .0625c9.393-9.344 9.424-24.53 .0781-33.94c-30.64-30.76-70.4-48.43-113-52.3V24c0-13.25-10.75-24-24.01-24S151.1 10.75 151.1 24v51.07c-37.04 6.385-71.24 23.64-98.35 50.86C-17.87 197.7-17.87 314.3 53.59 386.1c27.12 27.23 61.33 44.48 98.37 50.86V488c0 13.25 10.75 24 24.01 24s24.01-10.75 24.01-24v-49.63c42.65-3.875 82.4-21.54 113-52.3c9.346-9.406 9.315-24.59-.0781-33.94C303.5 342.8 288.4 342.8 278.1 352.2zM87.61 352.2C34.77 299.2 34.77 212.8 87.63 159.8c17.96-18.06 40.21-30.02 64.33-35.76v263.9C127.8 382.2 105.6 370.2 87.61 352.2z"],
    "cent-sign": [320, 512, [], "a2", "M313.4 346.9c9.125 9.594 8.781 24.78-.8125 33.92c-31.46 30.01-71.7 45.99-112.9 49.49c.041 .5781 .3359 1.072 .3359 1.662v56c0 13.25-10.75 24-24.01 24c-13.25 0-23.1-10.75-23.1-24V432c0-1.055 .4687-1.955 .6016-2.975c-36.09-5.83-70.72-21.66-98.51-48.17C19.22 347.6 0 303.2 0 256s19.22-91.56 54.09-124.8C81.89 104.6 116.5 88.81 152.6 82.97C152.5 81.96 152 81.05 152 80V24c0-13.25 10.75-24 23.1-24c13.25 0 24.01 10.75 24.01 24V80c0 .5879-.293 1.08-.334 1.656c41.2 3.506 81.44 19.47 112.9 49.5c9.594 9.141 9.938 24.33 .8125 33.92c-9.189 9.625-24.38 9.906-33.94 .7969c-53-50.53-139.2-50.55-192.2 .0156C61.94 190 48 222 48 256s13.94 65.98 39.22 90.13c53 50.53 139.2 50.53 192.2 0C289 336.1 304.2 337.3 313.4 346.9z"],
    "certificate": [512, 512, [], "f0a3", "M473.1 255.9l23.81-23.28c12.13-11.41 17-28.55 12.69-44.75c-4.313-16.25-17.06-28.73-32.85-32.48l-32.91-8.391l9.344-32.58c4.406-15.83-.125-32.95-11.88-44.69c-11.75-11.75-28.94-16.27-44.81-11.81l-32.41 9.266l-8.25-32.63C352.8 18.51 340.3 5.889 324.1 1.576c-16.28-4.344-33.38 .4688-44.5 12.25l-23.56 24.28L232.7 14.06C221.3 2.076 204.3-2.69 187.1 1.545C171.7 5.842 159.2 18.45 155.3 34.31L147.1 67.15L114.5 57.86C98.78 53.45 81.56 57.98 69.84 69.7c-11.75 11.73-16.28 28.86-11.81 44.83l9.282 32.44L34.77 155.3C18.65 159.1 5.959 171.5 1.615 187.7c-4.344 16.2 .4688 33.38 12.28 44.53l24.16 23.63L14.18 279.2c-12.13 11.48-16.97 28.69-12.59 44.91c4.344 16.19 17.09 28.61 32.81 32.36l32.91 8.375L57.96 397.5c-4.406 15.75 .0938 32.81 11.75 44.53c11.66 11.75 28.85 16.38 44.94 11.94l32.41-9.25l8.25 32.66c3.938 16.16 16.38 28.84 32.47 33.09C191.7 511.5 195.7 512 199.7 512c12.34 0 24.25-4.938 32.72-13.91l23.63-24.16l23.16 23.69c11.31 12.22 28.53 17.03 44.72 12.84c16.34-4.281 28.91-16.97 32.78-32.94l8.282-32.84l32.66 9.344c15.81 4.281 33-.25 44.69-12.03c11.66-11.72 16.16-28.78 11.69-44.66l-9.282-32.47l32.5-8.281c16.09-3.812 28.78-16.2 33.16-32.34S510 290.1 498 279.4L473.1 255.9zM384.9 330.6l21.81 76.13l-76.19-21.78l-19.41 76.75l-55.16-56.38l-55.16 56.38L181.4 384.9l-76.19 21.78l21.81-76.13L50.34 311l56.35-55.14L50.4 200.8l76.66-19.56L105.2 105.1L181.4 126.9l19.41-76.73l55.16 56.84l55.16-56.84l19.41 76.73l76.19-21.81l-21.81 76.13l76.66 19.56l-56.28 55.06l56.35 55.14L384.9 330.6z"],
    "chair": [448, 512, [63168], "1fa91", "M445.1 326.2l-10.63-32c-7.375-22-27.5-36.75-50.5-37.87L383.1 128c0-70.69-57.31-128-128-128H191.1C121.3 0 63.98 57.31 63.98 128L63.95 256.4c-23 1.125-43.13 15.87-50.5 37.87l-10.63 32c-5.625 17.13-2.75 36 7.75 50.5c5.5 7.75 13 13.62 21.38 17.62v93.63C31.95 501.3 42.72 512 55.97 512s23.98-10.75 23.98-23.1V400h288v88C367.1 501.3 378.7 512 391.1 512s23.98-10.75 23.98-23.1v-93.63c8.375-4 15.88-9.875 21.5-17.62C447.1 362.2 450.8 343.4 445.1 326.2zM295.1 59.13C319.7 73 335.1 98.5 335.1 128l-.0094 128h-40L295.1 59.13zM199.1 48h48L247.1 256H199.1L199.1 48zM151.1 59.13L151.1 256H111.1l.009-128C111.1 98.5 128.2 73 151.1 59.13zM48.32 341.5l10.75-32C60.07 306.1 63.2 304 66.57 304h314.8c3.375 0 6.5 2.25 7.625 5.5l10.62 32C401.3 346.8 397.3 352 391.9 352h-336C50.57 352 46.57 346.8 48.32 341.5z"],
    "chair-office": [448, 512, [], "f6c1", "M402.5 294.3c-7.375-22-27.5-36.75-50.5-37.88L351.1 64c0-35.38-28.62-64-64-64h-128C124.6 0 95.98 28.62 95.98 64L95.95 256.4c-23 1.125-43.13 15.88-50.38 37.88l-10.75 32c-5.625 17.12-2.75 36 7.75 50.5S69.95 400 87.95 400h112v64H152C138.7 464 128 474.7 128 488C128 501.3 138.7 512 152 512h144c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24h-48.04v-64h112c17.1 0 35-8.75 45.5-23.25c10.5-14.62 13.38-33.38 7.625-50.5L402.5 294.3zM143.1 64c0-8.875 7.125-16 16-16h128c8.875 0 16 7.125 16 16v192H143.1V64zM359.1 352H87.95c-5.375 0-9.375-5.25-7.625-10.5l10.75-32C92.08 306.1 95.2 304 98.58 304h250.8c3.375 0 6.5 2.25 7.625 5.5l10.63 32C369.3 346.8 365.3 352 359.1 352zM64 232v-80C64 138.8 53.25 128 40 128S16 138.8 16 152v80C16 245.3 26.75 256 40 256S64 245.3 64 232zM408 128C394.8 128 384 138.8 384 152v80C384 245.3 394.8 256 408 256s24-10.75 24-24v-80C432 138.8 421.3 128 408 128z"],
    "chalkboard": [576, 512, ["blackboard"], "f51b", "M552 432H416V384c0-17.67-14.33-32-32-32H256c-17.67 0-32 14.33-32 32v48H24C10.75 432 0 442.7 0 456C0 469.3 10.75 480 24 480h528c13.25 0 24-10.75 24-24C576 442.7 565.3 432 552 432zM368 432h-96v-32h96V432zM80 88c0-4.406 3.594-8 8-8h400c4.406 0 8 3.594 8 8v312H544V88C544 57.13 518.9 32 488 32H88C57.13 32 32 57.13 32 88v312h48V88z"],
    "chalkboard-user": [640, 512, ["chalkboard-teacher"], "f51c", "M192 352H128c-70.69 0-128 57.3-128 128c0 17.67 14.33 32 32 32h256c17.67 0 32-14.33 32-32C320 409.3 262.7 352 192 352zM49.61 464C57.04 427.5 89.37 400 128 400h64c38.63 0 70.96 27.53 78.39 64H49.61zM160 320c53.02 0 96-42.98 96-96c0-53.02-42.98-96-96-96C106.1 128 64 170.1 64 224C64 277 106.1 320 160 320zM160 176c26.47 0 48 21.53 48 48S186.5 272 160 272S112 250.5 112 224S133.5 176 160 176zM584 0H216C185.1 0 160 25.12 160 56V80c0 13.25 10.75 24 24 24S208 93.25 208 80V56c0-4.406 3.594-8 8-8h368c4.406 0 8 3.594 8 8v304c0 4.406-3.594 8-8 8H528v-32c0-17.67-14.33-32-32-32H416c-17.67 0-32 14.33-32 32v32h-32c-13.25 0-24 10.75-24 24S338.8 416 352 416h232c30.88 0 56-25.12 56-56v-304C640 25.12 614.9 0 584 0z"],
    "champagne-glass": [256, 512, ["glass-champagne"], "f79e", "M216 464h-64.01v-114.5c64.98-12 111.6-71.08 102.1-137.2l-26.99-184.9C225.7 11.75 212.2 0 196.2 0H59.77c-15.1 0-29.49 11.75-31.74 27.38L1.033 212.3c-8.746 66.25 38.01 125.3 102.1 137.1V464H40c-13.25 0-23.99 10.74-23.99 24c0 13.25 10.74 24 23.99 24h176c13.25 0 23.99-10.75 23.99-24C240 474.7 229.3 464 216 464zM182.5 48l11.71 80h-132.4l11.71-80H182.5zM48.55 219.2L54.85 176h146.3l6.213 42.58C211.5 250.2 186.2 304 128 304C70.25 304 44.37 250.7 48.55 219.2z"],
    "champagne-glasses": [640, 512, [63391, "glass-cheers"], "1f942", "M638.2 422.9c-3.803-9.258-12.68-14.88-22.13-14.88c-3.055 0-6.17 .5879-9.193 1.828l-44.59 18.36l-42.35-105.5c51.71-33.5 71.1-100.1 40.81-154.2L475.4 16.5C469.6 6.123 458.6 0 447 0c-3.928 0-7.984 .75-11.79 2.25L320 46.84L204.7 2.25C200.9 .75 196.9 0 192.1 0c-11.53 0-22.56 6.123-28.39 16.5L79.28 168.5c-30.29 54.12-10.9 120.7 40.81 154.2l-42.35 105.5l-44.59-18.36c-3.021-1.24-6.139-1.828-9.193-1.828c-9.453 0-18.33 5.617-22.13 14.88c-5.047 12.27 .7969 26.28 13.05 31.33l136 56C153.9 511.4 156.1 512 159.1 512c9.438 0 18.39-5.594 22.2-14.86c5.047-12.27-.7969-26.28-13.05-31.33l-46.59-19.19l42.52-105.7c8.111 1.625 16.22 2.5 24.08 2.5c53.36 0 102.3-34.25 115.8-87.37l14.96-59.62l15.08 59.62c13.56 53.12 62.48 87.37 115.8 87.37c7.857 0 15.97-.875 24.08-2.5l42.52 105.7l-46.59 19.19c-12.25 5.047-18.09 19.06-13.05 31.33C461.6 506.4 470.6 512 480 512c3.031 0 6.125-.5781 9.123-1.812l136-56C637.4 449.1 643.2 435.1 638.2 422.9zM121.1 191.1l26.21-46.71l122.8 52.61L258.5 244.2C232.7 345 70.54 282.4 121.1 191.1zM281.9 150.7l-110.1-47.55l28.82-51.36l97.49 37.72L281.9 150.7zM342.7 89.53l97.5-37.72l28.82 51.36L358 150.7L342.7 89.53zM381.6 244.4l-11.68-46.54l122.8-52.61l26.19 46.66C569.5 282.5 407.2 344.8 381.6 244.4z"],
    "charging-station": [576, 512, [], "f5e7", "M560 128H544V80C544 71.13 536.9 64 528 64S512 71.13 512 80V128h-32V80C480 71.13 472.9 64 464 64S448 71.13 448 80V128h-16C423.2 128 416 135.2 416 144V192c0 35.75 23.62 65.75 56 75.88v102.6c0 13.94-9.513 26.97-23.28 29.17C431.1 402.4 416 389 416 372V344C416 295.6 376.4 256 328 256H320V64c0-35.35-28.65-64-64-64H96C60.65 0 32 28.65 32 64v400H24C10.8 464 0 474.8 0 488C0 501.2 10.8 512 24 512h304c13.2 0 24-10.8 24-24c0-13.2-10.8-24-24-24H320v-160h8c21.1 0 40 18 40 40v23.97c0 39.1 29.09 76.07 68.92 79.71C481.1 451.8 520 416.2 520 372V267.9C552.4 257.8 576 227.8 576 192V144C576 135.2 568.8 128 560 128zM272 464h-192V64c0-8.838 7.164-16 16-16h160c8.836 0 16 7.162 16 16V464zM528 192c0 17.62-14.38 32-32 32s-32-14.38-32-32V176h64V192zM213.7 176H170.1l15.33-48.81c3.984-12.64-3.047-26.11-15.69-30.08C157.8 93.06 144.5 100.1 140.5 112.8l-25.14 80c-2.297 7.281-.9844 15.23 3.547 21.39C123.5 220.4 130.6 224 138.3 224h35.77l-31.89 60.86C136 296.6 140.5 311.1 152.3 317.3C155.8 319.1 159.6 320 163.4 320c8.641 0 16.98-4.672 21.28-12.86l50.3-96c3.891-7.438 3.609-16.38-.7344-23.56S222.1 176 213.7 176z"],
    "chart-area": [512, 512, ["area-chart"], "f1fe", "M120 384h336c13.25 0 24-10.75 24-24V240c0-5.531-1.906-10.91-5.438-15.19l-72-88c-4.281-5.25-10.59-8.438-17.38-8.781c-6.656-.5-13.38 2.219-18.16 7l-46.28 46.28L249.7 103.8C245.2 98.84 238.8 96.03 232.1 96C225.4 96 219 98.75 214.5 103.6l-112 120C98.31 228.1 96 233.9 96 240v120C96 373.3 106.8 384 120 384zM144 249.5l87.84-94.13l70.47 76.88C306.7 237 312.9 239.8 319.5 240c7.156 .0625 12.84-2.375 17.5-7.031l45.25-45.25L432 248.6V336h-288V249.5zM488 432H48V56C48 42.74 37.25 32 24 32S0 42.74 0 56V448c0 17.6 14.4 32 32 32h456c13.25 0 24-10.75 24-24C512 442.7 501.3 432 488 432z"],
    "chart-bar": [512, 512, ["bar-chart"], "f080", "M152 256h144C309.3 256 320 245.3 320 232S309.3 208 296 208h-144C138.8 208 128 218.8 128 232S138.8 256 152 256zM152 160h208C373.3 160 384 149.3 384 136S373.3 112 360 112h-208C138.8 112 128 122.8 128 136S138.8 160 152 160zM152 352h272c13.25 0 24-10.75 24-24S437.3 304 424 304h-272C138.8 304 128 314.8 128 328S138.8 352 152 352zM488 432H48V56C48 42.75 37.25 32 24 32S0 42.75 0 56V448c0 17.59 14.41 32 32 32h456c13.25 0 24-10.75 24-24S501.3 432 488 432z"],
    "chart-bullet": [512, 512, [], "e0e1", "M48 224H160V64H48C21.6 64 0 85.6 0 112v64C0 202.4 21.6 224 48 224zM48 112h64v64h-64V112zM464 288H384c0-8.838-7.164-16-16-16S352 279.2 352 288h-96v48h96v64h-96V448h96c0 8.836 7.164 16 16 16S384 456.8 384 448h80c26.4 0 48-21.6 48-48v-64C512 309.6 490.4 288 464 288zM464 400H384v-64h80V400zM0 336v64C0 426.4 21.6 448 48 448H224V288H48C21.6 288 0 309.6 0 336zM176 400h-128v-64h128V400zM464 64H288c0-8.838-7.164-16-16-16S256 55.16 256 64H192v48h64v64H192V224h64c0 8.836 7.164 16 16 16S288 232.8 288 224h176C490.4 224 512 202.4 512 176v-64C512 85.6 490.4 64 464 64zM464 176H288v-64h176V176z"],
    "chart-candlestick": [512, 512, [], "e0e2", "M400 320H416v48c0 8.836 7.164 16 16 16c8.838 0 16-7.164 16-16V320h16c8.838 0 16-7.164 16-16v-96C480 199.2 472.8 192 464 192H448V144C448 135.2 440.8 128 432 128C423.2 128 416 135.2 416 144V192h-16C391.2 192 384 199.2 384 208v96C384 312.8 391.2 320 400 320zM272 256H288v48c0 8.836 7.164 16 16 16c8.838 0 16-7.164 16-16V256h16C344.8 256 352 248.8 352 240v-128C352 103.2 344.8 96 336 96H320V48C320 39.16 312.8 32 304 32C295.2 32 288 39.16 288 48V96h-16C263.2 96 256 103.2 256 112v128C256 248.8 263.2 256 272 256zM144 320H160v48C160 376.8 167.2 384 176 384C184.8 384 192 376.8 192 368V320h16C216.8 320 224 312.8 224 304v-160C224 135.2 216.8 128 208 128H192V80C192 71.16 184.8 64 176 64C167.2 64 160 71.16 160 80V128H144C135.2 128 128 135.2 128 144v160C128 312.8 135.2 320 144 320zM488 432H48V56C48 42.75 37.25 32 24 32S0 42.75 0 56V448c0 17.59 14.41 32 32 32h456c13.25 0 24-10.75 24-24S501.3 432 488 432z"],
    "chart-column": [512, 512, [], "e0e3", "M488 432H48V56C48 42.74 37.25 32 24 32S0 42.74 0 56V448c0 17.6 14.4 32 32 32h456c13.25 0 24-10.75 24-24C512 442.7 501.3 432 488 432zM168 352C181.3 352 192 341.3 192 328v-48C192 266.8 181.3 256 168 256S144 266.8 144 280v48C144 341.3 154.8 352 168 352zM264 352c13.25 0 24-10.75 24-24v-176C288 138.8 277.3 128 264 128S240 138.8 240 152v176C240 341.3 250.8 352 264 352zM360 352c13.25 0 24-10.75 24-24v-112C384 202.8 373.3 192 360 192S336 202.8 336 216v112C336 341.3 346.8 352 360 352zM456 352c13.25 0 24-10.75 24-24v-208C480 106.8 469.3 96 456 96S432 106.8 432 120v208C432 341.3 442.8 352 456 352z"],
    "chart-gantt": [512, 512, [], "e0e4", "M216 256h144C373.3 256 384 245.3 384 232S373.3 208 360 208h-144C202.8 208 192 218.8 192 232S202.8 256 216 256zM152 160h112C277.3 160 288 149.3 288 136S277.3 112 264 112h-112C138.8 112 128 122.8 128 136S138.8 160 152 160zM376 352h80c13.25 0 24-10.75 24-24S469.3 304 456 304h-80C362.8 304 352 314.8 352 328S362.8 352 376 352zM488 432H48V56C48 42.75 37.25 32 24 32S0 42.75 0 56V448c0 17.59 14.41 32 32 32h456c13.25 0 24-10.75 24-24S501.3 432 488 432z"],
    "chart-line": [512, 512, ["line-chart"], "f201", "M144.1 304.1L208 241.9l79.05 79.03C291.7 325.6 297.9 328 304 328s12.28-2.344 16.95-7.047l152-151.1c9.375-9.375 9.371-24.58-.0078-33.95c-9.371-9.365-24.56-9.361-33.93 .0078L304 270L224.9 191C215.6 181.7 200.4 181.7 191 191l-80 80c-9.375 9.375-9.375 24.56 0 33.95C120.4 314.4 135.6 314.3 144.1 304.1zM488 432H48V56C48 42.75 37.25 32 24 32S0 42.75 0 56V448c0 17.59 14.41 32 32 32h456c13.25 0 24-10.75 24-24S501.3 432 488 432z"],
    "chart-line-down": [512, 512, [63053], "1f4c9", "M488 432H48V56C48 42.74 37.25 32 24 32S0 42.74 0 56V448c0 17.6 14.4 32 32 32h456c13.25 0 24-10.75 24-24C512 442.7 501.3 432 488 432zM191 256.1c9.375 9.375 24.56 9.375 33.94 0L304 177.9L398.1 272H344C330.8 272 320 282.8 320 296S330.8 320 344 320h112C469.3 320 480 309.3 480 296v-112C480 170.8 469.3 160 456 160S432 170.8 432 184v54.06l-111-111c-9.375-9.375-24.56-9.375-33.94 0L208 206.1L144.1 143c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L191 256.1z"],
    "chart-line-up": [512, 512, [], "e0e5", "M488 432H48V56C48 42.74 37.25 32 24 32S0 42.74 0 56V448c0 17.6 14.4 32 32 32h456c13.25 0 24-10.75 24-24C512 442.7 501.3 432 488 432zM144.1 304.1L208 241.9l79.03 79.03C291.7 325.7 297.8 328 304 328s12.28-2.344 16.97-7.031L432 209.9V264C432 277.3 442.8 288 456 288S480 277.3 480 264v-112C480 138.8 469.3 128 456 128h-112C330.8 128 320 138.8 320 152s10.75 24 24 24h54.06L304 270.1L224.1 191c-9.375-9.375-24.56-9.375-33.94 0l-80 80c-9.375 9.375-9.375 24.56 0 33.94S135.6 314.3 144.1 304.1z"],
    "chart-mixed": [576, 512, ["analytics"], "f643", "M208 192C194.8 192 184 202.8 184 216v266c0 13.25 10.75 24 24 24s24-10.75 24-24V216C232 202.8 221.3 192 208 192zM48 352c-13.25 0-24 10.75-24 24v112C24 501.3 34.75 512 48 512s24-10.75 24-24v-112C72 362.8 61.25 352 48 352zM528 0C501.5 0 480 21.5 480 48c0 2.375 .375 4.75 .75 7.125l-95.38 76.25C380 129.3 374.1 128 368 128s-12 1.25-17.38 3.375L255.3 55.12C255.6 52.75 256 50.38 256 48C256 21.5 234.5 0 208 0S160 21.5 160 48c0 4.25 .75 8.375 1.75 12.25l-101.5 101.5C56.37 160.8 52.25 160 48 160C21.5 160 0 181.5 0 208S21.5 256 48 256S96 234.5 96 208c0-4.25-.75-8.375-1.75-12.25l101.5-101.5C199.6 95.25 203.8 96 208 96c6.125 0 12-1.25 17.38-3.375l95.38 76.25C320.4 171.3 320 173.6 320 176C320 202.5 341.5 224 368 224S416 202.5 416 176c0-2.375-.375-4.75-.75-7.125l95.38-76.25C516 94.75 521.9 96 528 96C554.5 96 576 74.5 576 48S554.5 0 528 0zM368 320c-13.25 0-24 10.75-24 24v139.3c0 13.25 10.75 24 24 24s24-10.75 24-24V344C392 330.8 381.3 320 368 320zM528 192c-13.25 0-24 10.75-24 24v271.9c0 13.25 10.75 24 24 24s24-10.75 24-24V216C552 202.8 541.3 192 528 192z"],
    "chart-network": [640, 512, [], "f78a", "M576 192c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C512 163.3 540.7 192 576 192zM576 384c-14.43 0-27.61 4.953-38.31 13.01l-81.9-49.14C460.8 334.1 464 319.5 464 304c0-19.68-4.805-38.11-12.74-54.77l42.93-31.48c10.69-7.812 13-22.84 5.156-33.53c-7.812-10.66-22.81-13.09-33.53-5.156l-42.9 31.46C400.1 189.3 369.7 176 336 176c-10.84 0-21.19 1.752-31.24 4.289l-34-72.86C281.4 96.01 288 80.82 288 64c0-35.35-28.65-64-64-64S160 28.65 160 64c0 35.35 28.65 64 64 64c1.105 0 2.133-.2715 3.225-.3262l33.99 72.84C229.1 223.8 208 261.3 208 304c0 70.69 57.31 128 128 128c37.91 0 71.6-16.79 95.04-42.98l81.95 49.17C512.5 441.4 512 444.6 512 448c0 35.35 28.65 64 64 64S640 483.3 640 448C640 412.7 611.3 384 576 384zM336 384C291.9 384 256 348.1 256 304S291.9 224 336 224C380.1 224 416 259.9 416 304S380.1 384 336 384zM152 280H123.3C113.8 256.6 90.84 240 64 240c-35.35 0-64 28.65-64 64c0 35.35 28.65 64 64 64c26.84 0 49.75-16.56 59.25-40H152c13.25 0 24-10.75 24-24S165.3 280 152 280z"],
    "chart-pie": [576, 512, ["pie-chart"], "f200", "M543.1 223.2c-8.25-119.5-103.7-214.1-223.2-223.2C320.5 .0235 320.1 0 319.8 0c-8.625 0-15.76 7.51-15.76 16.26L304 240l223.7-.0012C536.9 240 544.6 232.4 543.1 223.2zM352 192V53.5C419.5 71 473 124.5 490.5 192H352zM256 288V50.75c0-8.875-7.119-16.25-15.74-16.25c-.75 0-1.374 .019-2.124 .144c-119.1 16.88-210.2 120.1-205.1 245.7C36.52 407.5 145.1 512 272.1 512c1 0 1.876-.0074 2.876-.0074c50.38-.625 96.1-16.88 135.2-44c8-5.625 8.487-17.24 1.612-24.11L256 288zM274.5 464H272.1c-100.6 0-188.6-84.88-191.1-185.2C77.27 193.4 130.3 118.4 208 91.12v216.8l140.2 140.3C325.1 458.2 300.1 463.6 274.5 464zM559.7 288l-237.2-.0006l157.1 158c3.25 3.25 7.529 4.862 11.65 4.862c3.875 0 7.582-1.378 10.58-4.128c38.63-36.5 65.24-85.61 73.12-140.9C577.2 296.4 569.4 288 559.7 288z"],
    "chart-pie-simple": [512, 512, ["chart-pie-alt"], "f64e", "M461.2 288H223.1V50.77c0-8.875-7.184-16.26-15.81-16.26c-.75 0-1.315 .0134-2.065 .1384c-119 16.88-210.1 120.7-205.1 245.5c4.125 124 107.7 227.6 231.7 231.7C234.6 511.1 237.4 512 239.1 512c121 0 220.9-89.62 237.4-206.1C478.6 296.4 470.8 288 461.2 288zM239.1 464c-2.125 0-4.375 0-6.5-.125C134.5 460.6 51.34 377.5 48.09 278.5C45.21 193.2 98.34 118.4 175.1 91.12V336h244.8C394.1 411 321.1 464 239.1 464zM288.8 .027C288.5 .027 288.1 0 287.8 0c-8.625 0-15.77 7.524-15.77 16.27l-.0026 223.7l223.7 .0004c9.125 0 16.87-7.776 16.25-16.78C503.7 103.7 408.3 8.277 288.8 .027z"],
    "chart-pyramid": [512, 512, [], "e0e6", "M506.3 417l-213.3-364C284.8 39 270.4 32 255.1 32S227.2 39 218.1 53l-213.2 364C-10.59 444.9 9.852 480 42.74 480H469.3C502.1 480 522.6 445 506.3 417zM255.1 84.8L314.1 184H197.8L255.1 84.8zM169.7 232h172.5l46.88 80H122.9L169.7 232zM52.58 432L96 357.9V360h320v-2.105L459.4 432H52.58z"],
    "chart-radar": [512, 512, [], "e0e7", "M505.8 233.4l-105.4-179.2C392.3 40.52 377.5 32 361.4 32H150.6C134.5 32 119.7 40.52 111.6 54.17l-105.4 179.2c-8.234 14-8.234 31.27 0 45.27l105.4 179.2C119.7 471.5 134.5 480 150.6 480h210.8c16.12 0 30.94-8.518 39.05-22.17l105.4-179.2C514.1 264.6 514.1 247.4 505.8 233.4zM359.9 432H152.1L48.55 255.1L152.1 80h207.9l103.5 175.1L359.9 432zM330.7 282.2l-40.87-102.2C293.4 174 296 167.4 296 160c0-22.03-17.97-40-40-40S216 137.1 216 160c0 3.721 1.172 7.08 2.131 10.5L160 248c-.002 0 .002 0 0 0C137.1 248 120 265.1 120 288S137.1 328 160 328c10.09 0 19.08-4.094 26.13-10.3l98.24 19.65C290.9 350.6 304.3 360 320 360c22.03 0 40-17.97 40-40C360 301.8 347.4 286.1 330.7 282.2zM202.1 271.9l47.5-63.38l31.69 79.22L202.1 271.9z"],
    "chart-scatter": [512, 512, [], "f7ee", "M288 288c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32s-32 14.33-32 32C256 273.7 270.3 288 288 288zM384 352c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32s-32 14.33-32 32C352 337.7 366.3 352 384 352zM416 160c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32s-32 14.33-32 32C384 145.7 398.3 160 416 160zM488 432H48V56C48 42.74 37.25 32 24 32S0 42.74 0 56V448c0 17.6 14.4 32 32 32h456c13.25 0 24-10.75 24-24C512 442.7 501.3 432 488 432zM192 192c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32S160 142.3 160 160C160 177.7 174.3 192 192 192zM160 352c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32s-32 14.33-32 32C128 337.7 142.3 352 160 352z"],
    "chart-scatter-3d": [512, 512, [], "e0e8", "M128 192c17.62 0 32-14.38 32-32S145.6 128 128 128S96 142.4 96 160S110.4 192 128 192zM384 96c17.62 0 32-14.38 32-32s-14.38-32-32-32s-32 14.38-32 32S366.4 96 384 96zM32 96c17.62 0 32-14.38 32-32S49.63 32 32 32S0 46.38 0 64S14.38 96 32 96zM384 288c17.62 0 32-14.38 32-32s-14.38-32-32-32s-32 14.38-32 32S366.4 288 384 288zM64 256c0-17.62-14.38-32-32-32S0 238.4 0 256s14.38 32 32 32S64 273.6 64 256zM480 128c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S497.6 128 480 128zM256 416c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S273.6 416 256 416zM280 276.8V56C280 42.75 269.3 32 256 32S232 42.75 232 56v220.8l-191.4 160.8c-10.14 8.531-11.47 23.66-2.938 33.81c8.516 10.16 23.64 11.45 33.81 2.938L256 319.3l184.6 155C445.1 478.2 450.5 480 455.1 480c6.844 0 13.64-2.906 18.39-8.562c8.531-10.16 7.203-25.28-2.938-33.81L280 276.8z"],
    "chart-scatter-bubble": [512, 512, [], "e0e9", "M488 432H48V56C48 42.75 37.25 32 24 32S0 42.75 0 56V448c0 17.59 14.41 32 32 32h456c13.25 0 24-10.75 24-24S501.3 432 488 432zM384 192c35.35 0 64-28.65 64-64s-28.65-64-64-64s-64 28.65-64 64S348.7 192 384 192zM384 112c8.822 0 16 7.178 16 16S392.8 144 384 144S368 136.8 368 128S375.2 112 384 112zM352 352c35.35 0 64-28.65 64-64s-28.65-64-64-64s-64 28.65-64 64S316.7 352 352 352zM352 272c8.822 0 16 7.178 16 16S360.8 304 352 304S336 296.8 336 288S343.2 272 352 272zM176 352C202.5 352 224 330.5 224 304S202.5 256 176 256S128 277.5 128 304S149.5 352 176 352zM240 224C266.5 224 288 202.5 288 176S266.5 128 240 128S192 149.5 192 176S213.5 224 240 224z"],
    "chart-tree-map": [512, 512, [], "e0ea", "M192 272H32c-17.67 0-32 14.33-32 32V448c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32V304C224 286.3 209.7 272 192 272zM176 432h-128V320h128V432zM480 192h-192c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32V224C512 206.3 497.7 192 480 192zM464 272h-160v-32h160V272zM480 32h-192c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32V64C512 46.33 497.7 32 480 32zM464 112h-160v-32h160V112zM192 32H32C14.33 32 0 46.33 0 64v144c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32V64C224 46.33 209.7 32 192 32zM176 192h-128V80h128V192zM480 352h-192c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32v-64C512 366.3 497.7 352 480 352zM464 432h-160v-32h160V432z"],
    "chart-user": [640, 512, ["user-chart"], "f6a3", "M160 320c53.02 0 96-42.98 96-96c0-53.02-42.98-96-96-96C106.1 128 64 170.1 64 224C64 277 106.1 320 160 320zM160 176c26.47 0 48 21.53 48 48S186.5 272 160 272S112 250.5 112 224S133.5 176 160 176zM192 352H128c-70.69 0-128 57.3-128 128c0 17.67 14.33 32 32 32h256c17.67 0 32-14.33 32-32C320 409.3 262.7 352 192 352zM49.61 464C57.04 427.5 89.37 400 128 400h64c38.63 0 70.96 27.53 78.39 64H49.61zM584 0H216C185.1 0 160 25.12 160 56V80c0 13.25 10.75 24 24 24S208 93.25 208 80V56c0-4.406 3.594-8 8-8h368c4.406 0 8 3.594 8 8v304c0 4.406-3.594 8-8 8H352c-13.25 0-24 10.75-24 24S338.8 416 352 416h232c30.88 0 56-25.12 56-56v-304C640 25.12 614.9 0 584 0zM328.1 167c-9.375-9.375-24.6-9.375-33.98 0s-9.354 24.58 .0208 33.96l71.98 72.02C371.7 277.7 377.8 280 384 280s12.3-2.323 16.99-7.01L496 177.9V200C496 213.3 506.8 224 520 224S544 213.3 544 200v-80C544 106.8 533.3 96 520 96h-80C426.8 96 416 106.8 416 120s10.75 24 24 24h22.06L384 222L328.1 167z"],
    "chart-waterfall": [512, 512, [], "e0eb", "M344 192c13.25 0 24-10.75 24-24v-80C368 74.75 357.3 64 344 64S320 74.75 320 88v80C320 181.3 330.8 192 344 192zM440 352c13.25 0 24-10.75 24-24v-240C464 74.75 453.3 64 440 64S416 74.75 416 88v240C416 341.3 426.8 352 440 352zM248 256c13.25 0 24-10.75 24-24v-80C272 138.8 261.3 128 248 128S224 138.8 224 152v80C224 245.3 234.8 256 248 256zM152 352c13.25 0 24-10.75 24-24v-80C176 234.8 165.3 224 152 224S128 234.8 128 248v80C128 341.3 138.8 352 152 352zM488 432H48V56C48 42.75 37.25 32 24 32S0 42.75 0 56V448c0 17.59 14.41 32 32 32h456c13.25 0 24-10.75 24-24S501.3 432 488 432z"],
    "check": [512, 512, [10004, 61452], "2713", "M480.1 128.1l-272 272C204.3 405.7 198.2 408 192 408s-12.28-2.344-16.97-7.031l-144-144c-9.375-9.375-9.375-24.56 0-33.94s24.56-9.375 33.94 0L192 350.1l255-255c9.375-9.375 24.56-9.375 33.94 0S490.3 119.6 480.1 128.1z"],
    "check-double": [512, 512, [], "f560", "M480.1 159c-9.375-9.375-24.56-9.375-33.94 0L192 414.1L64.97 287c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l144 144C179.7 469.7 185.8 472 192 472s12.28-2.344 16.97-7.031l272-272C490.3 183.6 490.3 168.4 480.1 159zM175 240.1C179.7 245.7 185.8 248 192 248s12.28-2.344 16.97-7.031l176-176c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L192 190.1L112.1 111c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L175 240.1z"],
    "check-to-slot": [576, 512, ["vote-yea"], "f772", "M341.1 137.2L268.6 229.5L231.6 197.8C221.6 189.2 206.4 190.3 197.8 200.4C189.2 210.4 190.3 225.6 200.4 234.2l56 48C260.8 285.1 266.2 287.1 271.1 287.1c.7813 0 1.606-.0187 2.388-.1125c6.531-.625 12.5-3.906 16.53-9.062l88-112c8.188-10.41 6.375-25.5-4.062-33.69C364.4 124.1 349.3 126.8 341.1 137.2zM96 408h384c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24V96c0-35.35-28.65-64-64-64H160C124.7 32 96 60.65 96 96v264c-13.25 0-24 10.74-24 24C72 397.3 82.75 408 96 408zM144 96c0-8.836 7.164-16 16-16h256c8.836 0 16 7.164 16 16v264h-288V96zM524.6 288c-13.25 0-24 10.75-24 24s10.75 24 24 24C526.5 336 528 337.5 528 339.4V424c0 4.406-3.594 8-8 8H56c-4.406 0-8-3.594-8-8v-84.58C48 337.5 49.53 336 51.41 336c13.25 0 24-10.75 24-24S64.66 288 51.41 288C23.06 288 0 311.1 0 339.4V424C0 454.9 25.13 480 56 480h464c30.88 0 56-25.12 56-56v-84.58C576 311.1 552.9 288 524.6 288z"],
    "cheese": [512, 512, [], "f7ef", "M299.9 32.01L298.4 32c-7.125 .125-14.13 2.508-19.62 7.008L0 255.1v192C0 465.6 14.38 480 32 480h448c17.62 0 32-14.37 32-31.1V255.1C512 136.1 417.1 38.26 299.9 32.01zM303.6 80.38c87.75 7.75 155.6 79.5 159.6 167.5H88.5L303.6 80.38zM464 432h-416V295.9h416V432z"],
    "cheese-swiss": [512, 512, [63472], "1f9c0", "M176 319.9c-26.5 0-48 21.5-48 48s21.5 48 48 48s48-21.5 48-48S202.5 319.9 176 319.9zM299.9 32.01L298.4 32c-7.125 .125-14.13 2.508-19.62 7.008L0 255.1v192C0 465.6 14.38 480 32 480h448c17.62 0 32-14.37 32-31.1V255.1C512 136.1 417.1 38.26 299.9 32.01zM196.5 163.8C204.6 181.9 223.1 193 242.9 191.9c19.88-1.25 36.88-14.5 42.88-33.38S285.5 119 269.1 106.6l33.63-26.12c87.75 7.625 155.6 79.38 159.6 167.4h-53.88c-8.5-14.88-24.25-24-41.38-24s-32.88 9.125-41.38 24H88.5L196.5 163.8zM464 432h-416V295.9h278.6c8.5 14.88 24.25 24 41.38 24s32.88-9.125 41.38-24H464V432z"],
    "cherries": [640, 512, [], "e0ec", "M539.3 224.1c-20.45 0-44.27 4.555-71.23 14.38C434.6 109.9 313.6 .0001 287.9 .0001c-11.19 0-21.47 7.998-23.63 19.68c-25.78 140.1-73.11 202.6-89.55 219.9c-12.51-4.698-43.26-15.48-74.13-15.48c-92.32 0-100.6 82.48-100.6 105.7c0 82.16 67.03 182.2 191.1 182.2c53.65 0 96.47-18.54 128-46.11c31.54 27.53 74.31 46.11 127.9 46.11c125 0 192.1-100.1 192.1-182.2C640 306.5 631.7 224.1 539.3 224.1zM303.4 67.38c33.89 30.3 88.24 88.81 113.6 167.4c-26.62-8.542-46.49-10.8-60.5-10.8c-13.72 0-25.53 2.499-36.34 6.143C309.2 226.5 297.1 224.1 283.3 224.1c-12.69 0-26.63 1.762-41.81 5.393C260.1 197.1 285.3 145.2 303.4 67.38zM48.02 329.8c0-23.24 6.353-57.79 52.57-57.79c30.45 0 59.48 12.81 91.34 26.82c33.63-14.79 60.76-26.82 91.32-26.82c46.22 0 52.59 34.54 52.59 57.79c0 19.76-19.1 134.2-143.9 134.2C66.58 464 48.02 349.1 48.02 329.8zM591.1 329.8c0 19.62-19.03 134.2-144.1 134.2c-45.82 0-76.86-17.05-96.34-33.88c21.22-31.24 32.31-67.2 32.31-100.4c0-29.51-9.051-48.89-13.16-56.73c28.8 3.611 53.32 15.29 77.19 25.78c33.55-14.74 60.84-26.81 91.4-26.81C585.7 272 591.1 306.7 591.1 329.8z"],
    "chess": [512, 512, [], "f439", "M497.6 279.1C506.6 273.2 512 263.2 512 252.5V192c0-17.6-14.4-32-32-32h-192c-17.6 0-32 14.4-32 32v60.5c0 10.88 5.5 21 12.75 25.5L296 299.6v74.75C291 378.9 288 385.2 288 392V416l-25.62 19.25C258.4 438.2 256 443 256 448c0-5-2.375-9.75-6.375-12.75L224 416v-24c-.125-10.38-6.875-19.5-16.88-22.5c-3.75-25-6.375-50.25-6.375-75.5V256H208C216.8 256 224 248.8 224 240V224c0-8.837-7.163-16-16-16H204.9l26.88-80.38c.8527-2.516 1.269-5.104 1.269-7.67c0-11.89-9.075-23.95-24.91-23.95L144.8 96V64h16C169.6 64 176.8 56.8 176.8 48S169.6 32 160.8 32H144.8V15.1C144.8 7.2 137.6 0 128.8 0S112.8 7.2 112.8 15.1V32H96.86C88.06 32 80.75 39.2 80.75 47.1S87.95 64 96.75 64H112.8v32L49.39 95.1c-15.54 0-24.91 11.86-24.91 23.95c0 2.567 .4164 5.155 1.269 7.671L52.75 208H48C39.16 208 32 215.2 32 224v16C32 248.8 39.16 256 48 256h8.75v38c0 25.12-2.5 50.25-6.375 75.12C39.88 371.8 32 380.8 32 392V416l-25.63 19.26C2.358 438.3 0 442.1 0 448v48C0 504.8 7.163 512 16 512h224c8.875 0 16-7.125 16-16c0 8.875 7.125 16 16 16h224c8.837 0 16-7.163 16-16V448c0-5.012-2.358-9.732-6.365-12.74L480 416v-24c0-6.75-3-13.12-8-17.62V299.5L497.6 279.1zM175.8 144l-21.5 64H103.4l-21.5-64H175.8zM158.8 368H98.88c3.5-25.25 5.875-50.13 5.875-73.1V256h48v38C152.8 317.9 155.1 342.8 158.8 368zM48 464l32-24V416h96v24l32 24H48zM304 464l32-24V416h96v24l32 24H304zM464 244.6l-40 31.75V368h-80V276.4L304 244.9V208h32v24h32V208h32v24h32V208h32V244.6zM384 288c-8.875 0-16 7.125-16 16v32h32v-32C400 295.1 392.9 288 384 288z"],
    "chess-bishop": [320, 512, [62522], "265d", "M296 464H23.1C10.75 464 0 474.7 0 487.1S10.75 512 23.1 512h272C309.3 512 320 501.3 320 488S309.3 464 296 464zM0 304c0 51.63 30.12 85.25 64 96v32h48v-67.13l-33.5-10.63C63.75 349.5 48 333.9 48 304c0-84.1 93.2-206.5 112.6-206.5c19.63 0 60.01 67.18 70.28 85.8l-66.13 66.13c-3.125 3.125-4.688 7.219-4.688 11.31S161.6 268.9 164.8 272L176 283.2c3.125 3.125 7.219 4.688 11.31 4.688s8.188-1.562 11.31-4.688L253 229C264.4 256.8 272 283.5 272 304c0 29.88-15.75 45.5-30.5 50.25L208 364.9V432H256v-32c33.88-10.75 64-44.38 64-96c0-73.38-67.75-197.2-120.6-241.5C213.4 59.12 224 47 224 32c0-17.62-14.38-32-32-32H128C110.4 0 96 14.38 96 32c0 15 10.62 27.12 24.62 30.5C67.75 106.8 0 230.6 0 304z"],
    "chess-bishop-piece": [256, 512, ["chess-bishop-alt"], "f43b", "M249.6 435.2L224 416v-24c0-12.12-9.125-21.62-20.75-23.38C201.4 352.5 200.2 336.2 200 320h8c8.875 0 16-7.125 16-16V288c-.125-7.875-5.875-14.5-13.62-15.5C224 261.6 232 243.4 232 211.4c0-41.63-25.88-100.6-58-132.6C184.2 76 192 67 192 56C192 42.75 181.2 32 168 32h-80C74.75 32 64 42.75 64 56c0 11 7.75 20 17.1 22.75C49.88 110.8 24 169.8 24 211.4c0 32 8 50.25 21.62 61.12C37.88 273.5 32.12 280.1 32 288v16C32 312.9 39.12 320 48 320h8c-.25 16.25-1.375 32.5-3.25 48.63C41.12 370.2 32 379.9 32 392V416l-25.62 19.25C2.375 438.2 0 443 0 448v48C0 504.9 7.125 512 16 512h224c8.875 0 16-7.125 16-16V448C256 443 253.6 438.2 249.6 435.2zM115.2 110.4C118.2 106.5 123 104.2 128 104.2c8.129 0 13.59 3.458 30.62 32.38L121 174.2C119.5 175.8 118.6 177.9 118.6 180S119.5 184.1 121 185.6L134.5 199C136 200.5 137.1 201.4 140.1 201.4c2.125 0 4.125-.875 5.625-2.375l28.62-28.62C180.2 185.6 184 200.2 184 211.4v.5C183.9 225.1 178.5 237.8 169 247L160 256v16H96V256L87 247C77.5 237.8 72.13 225.1 72 211.9V211.2C72 185.6 89.75 142.4 115.2 110.4zM154.9 368H101.1C102.6 352 103.9 336 104 320h48C152.1 336 153.4 352 154.9 368zM48 464l32-24V416h96v24l32 24H48z"],
    "chess-board": [448, 512, [], "f43c", "M64 96v64h64V96H64zM256 96H192v64h64V96zM192 416h64v-64H192V416zM64 416h64v-64H64V416zM64 224v64h64V224H64zM384 288V224h-64v64H384zM384 416v-64h-64v64H384zM320 160h64V96h-64V160zM256 224h64V160h-64V224zM384 32H64C28.8 32 0 60.8 0 96v320c0 35.2 28.8 64 64 64h320c35.2 0 64-28.8 64-64V96C448 60.8 419.2 32 384 32zM400 416c0 8.674-7.326 16-16 16H64c-8.672 0-16-7.326-16-16V96c0-8.674 7.328-16 16-16h320c8.674 0 16 7.326 16 16V416zM192 160H128v64h64V160zM192 288h64V224H192V288zM128 288v64h64V288H128zM256 352h64V288h-64V352z"],
    "chess-clock": [640, 512, [], "f43d", "M544 112L544 104c0-13.25-10.74-24-24-24h-112C394.7 80 384 90.75 384 104V112H200l.1662-32H232C245.3 80 256 69.25 256 56S245.3 32 232 32h-112C106.7 32 96 42.75 96 56S106.7 80 120 80h32.17L152 112H96c-53.02 0-96 42.98-96 96V384c0 53.02 42.98 96 96 96h448c53.02 0 96-42.98 96-96V207.1C640 154.1 597 112 544 112zM592 384c0 26.51-21.49 48-48 48H96c-26.51 0-48-21.49-48-48V208C48 181.5 69.49 160 96 160h448c26.51 0 48 21.49 48 48V384zM200 192C142.6 192 96 238.6 96 296s46.56 104 104 104S304 353.4 304 296S257.4 192 200 192zM216 288c0 8.844-7.156 16-16 16S184 296.8 184 288V240c0-8.844 7.156-16 16-16s16 7.156 16 16V288zM440 191.1c-59.49 0-104 48.64-104 103.1c0 55.64 44.81 103.1 104 103.1c59.49 0 104-48.62 104-103.1C544 240.4 499.3 191.1 440 191.1zM495.6 256.4c0 4.093-1.563 8.187-4.69 11.31l-33.94 33.94c-3.127 3.127-7.22 4.69-11.31 4.69c-8.552 0-16-6.904-16-16c0-4.093 1.563-8.187 4.69-11.31l33.94-33.94c3.126-3.127 7.219-4.69 11.31-4.69C488.7 240.4 495.6 247.9 495.6 256.4z"],
    "chess-clock-flip": [640, 512, ["chess-clock-alt"], "f43e", "M440 192c-57.44 0-104 46.56-104 104s46.56 104 104 104S544 353.4 544 296S497.4 192 440 192zM456 288c0 8.844-7.156 16-16 16s-16-7.156-16-16V240c0-8.844 7.156-16 16-16s16 7.156 16 16V288zM0 207.1l0 176.1C0 437 42.96 480 95.96 480h448.1C597 480 640 437 640 384V207.1C640 154.1 597 112 544 112H488l-.1662-32H520C533.3 80 544 69.25 544 56S533.3 32 520 32h-112C394.7 32 384 42.75 384 56s10.74 24 24 24h31.83L440 112H255.1L256 104C256 90.75 245.3 80 232 80h-112C106.7 80 96 90.75 96 104L95.97 112C42.98 112 0 154.1 0 207.1zM48 208C48 181.5 69.49 160 96 160h448c26.51 0 48 21.49 48 48V384c0 26.51-21.49 48-48 48H96c-26.51 0-48-21.49-48-48V208zM200 191.1c-59.49 0-104 48.64-104 103.1c0 55.64 44.81 103.1 104 103.1c59.49 0 104-48.62 104-103.1C304 240.4 259.3 191.1 200 191.1zM255.6 256.4c0 4.093-1.563 8.187-4.69 11.31L216.1 301.7c-3.127 3.127-7.221 4.69-11.31 4.69c-8.569 0-16-6.921-16-16c0-4.093 1.563-8.187 4.69-11.31l33.94-33.94c3.126-3.127 7.219-4.69 11.31-4.69C248.7 240.4 255.6 247.9 255.6 256.4z"],
    "chess-king": [448, 512, [62527], "265a", "M391.9 464H55.95c-13.25 0-23.1 10.75-23.1 23.1S42.7 512 55.95 512h335.1c13.25 0 23.1-10.75 23.1-23.1S405.2 464 391.9 464zM448 216c0-11.82-3.783-23.51-11.08-33.17c-10.3-14.39-27-22.88-44.73-22.88L247.9 160V104h31.1c13.2 0 24.06-10.8 24.06-24S293.1 56 279.9 56h-31.1V23.1C247.9 10.8 237.2 0 223.1 0S199.9 10.8 199.9 23.1V56H167.9c-13.2 0-23.97 10.8-23.97 24S154.7 104 167.9 104h31.1V160H55.95C24.72 160 0 185.3 0 215.9C0 221.6 .8893 227.4 2.704 233L68.45 432h50.5L48.33 218.4C48.09 217.6 47.98 216.9 47.98 216.1C47.98 212.3 50.93 208 55.95 208h335.9c6.076 0 8.115 5.494 8.115 8.113c0 .6341-.078 1.269-.2405 1.887L328.8 432h50.62l65.1-199.2C447.2 227.3 448 221.7 448 216z"],
    "chess-king-piece": [256, 512, ["chess-king-alt"], "f440", "M249.6 435.3L224 416v-24c-.125-10.38-6.875-19.5-16.88-22.5c-3.75-25-6.375-50.25-6.375-75.5V256H208C216.8 256 224 248.8 224 240V224c0-8.875-7.125-16-16-16h-3.125l26.1-80.38c.7917-2.458 1.181-4.986 1.181-7.495C233.1 107.3 222.8 96 209 96h-64.25V64h16c8.8 0 16-7.2 16-15.1S169.6 32 160.8 32h-16V15.1c0-8.8-7.2-15.1-16-15.1s-16 7.2-16 15.1V32H96.86C88.06 32 80.75 39.2 80.75 47.1S87.95 64 96.75 64h16v32H48.5C35.21 96 24.48 106.8 24.48 119.1c0 2.567 .4164 5.155 1.269 7.671L52.75 208H48C39.12 208 32 215.1 32 224v16C32 248.8 39.16 256 48 256h8.75v38c0 25.12-2.5 50.25-6.375 75.12C39.88 371.8 32 380.8 32 392V416l-25.63 19.26C2.358 438.3 0 442.1 0 448v48C0 504.8 7.163 512 16 512h224c8.837 0 16-7.163 16-16V448C256 442.1 253.6 438.3 249.6 435.3zM175.8 144l-21.5 64H103.4l-21.5-64H175.8zM158.4 368H99.12c3.375-24.5 5.625-49.25 5.625-73.1V256h48v38C152.8 318.8 155 343.5 158.4 368zM48 464l32-24V416h96v24l32 24H48z"],
    "chess-knight": [384, 512, [62529], "265e", "M44 320.6l14.5 6.5c-17.01 20.24-26.44 45.91-26.44 72.35C32.06 399.7 32.12 432 32.12 432h48v-32c0-24.75 14-47.5 36.13-58.63l38.13-23.37c13.25-6.625 21.75-20.25 21.75-35.13v-58.75l-15.37 9C155.6 235.8 151.9 240.4 150.5 245.9L143 271c-2.25 7.625-8 13.88-15.38 16.75L117.1 292C114 293.3 110.7 293.9 107.4 293.9c-3.626 0-7.263-.7514-10.66-2.254L63.5 276.9C54.12 272.6 48 263.2 48 252.9V140.5c0-5.125 2.125-10.12 5.75-13.88l7.375-7.375L49.5 96C48.5 94.12 48 92 48 89.88C48 84.38 52.38 80 57.88 80h105c86.75 0 156.1 70.38 156.1 157.1V432h48.06l-.0625-194.9C367.9 124 276 32 162.9 32H57.88C25.88 32 0 57.88 0 89.88c0 8.5 1.75 16.88 5.125 24.62C1.75 122.8 0 131.6 0 140.5v112.4C0 282.2 17.25 308.8 44 320.6zM80.12 164c0 11 8.875 20 20 20c11 0 20-9 20-20s-9-20-20-20C89 144 80.12 153 80.12 164zM360 464H23.1C10.75 464 0 474.7 0 487.1S10.75 512 23.1 512H360C373.3 512 384 501.3 384 488S373.3 464 360 464z"],
    "chess-knight-piece": [320, 512, ["chess-knight-alt"], "f442", "M89.75 195.2c7.849 0 13.87-6.619 13.87-13.97c0-3.581-1.416-7.122-3.991-9.78C96.93 168.9 93.33 167.5 89.7 167.5c-7.556 0-13.83 6.145-13.83 13.9C75.88 189 81.1 195.1 89.75 195.2zM313.6 435.2L288 416v-30.12c10.25-13.63 15.88-30.12 16-47.12V232.6C304 139.6 228.4 64 135.4 64H55.38C25.02 64-.0433 88.92-.0433 119.6c0 6.22 1.043 12.48 3.168 18.5C1 144.5 0 151.1 0 157.8v84.75C0 268 14.38 291.4 37 303c-21.32 29.94-20.88 61.54-20.88 62.21c0 16.67 5.481 33.03 15.88 46.42V416l-25.62 19.25C2.375 438.2 0 443 0 448v48C0 504.9 7.125 512 16 512h288c8.875 0 16-7.125 16-16V448C320 443 317.6 438.2 313.6 435.2zM48.01 119.6C48.01 115.2 51.47 112 55.38 112h80C201.8 112 256 166.2 256 232.6v106.1c0 8.5-3.375 16.62-9.375 22.62L240 368H64.75c-.0968-1.645-.4933-3.291-.4933-4.936c0-1.975 1.253-38.11 46.24-58.44l34.88-10.87C154.3 289.8 160 280.9 160 271.2V222.9L132.9 227.6c-3.875 2-6.625 5.5-7.75 9.625L119.5 256.2C115.1 270.8 94.67 273.5 92.5 273.5c-2.625 0-5.25-.625-7.75-1.75l-25-11.13C52.62 257.5 48 250.4 48 242.5V157.8c0-7.375 4.375-10.63 9.875-16L49.12 124.1C48.35 122.5 48.01 121 48.01 119.6zM48 464l32-24V416h160v24l32 24H48z"],
    "chess-pawn": [320, 512, [62531], "265f", "M296 463.1H23.1c-13.25 0-23.1 10.75-23.1 24s10.75 24 23.1 24h272c13.25 0 23.1-10.75 23.1-23.1S309.3 463.1 296 463.1zM55.1 287.1L80 287.1v29.5c0 40.25-3.5 81.25-23.38 114.5h53.5C125.1 394.1 128 354.6 128 317.5v-29.5h64v29.5c0 37.13 2.875 77.5 17.88 114.5h53.5C243.5 398.7 240 357.7 240 317.5V287.1l24-.0001C277.3 287.1 288 277.3 288 263.1c0-13.25-10.75-24-23.1-24H241c23.75-21.88 38.1-53.12 38.1-87.1c0-9.393-1.106-19.05-3.451-28.86C272.3 105.4 244.9 32 159.1 32C93.75 32 40 85.75 40 151.1c0 34.88 15.12 66.12 39 88H55.1C42.75 239.1 32 250.7 32 263.1C32 277.3 42.75 287.1 55.1 287.1zM160 79.1c39.75 0 72 32.25 72 72S199.8 223.1 160 223.1S88 191.7 88 151.1S120.2 79.1 160 79.1z"],
    "chess-pawn-piece": [256, 512, ["chess-pawn-alt"], "f444", "M249.6 435.4L224 416.2v-23.96c0-13.23-10.75-23.96-24-23.96h2.625C201.1 352.3 200 336.3 200 320.3V288.4h8c8.875 0 16-7.112 16-15.97V256.5c-.125-7.861-5.875-14.35-13.62-15.47c5.34-8.784 13.63-25.79 13.63-49.01C224 138.7 180.8 96 127.1 96C77.19 96 32 136.1 32 191.8c0 16.94 4.491 33.95 13.62 49.17C37.88 242.1 32 248.6 32 256.5v15.97c0 8.859 7.125 15.97 16 15.97h8v31.94c0 15.97-1.125 31.94-2.625 47.92H56c-13.25 0-24 10.73-24 23.96v23.96l-25.62 19.22C2.375 438.4 0 443.1 0 448.1v47.9C0 504.9 7.125 512 16 512h224c8.875 0 16-7.126 16-15.99v-47.9C256 443.1 253.6 438.4 249.6 435.4zM152 288.4v29.95c0 16.72 1 33.32 2.5 49.91h-53C103 351.7 104 335.1 104 318.3V288.4H152zM128 144.7c26.5 0 48 21.46 48 47.92S154.5 240.5 128 240.5S80 219 80 192.6S101.5 144.7 128 144.7zM48 464.1l32-23.96v-23.96h96v23.96l32 23.96H48z"],
    "chess-queen": [512, 512, [62533], "265b", "M256 112c30.88 0 56-25.12 56-56S286.9 0 256 0S199.1 25.12 199.1 56S225.1 112 256 112zM511.1 197.4c0-5.178-2.509-10.2-7.096-13.26L476.4 168.2c-2.5-1.75-5.497-2.62-8.497-2.62c-5.501 .125-10.63 2.87-13.75 7.245c-9.001 12-23.16 19.13-38.16 19.13c-3.125 0-6.089-.2528-9.089-.8778c-23.13-4.25-38.88-26.25-38.88-49.75C367.1 134 361.1 128 354.6 128h-38.75c-6.001 0-11.63 4-12.88 9.875C298.2 160.1 278.7 176 255.1 176c-22.75 0-42.25-15.88-47-38.12C207.7 132 202.2 128 196.1 128h-38.75C149.1 128 143.1 134 143.1 141.4c0 18.49-13.66 50.62-47.95 50.62c-15.13 0-29.3-7.118-38.3-19.24C54.6 168.4 49.66 165.7 44.15 165.6c-3 0-5.931 .8951-8.432 2.645l-28.63 16C2.509 187.2 0 192.3 0 197.4c0 2.438 .5583 4.901 1.72 7.185L109.9 432h53.13L69.85 236.4C78.35 238.8 87.11 240 95.98 240c2.432 0 56.83 1.503 84.76-52.5C198.1 210.5 226.6 224 255.9 224c29.38 0 57.01-13.38 75.26-36.25C336.1 197.6 360.6 240 416 240c8.751 0 17.5-1.125 26-3.5L349 432h53.13l108.1-227.4C511.4 202.3 511.1 199.8 511.1 197.4zM424 464H87.98c-13.26 0-24 10.75-24 23.1S74.72 512 87.98 512h336c13.26 0 24-10.75 24-23.1S437.3 464 424 464z"],
    "chess-queen-piece": [256, 512, ["chess-queen-alt"], "f446", "M223.6 416v-24c0-11.25-7.874-20.25-18.25-22.88c-3.125-22.25-5.25-44.63-5.25-67.12V256h23.1c8.749 0 15.1-7.125 15.1-16V224c0-8.875-7.249-16-15.1-16h-7.499l38.5-105C255.7 101.8 256 100.6 256 99.31c0-2.614-1.281-5.167-3.649-6.689l-12.12-8.125c-1.337-.8916-2.818-1.306-4.294-1.306c-8.735 0-9.064 13.41-26.12 13.41c-12.47 0-24.7-9.738-24.7-25.85c0-1.75-.6249-3.5-1.1-4.75C181.9 64.75 180.1 64 178.4 64l-20.01-.0052c-3.009 0-5.509 2.089-6.238 5.005c-2.375 11.25-12.37 19.38-23.87 19.38c-11.62 0-21.62-8.125-23.1-19.38c-.6075-2.916-3.353-5.003-6.369-5.003c-.0869 0 .0875-.0035 0 0L77.99 64c-3.749 0-6.749 3-6.749 6.875c0 16.14-12.25 25.74-24.72 25.74c-7.039 0-14.15-3.062-19.15-9.739C25.81 84.66 23.23 83.2 20.47 83.2c-1.443 0-2.934 .4002-4.35 1.302l-12.12 8.125c-2.308 1.539-3.623 4.131-3.623 6.775c0 1.222 .2804 2.454 .8728 3.6L39.87 208H32.37c-8.874 0-15.1 7.125-15.1 16v16c0 8.875 7.124 16 15.1 16h23.1v46c0 22.5-2.25 44.75-5.375 66.1C40.25 371.4 31.1 380.5 31.1 392V416l-25.62 19.25C2.375 438.2 0 443 0 448v48C0 504.9 7.125 512 15.1 512h223.6c8.874 0 15.1-7.125 15.1-16V448c0-5-2.375-9.75-6.374-12.75L223.6 416zM93.24 127.4c10.84 6.078 22.87 9.109 34.92 9.109c11.98 0 23.98-2.1 34.83-8.984c7.749 6.625 16.87 11.5 26.75 14.38L166.9 208H89.49l-22.87-66.25C76.37 139 85.49 134 93.24 127.4zM156.9 368H99.49c2.75-21.88 4.75-43.88 4.75-65.1V256h47.87v46C152.1 324.1 154.1 346.1 156.9 368zM47.87 464l31.1-24V416h95.87v24l31.87 24H47.87zM128.2 56c15.37 0 27.1-12.5 27.1-28S143.4 0 128 0c-15.5 0-27.81 12.5-27.81 28S112.7 56 128.2 56z"],
    "chess-rook": [384, 512, [62535], "265c", "M360 464H23.1C10.75 464 0 474.7 0 487.1S10.75 512 23.1 512H360C373.3 512 384 501.3 384 488S373.3 464 360 464zM345.1 32h-308C17 32 0 49 0 70v139.4C0 218.8 4 227.5 11 233.6L48 265.8c0 8.885 .0504 17.64 .0504 26.46c0 39.32-1.001 79.96-11.93 139.8h49C94.95 374.3 96.11 333.3 96.11 285.5C96.11 270.7 96 255.1 96 238.2L48 196.5V80h64V128H160V80h64V128h48V80h64v116.5L288 238.2c0 16.77-.1124 32.25-.1124 47.1c0 47.79 1.164 89.15 10.99 146.7h49c-10.92-59.83-11.93-100.6-11.93-139.9C335.9 283.3 336 274.6 336 265.8l37-32.13C380 227.5 384 218.8 384 209.4V70C384 49 367 32 345.1 32zM192 224C174.4 224 160 238.4 160 256v64h64V256C224 238.4 209.6 224 192 224z"],
    "chess-rook-piece": [320, 512, ["chess-rook-alt"], "f448", "M313.6 435.2L288 416v-24c0-11.12-7.75-20.12-18.12-22.75L264.5 251.5l26.75-20.12c8-6 12.75-15.5 12.75-25.5V96c0-17.62-14.38-32-32-32h-224c-17.62 0-32 14.38-32 32v110C16 216 20.75 225.5 28.75 231.6l26.75 20l-5.375 117.6C39.75 371.9 32 380.9 32 392V416l-25.62 19.25C2.375 438.2 0 443 0 448v48C0 504.9 7.125 512 16 512h288c8.875 0 16-7.125 16-16V448C320 443 317.6 438.2 313.6 435.2zM64 112h40v32h32v-32h48v32h32v-32H256v85.88L215.5 228.5L221.5 368h-123l6-139.6L64 198V112zM48 464l32-24V416h160v24l32 24H48zM184 247.6C184 234.5 173.5 224 160.4 224c-13 0-23.5 10.5-23.5 23.62V288H184V247.6z"],
    "chevron-down": [448, 512, [], "f078", "M432.6 209.3l-191.1 183.1C235.1 397.8 229.1 400 224 400s-11.97-2.219-16.59-6.688L15.41 209.3C5.814 200.2 5.502 184.1 14.69 175.4c9.125-9.625 24.38-9.938 33.91-.7187L224 342.8l175.4-168c9.5-9.219 24.78-8.906 33.91 .7187C442.5 184.1 442.2 200.2 432.6 209.3z"],
    "chevron-left": [320, 512, [61523], "2329", "M206.7 464.6l-183.1-191.1C18.22 267.1 16 261.1 16 256s2.219-11.97 6.688-16.59l183.1-191.1c9.152-9.594 24.34-9.906 33.9-.7187c9.625 9.125 9.938 24.37 .7187 33.91L73.24 256l168 175.4c9.219 9.5 8.906 24.78-.7187 33.91C231 474.5 215.8 474.2 206.7 464.6z"],
    "chevron-right": [320, 512, [61524], "232a", "M113.3 47.41l183.1 191.1c4.469 4.625 6.688 10.62 6.688 16.59s-2.219 11.97-6.688 16.59l-183.1 191.1c-9.152 9.594-24.34 9.906-33.9 .7187c-9.625-9.125-9.938-24.38-.7187-33.91l168-175.4L78.71 80.6c-9.219-9.5-8.906-24.78 .7187-33.91C88.99 37.5 104.2 37.82 113.3 47.41z"],
    "chevron-up": [448, 512, [], "f077", "M15.41 302.7l191.1-183.1C212 114.2 218 111.1 224 111.1s11.97 2.219 16.59 6.688l191.1 183.1c9.594 9.152 9.906 24.34 .7187 33.9c-9.125 9.625-24.38 9.938-33.91 .7187L224 169.2l-175.4 168c-9.5 9.219-24.78 8.906-33.91-.7187C5.502 327 5.814 311.8 15.41 302.7z"],
    "chevrons-down": [448, 512, ["chevron-double-down"], "f322", "M207.4 265.3c9.313 8.875 23.88 8.875 33.19 0l184-176c9.563-9.156 9.906-24.34 .75-33.94C420.6 50.47 414.3 48 408 48c-5.969 0-11.94 2.219-16.59 6.656L224 214.8L56.59 54.66C46.1 45.53 31.81 45.81 22.65 55.41S13.84 80.19 23.4 89.34L207.4 265.3zM408 240c-5.969 0-11.94 2.219-16.59 6.656L224 406.8L56.59 246.7C46.1 237.5 31.81 237.8 22.65 247.4S13.84 272.2 23.4 281.3l184 176c9.313 8.875 23.88 8.875 33.19 0l184-176c9.563-9.156 9.906-24.34 .75-33.94C420.6 242.5 414.3 240 408 240z"],
    "chevrons-left": [448, 512, ["chevron-double-left"], "f323", "M73.22 256l160.1-167.4c9.125-9.594 8.844-24.78-.75-33.94S207.8 45.84 198.7 55.4l-176 184c-8.875 9.313-8.875 23.88 0 33.19l176 184c9.156 9.563 24.34 9.907 33.94 .75C237.5 452.6 240 446.3 240 440c0-5.969-2.219-11.94-6.656-16.59L73.22 256zM425.3 423.4L265.2 256l160.1-167.4c9.125-9.594 8.844-24.78-.75-33.94s-24.78-8.813-33.94 .75l-176 184c-8.875 9.313-8.875 23.88 0 33.19l176 184c9.156 9.563 24.34 9.907 33.94 .75C429.5 452.6 432 446.3 432 440C432 434 429.8 428.1 425.3 423.4z"],
    "chevrons-right": [448, 512, ["chevron-double-right"], "f324", "M233.3 239.4l-176-184C48.19 45.84 33 45.49 23.41 54.65C18.47 59.37 16 65.68 16 71.99c0 5.969 2.219 11.94 6.656 16.59L182.8 256l-160.1 167.4c-9.125 9.594-8.844 24.78 .75 33.94c9.594 9.156 24.78 8.813 33.94-.75l176-184C242.2 263.3 242.2 248.7 233.3 239.4zM425.3 239.4l-176-184C240.2 45.84 225 45.49 215.4 54.65C210.5 59.37 208 65.68 208 71.99c0 5.969 2.219 11.94 6.656 16.59L374.8 256l-160.1 167.4c-9.125 9.594-8.844 24.78 .75 33.94c9.594 9.156 24.78 8.813 33.94-.75l176-184C434.2 263.3 434.2 248.7 425.3 239.4z"],
    "chevrons-up": [448, 512, ["chevron-double-up"], "f325", "M56.59 265.3L224 105.2l167.4 160.1C396.1 269.8 402 272 408 272c6.312 0 12.62-2.469 17.34-7.406c9.156-9.594 8.812-24.78-.75-33.94l-184-176c-9.312-8.875-23.88-8.875-33.19 0l-184 176C13.84 239.8 13.49 255 22.65 264.6S46.1 274.5 56.59 265.3zM240.6 246.7c-9.312-8.875-23.88-8.875-33.19 0l-184 176c-9.562 9.156-9.906 24.34-.75 33.94s24.35 9.875 33.94 .75L224 297.2l167.4 160.1C396.1 461.8 402 464 408 464c6.312 0 12.62-2.469 17.34-7.406c9.156-9.594 8.812-24.78-.75-33.94L240.6 246.7z"],
    "child": [448, 512, [], "f1ae", "M427.4 105.8c-7.844-10.72-22.92-12.98-33.55-5.172l-68.39 50.16c-59.22 43.44-143.6 43.44-202.8 0l-68.39-50.16C43.56 92.83 28.48 95.09 20.64 105.8C12.81 116.5 15.13 131.5 25.81 139.4l68.39 50.16C104.9 197.4 116.3 203.9 128 209.6V488C128 501.3 138.8 512 152 512s24-10.75 24-24V384h96v104c0 13.25 10.75 24 24 24S320 501.3 320 488V209.6c11.71-5.725 23.09-12.24 33.8-20.1l68.39-50.16C432.9 131.5 435.2 116.5 427.4 105.8zM272 336h-96V226.1C191.7 229.6 207.6 232 224 232s32.34-2.414 48-5.916V336zM224 144c39.75 0 72-32.25 72-72S263.8-.0004 224-.0004S151.1 32.25 151.1 72S184.3 144 224 144z"],
    "chimney": [448, 512, [], "f78b", "M416 32H32C14.33 32 0 46.33 0 64v128c0 17.75 14.25 32 32 32v232C32 469.3 42.75 480 55.1 480S80 469.3 80 456V384H256v72C256 469.3 266.7 480 279.1 480S304 469.3 304 456V384h64v72C368 469.3 378.7 480 391.1 480S416 469.3 416 456V224c17.75 0 32-14.25 32-32V64C448 46.33 433.7 32 416 32zM160 336H80V224H160V336zM368 336h-160V224h160V336zM400 176h-352v-96h352V176z"],
    "church": [640, 512, [62749], "26ea", "M464.5 230.6L344 158.4V112h48C405.3 112 416 101.3 416 88C416 74.74 405.3 64 392 64h-48V24C344 10.74 333.3 0 320 0S296 10.74 296 24V64h-48C234.7 64 224 74.74 224 88C224 101.3 234.7 112 248 112h48v46.38L175.5 230.6C165.9 236.5 160 246.9 160 258.1V488C160 501.3 170.7 512 184 512s24-10.75 24-24V267.1L320 200l112 67.13V488c0 13.25 10.75 24 24 24S480 501.3 480 488V258.1C480 246.9 474.1 236.5 464.5 230.6zM93.27 322.5l-80 40C5.141 366.6 0 374.9 0 384v104C0 501.3 10.75 512 24 512s24-10.75 24-24v-89.16l66.73-33.38c11.86-5.938 16.66-20.34 10.73-32.19C119.6 321.4 105.2 316.7 93.27 322.5zM626.7 362.5l-80-40c-11.81-5.875-26.28-1.125-32.2 10.75c-5.922 11.84-1.125 26.25 10.73 32.19L592 398.8V488c0 13.25 10.75 24 24 24S640 501.3 640 488V384C640 374.9 634.9 366.6 626.7 362.5zM320 320c-35.35 0-64 28.65-64 64v96c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32v-96C384 348.7 355.3 320 320 320z"],
    "circle": [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9898, 9899, 11044, 61713, 61708, 61915], "25cf", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-0": [512, 512, [], "e0ed", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 128C203.1 128 160 171.1 160 224v64c0 52.94 43.06 96 96 96s96-43.06 96-96V224C352 171.1 308.9 128 256 128zM304 288c0 26.47-21.53 48-48 48S208 314.5 208 288V224c0-26.47 21.53-48 48-48s48 21.53 48 48V288z"],
    "circle-1": [512, 512, [], "e0ee", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM320 336h-40V152c0-8.844-4.875-16.97-12.67-21.16c-7.781-4.188-17.25-3.75-24.64 1.188l-52 34.66C179.7 174 176.7 188.9 184 199.1c7.328 11 22.23 13.97 33.28 6.656L232 196.8V336H192c-13.25 0-24 10.75-24 24S178.8 384 192 384h128c13.25 0 24-10.75 24-24S333.3 336 320 336z"],
    "circle-2": [512, 512, [], "e0ef", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM328 336H246.2l63.06-57.19c17-16.69 26.38-38.91 26.38-62.56s-9.375-45.88-26.38-62.56c-34.8-34.19-91.45-34.19-126.3 0L172 164.5C162.5 173.7 162.4 188.9 171.7 198.4c9.312 9.469 24.48 9.656 33.94 .3125L216.6 187.9c16.27-15.94 42.78-15.94 59.02 0c7.734 7.594 12 17.66 12 28.31s-4.266 20.72-11.31 27.66l-108.4 98.31c-7.344 6.656-9.844 17.16-6.266 26.41C165.2 377.9 174.1 384 184 384h144c13.25 0 24-10.75 24-24S341.3 336 328 336z"],
    "circle-3": [512, 512, [], "e0f0", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM277.2 216.5l51.06-46.81c7.297-6.688 9.734-17.16 6.156-26.38C330.8 134.1 321.9 128 312 128h-128C170.8 128 160 138.8 160 152S170.8 176 184 176h66.3L199.8 222.3C192.5 229 190 239.5 193.6 248.7C197.2 257.9 206.1 264 216 264h52c19.84 0 36 16.16 36 36S287.8 336 268 336H223.4c-7.547 0-14.2-4.812-16.59-11.97C202.6 311.5 189 304.8 176.4 308.8c-12.58 4.188-19.38 17.78-15.19 30.38C170.2 366 195.1 384 223.4 384H268C314.3 384 352 346.3 352 300C352 256.8 319.2 221.1 277.2 216.5z"],
    "circle-4": [512, 512, [], "e0f1", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM328 272H320V221.3c0-13.25-10.75-24-24-24s-24 10.75-24 24V272H206.5l47.58-110.5c5.234-12.19-.375-26.31-12.56-31.53C229.3 124.7 215.2 130.3 209.1 142.5l-62 144c-3.188 7.438-2.438 15.94 2 22.69S161.9 320 169.1 320H272v40c0 13.25 10.75 24 24 24S320 373.3 320 360V320h8C341.3 320 352 309.3 352 296S341.3 272 328 272z"],
    "circle-5": [512, 512, [], "e0f2", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM282.2 226.4L220.4 219.2L228.6 176H312c13.25 0 24-10.75 24-24S325.3 128 312 128H208.7C197.2 128 187.3 136.2 185.2 147.5l-16.73 88C167.2 242.1 168.7 248.8 172.6 254.2c3.953 5.375 9.938 8.875 16.56 9.656l87.39 10.28C292.2 275.9 304 289.2 304 304.9C304 322.1 290.1 336 272.1 336H223.4c-7.547 0-14.2-4.812-16.59-11.97C202.6 311.5 188.1 304.8 176.4 308.8c-12.58 4.188-19.38 17.78-15.19 30.38C170.2 366 195.1 384 223.4 384h49.59C316.5 384 352 348.5 352 304.9C352 264.8 321.1 231.1 282.2 226.4z"],
    "circle-6": [512, 512, [], "e0f3", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM282 196l29.76-25.94c9.969-8.719 11.03-23.88 2.312-33.88C309.3 130.8 302.7 128 296 128c-5.594 0-11.22 1.938-15.78 5.906L200.3 203.6C187.5 214.7 160 246.7 160 288c0 52.94 43.06 96 96 96s96-43.06 96-96C352 244.1 322.3 207.5 282 196zM256 336c-26.47 0-48-21.53-48-48c0-4.719 .6562-9.312 1.969-13.72C216 254.1 234.9 240 256 240c26.47 0 48 21.53 48 48S282.5 336 256 336z"],
    "circle-7": [512, 512, [], "e0f4", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM328 128h-144C170.8 128 160 138.8 160 152S170.8 176 184 176h103.8l-92.94 172.6c-6.281 11.66-1.938 26.22 9.75 32.5C208.3 383.1 212.1 384 215.1 384c8.562 0 16.81-4.562 21.16-12.62l112-208c4-7.438 3.812-16.44-.5313-23.69C344.3 132.4 336.4 128 328 128z"],
    "circle-8": [512, 512, [], "e0f5", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM336 200C336 160.3 303.7 128 264 128h-16C208.3 128 176 160.3 176 200c0 15.77 5.254 30.26 13.9 42.13C171.8 256.8 160 278.9 160 304C160 348.1 195.9 384 240 384h32c44.13 0 80-35.88 80-80c0-25.06-11.81-47.19-29.9-61.87C330.7 230.3 336 215.8 336 200zM248 176h16C277.2 176 288 186.8 288 200S277.2 224 264 224h-16C234.8 224 224 213.2 224 200S234.8 176 248 176zM272 336h-32c-17.66 0-32-14.34-32-32s14.34-32 32-32h32c17.66 0 32 14.34 32 32S289.7 336 272 336z"],
    "circle-9": [512, 512, [], "e0f6", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 128C203.1 128 160 171.1 160 224c0 43.86 29.73 80.53 69.98 91.96l-29.76 25.94c-9.969 8.719-11.03 23.88-2.312 33.88C202.7 381.2 209.3 384 216 384c5.594 0 11.22-1.938 15.78-5.906l79.94-69.69C324.5 297.3 352 265.3 352 224C352 171.1 308.9 128 256 128zM302 237.7C296 257.9 277.1 272 256 272C229.5 272 208 250.5 208 224S229.5 176 256 176s48 21.53 48 48C304 228.7 303.3 233.3 302 237.7z"],
    "circle-a": [512, 512, [], "e0f7", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM277.8 124.8c-7.842-17.08-35.75-17.08-43.59 0l-95.99 208.1c-5.547 12.09-.2966 26.43 11.73 31.99c12.09 5.588 26.28 .3125 31.86-11.77l12.03-26.18h124.3l12.03 26.18c4.061 8.822 12.73 14 21.81 14c3.359 0 6.781-.7228 10.05-2.229c12.03-5.559 17.28-19.91 11.73-31.99L277.8 124.8zM215.1 279.6L256 192.5l40.02 87.14H215.1z"],
    "circle-ampersand": [512, 512, [], "e0f8", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM331.5 315.3l28.15-41.31c7.469-10.95 4.625-25.89-6.312-33.34c-10.97-7.484-25.88-4.609-33.38 6.312l-21.76 31.93l-29.74-32.53l19.69-15.89c13.59-11 21.41-27.36 21.41-44.86C309.6 153.9 283.7 128 251.9 128H228.8C197 128 171.1 153.9 171.1 185.7c0 16.36 6.062 32.03 17.12 44.14l10.34 11.33L168.8 265.2C153.1 277.9 144 296.9 144 317.2C144 354 173.1 384 210.8 384h32.47c23.41 0 45.38-10.41 60.16-28.19l18.62 20.38C326.8 381.4 333.3 384 339.8 384c5.781 0 11.59-2.078 16.19-6.281c9.781-8.953 10.47-24.12 1.531-33.91L331.5 315.3zM228.8 176h23.12c5.312 0 9.656 4.328 9.656 9.656c0 2.938-1.312 5.688-3.594 7.516L236 210.9L223.7 197.4C220.8 194.2 219.1 190 219.1 185.7C219.1 180.3 223.5 176 228.8 176zM268.3 322.8C262.7 331.1 253.3 336 243.3 336H210.8C200.5 336 192 327.5 192 317.2c0-5.719 2.531-11.06 7-14.64L231.1 276.6l39.37 43.08L268.3 322.8z"],
    "circle-arrow-down": [512, 512, ["arrow-circle-down"], "f0ab", "M342.4 247.7L280 314.9V144c0-13.25-10.75-24-24-24S232 130.8 232 144v170.9L169.6 247.7C160.5 237.9 145.4 237.4 135.7 246.4C125.1 255.4 125.4 270.6 134.4 280.3l104 112C242.1 397.2 249.3 400 256 400s13.03-2.781 17.59-7.656l104-112c9-9.719 8.438-24.91-1.25-33.94C366.6 237.4 351.5 237.9 342.4 247.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-arrow-down-left": [512, 512, [], "e0f9", "M327 151L192 286.1V188.7c0-13.25-10.75-24-24-24s-24 10.75-24 24V344c0 13.25 10.75 24 24 24h155.3c13.25 0 24-10.75 24-24s-10.75-24-24-24H225.9l135-135c9.375-9.375 9.375-24.56 0-33.94S336.4 141.7 327 151zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-arrow-down-right": [512, 512, [], "e0fa", "M344 164.7c-13.25 0-24 10.75-24 24v97.34L184.1 151c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L286.1 320H188.7c-13.25 0-24 10.75-24 24s10.75 24 24 24H344c13.25 0 24-10.75 24-24V188.7C368 175.5 357.3 164.7 344 164.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-arrow-left": [512, 512, ["arrow-circle-left"], "f0a8", "M368 232H197.1l67.21-62.41c9.719-9.062 10.25-24.22 1.25-33.94c-9.031-9.688-24.22-10.25-33.94-1.25l-112 104C114.8 242.1 112 249.3 112 256s2.781 13.03 7.656 17.59l112 104c9.719 9 24.91 8.438 33.94-1.25c9-9.719 8.469-24.88-1.25-33.94L197.1 280H368c13.25 0 24-10.75 24-24S381.3 232 368 232zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-arrow-right": [512, 512, ["arrow-circle-right"], "f0a9", "M280.3 134.4c-9.719-9-24.91-8.438-33.94 1.25c-9 9.719-8.469 24.88 1.25 33.94L314.9 232H144C130.8 232 120 242.8 120 256S130.8 280 144 280h170.9l-67.21 62.41c-9.719 9.062-10.25 24.22-1.25 33.94c9.031 9.688 24.22 10.25 33.94 1.25l112-104C397.2 269 400 262.7 400 256s-2.781-13.03-7.656-17.59L280.3 134.4zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-arrow-up": [512, 512, ["arrow-circle-up"], "f0aa", "M273.6 119.7C269 114.8 262.7 112 256 112S242.1 114.8 238.4 119.7l-104 112c-9 9.719-8.438 24.91 1.25 33.94c9.719 9 24.88 8.469 33.94-1.25L232 197.1V368c0 13.25 10.75 24 24 24s24-10.75 24-24V197.1l62.41 67.21c9.062 9.719 24.22 10.25 33.94 1.25c9.688-9.031 10.25-24.22 1.25-33.94L273.6 119.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-arrow-up-left": [512, 512, [], "e0fb", "M225.9 192h97.36c13.25 0 24-10.75 24-24s-10.75-24-24-24H168C154.8 144 144 154.8 144 168v155.3c0 13.25 10.75 24 24 24s24-10.75 24-24V225.9l135 135C331.7 365.7 337.9 368 344 368s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L225.9 192zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-arrow-up-right": [512, 512, [], "e0fc", "M344 144H188.7c-13.25 0-24 10.75-24 24S175.5 192 188.7 192h97.36l-135 135c-9.375 9.375-9.375 24.56 0 33.94C155.7 365.7 161.9 368 168 368s12.28-2.344 16.97-7.031L320 225.9v97.34c0 13.25 10.75 24 24 24s24-10.75 24-24V168C368 154.8 357.3 144 344 144zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-b": [512, 512, [], "e0fd", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM337.9 247.8C346.7 235.4 352 220.3 352 204C352 162.1 317.9 128 276 128H184C170.8 128 160 138.8 160 152v208C160 373.3 170.8 384 184 384h108c41.91 0 76-34.09 76-76C368 283.4 356.1 261.7 337.9 247.8zM208 176h68c15.44 0 28 12.56 28 28S291.4 232 276 232H208V176zM292 336H208V280h84C307.4 280 320 292.6 320 308S307.4 336 292 336z"],
    "circle-bolt": [512, 512, [], "e0fe", "M352 239.1h-71.25l47.44-105.4c3.062-6.781 1.031-14.81-4.906-19.31c-5.969-4.469-14.22-4.312-19.94 .4687L149.7 243.7C144.6 248 142.7 255.1 144.1 261.4C147.2 267.8 153.2 271.1 159.1 271.1h71.25l-47.44 105.4c-3.062 6.781-1.031 14.81 4.906 19.31C191.6 398.9 194.1 400 198.4 400c3.656 0 7.281-1.25 10.25-3.719l153.6-128c5.156-4.312 7.094-11.41 4.781-17.72C364.8 244.2 358.8 239.1 352 239.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-book-open": [512, 512, ["book-circle"], "e0ff", "M375.2 172.8c-21.23-8.648-41.63-12.94-59.14-12.79C296.1 160.3 281.9 164.9 272 168.1v183c11.81-6.961 50.9-25.71 101.4-3.73C378.4 350.4 384 346.9 384 341.9v-156.3C384 180.1 380.6 175 375.2 172.8zM136.8 172.8C131.4 174.1 128 180.1 128 185.5v156.3c0 5.047 5.643 8.545 10.56 6.405C189.1 326.3 228.2 345 240 352V168.1C230.1 164.9 215 160.3 195.9 160C178.3 159.7 157.1 164.1 136.8 172.8zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-bookmark": [512, 512, ["bookmark-circle"], "e100", "M309.3 144H202.7C187.9 144 176 155.9 176 170.7v165.3c0 13.41 15.52 20.88 25.1 12.49L256 304l54 44.46C320.5 356.8 336 349.4 336 335.1V170.7C336 155.9 324.1 144 309.3 144zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-c": [512, 512, [], "e101", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM310.1 199.4c9.359 9.438 24.55 9.445 33.94 .1328c9.422-9.344 9.484-24.53 .1562-33.94c-48.05-48.47-131.9-48.47-179.9 0c-49.44 49.88-49.44 131 0 180.9C189.2 370.7 221.1 384 255.1 384c.0156 0 0 0 0 0c33.98 0 65.95-13.34 89.96-37.56c9.328-9.438 9.266-24.62-.1562-33.94c-9.391-9.375-24.61-9.25-33.94 .125C296 327.7 276.2 336 255.1 336c-21.09 0-40.92-8.312-55.84-23.38c-30.97-31.22-30.97-82.03 0-113.3C229.1 169.3 281.1 169.2 310.1 199.4z"],
    "circle-calendar": [512, 512, ["calendar-circle"], "e102", "M336 160H320V144C320 135.2 312.8 128 304 128S288 135.2 288 144V160H224V144C224 135.2 216.8 128 208 128S192 135.2 192 144V160H176c-17.67 0-32 14.33-32 32v144c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32V192C368 174.3 353.7 160 336 160zM320 320H192V240h128V320zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-camera": [512, 512, ["camera-circle"], "e103", "M352 160h-36l-6.188-16.44C306.3 134.2 297.4 128 287.4 128H224.6c-10 0-19 6.188-22.5 15.56L196 160H160C142.3 160 128 174.3 128 192v128c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32V192C384 174.3 369.7 160 352 160zM256 304C229.5 304 208 282.5 208 256S229.5 208 256 208s48 21.5 48 48S282.5 304 256 304zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", "M352 208H160c-9.531 0-18.16 5.656-22 14.38C134.2 231.1 135.9 241.3 142.4 248.3l96 104C242.9 357.2 249.3 360 256 360s13.09-2.812 17.62-7.719l96-104c6.469-7 8.188-17.19 4.375-25.91C370.2 213.7 361.5 208 352 208zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-caret-left": [512, 512, ["caret-circle-left"], "f32e", "M289.6 138c-8.719-3.812-18.91-2.094-25.91 4.375l-104 96C154.8 242.9 152 249.3 152 256s2.812 13.09 7.719 17.62l104 96c7 6.469 17.19 8.188 25.91 4.375C298.3 370.2 304 361.5 304 352V160C304 150.5 298.3 141.8 289.6 138zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-caret-right": [512, 512, ["caret-circle-right"], "f330", "M248.3 142.4C241.3 135.9 231.1 134.2 222.4 138C213.7 141.8 208 150.5 208 160v192c0 9.531 5.656 18.16 14.38 22c8.719 3.812 18.91 2.094 25.91-4.375l104-96C357.2 269.1 360 262.7 360 256s-2.812-13.09-7.719-17.62L248.3 142.4zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", "M273.6 159.7C269.1 154.8 262.7 152 256 152S242.9 154.8 238.4 159.7l-96 104c-6.469 7-8.188 17.19-4.375 25.91C141.8 298.3 150.5 304 160 304h192c9.531 0 18.16-5.656 21.1-14.38c3.813-8.719 2.094-18.91-4.375-25.91L273.6 159.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", "M335 175L224 286.1L176.1 239c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l64 64C211.7 341.7 217.8 344 224 344s12.28-2.344 16.97-7.031l128-128c9.375-9.375 9.375-24.56 0-33.94S344.4 165.7 335 175zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-chevron-down": [512, 512, ["chevron-circle-down"], "f13a", "M351 207L256 302.1L160.1 207c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l112 112C243.7 357.7 249.8 360 256 360s12.28-2.344 16.97-7.031l112-112c9.375-9.375 9.375-24.56 0-33.94S360.4 197.7 351 207zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-chevron-left": [512, 512, ["chevron-circle-left"], "f137", "M304.1 127c-9.375-9.375-24.56-9.375-33.94 0l-112 112C154.3 243.7 152 249.8 152 256s2.344 12.28 7.031 16.97l112 112c9.375 9.375 24.56 9.375 33.94 0s9.375-24.56 0-33.94L209.9 256l95.03-95.03C314.3 151.6 314.3 136.4 304.1 127zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-chevron-right": [512, 512, ["chevron-circle-right"], "f138", "M240.1 127c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L302.1 256l-95.03 95.03c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0l112-112C357.7 268.3 360 262.2 360 256s-2.344-12.28-7.031-16.97L240.1 127zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", "M272.1 159C268.3 154.3 262.2 152 256 152S243.7 154.3 239 159l-112 112c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L256 209.9l95.03 95.03c9.375 9.375 24.56 9.375 33.94 0s9.375-24.56 0-33.94L272.1 159zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-d": [512, 512, [], "e104", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM254.4 128H184C170.8 128 160 138.8 160 152v208C160 373.3 170.8 384 184 384h70.41C325.9 384 384 326.6 384 256C384 185.4 325.9 128 254.4 128zM254.4 336H208v-160h46.41C299.4 176 336 211.9 336 256C336 300.1 299.4 336 254.4 336z"],
    "circle-dashed": [512, 512, [], "e105", "M52.51 298.6C50.29 287.1 41.53 280 30.67 280H27c-14.23 0-24.61 13.21-21.77 27.16c6.648 32.71 19.53 63.17 37.38 90.08c7.84 11.82 24.49 13.7 34.52 3.674l2.613-2.613c7.695-7.693 8.264-19.56 2.295-28.65C68.07 348.3 57.9 324.3 52.51 298.6zM77.14 111.1C67.11 101.1 50.46 102.9 42.62 114.8C24.76 141.7 11.88 172.1 5.232 204.8C2.396 218.8 12.77 232 27 232h3.672c10.86 0 19.61-7.965 21.84-18.59c5.387-25.75 15.56-49.75 29.54-71.05c5.969-9.1 5.4-20.96-2.295-28.66L77.14 111.1zM459.5 213.4C461.7 224 470.5 232 481.3 232h3.672c14.23 0 24.61-13.21 21.77-27.16c-6.648-32.71-19.53-63.17-37.38-90.08c-7.84-11.82-24.49-13.7-34.52-3.672l-2.613 2.611c-7.695 7.695-8.264 19.56-2.295 28.66C443.9 163.7 454.1 187.7 459.5 213.4zM213.4 459.5c-25.76-5.391-49.76-15.56-71.07-29.54c-9.1-5.969-20.96-5.4-28.66 2.293l-2.613 2.613c-10.03 10.03-8.145 26.68 3.672 34.52c26.91 17.86 57.38 30.75 90.1 37.4C218.8 509.6 232 499.2 232 484.1v-3.674C232 470.5 224 461.7 213.4 459.5zM307.2 5.232C293.2 2.396 280 12.77 280 27v3.672c0 10.86 7.963 19.61 18.59 21.84c25.76 5.389 49.76 15.56 71.07 29.54c9.1 5.969 20.96 5.402 28.66-2.293l2.613-2.611c10.03-10.03 8.145-26.68-3.672-34.52C370.3 24.77 339.9 11.88 307.2 5.232zM204.8 5.232C172.1 11.88 141.7 24.77 114.7 42.63C102.9 50.47 101 67.12 111.1 77.15l2.613 2.611c7.695 7.695 19.56 8.262 28.66 2.293c21.31-13.98 45.31-24.15 71.07-29.54C224 50.29 232 41.53 232 30.67V27C232 12.77 218.8 2.396 204.8 5.232zM484.1 280h-3.672c-10.86 0-19.61 7.963-21.84 18.59c-5.387 25.75-15.56 49.75-29.54 71.05c-5.969 9.098-5.4 20.96 2.295 28.65l2.613 2.613c10.03 10.03 26.68 8.143 34.52-3.674c17.85-26.9 30.74-57.37 37.38-90.08C509.6 293.2 499.2 280 484.1 280zM398.3 432.2c-7.695-7.693-19.56-8.262-28.66-2.293c-21.31 13.98-45.31 24.15-71.07 29.54C287.1 461.7 280 470.5 280 481.3v3.674c0 14.23 13.21 24.6 27.16 21.77c32.72-6.65 63.19-19.54 90.1-37.4c11.82-7.84 13.7-24.49 3.672-34.52L398.3 432.2z"],
    "circle-divide": [512, 512, [], "e106", "M256 192c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32S224 142.3 224 160C224 177.7 238.3 192 256 192zM256 320c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C288 334.3 273.7 320 256 320zM352 232h-192C146.7 232 136 242.7 136 256c0 13.25 10.75 24 24 24h192C365.3 280 376 269.3 376 256C376 242.7 365.3 232 352 232zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256S512 397.4 512 256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-dollar": [512, 512, ["dollar-circle", "usd-circle"], "f2e8", "M262 232.8L253.8 230.5C213.9 219.7 215.1 213.6 216.4 206.6c2.234-11.92 24.88-17.83 52.48-13.92c7.188 1.047 16.28 3.344 27.81 7.016c12.66 4.109 26.16-2.922 30.16-15.56c4.031-12.62-2.938-26.12-15.56-30.16c-12.37-3.955-22.26-6.373-31.23-7.939V128c0-13.25-10.75-24-24-24s-24 10.75-24 24v17.22C198.3 150.6 174.6 169.3 169.2 197.7c-10.62 56.73 47.28 72.44 72 79.16l8.594 2.281c43.95 11.61 47.58 16.67 45.78 26.28c-2.25 11.92-24.86 17.86-52.63 13.91C231.8 317.8 217.1 313.2 205.9 309.2L199.5 307c-12.67-4.109-26.17 2.734-30.28 15.34c-4.125 12.59 2.75 26.14 15.34 30.28l6.188 2.047c12.84 4.281 27.23 8.797 41.34 11.24V384c0 13.25 10.75 24 24 24s24-10.75 24-24v-17.19c33.68-5.404 57.38-24.12 62.72-52.53C353.5 256.9 296.3 241.8 262 232.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-dollar-to-slot": [512, 512, ["donate"], "f4b9", "M279.7 247.7c.8125-4.75 1.312-7.578-30.34-16.64l-6.5-1.875C224.7 223.8 176.4 209.6 184.1 160.1c4.105-23.88 21.79-39.91 47.06-45.62V104c0-13.25 10.74-24 23.99-24s24.01 10.75 24.01 24v11.25c5.9 1.363 12.21 3.092 19.81 5.719c12.53 4.344 19.16 18 14.84 30.53C310.4 164 296.7 170.6 284.2 166.3c-8.281-2.875-14.72-4.641-19.66-5.422c-16.88-2.641-31.06 .6094-32.22 7.391C231.6 172.4 231 175.6 256.4 183.1l6.188 1.797c25.53 7.297 73.13 20.91 64.44 70.95c-4.115 23.86-21.73 39.99-47 45.71V312c0 13.25-10.76 24-24.01 24s-23.99-10.75-23.99-24V300.6C222.5 298.4 213.1 295.3 204.6 292.3L199.1 290.6C187.5 286.2 180.9 272.5 185.4 259.1s18.12-19.02 30.66-14.61l4.875 1.75C229.7 250.3 239.7 253.9 247.3 255C264.5 257.8 278.6 254.5 279.7 247.7zM48 208C48 93.13 141.1 0 256 0s208 93.13 208 208S370.9 416 256 416S48 322.9 48 208zM96 208c0 88.22 71.78 160 160 160s160-71.78 160-160s-71.78-160-160-160S96 119.8 96 208zM460.6 352c-13.25 0-24 10.75-24 24s10.75 24 24 24C462.5 400 464 401.5 464 403.4V456c0 4.406-3.594 8-8 8H56c-4.406 0-8-3.594-8-8v-52.58C48 401.5 49.53 400 51.41 400c13.25 0 24-10.75 24-24s-10.75-24-24-24C23.06 352 0 375.1 0 403.4V456C0 486.9 25.13 512 56 512h400c30.88 0 56-25.12 56-56v-52.58C512 375.1 488.9 352 460.6 352z"],
    "circle-dot": [512, 512, [61842, "dot-circle"], "1f518", "M256 160C203 160 160 203 160 256c0 52.95 43.05 96 96 96s96-43.05 96-96C352 203 308.1 160 256 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-down": [512, 512, [61466, "arrow-alt-circle-down"], "f358", "M344 240h-56L287.1 152c0-13.25-10.75-24-24-24h-16C234.7 128 223.1 138.8 223.1 152L224 240h-56c-9.531 0-18.16 5.656-22 14.38C142.2 263.1 143.9 273.3 150.4 280.3l88.75 96C243.7 381.2 250.1 384 256.8 384c7.781-.3125 13.25-2.875 17.75-7.844l87.25-96c6.406-7.031 8.031-17.19 4.188-25.88S353.5 240 344 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-down-left": [512, 512, [], "e107", "M340.9 159.8c-9.369-9.371-24.57-9.373-33.94-.002L242.3 224.4L200.1 183C196.4 178.4 190.2 176 184 176c-3.094 0-6.219 .5938-9.188 1.812C165.8 181.5 160 190.3 160 200v128C160 341.3 170.8 352 184 352h128c9.703 0 18.45-5.844 22.17-14.81s1.656-19.28-5.203-26.16l-41.37-41.38l64.57-64.57c9.369-9.371 9.369-24.57 0-33.94L340.9 159.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-down-right": [512, 512, [], "e108", "M337.2 177.8C334.2 176.6 331.1 176 328 176c-6.234 0-12.38 2.438-16.97 7.031l-41.37 41.38L205.1 159.8C195.7 150.5 180.5 150.5 171.1 159.8L159.8 171.1c-9.369 9.367-9.369 24.57 0 33.94l64.57 64.57L183 311c-6.859 6.875-8.922 17.19-5.203 26.16S190.3 352 200 352h128c13.25 0 24-10.75 24-24v-128C352 190.3 346.2 181.5 337.2 177.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-e": [512, 512, [], "e109", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM328 176C341.3 176 352 165.3 352 152S341.3 128 328 128h-144C170.8 128 160 138.8 160 152v208C160 373.3 170.8 384 184 384h144c13.25 0 24-10.75 24-24s-10.75-24-24-24H208V280h88C309.3 280 320 269.3 320 256s-10.75-24-24-24H208V176H328z"],
    "circle-ellipsis": [512, 512, [], "e10a", "M256 224C238.3 224 224 238.3 224 256c0 17.67 14.33 32 32 32s32-14.33 32-32C288 238.3 273.7 224 256 224zM368 224c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C400 238.3 385.7 224 368 224zM144 224c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C176 238.3 161.7 224 144 224zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256S512 397.4 512 256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-ellipsis-vertical": [512, 512, [], "e10b", "M256 336c-17.67 0-32 14.33-32 32s14.33 32 32 32c17.67 0 32-14.33 32-32S273.7 336 256 336zM256 224C238.3 224 224 238.3 224 256s14.33 32 32 32c17.67 0 32-14.33 32-32S273.7 224 256 224zM256 112c-17.67 0-32 14.33-32 32s14.33 32 32 32c17.67 0 32-14.33 32-32S273.7 112 256 112zM256 0c-141.4 0-255.1 114.6-255.1 256S114.6 511.1 256 511.1s256-114.6 256-255.1S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-envelope": [512, 512, ["envelope-circle"], "e10c", "M256 288C253.1 288 251.1 287.6 250.1 286.9L128 238V320c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32V238l-122.1 48.82C260 287.6 258 288 256 288zM352 160H160C142.3 160 128 174.3 128 192v11.57l128 51.2l128-51.2V192C384 174.3 369.7 160 352 160zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-exclamation": [512, 512, ["exclamation-circle"], "f06a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 304c13.25 0 24-10.75 24-24v-128C280 138.8 269.3 128 256 128S232 138.8 232 152v128C232 293.3 242.8 304 256 304zM256 337.1c-17.36 0-31.44 14.08-31.44 31.44C224.6 385.9 238.6 400 256 400s31.44-14.08 31.44-31.44C287.4 351.2 273.4 337.1 256 337.1z"],
    "circle-exclamation-check": [576, 512, [], "e10d", "M256 304c13.25 0 24-10.75 24-24v-128C280 138.8 269.3 128 256 128S232 138.8 232 152v128C232 293.3 242.8 304 256 304zM256 400c17.36 0 31.44-14.08 31.44-31.44c0-17.36-14.07-31.44-31.44-31.44s-31.44 14.08-31.44 31.44C224.6 385.9 238.6 400 256 400zM568.3 166.4c-9.703-9-24.91-8.453-33.92 1.266l-87.05 93.75l-38.39-38.39c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l56 56C435.5 317.5 441.6 320 447.1 320h.4375c6.531-.125 12.72-2.891 17.16-7.672l103.1-112C578.6 190.6 578 175.4 568.3 166.4zM462.8 364c-11.06-7.406-25.94-4.312-33.25 6.75C390.8 429.1 325.9 464 256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48c81.34 0 155.7 47.88 189.4 121.9c5.531 12.12 19.84 17.41 31.78 11.91c12.06-5.5 17.41-19.72 11.91-31.78C447.6 58.91 356.1-.0187 256-.0187c-141.2 0-256 114.8-256 256s114.8 256 256 256c86.06 0 165.9-42.89 213.5-114.7C476.8 386.2 473.8 371.3 462.8 364z"],
    "circle-f": [512, 512, [], "e10e", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM328 128h-144C170.8 128 160 138.8 160 152v208C160 373.3 170.8 384 184 384s24-10.75 24-24V288h88C309.3 288 320 277.3 320 264S309.3 240 296 240H208v-64h120C341.3 176 352 165.3 352 152S341.3 128 328 128z"],
    "circle-g": [512, 512, [], "e10f", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM360 240h-80C266.8 240 256 250.8 256 264S266.8 288 280 288h50.47c-4.219 8.578-10.31 16.97-17.91 24.58c-30.19 30.22-82.94 30.22-113.1 0c-31.19-31.2-31.19-81.95 0-113.2C229.7 169.2 280.1 167.8 312 196.4c9.812 8.859 25 8.078 33.88-1.859c8.844-9.875 8-25.05-1.875-33.89c-50.53-45.3-130.6-43.06-178.5 4.875c-49.91 49.91-49.91 131.1 0 181C189.7 370.7 221.8 384 256 384s66.34-13.31 90.5-37.48c19.53-19.56 32.72-43.44 37.09-67.27C383.9 277.8 384 276.4 384 274.9V264C384 250.8 373.3 240 360 240z"],
    "circle-h": [512, 512, [62590, "hospital-symbol"], "24bd", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM344 128C330.8 128 320 138.8 320 152v80H192v-80C192 138.8 181.3 128 168 128S144 138.8 144 152v208C144 373.3 154.8 384 168 384S192 373.3 192 360v-80h128v80c0 13.25 10.75 24 24 24s24-10.75 24-24v-208C368 138.8 357.3 128 344 128z"],
    "circle-half": [512, 512, [], "e110", "M248.1 7.414C243.1 2.867 236.5 .7109 229.5 1.352C98.69 14.8 0 124.3 0 255.1s98.69 241.2 229.5 254.6C230.4 510.7 231.2 510.8 232 510.8c5.906 0 11.66-2.188 16.09-6.188C253.1 500 256 493.6 256 486.8V25.23C256 18.43 253.1 11.96 248.1 7.414zM208 458.5c-92.88-21.73-160-104.5-160-202.5s67.13-180.7 160-202.5V458.5z"],
    "circle-half-stroke": [512, 512, [61506, "adjust"], "25d0", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464v-416c114.7 0 208 93.31 208 208S370.7 464 256 464z"],
    "circle-heart": [512, 512, ["heart-circle"], "f4c7", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 170.6C224.8 146.2 180.3 145.6 150.5 170.7C132.3 185.8 121.2 208 120.1 231.6C118.9 255.2 127.8 278.3 144.3 295.1l84.72 85.75C236.3 388 245.8 392 255.1 392c10.16-.0313 19.78-4.031 26.94-11.28l84.69-85.66c16.53-16.66 25.41-39.72 24.31-63.28c-1.062-23.59-12.06-45.84-30.19-61.03C331.8 145.7 287.2 146.1 256 170.6zM333.5 261.3l-77.56 78.44L178.5 261.3C171.3 254.1 167.5 244.1 168 233.9c.5-10.34 5.156-19.66 13.19-26.34C187.3 202.5 194.8 200 202.5 200c9.906 0 20.16 4.062 28 12.03l25.66 25.28l25.59-25.5C295.5 197.9 317.1 196 330.9 207.6c7.938 6.656 12.59 16.03 13.06 26.41C344.4 244.3 340.7 254 333.5 261.3z"],
    "circle-i": [512, 512, [], "e111", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM328 176C341.3 176 352 165.3 352 152S341.3 128 328 128h-144C170.8 128 160 138.8 160 152S170.8 176 184 176h48v160h-48C170.8 336 160 346.8 160 360S170.8 384 184 384h144c13.25 0 24-10.75 24-24s-10.75-24-24-24h-48v-160H328z"],
    "circle-info": [512, 512, ["info-circle"], "f05a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM296 336h-16V248C280 234.8 269.3 224 256 224H224C210.8 224 200 234.8 200 248S210.8 272 224 272h8v64h-16C202.8 336 192 346.8 192 360S202.8 384 216 384h80c13.25 0 24-10.75 24-24S309.3 336 296 336zM256 192c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32S224 142.3 224 160C224 177.7 238.3 192 256 192z"],
    "circle-j": [512, 512, [], "e112", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM312 128C298.8 128 288 138.8 288 152v138.7C288 315.7 266.5 336 240 336S192 315.7 192 290.7V280C192 266.8 181.3 256 168 256S144 266.8 144 280v10.67C144 342.1 187.1 384 240 384s96-41.86 96-93.33V152C336 138.8 325.3 128 312 128z"],
    "circle-k": [512, 512, [], "e113", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM345.1 135.2c-9.266-9.422-24.48-9.547-33.94-.25L208 236.5V152C208 138.8 197.3 128 184 128S160 138.8 160 152v208C160 373.3 170.8 384 184 384s24-10.75 24-24V303.9l30.89-30.42l69.38 100.2C312.9 380.4 320.4 384 328 384c4.719 0 9.484-1.375 13.64-4.266c10.91-7.547 13.62-22.5 6.078-33.39l-72-104c-.7324-1.057-1.805-1.662-2.666-2.564l71.78-70.69C354.3 159.8 354.4 144.6 345.1 135.2z"],
    "circle-l": [512, 512, [], "e114", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM328 336H208V152C208 138.8 197.3 128 184 128S160 138.8 160 152v208C160 373.3 170.8 384 184 384h144c13.25 0 24-10.75 24-24S341.3 336 328 336z"],
    "circle-left": [512, 512, [61840, "arrow-alt-circle-left"], "f359", "M360 224L272 224v-56c0-9.531-5.656-18.16-14.38-22C248.9 142.2 238.7 143.9 231.7 150.4l-96 88.75C130.8 243.7 128 250.1 128 256.8c.3125 7.781 2.875 13.25 7.844 17.75l96 87.25c7.031 6.406 17.19 8.031 25.88 4.188s14.28-12.44 14.28-21.94l-.002-56L360 288C373.3 288 384 277.3 384 264v-16C384 234.8 373.3 224 360 224zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-location-arrow": [576, 512, ["location-circle"], "f602", "M361.3 153.8l-196 84c-9.562 4.094-14.98 14.47-12.89 24.62C154.5 272.6 163.6 280 173.1 280H264v90c0 10.41 7.391 19.5 17.62 21.59C283.1 391.9 284.6 392 285.1 392c8.797 0 16.73-5.219 20.23-13.31l84-196c3.562-8.344 1.719-17.86-4.656-24.2C379.3 152.1 369.8 150.3 361.3 153.8zM288 0C146.6 0 32 114.6 32 256s114.6 256 256 256s256-114.6 256-256S429.4 0 288 0zM288 464c-114.7 0-208-93.31-208-208S173.3 48 288 48s208 93.31 208 208S402.7 464 288 464z"],
    "circle-m": [512, 512, [], "e115", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM367.4 129.2c-9.953-3.25-20.75 .3125-26.84 8.781L256 255L171.5 137.1C165.4 129.5 154.5 125.9 144.6 129.2C134.7 132.4 128 141.6 128 152v208C128 373.3 138.8 384 152 384s24-10.75 24-24V226.2l60.55 83.83c9.031 12.5 29.88 12.5 38.91 0L336 226.2V360c0 13.25 10.75 24 24 24S384 373.3 384 360v-208C384 141.6 377.3 132.4 367.4 129.2z"],
    "circle-microphone": [512, 512, ["microphone-circle"], "e116", "M256 304c26.52 0 48-21.48 48-48V144C304 117.5 282.5 96 256 96S208 117.5 208 144V256C208 282.5 229.5 304 256 304zM360 232c-13.25 0-24 10.75-24 24c0 44.11-35.89 80-80 80S176 300.1 176 256c0-13.25-10.75-24-24-24S128 242.8 128 256c0 62.36 44.88 114.3 104 125.6V392C232 405.3 242.8 416 256 416s24-10.75 24-24v-10.43C339.1 370.3 384 318.4 384 256C384 242.8 373.3 232 360 232zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-microphone-lines": [512, 512, ["microphone-circle-alt"], "e117", "M360 232c-13.25 0-24 10.75-24 24c0 44.11-35.89 80-80 80S176 300.1 176 256c0-13.25-10.75-24-24-24S128 242.8 128 256c0 62.36 44.88 114.3 104 125.6V392C232 405.3 242.8 416 256 416s24-10.75 24-24v-10.43C339.1 370.3 384 318.4 384 256C384 242.8 373.3 232 360 232zM256 304c26.52 0 48-21.48 48-48V224h-24c-4.418 0-8-3.582-8-8s3.582-8 8-8h24v-32h-24c-4.418 0-8-3.582-8-8S275.6 160 280 160h24V144C304 117.5 282.5 96 256 96S208 117.5 208 144V256C208 282.5 229.5 304 256 304zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-minus": [512, 512, ["minus-circle"], "f056", "M352 232h-192C146.7 232 136 242.7 136 256c0 13.25 10.75 24 24 24h192C365.3 280 376 269.3 376 256C376 242.7 365.3 232 352 232zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256S512 397.4 512 256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-n": [512, 512, [], "e118", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM328 128c-13.25 0-24 10.75-24 24v131.2L203.7 138.3c-5.953-8.641-16.88-12.31-26.89-9.25C166.8 132.2 160 141.5 160 152v208C160 373.3 170.8 384 184 384s24-10.75 24-24V228.8l100.3 144.8C312.8 380.3 320.3 384 328 384c2.391 0 4.797-.3594 7.156-1.094C345.2 379.8 352 370.5 352 360v-208C352 138.8 341.3 128 328 128z"],
    "circle-notch": [512, 512, [], "f1ce", "M256 512c-141.2 0-256-114.8-256-256c0-113.7 76.25-214.9 185.4-246.1c12.59-3.656 26.03 3.719 29.66 16.47c3.656 12.75-3.719 26.03-16.47 29.69C109.9 81.41 48 163.6 48 256c0 114.7 93.31 208 208 208s208-93.31 208-208c0-92.36-61.94-174.6-150.6-199.1c-12.75-3.656-20.12-16.94-16.47-29.69c3.625-12.75 17.06-20.08 29.66-16.47C435.8 41.13 512 142.3 512 256C512 397.2 397.2 512 256 512z"],
    "circle-o": [512, 512, [], "e119", "M256 128C185.4 128 128 185.4 128 256s57.42 128 128 128s128-57.42 128-128S326.6 128 256 128zM256 336c-44.11 0-80-35.89-80-80S211.9 176 256 176s80 35.89 80 80S300.1 336 256 336zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-p": [512, 512, [], "e11a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM280 128h-96C170.8 128 160 138.8 160 152v208C160 373.3 170.8 384 184 384s24-10.75 24-24V304h72c48.53 0 88-39.47 88-88S328.5 128 280 128zM280 256H208V176h72C302.1 176 320 193.9 320 216S302.1 256 280 256z"],
    "circle-parking": [512, 512, ["parking-circle"], "f615", "M272 128H184C170.8 128 160 138.8 160 152v208C160 373.3 170.8 384 184 384s24-10.75 24-24V320h64c52.94 0 96-43.06 96-96S324.9 128 272 128zM272 272h-64v-96h64C298.5 176 320 197.5 320 224S298.5 272 272 272zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", "M200 160C186.8 160 176 170.8 176 184v144C176 341.3 186.8 352 200 352S224 341.3 224 328v-144C224 170.8 213.3 160 200 160zM312 160C298.8 160 288 170.8 288 184v144c0 13.25 10.75 24 24 24s24-10.75 24-24v-144C336 170.8 325.3 160 312 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-phone": [512, 512, ["phone-circle"], "e11b", "M374.5 303.6l-54.24-23.25c-6.391-2.766-13.9-.9062-18.24 4.484l-22.02 26.91c-34.63-17-62.77-45.14-79.77-79.75L227.2 209.1c5.375-4.391 7.211-11.83 4.492-18.22L208.4 137.5C205.4 130.5 197.8 126.7 190.5 128.4L140.1 140C132.1 141.7 127.1 147.9 127.1 155.2c0 126.1 102.6 228.8 228.7 228.8c7.336 0 13.6-4.984 15.24-12.11l11.62-50.39C385.3 314.2 381.5 306.6 374.5 303.6zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-phone-flip": [512, 512, ["phone-circle-alt"], "e11c", "M371.9 140l-50.38-11.62c-7.344-1.703-14.88 2.109-17.93 9.062L280.3 191.7c-2.719 6.391-.8828 13.83 4.492 18.22l26.91 22.05c-16.99 34.61-45.14 62.75-79.77 79.75L209.9 284.9C205.6 279.5 198.1 277.6 191.7 280.4L137.5 303.6c-6.953 3-10.74 10.58-9.055 17.88l11.62 50.39c1.633 7.125 7.9 12.11 15.24 12.11c126.1 0 228.7-102.6 228.7-228.8C384 147.9 379 141.7 371.9 140zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-phone-hangup": [512, 512, ["phone-circle-down"], "e11d", "M417.7 236.7C328.6 147.5 183.4 147.5 94.25 236.7c-5.188 5.188-6.088 13.14-2.205 19.33l27.41 43.85c3.965 6.354 12.03 9.05 19.06 6.253l54.82-21.92c6.475-2.562 10.46-9.18 9.717-16.06L199.6 233.6c36.5-12.46 76.31-12.46 112.8-.0003l-3.446 34.61c-.6973 6.904 3.275 13.47 9.717 16.06l54.82 21.92c7.07 2.762 15.08 .1433 19.06-6.253l27.41-43.85C423.8 249.9 422.9 241.9 417.7 236.7zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-play": [512, 512, [61469, "play-circle"], "f144", "M228.5 147.5C224.7 145.2 220.3 144 216 144C202.2 144 192 155.3 192 168v176c0 12.8 10.31 24 24 24c4.344 0 8.68-1.18 12.52-3.523l144-88C379.6 272.1 384 264.4 384 256c0-8.359-4.352-16.12-11.48-20.48L228.5 147.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-plus": [512, 512, ["plus-circle"], "f055", "M352 232H280V160c0-13.26-10.74-24-23.1-24S232 146.7 232 160v72H160C146.7 232 136 242.7 136 256c0 13.25 10.75 24 24 24H232V352c0 13.25 10.75 24 24 24S280 365.3 280 352V280h72C365.3 280 376 269.3 376 256C376 242.7 365.3 232 352 232zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256S512 397.4 512 256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-q": [512, 512, [], "e11e", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 128C185.4 128 128 185.4 128 256s57.41 128 128 128c26.64 0 51.37-8.209 71.88-22.18l15.15 15.15C347.7 381.7 353.8 384 360 384s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94l-15.15-15.15C375.8 307.4 384 282.6 384 256C384 185.4 326.6 128 256 128zM326.7 292.7l-29.69-29.69c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l29.69 29.69C281.7 332.4 269.3 336 256 336c-44.13 0-80-35.89-80-80S211.9 176 256 176s80 35.89 80 80C336 269.3 332.4 281.7 326.7 292.7z"],
    "circle-quarter": [512, 512, [], "e11f", "M248.1 7.422C243 2.875 236.5 .7187 229.5 1.359C109.7 13.69 13.69 109.7 1.375 229.5c-.6875 6.766 1.5 13.48 6.062 18.53S18.47 256 25.25 256H232C245.3 256 256 245.3 256 232V25.23C256 18.44 253.1 11.97 248.1 7.422zM208 208H53.59C71.63 131.9 131.9 71.64 208 53.58V208z"],
    "circle-question": [512, 512, [62108, "question-circle"], "f059", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 336c-18 0-32 14-32 32s13.1 32 32 32c17.1 0 32-14 32-32S273.1 336 256 336zM289.1 128h-51.1C199 128 168 159 168 198c0 13 11 24 24 24s24-11 24-24C216 186 225.1 176 237.1 176h51.1C301.1 176 312 186 312 198c0 8-4 14.1-11 18.1L244 251C236 256 232 264 232 272V288c0 13 11 24 24 24S280 301 280 288V286l45.1-28c21-13 34-36 34-60C360 159 329 128 289.1 128z"],
    "circle-r": [512, 512, [], "e120", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM368 208C368 163.9 332.1 128 288 128H184C170.8 128 160 138.8 160 152v208C160 373.3 170.8 384 184 384s24-10.75 24-24V288h45.97l62.63 86.11C321.3 380.6 328.6 384 336 384c4.875 0 9.812-1.484 14.09-4.594c10.72-7.797 13.09-22.8 5.281-33.52l-44.77-61.55C343.7 274.5 368 244.2 368 208zM288 240H208v-64H288c17.66 0 32 14.36 32 32S305.7 240 288 240z"],
    "circle-radiation": [512, 512, [63418, "radiation-alt"], "2622", "M256 16C123.5 16 16 123.5 16 256s107.5 240 240 240s240-107.5 240-240S388.5 16 256 16zM256 448c-105.9 0-192-86.13-192-192s86.13-192 192-192s192 86.13 192 192S361.9 448 256 448zM226.4 208.6L184.8 141.9C179.6 133.7 168.3 132 160.7 138.2C130.8 162.3 110.1 197.4 105.1 237.4C103.9 247.2 111.2 256 121 256H200C200 236 210.6 218.6 226.4 208.6zM256 288c17.67 0 32-14.33 32-32s-14.33-32-32-32C238.3 224 224 238.3 224 256S238.3 288 256 288zM285.6 303.3C276.1 308.7 266.9 312 256 312c-10.89 0-20.98-3.252-29.58-8.65l-41.74 66.8c-5.211 8.338-1.613 19.07 7.27 23.29C211.4 402.7 233.1 408 256 408c22.97 0 44.64-5.334 64.12-14.59c8.883-4.219 12.48-14.95 7.262-23.29L285.6 303.3zM351.4 138.2c-7.604-6.145-18.86-4.518-24.04 3.77l-41.71 66.67C301.4 218.6 312 236 312 256h78.96c9.844 0 17.11-8.791 15.91-18.56C401.9 197.5 381.3 162.4 351.4 138.2z"],
    "circle-right": [512, 512, [61838, "arrow-alt-circle-right"], "f35a", "M280.2 150.2C273.1 143.8 262.1 142.2 254.3 146.1S239.1 158.5 239.1 167.1l.002 56L152 224C138.8 224 128 234.8 128 248v16C128 277.3 138.8 288 152 288L240 287.1v56c0 9.531 5.656 18.16 14.38 22c8.75 3.812 18.91 2.094 25.91-4.375l96-88.75C381.2 268.3 384 261.9 384 255.2c-.3125-7.781-2.875-13.25-7.844-17.75L280.2 150.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-s": [512, 512, [], "e121", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM262.4 232.9C212.5 219.1 205.7 212.4 208.5 196.6c1.031-5.688 4.156-10.27 9.344-13.61c8.594-5.547 30.84-12.88 83.63 .5781c12.81 3.297 25.94-4.469 29.19-17.31c3.281-12.84-4.469-25.92-17.31-29.19c-53.66-13.69-94.47-11.81-121.5 5.562C175.5 153.2 164.7 169.4 161.3 188.2c-11.28 63.38 48.66 80 88.31 91c49.94 13.86 56.69 20.53 53.88 36.31c-1.312 7.312-4.344 11.81-10.12 15.06c-18.09 10.09-58.5 5.844-100.6-10.7c-12.22-4.75-26.28 1.188-31.12 13.58c-4.844 12.33 1.219 26.27 13.56 31.11c18.31 7.172 54.88 19.48 90.63 19.48c18 0 35.78-3.109 50.94-11.58c18.38-10.28 30.09-27.06 33.94-48.53C361.1 260.6 302.1 243.9 262.4 232.9z"],
    "circle-small": [320, 512, [], "e122", "M160 96C71.63 96 0 167.6 0 256c0 88.37 71.63 160 160 160c88.37 0 160-71.63 160-160C320 167.6 248.4 96 160 96zM160 368c-61.76 0-112-50.24-112-112c0-61.76 50.24-112 112-112c61.76 0 112 50.24 112 112C272 317.8 221.8 368 160 368z"],
    "circle-sort": [512, 512, ["sort-circle"], "e030", "M347.5 272h-183C148 272 139.9 291.9 151.4 303.4L243 394.6C246.5 398 251.1 400 256 400s9.625-2 13.12-5.375l91.5-91.25C372.1 291.9 364 272 347.5 272zM269.1 117.4C265.6 114 260.9 112 256 112S246.5 114 243 117.4L151.4 208.6C139.9 220.1 148 240 164.5 240h183c16.5 0 24.62-19.88 13.12-31.38L269.1 117.4zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-sort-down": [512, 512, ["sort-circle-down"], "e031", "M269.1 117.4C265.6 114 260.9 112 256 112S246.5 114 243 117.4L151.4 208.6C139.9 220.1 148 240 164.5 240h183c16.5 0 24.62-19.88 13.12-31.38L269.1 117.4zM197.3 208l58.7-58.47L314.7 208H197.3zM347.5 272h-183C148 272 139.9 291.9 151.4 303.4L243 394.6C246.5 398 251.1 400 256 400s9.625-2 13.12-5.375l91.5-91.25C372.1 291.9 364 272 347.5 272zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-sort-up": [512, 512, ["sort-circle-up"], "e032", "M269.1 117.4C265.6 114 260.9 112 256 112S246.5 114 243 117.4L151.4 208.6C139.9 220.1 148 240 164.5 240h183c16.5 0 24.62-19.88 13.12-31.38L269.1 117.4zM347.5 272h-183C148 272 139.9 291.9 151.4 303.4L243 394.6C246.5 398 251.1 400 256 400s9.625-2 13.12-5.375l91.5-91.25C372.1 291.9 364 272 347.5 272zM256.1 362.5L197.3 304h117.3L256.1 362.5zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-star": [512, 512, ["star-circle"], "e123", "M391.3 200.5l-82.33-11.98L272.2 114C268.9 107.4 262.4 103.1 255.1 104c-6.41 0-12.82 3.318-16.13 10.02L203 188.5L120.7 200.5C105.9 202.6 100 220.8 110.7 231.2l59.57 57.93l-14.09 81.83C154.2 382.6 163.5 392 173.1 392c2.773 0 5.629-.6602 8.371-2.109L256 351.2l73.65 38.64c2.736 1.436 5.582 2.088 8.352 2.088c10.46 0 19.8-9.34 17.8-21.04l-14.09-81.83l59.57-57.93C411.1 220.8 406.1 202.6 391.3 200.5zM298.2 319.2l-34.75-18.23c-4.654-2.443-10.21-2.443-14.87 0L213.8 319.2l6.637-38.55c.8945-5.201-.832-10.51-4.613-14.19L187.8 239.2l38.74-5.639C231.8 232.8 236.3 229.5 238.6 224.8L256 189.6l17.39 35.18c2.33 4.717 6.832 7.986 12.04 8.744l38.75 5.639l-28.01 27.24c-3.781 3.678-5.508 8.984-4.613 14.19L298.2 319.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M328 160h-144C170.8 160 160 170.8 160 184v144C160 341.2 170.8 352 184 352h144c13.2 0 24-10.8 24-24v-144C352 170.8 341.2 160 328 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-t": [512, 512, [], "e124", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM360 144h-208C138.8 144 128 154.8 128 168S138.8 192 152 192h80v168C232 373.3 242.8 384 256 384s24-10.75 24-24V192h80C373.3 192 384 181.3 384 168S373.3 144 360 144z"],
    "circle-three-quarters": [512, 512, [], "e125", "M256 512c-141.2 0-256-114.8-256-256c0-131.7 98.69-241.2 229.5-254.6c7.031-.6406 13.53 1.516 18.56 6.062S256 18.44 256 25.23V256h230.8c6.781 0 13.28 2.875 17.81 7.922c4.562 5.047 6.75 11.78 6.062 18.53C497.2 413.3 387.7 512 256 512zM208 53.53C115.1 75.27 48 158.1 48 256c0 114.7 93.31 208 208 208c97.94 0 180.8-67.14 202.4-160H232C218.8 304 208 293.3 208 280V53.53z"],
    "circle-trash": [512, 512, ["trash-circle"], "e126", "M170.6 361.5C171.4 373.9 182.1 384 194.5 384h122.9c12.44 0 23.17-10.08 23.95-22.5L351 208h-190L170.6 361.5zM352 144h-48l-5.789-11.58C296.9 129.7 294.1 128 291.1 128H220.9C217.9 128 215.1 129.7 213.8 132.4L208 144H160C151.2 144 144 151.2 144 160c0 8.836 7.164 16 16 16h192c8.838 0 16-7.164 16-16C368 151.2 360.8 144 352 144zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-u": [512, 512, [], "e127", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM344 144C330.8 144 320 154.8 320 168v122.9C320 324.6 291.3 352 256 352s-64-27.41-64-61.09V168C192 154.8 181.3 144 168 144S144 154.8 144 168v122.9C144 351.1 194.3 400 256 400s112-48.94 112-109.1V168C368 154.8 357.3 144 344 144z"],
    "circle-up": [512, 512, [61467, "arrow-alt-circle-up"], "f35b", "M272.9 135.7C268.3 130.8 261.9 128 255.2 128C247.5 128.3 241.1 130.9 237.5 135.8l-87.25 96C143.8 238.9 142.2 249 146.1 257.7C149.9 266.4 158.5 272 167.1 272h56L224 360c0 13.25 10.75 24 24 24h16c13.25 0 23.1-10.75 23.1-24L287.1 272h56c9.531 0 18.16-5.656 22-14.38c3.811-8.75 2.092-18.91-4.377-25.91L272.9 135.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-up-left": [512, 512, [], "e128", "M287.6 242.3l41.37-41.38c6.859-6.875 8.922-17.19 5.203-26.16S321.7 160 312 160h-128C170.8 160 160 170.8 160 184v128c0 9.719 5.844 18.47 14.81 22.19C177.8 335.4 180.9 336 184 336c6.234 0 12.38-2.438 16.97-7.031l41.37-41.38l64.57 64.57c9.369 9.371 24.57 9.371 33.94 0l11.31-11.31c9.369-9.367 9.369-24.57 0-33.94L287.6 242.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-up-right": [512, 512, [], "e129", "M328 160h-128C190.3 160 181.5 165.8 177.8 174.8S176.2 194.1 183 200.1l41.37 41.38L159.8 306.9c-9.369 9.371-9.369 24.57 0 33.94l11.31 11.31c9.369 9.371 24.57 9.371 33.94 0l64.57-64.57l41.37 41.38C315.6 333.6 321.8 336 328 336c3.094 0 6.219-.5938 9.188-1.812C346.2 330.5 352 321.7 352 312v-128C352 170.8 341.3 160 328 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-user": [512, 512, [62142, "user-circle"], "f2bd", "M256 112c-48.6 0-88 39.4-88 88C168 248.6 207.4 288 256 288s88-39.4 88-88C344 151.4 304.6 112 256 112zM256 240c-22.06 0-40-17.95-40-40C216 177.9 233.9 160 256 160s40 17.94 40 40C296 222.1 278.1 240 256 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-46.73 0-89.76-15.68-124.5-41.79C148.8 389 182.4 368 220.2 368h71.69c37.75 0 71.31 21.01 88.68 54.21C345.8 448.3 302.7 464 256 464zM416.2 388.5C389.2 346.3 343.2 320 291.8 320H220.2c-51.36 0-97.35 26.25-124.4 68.48C65.96 352.5 48 306.3 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 306.3 446 352.5 416.2 388.5z"],
    "circle-v": [512, 512, [], "e12a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM370.7 146.5c-11.86-5.891-26.27-1.125-32.2 10.73L256 322.3L173.5 157.3C167.5 145.4 153.2 140.6 141.3 146.5C129.4 152.5 124.6 166.9 130.5 178.7l104 208C238.6 394.9 246.9 400 256 400s17.41-5.141 21.47-13.27l104-208C387.4 166.9 382.6 152.5 370.7 146.5z"],
    "circle-video": [512, 512, ["video-circle"], "e12b", "M284 176h-120C152.1 176 144 184.1 144 196v120c0 11.04 8.955 20 20 20h120c11.04 0 20-8.955 20-20v-120C304 184.1 295 176 284 176zM379.8 194.3L336 224.5v62.96l43.84 30.2C388.3 323.5 400 317.6 400 307.4V204.6C400 194.4 388.4 188.4 379.8 194.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-w": [512, 512, [], "e12c", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM383.1 145.1c-12.66-3.828-26.11 3.203-30 15.88L313.5 289.4l-34.36-127.6C276.4 151.3 266.9 144 256 144S235.6 151.3 232.8 161.8L198.5 289.4L158.9 160.9c-3.906-12.67-17.34-19.73-30-15.88c-12.67 3.891-19.78 17.33-15.88 30l64 208C180.2 393.3 189.7 399.1 200.4 400c10.7-.1875 19.97-7.438 22.75-17.77L256 260.3l32.83 121.9C291.6 392.6 300.9 399.8 311.6 400H312c10.52 0 19.84-6.859 22.94-16.94l64-208C402.8 162.4 395.7 148.1 383.1 145.1z"],
    "circle-waveform-lines": [512, 512, ["waveform-circle"], "e12d", "M232 128C218.8 128 208 138.8 208 152v208C208 373.2 218.8 384 232 384S256 373.2 256 360v-208C256 138.8 245.2 128 232 128zM152 192C138.8 192 128 202.8 128 216v80C128 309.2 138.8 320 152 320S176 309.2 176 296v-80C176 202.8 165.2 192 152 192zM392 216c-13.22 0-24 10.78-24 24v32c0 13.22 10.78 24 24 24S416 285.2 416 272v-32C416 226.8 405.2 216 392 216zM312 176C298.8 176 288 186.8 288 200v112c0 13.22 10.78 24 24 24s24-10.78 24-24v-112C336 186.8 325.2 176 312 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-x": [512, 512, [], "e12e", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM359.5 133.7c-10.11-8.578-25.28-7.297-33.83 2.828L256 218.8L186.3 136.5C177.8 126.4 162.6 125.1 152.5 133.7C142.4 142.2 141.1 157.4 149.7 167.5L224.6 256l-74.88 88.5c-8.562 10.11-7.297 25.27 2.828 33.83C157 382.1 162.5 384 167.1 384c6.812 0 13.59-2.891 18.34-8.5L256 293.2l69.67 82.34C330.4 381.1 337.2 384 344 384c5.469 0 10.98-1.859 15.48-5.672c10.12-8.562 11.39-23.72 2.828-33.83L287.4 256l74.88-88.5C370.9 157.4 369.6 142.2 359.5 133.7z"],
    "circle-xmark": [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M336.1 175c-9.375-9.375-24.56-9.375-33.94 0L256 222.1L208.1 175c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l47.03 47.03L175 303c-9.375 9.375-9.375 24.56 0 33.94c9.373 9.373 24.56 9.381 33.94 0L256 289.9l47.03 47.03c9.373 9.373 24.56 9.381 33.94 0c9.375-9.375 9.375-24.56 0-33.94l-47.03-47.03l47.03-47.03C346.3 199.6 346.3 184.4 336.1 175zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256S512 397.4 512 256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-y": [512, 512, [], "e12f", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM341.8 152.4L256 252.5L170.2 152.4C161.6 142.3 146.5 141.2 136.4 149.8C126.3 158.4 125.2 173.6 133.8 183.6L232 298.2V376c0 13.25 10.75 24 24 24s24-10.75 24-24V298.2l98.22-114.6c8.625-10.06 7.469-25.22-2.594-33.84C365.5 141.1 350.4 142.3 341.8 152.4z"],
    "circle-z": [512, 512, [], "e130", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM328 336H229.8l117.9-170.3c5.094-7.328 5.688-16.89 1.531-24.8C345.1 132.1 336.9 128 328 128h-144C170.8 128 160 138.8 160 152S170.8 176 184 176h98.19l-117.9 170.3c-5.094 7.328-5.688 16.89-1.531 24.8C166.9 379 175.1 384 184 384h144c13.25 0 24-10.75 24-24S341.3 336 328 336z"],
    "citrus": [512, 512, [], "e2f4", "M496 271.1C496 404.3 388.3 512 256 512s-240-107.7-240-240S123.7 31.1 256 31.1c17.55 0 34.8 2.515 51.75 6.255C325.3 15.14 352.7 0 384 0h80C472.8 0 480 7.162 480 16v16c0 53.02-42.98 96-96 96h-80C295.2 128 288 120.8 288 112V96c0-4.396 .7227-8.596 1.295-12.84C278.3 81.25 267.2 80 256 80c-105.9 0-192 86.13-192 192s86.13 192 192 192s192-86.13 192-192c0-31.06-7.156-60.67-21.31-88c-6.094-11.78-1.5-26.25 10.28-32.34c11.81-6.172 26.28-1.484 32.34 10.28C486.8 195.7 496 233.7 496 271.1z"],
    "citrus-slice": [512, 512, [], "e2f5", "M425.3 7.031c-9.375-9.375-24.56-9.375-33.94 0L7.037 391.4c-10.56 10.56-8.143 25.79 0 33.94C62.91 481.2 137.2 512 216.2 512c79.03 0 153.3-30.77 209.2-86.64C481.2 369.5 512 295.2 512 216.2C512 137.2 481.2 62.89 425.3 7.031zM239.1 261.7l83.3 83.3C292.4 369.8 255.6 384 216.2 384C213.4 384 210.8 383.5 208 383.3V269.1C218.8 270.1 229.5 267.3 239.1 261.7zM345.1 322.4l-83.3-83.3C267.3 229.5 270.1 218.8 269.1 208h113.4c.1328 2.748 .6543 5.418 .6543 8.188C384 255.6 369.8 292.4 345.1 322.4zM378.6 176H290.3l60.29-60.3C364.2 133.7 373.3 154.3 378.6 176zM176 290.3v88.28c-21.71-5.34-42.25-14.47-60.28-28L176 290.3zM391.4 391.4C344.6 438.2 282.4 464 216.2 464c-58.12 0-113.2-19.9-157.4-56.45l22.81-22.81C119.7 415.3 166.6 432 216.2 432c57.63 0 111.8-22.45 152.6-63.22c40.77-40.76 63.22-94.95 63.22-152.6c0-49.55-16.69-96.5-47.25-134.6l22.81-22.81c36.54 44.26 56.44 99.31 56.44 157.4C464 282.4 438.2 344.6 391.4 391.4z"],
    "city": [640, 512, [63055], "1f3d9", "M244 384h-40C197.4 384 192 389.4 192 396v40C192 442.6 197.4 448 204 448h40C250.6 448 256 442.6 256 436v-40C256 389.4 250.6 384 244 384zM244 192h-40C197.4 192 192 197.4 192 204v40c0 6.625 5.375 12.01 12 12.01h40C250.6 256 256 250.6 256 244v-40C256 197.4 250.6 192 244 192zM148 192h-40C101.4 192 96 197.4 96 204v40C96 250.6 101.4 256 108 256h40C154.6 256 160 250.6 160 244v-40C160 197.4 154.6 192 148 192zM148 384h-40C101.4 384 96 389.4 96 396v40C96 442.6 101.4 448 108 448h40C154.6 448 160 442.6 160 436v-40C160 389.4 154.6 384 148 384zM148 288h-40C101.4 288 96 293.4 96 300v40C96 346.6 101.4 352 108 352h40C154.6 352 160 346.6 160 340v-40C160 293.4 154.6 288 148 288zM244 288h-40C197.4 288 192 293.4 192 300v40c0 6.625 5.375 12.01 12 12.01h40C250.6 352 256 346.6 256 340v-40C256 293.4 250.6 288 244 288zM532 384h-40C485.4 384 480 389.4 480 396v40C480 442.6 485.4 448 492 448h40C538.6 448 544 442.6 544 436v-40C544 389.4 538.6 384 532 384zM532 288h-40C485.4 288 480 293.4 480 300v40C480 346.6 485.4 352 492 352h40C538.6 352 544 346.6 544 340v-40C544 293.4 538.6 288 532 288zM576 192H512V63.1C512 28.65 483.3 0 448 0H319.1C284.7 0 256 28.65 256 63.1V96L224 96.01V24.01c0-13.25-10.75-23.1-24-23.1S176 10.75 176 24.01v72h-64V24.01c0-13.25-10.75-23.1-24-23.1S64 10.75 64 24.01v72c-35.35 0-64 28.64-64 63.99V488C0 501.3 10.75 512 23.1 512S48 501.3 48 488V160c0-8.837 7.163-16 16-16h240V64c0-8.837 7.163-16 16-16h128c8.837 0 16 7.163 16 16v176H576c8.837 0 16 7.163 16 16v232C592 501.3 602.7 512 616 512S640 501.3 640 488V255.1C640 220.7 611.3 192 576 192zM404 96h-40C357.4 96 352 101.4 352 108v40c0 6.625 5.375 12.01 12 12.01h40C410.6 160 416 154.6 416 148v-40C416 101.4 410.6 96 404 96zM404 288h-40C357.4 288 352 293.4 352 300v40C352 346.6 357.4 352 364 352h40C410.6 352 416 346.6 416 340v-40C416 293.4 410.6 288 404 288zM404 192h-40C357.4 192 352 197.4 352 204v40c0 6.625 5.375 12.01 12 12.01h40C410.6 256 416 250.6 416 244v-40C416 197.4 410.6 192 404 192z"],
    "clapperboard": [512, 512, [], "e131", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM254.1 80h67.88l-80 80H174.1L254.1 80zM48 126.1L94.06 80h67.88l-80 80H48V126.1zM464 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V208h416V416zM464 97.94L401.9 160h-67.88l80-80H448c8.822 0 16 7.178 16 16V97.94z"],
    "clapperboard-play": [512, 512, [], "e132", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM254.1 80h67.88l-80 80H174.1L254.1 80zM48 126.1L94.06 80h67.88l-80 80H48V126.1zM464 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V208h416V416zM464 97.94L401.9 160h-67.88l80-80H448c8.822 0 16 7.178 16 16V97.94zM218.7 400c1.959 0 3.938-.5605 5.646-1.682l106.7-68.97C334.1 327.3 336 323.8 336 319.1s-1.896-7.34-5.021-9.354l-106.7-68.97C221.1 239.5 216.9 239.5 213.5 241.4C210.1 243.3 208 247 208 251v137.9c0 4.008 2.104 7.705 5.5 9.656C215.1 399.5 216.9 400 218.7 400z"],
    "clarinet": [640, 512, [], "f8ad", "M272 231.1c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1S296 269.2 296 255.1C296 242.7 285.3 231.1 272 231.1zM368 231.1c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1s24-10.75 24-23.1C392 242.7 381.3 231.1 368 231.1zM616 111.1c-4.75 0-9.375 1.375-13.25 3.1l-66 43.1L480 159.1V127.1h16c8.8 0 16-7.2 16-15.1S504.8 96 496 96h-256C231.2 96 224 103.2 224 111.1s7.2 15.1 16 15.1H256v31.1l-149.6-.0013c-6.891 0-13.74 1.113-20.27 3.295L21.82 184.8C8.754 189.1 0 201.3 0 215.1v81.82c0 13.77 8.81 26 21.87 30.37l64.25 21.45c6.536 2.182 13.38 3.295 20.27 3.295l430.4 0l66 43.1c7.375 4.875 16.75 5.375 24.62 1.125C635.1 392.1 640 384.9 640 375.1V135.1C640 122.7 629.3 111.1 616 111.1zM384 127.1h64v31.1l-64 .0002V127.1zM288 127.1h64v31.1L288 159.1V127.1zM592 331.1l-40.75-27.12H103.8L48 285.4V226.6l55.75-18.62h447.5L592 180.9V331.1zM464 231.1c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1s24-10.75 24-23.1C488 242.7 477.3 231.1 464 231.1z"],
    "claw-marks": [512, 512, [], "f6c2", "M7.057 224.5C6.317 224.2 5.59 223.1 4.903 223.1c-2.714 0-4.83 2.446-4.83 5.048c0 1.194 .4459 2.422 1.485 3.46l85.12 85.12c5.1 5.1 9.375 14.13 9.375 22.62l-.0129 43.75l43.76-.0033c8.499 0 16.62 3.375 22.62 9.375l117.1 117.1c1.039 1.039 2.272 1.485 3.453 1.485c2.563 0 5.016-2.121 5.016-4.82C288 502.6 208.7 320.2 7.057 224.5zM246.7 29.63c5.1 5.1 9.333 14.13 9.333 22.62l-.0009 43.75l43.75-.005c8.499 0 16.62 3.375 22.62 9.375l52.25 52.25c5.1 5.1 9.375 14.13 9.375 22.62l.0005 43.75l43.75-.0042c8.499 0 16.62 3.375 22.62 9.375l53.12 53.12c1.039 1.039 2.266 1.485 3.46 1.485c2.602 0 5.048-2.116 5.048-4.83c0-.6879-.1571-1.414-.5085-2.154c-92.97-196.1-276.6-281-282.6-281c-2.714 0-4.83 2.446-4.83 5.048c0 1.194 .4459 2.422 1.485 3.46L246.7 29.63zM511.1 479.1c0-4.538-.9699-9.128-2.984-13.47l-1.5-2.1C363.3 155.2 67.57 .0614 32.08 .0614C21.05 .0614 0 8.603 0 32.6c0 7.778 2.739 15.19 7.772 20.15l144.4 179.7v63.5h61.1l65.87 65.1v61.1h64.5l114.1 80.5C465.1 509.3 472.4 512 479.1 512c6.375 0 12.75-1.1 18.37-5.875C507.2 499.9 511.1 490.1 511.1 479.1zM359.6 376h-31.62v-33.1L234 248H200.1V215.5L92.89 82.13c184.1 106.7 289.9 253.2 342.1 347.2L359.6 376z"],
    "clipboard": [384, 512, [62248], "1f4cb", "M320 64h-49.61C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h256c35.35 0 64-28.66 64-64V128C384 92.66 355.3 64 320 64zM192 48c13.23 0 24 10.77 24 24S205.2 96 192 96S168 85.23 168 72S178.8 48 192 48zM336 448c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V128c0-8.82 7.178-16 16-16h18.26C80.93 117.1 80 122.4 80 128v16C80 152.8 87.16 160 96 160h192c8.836 0 16-7.164 16-16V128c0-5.559-.9316-10.86-2.264-16H320c8.822 0 16 7.18 16 16V448z"],
    "clipboard-check": [384, 512, [], "f46c", "M245.1 233.2L172.6 325.5L135.6 293.8C125.5 285.2 110.4 286.3 101.8 296.4c-8.625 10.06-7.469 25.22 2.594 33.84l56 48C164.8 381.1 170.3 384 176 384c.7813 0 1.562-.0313 2.344-.125c6.516-.625 12.48-3.906 16.53-9.062l88-112c8.188-10.41 6.375-25.5-4.047-33.69C268.4 220.1 253.3 222.8 245.1 233.2zM320 64h-49.61C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h256c35.35 0 64-28.66 64-64V128C384 92.66 355.3 64 320 64zM192 48c13.23 0 24 10.77 24 24S205.2 96 192 96S168 85.23 168 72S178.8 48 192 48zM336 448c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V128c0-8.82 7.178-16 16-16h18.26C80.93 117.1 80 122.4 80 128v16C80 152.8 87.16 160 96 160h192c8.836 0 16-7.164 16-16V128c0-5.559-.9316-10.86-2.264-16H320c8.822 0 16 7.18 16 16V448z"],
    "clipboard-list": [384, 512, [], "f46d", "M104 248C90.75 248 80 258.7 80 272s10.75 24 24 24C117.3 296 128 285.3 128 272S117.3 248 104 248zM104 344c-13.25 0-24 10.75-24 24s10.75 24 24 24C117.3 392 128 381.3 128 368S117.3 344 104 344zM288 352H176C167.2 352 160 359.2 160 368S167.2 384 176 384H288c8.844 0 16-7.156 16-16S296.8 352 288 352zM320 64h-49.61C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h256c35.35 0 64-28.66 64-64V128C384 92.66 355.3 64 320 64zM192 48c13.23 0 24 10.77 24 24S205.2 96 192 96S168 85.23 168 72S178.8 48 192 48zM336 448c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V128c0-8.82 7.178-16 16-16h18.26C80.93 117.1 80 122.4 80 128v16C80 152.8 87.16 160 96 160h192c8.836 0 16-7.164 16-16V128c0-5.559-.9316-10.86-2.264-16H320c8.822 0 16 7.18 16 16V448zM288 256H176C167.2 256 160 263.2 160 272S167.2 288 176 288H288c8.844 0 16-7.156 16-16S296.8 256 288 256z"],
    "clipboard-list-check": [384, 512, [], "f737", "M320 64h-49.61C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h256c35.35 0 64-28.66 64-64V128C384 92.66 355.3 64 320 64zM192 48c13.23 0 24 10.77 24 24S205.2 96 192 96S168 85.23 168 72S178.8 48 192 48zM336 448c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V128c0-8.82 7.178-16 16-16h18.26C80.93 117.1 80 122.4 80 128v16C80 152.8 87.16 160 96 160h192c8.836 0 16-7.164 16-16V128c0-5.559-.9316-10.86-2.264-16H320c8.822 0 16 7.18 16 16V448zM288 256H176C167.2 256 160 263.2 160 272S167.2 288 176 288H288c8.844 0 16-7.156 16-16S296.8 256 288 256zM288 352H176C167.2 352 160 359.2 160 368S167.2 384 176 384H288c8.844 0 16-7.156 16-16S296.8 352 288 352zM104 344c-13.25 0-24 10.75-24 24s10.75 24 24 24C117.3 392 128 381.3 128 368S117.3 344 104 344zM108 288c4.094 0 8.188-1.562 11.31-4.688l48-48c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L108 249.4L95.31 236.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l24 24C99.81 286.4 103.9 288 108 288z"],
    "clipboard-medical": [384, 512, [], "e133", "M320 64h-49.61C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h256c35.35 0 64-28.66 64-64V128C384 92.66 355.3 64 320 64zM192 48c13.23 0 24 10.77 24 24S205.2 96 192 96S168 85.23 168 72S178.8 48 192 48zM336 448c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V128c0-8.82 7.178-16 16-16h18.26C80.93 117.1 80 122.4 80 128v16C80 152.8 87.16 160 96 160h192c8.836 0 16-7.164 16-16V128c0-5.559-.9316-10.86-2.264-16H320c8.822 0 16 7.18 16 16V448zM272 288H224V240C224 231.2 216.8 224 208 224h-32C167.2 224 160 231.2 160 240V288H112C103.2 288 96 295.2 96 304v32C96 344.8 103.2 352 112 352H160v48C160 408.8 167.2 416 176 416h32c8.801 0 16-7.203 16-16V352h48c8.801 0 16-7.203 16-16v-32C288 295.2 280.8 288 272 288z"],
    "clipboard-prescription": [384, 512, [], "f5e8", "M320 64h-49.61C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h256c35.35 0 64-28.66 64-64V128C384 92.66 355.3 64 320 64zM192 48c13.23 0 24 10.77 24 24S205.2 96 192 96S168 85.23 168 72S178.8 48 192 48zM336 448c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V128c0-8.82 7.178-16 16-16h18.26C80.93 117.1 80 122.4 80 128v16C80 152.8 87.16 160 96 160h192c8.836 0 16-7.164 16-16V128c0-5.559-.9316-10.86-2.264-16H320c8.822 0 16 7.18 16 16V448zM294.2 321.8c-7.812-7.812-20.5-7.812-28.31 0L240 347.7l-32.72-32.72C224.4 304.4 236 285.6 236 264c0-33.09-26.91-60-60-60H104C92.97 204 84 212.1 84 224v144c0 11.03 8.969 20 20 20s20-8.969 20-20v-44h35.69l52 52l-25.84 25.84c-7.781 7.812-7.781 20.5 0 28.31C189.8 434.1 194.9 436 200 436s10.25-1.938 14.16-5.844L240 404.3l25.84 25.84C269.8 434.1 274.9 436 280 436s10.25-1.938 14.16-5.844c7.781-7.812 7.781-20.5 0-28.31L268.3 376l25.84-25.84C301.9 342.3 301.9 329.7 294.2 321.8zM176 284H124v-40H176c11.03 0 20 8.969 20 20S187 284 176 284z"],
    "clipboard-user": [384, 512, [], "f7f3", "M320 64h-49.61C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h256c35.35 0 64-28.66 64-64V128C384 92.66 355.3 64 320 64zM192 48c13.23 0 24 10.77 24 24S205.2 96 192 96S168 85.23 168 72S178.8 48 192 48zM336 448c0 8.82-7.178 16-16 16h-1.613C310.7 418.6 271.5 384 224 384H160c-47.54 0-86.73 34.64-94.39 80H64c-8.822 0-16-7.18-16-16V128c0-8.82 7.178-16 16-16h18.26C80.93 117.1 80 122.4 80 128v16C80 152.8 87.16 160 96 160h192c8.836 0 16-7.164 16-16V128c0-5.559-.9316-10.86-2.264-16H320c8.822 0 16 7.18 16 16V448zM192 224C156.7 224 128 252.7 128 288c0 35.34 28.65 64 64 64s64-28.66 64-64C256 252.7 227.3 224 192 224z"],
    "clock": [512, 512, [61463, "clock-four"], "1f553", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM358.1 287.2L280 242.1V120C280 106.8 269.3 96 256 96S232 106.8 232 120V256c0 8.578 4.578 16.5 12 20.78l90.06 52C337.8 330.1 341.1 332 346 332c8.281 0 16.36-4.297 20.8-12C373.5 308.5 369.5 293.8 358.1 287.2z"],
    "clock-desk": [448, 512, [], "e134", "M248 228V120c0-13.25-10.75-24-24-24S200 106.8 200 120V240c0 7.562 3.562 14.66 9.594 19.19l64 48C277.9 310.4 282.1 312 287.1 312c7.312 0 14.53-3.312 19.22-9.594c7.969-10.62 5.801-25.66-4.793-33.59L248 228zM224 0C100.3 0 0 100.3 0 224v236.2C0 488.8 23.21 512 51.85 512h344.3C424.8 512 448 488.8 448 460.2V224C448 100.3 347.7 0 224 0zM224 400c-97.05 0-176-78.95-176-176S126.1 48 224 48s176 78.95 176 176S321 400 224 400z"],
    "clock-eight": [512, 512, [], "e345", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 96C242.8 96 232 106.8 232 120v122.1L153.9 287.2C142.5 293.8 138.5 308.5 145.2 320c4.438 7.703 12.52 12 20.8 12c4.078 0 8.203-1.031 11.98-3.219l90.06-52C275.4 272.5 280 264.6 280 256V120C280 106.8 269.3 96 256 96z"],
    "clock-eight-thirty": [512, 512, [], "e346", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM268 235.2c-7.438-4.281-16.56-4.281-24 0l-90.06 52C142.5 293.8 138.5 308.5 145.2 320c6.609 11.5 21.33 15.39 32.78 8.781L232 297.6V392C232 405.3 242.8 416 256 416s24-10.75 24-24V256C280 247.4 275.4 239.5 268 235.2z"],
    "clock-eleven": [512, 512, [], "e347", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 96C242.8 96 232 106.8 232 120v46.44l-7.219-12.5C218.1 142.5 203.5 138.5 192 145.2C180.5 151.8 176.6 166.5 183.2 177.9l52 90.06C239.6 275.6 247.6 280 256 280c2.062 0 4.141-.2656 6.219-.8125C272.7 276.4 280 266.9 280 256V120C280 106.8 269.3 96 256 96z"],
    "clock-eleven-thirty": [512, 512, [], "e348", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM224.8 153.9C218.2 142.5 203.5 138.5 192 145.2C180.5 151.8 176.6 166.5 183.2 177.9L232 262.4V392C232 405.3 242.8 416 256 416s24-10.75 24-24V256c0-4.219-1.109-8.359-3.219-12L224.8 153.9z"],
    "clock-five": [512, 512, [], "e349", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM280 249.6V120C280 106.8 269.3 96 256 96S232 106.8 232 120V256c0 4.219 1.109 8.359 3.219 12l52 90.06c4.438 7.703 12.52 12 20.8 12c4.078 0 8.203-1.031 11.98-3.219c11.48-6.625 15.41-21.3 8.781-32.78L280 249.6z"],
    "clock-five-thirty": [512, 512, [], "e34a", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM276.8 244c-5.438-9.422-16.42-13.95-27-11.19C239.3 235.6 232 245.1 232 256v136C232 405.3 242.8 416 256 416s24-10.75 24-24v-46.44l7.219 12.5c6.641 11.5 21.33 15.39 32.78 8.781c11.48-6.625 15.41-21.3 8.781-32.78L276.8 244z"],
    "clock-four-thirty": [512, 512, [], "e34b", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM358.1 287.2l-90.06-52c-7.438-4.281-16.56-4.281-24 0C236.6 239.5 232 247.4 232 256v136C232 405.3 242.8 416 256 416s24-10.75 24-24V297.6l54.06 31.22C345.5 335.4 360.2 331.5 366.8 320C373.5 308.5 369.5 293.8 358.1 287.2z"],
    "clock-nine": [512, 512, [], "e34c", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 96C242.8 96 232 106.8 232 120v112h-80C138.8 232 128 242.8 128 256s10.75 24 24 24H256c13.25 0 24-10.75 24-24V120C280 106.8 269.3 96 256 96z"],
    "clock-nine-thirty": [512, 512, [], "e34d", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 232H152C138.8 232 128 242.8 128 256s10.75 24 24 24h80v112C232 405.3 242.8 416 256 416s24-10.75 24-24V256C280 242.8 269.3 232 256 232z"],
    "clock-one": [512, 512, [], "e34e", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM320 145.2c-11.47-6.641-26.16-2.703-32.78 8.781L280 166.4V120C280 106.8 269.3 96 256 96S232 106.8 232 120V256c0 10.86 7.297 20.38 17.78 23.19C251.9 279.7 253.9 280 256 280c8.422 0 16.42-4.438 20.78-12l52-90.06C335.4 166.5 331.5 151.8 320 145.2z"],
    "clock-one-thirty": [512, 512, [], "e34f", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM320 145.2c-11.45-6.641-26.14-2.703-32.78 8.781L235.2 244C233.1 247.6 232 251.8 232 256v136C232 405.3 242.8 416 256 416s24-10.75 24-24V262.4l48.78-84.5C335.4 166.5 331.5 151.8 320 145.2z"],
    "clock-rotate-left": [512, 512, ["history"], "f1da", "M256 32C176.2 32 103.7 75.57 64 142.1V56C64 42.75 53.25 32 40 32S16 42.75 16 56v144C16 213.3 26.75 224 40 224h128C181.3 224 192 213.3 192 200S181.3 176 168 176H99.54C129.2 118.3 189.5 79.96 256 79.96c97.03 0 176 79.01 176 176s-78.97 175.1-176 175.1c-41.09 0-81.09-14.44-112.6-40.72c-10.16-8.5-25.31-7.156-33.81 3.062c-8.5 10.19-7.125 25.31 3.062 33.81C152.8 461.6 203.7 480 256 480c123.5 0 224-100.5 224-224S379.5 32 256 32zM256 128C242.8 128 232 138.8 232 152V272c0 7.75 3.741 15.03 10.04 19.53l56 40C302.3 334.6 307.2 336 311.1 336c7.484 0 14.86-3.5 19.55-10.06c7.703-10.78 5.203-25.75-5.578-33.47L280 259.7L280 152C280 138.8 269.3 128 256 128z"],
    "clock-seven": [512, 512, [], "e350", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 96C242.8 96 232 106.8 232 120v129.6l-48.78 84.5C176.6 345.5 180.5 360.2 192 366.8c3.781 2.188 7.906 3.219 11.98 3.219c8.281 0 16.36-4.297 20.8-12l52-90.06C278.9 264.4 280 260.2 280 256V120C280 106.8 269.3 96 256 96z"],
    "clock-seven-thirty": [512, 512, [], "e351", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM262.2 232.8C251.6 230 240.7 234.6 235.2 244l-52 90.06C176.6 345.5 180.5 360.2 192 366.8c11.47 6.641 26.16 2.719 32.78-8.781L232 345.6V392C232 405.3 242.8 416 256 416s24-10.75 24-24V256C280 245.1 272.7 235.6 262.2 232.8z"],
    "clock-six": [512, 512, [], "e352", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 96C242.8 96 232 106.8 232 120v240C232 373.3 242.8 384 256 384s24-10.75 24-24v-240C280 106.8 269.3 96 256 96z"],
    "clock-six-thirty": [512, 512, [], "e353", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 232C242.8 232 232 242.8 232 256v136C232 405.3 242.8 416 256 416s24-10.75 24-24V256C280 242.8 269.3 232 256 232z"],
    "clock-ten": [512, 512, [], "e354", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 96C242.8 96 232 106.8 232 120v94.44L177.9 183.2C166.5 176.6 151.8 180.5 145.2 192C138.5 203.5 142.5 218.2 153.9 224.8l90.06 52C247.7 278.9 251.9 280 256 280s8.281-1.078 12-3.219C275.4 272.5 280 264.6 280 256V120C280 106.8 269.3 96 256 96z"],
    "clock-ten-thirty": [512, 512, [], "e355", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM268 235.2l-90.06-52C166.5 176.6 151.8 180.5 145.2 192C138.5 203.5 142.5 218.2 153.9 224.8L232 269.9V392C232 405.3 242.8 416 256 416s24-10.75 24-24V256C280 247.4 275.4 239.5 268 235.2z"],
    "clock-three": [512, 512, [], "e356", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM360 232h-80v-112C280 106.8 269.3 96 256 96S232 106.8 232 120V256c0 13.25 10.75 24 24 24h104C373.3 280 384 269.3 384 256S373.3 232 360 232z"],
    "clock-three-thirty": [512, 512, [], "e357", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM360 232H256C242.8 232 232 242.8 232 256v136C232 405.3 242.8 416 256 416s24-10.75 24-24v-112h80C373.3 280 384 269.3 384 256S373.3 232 360 232z"],
    "clock-twelve": [512, 512, [], "e358", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 96C242.8 96 232 106.8 232 120V256c0 13.25 10.75 24 24 24S280 269.3 280 256V120C280 106.8 269.3 96 256 96z"],
    "clock-twelve-thirty": [512, 512, [], "e359", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 128C242.8 128 232 138.8 232 152v240C232 405.3 242.8 416 256 416s24-10.75 24-24v-240C280 138.8 269.3 128 256 128z"],
    "clock-two": [512, 512, [], "e35a", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM334.1 183.2L280 214.4V120C280 106.8 269.3 96 256 96S232 106.8 232 120V256c0 8.578 4.578 16.5 12 20.78C247.7 278.9 251.9 280 256 280s8.281-1.078 12-3.219l90.06-52C369.5 218.2 373.5 203.5 366.8 192S345.5 176.6 334.1 183.2z"],
    "clock-two-thirty": [512, 512, [], "e35b", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM334.1 183.2L244 235.2C236.6 239.5 232 247.4 232 256v136C232 405.3 242.8 416 256 416s24-10.75 24-24V269.9l78.06-45.08C369.5 218.2 373.5 203.5 366.8 192S345.5 176.6 334.1 183.2z"],
    "clone": [512, 512, [], "f24d", "M448 0H224C188.7 0 160 28.65 160 64v224c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64V64C512 28.65 483.3 0 448 0zM464 288c0 8.822-7.178 16-16 16H224C215.2 304 208 296.8 208 288V64c0-8.822 7.178-16 16-16h224c8.822 0 16 7.178 16 16V288zM304 448c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V224c0-8.822 7.178-16 16-16h64V160H64C28.65 160 0 188.7 0 224v224c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64v-64h-48V448z"],
    "closed-captioning": [576, 512, [], "f20a", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V416zM236.5 222.1c9.375 9.375 24.56 9.375 33.94 0c9.375-9.375 9.375-24.56 0-33.94c-37.44-37.44-98.31-37.44-135.7 0C116.5 206.2 106.5 230.4 106.5 256s9.1 49.75 28.12 67.88c18.72 18.72 43.28 28.08 67.87 28.08s49.16-9.359 67.87-28.08c9.375-9.375 9.375-24.56 0-33.94c-9.375-9.375-24.56-9.375-33.94 0c-18.69 18.72-49.19 18.72-67.87 0C159.5 280.9 154.5 268.8 154.5 256s5-24.88 14.06-33.94C187.3 203.3 217.8 203.3 236.5 222.1zM428.5 222.1c9.375 9.375 24.56 9.375 33.94 0c9.375-9.375 9.375-24.56 0-33.94c-37.44-37.44-98.31-37.44-135.7 0C308.5 206.2 298.5 230.4 298.5 256s9.1 49.75 28.12 67.88c18.72 18.72 43.28 28.08 67.87 28.08s49.16-9.359 67.87-28.08c9.375-9.375 9.375-24.56 0-33.94c-9.375-9.375-24.56-9.375-33.94 0c-18.69 18.72-49.19 18.72-67.87 0C351.5 280.9 346.5 268.8 346.5 256s5-24.88 14.06-33.94C379.3 203.3 409.8 203.3 428.5 222.1z"],
    "closed-captioning-slash": [640, 512, [], "e135", "M96 432c-8.822 0-16-7.178-16-16V159.4L32 121.8v294.2c0 35.35 28.65 64 64 64l393.1 .0002L427.8 432H96zM630.8 469.1l-30.73-24.09C604.7 436.2 608 426.7 608 416V95.1c0-35.35-28.65-64-64-64L96 31.1c-6.646 0-12.96 1.176-18.96 3.073L38.81 5.111c-10.47-8.172-25.49-6.359-33.69 4.078C-3.051 19.63-1.233 34.72 9.189 42.89l591.1 463.1C605.6 510.3 610.8 512 615.1 512c7.125 0 14.16-3.162 18.89-9.193C643.1 492.4 641.2 477.3 630.8 469.1zM560 413.6l-91.51-71.73c9.318-4.539 18.2-10.27 25.93-18.01c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0c-11.55 11.57-27.47 15.11-42.47 12.38l-35.89-28.13c-2.336-5.701-3.577-11.85-3.577-18.19c0-12.81 5-24.88 14.06-33.94c18.69-18.72 49.19-18.72 67.88 0c9.375 9.375 24.56 9.375 33.94 0s9.375-24.56 0-33.94c-37.44-37.44-98.31-37.44-135.8 0c-13.2 13.2-21.95 29.62-25.81 47.45L306.9 215.3c4.213-8.904 2.85-19.77-4.517-27.14C284.3 170 260.8 161 237 160.5L134.4 80H544c8.822 0 16 7.178 16 16V413.6zM148.9 213.4C142.4 226.5 138.5 240.9 138.5 256c0 25.64 10 49.75 28.12 67.88c18.72 18.72 43.28 28.08 67.88 28.08c22.08 0 43.9-7.969 61.72-23.06L256.6 297.8c-18.11 9.52-40.82 7.335-56.01-7.88C191.5 280.9 186.5 268.8 186.5 256c0-4.053 .6732-7.98 1.644-11.81L148.9 213.4z"],
    "clothes-hanger": [640, 512, [], "e136", "M607.8 382.1l-248.2-161l22.5-15C413.3 185.3 432 150.4 432 112C432 50.25 381.8 0 320 0S208 50.25 208 112c0 13.25 10.75 24 24 24S256 125.3 256 112c0-35.28 28.72-64 64-64s64 28.72 64 64.91c0 21.44-10.66 41.34-28.5 53.25L31.47 382.2C11.78 395.3 0 417.3 0 441.3C0 480.3 31.69 512 70.66 512h498.7C608.3 512 640 480.3 640 441.3C640 417.3 627.1 395.2 607.8 382.1zM569.3 464H70.66C58.16 464 48 453.8 48 440.1c0-7.594 3.781-14.62 10.09-18.84l258-172l265.6 172.3C588.2 426.5 592 433.6 592 441.3C592 453.8 581.8 464 569.3 464z"],
    "cloud": [640, 512, [61634], "2601", "M543.3 214.5C543.5 212.3 544 210.2 544 208C544 146.1 493.9 96 432 96c-11.41 0-22.19 2.207-32.56 5.377C368.9 59.51 319.8 32 264 32C170.8 32 95.41 107.9 96.08 200.8C40.24 220.6 0 273.4 0 336C0 415.5 64.47 480 144 480h360c75.11 0 136-60.89 136-136C640 282.7 599.1 231.4 543.3 214.5zM504 432H144c-52.94 0-96-43.07-96-96c0-40.2 25.77-76.36 64.13-89.97l32.19-11.42c-.2734-38.62-.2246-33.15-.293-37.17C145.4 132.4 198.7 80 264 80c38.4 0 73.63 18.1 96.66 49.67l20.14 27.6l32.67-9.988c48.86-14.94 84.23 25.56 81.96 64.4l-2.193 37.72l36.15 10.99C566.8 271.8 592 305.4 592 344C592 392.5 552.5 432 504 432z"],
    "cloud-arrow-down": [640, 512, [62337, "cloud-download", "cloud-download-alt"], "f0ed", "M543.3 214.5C543.5 212.3 544 210.2 544 208C544 146.1 493.9 96 432 96c-11.41 0-22.19 2.207-32.56 5.377C368.9 59.51 319.8 32 264 32C170.8 32 95.41 107.9 96.08 200.8C40.24 220.6 0 273.4 0 336C0 415.5 64.47 480 144 480h360c75.11 0 136-60.89 136-136C640 282.7 599.1 231.4 543.3 214.5zM504 432H144c-52.94 0-96-43.07-96-96c0-40.2 25.77-76.36 64.13-89.97l32.19-11.42c-.2734-38.62-.2246-33.15-.293-37.17C145.4 132.4 198.7 80 264 80c38.4 0 73.63 18.1 96.66 49.67l20.14 27.6l32.67-9.988c48.86-14.94 84.23 25.56 81.96 64.4l-2.193 37.72l36.15 10.99C566.8 271.8 592 305.4 592 344C592 392.5 552.5 432 504 432zM391 271L344 318.1V192c0-13.25-10.75-24-24-24S296 178.8 296 192v126.1L248.1 271c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l88 88c2.209 2.209 4.857 3.957 7.787 5.176C313.8 399.4 316.9 400 320 400s6.248-.6406 9.182-1.855c2.93-1.219 5.578-2.967 7.787-5.176l88-88c9.375-9.375 9.375-24.56 0-33.94S400.4 261.7 391 271z"],
    "cloud-arrow-up": [640, 512, ["cloud-upload", "cloud-upload-alt"], "f0ee", "M543.3 214.5C543.5 212.3 544 210.2 544 208C544 146.1 493.9 96 432 96c-11.41 0-22.19 2.207-32.56 5.377C368.9 59.51 319.8 32 264 32C170.8 32 95.41 107.9 96.08 200.8C40.24 220.6 0 273.4 0 336C0 415.5 64.47 480 144 480h360c75.11 0 136-60.89 136-136C640 282.7 599.1 231.4 543.3 214.5zM504 432H144c-52.94 0-96-43.07-96-96c0-40.2 25.77-76.36 64.13-89.97l32.19-11.42c-.2734-38.62-.2246-33.15-.293-37.17C145.4 132.4 198.7 80 264 80c38.4 0 73.63 18.1 96.66 49.67l20.14 27.6l32.67-9.988c48.86-14.94 84.23 25.56 81.96 64.4l-2.193 37.72l36.15 10.99C566.8 271.8 592 305.4 592 344C592 392.5 552.5 432 504 432zM336.1 175c-2.211-2.211-4.863-3.961-7.797-5.178c-5.867-2.43-12.48-2.43-18.34 0C307.9 171.1 305.2 172.8 303 175l-88 88c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L296 249.9V376c0 13.25 10.75 24 24 24s24-10.75 24-24V249.9l47.03 47.03C395.7 301.7 401.8 304 408 304s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L336.1 175z"],
    "cloud-bolt": [512, 512, [63340, "thunderstorm"], "1f329", "M410.8 104.3C397.3 61.75 357.1 32 312 32c-13.5 0-26.75 2.625-39.25 7.75C250.3 14.5 218.4 0 184 0c-64 0-116.4 50.25-119.8 113.4C25.63 130.4 0 168.5 0 212C0 271.5 48.53 320 108.2 320h41.31l52.79-48H108C74.88 272 48 245.1 48 212C48 184 67.13 160 94.38 153.8l20.75-4.875L112.4 124C112.3 122.8 112 121.4 112 120c0-39.75 32.25-72 72-72c25.25 0 48.25 13.12 61.38 35.13l13.38 22.12l21-15C289.4 83.63 300.5 80 312 80c28.62 0 52.38 21.75 55.25 50.38L369.5 152H404c33.13 0 60 26.88 60 60S437.1 272 404 272h-56.48L327.7 320h76.18C463.5 320 512 271.5 512 212C512 154.8 467.1 107.8 410.8 104.3zM344 352h-64.09l43.69-105.9c2.875-6.906 .5313-14.88-5.594-19.19c-6.093-4.25-14.37-3.781-19.94 1.25l-140.8 128c-4.906 4.438-6.562 11.44-4.188 17.62C155.5 379.9 161.4 384 168 384h64.09l-43.69 105.9c-2.875 6.906-.5313 14.88 5.593 19.19C196.8 511 199.1 512 203.2 512c3.875 0 7.719-1.406 10.75-4.156l140.8-128c4.906-4.438 6.562-11.44 4.188-17.62C356.5 356.1 350.6 352 344 352z"],
    "cloud-bolt-moon": [576, 512, ["thunderstorm-moon"], "f76d", "M363.4 183.4C351.4 146.6 316.8 120 276 120c-3.125 0-6.125 .25-9.125 .5C245.3 104.8 219.3 96 192 96C139.6 96 94.38 127.3 74.75 173.3C31.38 187.3 0 228 0 276c0 47.53 30.94 87.46 73.61 101.9c-3.422-16.57 1.51-34 14.17-45.45C64.57 324.2 48 302 48 276c0-33.13 26.88-60 60-60c1.625 0 3.25 .375 4.75 .5C116.6 175.9 150.4 144 192 144c25.25 0 47.38 11.88 62.13 30.12C260.6 170.3 268 168 276 168C300.3 168 320 187.8 320 212c0 1.75-.25 3.375-.5 5.25C347.1 222.6 368 246.8 368 276c0 26.23-16.96 48.31-40.43 56.46c5.549 4.936 10.32 10.81 13.18 18.1c3.398 8.867 3.85 18.3 1.992 27.21C385.2 363.2 416 323.4 416 276C416 237.3 395.3 202.4 363.4 183.4zM567.9 223.8C497.6 237.1 432.9 183.5 432.9 113c0-40.63 21.88-78 57.5-98.13c5.5-3.125 4.125-11.38-2.125-12.5C479.7 .75 470.8 0 461.8 0c-63.82 0-117.1 41.42-136.4 98.44c28.26 12.28 51.46 34.72 64.13 63.87C425.9 188.4 448 230.9 448 276c0 3.541-.4102 6.977-.6699 10.45c4.844 .5195 9.488 1.424 14.47 1.424c44.63 0 85.51-20.12 112.5-53.25C578.6 229.8 574.2 222.6 567.9 223.8zM296 352H231.9l43.69-105.9c2.875-6.906 .5313-14.88-5.594-19.19C263.9 222.7 255.7 223.1 250.1 228.2l-140.8 128c-4.906 4.438-6.562 11.44-4.188 17.62C107.5 379.9 113.4 384 120 384h64.09l-43.69 105.9c-2.875 6.906-.5313 14.88 5.593 19.19C148.8 511 151.1 512 155.2 512c3.875 0 7.719-1.406 10.75-4.156l140.8-128c4.906-4.438 6.562-11.44 4.188-17.62C308.5 356.1 302.6 352 296 352z"],
    "cloud-bolt-sun": [640, 512, ["thunderstorm-sun"], "f76e", "M148 176c.0098 18.99 9.012 35.72 22.79 46.71c13.54-32.94 39.09-60.06 72.66-74.8c2.424-4.523 5.293-8.709 8.109-12.93C240.6 123.4 225.2 116 208 116C174.9 116 148 142.9 148 176zM162.5 250.1C137.1 235.5 120 207.9 120 176C120 127.4 159.4 88.01 208 88.01c23.74 0 45.2 9.502 61.03 24.79c10.82-11.24 23.32-20.62 36.88-28.22L300.4 83.59L286.9 8.637c-1.357-7.516-10.04-11.11-16.31-6.754L208 45.31L145.4 1.883C139.2-2.473 130.5 1.121 129.1 8.637L115.6 83.59l-74.94 13.55C33.12 98.5 29.53 107.2 33.88 113.4L77.28 176L33.88 238.6C29.53 244.8 33.12 253.5 40.64 254.9l74.94 13.55l13.54 74.96c1.357 7.516 10.04 11.11 16.31 6.754l26.59-18.46C164.5 314.5 160 295.8 160 276C160 267.5 161 259.1 162.5 250.1zM555.4 183.4C543.4 146.6 508.8 120 468 120c-3.125 0-6.125 .25-9.125 .5C437.3 104.8 411.3 96 384 96c-52.38 0-97.63 31.25-117.3 77.25C223.4 187.3 192 228 192 276c0 47.52 30.93 87.45 73.6 101.9c-3.434-16.45 1.475-33.93 14.14-45.41C256.5 324.2 240 302 240 276c0-33.13 26.88-60 60-60c1.625 0 3.25 .375 4.75 .5C308.6 175.9 342.4 144 384 144c25.25 0 47.38 11.88 62.13 30.12C452.6 170.3 460 168 468 168C492.3 168 512 187.8 512 212c0 1.75-.25 3.375-.5 5.25C539.1 222.6 560 246.8 560 276c0 26.27-17.02 48.38-40.54 56.49c5.658 4.988 10.51 10.93 13.32 18.2c3.387 8.775 3.84 18.18 1.979 27.08C577.2 363.2 608 323.4 608 276C608 237.3 587.3 202.4 555.4 183.4zM488 352h-64.09l43.69-105.9c2.844-6.906 .5156-14.88-5.609-19.19c-6.094-4.281-14.39-3.75-19.95 1.25l-140.8 128c-4.891 4.438-6.547 11.44-4.156 17.62C299.5 379.9 305.4 384 312 384h64.09l-43.69 105.9c-2.844 6.906-.5156 14.88 5.609 19.19C340.8 511 344 512 347.2 512c3.875 0 7.734-1.406 10.77-4.156l140.8-128c4.891-4.438 6.547-11.44 4.156-17.62C500.5 356.1 494.6 352 488 352z"],
    "cloud-check": [640, 512, [], "e35c", "M543.3 214.5C543.5 212.3 544 210.2 544 208C544 146.1 493.9 96 432 96c-11.41 0-22.19 2.207-32.56 5.377C368.9 59.51 319.8 32 264 32C170.8 32 95.41 107.9 96.08 200.8C40.24 220.6 0 273.4 0 336C0 415.5 64.47 480 144 480h360c75.11 0 136-60.89 136-136C640 282.7 599.1 231.4 543.3 214.5zM504 432H144c-52.94 0-96-43.07-96-96c0-40.2 25.77-76.36 64.13-89.97l32.19-11.42c-.2734-38.62-.2246-33.15-.293-37.17C145.4 132.4 198.7 80 264 80c38.4 0 73.63 18.1 96.66 49.67l20.14 27.6l32.67-9.988c48.86-14.94 84.23 25.56 81.96 64.4l-2.193 37.72l36.15 10.99C566.8 271.8 592 305.4 592 344C592 392.5 552.5 432 504 432zM373.8 232.4l-79.13 92.34L264.1 295c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l48 48c4.5 4.5 10.62 7.031 16.97 7.031c.3125 0 .625 0 .9062-.0313c6.688-.25 12.97-3.281 17.31-8.344l96-112c8.625-10.06 7.469-25.22-2.594-33.84C397.6 221.2 382.4 222.3 373.8 232.4z"],
    "cloud-drizzle": [512, 512, [], "f738", "M410.8 104.3C397.3 61.75 357.1 32 312 32c-13.5 0-26.75 2.625-39.25 7.75C250.3 14.5 218.4 0 184 0c-64 0-116.4 50.25-119.8 113.4C25.63 130.4 0 168.5 0 212C0 271.5 48.38 320 108 320h296C463.6 320 512 271.5 512 212C512 154.8 467.1 107.8 410.8 104.3zM404 272h-296C74.88 272 48 245.1 48 212C48 184 67.13 160 94.38 153.8l20.88-4.875L112.4 124C112.3 122.8 112 121.4 112 120c0-39.75 32.25-72 72-72c25.25 0 48.25 13.12 61.38 35.13l13.38 22.12l21-15C289.4 83.63 300.5 80 312 80c28.62 0 52.38 21.75 55.25 50.38L369.5 152H404c33.13 0 60 26.88 60 60S437.1 272 404 272zM352 424c-13.25 0-24 10.75-24 24v40c0 13.25 10.75 24 24 24s24-10.75 24-24V448C376 434.8 365.3 424 352 424zM448 352c-13.25 0-24 10.75-24 24V416c0 13.25 10.75 24 24 24s24-10.75 24-24v-40C472 362.8 461.3 352 448 352zM160 424c-13.25 0-24 10.75-24 24v40C136 501.3 146.8 512 160 512s24-10.75 24-24V448C184 434.8 173.3 424 160 424zM64 352c-13.25 0-24 10.75-24 24V416c0 13.25 10.75 24 24 24S88 429.3 88 416v-40C88 362.8 77.25 352 64 352zM256 352c-13.25 0-24 10.75-24 24V416c0 13.25 10.75 24 24 24s24-10.75 24-24v-40C280 362.8 269.3 352 256 352z"],
    "cloud-fog": [640, 512, [63310, "fog"], "1f32b", "M200 464H87.1C74.8 464 64 474.8 64 487.1S74.8 512 87.1 512H200C213.2 512 224 501.2 224 488S213.2 464 200 464zM616 464H295.1C282.8 464 272 474.8 272 487.1S282.8 512 295.1 512H616c13.2 0 24-10.8 24-23.1S629.2 464 616 464zM576 400C576 386.8 565.2 376 552 376h-528C10.8 376 0 386.8 0 399.1C0 413.2 10.8 424 23.1 424h528C565.2 424 576 413.2 576 400zM172 320h296C527.6 320 576 271.5 576 212c0-57.25-44.88-104.2-101.2-107.8C461.2 61.75 421.1 32 376 32c-13.5 0-26.75 2.625-39.25 7.75C314.2 14.5 282.4 0 248 0c-64 0-116.4 50.25-119.8 113.4C89.62 130.4 64 168.5 64 212C64 271.5 112.4 320 172 320zM158.4 153.8L179.2 148.9L176.4 124C176.2 122.8 176 121.4 176 120c0-39.75 32.25-72 72-72c25.25 0 48.25 13.12 61.38 35.12l13.38 22.12l21-15C353.4 83.62 364.5 80 376 80c28.62 0 52.38 21.75 55.25 50.38L433.5 152H468c33.13 0 60 26.88 60 60S501.1 272 468 272h-296C138.9 272 112 245.1 112 212C112 184 131.1 160 158.4 153.8z"],
    "cloud-hail": [512, 512, [], "f739", "M384 352c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S401.8 352 384 352zM192 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S209.8 448 192 448zM320 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S337.8 448 320 448zM256 352c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S273.8 352 256 352zM64 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S81.75 448 64 448zM128 352c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S145.8 352 128 352zM410.8 104.2C397.2 61.75 357.1 32 312 32c-13.5 0-26.75 2.625-39.25 7.75C250.2 14.5 218.4 0 184 0c-64 0-116.4 50.25-119.8 113.4C25.62 130.4 0 168.5 0 212C0 271.5 48.38 320 108 320h296C463.6 320 512 271.5 512 212C512 154.8 467.1 107.8 410.8 104.2zM404 272h-296C74.88 272 48 245.1 48 212C48 184 67.12 160 94.38 153.8L115.2 148.9L112.4 124C112.2 122.8 112 121.4 112 120c0-39.75 32.25-72 72-72c25.25 0 48.25 13.12 61.38 35.12l13.38 22.12l21-15C289.4 83.62 300.5 80 312 80c28.62 0 52.38 21.75 55.25 50.38L369.5 152H404c33.13 0 60 26.88 60 60S437.1 272 404 272z"],
    "cloud-hail-mixed": [512, 512, [], "f73a", "M32 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S49.75 448 32 448zM410.8 104.3C397.3 61.75 357.1 32 312 32c-13.5 0-26.75 2.625-39.25 7.75C250.3 14.5 218.4 0 184 0c-64 0-116.4 50.25-119.8 113.4C25.63 130.4 0 168.5 0 212C0 271.5 48.38 320 108 320h296C463.6 320 512 271.5 512 212C512 154.8 467.1 107.8 410.8 104.3zM404 272h-296C74.88 272 48 245.1 48 212C48 184 67.13 160 94.38 153.8l20.88-4.875L112.4 124C112.3 122.8 112 121.4 112 120c0-39.75 32.25-72 72-72c25.25 0 48.25 13.12 61.38 35.13l13.38 22.12l21-15C289.4 83.63 300.5 80 312 80c28.62 0 52.38 21.75 55.25 50.38L369.5 152H404c33.13 0 60 26.88 60 60S437.1 272 404 272zM256 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S273.8 448 256 448zM198.8 353.9c-12.17-5.219-26.3 .4062-31.52 12.59l-48 112c-5.219 12.19 .4219 26.31 12.61 31.53C134.1 511.4 138.2 512 141.3 512c9.312 0 18.17-5.438 22.08-14.53l48-112C216.6 373.3 210.1 359.2 198.8 353.9zM81.45 353.9c-12.19-5.219-26.3 .4062-31.52 12.59l-8 18.66c-5.219 12.19 .4219 26.31 12.61 31.53c3.078 1.312 6.281 1.938 9.438 1.938c9.312 0 18.17-5.438 22.08-14.53l8-18.66C99.28 373.3 93.64 359.2 81.45 353.9zM305.5 353.9c-12.19-5.219-26.3 .4062-31.52 12.59l-8 18.66c-5.219 12.19 .4219 26.31 12.61 31.53c3.078 1.312 6.281 1.938 9.438 1.938c9.312 0 18.17-5.438 22.08-14.53l8-18.66C323.3 373.3 317.6 359.2 305.5 353.9zM433.5 353.9c-12.16-5.219-26.28 .4062-31.52 12.59l-48 112c-5.219 12.19 .4219 26.31 12.61 31.53C369.6 511.4 372.8 512 375.1 512c9.312 0 18.17-5.438 22.08-14.53l48-112C451.3 373.3 445.6 359.2 433.5 353.9z"],
    "cloud-meatball": [576, 512, [], "f73b", "M384.5 375.6l-16.75-8.748l5.75-17.1c6.125-19.12-7.501-35.87-25.25-35.87c-6 0-8.5 1.25-27.12 7.124l-8.75-16.75c-10.75-20.62-38.13-20.62-48.75 0l-8.75 16.75C237.2 314.4 234.1 312.9 227.8 312.9c-17.75 0-31.38 16.75-25.25 35.87l5.75 17.1l-16.75 8.748c-20.5 10.62-20.75 37.99 0 48.74l16.75 8.748l-5.75 17.1c-6.25 19.87 8.625 36.37 26.12 36.37c3.625 0 12.5-3.249 26.25-7.624l8.75 16.75c10.75 20.62 38.13 20.62 48.75 0l8.75-16.75c13.88 4.374 22.63 7.624 26.25 7.624c17.62 0 32.38-16.37 26.12-36.37l-5.75-17.1l16.75-8.748C405.2 413.5 405.1 386.2 384.5 375.6zM576 255.1c0-59.24-41.5-110.1-97.63-123.7c-9.5-56.86-59-100.2-118.4-100.2c-12.75 0-25.62 2.247-38 6.496C293.6 13.5 257.1 0 220 0C137.8 0 70.12 64.11 64.38 144.1C24.75 167.6 0 209.6 0 255.1c0 70.61 57.38 127.1 128 127.1h18.5c3.75-13.12 12-24.75 23.75-32.74c-1-5.124-1.125-10.25-.875-15.25H128c-44.12 0-80-35.87-80-79.99c0-32.49 19.38-61.49 49.62-73.86L113.2 175.7L112.4 158.7C112.2 157.3 112.2 155.1 112 155.1c0-59.49 48.38-107.1 108-107.1c30.12 0 58.25 12.37 79.13 34.99l12.25 13.25l16.25-8.124c49-24.87 103.5 12.62 104.4 62.49L429.2 174.7l24.88 1.875C495.6 179.7 528 214.6 528 255.8c0 44.12-35.88 79.99-80 79.99h-41.38c.25 4.999 .125 10.12-.75 15.25c11.75 7.999 19.88 19.62 23.75 32.74H448C518.6 383.9 576 326.6 576 255.1zM64 415.9c-17.75 0-32 14.25-32 31.99c0 17.75 14.25 31.99 32 31.99s32-14.25 32-31.99C96 430.2 81.75 415.9 64 415.9zM512 415.9c-17.75 0-32 14.25-32 31.99c0 17.75 14.25 31.99 32 31.99s32-14.25 32-31.99C544 430.2 529.8 415.9 512 415.9z"],
    "cloud-minus": [640, 512, [], "e35d", "M543.3 214.5C543.5 212.3 544 210.2 544 208C544 146.1 493.9 96 432 96c-11.41 0-22.19 2.207-32.56 5.377C368.9 59.51 319.8 32 264 32C170.8 32 95.41 107.9 96.08 200.8C40.24 220.6 0 273.4 0 336C0 415.5 64.47 480 144 480h360c75.11 0 136-60.89 136-136C640 282.7 599.1 231.4 543.3 214.5zM504 432H144c-52.94 0-96-43.07-96-96c0-40.2 25.77-76.36 64.13-89.97l32.19-11.42c-.2734-38.62-.2246-33.15-.293-37.17C145.4 132.4 198.7 80 264 80c38.4 0 73.63 18.1 96.66 49.67l20.14 27.6l32.67-9.988c48.86-14.94 84.23 25.56 81.96 64.4l-2.193 37.72l36.15 10.99C566.8 271.8 592 305.4 592 344C592 392.5 552.5 432 504 432zM400 264H240C226.7 264 216 274.7 216 288c0 13.26 10.73 23.1 24 23.1h160C413.3 311.1 424 301.3 424 288S413.3 264 400 264z"],
    "cloud-moon": [576, 512, [], "f6c3", "M566.5 261.1C484 276.6 408.2 214.1 408.2 131.8c0-47.39 25.68-90.97 67.44-114.5c6.436-3.609 4.816-13.25-2.492-14.58C464.7 1.25 450.7 0 442.1 0C348.2 0 272 75.14 272 168c0 .5703 .1641 1.094 .1699 1.662c3.479 2.164 7.135 4.008 10.46 6.432C284.4 176 286.2 176 288 176c61.69 0 115.7 42.47 131.3 100.1c20.34 14.92 36.18 34.78 46.64 57.19c42.93-5.99 81.37-27.71 108.2-60.36C578.9 268.1 573.8 259.7 566.5 261.1zM390.8 296.4C383.3 246.4 340 208 288 208c-5.125 0-10.25 .375-15.25 1.125C248.5 188 217.3 176 184 176c-64 0-118.3 45.25-132.4 105.3C19.63 305.1 0 343 0 384c0 70.63 57.38 128 128 128h204c64 0 116-52 116-116C448 354.3 425.3 316.8 390.8 296.4zM332 464H128c-44.25 0-80-35.75-80-80c0-32.75 19.75-61 48.13-73.25C96.75 262.8 135.8 224 184 224c31.25 0 58.38 16.25 74.13 40.75c8.625-5.5 18.87-8.75 29.87-8.75C318.9 255.1 344 281.1 344 312c0 5.875-1.25 11.5-2.875 16.88C374.3 333.4 400 361.5 400 396C400 433.6 369.5 464 332 464z"],
    "cloud-moon-rain": [576, 512, [], "f73c", "M148 426.7l-32 48c-7.344 11.03-4.375 25.94 6.657 33.28C126.8 510.7 131.4 512 135.1 512c7.75 0 15.38-3.75 20-10.69l32-48c7.344-11.03 4.375-25.94-6.657-33.28C170.3 412.7 155.4 415.7 148 426.7zM244 426.7l-32 48c-7.344 11.03-4.375 25.94 6.657 33.28C222.8 510.7 227.4 512 231.1 512c7.75 0 15.38-3.75 20-10.69l32-48c7.344-11.03 4.375-25.94-6.657-33.28C266.3 412.7 251.4 415.7 244 426.7zM340.1 426.7l-32 48c-7.344 11.03-4.375 25.94 6.657 33.28C318.8 510.7 323.4 512 327.1 512c7.75 0 15.38-3.75 20-10.69l32-48c7.344-11.03 4.375-25.94-6.657-33.28C362.3 412.7 347.4 415.7 340.1 426.7zM363.4 183.4C351.4 146.6 316.8 120 276 120c-3.125 0-6.125 .25-9.125 .5C245.3 104.8 219.3 96 192 96C139.6 96 94.38 127.3 74.75 173.3C31.38 187.3 0 228 0 276C0 335.6 48.38 384 108 384h200C367.6 384 416 335.6 416 276C416 237.3 395.3 202.4 363.4 183.4zM308 336h-200C74.88 336 48 309.1 48 276S74.88 216 108 216c1.625 0 3.25 .375 4.75 .5C116.6 175.9 150.4 144 192 144c25.25 0 47.38 11.88 62.13 30.12C260.6 170.3 268 168 276 168C300.3 168 320 187.8 320 212c0 1.75-.25 3.375-.5 5.25C347.1 222.6 368 246.8 368 276C368 309.1 341.1 336 308 336zM567.9 223.8C497.6 237.1 432.9 183.5 432.9 113c0-40.63 21.88-78 57.5-98.13c5.5-3.125 4.077-11.37-2.173-12.5C479.6 .7538 470.8 0 461.8 0c-63.82 0-117.2 41.42-136.4 98.44c28.26 12.28 51.46 34.72 64.13 63.87C425.9 188.4 448 230.9 448 276c0 3.541-.4102 6.977-.6699 10.45c4.844 .5195 9.533 1.446 14.52 1.446c44.63 0 85.46-20.15 112.5-53.27C578.6 229.8 574.2 222.6 567.9 223.8zM52.03 426.7l-32 48c-7.344 11.03-4.375 25.94 6.657 33.28C30.78 510.7 35.41 512 39.97 512c7.75 0 15.38-3.75 20-10.69l32-48c7.344-11.03 4.375-25.94-6.657-33.28C74.26 412.7 59.41 415.7 52.03 426.7z"],
    "cloud-music": [640, 512, [], "f8ae", "M543.3 214.5C543.5 212.3 544 210.2 544 208C544 146.1 493.9 96 432 96c-11.41 0-22.19 2.207-32.56 5.377C368.9 59.51 319.8 32 264 32C170.8 32 95.41 107.9 96.08 200.8C40.24 220.6 0 273.4 0 336C0 415.5 64.47 480 144 480h360c75.11 0 136-60.89 136-136C640 282.7 599.1 231.4 543.3 214.5zM504 432H144c-52.94 0-96-43.07-96-96c0-40.2 25.77-76.36 64.13-89.97l32.19-11.42c-.2734-38.62-.2246-33.15-.293-37.17C145.4 132.4 198.7 80 264 80c38.4 0 73.63 18.1 96.66 49.67l20.14 27.6l32.67-9.988c48.86-14.94 84.23 25.56 81.96 64.4l-2.193 37.72l36.15 10.99C566.8 271.8 592 305.4 592 344C592 392.5 552.5 432 504 432zM363.3 176.7l-128 47.25C228.5 226.1 224 232.2 224 239.2l.0073 98.73c-5.25-1.25-10.62-2-16-2c-26.5 0-48 14.38-48 32s21.5 32.01 47.1 32.01s48-14.37 48-31.1L256 283.1l96-37.5l.0073 60.35c-5.25-1.25-10.62-2-16-2c-26.5 0-48 14.38-48 32s21.5 32.01 47.1 32.01s48-14.37 48-31.1l-.0024-143.1c0-5.125-2.375-9.875-6.5-12.88S368 175.2 363.3 176.7z"],
    "cloud-plus": [640, 512, [], "e35e", "M543.3 214.5C543.5 212.3 544 210.2 544 208C544 146.1 493.9 96 432 96c-11.41 0-22.19 2.207-32.56 5.377C368.9 59.51 319.8 32 264 32C170.8 32 95.41 107.9 96.08 200.8C40.24 220.6 0 273.4 0 336C0 415.5 64.47 480 144 480h360c75.11 0 136-60.89 136-136C640 282.7 599.1 231.4 543.3 214.5zM504 432H144c-52.94 0-96-43.07-96-96c0-40.2 25.77-76.36 64.13-89.97l32.19-11.42c-.2734-38.62-.2246-33.15-.293-37.17C145.4 132.4 198.7 80 264 80c38.4 0 73.63 18.1 96.66 49.67l20.14 27.6l32.67-9.988c48.86-14.94 84.23 25.56 81.96 64.4l-2.193 37.72l36.15 10.99C566.8 271.8 592 305.4 592 344C592 392.5 552.5 432 504 432zM400 264H344V207.1C344 194.7 333.3 184 320 184S296 194.7 296 207.1V264H240C226.7 264 216 274.7 216 288c0 13.26 10.73 23.1 24 23.1h56v56C296 381.3 306.7 392 320 392c13.26 0 24-10.74 24-23.1V311.1h56C413.3 311.1 424 301.3 424 288S413.3 264 400 264z"],
    "cloud-rain": [512, 512, [127783, 63293], "26c6", "M410.8 104.3C397.3 61.75 357.1 32 312 32c-13.5 0-26.75 2.625-39.25 7.75C250.3 14.5 218.4 0 184 0c-64 0-116.4 50.25-119.8 113.4C25.63 130.4 0 168.5 0 212C0 271.5 48.38 320 108 320h296C463.6 320 512 271.5 512 212C512 154.8 467.1 107.8 410.8 104.3zM404 272h-296C74.88 272 48 245.1 48 212C48 184 67.13 160 94.38 153.8l20.88-4.875L112.4 124C112.3 122.8 112 121.4 112 120c0-39.75 32.25-72 72-72c25.25 0 48.25 13.12 61.38 35.13l13.38 22.12l21-15C289.4 83.63 300.5 80 312 80c28.62 0 52.38 21.75 55.25 50.38L369.5 152H404c33.13 0 60 26.88 60 60S437.1 272 404 272zM368 464c0 26.51 21.49 48 48 48s48-21.49 48-48s-48.01-95.1-48.01-95.1S368 437.5 368 464zM48 464C48 490.5 69.49 512 96 512s48-21.49 48-48s-48.01-95.1-48.01-95.1S48 437.5 48 464zM208 464c0 26.51 21.49 48 48 48s48-21.49 48-48s-48.01-95.1-48.01-95.1S208 437.5 208 464z"],
    "cloud-rainbow": [576, 512, [], "f73e", "M560.6 48.01C569.3 47.64 576 40.89 576 32.26V16.13c0-8.1-7.625-16.49-16.62-16.12c-140.1 5.1-260.9 87.25-323.5 204.2C220 196.4 202.4 192 184 192c-64 0-116.4 50.25-119.8 113.4C25.62 322.4 0 360.5 0 404C0 463.5 48.38 512 108 512h296C463.6 512 512 463.5 512 404c0-38.5-20.38-71.87-50.75-91.12c23.63-30.62 59-51.1 99.63-56.12C569.3 255.8 576 249.3 576 240.8V224.8c0-9.25-7.75-16.1-16.75-16.12c-61 5.25-113.9 39.12-145.5 87.87c-1-.125-2-.375-3-.5c-5.625-17.75-16-33.12-29.38-45.25c41.25-55.1 105.8-93.87 179.4-98.5C569.3 151.8 576 145.1 576 136.5V120.5c0-9.125-7.625-16.75-16.75-16.25c-91 5.25-170.6 52.1-220 123.5C330.5 225.3 321.4 223.8 312 223.8c-12 0-23.75 2.5-35 6.5C331.2 126.5 436.9 53.64 560.6 48.01zM312 272c28.62 0 52.38 21.75 55.25 50.37l2.25 21.62H404c33.13 0 60 26.87 60 59.1s-26.88 59.1-60 59.1h-296c-33.12 0-60-26.87-60-59.1c0-27.1 19.12-51.1 46.38-58.25l20.87-4.875L112.4 316C112.2 314.8 112 313.4 112 312c0-39.75 32.25-71.1 72-71.1c25.25 0 48.25 13.12 61.38 35.12l13.38 22.12l21-14.1C289.4 275.6 300.5 272 312 272z"],
    "cloud-showers": [512, 512, [], "f73f", "M410.8 104.3C397.3 61.75 358 32 312 32c-13.5 0-26.75 2.625-39.25 7.75C250.3 14.5 218.4 0 184 0c-64 0-116.4 50.25-119.8 113.4C25.63 130.4 0 168.5 0 212C0 271.5 48.38 320 108 320h296C463.6 320 512 271.5 512 212C512 154.8 467.1 107.8 410.8 104.3zM404 272h-296C74.88 272 48 245.1 48 212C48 184 67.13 160 94.38 153.8l20.88-4.875L112.4 124C112.3 122.8 112 121.4 112 120c0-39.75 32.25-72 72-72c25.25 0 48.25 13.12 61.38 35.13l13.38 22.12l21-15C289.4 83.63 300.5 80 312 80c28.62 0 52.38 21.75 55.25 50.38L369.5 152H404c33.13 0 60 26.88 60 60S437.1 272 404 272zM200 384c-13.25 0-24 10.75-24 24v80C176 501.3 186.8 512 200 512S224 501.3 224 488v-80C224 394.8 213.3 384 200 384zM104 352c-13.25 0-24 10.75-24 24v80C80 469.3 90.75 480 104 480S128 469.3 128 456v-80C128 362.8 117.3 352 104 352zM296 352c-13.25 0-24 10.75-24 24v80c0 13.25 10.75 24 24 24S320 469.3 320 456v-80C320 362.8 309.3 352 296 352zM392 384c-13.25 0-24 10.75-24 24v80c0 13.25 10.75 24 24 24S416 501.3 416 488v-80C416 394.8 405.3 384 392 384z"],
    "cloud-showers-heavy": [512, 512, [], "f740", "M410.8 104.3C397.3 61.75 358 32 312 32c-13.5 0-26.75 2.625-39.25 7.75C250.3 14.5 218.4 0 184 0c-64 0-116.4 50.25-119.8 113.4C25.63 130.4 0 168.5 0 212C0 271.5 48.38 320 108 320h296C463.6 320 512 271.5 512 212C512 154.8 467.1 107.8 410.8 104.3zM404 272h-296C74.88 272 48 245.1 48 212C48 184 67.13 160 94.38 153.8l20.75-4.875L112.4 124C112.3 122.8 112 121.4 112 120c0-39.75 32.25-72 72-72c25.25 0 48.25 13.12 61.38 35.13l13.38 22.12l21-15C289.4 83.63 300.5 80 312 80c28.62 0 52.38 21.75 55.25 50.38L369.5 152H404c33.13 0 60 26.88 60 60S437.1 272 404 272zM198.8 353.9c-12.17-5.219-26.3 .4062-31.52 12.59l-47.1 112c-5.219 12.19 .4217 26.31 12.61 31.53C134.1 511.4 138.2 512 141.3 512c9.312 0 18.17-5.438 22.08-14.53l47.1-112C216.6 373.3 210.1 359.2 198.8 353.9zM81.46 353.9c-12.19-5.219-26.3 .4062-31.52 12.59l-47.1 112c-5.219 12.19 .4217 26.31 12.61 31.53C17.63 511.4 20.83 512 23.99 512c9.312 0 18.17-5.438 22.08-14.53l47.1-112C99.29 373.3 93.65 359.2 81.46 353.9zM316.1 353.9c-12.19-5.219-26.3 .4062-31.52 12.59l-47.1 112c-5.219 12.19 .4218 26.31 12.61 31.53C252.3 511.4 255.5 512 258.7 512c9.312 0 18.17-5.438 22.08-14.53l47.1-112C333.1 373.3 328.3 359.2 316.1 353.9zM433.5 353.9c-12.17-5.219-26.28 .4062-31.52 12.59l-47.1 112c-5.219 12.19 .4218 26.31 12.61 31.53C369.6 511.4 372.8 512 375.1 512c9.312 0 18.17-5.438 22.08-14.53l47.1-112C451.3 373.3 445.6 359.2 433.5 353.9z"],
    "cloud-slash": [640, 512, [], "e137", "M144 432c-52.94 0-96-43.07-96-96c0-40.2 25.77-76.36 64.13-89.97l32.19-11.42l-.1758-24.95L98.61 173.1C97.25 182.8 96.01 191.6 96.08 200.8C40.24 220.6 0 273.4 0 336C0 415.5 64.47 480 144 480h345.1l-61.24-48H144zM596.9 442.6C623.3 417.8 640 383 640 344c0-61.33-40.87-112.6-96.65-129.5C543.5 212.3 544 210.2 544 208C544 146.1 493.9 96 432 96c-11.41 0-22.19 2.207-32.56 5.377C368.9 59.51 319.8 32 264 32C215.5 32 172.2 52.88 141.8 85.8L38.82 5.109C34.41 1.672 29.19 0 24.03 0C16.91 0 9.847 3.156 5.129 9.188C-3.059 19.62-1.246 34.72 9.191 42.89L601.2 506.9c10.5 8.203 25.56 6.328 33.69-4.078c8.188-10.44 6.375-25.53-4.062-33.7L596.9 442.6zM558.5 412.5L179.6 115.4C201.2 93.68 230.9 80 264 80c38.4 0 73.63 18.1 96.66 49.67l20.14 27.6l32.67-9.988c48.86-14.94 84.23 25.56 81.96 64.4l-2.193 37.72l36.15 10.99C566.8 271.8 592 305.4 592 344C592 371.8 578.8 396.3 558.5 412.5z"],
    "cloud-sleet": [576, 512, [], "f741", "M544.8 212c0-57.25-44.88-104.3-101.3-107.8C430 61.75 390.8 32 344.8 32c-13.5 0-26.75 2.625-39.25 7.75C283 14.5 251.1 0 216.8 0c-64 0-116.4 50.25-119.8 113.4C58.38 130.4 32.76 168.5 32.76 212c0 59.5 48.38 108 108 108h296C496.4 320 544.8 271.5 544.8 212zM80.76 212c0-28 19.12-52 46.38-58.25l20.75-4.875L145.1 124C145 122.8 144.8 121.4 144.8 120c0-39.75 32.25-72 72-72c25.25 0 48.25 13.12 61.38 35.13l13.38 22.12l21-15C322.1 83.63 333.3 80 344.8 80c28.62 0 52.38 21.75 55.25 50.38L402.3 152h34.5c33.13 0 60 26.88 60 60s-26.88 60-60 60h-296C107.6 272 80.76 245.1 80.76 212zM113.5 353.9c-12.19-5.219-26.3 .4062-31.52 12.59l-47.1 112c-5.219 12.19 .4217 26.31 12.61 31.53C49.63 511.4 52.83 512 55.99 512c9.312 0 18.17-5.438 22.08-14.53l47.1-112C131.3 373.3 125.6 359.2 113.5 353.9zM385.5 353.9c-12.22-5.219-26.28 .4062-31.52 12.59l-47.1 112c-5.219 12.19 .4218 26.31 12.61 31.53C321.6 511.4 324.8 512 327.1 512c9.312 0 18.17-5.438 22.08-14.53l47.1-112C403.3 373.3 397.6 359.2 385.5 353.9zM520 392h-15.1v-16c0-13.25-10.75-24-23.1-24s-23.1 10.75-23.1 24v16h-15.1c-13.25 0-23.1 10.75-23.1 24s10.75 24 23.1 24h15.1v16c0 13.25 10.75 24 23.1 24s23.1-10.75 23.1-24v-16h15.1C533.3 440 544 429.3 544 416S533.3 392 520 392zM264 392H248v-16c0-13.25-10.75-24-23.1-24c-13.25 0-23.1 10.75-23.1 24v16H184c-13.25 0-23.1 10.75-23.1 24s10.75 24 23.1 24H200v16c0 13.25 10.75 24 23.1 24c13.25 0 23.1-10.75 23.1-24v-16h15.1c13.25 0 23.1-10.75 23.1-24S277.3 392 264 392z"],
    "cloud-snow": [512, 512, [63298], "1f328", "M108 320h296C463.6 320 512 271.5 512 212c0-57.25-44.88-104.3-101.3-107.8C397.3 61.75 357.1 32 312 32c-13.5 0-26.75 2.625-39.25 7.75C250.3 14.5 218.4 0 184 0c-64 0-116.4 50.25-119.8 113.4C25.63 130.4 0 168.5 0 212C0 271.5 48.38 320 108 320zM94.38 153.8l20.75-4.875L112.4 124C112.3 122.8 112 121.4 112 120c0-39.75 32.25-72 72-72c25.25 0 48.25 13.12 61.38 35.13l13.38 22.12l21-15C289.4 83.63 300.5 80 312 80c28.62 0 52.38 21.75 55.25 50.38L369.5 152H404c33.13 0 60 26.88 60 60S437.1 272 404 272h-296C74.88 272 48 245.1 48 212C48 184 67.13 160 94.38 153.8zM104 392h-16v-16C88 362.8 77.25 352 64 352s-24 10.75-24 24v16h-16C10.75 392 0 402.8 0 416s10.75 24 24 24h16v16C40 469.3 50.75 480 64 480s24-10.75 24-24v-16h16C117.3 440 128 429.3 128 416S117.3 392 104 392zM488 392h-16v-16c0-13.25-10.75-24-24-24s-24 10.75-24 24v16h-16C394.8 392 384 402.8 384 416s10.75 24 24 24h16v16c0 13.25 10.75 24 24 24s24-10.75 24-24v-16h16c13.25 0 24-10.75 24-24S501.3 392 488 392zM296 424h-16v-16c0-13.25-10.75-24-24-24s-24 10.75-24 24v16h-16C202.8 424 192 434.8 192 448s10.75 24 24 24h16v16C232 501.3 242.8 512 256 512s24-10.75 24-24v-16h16c13.25 0 24-10.75 24-24S309.3 424 296 424z"],
    "cloud-sun": [640, 512, [63172], "26c5", "M128 208C128 247.2 156.2 279.6 193.3 286.5C199.9 277.1 207.3 269.1 215.5 262.8C226.8 226.5 250.3 195.9 280.5 174.7C267.9 147.2 240.3 128 208 128C163.8 128 128 163.8 128 208zM96 208C96.02 146.1 146.2 96.01 208 96.01c44.25 0 82.14 25.89 100.3 63.14C329.3 149.7 352.2 144 376 144c9.805 0 19.48 1.035 29.01 2.709l8.767-12.65c5.145-7.414 .8965-17.67-7.984-19.27L317.2 98.78L301.2 10.21C299.6 1.325 289.4-2.921 281.9 2.226L208 53.54L134.1 2.225C126.6-2.922 116.4 1.324 114.8 10.21L98.78 98.78L10.21 114.8C1.326 116.4-2.922 126.6 2.223 134.1l51.3 73.94L2.224 281.9c-5.145 7.414-.8975 17.67 7.983 19.27L98.78 317.2l16.01 88.58c1.605 8.883 11.86 13.13 19.27 7.982l27.06-18.78C160.9 391.3 160 387.8 160 384c0-24.19 5.697-47.81 15.1-69.22C129.9 300.9 96.02 258.7 96 208zM582.8 296.4C575.3 246.4 532 208 480 208c-5.125 0-10.25 .375-15.25 1.125C440.5 188 409.3 176 376 176c-64 0-118.3 45.25-132.4 105.3C211.6 305.1 192 343 192 384c0 70.63 57.38 128 128 128h204c64 0 116-52 116-116C640 354.3 617.3 316.8 582.8 296.4zM524 464H320c-44.25 0-80-35.75-80-80c0-32.75 19.75-61 48.13-73.25C288.8 262.8 327.8 224 376 224c31.25 0 58.38 16.25 74.13 40.75C458.8 259.3 469 256 480 256c30.88 0 56 25.12 56 56c0 5.875-1.25 11.5-2.875 16.88C566.3 333.4 592 361.5 592 396C592 433.6 561.6 464 524 464z"],
    "cloud-sun-rain": [640, 512, [63299], "1f326", "M162.5 250.1c-76.92-46.82-41.95-162.1 45.52-162.1c23.74 0 45.19 9.513 61.02 24.8c10.82-11.24 23.32-20.62 36.88-28.22L300.4 83.58L286.9 8.637c-.9554-5.29-5.537-8.637-10.35-8.637c-2.027 0-4.097 .5915-5.955 1.881l-62.57 43.42L145.4 1.882C143.6 .5918 141.5-.0003 139.5-.0003c-4.817 0-9.399 3.346-10.35 8.636l-13.54 74.95L40.64 97.13C35.35 98.08 31.1 102.7 31.1 107.5c0 2.026 .5922 4.094 1.881 5.951l43.41 62.57L33.88 238.6C32.59 240.4 32 242.5 32 244.5c0 4.818 3.347 9.398 8.636 10.35l74.95 13.54l13.54 74.95c.9554 5.29 5.537 8.636 10.35 8.636c2.027 0 4.096-.5919 5.954-1.882l26.31-18.27C164.3 314.7 160 295.9 160 276C160 267.5 161 259.1 162.5 250.1zM170.8 222.7c13.54-32.94 39.09-60.06 72.66-74.8c2.424-4.523 5.293-8.709 8.109-12.93C240.6 123.4 225.2 116 208 116C151.9 116 125.1 186.1 170.8 222.7zM555.4 183.4C543.4 146.6 508.8 120 468 120c-3.125 0-6.125 .25-9.125 .5C437.3 104.8 411.3 96 384 96c-52.38 0-97.63 31.25-117.3 77.25C223.4 187.3 192 228 192 276C192 335.6 240.4 384 300 384h200C559.6 384 608 335.6 608 276C608 237.3 587.3 202.4 555.4 183.4zM500 336h-200C266.9 336 240 309.1 240 276S266.9 216 300 216c1.625 0 3.25 .375 4.75 .5C308.6 175.9 342.4 144 384 144c25.25 0 47.38 11.88 62.13 30.12C452.6 170.3 460 168 468 168C492.3 168 512 187.8 512 212c0 1.75-.25 3.375-.5 5.25C539.1 222.6 560 246.8 560 276C560 309.1 533.1 336 500 336zM552 415.1c-7.753 0-15.35 3.752-19.97 10.69l-32 48c-2.73 4.093-4.037 8.719-4.037 13.29C496 501.4 506.9 512 520 512c7.75 0 15.36-3.75 19.98-10.69l32-48c2.731-4.093 4.037-8.719 4.037-13.29C576 426.6 565.1 415.1 552 415.1zM456 415.1c-7.75 0-15.34 3.752-19.98 10.69l-32 48c-2.73 4.093-4.037 8.719-4.037 13.29C400 501.4 410.9 512 423.1 512c7.75 0 15.36-3.75 19.98-10.69l32-48c2.73-4.093 4.037-8.719 4.037-13.29C480 426.6 469.1 415.1 456 415.1zM360 415.1c-7.753 0-15.34 3.752-19.97 10.69l-32 48c-2.73 4.093-4.037 8.719-4.037 13.29C304 501.4 314.9 512 327.1 512c7.75 0 15.36-3.75 19.99-10.69l32-48c2.73-4.093 4.037-8.719 4.037-13.29C384 426.6 373.1 415.1 360 415.1zM264 415.1c-7.755 0-15.35 3.752-19.97 10.69l-32 48c-2.73 4.093-4.037 8.719-4.037 13.29C208 501.4 218.9 512 231.1 512c7.75 0 15.36-3.75 19.98-10.69l32-48c2.73-4.093 4.037-8.719 4.037-13.29C288 426.6 277.1 415.1 264 415.1z"],
    "cloud-word": [640, 512, [], "e138", "M208 352h-32C167.2 352 160 359.2 160 368C160 376.8 167.2 384 176 384h32C216.8 384 224 376.8 224 368C224 359.2 216.8 352 208 352zM368 352h-96C263.2 352 256 359.2 256 368C256 376.8 263.2 384 272 384h96c8.836 0 16-7.164 16-16C384 359.2 376.8 352 368 352zM288 304C288 295.2 280.8 288 272 288h-128C135.2 288 128 295.2 128 304C128 312.8 135.2 320 144 320h128C280.8 320 288 312.8 288 304zM464 352h-32c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16h32c8.836 0 16-7.164 16-16C480 359.2 472.8 352 464 352zM496 287.1h-160c-8.836 0-16 7.164-16 16c0 8.838 7.164 16 16 16h160c8.836 0 16-7.162 16-16C512 295.2 504.8 287.1 496 287.1zM543.4 214.5C543.5 212.3 544 210.2 544 208C544 146.1 493.9 96 432 96c-11.38 0-22.19 2.203-32.56 5.375C368.9 59.52 319.8 32 264 32C170.8 32 95.44 107.9 96.09 200.8C40.22 220.6 0 273.4 0 336C0 415.5 64.5 480 144 480h360c75.13 0 136-60.89 136-136C640 282.7 599.1 231.4 543.4 214.5zM504 432H144c-52.94 0-96-43.08-96-96c0-40.19 25.75-76.34 64.13-89.98l32.19-11.42C144 196 144.1 201.5 144 197.4C145.4 132.5 198.7 80 264 80c38.41 0 73.63 18.11 96.69 49.66l20.12 27.62l32.66-9.984c48.88-14.95 84.22 25.56 81.97 64.42l-2.219 37.72l36.16 10.98C566.8 271.8 592 305.4 592 344C592 392.5 552.5 432 504 432z"],
    "cloud-xmark": [640, 512, [], "e35f", "M543.3 214.5C543.5 212.3 544 210.2 544 208C544 146.1 493.9 96 432 96c-11.41 0-22.19 2.207-32.56 5.377C368.9 59.51 319.8 32 264 32C170.8 32 95.41 107.9 96.08 200.8C40.24 220.6 0 273.4 0 336C0 415.5 64.47 480 144 480h360c75.11 0 136-60.89 136-136C640 282.7 599.1 231.4 543.3 214.5zM504 432H144c-52.94 0-96-43.07-96-96c0-40.2 25.77-76.36 64.13-89.97l32.19-11.42c-.2734-38.62-.2246-33.15-.293-37.17C145.4 132.4 198.7 80 264 80c38.4 0 73.63 18.1 96.66 49.67l20.14 27.6l32.67-9.988c48.86-14.94 84.23 25.56 81.96 64.4l-2.193 37.72l36.15 10.99C566.8 271.8 592 305.4 592 344C592 392.5 552.5 432 504 432zM400.1 207c-9.375-9.375-24.56-9.375-33.94 0l-47.03 47.03L272.1 207c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L286.1 288l-47.03 47.03c-9.375 9.375-9.375 24.56 0 33.94c9.373 9.371 24.56 9.379 33.94 0l47.03-47.03l47.03 47.03c9.373 9.371 24.56 9.379 33.94 0c9.375-9.375 9.375-24.56 0-33.94L353.9 288l47.03-47.03C410.3 231.6 410.3 216.4 400.1 207z"],
    "clouds": [640, 512, [], "f744", "M538.9 296.2C525.4 253.8 486.1 224 440.1 224c-13.5 0-26.76 2.625-39.26 7.75c-1.75-2.125-4.001-3.625-6.001-5.5c17-19 26.51-43.63 26.51-69c0-57.25-46.63-104-104-104c-7.001 0-13.88 .75-20.63 2.125C275.6 21.62 238 0 197.3 0c-51.13 0-96.02 33.88-111.3 81.62C37.26 90.12 0 132.8 0 184c0 57.25 46.76 104 104 104h90.77C193.7 293.8 192.5 299.4 192.2 305.4C153.5 322.4 127.9 360.5 127.9 404c0 59.5 48.38 108 108 108h296.1c59.64 0 108-48.5 108-108C640.1 346.8 595.2 299.8 538.9 296.2zM104 240c-30.88 0-56.01-25.12-56.01-56c0-30.38 24.38-55.25 54.76-56l23.38 .75l3.001-21.25C133.9 73.62 163.3 48 197.3 48c29.01 0 54.39 17.75 64.64 45l9.002 24l23.38-10.62C301.8 103 309.4 101.2 317.3 101.2c30.88 0 56.01 25.13 56.01 56c0 15.88-6.751 30.5-18.88 41.5l-1.25 1.125C340.2 195.1 326.4 192 311.9 192C272.9 192 238 210.9 216.2 240H104zM532.1 464H236c-33.13 0-60.01-26.88-60.01-60c0-28 19.13-52 46.38-58.25l20.88-4.875L240.4 316C240.3 314.8 240 313.4 240 312c0-39.75 32.26-72 72.01-72c25.25 0 48.26 13.12 61.39 35.13l13.38 22.12l21-15C417.5 275.5 428.6 272 440.1 272c28.63 0 52.39 21.75 55.26 50.38L497.6 344h34.51c33.13 0 60.01 26.88 60.01 60S565.2 464 532.1 464z"],
    "clouds-moon": [640, 512, [], "f745", "M630.1 248.7c-78.58 14.79-150.8-44.79-150.8-123.2c0-45.14 24.46-86.64 64.22-109c6.129-3.438 4.588-12.62-2.373-13.89C533.1 1.191 520.5 0 512.3 0c-69.37 0-127.1 43.29-151.1 103.9c31.84 24.83 52.24 63.54 52.24 107.3c0 12.28-1.719 24.34-5.094 36.09c37.04 11.93 67.07 37.73 85.35 70.79C499.1 318.9 506 320 512.5 320c49.97 0 95.57-22.47 125.8-59.25C642.7 255.3 637.9 247.4 630.1 248.7zM382.8 273.9c-3.75-5.75-8.5-10.62-13.12-15.62c7.375-14 11.88-29.88 11.88-47c0-56-44.38-102-99.75-103.9c-23.62-29.62-60-48.13-99-48.13c-40 0-77.13 19-100.9 50.38C35.13 119.5 0 161.4 0 211.3c0 37 19.5 69.13 48.63 87.5c-27.25 22-44.38 55.5-44.38 93.25c0 66.25 53.5 120 119.1 120h238.4c65.75 0 119.3-53.75 119.3-120C481 333 438.6 283.8 382.8 273.9zM47.75 211.3c0-30.88 24.88-56 55.5-56h6.75c12.25-28.12 40.25-48 72.75-48c34.25 0 63 21.88 74.38 52.25c6.5-2.75 13.62-4.25 21.12-4.25c30.62 0 55.5 25.12 55.5 56c0 7.5-1.75 14.25-4.375 20.75C317.1 227.3 304.3 224 290.4 224c-9.625 0-19 1.25-28.12 3.625C242.3 214.9 219 208 195.1 208c-43.5 0-82.88 22.38-105.9 57.25C65.25 258.9 47.75 237.3 47.75 211.3zM361.8 464H123.4c-39.5 0-71.5-32.25-71.5-72c0-37.63 28.75-68 65.13-71.25C124.1 283.9 156.3 256 194.9 256c23.75 0 44.88 10.75 59.38 27.25C264.5 276.3 276.9 272 290.3 272c30 0 55 20.88 61.63 49C355.3 320.5 358.4 320 361.8 320c39.5 0 71.5 32.25 71.5 72C433.4 431.8 401.3 464 361.8 464z"],
    "clouds-sun": [640, 512, [], "f746", "M95.1 208c.0156-61.85 50.15-111.1 111.1-111.1c36.89 0 69.35 18.08 89.76 45.61c7.939-7.496 16.5-14.34 26.21-19.67c3.967-6.971 8.594-13.37 13.52-19.49l-20.26-3.668L301.2 10.21c-1.605-8.883-11.86-13.13-19.27-7.983l-73.94 51.31l-73.94-51.32C126.6-2.922 116.4 1.324 114.8 10.21l-16.01 88.58L10.21 114.8C1.326 116.4-2.922 126.6 2.223 134.1l51.3 73.94l-51.3 73.94c-5.145 7.414-.8982 17.67 7.983 19.27l88.57 15.99l16.01 88.58c1.354 7.488 8.797 11.3 15.56 9.348C129.2 407.5 128 399.9 128 392c0-31.74 9.822-61.36 26.8-86.03C119.9 286.1 96.01 250.5 95.1 208zM127.1 208c.0137 32.79 19.79 60.88 48.03 73.23C187.1 270.9 199.7 262 213.9 255.3C225.5 235.7 241.1 218.8 259.1 205.5c3.357-13.62 9.428-26.13 16.73-37.84C262.8 144 237.4 128 207.1 128C163.8 128 128 163.8 127.1 208zM640 236.8c0-50.75-38.5-92.88-87.75-98.5C532 103.4 494.4 80 452 80c-46 0-85.88 26.38-104.5 66C315.8 159.8 293.1 189.6 288.9 225C266.6 237.8 248.3 256.8 236.8 280.3C191.4 297.6 160 341.1 160 392C160 458.3 213.8 512 280 512h240c66.25 0 120-53.75 120-120c0-32-12.75-60.75-33.25-82.25C626.8 291.6 640 266 640 236.8zM520 464h-240c-39.75 0-72-32.25-72-72c0-37.63 28.88-68 65.5-71.25C280.8 283.9 313 256 352 256c23.88 0 45.13 10.75 59.75 27.25C422.1 276.3 434.6 272 448 272c30.25 0 55.25 20.88 61.1 49C513.3 320.5 516.5 320 520 320c39.75 0 72 32.25 72 72S559.8 464 520 464zM565.6 281.3c-7.875-3.125-15.88-6-24.5-7.5C520.8 243.3 486.4 224 448 224c-9.625 0-19.25 1.25-28.25 3.625C399.5 214.9 376.1 208 352 208c-2.25 0-4.25 .375-6.375 .5c8.75-12.88 22.75-21.88 39.38-22.62c4.875-32.63 32.88-57.75 67-57.75c35.75 0 64.75 27.75 67.5 62.88c6.5-3.125 13.62-5.25 21.25-5.25C569.1 185.8 592 208.6 592 236.9C592 256 581.3 272.6 565.6 281.3z"],
    "clover": [512, 512, [], "e139", "M500.3 255.7c7.406-12.47 11.34-26.78 11.34-41.72c0-45.16-36.75-81.91-81.91-81.91c-18 0-38.94 4.281-62.59 12.75c8.469-23.66 12.75-44.59 12.75-62.59C379.9 36.91 343.2 0 297.1 0C283 0 268.4 4.125 255.7 11.69C243.3 4.281 228.9 .3438 213.1 .3438c-45.16 0-81.91 36.75-81.91 81.91c0 18 4.281 38.94 12.75 62.59C121.2 136.4 100.3 132.1 82.25 132.1C36.91 132.1 0 168.8 0 214c0 15 4.125 29.62 11.69 42.28C4.281 268.8 .3438 283.1 .3438 298c0 45.16 36.75 81.91 81.91 81.91c18 0 38.94-4.281 62.59-12.75c-8.469 23.66-12.75 44.59-12.75 62.59C132.1 475.1 168.8 512 213.1 512c15 0 29.63-4.125 42.28-11.69c12.47 7.406 26.78 11.34 41.72 11.34c45.16 0 81.91-36.75 81.91-81.91c0-18-4.281-38.94-12.75-62.59c23.66 8.469 44.59 12.75 62.59 12.75C475.1 379.9 512 343.2 512 298C512 283 507.9 268.4 500.3 255.7zM429.8 331.9c-23.25 0-58.59-12.16-99.56-34.22c-9.281-5.031-20.81-3.344-28.34 4.156c-7.5 7.5-9.188 19.03-4.156 28.34c22.06 40.97 34.22 76.31 34.22 99.56c0 18.69-15.22 33.91-33.91 33.91c-9.312 0-18.03-3.719-24.5-10.44c-4.531-4.688-10.75-7.344-17.28-7.344c-6.562 .0313-12.94 2.75-17.44 7.531C232.3 460.3 223.5 464 213.1 464c-18.69 0-33.91-15.38-33.91-34.25c0-23.25 12.16-58.59 34.22-99.56c5.031-9.312 3.344-20.84-4.156-28.34C205.5 297.2 199.4 294.8 193.2 294.8c-3.875 0-7.812 .9375-11.38 2.875c-40.97 22.06-76.31 34.22-99.56 34.22c-18.69 0-33.91-15.22-33.91-33.91c0-9.312 3.719-18.03 10.44-24.5C63.5 268.1 66.16 262.7 66.13 256.1S63.38 243.3 58.59 238.8C51.75 232.3 48 223.5 48 214c0-18.69 15.38-33.91 34.25-33.91c23.25 0 58.59 12.16 99.56 34.22c9.312 5.031 20.84 3.344 28.34-4.156s9.188-19.03 4.156-28.34C192.3 140.8 180.1 105.5 180.1 82.25c0-18.69 15.22-33.91 33.91-33.91c9.313 0 18.03 3.719 24.5 10.44c4.531 4.688 10.75 7.344 17.28 7.344c7.094 1.25 12.91-2.75 17.44-7.531C279.7 51.75 288.5 48 297.1 48c18.69 0 33.91 15.38 33.91 34.25c0 23.25-12.16 58.59-34.22 99.56c-5.031 9.312-3.344 20.84 4.156 28.34c7.531 7.5 19.09 9.219 28.34 4.156c40.97-22.06 76.31-34.22 99.56-34.22c18.69 0 33.91 15.22 33.91 33.91c0 9.312-3.719 18.03-10.44 24.5c-4.719 4.531-7.375 10.84-7.344 17.41s2.75 12.81 7.531 17.31C460.3 279.7 464 288.5 464 298C464 316.7 448.6 331.9 429.8 331.9z"],
    "club": [512, 512, [62247], "2663", "M394.2 160.1C395.4 152.9 396 145.6 396 138.3C396 62.03 333.2 0 256 0S116 62.03 116 138.3c0 7.312 .5938 14.59 1.781 21.81C50.66 173.6 0 232.3 0 302.6C0 382.8 66.06 448 147.3 448C176.5 448 206.6 438.4 232 422.1V464h-48C170.8 464 160 474.8 160 488S170.8 512 184 512h144c13.25 0 24-10.75 24-24s-10.75-24-24-24h-48v-41.88C305.4 438.4 335.5 448 364.8 448C445.9 448 512 382.8 512 302.6C512 232.3 461.3 173.6 394.2 160.1zM364.8 400c-33 0-70.41-19.66-88.94-46.72c-.3535-.5176-.9766-.7324-1.367-1.217c-1.578-1.967-3.428-3.543-5.541-4.93c-.8887-.582-1.615-1.275-2.572-1.734C263.2 343.9 259.7 342.8 256 342.8s-7.174 1.088-10.33 2.617c-.957 .459-1.684 1.152-2.572 1.734c-2.113 1.387-3.963 2.963-5.541 4.93c-.3906 .4844-1.014 .6992-1.367 1.217C217.7 380.3 180.3 400 147.3 400C92.53 400 48 356.3 48 302.6S92.53 205.2 144.7 205C153.5 206.3 163.6 202.2 168.6 194.6C173.1 187.9 173.9 179.5 170.8 172.1C166.3 161.2 164 149.8 164 138.3C164 88.5 205.3 48 256 48s92 40.5 92 90.28c0 11.5-2.312 22.88-6.844 33.81c-3.062 7.406-2.219 15.84 2.219 22.53c4.469 6.656 11.97 10.66 19.97 10.66c.625 0 1.531-.0625 2.375-.125C420 205.7 464 249.2 464 302.6C464 356.3 419.5 400 364.8 400z"],
    "coconut": [512, 512, [], "e2f6", "M323.3 101.3C302.8 80.9 236.6 114.2 175.4 175.6C114.1 236.9 81.07 303.2 101.5 323.6C121.1 343.1 188.2 310.7 249.4 249.3C310.7 187.9 343.7 121.6 323.3 101.3zM437.4 67.21c-43.56-43.57-42.33-42.77-46.7-45.27C372.8 7.393 349.7 0 322.9 0c-63.44 0-145.3 38.98-214.6 108.3c-102.2 102.2-138.5 231.8-80.99 289.3l39.89 39.89C116.9 487.2 182.1 512 247.2 512C465.9 512 605.1 235.8 437.4 67.21zM60.95 363.5c-4.393-4.393-7.709-10.01-9.92-16.79c-2.213-6.781-3.326-14.74-3.326-23.81c0-52.45 36.98-123.3 94.22-180.6c14.33-14.33 29.51-27.39 45.05-38.92C233.6 68.83 283.4 48 322.9 48c18.34 0 32.13 4.494 40.1 13.36c8.783 8.785 13.24 22.45 13.24 40.6c0 52.45-36.98 123.3-94.22 180.6C225.6 339.9 154.6 376.9 101.9 376.9C83.61 376.9 69.82 372.4 60.95 363.5zM415.8 379.8l-35.38-35.26c-9.404-9.375-24.59-9.312-33.93 .0625c-9.342 9.391-9.342 24.58 .0625 33.94l35.41 35.28c-24.18 20.88-52.42 35.57-82.88 43.42l-34.17-34.17c-9.375-9.375-24.56-9.375-33.93 0c-9.373 9.375-9.373 24.56 0 33.94l6.566 6.566c-41.41-1.877-80.53-15.85-113.4-40.28c59.61-7.711 130.9-45.14 192.4-106.6c61.56-61.56 98.97-132.1 106.6-192.6c24.68 32.98 38.78 72.3 40.62 113.9l-6.863-6.863c-9.373-9.375-24.56-9.375-33.93 0s-9.373 24.56 0 33.94l34.37 34.38C449.7 328.8 435.7 356.2 415.8 379.8z"],
    "code": [640, 512, [], "f121", "M169.5 119.6C160.5 109.9 145.3 109.4 135.6 118.5l-128 120C2.75 243 0 249.4 0 256S2.75 268.1 7.594 273.5l128 120C140.2 397.8 146.1 400 151.1 400c6.406 0 12.79-2.531 17.51-7.594c9.062-9.656 8.594-24.84-1.094-33.91L59.09 256l109.3-102.5C178.1 144.4 178.6 129.3 169.5 119.6zM390.4 .875c-12.81-3.531-25.97 3.969-29.5 16.75l-128 464c-3.531 12.78 3.969 26 16.75 29.5C251.8 511.7 253.9 512 256 512c10.53 0 20.19-6.969 23.12-17.62l128-464C410.7 17.59 403.2 4.375 390.4 .875zM632.4 238.5l-128-120c-9.656-9.062-24.88-8.594-33.91 1.094c-9.062 9.656-8.594 24.84 1.094 33.91L580.9 256l-109.3 102.5c-9.688 9.062-10.16 24.25-1.094 33.91C475.2 397.5 481.6 400 488 400c5.875 0 11.77-2.156 16.4-6.5l128-120C637.3 268.1 640 262.6 640 256S637.3 243 632.4 238.5z"],
    "code-branch": [448, 512, [], "f126", "M448 80C448 35.82 412.2 0 368 0C323.8 0 288 35.82 288 80c0 35.77 23.62 65.69 56 75.93V192c0 22.06-17.94 40-40 40h-160c-14.48 0-27.94 3.848-40 10.06V155.9C136.4 145.7 160 115.8 160 80C160 35.82 124.2 0 80 0C35.82 0 0 35.82 0 80c0 35.77 23.62 65.69 56 75.93v200.1C23.63 366.3 0 396.2 0 432C0 476.2 35.82 512 80 512C124.2 512 160 476.2 160 432c0-35.77-23.62-65.69-56-75.93V320c0-22.06 17.94-40 40-40h160c48.53 0 88-39.47 88-88V155.9C424.4 145.7 448 115.8 448 80zM80 48c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S62.36 48 80 48zM80 464c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S97.64 464 80 464zM368 112c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S385.6 112 368 112z"],
    "code-commit": [640, 512, [], "f386", "M616 232h-138.4C465.9 155.1 400.1 96 320 96S174.1 155.1 162.4 232H24C10.75 232 0 242.8 0 256s10.75 24 24 24h138.4C174.1 356.9 239.9 416 320 416s145.9-59.11 157.6-136H616C629.3 280 640 269.3 640 256S629.3 232 616 232zM320 368c-61.76 0-112-50.24-112-112S258.2 144 320 144s112 50.24 112 112S381.8 368 320 368z"],
    "code-compare": [512, 512, [], "e13a", "M278.8 94.44c-.2703-4.742-2.632-9.115-6.44-11.93L172 8.099C167 4.346 160.3 3.945 154.9 6.853c-5.465 2.972-8.733 8.792-8.379 15l3.187 55.91L133.7 78.67C85.26 81.43 48.1 123.1 50.86 171.5l10.25 179.8c-31.74 12.07-53.62 43.29-51.59 78.99c2.514 44.11 40.31 77.83 84.42 75.32c44.11-2.514 77.83-40.31 75.32-84.42C167.2 385.5 141.9 356.1 109 348.6L98.78 168.8c-1.255-22.03 15.63-40.96 37.66-42.21L152.4 125.7l3.187 55.91c.3539 6.209 4.262 11.62 10.03 13.95C167.8 196.4 170.2 196.8 172.5 196.7c3.666-.2089 7.23-1.664 10.02-4.296l91.29-85.33C277.3 103.8 279.1 99.18 278.8 94.44zM121.3 423.9c1.004 17.62-12.51 32.76-30.13 33.77c-17.62 1.004-32.77-12.51-33.77-30.13c-1.004-17.62 12.51-32.76 30.13-33.77C105.2 392.8 120.3 406.3 121.3 423.9zM418.1 6.377c-44.11 2.514-77.83 40.31-75.32 84.42c2.035 35.71 27.32 64.24 60.23 72.62l10.25 179.8c1.255 22.03-15.63 40.96-37.66 42.21l-15.97 .9105l-3.186-55.91c-.3539-6.209-4.262-11.62-10.03-13.95c-5.715-2.241-12.32-1.113-16.88 3.184l-91.29 85.33c-3.462 3.233-5.312 7.846-5.042 12.59c.2703 4.742 2.632 9.115 6.44 11.93l100.4 74.41c3.073 2.298 6.779 3.338 10.44 3.129c2.293-.1307 4.589-.7624 6.685-1.883c5.465-2.972 8.733-8.792 8.379-15l-3.187-55.91l15.97-.9104c48.45-2.762 85.61-44.41 82.85-92.86l-10.25-179.8c31.74-12.07 53.62-43.29 51.59-78.99C499.1 37.58 462.2 3.862 418.1 6.377zM424.4 118.2c-17.62 1.004-32.77-12.51-33.77-30.13c-1.004-17.62 12.51-32.76 30.13-33.77c17.62-1.004 32.76 12.51 33.77 30.13S442 117.2 424.4 118.2z"],
    "code-fork": [448, 512, [], "e13b", "M448 80C448 35.82 412.2 0 368 0S288 35.82 288 80c0 35.76 23.62 65.69 56 75.93V192c0 22.06-17.94 40-40 40h-160C121.9 232 104 214.1 104 192V155.9C136.4 145.7 160 115.8 160 80C160 35.82 124.2 0 80 0S0 35.82 0 80c0 35.76 23.62 65.69 56 75.93V192c0 48.53 39.47 88 88 88h56v76.07C167.6 366.3 144 396.2 144 432c0 44.18 35.82 80 80 80s80-35.82 80-80c0-35.76-23.62-65.69-56-75.93V280h56c48.53 0 88-39.47 88-88V155.9C424.4 145.7 448 115.8 448 80zM80 48c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S62.36 48 80 48zM224 464c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S241.6 464 224 464zM368 112c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S385.6 112 368 112z"],
    "code-merge": [448, 512, [], "f387", "M368 192c-35.76 0-65.69 23.62-75.93 56H224c-56.89 0-104.4-39.89-116.7-93.09C137.1 143.7 160 114.6 160 80C160 35.82 124.2 0 80 0C35.82 0 0 35.82 0 80c0 35.77 23.62 65.69 56 75.93v200.1C23.63 366.3 0 396.2 0 432C0 476.2 35.82 512 80 512C124.2 512 160 476.2 160 432c0-35.77-23.62-65.69-56-75.93V245.2C134.5 276.5 176.1 296 224 296h68.07C302.3 328.4 332.2 352 368 352c44.18 0 80-35.82 80-80S412.2 192 368 192zM80 48c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S62.36 48 80 48zM80 464c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S97.64 464 80 464zM368 304c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S385.6 304 368 304z"],
    "code-pull-request": [512, 512, [], "e13c", "M160 95.1c0-44.18-35.82-80-80-80c-44.18 0-80 35.82-80 80c0 35.77 23.62 65.69 56 75.93v168.1C23.63 350.3 0 380.2 0 415.1c0 44.18 35.82 80 80 80c44.18 0 80-35.82 80-80c0-35.77-23.62-65.69-56-75.93V171.9C136.4 161.7 160 131.8 160 95.1zM112 415.1c0 17.64-14.36 32-32 32s-32-14.36-32-32c0-17.64 14.36-32 32-32S112 398.4 112 415.1zM80 127.1c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S97.64 127.1 80 127.1zM456 340.1V159.1c0-48.53-39.47-88-88-88H352V15.99c0-6.219-3.594-11.84-9.219-14.5c-5.594-2.594-12.25-1.778-17.03 2.222l-96 80C226.1 86.75 224 91.25 224 95.1c0 4.75 2.094 9.25 5.75 12.28l96 80C328.7 190.7 332.3 191.1 336 191.1c2.312 0 4.625-.502 6.781-1.502C348.4 187.8 352 182.2 352 175.1V119.1h16c22.06 0 40 17.94 40 40v180.1C375.6 350.3 352 380.2 352 415.1c0 44.18 35.82 80 80 80c44.18 0 80-35.82 80-80C512 380.2 488.4 350.3 456 340.1zM432 447.1c-17.64 0-32-14.36-32-32c0-17.64 14.36-32 32-32s32 14.36 32 32C464 433.6 449.6 447.1 432 447.1z"],
    "code-simple": [576, 512, [], "e13d", "M208.1 71.03c-9.375-9.375-24.56-9.375-33.94 0l-168 168c-9.375 9.375-9.375 24.56 0 33.94l168 168C179.7 445.7 185.9 448 192 448s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L57.94 256l151-151C218.3 95.59 218.3 80.41 208.1 71.03zM568.1 239l-168-168c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L518.1 256l-151 151c-9.375 9.375-9.375 24.56 0 33.94C371.7 445.7 377.9 448 384 448s12.28-2.344 16.97-7.031l168-168C578.3 263.6 578.3 248.4 568.1 239z"],
    "coffee-bean": [448, 512, [], "e13e", "M435.8 130.5c-9.9-23.33-65.71-77.27-82.65-84.81C332.1 36.3 309.9 32 287.2 32C219.8 32 148.4 69.66 93.44 124.7c-72.35 72.44-116.1 174.8-81.27 256.8c9.9 23.33 65.7 77.27 82.65 84.81C115.9 475.7 138.1 480 160.9 480c67.34 0 138.7-37.67 193.6-92.7C426.9 314.9 470.6 212.5 435.8 130.5zM127.5 158.6C176.6 109.4 236.3 80 287.1 80c16.24 0 31.5 3.027 45.37 8.998c5.111 3.217 13.72 10.62 22.84 19.31c-23.39 75.84-69.77 121.2-138.7 134.2c-74.55 14.06-129.5 56.87-159.4 121.7c-.2422-.4121-.7031-.9941-.8945-1.365C29 298.3 72.36 213.8 127.5 158.6zM320.5 353.4C271.4 402.6 211.7 432 160.9 432c-16.24 0-31.5-3.027-45.37-9c-5.086-3.199-13.63-10.55-22.7-19.18c20.95-62.9 65.34-101.5 132.7-114.2c78.09-14.67 134.6-63.12 166.1-140.5c.0078 .0156-.0078-.0156 0 0C418.1 213.7 375.6 298.2 320.5 353.4z"],
    "coffee-beans": [512, 512, [], "e13f", "M170.2 196.4C162 193.3 144.4 192 127.3 192c-16.83 0-33.06 1.297-39.01 3.449C29.4 216.8-.0469 283.8 0 351.6c.0449 66.77 28.7 134.1 85.8 155.9C93.97 510.7 111.6 512 128.7 512c16.83 0 33.06-1.297 39.01-3.451c58.92-21.33 88.37-88.34 88.32-156.2C255.1 285.6 227.3 218.2 170.2 196.4zM111.2 463.4c-4.756-.3691-7.926-.8145-9.361-1.102c-37.13-14.1-53.8-66.21-53.83-110.7C47.97 311 62.39 265.3 93.84 246.2c-16.13 43.87-11.81 87.11 13.72 124.4C128 400.7 129.1 431.9 111.2 463.4zM166.7 455.2c11.04-37.78 4.574-76.39-19.48-111.7c-20.75-30.32-20.02-64.84 1.797-102.5c2.35 .2578 4.256 .5156 5.191 .7031c37.13 14.1 53.79 66.21 53.82 110.7C208 391.1 195.1 434.7 166.7 455.2zM455.6 56.93C421.8 23.23 377.1 0 334.4 0c-14.98 0-29.73 2.852-43.69 9.106c-15.31 6.859-51.31 44.04-56.53 55.17C208.5 119 234.1 184.8 280.4 231c33.74 33.7 78.42 56.93 121.2 56.93c14.98 0 29.73-2.852 43.69-9.106c15.31-6.859 51.31-44.04 56.53-55.17C527.5 168.1 501.9 103.2 455.6 56.93zM424.6 235.5c-6.99 2.947-14.71 4.439-22.98 4.439c-27.33 0-60.77-16.44-87.26-42.89c-24.65-24.61-44.18-59.9-41.79-91.41c21.45 35.34 53.63 58.46 94.51 66.15c33.6 6.328 56.2 25.03 68.68 54.34C431.4 230.2 427.3 233.8 424.6 235.5zM375.1 124.6c-34.92-6.57-59.39-28.59-73.04-65.35c3.328-2.967 6.328-5.439 8.471-6.832c6.99-2.947 14.71-4.439 22.98-4.439c27.33 0 60.77 16.44 87.26 42.89c23.36 23.33 42.15 56.25 42.04 86.46C443.2 149.9 413.4 131.7 375.1 124.6z"],
    "coffee-pot": [512, 512, [], "e002", "M428 175L480 32H88C39.4 32 0 71.4 0 120v80C0 213.3 10.75 224 23.1 224S48 213.3 48 200V120c0-22.09 17.91-40 40-40h25.5l34.75 95.5C96.88 215.2 64 276.1 64 344.6c0 51.5 18.62 84.74 49.62 117.7C124.5 473.6 139.5 480 155.1 480l265.8 0c15.53 0 30.66-6.274 41.32-17.57C493.3 429.5 512 396.2 512 344.6C512 276.9 480 215.1 428 175zM411.5 80L382.4 160H193.6L164.5 80H411.5zM114.1 320C121.2 273.8 148.2 234.1 186.2 208h205.9c37.25 26.12 63 66.25 69.75 112H114.1z"],
    "coffin": [448, 512, [63174], "26b0", "M406.5 115.2l-107.8-105.9C292.6 3.375 284.3 0 275.6 0H172.4C163.7 0 155.4 3.375 149.2 9.375L41.46 115.2c-8.002 7.875-11.25 19.38-8.502 30.38l87.14 342.1C123.7 502 136.7 512 151.7 512h144.7c14.88 0 27.88-9.1 31.51-24.25l87.14-342.1C417.8 134.6 414.5 123.1 406.5 115.2zM284.5 464H163.5l-81.64-321.1L178.5 48h91.02l96.64 94.88L284.5 464z"],
    "coffin-cross": [384, 512, [], "e051", "M374.5 115.3l-107.8-105.9C260.6 3.375 252.3 0 243.6 0h-103.3C131.7 0 123.4 3.375 117.2 9.375l-107.8 105.9c-8.002 7.875-11.25 19.38-8.502 30.38l87.14 342.1C91.73 502 104.7 512 119.7 512h144.7c14.88 0 27.88-9.1 31.51-24.25l87.14-342.1C385.8 134.6 382.5 123.1 374.5 115.3zM252.5 464H131.5l-81.64-321.1L146.5 48h91.02l96.64 94.88L252.5 464zM216 120C216 106.7 205.3 96 192 96C178.7 96 167.1 106.7 167.1 120V160H119.1c-13.25 0-23.1 10.74-23.1 23.1S106.7 208 119.1 208h48.02v119.1C167.1 341.3 178.7 352 191.1 352c13.26 0 24.01-10.75 24.01-24V208h48.01c13.26 0 24-10.75 24-24C288 170.7 277.3 160 264 160h-48.02V120z"],
    "coin": [512, 512, [63580], "1fa99", "M256 64C114.6 64 0 128.5 0 208V320c0 70.75 114.6 128 256 128s256-57.25 256-128V208C512 128.5 397.4 64 256 64zM88 363.4C62.38 349.1 48 333.2 48 320V291.8C60.38 301.4 73.88 309.6 88 316.5V363.4zM184 394.2c-21.75-3.375-43.25-8.875-64-16.37v-48c20.75 7.25 42.25 12.74 64 16.24V394.2zM296 398.2C283.2 399.4 269.9 400 256 400c-13.88 0-27.25-.625-40-1.75v-48.12C229.1 351.2 242.4 352 256 352s26.88-.75 40-1.875V398.2zM392 378c-20.75 7.375-42.25 12.87-64 16.25V346.1c21.75-3.5 43.25-8.988 64-16.24V378zM464 320c0 13.25-14.38 29.12-40 43.38V316.5c14.12-6.875 27.62-15.12 40-24.75V320zM256 304c-119 0-208-50.62-208-96s89-96 208-96s208 50.62 208 96S375 304 256 304z"],
    "coins": [512, 512, [], "f51e", "M192 129.4c-96 0-192 28.88-192 86.65v208C0 481.8 96.59 512 192 512s192-30.23 192-88v-208C384 158.2 288 129.4 192 129.4zM336 424c0 10.28-49.5 40-144 40s-144-29.72-144-40v-43.89C84.99 398.5 138.7 408 192 408s107-9.467 144-27.89V424zM336 320c0 10.28-49.5 40-144 40S48 330.3 48 320V276.1C84.99 294.5 138.7 304 192 304s107-9.467 144-27.89V320zM192 256C97.5 256 48 226.3 48 216S97.5 176 192 176s144 29.72 144 40S286.5 256 192 256zM320 0C205.8 0 135.1 39.84 135.1 68.41c0 10.17 7.99 24.03 23.98 24.03C182.4 92.44 189.7 48 320 48c94.5 0 144 29.72 144 40c0 1.875-6.906 13.8-39.75 24.98c-9.969 3.406-16.26 12.74-16.26 22.72c0 13.2 10.73 23.99 24.01 23.99c8.566 0 27.43-9.177 32-11.46V192c0 1.922-7.062 14.02-40.56 25.27c-10.05 3.367-16.38 12.72-16.38 22.74c0 13.28 10.79 24.01 24.01 24.01c9.054 0 29.74-10.22 32.94-11.82V296c0 1.875-6.906 13.8-39.75 24.98c-9.969 3.406-16.26 12.74-16.26 22.72c0 13.2 10.73 23.99 24.01 23.99c6.28 0 80-21.24 80-71.7v-208C512 30.23 415.4 0 320 0z"],
    "colon": [128, 512, [], "3a", "M64 192c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C.0008 163.3 28.66 192 64 192zM64 112c8.822 0 16 7.178 16 16S72.82 144 64 144S48 136.8 48 128S55.18 112 64 112zM64 320c-35.35 0-64 28.65-64 64c0 35.35 28.65 64 64 64s64-28.65 64-64C128 348.7 99.35 320 64 320zM64 400c-8.822 0-16-7.178-16-16s7.178-16 16-16s16 7.178 16 16S72.82 400 64 400z"],
    "colon-sign": [320, 512, [], "e140", "M278.1 352.2c-17.43 17.52-38.94 29.17-62.23 35.12l56.27-232.4c1.932 1.734 4.118 3.074 5.964 4.93c9.377 9.406 24.57 9.406 33.96 .0625c9.393-9.344 9.424-24.53 .0781-33.94c-8.51-8.543-17.74-16.09-27.5-22.7l17.81-73.58c3.11-12.91-4.798-25.87-17.69-28.97c-12.89-3.156-25.85 4.812-28.98 17.66l-15.45 63.83c-9.409-3.146-18.95-5.748-28.84-7.326l10.94-45.19c3.11-12.91-4.798-25.87-17.69-28.97c-12.86-3.156-25.87 4.812-28.98 17.66l-13.47 55.63C121.9 78.52 83.41 96.01 53.6 125.9C-17.87 197.7-17.87 314.3 53.59 386.1c8.77 8.803 18.29 16.57 28.39 23.31L64.31 482.3c-3.11 12.91 4.798 25.87 17.69 28.97c1.891 .4687 3.798 .6875 5.658 .6875c10.83 0 20.66-7.375 23.32-18.34l15.38-63.54c9.424 3.094 18.99 5.609 28.89 7.133L144.3 482.3c-3.11 12.91 4.798 25.87 17.69 28.97c1.891 .4687 3.798 .6875 5.658 .6875c10.83 0 20.66-7.375 23.32-18.34l13.49-55.73c40.91-4.736 78.96-22.19 108.5-51.86c9.346-9.406 9.315-24.59-.0781-33.94C303.5 342.8 288.3 342.8 278.1 352.2zM87.61 352.2C34.77 299.2 34.77 212.8 87.63 159.8c17.72-17.81 39.62-29.62 63.35-35.46l-56.52 233.5C92.22 355.9 89.73 354.3 87.61 352.2zM137.6 383.6l63.39-261.9c9.95 1.307 19.63 3.533 28.93 6.965l-63.34 261.7C156.6 389.1 146.9 386.1 137.6 383.6z"],
    "columns-3": [640, 512, [], "e361", "M576 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V96C640 60.65 611.3 32 576 32zM392 80v352h-144v-352H392zM48 416V96c0-8.822 7.178-16 16-16h136v352H64C55.18 432 48 424.8 48 416zM592 416c0 8.822-7.178 16-16 16h-136v-352H576c8.822 0 16 7.178 16 16V416z"],
    "comet": [512, 512, [], "e003", "M308.4 263.1l-61.01-9l-27.38-55.5c-2.25-4.625-7.001-7.5-12-7.5c-5.125 0-9.751 2.875-12 7.5l-27.38 55.5l-61.13 9C102.3 264.6 98.22 268.2 96.59 273.1C95.09 277.8 96.34 283.2 100.1 286.7l44.25 43.25l-10.5 61c-.8751 5 1.125 10.12 5.25 13.12s9.626 3.375 14.13 1l54.75-29.02l54.64 29.02c4.5 2.375 10 2 14.13-1c4.125-3 6.126-8.125 5.375-13.12l-10.5-61l44.25-43.25c3.625-3.5 5-8.875 3.375-13.75C317.6 268.2 313.5 264.6 308.4 263.1zM502.4 9.722c-8.626-8.75-21.38-11.88-33.13-8.25c-28.38 8.5-95.01 29.12-153.3 52.25c-4-10.25-12.13-18.38-22.38-22.25s-21.75-3.125-31.5 1.1c-42.25 22-146.3 79.13-203.5 136.3c-78.13 78.13-78.13 205.4 0 283.5c78.38 78.38 205.3 78.38 283.7 0c57.01-57 114.4-161.2 136.4-203.4c5.125-9.75 5.75-21.12 1.875-31.5c-3.875-10.25-12-18.38-22.38-22.38c23.25-58.5 43.88-124.9 52.38-153.1C514.1 31.1 511 18.35 502.4 9.722zM430.7 237.7c-23.88 44.75-74.01 133.1-122.5 181.5c-28.5 28.63-67.38 44.75-107.8 44.75c-40.5 0-79.26-16.12-107.9-44.75c-59.38-59.37-59.38-156.1 0-215.6c49.13-49.12 141.8-101.1 181.6-122.4c2.5 8 4.375 14.38 11 37.38l25-10.62c47.5-20.5 107.4-40.25 146.3-52.5c-12.25 38.88-31.88 98.5-52.38 146.4l-10.75 24.88C421.6 235.1 424.7 236.1 430.7 237.7z"],
    "comma": [192, 512, [], "2c", "M156.4 327.4c-8.775-24.27-33.94-39.39-58.1-39.39c-9.959 .002-19.91 2.39-28.8 7.544c-15.66 9.051-26.41 24.44-29.45 42.25l-22.57 131.7c-2.986 17.32 6.9 34.29 23.49 40.31C44.12 511.3 48.34 511.1 52.51 511.1c12.67 0 24.82-6.604 31.51-18.03l67.69-115.4C160.8 363 162.5 344.4 156.4 327.4zM110.3 354.3l-35.78 60.99l11.9-69.42c.6387-3.734 2.824-6.854 6.209-8.809C94.15 336.2 96.04 336 97.36 335.1c5.896 .002 12.37 3.605 13.88 7.768C112.5 347.3 112.2 351.1 110.3 354.3z"],
    "command": [448, 512, [], "e142", "M352 288h-48V224H352c53.02 0 96-42.98 96-96s-42.98-96-96-96s-96 42.98-96 96v48H192V128c0-53.02-42.98-96-96-96S0 74.98 0 128s42.98 96 96 96h48v64H96c-53.02 0-96 42.98-96 96s42.98 96 96 96s96-42.98 96-96v-48h64V384c0 53.02 42.98 96 96 96s96-42.98 96-96S405 288 352 288zM304 128c0-26.47 21.53-48 48-48s48 21.53 48 48S378.5 176 352 176h-48V128zM144 384c0 26.47-21.53 48-48 48S48 410.5 48 384s21.53-48 48-48h48V384zM144 176H96C69.53 176 48 154.5 48 128S69.53 80 96 80S144 101.5 144 128V176zM256 288H192V224h64V288zM352 432c-26.47 0-48-21.53-48-48v-48H352c26.47 0 48 21.53 48 48S378.5 432 352 432z"],
    "comment": [512, 512, [61557, 61669], "1f5e9", "M256 32C114.6 32 .0272 125.1 .0272 240c0 47.63 19.91 91.25 52.91 126.2c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.375 17.25-4.625 26C5.818 474.2 14.38 480 24 480c61.5 0 109.1-25.75 139.1-46.25C191.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256.1 400c-26.75 0-53.12-4.125-78.38-12.12l-22.75-7.125l-19.5 13.75c-14.25 10.12-33.88 21.38-57.5 29c7.375-12.12 14.37-25.75 19.88-40.25l10.62-28l-20.62-21.87C69.82 314.1 48.07 282.2 48.07 240c0-88.25 93.25-160 208-160s208 71.75 208 160S370.8 400 256.1 400z"],
    "comment-arrow-down": [512, 512, [], "e143", "M319 223L280 262.1V160c0-13.25-10.75-24-24-24S232 146.8 232 160v102.1L192.1 223C188.3 218.3 182.2 216 176 216S163.7 218.3 159 223c-9.375 9.375-9.375 24.56 0 33.94l80 80c9.375 9.375 24.56 9.375 33.94 0l80-80c9.375-9.375 9.375-24.56 0-33.94S328.4 213.7 319 223zM256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C191.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400z"],
    "comment-arrow-up": [512, 512, [], "e144", "M272.1 143c-9.375-9.375-24.56-9.375-33.94 0l-80 80c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L232 217.9V320c0 13.25 10.75 24 24 24s24-10.75 24-24V217.9l39.03 39.03C323.7 261.7 329.8 264 336 264s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L272.1 143zM256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C191.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400z"],
    "comment-arrow-up-right": [512, 512, [], "e145", "M312 144h-112C186.8 144 176 154.8 176 168S186.8 192 200 192h54.06L167 279c-9.375 9.375-9.375 24.56 0 33.94c9.373 9.375 24.56 9.381 33.94 0L288 225.9V280c0 13.25 10.75 24 24 24s24-10.75 24-24v-112C336 154.8 325.3 144 312 144zM256 32C114.6 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.374 17.25-4.624 26C5.818 474.3 14.38 480 24 480c61.5 0 109.1-25.75 139.1-46.25C191.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256.1 400c-26.75 0-53.13-4.125-78.38-12.12L154.9 380.8L135.4 394.5c-14.25 10.12-33.88 21.38-57.5 29c7.375-12.12 14.38-25.75 19.88-40.25l10.62-28l-20.62-21.88C69.82 314.1 48.07 282.3 48.07 240c0-88.25 93.25-160 208-160s208 71.75 208 160S370.8 400 256.1 400z"],
    "comment-captions": [512, 512, [], "e146", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.624 7-8.374 17.25-4.625 26C5.817 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.91 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.374-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160s207.1 71.75 207.1 160S370.8 400 256 400zM239.1 216c0-13.25-10.75-24-23.1-24H119.1C106.7 192 95.99 202.8 95.99 216S106.7 240 119.1 240l96-.0006C229.2 239.1 239.1 229.3 239.1 216zM295.1 272H215.1c-13.25 0-23.1 10.75-23.1 24S202.7 320 215.1 320h79.99c13.25 0 23.1-10.75 23.1-24S309.2 272 295.1 272zM135.1 272H119.1c-13.25 0-23.1 10.75-23.1 24S106.7 320 119.1 320h15.1c13.25 0 23.1-10.75 23.1-24S149.2 272 135.1 272zM391.9 272h-15.1c-13.25 0-23.1 10.75-23.1 24S362.7 320 375.9 320h15.1c13.25 0 23.1-10.75 23.1-24S405.2 272 391.9 272zM391.9 192h-95.99c-13.25 0-23.1 10.75-23.1 24s10.75 24 23.1 24h95.99c13.25 0 23.1-10.75 23.1-24S405.2 192 391.9 192z"],
    "comment-check": [512, 512, [], "f4ac", "M309.8 168.4L230.7 260.7L200.1 231c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l48 48C219.5 317.5 225.7 319.1 232 319.1c.3125 0 .625 0 .9062-.0313C239.6 319.7 245.9 316.7 250.2 311.6l96-112c8.625-10.06 7.469-25.22-2.594-33.84C333.6 157.2 318.4 158.3 309.8 168.4zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.815 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400z"],
    "comment-code": [512, 512, [], "e147", "M256 32C114.6 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.374 17.25-4.624 26C5.818 474.3 14.38 480 24 480c61.5 0 109.1-25.75 139.1-46.25C191.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256.1 400c-26.75 0-53.13-4.125-78.38-12.12L154.9 380.8L135.4 394.5c-14.25 10.12-33.88 21.38-57.5 29c7.375-12.12 14.38-25.75 19.88-40.25l10.62-28l-20.62-21.88C69.82 314.1 48.07 282.3 48.07 240c0-88.25 93.25-160 208-160s208 71.75 208 160S370.8 400 256.1 400zM216.1 159c-9.375-9.375-24.56-9.375-33.94 0l-64 64c-9.375 9.375-9.375 24.56 0 33.94l64 64C187.7 325.7 193.9 328 200 328s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L169.9 240l47.03-47.03C226.3 183.6 226.3 168.4 216.1 159zM328.1 159c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L342.1 240l-47.03 47.03c-9.375 9.375-9.375 24.56 0 33.94C299.7 325.7 305.9 328 312 328s12.28-2.344 16.97-7.031l64-64c9.375-9.375 9.375-24.56 0-33.94L328.1 159z"],
    "comment-dollar": [512, 512, [], "f651", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.9 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.816 474.3 14.4 480 24.02 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.14 14.25 92.89 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400zM261.5 220.8L255.1 219.2C232.3 212.2 232.8 208.1 233.6 204.5c1.375-7.812 16.59-9.719 30.27-7.625c5.594 .8438 11.73 2.812 17.59 4.844c10.39 3.594 21.83-1.938 25.45-12.34c3.625-10.44-1.891-21.84-12.33-25.47c-7.219-2.484-13.11-4.078-18.56-5.273V148c0-11.03-8.946-20-19.99-20S236 136.1 236 148v9.992C213.6 162.8 197.8 176.8 194.2 197.7C186.8 240.5 227.4 252.4 244.7 257.5L250.5 259.2c29.28 8.375 28.8 11.19 27.92 16.28c-1.375 7.812-16.59 9.75-30.31 7.625C241.2 282.1 232.3 278.9 224.5 276.1L219.1 274.5C209.6 270.9 198.2 276.3 194.5 286.7C190.8 297.1 196.3 308.5 206.7 312.2l4.266 1.5c7.758 2.789 16.38 5.59 25.06 7.512V332c0 11.03 8.961 20 20.01 20s19.99-8.969 19.99-20v-10.25c22.36-4.793 38.21-18.53 41.83-39.43C325.3 239 283.8 227.1 261.5 220.8z"],
    "comment-dots": [512, 512, [62637, 62075, "commenting"], "1f4ac", "M144 208C126.3 208 112 222.2 112 239.1C112 257.7 126.3 272 144 272s31.1-14.25 31.1-32S161.8 208 144 208zM256 207.1c-17.75 0-31.1 14.25-31.1 32s14.25 31.1 31.1 31.1s31.1-14.25 31.1-31.1S273.8 207.1 256 207.1zM368 208c-17.75 0-31.1 14.25-31.1 32s14.25 32 31.1 32c17.75 0 31.99-14.25 31.99-32C400 222.2 385.8 208 368 208zM256 31.1c-141.4 0-255.1 93.12-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.624 7-8.373 17.25-4.624 26C5.818 474.2 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.374-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.87C69.81 314.1 48.06 282.2 48.06 240c0-88.25 93.24-160 207.1-160s207.1 71.75 207.1 160S370.8 400 256 400z"],
    "comment-exclamation": [512, 512, [], "f4af", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400zM256 304c-17.67 0-32 14.33-32 32s14.33 32 32 32c17.67 0 32-14.33 32-32S273.7 304 256 304zM256 272c13.25 0 24-10.75 24-24v-112c0-13.25-10.75-24-24-24S232 122.8 232 136v112C232 261.3 242.8 272 256 272z"],
    "comment-image": [512, 512, [], "e148", "M256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C191.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400zM176 192c17.62 0 32-14.38 32-32s-14.38-32-32-32s-32 14.38-32 32S158.4 192 176 192zM311.1 167.1C309 162.7 304 160 298.7 160s-10.35 2.672-13.31 7.125L231.8 247.4L219.6 230.6C216.6 226.4 211.8 224 206.7 224S196.8 226.4 193.7 230.6l-46.67 64c-3.549 4.863-4.064 11.31-1.334 16.68C148.5 316.6 153.1 320 160 320h224c5.9 0 11.32-3.246 14.11-8.449c2.783-5.203 2.479-11.52-.7949-16.43L311.1 167.1z"],
    "comment-lines": [512, 512, [], "f4b0", "M264 272h-112C138.8 272 128 282.8 128 296S138.8 320 152 320h112C277.3 320 288 309.3 288 296S277.3 272 264 272zM360 176h-208C138.8 176 128 186.8 128 200S138.8 224 152 224h208C373.3 224 384 213.3 384 200S373.3 176 360 176zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400z"],
    "comment-medical": [512, 512, [], "f7f5", "M336 208H288V160c0-8.801-7.199-16-16-16h-32C231.2 144 224 151.2 224 160v48H176C167.2 208 160 215.2 160 223.1V256c0 8.797 7.199 15.1 16 15.1H224v48C224 328.8 231.2 336 240 336h32c8.801 0 16-7.201 16-16v-48h48C344.8 271.1 352 264.8 352 256V223.1C352 215.2 344.8 208 336 208zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25C397.4 447.1 512 354.9 512 239.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400z"],
    "comment-middle": [512, 512, [], "e149", "M256 0C114.6 0 0 93.09 0 208c0 95.99 80.08 176.5 188.8 200.5l48.89 93.39C241.2 508.6 248.6 512 256 512s14.76-3.361 18.28-10.08l48.89-93.39C431.9 384.5 512 303.1 512 208C512 93.09 397.4 0 256 0zM312.8 361.7L291 366.5L256 433.3l-35-66.86l-21.82-4.814C110.2 342 48 278.8 48 208c0-88.22 93.31-160 208-160s208 71.78 208 160C464 278.8 401.8 342 312.8 361.7z"],
    "comment-middle-top": [512, 512, [], "e14a", "M323.2 103.5l-48.89-93.39C270.8 3.361 263.4 0 256 0S241.2 3.361 237.7 10.08l-48.89 93.39C80.08 127.5 0 208 0 304c0 114.9 114.6 208 256 208s256-93.09 256-208C512 208 431.9 127.5 323.2 103.5zM256 464c-114.7 0-208-71.78-208-160c0-70.83 62.17-134 151.2-153.7L221 145.5L256 78.67l35 66.86l21.82 4.814C401.8 169.1 464 233.2 464 304C464 392.2 370.7 464 256 464z"],
    "comment-minus": [512, 512, [], "f4b1", "M256 32C114.6 32 .0281 125.1 .0281 240c0 47.63 19.91 91.25 52.91 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.373 17.25-4.623 26C5.82 474.3 14.38 480 24 480c61.5 0 109.1-25.75 139.1-46.25C191.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256.1 400c-26.75 0-53.13-4.125-78.38-12.12L154.9 380.8L135.4 394.5c-14.25 10.12-33.88 21.38-57.5 29c7.375-12.12 14.38-25.75 19.88-40.25l10.62-28l-20.62-21.88C69.82 314.1 48.07 282.3 48.07 240c0-88.25 93.25-160 208-160s208 71.75 208 160S370.8 400 256.1 400zM336 216H175.1C162.7 216 152 226.7 152 240c0 13.26 10.73 23.1 23.1 23.1h160C349.3 263.1 360 253.3 360 240S349.3 216 336 216z"],
    "comment-music": [512, 512, [], "f8b0", "M256 31.1c-141.4 0-255.1 93.12-255.1 208c0 47.62 19.93 91.25 52.93 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.374 17.25-4.624 26C5.722 474.2 14.47 480 23.97 480c61.5 0 109.1-25.75 139.1-46.25c30 9.375 61.42 14.25 92.92 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.62 0-53-4.125-78.38-12.12L155 380.8L135.5 394.5c-17.62 12.5-37 22.25-57.5 29c7.876-12.75 14.5-26.25 19.88-40.25l10.62-28l-20.62-21.87C69.75 314.1 48 282.2 48 240c0-88.25 93.38-160 208-160c114.8 0 208 71.75 208 160S370.8 400 256 400zM331.2 128.8l-128 47.25C196.5 178.1 192 184.2 192 191.2v98.72c-5.25-1.25-10.63-1.996-16-1.996c-26.5 0-48 14.38-48 32s21.5 32 48 32s47.1-14.38 47.1-32L224 235.1l96-37.5v60.34c-5.25-1.25-10.63-1.996-16-1.996c-26.5 0-48 14.38-48 32s21.5 32 48 32s48-14.38 48-32L352 144c0-5.125-2.375-9.875-6.5-12.88S336.1 127.2 331.2 128.8z"],
    "comment-pen": [512, 512, ["comment-edit"], "f4ae", "M324.2 149.3c-7.031-7.031-18.45-7.031-25.47 0l-18.23 18.23l48.01 48.01l18.24-18.24c7.029-7.035 7.029-18.44 0-25.47L324.2 149.3zM172.9 275.1C171.2 276.7 170.1 278.9 169.6 281.2l-9.521 47.61c-.8379 4.195 2.861 7.898 7.059 7.059l47.61-9.52c2.322-.4687 4.455-1.609 6.131-3.281l90.58-90.57L263.5 184.5L172.9 275.1zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400z"],
    "comment-plus": [512, 512, [], "f4b2", "M256 32C114.6 32 .0281 125.1 .0281 240c0 47.63 19.91 91.25 52.91 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.373 17.25-4.623 26C5.82 474.3 14.38 480 24 480c61.5 0 109.1-25.75 139.1-46.25C191.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256.1 400c-26.75 0-53.13-4.125-78.38-12.12L154.9 380.8L135.4 394.5c-14.25 10.12-33.88 21.38-57.5 29c7.375-12.12 14.38-25.75 19.88-40.25l10.62-28l-20.62-21.88C69.82 314.1 48.07 282.3 48.07 240c0-88.25 93.25-160 208-160s208 71.75 208 160S370.8 400 256.1 400zM336 216h-56V159.1C279.1 146.7 269.3 136 256 136S232 146.7 232 159.1V216H175.1C162.7 216 152 226.7 152 240c0 13.26 10.73 23.1 23.1 23.1h56v56C232 333.3 242.7 344 256 344c13.26 0 23.1-10.74 23.1-23.1V263.1h56C349.3 263.1 360 253.3 360 240S349.3 216 336 216z"],
    "comment-question": [512, 512, [], "e14b", "M277.7 128H234.3C201.8 128 176 153.6 176 185.8c0 10.74 9.166 19.83 20 19.83S216 196.6 216 185.8c0-9.914 8.334-18.17 18.33-18.17h43.33c10 0 18.33 8.26 18.33 18.17c0 6.607-3.334 12.39-9.166 15.7L239.3 229.6c-6.668 4.131-10 10.74-10 17.35v13.22c0 10.74 9.166 19.83 20 19.83c10.83 0 20-9.088 20-19.83V258.5l38.33-23.13C325.2 224.7 336 205.7 336 185.8C336 153.6 310.2 128 277.7 128zM249.1 300C235.4 300 224 311.4 224 326S235.4 352 249.1 352c14.63 0 26-11.38 26-26S264.6 300 249.1 300zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-208S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400z"],
    "comment-quote": [512, 512, [], "e14c", "M183.1 143.1c-30.93 0-56 25.07-56 56s25.07 56 56 56c2.74 0 5.365-.4256 8-.8064V264C192 277.2 181.2 288 168 288C154.8 288 144 298.8 144 312s10.75 23.1 23.1 23.1c39.7 0 71.1-32.3 71.1-72l0-63.1C239.1 169.1 214.9 143.1 183.1 143.1zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400zM327.1 143.1c-30.93 0-56 25.07-56 56s25.07 56 56 56c2.74 0 5.365-.4256 8-.8064V264C336 277.2 325.2 288 312 288C298.8 288 288 298.8 288 312s10.75 23.1 23.1 23.1c39.7 0 72-32.3 72-72l0-63.1C383.1 169.1 358.9 143.1 327.1 143.1z"],
    "comment-slash": [640, 512, [], "f4b3", "M630.8 469.1l-118.1-92.59C552 340 576 292.4 576 240c0-114.9-114.6-207.1-255.1-207.1c-67.74 0-129.1 21.53-174.9 56.47L38.81 5.117c-10.47-8.172-25.49-6.365-33.7 4.073C-3.057 19.63-1.234 34.72 9.188 42.89l591.1 463.1C605.6 510.3 610.8 512 615.1 512c7.125 0 14.17-3.159 18.9-9.191C643.1 492.4 641.2 477.3 630.8 469.1zM474.6 346.6l-290.3-227.5C220.8 94.85 268.1 80 320.1 80c114.8 0 208 71.75 208 160C528.1 281 507.7 318.3 474.6 346.6zM320.1 400c-26.75 0-53.13-4.125-78.38-12.12L218.9 380.8L199.4 394.5c-14.25 10.12-33.88 21.38-57.5 29c7.375-12.12 14.38-25.75 19.88-40.25l10.62-28l-20.62-21.88C133.8 314.1 112.1 282.3 112.1 240c0-16.84 3.438-33.05 9.727-48.3L83.13 161.4C70.92 185.7 64.03 212.2 64.03 239.1c0 47.63 19.91 91.25 52.91 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.374 17.25-4.624 26C69.82 474.3 78.38 480 88 480c61.5 0 109.1-25.75 139.1-46.25c28.88 9 60.15 14.25 92.9 14.25c37.51 0 73.08-6.715 105.2-18.5l-46.13-36.15C360.4 397.6 340.6 400 320.1 400z"],
    "comment-smile": [512, 512, [], "f4b4", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400zM319.1 207.1c17.75 0 31.99-14.25 31.99-31.1s-14.25-32-31.1-32s-31.1 14.25-31.1 32S302.2 207.1 319.1 207.1zM191.1 207.1c17.75 0 31.99-14.25 31.99-31.1s-14.25-32-31.1-32s-31.1 14.25-31.1 32S174.2 207.1 191.1 207.1zM325.7 272.3C308.5 292.4 283.1 304 255.1 304c-27.12 0-52.49-11.62-69.74-31.75C177.6 262.1 162.4 261 152.4 269.5C142.2 278.1 141.2 293.3 149.7 303.3c26.5 31 65.12 48.75 106.2 48.75c41.12 0 79.73-17.75 106.2-48.75c8.5-10 7.375-25.12-2.75-33.75C349.5 260.9 334.3 262.1 325.7 272.3z"],
    "comment-sms": [512, 512, ["sms"], "f7cd", "M302.1 185.1c-5.623-1.793-11.93 .0547-15.54 4.863L256 230.7L225.4 189.9c-3.613-4.809-9.889-6.684-15.54-4.863C204.2 186.1 200.4 192.3 200.4 198.3v83.46c0 7.689 6.223 13.91 13.91 13.91c7.689 0 13.91-6.221 13.91-13.91V239.1l16.68 22.25c5.271 7.01 17.01 7.01 22.28 0l16.68-22.25v41.73c0 7.689 6.221 13.91 13.91 13.91s13.91-6.221 13.91-13.91V198.3C311.6 192.3 307.8 186.1 302.1 185.1zM141.6 226.6C132.2 223.9 123.1 221.9 124 216.1C124.7 213.1 132.1 211.3 142.7 212.7c3.613 .5703 7.607 1.82 11.38 3.125C161.4 218.4 169.3 214.5 171.8 207.2c2.498-7.254-1.359-15.19-8.613-17.69C157.8 187.7 152.1 186 147 185.2C120.3 181 100.1 191.9 96.58 212.3C91.66 240.1 119.6 249.2 130.2 252.3c11.93 3.432 22.27 5.59 21.35 10.73C150.8 266.9 142.7 268.8 132.8 267.3C127.3 266.4 120.7 263.8 114.6 261.7C107.3 259.1 100.7 263.3 98.13 270.5C95.54 277.8 100.5 286.2 107.8 288.8c6.357 2.309 13.58 4.916 20.76 6.004c3.775 .5977 7.443 .8691 10.95 .8691c21.11 0 36.46-10.46 39.45-27.93C183.1 238.7 156.4 230.8 141.6 226.6zM378.1 226.6c-9.385-2.68-18.47-4.719-17.58-9.617c.6797-3.912 8.967-5.705 18.69-4.266c3.613 .5703 7.607 1.82 11.38 3.125c7.309 2.527 15.19-1.357 17.69-8.611c2.5-7.254-1.357-15.19-8.611-17.69c-5.354-1.848-11.03-3.531-16.17-4.32c-26.73-4.184-46.92 6.711-50.42 27.03c-4.918 28.72 23.04 36.92 33.58 39.99c11.93 3.432 22.27 5.59 21.35 10.73c-.6777 3.967-8.803 5.787-18.75 4.293c-5.514-.8594-12.08-3.426-18.15-5.598c-7.279-2.58-13.91 1.631-16.49 8.857s2.406 15.52 9.633 18.13c6.357 2.309 13.6 5.018 20.77 6.105c3.777 .5977 7.445 .8691 10.95 .8691c21.11 0 36.46-10.46 39.45-27.93C420.4 238.7 392.9 230.8 378.1 226.6zM256 32C114.7 32 .0137 125.1 .0137 240c0 47.63 19.9 91.25 52.89 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.782 474.3 14.35 480 23.97 480c61.49 0 109.1-25.75 139.1-46.25C191.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400z"],
    "comment-text": [512, 512, [], "e14d", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.374 17.25-4.624 26C5.818 474.3 14.38 480 24 480c61.5 0 109.1-25.75 139.1-46.25c28.88 9 60.15 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256.1 400c-26.75 0-53.13-4.125-78.38-12.12L154.9 380.8L135.4 394.5c-14.25 10.12-33.88 21.38-57.5 29c7.375-12.12 14.38-25.75 19.88-40.25l10.62-28l-20.62-21.88C69.82 314.1 48.07 282.3 48.07 240c0-88.25 93.25-160 208-160s208 71.75 208 160S370.8 400 256.1 400zM328 160h-144C170.8 160 160 170.7 160 183.1S170.8 208 184 208h48v104c0 13.25 10.75 23.1 23.1 23.1S280 325.3 280 312V208h48C341.3 208 352 197.2 352 183.1S341.3 160 328 160z"],
    "comment-xmark": [512, 512, ["comment-times"], "f4b5", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-208S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.373-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.88C69.81 314.1 48.06 282.3 48.06 240c0-88.25 93.24-160 207.1-160c114.7 0 207.1 71.75 207.1 160S370.8 400 256 400zM336.1 159c-9.375-9.375-24.56-9.375-33.94 0l-47.03 47.03L208.1 159c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L222.1 240L175 287c-9.375 9.375-9.375 24.56 0 33.94c9.373 9.371 24.56 9.379 33.94 0l47.03-47.03l47.03 47.03c9.373 9.371 24.56 9.379 33.94 0c9.375-9.375 9.375-24.56 0-33.94L289.9 240l47.03-47.03C346.3 183.6 346.3 168.4 336.1 159z"],
    "comments": [640, 512, [61574, 61670], "1f5ea", "M416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.63 17.18 79.81 45.73 109.9c-16.34 31.43-38.47 55.57-38.99 55.96c-6.746 7.15-8.635 17.81-4.721 26.98C5.93 378.1 14.97 384 24.95 384c54.18 0 98.32-19.24 128.1-38.22C171.2 349.7 189.3 352 208 352C322.9 352 416 273.2 416 176zM208 304c-14.16 0-28.77-1.689-43.41-5.021L145.4 294.6l-16.72 10.35c-17 10.52-34.42 18.39-52.14 23.57c4.184-6.668 8.191-13.57 11.77-20.45l15.78-30.34L80.57 252.9C65.71 237.3 48 211.2 48 176c0-70.58 71.78-128 160-128s160 57.42 160 128S296.2 304 208 304zM599.6 443.7C624.8 413.9 640 376.6 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 98.62-79.68 181.2-186.1 202.5C282.7 455.1 357.1 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7z"],
    "comments-dollar": [640, 512, [], "f653", "M212.7 159.5L207.1 158.1c-20.32-5.973-19.83-8.732-19.18-12.56c1.178-6.695 14.22-8.33 25.94-6.535c4.795 .7227 10.06 2.41 15.08 4.152c8.906 3.08 18.71-1.662 21.82-10.58C254.7 123.7 250 113.9 241.1 110.8C234.9 108.6 229.8 107.3 225.1 106.3v-9.113C225.1 87.69 217.5 80 208 80S190.9 87.69 190.9 97.14v8.564C171.6 109.8 158.1 121.8 155 139.7c-6.348 36.72 28.45 46.93 43.3 51.29l4.982 1.447C228.4 199.7 227.1 202.1 227.2 206.4c-1.18 6.697-14.22 8.357-25.98 6.535c-5.947-.8828-13.55-3.615-20.28-6.025L177.1 205.5C168.2 202.5 158.4 207.1 155.3 216C152.1 224.9 156.8 234.7 165.7 237.9l3.656 1.287c6.648 2.391 14.04 4.791 21.48 6.438v9.232C190.9 264.3 198.5 272 208 272s17.14-7.688 17.14-17.14V246.1c19.17-4.109 32.75-15.88 35.85-33.8C267.4 175.2 231.8 164.1 212.7 159.5zM599.6 443.7C624.8 413.9 640 376.6 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 98.62-79.68 181.2-186.1 202.5C282.7 455.1 357.1 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.63 17.18 79.81 45.73 109.9c-16.34 31.43-38.47 55.57-38.99 55.96c-6.746 7.15-8.635 17.81-4.721 26.98C5.93 378.1 14.97 384 24.95 384c54.18 0 98.32-19.24 128.1-38.22C171.2 349.7 189.3 352 208 352C322.9 352 416 273.2 416 176zM208 304c-14.16 0-28.77-1.689-43.41-5.021L145.4 294.6l-16.72 10.35c-17 10.52-34.42 18.39-52.14 23.57c4.184-6.668 8.191-13.57 11.77-20.45l15.78-30.34L80.57 252.9C65.71 237.3 48 211.2 48 176c0-70.58 71.78-128 160-128s160 57.42 160 128S296.2 304 208 304z"],
    "comments-question": [640, 512, [], "e14e", "M221.8 88H191.1c-24.39 0-44.23 19.84-44.23 44.23c0 8.844 7.156 16 16 16s16-7.156 16-16C178.8 125.5 184.3 120 191.1 120h30.7c8.5 0 15.41 6.906 15.41 15.41c0 5.875-3.266 11.16-8.516 13.78L200.8 163.1C195.4 165.8 192 171.3 192 177.4V192c0 8.844 7.156 16 16 16S224 200.8 224 192V187.3l18.95-9.484C259.1 169.8 269.2 153.5 269.2 135.4C269.2 109.3 247.9 88 221.8 88zM208 220c-11.04 0-20 8.953-20 20c0 11.04 8.955 20 20 20S228 251 228 240C228 228.1 219 220 208 220zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.63 17.18 79.81 45.73 109.9c-16.34 31.43-38.47 55.57-38.99 55.96c-6.746 7.15-8.635 17.81-4.721 26.98C5.93 378.1 14.97 384 24.95 384c54.18 0 98.32-19.24 128.1-38.22C171.2 349.7 189.3 352 208 352C322.9 352 416 273.2 416 176zM208 304c-14.16 0-28.77-1.689-43.41-5.021L145.4 294.6l-16.72 10.35c-17 10.52-34.42 18.39-52.14 23.57c4.184-6.668 8.191-13.57 11.77-20.45l15.78-30.34L80.57 252.9C65.71 237.3 48 211.2 48 176c0-70.58 71.78-128 160-128s160 57.42 160 128S296.2 304 208 304zM599.6 443.7C624.8 413.9 640 376.6 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 98.62-79.68 181.2-186.1 202.5C282.7 455.1 357.1 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7z"],
    "comments-question-check": [640, 512, [], "e14f", "M208 220c-11.04 0-20 8.953-20 20c0 11.04 8.955 20 20 20S228 251 228 240C228 228.1 219 220 208 220zM221.8 88H191.1c-24.39 0-44.23 19.84-44.23 44.23c0 8.844 7.156 16 16 16s16-7.156 16-16C178.8 125.5 184.3 120 191.1 120h30.7c8.5 0 15.41 6.906 15.41 15.41c0 5.875-3.266 11.16-8.516 13.78L200.8 163.1C195.4 165.8 192 171.3 192 177.4V192c0 8.844 7.156 16 16 16S224 200.8 224 192V187.3l18.95-9.484C259.1 169.8 269.2 153.5 269.2 135.4C269.2 109.3 247.9 88 221.8 88zM599.6 443.7C624.8 413.9 640 376.6 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 98.62-79.68 181.2-186.1 202.5C282.7 455.1 357.1 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7zM542.5 317.8l-84 88c-3.719 3.891-8.859 6.125-14.23 6.188c-5.297 0-10.62-2.109-14.38-5.859l-40-40c-7.812-7.812-7.812-20.47 0-28.28s20.47-7.812 28.28 0l25.53 25.53l69.86-73.2c7.656-8 20.3-8.297 28.28-.6562C549.8 297.2 550.1 309.8 542.5 317.8zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.63 17.18 79.81 45.73 109.9c-16.34 31.43-38.47 55.57-38.99 55.96c-6.746 7.15-8.635 17.81-4.721 26.98C5.93 378.1 14.97 384 24.95 384c54.18 0 98.32-19.24 128.1-38.22C171.2 349.7 189.3 352 208 352C322.9 352 416 273.2 416 176zM208 304c-14.16 0-28.77-1.689-43.41-5.021L145.4 294.6l-16.72 10.35c-17 10.52-34.42 18.39-52.14 23.57c4.184-6.668 8.191-13.57 11.77-20.45l15.78-30.34L80.57 252.9C65.71 237.3 48 211.2 48 176c0-70.58 71.78-128 160-128s160 57.42 160 128S296.2 304 208 304z"],
    "compact-disc": [512, 512, [128192, 128440, 62751], "1f4bf", "M227.5 131.2c8.609-1.953 14.03-10.52 12.08-19.14c-1.953-8.609-10.55-13.95-19.14-12.08c-59.7 13.5-107 60.81-120.5 120.5C97.1 229.1 103.4 237.7 112 239.6C113.2 239.9 114.4 240 115.6 240c7.312 0 13.91-5.047 15.59-12.47C141.1 179.8 179.8 141.1 227.5 131.2zM256 159.1c-53.08 0-96 42.92-96 96c0 53.08 42.92 95.1 96 95.1s96-42.92 96-95.1C352 202.9 309.1 159.1 256 159.1zM256 280C242.8 280 232 269.3 232 256S242.8 232 256 232S280 242.8 280 256S269.3 280 256 280zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "compass": [576, 512, [61774], "1f9ed", "M358.1 143.5L243.6 195.8c-5.957 2.723-13.06 9.824-15.78 15.78l-52.33 114.5c-12.32 26.95 15.45 54.72 42.4 42.41l114.5-52.32c5.939-2.715 13.03-9.817 15.75-15.76l52.34-114.5C412.8 158.1 385 131.2 358.1 143.5zM310.6 278.6c-12.5 12.5-32.75 12.5-45.25 0c-12.5-12.5-12.5-32.75 0-45.25c12.5-12.5 32.75-12.5 45.25 0C323.1 245.9 323.1 266.1 310.6 278.6zM288 0C146.6 0 32 114.6 32 256s114.6 256 256 256s256-114.6 256-256S429.4 0 288 0zM288 464c-114.7 0-208-93.31-208-208S173.3 48 288 48s208 93.31 208 208S402.7 464 288 464z"],
    "compass-drafting": [512, 512, ["drafting-compass"], "f568", "M508.7 475.8l-73.09-123.5c-13.28 8.99-27.11 17.07-41.61 23.94l73.39 124C471.8 507.8 479.8 512 488 512c4.156 0 8.375-1.078 12.2-3.344C511.6 501.9 515.4 487.2 508.7 475.8zM502.9 236.4c6.828-11.34 3.172-26.09-8.187-32.94c-11.34-6.812-26.11-3.172-32.94 8.188C417.9 284.5 340.1 328 256 328c-34.31 0-67.15-7.406-97.19-20.66l70.73-119.5C238 190.3 246.8 191.1 256 191.1s17.1-1.723 26.46-4.17l54.14 91.48c14.86-6.172 28.86-14.04 41.86-23.5l-54.5-92.09c17.31-17.37 28.04-41.31 28.04-67.72C351.1 43.06 308.9 0 256 0S160 43.06 160 95.1c0 26.4 10.73 50.34 28.04 67.72L117.1 283.6C90.65 264.8 67.74 240.7 50.25 211.6C43.39 200.3 28.63 196.6 17.32 203.4C5.957 210.3 2.301 225 9.129 236.4C30.83 272.4 59.54 302.1 92.62 324.9l-89.27 150.8c-6.75 11.41-2.969 26.12 8.437 32.88C15.61 510.9 19.83 512 23.99 512c8.203 0 16.19-4.203 20.67-11.78l89.64-151.5C171.7 366.2 212.9 376 256 376C357.9 376 450.2 323.8 502.9 236.4zM256 48c26.47 0 47.1 21.53 47.1 48S282.5 144 256 144S208 122.5 208 96S229.5 48 256 48z"],
    "compass-slash": [640, 512, [], "f5e9", "M249.9 368.5L311.1 340.5L229.1 276.9l-22.47 49.15C195.2 353 222.1 380.8 249.9 368.5zM630.8 469.1l-95.55-74.9C560.1 354.4 576 306.1 576 256c0-141.4-114.6-256-256-256C246.9 0 181.3 31.08 134.7 80.29L38.81 5.116C34.41 1.679 29.19 0 24.03 0C16.91 0 9.84 3.158 5.121 9.189C-3.067 19.63-1.249 34.71 9.189 42.89l591.1 463.1c10.5 8.203 25.57 6.333 33.69-4.073C643.1 492.4 641.2 477.3 630.8 469.1zM497.2 364.4l-107.7-84.39l42.99-94.06c12.32-26.95-15.46-54.72-42.41-42.4L279.7 193.9L172.6 109.1C210.3 71.85 262.3 48 320 48c114.7 0 208 93.31 208 208C528 295.7 516.6 332.8 497.2 364.4zM320 464c-114.7 0-208-93.31-208-208c0-22.21 3.578-43.57 10.05-63.65L82.34 161.2C70.62 190.6 64 222.5 64 256c0 141.4 114.6 256 256 256c55.54 0 106.8-17.87 148.7-47.92l-39.83-31.22C397.2 452.5 359.1 464 320 464z"],
    "compress": [448, 512, [], "f066", "M136 320h-112C10.75 320 0 330.7 0 344c0 13.25 10.75 24 24 24H112v88C112 469.3 122.7 480 136 480S160 469.3 160 456v-112C160 330.7 149.3 320 136 320zM312 192h112C437.3 192 448 181.3 448 168c0-13.26-10.75-24-24-24H336V56C336 42.74 325.3 32 312 32S288 42.74 288 56v112C288 181.3 298.7 192 312 192zM136 32C122.7 32 112 42.74 112 56V144H24C10.75 144 0 154.7 0 168C0 181.3 10.75 192 24 192h112C149.3 192 160 181.3 160 168v-112C160 42.74 149.3 32 136 32zM424 320h-112C298.7 320 288 330.7 288 344v112c0 13.25 10.75 24 24 24s24-10.75 24-24V368h88c13.25 0 24-10.75 24-24C448 330.7 437.3 320 424 320z"],
    "compress-wide": [512, 512, [], "f326", "M376 224h112C501.3 224 512 213.3 512 200c0-13.26-10.75-24-24-24H400V88C400 74.74 389.3 64 376 64S352 74.74 352 88v112C352 213.3 362.7 224 376 224zM136 288h-112C10.75 288 0 298.7 0 312c0 13.25 10.75 24 24 24H112v88C112 437.3 122.7 448 136 448S160 437.3 160 424v-112C160 298.7 149.3 288 136 288zM488 288h-112C362.7 288 352 298.7 352 312v112c0 13.25 10.75 24 24 24s24-10.75 24-24V336h88c13.25 0 24-10.75 24-24C512 298.7 501.3 288 488 288zM136 64C122.7 64 112 74.74 112 88V176H24C10.75 176 0 186.7 0 200C0 213.3 10.75 224 24 224h112C149.3 224 160 213.3 160 200v-112C160 74.74 149.3 64 136 64z"],
    "computer-classic": [448, 512, [], "f8b1", "M384 0H64C28.65 0 0 28.65 0 64v304c0 23.63 12.95 44.04 32 55.12V480c0 17.67 14.33 32 32 32h320c17.67 0 32-14.33 32-32v-56.88c19.05-11.09 32-31.49 32-55.12V64C448 28.65 419.3 0 384 0zM368 464h-288v-32h288V464zM400 368c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V64c0-8.822 7.178-16 16-16h320c8.822 0 16 7.178 16 16V368zM336 80h-224c-17.67 0-32 14.33-32 32l0 96c0 17.67 14.33 32 32 32h224c17.67 0 31.1-14.33 31.1-32L368 112C368 94.33 353.7 80 336 80zM120 304C106.7 304 96 314.7 96 328C96 341.3 106.7 352 120 352s24-10.75 24-24C144 314.7 133.3 304 120 304zM352 304h-128c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16S360.8 304 352 304z"],
    "computer-mouse": [384, 512, [63692, "mouse"], "1f5b1", "M224 0H160C71.63 0 0 71.62 0 160v192c0 88.38 71.63 160 160 160h64c88.38 0 160-71.63 160-160V160C384 71.62 312.4 0 224 0zM336 160v16h-120v-128H224C285.9 48.12 335.9 98.12 336 160zM160 48h8v128H48V160C48.13 98.12 98.13 48.12 160 48zM224 464H160c-61.88-.125-111.9-50.13-112-112V224h288v128C335.9 413.9 285.9 463.9 224 464z"],
    "computer-mouse-scrollwheel": [384, 512, ["mouse-alt"], "f8cd", "M224 0H160c-88.38 0-160 71.62-160 160v192c0 88.38 71.62 160 160 160h64c88.38 0 160-71.63 160-160V160C384 71.62 312.4 0 224 0zM336 352c-.125 61.88-50.13 111.9-112 112H160c-61.88-.125-111.9-50.13-112-112V160C48.12 98.12 98.12 48.12 160 48h64c61.88 .125 111.9 50.12 112 112V352zM192 95.1c-17.62 0-32 14.38-32 32v31.1C160 177.6 174.4 192 192 192c17.62 0 32-14.38 32-32V127.1C224 110.4 209.6 95.1 192 95.1z"],
    "computer-speaker": [640, 512, [], "f8b2", "M576 32h-192c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h192c35.35 0 64-28.65 64-64V96C640 60.65 611.3 32 576 32zM592 416c0 8.822-7.178 16-16 16h-192c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h192c8.822 0 16 7.178 16 16V416zM0 96v224c0 35.35 28.65 64 64 64h224v-48H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h225.6C292.7 61.67 301 45.24 312.1 32H64C28.65 32 0 60.65 0 96zM120 432C106.7 432 96 442.7 96 456C96 469.3 106.7 480 120 480h192.1c-11.94-13.24-20.25-29.67-23.35-48H120zM479.1 240c-44.18 0-80 35.82-80 80c0 44.18 35.82 80 80 80c44.18 0 79.1-35.82 79.1-80C559.1 275.8 524.2 240 479.1 240zM479.1 352c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S497.6 352 479.1 352zM480 176c17.67 0 32-14.33 32-32s-14.33-32-32-32C462.3 112 448 126.3 448 144S462.3 176 480 176z"],
    "container-storage": [640, 512, [], "f4b7", "M616 432H608v-352h8C629.3 80 640 69.25 640 56S629.3 32 616 32H24C10.75 32 0 42.75 0 56S10.75 80 24 80H32v352H24C10.75 432 0 442.8 0 456S10.75 480 24 480h592c13.25 0 24-10.75 24-24S629.3 432 616 432zM560 432h-480v-352h480V432zM192 400c13.25 0 24-10.75 24-24v-240C216 122.8 205.3 112 192 112S168 122.8 168 136v240C168 389.3 178.8 400 192 400zM320 400c13.25 0 24-10.75 24-24v-240c0-13.25-10.75-24-24-24S296 122.8 296 136v240C296 389.3 306.8 400 320 400zM448 400c13.25 0 24-10.75 24-24v-240c0-13.25-10.75-24-24-24s-24 10.75-24 24v240C424 389.3 434.8 400 448 400z"],
    "conveyor-belt": [640, 512, [], "f46e", "M128 368c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S145.8 368 128 368zM528 288h-416C50.14 288 0 338.1 0 400S50.14 512 112 512h416c61.86 0 112-50.14 112-112S589.9 288 528 288zM527.1 464H111.1C76.71 464 48 435.3 48 400c0-35.29 28.71-64 64-64h416c35.29 0 64 28.71 64 64C592 435.3 563.3 464 527.1 464zM512 368c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S529.8 368 512 368zM319.1 368C302.2 368 288 382.3 288 400s14.25 32 32 32s32-14.25 32-32S337.7 368 319.1 368zM192 256h256c35.35 0 64-28.65 64-64V64c0-35.35-28.65-64-64-64H192C156.7 0 128 28.65 128 64v128C128 227.3 156.7 256 192 256zM176 64c0-8.822 7.178-16 16-16h64V128l64-32l64 32V48h64c8.822 0 16 7.178 16 16v128c0 8.822-7.178 16-16 16H192C183.2 208 176 200.8 176 192V64z"],
    "conveyor-belt-boxes": [640, 512, ["conveyor-belt-alt"], "f46f", "M128 368c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S145.8 368 128 368zM160 256h144c15.22 0 29.02-5.535 40-14.41C354.1 250.5 368.8 256 384 256h96c35.35 0 64-28.65 64-64V128c0-35.35-28.65-64-64-64h-96c-5.559 0-10.86 .9316-16 2.264V64c0-35.35-28.65-64-64-64H160C124.7 0 96 28.65 96 64v128C96 227.3 124.7 256 160 256zM368 128c0-8.822 7.178-16 16-16h96c8.822 0 16 7.178 16 16v64c0 8.822-7.178 16-16 16h-96c-8.822 0-16-7.178-16-16V128zM144 64c0-8.822 7.178-16 16-16h144C312.8 48 320 55.18 320 64v128c0 8.822-7.178 16-16 16H160C151.2 208 144 200.8 144 192V64zM512 368c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S529.8 368 512 368zM320 368c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S337.8 368 320 368zM528 288h-416C50.14 288 0 338.1 0 400S50.14 512 112 512h416c61.86 0 112-50.14 112-112S589.9 288 528 288zM528 464h-416c-35.29 0-64-28.71-64-64c0-35.29 28.71-64 64-64h416c35.29 0 64 28.71 64 64C592 435.3 563.3 464 528 464z"],
    "conveyor-belt-empty": [640, 512, [], "e150", "M128 368c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S145.8 368 128 368zM512 368c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S529.8 368 512 368zM320 368c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S337.8 368 320 368zM528 288h-416C50.14 288 0 338.1 0 400S50.14 512 112 512h416c61.86 0 112-50.14 112-112S589.9 288 528 288zM528 464h-416c-35.29 0-64-28.71-64-64c0-35.29 28.71-64 64-64h416c35.29 0 64 28.71 64 64C592 435.3 563.3 464 528 464z"],
    "cookie": [512, 512, [62819], "1f36a", "M352 320c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S369.6 320 352 320zM320 160c17.62 0 32-14.38 32-32s-14.38-32-32-32s-32 14.38-32 32S302.4 160 320 160zM192 192c0-17.62-14.38-32-32-32s-32 14.38-32 32s14.38 32 32 32S192 209.6 192 192zM192 320c-17.62 0-32 14.38-32 32s14.38 32 32 32c17.62 0 32-14.38 32-32S209.6 320 192 320zM288 224c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S305.6 224 288 224zM510.4 254.8l-12.13-76.25c-4.375-27.62-17.37-53.12-37.12-72.88l-54.75-54.75c-19.75-19.75-45.13-32.75-72.75-37.12l-76.63-12.13C250.1 .5 243.3 0 236.4 0C215.6 0 195.1 4.875 176.5 14.38L107.4 49.62C82.5 62.25 62.25 82.5 49.5 107.4l-35 68.87C1.752 201.2-2.748 229.5 1.627 257.2l12.13 76.25c4.375 27.62 17.37 53.13 37.12 72.88l54.75 54.75c19.75 19.75 45.13 32.75 72.75 37.12l76.63 12.13C261.9 511.5 268.8 512 275.6 512c20.75 0 41.25-4.875 59.88-14.38l69.13-35.25c24.88-12.62 45.13-32.88 57.88-57.75l35-68.87C510.3 310.8 514.8 282.5 510.4 254.8zM454.8 314l-35.13 68.87c-8.125 15.88-20.75 28.62-36.75 36.75l-69.12 35.25C302 460.9 288.9 464 275.6 464c-4.375 0-8.75-.375-13.12-1l-76.63-12.12C168.3 448 152.3 439.9 139.6 427.2L84.75 372.5c-12.63-12.75-20.88-28.75-23.63-46.5L49 249.8c-2.75-17.75 0-35.63 8.25-51.75l35.13-68.88C100.5 113.2 113.1 100.5 129.1 92.38l69.13-35.25C210 51.12 223.1 48 236.4 48c4.375 0 8.75 .375 13.12 1l76.63 12.12C343.8 64 359.8 72.12 372.5 84.75l54.75 54.75c12.63 12.75 20.88 28.75 23.63 46.5l12.12 76.25C465.8 280 463 297.9 454.8 314z"],
    "cookie-bite": [512, 512, [], "f564", "M352 320c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S369.6 320 352 320zM192 192c0-17.62-14.38-32-32-32s-32 14.38-32 32s14.38 32 32 32S192 209.6 192 192zM192 320c-17.62 0-32 14.38-32 32s14.38 32 32 32c17.62 0 32-14.38 32-32S209.6 320 192 320zM288 224c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S305.6 224 288 224zM510.5 255.9C440.5 255 384 198.1 384 128c-70.13 0-127-56.5-127.8-126.5C249.6 .5 242.9 0 236.3 0c-20.62 0-41.13 4.875-59.75 14.38L107.4 49.5c-24.88 12.75-45.13 33-57.88 57.88l-35 68.87C1.752 201.2-2.748 229.5 1.627 257.2l12.13 76.25c4.375 27.62 17.37 53.13 37.12 72.88l54.75 54.87c19.75 19.63 45.13 32.63 72.75 37l76.63 12.13C261.9 511.5 268.9 512 275.8 512c20.62 0 41.25-4.875 59.87-14.38l69.13-35.25c24.87-12.62 45.12-32.88 57.75-57.75l35.13-68.87C510.1 311.1 514.6 283.1 510.5 255.9zM454.9 313.9l-35.12 68.88c-8.125 16-20.88 28.75-36.88 36.87l-69.12 35.25C302 460.9 288.9 464 275.8 464c-4.375 0-8.875-.375-13.13-1l-76.75-12.12C168.3 448 152.3 439.9 139.6 427.2L84.75 372.5c-12.63-12.75-20.88-28.75-23.63-46.5L49 249.8c-2.75-17.88 0-35.63 8.25-51.75l35.13-68.88C100.5 113.2 113.3 100.5 129.1 92.38l69.13-35.25c5.5-2.875 11.38-5 17.38-6.5c17.88 58.88 65.88 104.9 125.8 120.1c15.12 59.75 61.13 107.7 120.1 125.6C459.9 302.5 457.8 308.4 454.9 313.9z"],
    "copy": [512, 512, [], "f0c5", "M502.6 70.63l-61.25-61.25C435.4 3.371 427.2 0 418.7 0H255.1c-35.35 0-64 28.66-64 64l.0195 256C192 355.4 220.7 384 256 384h192c35.2 0 64-28.8 64-64V93.25C512 84.77 508.6 76.63 502.6 70.63zM464 320c0 8.836-7.164 16-16 16H255.1c-8.838 0-16-7.164-16-16L239.1 64.13c0-8.836 7.164-16 16-16h128L384 96c0 17.67 14.33 32 32 32h47.1V320zM272 448c0 8.836-7.164 16-16 16H63.1c-8.838 0-16-7.164-16-16L47.98 192.1c0-8.836 7.164-16 16-16H160V128H63.99c-35.35 0-64 28.65-64 64l.0098 256C.002 483.3 28.66 512 64 512h192c35.2 0 64-28.8 64-64v-32h-47.1L272 448z"],
    "copyright": [512, 512, [61945], "a9", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM255.1 176C255.1 176 255.1 176 255.1 176c21.06 0 40.92 8.312 55.83 23.38c9.375 9.344 24.53 9.5 33.97 .1562c9.406-9.344 9.469-24.53 .1562-33.97c-24-24.22-55.95-37.56-89.95-37.56c0 0 .0313 0 0 0c-33.97 0-65.95 13.34-89.95 37.56c-49.44 49.88-49.44 131 0 180.9c24 24.22 55.98 37.56 89.95 37.56c.0313 0 0 0 0 0c34 0 65.95-13.34 89.95-37.56c9.312-9.438 9.25-24.62-.1562-33.97c-9.438-9.312-24.59-9.219-33.97 .1562c-14.91 15.06-34.77 23.38-55.83 23.38c0 0 .0313 0 0 0c-21.09 0-40.95-8.312-55.89-23.38c-30.94-31.22-30.94-82.03 0-113.3C214.2 184.3 234 176 255.1 176z"],
    "corn": [512, 512, [63175], "1f33d", "M441.8 .3613c-1.1-.25-4.5-.375-6.1-.375c-12.12 0-23.75 2.875-34.12 8c-3.5-.5-7.125-.7501-10.75-.7501c-7.25 0-14.5 1-21.5 3.125c-9.249 2.625-17.87 7-25.5 12.75c-9.124 .5-18.12 2.5-26.62 6.125c-8.874 4-16.75 9.376-23.37 15.88c-9.124 1.5-17.1 4.75-25.1 9.501c-7.625 4.375-14.37 10-19.87 16.63C238.3 73.62 230 77.49 222.5 82.87C217.5 86.37 213.8 91.12 209.8 95.62C205 89.99 200.3 84.24 194.8 78.87L173.9 57.96C155.8 39.9 124.9 49.25 119.9 74.3L98.54 180.7L37.04 242.1C-10.21 289.4-12.08 364.4 30.54 413.6l60.75 62c27.27 27.27 65.2 40.28 104.9 35.31c29.42-3.678 56.23-18.87 77.21-39.81l57.87-57.75l106.4-21.35c25.05-5.024 34.4-35.94 16.33-54.01l-20.9-20.9c-5.375-5.375-10.87-10.25-16.62-15c3.625-3.375 7.625-6.375 10.5-10.5c5.375-7.375 9.249-15.5 11.5-24c6.1-5.875 12.1-12.88 17.5-20.75c4.5-7.75 7.625-16.25 9.125-25c6.5-6.5 11.87-14.13 15.62-22.5c3.1-8.875 6.125-18.13 6.625-27.5c5.75-7.375 10.12-15.75 12.87-24.63c3.125-10.25 3.1-21.13 2.625-31.75c5.375-10.13 8.5-21.38 8.1-32.88V80.62C514.3 39.49 483.5 3.987 441.8 .3613zM64.41 379.8c-24.12-30.63-21.75-75.5 6.5-103.8l71.75-71.75l18.37-91.63c45.87 46 62.25 102.1 48.87 155.3c-33.75 12-65.5 31.88-92.74 59.25L64.41 379.8zM307.6 369.3L235.9 441c-30.66 30.66-80.83 30.66-111.5-.0001l-26.75-26.75l53.37-53.38c37.87-37.88 85.99-58.38 133.5-58.38c41.12 0 81.87 15.5 114.7 48.5L307.6 369.3zM448 105.4c6.375 7.125 9.374 17.5 6.375 27.63c-2.1 9.626-10.62 16.75-19.5 19.5c4.1 7.875 6.125 18 1.1 27.13c-4.125 9.251-12.37 15-21.62 16.5c4.25 8.375 3.1 18.38-1.125 27c-4.75 8.5-13.5 13.5-22.75 14.25c3.25 8.5 2.375 18.38-3.375 26.38c-4.125 5.75-10.12 8.75-16.37 10.5c-27.12-12.75-56.75-19.63-87.12-19.63c-7.1 0-15.87 .5-23.62 1.375c4.75-39-2.375-78.63-21.37-115.6c1.375-7.25 4.75-14 10.1-18.38c9.499-6.875 19.1-6 26.62-3.5c.7499-9 5.75-17.75 14.25-22.5c13.62-8.125 26.5-1.375 26.87-1.125c1.625-9 7.625-17.25 16.87-21.38c11.5-5 21.75-1.25 27.12 2.25c2.75-9.251 9.999-16.5 19.75-19.25c2.5-.8751 15.1-4.375 27.5 6.875C432.9 18.61 495 81.24 448 105.4z"],
    "corner": [448, 512, [], "ac", "M424 384c-13.25 0-24-10.75-24-24V208H24C10.75 208 0 197.3 0 184S10.75 160 24 160h400C437.3 160 448 170.8 448 184v176C448 373.3 437.3 384 424 384z"],
    "couch": [640, 512, [], "f4b8", "M576 224c-35.35 0-64 28.65-64 64h-384c0-35.35-28.65-64-64-64s-64 28.65-64 64v160c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32h384c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V288C640 252.7 611.3 224 576 224zM80 432h-32V288c0-8.822 7.178-16 16-16S80 279.2 80 288V432zM512 400H128v-64h384V400zM592 432h-32V288c0-8.822 7.178-16 16-16s16 7.178 16 16V432zM88 192C101.3 192 112 181.3 112 168v-16c0-39.69 32.3-72 72-72h272c39.7 0 72 32.31 72 72v16C528 181.3 538.8 192 552 192S576 181.3 576 168v-16C576 85.84 522.2 32 456 32h-272C117.8 32 64 85.84 64 152v16C64 181.3 74.75 192 88 192z"],
    "cow": [640, 512, [63176], "1f404", "M624.5 238L608 218.9V176c0-11.88-12.5-19.62-23.12-14.25c-6.125 3-11.38 7-16.12 11.5l-59.1-69.54C490.6 78.71 461.8 64 431 64H112c-48.62 0-88 39.38-88 88v86.38C9.5 250.1 0 267.9 0 288v32c39.75 0 72-32.25 72-72l.0002-96c0-16.88 10.63-31.12 25.38-37C96.5 119.1 96 123.5 96 128L96 416c0 17.62 14.38 32 32 32h64c17.75 0 32-14.38 32-32v-40c2.625 .875 5.375 1.375 8.125 2.125L232.1 392c0 8.875 7.125 16 16 16c8.75 0 16-7.125 16-16l.0625-8.625c2.625 .125 13.25 .125 16-.125L280.1 392c0 8.875 7.125 16 16 16c8.75 0 16-7.125 16-16l.0625-14C314.8 377.2 317.5 376.9 320 376V416c0 17.62 14.38 32 32 32h64C433.6 448 448 433.6 448 416V272L464 288v42c0 12.25 3.5 24.38 10.25 34.75l35.38 54.87C521.1 437.2 540.8 448 561.8 448H576c35.38 0 64-28.62 64-64V279.8C640 264.5 634.5 249.6 624.5 238zM210.1 320.6C217 292.8 242.1 272 272 272s54.88 20.75 61.88 48.5C272.6 341.5 271.8 341.5 210.1 320.6zM592 384c0 8.875-7.125 16-16 16h-14.25c-4.75 0-9.125-2.375-11.75-6.5l-35.5-54.88C513.6 335.8 512.9 332.1 512 329.1V268.1l-75.75-75.75C422.9 179 400 188.5 400 207.4V400h-32v-64c0-45.63-38.13-96-96-96c-58.12 0-95.1 50.75-95.1 96L176 400h-32V128c0-8.875 7.25-16 16-16h4.375C165.1 113.5 189.8 146.9 189.8 146.9C211.5 175.8 241.1 192 272 192s60.5-16.25 82.38-45.12c0 0 24.5-33.38 25.38-34.88H431c15.25 0 29.88 7.375 38.88 19.88l118.3 137.5C590.6 272.2 592 276 592 279.8V384zM560 304C551.1 304 544 311.1 544 320s7.126 16 16 16s16-7.125 16-16S568.9 304 560 304z"],
    "cowbell": [448, 512, [], "f8b3", "M386.6 135.5C382.5 112.6 362.6 96 339.4 96h-18.76V48c0-26.51-21.49-48-48-48h-96.5C149.6 0 128.1 21.49 128.1 48L128.1 96H108.6C85.41 96 65.51 112.6 61.41 135.5L.4947 474.4C-2.835 493.3 11.5 512 32.12 512h383.8c20.65 0 34.95-18.69 31.63-37.63L386.6 135.5zM176 48h96V96h-96V48zM51.14 464l57.5-320h230.8l57.5 320H51.14z"],
    "cowbell-circle-plus": [576, 512, ["cowbell-more"], "f8b4", "M284.6 464H51.11l57.5-320h230.8l12.15 67.61c14.28-7.365 29.65-12.92 45.88-16.16l-10.79-59.94C382.5 112.6 362.6 96 339.3 96h-18.76V48c0-26.51-21.49-48-48-48H176.1c-26.51 0-48 21.49-48 48L128.1 96H108.6C85.38 96 65.48 112.6 61.37 135.5l-60.89 338.9C-2.85 493.3 11.49 512 32.11 512h298.9C312.6 499.1 296.9 482.8 284.6 464zM175.1 48h96V96h-96V48zM432 224C352.5 224 288 288.5 288 368s64.46 144 144 144C511.5 512 576 447.5 576 368S511.5 224 432 224zM496 384H448v48c0 8.836-7.163 16-15.1 16S416 440.8 416 432V384h-48c-8.836 0-15.1-7.164-15.1-16S359.2 352 368 352H416V304C416 295.2 423.2 288 432 288S448 295.2 448 304V352h48c8.836 0 16 7.164 16 16S504.8 384 496 384z"],
    "crate-apple": [512, 512, ["apple-crate"], "f6b1", "M210.5 50.5c11.38-12.25 14.5-32 13.25-50.25c-12.88-.875-35.63-.125-50 13.25C157.3 30.13 160 59.88 160.5 63.75C179 65 198.3 61.88 210.5 50.5zM402.3 50.5c11.25-12.25 14.38-32 13.25-50.25c-13-.875-35.75-.125-50.13 13.25c-16.5 16.62-13.75 46.38-13.12 50.25C370.6 65 389.1 61.88 402.3 50.5zM82.5 192C82.25 190.5 81.63 189.4 81.38 187.9c-3.125-17-1-43 9.125-57.63c5.25-7.625 11-9.5 14.38-10.12C112 119.3 133.4 123.5 148.3 131.9L160 138.4l11.75-6.5C186.5 123.6 207.9 119 215 120.1c6 1.125 10.62 4.375 14.62 10.12c10.12 14.62 12.25 40.63 9 58C238.4 189.6 237.9 190.6 237.6 192l48.66 .0003c2.625-18 1.462-40-4.413-60.38c.25-.375 .375-1 .625-1.375c5.25-7.625 10.88-9.5 14.5-10.12c6.75-1.125 28.5 3.375 43.38 11.75L352 138.4l11.75-6.5C378.5 123.6 399.9 119 407 120.1c3.75 .75 9.375 2.625 14.62 10.12c10.12 14.62 12.25 40.63 9 58C430.4 189.6 429.9 190.6 429.6 192h48.7c4-27 .4248-63.5-17.2-89c-11.25-16.38-27.13-26.75-45.88-30.12C397 69.75 371.5 75.88 352 84.25c-19.5-8.375-44.88-14.38-63.25-11.38C276.4 75.13 265.4 80.75 256 88.75c-9.375-8-20.38-13.62-32.75-15.88C205 69.75 179.5 75.88 160 84.25C140.5 75.88 115 69.88 96.75 72.88c-18.62 3.375-34.5 13.75-45.75 30C33.25 128.6 29.71 165.4 33.71 192L82.5 192zM480 223.8H32c-17.67 0-32 14.33-32 32v224.2C0 497.7 14.33 512 32 512h448c17.67 0 32-14.33 32-32V255.8C512 238.2 497.7 223.8 480 223.8zM464 464h-416v-72h416V464zM464 344h-416V271.7h416V344zM96 320c8.836 0 16-7.164 16-16S104.8 288 96 288S80 295.2 80 304S87.16 320 96 320zM416 320c8.836 0 16-7.164 16-16S424.8 288 416 288s-16 7.164-16 16S407.2 320 416 320zM96 448c8.836 0 16-7.164 16-16S104.8 416 96 416s-16 7.164-16 16S87.16 448 96 448zM416 448c8.836 0 16-7.164 16-16S424.8 416 416 416s-16 7.164-16 16S407.2 448 416 448z"],
    "crate-empty": [512, 512, [], "e151", "M480 223.8H32c-17.67 0-32 14.33-32 32v224.2C0 497.7 14.33 512 32 512h448c17.67 0 32-14.33 32-32V255.8C512 238.2 497.7 223.8 480 223.8zM464 464h-416v-72h416V464zM464 344h-416V271.7h416V344zM96 320c8.836 0 16-7.164 16-16S104.8 288 96 288S80 295.2 80 304S87.16 320 96 320zM416 320c8.836 0 16-7.164 16-16S424.8 288 416 288s-16 7.164-16 16S407.2 320 416 320zM96 448c8.836 0 16-7.164 16-16S104.8 416 96 416s-16 7.164-16 16S87.16 448 96 448zM416 448c8.836 0 16-7.164 16-16S424.8 416 416 416s-16 7.164-16 16S407.2 448 416 448z"],
    "credit-card": [576, 512, [61597, 62083, "credit-card-alt"], "1f4b3", "M512 32h-448c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM48.13 96c0-8.838 7.164-16 16-16h447.8c8.836 0 16 7.162 16 16v32H48.13V96zM527.9 416c0 8.836-7.164 16-16 16H64.13c-8.836 0-16-7.164-16-16L48 224h480L527.9 416zM120 384h48c13.25 0 23.1-10.75 23.1-24S181.3 336 168 336h-48C106.8 336 96 346.8 96 360S106.8 384 120 384zM248 384h112c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24h-112C234.7 336 224 346.7 224 360C224 373.3 234.7 384 248 384z"],
    "credit-card-blank": [576, 512, [], "f389", "M512 32h-448c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM527.9 416c0 8.836-7.164 16-16 16H64.13c-8.836 0-16-7.164-16-16V96c0-8.838 7.164-16 16-16h447.8c8.836 0 16 7.162 16 16V416zM168 336h-48C106.8 336 96 346.8 96 360S106.8 384 120 384h48c13.25 0 23.1-10.75 23.1-24S181.3 336 168 336zM360 336h-112C234.7 336 224 346.7 224 360C224 373.3 234.7 384 248 384h112c13.25 0 24-10.75 24-24C384 346.7 373.3 336 360 336z"],
    "credit-card-front": [576, 512, [], "f38a", "M512 32h-448c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM527.9 416c0 8.836-7.164 16-16 16H64.13c-8.836 0-16-7.164-16-16V96c0-8.838 7.164-16 16-16h447.8c8.836 0 16 7.162 16 16V416zM464 128h-96C359.2 128 352 135.2 352 144v64C352 216.8 359.2 224 368 224h96C472.8 224 480 216.8 480 208v-64C480 135.2 472.8 128 464 128zM168 336h-48C106.7 336 96 346.7 96 360C96 373.3 106.7 384 120 384h48C181.3 384 192 373.3 192 360C192 346.7 181.3 336 168 336zM168 256h-48C106.7 256 96 266.7 96 280C96 293.3 106.7 304 120 304h48C181.3 304 192 293.3 192 280C192 266.7 181.3 256 168 256zM328 336h-80C234.7 336 224 346.7 224 360C224 373.3 234.7 384 248 384h80c13.25 0 24-10.75 24-24C352 346.7 341.3 336 328 336zM328 256h-80C234.7 256 224 266.7 224 280C224 293.3 234.7 304 248 304h80C341.3 304 352 293.3 352 280C352 266.7 341.3 256 328 256zM456 256h-48C394.7 256 384 266.7 384 280c0 13.25 10.75 24 24 24h48C469.3 304 480 293.3 480 280C480 266.7 469.3 256 456 256z"],
    "cricket-bat-ball": [512, 512, [62537, "cricket"], "1f3cf", "M415.1 237.6c0-7.07-2.697-14.14-8.092-19.54l-34.35-34.35l129.1-129.1c6.247-6.246 9.374-14.44 9.374-22.62C511.1 14.94 498.3 0 480 0c-8.188 0-16.38 3.128-22.62 9.374l-129.1 129.1l-34.35-34.35c-5.395-5.395-12.46-8.09-19.54-8.09S260.3 98.69 254.9 104.1l-245.3 245.3c-5.861 5.861-9.592 13.8-9.592 22.02c0 102.8 108.9 140.6 140.6 140.6c8.219 0 16.16-3.727 22.03-9.594l245.3-245.3C413.3 251.7 415.1 244.6 415.1 237.6zM226.6 370.6l-92.39 92.39c-43.41-7.586-77.55-41.73-85.15-85.14L176 250.9V336h85.13L226.6 370.6zM309.1 288L224 287.1L224 202.9l50.42-50.42l85.14 85.14L309.1 288zM431.1 352c-44.25 0-80 35.75-80 79.1c0 44.25 35.75 79.1 80 79.1s80-35.75 80-79.1C511.1 387.8 476.2 352 431.1 352zM431.1 464c-17.64 0-32-14.36-32-32c0-17.64 14.36-31.99 32-31.99s32 14.35 32 31.99C463.1 449.6 449.6 464 431.1 464z"],
    "croissant": [512, 512, [63478], "1f950", "M507.7 167.1c-13.75-35.87-39.75-65.62-73.5-83.1c-3.375-16.87-12.62-31.1-26.25-42.5C372.8 14.75 329.7 .125 285.5 0c-15.5 .125-30.1 2-46.12 5.75C224.9-.375 208.6-1.625 193.4 2.25C99.12 25.62 25.62 99.12 2.123 193.4C-1.627 208.5-.3772 224.5 5.622 238.9c-13.87 58.62-.7499 120.4 35.75 168.4c10.25 13.25 24.1 22.5 41.5 25.1c18.5 34.25 48.62 60.62 84.99 74.5c46.87 17.62 95.37-21.1 87.12-71.5L239.1 341.2c1.625-1.875 2.1-3.75 4.375-5.75c18.12-.75 35.37-8.25 48.25-21.12l22.62-22.62c12.1-12.1 19.75-29.1 20.87-47.62c2.25-1.375 4.5-2.1 6.625-4.75l94.37 15.75C486.1 263.4 525.3 214.4 507.7 167.1zM111.7 382.2c-11.5 8.1-25.75 4.375-32.25-4.125c-21.87-28.62-31.87-63.25-30.75-97.87c.9999 .375 1.1 .1 3.125 1.25l135.2 41.62L111.7 382.2zM184.1 462.9c-20.12-7.75-37.62-20.1-50.5-38.25c2.375-1.375 4.75-2.1 6.1-4.625l54.1-43.12l11.12 67.37c.9999 5.875-1.25 11.1-5.1 15.87C196.1 463.9 190.6 464.1 184.1 462.9zM280.4 257.7l-22.62 22.75C251.1 287.1 241.2 289.6 232.2 286.9L65.99 235.6C52.99 231.6 45.37 218.2 48.74 204.1C67.87 127.1 127.1 67.87 204.1 48.75c13.12-3.25 26.62 4.25 30.62 17.25l51.12 166.1C289.6 241.2 287.1 251.1 280.4 257.7zM323.4 187.1l-41.87-135.1c-.375-1.25-.9999-2.375-1.375-3.625c1.75-.125 3.625-.375 5.375-.375c33.75 0 66.62 11.12 93.49 31.62c8.499 6.5 12.1 20.87 3.1 32.25L323.4 187.1zM444.2 207.7l-66.75-11.12l43.37-55.12c1.5-2.125 2.1-4.25 4.25-6.5c16.1 12.75 30.12 30.12 37.75 49.1c2.125 5.625 .9999 11.1-2.75 16.75C456.2 206.4 450.2 208.7 444.2 207.7z"],
    "crop": [512, 512, [], "f125", "M511.1 408c0 13.25-10.75 24-23.1 24H432v56c0 13.25-10.75 24-24 24S384 501.3 384 488V161.9L161.9 384H352v48H120c-22.06 0-40-17.94-40-40V128H24C10.75 128 0 117.3 0 104S10.75 80 24 80H80V24C80 10.75 90.75 0 103.1 0S128 10.75 128 24v326.1L350.1 128H160V80h238.1l72.97-72.97c9.375-9.375 24.56-9.375 33.94 0s9.375 24.56 0 33.94L432 113.9V384h56C501.3 384 511.1 394.8 511.1 408z"],
    "crop-simple": [512, 512, ["crop-alt"], "f565", "M488 384H432V120c0-22.06-17.94-40-40-40H160V128h224v360c0 13.25 10.75 24 23.1 24S432 501.3 432 488V432h56c13.25 0 23.1-10.75 23.1-24S501.3 384 488 384zM128 384V24C128 10.75 117.2 0 103.1 0S80 10.75 80 24V80H24c-13.25 0-24 10.75-24 24S10.75 128 24 128H80v264c0 22.06 17.94 40 40 40H352V384H128z"],
    "cross": [384, 512, [128327, 63060], "271d", "M335.1 112H272v-64C272 21.49 250.5 0 224 0H160C133.5 0 112 21.49 112 48v64H47.1C21.49 112-.0008 133.5-.0008 160v64c0 26.51 21.49 48 47.1 48H112v192C112 490.5 133.5 512 160 512h64c26.51 0 48-21.49 48-48v-192h63.1c26.51 0 48-21.49 48-48V160C383.1 133.5 362.5 112 335.1 112zM335.1 224H224v240H160V224H47.1V160H160V48h64V160h111.1V224z"],
    "crosshairs": [512, 512, [], "f05b", "M488 232h-17.38C459.6 131.9 380.1 52.38 280 41.38V23.1C280 10.75 269.3 0 256 0S232 10.75 232 23.1V41.38C131.9 52.38 52.38 131.9 41.38 232H23.1C10.75 232 0 242.7 0 256s10.75 24 23.1 24H41.38C52.38 380.1 131.9 459.6 232 470.6v17.38C232 501.3 242.7 512 255.1 512S280 501.3 280 488v-17.38c100.1-11 179.6-90.5 190.6-190.6H488C501.3 280 512 269.3 512 256S501.3 232 488 232zM280 422.2V391.1C280 378.7 269.3 368 256 368S232 378.7 232 391.1v30.25C158.4 411.9 100.1 353.5 89.75 280h30.25C133.3 280 144 269.3 144 256S133.3 232 120 232H89.75C100.1 158.4 158.5 100.1 232 89.75v30.25C232 133.3 242.7 144 255.1 144S280 133.3 280 120V89.75C353.6 100.1 411.9 158.5 422.2 232H391.1C378.7 232 368 242.7 368 255.1S378.7 280 391.1 280h30.25C411.9 353.6 353.5 411.9 280 422.2zM288 256c0 17.62-14.38 32-32 32C238.4 288 224 273.6 224 256s14.38-32 32-32C273.6 224 288 238.4 288 256z"],
    "crow": [640, 512, [], "f520", "M544 32L519.1 32C501.5 12.5 476.4 0 448 0c-53 0-96 43-96 96v30.12L12.12 393.6c-7.625 5.625-12.12 14.62-12.12 24.12c0 17.5 14.36 30.24 30.24 30.24c4.5 0 9.015-.9819 13.51-3.232l121.5-60.76L263.4 384l42.15 112.4c3.609 9.625 12.75 15.56 22.47 15.56c2.797 0 5.656-.5 8.422-1.531c12.42-4.656 18.7-18.5 14.05-30.91L314.7 384L352 384c1.875 0 3.75-.2513 5.625-.2513l1.574-.2588l42.34 112.9c3.609 9.625 12.75 15.56 22.47 15.56c2.797 0 5.656-.5 8.422-1.531c12.42-4.656 18.7-18.5 14.05-30.91l-38.99-103.1C486.4 351.7 544 278.7 544 192V112l96-16C640 60.63 597 32 544 32zM495.1 192C495.1 271.4 431.4 336 352 336H274.3l45.38-13c48-13.62 88.38-47.13 110.6-91.88c4-7.875 .75-17.5-7.125-21.38c-7.875-4-17.5-.75-21.5 7.125C383.4 253.5 350.3 281 310.8 292.3l-144.9 41.38L400 149.5l0-53.51C399.1 69.49 421.5 48 448 48s47.1 21.5 47.1 48V192zM448 72c-13.25 0-24 10.75-24 24S434.8 120 448 120S472 109.3 472 96S461.3 72 448 72z"],
    "crown": [576, 512, [62753], "1f451", "M536 96c-22.09 0-40 17.91-40 40c0 8.998 3.521 16.89 8.537 23.57l-89.63 71.7c-5.955 4.764-12.99 7.019-19.94 7.019c-11.61 0-22.98-6.298-28.68-17.7l-57.6-115.2C320 98.34 327.1 86.34 327.1 72C327.1 49.91 310.1 32 288 32S247.1 49.91 247.1 72c0 14.34 7.963 26.34 19.3 33.4L209.7 220.6C204 231.1 192.6 238.3 181 238.3c-6.945 0-13.98-2.255-19.94-7.019l-89.63-71.7C76.48 152.9 79.1 144.1 79.1 136c0-22.09-17.91-40-40-40s-40 17.91-40 40s17.91 40 40 40c.248 0 .457-.1164 .7051-.1203l50.52 277.8C93.99 468.9 107.2 480 122.7 480h330.6c15.46 0 28.72-11.06 31.48-26.27l50.52-277.9C535.5 175.9 535.8 176 536 176C558.1 176 576 158.1 576 136S558.1 96 536 96zM439.9 432H136.1l-33.89-186.4l28.94 23.15c14.14 11.31 31.87 17.54 49.92 17.54c30.53 0 57.97-16.95 71.61-44.23L288 171.3l35.37 70.73c13.64 27.28 41.08 44.23 71.61 44.23c18.06 0 35.79-6.229 49.92-17.54l28.94-23.15L439.9 432z"],
    "crutch": [512, 512, [], "f7f7", "M328.5 262.8L249.4 183.7l71.38-71.38l-33.88-33.88l-121.1 121c-11.75 11.62-19.88 26.38-23.5 42.38l-28.38 122.5l-106.8 106.7c-9.375 9.375-9.375 24.56 0 33.94C11.72 509.7 17.84 512 24 512s12.28-2.344 16.97-7.031l106.9-106.8l122.5-28.25c16-3.625 30.75-11.88 42.38-23.5l121.2-121L400 191.4L328.5 262.8zM278.8 312.6c-5.25 5.25-11.88 9-19.25 10.62l-91.75 21.25L189 252.7c1.625-7.375 5.375-14 10.75-19.25L215.5 217.6l79.13 79.25L278.8 312.6zM504.1 216.1C500.3 221.7 494.2 224 488 224s-12.28-2.344-16.97-7.031l-123.5-123.5c-.0391-.0391 .0391 .0391 0 0l-52.49-52.5c-9.375-9.375-9.375-24.56 0-33.94s24.56-9.375 33.94 0l123.5 123.5c.0391 .0391-.0391-.0391 0 0l52.49 52.5C514.3 192.4 514.3 207.6 504.1 216.1z"],
    "crutches": [640, 512, [], "f7f8", "M456.5 262.8l-79.13-79.13l71.38-71.38l-33.88-33.88l-121.1 121c-11.75 11.62-19.88 26.38-23.5 42.38l-28.38 122.5l-106.8 106.7C130.3 475.7 128 481.9 128 488C128 494.9 133.4 512 152 512c6.156 0 12.28-2.344 16.97-7.031l106.9-106.8l122.5-28.25c16-3.625 30.75-11.88 42.38-23.5l121.2-121L528 191.4L456.5 262.8zM406.8 312.6c-5.25 5.25-11.88 9-19.25 10.62l-91.75 21.25L317 252.7c1.625-7.375 5.375-14 10.75-19.25l15.75-15.88l79.13 79.25L406.8 312.6zM640 200C640 206.9 634.6 224 616 224c-6.156 0-12.28-2.344-16.97-7.031l-123.5-123.5c-.0391-.0391 .0391 .0391 0 0l-52.49-52.5C418.3 36.28 416 30.14 416 24C416 10.29 427.2 0 440 0c6.141 0 12.28 2.344 16.97 7.031l123.5 123.5c.0391 .0391-.0391-.0391 0 0l52.49 52.5C637.7 187.7 640 193.9 640 200zM55.26 202.7L40.97 216.1C36.28 221.7 30.16 224 24 224C5.205 224 0 206.8 0 200c0-6.141 2.344-12.28 7.031-16.97l52.49-52.5c.0391-.0391-.0391 .0391 0 0l123.5-123.5C187.7 2.344 193.9 0 200 0C213.7 0 224 11.21 224 24c0 6.141-2.344 12.28-7.031 16.97L202.3 55.62l95.05 94.98L271.1 176.8c-2.609 2.582-4.879 5.447-7.225 8.248L168.4 89.5L164.5 93.46c-.0391 .0391 .0391-.0391 0 0l-75.22 75.22l134.1 133.9l-10.54 45.52l-4.84 4.834c-2.869-2.234-6.098-3.969-8.68-6.551L55.26 202.7zM504.1 471C509.7 475.7 512 481.9 512 488c0 6.861-5.368 24-24 24c-6.156 0-12.28-2.344-16.97-7.031l-96.75-96.63l31.28-7.215c7.553-1.711 14.79-4.422 21.83-7.57L504.1 471z"],
    "cruzeiro-sign": [384, 512, [], "e152", "M378.8 396.2c8.219 10.38 6.5 25.47-3.906 33.7c-42.5 33.72-93.78 50.36-144.9 50.36c-58.91 0-117.6-22.08-162.4-65.59C24 372.3 0 315.1 0 256s24-116.3 67.59-158.6c83.75-81.25 215.9-87.81 307.3-15.23c10.41 8.234 12.12 23.33 3.906 33.7c-8.25 10.39-23.31 12.16-33.72 3.891c-72.72-57.64-177.7-52.45-244.1 12.08C66.84 165 48 209.1 48 256s18.84 90.98 53.03 124.2C118.4 397.1 138.6 409.7 160 418.4V248C160 234.8 170.8 224 184 224c11.35 0 20.43 8.055 22.92 18.65C219.2 236.1 233.1 232 248 232c31.31 0 60.53 16.84 76.22 43.97c6.625 11.47 2.719 26.16-8.75 32.8C303.9 315.4 289.3 311.4 282.7 300C275.5 287.7 262.3 280 248 280c-22.06 0-40 17.94-40 40v110.3c47.64 5.654 97.19-6.363 137.1-38.02C355.5 384 370.6 385.8 378.8 396.2z"],
    "crystal-ball": [448, 512, [], "e362", "M363.2 398.6C414.7 358.4 448 294.2 448 223.9C448 99.63 347.7 0 223.1 0C100.3 0 0 98.72 0 222.1c0 70.34 33.25 134.5 84.76 174.7l-46.35 62.09c-4.426 6.221-6.424 13.03-6.424 19.68C31.99 496.5 45.07 512 64.04 512h320c18.97 0 32.05-15.55 32.05-32.22c0-6.512-1.998-13.14-6.424-19.09L363.2 398.6zM296.9 383.5H151.1c-60.73-27.91-103.1-89.32-103.1-160.6c0-97.34 79.01-176.6 176-176.6s176 79.28 176 176.6C400.1 294.2 357.6 355.6 296.9 383.5zM364.4 217.4l-49.66-20.87l-20.73-50.08c-1.002-2.082-3.69-3.72-5.973-3.72c-2.315 0-4.909 1.639-5.911 3.72l-20.61 49.76l-.4063 .3783L211.6 217.4c-2.002 1.009-3.596 3.848-3.596 6.055c0 2.27 1.656 4.982 3.659 5.992l49.66 20.87l20.73 50.14c1.002 2.017 3.596 2.775 5.911 2.838c2.284 0 4.971-1.703 5.973-3.722l20.73-50.07l49.66-20.94c2.033-.1882 3.69-2.901 3.69-6.055C368.1 221.1 366.4 218.4 364.4 217.4zM205.8 139.1L175.8 126.6L163.2 96.72C162.6 95.53 162.8 94.52 160.5 94.52c-2.334 0-3.028 1.004-3.627 2.195L144.3 126.6L114.3 139.1C113 139.7 112 141.3 112 142.7s1.01 2.948 2.241 3.575L144.3 158.7l12.53 29.92c.631 1.254 3.123 2.258 3.627 2.258c.5059 0 2.114-1.004 3.598-3.136l12.56-29.92l29.19-11.54C207 145.6 208 144 208 142.7C208 141.3 207 139.7 205.8 139.1z"],
    "cube": [512, 512, [], "f1b2", "M491.2 85.31l-212.8-81.17C271.2 1.383 263.6 0 256 0S240.8 1.383 233.5 4.145l-212.8 81.17C8.273 90.08 0 102.2 0 115.8v280.4c0 13.57 8.273 25.72 20.76 30.48l212.8 81.17C240.8 510.6 248.4 512 256 512s15.23-1.383 22.47-4.145l212.8-81.17C503.7 421.9 512 409.8 512 396.2V115.8C512 102.2 503.7 90.08 491.2 85.31zM250.6 48.99C252.4 48.34 254.2 48 256 48s3.641 .3359 5.363 .9922l194.8 74.32L256 198.4L55.83 123.3L250.6 48.99zM48 171.6l184 69v215.3L48 385.7V171.6zM280 455.9V240.6l184-69v214.1L280 455.9z"],
    "cubes": [576, 512, [], "f1b3", "M555.2 256.6L448 215.8V78.95c0-13.53-8.273-25.64-20.76-30.4l-116.8-44.42C303.2 1.377 295.6 0 288 0S272.8 1.377 265.5 4.135L148.8 48.56C136.3 53.31 128 65.42 128 78.95v136.8L20.76 256.6C8.273 261.3 0 273.5 0 287v146c0 13.53 8.273 25.65 20.76 30.4l116.8 44.42C144.8 510.6 152.4 512 160 512s15.23-1.379 22.47-4.135L288 467.7l105.5 40.15C400.8 510.6 408.4 512 416 512s15.23-1.379 22.47-4.135l116.8-44.42C567.7 458.7 576 446.6 576 433V287C576 273.5 567.7 261.3 555.2 256.6zM136 455.9L48 422.4V337.8l88 29.33V455.9zM160 324.5L62.52 292L153.7 257.3l97.07 36.93L160 324.5zM264 425.5l-80 30.44V367.1l80-26.67V425.5zM264 243.2L182.5 212.1C180.4 211.3 178.2 210.9 176 210.3V129.8L264 159.1V243.2zM190.5 84.03l92.08-35.03C284.3 48.34 286.2 48 288 48s3.662 .3359 5.404 .998l92.07 35.03L288 116.5L190.5 84.03zM400 129.8v80.55c-2.166 .5684-4.359 1.003-6.473 1.808L312 243.1V159.1L400 129.8zM392 455.9l-80-30.44V340.4l80 26.67V455.9zM416 324.5l-90.79-30.26l97.06-36.93l91.2 34.7L416 324.5zM528 422.4l-88 33.48V367.1l88-29.33V422.4z"],
    "cup-straw": [384, 512, [], "e363", "M360 128l-153.3-.002l20-80L264 48C277.3 48 288 37.25 288 24C288 10.74 277.3 0 264 0l-43.5-.002c-18.32 0-34.29 12.47-38.75 30.24L157.3 127.1L24 128C10.75 128 0 138.7 0 152C0 165.3 10.75 176 24 176H32l30.5 306.3c1.25 16.88 15.12 29.88 32 29.75h195c16.88 .125 30.75-12.88 32-29.75L352 176h8C373.3 176 384 165.3 384 152C384 138.7 373.3 128 360 128zM275 464h-166l-28.75-288h223.5L275 464z"],
    "cup-straw-swoosh": [384, 512, [], "e364", "M360 128l-153.3-.002l20-80L264 48C277.3 48 288 37.25 288 24C288 10.74 277.3 0 264 0l-43.5-.002c-18.32 0-34.29 12.47-38.75 30.24L157.3 127.1L24 128C10.75 128 0 138.7 0 152C0 165.3 10.75 176 24 176H32l30.5 306.3c1.25 16.88 15.12 29.88 32 29.75h195c16.88 .125 30.75-12.88 32-29.75L352 176h8C373.3 176 384 165.3 384 152C384 138.7 373.3 128 360 128zM303.8 176l-5.707 57.17C253.7 238.7 211.7 264.3 180.8 305.6c-22.76 30.38-51.67 48.05-82.37 52.49L80.25 176H303.8zM275 464h-166l-5.719-57.29c43.83-5.83 85.28-31.45 115.9-72.31c20.66-27.57 46.35-44.97 73.86-51.35L275 464z"],
    "cup-togo": [448, 512, ["coffee-togo"], "f6c5", "M424 80h-9.789c-.3242-.9043-.3008-1.854-.7422-2.734l-32-64C377.4 5.141 369.1 0 360 0h-272C78.91 0 70.59 5.141 66.53 13.27l-32 64C34.09 78.15 34.11 79.1 33.79 80H24C10.75 80 0 90.74 0 104C0 117.3 10.75 128 24 128h400C437.3 128 448 117.3 448 104C448 90.74 437.3 80 424 80zM86.84 80l16.01-32h242.3l16.01 32H86.84zM387.8 160.3c-13.19-2-25.38 6.859-27.47 19.95L353.4 224H94.62L87.72 180.3C85.66 167.2 73.34 158.3 60.25 160.3C47.16 162.4 38.22 174.7 40.28 187.8l48 304C90.13 503.4 100.2 512 112 512h223.9c11.81 0 21.92-8.594 23.77-20.25l48-304C409.8 174.7 400.8 162.4 387.8 160.3zM315.5 464h-183L119.9 384h208.3L315.5 464z"],
    "curling-stone": [576, 512, [62538, "curling"], "1f94c", "M480 224c0-35.35-28.65-64-64-64H224V120C224 97.94 241.9 80 264 80h128C405.3 80 416 69.25 416 56S405.3 32 392 32h-128C215.5 32 176 71.47 176 120L175.1 160H160C124.7 160 95.1 188.7 95.1 224c-53.02 0-96 42.98-96 96v64c0 53.02 42.98 96 96 96h384c53.02 0 96-42.98 96-96v-64C576 266.1 533 224 480 224zM96 272h384c26.47 0 48 21.53 48 48v8h-480V320C48 293.5 69.53 272 96 272zM480 432H96c-26.47 0-48-21.53-48-48v-8h480V384C528 410.5 506.5 432 480 432z"],
    "d": [384, 512, [100], "44", "M154.7 480H24C10.75 480 0 469.3 0 456V56C0 42.75 10.75 32 24 32h130.7C281.1 32 384 132.5 384 256S281.1 480 154.7 480zM48 432h106.7C254.7 432 336 353 336 256s-81.34-176-181.3-176H48V432z"],
    "dagger": [384, 512, [], "f6cb", "M341.8 127.1L216 128V23.1C216 10.75 205.3 0 192 0S168 10.75 168 23.1V128L42.21 127.1C21.28 127.1 2.249 143.1 .201 163.9C-2.155 187.9 16.53 208 40 208c19.25 0 34.63-13.88 38.38-32H112v232l63.38 95.13C179.4 509 185.6 512 191.1 512c6.375 0 12.62-3 16.62-8.875L272 408V176h33.63c3.75 18.12 19.13 32 38.38 32c23.47 0 42.16-20.11 39.8-44.07C381.8 143.1 362.7 127.1 341.8 127.1zM224 393.5l-32 48l-32-48V176h64V393.5z"],
    "dash": [512, 512, [], "2014", "M512 256c0 13.25-10.75 24-24 24H24C10.75 280 0 269.3 0 256s10.75-24 24-24h464C501.3 232 512 242.8 512 256z"],
    "database": [448, 512, [], "f1c0", "M224 0c-123.7 0-224 35.82-224 80v352c0 44.18 100.3 80 224 80s224-35.82 224-80v-352C448 35.82 347.7 0 224 0zM224 464c-98.68 0-161.4-23.79-176-37.8v-72.81C89.01 372 152.5 384 223.1 384S358.1 372 400 353.4v72.81C385.4 440.2 322.7 464 224 464zM400 298.2C385.4 312.2 322.7 336 224 336S62.61 312.2 48 298.2V225.4C89.01 244 152.5 256 224 256s134.1-12 176-30.62V298.2zM400 170.2C385.4 184.2 322.7 208 223.1 208S62.61 184.2 48 170.2v-84.39C62.61 71.79 125.3 48 224 48s161.4 23.79 176 37.8V170.2z"],
    "deer": [512, 512, [63374], "1f98c", "M384 159.1c-8.75 0-16 7.248-16 15.1c0 8.748 7.25 15.1 16 15.1s16-7.248 16-15.1C400 167.2 392.8 159.1 384 159.1zM465.4 108.5l-68.62-19.37c3-3.374 6.125-6.373 8.625-9.998l18.12-27.12c4.875-7.248 2.875-17.25-4.375-22.24l-13.37-8.873c-7.375-4.874-17.25-2.874-22.13 4.374L365.5 52.49c-3.875 5.749-9.25 10.5-15.38 13.62l-48.88 24.37l-9.5-2.749c8-9.998 12.37-22.37 12.37-34.99l-.0625-36.74c0-8.748-7.188-15.1-15.94-15.1h-16C263.2-.0001 256 7.25 256 15.1l.125 36.74c0 1.875-.625 3.624-1.75 4.999L241 74.61L229.1 71.48C226.6 70.48 224.2 67.36 224.2 63.73V15.1c0-8.748-7.25-15.1-16-15.1h-16c-8.875 0-15.1 7.248-15.1 15.1v47.74c0 24.99 16.75 47.24 40.87 53.99l63.75 17.87l-14.63 24.37H88c-48.5 0-88 39.49-88 87.98v63.98h48v7.248l-10.38 27.74c-6.25 16.75-7.375 34.87-2.625 53.24l24.5 81.48C64 499.5 79.88 512 98.25 512h63.88c12.38 0 23.87-5.624 31.5-15.37c7.625-9.748 10.25-22.24 7-35.37l-23.1-80.61l10.62-28.62H240v119.1c0 22.12 17.88 39.99 40 39.99h64c22.12 0 40-17.87 40-39.99V295.2l20.75-31.24H448c35.25 0 64-28.74 64-63.98V170.1C512 141.6 492.8 116.2 465.4 108.5zM464 199.1c0 8.748-7.25 15.1-16 15.1h-68.75L336 280.7v183.2L288 463.9V303.9H153.1l-28.12 74.73l25.37 85.23h-47l-23.12-76.48c-2-7.873-1.5-16.12 1.25-23.74l14.12-31.74L96 263.9H48V247.9c0-22.12 17.88-39.99 40-39.99h205.8l34.5-58.74c7.5-14.1 24.5-22.49 40.75-17.1l83.25 23.49C459.3 156.6 464 162.1 464 170.1V199.1z"],
    "deer-rudolph": [576, 512, [], "f78f", "M400 159.1c-8.75 0-16 7.248-16 15.1c0 8.748 7.25 15.1 16 15.1S416 184.7 416 175.1C416 167.2 408.8 159.1 400 159.1zM536 95.98c-15.5 0-28.5 9.123-35.25 21.99c-5.75-4.124-12.25-7.373-19.38-9.373l-68.62-19.37c3-3.374 6.125-6.373 8.625-9.998l18.12-27.24c4.875-7.373 2.875-17.25-4.375-22.24l-13.37-8.873c-7.375-4.874-17.25-2.874-22.13 4.374L381.5 52.49c-3.875 5.749-9.25 10.5-15.38 13.62L316 91.1l-9-2.499l.75-.8748C315.6 77.73 320 65.36 320 52.74V15.1c0-8.748-7.25-15.1-16-15.1H288c-8.75 0-16 7.248-16 15.1v36.74c0 1.875-.625 3.624-1.75 4.999L256.9 74.61l-10.1-3.124C242.5 70.48 240.1 67.36 240.1 63.73V15.1c0-8.748-7.25-15.1-16-15.1H208.1c-8.875 0-16 7.248-16 15.1v47.74c0 24.99 16.75 47.24 40.88 53.99l63.75 17.87L282.2 159.1H88c-48.5 0-88 39.49-88 87.98v63.98h48v7.248l-10.38 27.74c-6.25 16.75-7.375 34.87-2.625 53.24l24.5 81.48C64 499.5 79.87 511.1 98.25 511.1l63.88 .0003c12.38 0 23.87-5.624 31.5-15.37c7.625-9.748 10.25-22.24 7-35.37l-24-80.61l10.62-28.62H256v119.1c0 22.12 17.88 39.99 40 39.99h64c22.12 0 40-17.87 40-39.99V302.3l21.88-38.37H464c35.25 0 64-28.74 64-63.98V174.3c2.75 .6248 5.25 1.625 8 1.625c22.12 0 40-17.87 40-39.99S558.1 95.98 536 95.98zM480 199.1c0 8.748-7.25 15.1-16 15.1h-69.88L352 289.6v174.3h-48V303.9H153.1l-28.12 74.73l25.37 85.23h-47l-23.12-76.48c-2-7.873-1.5-16.12 1.25-23.74l14.12-31.74L96 263.9L47.1 263.1L48 247.9c0-22.12 17.88-39.99 40-39.99h221.8l34.5-58.74c7.5-14.1 24.5-22.49 40.75-17.1l83.25 23.49C475.2 156.6 480 162.1 480 170.1V199.1z"],
    "delete-left": [576, 512, [62810, "backspace"], "232b", "M512 64H205.3C188.3 64 172 70.75 160 82.75L9.375 233.4c-12.5 12.5-12.5 32.75 0 45.25L160 429.3C172 441.3 188.3 448 205.3 448H512c35.38 0 64-28.62 64-64V128C576 92.63 547.4 64 512 64zM528 384c0 8.822-7.178 16-16 16H205.3c-4.268 0-8.283-1.666-11.31-4.691L54.63 256l139.3-139.3C196.1 113.7 200.1 112 205.3 112H512c8.822 0 16 7.178 16 16V384zM432.1 175c-9.375-9.375-24.56-9.375-33.94 0L352 222.1l-47.03-47.03c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l47.03 47.03L271 303c-9.375 9.375-9.375 24.56 0 33.94c9.373 9.373 24.56 9.381 33.94 0L352 289.9l47.03 47.03c9.373 9.373 24.56 9.381 33.94 0c9.375-9.375 9.375-24.56 0-33.94l-47.03-47.03l47.03-47.03C442.3 199.6 442.3 184.4 432.1 175z"],
    "delete-right": [576, 512, [], "e154", "M0 128v256c0 35.38 28.62 64 64 64h306.8C387.8 448 404 441.3 416 429.3l150.6-150.6c12.5-12.5 12.5-32.75 0-45.25L416 82.75C404 70.75 387.8 64 370.8 64H64C28.63 64 0 92.63 0 128zM48 128c0-8.822 7.178-16 16-16h306.8c4.268 0 8.283 1.666 11.31 4.691L521.4 256l-139.3 139.3C379 398.3 375 400 370.8 400H64c-8.822 0-16-7.178-16-16V128zM143 208.1l47.03 47.03L143 303c-9.375 9.375-9.375 24.56 0 33.94c9.381 9.381 24.56 9.373 33.94 0L224 289.9l47.03 47.03c9.381 9.381 24.56 9.373 33.94 0c9.375-9.375 9.375-24.56 0-33.94L257.9 255.1l47.03-47.03c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L224 222.1L176.1 175c-9.375-9.375-24.56-9.375-33.94 0S133.7 199.6 143 208.1z"],
    "democrat": [640, 512, [], "f747", "M638.7 221.2l-19.75-29.5c-25.25-37.88-66.51-61.25-111.6-63.75H288.3L214.6 66.75C226 47.62 226.1 23.75 213.8 4.87c-3.376-5.125-10.75-5.875-15.13-1.5L157.6 44.25l-41.88-41.88C112.1-1.255 106.1-.6302 103.4 3.62C91.1 20.75 93.5 43.25 106.5 59.62L13.48 168.2c-14.75 17.13-17.63 41.38-7.501 61.5l13.63 27.38c9.627 19.13 28.88 30.88 50.13 30.88h31.01c14.88 0 29.25-6 38.26-15.13l10.25-8.625l26.38 68.25v139.5C175.6 494.1 193.6 512 215.6 512h72.01c22.13 0 40.01-17.88 40.01-40v-40h96.14v40C423.8 494.1 441.8 512 463.8 512h72.14c22.13 0 40.01-17.88 40.01-40V214.8c.9728 1.227 2.2 2.195 3.125 3.586l19.63 29.38c1.125 1.875 3 3 5.001 3.5c2.25 .5 4.251 0 6.001-1.25l26.75-17.75C640.1 229.7 641.1 224.7 638.7 221.2zM527.8 463.1h-56.13v-64c0-8.75-7.126-16-16-16H295.7c-8.876 0-16 7.25-16 16v64H223.5v-112h304.3V463.1zM527.8 303.1H214.6l-37.01-98.75c-3.876-10.5-16.88-13.88-25.38-6.625L106.2 237.7C104.7 239.2 102.6 239.1 100.6 239.1H69.62c-3.126 0-5.876-1.75-7.251-4.375L48.62 208.2C47.24 205.4 47.62 201.1 49.74 199.5l88.76-103.5h36.26l96.14 80h216.9c22.13 0 40.01 17.88 40.01 40V303.1zM283.7 226.7L275.4 210.2c-1.5-3-5.751-3-7.251 0L260 226.7L241.6 229.5c-3.251 .5-4.501 4.5-2.125 6.75L252.6 249.2L249.6 267.4C249 270.7 252.5 273.2 255.4 271.6l16.25-8.625l16.38 8.625c2.875 1.5 6.376-.875 5.751-4.25L290.7 249.2l13.25-13c2.375-2.25 1.125-6.25-2.25-6.75L283.7 226.7zM379.4 226.7L371.2 210.2c-1.5-3-5.626-3-7.126 0L355.8 226.7l-18.25 2.75c-3.376 .5-4.626 4.5-2.25 6.75L348.5 249.2l-3.126 18.13c-.6251 3.375 2.875 5.875 5.751 4.25l16.38-8.625l16.25 8.625c2.875 1.5 6.376-.875 5.876-4.25L386.5 249.2l13.13-13c2.5-2.25 1.125-6.25-2.125-6.75L379.4 226.7zM475.7 226.7l-8.251-16.5c-1.5-3-5.751-3-7.251 0l-8.126 16.5l-18.38 2.75c-3.251 .5-4.501 4.5-2.125 6.75l13.13 13l-3 18.13c-.6251 3.375 2.875 5.875 5.751 4.25l16.25-8.625l16.38 8.625c2.875 1.5 6.376-.875 5.751-4.25L482.7 249.2l13.25-13c2.375-2.25 1.125-6.25-2.25-6.75L475.7 226.7z"],
    "desktop": [576, 512, [62352, 61704, "desktop-alt"], "1f5a5", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h148.3l-9.6 48H152C138.8 464 128 474.8 128 488S138.8 512 152 512h272c13.25 0 24-10.75 24-24s-10.75-24-24-24h-50.73L363.7 416H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM324.3 464H251.7L261.3 416h53.46L324.3 464zM528 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V304h480V352zM528 256h-480V64c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V256z"],
    "desktop-arrow-down": [576, 512, [], "e155", "M191 103c-9.375 9.375-9.375 24.56 0 33.94l80 80c9.375 9.375 24.56 9.375 33.94 0l80-80c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L312 142.1V24C312 10.75 301.3 0 288 0S264 10.75 264 24v118.1L224.1 103C220.3 98.34 214.2 96 208 96S195.7 98.34 191 103zM512 0h-160v48h160c8.822 0 16 7.178 16 16v192h-480V64c0-8.822 7.178-16 16-16h160V0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h148.3l-9.6 48H152C138.8 464 128 474.8 128 488S138.8 512 152 512h272c13.25 0 24-10.75 24-24s-10.75-24-24-24h-50.73L363.7 416H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM251.7 464L261.3 416h53.46l9.6 48H251.7zM528 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V304h480V352z"],
    "dharmachakra": [512, 512, [63061], "2638", "M499.3 232l-20.5 .625C474.1 188.2 456.6 147.9 429.1 115l15-14c5.125-4.75 5.25-12.75 .375-17.75l-16.62-16.62c-5-4.875-13-4.75-17.75 .375l-14 15C364.1 55.38 323.8 37.88 279.4 33.25L280 12.75C280.2 5.75 274.8 0 267.8 0h-23.5C237.3 0 231.8 5.75 232 12.75l.625 20.5C188.2 37.88 147.9 55.38 115 82L101 67C96.25 61.88 88.25 61.75 83.25 66.62L66.63 83.25C61.75 88.25 61.88 96.25 67 101l14.1 14c-26.62 32.88-44.12 73.25-48.75 117.6L12.75 232C5.75 231.8 0 237.2 0 244.2v23.5C0 274.8 5.75 280.2 12.75 280l20.5-.625c4.625 44.38 22.13 84.75 48.75 117.6l-14.1 14c-5.125 4.75-5.25 12.75-.375 17.75l16.62 16.62c5 4.875 13 4.75 17.75-.375l14-14.1c32.88 26.62 73.25 44.12 117.6 48.75L232 499.2C231.8 506.2 237.3 512 244.3 512h23.5c7 0 12.5-5.75 12.25-12.75l-.625-20.5c44.38-4.625 84.75-22.13 117.6-48.75l14 14.1c4.75 5.125 12.75 5.25 17.75 .375l16.62-16.62c4.875-5 4.75-13-.375-17.75l-15-14c26.63-32.88 44.13-73.25 48.75-117.6L499.3 280C506.3 280.2 512 274.8 512 267.8V244.2C512 237.2 506.3 231.8 499.3 232zM430.5 234.1l-80.5 2.5c-2.5-12.12-7.375-23.25-13.87-33.25l58.63-55.25C413.8 172.5 426.5 202 430.5 234.1zM256 304C229.5 304 208 282.5 208 256S229.5 208 256 208s48 21.5 48 48S282.5 304 256 304zM363.9 117.2l-55.25 58.63c-9.875-6.5-21.12-11.38-33.13-13.87l2.375-80.5C309.1 85.5 339.5 98.25 363.9 117.2zM234.1 81.5l2.5 80.5C224.5 164.5 213.4 169.4 203.4 175.9L148.1 117.2C172.5 98.25 201.1 85.5 234.1 81.5zM117.2 148.1l58.63 55.25C169.4 213.2 164.5 224.5 161.1 236.5L81.5 234.1C85.5 202 98.25 172.5 117.2 148.1zM81.5 277.9l80.5-2.5C164.5 287.5 169.4 298.6 175.9 308.6L117.2 363.9C98.25 339.5 85.5 310 81.5 277.9zM148.1 394.8l55.25-58.63c9.875 6.5 21.12 11.38 33.13 13.88L234.1 430.5C201.1 426.5 172.5 413.8 148.1 394.8zM277.9 430.5l-2.5-80.5c12.12-2.5 23.25-7.375 33.25-13.88l55.25 58.63C339.5 413.8 309.1 426.5 277.9 430.5zM394.8 363.9l-58.63-55.25c6.5-9.875 11.38-21.12 13.87-33.13l80.5 2.375C426.5 310 413.8 339.5 394.8 363.9z"],
    "diagram-lean-canvas": [640, 512, [], "e156", "M576 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V96C640 60.65 611.3 32 576 32zM576 80c8.824 0 16 7.178 16 16v208H512v-224H576zM464 80v96h-64v-96H464zM400 224h64v80h-64V224zM352 80v224H288v-224H352zM240 80v96h-64v-96H240zM176 224h64v80h-64V224zM64 80h64v224H48V96C48 87.18 55.18 80 64 80zM48 416v-64h248v80H64C55.18 432 48 424.8 48 416zM592 416c0 8.822-7.176 16-16 16h-232V352h248V416z"],
    "diagram-nested": [512, 512, [], "e157", "M232 376H176c-22.06 0-40-17.94-40-40V224H176C202.5 224 224 202.5 224 176v-128C224 21.49 202.5 0 176 0h-128C21.49 0 0 21.49 0 48v128C0 202.5 21.49 224 48 224h40v112c0 48.53 39.47 88 88 88h56c13.25 0 24-10.75 24-24S245.3 376 232 376zM48 176v-128h128v128H48zM464 288h-128C309.5 288 288 309.5 288 336v128c0 26.51 21.49 48 48 48h128c26.51 0 48-21.49 48-48v-128C512 309.5 490.5 288 464 288zM464 464h-128v-128h128V464z"],
    "diagram-project": [640, 512, ["project-diagram"], "f542", "M368 320h-96C245.5 320 224 341.5 224 368v96C224 490.5 245.5 512 272 512h96c26.51 0 48-21.49 48-48v-96C416 341.5 394.5 320 368 320zM368 464h-96v-96h96V464zM591.1 0h-96c-26.51 0-48 21.49-48 48v96c0 26.51 21.49 48 48 48h96c26.51 0 48-21.49 48-48v-96C639.1 21.49 618.5 0 591.1 0zM591.8 144h-96v-96h96V144zM392 72H192V48C192 21.49 170.5 0 144 0h-96C21.49 0 0 21.49 0 48v96C0 170.5 21.49 192 48 192h90.07l57.09 99.91C199.6 299.7 207.7 304 216 304c4.031 0 8.125-1.031 11.88-3.156c11.5-6.594 15.5-21.25 8.938-32.75L182.3 172.7C188.3 164.6 192 154.8 192 144V120h200C405.3 120 416 109.3 416 96S405.3 72 392 72zM144 144h-96v-96h96V144z"],
    "diagram-sankey": [640, 512, [], "e158", "M608 296c0-13.25-10.75-24-24-24H56C42.75 272 32 282.8 32 296S42.75 320 56 320h122.4l89.01 148.3C271.8 475.6 279.6 480 288 480h296c13.25 0 24-10.75 24-24s-10.75-24-24-24H301.6L234.4 320H584C597.3 320 608 309.3 608 296zM56 240h192c8.438 0 16.25-4.422 20.59-11.66L357.6 80H584C597.3 80 608 69.25 608 56S597.3 32 584 32h-240c-8.438 0-16.25 4.422-20.59 11.66L234.4 192H56C42.75 192 32 202.8 32 216S42.75 240 56 240z"],
    "diagram-venn": [640, 512, [], "e15a", "M416 32c-34.41 0-66.87 7.999-96 21.86C290.9 39.1 258.4 32 224 32C100.3 32 0 132.3 0 256s100.3 224 224 224c34.41 0 66.87-7.999 96-21.86C349.1 472 381.6 480 416 480c123.7 0 224-100.3 224-224S539.7 32 416 32zM320 108.7C340.4 122 357.7 139.6 370.1 160H269C282.3 139.6 299.6 122 320 108.7zM224 432c-97.05 0-176-78.95-176-176S126.1 80 224 80c15.95 0 31.33 2.322 46.03 6.316C222.3 127.4 192 188.1 192 256s30.33 128.6 78.03 169.7C255.3 429.7 239.9 432 224 432zM320 403.3C299.6 389.1 282.4 372.4 268.1 352h102C357.6 372.4 340.4 389.1 320 403.3zM387.8 320H252.2C246.2 304.9 242.6 288.8 241 272h157.9C397.4 288.8 393.8 304.9 387.8 320zM241 240C242.6 223.2 246.7 207.1 252.6 192h134.7c5.922 15.14 10.06 31.17 11.6 48H241z"],
    "dial": [576, 512, ["dial-med-high"], "e15b", "M32 256C14.33 256 0 270.3 0 288c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32C270.3 0 256 14.33 256 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35zM174.9 401.1c62.48 62.48 163.8 62.48 226.3-.002s62.48-163.8 0-226.3c-62.48-62.49-163.8-62.49-226.3-.002S112.4 338.7 174.9 401.1zM208.8 208.8c37.83-37.83 96.17-42.76 139.5-15.04L271 271c-9.369 9.369-9.369 24.57 0 33.94s24.57 9.369 33.94 0l77.26-77.26c27.72 43.32 22.79 101.7-15.04 139.5c-43.67 43.67-114.7 43.67-158.4 .002C165.1 323.5 165.1 252.5 208.8 208.8z"],
    "dial-high": [576, 512, [], "e15c", "M32 256C14.33 256 0 270.3 0 288c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32C270.3 0 256 14.33 256 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35zM127.1 288c.0014 88.36 71.64 159.1 160 159.1s160-71.63 159.1-159.1c.0014-88.37-71.63-160-159.1-160S127.1 199.6 127.1 288zM287.1 176c53.5 0 98.23 37.77 109.3 88H287.1c-13.25 0-24 10.75-24 24c0 13.25 10.75 24 24 24h109.3c-11.03 50.24-55.76 87.1-109.3 88c-61.76 0-112-50.24-112-112C175.1 226.2 226.2 175.1 287.1 176z"],
    "dial-low": [576, 512, [], "e15d", "M32 256C14.33 256 0 270.3 0 288c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32C270.3 0 256 14.33 256 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35zM448 287.1c-.0014-88.36-71.65-159.1-160-159.1s-159.1 71.63-159.1 159.1c-.0014 88.37 71.63 160 159.1 160S447.1 376.3 448 287.1zM287.1 400c-53.5 0-98.23-37.77-109.3-88h109.3c13.25 0 24-10.75 24-24c0-13.25-10.75-24-24-24H178.7c11.03-50.24 55.76-87.1 109.3-88c61.76 0 112 50.24 112 112C400 349.8 349.8 400 287.1 400z"],
    "dial-max": [576, 512, [], "e15e", "M129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM32 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32c-17.67 0-32 14.33-32 32C256 49.67 270.3 64 288 64zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.25 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM401.1 174.9c-62.48-62.48-163.8-62.48-226.3 0s-62.48 163.8 0 226.3s163.8 62.48 226.3 0S463.6 237.3 401.1 174.9zM382.2 348.3l-77.27-77.26c-9.369-9.369-24.57-9.369-33.94 0s-9.369 24.57 0 33.94l77.26 77.26c-43.33 27.72-101.7 22.79-139.5-15.04c-43.67-43.67-43.67-114.7-.002-158.4c43.67-43.67 114.7-43.67 158.4 0C405 246.6 409.1 304.1 382.2 348.3zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.25 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4z"],
    "dial-med": [576, 512, [], "e15f", "M32 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32c-17.67 0-32 14.33-32 32C256 49.67 270.3 64 288 64zM446.4 84.36c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.36zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM288 128c-88.37 0-160 71.63-160 159.1c0 88.37 71.63 160 160 160c88.37 0 160-71.63 160-160C448 199.6 376.4 128 288 128zM288 400c-61.76 0-112-50.24-112-112c0-53.5 37.77-98.23 88-109.3V288c0 13.25 10.75 24 24 24s24-10.75 24-24V178.7C362.2 189.8 400 234.5 400 288C400 349.8 349.8 400 288 400zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4z"],
    "dial-med-low": [576, 512, [], "e160", "M32 256C14.33 256 0 270.3 0 288c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32C270.3 0 256 14.33 256 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35zM401.1 401.1c62.48-62.48 62.48-163.8-.002-226.3s-163.8-62.48-226.3 0c-62.49 62.48-62.49 163.8-.002 226.3S338.7 463.6 401.1 401.1zM208.8 367.2c-37.83-37.83-42.76-96.17-15.04-139.5l77.26 77.26c9.369 9.369 24.57 9.369 33.94 0s9.369-24.57 0-33.94L227.7 193.8c43.32-27.72 101.7-22.79 139.5 15.04c43.67 43.67 43.67 114.7 .002 158.4C323.5 410.9 252.5 410.9 208.8 367.2z"],
    "dial-min": [576, 512, [], "e161", "M32 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32c-17.67 0-32 14.33-32 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35zM401.1 174.9c-62.48-62.48-163.8-62.48-226.3 .002s-62.48 163.8 0 226.3c62.48 62.49 163.8 62.49 226.3 .002S463.6 237.3 401.1 174.9zM367.2 367.2c-37.83 37.83-96.17 42.76-139.5 15.04l77.26-77.26c9.369-9.369 9.369-24.57 0-33.94s-24.57-9.369-33.94 0l-77.26 77.26c-27.72-43.32-22.79-101.7 15.04-139.5c43.67-43.67 114.7-43.67 158.4-.002C410.9 252.5 410.9 323.5 367.2 367.2z"],
    "dial-off": [576, 512, [], "e162", "M32 256C14.33 256 0 270.3 0 288c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32C270.3 0 256 14.33 256 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35zM287.1 127.1C199.6 128 127.1 199.6 127.1 288s71.63 160 159.1 159.1c88.37 .0014 160-71.63 160-159.1S376.4 128 287.1 127.1zM399.1 288c0 53.5-37.77 98.23-88 109.3V288c0-13.25-10.75-24-24-24c-13.25 0-24 10.75-24 24v109.3c-50.24-11.03-87.1-55.76-88-109.3c0-61.76 50.24-112 112-112C349.8 175.1 400 226.2 399.1 288z"],
    "diamond": [512, 512, [61977], "2666", "M497.1 222.1l-208.1-208.1C280.5 4.676 268.3 0 256 0C243.7 0 231.5 4.676 222.1 14.03L14.03 222.1c-18.71 18.71-18.71 49.04 0 67.74l208.1 208.1C231.5 507.3 243.7 512 256 512c12.26 0 24.52-4.677 33.87-14.03l208.1-208.1C516.7 271.2 516.7 240.8 497.1 222.1zM256.1 464L47.97 256.1l207.1-208.1l208.1 207.9L256.1 464z"],
    "diamond-turn-right": [512, 512, ["directions"], "f5eb", "M497.1 222.1l-208.1-208.1c-9.354-9.355-21.63-14.03-33.89-14.03c-12.26 0-24.5 4.675-33.85 14.03L14.03 222.1C4.677 231.5 .0004 243.7 .0004 255.1c0 12.26 4.676 24.52 14.03 33.87l208.1 208.1C231.5 507.3 243.7 511.1 256 511.1c12.26 0 24.52-4.679 33.87-14.03l208.1-208.1c9.353-9.354 14.03-21.61 14.03-33.87C511.1 243.7 507.3 231.5 497.1 222.1zM256.1 464L47.97 256.1l207.1-208.1l208.1 207.9L256.1 464zM302.1 216H200C186.8 216 176 226.8 176 240v72c0 13.25 10.75 24 24 24S224 325.3 224 312v-48h78.06l-23.03 23.03c-9.375 9.375-9.375 24.56 0 33.94C283.7 325.7 289.8 328 296 328s12.28-2.344 16.97-7.031l64-64c9.375-9.375 9.375-24.56 0-33.94l-64-64c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L302.1 216z"],
    "dice": [640, 512, [62754], "1f3b2", "M575.1 192h-102.2c3.551 10.11 5.748 20.73 5.748 31.77c0 25.64-9.984 49.75-28.12 67.89L320 423.2v24.84C320 483.3 348.7 512 383.1 512h191.1c35.35 0 63.1-28.65 63.1-63.1v-191.1C639.1 220.7 611.3 192 575.1 192zM479.1 376c-13.25 0-23.1-10.75-23.1-23.1c0-13.26 10.75-23.1 23.1-23.1s23.1 10.74 23.1 23.1C503.1 365.3 493.3 376 479.1 376zM447.5 223.8c0-16.38-6.249-32.76-18.75-45.26L269 18.73C256.5 6.238 240.3 0 223.1 0S191 6.238 178.5 18.73l-159.8 159.8C6.235 191-.0011 207.6-.0011 223.1s6.236 32.57 18.73 45.06l159.8 159.8c12.5 12.5 28.88 18.74 45.26 18.74s32.76-6.248 45.25-18.74l159.8-159.8C441.3 256.5 447.5 240.1 447.5 223.8zM394.9 235.1l-159.8 159.8c-4.076 4.076-8.838 4.686-11.31 4.686c-2.477 0-7.238-.6094-11.31-4.686L52.67 235.1C48.59 231 47.99 226.2 47.99 223.8s.6074-7.236 4.686-11.31l159.8-159.8c4.082-4.08 8.844-4.689 11.32-4.689s7.234 .6094 11.31 4.687l159.8 159.8c4.078 4.078 4.687 8.84 4.687 11.31S398.9 231 394.9 235.1zM223.8 301.6c-12.79 0-23.1 10.29-23.1 23.1c0 13.76 11.25 23.1 23.1 23.1c13.73 0 24-11.22 24-23.1C247.8 312.8 237.5 301.6 223.8 301.6zM223.8 199.8c-13.76 0-23.1 11.25-23.1 23.1c0 12.84 10.34 23.1 23.1 23.1c13.71 0 24-11.21 24-23.1C247.8 210.1 237.5 199.8 223.8 199.8zM121.9 199.8c-13.76 0-24 11.25-24 23.1c0 12.79 10.29 23.1 24 23.1c13.71 0 23.1-11.2 23.1-23.1C145.9 210.1 135.7 199.8 121.9 199.8zM325.6 199.8c-13.76 0-24 11.25-24 23.1c0 12.79 10.29 23.1 24 23.1c13.71 0 24-11.21 24-23.1C349.6 210.1 339.3 199.8 325.6 199.8zM223.8 97.94c-12.79 0-23.1 10.29-23.1 23.1c0 13.76 11.25 23.1 23.1 23.1c13.73 0 24-11.22 24-23.1C247.8 109.1 237.5 97.94 223.8 97.94z"],
    "dice-d10": [512, 512, [], "f6cd", "M512 282.6c0-7.59-2.683-15.19-8.118-21.32l-224.1-250.6C273.5 3.5 264.8 0 256 0S238.5 3.5 232.2 10.62L8.151 261.3C2.671 267.4 0 274.1 0 282.5C0 291.4 3.662 300.2 10.8 306.5l224.1 197.5C240.9 509.4 248.5 512 256 512c7.5 0 15.12-2.615 21.12-7.99l224.1-197.5C508.4 300.2 512 291.4 512 282.6zM256 287.9L189.9 243.8l66.12-154.1l66.12 154.1L256 287.9zM142.7 232.2L85.79 246.5l97.49-109.1L142.7 232.2zM155.5 278.5l76.5 51v108l-157.4-138.7L155.5 278.5zM280 329.5l76.5-51l80.87 20.25l-157.4 138.7V329.5zM369.4 232.2l-40.62-94.87l97.49 109.1L369.4 232.2z"],
    "dice-d12": [512, 512, [], "f6ce", "M508.6 185.2l-55.87-111.7c-3.125-6.125-8.125-11.12-14.25-14.25l-111.7-55.87C322.4 1.125 317.4 0 312.5 0h-113C194.6 0 189.6 1.125 185.2 3.375L73.5 59.25C67.38 62.38 62.38 67.38 59.25 73.5L3.375 185.2C1.125 189.6 0 194.6 0 199.5v113c0 4.875 1.125 9.75 3.375 14.25l55.87 111.7c3.125 6.125 8.125 11.12 14.25 14.25l111.7 55.87C189.6 510.9 194.6 512 199.5 512h113c4.875 0 9.75-1.125 14.25-3.375l111.7-55.87c6.125-3.125 11.12-8.125 14.25-14.25l55.87-111.7C510.9 322.2 512 317.4 512 312.5v-113C512 194.6 510.9 189.8 508.6 185.2zM455 185.4l-78.13 104.2L280 241.1v-93.5l140.8-28.12l-1-4.625L455 185.4zM300.5 464h-89l-53-132.4L256 282.9l97.5 48.75L300.5 464zM203.4 48h105.3L373 80.12L256 103.5L139 80.12L203.4 48zM92.25 114.9l-1 4.625L232 147.6v93.5L135.1 289.6L57 185.4L92.25 114.9zM48 308.6v-55.25l58.88 78.5l42 104.9L99.75 412.2L48 308.6zM412.2 412.2l-49.12 24.5l42-104.9L464 253.4v55.25L412.2 412.2z"],
    "dice-d20": [512, 512, [], "f6cf", "M463.9 116.1l-192-111.9C267 1.438 261.5 0 255.1 0S245 1.438 240.1 4.25l-192 111.9C38.12 121.1 32 132.7 32 144.5v223c0 11.75 6.125 22.48 16.12 28.36l192 111.9C245 510.6 250.5 512 256 512s11-1.438 15.88-4.25l192-111.9C473.9 390 480 379.3 480 367.5V144.5C480 132.7 473.9 121.1 463.9 116.1zM256 87.85l72.5 96.14h-145L256 87.85zM256 339.3L187.8 231.1h136.5L256 339.3zM145.1 254.5l63.38 99.51l-83.38-19.38L145.1 254.5zM366.9 254.5l20 80.13l-83.38 19.38L366.9 254.5zM383.5 177.2l-70.38-93.39l106 61.76L383.5 177.2zM128.5 177.2L92.88 145.6l106-61.76L128.5 177.2zM104.2 219.9L80 317V198.4L104.2 219.9zM232 408.8v38.63l-110.2-64.26L232 408.8zM280 408.8l110.2-25.63L280 447.4V408.8zM432 317l-24.25-97.14L432 198.4V317z"],
    "dice-d4": [512, 512, [], "f6d0", "M512 309.1c0-7.05-2.318-14.15-7.127-20.07l-224-277.1C274.5 3.1 265.2 0 256 0C246.8 0 237.5 3.1 231.1 11.88l-224 277.1C2.318 294.9 0 302 0 309.1c0 9.625 4.319 19.15 12.62 25.43l224 170.1C242.1 509.7 249 512 256 512c6.875 0 13.62-2.135 19.37-6.51l224-170.1C507.7 328.2 512 318.7 512 309.1zM232 87.12V441.5L54.76 306.4L232 87.12zM279.1 441.5V87.12l177.2 219.3L279.1 441.5z"],
    "dice-d6": [448, 512, [], "f6d1", "M431.9 116.1l-192-111.9C235 1.438 229.5 0 224 0S213 1.438 208.1 4.25l-192 111.9C6.125 121.1 0 132.7 0 144.5v223c0 11.75 6.125 22.48 16.12 28.36l192 111.9C213 510.6 218.5 512 224 512s11-1.438 15.88-4.25l192-111.9C441.9 390 448 379.3 448 367.5V144.5C448 132.7 441.9 121.1 431.9 116.1zM224 50.6l152.4 88.76L224 228.2L71.63 139.4L224 50.6zM48 181.1l152 88.64v177.6L48 358.9V181.1zM248 447.4V269.8l152-88.64v177.8L248 447.4z"],
    "dice-d8": [512, 512, [], "f6d2", "M512 256c0-8.625-3.305-17.25-9.868-23.88l-222.2-222.3C273.3 3.262 264.6 0 256 0S238.7 3.262 232.1 9.887L9.868 232.1C3.305 238.8 0 247.4 0 256S3.305 273.3 9.868 279.9l222.2 222.3C238.7 508.7 247.4 512 256 512s17.26-3.262 23.89-9.887l222.2-222.3C508.7 273.2 512 264.7 512 256zM280 77.88l166.4 166.4l-166.4 71.38V77.88zM231.1 315.6L65.6 244.2L231.1 77.88V315.6zM231.1 367.9v66.25l-116-116L231.1 367.9zM280 367.9l116-49.75l-116 116V367.9z"],
    "dice-five": [448, 512, [62755], "2684", "M128 128C110.4 128 96 142.4 96 160s14.38 32 32 32s32-14.38 32-32S145.6 128 128 128zM128 320c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S145.6 320 128 320zM320 320c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S337.6 320 320 320zM320 128c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S337.6 128 320 128zM384 32H64C28.63 32 0 60.63 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.63 419.4 32 384 32zM400 416c0 8.875-7.125 16-16 16H64c-8.875 0-16-7.125-16-16V96c0-8.875 7.125-16 16-16h320c8.875 0 16 7.125 16 16V416zM224 224C206.4 224 192 238.4 192 256s14.38 32 32 32s32-14.38 32-32S241.6 224 224 224z"],
    "dice-four": [448, 512, [62756], "2683", "M384 32H64C28.63 32 0 60.63 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.63 419.4 32 384 32zM400 416c0 8.875-7.125 16-16 16H64c-8.875 0-16-7.125-16-16V96c0-8.875 7.125-16 16-16h320c8.875 0 16 7.125 16 16V416zM128 128C110.4 128 96 142.4 96 160s14.38 32 32 32s32-14.38 32-32S145.6 128 128 128zM320 320c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S337.6 320 320 320zM320 128c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S337.6 128 320 128zM128 320c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S145.6 320 128 320z"],
    "dice-one": [448, 512, [62757], "2680", "M224 224C206.4 224 192 238.4 192 256s14.38 32 32 32s32-14.38 32-32S241.6 224 224 224zM384 32H64C28.63 32 0 60.63 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.63 419.4 32 384 32zM400 416c0 8.875-7.125 16-16 16H64c-8.875 0-16-7.125-16-16V96c0-8.875 7.125-16 16-16h320c8.875 0 16 7.125 16 16V416z"],
    "dice-six": [448, 512, [62758], "2685", "M128 128C110.4 128 96 142.4 96 160s14.38 32 32 32s32-14.38 32-32S145.6 128 128 128zM128 224C110.4 224 96 238.4 96 256s14.38 32 32 32s32-14.38 32-32S145.6 224 128 224zM128 320c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S145.6 320 128 320zM384 32H64C28.63 32 0 60.63 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.63 419.4 32 384 32zM400 416c0 8.875-7.125 16-16 16H64c-8.875 0-16-7.125-16-16V96c0-8.875 7.125-16 16-16h320c8.875 0 16 7.125 16 16V416zM320 128c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S337.6 128 320 128zM320 320c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S337.6 320 320 320zM320 224c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S337.6 224 320 224z"],
    "dice-three": [448, 512, [62759], "2682", "M128 128C110.4 128 96 142.4 96 160s14.38 32 32 32s32-14.38 32-32S145.6 128 128 128zM224 224C206.4 224 192 238.4 192 256s14.38 32 32 32s32-14.38 32-32S241.6 224 224 224zM384 32H64C28.63 32 0 60.63 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.63 419.4 32 384 32zM400 416c0 8.875-7.125 16-16 16H64c-8.875 0-16-7.125-16-16V96c0-8.875 7.125-16 16-16h320c8.875 0 16 7.125 16 16V416zM320 320c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S337.6 320 320 320z"],
    "dice-two": [448, 512, [62760], "2681", "M128 128C110.4 128 96 142.4 96 160s14.38 32 32 32s32-14.38 32-32S145.6 128 128 128zM384 32H64C28.63 32 0 60.63 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.63 419.4 32 384 32zM400 416c0 8.875-7.125 16-16 16H64c-8.875 0-16-7.125-16-16V96c0-8.875 7.125-16 16-16h320c8.875 0 16 7.125 16 16V416zM320 320c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S337.6 320 320 320z"],
    "diploma": [640, 512, ["scroll-ribbon"], "f5ea", "M539.3 144h-66.1C477.5 134.2 480 123.4 480 112C480 68.15 444.3 32 400.5 32C367.7 32 345.5 47.09 320 78.95C294.5 47.09 272.3 32 239.5 32C195.7 32 160 68.15 160 112c0 11.4 2.506 22.19 6.844 32H96c-53.02 0-96 48.47-96 128S42.98 416 96 416l160-34.29v82.26c0 2.98 .9551 5.52 2.266 7.805c.3672 .6445 .7793 1.156 1.227 1.734c1.244 1.613 2.709 2.926 4.438 3.953c.5078 .3008 .9023 .6758 1.438 .9219C267.5 479.4 269.7 480 272.1 480c.2383 0 .4766-.1016 .7148-.1172c.3438-.0156 .6523-.1172 .9961-.1562c2.688-.2969 5.381-1.121 7.826-2.957L320 447.1l38.4 28.78c2.445 1.836 5.139 2.66 7.826 2.957c.3438 .0391 .6523 .1406 .9961 .1562C367.5 479.9 367.7 480 367.9 480c2.35 0 4.592-.6406 6.693-1.613c.5371-.2461 .9355-.6211 1.443-.9258c1.73-1.031 3.195-2.336 4.439-3.953c.4453-.5781 .8535-1.086 1.219-1.727C383 469.5 384 466.1 384 463.1v-81.96L539.3 416C594.9 416 640 351.5 640 272C640 192.5 594.9 144 539.3 144zM400.5 80.47C417.9 80.47 432 94.59 432 112s-14.11 31.53-31.53 31.53H332.6C373.2 83.07 384.8 80.47 400.5 80.47zM239.5 80.47c15.69 0 27.27 2.6 67.86 63.06H239.5C222.1 143.5 208 129.4 208 112S222.1 80.47 239.5 80.47zM245.9 334.8l-153.4 32.86C73.29 363.7 48 327.3 48 272C48 224.9 67.74 192 96 192h144.6L240.3 191.5H256v141.1L245.9 334.8zM543 367.7L384 332.9V191.5h15.65L399.4 192h139.8C570.8 192 592 224.1 592 272C592 324.2 566.9 363.8 543 367.7z"],
    "disc-drive": [512, 512, [], "f8b5", "M256 112C176.5 112 112 176.5 112 256s64.5 144 144 144s144-64.5 144-144S335.5 112 256 112zM256 288C238.4 288 224 273.6 224 256s14.38-32 32-32c17.62 0 32 14.38 32 32S273.6 288 256 288zM488 432H480V96c0-35.35-28.65-64-64-64H96C60.65 32 32 60.65 32 96v336H23.1C10.75 432 0 442.7 0 455.1S10.75 480 23.1 480H488c13.25 0 24-10.75 24-23.1S501.3 432 488 432zM432 432h-352V96c0-8.875 7.125-16 16-16h320c8.875 0 16 7.125 16 16V432z"],
    "disease": [512, 512, [], "f7fa", "M459.6 179.6l-60.74-20.5c-9.748-3.25-16.87-9.875-18.1-17.62l-14.5-54c-6.874-25.5-27.62-45-55.74-52.5c-30.87-7.1-63.12 .25-84.24 21.62L183.6 99.25c-6.999 7.125-18.62 11-30.12 10.13l-65.11-5c-33.74-2.5-65.11 13.25-79.99 40.25c-12.87 23.38-10.87 50.25 5.374 72l34.87 46.88c4.624 6.125 5.374 13.12 1.1 19.62l-25.62 50.88c-11.87 23.38-9.249 49.88 6.874 70.88c19.25 24.88 52.99 36.37 86.11 29.37l63.37-13.75c11.37-2.375 23.87 0 32.37 6.375l49.24 36.37c15.12 11 33.24 16.88 51.87 16.75c12.87 0 25.5-2.75 37.24-8c25.37-11.62 41.74-33.75 43.74-59.38l4.249-55.25c.4999-7.375 5.999-14.38 14.62-18.75l56.24-28.38c27.25-13.75 42.89-39.65 40.89-67.52C509.7 213.1 489.7 189.8 459.6 179.6zM449.3 267.4l-56.24 28.38c-23.75 12-38.99 33.62-40.87 58l-4.249 55.12c-.8748 11.37-11.37 17.37-15.75 19.37c-10.25 4.75-26.1 6.5-40.74-3.5l-49.12-36.5c-14.75-10.87-33.24-16.62-51.99-16.62c-6.374 0-12.75 .625-18.1 2l-63.37 13.62c-16.1 3.75-31.5-3.25-37.99-11.75c-4.874-6.375-5.624-13-2.125-19.88l25.75-50.87c11.37-22.5 8.999-49.38-6.374-70L52.28 187.9C47.28 181.4 46.78 174.5 50.53 167.8c4.374-8 16.37-16.88 34.12-15.5l65.11 5c25.25 2 51.12-7.125 68.11-24.37l41.74-42.63c8.874-9 23.87-12.5 37.87-8.75c11.12 2.875 19.25 9.75 21.5 18.38l14.5 54c6.249 23.37 24.1 42.25 50.12 50.75l60.74 20.5c11.62 3.875 18.87 11.75 19.62 21C464.6 254.6 459.2 262.4 449.3 267.4zM159.1 192c-17.62 0-31.1 14.37-31.1 31.1S142.4 256 159.1 256s31.1-14.37 31.1-31.1S177.6 192 159.1 192zM287.1 288c-17.62 0-31.1 14.37-31.1 31.1s14.38 31.1 31.1 31.1s31.1-14.37 31.1-31.1S305.6 288 287.1 288zM303.1 192c-8.874 0-15.1 7.124-15.1 15.1s7.126 15.1 15.1 15.1s15.1-7.124 15.1-15.1S312.9 192 303.1 192z"],
    "display": [576, 512, [], "e163", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h148.3l-9.6 48H152C138.8 464 128 474.8 128 488S138.8 512 152 512h272c13.25 0 24-10.75 24-24s-10.75-24-24-24h-50.73L363.7 416H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM324.3 464H251.7L261.3 416h53.46L324.3 464zM528 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V64c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V352z"],
    "display-arrow-down": [576, 512, [], "e164", "M191 167c-9.375 9.375-9.375 24.56 0 33.94l80 80c9.375 9.375 24.56 9.375 33.94 0l80-80c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L312 206.1V24C312 10.75 301.3 0 288 0S264 10.75 264 24v182.1L224.1 167C220.3 162.3 214.2 160 208 160S195.7 162.3 191 167zM512 0h-160v48h160c8.822 0 16 7.178 16 16v288c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V64c0-8.822 7.178-16 16-16h160V0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h148.3l-9.6 48H152C138.8 464 128 474.8 128 488S138.8 512 152 512h272c13.25 0 24-10.75 24-24s-10.75-24-24-24h-50.73L363.7 416H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM251.7 464L261.3 416h53.46l9.6 48H251.7z"],
    "display-code": [576, 512, ["desktop-code"], "e165", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h148.3l-9.6 48H152C138.8 464 128 474.8 128 488S138.8 512 152 512h272c13.25 0 24-10.75 24-24s-10.75-24-24-24h-50.73L363.7 416H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM251.7 464L261.3 416h53.46l9.6 48H251.7zM528 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V64c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V352zM362.1 137.9c-7.812-7.812-20.47-7.812-28.28 0s-7.812 20.5 0 28.31l33.86 33.84l-33.86 33.84c-7.812 7.812-7.812 20.5 0 28.31C337.8 266.1 342.9 268 348 268s10.23-1.938 14.14-5.844l48-48c7.812-7.812 7.812-20.5 0-28.31L362.1 137.9zM242.1 137.9c-7.812-7.812-20.47-7.812-28.28 0l-48 48c-7.812 7.812-7.812 20.5 0 28.31l48 48C217.8 266.1 222.9 268 228 268S238.2 266.1 242.1 262.2c7.812-7.812 7.812-20.5 0-28.31L208.3 200L242.1 166.2C249.1 158.4 249.1 145.7 242.1 137.9z"],
    "display-medical": [576, 512, ["desktop-medical"], "e166", "M368 176H320V128c0-8.801-7.199-16-16-16h-32C263.2 112 256 119.2 256 128v48H208C199.2 176 192 183.2 192 191.1V224c0 8.797 7.199 15.1 16 15.1H256v48C256 296.8 263.2 304 272 304h32c8.801 0 16-7.2 16-16v-48h48C376.8 239.1 384 232.8 384 224V191.1C384 183.2 376.8 176 368 176zM512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h148.3l-9.6 48H152C138.8 464 128 474.8 128 488S138.8 512 152 512h272c13.25 0 24-10.75 24-24s-10.75-24-24-24h-50.73L363.7 416H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM251.7 464L261.3 416h53.46l9.6 48H251.7zM528 352c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V64c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V352z"],
    "display-slash": [640, 512, ["desktop-slash"], "e2fa", "M630.8 469.1l-70.69-55.41C587.6 406.5 608 381.7 608 352V64c0-35.35-28.65-64-64-64H96C79.54 0 64.69 6.334 53.41 16.55L38.81 5.113c-10.47-8.172-25.49-6.359-33.69 4.078C-3.051 19.63-1.234 34.72 9.188 42.89L601.2 506.9C605.6 510.3 610.8 512 615.1 512c7.125 0 14.17-3.159 18.9-9.19C643.1 492.4 641.2 477.3 630.8 469.1zM560 352c0 8.822-7.178 16-16 16h-42.19L94.04 48.4C94.71 48.31 95.3 48 96 48h448c8.822 0 16 7.178 16 16V352zM455.1 464h-50.73L395.7 416h12.31l-61.25-48H96c-8.822 0-16-7.178-16-16V158.9l-48-37.63L32 352c0 35.35 28.65 64 64 64h148.3l-9.6 48H183.1c-13.25 0-24 10.75-24 24s10.75 24 24 24h271.1c13.25 0 24-10.75 24-24S469.2 464 455.1 464zM283.7 464L293.3 416h53.46l9.6 48H283.7z"],
    "distribute-spacing-horizontal": [448, 512, [], "e365", "M272 96h-96C149.5 96 128 117.5 128 144v224C128 394.5 149.5 416 176 416h96c26.51 0 48-21.49 48-48v-224C320 117.5 298.5 96 272 96zM272 368h-96v-224h96V368zM424 0c-13.2 0-24 10.8-24 24v464c0 13.2 10.8 24 24 24S448 501.2 448 488V24C448 10.8 437.2 0 424 0zM24 0C10.8 0 0 10.8 0 24v464C0 501.2 10.8 512 24 512s24-10.8 24-24V24C48 10.8 37.2 0 24 0z"],
    "distribute-spacing-vertical": [512, 512, [], "e366", "M144 160C117.5 160 96 181.5 96 208v96C96 330.5 117.5 352 144 352h224c26.51 0 48-21.49 48-48v-96C416 181.5 394.5 160 368 160H144zM368 304h-224v-96h224V304zM488 432H24C10.8 432 0 442.8 0 456C0 469.2 10.8 480 24 480h464c13.2 0 24-10.8 24-24C512 442.8 501.2 432 488 432zM24 80h464C501.2 80 512 69.2 512 56C512 42.8 501.2 32 488 32H24C10.8 32 0 42.8 0 56C0 69.2 10.8 80 24 80z"],
    "ditto": [320, 512, [], "22", "M63.99 32C45.53 32 27.06 39.64 14.89 54.93C2.692 70.21-2.372 90.22 1.044 109.9l25.21 145.2C29.55 274.1 45.44 288 63.99 288S98.43 274.1 101.7 255l25.24-145.2c3.389-19.6-1.678-39.61-13.88-54.9C100.9 39.64 82.46 32 63.99 32zM63.1 191.8L48.33 101.6c-1.057-6.08 .4277-12.19 4.113-16.8C56.01 80.35 62.18 80 63.99 80s7.982 .3477 11.58 4.871C79.23 89.45 80.72 95.56 79.68 101.6L63.1 191.8zM305.1 54.93C292.9 39.64 274.5 32 255.1 32s-36.93 7.643-49.1 22.93c-12.2 15.29-17.27 35.3-13.85 54.93l25.21 145.2C221.6 274.1 237.4 288 255.1 288s34.44-13.89 37.74-32.99l25.24-145.2C322.4 90.22 317.3 70.21 305.1 54.93zM255.1 191.8l-15.67-90.19c-1.057-6.08 .4277-12.19 4.113-16.8C248 80.35 254.2 80 255.1 80s7.982 .3477 11.58 4.871c3.654 4.578 5.148 10.69 4.104 16.73L255.1 191.8z"],
    "divide": [448, 512, [10135, 62761], "f7", "M424 232H24C10.75 232 0 242.8 0 256s10.75 24 24 24h400C437.3 280 448 269.3 448 256S437.3 232 424 232zM224 144c26.51 0 48-21.49 48-48s-21.49-48-48-48s-48 21.49-48 48S197.5 144 224 144zM224 368c-26.51 0-48 21.49-48 48s21.49 48 48 48s48-21.49 48-48S250.5 368 224 368z"],
    "dna": [448, 512, [62577], "1f9ec", "M32.03 495.1C31.53 503 37.28 512 47.4 512h15.37c8.124 0 14.75-6.25 15.37-14.38C78.4 493.1 79.15 487.1 80.27 480h286.1c1.25 7.125 2.125 13.38 2.5 17.75C370.5 505.8 377.1 512 385.1 512h15.5c11.5 0 15.75-10.75 15.25-16.75c-2.125-29.5-16.25-126.9-108.5-208.9c-12.62 9.375-26.12 18.25-40.87 26.75c9.124 7.5 16.1 15.12 24.62 23H155.6c20.62-20.88 46.37-41.37 79.24-59.37C391.7 190.5 413.2 56 415.1 16.88C416.5 9 410.7 0 400.6 0H385.2c-8.124 0-14.75 6.25-15.37 14.38C369.6 18.88 368.9 24.88 367.7 32H80.65c-1.375-7.125-1.1-13.25-2.375-17.75C77.52 6.25 70.9 0 62.9 0H47.4c-10.12 0-15.87 9.125-15.37 16.88c2.625 35.75 21.25 153 147.9 238.9C53.28 341.4 34.65 458.9 32.03 495.1zM354.4 80c-5.624 15-13.62 31.25-24.12 48H118.3C107.8 111.2 99.77 95 94.02 80H354.4zM224 228.8C196.6 212.5 174.6 194.5 156.5 176h135.4C273.7 194.4 251.6 212.4 224 228.8zM93.4 432c5.749-14.88 13.5-31.25 24.12-48h211.7c10.5 16.75 18.5 33 24.37 48H93.4z"],
    "do-not-enter": [512, 512, [], "f5ec", "M376 208h-240C122.7 208 112 218.7 112 232v48c0 13.25 10.75 24 24 24h240c13.26 0 24-10.75 24-24v-48C400 218.7 389.3 208 376 208zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "dog": [576, 512, [63187], "1f415", "M416 96c-8.875 0-16 7.124-16 15.1s7.125 15.1 16 15.1s16-7.124 16-15.1S424.9 96 416 96zM536 64h-49.13l-.625-1c-10.66-17.05-35.83-31-55.93-31H360c-.5 0-1 .125-1.5 .125l-27.25-27.38C321.3-5.373 304 1.752 304 16v176H184c-31.38 0-59.63 12.38-81 32H90.98c-22.35 0-43.61-16.98-42.99-39.32C48.37 171.1 37.47 160 24 160c-13.25 0-24 10.75-24 24c.125 42.38 30.25 78.63 71.88 86.38C66.75 283.6 64.13 297.8 64 312V448c0 35.2 28.8 64 64 64h16c35.2 0 64-28.8 64-64v-64h128v64c0 35.2 28.8 64 64 64H416c35.2 0 64-28.8 64-64V240l8 .001c48.6 0 88-39.4 88-88v-48C576 81.91 558.1 64 536 64zM432 448c0 8.836-7.164 16-16 16h-16c-8.836 0-16-7.164-16-16v-112H160V448c0 8.836-7.164 16-16 16H128c-8.836 0-16-7.164-16-16V312c0-39.76 32.24-71.1 72-71.1H320l112 28.75V448zM528 152c0 22.12-17.88 40-40 40H432v27.25l-80-20V88c0-4.375 3.625-8 8-8h76.25c3 0 5.75 1.75 7.125 4.375l13.75 27.62H528V152z"],
    "dog-leashed": [576, 512, [63188], "1f9ae", "M536 64h-49.13l-.625-1c-10.66-17.05-35.83-31-55.93-31H360c-.5 0-1 .125-1.5 .125l-27.25-27.38C321.3-5.373 304 1.752 304 16v162.1L70.3 4.719c-10.61-7.875-25.66-5.656-33.58 4.969c-7.891 10.66-5.656 25.69 4.984 33.59l200.4 148.7H184c-31.38 0-59.63 12.38-81 32H90.98c-22.35 0-43.61-16.98-42.99-39.32C48.37 171.1 37.47 160 24 160c-13.25 0-24 10.75-24 24c.125 42.38 30.25 78.63 71.88 86.38C66.75 283.6 64.13 297.8 64 312V448c0 35.2 28.8 64 64 64h16C179.2 512 208 483.2 208 448v-64h128v64c0 35.2 28.8 64 64 64H416c35.2 0 64-28.8 64-64l.0001-207.1L488 240c48.6 0 88-39.4 88-88v-48C576 81.91 558.1 64 536 64zM280 336H160V448c0 8.836-7.164 16-16 16l-15.1 .0006C119.2 464 112 456.8 112 448V312c0-39.76 32.24-71.1 72-71.1h96V336zM432 448c0 8.836-7.164 16-15.1 16L400 464c-8.836 0-16-7.164-16-16v-112h-56V242.8l104 26V448zM528 152c0 22.12-17.88 40-40 40H432v27.25l-80-20V88c0-4.375 3.625-8 8-8h76.25c3 0 5.75 1.75 7.125 4.375l13.75 27.62H528V152zM416 95.98c-8.875 0-15.1 7.133-15.1 16.01s7.125 16 15.1 16S432 120.9 432 111.1S424.9 95.98 416 95.98z"],
    "dollar-sign": [320, 512, [128178, "dollar", "usd"], "24", "M302 357.8c-9.336 47.9-53.78 77.04-117.9 81.34V488c0 13.25-10.81 24-24.06 24s-23.94-10.75-23.94-24v-50.23c-3.416-.3652-6.512-.2383-10-.7227C99.06 433.4 70.16 424.2 44.66 416l-11.88-3.781c-12.62-3.984-19.66-17.45-15.69-30.11c4-12.62 17.31-19.72 30.12-15.67l12.06 3.844c23.62 7.562 50.38 16.14 73.31 19.22c55.44 7.688 114.8-1.938 122.3-40.86C261.9 312.1 235.8 300 154 279.2l-16.03-4.109C90.25 262.6 1.375 239.4 17.97 154.2c9.334-47.94 53.88-77.02 118.1-81.29V24c0-13.25 10.67-24 23.92-24s24.08 10.75 24.08 24v50.13c3.324 .3574 6.42 .3555 9.812 .8262c17.44 2.422 37.5 7.219 63.16 15.11c12.66 3.891 19.78 17.33 15.88 29.98c-3.875 12.67-17.25 19.8-30 15.89c-23.12-7.109-40.81-11.39-55.66-13.45C132 114.8 72.66 124.4 65.09 163.4C58.97 194.8 78.84 210 150.1 228.6l15.75 4.031C230.4 249.1 318.8 271.6 302 357.8z"],
    "dolly": [576, 512, ["dolly-box"], "f472", "M574.6 304c-4.391-12.5-18.11-19.06-30.59-14.69l-16.29 5.725l-70.73-188.6c-4.969-13.28-14.81-23.83-27.72-29.69c-12.89-5.875-27.34-6.391-40.58-1.375l-194.8 73.06L150.8 16.55C147.6 6.672 138.4 0 127.1 0H24C10.75 0 0 10.75 0 24S10.75 48 24 48h86.59l93.8 287.3C177.8 352.3 160 382 160 416c0 53.02 42.98 96 96 96s96-42.98 96-96c0-2.744-.584-5.326-.8105-8.012l208.8-73.35C572.5 330.2 579 316.5 574.6 304zM256 464c-26.47 0-48-21.53-48-48s21.53-48 48-48s48 21.53 48 48S282.5 464 256 464zM335.7 362.6C318.5 336.9 289.2 320 256 320c-2.023 0-3.917 .4727-5.909 .5957L208.8 194.1l89.75-33.65l26.98 71.96C329.1 242.1 338.3 248 348 248c2.797 0 5.656-.4844 8.422-1.531c12.42-4.656 18.7-18.48 14.05-30.89L343.5 143.6l62.1-23.28c2.203-.7969 5.641 .7187 6.484 2.953l70.4 187.7L335.7 362.6z"],
    "dolly-empty": [576, 512, [], "f473", "M574.6 304c-4.391-12.5-18.11-19.06-30.59-14.69l-208.3 73.2C318.5 336.9 289.2 320 256 320c-2.023 0-3.917 .4727-5.909 .5957L150.8 16.55C147.6 6.672 138.4 0 127.1 0H24C10.75 0 0 10.75 0 24S10.75 48 24 48h86.59l93.8 287.3C177.8 352.3 160 382 160 416c0 53.02 42.98 96 96 96s96-42.98 96-96c0-2.744-.584-5.326-.8105-8.012l208.8-73.35C572.5 330.2 579 316.5 574.6 304zM256 464c-26.47 0-48-21.53-48-48s21.53-48 48-48s48 21.53 48 48S282.5 464 256 464z"],
    "dolphin": [512, 512, [], "e168", "M434.1 138.8L429.4 134.8c9.318-19.63 23.7-42.8 42.81-68.99c10.8-14.93 10.46-33.99-.8613-48.59C462.7 6.119 450.2 0 435.1 0c-2.523 0-5.094 .1973-7.699 .6016c-41.18 6.473-80.86 18.58-118 36.01C278.4 14.77 249.2 1.166 206.1 .3203c-85.27 1.752-157.3 60.3-171.6 139.2C30.16 163 31.19 186.7 37.46 210.1l-12.67 8.445C4.256 232.2-4.727 257.2 2.438 280.7c7.197 23.84 28.17 39.26 53.42 39.26h336.1c13.24 0 24.01-10.77 24.01-24c0-13.23-10.77-24-24.01-24H55.85c-4.912 0-6.768-2.783-7.459-5.117C47.78 264.9 47.37 261.2 51.42 258.5C95.79 228.9 88.16 234 95.31 229.3C85.27 203.5 75.53 181.9 81.67 148.1c10.03-55.26 63.49-98.16 124.4-99.79c28.89 .666 45.37 4.709 99.84 44.16c36.65-18.77 68.93-33.29 118.6-42.54c-40.29 57.64-48.2 87.63-52.41 98.97c51.64 44.19 91.88 71.78 91.88 147.1c0 71.84-60.29 103.1-120 103.1h-50.98l-28.8-44.41c-9.254-12.42-23.91-19.58-39.51-19.58H163.9c-13.96 0-26.4 7.514-32.45 19.61c-5.746 11.49-4.494 25.03 3.268 35.33l24.78 33.06l-24.76 33.02c-7.756 10.38-8.986 23.94-3.215 35.4C137.6 504.5 149.1 512 163.9 512h60.74c15.84 0 30.36-7.303 39.84-20.04L292.1 448h50.96C441.3 448 512 384.1 512 296C512 204.2 459.4 160 434.1 138.8zM225.1 464.6l-35.72-.4121L219.5 424l-29.98-39.1h35.15c.2969 .0527 .6064 .0596 .7451 .0596c.0977 0-.0352 .0254 0 0L251.3 424L225.1 464.6zM135.9 160c0 13.26 10.75 24 24.01 24S183.9 173.3 183.9 160s-10.75-24-24.01-24S135.9 146.7 135.9 160z"],
    "dong-sign": [448, 512, [], "e169", "M224 400c30.42 0 58.01-11.1 80-28.89V376c0 13.25 10.75 24 24 24S352 389.3 352 376V112h8C373.3 112 384 101.3 384 88S373.3 64 360 64H352V56C352 42.75 341.3 32 328 32S304 42.75 304 56V64h-56C234.8 64 224 74.75 224 88s10.75 24 24 24h56v60.89C282 155.1 254.4 144 224 144c-70.58 0-128 57.41-128 128S153.4 400 224 400zM224 192c44.11 0 80 35.88 80 80S268.1 352 224 352S144 316.1 144 272S179.9 192 224 192zM392 432H56C42.75 432 32 442.8 32 456S42.75 480 56 480h336c13.25 0 24-10.75 24-24S405.3 432 392 432z"],
    "door-closed": [576, 512, [62762], "1f6aa", "M368 224c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32S385.6 224 368 224zM552 464H480V64c0-35.2-28.8-64-64-64H160C124.8 0 96 28.8 96 64v400H24C10.75 464 0 474.7 0 488C0 501.3 10.75 512 24 512h528c13.25 0 24-10.75 24-24C576 474.7 565.3 464 552 464zM432 464h-288V64c0-8.838 7.164-16 16-16h256c8.836 0 16 7.162 16 16V464z"],
    "door-open": [576, 512, [], "f52b", "M224 288c13.25 0 24-14.37 24-31.1S237.3 224 224 224S200 238.4 200 256S210.8 288 224 288zM288 0C285.5 0 282.9 .382 280.3 1.007l-192 49.75C73.1 54.51 64 67.76 64 82.88V464H24C10.75 464 0 474.7 0 488C0 501.3 10.75 512 24 512H288c17.67 0 32-14.33 32-32V33.13C320 14.38 305.3 0 288 0zM272 464h-160V94.13l160-41.38V464zM552 464H512V128c0-35.35-28.65-64-64-64l-96 .0061V112h96c8.836 0 16 7.162 16 16v352c0 17.67 14.33 32 32 32h56c13.25 0 24-10.75 24-24C576 474.7 565.3 464 552 464z"],
    "dove": [512, 512, [62650], "1f54a", "M368 160.3c0 8.751 7.25 16 16 16s16.01-7.427 16.01-16.18c0-8.876-7.259-16.01-16.01-16.01C375.1 144.1 368 151.4 368 160.3zM383.1 63.98c-46.25 0-84.73 32.81-93.86 76.44c-29-36.63-49.01-79.75-56.26-126.5C231.7 .6552 215.1-5.145 206.1 5.481c-25.12 29.63-44.35 65.17-55.1 105.2C149.4 116.4 148.6 122.3 147.6 128.2c-25.38-24.38-46.4-53.53-60.65-86.4c-5.5-12.5-23.34-13.04-29.21-.6633C41.64 75.22 32.57 113.1 31.94 153.1c-1.25 96.13 54.81 163.2 95.93 199.4l-114.1 38.5c-12.13 3.25-17.63 18.25-10.75 29.25c19.75 32.38 68.84 87.02 174.7 91.64c13.5 .625 17.66-4.632 25.29-9.383l76.38-54.13h40.63c88.38 0 159.1-71.77 159.1-160.3l-.002-128.2l32-95.95L383.1 63.98zM197.4 123c2.625-9.751 5.875-19.13 9.625-28.25c15.88 38.5 39.88 73.01 69.25 102.5c-30.12-6.876-58.5-18.25-84-34.13C192.6 149.4 194 135.9 197.4 123zM432 152.2v136.1c0 61.76-50.25 111.6-112 111.6h-55.88l-89.38 63.76c-52.38-3.375-86-21.38-107-40.25l154-52.01c-55.88-46.5-143.1-110.3-141.8-217.6c.125-9.001 .75-17 1.875-25.75c92.75 121.1 238.1 128 254.1 128V160.3c0-26.63 21.5-48.13 48-48.13h61.38L432 152.2z"],
    "down": [384, 512, ["arrow-alt-down"], "f354", "M381.6 259.8C376.6 247.8 364.9 240 352 240h-80v-160C272 53.49 250.5 32 224 32H160C133.5 32 112 53.49 112 80v160H32c-12.94 0-24.61 7.797-29.56 19.75C-2.516 271.7 .2188 285.5 9.375 294.6l160 176C175.6 476.9 183.8 480 192 480s16.38-3.125 22.62-9.375l160-176C383.8 285.5 386.5 271.7 381.6 259.8zM192 425.4L70.63 288H160V80h64V288h89.37L192 425.4z"],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", "M314.9 240H272v-64c0-26.51-21.49-47.95-48-47.95H160c-26.51 0-48 21.44-48 47.95v64H68.71c-41.63 0-63.52 49.37-35.58 80.23l136.2 150.4C175.6 476.9 183.8 480 192 480s16.38-3.125 22.62-9.375l135.9-150.4C378.4 289.3 356.5 240 314.9 240zM192 425.4L70.63 288H160V176h64V288h89.37L192 425.4zM360 32H24C10.75 32 0 42.75 0 56S10.75 80 24 80h336C373.3 80 384 69.25 384 56S373.3 32 360 32z"],
    "down-left": [384, 512, [], "e16a", "M290.7 112l45.28 45.25L179.3 313.9L249.4 384H63.1V198.6l70.06 70.05L290.7 112C290.7 111.1 290.7 112 290.7 112zM290.7 64c-12.28 0-24.57 4.684-33.94 14.06L134.1 200.8L70.62 137.4C64.5 131.2 56.33 127.1 48.01 127.1c-4.131 0-8.295 .8086-12.26 2.48C23.8 135.4 15.1 147.1 15.1 160l.0002 240C15.1 417.7 30.33 432 47.1 432h240c12.94 0 24.61-7.781 29.56-19.75s2.219-25.72-6.938-34.88L247.2 313.9l122.7-122.8c18.74-18.74 18.75-49.14 0-67.88l-45.25-45.25C315.3 68.68 303 64 290.7 64z"],
    "down-left-and-up-right-to-center": [512, 512, ["compress-alt"], "f422", "M488.1 23.03c-9.375-9.375-24.56-9.375-33.94 0l-81.38 81.38l-47.03-47.03c-6.127-6.117-14.3-9.35-22.63-9.35c-4.117 0-8.275 .7918-12.24 2.413c-11.97 4.953-19.75 16.63-19.75 29.56v135.1c0 13.25 10.74 23.1 24 23.1h136c12.94 0 24.63-7.797 29.56-19.75c4.969-11.97 2.219-25.72-6.938-34.87l-47.04-47.03l81.38-81.38C498.3 47.59 498.3 32.41 488.1 23.03zM215.1 272h-136c-12.94 0-24.63 7.797-29.56 19.75C45.47 303.7 48.22 317.5 57.37 326.6l47.04 47.03l-81.38 81.38c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0l81.38-81.38l47.03 47.03c6.127 6.117 14.29 9.367 22.63 9.367c4.117 0 8.279-.8086 12.25-2.43c11.97-4.953 19.75-16.63 19.75-29.56V296C239.1 282.7 229.3 272 215.1 272z"],
    "down-long": [320, 512, ["long-arrow-alt-down"], "f309", "M34 366.3c3.811-8.758 12.45-14.42 21.1-14.42h80V24c0-13.25 10.75-24 23.1-24s24 10.75 24 24v327.9h79.1c9.547 0 18.19 5.66 22 14.42c3.811 8.754 2.076 18.95-4.408 25.94l-104 112.1c-9.5 10.23-25.69 10.23-35.19 0l-104-112.1C31.92 385.3 30.19 375.1 34 366.3z"],
    "down-right": [384, 512, [], "e16b", "M93.23 112l156.7 156.7l70.06-70.05V384h-185.4l70.06-70.05l-156.7-156.7L93.23 112C93.24 111.1 93.23 112 93.23 112zM93.25 64C80.97 64 68.69 68.68 59.31 78.06L14.06 123.3c-18.75 18.75-18.74 49.14 0 67.88L136.8 313.9l-63.43 63.43c-9.156 9.156-11.89 22.91-6.938 34.88C71.39 424.2 83.06 432 96 432h240c17.67 0 31.1-14.31 31.1-31.1L368 160c0-12.94-7.797-24.62-19.75-29.56c-3.967-1.672-8.133-2.48-12.26-2.48c-8.313 0-16.48 3.281-22.61 9.418l-63.43 63.43L127.2 78.06C117.8 68.68 105.5 64 93.25 64z"],
    "down-to-line": [384, 512, ["arrow-alt-to-bottom"], "f34a", "M169.8 374.6C176 380.9 184.2 384 192.4 384s16.38-3.125 22.62-9.375l135.9-150.4C378.8 193.3 356.9 144 315.3 144h-42.91v-64c0-26.51-21.49-48-48-48h-64c-26.51 0-48 21.49-48 48v64H69.09c-41.63 0-63.52 49.37-35.58 80.23L169.8 374.6zM160.4 192V80h64V192h89.37l-121.4 137.4L71.01 192H160.4zM360 432H24C10.75 432 0 442.8 0 456S10.75 480 24 480h336c13.25 0 24-10.75 24-24S373.3 432 360 432z"],
    "download": [512, 512, [], "f019", "M448 304h-53.5l-48 48H448c8.822 0 16 7.178 16 16V448c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16v-80C48 359.2 55.18 352 64 352h101.5l-48-48H64c-35.35 0-64 28.65-64 64V448c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64v-80C512 332.7 483.3 304 448 304zM432 408c0-13.26-10.75-24-24-24S384 394.7 384 408c0 13.25 10.75 24 24 24S432 421.3 432 408zM239 368.1C243.7 373.7 249.8 376 256 376s12.28-2.344 16.97-7.031l136-136c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L280 294.1V24C280 10.75 269.3 0 256 0S232 10.75 232 24v270.1L136.1 199c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L239 368.1z"],
    "dragon": [640, 512, [63189], "1f409", "M568.8 265.6l-78.07-45.94c-6.609-3.312-10.72-10-10.72-17.5L479.1 192h10.66l17.89 16.47C518.5 218.5 531.8 224 545.1 224h28.09c19.92 0 38.51-11.56 47.57-29.94l12.8-27.47c8.905-18.03 6.984-39.22-5.031-55.38l-67.65-90.25C551.7 7.844 535.9 0 519.5 0h-215.2c-12.67 0-23.98 7.562-28.82 19.25C270.6 30.97 273.3 44.34 284 54.94L308.9 75.25L290.1 83.06C279.6 88.44 273 99.13 273 110.1c0 11.81 6.546 22.5 19.44 28.94l43.59 16.62v48.66L200.3 106.8C176.5 90.88 145 92.75 123.3 111.2l-117.5 116.4C-6.561 238 2.437 258 18.43 255.8L192 224L100.8 292.6C90.67 302.8 97.8 320 112 320h240.2c8.688 21.67 20.39 42.05 35.52 59.97C219.6 391 80.49 421.8 31.48 432.7C13.23 436.7 0 453.1 0 471.9C0 494 17.98 512 40.07 512h464.3c72.24 0 131.7-54.06 135.4-123.1C642.5 337.3 614.7 289 568.8 265.6zM504.4 464H116.3c78.27-15.16 198.5-34.41 331.6-39l74.52-2.594l-62.04-41.38c-47.78-31.84-76.29-85.16-76.29-142.6V123.5l-34.61-13.16l51.81-21.53L351.3 48h168.2c1.547 0 3.14 .8125 4.015 1.969l67.46 90c1.156 1.531 1.328 3.594 .2187 5.844l-12.8 27.47C577.6 174.9 575.9 176 574.1 176h-28.09c-1.312 0-2.593-.5313-4.234-2.156L509.4 144h-77.33v58.19c0 25.81 14.3 48.97 35.82 59.66l78.69 46.31c29.73 14.91 47.1 44.88 45.34 78.19C589.6 429.2 550.4 464 504.4 464zM502.5 109.6c11.62 .625 21.37-7.25 24.12-18.25L480.8 80C476.6 97.13 489.5 109 502.5 109.6z"],
    "draw-circle": [512, 512, [], "f5ed", "M512 256c0-30.25-21.12-55.5-49.38-62.12c-20.87-69.13-75.38-123.6-144.5-144.5C311.5 21.12 286.2 0 256 0S200.5 21.12 193.9 49.38C124.8 70.25 70.25 124.8 49.38 193.9C21.12 200.5 0 225.8 0 256s21.12 55.5 49.38 62.13c20.87 69.12 75.38 123.6 144.5 144.5C200.5 490.9 225.8 512 256 512s55.5-21.12 62.13-49.38c69.12-20.87 123.6-75.38 144.5-144.5C490.9 311.5 512 286.2 512 256zM448 272c-8.875 0-16-7.125-16-16c0-8.875 7.125-16 16-16s16 7.125 16 16C464 264.9 456.9 272 448 272zM256 48c8.875 0 16 7.125 16 16S264.9 80 256 80C247.1 80 240 72.88 240 64S247.1 48 256 48zM64 240c8.875 0 16 7.125 16 16c0 8.875-7.125 16-16 16S48 264.9 48 256C48 247.1 55.12 240 64 240zM256 464c-8.875 0-16-7.125-16-16s7.125-16 16-16c8.875 0 16 7.125 16 16S264.9 464 256 464zM309.9 413.8C298.5 395.9 278.8 384 256 384s-42.5 11.88-53.88 29.75C153.2 397 115 358.8 98.25 309.9C116.1 298.5 128 278.8 128 256S116.1 213.5 98.25 202.1C115 153.2 153.2 115 202.1 98.25C213.5 116.1 233.2 128 256 128s42.5-11.88 53.88-29.75c48.88 16.75 87.13 55 103.9 103.9C395.9 213.5 384 233.2 384 256s11.88 42.5 29.75 53.88C397 358.8 358.8 397 309.9 413.8z"],
    "draw-polygon": [448, 512, [], "f5ee", "M384 352c-3.375 0-6.625 .5-9.75 1L339 294.2C347 283.6 352 270.4 352 256c0-14.38-5-27.62-13-38.25l35.25-58.75C377.4 159.5 380.6 160 384 160c35.38 0 64-28.62 64-64s-28.62-64-64-64c-26.88 0-49.75 16.5-59.25 40H123.2C113.8 48.5 90.88 32 64 32C28.62 32 0 60.62 0 96c0 26.88 16.5 49.75 40 59.25v201.5C16.5 366.2 0 389.1 0 416c0 35.38 28.62 64 64 64c26.88 0 49.75-16.5 59.25-40h201.5C334.2 463.5 357.1 480 384 480c35.38 0 64-28.62 64-64S419.4 352 384 352zM88 356.8V155.2C104 148.8 116.8 136 123.2 120h201.5c2.125 5.25 5 9.875 8.25 14.38L297.8 193C294.6 192.5 291.4 192 288 192c-35.38 0-64 28.62-64 64s28.62 64 64 64c3.375 0 6.625-.5 9.75-1l35.25 58.63c-3.25 4.5-6.125 9.25-8.25 14.38H123.2C116.8 376 104 363.2 88 356.8zM288 240c8.875 0 16 7.125 16 16c0 8.875-7.125 16-16 16S272 264.9 272 256C272 247.1 279.1 240 288 240zM384 80c8.875 0 16 7.125 16 16S392.9 112 384 112S368 104.9 368 96S375.1 80 384 80zM64 80c8.875 0 16 7.125 16 16S72.88 112 64 112S48 104.9 48 96S55.12 80 64 80zM64 432c-8.875 0-16-7.125-16-16s7.125-16 16-16s16 7.125 16 16S72.88 432 64 432zM384 432c-8.875 0-16-7.125-16-16s7.125-16 16-16s16 7.125 16 16S392.9 432 384 432z"],
    "draw-square": [448, 512, [], "f5ef", "M408 356.8V155.2C431.5 145.8 448 122.9 448 96c0-35.38-28.62-64-64-64c-26.88 0-49.75 16.5-59.25 40H123.2C113.8 48.5 90.88 32 64 32C28.62 32 0 60.62 0 96c0 26.88 16.5 49.75 40 59.25v201.5C16.5 366.2 0 389.1 0 416c0 35.38 28.62 64 64 64c26.88 0 49.75-16.5 59.25-40h201.5C334.2 463.5 357.1 480 384 480c35.38 0 64-28.62 64-64C448 389.1 431.5 366.2 408 356.8zM88 356.8V155.2C104 148.8 116.8 136 123.2 120h201.5C331.2 136 344 148.8 360 155.2v201.5C344 363.2 331.2 376 324.8 392H123.2C116.8 376 104 363.2 88 356.8zM384 80c8.875 0 16 7.125 16 16S392.9 112 384 112S368 104.9 368 96S375.1 80 384 80zM64 80c8.875 0 16 7.125 16 16S72.88 112 64 112S48 104.9 48 96S55.12 80 64 80zM64 432c-8.875 0-16-7.125-16-16s7.125-16 16-16s16 7.125 16 16S72.88 432 64 432zM384 432c-8.875 0-16-7.125-16-16s7.125-16 16-16s16 7.125 16 16S392.9 432 384 432z"],
    "dreidel": [448, 512, [], "f792", "M448 56C448 42.29 436.8 32 424 32c-6.141 0-12.28 2.344-16.97 7.031l-112.3 112.3l-77.52-77.63c-6.5-6.5-15.18-9.737-23.68-9.737c-8.625 0-17.15 3.237-23.65 9.737L19.62 223.1C6.999 236.5 0 253.5 0 271.3v141.9C0 450.1 29.87 480 66.87 480h141.9c17.62 0 34.63-7.002 47.26-19.63l150.2-150.1c6.5-6.562 9.813-15.13 9.813-23.69c0-8.564-3.313-17.13-9.813-23.69l-77.57-77.57l112.3-112.3C445.7 68.28 448 62.14 448 56zM222.1 426.5C218.5 430.1 213.8 432 208.8 432H66.88C56.5 432 48 423.5 48 413.1V271.3c0-5 1.1-9.75 5.5-13.25l53.25-53.25l168.5 168.5L222.1 426.5zM309.3 339.3l-168.5-168.5l52.63-52.63l168.6 168.5L309.3 339.3z"],
    "drone": [512, 512, [], "f85f", "M339.4 92.38c9.25-28.75 37.38-47.13 67.38-44c30 3.125 53.75 26.87 56.87 56.87s-15.25 58.13-44 67.38l-35.87 49.75C389.1 223.2 394.5 223.9 400 224C461.9 224 512 173.9 512 112S461.9 0 400 0S288 50.12 288 112c.125 5.5 .75 10.88 1.625 16.25L339.4 92.38zM111 368.2C93.62 368.8 79.88 383 80 400.4C80.12 417.8 94.25 431.9 111.6 432s31.62-13.62 32.13-31L211.6 352h88.75l67.87 49c.5001 17.38 14.75 31.12 32.13 31c17.38-.125 31.5-14.25 31.62-31.62c.125-17.38-13.62-31.62-31-32.13L352 300.4v-88.75l49-67.87C418.4 143.2 432.1 129 432 111.6S417.8 80.12 400.4 80c-17.38-.125-31.62 13.62-32.13 31L300.4 160H211.6L143.8 111C143.2 93.62 129 79.88 111.6 80S80.12 94.25 80 111.6s13.62 31.62 31 32.13L160 211.6v88.75L111 368.2zM208 208h96v96h-96V208zM400 288c-5.5 .125-10.88 .75-16.25 1.625l35.87 49.75c28.75 9.25 47.13 37.38 44 67.38s-26.87 53.75-56.87 56.87c-30 3.125-58.13-15.25-67.38-44l-49.75-35.87C288.8 389.1 288.1 394.5 288 400c0 61.88 50.13 112 112 112s112-50.13 112-112S461.9 288 400 288zM112 224c5.5-.125 10.88-.75 16.25-1.625L92.38 172.6C63.62 163.4 45.25 135.2 48.38 105.2c3.125-30 26.87-53.75 56.87-56.87c30-3.125 58.13 15.25 67.38 44l49.75 35.87C223.2 122.9 223.9 117.5 224 112C224 50.12 173.9 0 112 0S0 50.12 0 112S50.12 224 112 224zM172.6 419.6c-9.25 28.75-37.38 47.13-67.38 44c-30-3.125-53.75-26.87-56.87-56.87c-3.125-30 15.25-58.13 44-67.38L128.2 289.6C122.9 288.8 117.5 288.1 112 288C50.12 288 0 338.1 0 400S50.12 512 112 512S224 461.9 224 400c-.125-5.5-.75-10.88-1.625-16.25L172.6 419.6z"],
    "drone-front": [640, 512, ["drone-alt"], "f860", "M288 136.1c0-13.25-10.75-23.99-24-23.99L166.4 112.1C163.1 102.5 154.1 96.06 144 96.06S124.9 102.5 121.6 112.1L24 112.1c-13.25 0-24 10.73-24 23.98s10.75 24.01 24 24.01h240C277.2 160.1 288 149.3 288 136.1zM472 237.7l-96.88-28.99c-36-10.87-74.29-10.87-110.3 0L168 237.7V192h-48v63.1c0 17.75 14.38 31.99 32 31.99h45.42c-30.25 29.38-49.17 68.35-53.29 110.2c-.5 4.5 1 8.997 4 12.37C151.2 414 155.5 416 160.1 416h16.3C184.6 416 191.1 409.4 192 401.1c3.5-31.5 18.38-60.63 41.88-81.88L251 336.4C261 346.4 274.5 352 288.8 352h62.37c14.12 0 27.75-5.625 37.75-15.62l17.12-17.13c23.5 21.25 38.46 50.38 41.96 81.88C448.8 409.4 455.3 416 463.6 416h16.32c4.625 0 8.808-1.998 11.93-5.374c3-3.375 4.5-7.872 4-12.37c-4.125-41.87-23.12-80.85-53.25-110.2h45.38c17.75 0 31.1-14.24 31.1-31.99l-.0208-63.1h-48L472 237.7zM355 302.5C353.9 303.4 352.6 304 351.1 304H288.8c-1.5 0-2.875-.625-3.875-1.5l-38.25-38.38L278.5 254.6c27-8.125 55.88-8.125 82.75 0l32 9.5L355 302.5zM616.4 112.2l-97.79 .2495C515.5 102.7 506.2 96 496 96s-19.29 6.829-22.42 16.58l-98 .3754c-12.75 .25-23 10.74-23 23.62c.125 12.75 10.29 23.24 23.17 23.37l240.7-.7498c12.88-.25 23.12-10.82 23-23.69C639.5 122.8 629.3 112.3 616.4 112.2z"],
    "droplet": [384, 512, [61507, "tint"], "1f4a7", "M221.3 22.13C217.3 7.501 204.6 0 191.1 0C179.6 0 167.2 7.251 162.8 22.13C116 179.9 16 222.8 16 333.9c0 98.5 78.75 178.1 176 178.1s176-79.62 176-178.1C368 222.1 268.3 180.6 221.3 22.13zM192 464c-70.62 0-128-58.38-128-130.1C64 290.6 84.62 261 116 216.1C140.1 181.5 169 140.2 192 83.62c23.12 56.88 52 98.13 76.25 132.8C299.4 260.9 320 290.4 320 333.9C320 405.6 262.6 464 192 464zM208 400C163.9 400 128 364.1 128 320c0-8.875-7.125-16-16-16S96 311.1 96 320c0 61.75 50.25 111.1 112 111.1c8.875 0 16-7.125 16-16S216.9 400 208 400z"],
    "droplet-degree": [448, 512, ["dewpoint"], "f748", "M368 32c-44.06 0-79.1 35.94-79.1 80S323.9 192 368 192s79.1-35.94 79.1-80S412.1 32 368 32zM368 144c-17.64 0-31.1-14.36-31.1-32s14.36-32 31.1-32s31.1 14.36 31.1 32S385.6 144 368 144zM159.1 32C148.7 32 137.5 38.32 133.4 51.36c-42.5 137.9-133.4 175.5-133.4 272.8C.0003 410.2 71.56 480 159.1 480s159.1-69.78 159.1-155.9c0-97.78-90.73-134.1-133.4-272.8C182.9 38.6 171.5 32 159.1 32zM272 324.1C272 383.6 221.8 432 160 432s-112-48.39-112-107.9c0-33.94 15.76-57.27 45.97-98.93c20.85-28.76 45.5-62.75 66.02-108.4c20.61 45.93 45.33 79.92 66.23 108.7C256.3 266.8 272 289.1 272 324.1z"],
    "droplet-percent": [320, 512, ["humidity"], "f750", "M186.6 51.36c-3.631-12.77-15.08-19.36-26.57-19.36c-11.25 0-22.53 6.32-26.55 19.36C90.94 189.3 0 226.9 0 324.1c0 86.08 71.56 155.9 160 155.9s160-69.78 160-155.9C320 226.4 229.3 190 186.6 51.36zM160 432c-61.76 0-112-48.38-112-107.9c0-33.94 15.76-57.26 45.97-98.93c20.85-28.76 45.5-62.76 66.02-108.4c20.61 45.93 45.33 79.92 66.23 108.7C256.3 266.8 272 289.1 272 324.1C272 383.6 221.8 432 160 432zM120 304c13.31 0 24-10.69 24-24S133.3 256 120 256S96 266.7 96 280S106.7 304 120 304zM196.7 260.7l-96 95.1c-6.25 6.25-6.25 16.37 0 22.62C103.8 382.4 107.9 383.1 112 383.1s8.188-1.562 11.31-4.688l96-95.1c6.25-6.25 6.25-16.37 0-22.62C213.1 254.4 202.9 254.4 196.7 260.7zM200 336c-13.31 0-24 10.69-24 24S186.7 384 200 384S224 373.3 224 360S213.3 336 200 336z"],
    "droplet-slash": [640, 512, ["tint-slash"], "f5c7", "M630.8 469.1l-137.1-107.5c1.426-9.035 2.305-18.31 2.305-27.76c0-111.8-99.75-153.2-146.8-311.7C345.3 7.503 332.6 0 319.1 0c-12.38 0-24.74 7.253-29.24 22.13C274.3 77.58 251.3 118.7 228.4 153.7L38.81 5.11C34.41 1.672 29.19 .0002 24.03 .0002c-7.125 0-14.19 3.156-18.91 9.187c-8.188 10.44-6.375 25.53 4.062 33.7l591.1 463.1c10.5 8.203 25.56 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1zM266.3 183.4C284.6 155.7 303.8 123.6 320 83.63c23.12 56.88 52 98.13 76.25 132.8c29.03 41.51 48.7 70.11 51.24 109L266.3 183.4zM320 464c-70.63 0-128-58.38-128-130.1c0-26.34 7.729-47.64 20.8-70.4l-38.03-29.81C156.6 263.9 144 294.6 144 333.9C144 432.4 222.8 512 320 512c52.81 0 100-23.6 132.3-60.83l-38.12-29.87C390.8 447.4 357.4 464 320 464zM336 432c8.875 0 16-7.125 16-16s-7.125-16-16-16C291.9 400 256 364.1 256 320c0-8.875-7.125-16-16-16S224 311.1 224 320C224 381.8 274.3 432 336 432z"],
    "drum": [512, 512, [62825], "1f941", "M431.6 121.9l69.53-45.77c11.09-7.264 14.19-22.15 6.906-33.25c-7.219-11.06-22.09-14.22-33.22-6.924l-106.4 69.73c-48.5-8.5-94.94-9.669-112.4-9.669C213.2 96 0 101.4 0 207.1v159.1C0 429.9 114.6 480 255.1 480s256-50.15 256-112V207.1C511.1 164.6 476.5 138.1 431.6 121.9zM88 400.3C61.1 387.9 48 375.1 48 368V279.5c12.75 7.125 26.12 13 40 17.5V400.3zM232 431c-37.5-1.625-69.75-6.625-96-13.5V309.3c36 6.875 71.63 9.375 96 10.25V431zM376 417.5c-26.25 7-58.5 11.88-96 13.5V319.5c24.38-.875 60-3.375 96-10.25V417.5zM464 368c0 7.125-14 19.88-40 32.25V297c13.88-4.5 27.25-10.38 40-17.5V368zM256 272.1c-114.9 0-207.1-28.62-207.1-63.97c0-35.35 93.12-63.1 207.1-63.1c17.57 0 34.41 .7041 50.71 1.966L242.8 187.1c-11.09 7.266-14.19 22.15-6.906 33.25C240.5 228.3 248.2 232.1 256 232.1c4.5 0 9.062-1.267 13.12-3.923l109.3-71.67c51.69 11.64 85.5 30.44 85.5 51.67C463.1 243.5 370.9 272.1 256 272.1z"],
    "drum-steelpan": [576, 512, [], "f56a", "M288 32C129 32 0 89.25 0 160v192c0 70.75 129 128 288 128s288-57.25 288-128V160C576 89.25 447 32 288 32zM288 80c24.25 0 47.75 1.25 69.88 3.5l-11.5 44.62C341.9 145.8 315.6 160 288 160S234.1 145.8 229.6 128.1L218.1 83.5C240.2 81.25 263.8 80 288 80zM229.6 175.5C245.1 185.9 266.6 192 288 192c21 0 41.5-5.875 57.63-16c2.875 21.75 11.5 42 24.75 59C344.6 238.2 317 240 288 240c-29.38 0-57.25-1.875-83.25-5C217.9 217.6 226.8 197.4 229.6 175.5zM174.5 89.5l13 46.12C197.4 170.4 184.1 206.1 157.2 227C91.5 212.8 48 188.1 48 160C48 129.5 99.25 103 174.5 89.5zM528 352c0 27.5-93.5 80-240 80S48 379.5 48 352V230.8C99.62 265.2 187.8 288 288 288s188.4-22.75 240-57.25V352zM418.1 227.1C409.8 221 402.5 213.2 396.9 204.2c-11.75-18.87-15.5-41.13-10.38-62.75l12.12-52.5C475.5 102.4 528 129.1 528 160C528 188.1 484.3 212.9 418.1 227.1z"],
    "drumstick": [512, 512, [63190], "1f357", "M511.1 165.4c0-40.03-14.06-77.61-40.87-107.8c-48.4-54.99-110.1-57.63-128.3-57.63c-45.19 0-88.72 17.86-120.9 49.71C195.4 76.13 160.2 119.3 160 189.2l.0506 88.67L119.5 318.3c-6.024 6.103-13.93 8.918-22.11 8.918c-13.76 0-18.3-7.244-37.06-7.244c-19.8 0-38.89 9.78-50.32 27.19c-6.721 10.11-9.99 21.63-9.99 33.09c0 22.44 16.85 59.58 59.13 59.58c4.923 0 9.876-.5726 14.72-1.683c-1.109 4.841-1.682 9.791-1.682 14.71c0 15.01 5.319 29.84 16.81 41.42c11.66 11.67 27.12 17.69 42.7 17.69c32.88 0 60.36-26.58 60.36-60.3c0-19.02-7.243-23.02-7.243-37.02c0-8.157 2.815-16.04 8.917-22.14l40.48-40.58l88.82-.0508c38.76 0 72.77-10.12 104-31.12C480.8 284.9 511.1 226.2 511.1 165.4zM464.6 164.2c0 61.18-52.3 139.7-141.6 139.7H239.1c-17.67 0-32-14.33-32-32V189.7c0-40.99 14.25-72.61 47.76-105.1c25.52-25.35 55.8-35.86 85.07-35.86C395.6 47.84 464.6 89.74 464.6 164.2z"],
    "drumstick-bite": [512, 512, [], "f6d7", "M471.2 57.62c-48.3-54.88-109.9-57.62-128.2-57.62c-45.18 0-88.83 17.86-121 49.71C195.4 76.1 160.3 119.2 160 188.9l.0603 88.93L119.5 318.3c-6.104 6.103-13.98 8.914-22.14 8.914c-13.75 0-18.21-7.219-36.96-7.219c-33.29 0-60.39 26.97-60.39 60.34c0 22.31 16.74 59.5 59.13 59.5c4.925 0 9.876-.5709 14.72-1.681c-1.12 4.851-1.695 9.806-1.695 14.75c0 14.94 5.265 29.8 16.82 41.26C100.6 505.9 116.1 512 131.7 512c32.95 0 60.37-26.61 60.37-60.33c0-19.32-7.244-22.92-7.244-37.03c0-8.163 2.817-16.07 8.921-22.17l40.59-40.49l88.65-.0636c17.13 0 34.25-2.375 50.76-7c7.906-2.081 17.72-9.92 17.72-23.04c0-14.05-15.03-22.75-15.03-56.05c0-31.12 22.64-81.6 81.04-81.6c17.38 0 23.13 4.202 30.54 4.202c17.55 0 23.1-15.73 23.1-23.85C511.1 117.4 492.1 81.09 471.2 57.62zM457 136.3c-34.1 0-66.8 13.42-91.04 37.54c-24.69 24.68-37.5 57.93-37.5 91.9c0 9.712 1.047 19.48 3.161 29.13l-7.018 9.068H246.1c-24.66 0-39.03-14.4-39.03-32V189.7c0-40.99 14.25-72.61 47.76-105.1c25.52-25.35 55.82-35.86 85.11-35.86c36.99 0 72.36 16.77 94.41 41.61c12 13.37 20.5 29.5 25 46.87C459.2 136.3 458.1 136.3 457 136.3z"],
    "dryer": [448, 512, [], "f861", "M368 0h-288C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V80C448 35.82 412.2 0 368 0zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V80c0-17.64 14.36-32 32-32h288c17.64 0 32 14.36 32 32V448zM128.1 104c0-13.25-10.83-24-24.02-24c-13.31 0-24.02 10.75-24.02 24S90.72 128 104 128C117.2 128 128.1 117.3 128.1 104zM184.1 128c13.19 0 23.89-10.75 23.89-24S197.2 80 184.1 80c-13.31 0-24.02 10.75-24.02 24S170.7 128 184.1 128zM224 160C148.8 160 87.98 220.9 87.98 296S148.8 432 224 432s136-60.88 136-136S299.2 160 224 160zM224 384c-40.16 0-73.74-27.18-84.27-64H176c13.25 0 24-10.75 24-24S189.3 272 176 272H139.7C150.3 235.2 183.8 208 224 208c48.53 0 88.02 39.48 88.02 88S272.5 384 224 384z"],
    "dryer-heat": [448, 512, ["dryer-alt"], "f862", "M368 0h-288C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V80C448 35.82 412.2 0 368 0zM400 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V80c0-17.64 14.36-32 32-32h288c17.64 0 32 14.36 32 32V448zM128.1 104c0-13.25-10.83-24-24.02-24c-13.31 0-24.02 10.75-24.02 24S90.72 128 104 128C117.2 128 128.1 117.3 128.1 104zM184.1 128c13.19 0 23.89-10.75 23.89-24S197.2 80 184.1 80c-13.31 0-24.02 10.75-24.02 24S170.7 128 184.1 128zM224 160C148.8 160 87.98 220.9 87.98 296S148.8 432 224 432s136-60.88 136-136S299.2 160 224 160zM219.3 371.3C216.2 374.4 212.1 376 208 376s-8.172-1.562-11.3-4.688l-6.703-6.688c-20.03-20.03-24.97-50.47-12.31-75.78C184.2 275.9 181.6 260.3 171.4 250L164.7 243.3C158.4 237.1 158.4 226.1 164.7 220.7c6.25-6.25 16.38-6.25 22.62 0l6.703 6.688c20.03 20.03 24.97 50.47 12.31 75.78C199.8 316.1 202.4 331.8 212.6 342l6.688 6.688C225.6 354.9 225.6 365 219.3 371.3zM283.3 371.3C280.2 374.4 276.1 376 272 376s-8.172-1.562-11.3-4.688l-6.703-6.688c-20.03-20.03-24.97-50.47-12.31-75.78C248.2 275.9 245.6 260.3 235.4 250l-6.688-6.688c-6.266-6.219-6.266-16.34-.0313-22.62c6.25-6.25 16.38-6.25 22.62 0l6.703 6.688c20.03 20.03 24.97 50.47 12.31 75.78c-6.484 12.97-3.953 28.59 6.297 38.84l6.688 6.688C289.6 354.9 289.6 365 283.3 371.3z"],
    "duck": [640, 512, [63192], "1f986", "M496 240C557.9 240 608 189.9 608 128h-65.62c-.375-3.375-.5-6.625-1.25-10c-9.25-40.5-41.1-73.63-82.62-83C449.5 33 440.6 32 432 32c-61.87 0-111.1 50.13-111.1 112L319.1 232H260.2c-24.11 0-61.15-10.66-74.64-24.84c-10.97-11.62-27.61-15.31-42.37-9.375C128.4 203.6 118.9 217.6 118.9 233.3C118.9 323.7 192.7 400 279.9 400c13.25 0 23.1-10.75 23.1-24S293.1 352 279.9 352C225.6 352 178.7 309.2 168.9 254.7C195.3 271.2 232.6 280 260.2 280h83.8c13.25 0 23.1-10.75 23.1-24l.043-112c0-35.25 28.75-64 63.1-64c5.25 0 10.5 .625 15.75 1.875c22.75 5.125 41.37 24 46.5 46.75c7.875 35-11.87 61.88-34.87 72.88l-27.37 13L431.1 294.9c22.68 16.17 34.49 42.11 31.55 69.41C459.4 401.6 425.4 432 387.6 432H258.4c-93.18 0-171.6-71.53-178.5-162.8c-.1-13.22-12.45-22.56-25.75-22.12C40.91 248 31 259.6 32 272.8C40.78 388.1 140.2 480 258.4 480h129.3c62.5 0 116.8-48.5 123.6-110.5c3.853-35.71-7.74-69.77-31.22-95.54V240H496zM448 144c0-8.875-7.122-15.1-15.1-15.1S416 135.1 416 144S423.1 160 432 160S448 152.9 448 144z"],
    "dumbbell": [640, 512, [], "f44b", "M608 224V152C608 121.1 582.9 96 552 96h-32C517.3 96 514.6 96.38 512 96.75V88C512 57.07 486.9 32 456 32h-32c-30.93 0-56 25.07-56 56V224h-96V88C272 57.07 246.9 32 216 32h-32C153.1 32 128 57.07 128 88v8.75C125.4 96.38 122.8 96 120 96h-32C57.07 96 32 121.1 32 152V224C14.4 224 0 238.4 0 256s14.4 32 31.1 32L32 360C32 390.9 57.07 416 88 416h32c2.75 0 5.375-.375 8-.75V424C128 454.9 153.1 480 184 480h32c30.93 0 56-25.07 56-56V288h96v136c0 30.93 25.07 56 56 56h32c30.93 0 56-25.07 56-56v-8.75C514.6 415.6 517.3 416 520 416h32c30.93 0 56-25.07 56-56V288c17.6 0 32-14.4 32-32S625.6 224 608 224zM120 368h-32c-4.375 0-8-3.625-8-8v-208c0-4.375 3.625-8 8-8h32C124.4 144 128 147.6 128 152v208C128 364.4 124.4 368 120 368zM224 424c0 4.375-3.625 8-8 8h-32c-4.375 0-8-3.625-8-8V88c0-4.375 3.625-8 8-8h32C220.4 80 224 83.62 224 88V424zM464 424c0 4.375-3.625 8-8 8h-32c-4.375 0-8-3.625-8-8V88c0-4.375 3.625-8 8-8h32c4.375 0 8 3.625 8 8V424zM560 360c0 4.375-3.625 8-8 8h-32c-4.375 0-8-3.625-8-8v-208c0-4.375 3.625-8 8-8h32c4.375 0 8 3.625 8 8V360z"],
    "dumpster": [576, 512, [], "f793", "M560 160c10.38 0 17.1-9.75 15.5-19.88l-24-95.1C549.8 37 543.3 32 536 32h-98.88l25.62 128H560zM404.5 32H304v128h126.1L404.5 32zM552 224h-12L544 192H32l4 32H23.1C10.8 224 0 234.8 0 247.1S10.8 272 23.1 272h17.1L64 448v8C64 469.3 74.75 480 87.1 480S112 469.3 112 456V448h352v8C464 469.3 474.7 480 488 480c13.25 0 24-10.75 24-23.1V448l21.1-176H552C565.2 272 576 261.2 576 248C576 234.8 565.2 224 552 224zM469.6 400H106.4l-20-160h403.4L469.6 400zM16 160h97.25l25.63-128H40C32.75 32 26.25 37 24.5 44.12l-24 95.1C-2 150.2 5.625 160 16 160zM272 32H171.5L145.9 160H272V32z"],
    "dumpster-fire": [640, 512, [], "f794", "M418.8 104.2L404.6 32H304.1L304 159.1h60.77C381.1 140.7 399.1 121.8 418.8 104.2zM461.3 104.2c18.25 16.25 35.51 33.62 51.14 51.49c5.751-5.623 11.38-11.12 17.38-16.37l21.26-18.98l21.25 18.98c1.125 .9997 2.125 2.124 3.126 3.124c-.125-.7498 .2501-1.5 0-2.249l-24-95.97c-1.625-7.123-8.127-12.12-15.38-12.12H437.2l12.25 61.5L461.3 104.2zM272.1 32.12H171.5L145.9 160.1h126.1L272.1 32.12zM106.4 400L86.39 240.1h225.4c7.876-15.75 17.45-31.89 28.83-48.01L32.01 192.1l4.001 31.99L24 224.1C10.8 224.1 0 234.9 0 248.1s10.8 23.99 24 23.99h18l22 175.9l.0033 8C64.01 469.2 74.81 480 88.02 480s24-10.8 24-23.99v-7.998l224.8-.0025c-12.75-14.25-23.47-30.36-31.47-47.98H106.4zM16 160.1l97.26-.0223l25.64-127.9h-98.89c-7.251 0-13.75 4.999-15.5 12.12L.5001 140.2C-2 150.3 5.626 160.1 16 160.1zM551.2 163.3c-14.88 13.25-28.38 27.12-40.26 41.12c-19.5-25.74-43.63-51.99-71.01-76.36c-70.14 62.73-120 144.2-120 193.6C319.1 409.1 391.6 480 479.1 480s160-70.87 160-158.3C640.1 285 602.1 209.4 551.2 163.3zM480.1 432c-61.76 0-112-49.49-112-110.3c0-22.62 24.88-74.73 72.26-126.3c22.38 23.62 30.51 35.62 68.51 85.98c40.51-47.74 39.01-45.99 41.01-48.36c26.51 35.37 42.26 73.98 42.26 88.85C592.1 382.5 541.9 432 480.1 432z"],
    "dungeon": [512, 512, [], "f6d9", "M512 295.4c0-8.375-1.875-16.5-5.375-23.62c3.75-7.875 5.562-16.56 5.188-25.44c-1.25-35.13-9.813-69.13-25.06-101c-4.375-8.875-11-16.44-19-21.81c-1.5-9.625-5.375-18.69-11.5-26.44c-21.25-26.75-47.31-48.81-77.31-65.31c-8.25-4.5-17.31-6.875-26.56-6.875c-.5 0-.875 0-1.375 .125c-6.75-7.125-15.25-12.38-24.75-15C303.4 3.375 279.6 0 256 0C232.4 0 208.6 3.375 185.8 10c-9.5 2.625-18 7.875-24.75 15C160.5 24.88 160.1 24.88 159.6 24.88c-9.25 0-18.31 2.375-26.56 6.875C103.2 48.25 76.1 70.25 55.75 97.13C49.62 104.8 45.75 113.8 44.25 123.5c-8 5.375-14.62 12.94-18.1 21.81C9.1 177.2 1.5 211.1 .125 246.4c-.25 8.75 1.5 17.5 5.25 25.38C1.75 279.1 0 287.2 0 295.4v57.25C0 361 1.875 368.9 5.25 376C1.875 383.1 0 391 0 399.4v57.25C0 487.1 24.88 512 55.38 512h401.3C487.1 512 512 487.1 512 456.6v-57.25C512 391 510.1 383.1 506.8 376C510.1 368.9 512 361 512 352.6V295.4zM112 456.6C112 460.6 108.6 464 104.6 464H55.38C51.38 464 48 460.6 48 456.6v-57.25C48 395.4 51.38 392 55.38 392h49.25C108.6 392 112 395.4 112 399.4V456.6zM112 352.6C112 356.6 108.6 360 104.6 360H55.38C51.38 360 48 356.6 48 352.6V295.4C48 291.4 51.38 288 55.38 288h49.25C108.6 288 112 291.4 112 295.4V352.6zM133.2 204.1c-6 14-9.875 29-10.75 44.88C122.2 252.9 119.2 256 115.2 256H55.75C51.5 256 48 252.4 48.12 248.1c1.125-29.25 8.375-57 20.38-82C69.75 163.5 72.5 162 75.38 162c1.375 0 2.75 .375 4 1.125l51.12 32C133.6 197 134.6 200.9 133.2 204.1zM150.1 171c-1.25 0-2.625-.25-3.75-1l-51.13-32c-3.75-2.25-4.75-7.625-2-11c17.25-21.62 38.63-39.75 62.88-53.12c1.125-.625 2.375-1 3.5-1c3.125 0 6 1.875 7.25 4.875L189 134c1.25 3.375-.125 7-3.125 8.875C174.6 149.9 164.5 158.5 155.8 168.5C154.2 170.1 152.2 171 150.1 171zM208 456c0 4.375-3.625 8-8 8h-16c-4.375 0-8-3.625-8-8V203.1c8.125-12.25 19.25-22.37 32-29.75V456zM272 456c0 4.375-3.625 8-8 8h-16c-4.375 0-8-3.625-8-8V161.6C245.2 160.8 250.5 160 256 160s10.75 .75 16 1.625V456zM288.9 126.8c-.625 0-1.25-.125-1.875-.25C276 123.6 265.1 122.2 256 122.2c-10 0-20 1.5-30.88 4.25c-.7499 .125-1.375 .25-2 .25c-3 0-5.75-1.75-6.875-4.625l-22.12-56C192.6 62 194.8 57.25 199 56.12C217.1 50.88 236.2 48 256 48s38.88 2.875 57 8.125c4.25 1.125 6.375 5.875 4.875 10l-22.12 56C294.6 125 291.9 126.8 288.9 126.8zM336 456c0 4.375-3.625 8-8 8h-16c-4.375 0-8-3.625-8-8V173.4c12.75 7.5 23.88 17.5 32 29.75V456zM361.9 171c-2.125 0-4.125-.875-5.625-2.5c-8.75-10-18.87-18.62-30.12-25.62C323.1 141 321.8 137.4 323 134l22.12-56.25c1.25-3 4.125-4.875 7.25-4.875c1.125 0 2.375 .375 3.5 .875c24.25 13.37 45.63 31.5 62.88 53.12c2.75 3.5 1.75 8.75-2 11.12l-51.13 32C364.5 170.8 363.1 171 361.9 171zM389.5 249c-.875-15.88-4.75-30.88-10.75-44.88c-1.375-3.25-.375-7.125 2.75-9l51.13-32c1.25-.75 2.625-1.125 4-1.125c2.875 0 5.625 1.5 6.875 4.125c12 25 19.25 52.75 20.38 82C464 252.4 460.5 256 456.3 256h-59.5C392.8 256 389.8 252.9 389.5 249zM464 456.6c0 4-3.375 7.375-7.375 7.375h-49.25C403.4 464 400 460.6 400 456.6v-57.25c0-4 3.375-7.375 7.375-7.375h49.25c4 0 7.375 3.375 7.375 7.375V456.6zM464 352.6c0 4-3.375 7.375-7.375 7.375h-49.25c-4 0-7.375-3.375-7.375-7.375V295.4C400 291.4 403.4 288 407.4 288h49.25C460.6 288 464 291.4 464 295.4V352.6z"],
    "e": [320, 512, [101], "45", "M320 456c0 13.25-10.75 24-24 24h-272C10.75 480 0 469.3 0 456V56C0 42.75 10.75 32 24 32h272C309.3 32 320 42.75 320 56S309.3 80 296 80H48v152h184c13.25 0 24 10.76 24 24.01C256 269.3 245.3 280 232 280H48v152h248C309.3 432 320 442.8 320 456z"],
    "ear": [384, 512, [62960], "1f442", "M192 0C86 0 0 86 0 192v176C0 447.5 64.5 512 144 512s144-64.5 144-144v-9.875C345.4 324.9 384 263 384 192C384 86 298 0 192 0zM263.9 316.6L240 330.5V368c0 52.94-43.06 96-96 96s-96-43.06-96-96V192c0-79.4 64.6-144 144-144s144 64.6 144 144C336 243.1 308.4 290.8 263.9 316.6zM200 80h-16C126.7 80 80 126.7 80 184v47.97c0 9.9 5.934 18.65 15.12 22.28l28.98 11.58c3.857 1.547 4.746 4.91 4.949 6.283c.2031 1.367 .3242 4.826-2.916 7.418L89 309.2c-10.32 8.285-12 23.42-3.756 33.74C89.81 348.6 96.88 352 104.2 352c5.35 0 10.47-1.818 14.81-5.262l37.15-29.71c15.73-12.59 23.36-32 20.4-51.92C173.6 245.2 160.6 228.8 141.9 221.3L128 215.7V184C128 153.1 153.1 128 184 128h16C230.9 128 256 153.1 256 184c0 13.23 10.77 24 24 24s24-10.77 24-24C304 126.7 257.3 80 200 80zM104.2 344c-.4102 0-.7539-.2422-1.158-.2734c1.154 .0898 2.32 .0625 3.502-.1191C105.7 343.7 104.9 344 104.2 344z"],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", "M240 63.1C142.1 63.1 64 145.3 64 245.1c0 13.25 10.75 24 24 24s24-10.75 24-24C112 171.7 169.4 112 240 112s128 59.72 128 133.1c0 46.97-17.52 91.19-49.31 124.5l-5.625 5.906l-.8594 8.125C307.4 429.5 270.4 464 226.2 464c-13.25 0-24 10.75-24 24s10.75 24 24 24c66.11 0 121.8-48.91 132.6-115.1C395.8 355.4 416 301.8 416 245.1C416 145.3 337 63.1 240 63.1zM168 320c-6.141 0-12.28 2.344-16.97 7.031l-144 144C2.344 475.7 0 481.9 0 488C0 501.7 11.21 512 24 512c6.141 0 12.28-2.344 16.97-7.031l144-144C189.7 356.3 192 350.1 192 344C192 330.3 180.8 320 168 320zM512 24C512 10.29 500.8 0 488 0c-6.141 0-12.28 2.344-16.97 7.031l-64 64C402.3 75.72 400 81.86 400 88c0 13.71 11.21 24 24 24c6.141 0 12.28-2.344 16.97-7.031l64-64C509.7 36.28 512 30.14 512 24zM240 200c22.06 0 40 17.94 40 40c0 13.25 10.75 24 24 24s24-10.75 24-24c0-48.53-39.47-88-88-88S152 191.5 152 240c0 13.25 10.75 24 24 24S200 253.3 200 240C200 217.9 217.9 200 240 200z"],
    "ear-listen": [512, 512, ["assistive-listening-systems"], "f2a2", "M80.97 367c-9.375-9.377-24.56-9.377-33.94 0c-9.375 9.375-9.375 24.56 0 33.94l64 64C115.7 469.7 121.9 471.1 128 471.1s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L80.97 367zM386.7 2.516c-11.86-5.875-26.28-1.125-32.2 10.75c-5.922 11.84-1.125 26.25 10.73 32.19c.8438 .4062 84.67 43.56 98.92 157.5c1.516 12.16 11.86 21.03 23.78 21.03c1 0 2-.0625 3.016-.1875c13.14-1.656 22.47-13.62 20.83-26.78C494.4 57.86 391.1 4.703 386.7 2.516zM24 463.1c-13.25 0-24 10.74-24 24S10.75 512 24 512s24-10.75 24-24S37.25 463.1 24 463.1zM168 319.1c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S192 357.2 192 343.1C192 330.7 181.3 319.1 168 319.1zM240 63.1c-97.05 0-176 81.24-176 181.1c0 13.25 10.75 24 24 24s24-10.75 24-24c0-73.41 57.42-133.1 128-133.1s128 59.72 128 133.1c0 46.97-17.52 91.19-49.31 124.5l-5.625 5.906l-.8594 8.125c-4.844 45.78-41.83 80.31-86.02 80.31c-13.25 0-24 10.75-24 24c0 13.25 10.75 24 24 24c66.11 0 121.8-48.91 132.6-115.1C395.8 355.4 416 301.8 416 245.1C416 145.2 337 63.1 240 63.1zM240 200c22.06 0 40 17.94 40 40c0 13.25 10.75 24 24 24s24-10.75 24-24c0-48.53-39.47-88-88-88S152 191.5 152 240c0 13.25 10.75 24 24 24S200 253.3 200 240C200 217.9 217.9 200 240 200z"],
    "ear-muffs": [640, 512, [], "f795", "M638.5 335.1c-.0313-.1562-.0781-.3125-.1094-.4687c-2.938-11.41-9.33-21.47-18.27-29.1c-1.156-11.57-5.969-22.6-13.96-31.35c-8.143-9.158-19.1-15.57-31.33-18.54c-6.812-10-16.83-17.79-29-22.22c-5.766-2.07-11.77-3.047-17.8-3.336V208.1C528.1 93.33 434.7 0 320 0C205.3 0 112 93.33 112 208.1v22.01C105.9 230.3 99.83 231.3 93.98 233.4C81.92 237.8 71.95 245.6 65.13 255.6c-12.22 2.938-23.14 9.283-31.15 18.29C25.88 282.8 21 293.9 19.83 305.5c-8.939 7.658-15.36 17.85-18.38 29.57c-2.656 11.25-1.609 22.91 2.705 33.32c-4.283 10.66-5.143 22.47-2.174 33.79c3.049 11.31 9.408 21.29 18.14 28.82c1.297 11.47 6.221 22.47 14.58 31.85c8.422 8.971 19.31 15.13 31.19 17.91c6.783 9.971 16.57 17.63 27.4 21.32c11.24 4.908 25.99 5.908 39.79 2.189C142.2 509.3 152.6 512 163.4 512c33.44 0 60.65-25.76 60.65-57.39c0-7.439-1.641-14.79-4.734-21.66c3.094-6.877 4.734-14.25 4.734-21.69c0-7.564-1.531-14.91-4.438-21.69c2.906-6.781 4.438-14.1 4.438-21.6s-1.531-14.82-4.438-21.57c2.906-6.783 4.438-14.1 4.438-21.6c0-7.596-1.594-14.94-4.688-21.79C222.4 296.2 224 288.9 224 281.3c0-31.63-27.21-57.39-60.65-57.39c-1.141 0-2.225 .3848-3.359 .4492V208.1c0-88.24 71.79-160 160-160s160 71.8 160 160V224.4c-1.162-.0664-2.271-.459-3.439-.459c-33.44 0-60.65 25.76-60.65 57.39c0 7.533 1.594 14.85 4.688 21.69c-3.094 6.844-4.688 14.19-4.688 21.79c0 7.502 1.531 14.82 4.438 21.6c-2.906 6.752-4.438 14.07-4.438 21.57s1.531 14.82 4.438 21.6c-2.906 6.783-4.438 14.13-4.438 21.69c0 7.439 1.641 14.82 4.734 21.69c-3.094 6.877-4.734 14.22-4.734 21.66c0 31.63 27.21 57.39 60.65 57.39c10.8 0 21.16-2.689 30.3-7.752c13.75 3.688 29.71 2.25 37.99-1.5c12.05-4.158 22.22-11.97 29.14-22.01c11.92-2.814 22.93-9.096 31.69-18.41c8.049-9.066 12.88-19.94 14.13-31.35c8.736-7.564 15.1-17.57 18.18-29.01c2.938-11.19 2.062-22.94-2.203-33.6C640.2 357.9 641.2 346.3 638.5 335.1zM176 281.3c0 1.875-1.471 3.781-2.705 5.064C164.4 295.7 164.4 310.4 173.4 319.7c1.766 1.844 2.658 3.562 2.658 5.125c0 1.846-.6895 3.439-2.08 4.908c-8.953 9.283-8.984 23.97-.0469 33.29c1.908 1.969 2.121 3.8 2.121 4.988s-.2129 2.983-2.121 4.952c-8.938 9.316-8.906 24.01 .0469 33.29c1.422 1.471 2.08 3.064 2.08 5.033c0 1.844-1.455 3.721-2.658 5.002c-8.955 9.283-8.986 23.97-.0469 33.29c1.688 1.75 2.705 3.656 2.705 5.064c0 5.094-5.783 9.377-12.64 9.377c-4.922 0-8.203-2.189-10.08-4.033c-4.609-4.562-10.69-6.908-16.83-6.908c-4.109 0-8.252 1.062-12 3.221c-4.986 2.844-10.03 2.531-13.72 1.094c-3.689-1.281-5.643-3.846-6.236-5.846c-3.109-10.41-11.97-16.66-23.69-17.13c-4.299-.0625-8.393-1.531-10.69-3.938c-1.953-2.221-2.688-4.596-2.141-7.096c2.375-11.07-3.314-22.29-13.64-26.95c-3.031-1.344-5.203-3.812-5.953-6.564c-.6719-2.594 .8125-4.812 1.766-5.906c7.971-9.189 7.814-22.88-.3594-31.88c-1.094-1.219-2.266-3.221-1.719-5.533c.9531-3.719 4.219-5.658 6.078-6.471c10.58-4.719 16.29-16.29 13.6-27.54c-.375-1.594-.3906-3.939 1.922-6.502c2.375-2.656 6.531-4.252 11.14-4.252c10.52 0 19.8-6.844 22.93-16.88C104.6 282.1 107 279.8 110.3 278.6c5.627-1.971 10.85 .2813 13.44 1.781c9.658 5.783 21.96 4 29.66-4.096c1.533-1.625 4.846-4.312 9.955-4.312C170.2 271.9 176 276.2 176 281.3zM589.9 383.9c.9531 1.094 2.438 3.312 1.812 5.719c-.7969 2.939-2.969 5.408-6.002 6.752c-10.33 4.658-16.02 15.88-13.64 26.95c.5469 2.5-.1875 4.875-1.672 6.594c-2.734 2.908-6.658 4.439-11.16 4.439c-12.14-.125-20.58 6.721-23.69 17.13c-.5938 2-2.549 4.564-8.018 6.533c-.0938 .0625-6.971 1.062-11.94-1.781c-9.33-5.377-21.13-3.877-28.85 3.688c-1.875 1.844-5.125 4.033-10.06 4.033c-6.859 0-12.64-4.283-12.64-9.377c0-1.408 1.016-3.314 2.703-5.064c8.939-9.314 8.908-24.01-.0469-33.29c-1.203-1.281-2.656-3.158-2.656-5.002c0-1.969 .6562-3.562 2.078-5.033c8.955-9.283 8.986-23.97 .0469-33.29c-1.906-1.969-2.119-3.765-2.119-4.953s.2129-3.018 2.119-4.987c8.939-9.314 8.908-24.01-.0469-33.29c-1.391-1.469-2.078-3.062-2.078-4.908c0-1.562 .8906-3.281 2.656-5.125c8.955-9.283 8.986-23.97 .0469-33.29c-1.234-1.283-2.703-3.189-2.703-5.064c0-5.096 5.783-9.377 12.64-9.377c5.111 0 8.424 2.688 9.955 4.312c7.689 8.096 20 9.879 29.66 4.096c2.609-1.5 7.861-3.752 13.3-1.844c3.406 1.25 5.861 3.562 6.721 6.344c3.109 10.07 12.41 16.91 22.93 16.91c4.609 0 8.768 1.596 11.35 4.502c2.109 2.312 2.094 4.658 1.719 6.252c-2.688 11.25 3.016 22.82 13.6 27.54c1.828 .8125 4.986 2.689 6.018 6.252c.5313 2.625-.5938 4.564-1.656 5.752C582 361.1 581.9 374.7 589.9 383.9z"],
    "earth-africa": [576, 512, [62844, "globe-africa"], "1f30d", "M289.2 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S430.6 0 289.2 0zM289.2 464c-114.7 0-208-93.31-208-208s93.31-208 208-208c10.91 0 21.54 1.098 31.1 2.723v29.78C321.2 89 314.3 96 305.7 96H281.5c-5.086 0-9.93 2.625-12.84 6.875L260.6 115C258.5 118.3 255.2 120.5 251.5 121.5L236.9 125c-6.902 1.75-11.75 8-11.75 15.12V144.5C225.2 153 232.2 160 240.7 160h90.09c4.117 0 8.113 1.625 11.02 4.5l6.902 7C351.6 174.4 355.5 176 359.6 176h10.17c8.477 0 15.5 6.875 15.5 15.5c0 6.625-4.359 12.62-10.66 14.75L327.3 222c-3.875 1.25-8.113 1-11.75-.875l-14.77-7.375C293.3 210 284.8 208 276.3 208H275.5c-11.87 0-23.37 3.875-32.82 10.88L215.2 239.6c-13.8 10.25-21.92 26.5-21.92 43.63v14.12c0 14.5 5.812 28.38 15.98 38.63C219.5 346.3 233.4 352 247.8 352h25.91c8.598 0 15.5 7 15.5 15.5v29.88c0 12.25 2.906 24.38 8.355 35.25c3.305 6.641 9.047 11.36 15.76 13.69c8.902-1.125 17.59-2.895 26.06-5.199c2.109-1.73 4.477-3.152 6.012-5.488l13.08-19.5c7.145-10.75 15.5-20.5 24.95-29.12c2.543-2.375 4.238-5.375 4.844-8.625l4.238-22.88c.4844-2.25 1.453-4.5 2.906-6.375l18.65-25c2.059-2.625 3.148-5.875 3.148-9.25V303.5C417.3 295 410.4 288 401.8 288h-8.234c-5.207 0-10.05-2.625-12.84-6.875l-13.32-19.88c-5.57-8.5-1.695-20.12 7.992-23.25l2.664-.875c4.602-1.625 9.566-.875 13.56 1.75l18.16 12.12c4.602 3.125 10.54 3.5 15.5 1l15.5-7.75c5.207-2.625 8.477-8 8.477-13.88V223.5c0-8.5 7.023-15.5 15.5-15.5h26.7c3.666 15.44 5.812 31.46 5.812 48C497.2 370.7 403.9 464 289.2 464z"],
    "earth-americas": [576, 512, [62845, "earth", "globe-americas"], "1f30e", "M289.2 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S430.6 0 289.2 0zM81.23 256c0-32.52 7.713-63.19 21.07-90.63c1.127 2.451 1.955 5.033 3.479 7.291c11.72 17.39 28.38 42.07 35.67 52.77c5.166 7.611 11.23 14.58 18.06 20.74L160.3 246.9c9.533 8.629 20.18 15.94 31.65 21.75c14 7.051 34.44 18.16 48.81 26.11c10.18 5.633 16.49 16.36 16.46 28v32c-.002 8.486 3.369 16.63 9.369 22.63c15 15 24.32 38.63 22.63 51.25v13.07c.002 11.6 9.404 21 21 20.1c.832 0 1.662-.0488 2.488-.1484c.5234-.0625 1.041-.1426 1.562-.209C306.1 463.3 297.7 464 289.2 464C174.5 464 81.23 370.7 81.23 256zM318.4 461.7c8.17-1.441 14.76-7.523 16.72-15.62l14.11-41.63c2-5.49 3.26-11.21 4.77-16.87c1.1-4.057 3.248-7.75 6.23-10.71c3.32-3.33 7.41-7.398 11.31-11.28c8.789-8.73 13.73-20.61 13.72-33C385.3 324.5 382.1 316.7 376.3 311l-13.71-13.64C356.6 291.4 348.5 287.1 339.1 288H273.2c-9.41-4.711-21.48-32-32-32C230.7 256 220.3 253.5 210.9 248.8L199.8 243.3c-5.889-3.037-8.201-10.27-5.164-16.16c1.41-2.736 3.818-4.824 6.725-5.836l31.17-10.39C237.9 209.1 243.9 210.3 248.1 214l9.279 8.061c1.449 1.275 3.309 1.986 5.24 2h5.641C272.7 224.1 276.3 220.5 276.3 216.1C276.3 214.8 276 213.6 275.4 212.5L259.9 181.3C258.3 178.2 258.9 174.4 261.4 172l9.92-9.65C272.8 160.9 274.8 160 276.9 160h9c2.123 .002 4.16-.8398 5.66-2.34l8-8c3.123-3.125 3.123-8.188 0-11.31l-4.689-4.689c-3.121-3.125-3.121-8.188 0-11.31l15.02-15.03c6.25-6.248 6.248-16.38 .002-22.63c-.002 0 .002 .002 0 0L285.5 60.29c-2.516-2.52-5.994-3.836-9.549-3.609C273.4 56.85 270.9 57.06 268.4 57.33c-6.332 .6406-11.15 5.967-11.16 12.33c.084 7.266-4.639 13.71-11.59 15.83c-3.855 1.105-7.984 .7227-11.57-1.07c-5.861-2.934-11.25-6.721-16-11.24L208.7 64.25C233.5 53.79 260.7 48 289.2 48c82.61 0 153.9 48.53 187.5 118.5c-7.537 1.236-14.92 3.277-21.77 6.699c-3.734 1.867-6.92 4.676-9.24 8.15l-19.59 29.38c-5.371 8.061-5.371 18.56 0 26.62l18 27c2.584 3.889 6.248 6.939 10.54 8.779l20.52 10.1l18.61 9.771C477.9 380.6 407.1 449.2 318.4 461.7z"],
    "earth-asia": [576, 512, [62846, "globe-asia"], "1f30f", "M444.5 322.5L432.6 310.6c-1.453-1.5-2.301-3.5-2.301-5.625V292c0-2.25-1.816-4-3.996-4h-6.055c-1.816 0-3.391 1.25-3.875 2.875l-4.238 14.5c-.4844 1.75-2.059 2.875-3.754 2.875h-3.875c-1.574 0-3.027-1-3.633-2.5L395.6 293C394.2 290 391.3 288 388.2 288h-12.11c-1.695 0-3.27 .5-4.723 1.5l-23.61 16.88c-1.816 1.25-3.633 2.25-5.691 3l-39.23 15.75c-3.148 1.25-5.086 4.25-5.086 7.5v10.12c0 2.125 .8477 4.25 2.301 5.75L312 360.4c2.906 3 7.023 4.625 11.26 4.625h10.29c1.332 0 2.664-.125 3.996-.375l21.19-5.375c9.203-2.25 18.77 .375 25.43 7l13.08 13C400.2 382.3 404.3 384 408.5 384h15.14c4.238 0 8.355-1.75 11.38-4.75l5.5-5.461c2.615-3.352 5.252-6.695 7.646-10.22c.5684-1.676 1.021-3.402 1.021-5.195v-24.5C449.2 329.6 447.5 325.5 444.5 322.5zM289.2 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S430.6 0 289.2 0zM289.2 464c-103.8 0-189.8-76.48-205.3-176h70.62c4.238 0 8.355-1.75 11.38-4.75L185.3 263.9C189.2 260 195.8 261 198.2 265.9l22.64 45.25C223.5 316.6 229.1 320 235.1 320h6.176c8.84 0 15.98-7.125 15.98-16V294.6c0-4.25-1.695-8.25-4.723-11.25L246.9 277.6c-3.027-3.125-3.027-8.125 0-11.25l5.691-5.625C255.6 257.8 259.6 256 263.8 256H264.2c5.57 0 10.78-3 13.68-7.75l17.44-29c1.816-3 6.176-2.75 7.75 .375C304.4 222.3 307.2 224 310.2 224h3.027c4.48 0 7.992-3.625 7.992-8V137.9c0-6-3.391-11.62-8.84-14.25l-10.78-5.5c-5.57-2.75-5.934-10.38-.8477-13.75l29.86-22.93c7.887-6.059 12.51-15.43 12.51-25.38V55.33C431.7 79.16 497.2 159.1 497.2 256C497.2 370.7 403.9 464 289.2 464z"],
    "earth-europa": [576, 512, ["globe-europe"], "f7a2", "M207.1 112.4c-2.906 0-5.812 1.25-7.992 3.375L174.7 141.1c-2.18 2.125-3.391 5-3.391 8c0 6.125 5.135 11.25 11.43 11.25h15.94c3.027 0 5.934-1.125 7.992-3.25l9.445-9.375c2.059-2.125 3.27-5 3.27-8v-16C219.4 117.5 214.3 112.4 207.1 112.4zM289.2 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S430.6 0 289.2 0zM454.8 352c-4.127-.4375-8.096-1.965-11.02-4.875l-17.32-17.38c-5.934-6-14.05-9.375-22.64-9.375h-18.29l-43.11-37.13c-8.234-7-18.77-10.88-29.67-10.88H281.6c-8.234 0-16.35 2.375-23.49 6.5L215.3 304.6c-13.68 8.125-22.04 23-22.04 39v23.88c0 14.25 6.66 27.75 18.16 36.38l22.16 16.75c8.719 6.5 24.58 11.75 35.36 11.75h20.22c8.527 0 15.47 6.777 15.95 15.11c.0977-.0078-.0977 .0039 0 0l.1436 15.71C299.9 463.6 294.6 464 289.2 464c-114.7 0-208-93.31-208-208s93.31-208 208-208c2.902 0 5.725 .3164 8.598 .4355L260.3 77.98c-2.059 1.5-3.27 3.871-3.27 6.367v19.97c0 4.367 3.633 7.988 7.992 7.988h15.98c4.48 0 7.992-3.621 7.992-7.988V96.33l16.11-15.98h20.71c6.176 0 11.26 5.117 11.26 11.36c0 2.992-1.211 5.867-3.27 7.984l-26.88 26.71c-1.211 1.25-2.664 2.125-4.359 2.75L262.6 142.4C259.2 143.5 257.1 146.6 257.1 150c0 6.613-2.543 12.86-7.145 17.47L229.8 187.6c-3.027 2.992-4.723 6.988-4.723 11.23v25.21c0 8.859 7.145 15.98 15.98 15.98h22.16c6.055 0 11.5-3.371 14.29-8.738l9.324-18.72c1.453-2.621 4.238-4.367 7.266-4.367h3.027c4.48 0 7.992 3.617 7.992 7.988c0 4.367 3.633 7.988 7.992 7.988h16.11c4.359 0 7.992-3.621 7.992-7.988V214c0-3.496 2.18-6.492 5.449-7.617l31.61-10.48c6.539-2.246 10.9-8.359 10.9-15.23V176.2c0-8.738 7.266-15.98 15.98-15.98h36.69c6.176 0 11.38 5.117 11.38 11.36v9.359c0 6.117-5.207 11.23-11.38 11.23h-31.97c-3.027 0-5.934 1.25-7.992 3.367l-9.445 9.363c-2.059 2.121-3.27 4.992-3.27 7.988c0 6.117 5.086 11.23 11.26 11.23h15.98c3.027 0 5.934 1.25 8.113 3.367l9.324 9.363c2.18 2.121 3.27 4.992 3.27 7.988v8.613l-12.47 12.48c-4.602 4.617-4.602 12.11-.1211 16.73l32.09 32.58C455.5 318.4 459.6 320 464 320h23.05c-3.604 11.11-8.145 21.79-13.48 32H454.8z"],
    "eclipse": [640, 512, [], "f749", "M256 458l-51.88-76.1l-90.88 17.62l17.5-91.24L53.1 255.4l76.75-51.1l-17.5-91.12l91 17.5L256 53.03l31.75 46.87c11.12-11.5 23.62-21.88 37.13-30.75L289.6 16.78c-15.12-22.37-51.88-22.37-67 0L182.3 76.65L111.4 62.9C97.1 60.4 84.5 64.53 75 74.15C65.5 83.78 61.25 97.28 63.88 110.4l13.75 70.1l-59.88 40.5C6.625 229.5 0 242 0 255.5c0 13.5 6.75 25.1 17.75 33.5l59.88 40.5l-13.75 70.1c-2.625 13.25 1.594 26.96 11.09 36.46s22.91 13.54 36.28 10.91l70.88-13.62l40.38 59.87C229.1 505.3 242.5 512 255.9 512s26.08-6.75 33.58-17.75l34.75-51.62c-13.5-9-25.75-19.37-37-30.87L256 458zM229.6 206.9c4.25-19.12 11-37.25 19.88-54.25c-54.25 3.5-97.49 48.24-97.49 103.4c0 55.12 43.24 99.88 97.49 103.3c-8.875-16.88-15.62-34.1-19.88-54.25C212.1 295.5 200 277.3 200 255.9C200 234.6 212.1 216.4 229.6 206.9zM448 64.02c-106 0-191.1 86-191.1 191.1S341.1 448.1 448 448.1c105.1 0 192-86.05 192-192S553.1 64.02 448 64.02zM448 400c-79.38 0-143.1-64.63-143.1-143.1c0-79.37 64.62-143.1 143.1-143.1s144 64.62 144 143.1C592 335.4 527.4 400 448 400z"],
    "egg": [384, 512, [63483], "1f95a", "M192 0C85.1 0 0 214 0 320s85.1 192 192 192c105.1 0 192-86 192-192S297.1 0 192 0zM192 464c-79.38 0-144-64.63-144-144c0-117.4 90.63-272 144-272s144 154.6 144 272C336 399.4 271.4 464 192 464zM168 103.1c-7.299 0-14.11 3.262-18.7 8.949C113.1 156.8 76.34 238.6 76.34 304c0 13.23 10.77 24 24 24c13.24 0 24-10.77 24-24c0-52.42 31.7-122.1 62.35-160.9c8.303-10.29 6.688-25.43-3.596-33.75C178.8 105.9 173.5 103.1 168 103.1z"],
    "egg-fried": [512, 512, [], "f7fc", "M478.4 150.5c-39.5-40.75-100.8-46.38-144.5-82.25C290.2 32.24 255.6 0 200.5 0C192.1 0 183.7 .7387 175.3 2.114c-86.76 13.1-111.8 80.01-125 157.1c-11.13 64.38-54.38 127-50 192.9c4.375 65.88 52.88 128.5 115 150.8C132.9 509.3 149.2 512 164.2 512c64.76 0 109-51.12 155.8-95.49c43.63-41.5 93.38-37.75 140.9-74C517.2 299.8 532.6 201.1 478.4 150.5zM431.9 304.2c-16.13 12.38-33.63 18.75-53.88 26.13c-28.25 10.38-60.26 22-91.01 51.25c-5.501 5.125-11 10.5-16.5 15.88C233.7 433.1 201.1 464 164.2 464c-10.25 0-20.88-1.999-32.75-6.25c-44.38-16-80.26-62.75-83.26-108.8C46.19 320 58.44 287.6 71.44 253.2C81.69 226 92.44 197.9 97.57 167.5c13.88-80.12 35.38-109.9 85.38-118C188.7 48.62 194.6 48.12 200.5 48c32.38 0 54.38 17 93.51 49.5l9.376 7.875c25.5 21 54.13 33.12 79.38 43.75c25 10.63 46.5 19.75 61.13 34.75l.6251 .75l.75 .75c17.75 16.87 19.25 40.75 18.63 53.5C462.5 264.9 449.9 290.6 431.9 304.2zM223.1 128.1c-61.76 0-112 50.38-112 112.1c0 61.88 50.26 112.1 112 112.1s112-50.26 112-112.1C335.1 178.5 285.7 128.1 223.1 128.1zM223.1 200.1c-22.13 0-40 17.91-40 40.03c0 8.875-7.125 15.99-16 15.99c-8.876 0-16-7.113-16-15.99c0-39.75 32.25-71.89 72-72.01c8.876 0 16 7.238 16 15.99C239.1 192.1 232.9 200.1 223.1 200.1z"],
    "eggplant": [512, 512, [], "e16c", "M414.2 193.7c-21.8 42.21-44.23 81.8-68.53 119c-95.67 145.4-135.5 151.3-165.4 151.3c-149.1 0-175.8-186-62.07-233.3c19.83-7.764 92.45-40.21 203.7-130.8c-14.41-7.936-26.46-19.42-35.17-33.33C190.3 144.5 124.7 176.7 100.8 186.1C31.93 214.6 .0005 275.1 .0005 337.4c0 141.1 129.2 174.7 172.6 174.7c57.68 0 108.2-13.32 213.2-172.9c23.94-36.67 44.8-73.65 64.42-110.8C435.3 220.2 423 208.1 414.2 193.7zM512 24C512 10.29 500.8 0 488 0c-6.141 0-12.28 2.344-16.97 7.031l-14.04 14.04C449.3 17.81 440.9 16 432 16h-128c0 35.35 28.65 64 64 64c0 35.35 28.65 64 64 64c0 35.35 28.65 64 64 64v-128c0-8.871-1.812-17.31-5.074-24.99l14.04-14.04C509.7 36.28 512 30.14 512 24z"],
    "eject": [448, 512, [61522], "23cf", "M48.01 351.1h351.1c41.62 0 63.49-49.63 35.37-80.38l-175.1-192.1C249.9 69.16 236.9 64.01 224 64.01c-12.94 0-25.87 5.156-35.37 15.47L12.64 271.6C-15.48 302.2 6.393 351.1 48.01 351.1zM223.9 112C223.9 112 223.9 112 223.9 112L399.1 304L48.04 304L223.9 112zM424 400H24C10.75 400 0 410.7 0 424C0 437.3 10.75 448 24 448h400c13.26 0 24-10.75 24-24C448 410.7 437.3 400 424 400z"],
    "elephant": [640, 512, [63194], "1f418", "M528 128c-8.875 0-16 7.124-16 15.1c0 8.75 7.125 15.99 16 15.99S544 152.8 544 144C544 135.2 536.9 128 528 128zM512 32.05l-61.13-.0591c-3.625-3.75-7.5-7.375-11.75-10.75c-26-19.88-59.37-26.13-91.88-17.38c-18 4.875-33.87 14.88-46.37 28.13L192 32.06c-106 0-192 85.85-192 191.1v111.1c0 8.875 7.125 15.1 16 15.1L32 352v127.1C32 497.6 46.38 512 64 512h80c17.62 0 32-14.38 32-32V407.1c18.5 5.125 66.5 17 128 0v72.88C304 497.6 318.4 512 336 512H416c17.62 0 32-14.37 32-32V288l144-.0276v88c0 13.25-10.75 24-24 24S544 389.2 544 375.1v-7.929c0-8.875-7.125-16.07-16-16.07L512 351.1c-8.875 0-16 7.125-16 16v4.75c0 37.63 27.38 71.25 64.75 74.88C603.8 451.9 640 418.1 640 375.1v-215.1C640 89.28 582.8 32.05 512 32.05zM400 463.1L352 463.1v-119.9c-120.6 33.25-111.1 31.13-224 0v119.9H80V303.1h-32V223.1c0-79.63 64.5-144 144-144h83.25C269.1 106.9 272.8 134.1 286.8 157.4C298.2 176.6 315.8 191.5 336 199.1c0 40.13 27.12 73.75 64 84.25V463.1zM592 207.1c0 17.63-14.38 32-32 32h-136c-22 0-40-18-40-40V162.7c-22.62-4.625-41.88-6.375-56-30c-16.5-27.5-7.5-71.88 31.88-82.63c29.12-7.875 55.5 6.375 66.63 29.88H512c44.13 0 80 35.88 80 80V207.1z"],
    "elevator": [512, 512, [], "e16d", "M448 128H64c-35.35 0-64 28.65-64 63.1v255.1C0 483.3 28.65 512 64 512h384c35.35 0 64-28.65 64-63.1V192C512 156.7 483.3 128 448 128zM464 448c0 8.822-7.178 16-16 16h-16v-64c0-26.51-21.49-48-48-48h-64c-26.51 0-48 21.49-48 48v64h-32v-64C240 373.5 218.5 352 192 352H128c-26.51 0-48 21.49-48 48v64H64c-8.822 0-16-7.178-16-16V192c0-8.822 7.178-16 16-16h384c8.822 0 16 7.178 16 16V448zM160 224C133.5 224.1 112 245.5 112 272c0 26.46 21.47 47.9 48 48C186.5 319.9 208 298.5 208 272C208 245.5 186.5 224.1 160 224zM352 224C325.5 224.1 304 245.5 304 272c0 26.46 21.47 47.9 48 48C378.5 319.9 400 298.5 400 272C400 245.5 378.5 224.1 352 224zM79 96h130c5.967 0 11.37-3.402 13.75-8.662c2.385-5.262 1.299-11.39-2.754-15.59l-65-67.34c-5.684-5.881-16.31-5.881-21.99 0l-65 67.34C63.95 75.95 62.87 82.08 65.25 87.34C67.63 92.6 73.03 96 79 96zM357 91.59c5.686 5.881 16.31 5.881 21.99 0l65-67.34c4.053-4.199 5.137-10.32 2.754-15.59C444.4 3.402 438.1 0 433 0h-130c-5.967 0-11.37 3.402-13.75 8.662c-2.385 5.262-1.301 11.39 2.752 15.59L357 91.59z"],
    "ellipsis": [512, 512, ["ellipsis-h"], "f141", "M400 256c0 26.5 21.5 48 48 48s48-21.5 48-48S474.5 208 448 208S400 229.5 400 256zM112 256c0-26.5-21.5-48-48-48S16 229.5 16 256S37.5 304 64 304S112 282.5 112 256zM304 256c0-26.5-21.5-48-48-48S208 229.5 208 256S229.5 304 256 304S304 282.5 304 256z"],
    "ellipsis-stroke": [512, 512, ["ellipsis-h-alt"], "f39b", "M256 176C211.8 176 176 211.8 176 256s35.82 80 80 80c44.18 0 80-35.82 80-80S300.2 176 256 176zM256 288C238.4 288 224 273.6 224 256s14.36-32 32-32s32 14.36 32 32S273.6 288 256 288zM432 176C387.8 176 352 211.8 352 256s35.82 80 80 80c44.18 0 80-35.82 80-80S476.2 176 432 176zM432 288c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S449.6 288 432 288zM80 176C35.82 176 0 211.8 0 256s35.82 80 80 80C124.2 336 160 300.2 160 256S124.2 176 80 176zM80 288c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S97.64 288 80 288z"],
    "ellipsis-stroke-vertical": [192, 512, ["ellipsis-v-alt"], "f39c", "M176 256c0-44.18-35.82-80-80-80S16 211.8 16 256c0 44.18 35.82 80 80 80S176 300.2 176 256zM64 256c0-17.64 14.36-32 32-32s32 14.36 32 32s-14.36 32-32 32S64 273.6 64 256zM176 432c0-44.18-35.82-80-80-80s-80 35.82-80 80c0 44.18 35.82 80 80 80S176 476.2 176 432zM64 432c0-17.64 14.36-32 32-32s32 14.36 32 32s-14.36 32-32 32S64 449.6 64 432zM176 80C176 35.82 140.2 0 96 0S16 35.82 16 80C16 124.2 51.82 160 96 160S176 124.2 176 80zM64 80c0-17.64 14.36-32 32-32s32 14.36 32 32s-14.36 32-32 32S64 97.64 64 80z"],
    "ellipsis-vertical": [128, 512, ["ellipsis-v"], "f142", "M64 112c26.5 0 48-21.5 48-48S90.5 16 64 16S16 37.5 16 64S37.5 112 64 112zM64 400c-26.5 0-48 21.5-48 48s21.5 48 48 48s48-21.5 48-48S90.5 400 64 400zM64 208C37.5 208 16 229.5 16 256S37.5 304 64 304s48-21.5 48-48S90.5 208 64 208z"],
    "empty-set": [512, 512, [8709, 63062], "d8", "M504.1 7.031c-9.375-9.375-24.56-9.375-33.94 0l-74.59 74.59C358 50.63 309.2 32 256 32C132.3 32 32 132.3 32 256c0 53.21 18.63 102 49.62 140.4l-74.59 74.59c-9.375 9.375-9.375 24.56 0 33.94C11.72 509.7 17.84 512 24 512s12.28-2.344 16.97-7.031l74.59-74.59C153.1 461.4 202.8 480 256 480c123.7 0 224-100.3 224-224c0-53.21-18.63-102-49.62-140.4l74.59-74.59C514.3 31.59 514.3 16.41 504.1 7.031zM80 256c0-97.05 78.95-176 176-176c39.88 0 76.59 13.49 106.1 35.93l-246.2 246.2C93.49 332.6 80 295.9 80 256zM432 256c0 97.05-78.95 176-176 176c-39.88 0-76.59-13.49-106.1-35.93l246.2-246.2C418.5 179.4 432 216.1 432 256z"],
    "engine": [640, 512, [], "e16e", "M192 232C178.7 232 168 242.7 168 256c0 13.25 10.75 24 24 24S216 269.3 216 256C216 242.7 205.3 232 192 232zM592 192h-32C533.5 192 512 213.5 512 240V256h-16V207.1c0-4.855-2.207-9.459-6.001-12.49L418.7 138.5C410.2 131.7 415.7 128 404.8 128H312V112h64c13.25 0 24-10.75 24-24C400 74.74 389.3 64 376 64h-176C186.7 64 176 74.74 176 88c0 13.25 10.75 24 24 24h64V128H128C101.5 128 80 149.5 80 176v56h-32v-80C48 138.7 37.25 128 24 128S0 138.7 0 152v208C0 373.3 10.75 384 24 384s24-10.75 24-24v-80h32v56C80 362.5 101.5 384 128 384h41.38l49.95 49.95C228.3 442.9 240.5 448 253.3 448H448c26.51 0 48-21.49 48-48V384H512v16c0 26.51 21.49 48 48 48h32c26.51 0 48-21.49 48-48v-160C640 213.5 618.5 192 592 192zM448 400l-194.7 .0059L189.3 336H128v-160h260.8L448 223.4V400zM592 400h-32v-64h-64v-32h64v-64h32V400zM288 232C274.7 232 264 242.7 264 256c0 13.25 10.75 24 24 24S312 269.3 312 256C312 242.7 301.3 232 288 232zM360 256c0 13.25 10.75 24 24 24S408 269.3 408 256c0-13.26-10.75-24-24-24S360 242.7 360 256z"],
    "engine-warning": [640, 512, ["engine-exclamation"], "f5f2", "M288 384c-17.62 0-32 14.38-32 32c0 17.75 14.38 32 32 32s32-14.25 32-32C320 398.4 305.6 384 288 384zM287.1 352c13.25 0 24-10.75 24-24v-112c0-13.25-10.75-24-24-24s-24 10.75-24 24v112C263.1 341.3 274.7 352 287.1 352zM592 192h-32C533.5 192 512 213.5 512 240V256h-16V207.1c0-4.855-2.207-9.459-6.001-12.49L418.7 138.5C410.2 131.7 399.7 128 388.8 128H312V112h64c13.25 0 24-10.75 24-24C400 74.74 389.3 64 376 64h-176C186.7 64 176 74.74 176 88c0 13.25 10.75 24 24 24h64V128H128C101.5 128 80 149.5 80 176v56h-32v-80C48 138.7 37.25 128 24 128S0 138.7 0 152v208C0 373.3 10.75 384 24 384s24-10.75 24-24v-80h32v56C80 362.5 101.5 384 128 384h41.38l49.95 49.95c2.969 2.967 6.375 5.328 9.943 7.398C225.9 433.6 224 425 224 416c0-12.87 3.879-24.8 10.42-34.84L189.3 336H128v-160h260.8L448 223.4V400l-98.26 .0039C351.1 405.1 352 410.4 352 416c0 11.72-3.379 22.55-8.877 32H448c26.51 0 48-21.49 48-48V384H512v16c0 26.51 21.49 48 48 48h32c26.51 0 48-21.49 48-48v-160C640 213.5 618.5 192 592 192zM592 400h-32v-64h-64v-32h64v-64h32V400z"],
    "envelope": [512, 512, [128386, 61664, 61443], "2709", "M448 64H64C28.65 64 0 92.65 0 128v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V128C512 92.65 483.3 64 448 64zM64 112h384c8.822 0 16 7.178 16 16v22.16l-166.8 138.1c-23.19 19.28-59.34 19.27-82.47 .0156L48 150.2V128C48 119.2 55.18 112 64 112zM448 400H64c-8.822 0-16-7.178-16-16V212.7l136.1 113.4C204.3 342.8 229.8 352 256 352s51.75-9.188 71.97-25.98L464 212.7V384C464 392.8 456.8 400 448 400z"],
    "envelope-dot": [576, 512, ["envelope-badge"], "e16f", "M512 0c-35.35 0-64 28.65-64 64c0 35.35 28.65 64 64 64s64-28.65 64-64C576 28.65 547.3 0 512 0zM488.2 156.7l-158.9 132.5c-23.19 19.28-59.34 19.27-82.47 .0156L80 150.2V128c0-8.822 7.178-16 16-16h333.3C421.1 97.83 416 81.58 416 64H96C60.65 64 32 92.65 32 128v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V154.1C533.9 157.7 523.3 160 512 160C503.7 160 495.9 158.6 488.2 156.7zM496 384c0 8.822-7.178 16-16 16H96c-8.822 0-16-7.178-16-16V212.7l136.1 113.4C236.3 342.8 261.8 352 288 352s51.75-9.184 71.97-25.98L496 212.7V384z"],
    "envelope-open": [512, 512, [62135], "f2b6", "M493.6 163c-24.88-19.62-45.5-35.37-164.3-121.6C312.7 29.21 279.7 0 256.4 0H255.6C232.3 0 199.3 29.21 182.6 41.38C63.88 127.6 43.25 143.4 18.38 163C6.75 172 0 186 0 200.8v247.2C0 483.3 28.65 512 64 512h384c35.35 0 64-28.67 64-64.01V200.8C512 186 505.3 172 493.6 163zM464 448c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V276.7l136.1 113.4C204.3 406.8 229.8 416 256 416s51.75-9.211 71.97-26.01L464 276.7V448zM464 214.2l-166.8 138.1c-23.19 19.28-59.34 19.27-82.47 .0156L48 214.2l.1055-13.48c23.24-18.33 42.25-32.97 162.9-120.6c3.082-2.254 6.674-5.027 10.63-8.094C229.4 65.99 246.7 52.59 256 48.62c9.312 3.973 26.62 17.37 34.41 23.41c3.959 3.066 7.553 5.84 10.76 8.186C421.6 167.7 440.7 182.4 464 200.8V214.2z"],
    "envelope-open-dollar": [512, 512, [], "f657", "M257.3 304c11.05 0 20-8.969 20-20V273.7c22.36-4.793 38.21-18.53 41.83-39.43c7.484-43.28-34.03-55.19-56.33-61.56l-5.547-1.594C233.5 164.2 234.1 160.1 234.9 156.5c1.375-7.812 16.59-9.719 30.27-7.625c5.594 .8438 11.73 2.812 17.59 4.844c10.39 3.594 21.83-1.938 25.45-12.34c3.625-10.44-1.891-21.84-12.33-25.47c-7.219-2.484-13.11-4.078-18.56-5.273V100c0-11.03-8.953-20-20-20s-20 8.969-20 20v9.992C214.9 114.8 199.1 128.8 195.5 149.7C188 192.5 228.6 204.4 245.1 209.5l5.812 1.688c29.28 8.375 28.8 11.19 27.92 16.28C278.3 235.3 263.1 237.3 249.4 235.1C242.5 234.1 233.6 230.9 225.7 228.1L221.3 226.5C210.9 222.9 199.4 228.3 195.8 238.7C192.1 249.1 197.5 260.5 207.1 264.2l4.266 1.5c7.758 2.789 16.38 5.59 25.06 7.512V284C237.3 295 246.2 304 257.3 304zM476.8 214.2c-8.244 0-16.23 2.891-22.56 8.168l-156.9 130.8c-22.68 18.9-59.8 18.91-82.49 .002L57.8 222.3c-6.332-5.277-14.32-8.168-22.56-8.168C15.78 214.2 0 229.9 0 249.4v198.6C0 483.3 28.65 512 64 512h384c35.35 0 64-28.67 64-64.01V249.4C512 229.9 496.2 214.2 476.8 214.2zM464 448c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V276.7l136.1 113.4C204.3 406.8 229.8 416.1 256 416.1s51.75-9.224 71.97-26.02L464 276.7V448zM112 225.9V56c0-4.406 3.594-8 8-8h272c4.406 0 8 3.594 8 8v169.8l33.72-28.1C438.1 194.1 442.9 191.3 448 188.9V56C448 25.12 422.9 0 392 0h-272C89.13 0 64 25.12 64 56v132.9c5.064 2.41 9.941 5.23 14.3 8.863L112 225.9z"],
    "envelope-open-text": [512, 512, [], "f658", "M476.8 214.2c-8.244 0-16.23 2.891-22.56 8.168l-156.9 130.8c-22.68 18.9-59.8 18.91-82.49 .002L57.8 222.3c-6.332-5.277-14.32-8.168-22.56-8.168C15.78 214.2 0 229.9 0 249.4v198.6C0 483.3 28.65 512 64 512h384c35.35 0 64-28.67 64-64.01V249.4C512 229.9 496.2 214.2 476.8 214.2zM464 448c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V276.7l136.1 113.4C204.3 406.8 229.8 416.1 256 416.1s51.75-9.224 71.97-26.02L464 276.7V448zM112 225.9V56c0-4.406 3.594-8 8-8h272c4.406 0 8 3.594 8 8v169.8l33.72-28.1C438.1 194.1 442.9 191.3 448 188.9V56C448 25.12 422.9 0 392 0h-272C89.13 0 64 25.12 64 56v132.9c5.064 2.41 9.941 5.23 14.3 8.863L112 225.9zM328 96h-144C170.7 96 160 106.7 160 120C160 133.3 170.7 144 184 144h144C341.3 144 352 133.3 352 120C352 106.7 341.3 96 328 96zM328 176h-144C170.7 176 160 186.7 160 200C160 213.3 170.7 224 184 224h144C341.3 224 352 213.3 352 200C352 186.7 341.3 176 328 176z"],
    "envelopes": [640, 512, [], "e170", "M544 32H192C156.7 32 128 60.65 128 96v224c0 35.35 28.65 64 64 64h352c35.35 0 64-28.65 64-64V96C608 60.65 579.3 32 544 32zM560 320c0 8.822-7.178 16-16 16H192c-8.822 0-16-7.178-16-16V161.9l120.1 100.1C316.3 278.8 341.8 288 368 288s51.75-9.25 71.97-26.05L560 161.9V320zM560 99.42l-150.8 125.6c-23.19 19.28-59.34 19.27-82.47 .0156L176 99.42V96c0-8.822 7.178-16 16-16h352c8.822 0 16 7.178 16 16V99.42zM488 480H152C85.83 480 32 426.2 32 360v-240C32 106.8 42.75 96 56 96S80 106.8 80 120v240c0 39.7 32.3 72 72 72h336c13.25 0 24 10.75 24 24S501.3 480 488 480z"],
    "envelopes-bulk": [640, 512, ["mail-bulk"], "f674", "M592 128h-320C245.5 128 224 149.5 224 176V192h48V176h320v192H416V416h176c26.5 0 48-21.5 48-48v-192C640 149.5 618.5 128 592 128zM112 48h320V96H480V48C480 21.5 458.5 0 432 0h-320C85.5 0 64 21.5 64 48V192h48V48zM336 224h-288C21.5 224 0 245.5 0 272v192C0 490.5 21.5 512 48 512h288c26.5 0 48-21.5 48-48v-192C384 245.5 362.5 224 336 224zM336 464h-288v-120C62.5 355 128 402.1 128 402.1C142.5 413.3 166.6 432 192 432s49.5-18.75 64-29.88c0 0 65.5-47.13 80-58.13V464zM336 285.4c-2.375 1.875-111.8 82-117.1 85.63C210.4 376.8 199.8 384 192 384c-9.375 0-22.75-10.5-31.5-17.5C157.1 363.8 50.38 284 48 282.3V272h288V285.4zM496 208v64h64v-64H496z"],
    "equals": [448, 512, [62764], "3d", "M408 328H40c-13.25 0-24 10.76-24 24.01S26.75 376 40 376h368c13.25 0 24-10.74 24-23.99S421.3 328 408 328zM40 184h368c13.25 0 24-10.74 24-23.99S421.3 136 408 136H40c-13.25 0-24 10.76-24 24.01S26.75 184 40 184z"],
    "eraser": [512, 512, [], "f12d", "M497.9 273.1c9.312-9.375 13.97-21.69 13.97-34c0-12.31-4.656-24.63-13.97-34l-159.1-160C328.6 36.66 316.3 32 303.1 32c-12.31 0-24.62 4.656-33.1 13.97L13.97 301.1C4.655 311.4 0 323.7 0 335.1c0 12.31 4.655 24.63 13.97 34l95.1 96c8.963 8.963 21.17 13.1 33.85 14l344.2 .0136C501.3 479.1 512 469.3 512 455.1c0-13.25-10.74-23.1-23.1-24l-148.2-.0269L497.9 273.1zM143.1 431.1l-96-96l119-119l160 160l-55 55H143.1z"],
    "escalator": [640, 512, [], "e171", "M544 96h-96c-23.25 0-45.72 8.438-63.22 23.75L303.9 190.6C303.1 155.9 274.9 128 240 128c-35.35 0-64 28.65-64 64v110.4L155.9 320H96c-53.03 0-96 42.98-96 96s42.97 96 96 96h96c23.25 0 45.72-8.438 63.22-23.75L484.1 288H544c53.03 0 96-42.98 96-96S597 96 544 96zM544 240h-77.97L223.6 452.1C214.9 459.8 203.6 464 192 464H96c-26.47 0-48-21.53-48-48s21.53-48 48-48h77.97l242.4-212.1C425.1 148.2 436.4 144 448 144h96c26.47 0 48 21.53 48 48S570.5 240 544 240zM240 96C266.5 95.9 288 74.46 288 48C288 21.54 266.5 .0996 240 0C213.5 .0996 192 21.54 192 48C192 74.46 213.5 95.9 240 96z"],
    "ethernet": [512, 512, [], "f796", "M480 192h-32V160c0-17.6-14.4-32-32-32h-32V96c0-17.6-14.4-32-32-32H160C142.4 64 128 78.4 128 96v32H96C78.4 128 64 142.4 64 160v32H32C14.4 192 0 206.4 0 224v192c0 17.6 14.4 32 32 32h448c17.6 0 32-14.4 32-32V224C512 206.4 497.6 192 480 192zM464 400h-40v-56c0-13.25-10.75-24-24-24s-24 10.75-24 24v56h-48v-56c0-13.25-10.75-24-24-24s-24 10.75-24 24v56h-48v-56C232 330.8 221.3 320 208 320s-24 10.75-24 24v56h-48v-56C136 330.8 125.3 320 112 320s-24 10.75-24 24v56H48v-160H96c8.836 0 16-7.164 16-16V176H160c8.836 0 16-7.164 16-16V112h160V160c0 8.836 7.164 16 16 16h48V224c0 8.836 7.164 16 16 16h48V400z"],
    "euro-sign": [384, 512, [61779, "eur", "euro"], "20ac", "M335.5 447c2.688 12.97-5.672 25.65-18.64 28.34C301.7 478.5 286.5 480 271.4 480c-58.7 0-115.5-23.12-157.9-65.68c-25.05-25.1-42.65-54.79-53.29-86.34H40c-13.25 0-24-10.74-24-23.98s10.75-24.01 24-24.01h9.494c-1.701-15.96-1.701-32.04 0-47.1H40c-13.25 0-24-10.73-24-23.98c0-13.25 10.75-24.01 24-24.01h20.16c10.65-31.56 28.25-61.26 53.31-86.37c53.34-53.46 129.4-76.21 203.4-60.99c12.97 2.688 21.33 15.37 18.64 28.34c-2.672 13-15.39 21.34-28.36 18.66c-58.16-11.94-117.8 5.904-159.7 47.9C131.9 147.1 120.4 165 111.9 183.1h152.1c13.25 0 24 10.77 24 24.02c0 13.25-10.75 23.97-24 23.97H98.37c-2.18 15.96-2.18 32.04-.002 47.1h165.6c13.25 0 24 10.76 24 24.01s-10.75 23.99-24 23.99H111.9c8.484 18.96 19.99 36.89 35.51 52.43c41.89 42.03 101.6 59.1 159.7 47.93C320.1 425.6 332.8 434 335.5 447z"],
    "exclamation": [128, 512, [10069, 10071, 61738], "21", "M64 368c13.27 0 24-10.75 24-24v-288c0-13.25-10.73-23.99-24-23.99S40 42.75 40 56v288C40 357.3 50.73 368 64 368zM64 416c-17.67 0-32 14.33-32 32s14.33 32.01 32 32.01S96 465.7 96 448S81.67 416 64 416z"],
    "expand": [448, 512, [], "f065", "M136 32h-112C10.75 32 0 42.75 0 56v112C0 181.3 10.75 192 24 192C37.26 192 48 181.3 48 168V80h88C149.3 80 160 69.25 160 56S149.3 32 136 32zM424 32h-112C298.7 32 288 42.75 288 56c0 13.26 10.75 24 24 24h88v88C400 181.3 410.7 192 424 192S448 181.3 448 168v-112C448 42.75 437.3 32 424 32zM136 432H48v-88C48 330.7 37.25 320 24 320S0 330.7 0 344v112C0 469.3 10.75 480 24 480h112C149.3 480 160 469.3 160 456C160 442.7 149.3 432 136 432zM424 320c-13.26 0-24 10.75-24 24v88h-88c-13.26 0-24 10.75-24 24S298.7 480 312 480h112c13.25 0 24-10.75 24-24v-112C448 330.7 437.3 320 424 320z"],
    "expand-wide": [512, 512, [], "f320", "M136 400H48V312C48 298.7 37.25 288 24 288S0 298.7 0 312v112C0 437.3 10.75 448 24 448h112C149.3 448 160 437.3 160 424C160 410.7 149.3 400 136 400zM136 64h-112C10.75 64 0 74.75 0 88v112C0 213.3 10.75 224 24 224C37.26 224 48 213.3 48 200V112h88C149.3 112 160 101.3 160 88S149.3 64 136 64zM488 64h-112C362.7 64 352 74.75 352 88c0 13.26 10.75 24 24 24h88v88C464 213.3 474.7 224 488 224S512 213.3 512 200v-112C512 74.75 501.3 64 488 64zM488 288c-13.26 0-24 10.75-24 24v88h-88c-13.26 0-24 10.75-24 24S362.7 448 376 448h112c13.25 0 24-10.75 24-24v-112C512 298.7 501.3 288 488 288z"],
    "eye": [576, 512, [61550], "1f441", "M572.5 238.1C518.3 115.5 410.9 32 288 32S57.69 115.6 3.469 238.1C1.563 243.4 0 251 0 256c0 4.977 1.562 12.6 3.469 17.03C57.72 396.5 165.1 480 288 480s230.3-83.58 284.5-206.1C574.4 268.6 576 260.1 576 256C576 251 574.4 243.4 572.5 238.1zM288 432c-99.48 0-191.2-67.5-239.6-175.1C97.01 147.4 188.6 80 288 80c99.48 0 191.2 67.5 239.6 175.1C478.1 364.6 387.4 432 288 432zM288 128C217.3 128 160 185.3 160 256s57.33 128 128 128c70.64 0 128-57.32 128-127.9C416 185.4 358.7 128 288 128zM288 336c-44.11 0-80-35.89-80-80c0-.748 .1992-1.441 .2207-2.184C213.3 255.1 218.5 256 224 256c35.35 0 64-28.65 64-64c0-5.48-.875-10.72-2.184-15.78C286.6 176.2 287.3 176 288 176c44.11 0 80 35.89 80 80.05C368 300.1 332.1 336 288 336z"],
    "eye-dropper": [512, 512, ["eye-dropper-empty", "eyedropper"], "f1fb", "M137.3 434.7c-2.963 2.959-6.977 4.623-11.17 4.623H72.63v-53.46c0-4.248 1.625-8.244 4.748-11.24l141.2-141.2L184.6 199.5l-141.2 141.2c-11.99 11.99-18.72 28.25-18.72 45.21v45.47l-20.76 36.33C-2.723 479.3-.7695 493.9 8.672 503.3c9.441 9.439 24.03 11.39 35.62 4.771l36.33-20.76h45.47c16.96 0 33.22-6.736 45.21-18.73l141.2-141.2l-33.87-33.87L137.3 434.7zM483.9 28.12c-37.48-37.47-98.25-37.47-135.7 0L237.3 139.1L225.2 126.9c-9.369-9.369-24.55-9.369-33.92 0s-9.369 24.54 0 33.91l159.9 159.9c4.684 4.686 10.8 7.027 16.96 7.027s12.27-2.342 16.96-7.027c9.369-9.369 9.369-24.55 0-33.91L372.9 274.7l110.9-110.9C521.4 126.4 521.4 65.6 483.9 28.12z"],
    "eye-dropper-full": [512, 512, [], "e172", "M483.9 28.12c-37.48-37.47-98.25-37.47-135.7 0L237.3 139.1L225.2 126.9c-9.369-9.369-24.55-9.369-33.92 0s-9.369 24.54 0 33.91l159.9 159.9c4.684 4.686 10.8 7.027 16.96 7.027s12.27-2.342 16.96-7.027c9.369-9.369 9.369-24.55 0-33.91L372.9 274.7l110.9-110.9C521.4 126.4 521.4 65.6 483.9 28.12zM43.39 340.7c-11.99 11.99-18.72 28.25-18.72 45.21v45.47l-20.76 36.33C-2.723 479.3-.7695 493.9 8.672 503.3c9.441 9.439 24.03 11.39 35.62 4.771l36.33-20.76h45.47c16.96 0 33.22-6.736 45.21-18.73l141.2-141.2L184.6 199.5L43.39 340.7z"],
    "eye-dropper-half": [512, 512, [], "e173", "M252.2 320H132l86.54-86.55L184.6 199.5l-141.2 141.2c-11.99 11.99-18.72 28.25-18.72 45.21v45.47l-20.76 36.33C-2.723 479.3-.7695 493.9 8.672 503.3c9.441 9.439 24.03 11.39 35.62 4.771l36.33-20.76h45.47c16.96 0 33.22-6.736 45.21-18.73l141.2-141.2l-33.87-33.87L252.2 320zM483.9 28.12c-37.48-37.47-98.25-37.47-135.7 0L237.3 139.1L225.2 126.9c-9.369-9.369-24.55-9.369-33.92 0s-9.369 24.54 0 33.91l159.9 159.9c4.684 4.686 10.8 7.027 16.96 7.027s12.27-2.342 16.96-7.027c9.369-9.369 9.369-24.55 0-33.91L372.9 274.7l110.9-110.9C521.4 126.4 521.4 65.6 483.9 28.12z"],
    "eye-evil": [640, 512, [], "f6db", "M610.1 217.5l-94.53-25.16c44.73-69.76 47.53-70.96 47.53-85.6c0-29.4-27.26-39.92-41.17-39.92c-4.707 0-9.479 .7809-14.12 2.396l-101.6 36.06c-4-1.688-8.062-3.281-12.17-4.781l-36.7-76.97C350.5 9.031 336.2 0 319.1 0S289.5 9.031 282.7 23.44L245.1 100.5c-4.109 1.5-8.172 3.094-12.17 4.781L132.1 69.22C127.5 67.65 122.8 66.89 118.2 66.89c-13.39 0-41.25 10.3-41.25 39.86c0 7.252 2.058 14.56 6.222 21.16l41.3 64.47L29.1 217.5c-17.95 4.656-29.1 20.16-29.1 38.5s12.05 33.84 29.88 38.47l94.44 25.12c-44.83 69.88-47.42 71.28-47.42 85.63c0 29.37 27.27 39.95 41.17 39.95c4.711 0 9.485-.7885 14.13-2.423l101.6-36.06c4 1.688 8.062 3.281 12.17 4.781l36.7 76.97C289.5 502.1 303.8 512 319.1 512s30.5-9.031 37.27-23.44l36.77-77.09c4.109-1.5 8.172-3.094 12.17-4.781l101.7 36.09c4.613 1.602 9.356 2.376 14.04 2.376c14.32 0 41.16-11.06 41.16-39.91c0-14.56-2.749-15.88-47.41-85.65l94.31-25.09c17.95-4.656 30-20.15 30-38.49C640 237.7 628 222.2 610.1 217.5zM486.2 277.8l-5 6.719c-4.125 5.531-8.797 11.25-13.91 17.34l-11.45 13.91c0 0 33.81 52.22 48.16 74.69l-100.3-35.59l-9.031 4.375c-7.984 3.844-16.34 7.125-24.88 9.719l-10.11 3.094L320 455.2l-39.66-83.16l-10.11-3.094c-8.531-2.594-16.89-5.875-24.88-9.719l-9.031-4.375L136 390.4c14.34-22.47 36.19-56.69 37.92-59.31L184.6 316L172.7 301.8C167.6 295.8 162.9 290 158.8 284.5l-5-6.719L71.95 256l81.81-21.78l5-6.688C163.2 221.7 167.8 216 172.6 210.4L184.4 196.8c0 0-33.63-52.22-48.31-75.19l100.3 35.59l9.031-4.375c7.984-3.844 16.34-7.125 24.88-9.719l10.11-3.094L320 56.81l39.66 83.16l10.11 3.094c8.531 2.594 16.89 5.875 24.88 9.719l9.031 4.375l100.3-35.59c-14.72 23-48.38 75.28-48.38 75.28l11.95 13.69c5.094 5.812 9.672 11.53 13.7 16.97l5 6.719L568 256L486.2 277.8zM390.7 200.9c-11.89 0-29.03 12.51-70.69 12.51c-41.58 0-58.71-12.57-70.98-12.57c-28.76 0-33.01 28-33.01 47.19c0 6.472 .5959 13.08 1.843 19.78c3.021 16.22 26.01 84.23 102.1 84.23c57.49 0 103.1-46.51 103.1-104C423.1 201.1 395.8 200.9 390.7 200.9zM319.1 304c-36.19 0-53.47-30.08-55.62-49.57c12.07 3.094 24.52 4.766 37.12 5.785L320 288l18.51-27.77c12.6-1.016 25.05-2.691 37.11-5.781C372.4 282.3 348.7 304 319.1 304z"],
    "eye-low-vision": [640, 512, ["low-vision"], "f2a8", "M630.8 469.1l-103.6-81.21c31.35-31.94 57.9-70.68 77.32-114.9c1.906-4.43 3.469-12.07 3.469-17.02c0-4.977-1.562-12.6-3.469-17.03C550.3 115.5 442.9 32 320 32c-62.67 0-121.2 21.97-170.8 59.64L38.81 5.116C34.41 1.679 29.19 0 24.03 0C16.91 0 9.839 3.158 5.121 9.189c-8.188 10.44-6.37 25.53 4.068 33.7l591.1 463.1c10.5 8.203 25.57 6.333 33.69-4.073C643.1 492.4 641.2 477.3 630.8 469.1zM394.4 283.8l-81.65-63.1C316.1 211.3 320 202.2 320 192C320 186.5 319.1 181.3 317.8 176.2C318.6 176.2 319.3 176 320 176c44.11 0 80 35.89 80 80.05C400 265.9 397.7 275.1 394.4 283.8zM433.2 314.2C442.4 296.8 448 277.2 448 256.1C448 185.4 390.7 128 320 128C287.8 128 258.7 140.2 236.3 159.9L188.3 122.3C228 95.03 273.1 80 320 80c99.48 0 191.2 67.5 239.6 175.1c-18.06 40.38-42.41 74.43-70.61 101.9L433.2 314.2zM36.85 236.1l307.5 242.8c13.9-1.262 27.55-3.609 40.91-6.941L50.88 207.9C45.92 217.1 41.18 226.4 36.85 236.1zM292.1 478.4L37.55 277.4C88.16 389 182.5 466.1 292.1 478.4zM67.41 180.2l354.3 279.7c10.62-4.277 21.02-9.117 31.12-14.66L85.2 155C78.95 163.1 73.08 171.5 67.41 180.2z"],
    "eye-slash": [640, 512, [], "f070", "M630.8 469.1l-103.5-81.11c31.35-31.94 57.79-70.78 77.21-114.1c1.906-4.43 3.469-12.07 3.469-17.03c0-4.977-1.562-12.6-3.469-17.03c-54.25-123.4-161.6-206.1-284.5-206.1c-62.67 0-121.2 21.95-170.8 59.62L38.81 5.116C34.41 1.679 29.19 0 24.03 0C16.91 0 9.839 3.158 5.121 9.189c-8.188 10.44-6.37 25.53 4.068 33.7l591.1 463.1c10.5 8.203 25.57 6.333 33.69-4.073C643.1 492.4 641.2 477.3 630.8 469.1zM394.4 283.8l-81.65-63.1C316.1 211.3 319.1 202.2 319.1 192c0-5.48-.8744-10.73-2.183-15.78C318.6 176.2 319.3 176 320 176c44.11 0 80 35.89 80 80.05C400 265.9 397.7 275.1 394.4 283.8zM433.2 314.2C442.4 296.8 448 277.2 448 256.1C448 185.4 390.7 128 320 128C287.8 128 258.7 140.2 236.3 159.9L188.3 122.3C228 95.03 273.1 80 320 80c99.48 0 191.2 67.5 239.6 175.1c-18.06 40.38-42.41 74.43-70.61 101.9L433.2 314.2zM320 384c13.42 0 26.16-2.643 38.31-6.477L302.8 334C279.1 328.8 259.5 312.9 248.8 291.7L192.8 247.8C192.6 250.6 192 253.2 192 256C192 326.7 249.3 384 320 384zM320 432c-99.48 0-191.2-67.5-239.6-175.1c10.83-24.22 24.09-46.03 38.81-65.86L81.28 160.4c-17.77 23.74-33.27 50.04-45.81 78.59C33.56 243.4 31.1 251 31.1 256c0 4.977 1.562 12.6 3.469 17.03c54.25 123.4 161.6 206.1 284.5 206.1c45.46 0 88.77-11.49 128.1-32.14l-42.87-33.59C378 425.4 349.5 432 320 432z"],
    "eyes": [640, 512, [], "e367", "M468 32c-62.9 0-117.9 44.34-147.9 110.1c-10.8-23.89-24.89-45.37-42.23-62.99C247.5 48.31 210.9 32 172 32C77.16 32 0 132.5 0 256s77.16 224 172 224c62.1 0 118-44.48 148-110.4C349.1 435.5 405 480 468 480C562.8 480 640 379.5 640 256S562.8 32 468 32zM172 432c-45.95 0-86.05-35.75-107.5-88.59C73.86 348.7 84.5 352 96 352c35.35 0 64-28.65 64-64S131.3 224 96 224C76.98 224 60.09 232.5 48.37 245.6C52.19 153.4 106.1 80 172 80c25.75 0 50.53 11.34 71.72 32.84C276.4 146.1 296 199.6 296 256C296 353 240.4 432 172 432zM468 432c-44.59 0-83.64-33.7-105.5-83.97C369.3 350.4 376.4 352 384 352c35.35 0 64-28.65 64-64s-28.65-64-64-64c-14.91 0-28.46 5.312-39.34 13.87C351.1 149.3 403.9 80 468 80C536.4 80 592 158.1 592 256S536.4 432 468 432z"],
    "f": [320, 512, [102], "46", "M320 56c0 13.25-10.75 24-24 24H48v152h184c13.25 0 24 10.76 24 24.01S245.3 280 232 280H48v176C48 469.3 37.25 480 24 480S0 469.3 0 456V56C0 42.75 10.75 32 24 32h272C309.3 32 320 42.75 320 56z"],
    "face-angry": [512, 512, [62806, "angry"], "1f620", "M256 312c-33.54 0-65.15 14.75-86.82 40.63c-8.477 10.12-7.023 25.25 3.148 33.75s25.31 7.25 33.79-3c24.82-29.62 74.96-29.62 99.78 0c8.113 9.75 23.25 11.88 33.79 3c10.17-8.5 11.5-23.62 3.148-33.75C321.1 326.8 289.5 312 256 312zM208 240c10.29 0 19.86-6.75 23.01-17.12C234.8 210.3 227.5 196.8 214.9 193l-80.04-24c-12.84-3.875-26.16 3.375-29.91 16.12C101.2 197.8 108.4 211.3 121.1 215l28.21 8.5C146.2 228.4 143.1 233.8 143.1 240c0 17.62 14.38 32 32.06 32C193.8 272 208 257.8 208 240zM407 185.1c-3.754-12.75-17.07-19.88-29.91-16.12l-80.04 24c-12.59 3.75-19.86 17.25-16.11 29.88C284.1 233.3 293.8 240 304 240c0 17.75 14.2 32 31.1 32c17.68 0 32.06-14.25 32.06-32c0-6.25-2.271-11.75-5.419-16.62l28.21-8.5C403.6 211.3 410.8 197.8 407 185.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-angry-horns": [640, 512, [], "e368", "M320 328c-33.54 0-65.15 14.75-86.82 40.63c-8.477 10.12-7.023 25.25 3.148 33.75s25.31 7.25 33.79-3c24.82-29.62 74.96-29.62 99.78 0c8.113 9.75 23.25 11.88 33.79 3c10.17-8.5 11.5-23.62 3.148-33.75C385.1 342.8 353.5 328 320 328zM272 256C282.3 256 291.9 249.3 295.1 238.9C298.8 226.3 291.5 212.8 278.9 209l-80.04-24c-12.84-3.875-26.16 3.375-29.91 16.12C165.2 213.8 172.4 227.3 185.1 231l28.21 8.5C210.2 244.4 207.1 249.8 207.1 256c0 17.62 14.36 31.98 32.04 31.98C257.8 288 272 273.8 272 256zM441.1 185l-80.04 24c-12.59 3.75-19.86 17.25-16.11 29.88C348.1 249.3 357.8 256 368 256c0 17.75 14.18 32 31.98 32c17.68 0 32.08-14.25 32.08-32c0-6.25-2.271-11.75-5.42-16.62l28.21-8.5c12.71-3.625 19.86-17.12 16.11-29.75C467.3 188.4 453.9 181.3 441.1 185zM607.1 15.62c-.1562-5.469-3.094-10.53-7.812-13.34c-4.688-2.812-10.53-3-15.44-.5313c-35.87 18.21-74.93 33.42-115.3 47.08C427.3 18.25 375.9 0 319.9 0c-55.87 0-107.7 18.19-149.8 48.68C129.9 35.06 91.04 19.91 55.29 1.75C50.38-.7187 44.54-.5313 39.85 2.281C35.13 5.094 32.19 10.16 32.04 15.62L32.01 16.88C31.97 17.97 32.07 19.06 32.26 20.12c8.656 48.06 25.7 94.48 50.77 138.5C70.63 188.7 63.94 221.5 63.94 256c0 141.2 114.8 256 256 256s256-114.8 256-256c0-34.22-7.119-66.84-19.36-96.71c25.25-44.19 42.45-90.82 51.2-139.2C607.1 19.06 608 16.72 607.1 15.62zM319.7 464c-114.7 0-208-93.31-208-208s93.31-208 208-208s208 93.31 208 208S434.4 464 319.7 464z"],
    "face-anguished": [512, 512, [], "e369", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM208 224c0-17.75-14.29-32-32.09-32C158.3 192 143.1 206.3 143.1 224S158.3 256 175.1 256C193.8 256 208 241.8 208 224zM336 192c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 192 336 192zM208 112C208 103.2 200.8 96 192 96C138 96 102.2 131.2 100.7 132.7C94.45 138.9 94.45 148.1 100.7 155.3C103.8 158.4 107.9 159.1 112 159.1c4.062 0 8.128-1.536 11.25-4.599C123.5 155.1 151.6 128 192 128C200.8 128 208 120.8 208 112zM411.3 132.7C409.8 131.2 374 96 320 96c-8.844 0-16 7.156-16 16S311.2 128 320 128c40.42 0 68.45 27.09 68.73 27.38C391.9 158.5 395.9 160 400 160c4.094 0 8.188-1.562 11.31-4.688C417.6 149.1 417.6 138.9 411.3 132.7zM256 320c-44.11 0-80 35.88-80 80C176 408.8 183.2 416 192 416h128c8.844 0 16-7.156 16-16C336 355.9 300.1 320 256 320z"],
    "face-anxious-sweat": [576, 512, [], "e36a", "M288 336c-35.3 0-64 28.72-64 64C224 408.8 231.2 416 240 416h96c8.844 0 16-7.156 16-16C352 364.7 323.3 336 288 336zM208 128.7c-4.844 0-9.656 2.219-12.78 6.375C176.1 160.5 150.6 180.7 121.6 193.4C113.5 196.9 109.8 206.4 113.3 214.4c3.562 8.094 13.06 11.69 21.06 8.25C168.5 207.8 198.3 184.2 220.8 154.3c5.312-7.062 3.906-17.09-3.156-22.41C214.7 129.7 211.3 128.7 208 128.7zM207.9 240c-17.66 0-31.95 14.25-31.95 32s14.28 32 31.95 32c17.79 0 32.07-14.25 32.07-32S225.7 240 207.9 240zM335.1 272c0 17.75 14.28 32 32.07 32C385.7 304 400 289.8 400 272s-14.28-32-31.95-32C350.3 240 335.1 254.3 335.1 272zM441.6 222.7c8.125 3.438 17.53-.1562 21.06-8.25s-.1562-17.53-8.25-21.06c-29.06-12.69-54.5-32.84-73.63-58.28c-3.125-4.188-7.938-6.406-12.78-6.406c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38C377.6 184.2 407.5 207.8 441.6 222.7zM41.6 291.3C28.43 308.6 0 349 0 369C0 395 21.54 416 48 416S96 395 96 369c0-19.1-28.55-60.36-41.6-77.73C51.2 286.9 44.8 286.9 41.6 291.3zM288 0C146.6 0 32 114.6 32 256c0 1.18 .1602 2.319 .1758 3.495C37.12 257.4 42.46 256 48 256c12.67 0 24.7 6.083 32.2 16.33c.25 .332 .4329 .6315 .679 .9616C80.4 267.6 80 261.8 80 256c0-114.7 93.31-208 208-208s208 93.31 208 208s-93.31 208-208 208c-65.46 0-123.9-30.46-162-77.87c-3.84 17.04-13.39 31.8-26.4 42.75C146.4 479.9 213.4 512 288 512c141.4 0 256-114.6 256-256S429.4 0 288 0z"],
    "face-astonished": [512, 512, [], "e36b", "M175.1 192C158.3 192 143.1 206.3 143.1 224S158.3 256 175.1 256c17.8 0 32.09-14.25 32.09-32S193.8 192 175.1 192zM256 304c-26.51 0-48 21.49-48 48v32c0 26.51 21.49 48 48 48s48-21.49 48-48v-32C304 325.5 282.5 304 256 304zM336 192c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 192 336 192zM208 128c0-8.844-7.156-16-16-16c-54 0-89.81 35.19-91.31 36.69C94.47 154.9 94.47 164.1 100.7 171.3C103.8 174.4 107.9 175.1 112 175.1c4.062 0 8.156-1.531 11.25-4.594C123.5 171.1 151.6 144 192 144C200.8 144 208 136.8 208 128zM411.3 148.7C409.8 147.2 374 112 320 112c-8.844 0-16 7.156-16 16s7.156 16 16 16c40.41 0 68.47 27.09 68.75 27.38C391.8 174.5 395.9 176 400 176c4.094 0 8.188-1.562 11.31-4.688C417.6 165.1 417.6 154.9 411.3 148.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-confounded": [512, 512, [], "e36c", "M160.5 240l-33.66 40.25c-8.598 10.5 3.875 24.88 15.38 18l80.04-48c7.75-4.625 7.75-15.88 0-20.5l-80.04-48c-11.62-7-23.98 7.625-15.38 18L160.5 240zM369.8 298.3c11.5 6.875 24.1-7.5 15.38-18l-33.66-40.25l33.66-40.25c8.598-10.38-3.754-25-15.38-18l-80.04 48c-7.629 4.625-7.629 15.88 0 20.5L369.8 298.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM352.4 337.8l-15.16 13l-27.31-15.62c-7.375-4.188-16.44-4.188-23.81 0L256 352.3l-30.09-17.19c-7.375-4.188-16.44-4.188-23.81 0l-27.31 15.62l-15.16-13c-10.03-8.594-25.19-7.469-33.84 2.594c-8.625 10.06-7.469 25.22 2.594 33.84l28 24c7.75 6.625 18.72 7.656 27.53 2.625L214 383.7l30.09 17.19c7.375 4.188 16.44 4.188 23.81 0L298 383.7l30.09 17.19C331.8 402.1 335.9 404 340 404c5.594 0 11.16-1.969 15.62-5.781l28-24c10.06-8.625 11.22-23.78 2.594-33.84S362.5 329.2 352.4 337.8z"],
    "face-confused": [512, 512, [], "e36d", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM175.1 240c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32S158.3 240 175.1 240zM336 304c-114.6 0-173.6 51.94-176.1 54.16C150.2 366.1 149.4 382 158.1 391.9c4.719 5.312 11.31 8.031 17.94 8.031c5.625 0 11.31-1.969 15.88-5.938C192.4 393.5 241 352 336 352c13.25 0 24-10.75 24-24S349.3 304 336 304zM336 176c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 176 336 176z"],
    "face-cowboy-hat": [512, 512, [], "e36e", "M256 416c34.59 0 76.86-21.85 82.18-53.28c1.039-6.785-5.396-12.36-11.83-10.29c-17.3 5.57-42.96 8.713-70.36 8.713c-27.4 0-53.06-3.143-70.36-8.713c-6.504-2.07-12.94 3.5-11.83 10.29C179.1 394.1 221.4 416 256 416zM217 282C217 267.6 205.4 256 190.1 256C176.6 256 164.1 267.6 164.1 282S176.6 308 190.1 308C205.4 308 217 296.4 217 282zM394.5 225.6C407.9 248.8 416 275.3 416 304c0 88.22-71.78 160-159.1 160s-159.1-71.78-159.1-160c0-28.67 8.066-55.22 21.46-78.41C102.2 217.9 88.48 209.4 76.54 200.1C58.7 230.7 48 266 48 304c0 114.9 93.13 208 207.1 208s207.1-93.13 207.1-208c0-37.1-10.7-73.25-28.54-103.9C423.5 209.4 409.8 217.9 394.5 225.6zM347 282c0-14.42-11.61-26-25.97-26c-14.46 0-26.07 11.58-26.07 26s11.61 26 26.07 26C335.4 308 347 296.4 347 282zM256 224c190.1 0 231-146.4 231.4-147.9c1.797-6.812-1.094-14-7.109-17.69c-6-3.719-13.75-3-19.03 1.656c-.4395 .4082-30.39 25.73-88.78 43.34C356.1 35.08 332.9 0 303.2 0c-11.84 0-23.36 4.406-34.27 13.09c-7.578 6.156-18.22 6.125-25.89-.0313C232.2 4.406 220.8 0 208.9 0C179 0 156.3 34.19 139.6 103.4C81.11 85.83 51.11 60.47 50.67 60.06C45.39 55.41 37.64 54.69 31.64 58.41C25.62 62.09 22.73 69.28 24.53 76.09C24.92 77.56 65.89 224 256 224z"],
    "face-disappointed": [512, 512, [], "e36f", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM212.3 242.7c-2.533-2.609-5.709-4.15-9.012-4.666C198.5 237.2 193.4 238.7 189.7 242.3C166.8 264.5 138.6 280.5 107.9 288.6C99.39 290.8 94.29 299.6 96.53 308.1c2.27 8.547 11.1 13.56 19.54 11.4c35.95-9.438 69.12-28.2 95.89-54.22C218.3 259.1 218.5 248.1 212.3 242.7zM404.1 288.6c-30.67-8.049-58.92-24.04-81.74-46.22c-3.732-3.656-8.83-5.105-13.62-4.357c-3.303 .5176-6.479 2.057-8.98 4.662c-6.193 6.312-6.035 16.44 .3047 22.6c26.75 26.06 59.92 44.82 95.9 54.25c8.559 2.141 17.3-2.861 19.54-11.4C417.7 299.6 412.6 290.8 404.1 288.6zM256 336c-54.88 0-82.81 40.94-83.97 42.69c-7.344 11.03-4.375 25.94 6.656 33.28c11.03 7.312 25.94 4.344 33.28-6.656C212.1 405.1 227 384 256 384c28.69 0 43.56 20.69 44.03 21.31C304.7 412.3 312.3 416 320 416c4.562 0 9.211-1.312 13.3-4.031c11.03-7.344 14-22.25 6.656-33.28C338.8 376.9 310.9 336 256 336z"],
    "face-disguise": [576, 512, [], "e370", "M200 240C213.3 240 224 229.3 224 216C224 202.7 213.3 192 200 192S176 202.7 176 216C176 229.3 186.7 240 200 240zM400 216C400 202.7 389.3 192 376 192S352 202.7 352 216c0 13.25 10.75 24 24 24S400 229.3 400 216zM544 192c0-7.688-5.518-13.8-12.74-15.34C497.8 74.25 401.5 0 288 0S78.23 74.25 44.74 176.7C37.52 178.2 32 184.3 32 192c0 4.729 2.131 8.865 5.387 11.79C33.88 220.7 32 238.1 32 256c0 141.2 114.8 256 256 256s256-114.8 256-256c0-17.89-1.877-35.34-5.387-52.21C541.9 200.9 544 196.7 544 192zM456 152V133.9C465.4 146.8 472.9 161.1 479.2 176h-12.87c-2.758-7.74-6.303-15.12-10.85-21.8C455.5 153.4 456 152.8 456 152zM348.4 265.5l-18.76-32.82c-4.191-7.34-10.06-13.16-16.92-17.3C312.5 212.9 312 210.5 312 208c0-35.28 28.7-64 64-64s64 28.72 64 64s-28.7 64-64 64C366.1 272 356.8 269.5 348.4 265.5zM368 336c0 3.781-2.094 7.156-5.469 8.844l-53.06 26.53c-13.44 6.688-29.5 6.688-42.94 0l-53.08-26.53C210.1 343.2 208 339.8 208 336s2.094-7.156 5.469-8.844l17.69-8.844C233.1 316.9 236.3 314.7 237.9 311.9L274.1 248.6C278.3 241.3 285.2 240.5 288 240.5s9.734 .7813 13.89 8.062l36.22 63.38c1.562 2.75 3.906 4.969 6.734 6.375l17.7 8.844C365.9 328.8 368 332.2 368 336zM288 48c56.16 0 107.1 22.47 144.6 58.77c-.1992-.0039-.3633-.1133-.5625-.1133c-8.92 0-16.4 5.09-20.53 12.32C410.4 118.5 409.1 118.3 408 117.9V112c0-13.25-10.75-24-24-24s-24 10.75-24 24v1.617c-.8828 .1484-1.826 .0996-2.701 .2734C353.4 105.1 345.4 100.4 336 100.4c-13.25 0-24 10.75-24 24v12.53C301.9 146.1 293.5 157.2 288 169.8C282.5 157.2 274.1 146.1 264 136.1V124.4c0-13.25-10.75-24-24-24c-9.414 0-17.37 5.559-21.3 13.45C217.8 113.7 216.9 113.8 216 113.6V112c0-13.25-10.75-24-24-24S168 98.75 168 112v5.896C166.9 118.3 165.6 118.5 164.5 118.1C160.4 111.7 152.9 106.7 144 106.7c-.1992 0-.3633 .1094-.5625 .1133C180.9 70.47 231.8 48 288 48zM200 144c35.3 0 64 28.72 64 64c0 2.529-.4609 4.934-.748 7.389C256.4 219.5 250.5 225.3 246.3 232.7L227.6 265.5C219.2 269.5 209.9 272 200 272c-35.3 0-64-28.72-64-64S164.7 144 200 144zM120 133.9V152c0 .8008 .4707 1.42 .5527 2.195C116 160.9 112.5 168.3 109.7 176H96.84C103.1 161.1 110.6 146.8 120 133.9zM288 464c-114.7 0-208-93.31-208-208c0-16.62 2.594-32.53 6.32-48H104c0 50.31 39.03 91.24 88.32 95.22C182.2 311.1 176 322.9 176 336c0 15.96 8.871 30.33 23.14 37.46L179.5 398c-5.516 6.906-4.391 16.97 2.5 22.5C184.1 422.8 188.5 424 191.1 424c4.703 0 9.344-2.062 12.52-6l23.92-29.9l7.254 3.629l-10.53 26.33c-3.281 8.188 .7187 17.5 8.922 20.78C236 439.6 238 440 240 440c6.344 0 12.36-3.812 14.86-10.06l10.13-25.33C267.3 405.3 269.6 406.1 272 406.6V432c0 8.844 7.156 16 16 16s16-7.156 16-16v-25.44c2.385-.4844 4.664-1.26 7.006-1.961l10.13 25.33C323.6 436.2 329.7 440 336 440c1.984 0 4-.375 5.938-1.156c8.203-3.281 12.2-12.59 8.922-20.78l-10.54-26.34l7.254-3.629L371.5 418c3.172 3.938 7.812 6 12.52 6c3.5 0 7.031-1.156 9.984-3.5c6.891-5.531 8.016-15.59 2.5-22.5l-19.64-24.55C391.1 366.3 400 351.1 400 336c0-13.14-6.236-24.95-16.32-32.78C432.1 299.2 472 258.3 472 208h17.68C493.4 223.5 496 239.4 496 256C496 370.7 402.7 464 288 464z"],
    "face-dizzy": [512, 512, ["dizzy"], "f567", "M256 272c-35.36 0-64.06 28.75-64.06 64S220.6 400 256 400s64.06-28.75 64.06-64S291.4 272 256 272zM382.2 145.9c-7.75-7.75-20.46-7.75-28.34 0l-17.8 17.88l-17.8-17.88c-7.871-7.75-20.59-7.75-28.34 0c-7.75 7.875-7.75 20.5 0 28.38l17.92 17.88L289.9 210c-7.75 7.75-7.75 20.5 0 28.25c7.75 7.875 20.46 7.875 28.34 0l17.8-17.75l17.8 17.75c7.75 7.875 20.46 7.875 28.21 0c7.871-7.75 7.871-20.5 0-28.25L364.3 192l17.92-17.88C389.9 166.3 389.9 153.8 382.2 145.9zM222.2 238.1c7.75-7.875 7.75-20.5 0-28.38L204.3 192l17.92-17.88c7.75-7.875 7.75-20.5 0-28.38c-7.871-7.75-20.46-7.75-28.34 0l-17.92 18L158.2 145.9c-7.75-7.75-20.46-7.75-28.21 0c-7.871 7.875-7.871 20.5 0 28.38l17.8 17.88L129.9 210c-7.871 7.75-7.871 20.5 0 28.25c7.75 7.875 20.46 7.875 28.21 0L175.1 220.5l17.8 17.75C201.8 246 214.3 246 222.2 238.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-downcast-sweat": [512, 512, [], "e371", "M172 378.7c-7.344 11.03-4.375 25.94 6.656 33.28c11.03 7.312 25.94 4.344 33.28-6.656C212.1 405.1 227 384 256 384c28.69 0 43.56 20.69 44.03 21.31C304.7 412.3 312.3 416 320 416c4.562 0 9.211-1.312 13.3-4.031c11.03-7.344 14-22.25 6.656-33.28C338.8 376.9 310.9 336 256 336S173.2 376.9 172 378.7zM208 256h-96C103.2 256 96 263.2 96 272S103.2 288 112 288h96C216.8 288 224 280.8 224 272S216.8 256 208 256zM400 288C408.8 288 416 280.8 416 272S408.8 256 400 256h-96C295.2 256 288 263.2 288 272S295.2 288 304 288H400zM56 144c30.87 0 56-23.62 56-52.86c0-22.5-33.17-67.91-48.54-87.45c-3.732-4.922-11.2-4.922-14.93 0C33.31 23.23 0 68.64 0 91.14C0 120.4 25.13 144 56 144zM256 0C207.9 0 163 13.53 124.5 36.63c10.04 17.61 15.94 32.69 17.9 45.33C175.1 60.56 214.1 48 256 48c114.7 0 208 93.31 208 208s-93.31 208-208 208S48 370.7 48 256c0-28.65 5.824-55.96 16.35-80.81C61.56 175.4 58.86 176 56 176c-14.31 0-27.64-3.625-39.6-9.494C5.975 194.4 0 224.5 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256S397.4 0 256 0z"],
    "face-drooling": [512, 512, [], "e372", "M143.2 213.2C143.7 211.6 156.4 176 192 176c8.844 0 16-7.156 16-16S200.8 144 192 144c-58.84 0-78.38 56.53-79.19 58.94C110 211.3 114.5 220.3 122.9 223.1C124.6 223.7 126.3 223.1 128 223.1C134.6 223.1 140.8 219.8 143.2 213.2zM378.9 306.8c-11.67-6-26.09-1.406-32.27 10.19C345.7 318.8 322.1 360 256 360c-66.56 0-89.44-40.72-90.66-42.97c-5.984-11.66-20.27-16.34-32.08-10.5c-11.86 5.938-16.66 20.34-10.73 32.19C123.1 341.6 158.3 408 256 408c11.59 0 22.14-1.061 32-2.713V464c0 8.836 7.164 16 16 16s16-7.164 16-16v-67.42c12.73-4.939 23.1-11.05 32-17.45V496c0 8.836 7.164 16 16 16s16-7.164 16-16v-148.6c3.152-4.604 5.186-8.143 5.469-8.711C395.3 327 390.6 312.8 378.9 306.8zM320 144c-8.844 0-16 7.156-16 16s7.156 16 16 16c35.56 0 48.31 35.63 48.84 37.16C371.1 219.8 377.3 224 384 224c1.688 0 3.375-.25 5.062-.8125c8.375-2.812 12.91-11.88 10.12-20.25C398.4 200.5 378.8 144 320 144zM511.6 241.2c-8.156-140.9-129.2-248.5-270.4-240.8c-68.27 3.969-130.9 34.25-176.4 85.31s-68.34 116.8-64.39 185c7.344 127 108.4 230.3 234.1 240.4c.6562 .0313 1.305 .0781 1.945 .0781c12.39 0 22.89-9.531 23.89-22.09c1.047-13.22-8.812-24.78-22.02-25.84c-102.9-8.156-184.9-92.13-190.9-195.3C45.14 212.6 63.72 159.2 100.7 117.7c36.95-41.5 87.84-66.13 143.3-69.31c114.5-6.906 213 81.13 219.7 195.6c3.094 53.59-14.31 105.6-49 146.5c-8.578 10.12-7.328 25.25 2.766 33.84c10.11 8.5 25.27 7.297 33.83-2.797C493.1 371.2 515.4 307.1 511.6 241.2z"],
    "face-explode": [512, 512, ["exploding-head"], "e2fe", "M511.5 246.2c-3.521 1.896-9.491 4.147-16.59 4.147c-5.104 0-10.79-1.165-16.57-4.464l-34.38-19.65c-.1299-.0743-3.662-2.267-8.601-2.267c-2.511 0-5.386 .5668-8.362 2.267l-34.38 19.65c-5.39 3.078-11.12 4.458-16.91 4.458C348.5 250.4 320 219.8 320 192c0-17.67 14.33-32 32-32h40c30.93 0 56-25.24 56-56.16s-25.07-55.91-56-55.91c-9.031 0-17.44 2.33-24.99 6.127C362.2 23.42 335.1 0 304 0c-19.22 0-36.27 8.617-48 22.04C244.3 8.617 227.2 0 208 0C176 0 149.8 23.42 144.1 54.05c-7.555-3.797-15.96-6.127-24.99-6.127c-30.93 0-56 24.98-56 55.91S89.07 160 120 160c.9141 0 1.764-.2266 2.666-.2695L160 160c17.67 0 32 14.33 32 32c0 28.12-29.04 58.23-56.06 58.23c-5.708 0-11.33-1.344-16.56-4.334l-34.39-19.65C84.87 226.2 81.33 223.1 76.4 223.1c-2.511 0-5.385 .5668-8.361 2.267l-34.39 19.65C27.87 249.2 22.18 250.4 17.08 250.4c-7.096 0-13.06-2.254-16.59-4.151C.3711 249.5 0 252.7 0 256c0 132.5 100.7 241.5 229.8 254.7C238.4 511.5 247.1 512 256 512s17.59-.5078 26.23-1.33C411.3 497.5 512 388.5 512 256C512 252.7 511.6 249.5 511.5 246.2zM256 464c-131.8 0-193.8-105.6-205.1-173.1c2.236-1.021 4.43-2.146 6.57-3.369l19.05-10.89l19.05 10.89c12.4 7.084 26.5 10.83 40.78 10.83c14.28 0 28.38-3.744 40.78-10.83l19.05-10.89l19.05 10.89C227.6 294.7 241.7 298.4 256 298.4c14.28 0 28.38-3.744 40.78-10.83l19.05-10.89l19.05 10.89c12.4 7.084 26.5 10.83 40.78 10.83c14.28 0 28.38-3.744 40.78-10.83l19.05-10.89l19.06 10.89c2.139 1.223 4.328 2.344 6.562 3.365C449.9 357.9 387.5 464 256 464zM175.1 305.2c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32c17.8 0 32.09-14.25 32.09-32S193.8 305.2 175.1 305.2zM256 368c-26.51 0-48 21.49-48 48c0 8.836 7.164 16 16 16h64c8.836 0 16-7.164 16-16C304 389.5 282.5 368 256 368zM336 305.2c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 305.2 336 305.2z"],
    "face-expressionless": [512, 512, [], "e373", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM352 328H160c-13.25 0-24 10.75-24 24S146.8 376 160 376h192c13.25 0 24-10.75 24-24S365.3 328 352 328zM368 192h-64C295.2 192 288 199.2 288 208S295.2 224 304 224h64C376.8 224 384 216.8 384 208S376.8 192 368 192zM208 224C216.8 224 224 216.8 224 208S216.8 192 208 192h-64C135.2 192 128 199.2 128 208S135.2 224 144 224H208z"],
    "face-eyes-xmarks": [512, 512, [], "e374", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM374.6 208l28.69-28.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L352 185.4l-28.69-28.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L329.4 208l-28.69 28.69c-6.25 6.25-6.25 16.38 0 22.62C303.8 262.4 307.9 264 312 264s8.188-1.562 11.31-4.688L352 230.6l28.69 28.69C383.8 262.4 387.9 264 392 264s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L374.6 208zM200 264c4.094 0 8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L182.6 208l28.69-28.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L160 185.4L131.3 156.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L137.4 208L108.7 236.7c-6.25 6.25-6.25 16.38 0 22.62C111.8 262.4 115.9 264 120 264s8.188-1.562 11.31-4.688L160 230.6l28.69 28.69C191.8 262.4 195.9 264 200 264zM261.1 304H250.9c-46.65 0-85.21 36.67-90.83 84C159.3 394.4 164.1 400 170.2 400h171.7c6.082 0 10.86-5.666 10.09-12C346.3 340.7 307.7 304 261.1 304z"],
    "face-fearful": [512, 512, [], "e375", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208c0-43.46 13.44-83.81 36.33-117.2c.1406 .1523 .1836 .3535 .3301 .502C87.78 142.4 91.88 144 96.01 144c4.062 0 8.133-1.531 11.26-4.594C107.5 139.1 135.6 112 176 112c8.844 0 16-7.141 16-15.98s-7.156-16-16-16c-15.26 0-28.85 2.938-40.84 7.002C169.3 62.57 210.9 48 256 48c45.04 0 86.67 14.54 120.8 38.97C364.8 82.92 351.2 80 336 80C327.2 80 320 87.16 320 96s7.156 16 16 16c40.42 0 68.45 27.09 68.73 27.38C407.9 142.5 411.9 144 416 144c4.094 0 8.188-1.562 11.31-4.688c.1582-.1582 .207-.375 .3574-.5391C450.6 172.2 464 212.5 464 256C464 370.7 370.7 464 256 464zM159.9 200C146.7 200 135.1 210.7 135.1 224s10.71 24 23.96 24C173.3 248 183.1 237.3 183.1 224S173.3 200 159.9 200zM240 224c0-44.38-35.86-80-80.05-80c-44.5 0-80.08 35.63-80.08 80s35.58 80 80.08 80C204.2 304 240 268.4 240 224zM159.1 272C133.3 272 111.9 250.6 111.9 224s21.33-48 48.04-48C186.5 176 208 197.4 208 224S186.5 272 159.1 272zM352 200c-13.25 0-24 10.69-24 24S338.8 248 352 248c13.34 0 24-10.69 24-24S365.3 200 352 200zM352.1 144c-44.5 0-80.21 35.63-80.21 80s35.7 80 80.21 80c44.2 0 79.93-35.63 79.93-80S396.3 144 352.1 144zM352.1 272c-26.7 0-48.16-21.38-48.16-48s21.46-48 48.16-48c26.52 0 47.95 21.38 47.95 48S378.6 272 352.1 272zM256 320c-44.11 0-80 35.88-80 80C176 408.8 183.2 416 192 416h128c8.844 0 16-7.156 16-16C336 355.9 300.1 320 256 320z"],
    "face-flushed": [512, 512, [62841, "flushed"], "1f633", "M352 152c-39.79 0-72.05 32.17-72.05 72c0 39.82 32.26 72 72.05 72c39.79 0 71.93-32.18 71.93-72C423.1 184.2 391.8 152 352 152zM352.1 264C329.1 264 312 246.1 312 224c0-22.06 17.97-40 40.05-40C374.1 184 392 201.9 392 224C392 246.1 374.1 264 352.1 264zM159.1 200c-13.33 0-23.98 10.75-23.98 24s10.65 24 23.98 24S183.1 237.3 183.1 224S173.3 200 159.1 200zM231.1 224c0-39.83-32.23-72-72.02-72c-39.79 0-71.97 32.17-71.97 72c0 39.82 32.18 72 71.97 72C199.8 296 231.1 263.8 231.1 224zM160.1 264C137.1 264 120 246.1 120 224c0-22.06 17.97-40 40.05-40C182.1 184 200 201.9 200 224C200 246.1 182.1 264 160.1 264zM312 335.1H199.1c-13.2 0-23.98 10.75-23.98 24s10.78 24 23.98 24h112.1c13.2 0 23.98-10.75 23.98-24S325.2 335.1 312 335.1zM352 200c-13.33 0-23.98 10.75-23.98 24s10.65 24 23.98 24S375.1 237.3 375.1 224S365.3 200 352 200zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-frown": [512, 512, [61721, "frown"], "2639", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM175.1 240c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32S158.3 240 175.1 240zM336 240c17.68 0 31.97-14.25 31.97-32s-14.29-32-31.97-32c-17.8 0-32.09 14.25-32.09 32S318.2 240 336 240zM256 272c-86.31 0-121.2 65.16-127.6 99.63C126 384.6 134.5 396.1 147.5 399.5c12.81 2.438 25.5-6 28.09-18.91C176.8 374.4 189.7 320 256 320s79.19 54.38 80.41 60.38C338.5 391.9 348.6 400 359.1 400c1.469 0 2.938-.125 4.406-.4062c13.03-2.406 21.62-14.94 19.22-27.97C377.2 337.2 342.3 272 256 272z"],
    "face-frown-open": [512, 512, [62842, "frown-open"], "1f626", "M256 288c-35.6 0-88.76 21.25-95.79 61.25c-2.059 11.75 8.961 21.5 20.46 18C211.9 357.8 240.1 352 256 352s44.08 5.75 75.32 15.25c11.38 3.5 22.52-6.25 20.46-18C344.8 309.3 291.6 288 256 288zM208 208c0-17.75-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32C193.8 240 208 225.8 208 208zM336 176c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 176 336 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-frown-slight": [512, 512, [], "e376", "M256 304c-40.2 0-77.98 17.75-103.8 48.63c-8.477 10.12-7.145 25.25 3.027 33.75c10.29 8.375 25.31 7.125 33.91-3.125C205.7 363.4 230.1 352 255.1 352s50.28 11.25 66.87 31.25c8.113 9.75 23.13 12 33.91 3.125c10.17-8.5 11.5-23.62 3.027-33.75C333.1 321.8 296.2 304 256 304zM175.1 240c17.8 0 32.02-14.25 32.02-32s-14.22-32-32.02-32c-17.68 0-31.99 14.25-31.99 32S158.3 240 175.1 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM336 176c-17.8 0-32.02 14.25-32.02 32s14.22 32 32.02 32c17.68 0 31.99-14.25 31.99-32S353.7 176 336 176z"],
    "face-glasses": [576, 512, [], "e377", "M384 192c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C416 206.3 401.7 192 384 192zM544 176C544 167.2 536.8 160 528 160h-2.783C487.2 66.22 395.4 0 288 0S88.78 66.22 50.78 160H48C39.16 160 32 167.2 32 176c0 6.236 3.664 11.5 8.871 14.14C35.27 211.2 32 233.2 32 256c0 141.4 114.6 256 256 256s256-114.6 256-256c0-22.81-3.271-44.81-8.871-65.86C540.3 187.5 544 182.2 544 176zM288 48c74.8 0 140.3 39.82 176.1 99.25C459.7 145.2 453.1 144 448 144h-96c-9.77 0-18.84 2.969-26.43 8H250.4C242.8 146.1 233.8 144 224 144H128c-5.992 0-11.67 1.234-16.97 3.25C147.7 87.82 213.2 48 288 48zM464 192v64c0 8.812-7.172 16-16 16h-96c-8.828 0-16-7.188-16-16V192c0-8.812 7.172-16 16-16h96C456.8 176 464 183.2 464 192zM240 192v64c0 8.812-7.172 16-16 16H128C119.2 272 112 264.8 112 256V192c0-8.812 7.172-16 16-16h96C232.8 176 240 183.2 240 192zM288 464c-114.7 0-208-93.31-208-208c0 26.47 21.53 48 48 48h96c26.47 0 48-21.53 48-48V192c0-2.74-.3652-5.385-.8086-8h33.62C304.4 186.6 304 189.3 304 192v64c0 26.47 21.53 48 48 48h96c26.47 0 48-21.53 48-48C496 370.7 402.7 464 288 464zM192 192C174.3 192 160 206.3 160 224c0 17.67 14.33 32 32 32s32-14.33 32-32C224 206.3 209.7 192 192 192zM378.2 341.7C355.8 368.5 323 383.9 288 383.9s-67.82-15.33-90.2-42.22c-13.62-16.2-38.16 4.203-24.57 20.5C201.7 396.4 243.5 415.1 288 415.1s86.31-19.56 114.8-53.76C416.3 345.9 391.6 325.5 378.2 341.7z"],
    "face-grimace": [512, 512, [62847, "grimace"], "1f62c", "M336.1 240c17.68 0 31.95-14.25 31.95-32s-14.27-32-31.95-32c-17.8 0-32.07 14.25-32.07 32S318.3 240 336.1 240zM335.1 272H176c-26.48 0-47.95 21.47-47.95 47.95L128 336c0 26.51 21.51 48 48.02 48h159.9c26.51 0 48.02-21.49 48.02-48L383.1 320C383.1 293.5 362.5 272 335.1 272zM184 352H176c-8.822 0-15.98-7.178-15.98-16L160 319.1C160 311.2 167.2 304 176 304h8V352zM240 352H216l.026-48H240V352zM296 352H272V304h23.97L296 352zM351.1 336c0 8.822-7.154 16-15.98 16H328V304h7.953c8.822 0 16.02 7.178 16.02 16L351.1 336zM175.9 240c17.8 0 32.07-14.25 32.07-32s-14.27-32-32.07-32c-17.68 0-31.95 14.25-31.95 32S158.3 240 175.9 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin": [512, 512, [62848, "grin"], "1f600", "M336 240c17.68 0 31.97-14.25 31.97-32s-14.29-32-31.97-32c-17.8 0-32.09 14.25-32.09 32S318.2 240 336 240zM175.1 240c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32S158.3 240 175.1 240zM361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.5 301.5 131 310 132.7 319.9c7.871 47.13 71.32 80 123.3 80s115.3-32.88 123.3-80C380.8 310.1 371.6 301.5 361.6 304.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-beam": [512, 512, [62850, "grin-beam"], "1f604", "M144.5 210.9c7.75-13.75 19.25-21.62 31.48-21.62c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 231.7 223.2 232.8 226.3 231.8c3.512-1.125 5.934-4.5 5.691-8.375C228.8 181.3 199.8 152 175.1 152c-23.73 0-52.54 29.25-55.81 71.38C119.8 227.1 122.1 230.6 125.7 231.8c3.512 1 7.459-.575 9.397-3.825L144.5 210.9zM361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.6 301.5 131 309.9 132.7 319.9c7.871 47.13 71.32 80 123.3 80s115.3-32.88 123.3-80C380.8 310.1 371.6 301.5 361.6 304.6zM336 152c-23.86 0-52.64 29.25-55.91 71.38c-.2422 3.75 2.034 7.25 5.546 8.375c3.512 1 7.459-.575 9.397-3.825l9.494-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.81 7.875 31.56 21.62l9.445 17c2.18 3.75 6.103 4.825 9.252 3.825c3.633-1.125 6.055-4.5 5.691-8.375C388.7 181.3 359.8 152 336 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-beam-sweat": [512, 512, [62851, "grin-beam-sweat"], "1f605", "M256 400c51.95 0 115.3-32.88 123.3-80c1.695-9.875-7.629-18.5-17.68-15.25C335.7 313 297.2 317.8 256 317.8S176.4 313 150.4 304.8C140.6 301.6 131 310 132.7 320C140.7 367.1 204.1 400 256 400zM176 189.3c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 231.7 223.2 232.8 226.3 231.8c3.512-1.125 5.934-4.5 5.691-8.375C228.8 181.3 199.8 152 175.1 152c-23.73 0-52.54 29.25-55.81 71.38C119.8 227.1 122.1 230.6 125.7 231.8c3.512 1 7.459-.575 9.397-3.825l9.445-17C152.3 197.2 163.8 189.3 176 189.3zM391.1 223.4c-3.27-42.13-32.22-71.37-55.96-71.37c-23.86 0-52.64 29.25-55.91 71.37c-.2422 3.75 2.034 7.25 5.546 8.375c3.512 1 7.459-.575 9.397-3.825l9.494-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.81 7.875 31.56 21.62l9.446 17c2.18 3.625 6.103 4.7 9.252 3.825C389.9 230.6 392.4 227.3 391.1 223.4zM456 176c-2.857 0-5.557-.5547-8.346-.8125C458.2 200 464 227.4 464 256c0 114.7-93.31 208-208 208S48 370.7 48 256S141.3 48 256 48c41.9 0 80.88 12.56 113.6 33.96c1.953-12.64 7.857-27.72 17.9-45.33C348.1 13.53 304.1 .0002 256 .0002C114.6 .0002 0 114.6 0 256s114.6 255.1 256 255.1S512 397.4 512 256c0-31.53-5.975-61.6-16.4-89.49C483.6 172.4 470.3 176 456 176zM456 144C486.9 144 512 120.4 512 91.14c0-22.5-33.31-67.91-48.54-87.45c-3.732-4.922-11.2-4.922-14.93 0C433.2 23.23 400 68.64 400 91.14C400 120.4 425.1 144 456 144z"],
    "face-grin-hearts": [512, 512, [62852, "grin-hearts"], "1f60d", "M361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.6 301.5 131 309.9 132.7 319.9c7.871 47.25 71.32 80 123.3 80s115.3-32.88 123.3-80C380.8 310.1 371.6 301.5 361.6 304.6zM352.8 168.4L345.6 170.3l-2.059-7c-4.965-18.12-22.77-31-41.41-28c-21.43 3.5-34.39 24.25-28.82 44.5l19.38 70c1.211 4.5 5.934 7.125 10.54 6l70.11-18.25c20.46-5.25 31.97-26.88 24.22-47.13C390.9 172.8 370.9 163.8 352.8 168.4zM208.8 255.8c4.48 1.125 9.203-1.5 10.54-6l19.38-70c5.57-20.25-7.387-41-28.82-44.5c-18.53-3-36.33 9.875-41.41 28l-2.059 7L159.2 168.4c-18.16-4.625-38.14 4.375-44.8 22C106.7 210.6 118.2 232.3 138.7 237.6L208.8 255.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-squint": [512, 512, [62853, "grin-squint"], "1f606", "M361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.5 301.5 131 310 132.7 319.9c7.871 47.13 71.32 80 123.3 80s115.3-32.88 123.3-80C380.8 310.1 371.6 301.5 361.6 304.6zM142.2 266.3l80.04-48C225.8 216.1 228 212.3 228 208S225.8 199.9 222.2 197.8l-80.04-48c-5.086-3-11.38-2-15.26 2.5c-3.754 4.5-3.754 11-.121 15.5L160.5 208l-33.66 40.25c-3.754 4.5-3.633 11.12 .121 15.5C130.5 268 136.8 269.5 142.2 266.3zM385.1 152.3c-3.754-4.5-10.17-5.5-15.26-2.5l-80.04 48C286.2 199.9 283.1 203.8 283.1 208s2.18 8.125 5.813 10.25l80.04 48C375.2 269.5 381.5 268 385.1 263.8c3.754-4.5 3.754-11 .1212-15.5L351.5 208l33.66-40.25C388.1 163.3 388.8 156.8 385.1 152.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-squint-tears": [512, 512, [62854, "grin-squint-tears"], "1f923", "M364.9 215.8c-12.25 24.25-36.13 54.74-65.26 83.86c-29.13 29.12-59.76 52.87-83.89 65.37c-9.252 4.75-10 17.5-1.752 23.37c38.88 27.75 107 6.248 143.8-30.62c36.63-36.75 58.26-104.7 30.5-143.6C382.5 205.9 369.8 206.5 364.9 215.8zM247.6 211.1l90.52-22.62c5.627-1.373 9.502-6.748 9.127-12.62c-.5-5.748-5.127-10.5-11-10.1l-52.26-4.75l-4.75-52.37c-.5-5.75-5.25-10.37-11-10.87C262.6 96.77 257 100.3 255.6 106L232.1 196.5c-1 4.125 .25 8.373 3.25 11.37C241.2 212.9 247.5 211.1 247.6 211.1zM207.9 236.3c-3-3-7.127-4.25-11.38-3.25L105.1 255.8c-5.75 1.375-9.502 6.623-9.127 12.5c.5 5.873 5.127 10.5 10.88 10.1L160.1 284.1l4.75 52.24c.5 5.875 5.252 10.37 11 10.87h.875c5.502 0 10.38-3.623 11.75-8.998l22.63-90.49C212.1 243.5 210.9 239.3 207.9 236.3zM394.9 127.9c25.88-3.625 84.01-13.62 100.9-30.62c22-21.87 21.5-57.87-.877-80.24c-22.38-22.37-58.26-22.75-80.26-.875c-16.88 16.87-26.88 75.12-30.63 100.9C383.3 123.4 388.6 128.8 394.9 127.9zM75.45 358.9C58.07 328.5 48 293.4 48 256c0-114.7 93.31-208 208-208c37.46 0 72.56 10.1 102.1 27.5c4.295-20.62 8.787-35.96 13.14-47.46C337.2 10.24 297.8 0 256 0C114.6 0 0 114.6 0 256c0 41.79 10.22 81.13 27.98 115.1C39.5 367.6 54.83 363.1 75.45 358.9zM484 140c-11.51 4.391-26.85 8.895-47.46 13.12C453.9 183.5 464 218.6 464 256c0 114.7-93.31 208-208 208c-37.46 0-72.56-10.1-102.1-27.5c-4.295 20.62-8.787 35.96-13.14 47.46C174.8 501.8 214.2 512 256 512c141.4 0 256-114.6 256-256C512 214.2 501.8 174.9 484 140zM117.1 384.1c-25.88 3.625-84.01 13.62-100.9 30.62c-22 21.87-21.5 57.87 .877 80.24c22.38 22.37 58.26 22.75 80.26 .875c16.88-16.87 26.88-75.12 30.63-100.9C128.7 388.6 123.4 383.2 117.1 384.1z"],
    "face-grin-stars": [512, 512, [62855, "grin-stars"], "1f929", "M133.7 247.1C132.7 253.3 139.1 258.1 144.7 255l31.24-16.25L207.3 255C212.9 258.1 219.3 253.3 218.3 247.1l-6.055-34.88l25.43-24.62c4.48-4.5 1.938-12.25-4.359-13.25l-34.88-5l-15.5-31.62C180.1 132 171.1 132 169.1 137.8L153.6 169.4l-34.88 5C112.5 175.3 109.8 183 114.4 187.6l25.31 24.62L133.7 247.1zM361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.6 301.5 131 309.9 132.7 319.9C140.6 367.1 204.1 399.9 256 399.9s115.3-32.94 123.3-80.06C380.8 310.1 371.6 301.5 361.6 304.6zM393.4 174.4l-34.1-5l-15.5-31.62c-2.785-5.75-10.9-5.75-13.8 0l-15.5 31.62l-34.1 5c-6.176 .875-8.84 8.625-4.238 13.25l25.43 24.62l-6.055 34.88c-.9687 6.125 5.449 11 11.02 7.875l31.24-16.25L367.4 255c5.57 3.125 11.99-1.75 11.02-7.875l-6.055-34.88l25.43-24.62C402.3 183 399.6 175.4 393.4 174.4zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-tears": [640, 512, [62856, "grin-tears"], "1f602", "M456 223.4C452.8 181.3 423.8 152 400 152c-23.75 0-52.66 29.25-55.91 71.38c-.25 3.75 2.077 7.25 5.702 8.375c3.5 1 7.364-.575 9.239-3.825l9.481-17c7.75-13.75 19.24-21.62 31.49-21.62c12.25 0 23.81 7.875 31.56 21.62l9.457 17c2.125 3.625 6.236 4.7 9.237 3.825C453.9 230.6 456.3 227.3 456 223.4zM240 189.3c12.25 0 23.74 7.875 31.49 21.62l9.554 17C283.2 231.7 287.2 232.8 290.2 231.8c3.627-1.125 6.098-4.5 5.848-8.375C292.8 181.3 263.7 152 239.1 152c-23.75 0-52.57 29.25-55.82 71.38C183.9 227.1 186.1 230.6 189.7 231.8c3.5 1 7.51-.575 9.385-3.825l9.457-17C216.3 197.2 227.8 189.3 240 189.3zM319.1 400c51.88 0 115.3-32.88 123.3-80c1.75-9.875-7.625-18.5-17.63-15.25c-25.88 8.25-64.38 13-105.6 13S240.4 313 214.4 304.8C204.6 301.6 194.1 310 196.7 320C204.7 367.1 268.1 400 319.1 400zM623.8 286.8c-16.88-17-75.01-27-100.9-30.62c-6.252-.875-11.63 4.5-10.75 10.75c3.625 25.88 13.63 84 30.63 100.9c21.88 22 57.88 21.5 80.26-.875C645.3 344.6 645.8 308.6 623.8 286.8zM117.1 256.1c-25.88 3.625-84.01 13.62-100.9 30.62c-22 21.88-21.5 57.88 .875 80.25s58.26 22.75 80.26 .875C114.2 351 124.2 292.8 127.1 267C128.7 260.6 123.3 255.3 117.1 256.1zM114.7 224.2C130.1 124.6 216.2 48 320 48c103.9 0 189.9 76.59 205.3 176.2l2.004 .2285c18.93 2.648 34.16 5.637 47.53 8.713C563.3 102.5 453.7 0 320 0C186.3 0 76.73 102.5 65.15 233.1c13.36-3.074 28.58-6.059 47.5-8.707L114.7 224.2zM500.9 358.3C465.1 421.3 397.5 464 320 464c-77.53 0-145.2-42.71-180.9-105.8c-8.195 20.89-15.6 28.76-19.1 32.26c-3.596 3.572-7.549 6.629-11.61 9.486C154.4 467.6 232 512 320 512c88.02 0 165.6-44.45 211.7-112.1c-4.074-2.883-8.029-5.977-11.62-9.584C516.6 386.9 509.1 378.1 500.9 358.3z"],
    "face-grin-tongue": [512, 512, [62857, "grin-tongue"], "1f61b", "M175.1 176c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32c17.8 0 32.09-14.25 32.09-32S193.8 176 175.1 176zM256 0C114.6 0 0 114.6 0 256c0 140.6 113.3 254.6 253.6 255.9c.3672 .0098 .707 .1113 1.074 .1172c.1484 0 .2656-.0163 .4141-.0163C255.4 511.1 255.8 512 256.1 512C397.5 512 512 397.4 512 256S397.4 0 256 0zM320.1 416c0 35.63-29.18 64.5-64.91 64c-35.12-.5-63.21-29.75-63.21-65v-50.75l17.8-8.875c15.02-7.5 31.48 1.75 34.88 16.5l2.785 12.12c2.059 9.25 15.26 9.25 17.32 0l2.785-12.12c3.391-14.75 19.74-24.12 34.88-16.5l17.68 8.875V416zM351.9 440.4l.1602-75.92c14.15-12.37 24.31-27.48 27.21-44.47c1.695-9.875-7.629-18.5-17.68-15.25C335.7 313 297.2 317.8 256 317.8s-79.56-4.75-105.6-13C140.5 301.6 131 310 132.7 320c2.904 16.99 13.07 32.1 27.21 44.47l.1699 75.92C93.58 405.7 48 336.1 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 336.1 418.4 405.6 351.9 440.4zM336 176c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 176 336 176z"],
    "face-grin-tongue-squint": [512, 512, [62858, "grin-tongue-squint"], "1f61d", "M385.1 152.3c-3.754-4.5-10.29-5.5-15.26-2.5l-80.04 48C286.2 199.9 283.1 203.8 283.1 208s2.18 8.125 5.812 10.25l80.04 48C375.2 269.5 381.5 268 385.1 263.8c3.754-4.5 3.754-11 .1211-15.5L351.5 208l33.66-40.25C388.1 163.3 388.8 156.6 385.1 152.3zM256 0C114.6 0 0 114.6 0 256c0 140.6 113.3 254.6 253.6 255.9c.3672 .0098 .707 .1113 1.074 .1172c.1484 0 .2656-.0163 .4141-.0163C255.4 511.1 255.8 512 256.1 512C397.5 512 512 397.4 512 256S397.4 0 256 0zM320.1 416c0 35.63-29.18 64.5-64.91 64c-35.12-.5-63.21-29.75-63.21-65v-50.75l17.8-8.875c15.02-7.5 31.48 1.75 34.88 16.5l2.785 12.12c2.059 9.25 15.26 9.25 17.32 0l2.785-12.12c3.391-14.75 19.74-24.12 34.88-16.5l17.68 8.875V416zM351.9 440.4l.1406-75.91c14.15-12.37 24.31-27.48 27.21-44.47c1.695-9.875-7.629-18.5-17.68-15.25C335.7 313 297.2 317.8 256 317.8s-79.56-4.75-105.6-13C140.5 301.6 131 310 132.7 320c2.904 16.99 13.07 32.1 27.21 44.47l.1504 75.91C93.57 405.6 48 336.1 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 336.1 418.4 405.6 351.9 440.4zM142.2 149.8c-4.965-3-11.38-2-15.26 2.5c-3.754 4.5-3.754 11-.1211 15.5L160.5 208l-33.66 40.25c-3.754 4.5-3.633 11 .1211 15.5C130.5 268 136.8 269.5 142.2 266.3l80.04-48C225.8 216.1 228 212.3 228 208S225.8 199.9 222.2 197.8L142.2 149.8z"],
    "face-grin-tongue-wink": [512, 512, [62859, "grin-tongue-wink"], "1f61c", "M159.1 180c-25.67 0-55.82 16.88-59.82 42.13c-.7266 5 1.695 10 6.176 12.38c4.359 2.375 9.93 1.75 13.68-1.625l9.445-8.5c14.89-13.12 46.26-13.12 61.03 0l9.566 8.5C202.5 235.1 208 237.6 213.7 234.5c4.359-2.375 6.902-7.375 6.055-12.38C215.9 196.9 185.6 180 159.1 180zM256 0C114.6 0 0 114.6 0 256c0 140.6 113.3 254.6 253.6 255.9c.3672 .0098 .707 .1113 1.074 .1172c.1484 0 .2656-.0163 .4141-.0163C255.4 511.1 255.8 512 256.1 512C397.5 512 512 397.4 512 256S397.4 0 256 0zM320.1 416c0 35.63-29.18 64.5-64.91 64c-35.12-.5-63.21-29.75-63.21-65v-50.75l17.8-8.875c15.02-7.5 31.48 1.75 34.88 16.5l2.785 12.12c2.059 9.25 15.26 9.25 17.32 0l2.785-12.12c3.391-14.75 19.74-24.12 34.88-16.5l17.68 8.875V416zM352 440.3l.0586-75.87c14.15-12.37 24.31-27.48 27.21-44.47c1.695-9.875-7.629-18.5-17.68-15.25C335.7 313 297.2 317.8 256 317.8s-79.56-4.75-105.6-13C140.5 301.6 131 310 132.7 320c2.904 16.99 13.07 32.1 27.21 44.47L160 440.3C93.53 405.6 48 336.1 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 336.1 418.5 405.6 352 440.3zM336 128C291.8 128 256 163.8 256 208c0 44.25 35.84 80 80.04 80S415.1 252.3 415.1 208C415.1 163.8 380.2 128 336 128zM336 256c-26.52 0-48.07-21.5-48.07-48S309.5 160 336 160c26.4 0 47.95 21.5 47.95 48S362.4 256 336 256zM336 184c-13.32 0-24.04 10.75-24.04 24s10.72 24 24.04 24c13.2 0 23.97-10.75 23.97-24S349.2 184 336 184z"],
    "face-grin-wide": [512, 512, [62849, "grin-alt"], "1f603", "M208.3 248C220.6 229.3 223.4 210.8 224 192c-.4844-18.75-3.391-37.25-15.74-56c-7.992-12-25.07-11.38-32.7 0C163.2 154.8 160.5 173.3 159.9 192c.6055 18.75 3.391 37.25 15.74 56C183.7 260 200.8 259.4 208.3 248zM361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.5 301.5 131 309.9 132.7 319.9c7.871 47.25 71.32 80 123.3 80s115.3-32.88 123.3-80C380.8 310.1 371.6 301.5 361.6 304.6zM336.1 248c12.47-18.75 15.28-37.25 15.88-56c-.4844-18.75-3.412-37.25-15.88-56c-7.992-12-24.92-11.38-32.55 0C291.2 154.8 288.5 173.3 287.8 192c.6055 18.75 3.391 37.25 15.74 56C311.7 260 328.6 259.4 336.1 248zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-wink": [512, 512, ["grin-wink"], "f58c", "M175.9 240c17.68 0 32.07-14.38 32.07-32s-14.39-32-32.07-32s-31.95 14.38-31.95 32S158.3 240 175.9 240zM361.6 304.6C335.7 313 297.2 317.8 256 317.8S176.3 313 150.4 304.6C140.5 301.5 131 310 132.7 320C140.7 367.1 204.1 400 256 400s115.3-32.88 123.3-80C380.1 310.1 371.6 301.5 361.6 304.6zM336 180.1c-25.79 0-55.85 16.88-59.85 42.13c-1.695 11.25 11.41 18.16 19.77 10.78l9.566-8.5c14.77-13.25 46.23-13.25 61 0L376 233c8.477 7.375 21.65 .3438 19.95-10.78C391.1 196.1 361.7 180.1 336 180.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-hand-over-mouth": [512, 512, [], "e378", "M368 208c0-17.75-14.29-32-31.97-32c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32C353.7 240 368 225.8 368 208zM208 208c0-17.75-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32C193.8 240 208 225.8 208 208zM165 384.8C165 384.8 165 384.8 165 384.8C165 384.8 165 384.8 165 384.8S165 384.8 165 384.8zM372.8 373.8c11.44-17.18 9.582-40.66-5.561-55.8c-1.098-1.098-2.244-2.133-3.434-3.1c-.4121-10.76-4.715-21.39-12.91-29.58c-7.955-7.957-18.41-12.51-29.6-12.93c-.9609-1.18-1.988-2.318-3.08-3.41C309.8 260.6 298.7 256 286.9 256c-11.82 0-22.94 4.604-31.29 12.97l-31.22 31.22C217.1 292.3 207.1 286.7 195.6 285.1C193.4 284.7 191.1 284.6 188.8 284.6c-23.9 0-44.44 17.88-47.8 41.58l-7.623 54.18c-4.613 27.71 1.1 56.92 16.21 81.46C168.9 493.2 202.5 512 239.4 512c29.27 0 56.79-11.4 77.48-32.1l50.31-50.31C382.3 414.4 384.2 390.1 372.8 373.8zM303.2 413.6l24.02-24.02c2.395-2.395 5.529-3.59 8.664-3.59c3.137 0 6.271 1.195 8.666 3.59c4.787 4.787 4.787 12.54 0 17.33l-50.31 50.31C279.6 471.9 260.1 480 239.4 480c-25.71 0-49.12-13.08-62.6-34.98c-11.05-17.96-15.23-39.4-11.77-60.22c.002-.0039 0 .0059 0 0c0 0-.002 0 0 0c0-.0039 0 0 0 0c0-.0098 0 0 0 0s.002-.0176 0 0l7.62-54.16c1.15-8.129 8.064-14.06 16.1-14.06c.7793 0 1.57 .0566 2.365 .1719C200.1 318 206.3 326.3 205 335.2l-4.865 34.43l78.06-78.06C280.6 289.2 283.7 288 286.9 288c3.137 0 6.271 1.197 8.666 3.59c4.787 4.787 4.787 12.54 0 17.33l-48.53 48.53l7.182 7.18l56.7-56.7c2.393-2.395 5.529-3.592 8.664-3.592c3.137 0 6.271 1.197 8.664 3.592c4.787 4.787 4.787 12.54 0 17.33l-56.7 56.7l7.18 7.182l48.53-48.53c2.395-2.395 5.529-3.592 8.664-3.592c3.137 0 6.271 1.197 8.666 3.592c4.787 4.787 4.787 12.54 0 17.33l-48.53 48.53L303.2 413.6zM256 0C114.6 0 0 114.6 0 256c0 90.95 47.57 170.6 119 216c-13.34-24.23-19.69-51.24-18.62-78.45C67.91 356.9 48 308.8 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208c0 52.66-19.83 100.7-52.21 137.3c1.354 21.33-6.076 42.95-21.98 58.87l-42.82 42.83C443.4 458.3 512 365.3 512 256C512 114.6 397.4 0 256 0z"],
    "face-hand-yawn": [512, 512, [], "e379", "M127.1 215.3c7.312 0 14.5-3.312 19.22-9.594C165.5 181.4 189.8 162.1 217.6 150C229.8 144.7 235.3 130.5 230 118.4C224.7 106.2 210.5 100.7 198.4 106C163 121.4 132.1 145.1 108.8 176.9C100.8 187.5 103 202.6 113.6 210.5C117.9 213.8 122.1 215.3 127.1 215.3zM364.8 205.8c4.719 6.281 11.91 9.594 19.22 9.594c5 0 10.06-1.562 14.38-4.812c10.62-7.969 12.75-23 4.781-33.59c-23.28-30.97-54.25-55.5-89.59-70.94C301.5 100.7 287.3 106.2 282 118.4C276.7 130.5 282.3 144.7 294.4 150C322.2 162.1 346.5 181.4 364.8 205.8zM145.4 364.3C145.4 364.3 145.5 364.3 145.4 364.3C145.4 364.3 145.4 364.3 145.4 364.3S145.4 364.3 145.4 364.3zM389.3 350.9C396.2 342.5 400 332.1 400 321.1c0-12.53-4.875-24.3-13.73-33.16c-1.924-1.924-3.977-3.655-6.156-5.194c.3594-12.46-4.217-25.04-13.7-34.52c-8.854-8.857-20.63-13.74-33.16-13.74c-.459 0-.916 .0059-1.375 .0195c-1.535-2.17-3.267-4.225-5.185-6.143c-8.859-8.859-20.63-13.74-33.16-13.74c-10.75 0-20.82 3.778-29.09 10.4C261.6 224.8 258.9 224 256 224C231.5 224 209.4 235 192.6 252.7C189.1 251.4 185.5 250.5 181.6 249.9C179.2 249.6 176.7 249.4 174.3 249.4c-25.63-.002-47.66 19.18-51.25 44.61L113.8 359.8c-5.363 32.22 1.251 66.02 18.74 94.43C154.8 490.4 193.4 512 235.8 512c33.73 0 65.44-13.14 89.29-36.1l61.14-61.14C403.5 396.7 404.5 369.3 389.3 350.9zM145.4 364.3C145.4 364.3 145.5 364.3 145.4 364.3C145.4 364.3 145.5 364.3 145.4 364.3C145.5 364.3 145.4 364.3 145.4 364.3zM313.4 399.4l29.19-29.19c2.91-2.908 6.721-4.363 10.53-4.363s7.621 1.455 10.53 4.363c5.818 5.818 5.818 15.24 0 21.06l-61.15 61.15C284.7 470.2 261 480 235.8 480c-31.24 0-59.69-15.89-76.08-42.51c-13.44-21.82-18.51-47.89-14.3-73.2c.002-.002 0 .0059 0 0c0 0-.002 .0039 0 0l9.261-65.81c1.311-9.258 8.838-15.93 17.8-16.76c0 .002 0-.002 0 0c.6113-.0215 1.146-.3252 1.761-.3252c.9473 0 1.908 .0684 2.875 .209c10.86 1.541 18.42 11.59 16.89 22.45l-5.914 41.84L283 251c2.908-2.91 6.719-4.363 10.53-4.363c1.957 0 3.699 .8555 5.609 1.094c1.789 .7285 3.469 1.816 4.922 3.27c5.818 5.818 5.818 15.24 0 21.06l-58.98 58.98l8.729 8.727l68.9-68.9c2.91-2.91 6.721-4.364 10.53-4.364s7.621 1.454 10.53 4.364c5.818 5.818 5.818 15.24 0 21.06l-68.9 68.9l8.727 8.729l58.98-58.98c2.91-2.91 6.721-4.364 10.53-4.364s7.621 1.454 10.53 4.364c5.818 5.818 5.818 15.24 0 21.06l-58.97 58.97L313.4 399.4zM256 0C114.6 0 0 114.6 0 255.1c0 81.79 38.58 154.4 98.32 201.2c-13.81-27.81-19.71-58.5-17.12-89.25C60.35 335.6 48 297.3 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208c0 41.44-12.45 79.88-33.46 112.3c3.906 24.2-3.074 49.61-21.66 68.2l-55.39 55.39C446.3 453.5 512 362.7 512 255.1C512 114.6 397.4 0 256 0z"],
    "face-head-bandage": [576, 512, [], "e37a", "M260.4 378.4C269.1 376.8 278.4 376 288 376c52.2 0 78.16 24.16 79.03 24.97C371.7 405.7 377.9 408 384 408s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94C399.4 365.4 361.1 328 288 328c-12.53 0-24.78 1.094-36.38 3.25c-13.03 2.406-21.64 14.94-19.22 27.97S247.4 380.9 260.4 378.4zM198.4 69.08C198.4 69.07 198.3 69.08 198.4 69.08c19.57-9.426 40.65-16.31 63.05-19.18l94.86-40.48C334.5 3.397 311.7 0 288 0C213.7 0 146.1 31.7 100.3 82.26C105.3 81.37 148.5 73.61 198.4 69.08zM541.1 219.4c0 0-38.37-7.838-50.54-10.06C493.1 224.4 496 239.9 496 256c0 114.7-93.31 208-208 208c-92.5 0-171-60.73-197.1-144.4c-5.754 6.967-33.7 44.03-33.7 44.03C97.06 451.1 185.2 512 288 512c141.4 0 256-114.6 256-256C544 243.5 542.8 231.4 541.1 219.4zM533.8 185.1c-7.428-25.78-18.62-49.95-33.24-71.69C436.7 102.2 371.1 96 304 96C224.3 96 146.5 104.3 71.36 120C57.38 142.3 46.79 166.8 40.15 192.9C124.6 171.5 212.1 160 304 160C382.9 160 459.7 168.8 533.8 185.1zM441.5 72.54L448 69.79C429.3 54.43 408.1 41.63 385.1 32l-75.41 32.12C353.2 64.34 397.3 67.24 441.5 72.54zM172.2 200.5C132.1 205.6 92.28 213.1 53.05 222.8C46.13 229.8 38.74 236.3 32.17 243.6C32.16 244.7 32 245.7 32 246.8c0 26.95 5.074 52.73 13.98 76.84C80.76 276 123.4 234.6 172.2 200.5zM216.6 209.7C202.8 218.2 189.5 227.3 176.6 236.1C176.5 238 176 238.9 176 240c0 17.67 14.33 32 32 32s32-14.33 32-32C240 225.4 229.1 213.6 216.6 209.7zM400 240c0-17.67-14.33-32-32-32s-32 14.33-32 32c0 17.67 14.33 32 32 32S400 257.7 400 240z"],
    "face-hushed": [512, 512, [], "e37b", "M175.1 224C158.3 224 143.1 238.3 143.1 256S158.3 288 175.1 288c17.8 0 32.09-14.25 32.09-32S193.8 224 175.1 224zM256 336c-26.51 0-48 21.49-48 48s21.49 48 48 48s48-21.49 48-48S282.5 336 256 336zM208 144C208 135.2 200.8 128 192 128C138 128 102.2 163.2 100.7 164.7C94.47 170.9 94.47 180.1 100.7 187.3C103.8 190.4 107.9 191.1 112 191.1c4.062 0 8.156-1.531 11.25-4.594C123.5 187.1 151.6 160 192 160C200.8 160 208 152.8 208 144zM336 224c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 224 336 224zM411.3 164.7C409.8 163.2 374 128 320 128c-8.844 0-16 7.156-16 16S311.2 160 320 160c40.41 0 68.47 27.09 68.75 27.38C391.8 190.5 395.9 192 400 192c4.094 0 8.188-1.562 11.31-4.688C417.6 181.1 417.6 170.9 411.3 164.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-icicles": [576, 512, [], "e37c", "M287.1 464c-57.46 0-110.1-22.94-150.6-64.56c-9.188-9.594-24.31-10-33.94-.8125c-9.594 9.156-9.969 24.34-.8125 33.94C151.4 483.8 217.3 512 288 512c13.25 0 23.96-10.75 23.96-24S301.2 464 287.1 464zM543.8 252.4C541.8 112.9 427.9 0 288 0C146.9 0 32.02 114.8 32.02 256l13.75 224c.3086 5.096 4.377 9.279 9.602 9.602C61.02 489.9 65.88 485.7 66.23 480l13.77-224c0-114.7 93.3-208 207.1-208c114.7 0 207.1 93.31 207.1 208c0 53.66-20.37 104.6-57.37 143.4c-9.154 9.594-8.779 24.78 .8125 33.94C444.1 437.8 450 440 455.1 440c6.342 0 12.65-2.5 17.37-7.438c11.75-12.34 22.08-25.71 31.03-39.83L509.7 480c.3086 5.096 4.377 9.279 9.602 9.602C524.1 489.9 529.8 485.7 530.2 480c0 0 13.82-214.3 13.82-224c.0508-.9258 .0109-2.002-.0477-2.951C543.9 252.8 543.8 252.6 543.8 252.4zM399.1 208c0-17.75-14.28-32-31.95-32c-17.78 0-32.07 14.25-32.07 32s14.28 32 32.07 32C385.7 240 399.1 225.8 399.1 208zM367.9 272H207.9c-26.48 0-47.95 21.47-47.95 47.95L159.1 336c0 26.51 21.49 48 47.1 48h92.59l9.18 64c.6387 4.422 4.115 8.096 8.762 8.764c5.65 .8105 10.89-3.113 11.7-8.764l9.178-64h28.48c1.209 0 2.322-.2676 3.508-.3555L381.7 480c.5059 4.709 4.227 8.602 9.129 9.129c5.65 .6094 10.72-3.479 11.33-9.129l13.78-128C416.2 350.3 415.9 320 415.9 320C415.9 293.5 394.4 272 367.9 272zM215.9 352H207.1c-8.822 0-15.98-7.178-15.98-16V319.1C191.1 311.2 199.1 304 207.9 304h7.999V352zM271.9 352h-23.1l.0571-48h23.94V352zM303.9 352V304h24.02L327.9 352H303.9zM383.9 336c0 8.822-7.154 16-15.98 16h-7.975V304h7.951c8.822 0 16.05 7.178 16.05 16L383.9 336zM239.1 208c0-17.75-14.28-32-32.07-32c-17.66 0-31.94 14.25-31.94 32s14.28 32 31.94 32C225.7 240 239.1 225.8 239.1 208z"],
    "face-kiss": [512, 512, [62870, "kiss"], "1f617", "M276.9 344.4C298.6 335.3 311.9 321 311.9 308c0-19.25-28.7-41.5-71.45-44C236.7 263.6 233.1 266.4 232.3 270.3C231.4 274 233.4 277.9 236.1 279.4l16.95 7.25c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5l-16.95 7.125c-5.691 2.5-5.934 12.25 0 14.88l16.95 7.125c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5L236.1 409c-3.633 1.5-5.57 5.375-4.723 9.25c.8477 3.5 4.117 6.125 7.871 6.125h.4844c42.75-2.5 71.45-24.75 71.45-44C312.1 367.4 298.7 353.1 276.9 344.4zM175.9 176c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32c17.8 0 32.09-14.25 32.09-32S193.7 176 175.9 176zM336.1 176c-17.8 0-32.07 14.25-32.07 32s14.27 32 32.07 32c17.68 0 31.95-14.25 31.95-32S353.7 176 336.1 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-kiss-beam": [512, 512, [62871, "kiss-beam"], "1f619", "M176 152c-23.73 0-52.67 29.25-55.94 71.38C119.7 227.1 121.9 230.6 125.6 231.8c3.512 1 7.58-.575 9.397-3.825l9.445-17c7.75-13.75 19.18-21.62 31.53-21.62c12.23 0 23.73 7.875 31.48 21.62l9.518 17c2.059 3.75 6.103 4.825 9.252 3.825c3.633-1.125 5.934-4.5 5.57-8.375C228.8 181.3 199.9 152 176 152zM276.9 344.4C298.6 335.3 311.9 321 311.9 308c0-19.25-28.7-41.5-71.45-44C236.7 263.6 233.1 266.4 232.3 270.3C231.4 274 233.4 277.9 236.1 279.4l16.95 7.25c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5l-16.95 7.125c-5.691 2.5-5.934 12.25 0 14.88l16.95 7.125c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5L236.1 409c-3.633 1.5-5.57 5.375-4.723 9.25c.8477 3.5 4.117 6.125 7.871 6.125h.4844c42.75-2.5 71.45-24.75 71.45-44C312.1 367.4 298.7 353.1 276.9 344.4zM336 152c-23.86 0-52.72 29.25-55.99 71.38c-.2422 3.75 1.986 7.25 5.498 8.375c3.512 1 7.58-.575 9.397-3.825l9.566-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.73 7.875 31.48 21.62l9.445 17c2.18 3.75 6.224 4.825 9.252 3.825c3.633-1.125 5.934-4.5 5.57-8.375C388.7 181.3 359.8 152 336 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-kiss-closed-eyes": [512, 512, [], "e37d", "M311.9 315.9c0-19.19-28.7-41.38-71.45-43.87C232.1 270.9 228.3 283.8 236.9 287.4l17.07 7.227c12.96 5.484 20.71 13.46 20.71 21.44s-7.75 15.95-20.71 21.44l-17.07 7.102c-6.055 2.617-5.934 12.34 0 14.83l17.07 7.105c12.96 5.484 20.71 13.46 20.71 21.43c0 7.977-7.75 15.95-20.71 21.44l-17.07 7.23c-8.477 3.609-4.844 16.07 3.633 15.33c42.75-2.492 71.45-24.68 71.45-43.87c0-12.96-13.32-27.17-35.12-36.27C298.6 343.1 311.9 328.9 311.9 315.9zM171.1 180.1c-25.67 0-55.85 16.88-59.85 42.13C110.3 233.3 123.6 240.3 131.9 232.1l9.566-8.5c14.77-13.25 46.14-13.25 61.03 0L212.2 233c8.355 7.5 21.37 .2187 19.68-10.78C227.9 196.1 197.8 180.1 171.1 180.1zM336 180.1c-25.67 0-55.85 16.88-59.85 42.13c-1.816 11.12 11.5 18.12 19.74 10.75l9.566-8.5c14.77-13.25 46.14-13.25 61.03 0L376.2 233c8.355 7.5 21.37 .2187 19.68-10.78C391.9 196.1 361.8 180.1 336 180.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-kiss-wink-heart": [512, 512, [62872, "kiss-wink-heart"], "1f618", "M366.4 224.5l9.566 8.5c8.477 7.375 21.55 .25 19.86-10.88C391.9 196.9 361.7 180 336 180c-25.79 0-55.95 16.88-59.94 42.13c-1.695 11.25 11.5 18.25 19.86 10.88l9.566-8.5C320.3 211.3 351.7 211.3 366.4 224.5zM342.2 445.1C315.9 457.1 286.8 464 256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208c0 24.24-4.385 47.43-12.04 69.08c5.838 5.277 11.15 11.15 15.21 18.06c9.578 .0332 18.64 2.279 27.27 5.51C505.6 319.9 512 288.7 512 256c0-141.4-114.6-256-256-256S0 114.6 0 256s114.6 256 256 256c35.92 0 70.07-7.461 101.1-20.81c-1.721-2.883-3.465-5.766-4.494-9.094L342.2 445.1zM253.9 401.8L236.1 409c-3.633 1.5-5.57 5.375-4.723 9.25c.8477 3.5 4.117 6.125 7.871 6.125h.4844c42.75-2.5 71.45-24.75 71.45-44c0-13-13.32-27.25-35.12-36C298.6 335.3 311.9 321 311.9 308c0-19.25-28.7-41.5-71.45-44C236.7 263.6 233.1 266.4 232.3 270.3C231.4 274 233.4 277.9 236.1 279.4l16.95 7.25c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5l-16.95 7.125c-5.691 2.5-5.934 12.25 0 14.88l16.95 7.125c12.96 5.5 20.71 13.5 20.71 21.5S266.9 396.3 253.9 401.8zM143.1 208c0 17.75 14.28 32 31.96 32c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32C158.3 176 143.1 190.3 143.1 208zM455.2 376.6l-8.5 2.125l-2.375-8.375c-6-21.38-27.38-36.5-49.75-33c-25.62 4-41.25 28.62-34.63 52.63l23.25 82.63c1.625 5.25 7.125 8.5 12.62 7.125l84.38-21.5c24.5-6.375 38.25-31.88 28.88-55.75C500.9 381.8 477 371 455.2 376.6z"],
    "face-laugh": [512, 512, ["laugh"], "f599", "M175.1 224c17.8 0 32.09-14.25 32.09-32S193.8 160 175.1 160C158.3 160 143.1 174.3 143.1 192S158.3 224 175.1 224zM336 224c17.68 0 31.97-14.25 31.97-32s-14.29-32-31.97-32c-17.8 0-32.09 14.25-32.09 32S318.2 224 336 224zM370.4 288H141.6c-8.113 0-14.41 7-13.44 15C135.6 362.3 186.1 408 249.2 408h13.56c62.24 0 113.6-45.75 121.1-105C384.8 295 378.5 288 370.4 288zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-laugh-beam": [512, 512, [62874, "laugh-beam"], "1f601", "M144.5 210.9C152.2 197.3 163.7 189.3 175.1 189.3c12.35 0 23.86 8 31.48 21.62l9.566 17c4.117 7.375 15.62 4 14.89-4.5C228.6 181.3 199.7 152 175.1 152c-23.86 0-52.82 29.25-56.09 71.38c-.6055 8.5 10.9 11.88 15.14 4.5L144.5 210.9zM370.4 288H141.6c-8.113 0-14.41 7-13.44 15C135.6 362.3 186.1 408 249.2 408h13.56c62.24 0 113.6-45.75 121.1-105C384.8 295 378.5 288 370.4 288zM336 152c-23.86 0-52.78 29.25-56.04 71.38C279.3 232 290.8 235.3 294.9 227.9l9.566-17c7.629-13.62 19.13-21.62 31.48-21.62c12.23 0 23.73 8 31.48 21.62l9.445 17c4.117 7.375 15.62 4 14.89-4.5C388.7 181.3 359.8 152 336 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-laugh-squint": [512, 512, ["laugh-squint"], "f59b", "M142.2 254.3l80.04-48c7.75-4.625 7.75-15.88 0-20.5l-80.04-48c-11.62-7-23.98 7.625-15.38 18L160.5 196l-33.66 40.25C118.1 246.8 130.5 261.1 142.2 254.3zM370.4 288H141.6c-8.113 0-14.41 7-13.44 15C135.6 362.3 186.1 408 249.2 408h13.56c62.24 0 113.6-45.75 121.1-105C384.8 295 378.5 288 370.4 288zM369.8 137.8l-80.04 48c-7.75 4.625-7.75 15.88 0 20.5l80.04 48c11.5 6.875 23.98-7.5 15.38-18L351.5 196l33.66-40.25C393.8 145.4 381.5 130.9 369.8 137.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", "M370.4 288H141.6c-8.113 0-14.41 7-13.44 15C135.6 362.3 186.1 408 249.2 408h13.56c62.24 0 113.6-45.75 121.1-105C384.8 295 378.5 288 370.4 288zM175.1 224c17.8 0 32.09-14.25 32.09-32S193.8 160 175.1 160C158.3 160 143.1 174.3 143.1 192S158.3 224 175.1 224zM336 164c-25.79 0-55.95 16.88-59.94 42.13c-1.695 11.12 11.5 18.12 19.74 10.75l9.566-8.5c14.77-13.12 46.14-13.12 61.03 0l9.445 8.5c8.477 7.375 21.68 .375 19.86-10.75C391.9 180.9 361.7 164 336 164zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-lying": [512, 512, [], "e37e", "M215.8 321.8c-24.78 4.938-46.09 19.59-60.03 41.25c-7.156 11.12-3.938 26 7.219 33.16C167 398.8 171.5 400 175.1 400c7.906 0 15.62-3.875 20.22-11.03c6.812-10.59 17.09-17.69 29.03-20.06c11.53-2.312 23.31 .0938 33.13 6.906c10.94 7.562 25.91 4.75 33.41-6.094c7.531-10.91 4.812-25.84-6.094-33.41C265 322.1 240.1 316.8 215.8 321.8zM512 255.2c0-141.2-114.8-255.1-255.1-255.1s-256 114.8-256 256s114.8 256 256 256c119.1 0 219.1-81.81 247.6-192.1C508.8 309.8 512 299.3 512 288c0-3.754-.4863-7.383-1.109-10.96C511.5 269.8 512 262.5 512 255.2zM448 320h-96c-8.844 0-16 7.156-16 16S343.2 352 352 352h87.45C404.5 417.9 335.6 463.2 256 463.2c-114.7 0-208-93.31-208-208s93.31-208 208-208c104.6 0 191 77.69 205.5 178.3C457.1 224.6 452.6 224 448 224h-160c-8.844 0-16 7.156-16 16S279.2 256 288 256h160c17.66 0 32 14.34 32 32S465.7 320 448 320zM336 208c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32s-32 14.33-32 32C304 193.7 318.3 208 336 208zM176 208c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32s-32 14.33-32 32C144 193.7 158.3 208 176 208z"],
    "face-mask": [576, 512, [], "e37f", "M240 144c-69.83 0-105.8 35.19-107.3 36.69c-6.219 6.219-6.203 16.22-.0469 22.5c3.125 3.156 7.25 4.75 11.39 4.75c4.031 0 8.078-1.531 11.19-4.531C156.4 202.3 184.1 176 240 176C248.8 176 256 168.8 256 160S248.8 144 240 144zM443.3 180.7C441.8 179.2 405.8 144 336 144C327.2 144 320 151.2 320 160s7.156 16 16 16c55.86 0 83.63 26.28 84.78 27.41C423.9 206.5 427.9 208 432 208c4.094 0 8.188-1.562 11.31-4.688C449.6 197.1 449.6 186.9 443.3 180.7zM558.3 216.8c-3.525-7.053-11.51-10.07-18.82-7.872C517.4 90.08 413.3 0 288 0S58.61 90.09 36.5 208.1C29.21 206.8 21.21 209.8 17.69 216.8c-3.953 7.906-.75 17.5 7.156 21.47l7.852 3.926C32.45 246.8 32 251.4 32 256c0 141.4 114.6 256 256 256s256-114.6 256-256c0-4.646-.4512-9.176-.6953-13.76l7.852-3.926C559.1 234.3 562.3 224.8 558.3 216.8zM136 397.5c-32.46-34.84-53.02-80.71-55.49-131.4L136 293.9V397.5zM392 416c0 4.406-3.594 8-8 8H192c-4.406 0-8-3.594-8-8v-16h208V416zM392 368h-208v-32h208V368zM392 304h-208V288c0-4.406 3.594-8 8-8h192c4.406 0 8 3.594 8 8V304zM384 232H192c-21.27 0-39.59 12.06-49.07 29.58L81.66 230.9C94.1 128 181.8 48 288 48s193.9 80.04 206.3 182.9l-61.27 30.64C423.6 244.1 405.3 232 384 232zM440 397.5V293.9l55.49-27.74C493 316.8 472.5 362.7 440 397.5z"],
    "face-meh": [512, 512, [61722, "meh"], "1f610", "M344 320H167.1c-13.2 0-23.98 10.75-23.98 24s10.78 24 23.98 24h176.1c13.2 0 23.98-10.75 23.98-24S357.2 320 344 320zM175.1 240c17.8 0 32.02-14.25 32.02-32s-14.22-32-32.02-32c-17.68 0-31.99 14.25-31.99 32S158.3 240 175.1 240zM336 176c-17.8 0-32.02 14.25-32.02 32s14.22 32 32.02 32c17.68 0 31.99-14.25 31.99-32S353.7 176 336 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-meh-blank": [512, 512, [62884, "meh-blank"], "1f636", "M336 176c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 176 336 176zM175.1 176c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32c17.8 0 32.09-14.25 32.09-32S193.8 176 175.1 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-monocle": [512, 512, [], "e380", "M287.1 224c0 17.7 14.34 32 32.02 32C337.7 256 352 241.7 352 224s-14.31-32-31.99-32S287.1 206.3 287.1 224zM192 192c0-17.7-14.3-32-31.98-32S128 174.3 128 192s14.33 32 32.01 32C177.7 224 192 209.7 192 192zM160 351.1c0 8.844 7.156 16 15.97 16.03c.875 0 86.59 .9062 113.7 55.16C292.5 428.8 298.2 432 304 432c2.406 0 4.844-.5313 7.156-1.688c7.906-3.969 11.09-13.56 7.156-21.47C282.3 336.8 180.3 336 176 336C167.2 336 160 343.2 160 351.1zM503.2 481.7c-25.36-12.69-43.52-34.93-51.15-61.16C489.4 376 512 318.7 512 256c0-141.4-114.6-256-256-256S0 114.6 0 256s114.6 256 256 256c65.93 0 125.8-25.14 171.2-66.08c12.13 27.45 33.55 50.34 61.62 64.39C491.1 511.5 493.6 512 496 512c5.844 0 11.5-3.25 14.31-8.844C514.3 495.3 511.1 485.7 503.2 481.7zM432 208c-1.021 0-1.91 .3984-2.877 .5801C418.5 162.5 377.4 128 328 128C270.6 128 224 174.6 224 232s46.56 104 104 104c37.22 0 69.62-19.71 88-49.1v101.8C377.8 434.7 320.3 464 256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48c28.4 0 55.48 5.756 80.16 16.11c-16.99-.0352-33.1 5.264-48.2 15.92l-25.56 19.16c-7.062 5.312-8.5 15.34-3.219 22.41C262.3 125.8 267.2 128 271.1 128c3.344 0 6.719-1.031 9.594-3.188l25.59-19.19c17-12.75 40.66-12.72 57.59-.0313c7.125 5.344 17.12 3.875 22.41-3.156c1.262-1.686 2.09-3.551 2.607-5.463C435.1 135.2 464 192.2 464 256c0 28.29-5.723 55.26-16 79.87V224C448 215.2 440.8 208 432 208zM400 232c0 39.7-32.3 72-72 72S256 271.7 256 232S288.3 160 328 160S400 192.3 400 232z"],
    "face-nauseated": [512, 512, [], "e381", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM204.8 114.3c5.312-7.062 3.906-17.09-3.156-22.41C198.7 89.73 195.3 88.7 191.1 88.7c-4.844 0-9.656 2.219-12.78 6.375C160.1 120.5 134.6 140.7 105.6 153.4C97.5 156.9 93.81 166.4 97.34 174.4c3.562 8.094 13.06 11.69 21.06 8.25C152.5 167.8 182.3 144.2 204.8 114.3zM176 240c17.67 0 31.1-14.33 31.1-32c0-17.67-14.33-32-31.1-32s-32 14.33-32 32C144 225.7 158.3 240 176 240zM335.1 176c-17.67 0-31.1 14.33-31.1 32c0 17.67 14.33 32 31.1 32s32-14.33 32-32C367.1 190.3 353.7 176 335.1 176zM406.4 152.7C377.4 140 351.9 119.8 332.8 94.41C329.7 90.22 324.9 88 320 88c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38c22.41 29.88 52.28 53.53 86.38 68.41c8.125 3.438 17.53-.1562 21.06-8.25S414.5 156.2 406.4 152.7zM357.8 309.7c10.84-7.594 13.53-22.56 5.938-33.44c-7.562-10.84-22.47-13.5-33.44-5.938C313.3 282.2 302 300.1 297.1 320H214.1c-4.086-19.88-15.34-37.79-32.3-49.66C170.8 262.8 155.9 265.4 148.3 276.3S143.4 302.1 154.3 309.7C162.9 315.7 168 325.5 168 336s-5.125 20.28-13.75 26.28c-10.84 7.594-13.53 22.56-5.938 33.44c4.688 6.688 12.12 10.25 19.72 10.25c4.719 0 9.531-1.406 13.72-4.312C198.7 389.8 209.1 371.9 214.1 352h83.9c4.086 19.87 15.33 37.79 32.3 49.66c4.188 2.906 9 4.312 13.72 4.312c7.594 0 15.03-3.562 19.72-10.25c7.594-10.88 4.906-25.84-5.938-33.44C349.1 356.3 344 346.5 344 336S349.1 315.7 357.8 309.7z"],
    "face-nose-steam": [512, 512, [], "e382", "M96 240C96 248.8 103.2 256 112 256h96C216.8 256 224 248.8 224 240S216.8 224 208 224h-96C103.2 224 96 231.2 96 240zM304 256h96C408.8 256 416 248.8 416 240S408.8 224 400 224h-96C295.2 224 288 231.2 288 240S295.2 256 304 256zM131.8 420.4L192 320l-100.4 60.22C84.08 363.6 67.44 352 48 352C21.49 352 0 373.5 0 400c0 12.35 4.795 23.49 12.46 32C4.795 440.5 0 451.7 0 464C0 490.5 21.49 512 48 512c12.35 0 23.49-4.795 32-12.46C88.51 507.2 99.65 512 112 512C138.5 512 160 490.5 160 464C160 444.6 148.4 427.9 131.8 420.4zM464 352c-19.44 0-36.08 11.61-43.63 28.22L320 320l60.22 100.4C363.6 427.9 352 444.6 352 464c0 26.51 21.49 48 48 48c12.35 0 23.49-4.795 32-12.46C440.5 507.2 451.7 512 464 512c26.51 0 48-21.49 48-48c0-12.35-4.795-23.49-12.46-32C507.2 423.5 512 412.3 512 400C512 373.5 490.5 352 464 352zM48 320c3.564 0 7.045 .4668 10.52 .9355C51.78 300.5 48 278.7 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208c0 22.69-3.775 44.48-10.52 64.94C456.1 320.5 460.4 320 464 320c13.48 0 25.99 3.666 37.15 9.578C508.1 306.3 512 281.6 512 256c0-141.4-114.6-256-256-256S0 114.6 0 256c0 25.59 3.865 50.26 10.85 73.58C22.01 323.7 34.52 320 48 320zM320.9 453.5C300.5 460.2 278.7 464 256 464s-44.48-3.775-64.94-10.52C191.5 456.1 192 460.4 192 464c0 13.48-3.666 25.99-9.578 37.15C205.7 508.1 230.4 512 256 512s50.26-3.865 73.58-10.85C323.7 489.1 320 477.5 320 464C320 460.4 320.5 456.1 320.9 453.5zM196.9 187.5C200.6 191.1 205.7 192.6 210.5 191.8c3.303-.5156 6.479-2.057 8.98-4.66C225.6 180.8 225.5 170.7 219.1 164.5C192.4 138.5 159.2 119.7 123.2 110.3C114.7 108.2 105.1 113.2 103.7 121.7S106.6 138.1 115.1 141.2C145.8 149.3 174 165.3 196.9 187.5zM315.1 187.3c22.86-22.21 51.1-38.19 81.74-46.25c8.541-2.24 13.64-10.99 11.4-19.54c-2.27-8.545-11.1-13.56-19.54-11.4c-35.95 9.439-69.12 28.2-95.89 54.22c-6.338 6.156-6.498 16.29-.3398 22.62c2.533 2.611 5.709 4.15 9.012 4.666C306.3 192.4 311.4 190.9 315.1 187.3z"],
    "face-party": [640, 512, [], "e383", "M463.5 406.6C424.6 443.6 373.7 464 320 464c-114.7 0-208-93.31-208-208S205.3 48 320 48c81.34 0 155.7 47.88 189.4 121.9c5.5 12.09 19.72 17.41 31.78 11.91s17.39-19.72 11.91-31.78C511.6 58.91 420.1 0 320 0C178.8 0 64 114.8 64 256s114.8 256 256 256c66.05 0 128.8-25.09 176.5-70.63c9.609-9.156 9.969-24.34 .8281-33.94C488.2 397.8 473 397.5 463.5 406.6zM21.75 1.057c-5.891-2.25-12.58-.8438-17.06 3.625c-4.469 4.469-5.891 11.16-3.625 17.06l17.69 45.99c11.58-18.77 24.79-36.35 39.51-52.63L21.75 1.057zM90.25 27.4C67.65 50.62 48.54 77.17 33.55 106.2l17.81 46.3C67.78 109.8 93.99 71.94 127.3 41.66L90.25 27.4zM176.1 222.2C174.3 233.3 187.6 240.3 195.9 232.1l9.566-8.5c14.77-13.25 46.14-13.25 61.03 0L276.2 233c8.355 7.5 21.37 .2187 19.68-10.78C291.9 196.1 261.8 180.1 235.1 180.1C210.3 180.1 180.1 196.1 176.1 222.2zM340.2 222.2c-1.816 11.12 11.5 18.12 19.74 10.75l9.566-8.5c14.77-13.25 46.14-13.25 61.03 0L440.2 233c8.355 7.5 21.37 .2187 19.68-10.78c-3.996-25.25-34.09-42.13-59.88-42.13C374.4 180.1 344.2 196.1 340.2 222.2zM592 208h-32C533.5 208 512 229.5 512 256s21.53 48 48 48C568.8 304 576 296.8 576 288s-7.156-16-16-16C551.2 272 544 264.8 544 256s7.172-16 16-16h32C600.8 240 608 247.2 608 256v64c0 8.812-7.172 16-16 16h-186.1c6.398-6.416 10.04-13.39 10.04-20.06c0-19.19-28.72-41.38-71.47-43.87c-8.355-1.125-12.23 11.71-3.633 15.33l17.07 7.227c12.96 5.484 20.71 13.46 20.71 21.44s-7.75 15.95-20.71 21.44l-17.07 7.102c-6.055 2.617-5.934 12.34 0 14.83l17.07 7.105c12.96 5.484 20.71 13.46 20.71 21.43c0 7.977-7.75 15.95-20.71 21.44l-17.07 7.23c-8.477 3.609-4.844 16.07 3.633 15.33c42.75-2.492 71.47-24.68 71.47-43.87c0-6.666-3.629-13.64-10.02-20.1H592c26.47 0 48-21.53 48-48V256C640 229.5 618.5 208 592 208z"],
    "face-pensive": [512, 512, [], "e384", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM422.4 193.4c-29.06-12.69-54.5-32.84-73.63-58.28c-3.125-4.188-7.938-6.406-12.78-6.406c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38c22.41 29.88 52.28 53.53 86.38 68.41c8.125 3.438 17.53-.1562 21.06-8.25S430.5 196.9 422.4 193.4zM102.4 222.7C136.5 207.8 166.3 184.2 188.8 154.3c5.312-7.062 3.906-17.09-3.156-22.41C182.7 129.7 179.3 128.7 176 128.7c-4.844 0-9.656 2.219-12.78 6.375C144.1 160.5 118.6 180.7 89.6 193.4C81.5 196.9 77.82 206.4 81.35 214.4C84.91 222.5 94.41 226.1 102.4 222.7zM304 368h-96c-13.25 0-24 10.75-24 24S194.8 416 208 416h96c13.25 0 24-10.75 24-24S317.3 368 304 368zM219.4 276.1C213.3 270.7 203.2 270.5 196.9 276.5C196.4 276.1 184.3 288 160 288C136 288 123.9 277.2 123.2 276.5C116.9 270.4 106.9 270.5 100.7 276.7c-6.25 6.25-6.25 16.38 0 22.62C102.8 301.4 122.5 320 160 320s57.19-18.56 59.31-20.69C225.5 293.1 225.5 283.3 219.4 276.1zM388.9 276.5C388.4 276.1 376.3 288 352 288c-24 0-36.09-10.78-36.84-11.47c-6.219-6.094-16.25-6.062-22.47 .1562c-6.25 6.25-6.25 16.38 0 22.62C294.8 301.4 314.5 320 352 320s57.19-18.56 59.31-20.69c6.188-6.188 6.156-16.06 .0938-22.34C405.3 270.7 395.2 270.5 388.9 276.5z"],
    "face-persevering": [512, 512, [], "e385", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 336c-54.88 0-82.81 40.94-83.97 42.69c-7.344 11.03-4.375 25.94 6.656 33.28c11.03 7.312 25.94 4.344 33.28-6.656C212.1 405.1 227 384 256 384c28.69 0 43.56 20.69 44.03 21.31C304.7 412.3 312.3 416 320 416c4.562 0 9.211-1.312 13.3-4.031c11.03-7.344 14-22.25 6.656-33.28C338.8 376.9 310.9 336 256 336zM222.2 261.8l-80.04-48c-11.62-7-23.98 7.625-15.38 18l33.66 40.25l-33.66 40.25c-8.598 10.5 3.875 24.88 15.38 18l80.04-48C229.1 277.6 229.1 266.4 222.2 261.8zM351.5 272l33.66-40.25c8.598-10.38-3.754-25-15.38-18l-80.04 48c-7.629 4.625-7.629 15.88 0 20.5l80.04 48c11.5 6.875 24.1-7.5 15.38-18L351.5 272zM212.3 98.65c-2.533-2.609-5.709-4.15-9.012-4.666C198.5 93.24 193.4 94.69 189.7 98.31C166.8 120.5 138.6 136.5 107.9 144.6C99.39 146.8 94.29 155.6 96.53 164.1C98.8 172.6 107.6 177.7 116.1 175.5c35.95-9.438 69.12-28.2 95.89-54.22C218.3 115.1 218.5 104.1 212.3 98.65zM404.1 144.6c-30.67-8.049-58.92-24.04-81.74-46.22c-3.732-3.656-8.83-5.105-13.62-4.357c-3.303 .5176-6.479 2.057-8.98 4.662c-6.193 6.312-6.035 16.44 .3047 22.6c26.75 26.06 59.92 44.82 95.9 54.25c8.559 2.141 17.3-2.861 19.54-11.4C417.7 155.6 412.6 146.8 404.1 144.6z"],
    "face-pleading": [512, 512, [], "e386", "M240 240c0-41.55-31.42-75.03-71.66-79.18C175.7 153.6 182.6 145.9 188.8 137.6c5.312-7.062 3.906-17.09-3.156-22.41C182.7 113 179.3 112 175.1 112c-4.844 0-9.656 2.219-12.78 6.375C144.1 143.8 118.6 164 89.59 176.7C81.5 180.2 77.81 189.7 81.34 197.8C82.79 201.1 85.38 203.4 88.3 205C83.14 215.6 79.99 227.4 79.99 240c0 44.38 35.7 80 80.17 80C204.3 320 240 284.4 240 240zM160 280c-22.06 0-40-17.94-40-40S137.9 200 160 200S200 217.9 200 240S182.1 280 160 280zM256 384c-23.59 0-39.58 14.53-45.31 23.12c-4.906 7.344-2.922 17.28 4.438 22.19c7.328 4.875 17.28 2.906 22.19-4.438C237.4 424.8 243.8 416 256 416c12.14 0 18.58 8.719 18.69 8.875C277.8 429.5 282.8 432 288 432c3.047 0 6.141-.875 8.859-2.688c7.359-4.906 9.344-14.84 4.438-22.19C295.6 398.5 279.6 384 256 384zM423.1 205.5c2.799-1.637 5.264-3.887 6.662-7.094c3.531-8.094-.1562-17.53-8.25-21.06c-29.06-12.69-54.5-32.84-73.63-58.28c-3.125-4.188-7.938-6.406-12.78-6.406c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38c6.029 8.041 12.69 15.54 19.73 22.62C302.9 165.5 271.1 198.8 271.1 240c0 44.38 35.7 80 80.17 80c44.16 0 79.87-35.63 79.87-80C432 227.6 428.1 215.1 423.1 205.5zM352 280c-22.06 0-40-17.94-40-40S329.9 200 352 200s40 17.94 40 40S374.1 280 352 280zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-pouting": [512, 512, [], "e387", "M208 240c10.29 0 19.86-6.75 23.01-17.12C234.8 210.3 227.5 196.8 214.9 193l-80.04-24c-12.84-3.875-26.16 3.375-29.91 16.12C101.2 197.8 108.4 211.3 121.1 215l28.21 8.5C146.2 228.4 143.1 233.8 143.1 240c0 17.62 14.38 32 32.06 32C193.8 272 208 257.8 208 240zM256 320c-35.6 0-88.76 21.25-95.79 61.25c-2.059 11.75 8.961 21.5 20.46 18C211.9 389.8 240.1 384 256 384s44.08 5.75 75.32 15.25c11.38 3.5 22.52-6.25 20.46-18C344.8 341.3 291.6 320 256 320zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM407 185.1c-3.754-12.75-17.07-19.88-29.91-16.12l-80.04 24c-12.59 3.75-19.86 17.25-16.11 29.88C284.1 233.3 293.8 240 304 240c0 17.75 14.2 32 31.1 32c17.68 0 32.06-14.25 32.06-32c0-6.25-2.271-11.75-5.419-16.62l28.21-8.5C403.6 211.3 410.8 197.8 407 185.1z"],
    "face-raised-eyebrow": [512, 512, [], "e388", "M344 320H167.1c-13.2 0-23.98 10.75-23.98 24s10.78 24 23.98 24h176.1c13.2 0 23.98-10.75 23.98-24S357.2 320 344 320zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM208 160c0-8.844-7.156-16-16-16H128C119.2 144 112 151.2 112 160S119.2 176 128 176h64C200.8 176 208 168.8 208 160zM175.1 208c-17.69 0-31.99 14.3-31.99 32s14.3 32 31.99 32s32.02-14.3 32.02-32S193.7 208 175.1 208zM368 240c0-17.7-14.3-32-31.99-32s-32.02 14.3-32.02 32s14.34 32 32.02 32S368 257.7 368 240zM374.6 104c-12.06-12.06-33.19-12.06-45.25 0l-52.69 52.69c-6.25 6.25-6.25 16.38 0 22.62C279.8 182.4 283.9 184 288 184s8.188-1.562 11.31-4.688L352 126.6l20.69 20.69c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L374.6 104z"],
    "face-relieved": [512, 512, [], "e389", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM219.4 244.1C213.3 238.7 203.2 238.5 196.9 244.5C196.4 244.1 184.3 256 160 256C136 256 123.9 245.2 123.2 244.5C116.9 238.4 106.9 238.5 100.7 244.7c-6.25 6.25-6.25 16.38 0 22.62C102.8 269.4 122.5 288 160 288s57.19-18.56 59.31-20.69C225.5 261.1 225.5 251.3 219.4 244.1zM411.4 244.1c-6.125-6.281-16.19-6.438-22.53-.4687C388.4 244.1 376.3 256 352 256c-24 0-36.09-10.78-36.84-11.47c-6.219-6.094-16.25-6.031-22.47 .1562c-6.25 6.25-6.25 16.38 0 22.62C294.8 269.4 314.5 288 352 288s57.19-18.56 59.31-20.69C417.5 261.1 417.5 251.3 411.4 244.1zM313.6 127.3C342.6 140 368.1 160.2 387.2 185.6C390.3 189.8 395.2 192 399.1 192c3.344 0 6.719-1.031 9.625-3.219c7.062-5.312 8.469-15.34 3.156-22.41c-22.44-29.84-52.31-53.5-86.38-68.38c-8-3.438-17.5 .1562-21.06 8.25C301.8 114.3 305.5 123.8 313.6 127.3zM111.1 192C116.8 192 121.7 189.8 124.8 185.6C143.9 160.2 169.3 140 198.4 127.3C206.5 123.8 210.2 114.3 206.7 106.3S193.7 94.56 185.6 98C151.5 112.9 121.6 136.5 99.22 166.4C93.9 173.5 95.31 183.5 102.4 188.8C105.3 190.1 108.7 192 111.1 192zM312.1 346.8c-31 27.38-81.25 27.38-112.3 0C189.1 338 174.8 338.9 166 348.9C157.3 358.8 158.2 374 168.1 382.8C192.4 404.2 223.6 416 256 416s63.63-11.83 87.88-33.24c9.938-8.781 10.88-23.94 2.125-33.88C337.2 338.9 322 338 312.1 346.8z"],
    "face-rolling-eyes": [512, 512, [62885, "meh-rolling-eyes"], "1f644", "M240 224c0-39.75-32.21-72-72.05-72C128.2 152 96.03 184.3 96.03 224s32.22 72 71.94 72C207.8 296 240 263.8 240 224zM128 224c0-13.62 7.266-25.12 17.68-32.25C144.7 194.3 143.1 197 143.1 200c0 13.25 10.66 24 23.98 24s23.98-10.75 23.98-24c0-2.875-.6055-5.75-1.695-8.25C200.7 198.9 208 210.4 208 224c0 22.12-17.9 40-40.06 40C145.9 264 128 246.1 128 224zM344 152c-39.84 0-72.05 32.25-72.05 72s32.21 72 72.05 72c39.72 0 71.94-32.25 71.94-72S383.8 152 344 152zM344 264c-22.16 0-40.06-17.88-40.06-40c0-13.62 7.363-25.12 17.78-32.25C320.7 194.3 320.1 197 320.1 200c0 13.25 10.66 24 23.98 24s23.98-10.75 23.98-24c0-2.875-.7266-5.75-1.695-8.25C376.7 198.9 383.1 210.4 383.1 224C383.1 246.1 366.1 264 344 264zM320.1 352H191.9c-13.2 0-23.98 10.75-23.98 24s10.78 24 23.98 24h128.1c13.2 0 23.98-10.75 23.98-24S333.3 352 320.1 352zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-sad-cry": [512, 512, [62899, "sad-cry"], "1f62d", "M256 272c-30.88 0-55.95 28.75-55.95 64s25.07 64 55.95 64s55.95-28.75 55.95-64S286.9 272 256 272zM352.1 180.1c-25.67 0-56.04 16.88-59.91 42.13c-.8477 5 1.695 10 6.055 12.38c4.48 2.375 9.93 1.75 13.68-1.625l9.657-8.594c14.77-13.12 46.05-13.12 60.94 0l9.536 8.5c2.543 2.25 7.992 4.75 13.68 1.625c4.48-2.375 6.902-7.281 6.176-12.28C407.9 196.1 377.8 180.1 352.1 180.1zM213.9 234.6c4.359-2.375 6.872-7.375 6.146-12.38c-3.996-25.25-34.36-42.13-59.91-42.13S104.1 196.1 100.2 222.2c-.7266 5 1.695 10 6.176 12.38c4.359 2.375 9.809 1.75 13.68-1.625l9.445-8.5c14.77-13.12 46.26-13.12 61.03 0l9.627 8.5C202.7 235.3 208 237.8 213.9 234.6zM256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256S397.2 0 256 0zM399.1 405.8V280c0-13.25-10.78-24-23.98-24s-23.99 10.75-23.99 24v160.3C323.3 455.4 290.6 464 256 464c-34.65 0-67.28-8.637-96.04-23.69L159.1 280c0-13.25-10.79-24-23.99-24S112 266.8 112 280l-.0137 125.7C72.64 367.9 48 314.8 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 314.8 439.4 367.9 399.1 405.8z"],
    "face-sad-sweat": [576, 512, [], "e38a", "M204 378.7c-7.344 11.03-4.375 25.94 6.656 33.28c11.03 7.312 25.94 4.344 33.28-6.656C244.1 405.1 259 384 288 384c28.69 0 43.56 20.69 44.03 21.31c4.625 6.938 12.23 10.68 19.98 10.68c4.562 0 9.203-1.306 13.3-4.025c11.03-7.344 14-22.25 6.656-33.28C370.8 376.9 342.9 336 288 336S205.2 376.9 204 378.7zM41.6 291.3C28.43 308.6 0 349 0 369C0 395 21.54 416 48 416S96 395 96 369c0-19.1-28.55-60.36-41.6-77.73C51.2 286.9 44.8 286.9 41.6 291.3zM207.1 128.7c-4.844 0-9.656 2.219-12.78 6.375C176.1 160.5 150.6 180.7 121.6 193.4C113.5 196.9 109.8 206.4 113.3 214.4c3.562 8.094 13.06 11.69 21.06 8.25C168.5 207.8 198.3 184.2 220.8 154.3c5.312-7.062 3.906-17.09-3.156-22.41C214.7 129.7 211.3 128.7 207.1 128.7zM207.9 240c-17.66 0-31.95 14.25-31.95 32s14.28 32 31.95 32c17.79 0 32.07-14.25 32.07-32S225.7 240 207.9 240zM335.1 272c0 17.75 14.28 32 32.07 32C385.7 304 400 289.8 400 272s-14.28-32-31.95-32C350.3 240 335.1 254.3 335.1 272zM441.6 222.7c8.125 3.438 17.53-.1562 21.06-8.25S462.5 196.9 454.4 193.4c-29.06-12.69-54.5-32.84-73.63-58.28c-3.125-4.188-7.938-6.406-12.78-6.406c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38C377.6 184.2 407.5 207.8 441.6 222.7zM288 0C146.6 0 32 114.6 32 256c0 1.18 .1602 2.319 .1758 3.495C37.12 257.4 42.46 256 48 256c12.67 0 24.7 6.083 32.2 16.33c.25 .332 .4329 .6315 .679 .9616C80.4 267.6 80 261.8 80 256c0-114.7 93.31-208 208-208s208 93.31 208 208s-93.31 208-208 208c-65.46 0-123.9-30.46-162-77.87c-3.84 17.04-13.39 31.8-26.4 42.75C146.4 479.9 213.4 512 288 512c141.4 0 256-114.6 256-256S429.4 0 288 0z"],
    "face-sad-tear": [512, 512, [62900, "sad-tear"], "1f622", "M175.1 240c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32S158.3 240 175.1 240zM170.4 274.8c-11.38 15.38-36.33 50.63-36.33 68.13C134.1 365.6 152.8 384 175.1 384c23.25 0 42.02-18.38 42.02-41.13c0-17.5-24.95-52.75-36.33-68.13C178.7 271.1 173.2 271.1 170.4 274.8zM336 176c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 176 336 176zM263.1 304c-13.2 0-23.98 10.75-23.98 24S250.8 352 263.1 352c23.86 0 46.26 10.5 61.64 28.75c8.113 9.875 23.13 12 33.79 3.125c10.17-8.5 11.62-23.62 3.027-33.75C337.1 320.8 302.1 304 263.1 304zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-scream": [640, 512, [], "e38b", "M262.4 149.8C234.2 134.2 194.3 151.2 172.1 187.9C151.6 224.6 157.2 266.7 185.4 282.2c28.38 15.63 68.29-1.311 89.63-38.04C296.4 207.4 290.8 165.4 262.4 149.8zM320 432C346.5 432 368 410.5 368 384v-32c0-26.51-21.49-48-48-48S272 325.5 272 352v32C272 410.5 293.5 432 320 432zM74.73 288C89.98 288 104.7 292.9 117.2 301.5C113.9 286.8 112 271.6 112 256c0-114.7 93.31-208 208-208s208 93.31 208 208c0 15.38-1.799 30.33-4.982 44.78C535.3 292.6 549.6 288 564.4 288c3.117 0 6.078 .9395 9.145 1.322C575 278.4 576 267.3 576 256c0-141.4-114.6-256-256-256S63.99 114.6 63.99 256c0 11.29 .9887 22.32 2.405 33.21C69.2 288.9 71.88 288 74.73 288zM204.1 428.6c3.162 8.957 6.498 17.74 9.045 27.31c2.898 12.05 4.959 23.94 6.705 35.71C250.6 504.7 284.4 512 320 512c35.55 0 69.4-7.27 100.2-20.37c1.703-11.73 3.684-23.57 6.555-35.76c2.451-9.389 5.727-18.14 8.824-27.04C402.5 451 362.7 464 320 464C277.1 464 237.2 450.9 204.1 428.6zM454.6 282.2c28.18-15.52 33.82-57.56 12.48-94.28c-21.35-36.73-61.26-53.67-89.44-38.15c-28.38 15.63-34.02 57.66-12.67 94.39C386.3 280.9 426.2 297.8 454.6 282.2zM588.2 326.9c-16.35-10.54-37.06-8.596-51.17 3.361c-13.1 11.89-20.82 20.08-29.6 30.79c-7.926 10.29-15.35 20.93-21.45 32.16c-12.64 22.31-21.83 46.25-28.26 70.77C453.1 479.8 451.6 495.9 450.1 512h108.9c-.1309-9.447 .166-18.84 1.004-28.17c2.117-16.55 5.947-32.83 12.06-48.12c2.859-7.768 6.705-14.97 10.65-21.98c3.502-6.312 9.807-14.59 11.33-16.93l7.055-10.73C613.9 366.2 608.1 339.7 588.2 326.9zM153.5 392.8c-6.125-11.2-13.57-21.8-21.5-32.05c-8.781-10.67-15.61-18.83-29.6-30.64c-14.09-11.89-34.71-13.72-50.91-3.1c-19.77 12.96-25.4 39.49-12.43 59.26l7.073 10.7c1.529 2.332 7.842 10.57 11.36 16.87c3.963 6.994 7.826 14.17 10.71 21.93c6.16 15.25 10.05 31.51 12.25 48.06C81.34 493.1 81.68 502.5 81.6 512h108.3c-1.654-16.28-4.059-32.55-7.92-48.6C175.5 438.9 166.2 415 153.5 392.8z"],
    "face-shush": [512, 512, [], "e38c", "M321.6 220.8c-5.543 4.16-11.5 7.549-17.67 10.45C303.5 200.7 278.6 176 248 176c-27.57 0-50.41 20.06-55.02 46.33C192.2 221.8 191.2 221.4 190.4 220.8C179.8 212.8 164.7 215 156.8 225.6C148.8 236.2 150.1 251.2 161.6 259.2C171.1 266.3 181.4 271.8 192 276.5v39.73c-3.609 2.988-6.998 6.281-10.12 9.859l-16.13 18.41C151.7 360.6 144 381.1 144 402.4V424C144 472.5 183.5 512 232 512h48c26.3 0 49.34-18.68 54.78-44.42c3.678-17.12-1.137-34.63-11.93-47.56C331.1 410.3 336 397.7 336 384v-32c0-22.3-13.1-41.59-32-50.59V282.9c16.55-5.186 32.22-13.02 46.41-23.69c10.62-7.969 12.75-23 4.781-33.59C347.3 215.1 332.3 212.8 321.6 220.8zM224 232C224 218.7 234.7 208 248 208c13.26 0 24 10.74 24 24v64H248.1C239.8 296 231.8 297.6 224 299.9V232zM304 384c0 13.25-10.75 24-24 24S256 397.3 256 384v-8H248.1c-2.312 0-4.5 1-6.031 2.75l-16.12 18.41C224.7 398.6 224 400.5 224 402.4v2.406l65.75 29.22c10.34 4.625 16.09 15.84 13.72 26.91C301.1 472.1 291.3 480 280 480h-48c-30.88 0-56-25.12-56-56v-21.56c0-13.56 4.906-26.66 13.81-36.88l16.16-18.44C216.6 334.1 231.1 328 248.1 328H280c13.25 0 24 10.75 24 24V384zM368 144c0-17.7-14.3-32-31.99-32s-32.02 14.3-32.02 32s14.34 32 32.02 32S368 161.7 368 144zM256 0C114.8 0 0 114.8 0 256c0 70.72 28.22 136.6 79.44 185.4c9.625 9.156 24.81 8.75 33.94-.8125c9.156-9.594 8.781-24.78-.8125-33.94C70.94 366.1 48 313.5 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208c0 69.97-34.88 134.8-93.25 173.5c-11.06 7.312-14.06 22.22-6.75 33.25c4.625 6.969 12.25 10.75 20.03 10.75c4.531 0 9.156-1.281 13.22-4C469.1 421.9 512 342.1 512 256C512 114.8 397.2 0 256 0zM175.1 176c17.69 0 32.02-14.3 32.02-32s-14.33-32-32.02-32S143.1 126.3 143.1 144S158.3 176 175.1 176z"],
    "face-sleeping": [512, 512, [], "e38d", "M457.3 138.2c-12.06 5.5-17.41 19.72-11.91 31.78C457.8 197 464 225.1 464 256c0 114.7-93.31 208-208 208S48 370.7 48 256S141.3 48 256 48c30.03 0 59 6.25 86.06 18.56C354 72 368.3 66.75 373.8 54.66c5.5-12.06 .1562-26.28-11.91-31.78C328.6 7.688 292.9 0 256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256c0-36.94-7.688-72.59-22.88-105.9C483.6 137.1 469.3 132.7 457.3 138.2zM219.4 244.1c-3.125-3.221-7.301-4.832-11.48-4.832c-3.975 0-7.955 1.455-11.05 4.363C196.4 244.1 184.3 256 160 256C136 256 123.9 245.2 123.2 244.5C120.1 241.5 116 240 112 240c-4.1 .002-8.199 1.564-11.32 4.686c-6.25 6.25-6.25 16.38 0 22.62C102.8 269.4 122.5 288 160 288s57.18-18.56 59.31-20.69C225.5 261.1 225.5 251.3 219.4 244.1zM388.9 244.5C388.4 244.1 376.3 256 352 256c-24 0-36.09-10.78-36.84-11.47C312.1 241.5 308.1 240 304 240c-4.098 0-8.207 1.564-11.34 4.686c-6.25 6.25-6.25 16.38 0 22.62C294.8 269.4 314.5 288 352 288s57.18-18.56 59.31-20.69c6.188-6.188 6.156-16.06 .0938-22.34c-3.141-3.221-7.316-4.832-11.49-4.832C395.9 240.1 391.1 241.6 388.9 244.5zM256 424c22.09 0 40-17.91 40-40c0-22.09-17.91-40-40-40S216 361.9 216 384C216 406.1 233.9 424 256 424zM304 112C304 120.8 311.2 128 320 128h25.38l-36.69 36.69c-4.562 4.562-5.938 11.47-3.469 17.44S313.5 192 320 192h64c8.844 0 16-7.156 16-16S392.8 160 384 160h-25.38l36.69-36.69c4.562-4.562 5.938-11.47 3.469-17.44S390.5 96 384 96h-64C311.2 96 304 103.2 304 112zM432 32h25.38l-36.69 36.69c-4.562 4.562-5.938 11.47-3.469 17.44S425.5 96 432 96h64C504.8 96 512 88.84 512 80S504.8 64 496 64h-25.38l36.69-36.69c4.562-4.562 5.938-11.47 3.469-17.44S502.5 0 496 0h-64C423.2 0 416 7.156 416 16S423.2 32 432 32z"],
    "face-sleepy": [512, 512, [], "e38e", "M195.8 415.4c25-7.602 47.58-12.2 60.27-12.2c12.69 0 35.27 4.6 60.27 12.2c9.109 2.801 18.02-4.9 16.38-14.4C327.1 369 284.6 352 256 352s-71.03 17-76.65 49.01C177.7 410.4 186.6 418.2 195.8 415.4zM219.4 244.1C213.3 238.7 203.2 238.5 196.9 244.5C196.4 244.1 184.3 256 160 256C136 256 123.9 245.2 123.2 244.5C116.9 238.4 106.9 238.5 100.7 244.7c-6.25 6.25-6.25 16.38 0 22.62C102.8 269.4 122.5 288 160 288s57.19-18.56 59.31-20.69C225.5 261.1 225.5 251.3 219.4 244.1zM384.5 445.1c.4453-8.518 .7109-17.11-.2656-25.64C348.8 447.3 304.4 464 256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208c0 25.82-4.947 50.46-13.59 73.29c14.69 7.15 28.78 15.9 41.49 26.3C504.8 324.1 512 291.3 512 256c0-141.4-114.6-256-256-256S0 114.6 0 256s114.6 256 256 256c47.43 0 91.7-13.13 129.8-35.62C384.7 470.7 384 464.7 384 458.7C384 454.4 384.2 449.8 384.5 445.1zM411.3 267.3c6.188-6.188 6.156-16.06 .0938-22.34c-6.094-6.281-16.19-6.438-22.53-.4687C388.4 244.1 376.3 256 352 256c-24 0-36.09-10.78-36.84-11.47c-6.219-6.094-16.25-6.031-22.47 .1562c-6.25 6.25-6.25 16.38 0 22.62C294.8 269.4 314.5 288 352 288S409.2 269.4 411.3 267.3zM353.9 336.1c66.59 33.03 64.16 79.69 62.56 110.7C416.2 450.9 416 454.9 416 458.7C416 488.1 437.7 512 464.3 512C490.6 512 512 488.1 512 458.7C512 378.7 412.6 337.8 353.9 336.1z"],
    "face-smile": [512, 512, [61720, "smile"], "1f642", "M336 240c17.68 0 31.99-14.25 31.99-32s-14.31-32-31.99-32c-17.8 0-32.02 14.25-32.02 32S318.2 240 336 240zM175.1 240c17.8 0 32.02-14.25 32.02-32s-14.22-32-32.02-32c-17.68 0-31.99 14.25-31.99 32S158.3 240 175.1 240zM340 312.6C319.2 337.6 288.5 352 256 352s-63.21-14.25-84.04-39.38c-8.477-10.25-23.61-11.5-33.79-3.125C128 318 126.7 333.1 135.1 343.3c29.91 36 74.11 56.73 120.9 56.73s90.94-20.73 120.9-56.73c8.598-10.12 7.145-25.25-3.027-33.75C363.7 301.1 348.5 302.4 340 312.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-smile-beam": [512, 512, [62904, "smile-beam"], "1f60a", "M340 312.6C319.2 337.6 288.5 352 256 352s-63.21-14.25-84.04-39.38c-8.477-10.25-23.61-11.5-33.79-3.125C128 318 126.7 333.1 135.1 343.3c29.91 36 74.11 56.73 120.9 56.73s90.94-20.73 120.9-56.73c8.598-10.12 7.145-25.25-3.027-33.75C363.7 301.1 348.5 302.4 340 312.6zM144.5 210.9c7.75-13.75 19.25-21.62 31.48-21.62c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 231.7 223.2 232.8 226.3 231.8c3.512-1.125 5.934-4.5 5.691-8.375C228.8 181.3 199.8 152 175.1 152c-23.73 0-52.68 29.25-55.95 71.38C119.6 227.1 122.1 230.6 125.7 231.8c3.391 1 7.459-.575 9.397-3.825L144.5 210.9zM336 152c-23.86 0-52.72 29.25-55.99 71.38c-.2422 3.75 2.107 7.25 5.619 8.375c3.512 1 7.387-.575 9.324-3.825l9.566-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.73 7.875 31.48 21.62l9.445 17c2.18 3.75 6.176 4.825 9.324 3.825c3.633-1.125 6.127-4.5 5.764-8.375C388.8 181.3 359.8 152 336 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-smile-halo": [512, 512, [], "e38f", "M294.1 267.9l9.566-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.73 7.875 31.48 21.62l9.445 17c2.18 3.75 6.176 4.826 9.324 3.826c3.633-1.125 6.127-4.5 5.764-8.375c-3.27-42.13-32.29-71.36-56.03-71.36c-23.86 0-52.72 29.23-55.99 71.36c-.2422 3.75 2.107 7.25 5.619 8.375C289.2 272.7 293.1 271.1 294.1 267.9zM171.1 328.7c-8.477-10.25-23.61-11.5-33.79-3.125c-10.17 8.5-11.5 23.62-3.027 33.75c29.91 36 74.11 56.71 120.9 56.71s90.94-20.71 120.9-56.71c8.598-10.12 7.145-25.25-3.027-33.75c-10.17-8.375-25.31-7.125-33.79 3.125C319.2 353.7 288.5 368 256 368S192.8 353.8 171.1 328.7zM175.1 191.1c-23.73 0-52.68 29.23-55.95 71.36C119.6 267.1 122.1 270.6 125.7 271.7c3.391 1 7.459-.5762 9.396-3.826l9.445-17c7.75-13.75 19.25-21.62 31.48-21.62c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 271.6 223.2 272.7 226.3 271.7c3.512-1.125 5.934-4.5 5.691-8.375C228.8 221.2 199.8 191.1 175.1 191.1zM447.8 169.7c-12.31 4.906-18.31 18.88-13.38 31.19C443.4 223.5 448 247.4 448 272c0 105.9-86.13 192-192 192s-192-86.13-192-192c0-24.56 4.562-48.47 13.59-71.09c4.938-12.31-1.062-26.28-13.38-31.19C51.84 164.8 37.97 170.8 33.03 183.1C21.72 211.4 16 241.3 16 272c0 132.3 107.7 240 240 240s240-107.7 240-240c0-30.69-5.719-60.59-17.03-88.91C474.1 170.8 460.1 164.8 447.8 169.7zM256 0C114.6 0 0 32.23 0 72C0 111.8 114.6 144 256 144s256-32.24 256-72C512 32.23 397.4 0 256 0zM256 96C169.6 96 106.7 83.88 72.18 72C106.7 60.12 169.6 48 256 48s149.3 12.12 183.8 24C405.3 83.88 342.4 96 256 96z"],
    "face-smile-hearts": [640, 512, [], "e390", "M566.8 397.1l-6.27 5.635l-5.994-5.828c-15.25-14.9-40.71-17.62-58.2-4.52c-20.03 14.1-21.75 42.45-4.717 59.24l59.01 57.57c3.875 3.592 10.12 3.764 14.18 .1191l62.02-56.26c17.95-16.45 17.64-43.77-1.68-59.19C608.4 380.5 582.9 382.5 566.8 397.1zM145.2 361.9c-16.78-13.41-42.3-11.39-58.35 3.24l-6.27 5.635l-5.994-5.828c-15.25-14.9-40.71-17.62-58.2-4.52c-20.03 14.1-21.75 42.45-4.717 59.24l59.01 57.57c3.875 3.594 10.12 3.764 14.18 .1191l62.02-56.26C164.8 404.6 164.5 377.3 145.2 361.9zM340.2 222.2c-1.816 11.12 11.5 18.12 19.74 10.75l9.566-8.5c14.77-13.25 46.14-13.25 61.03 0L440.2 233c8.355 7.5 21.37 .2187 19.68-10.78c-3.996-25.25-34.09-42.13-59.88-42.13C374.4 180.1 344.2 196.1 340.2 222.2zM522.3 352c11.08 0 21.82 2.947 31.8 7.357c14.03-31.64 21.93-66.56 21.93-103.3c0-23.97-3.313-47.73-9.875-70.61c-3.656-12.75-17.03-20.31-29.66-16.47C523.7 172.6 516.3 185.8 520 198.6C525.3 217.2 528 236.5 528 256c0 35.67-9.045 69.26-24.94 98.63C509.3 353 515.7 352 522.3 352zM320 408c35.16 0 68.38-13.19 96.06-38.19c9.844-8.875 10.62-24.03 1.75-33.88c-8.844-9.844-24.03-10.66-33.88-1.75c-37.5 33.75-90.38 33.75-127.9 0c-9.844-8.938-25.03-8.125-33.88 1.75c-8.875 9.844-8.094 25 1.75 33.88C251.6 394.8 284.8 408 320 408zM266.5 224.5L276.2 233c8.355 7.5 21.37 .2187 19.68-10.78C291.9 196.1 261.8 180.1 235.1 180.1c-25.67 0-55.85 16.88-59.85 42.13C174.3 233.3 187.6 240.3 195.9 232.1l9.566-8.5C220.2 211.2 251.6 211.2 266.5 224.5zM320 464c-50.37 0-96.59-18.02-132.6-47.92c-3.949 10.71-10.22 20.63-19.03 28.7l-10.32 9.364C202.2 490.3 258.6 512 320 512c53.23 0 102.7-16.3 143.7-44.22c-10.89-13.71-16.75-30.82-15.57-48.33C412.8 447.2 368.4 464 320 464zM81.17 330.2c11.41-6.096 24.25-9.344 37.5-9.344c1.338 0 2.635 .2598 3.963 .3281C115.8 300.7 112 278.8 112 256c0-114.7 93.31-208 208-208c30.03 0 59 6.25 86.06 18.56c11.97 5.469 26.28 .1875 31.78-11.91c5.5-12.06 .1562-26.28-11.91-31.78C392.6 7.688 356.9 .0228 320 .0228c-141.2 0-256 114.8-256 255.1c0 24.82 3.702 48.74 10.32 71.45C76.57 328.5 79.04 329 81.17 330.2zM550.7 125.2c3.875 3.594 10.12 3.764 14.18 .1191l62.02-56.26c17.95-16.45 17.64-43.77-1.68-59.19c-16.78-13.41-42.3-11.39-58.35 3.24l-6.27 5.635l-5.994-5.828c-15.25-14.9-40.71-17.62-58.2-4.52c-20.03 14.1-21.75 42.45-4.717 59.24L550.7 125.2z"],
    "face-smile-horns": [640, 512, [], "e391", "M207.1 256c0 17.62 14.36 31.98 32.04 31.98c17.8 0 32.02-14.27 32.02-32.02C282.3 256 291.9 249.3 295.1 238.9C298.8 226.3 291.5 212.8 278.9 209l-80.04-24c-12.84-3.875-26.16 3.375-29.91 16.12C165.2 213.8 172.4 227.3 185.1 231l28.21 8.5C210.2 244.4 207.1 249.8 207.1 256zM404 328.6C383.2 353.6 352.5 368 320 368s-63.21-14.25-84.04-39.38c-8.477-10.25-23.61-11.5-33.79-3.125c-10.17 8.5-11.5 23.62-3.027 33.75c29.91 36 74.11 56.74 120.9 56.74s90.94-20.74 120.9-56.74c8.598-10.12 7.145-25.25-3.027-33.75C427.7 317.1 412.5 318.4 404 328.6zM441.1 185l-80.04 24c-12.59 3.75-19.86 17.25-16.11 29.88C348.1 249.3 357.8 256 368 256c0 17.75 14.18 32 31.98 32c17.68 0 32.08-14.25 32.08-32c0-6.25-2.271-11.75-5.42-16.62l28.21-8.5c12.71-3.625 19.86-17.12 16.11-29.75C467.3 188.4 453.9 181.3 441.1 185zM607.1 15.62c-.1562-5.469-3.094-10.53-7.812-13.34c-4.688-2.812-10.53-3-15.44-.5313c-35.87 18.21-74.93 33.42-115.3 47.08C427.3 18.25 375.8 0 319.9 0c-55.87 0-107.6 18.19-149.8 48.68C129.9 35.06 91.04 19.91 55.29 1.75C50.38-.7187 44.54-.5313 39.85 2.281C35.13 5.094 32.19 10.16 32.04 15.62L32.01 16.88C31.97 17.97 32.07 19.06 32.26 20.12c8.656 48.06 25.7 94.48 50.77 138.5C70.63 188.7 63.87 221.5 63.87 256c0 141.2 114.8 256 256 256s256-114.8 256-256c0-34.22-7.054-66.84-19.29-96.71c25.25-44.19 42.45-90.82 51.2-139.2C607.1 19.06 608 16.72 607.1 15.62zM319.7 464c-114.7 0-208-93.31-208-208s93.31-208 208-208s208 93.31 208 208S434.4 464 319.7 464z"],
    "face-smile-plus": [640, 512, ["smile-plus"], "f5b9", "M224 64C100.3 64 0 164.3 0 288c0 123.7 100.3 224 224 224s224-100.3 224-224C448 164.3 347.7 64 224 64zM224 464c-97.05 0-176-78.95-176-176S126.1 112 224 112s176 78.95 176 176S321 464 224 464zM143.1 272c17.8 0 32.02-14.25 32.02-32s-14.22-32-32.02-32C126.3 208 112 222.3 112 240S126.3 272 143.1 272zM304 272C321.7 272 336 257.8 336 240s-14.31-32-31.99-32c-17.8 0-32.02 14.25-32.02 32S286.2 272 304 272zM306.5 328.8c-20.83 25-51.59 39.38-84.04 39.38s-63.21-14.25-84.04-39.38c-8.477-10.25-23.61-11.5-33.79-3.125c-10.17 8.5-11.5 23.62-3.027 33.75C131.5 395.4 175.7 416 222.4 416s90.94-20.62 120.9-56.63c8.598-10.12 7.145-25.25-3.027-33.75C330.1 317.3 314.9 318.5 306.5 328.8zM616 72h-48V23.1C568 10.75 557.3 0 544 0s-24 10.75-24 23.1V72h-48C458.7 72 448 82.75 448 95.1S458.7 120 471.1 120H520v48C520 181.3 530.8 192 544 192s24-10.75 24-23.1V120h48c13.25 0 24-10.75 24-23.1S629.3 72 616 72z"],
    "face-smile-relaxed": [512, 512, [], "e392", "M202.5 224.5L212.2 233c8.355 7.5 21.37 .2187 19.68-10.78C227.9 196.1 197.8 180.1 171.1 180.1c-25.67 0-55.85 16.88-59.85 42.13C110.3 233.3 123.6 240.3 131.9 232.1l9.566-8.5C156.2 211.2 187.6 211.2 202.5 224.5zM336 180.1c-25.67 0-55.85 16.88-59.85 42.13c-1.816 11.12 11.5 18.12 19.74 10.75l9.566-8.5c14.77-13.25 46.14-13.25 61.03 0L376.2 233c8.355 7.5 21.37 .2187 19.68-10.78C391.9 196.1 361.8 180.1 336 180.1zM319.9 334.2c-37.5 33.75-90.38 33.75-127.9 0c-9.875-8.938-25.06-8.125-33.88 1.75c-8.875 9.844-8.094 25 1.75 33.88C187.6 394.8 220.8 408 256 408s68.38-13.19 96.06-38.19c9.844-8.875 10.62-24.03 1.75-33.88S329.8 325.3 319.9 334.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-smile-tear": [512, 512, [], "e393", "M336 240c17.68 0 31.97-14.25 31.97-32s-14.29-32-31.97-32c-17.8 0-32.09 14.25-32.09 32S318.2 240 336 240zM175.1 240c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32S158.3 240 175.1 240zM256 360c-32.78 0-64.06-14.47-85.84-39.69C161.5 310.3 146.3 309.2 136.3 317.8c-10.03 8.656-11.16 23.81-2.469 33.84C164.7 387.5 209.3 408 256 408c13.25 0 24-10.75 24-24S269.3 360 256 360zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM431.1 369c0 43.56-35.87 79-79.95 79c-4.516 0-8.873-.6016-13.19-1.314C313.4 457.8 285.4 464 256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208c0 40.61-11.88 78.42-32.08 110.5C431.9 367.4 431.1 368.3 431.1 369zM345.6 291.3c-13.08 17.38-41.65 57.75-41.65 77.75c0 26 21.55 47 48.07 47s47.95-21 47.95-47c0-20-28.46-60.38-41.54-77.75C355.2 286.9 348.8 286.9 345.6 291.3z"],
    "face-smile-tongue": [576, 512, [], "e394", "M207.1 152c-23.86 0-52.81 29.25-56.08 71.38c-.6055 8.5 10.9 11.88 15.14 4.5l9.445-17C184.2 197.3 195.7 189.3 207.1 189.3c12.35 0 23.86 8 31.48 21.62l9.594 17.06c4.117 7.375 15.59 3.938 14.87-4.562C260.6 181.3 231.7 152 207.1 152zM544 256c0-141.4-114.6-256-256-256S32 114.6 32 256s114.6 256 256 256c68.58 0 130.4-27.38 176.3-71.34c27.5-.5117 54.11-14.79 68.83-40.26c14.32-24.8 13.81-54.03 1.521-77.74C540.5 301.4 544 279.1 544 256zM491.6 376.4c-9.094 15.69-29.25 21.03-45 12.03l-38.81-22.4c15.68-15.48 28.58-33.73 37.39-54.46l34.36 19.83C495.3 340.5 500.7 360.7 491.6 376.4zM493.9 284.3l-44.31-25.57c-3.326-3.721-7.523-6.719-12.79-7.795c-13.03-2.531-25.69 5.75-28.31 18.75C396.9 326.7 346.3 368 288 368c-54.47 0-101.7-34.97-117.6-87C166.5 268.3 153.2 261.3 140.4 265C127.8 268.9 120.6 282.3 124.5 295C146.6 367.4 212.3 416 288 416c27.63 0 53.81-7.125 77.25-19.1l45.65 26.35C376.4 448.7 334 464 288 464c-114.7 0-208-93.31-208-208S173.3 48 288 48s208 93.31 208 208C496 265.6 495.2 275 493.9 284.3zM368 152c-23.86 0-52.78 29.25-56.05 71.38C311.3 232 322.8 235.3 326.9 227.9l9.566-17c7.629-13.62 19.13-21.62 31.48-21.62c12.23 0 23.73 8 31.48 21.62l9.551 17.06c4.117 7.375 15.52 3.938 14.79-4.562C420.7 181.3 391.8 152 368 152z"],
    "face-smile-upside-down": [512, 512, [], "e395", "M175.1 272c-17.68 0-31.99 14.25-31.99 32s14.31 32 31.99 32c17.8 0 32.02-14.25 32.02-32S193.8 272 175.1 272zM336 272c-17.8 0-32.02 14.25-32.02 32s14.22 32 32.02 32c17.68 0 31.99-14.25 31.99-32S353.7 272 336 272zM171.1 199.4C192.8 174.4 223.5 160 256 160s63.21 14.25 84.04 39.38c8.477 10.25 23.61 11.5 33.79 3.125c10.17-8.5 11.5-23.62 3.027-33.75C346.9 132.8 302.7 112 256 112S165.1 132.8 135.1 168.8C126.6 178.9 128 194 138.2 202.5C148.3 210.9 163.5 209.6 171.1 199.4zM256 512c141.4 0 256-114.6 256-256s-114.6-256-256-256S0 114.6 0 256S114.6 512 256 512zM256 48c114.7 0 208 93.31 208 208s-93.31 208-208 208S48 370.7 48 256S141.3 48 256 48z"],
    "face-smile-wink": [512, 512, [62682, "smile-wink"], "1f609", "M340 312.8C319.2 337.8 288.5 352.1 256 352.1s-63.21-14.38-84.04-39.38c-8.477-10.25-23.61-11.5-33.79-3.125c-10.17 8.5-11.5 23.62-3.027 33.75C165.1 379.4 209.3 400 256 400s90.94-20.62 120.9-56.63c8.598-10.12 7.145-25.25-3.027-33.75S348.5 302.5 340 312.8zM175.1 240c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32S158.3 240 175.1 240zM336 180.1c-25.79 0-55.85 16.88-59.85 42.13c-1.695 11.12 11.5 18.12 19.74 10.75l9.566-8.5c14.77-13.12 46.14-13.12 61.03 0l9.354 8.406c8.477 7.375 21.86 .4687 20.04-10.66C392 196.1 361.7 180.1 336 180.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-smiling-hands": [640, 512, [], "e396", "M281.1 227.9C285.2 235.3 296.7 232 296 223.4C292.8 181.3 263.8 152 239.1 152c-23.73 0-52.68 29.25-55.95 71.38c-.7266 8.5 10.73 11.92 15.09 4.549l9.445-17C216.3 197.3 227.8 189.3 240 189.3c12.35 0 23.86 8 31.48 21.62L281.1 227.9zM254.6 395.6C275.3 403.5 297.3 408 319.1 408c22.66 0 44.52-4.469 65.17-12.32l8.16-57.71c-44.07 28.13-102.6 28.13-146.7 0l7.773 55.12C254.6 393.9 254.5 394.8 254.6 395.6zM431.5 210.9l9.445 17C445.1 235.3 456.7 232 456.1 223.4C452.8 181.3 423.9 152 400 152c-23.73 0-52.72 29.25-55.99 71.38c-.7266 8.5 10.83 11.92 14.94 4.549l9.566-17c7.629-13.62 19.13-21.62 31.48-21.62C412.3 189.3 423.8 197.3 431.5 210.9zM112.1 253.2C113.7 139.8 206.3 48 319.1 48c113.7 0 206.3 91.78 207.9 205.1C536.4 249.9 545.4 248 554.8 248c7.221 0 14.21 1.24 20.95 3.203C573.2 112.1 459.8 0 319.1 0C180.2 0 66.82 112.1 64.24 251.2C71.01 249.2 77.99 248 85.19 248C94.57 248 103.6 249.9 112.1 253.2zM391.1 451.2C368.9 459.3 345 464 319.1 464c-25.03 0-48.92-4.67-71.17-12.81c-3.422 10.62-7.648 21.01-13.6 30.65c-2.66 4.322-5.605 8.387-8.691 12.3C255.5 505.5 286.1 512 319.1 512c33.01 0 64.46-6.465 93.43-17.84c-3.082-3.91-6.025-7.965-8.684-12.28C398.8 472.2 394.6 461.8 391.1 451.2zM216 345.9c-3.203-22.66-22.83-39.74-45.66-39.74c-2.186 0-4.398 .1543-6.629 .4766c-9.373 1.33-17.7 5.42-24.27 11.34L115.3 293.8c-8.055-8.055-18.76-12.49-30.15-12.49c-11.39 0-22.1 4.438-30.16 12.5c-.5957 .5957-1.172 1.207-1.729 1.832C43.23 296.5 33.88 300.8 26.65 307.1C19.24 315.4 15.13 324.9 14.33 334.6c-.6367 .5645-1.258 1.15-1.865 1.758c-13.91 13.91-16.18 35.13-6.803 51.43c-9.375 16.29-7.107 37.51 6.803 51.42l43.68 43.68C74.9 501.7 99.85 512 126.4 512c33.52 0 64.03-17.04 81.6-45.59c13.65-22.17 18.82-48.57 14.54-74.33L216 345.9zM180.7 449.6C169 468.6 148.7 480 126.4 480c-17.98 0-34.9-7.004-47.62-19.73l-43.68-43.68c-4.156-4.156-4.156-10.89 0-15.04c2.078-2.078 4.801-3.115 7.523-3.115c2.721 0 5.443 1.037 7.521 3.115l20.85 20.85l6.234-6.234l-42.13-42.13c-4.156-4.156-4.156-10.89 0-15.04c2.078-2.078 4.801-3.117 7.523-3.117c2.721 0 5.443 1.039 7.521 3.117l42.13 42.13l6.232-6.236l-49.22-49.22c-4.156-4.156-4.156-10.89 0-15.04c2.078-2.078 4.801-3.117 7.523-3.117s5.443 1.039 7.521 3.117l49.22 49.22l6.234-6.234l-42.13-42.13c-4.156-4.154-4.156-10.89 0-15.04c2.076-2.078 4.799-3.117 7.521-3.117s5.445 1.039 7.523 3.117l67.77 67.77l-4.225-29.89c-1.094-7.756 4.309-14.93 12.07-16.03c.6914-.0996 1.377-.1484 2.055-.1484c6.973 0 12.98 5.148 13.97 12.21l6.618 46.98c0-.002 0 0 0 0s-.002-.0137 0 0c0 .0039 0 0 0 0C193.1 415.4 190.3 434 180.7 449.6zM190.1 397.3C190.1 397.3 190.1 397.3 190.1 397.3L190.1 397.3zM627.5 336.4c-.6074-.6055-1.229-1.193-1.865-1.758c-.8008-9.711-4.908-19.2-12.32-26.61c-7.217-7.219-16.57-11.53-26.64-12.35c-.5586-.627-1.137-1.24-1.736-1.84c-8.053-8.053-18.76-12.49-30.15-12.49c-11.39 0-22.1 4.438-30.15 12.49l-24.14 24.14c-6.586-5.924-14.94-10.02-24.34-11.36c-2.152-.3105-4.365-.4648-6.549-.4648c-22.83-.002-42.46 17.08-45.66 39.72l-6.619 47.04c-4.158 24.96 1.004 51.34 14.66 73.52C449.6 494.1 480.1 512 513.6 512c26.54 0 51.49-10.34 70.25-29.11l43.68-43.68c13.91-13.92 16.18-35.13 6.805-51.43C643.7 371.5 641.4 350.3 627.5 336.4zM569 422.4l20.85-20.85c2.078-2.076 4.801-3.115 7.523-3.115s5.443 1.039 7.521 3.115c4.156 4.156 4.156 10.89 0 15.05l-43.68 43.68C548.5 472.1 531.6 480 513.6 480c-22.32 0-42.64-11.35-54.35-30.37c-9.6-15.59-13.22-34.2-10.22-52.28c-.002 .0078 0 0 0 0s-.002 .0156 0 0c.002-.0137 0 0 0 0c-.002 0 .002-.0078 0 0l6.615-47.01c1-7.059 7.002-12.21 13.98-12.21c.6758 0 1.361 .0469 2.053 .1484c7.758 1.1 13.16 8.277 12.07 16.04l-4.225 29.89l67.77-67.77c2.076-2.078 4.799-3.117 7.521-3.117c2.721 0 5.443 1.039 7.521 3.117c4.156 4.156 4.156 10.89 0 15.04l-42.13 42.13l6.234 6.234l49.22-49.22c2.078-2.078 4.801-3.117 7.521-3.117c2.723 0 5.445 1.039 7.523 3.117c4.156 4.156 4.156 10.89 0 15.04l-49.22 49.22l6.234 6.236l42.13-42.13c2.078-2.08 4.801-3.119 7.523-3.119s5.443 1.039 7.521 3.119c4.156 4.154 4.156 10.89 0 15.04l-42.13 42.13L569 422.4z"],
    "face-smirking": [512, 512, [], "e397", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM384 192h-64c-8.844 0-16 7.156-16 16S311.2 224 320 224h32c0 17.67 14.33 32 32 32c17.67 0 32-14.33 32-32C416 206.3 401.7 192 384 192zM192 224c0-17.67-14.33-32-32-32H96C87.16 192 80 199.2 80 208S87.16 224 96 224h32c0 17.67 14.33 32 32 32C177.7 256 192 241.7 192 224zM365.8 304.7c-12.72-3.312-25.88 4.594-29.09 17.47C329.1 349.2 305.8 368 278 368H184C170.8 368 160 378.8 160 392S170.8 416 184 416h94.03c49.88 0 93.16-33.78 105.3-82.19C386.5 320.1 378.7 307.9 365.8 304.7z"],
    "face-sunglasses": [512, 512, [], "e398", "M340 328.6C319.2 353.6 288.5 368 256 368s-63.21-14.25-84.04-39.38c-8.477-10.25-23.61-11.5-33.79-3.125c-10.17 8.5-11.5 23.62-3.027 33.75c29.91 36 74.11 56.73 120.9 56.73s90.94-20.73 120.9-56.73c8.598-10.12 7.145-25.25-3.027-33.75C363.7 317.1 348.5 318.4 340 328.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 48c66.79 0 126.2 31.77 164.3 80.86C417.7 128.4 415.2 128 412.5 128h-97.74c-14.31 0-26.97 6.25-35.71 16H232.1C224.2 134.3 211.6 128 197.3 128H99.52C96.84 128 94.3 128.4 91.75 128.9C129.8 79.77 189.2 48 256 48zM256 464c-114.7 0-208-93.31-208-208c0-18.21 2.592-35.79 7.01-52.64l4.027 27.57C62.48 254.5 82.7 272 106.5 272h84.41c24.09 0 44.45-17.85 47.59-41.73L243.6 192h24.86l5.041 38.27C276.6 254.1 296.1 272 321.1 272h84.41c23.83 0 44.05-17.48 47.5-41.06l4.027-27.57C461.4 220.2 464 237.8 464 256C464 370.7 370.7 464 256 464z"],
    "face-surprise": [512, 512, [62914, "surprise"], "1f62e", "M256 280c-35.36 0-64.06 28.75-64.06 64s28.7 64 64.06 64s64.06-28.75 64.06-64S291.4 280 256 280zM208 208c0-17.75-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32C193.8 240 208 225.8 208 208zM336 176c-17.8 0-32.07 14.25-32.07 32s14.27 32 32.07 32c17.68 0 31.95-14.25 31.95-32S353.7 176 336 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-swear": [640, 512, [], "e399", "M286.5 194.1c3-8.312-1.312-17.5-9.625-20.5L197.4 144.9c-8.375-2.906-17.47 1.344-20.5 9.625c-3 8.312 1.312 17.5 9.625 20.5l30.38 10.95C211.5 191.8 208 199.4 208 208c0 17.67 14.33 32 32 32s32-14.33 32-32c0-1.203-.5098-2.215-.6387-3.383c.0293 0-.0293 0 0 0C277.9 204.6 284.1 200.6 286.5 194.1zM463.1 154.6c-3.031-8.312-12.16-12.53-20.5-9.625l-79.41 28.62c-8.312 3-12.62 12.19-9.625 20.5c2.375 6.5 8.545 10.55 15.11 10.55c.0293 0-.0293 0 0 0C368.5 205.8 368 206.8 368 208c0 17.67 14.33 32 32 32s32-14.33 32-32c0-8.559-3.469-16.24-8.941-21.99l30.38-10.95C461.8 172.1 466.1 162.9 463.1 154.6zM320 48c114.7 0 208 93.31 208 208H576c0-141.4-114.6-256-256-256S64 114.6 64 256h48C112 141.3 205.3 48 320 48zM608 288H32c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32v-160C640 302.3 625.7 288 608 288zM192 336C192 327.2 199.2 320 208 320S224 327.2 224 336v64C224 408.8 216.8 416 208 416S192 408.8 192 400V336zM159.3 431.9C156.6 447.8 144.8 458.3 128 462.2V464C128 472.8 120.8 480 112 480S96 472.8 96 464v-2.279c-6.428-1.496-12.79-3.551-18.5-5.627c-8.312-3-14.06-12.66-11.09-20.97S76.94 422 85.38 424.9L88.34 426c5.75 2.062 12.09 4.469 17.91 5.375c11.41 1.781 20.78-.4062 21.56-4.938c.5625-3.156 .875-5.031-20.22-11.09l-4.344-1.25c-12.12-3.531-44.28-12.97-38.63-46C67.37 352.3 79.34 342 96 338.1V336C96 327.2 103.2 320 112 320S128 327.2 128 336v2.436c4.396 1.02 8.842 2.023 13.22 3.533c8.344 2.875 12.78 12 9.906 20.34c-2.875 8.344-11.97 12.84-20.34 9.906c-4.344-1.5-8.938-2.938-13.09-3.594c-11.22-1.656-20.72 .4062-21.5 4.906c-.5 2.75-.8438 4.906 16.06 9.875l4.156 1.188C133.4 389.5 165.1 398.5 159.3 431.9zM208 480c-13.25 0-24-10.75-24-24c0-13.26 10.75-24 24-24s24 10.74 24 24C232 469.3 221.3 480 208 480zM400 416c8.844 0 16 7.156 16 16S408.8 448 400 448H384v16c0 8.844-7.156 16-16 16S352 472.8 352 464V448h-32v16c0 8.844-7.156 16-16 16S288 472.8 288 464V448H272C263.2 448 256 440.8 256 432S263.2 416 272 416H288v-32H272C263.2 384 256 376.8 256 368S263.2 352 272 352H288v-16C288 327.2 295.2 320 304 320s16 7.156 16 16V352h32v-16c0-8.844 7.156-16 16-16s16 7.156 16 16V352h16c8.844 0 16 7.156 16 16S408.8 384 400 384H384v32H400zM472 328c13.25 0 24 10.74 24 24c0 13.25-10.75 24-24 24S448 365.3 448 352C448 338.7 458.7 328 472 328zM469.1 472c-3.343 0-6.718-1.031-9.593-3.188c-7.062-5.312-8.5-15.34-3.219-22.41l84-112c5.344-7.062 15.38-8.469 22.41-3.219c7.062 5.312 8.5 15.34 3.219 22.41l-84 112C479.7 469.8 474.8 472 469.1 472zM552 472c-13.25 0-24-10.75-24-24c0-13.26 10.75-24 24-24S576 434.7 576 448C576 461.3 565.3 472 552 472zM320 416h32v-32h-32V416z"],
    "face-thermometer": [576, 512, [], "e39a", "M176 208c0 17.67 14.33 32 32 32s32-14.33 32-32c0-17.67-14.33-32-32-32S176 190.3 176 208zM336 208c0 17.67 14.33 32 32 32s32-14.33 32-32c0-17.67-14.33-32-32-32S336 190.3 336 208zM288 464c-114.7 0-208-93.31-208-208S173.3 48 288 48c73.79 0 138.6 38.73 175.5 96.82c13.28-10.24 29.18-16.08 46.13-16.58C465.4 51.66 382.8 0 288 0C146.6 0 32 114.6 32 256s114.6 256 256 256c129.2 0 235.7-95.74 253.2-220.1l-82.22 82.23C421.4 428.4 358.8 464 288 464zM545.9 174.1C536.6 164.7 524.3 160 512 160s-24.56 4.688-33.94 14.06l-156.9 156.9C310.9 329.3 300.1 328 288 328c-73.09 0-111.4 37.44-112.1 39.03c-9.297 9.281-9.281 24.22-.0938 33.63c9.188 9.438 24.34 9.625 33.83 .5C209.8 400.2 235.8 376 288 376s78.16 24.16 79.03 24.97C371.7 405.7 377.9 408 384 408s12.28-2.344 16.97-7.031c5.584-5.584 7.428-13.17 6.359-20.42l138.6-138.6C564.7 223.2 564.7 192.8 545.9 174.1zM523.3 219.3l-15.51 15.51L504.5 231.5c-4.688-4.688-12.28-4.688-16.97 0s-4.688 12.31 0 17l3.303 3.301l-15.02 15.02L472.5 263.5c-4.688-4.688-12.28-4.688-16.97 0s-4.688 12.31 0 17l3.303 3.301l-15.02 15.02L440.5 295.5c-4.688-4.688-12.28-4.688-16.97 0s-4.688 12.31 0 17l3.303 3.301l-15.02 15.02l-3.318-3.316c-4.688-4.688-12.28-4.688-16.97 0s-4.688 12.31 0 17l3.303 3.301l-8.152 8.152c-7.24-4.844-17.04-10.41-29.83-15.41l143.9-143.9c6.768-6.766 16.89-5.73 22.62 0C529.5 202.9 529.5 213.1 523.3 219.3z"],
    "face-thinking": [512, 512, [], "e39b", "M285.2 391.5C286 391.2 320 384 319.8 352c-.1836-30.6-30.38-72-118.7-72H184c-8.844 0-16 7.156-16 16s7.156 16 16 16h17.16c9.064 0 18.04 1.014 26.91 2.559l-89 29.66v-10.69C139.1 308.4 118.6 288 93.53 288S48 308.4 48 333.5v103.4C48 478.3 81.69 512 123.1 512h37.81c32.41 0 61-20.62 71.19-51.31l19.31-57.91L285.2 391.5zM223.5 385.1l-21.84 65.53C195.8 468.2 179.5 480 160.9 480H123.1C99.31 480 80 460.7 80 436.9v-103.4C80 326.1 86.06 320 93.53 320s13.53 6.062 13.53 13.53v32.88c0 5.156 2.469 9.969 6.656 12.97c4.125 3.031 9.5 3.781 14.41 2.219l138.4-46.09c3.469-1.219 7.219-.9062 10.34 .6875c3.219 1.594 5.594 4.375 6.75 7.844c1.156 3.438 .875 7.094-.75 10.34c-1.594 3.219-4.375 5.625-7.781 6.75l-41.41 13.81C228.9 376.5 225.1 380.3 223.5 385.1zM240 160c4.844 0 9.656-2.219 12.81-6.406c5.281-7.062 3.844-17.09-3.219-22.41L224 112c-28.31-21.25-67.75-21.25-96.06 0C120.9 117.3 119.5 127.3 124.8 134.4c5.281 7.031 15.28 8.5 22.41 3.156c16.94-12.69 40.59-12.72 57.59 .0313l25.59 19.19C233.3 158.1 236.7 160 240 160zM175.1 160C158.3 160 143.1 174.3 143.1 192s14.3 32 31.99 32s32.02-14.3 32.02-32S193.7 160 175.1 160zM256 0C114.6 0 0 114.6 0 256c0 31.12 5.832 60.81 16 88.4v-10.87c0-26.03 12.1-48.98 32.73-63.05C48.4 265.7 48 260.9 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208c0 111.7-88.59 202.9-199.2 207.6l-2.426 7.26c-5.131 15.48-13.69 29.05-24.48 40.27C243.9 511.5 249.9 512 256 512c141.4 0 256-114.6 256-256S397.4 0 256 0zM336 240c17.69 0 31.99-14.3 31.99-32s-14.3-32-31.99-32s-32.02 14.3-32.02 32S318.3 240 336 240z"],
    "face-tired": [512, 512, [62920, "tired"], "1f62b", "M256 272c-45.41 0-100.9 38.25-107.8 93.25c-1.574 11.88 6.902 21.62 15.5 18C186.4 373.5 220 368 256 368s69.63 5.486 92.27 15.24c8.477 3.625 17.07-6 15.5-18C356.9 310.3 301.4 272 256 272zM228 208c0-4.25-2.18-8.125-5.812-10.25l-80.04-48c-4.965-3-11.5-2-15.26 2.5s-3.875 11-.1211 15.5L160.5 208l-33.66 40.25c-3.754 4.5-3.633 11 .1211 15.5c3.512 4.125 9.93 5.75 15.26 2.5l80.04-48C225.8 216.1 228 212.3 228 208zM385.1 152.3c-3.754-4.5-10.29-5.5-15.26-2.5l-80.04 48C286.2 199.9 283.1 203.8 283.1 208s2.18 8.125 5.812 10.25l80.04 48c5.328 3.25 11.75 1.625 15.26-2.5c3.754-4.5 3.875-11 .1211-15.5L351.5 208l33.66-40.25C388.1 163.3 388.8 156.6 385.1 152.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-tissue": [512, 512, [], "e39c", "M256 0C114.8 0 .002 114.8 .002 256c0 10.22 .8033 20.24 1.989 30.15c2.393-.7363 4.652-1.874 7.197-2.242l40.24-5.748C48.63 270.9 48 263.5 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208s-93.31 208-208 208c-7.512 0-14.86-.6309-22.16-1.434l-5.742 40.21c-.3691 2.557-1.509 4.825-2.249 7.227C235.8 511.2 245.8 512 256 512C397.2 512 512 397.2 512 256S397.2 0 256 0zM142.2 254.2l80.04-48c7.75-4.625 7.75-15.88 0-20.5l-80.04-48c-11.62-7-23.98 7.625-15.38 18l33.66 40.25l-33.66 40.25C118.2 246.7 130.7 261.1 142.2 254.2zM263.1 322.7l-10.3 6.867l-6.066 42.5l25.24-16.84l39.13 26.09c2.688 1.781 5.781 2.688 8.875 2.688s6.188-.9062 8.875-2.688l48-32c7.344-4.906 9.344-14.84 4.438-22.19c-4.938-7.375-14.94-9.312-22.19-4.438L320 348.8l-39.13-26.09C275.5 319.1 268.5 319.1 263.1 322.7zM369.8 137.7l-80.04 48c-7.629 4.625-7.629 15.88 0 20.5l80.04 48c11.5 6.875 24.1-7.5 15.38-18l-33.66-40.25l33.66-40.25C393.8 145.3 381.5 130.7 369.8 137.7zM205.8 288.2l-192 27.44c-6.938 1-12.44 6.375-13.53 13.28c-1.125 6.906 2.375 13.75 8.625 16.88l35.19 17.59c4.812 2.406 7.281 7.75 5.969 12.97l-22.09 88.38c-1.344 5.438 .2582 11.21 4.227 15.18c3.938 3.938 9.711 5.569 15.18 4.225L135.7 462c5.188-1.375 10.59 1.125 13 5.969l17.59 35.19C169 508.6 174.6 512 180.6 512c.8438 0 1.719-.0625 2.562-.2187c6.906-1.094 12.28-6.594 13.28-13.53l27.44-192c.7187-4.969-.9687-10-4.531-13.56S210.7 287.5 205.8 288.2z"],
    "face-tongue-money": [512, 512, [], "e39d", "M250.7 422.8C250.7 422.8 250.7 422.8 250.7 422.8C250.7 422.8 250.7 422.8 250.7 422.8l3.094 .8958c12.92 3.75 13.86 5.25 13.28 8.625c-.3281 1.938-1.078 2.719-2.094 3.281c-4.297 2.406-14.67 1.156-25.14-3.125c-4.094-1.688-8.766 .2813-10.44 4.375s.2969 8.781 4.375 10.44C236.9 448.6 242.1 450.4 248 451.6V456c0 4.406 3.578 8 8 8s8-3.594 8-8v-3.723c3.062-.457 6.053-1.199 8.734-2.684c5.5-3.062 9-8.094 10.11-14.59c3.203-18.62-14.22-23.66-24.62-26.69l-2.953-.8438c0 0 .0156 0 0 0c-11.08-3.312-10.78-5.156-10.33-7.75c.2031-1.25 .8594-2.219 1.969-2.938c1.688-1.062 7-3.125 20.77 .4375c4.328 1.125 8.641-1.438 9.781-5.656c1.125-4.281-1.422-8.656-5.688-9.781c-2.926-.7832-5.109-.5879-7.766-1.014V376c0-4.406-3.578-8-8-8s-8 3.594-8 8v4.516c-3.482 .6484-7.117 1.117-9.75 2.797c-4.891 3.156-8.125 8.031-9.094 13.72C226 415.4 243.3 420.6 250.7 422.8zM180.4 176.7l-4.891-1.438c-.0156 0 0 0 0 0C159.3 170.3 159.7 168.3 160.2 165.3c.2969-1.75 1.266-2.594 2.094-3.125c1.953-1.25 10.05-4.812 32.48 1.094C203.4 165.6 212.1 160.5 214.3 151.9C216.6 143.4 211.5 134.6 202.1 132.4C199.1 131.3 195.6 130.8 192 130.2V120c0-8.844-7.156-16-16-16S160 111.2 160 120v9.666C154.4 130.9 149.3 132.5 144.1 135.3C136.2 140.1 130.4 149.7 128.6 159.9C122.1 192.8 154.5 202.3 166.4 205.9c.0313 0-.0313-.0313 0 0c.0469 0-.0625 0 0 0l5.156 1.5C192.7 213.5 192.4 215.3 191.8 218.7C191.4 221.4 190.5 221.9 189.7 222.3c-5.562 3.156-20.94 2.281-39.61-5.344C141.9 213.6 132.5 217.6 129.2 225.8c-3.344 8.156 .5938 17.5 8.766 20.84C142.9 248.6 150.9 251.4 160 253.4V264c0 8.844 7.156 16 16 16S192 272.8 192 264V254.8c4.604-.8809 9.076-2.246 13.19-4.525c9.891-5.469 16.19-14.53 18.17-26.16C229.1 190.7 197.4 181.6 180.4 176.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM320 416c0 35.35-28.65 64-64 64c-35.35 0-64-28.65-64-64v-64h128V416zM347.9 442.3c1.639-5.695 2.699-11.57 3.256-17.64c26.17-21.6 44.34-52.42 48.76-87.64C401 327.9 393.9 320 384.8 320h-257.5c-9.121 0-16.28 8.053-15.13 17.05c4.414 35.22 22.59 66.04 48.76 87.64c.5566 6.072 1.617 11.95 3.256 17.64C95.45 408.3 48 337.7 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 337.7 416.5 408.3 347.9 442.3zM340.4 176.7l-4.891-1.438c-.0156 0 0 0 0 0c-16.19-4.875-15.84-6.969-15.33-9.875c.2969-1.75 1.266-2.594 2.094-3.125c1.953-1.25 10.08-4.812 32.48 1.094c8.516 2.312 17.3-2.812 19.56-11.38c2.266-8.531-2.828-17.31-11.38-19.56C359.1 131.3 355.6 130.8 352 130.2V120c0-8.844-7.156-16-16-16S320 111.2 320 120v9.666c-5.564 1.189-10.74 2.877-15.03 5.646c-8.797 5.656-14.59 14.41-16.33 24.62c-5.656 32.84 25.84 42.38 37.77 45.97c.0313 0-.0313-.0313 0 0c.0469 0-.0625 0 0 0l5.156 1.5c21.16 6.094 20.84 7.938 20.27 11.28c-.4531 2.688-1.375 3.188-2.172 3.625c-5.547 3.156-20.94 2.281-39.61-5.344c-8.156-3.344-17.52 .5938-20.86 8.781c-3.344 8.156 .5938 17.5 8.766 20.84C302.9 248.6 310.9 251.4 320 253.4V264c0 8.844 7.156 16 16 16S352 272.8 352 264V254.8c4.604-.8809 9.076-2.246 13.19-4.525c9.891-5.469 16.19-14.53 18.17-26.16C389.1 190.7 357.4 181.6 340.4 176.7z"],
    "face-tongue-sweat": [576, 512, [], "e39e", "M41.6 291.3C28.43 308.6 0 349 0 369C0 395 21.54 416 48 416S96 395 96 369c0-19.1-28.55-60.36-41.6-77.73C51.2 286.9 44.8 286.9 41.6 291.3zM223.1 128.7c-4.844 0-9.656 2.219-12.78 6.375C192.1 160.5 166.6 180.7 137.6 193.4C129.5 196.9 125.8 206.4 129.3 214.4c3.562 8.094 13.06 11.69 21.06 8.25C184.5 207.8 214.3 184.2 236.8 154.3c5.312-7.062 3.906-17.09-3.156-22.41C230.7 129.7 227.3 128.7 223.1 128.7zM288 0C146.6 0 32 114.6 32 256c0 1.189 .1621 2.334 .1777 3.52C37.14 257.4 42.47 256 48 256c12.68 0 24.72 6.129 31.98 16.06c.3379 .4492 .5586 .8047 .8926 1.25C80.4 267.6 80 261.8 80 256c0-114.7 93.31-208 208-208s208 93.31 208 208c0 81.48-47.2 151.1-115.6 186.1C382.5 434.3 384 426.4 384 418v-17.64c9.926-7.164 16-15.43 16-24.37c0-26.51-50.14-48-112-48s-112 21.49-112 48c0 8.938 6.074 17.2 16 24.37v16.8c0 8.771 1.615 17.11 3.896 25.2c-27.18-13.52-51.04-32.78-69.91-56.23c-3.838 17.04-13.39 31.8-26.4 42.75c46.29 50.43 112.4 82.31 186 82.99c.3691 .0078 .7109 .1191 1.08 .123c.1406 0 .2142-.0156 .3548-.0156C287.4 511.1 287.8 512 288.1 512C429.4 512 544 397.4 544 256S429.4 0 288 0zM352 418C352 452.2 323.3 480 287.1 480c-.3027 0-.6074 .002-.9141-.002C252 479.6 224 451.3 224 417.2v-18.47c0-12.06 7.045-23.05 17.97-28.17c.5898-.2734 .6484-.293 .9199-.4062C246.2 368.7 249.6 368 252.1 368c11.29 0 21.84 7.615 24.55 19.19l1.816 7.508C280.4 399.2 284.2 401.4 288 401.4s7.629-2.24 8.658-6.721l1.816-7.508C301.2 375.6 311.7 368 322.1 368c3.342 0 6.746 .6738 10.02 2.117c.2109 .0859 .2871 .1094 .5859 .2422C344.8 375.2 352 386.5 352 398.7V418zM207.9 240c-17.66 0-31.95 14.25-31.95 32s14.28 32 31.95 32c17.79 0 32.07-14.25 32.07-32S225.7 240 207.9 240zM425.6 222.7c8.125 3.438 17.53-.1562 21.06-8.25S446.5 196.9 438.4 193.4c-29.06-12.69-54.5-32.84-73.63-58.28c-3.125-4.188-7.938-6.406-12.78-6.406c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38C361.6 184.2 391.5 207.8 425.6 222.7zM368.1 304C385.7 304 400 289.8 400 272s-14.28-32-31.95-32c-17.79 0-32.07 14.25-32.07 32S350.3 304 368.1 304z"],
    "face-unamused": [512, 512, [], "e39f", "M192 224c0-17.67-14.33-32-32-32H96C87.16 192 80 199.2 80 208S87.16 224 96 224h32c0 17.67 14.33 32 32 32S192 241.7 192 224zM384 192h-64c-8.844 0-16 7.156-16 16S311.2 224 320 224h32c0 17.67 14.33 32 32 32s32-14.33 32-32C416 206.3 401.7 192 384 192zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM255.1 319.7c-33.57 0-65.18 14.84-86.72 40.71c-6.158 7.314-7.551 16.65-3.693 24.94C169.6 394.1 178.7 400 188.1 400c6.881 0 13.28-3.131 18.03-8.816c11.76-14.15 29.95-22.25 49.91-22.25c19.96 0 38.11 8.102 49.8 22.23c4.764 5.672 11.16 8.771 18.05 8.771c9.443 0 18.52-5.842 22.58-14.54c3.846-8.232 2.445-17.57-3.748-24.97C321.2 334.6 289.6 319.7 255.1 319.7z"],
    "face-viewfinder": [512, 512, [], "e2ff", "M24 160C37.25 160 48 149.3 48 136V48h88C149.3 48 160 37.25 160 24S149.3 0 136 0H32C14.33 0 0 14.33 0 32v104C0 149.3 10.75 160 24 160zM136 464H48v-88C48 362.7 37.25 352 24 352S0 362.7 0 376V480c0 17.67 14.33 32 32 32h104C149.3 512 160 501.3 160 488S149.3 464 136 464zM488 352c-13.25 0-24 10.75-24 24v88h-88c-13.25 0-24 10.75-24 24S362.7 512 376 512H480c17.67 0 32-14.33 32-32v-104C512 362.7 501.3 352 488 352zM480 0h-104C362.7 0 352 10.75 352 24s10.75 24 24 24h88v88C464 149.3 474.7 160 488 160S512 149.3 512 136V32C512 14.33 497.7 0 480 0zM416 256c0-88.37-71.63-160-160-160S96 167.6 96 256s71.63 160 160 160S416 344.4 416 256zM256 368c-61.76 0-112-50.24-112-112S194.2 144 256 144c61.76 0 112 50.24 112 112S317.8 368 256 368zM296 240C309.3 240 320 229.3 320 216S309.3 192 296 192S272 202.7 272 216S282.7 240 296 240zM216 240c13.25 0 24-10.75 24-24S229.3 192 216 192S192 202.7 192 216S202.7 240 216 240zM319.4 274.2C311.9 269.8 302 272.4 297.6 280C289 294.8 273.1 304 256 304S222.1 294.8 214.4 280C209.1 272.3 200.1 269.7 192.6 274.2C184.9 278.6 182.3 288.4 186.7 296C200.1 320.7 227.5 336 256 336s55.03-15.31 69.28-39.97C329.7 288.4 327.1 278.6 319.4 274.2z"],
    "face-vomit": [576, 512, [], "e3a0", "M401.8 137.7l-80.04 48c-7.629 4.625-7.629 15.88 0 20.5l80.04 48c11.5 6.875 24.1-7.5 15.38-18l-33.66-40.25l33.66-40.25C425.8 145.3 413.5 130.7 401.8 137.7zM138 432.1c8.033-2.654 14.13-8.441 17.9-15.55C109.6 378.4 80 320.6 80 256c0-114.7 93.31-208 208-208s208 93.31 208 208c0 64.61-29.62 122.4-75.99 160.6c3.758 7.135 9.84 12.95 17.87 15.62l26.64 8.881C513.4 394.5 544 328.9 544 256c0-141.4-114.6-256-256-256S32 114.6 32 256c0 72.8 30.53 138.3 79.31 184.1L138 432.1zM174.2 254.2l80.04-48c7.75-4.625 7.75-15.88 0-20.5l-80.04-48c-11.62-7-23.98 7.625-15.38 18l33.66 40.25l-33.66 40.25C150.2 246.7 162.7 261.1 174.2 254.2zM467.3 475.8l-39.54-13.18C401.6 453.9 384 429.4 384 401.9v-65.64c8.771 3.623 16.31 7.73 22.06 12.3C409 350.9 412.5 352 416 352c4.719 0 9.375-2.062 12.53-6.062c5.5-6.906 4.344-16.97-2.594-22.47C398.4 301.6 345.5 288 288 288s-110.4 13.59-137.9 35.47c-6.938 5.5-8.094 15.56-2.594 22.47c5.5 6.969 15.56 8.094 22.47 2.594C175.7 343.1 183.2 339.9 192 336.2v65.51c0 27.61-17.71 52.11-43.92 60.77l-40.19 13.28c-7.609 2.514-12.75 9.625-12.75 17.64C95.14 503.7 103.5 512 113.7 512h347.7C471.7 512 480 503.7 480 493.4C480 485.4 474.9 478.3 467.3 475.8zM240 448C231.2 448 224 440.8 224 432C224 423.2 231.2 416 240 416S256 423.2 256 432C256 440.8 248.8 448 240 448zM304 416c-8.836 0-16-7.164-16-16c0-8.838 7.164-16 16-16s16 7.162 16 16C320 408.8 312.8 416 304 416zM544 416c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 430.3 561.7 416 544 416zM32 448c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C64 462.3 49.67 448 32 448z"],
    "face-weary": [512, 512, [], "e3a1", "M256 288c-45.46 0-100.9 38.28-107.8 93.4c-1.482 11.7 6.887 21.44 15.47 17.83C186.4 389.5 220.1 384 256 384s69.61 5.469 92.29 15.2c8.477 3.609 16.95-6.016 15.47-17.83C356.9 326.3 301.5 288 256 288zM212.3 164.9c-2.533-2.611-5.709-4.15-9.012-4.666C198.5 159.4 193.4 160.9 189.7 164.5C166.8 186.7 138.6 202.7 107.9 210.8C99.39 213 94.29 221.8 96.53 230.3c2.27 8.545 11.1 13.56 19.54 11.4c35.95-9.439 69.12-28.2 95.89-54.22C218.3 181.3 218.5 171.2 212.3 164.9zM404.1 210.8c-30.67-8.049-58.92-24.04-81.74-46.22c-3.732-3.654-8.83-5.104-13.62-4.355c-3.303 .5156-6.479 2.057-8.98 4.66c-6.193 6.314-6.035 16.44 .3047 22.6c26.75 26.06 59.92 44.82 95.9 54.25c8.559 2.143 17.3-2.861 19.54-11.4S412.6 213 404.1 210.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-woozy": [512, 512, [], "e3a2", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM204.8 121.6c5.312-7.062 3.906-17.09-3.156-22.41C198.7 97.03 195.3 96 192 96C187.2 96 182.3 98.22 179.2 102.4C160.1 127.8 134.6 148 105.6 160.7C97.5 164.2 93.81 173.7 97.34 181.8C100.9 189.8 110.4 193.4 118.4 190C152.5 175.1 182.3 151.5 204.8 121.6zM350.3 332.1l-24.31 26.41c-9.375 11-24.16 12.62-35.28 3.969l-6.156-4.844c-18.62-14.56-43.13-19.28-65.63-12.78l-30.12 8.875c-9.625 2.906-19.72-.4375-26.56-8.469C153.7 335.3 138.6 334 128.4 342.6c-10.09 8.594-11.31 23.72-2.719 33.84c19 22.34 49.19 31.53 76.69 23.41l30.09-8.875c7.719-2.25 15.94-.625 22.5 4.5l6.125 4.812c13.47 10.56 29.44 15.69 45.28 15.69c20.75 0 41.28-8.781 55.56-25.56l23.69-25.69c8.969-9.75 8.343-24.94-1.375-33.94C374.5 321.8 359.4 322.4 350.3 332.1zM352.3 263.2C364.6 244.8 367.5 226.3 368 207.1c-.6055-18.38-3.391-36.88-15.74-55.25c-7.992-11.75-25.07-11.5-32.7 0c-12.35 18.38-15.14 36.88-15.74 55.25c.6055 18.38 3.391 36.88 15.74 55.25C327.6 274.1 344.6 274.7 352.3 263.2zM140.1 224.5C131.5 226.6 126.3 235.3 128.5 243.9C130.3 251.2 136.8 256 144 256c1.281 0 2.594-.1562 3.875-.4687l64-16c8.594-2.156 13.78-10.84 11.66-19.41c-2.125-8.594-11-13.78-19.41-11.66L140.1 224.5z"],
    "face-worried": [512, 512, [], "e3a3", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 336c-69.66 0-93.66 53.06-94.66 55.31c-2.75 6.312-1.156 13.69 3.969 18.28c5.125 4.625 12.69 5.438 18.62 2.031C184.3 411.4 220.9 390.8 256 390.8s71.72 20.56 72.06 20.78c2.469 1.406 5.211 2.094 7.93 2.094c3.844 0 7.695-1.406 10.7-4.125c5.125-4.594 6.719-11.97 3.969-18.28C349.7 389.1 325.7 336 256 336zM208 144C208 135.2 200.8 128 192 128C138 128 102.2 163.2 100.7 164.7C94.47 170.9 94.47 180.1 100.7 187.3C103.8 190.4 107.9 191.1 112 191.1c4.062 0 8.156-1.536 11.25-4.599C123.5 187.1 151.6 160 192 160C200.8 160 208 152.8 208 144zM208 272c0-17.75-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32C193.8 304 208 289.8 208 272zM411.3 164.7C409.8 163.2 374 128 320 128c-8.844 0-16 7.156-16 16S311.2 160 320 160c40.41 0 68.47 27.09 68.75 27.38C391.8 190.5 395.9 192 400 192c4.094 0 8.188-1.562 11.31-4.688C417.6 181.1 417.6 170.9 411.3 164.7zM336 240c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 240 336 240z"],
    "face-zany": [512, 512, [], "e3a4", "M484.1 141.5C440.1 51.81 349.8-.0189 255.9-.0189c-38.47 0-77.66 8.667-114.4 27.04C15.05 90.26-36.2 244 27.03 370.5c44.49 88.98 133.8 140.6 226.9 141.4c.2871 .0059 .8047 .0859 1.092 .0898c.4043 .002 .6719 .028 1.076 .028c38.48 0 77.62-8.669 114.4-27.05C496.9 421.7 548.2 267.1 484.1 141.5zM320 418C320 452.2 291.4 480 256.1 480c-.3008 0-.7031-.002-1.006-.0059C220.1 479.6 192 451.3 192 417.2v-25.54c0-12.06 7.045-23.05 17.97-28.17c.5898-.2734 .6484-.293 .9199-.4062c3.305-1.443 6.729-2.117 10.09-2.117c11.29 0 21.84 7.615 24.55 19.19l1.816 7.508C248.4 392.1 252.2 394.3 256 394.3s7.629-2.24 8.658-6.721l1.816-7.508c2.707-11.57 13.26-19.19 24.49-19.19c3.342 0 6.746 .6738 10.02 2.117c.2109 .0859 .2871 .1094 .5859 .2422C312.8 368.1 320 379.4 320 391.7V418zM349 442c-.2305 .1152-.4707 .1895-.7012 .3027C350.5 434.5 352 426.5 352 418v-14.46c58.67-35.57 84.69-106.1 62.2-170.7c-3.215-9.154-13.72-13.27-22.33-8.959l-243.1 121.6c-8.613 4.307-11.57 15.29-6.232 23.24c5.23 7.84 11.22 14.93 17.7 21.43C160.2 390.6 160 391.1 160 391.6v25.54c0 8.723 1.598 17.02 3.857 25.07c-39.81-19.66-73.12-51.64-93.9-93.2C18.67 246.4 60.4 121.3 162.1 69.96C192.2 55.35 223.4 47.94 255.8 47.94c79.4 0 150.8 44.08 186.2 115C493.3 265.6 451.6 390.7 349 442zM144 208C135.2 208 128 215.2 128 224c0 8.836 7.164 16 16 16C152.8 240 160 232.8 160 224C160 215.2 152.8 208 144 208zM144 160c-35.35 0-64 28.65-64 64c0 35.35 28.65 64 64 64c35.35 0 64-28.65 64-64C208 188.7 179.3 160 144 160zM144 256c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S161.6 256 144 256zM312.1 80c-39.84 0-72.05 32.25-72.05 72S272.2 224 312.1 224C351.8 224 384 191.8 384 152S351.8 80 312.1 80zM312.1 192c-22.09 0-40.05-17.95-40.05-40c0-2.832 1.057-5.322 1.619-7.99C276.9 153.3 285.5 160 296 160c13.32 0 23.98-10.75 23.98-24c0-10.41-6.664-19.05-15.94-22.38C306.7 113.1 309.2 112 312.1 112C334.1 112 352 129.9 352 152C352 174.1 334.1 192 312.1 192z"],
    "face-zipper": [576, 512, [], "e3a5", "M351.9 304l-.0615 32c0 8.836 7.16 16 15.99 16s15.99-7.164 15.99-16l.0352-32c0-8.838-7.146-16-15.98-16S351.9 295.2 351.9 304zM287.1 304v32c0 8.836 7.165 16 15.1 16c8.836 0 15.1-7.164 15.1-16v-32c0-8.838-7.161-16-15.1-16C295.1 288 287.1 295.2 287.1 304zM431.6 443.9l-14.62-25.12C381.5 446.1 336.7 464 287.9 464c-114.6 0-207.9-93.31-207.9-208s93.27-208 207.9-208c114.6 0 207.9 93.31 207.9 208c0 17.53-2.416 34.47-6.52 50.75l43.08 25.06C539.8 307.8 543.1 282.4 543.1 256c0-141.4-114.7-256-255.1-256S32 114.6 32 256s114.6 256 255.1 256c58.8 0 112.7-20.04 155.9-53.39c-4.166-3.965-8.055-8.279-11.3-13.19C432.3 444.9 431.9 444.4 431.6 443.9zM399.1 208c0-17.75-14.3-32-31.97-32c-17.79 0-32.06 14.25-32.06 32s14.27 32 32.06 32C385.7 240 399.1 225.8 399.1 208zM240 208c0-17.75-14.27-32-32.06-32c-17.67 0-31.97 14.25-31.97 32s14.3 32 31.97 32C225.7 240 240 225.8 240 208zM239.1 352c8.834 0 15.1-7.164 15.1-16v-32c0-8.838-7.163-16-15.1-16c-8.832 0-15.1 7.162-15.1 16v32C223.1 344.8 231.1 352 239.1 352zM524.2 364.1L448.4 319.1l-32.78 32.81l43.62 74.95c2.117 3.201 4.596 5.975 7.285 8.43c.5527 .4941 1.174 .8604 1.744 1.329c.0098-.0098-.0117 .0117 0 0c17.6 14.52 44.38 14.16 61.84-3.302C550.7 413.6 548.1 379.1 524.2 364.1zM514 402l-16.4 16.41c-3.631 3.631-8.795 3.533-13.14 1.352c-1.076-.543-2.361-.4512-3.26-1.352c-4.516-4.518-4.516-11.89 0-16.41l16.4-16.4c4.518-4.518 11.88-4.518 16.4 0C518.6 390.1 518.6 397.5 514 402zM159.1 304v32c0 8.836 7.163 16 15.1 16s15.1-7.164 15.1-16v-32c0-8.838-7.162-16-15.1-16S159.1 295.2 159.1 304z"],
    "family": [512, 512, [], "e300", "M256 224c26.53 0 48-21.47 48-48S282.5 128 256 128S208 149.5 208 176S229.5 224 256 224zM288 256H224C197.5 256 176 277.5 176 304V384c0 17.67 14.33 32 32 32v64c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-64c17.67 0 32-14.33 32-32V304C336 277.5 314.5 256 288 256zM288 368H224v-64h64V368zM384 128c35.38 0 64-28.62 64-64s-28.62-64-64-64s-64 28.62-64 64S348.6 128 384 128zM128 128c35.38 0 64-28.62 64-64S163.4 0 128 0S64 28.62 64 64S92.63 128 128 128zM80 224c0-8.822 7.178-16 16-16h87.12C178.7 198.2 176 187.5 176 176c0-4.561 .6107-8.963 1.347-13.32C171.8 161.1 166.1 160 160 160H96C60.65 160 32 188.7 32 224v96c0 17.67 14.33 32 32 32v136C64 501.3 74.75 512 88 512s24-10.75 24-24V352h32V304h-64V224zM505.5 343.2l-39.08-136.8C458.6 178.9 433.5 160 404.9 160h-41.86c-10.08 0-19.34 3.043-27.95 7.299C335.4 170.2 336 173 336 176c0 11.46-2.699 22.19-7.121 32h76.05c7.145 0 13.42 4.734 15.38 11.6L453.6 336H368V384h32v104c0 13.25 10.75 24 24 24S448 501.3 448 488V384h26.78C496 384 511.4 363.7 505.5 343.2z"],
    "family-dress": [512, 512, [], "e301", "M256 224c26.53 0 48-21.47 48-48S282.5 128 256 128S208 149.5 208 176S229.5 224 256 224zM288 256H224C197.5 256 176 277.5 176 304V384c0 17.67 14.33 32 32 32v64c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-64c17.67 0 32-14.33 32-32V304C336 277.5 314.5 256 288 256zM288 368H224v-64h64V368zM384 128c35.38 0 64-28.62 64-64s-28.62-64-64-64s-64 28.62-64 64S348.6 128 384 128zM505.5 343.2l-39.08-136.8C458.6 178.9 433.5 160 404.9 160h-41.86c-10.08 0-19.34 3.043-27.95 7.299C335.4 170.2 336 173 336 176c0 11.46-2.699 22.19-7.121 32h76.05c7.145 0 13.42 4.734 15.38 11.6L453.6 336H368V384h32v104c0 13.25 10.75 24 24 24S448 501.3 448 488V384h26.78C496 384 511.4 363.7 505.5 343.2zM128 128c35.38 0 64-28.62 64-64S163.4 0 128 0S64 28.62 64 64S92.63 128 128 128zM91.69 219.6C93.65 212.7 99.93 208 107.1 208h76.05C178.7 198.2 176 187.5 176 176c0-2.98 .5605-5.805 .8789-8.701C168.3 163 159 160 148.9 160H107.1C78.5 160 53.39 178.9 45.54 206.4l-39.08 136.8C.6105 363.7 15.96 384 37.22 384H64v104C64 501.3 74.75 512 88 512s24-10.75 24-24V384h32v-48H58.43L91.69 219.6z"],
    "family-pants": [448, 512, [], "e302", "M224 224c26.53 0 48-21.47 48-48S250.5 128 224 128S176 149.5 176 176S197.5 224 224 224zM256 256H192C165.5 256 144 277.5 144 304V384c0 17.67 14.33 32 32 32v64c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-64c17.67 0 32-14.33 32-32V304C304 277.5 282.5 256 256 256zM256 368H192v-64h64V368zM96 128c35.38 0 64-28.62 64-64S131.4 0 96 0S32 28.62 32 64S60.63 128 96 128zM48 224c0-8.822 7.178-16 16-16h87.12C146.7 198.2 144 187.5 144 176c0-4.561 .6107-8.963 1.347-13.32C139.8 161.1 134.1 160 128 160H64C28.65 160 0 188.7 0 224v96c0 17.67 14.33 32 32 32v136C32 501.3 42.75 512 56 512s24-10.75 24-24V352h32V304h-64V224zM352 128c35.38 0 64-28.62 64-64s-28.62-64-64-64s-64 28.62-64 64S316.6 128 352 128zM384 160h-64c-6.055 0-11.8 1.111-17.35 2.682C303.4 167 304 171.4 304 176c0 11.46-2.699 22.19-7.121 32H384c8.822 0 16 7.178 16 16v80h-64V352h32v136c0 13.25 10.75 24 24 24S416 501.3 416 488V352c17.67 0 32-14.33 32-32V224C448 188.7 419.3 160 384 160z"],
    "fan": [512, 512, [], "f863", "M255.1 223.1c-17.62 0-31.1 14.38-31.1 32s14.38 32 31.1 32s31.1-14.38 31.1-32S273.6 223.1 255.1 223.1zM511.7 265.1c-10.75-84.88-82.98-149.1-168.2-149.1c-14.25 0-28.37 1.125-42.49 3.625l7.748-77.13c1.125-11.75-3.125-23.38-11.62-31.62s-20.37-12.12-31.99-10.5C180.1 10.99 116 83.24 116 168.5c0 14.25 1.125 28.5 3.623 42.5L42.55 203.2c-11.62-1.25-23.24 3-31.37 11.38c-8.373 8.502-12.37 20.5-10.87 32.25c10.75 85 82.98 149.1 168.2 149.1c14.25 0 28.37-1.125 42.49-3.625L203.3 469.5c-1.25 11.62 3 23.25 11.37 31.38C222 508 231.8 512 242 512c1.623 0 3.373-.125 4.998-.25c84.86-10.75 148.1-83 148.1-168.3c0-14.25-1.125-28.38-3.623-42.5l77.11 7.875c11.62 1.125 23.25-3.125 31.37-11.5C509.2 288.9 513.2 276.1 511.7 265.1zM350.1 248.6c-11.73-1.184-20.67 10.29-16.65 21.37l4.328 11.95c6.748 18.62 10.25 39.38 10.25 61.63c0 57.25-40.49 106.5-95.85 118.6l11.32-112.1c1.184-11.73-10.29-20.67-21.37-16.65l-11.94 4.328c-18.62 6.875-39.37 10.25-61.61 10.25c-57.24 0-106.3-40.5-118.6-95.88l112 11.32c11.73 1.186 20.67-10.29 16.65-21.37L174.3 230.1C167.5 211.5 164 190.7 164 168.5c0-57.25 40.49-106.4 95.85-118.6L248.6 161.9c-1.184 11.73 10.29 20.67 21.37 16.65l11.94-4.326c18.62-6.75 39.37-10.25 61.61-10.25c57.24 0 106.5 40.5 118.6 95.88L350.1 248.6z"],
    "fan-table": [448, 512, [], "e004", "M353.1 266.3c5.125 .875 10.25-.5 14.25-3.875c3.875-3.25 6.125-8.125 6.125-13.38c.125-34.13-19.75-65.13-50.75-79.5S256.1 160 229.1 182.1L195.6 90.25c-2.625-6.875-13-15.88-25.12-9C150.4 92.88 135.6 112 129.6 134.5C120.8 167.6 132 220.5 185 239.4L122.4 315.5c-8.75 10.62-1.75 22.5 4.75 26.25c42 24.25 95.63 9.875 119.8-32.13c10.38-18 13.88-39.13 10-59.5L353.1 266.3zM224 240C215.1 240 208 232.9 208 224S215.1 208 224 208s16 7.125 16 16S232.9 240 224 240zM360 464h-112v-17.38C360.4 434.8 448 339.6 448 224c0-123.8-100.3-224-224-224S0 100.3 0 224c0 115.6 87.63 210.8 200 222.6V464h-112C74.75 464 64 474.7 64 488C64 501.3 74.75 512 88 512h272c13.25 0 24-10.75 24-24C384 474.7 373.3 464 360 464zM48 224c0-97 79-176 176-176s176 79 176 176s-79 176-176 176S48 321 48 224z"],
    "farm": [576, 512, ["barn-silo"], "f864", "M400 224h-64C327.1 224 320 231.1 320 240v64c0 8.875 7.125 16 16 16h64c8.875 0 16-7.125 16-16v-64C416 231.1 408.9 224 400 224zM572.6 246.3l-55.52-111c-3.303-6.605-8.855-11.97-15.61-14.96L381 66.76c-8.285-3.68-17.72-3.685-26.01 .0029L234.5 120.4C229.4 122.6 223.5 128.4 224 128.4c-2 2-3.75 4.38-5.125 6.88L163.4 246.3C161.2 250.7 160 255.6 160 260.5V480c0 17.67 14.33 32 32 32h352c17.67 0 32-14.33 32-32V260.5C576 255.6 574.8 250.7 572.6 246.3zM528 464H416V416c0-17.67-14.33-32-32-32h-32c-17.67 0-32 14.33-32 32v48H208V264.3l51.25-102.4L368 113.5l108.8 48.38L528 264.3V464zM136 144H48v-32c0-35.28 28.72-64 64-64c26.56 0 49.97 16 59.66 40.75c4.812 12.34 18.78 18.44 31.09 13.59c12.34-4.812 18.44-18.75 13.59-31.09C199.4 27.97 158.5 0 112 0C50.25 0 0 50.25 0 112v376C0 501.3 10.75 512 24 512s24-10.75 24-24V192h88C149.3 192 160 181.3 160 168S149.3 144 136 144z"],
    "faucet": [512, 512, [], "e005", "M512 368v32c0 26.51-21.49 48-48 48h-64c-26.51 0-48-21.49-48-48V384h-28.88C299.8 413 264.3 432 224 432S148.3 413 124.9 384H24C10.75 384 0 373.3 0 360c0-13.26 10.75-24 24-24h126.8C163.5 365.1 192.3 384 224 384s60.5-18.88 73.25-48H368c17.6 0 32 14.4 32 32v32h64v-32c0-53.02-42.98-96-96-96h-70.75C284.5 242.9 255.8 224 224 224S163.5 242.9 150.8 272H24C10.75 272 0 261.3 0 248C0 234.7 10.75 224 24 224h100.9C143.5 200.9 169.6 184.3 200 178.4V147.6C200 147.6 81.38 160 80 160C71.25 160 64 152.5 64 143.1V112.9c0-9.375 7.238-16.85 15.99-16.85c1.375 0-6.113-.7881 120 13.34V80c0-8.838 7.164-16 16-16h16c8.836 0 16 7.162 16 16v29.38c126.1-14.12 118.6-13.34 120-13.34C376.8 96.04 384 103.5 384 112.9v30.24C384 152.5 376.8 160 368 160c-1.375 0-120-12.38-120-12.38v30.75C278.4 184.3 304.5 200.9 323.1 224H368C447.5 224 512 288.5 512 368z"],
    "faucet-drip": [512, 512, [57350], "1f6b0", "M416 480c0 17.62 14.38 32 32 32s32-14.38 32-32s-32-64-32-64S416 462.4 416 480zM368 160h-44.88C304.5 136.9 278.4 120.2 248 114.4V83.62C248 83.62 366.6 96 368 96C376.8 96 384 88.5 384 79.12V48.89c0-9.375-7.242-16.86-15.99-16.86c-1.375 0 6.117-.7754-120 13.35V16c0-8.837-7.163-16-16-16h-16c-8.837 0-16 7.163-16 16v29.38C73.88 31.25 81.37 32.03 79.99 32.03C71.24 32.03 64 39.51 64 48.89V79.12C64 88.5 71.25 96 80 96c1.375 0 120-12.38 120-12.38v30.75C169.6 120.2 143.5 136.9 124.9 160H23.1C10.75 160 0 170.7 0 183.1S10.75 208 23.1 208H150.8C163.5 178.9 192.3 160 224 160s60.5 18.88 73.25 48H368c53.02 0 96 42.98 96 96v32h-64v-32c0-17.6-14.4-32-32-32h-70.75C284.5 301.1 255.8 320 224 320S163.5 301.1 150.8 272H23.1C10.75 272 0 282.7 0 295.1S10.75 320 23.1 320h100.9C148.2 349 183.8 368 224 368s75.75-19 99.13-48H352v16c0 26.51 21.49 48 48 48h64c26.51 0 48-21.49 48-48v-32C512 224.5 447.5 160 368 160z"],
    "fax": [512, 512, [128439, 61868], "1f4e0", "M352 432h32c8.875 0 16-7.125 16-16v-32c0-8.875-7.125-16-16-16h-32c-8.875 0-16 7.125-16 16v32C336 424.9 343.1 432 352 432zM352 336h32c8.875 0 16-7.125 16-16V288c0-8.875-7.125-16-16-16h-32c-8.875 0-16 7.125-16 16v32C336 328.9 343.1 336 352 336zM256 336h32c8.875 0 16-7.125 16-16V288c0-8.875-7.125-16-16-16h-32C247.1 272 240 279.1 240 288v32C240 328.9 247.1 336 256 336zM464 192H176L175.1 48h222.1L432 81.94V160H480V81.94c0-12.73-5.057-24.94-14.06-33.94l-33.94-33.94C423 5.057 410.8 0 398.1 0H175.1c-26.51 0-48 21.49-48 48l.0059 82.26C122.9 128.9 117.6 128 112 128H64C28.65 128 0 156.7 0 192v256c0 35.35 28.65 64 64 64h400c26.47 0 48-21.53 48-48v-224C512 213.5 490.5 192 464 192zM128 448c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V192c0-8.822 7.178-16 16-16h48C120.8 176 128 183.2 128 192V448zM464 464H173.7C175.1 458.9 176 453.6 176 448V240h288V464zM256 432h32c8.875 0 16-7.125 16-16v-32c0-8.875-7.125-16-16-16h-32c-8.875 0-16 7.125-16 16v32C240 424.9 247.1 432 256 432z"],
    "feather": [512, 512, [62765], "1fab6", "M467.1 44.85C438.3 15.97 401.7 0 361.7 0c-46.75 0-98.01 21.88-146.9 70.63L129.1 156.3c-74.99 75.12-72.23 196.4-56.24 248.9l-65.84 65.77c-9.374 9.374-9.374 24.6 0 33.98c9.374 9.374 24.6 9.374 33.98 0l65.64-65.62c17.37 5.25 42.36 9.138 70.86 9.138c57.12 0 127.1-15.56 178.1-65.56l85.75-85.75C531.1 206.6 529.6 107.5 467.1 44.85zM147.4 398.6l46.62-46.62h123.1c-44.5 41.87-106.7 48.5-140.5 48.5C166 400.5 156.1 399.6 147.4 398.6zM350.6 319.1H226l63.1-63.1h123.7c-2.25 2.375-3.1 4.875-6.375 7.25L350.6 319.1zM438.9 223.1h-116.9l22.5-22.5c9.374-9.374 9.374-24.62 0-33.1c-9.374-9.374-24.62-9.374-33.1 0l-196.1 196.1c-5.25-45.87-.25-124.2 49.5-174.1l85.74-85.74c36.1-36.1 75.99-56.62 112.9-56.62c26.62 0 51.37 10.75 71.49 30.87C472.2 117.1 473.1 171.1 438.9 223.1z"],
    "feather-pointed": [512, 512, ["feather-alt"], "f56b", "M481.2 0c-.7578 0-1.514 .0299-2.284 .0846C362.5 8.436-2.977 61.97 75.11 402.1l-68.07 68.07c-9.375 9.375-9.375 24.56 0 33.94c4.688 4.688 10.81 7.031 16.97 7.031s12.28-2.344 16.97-7.031l68.13-68.13c32.43 7.434 62.3 11.16 89.74 11.16c261.1 0 305.5-309.5 313.1-414.9C513.2 15.04 498.1 0 481.2 0zM198.8 400c-15.38 0-31.8-1.74-48.63-4.275L193.9 352h141.2C284.7 392 231.6 400 198.8 400zM380.2 304H241.9l48-48h119.8C400.6 274.4 390.6 289.9 380.2 304zM429.5 208h-91.54l7.031-7.031c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0l-195.1 195.1C105 291.4 116.4 233.6 150.6 186.4c73.56-101.5 238.6-129.2 311.8-136.7C456.5 113.7 444.6 165.2 429.5 208z"],
    "fence": [576, 512, [], "e303", "M569.6 66.14l-44.8-59.73C521.6 2.14 516.8 0 512 0c-4.801 0-9.6 2.14-12.8 6.407l-44.8 59.73C450.2 71.68 448 78.42 448 85.34v394.7c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V85.34C576 78.42 573.8 71.68 569.6 66.14zM528 464h-32V90.67L512 69.33l16 21.33V464zM128 85.34C128 78.42 125.8 71.68 121.6 66.14L76.8 6.407C73.6 2.14 68.8 0 64 0C59.2 0 54.4 2.14 51.2 6.407L6.4 66.14C2.246 71.68 0 78.42 0 85.34v394.7c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V416h64v-64H128V224h64V160H128V85.34zM80 464h-32V90.67l16-21.33L80 90.67V464zM352 85.34c0-6.924-2.246-13.66-6.4-19.2l-44.8-59.73C297.6 2.14 292.8 0 288 0C283.2 0 278.4 2.14 275.2 6.407L230.4 66.14C226.2 71.68 224 78.42 224 85.34v394.7c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V416h64v-64h-64V224h64V160h-64V85.34zM304 464h-32V90.67L288 69.33l16 21.33V464z"],
    "ferris-wheel": [512, 512, [], "e174", "M512 256c0 22.68-15.78 41.57-36.92 46.59c-5.904 27.9-17.01 53.85-32.25 76.86c8.557 17.85 5.902 39.7-8.891 54.49c-8.646 8.645-19.83 12.84-31.14 13.51l-37.66-80.22c.3477-.3711 .5625-.8145 .9238-1.176c9.373-9.371 21.66-14.06 33.94-14.06c1.01 0 1.961 .5143 2.969 .5768c12.6-19.1 21.53-40.79 25.9-64.08C426.5 285.9 424.4 283.1 422.7 280h-90.91c2.508-7.773 4.248-15.78 4.248-24c0-8.416-1.666-16.38-4.086-24h90.75c1.779-3.059 3.822-5.914 6.211-8.496c-4.373-23.29-13.3-44.98-25.9-64.08C401.1 159.5 401 160 400 160c-4.002 0-7.869-1.295-11.77-2.291l-61.58 61.58c-7.592-14.54-19.4-26.35-33.94-33.94l61.58-61.58c-1.248-4.887-2.027-9.736-1.713-14.74c-19.1-12.6-40.79-21.53-64.08-25.9C285.9 85.52 283.1 87.56 280 89.34v90.74C272.4 177.7 264.4 176 255.1 176C247.6 176 239.6 177.7 232 180.1V89.34c-3.059-1.779-5.914-3.822-8.496-6.211C200.2 87.51 178.5 96.44 159.4 109c.3145 5.004-.4648 9.854-1.713 14.74L219.3 185.3C204.7 192.9 192.9 204.7 185.3 219.3L123.8 157.7C119.9 158.7 116 160 112 160C110.1 160 110 159.5 109 159.4C96.44 178.5 87.51 200.2 83.13 223.5C85.52 226.1 87.56 228.9 89.34 232h90.73C177.7 239.6 175.1 247.6 175.1 256c0 8.225 1.74 16.23 4.248 24H89.34c-1.779 3.059-3.822 5.914-6.211 8.496c4.373 23.29 13.3 44.98 25.9 64.08C110 352.5 110.1 352 112 352c12.28 0 24.57 4.686 33.94 14.06c.3555 .3555 .5684 .791 .9102 1.156l-37.68 80.23c-11.31-.6758-22.47-4.869-31.12-13.51c-14.79-14.79-17.45-36.64-8.891-54.49c-15.23-23.01-26.34-48.96-32.25-76.86C15.78 297.6 0 278.7 0 256s15.78-41.57 36.93-46.59C42.83 181.5 53.94 155.6 69.17 132.6c-8.557-17.85-5.902-39.7 8.891-54.49C87.43 68.69 99.72 64 112 64c7.104 0 14.01 2.032 20.55 5.167C155.6 53.94 181.5 42.83 209.4 36.93C214.4 15.78 233.3 0 256 0s41.57 15.78 46.59 36.93c27.9 5.904 53.85 17.01 76.86 32.24C385.1 66.03 392.9 64 400 64c12.28 0 24.57 4.687 33.94 14.06c14.79 14.79 17.45 36.64 8.891 54.49c15.23 23.01 26.33 48.96 32.24 76.86C496.2 214.4 512 233.3 512 256zM382 478.5c3.219 7.406 2.469 15.94-1.969 22.69C375.6 507.9 368.1 512 359.1 512H151.1c-8.094 0-15.62-4.062-20.06-10.84c-4.438-6.75-5.188-15.28-1.969-22.69l89.82-191.3C212.5 278.8 207.1 267.1 207.1 256c0-26.51 21.49-48 48-48s48 21.49 48 48c0 11.97-4.541 22.78-11.79 31.19L382 478.5zM255.1 323L189.8 464h132.4L255.1 323zM255.1 208c26.51 0 48 21.49 48 48c0 11.97-4.541 22.78-11.79 31.19l89.82 191.3c3.219 7.406 2.469 15.94-1.969 22.69C375.6 507.9 368.1 512 359.1 512H151.1c-8.094 0-15.62-4.062-20.06-10.84c-4.438-6.75-5.188-15.28-1.969-22.69l89.82-191.3C212.5 278.8 207.1 267.1 207.1 256C207.1 229.5 229.5 208 255.1 208z"],
    "field-hockey-stick-ball": [512, 512, [62540, "field-hockey"], "1f3d1", "M424 335.1c-48.61 0-88.06 39.42-88.06 88.01c0 48.59 39.44 88.01 88.06 88.01s87.94-39.42 87.94-88.01C511.1 375.4 472.7 335.1 424 335.1zM424 463.1c-22.09 0-40.06-17.95-40.06-40.01s17.97-40.01 40.06-40.01c22.02 0 39.94 17.95 39.94 40.01S446.1 463.1 424 463.1zM512 69.12c0-5.412-.851-29.12-23.64-44.25l-24.14-16.1C455.3 2.84 445.1 0 435.1 0c-16.1 0-33.74 8.118-43.98 23.12L155.3 370.4c-3.264 4.647-8.247 6.721-11.92 6.721c-5.541 0-8.546-5.585-8.546-9.874c0-2.792 1.114-4.767 1.824-5.785l8.906-12.78c8.187-11.74 12.11-25.22 12.11-38.56c0-31.83-25.09-67.66-67.32-67.66c-6.721 0-35.98 .9878-55.37 28.93L26.14 284.1c-10.26 14.73-26.14 43.33-26.14 83.53C.0012 452.9 69.81 512 142.1 512c72.6 0 113.1-50.18 123.5-65.1l236.3-348C508.9 89.93 512 79.66 512 69.12zM226.9 419.6c-7.126 10.21-34.61 44.42-84.72 44.42c-47.71 0-94.2-39.97-94.2-96.61c0-26.93 10.64-46.09 17.51-55.95l8.906-12.75c1.119-1.61 6.099-8.314 15.89-8.314c12.17 0 19.42 10.34 19.42 19.57c0 3.87-1.138 7.778-3.509 11.18l-8.906 12.78c-9.069 12.98-10.44 25.99-10.44 33.06c0 17.32 7.724 38.72 29.68 51.07c8.312 4.75 17.54 7.018 26.85 7.018c19.35 0 39.03-9.805 51.44-27.49l173.5-255.5l31.16 23.37L226.9 419.6z"],
    "file": [384, 512, [128459, 61787, 61462], "1f4c4", "M365.3 93.38l-74.63-74.64C278.6 6.743 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.35 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM320 464H64.02c-8.836 0-15.1-7.163-16-15.1L48 64.13c-.0004-8.837 7.163-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1v288C336 456.8 328.8 464 320 464z"],
    "file-arrow-down": [384, 512, ["file-download"], "f56d", "M216 342.1V240c0-13.25-10.75-24-24-24S168 226.8 168 240v102.1L128.1 303C124.3 298.3 118.2 296 112 296S99.72 298.3 95.03 303c-9.375 9.375-9.375 24.56 0 33.94l80 80c9.375 9.375 24.56 9.375 33.94 0l80-80c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0L216 342.1zM365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448z"],
    "file-arrow-up": [384, 512, ["file-upload"], "f574", "M175 223l-80 80c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L168 297.9V400c0 13.25 10.75 24 24 24s24-10.75 24-24V297.9l39.03 39.03C259.7 341.7 265.8 344 272 344s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94l-80-80C199.6 213.7 184.4 213.7 175 223zM365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448z"],
    "file-audio": [384, 512, [], "f1c7", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM171.5 259.5L136 296H92C85.38 296 80 301.4 80 308v56C80 370.7 85.38 376 92 376H136l35.5 36.5C179.1 420 192 414.8 192 404v-136C192 257.3 179.1 251.9 171.5 259.5zM235.1 260.7c-6.25 6.25-6.25 16.38 0 22.62C235.3 283.5 256 305.1 256 336c0 30.94-20.77 52.53-20.91 52.69c-6.25 6.25-6.25 16.38 0 22.62C238.2 414.4 242.3 416 246.4 416s8.188-1.562 11.31-4.688C258.1 410.1 288 380.5 288 336s-29.05-74.06-30.28-75.31C251.5 254.4 241.3 254.4 235.1 260.7z"],
    "file-binary": [384, 512, [], "e175", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM216 264C216 277.3 226.8 288 240 288v80c-13.25 0-24 10.75-24 24S226.8 416 240 416H288c13.25 0 24-10.75 24-24S301.3 368 288 368V264c0-13.25-10.75-24-24-24H240C226.8 240 216 250.8 216 264zM144 240H128c-30.88 0-56 25.12-56 56v64C72 390.9 97.13 416 128 416h16c30.88 0 56-25.12 56-56v-64C200 265.1 174.9 240 144 240zM152 360c0 4.406-3.594 8-8 8H128c-4.406 0-8-3.594-8-8v-64C120 291.6 123.6 288 128 288h16c4.406 0 8 3.594 8 8V360z"],
    "file-certificate": [512, 512, ["file-award"], "f5f3", "M247.4 338.3c7.5-7.5 10.37-18.5 7.625-28.75c-5.375-20.62-5.5-17.75 0-38.38c2.748-10.38-.125-21.38-7.625-28.88C232.5 227.1 233.1 229.6 228.5 209C225.9 198.8 217.1 190.8 207.9 188C187.5 182.4 190 183.9 175.1 168.8C167.8 161.3 156.1 158.3 146.9 161c-20.37 5.5-17.49 5.5-37.74 0C99.01 158.3 88.26 161.3 80.89 168.8C65.89 183.9 68.39 182.4 48.14 188C38.02 190.8 30.23 198.8 27.48 209c-5.375 20.75-4 18.12-18.87 33.25c-7.375 7.5-10.33 18.5-7.582 28.88c5.375 20.62 5.375 17.75 0 38.38c-2.75 10.25 .207 21.25 7.582 28.75c14.87 15.12 13.5 12.62 18.87 33.25c2.75 10.38 10.54 18.38 20.67 21.12c14.37 3.875 11.5 3 15.87 5V512l63.99-32l63.99 32v-114.4c4.25-2 1.499-1.125 15.87-5c9.998-2.75 17.1-10.75 20.62-21.12C233.1 350.8 232.5 353.4 247.4 338.3zM128 352c-35.37 0-63.99-28.62-63.99-64S92.64 224 128 224s63.99 28.62 63.99 64S163.4 352 128 352zM493.3 93.38l-74.63-74.64C406.6 6.742 390.3 0 373.4 0L191.1-.0001c-35.35 0-64 28.65-64 64l.0105 68.94c0 0 22.02-10.7 48-.7539L176 64.13c0-8.836 7.164-16 16-16h160L352 128c0 17.67 14.33 32 32 32h79.1v288c0 8.836-7.164 16-16 16H224L223.1 512l224-.0001c35.2 0 64-28.8 64-64V138.6C512 121.7 505.3 105.4 493.3 93.38z"],
    "file-chart-column": [384, 512, ["file-chart-line"], "f659", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM192 256C178.8 256 168 266.8 168 280v128c0 13.25 10.75 24 24 24s24-10.75 24-24v-128C216 266.8 205.3 256 192 256zM256 408c0 13.25 10.75 24 24 24s24-10.75 24-24v-96C304 298.8 293.3 288 280 288S256 298.8 256 312V408zM104 320c-13.25 0-24 10.75-24 24v64c0 13.25 10.75 24 24 24S128 421.3 128 408v-64C128 330.8 117.3 320 104 320z"],
    "file-chart-pie": [384, 512, [], "f65a", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM176 240c-53.02 0-96 42.98-96 96s42.98 96 96 96s96-42.98 96-96h-96V240zM208 304h96c0-53.02-42.98-96-96-96V304z"],
    "file-check": [384, 512, [], "f316", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM166.7 324.7L136.1 295c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l48 48C155.5 381.5 161.7 384 168 384c.3125 0 .625 0 .9062-.0313c6.688-.25 12.97-3.281 17.31-8.344l96-112c8.625-10.06 7.469-25.22-2.594-33.84c-10.03-8.594-25.19-7.469-33.84 2.594L166.7 324.7z"],
    "file-code": [384, 512, [], "f1c9", "M162.1 257.8c-7.812-7.812-20.47-7.812-28.28 0l-48 48c-7.812 7.812-7.812 20.5 0 28.31l48 48C137.8 386.1 142.9 388 148 388s10.23-1.938 14.14-5.844c7.812-7.812 7.812-20.5 0-28.31L128.3 320l33.86-33.84C169.1 278.3 169.1 265.7 162.1 257.8zM365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM221.9 257.8c-7.812 7.812-7.812 20.5 0 28.31L255.7 320l-33.86 33.84c-7.812 7.812-7.812 20.5 0 28.31C225.8 386.1 230.9 388 236 388s10.23-1.938 14.14-5.844l48-48c7.812-7.812 7.812-20.5 0-28.31l-48-48C242.3 250 229.7 250 221.9 257.8z"],
    "file-contract": [384, 512, [], "f56c", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM96 128h80C184.8 128 192 120.8 192 112S184.8 96 176 96H96C87.16 96 80 103.2 80 112S87.16 128 96 128zM96 192h80C184.8 192 192 184.8 192 176S184.8 160 176 160H96C87.16 160 80 167.2 80 176S87.16 192 96 192zM196.6 363.4l-13.88-41.63C179.5 311.9 170.4 305.3 160 305.3s-19.5 6.625-22.75 16.5L119 376.4C117.5 380.9 113.3 384 108.4 384H96c-8.875 0-16 7.125-16 16S87.13 416 96 416h12.38c18.62 0 35.13-11.88 41-29.5L160 354.6L176.9 405c2 6.25 7.5 10.5 14 11H192c5.1 0 11.62-3.375 14.25-8.875l7.75-15.38C216.8 386.3 221.9 385.6 224 385.6s7.25 .625 10.12 6.5C241.5 406.9 256.4 416 272.8 416H288c8.875 0 16-7.125 16-16S296.9 384 288 384h-15.25c-4.125 0-8.125-2.5-10.12-6.5C250.8 353.6 216.4 347.1 196.6 363.4z"],
    "file-csv": [384, 512, [], "f6dd", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM179.5 298.5C178.1 297.3 177.4 295.9 177.4 294.6C177.4 291.5 181.8 288 187.8 288H192c8.801 0 16-7.203 16-16C208 263.2 200.8 256 192 256H187.8C164.4 256 145.4 273.4 145.4 294.6c0 10.62 4.875 20.88 13.25 28.12L180.5 341.5c1.375 1.25 2.125 2.625 2.125 3.875C182.6 348.5 178.3 352 172.3 352H168c-8.801 0-16 7.199-16 16c0 8.797 7.199 16 16 16h4.25c23.38 0 42.38-17.38 42.38-38.63c0-10.62-4.875-20.88-13.25-28.12L179.5 298.5zM112 288C120.8 288 128 280.8 128 272C128 263.2 120.8 256 112 256C85.49 256 64 277.5 64 304v32C64 362.5 85.49 384 112 384C120.8 384 128 376.8 128 368C128 359.2 120.8 352 112 352C103.2 352 96 344.8 96 336v-32C96 295.2 103.2 288 112 288zM256 272C256 263.2 248.8 256 240 256S224 263.2 224 272v12.75c0 35.5 12.88 69 36.25 94.13C263.3 382.1 267.5 384 272 384s8.75-1.875 11.75-5.125C307.1 353.8 320 320.3 320 284.8V272C320 263.2 312.8 256 304 256S288 263.2 288 272v12.75c0 20.38-5.75 40.25-16 56.88C261.8 325 256 305.1 256 284.8V272z"],
    "file-dashed-line": [576, 512, ["page-break"], "f877", "M160 288c0-13.25-10.75-24-24-24h-112C10.75 264 0 274.8 0 288s10.75 24 24 24h112C149.3 312 160 301.3 160 288zM552 264h-112C426.8 264 416 274.8 416 288s10.75 24 24 24h112C565.3 312 576 301.3 576 288S565.3 264 552 264zM248 264C234.8 264 224 274.8 224 288s10.75 24 24 24h80C341.3 312 352 301.3 352 288s-10.75-24-24-24H248zM144 224L144 64.13c0-8.836 7.164-16 16-16h160V128c0 17.67 14.33 32 32 32h79.99v64H480V138.6c0-16.98-6.742-33.26-18.74-45.26l-74.63-74.64C374.6 6.742 358.3 0 341.4 0H160C124.7 0 96 28.65 96 64l.0078 160H144zM432 448c0 8.836-7.164 16-16 16H160c-8.838 0-16-7.164-16-16l-.0039-96h-47.1l-.0091 96c0 35.34 28.65 64 64 64H416c35.2 0 64-28.8 64-64v-96h-47.1V448z"],
    "file-excel": [384, 512, [], "f1c3", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM229.1 233.3L192 280.9L154.9 233.3C146.8 222.8 131.8 220.9 121.3 229.1C110.8 237.2 108.9 252.3 117.1 262.8L161.6 320l-44.53 57.25c-8.156 10.47-6.25 25.56 4.188 33.69C125.7 414.3 130.8 416 135.1 416c7.156 0 14.25-3.188 18.97-9.25L192 359.1l37.06 47.65C233.8 412.8 240.9 416 248 416c5.125 0 10.31-1.656 14.72-5.062c10.44-8.125 12.34-23.22 4.188-33.69L222.4 320l44.53-57.25c8.156-10.47 6.25-25.56-4.188-33.69C252.2 220.9 237.2 222.8 229.1 233.3z"],
    "file-exclamation": [384, 512, [], "f31a", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM192 336c13.25 0 24-10.75 24-24v-96C216 202.8 205.3 192 192 192S168 202.8 168 216v96C168 325.3 178.8 336 192 336zM191.1 368C174.3 368 160 382.3 160 400s14.33 32 32 32c17.67 0 32-14.33 32-32S209.7 368 191.1 368z"],
    "file-export": [576, 512, ["arrow-right-from-file"], "f56e", "M568.1 303l-80-80c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L494.1 296H216C202.8 296 192 306.8 192 320s10.75 24 24 24h278.1l-39.03 39.03C450.3 387.7 448 393.8 448 400s2.344 12.28 7.031 16.97c9.375 9.375 24.56 9.375 33.94 0l80-80C578.3 327.6 578.3 312.4 568.1 303zM360 384c-13.25 0-24 10.74-24 24V448c0 8.836-7.164 16-16 16H64.02c-8.836 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1v72c0 13.25 10.74 24 23.1 24S384 245.3 384 232V138.6c0-16.98-6.742-33.26-18.75-45.26l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H63.1C28.65 0-.002 28.66 0 64l.0065 384c.002 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64v-40C384 394.7 373.3 384 360 384z"],
    "file-heart": [384, 512, [], "e176", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM199.3 264.5l-7.391 7.664l-7.389-7.664c-18.74-19.37-49.27-22.55-69.83-5.031C91.11 279.6 89.83 315.6 110.9 337.5l72.62 74.86c4.713 4.816 12.21 4.816 16.92 0l72.62-74.86c21.1-21.89 19.81-57.9-3.859-78.04C248.8 241.1 218.1 245.1 199.3 264.5z"],
    "file-image": [384, 512, [61893], "1f5bb", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM215.3 292c-4.68 0-9.051 2.34-11.65 6.234L164 357.8l-11.68-17.53C149.7 336.3 145.3 334 140.7 334c-4.682 0-9.053 2.34-11.65 6.234l-46.67 70c-2.865 4.297-3.131 9.82-.6953 14.37C84.09 429.2 88.84 432 93.1 432h196c5.163 0 9.907-2.844 12.34-7.395c2.436-4.551 2.17-10.07-.6953-14.37l-74.67-112C224.4 294.3 220 292 215.3 292zM128 288c17.67 0 32-14.33 32-32S145.7 224 128 224S96 238.3 96 256S110.3 288 128 288z"],
    "file-import": [512, 512, ["arrow-right-to-file"], "f56f", "M263 383C258.3 387.7 256 393.8 256 400s2.344 12.28 7.031 16.97c9.375 9.375 24.56 9.375 33.94 0l80-80c9.375-9.375 9.375-24.56 0-33.94l-80-80c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L302.1 296H24C10.75 296 0 306.8 0 320s10.75 24 24 24h278.1L263 383zM493.3 93.38l-74.63-74.64C406.6 6.742 390.3 0 373.4 0H192C156.7 0 127.1 28.66 128 64l.0078 168c.002 13.26 10.75 24 24 24s24-10.75 23.1-24L176 64.13c0-8.836 7.162-16 16-16h160L352 128c0 17.67 14.33 32 32 32h79.1v288c0 8.836-7.164 16-16 16H192c-8.838 0-16-7.164-16-16l-.002-40C176 394.7 165.3 384 152 384s-24 10.75-23.1 24L128 448c.002 35.34 28.65 64 64 64H448c35.2 0 64-28.8 64-64V138.6C512 121.7 505.3 105.4 493.3 93.38z"],
    "file-invoice": [384, 512, [], "f570", "M80 256v64c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32V256c0-17.67-14.33-32-32-32h-160C94.33 224 80 238.3 80 256zM365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM96 128h80C184.8 128 192 120.8 192 112S184.8 96 176 96H96C87.16 96 80 103.2 80 112S87.16 128 96 128zM96 192h80C184.8 192 192 184.8 192 176S184.8 160 176 160H96C87.16 160 80 167.2 80 176S87.16 192 96 192zM288 384h-80c-8.844 0-16 7.156-16 16s7.156 16 16 16H288c8.844 0 16-7.156 16-16S296.8 384 288 384z"],
    "file-invoice-dollar": [384, 512, [], "f571", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM96 128h80C184.8 128 192 120.8 192 112S184.8 96 176 96H96C87.16 96 80 103.2 80 112S87.16 128 96 128zM192 176C192 167.2 184.8 160 176 160H96C87.16 160 80 167.2 80 176S87.16 192 96 192h80C184.8 192 192 184.8 192 176zM197.5 308.8L191.1 307.2C168.3 300.2 168.8 296.1 169.6 292.5c1.375-7.812 16.59-9.719 30.27-7.625c5.594 .8438 11.73 2.812 17.59 4.844c10.39 3.594 21.83-1.938 25.45-12.34c3.625-10.44-1.891-21.84-12.33-25.47c-7.219-2.484-13.11-4.078-18.56-5.273V240c0-11.03-8.953-20-20-20s-20 8.969-20 20v5.992C149.6 250.8 133.8 264.8 130.2 285.7c-7.406 42.84 33.19 54.75 50.52 59.84l5.812 1.688c29.28 8.375 28.8 11.19 27.92 16.28c-1.375 7.812-16.59 9.75-30.31 7.625c-6.938-1.031-15.81-4.219-23.66-7.031l-4.469-1.625c-10.41-3.594-21.83 1.812-25.52 12.22c-3.672 10.41 1.781 21.84 12.2 25.53l4.266 1.5c7.758 2.789 16.38 5.59 25.06 7.512V416c0 11.03 8.953 20 20 20s20-8.969 20-20v-6.254c22.36-4.793 38.21-18.53 41.83-39.43C261.3 327 219.8 315.1 197.5 308.8z"],
    "file-lines": [384, 512, [128462, 61788, 61686, "file-alt", "file-text"], "1f5b9", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM96 280C96 293.3 106.8 304 120 304h144C277.3 304 288 293.3 288 280S277.3 256 264 256h-144C106.8 256 96 266.8 96 280zM264 352h-144C106.8 352 96 362.8 96 376s10.75 24 24 24h144c13.25 0 24-10.75 24-24S277.3 352 264 352z"],
    "file-lock": [576, 512, [], "e3a6", "M543.1 320L544 272C544 227.9 508.1 192 464 192S384 227.9 384 272V320c-17.68 0-32 14.33-32 32.01v127.1C352 497.7 366.3 512 384 512h159.1C561.7 512 576 497.7 576 479.1v-127.1C576 334.3 561.7 320 543.1 320zM496 320h-64V272c0-17.64 14.34-32 32-32s32 14.36 32 32V320zM360.4 192C373.4 192 384 181.4 384 168.4V138.6c0-16.97-6.742-33.25-18.74-45.25l-74.64-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 .0007 28.65 .0007 64l.0059 384c0 35.35 28.66 64 64 64h232.4c13.06 0 23.64-10.58 23.64-23.64v-.7207C320 474.6 309.4 464 296.4 464H64.02c-8.836 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 127.1c0 17.67 14.33 32 32 32H336v8.357C336 181.4 346.6 192 359.6 192H360.4z"],
    "file-magnifying-glass": [384, 512, ["file-search"], "f865", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM176 208c-53.02 0-96 42.98-96 96s42.98 96 96 96c17.77 0 34.21-5.16 48.48-13.58l46.55 46.55C275.7 437.7 281.8 440 288 440s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94l-46.55-46.55C266.8 338.2 272 321.8 272 304C272 250.1 229 208 176 208zM176 352C149.5 352 128 330.5 128 304S149.5 256 176 256S224 277.5 224 304S202.5 352 176 352z"],
    "file-medical": [384, 512, [], "f477", "M224 240C224 231.2 216.8 224 208 224h-32C167.2 224 160 231.2 160 240V288H112C103.2 288 96 295.2 96 303.1V336c0 8.797 7.199 15.1 16 15.1l48 .0006v47.1C160 408.8 167.2 416 176 416h32c8.801 0 16-7.201 16-16v-47.1l48-.0006c8.801 0 16-7.201 16-15.1V303.1C288 295.2 280.8 288 272 288H224V240zM365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448z"],
    "file-minus": [384, 512, [], "f318", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.66 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.836 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32H336V448zM112 280c-13.26 0-24 10.74-24 23.1c0 13.26 10.73 23.1 24 23.1h160c13.26 0 24-10.74 24-23.1s-10.74-23.1-24-23.1H112z"],
    "file-music": [384, 512, [], "f8b6", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM144 255.3V370C138.8 368.8 133.4 368 128 368c-26.5 0-48 14.38-48 32s21.5 32 48 32s48-14.38 48-32V299.1l96-37.5V338C266.8 336.8 261.4 336 256 336c-26.5 0-48 14.38-48 32s21.5 32 48 32s48-14.38 48-32v-160c0-5.125-2.375-9.875-6.5-12.88S288 191.3 283.3 192.8l-128 47.25C148.5 242.1 144 248.3 144 255.3z"],
    "file-pdf": [384, 512, [], "f1c1", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM202 286.1c.877-2.688 1.74-5.398 2.582-8.145c1.434-5.762 7.488-31.54 7.488-52.47C212.1 207 197.1 192 178.6 192C160.1 192 145.1 207 145.1 225.5c0 .2969 .1641 28.81 13.85 62.3c-7.035 19.36-15.57 38.8-25.41 57.93c-21.49 10.11-39.24 22.23-52.8 36.07c-6.234 6.438-9.367 14.74-9.367 24.72c0 18.45 15.01 33.46 33.46 33.46c10.8 0 20.98-5.227 27.22-13.98c7.322-10.28 18.38-26.9 30.47-48.95c15.8-6.352 33.88-11.72 53.88-16c13.55 9.578 28.9 17.29 45.71 22.95c4.527 1.551 9.402 2.348 14.43 2.348c20.26 0 36.13-16.19 36.13-36.86c0-20.33-16.54-36.87-36.87-36.87h-3.705c-2.727 .125-20.51 1.141-45.37 5.367C216.9 308.9 208.6 298.3 202 286.1zM110.2 410.4c-3.273 4.688-12.03 2.777-12.03-5.312c0-1.754 .6289-3.43 1.729-4.555c9.02-9.219 19.94-17.05 31.85-23.72C122.3 393.1 114.3 404.7 110.2 410.4zM178.6 218.8c3.693 0 6.703 3.008 6.703 6.703c0 15.21-4.109 34.84-5.746 42.1C172.1 245 171.9 227.2 171.9 225.5C171.9 221.8 174.9 218.8 178.6 218.8zM162.3 348.3c6.611-13.48 13.22-28.46 19.38-44.7c6.389 10.92 14.56 21.86 24.96 31.97C192.6 338.8 177.4 342.9 162.3 348.3zM272.4 339.5h3.352c5.539 0 10.05 4.5 10.05 10.79c0 5.129-4.176 9.32-9.32 9.32c-2.029 0-4.059-.3164-5.852-.9414c-12.33-4.137-23.11-9.32-32.54-15.19C258.3 340.3 272.1 339.5 272.4 339.5z"],
    "file-pen": [384, 512, [62236, "file-edit"], "1f4dd", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM95.08 360.9c-1.955 1.953-3.287 4.445-3.83 7.156l-11.11 55.54c-.9785 4.895 3.34 9.215 8.236 8.234l55.55-11.11c2.709-.543 5.197-1.871 7.152-3.828l97.62-97.6l-56.01-56.01L95.08 360.9zM215.3 240.7l56.01 56.01l24.48-24.48c10.94-10.93 10.94-28.66 .002-39.6L279.4 216.2c-10.93-10.93-28.66-10.93-39.6 0L215.3 240.7z"],
    "file-plus": [384, 512, [], "f319", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.66 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.836 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32H336V448zM216 223.1C216 210.7 205.3 200 192 200S168 210.7 168 223.1V280H112c-13.26 0-24 10.74-24 23.1c0 13.26 10.73 23.1 24 23.1h56v56C168 397.3 178.7 408 192 408c13.26 0 24-10.74 24-23.1V327.1h56c13.26 0 24-10.74 24-23.1s-10.74-23.1-24-23.1h-56V223.1z"],
    "file-plus-minus": [384, 512, [], "e177", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM216 232V192c0-13.25-10.75-24-24-24S168 178.8 168 192v40H128C114.8 232 104 242.8 104 256S114.8 280 128 280h40V320c0 13.25 10.75 24 24 24s24-10.75 24-24V280H256c13.25 0 24-10.75 24-24S269.3 232 256 232H216zM256 376H128c-13.25 0-24 10.75-24 24S114.8 424 128 424h128c13.25 0 24-10.75 24-24S269.3 376 256 376z"],
    "file-powerpoint": [384, 512, [], "f1c4", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM200 224H128C119.2 224 112 231.2 112 240v168c0 13.25 10.75 24 24 24S160 421.3 160 408v-32h44c44.21 0 79.73-37.95 75.69-82.98C276.1 253.2 240 224 200 224zM204 328H160V272h44c15.44 0 28 12.56 28 28S219.4 328 204 328z"],
    "file-prescription": [384, 512, [], "f572", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM206.5 311.9c22.46-12.29 36.94-37.2 32.79-65.51C234.6 214.6 205.6 192 173.5 192H96C87.16 192 80 199.2 80 208v152.1C80 373.3 90.75 384 103.1 384S128 373.3 128 360.1V320h18.75l59.25 59.25l-24.43 24.53c-9.318 9.352-9.303 24.49 .0352 33.82c9.348 9.348 24.66 9.371 34.01 .0273L240 413.3l24.35 24.45c9.385 9.426 24.72 9.398 34.07-.0586c9.297-9.398 9.279-24.57-.0703-33.92l-24.35-24.35l24.25-24.35c9.367-9.406 9.311-24.63-.1289-33.97c-9.4-9.297-24.54-9.254-33.89 .0938L240 345.4L206.5 311.9zM176 272H128v-32h48C184.9 240 192 247.1 192 256S184.9 272 176 272z"],
    "file-signature": [576, 512, [], "f573", "M48.02 448L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1v94.18L384 206.5V138.6c0-16.98-6.742-33.26-18.74-45.26l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H63.93C28.58 0 0 28.65 0 64l.0065 384c0 35.34 28.58 64 63.93 64H320c29.65 0 54.53-20.52 61.71-48H64.02C55.18 464 48.02 456.8 48.02 448zM292.7 342.3C289.7 345.3 288 349.4 288 353.7V383.9L272.8 384c-4.125 0-8.125-2.5-10.12-6.5c-11.88-23.88-46.25-30.38-66-14.12l-13.88-41.63C179.5 311.9 170.4 305.3 160 305.3s-19.5 6.625-22.75 16.5L119 376.4C117.5 380.9 113.3 384 108.4 384H96c-8.875 0-16 7.125-16 16S87.13 416 96 416h12.38c18.62 0 35.13-11.88 41-29.5L160 354.6L176.9 405c2 6.25 7.5 10.5 14 11H192c5.999 0 11.62-3.375 14.25-8.875l7.749-15.38C216.8 386.3 221.9 385.6 224 385.6s7.25 .625 10.12 6.5C241.5 406.9 256.4 416 272.8 416h77.59c4.264 0 8.35-1.703 11.35-4.727l156.9-158l-67.88-67.88L292.7 342.3zM568.5 167.4L536.6 135.5c-9.875-10-26-10-36 0l-27.25 27.25l67.88 67.88l27.25-27.25C578.5 193.4 578.5 177.3 568.5 167.4z"],
    "file-slash": [640, 512, [], "e3a7", "M639.1 487.1c0-7.119-3.153-14.16-9.191-18.89l-118.8-93.12l.0013-237.3c0-16.97-6.742-33.26-18.74-45.26l-74.63-74.64C406.6 6.742 390.3 0 373.4 0H192C156.7 0 128 28.65 128 64L128 75.01L38.82 5.11C34.41 1.672 29.19 0 24.04 0C10.19 0-.0002 11.3-.0002 23.1c0 7.12 3.153 14.16 9.192 18.89l591.1 463.1C605.6 510.3 610.8 512 615.1 512C629.8 512 639.1 500.6 639.1 487.1zM464 338.4l-287.1-225.7l-.002-48.51c0-8.836 7.164-16 15.1-16h160l-.0065 79.87c0 17.67 14.33 31.1 31.1 31.1L464 159.1V338.4zM448 463.1H192c-8.834 0-15.1-7.164-15.1-16L176 234.6L128 197L128 447.1c0 35.34 28.65 64 63.1 64H448c20.4 0 38.45-9.851 50.19-24.84l-37.72-29.56C457.5 461.4 453.2 463.1 448 463.1z"],
    "file-spreadsheet": [384, 512, [], "f65b", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM80 256v128c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32V256c0-17.67-14.33-32-32-32h-160C94.33 224 80 238.3 80 256zM176 384h-64v-48h64V384zM208 256h64v48h-64V256zM208 336h64V384h-64V336zM176 304h-64V256h64V304z"],
    "file-user": [384, 512, [], "f65c", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H318.4C310.7 418.6 271.5 384 224 384H160c-47.54 0-86.73 34.64-94.39 80H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM192 224C156.7 224 128 252.7 128 288c0 35.34 28.65 64 64 64s64-28.66 64-64C256 252.7 227.3 224 192 224z"],
    "file-video": [384, 512, [], "f1c8", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM240 288c0-17.67-14.33-32-32-32h-96c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32v-16.52l43.84 30.2C292.3 403.5 304 397.6 304 387.4V284.6c0-10.16-11.64-16.16-20.16-10.32L240 304.5V288z"],
    "file-waveform": [448, 512, ["file-medical-alt"], "f478", "M172 381.3C176.5 388 183.9 392 191.9 392c.5 0 1.047 0 1.547-.0313c8.547-.5313 16.16-5.594 19.98-13.25l43.94-87.88l9.75 17.06C271.4 315.4 279.4 320 288 320h40C341.3 320 352 309.3 352 296S341.3 272 328 272h-26.08l-25.08-43.91C272.5 220.4 264.7 215.8 255.3 216c-8.844 .25-16.84 5.344-20.8 13.28l-45.5 91L163.1 282.7C159.5 276 152 272 144 272H24C10.75 272 0 282.8 0 296S10.75 320 24 320h107.2L172 381.3zM429.3 93.38l-74.63-74.64C342.6 6.742 326.3 0 309.4 0H128C92.65 0 63.1 28.66 64 64l.0059 152c.002 13.26 10.75 24 24 24s24-10.75 24-24L112 64.13c0-8.836 7.162-16 16-16h160L288 128c0 17.67 14.33 32 32 32h79.1v288c0 8.836-7.164 16-16 16H128c-8.836 0-16-7.164-16-16l-.0039-72c0-13.26-10.74-24-23.1-24s-24 10.74-24 24L64.01 448c.002 35.34 28.65 64 64 64H384c35.2 0 64-28.8 64-64V138.6C448 121.7 441.3 105.4 429.3 93.38z"],
    "file-word": [384, 512, [], "f1c2", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM214.6 248C211.3 238.4 202.2 232 192 232s-19.25 6.406-22.62 16L144.7 318.1l-25.89-77.66C114.6 227.8 101 221.2 88.41 225.2C75.83 229.4 69.05 243 73.23 255.6l48 144C124.5 409.3 133.5 415.9 143.8 416c10.17 0 19.45-6.406 22.83-16L192 328.1L217.4 400C220.8 409.6 229.8 416 240 416c10.27-.0938 19.53-6.688 22.77-16.41l48-144c4.188-12.59-2.594-26.16-15.17-30.38c-12.61-4.125-26.2 2.594-30.36 15.19l-25.89 77.66L214.6 248z"],
    "file-xmark": [384, 512, ["file-times"], "f317", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.66 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.836 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32H336V448zM239 239L192 286.1L144.1 239c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L158.1 320l-47.03 47.03c-9.375 9.375-9.375 24.56 0 33.94c9.375 9.371 24.55 9.379 33.94 0L192 353.9l47.03 47.03c9.375 9.371 24.55 9.379 33.94 0c9.375-9.375 9.375-24.56 0-33.94L225.9 320l47.03-47.03c9.375-9.375 9.375-24.56 0-33.94S248.4 229.7 239 239z"],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h48V64h64V48.13h48.01L224 128c0 17.67 14.33 32 32 32h79.1V448zM176 96h-64v32h64V96zM176 160h-64v32h64V160zM176 224h-64l-30.56 116.5C73.51 379.5 103.7 416 144.3 416c40.26 0 70.45-36.3 62.68-75.15L176 224zM160 368H128c-8.836 0-16-7.164-16-16s7.164-16 16-16h32c8.836 0 16 7.164 16 16S168.8 368 160 368z"],
    "files": [448, 512, [], "e178", "M429.3 93.38l-74.63-74.64C342.6 6.742 326.3 0 309.4 0H160C124.7 0 96 28.65 96 64l.0098 288c0 35.34 28.65 64 64 64h224C419.2 416 448 387.2 448 352V138.6C448 121.7 441.3 105.4 429.3 93.38zM400 352c0 8.836-7.164 16-16 16H160c-8.838 0-16-7.164-16-16L144 64.13c0-8.836 7.164-16 16-16h128V128c0 17.67 14.33 32 32 32h79.99V352zM328 512h-208C53.83 512 0 458.2 0 392v-272C0 106.8 10.75 96 24 96S48 106.8 48 120v272c0 39.7 32.3 72 72 72h208c13.25 0 24 10.75 24 24S341.3 512 328 512z"],
    "files-medical": [448, 512, [], "f7fd", "M298.7 189.3C298.7 182 292.7 176 285.3 176h-26.67c-7.334 0-13.33 6-13.33 13.33v40h-40C197.1 229.3 192 235.3 192 242.7v26.67c0 7.332 5.1 13.33 13.33 13.33h40v40c0 7.332 5.998 13.34 13.33 13.34h26.67c7.334 0 13.33-6.004 13.33-13.34v-40h40C345.1 282.7 352 276.7 352 269.3V242.7c0-7.332-6-13.33-13.33-13.33h-40V189.3zM429.3 93.38l-74.63-74.64C342.6 6.742 326.3 0 309.4 0H160C124.7 0 96 28.65 96 64l.0098 288c0 35.34 28.65 64 64 64h224C419.2 416 448 387.2 448 352V138.6C448 121.7 441.3 105.4 429.3 93.38zM400 352c0 8.836-7.164 16-16 16H160c-8.838 0-16-7.164-16-16L144 64.13c0-8.836 7.164-16 16-16h128V128c0 17.67 14.33 32 32 32h79.99V352zM328 512h-208C53.83 512 0 458.2 0 392v-272C0 106.8 10.75 96 24 96S48 106.8 48 120v272c0 39.7 32.3 72 72 72h208c13.25 0 24 10.75 24 24S341.3 512 328 512z"],
    "fill": [512, 512, [], "f575", "M502.6 217L294.1 9.375C288.1 3.375 280.8 0 272.3 0c-8.125 0-16.4 3.125-22.52 9.375L162.5 96.5L72.89 7.007c-9.359-9.347-24.52-9.341-33.87 .0115C29.66 16.37 29.66 31.54 39.01 40.89L128.6 130.5L28.13 230.1c-37.5 37.38-37.5 98.25 0 135.7l117.1 117.1C164 502.6 188.6 512 213.1 512c24.63 0 49.13-9.375 67.88-28.12l221.6-221.6C515.1 249.7 515.1 229.5 502.6 217zM409 288H49.38c2-8.625 6.25-16.62 12.62-23.12L162.5 164.5l69.88 69.88c9.375 9.375 24.62 9.375 33.1 0c9.375-9.375 9.375-24.62 0-34L196.5 130.5l75.75-75.88l185.1 185.1L409 288z"],
    "fill-drip": [576, 512, [], "f576", "M502.6 217L294.1 9.371C288.1 3.371 280.8 0 272.3 0c-8.125 0-16.4 3.121-22.53 9.371L162.5 96.5l-89.61-89.49c-9.359-9.347-24.52-9.341-33.87 .0115c-9.353 9.353-9.353 24.52 0 33.87L128.6 130.5L28.13 231c-37.5 37.38-37.5 98.25 0 135.8l117.1 117.1C164 502.6 188.6 512 213.1 512c24.62 0 49.13-9.375 67.88-28.12l221.6-221.6C515.1 249.7 515.1 229.5 502.6 217zM409 288H49.38c2-8.625 6.25-16.62 12.62-23.12L162.5 164.5l69.88 69.88c9.375 9.375 24.62 9.375 34 0s9.375-24.62 0-34L196.5 130.5l75.75-75.88l185.1 185.1L409 288zM525.4 340.4c-6.307-9.857-20.58-9.857-26.89 0C479.8 369.7 448 423.1 448 448C448 483.4 476.6 512 512 512s64-28.6 64-63.97C576 423.1 544.2 369.7 525.4 340.4z"],
    "film": [512, 512, [61448], "1f39e", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM112 432H64c-8.822 0-16-7.178-16-16v-72h64V432zM112 296h-64v-80h64V296zM112 168h-64V96c0-8.822 7.178-16 16-16h48V168zM352 432H160V280h192V432zM352 232H160V80h192V232zM464 416c0 8.822-7.178 16-16 16h-48v-88h64V416zM464 296h-64v-80h64V296zM464 168h-64V80H448c8.822 0 16 7.178 16 16V168z"],
    "film-canister": [576, 512, [], "f8b7", "M544 128h-224V80h8C341.3 80 352 69.25 352 56C352 42.74 341.3 32 328 32H256V16C256 7.162 248.8 0 240 0h-128C103.2 0 96 7.162 96 16V32H24C10.75 32 0 42.74 0 56C0 69.25 10.75 80 24 80H32v384H24C10.75 464 0 474.7 0 488C0 501.3 10.75 512 24 512h304c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24H320V416h160c17.62 0 32-14.38 32-32v-32c0-17.62 14.38-32 32-32s32-14.38 32-32V160C576 142.4 561.6 128 544 128zM272 464h-192v-384h192V464zM440 360c0 8.875-7.125 16-16 16h-16c-8.875 0-16-7.125-16-16v-16c0-8.875 7.125-16 16-16h16c8.875 0 16 7.125 16 16V360zM440 200c0 8.875-7.125 16-16 16h-16c-8.875 0-16-7.125-16-16v-16c0-8.875 7.125-16 16-16h16c8.875 0 16 7.125 16 16V200zM536 200c0 8.875-7.125 16-16 16h-16c-8.875 0-16-7.125-16-16v-16c0-8.875 7.125-16 16-16h16c8.875 0 16 7.125 16 16V200z"],
    "film-simple": [512, 512, ["film-alt"], "f3a0", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM112 432H64c-8.822 0-16-7.178-16-16v-72h64V432zM112 296h-64v-80h64V296zM112 168h-64V96c0-8.822 7.178-16 16-16h48V168zM352 432H160v-352h192V432zM464 416c0 8.822-7.178 16-16 16h-48v-88h64V416zM464 296h-64v-80h64V296zM464 168h-64V80H448c8.822 0 16 7.178 16 16V168z"],
    "film-slash": [640, 512, [], "e179", "M224 432V272.3L176 234.6V296h-64v-80h40.22L64 146.9V416c0 35.35 28.65 64 64 64h361l-61.24-48H224zM176 432H128c-8.822 0-16-7.178-16-16v-72h64V432zM630.8 469.1l-55.93-43.84C575.3 422.2 576 419.2 576 416V96c0-35.35-28.65-64-64-64H128C113.6 32 100.4 36.98 89.78 45.06l-50.97-39.95C28.34-3.058 13.31-1.246 5.109 9.192C-3.063 19.63-1.235 34.72 9.187 42.89L601.2 506.9C605.6 510.3 610.8 512 615.1 512c7.125 0 14.17-3.156 18.91-9.188C643.1 492.4 641.2 477.3 630.8 469.1zM176 112.6L134.4 80H176V112.6zM416 300.7L389.5 280H416V300.7zM416 232h-87.71L224 150.3V80h192V232zM528 388.5L471.2 344H528V388.5zM528 296h-64v-80h64V296zM528 168h-64V80H512c8.822 0 16 7.178 16 16V168z"],
    "films": [576, 512, [], "e17a", "M512 32H160C124.7 32 96 60.65 96 96v224c0 35.35 28.65 64 64 64h352c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM208 336H160c-8.822 0-16-7.178-16-16V280h64V336zM208 232h-64v-48h64V232zM208 136h-64V96c0-8.822 7.178-16 16-16h48V136zM416 336H256V232h160V336zM416 184H256V80h160V184zM528 320c0 8.822-7.178 16-16 16h-48V280h64V320zM528 232h-64v-48h64V232zM528 136h-64V80H512c8.822 0 16 7.178 16 16V136zM456 480H120C53.83 480 0 426.2 0 360v-240C0 106.8 10.75 96 24 96S48 106.8 48 120v240c0 39.7 32.3 72 72 72h336c13.25 0 24 10.75 24 24S469.3 480 456 480z"],
    "filter": [512, 512, [], "f0b0", "M507.7 58.71C500 42.23 483.8 32 465.3 32H46.65C28.21 32 11.97 42.23 4.283 58.71C-3.195 74.73-.7578 93.16 10.64 106.8l165.4 203.1v67.71c0 12.55 6.178 24.3 16.52 31.45l82.32 63.55C281.1 477.6 289.6 480 297.4 480c21.28 0 38.59-17.19 38.59-38.33V309.9l165.5-203.3C512.8 93.16 515.2 74.73 507.7 58.71zM295.2 283.1c-4.652 5.713-7.191 12.86-7.191 20.23V422.1l-64-49.39V304.2c0-7.371-2.539-14.52-7.191-20.23L50.77 80.04h410.4L295.2 283.1z"],
    "filter-circle-dollar": [576, 512, ["funnel-dollar"], "f662", "M223.1 340.7V272.2c0-7.369-2.539-14.51-7.191-20.22L50.77 48.04h410.4l-85.57 105.1c-7.77 9.545-7.061 23.42 1.643 32.13c10.06 10.06 26.62 9.219 35.6-1.812l88.61-108.8c11.26-13.46 13.7-31.89 6.225-47.92C500 10.23 483.8 0 465.3 0H46.65C28.21 0 11.97 10.23 4.283 26.71C-3.195 42.73-.7578 61.16 10.64 74.79l165.4 203.1v67.71c0 12.55 6.178 24.3 16.52 31.45l24.81 19.15C233.1 408.4 256 397.2 256 377.2c0-7.439-3.449-14.46-9.34-19L223.1 340.7zM432 224C352.5 224 288 288.5 288 368s64.46 144 144 144C511.5 512 576 447.5 576 368S511.5 224 432 224zM484.6 404.8c-3.109 17.97-17.03 29.62-36.59 33.47V448c0 8.844-7.156 16-16 16s-16-7.156-16-16v-10.08c-9.816-2.025-19.17-5.441-26.72-8.166c-8.344-2.953-12.69-12.09-9.75-20.42c2.969-8.328 12.22-12.62 20.44-9.734c16.21 5.807 19.95 6.891 24.84 7.625c13.12 2.094 26.88 0 28.22-7.922c1.684-9.633-12.26-12.11-30.53-17.39c-14.78-4.344-49.41-14.5-43.13-50.67c3.094-18.04 16.88-30.03 36.63-33.82V288c0-8.844 7.156-16 16-16s16 7.156 16 16v10.22c5.646 1.18 11.52 2.633 17.22 4.621c8.344 2.891 12.75 12 9.875 20.36c-2.938 8.359-12 12.8-20.38 9.859c-5.219-1.797-10.72-3.516-15.72-4.312c-12.84-1.984-26.75 .0625-28.12 7.953c-1.543 9.193 11.23 11.76 25.47 15.89C456.8 358.4 490.9 368.2 484.6 404.8z"],
    "filter-circle-xmark": [576, 512, [], "e17b", "M432 224C352.5 224 288 288.5 288 368s64.47 144 144 144s144-64.47 144-144S511.5 224 432 224zM488.5 401.9c6.242 6.242 6.252 16.37 .0098 22.62c-6.24 6.242-16.37 6.231-22.62-.0113l-33.91-33.91l-33.91 33.91c-6.242 6.242-16.37 6.253-22.62 .0106s-6.232-16.37 .0098-22.62l33.91-33.91l-33.91-33.91c-6.242-6.242-6.251-16.37-.009-22.62s16.37-6.232 22.62 .0106l33.91 33.91l33.91-33.91c6.242-6.242 16.37-6.254 22.61-.0113s6.233 16.37-.009 22.62l-33.91 33.91L488.5 401.9zM223.1 340.7V272.2c0-7.369-2.539-14.51-7.191-20.22L50.77 48.04h410.4l-85.57 105.1c-7.77 9.545-7.061 23.42 1.643 32.13c10.06 10.06 26.62 9.219 35.6-1.812l88.61-108.8c11.26-13.46 13.7-31.89 6.225-47.92C500 10.23 483.8 0 465.3 0H46.65C28.21 0 11.97 10.23 4.283 26.71C-3.195 42.73-.7578 61.16 10.64 74.79l165.4 203.1v67.71c0 12.55 6.178 24.3 16.52 31.45l24.81 19.15C233.1 408.4 256 397.2 256 377.2c0-7.439-3.449-14.46-9.34-19L223.1 340.7z"],
    "filter-list": [512, 512, [], "e17c", "M440 120h48c13.25 0 24-10.75 24-23.1S501.3 72 488 72h-48C426.8 72 416 82.75 416 95.1S426.8 120 440 120zM488 232h-144C330.8 232 320 242.8 320 256s10.75 24 24 24h144C501.3 280 512 269.3 512 256S501.3 232 488 232zM329.5 64H22.48c-18.9 0-29.33 21.5-17.41 35.88L112 225.8V368c0 7.828 3.812 15.17 10.25 19.66l79.1 55.98C206.5 446.6 211.3 448 215.9 448C228.3 448 240 438.2 240 423.1V225.8l106.9-125.9C358.8 85.5 348.4 64 329.5 64zM203.4 194.7L192 208.2v169.7l-32-22.39V208.2L78.34 112h195.3L203.4 194.7zM488 392h-144C330.8 392 320 402.8 320 416s10.75 24 24 24h144c13.25 0 24-10.75 24-24S501.3 392 488 392z"],
    "filter-slash": [640, 512, [], "e17d", "M630.8 469.1l-220-172.4l154.7-190c11.26-13.46 13.7-31.89 6.225-47.92C564 42.23 547.8 32 529.3 32H110.7C100.7 32 91.58 35.16 83.92 40.46L38.81 5.11c-4.406-3.438-9.625-5.109-14.78-5.109c-7.125 0-14.19 3.156-18.91 9.188c-8.188 10.44-6.375 25.53 4.062 33.7l591.1 463.1c10.5 8.203 25.56 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1zM134.4 80.04h390.8l-152.2 186.1L134.4 80.04zM351.1 422.1l-64-49.39v-50.31L183.5 240.5l56.49 69.39v67.71c0 12.55 6.178 24.3 16.52 31.45l82.32 63.55C345.1 477.6 353.6 480 361.4 480c21.28 0 38.59-17.19 38.59-38.33v-31.47l-48-37.62V422.1z"],
    "filters": [640, 512, [], "e17e", "M255.1 317.5v104.6l-64-55.79V317.5L50.74 144h140.1L177.8 126.1C170.2 117.8 165.6 107.1 162.8 96H46.66C28.19 96 11.97 106.2 4.299 122.7c-7.5 16-5.062 34.44 6.359 48.06L144 334.6v43.02c0 12.55 6.17 24.3 16.51 31.47l82.3 63.55C249.1 477.6 257.6 480 265.4 480c21.28 0 38.59-17.19 38.59-38.34L304 281.1L294.5 270.3L255.1 317.5zM635.7 58.72C628 42.23 611.8 32 593.3 32H238.7C220.2 32 203.1 42.23 196.3 58.72c-7.5 16-5.062 34.44 6.359 48.06L336 270.6v75.02c0 12.55 6.17 24.3 16.51 31.47l82.3 63.55C441.1 445.6 449.6 448 457.4 448c21.28 0 38.59-17.19 38.59-38.34V270.6l133.5-163.1C640.7 93.16 643.2 74.72 635.7 58.72zM447.1 253.5v136.6l-64-49.42V253.5L242.7 80H589.3L447.1 253.5z"],
    "fingerprint": [512, 512, [], "f577", "M256.1 246c-13.25 0-23.1 10.75-23.1 23.1c1.125 72.25-8.124 141.9-27.75 211.5C201.7 491.3 206.6 512 227.5 512c10.5 0 20.12-6.875 23.12-17.5c13.5-47.87 30.1-125.4 29.5-224.5C280.1 256.8 269.4 246 256.1 246zM255.2 164.3C193.1 164.1 151.2 211.3 152.1 265.4c.75 47.87-3.75 95.87-13.37 142.5c-2.75 12.1 5.624 25.62 18.62 28.37c12.1 2.625 25.62-5.625 28.37-18.62c10.37-50.12 15.12-101.6 14.37-152.1C199.7 238.6 219.1 212.1 254.5 212.3c31.37 .5 57.24 25.37 57.62 55.5c.8749 47.1-2.75 96.25-10.62 143.5c-2.125 12.1 6.749 25.37 19.87 27.62c19.87 3.25 26.75-15.12 27.5-19.87c8.249-49.1 12.12-101.1 11.25-151.1C359.2 211.1 312.2 165.1 255.2 164.3zM144.6 144.5C134.2 136.1 119.2 137.6 110.7 147.9C85.25 179.4 71.38 219.3 72 259.9c.6249 37.62-2.375 75.37-8.999 112.1c-2.375 12.1 6.249 25.5 19.25 27.87c20.12 3.5 27.12-14.87 27.1-19.37c7.124-39.87 10.5-80.62 9.749-121.4C119.6 229.3 129.2 201.3 147.1 178.3C156.4 167.9 154.9 152.9 144.6 144.5zM253.1 82.14C238.6 81.77 223.1 83.52 208.2 87.14c-12.87 2.1-20.87 15.1-17.87 28.87c3.125 12.87 15.1 20.75 28.1 17.75C230.4 131.3 241.7 130 253.4 130.1c75.37 1.125 137.6 61.5 138.9 134.6c.5 37.87-1.375 75.1-5.624 113.6c-1.5 13.12 7.999 24.1 21.12 26.5c16.75 1.1 25.5-11.87 26.5-21.12c4.625-39.75 6.624-79.75 5.999-119.7C438.6 165.3 355.1 83.64 253.1 82.14zM506.1 203.6c-2.875-12.1-15.51-21.25-28.63-18.38c-12.1 2.875-21.12 15.75-18.25 28.62c4.75 21.5 4.875 37.5 4.75 61.62c-.1249 13.25 10.5 24.12 23.75 24.25c13.12 0 24.12-10.62 24.25-23.87C512.1 253.8 512.3 231.8 506.1 203.6zM465.1 112.9c-48.75-69.37-128.4-111.7-213.3-112.9c-69.74-.875-134.2 24.84-182.2 72.96c-46.37 46.37-71.34 108-70.34 173.6l-.125 21.5C-.3651 281.4 10.01 292.4 23.26 292.8C23.51 292.9 23.76 292.9 24.01 292.9c12.1 0 23.62-10.37 23.1-23.37l.125-23.62C47.38 193.4 67.25 144 104.4 106.9c38.87-38.75 91.37-59.62 147.7-58.87c69.37 .1 134.7 35.62 174.6 92.37c7.624 10.87 22.5 13.5 33.37 5.875C470.1 138.6 473.6 123.8 465.1 112.9z"],
    "fire": [448, 512, [61549], "1f525", "M323.5 51.25C302.8 70.5 284 90.75 267.4 111.1C240.1 73.62 206.2 35.5 168 0C69.75 91.12 0 210 0 281.6C0 408.9 100.2 512 224 512s224-103.1 224-230.4C448 228.4 396 118.5 323.5 51.25zM224 464c-97 0-176-81.88-176-182.4c0-45.38 44.25-133.2 120.1-214.1C190.5 90.88 211 115.2 228.5 139.4l36.63 50.38l39.38-48.25c5.875-7.125 11.88-14.12 18-21C368.9 178 400 250.4 400 281.6C400 382.1 321 464 224 464zM313.5 243.1l-51.38 58.5c0 0-80.37-102.6-86.37-109.6C133.2 242.9 112 272.6 112 306.4C112 374.3 163.4 416 226.5 416c25.25 0 48.63-7.875 67.63-21.12c43-30.12 53.12-88.63 29.25-134.3C320.4 255 317.1 249.1 313.5 243.1z"],
    "fire-extinguisher": [512, 512, [61748], "1f9ef", "M503.4 5.56c-5.453-4.531-12.61-6.406-19.67-5.188l-175.1 32c-11.41 2.094-19.7 12.03-19.7 23.63L200 56v-32C200 10.75 189.3 0 176 0S152 10.75 152 24v32h-32C53.84 56 0 109.8 0 176c0 13.25 10.75 24 24 24S48 189.3 48 176c0-39.69 32.31-72 72-72h32v26.72C101.7 141.7 64 186.4 64 240L64 480c0 17.67 14.33 32 31.1 32H256c17.67 0 31.1-14.33 31.1-32l0-240c0-53.6-37.71-98.27-87.1-109.3V104l87.1-.002c0 11.59 8.297 21.53 19.7 23.62l175.1 31.1c1.438 .25 2.875 .375 4.297 .375c5.578 0 11.03-1.938 15.37-5.562c5.469-4.562 8.625-11.31 8.625-18.44V23.1C511.1 16.87 508.8 10.12 503.4 5.56zM240 464h-128v-32h128V464zM240 240V384h-128V240c0-35.29 28.71-64 64-64C211.3 176 240 204.7 240 240z"],
    "fire-flame": [384, 512, ["flame"], "f6df", "M191.1 0C79.75 101.4 0 220.9 0 300.5C0 425 79 512 192 512s192-87 192-211.5C384 220.6 303.7 100.9 191.1 0zM192 464c-86.13 0-144-65.75-144-163.5c0-46.25 45.25-136.6 144-234.4C278.2 152 336 244.9 336 300.5C336 398.2 278.1 464 192 464zM237.1 239.6c-20-17-38.75-33-38.75-58.12c0-3.499-2.75-4.75-4-5.125C192 175.6 188.6 175.8 186.4 178.8C131.5 253.4 216 248 216 302C216 325.2 197.2 344 173.1 344C150.8 344 132 325.2 132 302V272c0-2.375-1.5-4.625-3.75-5.5C125.1 265.5 123.5 266 121.8 267.8C115.4 274 96 294.5 96 327.6C96 376.4 139 416 192 416s96-39.63 96-88.38C288 283.2 262.1 261.1 237.1 239.6z"],
    "fire-flame-curved": [384, 512, ["fire-alt"], "f7e4", "M215.1 23.88c0-23.75-31.15-33.15-44.15-13.03C76.47 158.1 200 238.7 200 287.1c0 22-18 40-40 40c-22 0-40-18-40-40V182.1c0-19.38-21.88-30.75-37.75-19.63C30.75 198.4 0 257.2 0 319.1C0 425.9 86.12 512 192 512s192-86.12 192-192C384 149.7 215.1 127 215.1 23.88zM192 463.1c-79.38 0-144-64.63-144-144c0-28.63 8.5-64.75 24-88v56c0 48.5 39.5 88 88 88s88-39.5 88-88c0-64.25-88-120-64-208C224 167.1 336 201.7 336 319.1C336 399.4 271.4 463.1 192 463.1z"],
    "fire-flame-simple": [384, 512, ["burn"], "f46a", "M192 0C86.25 93.5 0 214.4 0 298.1C0 424 79 512 192 512s192-88 192-213.9C384 214.1 296.8 92.5 192 0zM192 65.25c51.38 51 144 158.5 144 232.9c0 29.5-5.625 55.63-15.12 78.38C317.4 301.8 237.2 218.6 192 167.8c-45.75 51.5-125.4 133.7-128.9 208.7C53.75 353.8 48 327.5 48 298.1C48 223.9 140.6 116.4 192 65.25zM173.9 462.2C135.8 454.8 110.5 423.5 110.5 381.1C110.5 360.5 124 316.5 192 240c68 76.5 81.5 120.5 81.5 141.1c0 42.38-25.25 73.63-63.38 81.12C189.2 464.6 194.8 464.6 173.9 462.2z"],
    "fire-hydrant": [384, 512, [], "e17f", "M56 176h272C341.3 176 352 165.3 352 152C352 138.7 341.3 128 328 128h-12.53C303.9 83.17 268.8 48.13 224 36.53V32c0-17.67-14.33-32-32-32S160 14.33 160 32v4.525C115.2 48.13 80.13 83.17 68.53 128H56C42.75 128 32 138.7 32 152C32 165.3 42.75 176 56 176zM320 240v-32h-48v64h32v96h-32v96h-160v-96h-32v-96h32v-64H64v32c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32v64H56C42.75 464 32 474.7 32 488C32 501.3 42.75 512 56 512h272c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24H320v-64c17.67 0 32-14.33 32-32v-96C352 254.3 337.7 240 320 240zM128 320c0 35.35 28.65 64 64 64s64-28.65 64-64c0-35.35-28.65-64-64-64S128 284.7 128 320z"],
    "fire-smoke": [640, 512, [], "f74b", "M352 200c0 0-70.25-71.75-75.38-77.88C240.4 167 222.3 193.3 222.3 223.3c0 11.38 2 21.5 5 31.25C254.1 235 286.5 224 320 224c32.38 0 63.75 10.5 90.13 28.75C416 229.9 413.9 204.8 402.9 182.8c-2.5-5-5.488-10.01-8.613-15.38L352 200zM152 240c15.75 0 30.88 2.625 45.38 7.25C194.3 236.3 192 224.9 192 213c0-29.75 31.5-89.75 84.25-146.1C290.8 82 304.1 97.63 315.8 113l36 47.88c0 0 43-50.63 45.25-53.13C428.9 148.8 448 195.6 448 213c0 11.88-2.25 23.25-5.375 34.25C457.1 242.6 472.3 240 488 240c1.875 0 3.75 .5 5.625 .625c1.5-9 2.312-18.37 2.312-27.75c0-40.25-40.75-123.3-97.75-174.2c-16.38 14.62-31.12 29.94-44.25 45.44C332.6 55.63 306.1 26.88 276 0C198.8 68.88 144 158.8 144 213c0 9.375 1 18.62 2.375 27.62C148.3 240.5 150.1 240 152 240zM486.4 282c-24.36 0-47.94 8.125-67.25 22.62C395.5 274.3 359.3 255.1 320 255.1S244.5 274.3 220.8 304.6C201.5 290.1 177.1 282 153.6 282C90.95 282 40 333.6 40 397S90.95 512 153.6 512h332.8C549 512 600 460.4 600 397S549 282 486.4 282zM486.4 464H153.6C117.4 464 88 433.9 88 397s29.42-67 65.59-67c20.88 0 40.06 10.03 52.63 27.47c5.078 7.062 13.62 10.69 22.2 9.844c8.641-1 16.06-6.562 19.42-14.59C260.2 323.1 288.5 304 320 304s59.78 19.12 72.16 48.72c3.359 8.031 10.78 13.59 19.42 14.59c8.641 .9687 17.12-2.781 22.2-9.844c12.56-17.44 31.75-27.47 52.63-27.47c36.17 0 65.59 30.06 65.59 67S522.6 464 486.4 464z"],
    "fireplace": [640, 512, [], "f79a", "M342.3 311.6C328.3 292.8 310.9 273.8 291.3 256c-50.5 45.63-86.5 105-86.5 140.8C204.8 460.4 256.4 512 320 512s115.3-51.63 115.3-115.3c0-26.5-26.75-81.5-64-115.1C360.5 291.3 350.8 301.4 342.3 311.6zM357.8 448.5C347.3 456.3 334.1 460.8 320 460.8c-35.25 0-64-24.38-64-64c0-19.62 11.88-36.1 35.63-66.75c3.375 4.125 48.25 64.12 48.25 64.12l28.75-34.25c2 3.5 3.875 6.875 5.5 10.25C387.5 396.8 381.9 430.9 357.8 448.5zM608 0H32C14.4 0 0 14.4 0 32v64c0 17.6 14.4 32 32 32v360C32 501.3 42.75 512 56 512s24-10.75 24-24V128h480v359.9c0 13.25 10.75 24 24 24s24-10.75 24-24V128c17.6 0 32-14.4 32-32V32C640 14.4 625.6 0 608 0zM592 72c0 4.418-3.582 8-8 8H56C51.58 80 48 76.42 48 72v-16c0-4.418 3.582-8 8-8h528c4.418 0 8 3.582 8 8V72zM317.1 160C201.2 160.9 112 261.3 112 374.9V488C112 501.3 122.7 512 136 512S160 501.3 160 488v-115.4c0-87.06 74.03-164.7 160-164.7c88.38 0 160 71.63 160 160v120c0 13.25 10.75 24 24 24s24-10.75 24-24v-119C528 253.4 433.5 159.1 317.1 160z"],
    "fish": [576, 512, [62840], "1f41f", "M323.9 64C231.7 64 160.3 125.5 126.4 161.7L65.05 112.5C52.3 101.4 34.61 99.63 20.08 107.1C5.299 116.4-2.482 133.4 .9551 151.4L25.74 256l-25.03 105.6c-3.188 16.91 4.625 33.95 19.41 42.41c14.53 8.375 32.16 6.578 44.06-3.828l62.13-49.88C160.3 386.5 231.7 448 323.9 448C462.6 448 576 303 576 256S462.6 64 323.9 64zM323.9 400c-70.97 0-137.5-50.58-176.1-97.92L132.7 283.6l-79.31 63.67L75.05 256L53.39 164.7L132.8 228.4l15.06-18.5C186.4 162.6 252.8 112 323.9 112c110.3 0 201.5 120.4 204.2 143.5C525.4 279.6 434.2 400 323.9 400zM416 224c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C448 238.3 433.7 224 416 224z"],
    "fish-bones": [576, 512, [], "e304", "M448.3 96c-16.65 0-32.28 13.36-32.28 32.2l-.0001 103.8h-40V160c0-13.23-10.75-23.99-24-23.99c-13.25 0-24 10.76-24 23.99v71.96h-48V160c0-13.23-10.75-23.99-24-23.99c-13.25 0-24 10.76-24 23.99v71.96H184V160c0-13.23-10.75-23.99-24-23.99c-13.25 0-24 10.76-24 23.99v71.96L69.37 232L53.4 164.8l3.598 2.882C61.57 171.3 66.79 172.1 71.9 172.1c12.41 0 24.11-9.757 24.11-24c0-7.27-3.307-14.15-8.987-18.7l-21.96-17.58C57.65 106.3 48.57 102.1 39.42 102.1c-20.23 0-39.27 16.27-39.27 40.2c0 2.758 .2631 5.569 .8059 8.405l24.78 104.4L.7056 361.5C.2307 363.1 0 366.5 0 368.1c0 23.48 19.22 40.1 39.67 40.1c8.944 0 17.67-3.132 24.51-9.1l22.85-18.32c5.672-4.548 8.973-11.42 8.973-18.68c0-14.25-11.7-24-24.11-24c-5.104 0-10.33 1.651-14.9 5.319l-3.561 2.855l15.94-67.19l66.64 .0238v71.96c0 13.23 10.75 23.99 24 23.99c13.25 0 24-10.76 24-23.99V279.1h48v71.96c0 13.23 10.75 23.99 24 23.99c13.25 0 24-10.76 24-23.99V279.1h48v71.96c0 13.23 10.75 23.99 24 23.99c13.25 0 24-10.76 24-23.99V279.1h40l.0001 103.8C416 402.6 431.7 416 448.3 416C484.7 416 576 303.5 576 256C576 208.6 484.7 96 448.3 96zM464 350.2V161.8c37.38 35.23 60.87 78.77 63.85 94.24C524.9 271.5 501.4 315 464 350.2z"],
    "fish-cooked": [576, 512, [], "f7fe", "M323.9 64C231.7 64 160.3 125.5 126.4 161.7L65.05 112.5C52.3 101.4 34.61 99.63 20.08 107.1c-14.78 8.453-22.56 25.48-19.13 43.47L25.74 256l-25.03 105.6c-3.188 16.91 4.625 33.95 19.41 42.41c14.53 8.375 32.16 6.578 44.06-3.828l62.13-49.88C160.3 386.5 231.7 448 323.9 448c138.7 0 252.1-144.1 252.1-192S462.6 64 323.9 64zM323.9 400c-70.97 0-137.5-50.58-176.1-97.92L132.7 283.6l-79.31 63.67L75.05 256L53.39 164.7L132.8 228.4l15.06-18.5C186.4 162.6 252.8 112 323.9 112c110.3 0 201.5 120.4 204.2 143.5C525.4 279.6 434.2 400 323.9 400zM251.3 251.3l64-64c6.25-6.25 6.25-16.38 0-22.62c-6.25-6.25-16.38-6.25-22.63 0l-64 64c-6.25 6.25-6.25 16.38 0 22.62C231.8 254.4 235.9 256 239.1 256S248.2 254.4 251.3 251.3zM427.3 164.7c-6.25-6.25-16.37-6.25-22.63 0l-160 160c-6.25 6.25-6.25 16.38 0 22.62C247.8 350.4 251.9 352 255.1 352s8.187-1.562 11.31-4.688l160-160C433.6 181.1 433.6 170.9 427.3 164.7zM420.7 260.7l-64 64c-6.25 6.25-6.25 16.38 0 22.62C359.8 350.4 363.9 352 367.1 352s8.188-1.562 11.31-4.688l64-64c6.25-6.25 6.25-16.38 0-22.62S426.9 254.4 420.7 260.7z"],
    "fishing-rod": [512, 512, [], "e3a8", "M438.5 456.4C463.8 429.7 496 385.3 496 332.2c0-72.64-62.91-131.4-88-151.9V88.04C408 23.46 351 0 320.2 0c-7.168 0-14.39 .8792-21.55 2.668L235.6 18.45C139.3 42.51 72 128.7 72 227.1v60.03H64c-17.67 0-32 14.33-32 31.1v159.1c0 17.67 14.33 31.1 32 31.1h64c17.67 0 32-14.33 32-31.1v-159.1c0-17.67-14.33-31.1-32-31.1H120V227.1c0-77.25 52.31-144.2 127.3-162.1l63-15.78c3.261-.8088 6.546-1.207 9.799-1.207c13.78 0 39.92 10.72 39.92 40.02v92.25c-25.09 20.54-88 79.29-88 151.9c0 53.06 32.22 97.53 57.47 124.2l-15.16 13.87c-5.168 4.722-7.788 11.19-7.788 17.68c0 13.17 10.67 24.01 23.1 24.01c5.796 0 11.61-2.089 16.23-6.319l33.97-31.12C381.9 473.4 383 472.2 384 470.9c.9687 1.312 2.062 2.562 3.281 3.687l33.97 31.12c4.625 4.219 10.41 6.312 16.22 6.312c13.33 0 24.01-10.82 24.01-24.01c0-6.492-2.621-12.96-7.788-17.68L438.5 456.4zM384 442.9c-3.592-5.071-64-52.52-64-110.7c0-46.94 41.56-89.68 64-109.3c22.44 19.66 64 62.4 64 109.3C448 390.3 387.5 437.9 384 442.9zM384 288c-13.25 0-24 10.74-24 23.1c0 13.25 10.75 23.1 24 23.1s24-10.75 24-23.1C408 298.8 397.3 288 384 288z"],
    "flag": [512, 512, [61476, 61725], "1f3f4", "M476.3 0c-6.365 0-13.01 1.35-19.34 4.233c-45.69 20.86-79.56 27.94-107.8 27.94c-59.96 0-94.81-31.86-163.9-31.87c-34.63 0-77.87 8.003-137.2 32.05V24C48 10.75 37.25 0 24 0S0 10.75 0 24v464C0 501.3 10.75 512 24 512s24-10.75 24-24v-104c53.59-23.86 96.02-31.81 132.8-31.81c73.63 0 124.9 31.78 198.6 31.78c31.91 0 68.02-5.971 111.1-23.09C504.1 355.9 512 344.4 512 332.1V30.73C512 11.1 495.3 0 476.3 0zM464 319.8c-30.31 10.82-58.08 16.1-84.6 16.1c-30.8 0-58.31-7-87.44-14.41c-32.01-8.141-68.29-17.37-111.1-17.37c-42.35 0-85.99 9.09-132.8 27.73V84.14l18.03-7.301c47.39-19.2 86.38-28.54 119.2-28.54c28.24 .0039 49.12 6.711 73.31 14.48c25.38 8.148 54.13 17.39 90.58 17.39c35.43 0 72.24-8.496 114.9-26.61V319.8z"],
    "flag-checkered": [576, 512, [61726], "1f3c1", "M508.3 0c-6.365 0-13.04 1.35-19.37 4.232c-45.69 20.86-79.56 27.94-107.8 27.94c-59.96 0-94.8-31.86-163.9-31.87c-34.63 0-77.87 8.002-137.2 32.04V24C80 10.75 69.26 0 56 0S32 10.75 32 24v464C32 501.3 42.74 512 56 512s24-10.75 24-24v-104c53.59-23.86 96.02-31.81 132.8-31.81c73.63 0 124.9 31.78 198.6 31.78c31.91 0 68.02-5.973 111.1-23.09C536.1 355.8 544 344.4 544 332.1V30.74C544 12.01 527.3 0 508.3 0zM152 310.4C128.7 315 104.8 322 80 331.9V283.8l18.03-7.301C117.5 268.7 135.2 262.8 152 258.3V310.4zM152 208.6C130.8 213.7 107.3 221 80 232.1V187.8l18.03-7.301C117.5 172.7 135.2 166.8 152 162.3V208.6zM152 112.6C130.8 117.7 107.3 125 80 136.1V84.14l18.03-7.301C117.5 68.95 135.2 63.15 152 58.55V112.6zM272 309.7C253.7 306.4 234.1 304.2 212.8 304.2c-4.248 0-8.574 .5039-12.85 .6836V249.2C205.8 248.6 211.7 248 217.2 248C238.1 248 254.9 251.7 272 256.7V309.7zM272 207.1C255.7 203.1 238.1 200 217.2 200C211.8 200 205.8 200.6 200 201v-47.84C205.8 152.6 211.7 152 217.2 152C238.1 152 254.9 155.7 272 160.7V207.1zM272 111.1C255.7 107.1 238.1 104 217.2 104C211.8 104 205.8 104.6 200 105V49.47c5.826-.5195 11.74-1.172 17.21-1.172C238.1 48.3 254.9 51.98 272 57.02V111.1zM392 334.9c-23.25-2.121-45.17-7.555-68.04-13.37C322.7 321.2 321.3 320.9 320 320.6V271.2C338.1 276 357.9 279.9 381.1 279.9c3.592 0 7.283-.4766 10.91-.6523V334.9zM392 231.2c-3.627 .2227-7.457 .6992-10.91 .6992c-22.93 0-42.19-4.672-61.09-10.43V175.2C338.1 180 357.9 183.9 381.1 183.9c3.592 0 7.283-.4766 10.91-.6523V231.2zM392 135.2c-3.627 .2227-7.457 .6992-10.91 .6992c-22.93 0-42.19-4.672-61.09-10.43V71.48c18.07 4.82 37.91 8.684 61.09 8.684c3.592 0 7.283-.4766 10.91-.6523V135.2zM496 319.8c-19.64 7.012-38.14 11.46-56 13.89v-61.55c17.73-4.375 36.19-10.5 56-18.91V319.8zM496 201.6c-2.371 .6562-4.75 1.289-7.072 2.344C470.7 212.2 454.8 217.8 440 222.2V176.2c17.73-4.375 36.19-10.5 56-18.91V201.6zM496 105.6c-2.371 .6562-4.75 1.289-7.072 2.344C470.7 116.2 454.8 121.8 440 126.2V72.47c17.73-4.375 36.19-10.5 56-18.91V105.6z"],
    "flag-pennant": [512, 512, [62550, "pennant"], "1f6a9", "M496.3 185.5L47.19 20.01C45.23 8.734 35.84 0 24 0C10.75 0 0 10.74 0 24v464C0 501.3 10.75 512 24 512s24-10.75 24-24v-92.3l448.3-165.2C505.7 227 512 218.1 512 208S505.7 188.1 496.3 185.5zM48 344.5V71.48L418.6 208L48 344.5z"],
    "flag-swallowtail": [512, 512, ["flag-alt"], "f74c", "M391.4 208l114.1-136.5c6.016-7.156 7.344-17.12 3.406-25.59S497.3 32 487.1 32H48V24C48 10.74 37.25 0 24 0S0 10.74 0 24v464C0 501.3 10.75 512 24 512s24-10.75 24-24V384h439.1c9.326 0 17.83-5.406 21.76-13.88s2.609-18.44-3.406-25.59L391.4 208zM48 336v-256h388.4l-94.77 112.5c-7.516 8.938-7.516 22 0 30.94L436.4 336H48z"],
    "flag-usa": [576, 512, [], "f74d", "M508.3 0c-6.365 0-13.04 1.35-19.37 4.232c-45.69 20.86-79.56 27.94-107.8 27.94c-59.96 0-94.8-31.86-163.9-31.87c-34.63 0-77.87 8.002-137.2 32.04V24C80 10.75 69.26 0 56 0C42.75 0 32 10.75 32 24v464C32 501.3 42.75 512 56 512c13.26 0 24-10.75 24-24v-104c53.59-23.86 96.02-31.81 132.8-31.81c73.63 0 124.9 31.78 198.6 31.78c31.91 0 68.02-5.973 111.1-23.09C536.1 355.8 544 344.4 544 332.1V30.74C544 12.01 527.3 0 508.3 0zM184 32c8.836 0 16 7.164 16 16S192.8 64 184 64s-16-7.164-16-16S175.2 32 184 32zM184 88c8.836 0 16 7.164 16 16s-7.164 16-16 16s-16-7.164-16-16S175.2 88 184 88zM120 48c8.836 0 16 7.164 16 16s-7.164 16-16 16S104 72.84 104 64S111.2 48 120 48zM120 112c8.836 0 16 7.164 16 16s-7.164 16-16 16S104 136.8 104 128S111.2 112 120 112zM496 319.8c-30.31 10.82-58.08 16.1-84.6 16.1c-30.8 0-58.31-7-87.44-14.41c-32.01-8.141-68.29-17.37-111.1-17.37c-42.35 0-85.99 9.09-132.8 27.73V283.8l18.03-7.301C145.4 257.3 184.4 248 217.2 248c28.24 .0039 49.13 6.711 73.31 14.48c25.38 8.148 54.13 17.39 90.58 17.39c35.43 0 72.24-8.496 114.9-26.61V319.8zM496 201.6c-2.371 .6562-4.75 1.289-7.072 2.344c-45.69 20.86-79.56 27.94-107.8 27.94c-59.96 0-94.8-31.86-163.9-31.87C182.6 200 139.3 208 80 232.1V187.8l18.03-7.301C145.4 161.3 184.4 152 217.2 152c28.24 .0039 49.13 6.711 73.31 14.48c25.38 8.148 54.13 17.39 90.58 17.39c35.43 0 72.24-8.496 114.9-26.61V201.6zM496 105.6c-2.371 .6562-4.75 1.289-7.072 2.344c-45.69 20.86-79.56 27.94-107.8 27.94c-52.97 0-86.42-24.78-141.1-30.59V49.96c17.7 2.422 33.32 7.297 50.52 12.82c25.38 8.148 54.13 17.39 90.58 17.39c35.43 0 72.24-8.496 114.9-26.61V105.6z"],
    "flashlight": [640, 512, [63672], "1f526", "M607.1 96h-32c-62.63 0-123.7 18.5-175.9 53.25L383.1 160H48C21.5 160 0 181.5 0 208v96C0 330.5 21.5 352 48 352h335.1l16.12 10.75C452.2 397.5 513.4 416 575.1 416h32c17.62 0 32-14.38 32-32V128C639.1 110.4 625.6 96 607.1 96zM544 365.6c-41.88-4.75-82.13-19.5-117.2-42.87L398.5 304H48v-96h350.5l28.25-18.75C461.9 165.9 502.1 151.2 544 146.4V365.6zM284 232h-24c-13.25 0-24 10.75-24 24c0 13.25 10.75 24 24 24h24c13.25 0 24-10.75 24-24C308 242.8 297.2 232 284 232z"],
    "flask": [448, 512, [], "f0c3", "M437.2 403.5L319.1 215L319.1 48h7.998c13.25 0 23.1-10.75 23.1-24S341.2 0 327.1 0H120C106.8 0 96.01 10.75 96.01 24S106.8 48 120 48h7.998L128 215l-117.2 188.5C-18.48 450.6 15.27 512 70.89 512h306.2C432.7 512 466.5 450.5 437.2 403.5zM119.2 320l56.78-91.29V48h95.98v180.7L328.8 320H119.2z"],
    "flask-round-poison": [448, 512, ["flask-poison"], "f6e0", "M319.1 169V48h7.996c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24H119.1c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24h7.992v120.1C61.62 202.9 16 271.9 16 352c0 53.75 20.38 102.8 53.99 139.8C81.87 504.9 99.12 512 116.1 512h213.1c18 0 35.5-7.5 47.5-20.88c32.24-35.75 52.24-82.75 53.49-134.5C433.7 276.8 387.2 205.1 319.1 169zM342.7 459.1C339.1 462.2 335.6 464 330.1 464H116.1c-4.617 0-8.879-1.666-11.47-4.527C78.74 430 64 391.8 64 352c0-59.33 33.05-113.5 86.25-141.4l25.73-13.47V48h95.98v149.7l25.28 13.58c53.96 28.99 88 85.63 86.72 144.2C383 393.8 368.4 430.6 342.7 459.1zM224 256c-49.13 0-88.88 31.88-88.88 71.13c0 23.12 14.12 43.63 35.5 56.5v14.62C170.6 408 178.6 416 188.5 416h71c9.875 0 17.88-8 17.88-17.75v-14.62c21.38-12.88 35.5-33.38 35.5-56.5C312.9 287.9 273.1 256 224 256zM188.5 344.9c-9.875 0-17.88-8-17.88-17.75c0-9.875 8-17.75 17.88-17.75c9.75 0 17.75 7.875 17.75 17.75C206.3 336.9 198.3 344.9 188.5 344.9zM259.5 344.9c-9.75 0-17.75-8-17.75-17.75c0-9.875 8-17.75 17.75-17.75c9.875 0 17.88 7.875 17.88 17.75C277.4 336.9 269.4 344.9 259.5 344.9z"],
    "flask-round-potion": [448, 512, ["flask-potion"], "f6e1", "M319.1 169V48h7.996c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24H119.1c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24h7.992v120.1C61.62 202.9 16 271.9 16 352c0 53.75 20.38 102.8 53.99 139.8C81.87 504.9 99.12 512 116.1 512h213.1c18 0 35.5-7.5 47.5-20.88c32.24-35.75 52.24-82.75 53.49-134.5C433.7 276.8 387.2 205.1 319.1 169zM267.5 329.1c-60.31-30.16-128.9-32.3-202.1 3.932c6.24-51.7 37.48-97.5 84.93-122.3l25.73-13.47V48h95.98v149.7l25.28 13.58c52.88 28.41 86.4 83.38 86.54 140.7C357.5 351.1 317.3 353.1 267.5 329.1z"],
    "floppy-disk": [448, 512, [128426, 61639, "save"], "1f4be", "M224 256c-35.2 0-64 28.8-64 64c0 35.2 28.8 64 64 64c35.2 0 64-28.8 64-64C288 284.8 259.2 256 224 256zM433.1 129.1l-83.9-83.9C341.1 37.06 328.8 32 316.1 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V163.9C448 151.2 442.9 138.9 433.1 129.1zM128 80h144V160H128V80zM400 416c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V96c0-8.838 7.164-16 16-16h16v104c0 13.25 10.75 24 24 24h192C309.3 208 320 197.3 320 184V83.88l78.25 78.25C399.4 163.2 400 164.8 400 166.3V416z"],
    "floppy-disk-circle-arrow-right": [576, 512, ["save-circle-arrow-right"], "e180", "M224 256c-35.2 0-64 28.8-64 64c0 35.2 28.8 64 64 64c11.83 0 22.81-3.473 32.35-9.133C256.3 372.6 256 370.3 256 368c0-30.26 7.65-58.73 21.1-83.6C265.6 267.3 246 256 224 256zM64 432c-8.836 0-16-7.164-16-16V96c0-8.838 7.164-16 16-16h16v104c0 13.25 10.75 24 24 24h192C309.3 208 320 197.3 320 184V83.88l78.25 78.25C399.4 163.2 400 164.8 400 166.3v28.7C410.4 193.1 421.1 192 432 192c5.402 0 10.72 .3301 16 .8066V163.9c0-12.68-5.076-24.94-14.04-33.9l-83.9-83.9C341.1 37.06 328.8 32 316.1 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h232.2c-11.78-14.26-21.2-30.48-28.05-48H64zM128 80h144V160H128V80zM432 224c-79.54 0-144 64.46-144 144s64.46 144 144 144c79.54 0 143.1-64.46 143.1-144S511.5 224 432 224zM507.3 379.3l-56 56C448.2 438.4 444.1 440 439.1 440s-8.187-1.562-11.31-4.688c-6.25-6.25-6.25-16.38 0-22.62L457.4 384h-89.38c-8.836 0-15.1-7.164-15.1-16s7.163-16 15.1-16h89.38l-28.69-28.69c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0l56 56C513.6 362.9 513.6 373.1 507.3 379.3z"],
    "floppy-disk-circle-xmark": [576, 512, ["floppy-disk-times", "save-circle-xmark", "save-times"], "e181", "M432 224c-9.941 0-19.65 1.008-29.02 2.926C337.4 240.4 288 298.4 288 368c0 79.54 64.46 144 144 144s144-64.46 144-144S511.5 224 432 224zM488.5 401.9c6.242 6.242 6.252 16.37 .0098 22.62c-6.24 6.242-16.37 6.231-22.62-.0113l-33.91-33.91l-33.91 33.91c-6.242 6.242-16.37 6.253-22.62 .0106s-6.232-16.37 .0098-22.62l33.91-33.91l-33.91-33.91c-6.242-6.242-6.251-16.37-.009-22.62s16.37-6.232 22.62 .0106l33.91 33.91l33.91-33.91c6.242-6.242 16.37-6.254 22.61-.0113s6.233 16.37-.009 22.62l-33.91 33.91L488.5 401.9zM224 256c-35.2 0-64 28.8-64 64c0 35.2 28.8 64 64 64c11.83 0 22.81-3.473 32.35-9.133C256.3 372.6 256 370.3 256 368c0-30.26 7.65-58.73 21.1-83.6C265.6 267.3 246 256 224 256zM64 432c-8.836 0-16-7.164-16-16V96c0-8.838 7.164-16 16-16h16v104c0 13.25 10.75 24 24 24h192C309.3 208 320 197.3 320 184V83.88l78.25 78.25C399.4 163.2 400 164.8 400 166.3v28.7C410.4 193.1 421.1 192 432 192c5.402 0 10.72 .3301 16 .8066V163.9c0-12.68-5.077-24.94-14.04-33.9l-83.9-83.9C341.1 37.06 328.8 32 316.1 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h232.2c-11.78-14.26-21.2-30.48-28.05-48H64zM128 80h144V160H128V80z"],
    "floppy-disk-pen": [576, 512, [], "e182", "M48 416V96c0-8.838 7.164-16 16-16h16v104c0 13.25 10.75 24 24 24h192C309.3 208 320 197.3 320 184V83.88l78.25 78.25C399.4 163.2 400 164.8 400 166.3v116.4l48-48V163.9c0-12.68-5.076-24.94-14.04-33.9l-83.9-83.9C341.1 37.06 328.8 32 316.1 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h195.8l9.594-48H64C55.16 432 48 424.8 48 416zM128 80h144V160H128V80zM307.4 420.6c-2.514 2.512-4.227 5.715-4.924 9.203l-14.28 71.41c-1.258 6.289 4.293 11.84 10.59 10.59l71.42-14.29c3.482-.6992 6.682-2.406 9.195-4.922l125.3-125.3l-72.01-72.01L307.4 420.6zM224 256c-35.2 0-64 28.8-64 64c0 35.2 28.8 64 64 64c35.2 0 64-28.8 64-64C288 284.8 259.2 256 224 256zM565.5 255.7l-21.1-21.11c-14.06-14.06-36.85-14.06-50.91 0l-38.13 38.13l72.01 72.01l38.13-38.13C579.5 292.5 579.5 269.7 565.5 255.7z"],
    "floppy-disks": [512, 512, [], "e183", "M497.9 97.94l-83.88-83.88C405.1 5.061 392.9 0 380.1 0H160C124.7 0 96 28.65 96 64v288c0 35.35 28.65 64 64 64h288c35.35 0 64-28.65 64-64V131.9C512 119.1 506.9 106.9 497.9 97.94zM224 48h112V96H224V48zM464 352c0 8.836-7.164 16-16 16H160c-8.836 0-16-7.164-16-16V64c0-8.838 7.164-16 16-16h16v72c0 13.25 10.75 24 24 24h160C373.3 144 384 133.3 384 120V51.88l78.23 78.23C463.4 131.2 464 132.8 464 134.4V352zM304 192c-35.2 0-64 28.8-64 64c0 35.2 28.8 64 64 64c35.2 0 64-28.8 64-64C368 220.8 339.2 192 304 192zM392 512h-272C53.83 512 0 458.2 0 392v-272C0 106.8 10.75 96 24 96S48 106.8 48 120v272c0 39.7 32.3 72 72 72h272c13.25 0 24 10.75 24 24S405.3 512 392 512z"],
    "florin-sign": [384, 512, [], "e184", "M384 56c0 13.25-10.75 24-24 24h-51.02c-16.81 0-31.94 10.62-37.64 26.44L226.1 232H328C341.3 232 352 242.8 352 256s-10.75 24-24 24h-119.1l-51.05 141.8C145.3 456.6 112 480 75.02 480H24C10.75 480 0 469.3 0 456s10.75-24 24-24h51.02c16.81 0 31.94-10.62 37.64-26.44L157.9 280H56C42.75 280 32 269.3 32 256s10.75-24 24-24h119.1l51.05-141.8C238.7 55.38 272 32 308.1 32H360C373.3 32 384 42.75 384 56z"],
    "flower": [512, 512, [127804, 63487], "273f", "M480 170.3C480 94.03 417.1 32 341.7 32C310.5 32 280.3 42.84 256 62.31C231.7 42.84 201.5 32 170.3 32C94.03 32 32 94.03 32 170.3C32 201.5 42.83 231.7 62.3 256C42.83 280.3 32 310.5 32 341.7C32 417.1 94.03 480 170.3 480C201.5 480 231.7 469.2 256 449.7C280.3 469.2 310.5 480 341.7 480C417.1 480 480 417.1 480 341.7C480 310.5 469.2 280.3 449.7 256C469.2 231.7 480 201.5 480 170.3zM400.8 274.1C420.9 291.7 432 315.7 432 341.7C432 391.5 391.5 432 341.7 432c-26.03 0-50.06-11.09-67.66-31.22L256 380.1l-18.06 20.66C220.3 420.9 196.3 432 170.3 432C120.5 432 80 391.5 80 341.7c0-26.03 11.08-50.06 31.19-67.66L131.9 256L111.2 237.9C91.08 220.3 80 196.3 80 170.3C80 120.5 120.5 80 170.3 80c26.03 0 50.06 11.09 67.66 31.22L256 131.9l18.06-20.66C291.7 91.09 315.7 80 341.7 80C391.5 80 432 120.5 432 170.3c0 26.03-11.08 50.06-31.19 67.66L380.1 256L400.8 274.1zM256 176C211.9 176 176 211.9 176 256s35.88 80 80 80s80-35.88 80-80S300.1 176 256 176zM256 288C238.4 288 224 273.6 224 256s14.36-32 32-32s32 14.36 32 32S273.6 288 256 288z"],
    "flower-daffodil": [512, 512, [63488], "2698", "M495.9 288h-47.26c-67.51 0-127.5 30-168.7 77v-82c37.38 12.88 78.76 0 102.3-31.88C405.8 219.2 405.9 175.9 382.5 144c11.38-15.5 17.5-34.12 17.5-53.38C400 40.62 359.4 0 309.4 0C290.1 0 271.5 6.125 256 17.5C240.5 6.125 221.9 0 202.6 0C152.6 0 111.1 40.62 111.1 90.62c0 19.25 6.126 37.88 17.5 53.38C118.1 159.5 111.1 178.1 111.1 197.4c0 29.25 14 56.75 37.88 73.75S204.4 292.6 231.1 283v82C190.9 318 130.9 288 63.35 288H16.09C6.962 288-.9142 296.9 .0859 307.7C9.962 422.1 106.4 512 223.9 512h64.26c117.5 0 213.9-89.88 223.8-204.4C512.9 297 505 288 495.9 288zM223.9 464c-79.51 0-148.8-54.13-169.9-128c75.26 0 128.6 32.25 160.9 85.88L240.1 464H223.9zM236.7 222.6C226.9 236.1 209.1 242.5 193.6 239C177.2 235.5 164.5 222.8 160.1 206.4C157.5 190 163.9 173.1 177.4 163.2L203.2 144L177.4 124.8c-10.88-8-17.38-20.63-17.38-34.13C159.1 67.12 179.1 48 202.6 48c13.5 0 26.13 6.5 34.13 17.38L256 91.25l19.25-25.87C283.1 54.5 295.9 48 309.4 48c23.5 0 42.63 19.12 42.63 42.62c0 13.5-6.501 26.13-17.38 34.13L308.8 144l25.88 19.25c10.88 8 17.38 20.63 17.38 34.13c0 23.5-19.13 42.62-42.63 42.62c-13.5 0-26.13-6.5-34.13-17.38L256 196.8L236.7 222.6zM288 464h-16.13l25.25-42.13C329.3 368.5 382.5 336 458.2 336C436.9 409.9 367.8 464 288 464zM288 144c0-17.62-14.38-32-32-32s-32 14.38-32 32S238.4 176 256 176S288 161.6 288 144z"],
    "flower-tulip": [512, 512, [63489], "1f337", "M495.9 288h-47.26c-67.51 0-127.5 30-168.7 77V287.9c75.26-.875 136-61.1 136-137.5V16c0-5.999-3.375-11.5-8.751-14.25c-5.376-2.75-11.88-2.125-16.75 1.375L316.6 56.75l-48.38-51C265.3 2.125 260.8 0 256 0C251.2 0 246.7 2.125 243.7 5.75l-48.38 51L121.5 3.125C116.6-.375 110.1-1 104.7 1.75C99.35 4.5 95.98 10 95.98 16v134.4c0 75.5 60.76 136.6 136 137.5V365C190.9 318 130.9 288 63.35 288H16.09C6.962 288-.9142 297 .0859 307.6C9.962 422.1 106.4 512 223.9 512h64.26c117.5 0 213.9-89.88 223.8-204.4C512.9 297 505 288 495.9 288zM143.1 150.4V78.38L199.1 120L256 64l56.01 56l56.01-41.62v72c0 49.5-40.13 89.62-89.64 89.62H233.6C184.1 240 143.1 199.9 143.1 150.4zM223.9 464c-79.64 0-148.8-54.13-170-128c75.26 0 128.8 32.25 161 85.88L240.1 464H223.9zM288 464h-16.13l25.25-42.13C329.1 368.6 382.4 336 458.2 336C436.9 409.9 367.8 464 288 464z"],
    "flute": [640, 512, [], "f8b9", "M320 232C306.8 232 296 242.8 296 256S306.8 280 320 280S344 269.3 344 256S333.3 232 320 232zM576 160H64C28.65 160 0 188.7 0 224v64c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V224C640 188.7 611.3 160 576 160zM96 304H64C55.16 304 48 296.8 48 288V224c0-8.838 7.164-16 16-16h32V304zM592 288c0 8.836-7.164 16-16 16H144v-96H576c8.836 0 16 7.162 16 16V288zM512 232c-13.25 0-24 10.75-24 24S498.8 280 512 280S536 269.3 536 256S525.3 232 512 232zM416 232c-13.25 0-24 10.75-24 24S402.8 280 416 280S440 269.3 440 256S429.3 232 416 232z"],
    "flux-capacitor": [448, 512, [], "f8ba", "M448 120v272c-.125 48.63-39.38 87.88-88 88h-272C39.38 479.9 .125 440.6 0 392v-272C.125 71.38 39.38 32.12 88 32h272C408.6 32.12 447.9 71.38 448 120zM400 120c0-22.12-17.88-40-40-40h-272C65.88 80 48 97.88 48 120v272c0 22.12 17.88 40 40 40h272c22.12 0 40-17.88 40-40V120zM384 176C384 220.1 348.1 256 304 256c-6.875-.25-13.75-1.25-20.5-3l48.75-48.75C339 197.8 344.5 184.9 344.5 175.5c0-22.12-17.88-40-40-40c-9.375 0-22.25 5.5-28.75 12.25L224 199.5L172.2 147.8C165.8 141 152.9 135.5 143.5 135.5c-22.12 0-40 17.88-40 40c0 9.375 5.5 22.25 12.25 28.75L164.5 253C157.8 254.8 150.9 255.8 144 256C99.88 256 64 220.1 64 176S99.88 96 144 96S224 131.9 224 176C224 131.9 259.9 96 304 96S384 131.9 384 176zM208 336V262.6L132.8 187.2c-2.75-3-4.25-6.875-4.5-11C128.2 172 129.1 168 133 165C136 162 140.1 160.2 144.4 160.2c4 .25 7.875 1.751 10.87 4.5L224 233.4l68.63-68.63c3.125-2.749 7-4.25 11-4.5c4.25 0 8.375 1.751 11.38 4.75C317.1 168 319.8 172 319.6 176.2c-.125 4.125-1.625 8-4.375 11L240 262.6V336c0 8.875-7.125 16-16 16S208 344.9 208 336zM304 336.1c0 44.12-35.88 80.06-80 80.06s-80-35.88-80-80c0-24 16.25-54.12 36.38-67.13L184 272.5V336c0 22.12 17.88 40 40 40s40-17.88 40-40V272.5l3.5-3.5C287.6 282 304 312.1 304 336.1z"],
    "flying-disc": [448, 512, [], "e3a9", "M447.1 131.1C447.1 92.05 425.5 32 349 32c-57.26 0-133.3 38.62-203.3 101.9c-15.97 14.21-31.13 28.83-49.86 50.78C41.42 246.8 0 319.7 0 380.9C0 419.1 22.51 480 98.97 480C233.5 480 447.1 270.6 447.1 131.1zM74.73 323.6c0-69.64 148.5-217.1 217.1-217.1c13.06 0 24.23 6.177 24.23 24.23c0 69.63-148.4 217.1-217.1 217.1C86.07 347.8 74.73 341.8 74.73 323.6zM400 130.1c0 110.8-191 301-301 301c-37.63 0-50.83-23.82-50.83-50.96c0-1.467 .0363-2.958 .1084-4.472c9.439 9.031 25.53 19.27 50.71 19.27c92.85 0 265.7-165.6 265.7-266.9c0-18.25-5.483-34.88-18.17-48.65C347.3 80.22 348.2 80 349 80C376.1 80 400 93.42 400 130.1z"],
    "folder": [512, 512, [128447, 61563, 61716], "1f4c1", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM64 80h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16v32h-416V96C48 87.18 55.18 80 64 80zM448 432H64c-8.822 0-16-7.176-16-16V240h416V416C464 424.8 456.8 432 448 432z"],
    "folder-arrow-down": [512, 512, ["folder-download"], "e053", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16V416zM319 271L280 310.1V208c0-13.25-10.75-24-24-24S232 194.8 232 208v102.1L192.1 271c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l80 80C243.7 389.7 249.9 392 256 392s12.28-2.344 16.97-7.031l80-80c9.375-9.375 9.375-24.56 0-33.94S328.4 261.7 319 271z"],
    "folder-arrow-up": [512, 512, ["folder-upload"], "e054", "M272.1 191c-9.375-9.375-24.56-9.375-33.94 0l-80 80c-9.375 9.375-9.375 24.56 0 33.94s24.56 9.375 33.94 0L232 265.9V368c0 13.25 10.75 24 24 24s24-10.75 24-24V265.9l39.03 39.03C323.7 309.7 329.8 312 336 312s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L272.1 191zM448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16V416z"],
    "folder-blank": [512, 512, [], "e185", "M447.1 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H63.1c-35.35 0-64 28.66-64 64v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C511.1 124.7 483.3 96 447.1 96zM463.1 416c0 8.824-7.178 16-16 16h-384c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L255.1 144h192c8.822 0 16 7.176 16 16V416z"],
    "folder-bookmark": [512, 512, [], "e186", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144v159.1c0 13.41 15.52 20.86 25.1 12.48L336 273.3l54 43.2C400.5 324.8 416 317.4 416 303.1V144h32c8.822 0 16 7.176 16 16V416z"],
    "folder-gear": [512, 512, ["folder-cog"], "e187", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16V416zM338.5 303.3C339.4 298.3 340 293.2 340 288s-.625-10.31-1.541-15.28L358.8 261c2.811-1.625 4.207-4.984 3.229-8.082C359.7 245.8 356.9 238.8 352.1 232s-8.562-12.73-13.62-18.25c-2.193-2.398-5.805-2.875-8.615-1.246l-20.52 11.85C302.5 217.8 293.7 212.6 284 209.1V185.5c0-3.246-2.215-6.137-5.387-6.836C271.3 177 263.8 176 256 176S240.7 177 233.4 178.7C230.2 179.4 228 182.3 228 185.5v23.64C218.3 212.6 209.5 217.8 201.8 224.4L181.2 212.5C178.4 210.9 174.8 211.4 172.6 213.8C167.6 219.3 162.9 225.2 159 232c-3.898 6.754-6.744 13.78-8.998 20.91C149 256 150.4 259.4 153.2 261l20.3 11.72C172.6 277.7 172 282.8 172 288s.623 10.31 1.539 15.28L153.2 315c-2.812 1.621-4.207 4.984-3.23 8.082C152.3 330.2 155.1 337.2 159 344c3.9 6.754 8.562 12.73 13.62 18.25c2.195 2.398 5.805 2.875 8.617 1.246l20.52-11.85C209.5 358.2 218.3 363.4 228 366.9v23.64c0 3.242 2.215 6.137 5.387 6.836C240.7 398.1 248.2 400 256 400s15.3-1.047 22.61-2.664c3.172-.6992 5.387-3.594 5.387-6.836v-23.64c9.734-3.465 18.54-8.637 26.24-15.21l20.52 11.85c2.811 1.629 6.422 1.152 8.615-1.246c5.055-5.52 9.716-11.5 13.62-18.25s6.745-13.78 8.999-20.92c.9766-3.098-.4199-6.461-3.23-8.082L338.5 303.3zM256 323c-19.33 0-35-15.67-35-35S236.7 253 256 253c19.33 0 35 15.67 35 35S275.3 323 256 323z"],
    "folder-grid": [512, 512, [], "e188", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16V416zM160 240H96C87.16 240 80 247.2 80 256v64c0 8.844 7.156 16 16 16h64c8.844 0 16-7.156 16-16V256C176 247.2 168.8 240 160 240zM288 240H224C215.2 240 208 247.2 208 256v64c0 8.844 7.156 16 16 16h64c8.844 0 16-7.156 16-16V256C304 247.2 296.8 240 288 240zM416 240h-64c-8.844 0-16 7.156-16 16v64c0 8.844 7.156 16 16 16h64c8.844 0 16-7.156 16-16V256C432 247.2 424.8 240 416 240z"],
    "folder-heart": [512, 512, [], "e189", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16V416zM264.3 210.9L255.9 219.7L247.4 210.9C226 188.7 191.1 185.1 167.6 205.1C140.7 228.1 139.2 269.3 163.3 294.3l82.93 85.56c5.385 5.504 14.04 5.504 19.42 0l82.97-85.56c24.11-25.02 22.64-66.17-4.41-89.19C320.9 185.1 285.9 188.7 264.3 210.9z"],
    "folder-image": [512, 512, [], "e18a", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16V416zM127.1 240c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S110.3 240 127.1 240zM306.6 215.1C303.7 210.7 298.7 208 293.3 208s-10.35 2.672-13.31 7.125l-62.74 94.11L194.9 278.6C191.9 274.4 187.1 272 181.1 272c-5.111 0-9.916 2.441-12.93 6.574l-70 96c-3.549 4.863-4.064 11.31-1.334 16.68C100.5 396.6 105.1 400 112 400h288c5.9 0 11.32-3.246 14.11-8.449c2.783-5.203 2.479-11.52-.7949-16.43L306.6 215.1z"],
    "folder-magnifying-glass": [576, 512, ["folder-search"], "e18b", "M480 96h-172.1L258.7 50.75C246.7 38.74 230.5 32 213.5 32H96C60.65 32 32 60.66 32 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C544 124.7 515.3 96 480 96zM496 416c0 8.824-7.178 16-16 16H96c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L288 144h192c8.822 0 16 7.176 16 16V416zM354.4 320.5C362.8 306.2 368 289.8 368 272c0-53.02-42.98-96-96-96s-96 42.98-96 96s42.98 96 96 96c17.77 0 34.21-5.16 48.48-13.58l46.55 46.55C371.7 405.7 377.8 408 384 408s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L354.4 320.5zM272 320C245.5 320 224 298.5 224 272S245.5 224 272 224S320 245.5 320 272S298.5 320 272 320z"],
    "folder-medical": [512, 512, [], "e18c", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16V416zM336 256H288V208C288 199.2 280.8 192 272 192h-32C231.2 192 224 199.2 224 208V256H176C167.2 256 160 263.2 160 271.1V304c0 8.797 7.199 15.1 16 15.1L224 319.1v47.1C224 376.8 231.2 384 240 384h32c8.801 0 16-7.201 16-16V319.1l48-.0012c8.801 0 16-7.201 16-15.1V271.1C352 263.2 344.8 256 336 256z"],
    "folder-minus": [512, 512, [], "f65d", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.66 32 0 60.66 0 96v320c0 35.34 28.66 64 64 64h384c35.34 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.18 16-16 16H64c-8.82 0-16-7.176-16-16V96c0-8.824 7.18-16 16-16h117.5c4.273 0 8.289 1.664 11.31 4.688L256 144h192c8.82 0 16 7.176 16 16V416zM336 264H175.1C162.7 264 152 274.7 152 288c0 13.26 10.73 23.1 23.1 23.1h160C349.3 311.1 360 301.3 360 288S349.3 264 336 264z"],
    "folder-music": [512, 512, [], "e18d", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16V416zM331.3 176.8L203.3 224C196.5 226.1 192 232.3 192 239.3v114.7C186.8 352.8 181.4 352 176 352C149.5 352 128 366.4 128 384s21.5 32 48 32S224 401.6 224 384V283.1l96-37.5v76.38C314.8 320.8 309.4 320 304 320c-26.5 0-48 14.38-48 32s21.5 32 48 32s48-14.38 48-32V192c0-5.125-2.375-9.875-6.5-12.88S336 175.3 331.3 176.8z"],
    "folder-open": [576, 512, [128449, 61564, 61717], "1f4c2", "M572.6 270.3l-96 192C471.2 473.2 460.1 480 447.1 480H64c-35.35 0-64-28.66-64-64V96c0-35.34 28.65-64 64-64h117.5c16.97 0 33.25 6.742 45.26 18.75L275.9 96H416c35.35 0 64 28.66 64 64v32h-48V160c0-8.824-7.178-16-16-16H256L192.8 84.69C189.8 81.66 185.8 80 181.5 80H64C55.18 80 48 87.18 48 96v288l71.16-142.3C124.6 230.8 135.7 224 147.8 224h396.2C567.7 224 583.2 249 572.6 270.3z"],
    "folder-plus": [512, 512, [], "f65e", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.66 32 0 60.66 0 96v320c0 35.34 28.66 64 64 64h384c35.34 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.18 16-16 16H64c-8.82 0-16-7.176-16-16V96c0-8.824 7.18-16 16-16h117.5c4.273 0 8.289 1.664 11.31 4.688L256 144h192c8.82 0 16 7.176 16 16V416zM336 264h-56V207.1C279.1 194.7 269.3 184 256 184S232 194.7 232 207.1V264H175.1C162.7 264 152 274.7 152 288c0 13.26 10.73 23.1 23.1 23.1h56v56C232 381.3 242.7 392 256 392c13.26 0 23.1-10.74 23.1-23.1V311.1h56C349.3 311.1 360 301.3 360 288S349.3 264 336 264z"],
    "folder-tree": [576, 512, [], "f802", "M544 320h-96l-44.16-27.23C398.8 289.6 392.1 288 387 288H320c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32h224c17.67 0 32-14.33 32-32v-128C576 334.3 561.7 320 544 320zM528 464h-192v-128h46.5l40.3 24.86C430.4 365.5 439.1 368 448 368h80V464zM232 160C245.3 160 256 149.3 256 136C256 122.7 245.3 112 232 112H48V24C48 10.74 37.25 0 24 0S0 10.74 0 24v368C0 422.9 25.07 448 56 448h176C245.3 448 256 437.3 256 424c0-13.26-10.75-24-24-24h-176c-4.4 0-8-3.602-8-8V160H232zM544 32h-96l-44.16-27.23C398.8 1.648 392.1 0 387 0H320c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32h224c17.67 0 32-14.33 32-32V64C576 46.33 561.7 32 544 32zM528 176h-192v-128h46.5l40.3 24.86C430.4 77.53 439.1 80 448 80h80V176z"],
    "folder-user": [512, 512, [], "e18e", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.178 16-16 16h-65.61C374.7 386.6 335.5 352 288 352H224c-47.54 0-86.73 34.64-94.39 80H64c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16V416zM256 192C220.7 192 192 220.7 192 256c0 35.34 28.65 64 64 64s64-28.66 64-64C320 220.7 291.3 192 256 192z"],
    "folder-xmark": [512, 512, ["folder-times"], "f65f", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.66 32 0 60.66 0 96v320c0 35.34 28.66 64 64 64h384c35.34 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM464 416c0 8.824-7.18 16-16 16H64c-8.82 0-16-7.176-16-16V96c0-8.824 7.18-16 16-16h117.5c4.273 0 8.289 1.664 11.31 4.688L256 144h192c8.82 0 16 7.176 16 16V416zM336.1 207c-9.375-9.375-24.56-9.375-33.94 0L256 254.1L208.1 207c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94L222.1 288l-47.03 47.03c-9.375 9.375-9.375 24.56 0 33.94c9.375 9.371 24.55 9.379 33.94 0L256 321.9l47.03 47.03c9.375 9.371 24.55 9.379 33.94 0c9.375-9.375 9.375-24.56 0-33.94L289.9 288l47.03-47.03C346.3 231.6 346.3 216.4 336.1 207z"],
    "folders": [640, 512, [], "f660", "M544 96h-140.1l-49.14-45.25C342.7 38.74 326.5 32 309.5 32H192C156.7 32 128 60.66 128 96v224c0 35.34 28.65 64 64 64h352c35.35 0 64-28.66 64-64V160C608 124.7 579.3 96 544 96zM560 320c0 8.824-7.178 16-16 16H192c-8.822 0-16-7.176-16-16V96c0-8.824 7.178-16 16-16h117.5c4.273 0 8.293 1.664 11.31 4.688L384 144h160c8.822 0 16 7.176 16 16V320zM488 480H152C85.83 480 32 426.2 32 360v-240C32 106.8 42.75 96 56 96S80 106.8 80 120v240c0 39.7 32.3 72 72 72h336c13.25 0 24 10.75 24 24S501.3 480 488 480z"],
    "font": [448, 512, [], "f031", "M424 432h-31.44L246.4 47.47c-3.5-9.25-12.51-15.37-22.38-15.46c-.0938 0 .0625 0 0 0c-9.812 0-18.68 5.961-22.34 15.09L47.76 432H24C10.75 432 0 442.8 0 456S10.75 480 24 480h112C149.3 480 160 469.3 160 456S149.3 432 136 432H99.45l35.21-88h173.1l33.44 88H312c-13.25 0-24 10.75-24 24S298.8 480 312 480h112c13.25 0 24-10.75 24-24S437.3 432 424 432zM153.9 296l69.58-173.9L289.5 296H153.9z"],
    "font-awesome": [448, 512, [62694, 61964, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M448 48V384c-63.09 22.54-82.34 32-119.5 32c-62.82 0-86.6-32-149.3-32c-21.69 0-38.48 3.791-53.74 8.766C110.1 397.5 96 386.1 96 371.7v-.7461c0-9.275 5.734-17.6 14.42-20.86C129.1 342.8 150.2 336 179.2 336c62.73 0 86.51 32 149.3 32c25.5 0 42.85-4.604 71.47-14.7v-240C379.2 120.6 357.7 128 328.5 128c-.0039 0 .0039 0 0 0c-62.81 0-86.61-32-149.3-32C122.1 96 98.8 122.1 48 126.1V456C48 469.3 37.25 480 24 480S0 469.3 0 456V56C0 42.74 10.75 32 24 32S48 42.74 48 56v22.99C98.8 74.14 122.1 48 179.2 48c62.77 0 86.45 32 149.3 32C366.1 80 386.8 69.85 448 48z"],
    "font-case": [640, 512, [