<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWaiterCallsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('waiter_calls', function (Blueprint $table) {
            $table->id();
            $table->string("customer_name");
            $table->text("customer_phone");
            $table->text("table_name")->nullable();
            $table->string("order_id")->nullable();
            $table->string("comment")->nullable();
            $table->unsignedBigInteger('store_id');
            $table->boolean("is_completed")->default(0);
            $table->foreign('store_id')->references('id')->on('stores')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('waiter_calls');
    }
}
