<?php

namespace App\Http\Livewire\Home\Payments;

use Livewire\Component;
use App\Models\Order;

class StripeFail extends Component
{
    public $view_id,$order;
    public function render()
    {
        return view('livewire.home.payments.stripe-fail')
        ->extends('layouts.Home_layout')
        ->section('content');
    }

    public function mount($orderid)
    {
        $orderid = base64_decode($orderid);
        $this->order = Order::where('order_unique_id',$orderid)->first();
        if(!$this->order)
        {
            abort(404);
        }
        $store = \App\Models\Store::where('id',$this->order->store_id)->first();
        $this->view_id = $store->view_id;
    }
}