<?php

namespace App\Http\Livewire\Home\Payments;

use Livewire\Component;
use App\Models\Order;
class PaymentSuccess extends Component
{
    public $view_id,$order;
    public function render()
    {
        return view('livewire.home.payment-success')
        ->extends('layouts.home_layout')
        ->section('content');
    }

    public function mount($order_id = null)
    {
        $order_id = base64_decode($order_id);
        if(!$order_id)
        {
            abort(404);
        }
        $this->order = Order::where('order_unique_id',$order_id)->first();
        $this->order->status = 1;
        $this->payment_status = 1; 
        $this->order->save();
        $store = \App\Models\Store::where('id',$this->order->store_id)->first();
        $this->view_id = $store->view_id;
        session()->forget('cart'.$store->id);
    }
}