<?php

namespace App\Http\Livewire\Home;

use Livewire\Component;
use App\Http\Controllers\TranslationService;
use App\Translation;
use App\Models\Store;
use App\Product;
use App\Category;
class SearchProducts extends Component
{
    public $search_query,$store,$view_id,$selected_lanugage,$categories,$products,$selected_category,$count,$favicon;
    public function render()
    {
        return view('livewire.home.search-products')
        ->extends('layouts.home_layout',['title' => $this->store->store_name,'favicon' => $this->favicon])
        ->section('content');
    }

    public function mount($view_id)
    {
        $appsettings = \App\Application::all()->first();
        if($appsettings)
        {
            if(file_exists($appsettings->fav_icon))
            {
                $this->favicon = $appsettings->fav_icon;
            }
        }
        $translation = new TranslationService();
        if(session()->has('selected_language'))
        {
            $this->selected_language = Translation::where('id',session()->get('selected_language'))->first();
        }
        else{
            $this->selected_language = Translation::where('is_default',1)->first();
        }
        $this->view_id = $view_id;
        if(Store::all()->where('view_id','=',$view_id)->count() ==0){
            abort(404);
        }
        $this->store = Store::all()->where('view_id','=',$view_id)->first();
        $this->account_info = $this->store;
        $this->categories = Category::where('store_id',$this->store->id)->where('is_active',1)->has('productinfos')->get();
        $this->products = Product::where('store_id',$this->store->id)->where('is_active',1)->limit(10)->get();
    }

    public function updated($name,$value)
    {
        if($name == 'search_query')
        {
            if($this->selected_category)
            {
                $this->products = Product::where('name', 'like', '%' . $value . '%')->where('category_id',$this->selected_category->id)->where('store_id',$this->store->id)->where('is_active',1)->get();
            }
            else{
                $this->products = Product::where('name', 'like', '%' . $value . '%')->where('store_id',$this->store->id)->where('is_active',1)->get();

            }
        }
        if($name == 'search_query' && $value == '')
        {
            if($this->selected_category)
            {
                $this->products = Product::where('category_id',$this->selected_category->id)->where('store_id',$this->store->id)->where('is_active',1)->get();

            }
            else{
                $this->products = Product::where('store_id',$this->store->id)->where('is_active',1)->limit(10)->get();
            }
            
        }
    }

    public function selectCategory($id)
    {
        if($this->selected_category)
        {
            if($this->selected_category->id == $id)
            {
                $this->selected_category = null;
                $this->products = Product::where('store_id',$this->store->id)->where('is_active',1)->limit(10)->get();

            }
            else{
                $this->selected_category = Category::where('id',$id)->first();
                $this->products = Product::where('category_id',$this->selected_category->id)->where('store_id',$this->store->id)->where('is_active',1)->get();

            }
        }
        else{
            $this->selected_category = Category::where('id',$id)->first();
            $this->products = Product::where('category_id',$this->selected_category->id)->where('store_id',$this->store->id)->where('is_active',1)->get();
        }
    }
    public function getCartCount()
    {
        $cart = session()->get('cart'.$this->store->id);
        if(isset($cart))
        {
            $this->count = count($cart);
        }
    }
}
