/*!
 * Font Awesome Pro 6.0.0-beta1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};

  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {}

  var _ref = _WINDOW.navigator || {},
      _ref$userAgent = _ref.userAgent,
      userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e) {
      return false;
    }
  }();

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);

      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }

      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  var w = WINDOW || {};
  if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
  if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
  if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;

      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }

      return acc;
    }, {});
  }

  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
        skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);

    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }
    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll easy the upgrade process for our users by automatically defining
     * this as well.
     */


    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", "M160 32.01c-88.22 0-160 71.78-160 160v127.1c0 88.22 71.78 160 160 160s160-71.78 160-160V192C320 103.8 248.2 32.01 160 32.01zM288 320c0 70.59-57.41 128-128 128s-128-57.41-128-128V192c0-70.59 57.41-128 128-128s128 57.41 128 128V320z"],
    "1": [256, 512, [], "31", "M256 464c0 8.844-7.156 16-16 16h-224C7.156 480 0 472.8 0 464S7.156 448 16 448h96V78.72L57.17 117.1C49.95 122.2 39.95 120.4 34.89 113.2C29.83 105.9 31.58 95.97 38.83 90.91l80-55.1c4.891-3.438 11.28-3.875 16.56-1.094C140.7 36.57 144 42.04 144 48.01V448h96C248.8 448 256 455.2 256 464z"],
    "2": [320, 512, [], "32", "M320 463.1C320 472.8 312.8 480 304 480H16c-6.607 0-12.53-4.064-14.92-10.22s-.7344-13.16 4.156-17.63l213.2-194.2c45.7-40.07 51.02-107.7 12.28-154.2C211.5 80.66 184.4 66.66 154.4 64.29c-29.75-2.221-58.89 7.25-81.53 27.03L40.86 119.4C34.22 125.1 24.13 124.5 18.28 117.9C12.47 111.2 13.14 101.1 19.8 95.29l32.05-28.04C81 41.72 118.6 29.66 156.9 32.38c38.64 3.064 73.58 21.13 98.39 50.88c49.94 59.95 43.09 147.2-15.55 198.6l-182.4 166.1H304C312.8 447.1 320 455.2 320 463.1z"],
    "3": [320, 512, [], "33", "M320 352c0 70.59-57.42 128-128 128H93.09c-41.94 0-79.02-26.72-92.27-66.5c-2.797-8.375 1.734-17.44 10.11-20.25c8.422-2.812 17.44 1.75 20.23 10.12C40.08 430.1 64.95 448 93.09 448H192c52.94 0 96-43.06 96-96s-43.06-96-96-96H80C73.41 256 67.5 251.1 65.09 245.8c-2.391-6.125-.7813-13.09 4.047-17.56L247.1 64H16C7.156 64 0 56.84 0 48S7.156 32 16 32h272c6.594 0 12.5 4.031 14.91 10.19c2.391 6.125 .7813 13.09-4.047 17.56L120.9 224H192C262.6 224 320 281.4 320 352z"],
    "4": [384, 512, [], "34", "M384 336c0 8.843-7.156 15.1-15.1 15.1l-47.1-.005l.0006 111.1c0 8.843-7.156 15.1-15.1 15.1s-15.1-7.156-15.1-15.1v-111.1H16c-5.547 0-10.69-2.875-13.61-7.593C-.5267 339.7-.7923 333.8 1.692 328.9l143.1-287.1c3.969-7.875 13.55-11.16 21.47-7.156c7.906 3.969 11.11 13.56 7.156 21.47l-132.4 264.8h246.1V144c0-8.843 7.156-15.1 15.1-15.1s15.1 7.156 15.1 15.1v175.1h47.1C376.8 320 384 327.2 384 336z"],
    "5": [320, 512, [], "35", "M320 352c0 70.59-57.42 128-128 128H94.7c-42.66 0-80.39-27.19-93.88-67.66c-2.797-8.375 1.734-17.44 10.11-20.25c8.484-2.844 17.45 1.75 20.23 10.12C40.31 429.6 65.84 448 94.7 448H192c52.94 0 96-43.06 96-96s-43.06-96-96-96H16C11.08 256 6.422 253.7 3.391 249.8s-4.109-8.938-2.906-13.72l48-192C50.27 37 56.66 32.01 64 32.01L272 32C280.8 32 288 39.16 288 48S280.8 64 272 64H76.5l-40 160H192C262.6 224 320 281.4 320 352z"],
    "6": [320, 512, [], "36", "M0 320c0 88.22 71.78 160 160 160s160-71.78 160-160S248.2 160 160 160C147.5 160 135.4 161.8 123.7 164.5l96.17-105.8c5.938-6.531 5.469-16.66-1.094-22.59C215.7 33.38 211.8 32.01 208 32.01c-4.344 0-8.688 1.74-11.84 5.24C51.7 196.1 0 238.6 0 320zM288 320c0 70.59-57.41 128-128 128s-128-57.41-128-128s57.41-128 128-128S288 249.4 288 320z"],
    "7": [320, 512, [], "37", "M317.6 56.38l-256 416C58.6 477.3 53.35 480 48 480c-2.875 0-5.781-.75-8.375-2.375c-7.531-4.625-9.875-14.5-5.25-22L275.4 64H16C7.156 64 0 56.84 0 48S7.156 32 16 32h288c5.781 0 11.13 3.125 13.97 8.188C320.8 45.25 320.7 51.44 317.6 56.38z"],
    "8": [320, 512, [], "38", "M250.7 251.7C282.8 230.1 304 193.5 304 152C304 85.84 250.2 32 184 32h-48C69.84 32 16 85.84 16 152c0 41.48 21.19 78.09 53.29 99.65C28.5 270.8 0 312 0 360C0 426.2 53.84 480 120 480h80c66.16 0 120-53.84 120-120C320 312 291.5 270.8 250.7 251.7zM48 152C48 103.5 87.47 64 136 64h48c48.53 0 88 39.47 88 88S232.5 240 184 240h-48C87.47 240 48 200.5 48 152zM200 448h-80C71.47 448 32 408.5 32 360S71.47 272 120 272h80c48.53 0 88 39.47 88 88S248.5 448 200 448z"],
    "9": [320, 512, [], "39", "M320 192c0-88.22-71.78-160-160-160s-160 71.78-160 160S71.78 352 160 352c12.54 0 24.61-1.797 36.33-4.539l-96.17 105.8c-5.938 6.531-5.469 16.66 1.094 22.59C104.3 478.6 108.2 480 112 480c4.344 0 8.688-1.76 11.84-5.26C268.3 315.9 320 273.4 320 192zM32 192c0-70.59 57.41-128 128-128s128 57.41 128 128s-57.41 128-128 128S32 262.6 32 192z"],
    "360-degrees": [640, 512, [], "e2dc", "M496 64c-44.12 0-79.1 35.89-79.1 80v224c0 44.11 35.88 80 79.1 80s79.1-35.89 79.1-80v-224C576 99.89 540.1 64 496 64zM544 368c0 26.47-21.53 48-47.1 48c-26.47 0-47.1-21.53-47.1-48v-224c0-26.47 21.53-48 47.1-48c26.47 0 47.1 21.53 47.1 48V368zM304 192C285.9 192 269.4 198.3 256 208.4V204.6c0-46.78 29.53-89.05 73.44-105.2l12.06-4.422c8.312-3.031 12.56-12.22 9.531-20.52c-3.031-8.312-12.31-12.56-20.53-9.516L318.4 69.41C261.9 90.11 224 144.4 224 204.6L224 368c0 44.11 35.88 80 79.1 80s79.1-35.89 79.1-80l.0001-96C384 227.9 348.1 192 304 192zM352 368c0 26.47-21.53 48-47.1 48c-26.47 0-47.1-21.53-47.1-48v-96c0-26.47 21.53-48 47.1-48c26.47 0 48 21.53 48 48V368zM608 0c-17.67 0-31.1 14.33-31.1 32c0 17.67 14.33 32 31.1 32C625.7 64 640 49.67 640 32C640 14.33 625.7 0 608 0zM81.44 208l95.03-117.1C180.3 85.23 181.1 78.66 178.4 73.09C175.8 67.53 170.2 64 164 64H16C7.161 64 .0047 71.16 .0047 80S7.161 96 16 96h114.6L35.54 213.1c-3.844 4.797-4.625 11.38-1.969 16.94S41.85 240 48 240h32.72c43.72 0 79.28 35.56 79.28 79.28v17.44C160 380.4 124.4 416 80.72 416c-21.53 0-41.47-10.64-50.81-27.11c-4.375-7.703-14.16-10.38-21.81-6.016c-7.687 4.375-10.37 14.14-5.1 21.83C17.25 431.4 47.38 448 80.72 448c61.37 0 111.3-49.92 111.3-111.3V319.3C192 258.2 142.5 208.4 81.44 208z"],
    "a": [384, 512, [97], "41", "M382.7 457.7L206.7 40.92c-4.1-11.9-24.47-11.9-29.47 0L1.267 457.7c-3.437 8.141 .3594 17.53 8.5 21.01c8.078 3.319 17.52-.3757 20.97-8.548l36.48-86.39h249.6l36.48 86.39C355.8 476.3 361.8 480 367.1 480c2.078 0 4.203-.407 6.234-1.252C382.4 475.3 386.2 465.9 382.7 457.7zM80.75 351.7L192 88.3l111.2 263.5H80.75z"],
    "abacus": [576, 512, [63040], "1f9ee", "M512 32H64c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64v-320C576 60.65 547.3 32 512 32zM512 64c17.64 0 32 14.36 32 32v96h-96l0-31.1L464 160C472.8 160 480 152.8 480 144s-7.156-15.1-16-15.1L448 128V64H512zM416 64v64l-16 .0002c-8.844 0-16 7.156-16 15.1S391.2 160 400 160l15.1 .0004L416 192h-128l0-31.1L304 160C312.8 160 320 152.8 320 144s-7.156-15.1-16-15.1L288 128V64H416zM256 64v64L240 128C231.2 128 224 135.2 224 144S231.2 160 240 160l15.1 .0004L256 192H160l0-31.1L176 160C184.8 160 192 152.8 192 144S184.8 128 176 128L160 128V64H256zM32 96c0-17.64 14.36-32 32-32h64v64L112 128C103.2 128 96 135.2 96 144S103.2 160 112 160l15.1 .0004L128 192H32V96zM64 448c-17.64 0-32-14.36-32-32V224h96v64L112 288C103.2 288 96 295.2 96 304S103.2 320 112 320l15.1 .0004v32L112 352C103.2 352 96 359.2 96 368s7.156 16 16 16L128 384v64H64zM160 448v-64l16 .0002c8.844 0 16-7.156 16-16S184.8 352 176 352l-15.1 .0004v-32L176 320C184.8 320 192 312.8 192 304S184.8 288 176 288L160 288V224h96v64L240 288C231.2 288 224 295.2 224 304S231.2 320 240 320l15.1 .0004v32L240 352C231.2 352 224 359.2 224 368s7.156 16 16 16L256 384v64H160zM288 448v-64l16 .0002c8.844 0 16-7.156 16-16S312.8 352 304 352l-15.1 .0004v-32L304 320c8.844 0 16-7.156 16-16s-7.156-15.1-16-15.1L288 288V224h128l0 128L400 352c-8.844 0-16 7.156-16 16s7.156 16 16 16L416 384v64H288zM544 416c0 17.64-14.36 32-32 32h-64v-64l16 .0002c8.844 0 16-7.156 16-16S472.8 352 464 352l-15.1 .0004L448 224h96V416z"],
    "accent-grave": [192, 512, [], "60", "M40.3 90.61l67.69 115.4c6.688 11.43 18.84 18.03 31.51 18.03c4.164 0 8.381-.7115 12.48-2.2c16.59-6.018 26.48-22.99 23.49-40.31l-22.57-131.7c-3.045-17.81-13.79-33.2-29.45-42.25c-8.891-5.154-18.84-7.542-28.8-7.544c-.0039 0 .002 0 0 0c-25.06 0-50.23 15.13-58.1 39.39C29.5 56.36 31.18 75.03 40.3 90.61zM65.73 50.31C69.51 39.86 81.94 32 94.65 32c4.77 .002 9.062 1.088 12.76 3.229c7.449 4.307 12.52 11.57 13.96 19.96l22.57 131.7c.3594 2.076-.8457 4.092-2.861 4.822c-.457 .0449-.8828 .0684-1.283 .0684c-2.074 0-3.387-.625-4.18-1.98L67.9 74.42C63.63 67.11 62.83 58.31 65.73 50.31z"],
    "acorn": [448, 512, [], "f6ae", "M352 64.04l-106.6-.0063c4.447-13.69 11.63-26.44 21.9-36.72c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0C228.4 21 217.2 41.76 211.9 64.03L96 64.04c-53 0-95.1 42.97-95.1 95.97L0 176c0 17.62 14.38 32 32 32V224c0 98 55.38 187.8 143.1 231.5L224 480l48.88-24.5C360.6 411.8 416 322 416 224V208c17.62 0 32-14.38 32-32l-.001-16.01C447.1 107 405 64.04 352 64.04zM384 224c0 86.5-48 164.3-125.4 202.9L224 444.3l-34.63-17.38C112 388.3 64 310.5 64 224V208h320V224zM416 176H32V160c0-35.25 28.75-64 64-64h256c35.25 0 64 28.75 64 64V176z"],
    "address-book": [512, 512, [62138, "contact-book"], "f2b9", "M272 288h-64C163.8 288 128 323.8 128 368C128 376.8 135.2 384 144 384C152.8 384 160 376.8 160 368C160 341.5 181.5 320 208 320h64c26.51 0 48 21.49 48 48c0 8.836 7.164 16 16 16c8.837 0 16-7.164 16-16C352 323.8 316.2 288 272 288zM496 192H480v96h16C504.8 288 512 280.8 512 272v-64C512 199.2 504.8 192 496 192zM240 256c35.35 0 64-28.65 64-64s-28.65-64-64-64s-64 28.65-64 64S204.7 256 240 256zM240 160c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S222.4 160 240 160zM496 320H480v96h16c8.837 0 16-7.164 16-16v-64C512 327.2 504.8 320 496 320zM496 64H480v96h16C504.8 160 512 152.8 512 144v-64C512 71.16 504.8 64 496 64zM384 0H96C60.65 0 32 28.65 32 64v384c0 35.35 28.65 64 64 64h288c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM416 448c0 17.64-14.36 32-32 32H96c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h288c17.64 0 32 14.36 32 32V448z"],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M480 288h-128c-8.836 0-16 7.164-16 16S343.2 320 352 320h128c8.836 0 16-7.164 16-16S488.8 288 480 288zM192 256c35.35 0 64-28.65 64-64S227.3 128 192 128S128 156.7 128 192S156.7 256 192 256zM192 160c17.64 0 32 14.36 32 32S209.6 224 192 224S160 209.6 160 192S174.4 160 192 160zM224 288H160c-44.18 0-80 35.82-80 80C80 376.8 87.16 384 96 384s16-7.164 16-16C112 341.5 133.5 320 160 320h64c26.51 0 48 21.49 48 48c0 8.836 7.164 16 16 16s16-7.164 16-16C304 323.8 268.2 288 224 288zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V416zM480 224h-128c-8.836 0-16 7.164-16 16S343.2 256 352 256h128c8.836 0 16-7.164 16-16S488.8 224 480 224zM480 160h-128c-8.836 0-16 7.164-16 16S343.2 192 352 192h128c8.836 0 16-7.164 16-16S488.8 160 480 160z"],
    "air-conditioner": [576, 512, [], "f8f4", "M224 416c0 35.3-28.7 64-64 64c-26.47 0-48-21.53-48-48S133.5 384 160 384c8.836 0 16-7.164 16-16S168.8 352 160 352c-44.11 0-80 35.89-80 79.1S115.9 512 160 512c52.94 0 96-43.06 96-96V288H224V416zM416 320c-8.836 0-16 7.164-16 15.1S407.2 352 416 352c26.47 0 48 21.53 48 48S442.5 448 416 448c-35.3 0-64-28.7-64-64V288h-32v96c0 52.94 43.06 96 96 96c44.11 0 80-35.89 80-80S460.1 320 416 320zM512 .0002H64c-35.2 0-64 28.8-64 64V192c0 35.2 28.8 64 64 64h448c35.2 0 64-28.8 64-64V64C576 28.8 547.2 .0002 512 .0002zM544 192c0 17.67-14.33 32-32 32H64C46.33 224 32 209.7 32 192V64c0-17.67 14.33-32 32-32h448c17.67 0 32 14.33 32 32V192zM464 128h-352C103.2 128 96 135.2 96 144S103.2 160 112 160h352C472.8 160 480 152.8 480 144S472.8 128 464 128z"],
    "airplay": [576, 512, [], "e089", "M496 32h-416C35.88 32 0 67.88 0 112v224C0 380.1 35.88 416 80 416C88.84 416 96 408.8 96 400S88.84 384 80 384C53.53 384 32 362.5 32 336v-224C32 85.53 53.53 64 80 64h416C522.5 64 544 85.53 544 112v224c0 26.47-21.53 48-48 48c-8.844 0-16 7.156-16 16s7.156 16 16 16c44.13 0 80-35.88 80-80v-224C576 67.88 540.1 32 496 32zM310.6 297.4c-12.5-12.5-32.86-12.5-45.36 0l-127.1 128C117.3 445.5 131.7 480 160 480h255.9c28.37 0 42.73-34.5 22.62-54.63L310.6 297.4zM160 448l127.1-128L415.1 448H160z"],
    "alarm-clock": [512, 512, [62286], "23f0", "M272 296V176c0-8.844-7.156-16-15.1-16S240 167.2 240 176v128c0 5.031 2.375 9.781 6.406 12.8l64 48C313.3 366.1 316.6 368 319.1 368c4.875 0 9.672-2.203 12.81-6.406c2.162-2.875 3.207-6.244 3.207-9.584c0-4.863-2.213-9.666-6.41-12.81L272 296zM41.61 156.8C48.67 151.5 50.09 141.5 44.8 134.4C36.42 123.3 32 109.1 32 96c0-35.3 28.7-64 64-64c13.97 0 27.25 4.422 38.39 12.8c7.031 5.297 17.11 3.891 22.41-3.188C162.1 34.55 160.7 24.52 153.6 19.2C136.9 6.641 116.9 0 95.1 0c-52.94 0-96 43.06-96 96c0 20.95 6.644 40.88 19.21 57.61C22.34 157.8 27.16 160 32.02 160C35.36 160 38.73 158.1 41.61 156.8zM256 64C132.3 64 32 164.3 32 288c0 56.09 20.76 107.2 54.84 146.5l-50.15 50.15c-6.25 6.25-6.25 16.38 0 22.62C39.81 510.4 43.91 512 48 512s8.188-1.562 11.31-4.688l50.15-50.15C148.8 491.2 199.9 512 256 512s107.2-20.76 146.5-54.84l50.15 50.15C455.8 510.4 459.9 512 464 512s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-50.15-50.15c34.07-39.3 54.84-90.45 54.84-146.5C479.1 164.3 379.7 64 256 64zM256 480c-105.9 0-192-86.13-192-192s86.13-192 192-192s192 86.13 192 192S361.9 480 256 480zM415.1 0c-20.95 0-40.87 6.641-57.61 19.2c-7.062 5.312-8.484 15.34-3.188 22.41c5.297 7.078 15.36 8.516 22.41 3.188C388.8 36.42 402 32 416 32c35.3 0 64 28.7 64 64c0 13.97-4.422 27.25-12.8 38.39c-5.297 7.062-3.875 17.09 3.188 22.41C473.3 158.1 476.6 160 479.1 160c4.859 0 9.672-2.203 12.81-6.391C505.4 136.9 511.1 116.1 511.1 96C511.1 43.06 468.9 0 415.1 0z"],
    "alarm-exclamation": [512, 512, [], "f843", "M256 360c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C280 370.7 269.3 360 256 360zM256 336c8.844 0 16-7.156 16-16V176c0-8.844-7.167-16-16.01-16S240 167.2 240 176V320C240 328.8 247.2 336 256 336zM41.61 156.8C48.67 151.5 50.09 141.5 44.8 134.4C36.42 123.3 32 109.1 32 96c0-35.3 28.7-64 64-64c13.97 0 27.25 4.422 38.39 12.8c7.031 5.297 17.11 3.891 22.41-3.188C162.1 34.55 160.7 24.52 153.6 19.2C136.9 6.641 116.9 0 95.1 0c-52.94 0-96 43.06-96 95.99c0 20.95 6.644 40.88 19.21 57.62C22.34 157.8 27.16 160 32.02 160C35.36 160 38.73 158.1 41.61 156.8zM255.1 63.1C132.3 63.1 32 164.3 32 287.1c0 56.09 20.76 107.3 54.84 146.6l-50.15 50.15c-6.25 6.25-6.25 16.38 0 22.62C39.81 510.4 43.91 512 48 512s8.188-1.562 11.31-4.688l50.15-50.15C148.8 491.2 199.9 512 256 512s107.2-20.76 146.5-54.84l50.15 50.15C455.8 510.4 459.9 512 464 512s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-50.15-50.15c34.07-39.3 54.84-90.46 54.84-146.6C480 164.3 379.7 63.1 255.1 63.1zM256 480c-105.9 0-192-86.13-192-192s86.13-192 192-192s192 86.13 192 192S361.9 480 256 480zM415.1 0c-20.95 0-40.87 6.641-57.61 19.2c-7.062 5.312-8.484 15.34-3.188 22.41c5.297 7.078 15.36 8.516 22.41 3.188C388.8 36.42 402 32 416 32c35.3 0 64 28.7 64 64c0 13.97-4.422 27.25-12.8 38.39c-5.297 7.062-3.875 17.09 3.188 22.41C473.3 158.1 476.6 160 479.1 160c4.859 0 9.672-2.203 12.81-6.391c12.56-16.73 19.2-36.66 19.2-57.62C511.1 43.06 468.9 0 415.1 0z"],
    "alarm-plus": [512, 512, [], "f844", "M352 272h-80V192c0-8.844-7.155-16-15.1-16S240 183.2 240 192v80H160C151.2 272 144 279.2 144 288S151.2 304 160 304h80V384c0 8.844 7.158 16 16 16S272 392.8 272 384V304H352c8.844 0 16-7.156 16-16S360.8 272 352 272zM41.61 156.8C48.67 151.5 50.09 141.5 44.8 134.4C36.42 123.3 32 109.1 32 96c0-35.3 28.7-64 64-64c13.97 0 27.25 4.422 38.39 12.8c7.031 5.297 17.11 3.891 22.41-3.188C162.1 34.55 160.7 24.52 153.6 19.2C136.9 6.641 116.9 0 95.1 0c-52.94 0-96 43.06-96 95.99c0 20.95 6.644 40.88 19.21 57.62C22.34 157.8 27.16 160 32.02 160C35.36 160 38.73 158.1 41.61 156.8zM415.1 0c-20.95 0-40.87 6.641-57.61 19.2c-7.062 5.312-8.484 15.34-3.188 22.41c5.297 7.078 15.36 8.516 22.41 3.188C388.8 36.42 402 32 416 32c35.3 0 64 28.7 64 64c0 13.97-4.422 27.25-12.8 38.39c-5.297 7.062-3.875 17.09 3.188 22.41C473.3 158.1 476.6 160 479.1 160c4.859 0 9.672-2.203 12.81-6.391c12.56-16.73 19.2-36.66 19.2-57.62C511.1 43.06 468.9 0 415.1 0zM255.1 63.1C132.3 63.1 32 164.3 32 287.1c0 56.09 20.76 107.3 54.84 146.6l-50.15 50.15c-6.25 6.25-6.25 16.38 0 22.62C39.81 510.4 43.91 512 48 512s8.188-1.562 11.31-4.688l50.15-50.15C148.8 491.2 199.9 512 256 512s107.2-20.76 146.5-54.84l50.15 50.15C455.8 510.4 459.9 512 464 512s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-50.15-50.15c34.07-39.3 54.84-90.46 54.84-146.6C479.1 164.3 379.7 63.1 255.1 63.1zM256 480c-105.9 0-192-86.13-192-192s86.13-192 192-192s192 86.13 192 192S361.9 480 256 480z"],
    "alarm-snooze": [512, 512, [], "f845", "M336 208C336 195.5 324.6 192 320 192H192C183.2 192 176 199.2 176 208S183.2 224 192 224h94.72L179.5 358c-2.311 2.893-3.504 6.424-3.504 9.984C175.1 380.5 187.4 384 192 384h128c8.844 0 16-7.156 16-16S328.8 352 320 352H225.3l107.2-134C334.8 215.1 336 211.6 336 208zM41.61 156.8C48.67 151.5 50.09 141.5 44.8 134.4C36.42 123.3 32 109.1 32 96c0-35.3 28.7-64 64-64c13.97 0 27.25 4.422 38.39 12.8c7.031 5.297 17.11 3.891 22.41-3.188C162.1 34.55 160.7 24.52 153.6 19.2C136.9 6.641 116.9 0 95.1 0c-52.94 0-96 43.06-96 95.99c0 20.95 6.644 40.88 19.21 57.62C22.34 157.8 27.16 160 32.02 160C35.36 160 38.73 158.1 41.61 156.8zM256 63.1c-123.7 0-224 100.3-224 223.1c0 56.09 20.76 107.3 54.84 146.6l-50.15 50.15c-6.25 6.25-6.25 16.38 0 22.62C39.81 510.4 43.91 512 48 512s8.188-1.562 11.31-4.688l50.15-50.15C148.8 491.2 199.9 512 256 512s107.2-20.76 146.5-54.84l50.15 50.15C455.8 510.4 459.9 512 464 512s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-50.15-50.15C459.2 395.2 480 344.1 480 287.1C480 164.3 379.7 63.1 256 63.1zM256 480c-105.9 0-192-86.13-192-192s86.13-192 192-192s192 86.13 192 192S361.9 480 256 480zM415.1 0c-20.95 0-40.87 6.641-57.61 19.2c-7.062 5.312-8.484 15.34-3.188 22.41c5.297 7.078 15.36 8.516 22.41 3.188C388.8 36.42 402 32 416 32c35.3 0 64 28.7 64 64c0 13.97-4.422 27.25-12.8 38.39c-5.297 7.062-3.875 17.09 3.188 22.41C473.3 158.1 476.6 160 479.1 160c4.859 0 9.672-2.203 12.81-6.391c12.56-16.73 19.2-36.66 19.2-57.62C511.1 43.06 468.9 0 415.1 0z"],
    "album": [448, 512, [63647], "1f4bd", "M224 232C210.8 232 200 242.8 200 256S210.8 280 224 280S248 269.3 248 256S237.3 232 224 232zM384 32H64c-35.2 0-64 28.8-64 64v320c0 35.2 28.8 64 64 64h320c35.2 0 64-28.8 64-64v-320C448 60.8 419.2 32 384 32zM416 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V416zM224 96c-88.25 0-160 71.75-160 160s71.75 160 160 160s160-71.75 160-160S312.3 96 224 96zM224 384c-70.58 0-128-57.42-128-128c0-70.58 57.42-128 128-128s128 57.42 128 128C352 326.6 294.6 384 224 384z"],
    "album-collection": [512, 512, [], "f8a0", "M499.3 142.8C490.5 133.3 478.7 128 466 128H45.1C33.34 128 21.53 133.3 12.78 142.8c-9.188 10.03-13.78 23.7-12.59 37.5l24.5 287.9C26.81 493.2 46.5 512 70.5 512h371c23.72 0 43.78-19.27 45.69-43.75l24.63-287.9C513 166.5 508.4 152.8 499.3 142.8zM455.3 465.7C454.7 473.7 448.6 480 441.5 480H70.5c-7.125 0-13.25-6.359-13.94-14.47L32.06 177.6C31.65 172.7 33.22 167.9 36.37 164.5C37.87 162.8 41.15 160 45.1 160h420c3.625 0 7.031 1.562 9.656 4.422c3.156 3.422 4.719 8.219 4.281 13.17L455.3 465.7zM256 299.1c-14.5 0-26.25 10.12-26.13 22.62S241.8 344 256 344c14.25 0 26-9.875 26.13-22.25C282.3 309.5 270.5 299.1 256 299.1zM256 192c-92.88 0-164.4 61.88-159.8 134.4C100.5 395 172 448 256 448s155.5-53 159.8-121.6C420.4 253.9 348.9 192 256 192zM256 416c-67.35 0-124.7-41.09-127.8-91.66C126.5 297.4 139.8 277.1 151.4 264.9C175.7 238.9 213.9 224 256 224c42.14 0 80.28 14.9 104.7 40.87c11.51 12.27 24.88 32.55 23.16 59.53C380.7 374.9 323.4 416 256 416zM47.1 32h416c8.844 0 16-7.157 16-16S472.8 0 464 0H47.1C39.15 0 31.1 7.156 31.1 16S39.15 32 47.1 32zM31.1 96H480c8.844 0 16-7.156 16-16S488.8 64 480 64H31.1c-8.844 0-16 7.156-16 16S23.15 96 31.1 96z"],
    "alicorn": [640, 512, [], "f6b0", "M632 64h-97c5.721-10.11 8.626-22.03 8.212-34.2C542.7 13.03 528 0 511.3 0l-111.3 .0003c-69.13 0-125.4 55.25-127.6 123.9C236.8 114.8 209.3 89.25 190.9 47.25c-4-9.125-13-15.12-23-15.25c-10.5 .25-18.88 5.375-23.13 14.38C133.6 70 128 95.13 128 121.1c0 75.38 56.5 143.6 132.9 161.9c4.377 1 8.877-2 9.752-6.5l2.875-15.62c.875-4.25-1.875-8.125-6-9.25c-61.75-15.12-107.5-70-107.5-130.5c0-16.38 2.75-32.25 8-47.38c29.38 56.5 76.13 86.25 136 86.25v-32c0-53.02 42.98-96 96-96h111.3c0 13.25-8.125 24.62-19.63 29.5l20.38 24.75v93.88c0 6.875-4.375 13-10.88 15.12l-25.5 8.75c-9.25 3.25-16.12-2.75-18.5-6.25l-25.13-37.75l-48-16v100.3c0 26.62-12.63 50.12-32 65.5v154.3c0 8.837-7.163 16-16 16h-32c-8.837 0-16-7.163-16-16V318.8L183.6 295.5l-32.13 89.5l18.97 75.08c2.554 10.11-5.087 19.92-15.51 19.92H130.6c-7.396 0-13.83-5.069-15.56-12.26l-18.18-75.61c-1.29-5.366-1.146-10.98 .4179-16.27l27.58-93.35c-17.38-12.12-28.88-32.25-28.88-55.12c0-15.88 5.625-30.12 14.88-41.63c-5-10.88-9-22.12-11.5-33.75c-8 6.875-15.13 15-20.75 24.12C35.13 176.9 0 212.3 0 256v47.1c0 8.801 7.2 16 16 16S32 312.8 32 304v-48c0-21.5 14.25-39.5 33.75-45.62c-1 5.625-1.75 11.12-1.75 17c0 24.25 8.875 47.37 24.5 65.25l-21.93 74.42c-3.123 10.6-3.408 21.83-.8246 32.58l18.17 75.59c5.186 21.57 24.48 36.78 46.67 36.78h24.35c31.28 0 54.21-29.44 46.53-59.77l-16.59-65.6l19.25-53.75l51.88 11.5v119.6c0 26.4 21.6 48 47.1 48l32.01-.0002c26.4 0 48.03-21.6 48.03-48l-.0277-140.2c20.5-21.5 32-49.75 32-79.5v-50.5l14.5 21.75c19.13 28.62 50 20.62 55.5 18.75l25.5-8.625c19.43-6.57 32.5-24.79 32.5-45.3V115.4l92.38-36.75C643 74.25 639.9 64 632 64zM464 96c0-8.875-7.125-16-16-16s-16 7.125-16 16s7.127 16 16 16S464 104.9 464 96z"],
    "alien": [448, 512, [63733], "1f47d", "M224 .0001c-123.8 0-224 87.99-224 232.5c0 111.7 134.2 224.5 194.9 269.9c17.25 12.87 41 12.87 58.25 0C313.8 456.1 448 344.2 448 232.5C448 87.99 347.8 .0001 224 .0001zM233.1 476.6c-5.874 4.5-14.12 4.5-20 0C171.2 444.7 32 332.1 32 232.5C32 114.4 111 31.1 224 31.1s192 82.37 192 200.5C416 332.1 276.8 444.7 233.1 476.6zM368 211.1H320c-44.13 0-80 35.87-80 79.1v11.1c0 8.874 7.125 15.1 16 15.1h48c44.13 0 80-35.87 80-79.1V227.1C384 219.1 376.9 211.1 368 211.1zM304 287.1h-31.88C274.2 263.1 295 243.1 320 243.1h31.88C349.8 268.9 329 287.1 304 287.1zM128 211.1H80c-8.875 0-16 7.125-16 15.1v11.1c0 44.12 35.88 79.1 80 79.1H192c8.875 0 16-7.125 16-15.1V291.1C208 247.9 172.1 211.1 128 211.1zM144 287.1c-25 0-45.75-19.12-47.88-43.1H128c25 0 45.75 19.12 47.88 43.1H144z"],
    "alien-8bit": [576, 512, [63734, "alien-monster"], "1f47e", "M192 320h32V224H192V320zM352 320h32V224h-32V320zM544 112h-32c-17.62 0-32 14.38-32 32V160l-64 .0002V128h32c17.62 0 32-14.38 32-32V64c0-17.62-14.38-31.1-32-31.1L416 32c-17.62 0-32 14.38-32 32L352 64c-17.62 0-32 14.38-32 32v32H256V96c0-17.62-14.38-32-32-32L192 64C192 46.38 177.6 32 160 32L128 32C110.4 32 96 46.38 96 64v32c0 17.62 14.38 32 32 32h32v32L96 160V144c0-17.62-14.38-32-32-32H32c-17.62 0-32 14.38-32 32V288c0 17.62 14.38 32 32 32h32v32c0 17.62 14.38 32 32 32l32 .0002V448c0 17.62 14.38 32 32 32l80 .0002c17.62 0 32-14.38 32-32v-32c0-17.62-14.38-32-32-32h96c-17.62 0-32 14.38-32 32v32c0 17.62 14.38 32 32 32L416 480c17.62 0 32-14.38 32-32v-63.1L480 384c17.62 0 32-14.38 32-32v-32h32c17.62 0 32-14.38 32-32V144C576 126.4 561.6 112 544 112zM416 64h32v32l-32-.0002V64zM128 96V64h32v32L128 96zM240 448H160v-64l32 .0002v32h48V448zM416 448h-80v-31.1H384v-32L416 384V448zM544 288h-64v64H96V288H32V144l32 .0002V256h32V192h96V96h32v64h128V96h32v96h96v64h32V144L544 144V288z"],
    "align-center": [448, 512, [], "f037", "M16 208h416c8.801 0 16-7.199 16-15.1S440.8 176 432 176h-416C7.199 176 0 183.2 0 192S7.199 208 16 208zM112 80h224c8.801 0 16-7.199 16-15.1S344.8 48 336 48h-224C103.2 48 96 55.2 96 64S103.2 80 112 80zM432 432h-416c-8.801 0-16 7.199-16 16S7.199 464 16 464h416c8.801 0 16-7.199 16-15.1S440.8 432 432 432zM112 304C103.2 304 96 311.2 96 320S103.2 336 112 336h224c8.801 0 16-7.199 16-15.1S344.8 304 336 304H112z"],
    "align-justify": [448, 512, [], "f039", "M432 432h-416c-8.801 0-16 7.199-16 16S7.199 464 16 464h416c8.801 0 16-7.199 16-15.1S440.8 432 432 432zM16 80h416c8.801 0 16-7.199 16-15.1S440.8 48 432 48h-416C7.199 48 0 55.2 0 64S7.199 80 16 80zM432 176h-416C7.199 176 0 183.2 0 192S7.199 208 16 208h416c8.801 0 16-7.199 16-15.1S440.8 176 432 176zM432 304h-416C7.199 304 0 311.2 0 320S7.199 336 16 336h416c8.801 0 16-7.199 16-15.1S440.8 304 432 304z"],
    "align-left": [448, 512, [], "f036", "M16 208h416c8.801 0 16-7.199 16-15.1S440.8 176 432 176h-416C7.199 176 0 183.2 0 192S7.199 208 16 208zM16 80h256c8.801 0 16-7.199 16-15.1S280.8 48 272 48h-256C7.199 48 0 55.2 0 64S7.199 80 16 80zM16 336h256c8.801 0 16-7.199 16-15.1S280.8 304 272 304h-256C7.199 304 0 311.2 0 320S7.199 336 16 336zM432 432h-416c-8.801 0-16 7.199-16 16S7.199 464 16 464h416c8.801 0 16-7.199 16-15.1S440.8 432 432 432z"],
    "align-right": [448, 512, [], "f038", "M176 80h256c8.801 0 16-7.199 16-15.1S440.8 48 432 48h-256C167.2 48 160 55.2 160 64S167.2 80 176 80zM432 432h-416c-8.799 0-16 7.199-16 16S7.201 464 16 464h416c8.801 0 16-7.199 16-15.1S440.8 432 432 432zM432 176h-416C7.201 176 0 183.2 0 192S7.201 208 16 208h416c8.801 0 16-7.199 16-15.1S440.8 176 432 176zM432 304h-256C167.2 304 160 311.2 160 320S167.2 336 176 336h256c8.801 0 16-7.199 16-15.1S440.8 304 432 304z"],
    "align-slash": [640, 512, [], "f846", "M528 304h-43.91l40.53 32h3.381c8.838 0 15.1-7.164 15.1-15.1C544 311.2 536.8 304 528 304zM528 80c8.801 0 15.1-7.201 15.1-15.1C544 55.2 536.8 48 528 48H159.8l40.53 32H528zM528 176h-206l40.53 32h165.5c8.801 0 15.1-7.201 15.1-15.1C544 183.2 536.8 176 528 176zM111.1 336h206l-40.53-32H111.1c-8.801 0-15.1 7.201-15.1 16C95.1 328.8 103.2 336 111.1 336zM111.1 432c-8.801 0-15.1 7.2-15.1 16C95.1 456.8 103.2 464 111.1 464h368.2l-40.53-32H111.1zM633.9 483.4L25.92 3.42C18.98-2.033 8.921-.8301 3.437 6.061c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4zM111.1 208h43.91l-40.53-32H111.1c-8.801 0-15.1 7.2-15.1 16C95.1 200.8 103.2 208 111.1 208z"],
    "alt": [640, 512, [], "e08a", "M416 432c0 8.838 7.164 16 16 16h192c8.836 0 16-7.162 16-16c0-8.836-7.164-16-16-16h-192C423.2 416 416 423.2 416 432zM640 80C640 71.16 632.8 64 624 64h-129.7c-24.09 0-46.69 10.69-61.94 29.34l-249.6 305.1C173.7 409.6 160.1 416 145.7 416H16C7.156 416 0 423.2 0 432S7.156 448 16 448h129.7c24.09 0 46.69-10.69 61.94-29.34l249.6-305.1C466.3 102.4 479.9 96 494.3 96H624C632.8 96 640 88.84 640 80z"],
    "amp-guitar": [512, 512, [], "f8a1", "M416 352c8.875 0 16-7.125 16-16S424.9 320 416 320s-16 7.125-16 16S407.1 352 416 352zM352 352c8.875 0 16-7.125 16-16S360.9 320 352 320s-16 7.125-16 16S343.1 352 352 352zM384 400c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S375.1 400 384 400zM288 352c8.875 0 16-7.125 16-16S296.9 320 288 320s-16 7.125-16 16S279.1 352 288 352zM320 400c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S311.1 400 320 400zM160 416c-8.875 0-16 7.125-16 16S151.1 448 160 448s16-7.125 16-16S168.9 416 160 416zM416 416c-8.875 0-16 7.125-16 16S407.1 448 416 448s16-7.125 16-16S424.9 416 416 416zM224 416c-8.875 0-16 7.125-16 16S215.1 448 224 448s16-7.125 16-16S232.9 416 224 416zM256 400c8.875 0 16-7.125 16-16s-7.125-16-16-16S240 375.1 240 384S247.1 400 256 400zM288 416c-8.875 0-16 7.125-16 16S279.1 448 288 448s16-7.125 16-16S296.9 416 288 416zM352 416c-8.875 0-16 7.125-16 16S343.1 448 352 448s16-7.125 16-16S360.9 416 352 416zM224 352c8.875 0 16-7.125 16-16S232.9 320 224 320s-16 7.125-16 16S215.1 352 224 352zM464 64h-77.25C357.9 36.13 310.3 0 256 0S154.1 36.13 125.3 64H48C21.5 64 0 85.5 0 112v352C0 490.5 21.5 512 48 512h416c26.5 0 48-21.5 48-48v-352C512 85.5 490.5 64 464 64zM256 32c30.12 0 58.63 14.88 81.63 32H174.4C197.4 46.88 225.9 32 256 32zM480 464c0 8.875-7.125 16-16 16h-416C39.13 480 32 472.9 32 464V288h448V464zM480 256H32V112C32 103.1 39.13 96 48 96h416C472.9 96 480 103.1 480 112V256zM96 352c8.875 0 16-7.125 16-16S104.9 320 96 320s-16 7.125-16 16S87.13 352 96 352zM96 448c8.875 0 16-7.125 16-16S104.9 416 96 416s-16 7.125-16 16S87.13 448 96 448zM160 352c8.875 0 16-7.125 16-16S168.9 320 160 320s-16 7.125-16 16S151.1 352 160 352zM192 400c8.875 0 16-7.125 16-16S200.9 368 192 368S176 375.1 176 384S183.1 400 192 400zM128 400c8.875 0 16-7.125 16-16S136.9 368 128 368S112 375.1 112 384S119.1 400 128 400zM96 152c-13.25 0-24 10.75-24 24S82.75 200 96 200c13.26 0 24-10.75 24-24S109.3 152 96 152zM192 152c-13.25 0-24 10.75-24 24S178.7 200 192 200c13.26 0 24-10.75 24-24S205.3 152 192 152zM320 152c-13.25 0-24 10.75-24 24S306.7 200 320 200c13.26 0 24-10.75 24-24S333.3 152 320 152zM416 152c-13.25 0-24 10.75-24 24S402.7 200 416 200c13.26 0 24-10.75 24-24S429.3 152 416 152z"],
    "ampersand": [384, 512, [], "26", "M379.5 452.9l-71.4-74.19l72.99-104.5c5.062-7.234 3.281-17.22-3.969-22.28c-7.156-5.016-17.19-3.312-22.28 3.969l-69.36 99.32L170.4 235.6l69.87-55.36c20.16-15.88 31.72-39.55 31.72-64.94C271.1 69.38 233.9 32 187.1 32H132.9C86.09 32 47.1 69.38 47.1 115.3c0 24.81 9.437 48.55 26.69 67l48.22 50.09L38.72 299.1C14.12 318.5 0 347.4 0 378.3C0 434.4 46.48 480 103.7 480h66.61c41.1 0 81.25-20.27 104.1-54.23l14.17-20.3l67.01 69.63C359.6 478.4 363.8 480 367.1 480c3.1 0 7.1-1.484 11.09-4.469C385.5 469.4 385.6 459.3 379.5 452.9zM97.9 160.3c-11.56-12.33-17.91-28.31-17.91-44.97C79.1 87.02 103.7 64 132.9 64h54.12c29.19 0 52.94 23.02 52.94 51.31c0 15.52-7.125 30.03-19.56 39.83L148.1 212.5L97.9 160.3zM249 407.5C231.3 432.8 201.9 448 170.3 448H103.7c-39.56 0-71.75-31.25-71.75-69.67c0-21.08 9.656-40.8 26.56-54.11l86.62-68.64l121.6 126.4L249 407.5z"],
    "anchor": [576, 512, [61757], "2693", "M571.3 324.7l-63.1-64c-6.25-6.25-16.37-6.25-22.62 0l-63.1 64c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L480 310.6V336c0 79.41-64.59 144-144 144h-32V224h64C376.8 224 384 216.8 384 208S376.8 192 368 192h-64V158.4c36.47-7.434 64-39.75 64-78.38c0-44.11-35.89-80-79.1-80S208 35.89 208 80c0 38.63 27.53 70.95 64 78.38V192h-64C199.2 192 192 199.2 192 208S199.2 224 208 224h64v256h-32C160.6 480 96 415.4 96 336V310.6l36.69 36.69C135.8 350.4 139.9 352 144 352s8.184-1.562 11.31-4.688c6.25-6.25 6.254-16.38 .0037-22.62l-63.1-64c-6.25-6.25-16.37-6.25-22.62 0l-63.1 64c-6.25 6.25-6.256 16.38-.0059 22.62s16.38 6.25 22.62 0L64 310.6V336C64 433 142.1 512 240 512h95.1C433 512 512 433 512 336V310.6l36.69 36.69C551.8 350.4 555.9 352 559.1 352s8.189-1.562 11.31-4.688C577.6 341.1 577.6 330.9 571.3 324.7zM240 80C240 53.53 261.5 32 288 32s48 21.53 48 48S314.5 128 288 128S240 106.5 240 80z"],
    "angel": [640, 512, [], "f779", "M240 144c0 44.25 35.75 80 79.1 80s79.1-35.75 79.1-80S364.3 64 320 64S240 99.75 240 144zM367.1 144c0 26.5-21.5 48-48 48s-48-21.5-48-48s21.5-48 48-48S367.1 117.5 367.1 144zM604.5 464.6l-38.25-78.62c-7.502-15.75-7.502-34.38 0-50.13c16.75-34.13 25.63-36.5 25.63-71.75c0-46.88-43.13-88-92.38-88c-23 0-44.5 9.125-60.76 25.62l-67.51 68.13C355.1 261 338.4 256.1 320 256.1S284.1 261 268.7 269.8l-67.51-68C185.1 185.3 163.5 176 140.5 176c-49.26 0-92.38 41.13-92.38 88c0 35.38 9.002 37.88 25.63 71.75c7.502 15.75 7.502 34.5 0 50.13l-38.13 78.75C23.83 488.5 42.96 512 64.58 512H575.4C597.6 512 615.9 487.9 604.5 464.6zM64.58 480l37.88-80.13c11.88-24.5 11.88-53.63 0-78.13C84.59 285 80.21 289.9 80.21 264c0-29.25 28.75-56 60.38-56c14.13 0 27.63 5.75 37.75 16.25l65.13 65.63C237.2 296.8 231.8 304.7 227.4 313.2L144.1 480H64.58zM179.8 480l76.13-152.4C268.2 303.3 292.7 288 319.1 288c27.25 0 51.75 15.25 64.01 39.63L460.3 480H179.8zM495.9 479.9L412.6 313.2c-4.377-8.625-9.872-16.5-16.12-23.5l65.13-65.63c10.13-10.38 23.63-16.25 37.75-16.25c31.63 0 60.38 26.75 60.38 56c0 26-4.5 21-22.38 57.88c-11.88 24.5-11.88 53.5 0 78l37.88 80.13H495.9zM217.6 123.3c6.234-6.266 6.331-16.41 .0652-22.64C211.3 94.38 208 88.05 208 81.81C208 58.3 255.9 32 320 32s112 26.3 112 49.81c0 6.234-3.203 12.56-9.5 18.83c-6.266 6.234-6.297 16.38-.063 22.64C425.6 126.4 429.7 128 433.8 128c4.078 0 8.156-1.547 11.28-4.656C457.5 111 464 96.66 464 81.81C464 35.94 400.8 0 320 0S176 35.94 176 81.81c0 14.84 6.547 29.2 18.94 41.53C201.2 129.6 211.4 129.6 217.6 123.3z"],
    "angle": [448, 512, [], "e08c", "M324.5 402.4c1.219 7.908 8.031 13.56 15.8 13.56c.8125 0 1.625-.0625 2.453-.1875c8.734-1.344 14.72-9.531 13.37-18.25c-3.844-24.94-10.61-49.44-20.11-72.88c-3.328-8.188-12.7-12.25-20.84-8.812c-8.188 3.312-12.12 12.62-8.812 20.81C314.1 357.8 321 379.1 324.5 402.4zM432 447.1H41.89l196.4-392.9c3.953-7.906 .75-17.52-7.156-21.47c-7.922-3.906-17.5-.75-21.47 7.156l-207.1 416c-2.484 4.969-2.219 10.85 .7031 15.56S10.46 480 16 480H432c8.844 0 16-7.156 16-16C448 455.2 440.8 447.1 432 447.1zM208.8 190.3C203.4 197.3 204.7 207.4 211.7 212.8c20.94 16.03 39.64 34.75 55.59 55.64c3.156 4.109 7.922 6.281 12.73 6.281c3.391 0 6.797-1.078 9.703-3.281c7.016-5.375 8.359-15.41 3-22.44c-17.69-23.14-38.39-43.86-61.56-61.61C224.2 182 214.1 183.3 208.8 190.3z"],
    "angle-90": [448, 512, [], "e08d", "M267.3 268.4c3.156 4.109 7.922 6.281 12.73 6.281c3.391 0 6.797-1.078 9.703-3.281c7.016-5.375 8.359-15.41 3-22.44c-17.69-23.14-38.39-43.86-61.56-61.61c-7-5.359-17.05-4.016-22.44 2.969C203.4 197.4 204.7 207.4 211.7 212.8C232.7 228.8 251.4 247.5 267.3 268.4zM324.5 402.4C325.7 410.3 332.5 416 340.3 416c.8125 0 1.625-.0625 2.453-.1875c8.734-1.344 14.72-9.531 13.38-18.25c-3.844-24.94-10.61-49.44-20.11-72.88c-3.328-8.188-12.7-12.25-20.84-8.812c-8.188 3.312-12.12 12.62-8.812 20.81C314.1 357.8 321 379.1 324.5 402.4zM432 448H32V48C32 39.16 24.84 32 16 32S0 39.16 0 48v416C0 472.8 7.156 480 16 480h416c8.844 0 16-7.156 16-16S440.8 448 432 448zM77.56 155.5c22.48 3.469 44.59 9.562 65.72 18.14c1.969 .7969 4 1.172 6.016 1.172c6.312 0 12.3-3.766 14.83-9.984C167.4 156.6 163.5 147.3 155.3 143.1c-23.42-9.5-47.94-16.27-72.88-20.11C73.7 122.6 65.55 128.5 64.19 137.2C62.84 145.1 68.83 154.1 77.56 155.5z"],
    "angle-down": [384, 512, [61703], "2304", "M362.7 203.9l-159.1 144c-6.125 5.469-15.31 5.469-21.44 0L21.29 203.9C14.73 197.1 14.2 187.9 20.1 181.3C26.38 174.4 36.5 174.5 42.73 180.1L192 314.5l149.3-134.4c6.594-5.877 16.69-5.361 22.62 1.188C369.8 187.9 369.3 197.1 362.7 203.9z"],
    "angle-left": [256, 512, [61700], "2039", "M203.9 405.3c5.877 6.594 5.361 16.69-1.188 22.62c-6.562 5.906-16.69 5.375-22.59-1.188L36.1 266.7c-5.469-6.125-5.469-15.31 0-21.44l144-159.1c5.906-6.562 16.03-7.094 22.59-1.188c6.918 6.271 6.783 16.39 1.188 22.62L69.53 256L203.9 405.3z"],
    "angle-right": [256, 512, [61701], "203a", "M219.9 266.7L75.89 426.7c-5.906 6.562-16.03 7.094-22.59 1.188c-6.918-6.271-6.783-16.39-1.188-22.62L186.5 256L52.11 106.7C46.23 100.1 46.75 90.04 53.29 84.1C59.86 78.2 69.98 78.73 75.89 85.29l144 159.1C225.4 251.4 225.4 260.6 219.9 266.7z"],
    "angle-up": [384, 512, [61702], "2303", "M363.9 330.7c-6.271 6.918-16.39 6.783-22.62 1.188L192 197.5l-149.3 134.4c-6.594 5.877-16.69 5.361-22.62-1.188C14.2 324.1 14.73 314 21.29 308.1l159.1-144c6.125-5.469 15.31-5.469 21.44 0l159.1 144C369.3 314 369.8 324.1 363.9 330.7z"],
    "angles-down": [384, 512, ["angle-double-down"], "f103", "M181.3 251.9c6.125 5.469 15.31 5.469 21.44 0l159.1-144c6.562-5.906 7.094-16.03 1.188-22.59c-5.938-6.549-16.03-7.064-22.62-1.188L192 218.5L42.73 84.11C36.5 78.51 26.38 78.38 20.1 85.29C14.2 91.86 14.73 101.1 21.29 107.9L181.3 251.9zM341.3 276.1L192 410.5L42.73 276.1C36.5 270.5 26.38 270.4 20.1 277.3C14.2 283.9 14.73 293.1 21.29 299.9l159.1 144c6.125 5.469 15.31 5.469 21.44 0l159.1-144c6.562-5.906 7.094-16.03 1.188-22.59C357.1 270.7 347.9 270.2 341.3 276.1z"],
    "angles-left": [448, 512, [61696, "angle-double-left"], "ab", "M202.7 84.1C196.1 78.2 186 78.73 180.1 85.29L36.1 245.3c-5.469 6.125-5.469 15.31 0 21.44l144 159.1c5.906 6.562 16.03 7.094 22.59 1.188c6.549-5.938 7.064-16.03 1.188-22.62L69.53 256l134.4-149.3C209.5 100.5 209.6 90.38 202.7 84.1zM261.5 256l134.4-149.3c5.596-6.23 5.73-16.35-1.188-22.62c-6.562-5.906-16.69-5.375-22.59 1.188l-144 159.1c-5.469 6.125-5.469 15.31 0 21.44l144 159.1c5.906 6.562 16.03 7.094 22.59 1.188c6.549-5.938 7.064-16.03 1.188-22.62L261.5 256z"],
    "angles-right": [448, 512, [61697, "angle-double-right"], "bb", "M75.89 85.29C69.98 78.73 59.86 78.2 53.29 84.1C46.75 90.04 46.23 100.1 52.11 106.7L186.5 256l-134.4 149.3c-5.596 6.23-5.73 16.35 1.188 22.62c6.562 5.906 16.69 5.375 22.59-1.188l144-159.1c5.469-6.125 5.469-15.31 0-21.44L75.89 85.29zM411.9 245.3L267.9 85.29c-5.906-6.562-16.03-7.094-22.59-1.188c-6.549 5.938-7.064 16.03-1.188 22.62L378.5 256l-134.4 149.3c-5.596 6.23-5.73 16.35 1.188 22.62c6.562 5.906 16.69 5.375 22.59-1.188l144-159.1C417.4 260.6 417.4 251.4 411.9 245.3z"],
    "angles-up": [384, 512, ["angle-double-up"], "f102", "M42.73 235.9L192 101.5l149.3 134.4c6.23 5.596 16.35 5.73 22.62-1.188c5.906-6.562 5.375-16.69-1.188-22.59l-159.1-144c-6.125-5.469-15.31-5.469-21.44 0L21.29 212.1C14.73 218 14.2 228.1 20.1 234.7C26.04 241.3 36.13 241.8 42.73 235.9zM202.7 260.1c-6.125-5.469-15.31-5.469-21.44 0L21.29 404.1c-6.562 5.906-7.094 16.03-1.188 22.59c5.938 6.549 16.03 7.064 22.62 1.188L192 293.5l149.3 134.4c6.23 5.596 16.35 5.73 22.62-1.188c5.906-6.562 5.375-16.69-1.188-22.59L202.7 260.1z"],
    "ankh": [320, 512, [63044], "2625", "M304 288h-88.63C252.3 252 288 191.6 288 137.1C288 53 230.8 0 160 0S32 53 32 137.1C32 191.6 67.75 252 104.6 288H16C7.199 288 0 295.2 0 304S7.199 320 16 320h128v176c0 8.801 7.199 16 16 16s16-7.199 16-16V320h128c8.801 0 16-7.199 16-16S312.8 288 304 288zM160.3 288C139.4 286.1 64 208.9 64 137.1C64 75.25 103.5 32 160 32s96 43.25 96 105.1C256 208.9 180.8 286.1 160.3 288z"],
    "aperture": [512, 512, [], "e2df", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM458.1 160H237.5l70.27-121.7C374.3 54.12 429.3 99.59 458.1 160zM292.9 320H219.1L182.1 256L219.1 192h73.89l36.95 64L292.9 320zM256 32c6.059 0 12.01 .4336 17.95 .9082L163.6 223.1L93.41 102.4C134.3 59.15 191.1 32 256 32zM71.76 128.9L182.1 320h-140.7C35.37 299.7 32 278.2 32 256C32 208.8 46.75 165 71.76 128.9zM53.92 352h220.5l-70.27 121.7C137.7 457.9 82.74 412.4 53.92 352zM256 480c-6.059 0-12.01-.4336-17.95-.9082l110.3-191.1l70.22 121.6C377.7 452.8 320 480 256 480zM440.2 383.1L329.9 192h140.7C476.6 212.3 480 233.8 480 256C480 303.2 465.3 346.1 440.2 383.1z"],
    "apostrophe": [192, 512, [], "27", "M112 32C67.82 32 32 67.82 32 112C32 156.2 67.82 192 112 192c18.1 0 34.6-6.232 48-16.36V208C160 252.1 124.1 288 80 288C71.16 288 64 295.2 64 304S71.16 320 80 320c61.75 0 112-50.25 112-112v-96C192 67.82 156.2 32 112 32zM112 160C85.53 160 64 138.5 64 112S85.53 64 112 64S160 85.53 160 112S138.5 160 112 160z"],
    "apple-core": [384, 512, [], "e08f", "M174.6 127.4c0 0 5.344 .6855 13.75 .6855c18.09 0 51.75-3.326 74-25.57c31.44-31.31 25.22-85.48 24.94-87.78c-.875-7.264-6.656-13.01-13.94-13.93c0 0-5.674-.791-14.45-.791c-18.6 0-51.15 3.547-73.3 25.68c-31.44 31.31-25.22 85.48-24.94 87.78C161.6 120.7 167.3 126.5 174.6 127.4zM208.2 48.31c13.16-13.15 35.66-15.76 47.75-16.15c-.5 14.83-3.1 35.56-16.19 47.71c-13.16 13.15-35.66 15.76-47.75 16.15C192.5 81.2 196 60.46 208.2 48.31zM287.1 304c0-62.43 32.67-117.2 81.69-148.4c-13.6-13.4-30.41-22.82-50.56-26.38c-34.91-5.984-96.57 13.61-127.1 30.83c-30.33-17.09-91.64-36.77-127.3-30.83c-20.08 3.559-36.85 12.98-50.42 26.38C63.34 186.8 95.1 241.6 95.1 304c0 61.17-31.16 114.1-78.52 146.5C43.08 486.3 79.22 512 128.4 512c27.58 0 35.23-17.87 63.63-17.87C220.5 494.1 227.1 512 255.6 512c49.16 0 85.3-25.66 110.9-61.5C319.2 418.1 287.1 365.2 287.1 304zM255.6 480c-16.01 0-27.36-17.87-63.63-17.87C155.7 462.1 144.3 480 128.4 480c-24.79 0-46.26-8.33-65.01-25.33C104.3 415.7 128 361.6 128 304c0-54.23-20.84-105.1-57.37-143.3C114.3 154.1 179.3 192.1 191.1 192.1c12.36 0 79.14-38.33 121.4-31.39C276.8 198.9 256 249.8 256 304c0 57.56 23.66 111.7 64.64 150.7C301.9 471.7 280.4 480 255.6 480z"],
    "apple-whole": [448, 512, [127823, 62929, "apple-alt"], "1f34e", "M206.6 127.4c0 0 5.344 .6855 13.75 .6855c18.09 0 51.75-3.326 74-25.57c31.44-31.31 25.22-85.48 24.94-87.78c-.875-7.264-6.656-13.01-13.94-13.93c0 0-55.16-7.688-87.75 24.88c-31.44 31.31-25.22 85.48-24.94 87.78C193.6 120.7 199.3 126.5 206.6 127.4zM240.2 48.31c13.16-13.15 35.66-15.76 47.75-16.15c-.5 14.83-4 35.56-16.19 47.71c-13.16 13.15-35.66 15.76-47.75 16.15C224.5 81.2 228 60.46 240.2 48.31zM351 129.1c-4.375-.75-9.161-1.036-14.41-1.036c-36.13 0-87.12 17.58-112.6 31.95c-25.5-14.37-76.51-31.95-112.6-31.95c-5.25 0-10.12 .375-14.62 1.125c-81.13 14.37-107.4 124.5-93 205.6C17.99 415.9 64.99 512 160.4 512c12.12 0 24.12-4.625 34.5-10.37c9.002-4.998 19.13-7.498 29.13-7.498c10.12 0 20.12 2.5 29.12 7.498C263.5 507.4 275.5 512 287.6 512c95.38 0 142.4-96.11 156.6-177.2C458.6 253.7 432.4 143.5 351 129.1zM412.7 329.3c-4.426 25.17-31.24 150.8-125.1 150.8c-16.01 0-27.36-17.87-63.63-17.87c-36.33 0-47.68 17.87-63.63 17.87c-93.87 0-120.7-125.6-125.1-150.8c-6.557-36.99-3.15-78.46 9.113-110.9C53.1 195.1 70.25 166.4 102 160.8c29.9-4.979 86.47 16.02 106.3 27.18c4.877 2.75 10.3 4.125 15.71 4.125s10.84-1.375 15.71-4.125c19.05-10.73 76.64-32.22 105.8-27.23c32.2 5.688 49.37 34.44 58.1 57.56C415.9 250.7 419.3 292.2 412.7 329.3z"],
    "archway": [576, 512, [], "f557", "M560 480H544V32h16C568.8 32 576 24.8 576 16S568.8 0 560 0h-544C7.199 0 0 7.199 0 16S7.199 32 16 32H32v448H16C7.199 480 0 487.2 0 496S7.199 512 16 512h160C184.8 512 192 504.8 192 496l0-172.8c0-52.84 41.32-98.2 94.16-99.19C340 223 384 266.4 384 320v176c0 8.836 7.164 16 16 16h160c8.801 0 16-7.199 16-16S568.8 480 560 480zM512 480h-96v-160c0-70.63-57.38-128-128-128s-128 57.38-128 128v160H64V128h448V480zM512 96H64V32h448V96z"],
    "arrow-down": [384, 512, [61539], "2193", "M378.8 299.8l-176 160C199.7 462.6 195.9 464 192 464s-7.719-1.375-10.77-4.156l-176-160C-1.297 293.9-1.781 283.8 4.156 277.3c5.953-6.594 16.09-7 22.61-1.094L176 411.8V48c0-8.844 7.156-15.1 15.1-15.1S208 39.16 208 48v363.8l149.2-135.7c6.516-5.906 16.66-5.5 22.61 1.094C385.8 283.8 385.3 293.9 378.8 299.8z"],
    "arrow-down-1-9": [512, 512, ["sort-numeric-asc", "sort-numeric-down"], "f162", "M336 224l96-.0039c8.844 0 16-7.152 16-15.1S440.8 192 432 192h-32V48C400 39.16 392.8 32 384 32h-32c-8.844 0-16 7.156-16 16S343.2 64 352 64h16v128h-32C327.2 192 320 199.2 320 208S327.2 224 336 224zM384 256c-44.13 0-80 35.88-80 80S339.9 416 384 416c16.73 0 32.25-5.199 45.11-14.01C421.3 428.5 396.1 448 368 448c-8.844 0-16 7.156-16 16s7.156 16 16 16c52.94 0 96-43.06 96-96v-48C464 291.9 428.1 256 384 256zM384 384c-26.47 0-48-21.53-48-48S357.5 288 384 288s48 21.53 48 48S410.5 384 384 384zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-9-1": [512, 512, ["sort-numeric-desc", "sort-numeric-down-alt"], "f886", "M432 448h-32V304C400 295.2 392.8 288 384 288h-32c-8.844 0-16 7.156-16 16S343.2 320 352 320h16v128h-32c-8.844 0-16 7.156-16 16s7.156 16 16 16h96c8.844 0 16-7.156 16-16S440.8 448 432 448zM384 32c-44.13 0-80 35.88-80 80S339.9 192 384 192c16.73 0 32.25-5.199 45.11-14.01C421.3 204.5 396.1 224 368 224C359.2 224 352 231.2 352 240S359.2 256 368 256c52.94 0 96-43.06 96-96V112C464 67.88 428.1 32 384 32zM384 160c-26.47 0-48-21.53-48-48S357.5 64 384 64s48 21.53 48 48S410.5 160 384 160zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-a-z": [512, 512, ["sort-alpha-asc", "sort-alpha-down"], "f15d", "M478.3 200.8l-79.1-160c-5.438-10.81-23.19-10.81-28.62 0l-79.1 160c-3.953 7.906-.75 17.5 7.156 21.47c7.906 4 17.52 .7187 21.47-7.156L329.9 192h108.2l11.58 23.16c3.096 6.156 12.08 11.88 21.47 7.156C479.1 218.3 482.3 208.8 478.3 200.8zM345.9 160l38.11-76.22L422.1 160H345.9zM447.1 448h-94.7l107.2-134c3.844-4.812 4.578-11.38 1.922-16.94C459.7 291.5 454.2 288 447.1 288H319.1c-8.844 0-16 7.156-16 16s7.156 16 16 16h94.7l-107.2 134c-3.844 4.812-4.578 11.38-1.922 16.94C308.2 476.5 313.8 480 319.1 480h127.1c8.844 0 15.1-7.156 15.1-16S456.8 448 447.1 448zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48c0-8.844-7.156-16-16-16S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-arrow-up": [448, 512, ["sort-alt"], "f883", "M224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352zM427.3 132.7l-96-96c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L304 86.63V464c0 8.844 7.156 16 16 16s16-7.156 16-16V86.63l68.69 68.69C407.8 158.4 411.9 160 416 160s8.188-1.562 11.31-4.688C433.6 149.1 433.6 138.9 427.3 132.7z"],
    "arrow-down-big-small": [512, 512, ["sort-size-down"], "f88c", "M399.1 320H336c-26.4 0-48 21.6-48 48v64c0 26.4 21.6 48 48 48h63.1c26.4 0 48-21.6 48-48v-64C447.1 341.6 426.4 320 399.1 320zM415.1 432c0 8.672-7.326 16-16 16H336c-8.674 0-16-7.328-16-16v-64c0-8.672 7.326-16 16-16h63.1c8.674 0 16 7.328 16 16V432zM464 32h-128C309.5 32 288 53.49 288 80v128C288 234.5 309.5 256 336 256h128C490.5 256 512 234.5 512 208v-128C512 53.49 490.5 32 464 32zM480 208C480 216.8 472.8 224 464 224h-128C327.2 224 320 216.8 320 208v-128C320 71.18 327.2 64 336 64h128C472.8 64 480 71.18 480 80V208zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-from-dotted-line": [448, 512, [], "e090", "M320 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S306.7 87.1 320 87.1zM224 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S210.7 87.1 224 87.1zM416 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S402.7 87.1 416 87.1zM128 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S114.7 87.1 128 87.1zM32 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S18.74 87.1 32 87.1zM212.7 475.3C215.8 478.4 219.9 479.1 224 479.1s8.188-1.562 11.31-4.688l144-144c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L240 425.4V159.1c0-8.844-7.156-16-16-16s-16 7.156-16 16v265.4L91.31 308.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L212.7 475.3z"],
    "arrow-down-from-line": [384, 512, [62277, "arrow-from-top"], "21a7", "M324.7 308.7L208 425.4V128c0-8.844-7.156-16-16-16S176 119.2 176 128v297.4L59.31 308.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l144 144C183.8 478.4 187.9 480 192 480s8.188-1.562 11.31-4.688l144-144c6.25-6.25 6.25-16.38 0-22.62S330.9 302.4 324.7 308.7zM368 32h-352C7.156 32 0 39.16 0 48S7.156 64 16 64h352C376.8 64 384 56.84 384 48S376.8 32 368 32z"],
    "arrow-down-left": [320, 512, [], "e091", "M315.3 122.6L54.43 383.4L240 384C248.9 384 256 391.2 256 400C255.1 408.9 248.8 416 240 416l-224-.6562C7.141 415.3 0 408.2 0 399.3V176C0 167.2 7.156 160 16 160S32 167.2 32 176v184.6l260.7-260.7c6.25-6.25 16.38-6.25 22.62 0S321.6 116.3 315.3 122.6z"],
    "arrow-down-left-and-arrow-up-right-to-center": [512, 512, [], "e092", "M208 288h-160C39.16 288 32 295.2 32 304S39.16 320 48 320h121.4l-148.7 148.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L192 342.6V464C192 472.8 199.2 480 208 480S224 472.8 224 464v-160C224 295.2 216.8 288 208 288zM491.3 20.69c-6.25-6.25-16.38-6.25-22.62 0L320 169.4V48C320 39.16 312.8 32 304 32S288 39.16 288 48v160C288 216.8 295.2 224 304 224h160C472.8 224 480 216.8 480 208S472.8 192 464 192h-121.4l148.7-148.7C497.6 37.06 497.6 26.94 491.3 20.69z"],
    "arrow-down-long": [320, 512, ["long-arrow-down"], "f175", "M315.3 363.3l-144 144C168.2 510.4 164.1 512 160 512s-8.188-1.562-11.31-4.688l-144-144c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0L144 457.4V16C144 7.156 151.2 0 160 0s16 7.156 16 16v441.4l116.7-116.7c6.25-6.25 16.38-6.25 22.62 0S321.6 357.1 315.3 363.3z"],
    "arrow-down-right": [320, 512, [], "e093", "M320 176v223.3c0 8.812-7.141 15.97-15.95 16l-224 .6562C71.23 416 64.03 408.9 64 400c-.0313-8.812 7.109-16 15.95-16.03l185.6-.5547L4.688 122.6c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0L288 360.6V176C288 167.2 295.2 160 304 160S320 167.2 320 176z"],
    "arrow-down-short-wide": [576, 512, ["sort-amount-desc", "sort-amount-down-alt"], "f884", "M304 208h128C440.8 208 448 200.8 448 192s-7.156-16-16-16h-128c-8.844 0-15.1 7.156-15.1 16S295.2 208 304 208zM304 336h192c8.844 0 16-7.156 16-16s-7.156-16-16-16h-192c-8.844 0-15.1 7.156-15.1 16S295.2 336 304 336zM304 80h64c8.844 0 16-7.156 16-16S376.8 48 368 48h-64c-8.844 0-15.1 7.156-15.1 16S295.2 80 304 80zM560 432h-256c-8.844 0-15.1 7.156-15.1 16S295.2 464 304 464h256c8.844 0 16-7.156 16-16S568.8 432 560 432zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-small-big": [512, 512, ["sort-size-down-alt"], "f88d", "M336 192h63.1c26.4 0 48-21.6 48-48v-64c0-26.4-21.6-48-48-48H336C309.6 32 288 53.6 288 80v64C288 170.4 309.6 192 336 192zM320 80C320 71.33 327.3 64 336 64h63.1c8.674 0 16 7.328 16 16v64c0 8.672-7.326 16-16 16H336C327.3 160 320 152.7 320 144V80zM464 256h-128C309.5 256 288 277.5 288 304v128c0 26.51 21.49 48 48 48h128c26.51 0 48-21.49 48-48v-128C512 277.5 490.5 256 464 256zM480 432c0 8.824-7.178 16-16 16h-128c-8.822 0-16-7.176-16-16v-128C320 295.2 327.2 288 336 288h128C472.8 288 480 295.2 480 304V432zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-square-triangle": [512, 512, ["sort-shapes-down-alt"], "f889", "M336 223.1l96 .0059c26.51 0 48-21.49 48-48.01V80c0-26.51-21.49-48-48-48h-96c-26.51 0-48 21.49-48 48v95.99C288 202.5 309.5 223.1 336 223.1zM320 80c0-8.824 7.178-16 16-16h96c8.822 0 16 7.176 16 16v95.99c0 8.824-7.178 16-16 16h-96c-8.822 0-16-7.176-16-16V80zM492.1 438.9l-83.13-137.1c-5.562-9.188-15.28-13.76-24.97-13.76s-19.34 4.573-24.91 13.76l-83.25 137.1c-11 18.25 2.75 41.13 25 41.13h166.3C489.4 480 503.1 457.1 492.1 438.9zM307.8 448l76.29-125.6l76.18 125.6H307.8zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48c0-8.844-7.156-15.1-16-15.1S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-to-bracket": [448, 512, [], "e094", "M224 352c4.094 0 8.188-1.562 11.31-4.688l144-144c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L240 297.4V16C240 7.156 232.8 0 224 0S208 7.156 208 16v281.4L91.31 180.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l144 144C215.8 350.4 219.9 352 224 352zM448 432v-96c0-8.844-7.156-16-16-16S416 327.2 416 336v96c0 26.47-21.53 48-48 48h-288C53.53 480 32 458.5 32 432v-96C32 327.2 24.84 320 16 320S0 327.2 0 336v96C0 476.1 35.88 512 80 512h288C412.1 512 448 476.1 448 432z"],
    "arrow-down-to-dotted-line": [448, 512, [], "e095", "M128 424c-13.26 0-24 10.75-24 24S114.7 472 128 472S152 461.3 152 448S141.3 424 128 424zM224 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S237.3 424 224 424zM32 424c-13.26 0-24 10.75-24 24S18.74 472 32 472S56 461.3 56 448S45.26 424 32 424zM320 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S333.3 424 320 424zM416 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S429.3 424 416 424zM212.7 363.3C215.8 366.4 219.9 367.1 224 367.1s8.188-1.562 11.31-4.688l144-144c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L240 313.4V47.1c0-8.844-7.156-16-16-16s-16 7.156-16 16v265.4L91.31 196.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L212.7 363.3z"],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", "M180.7 395.3C183.8 398.4 187.9 400 192 400s8.188-1.562 11.31-4.688l144-144c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L208 345.4V48C208 39.16 200.8 32 192 32S176 39.16 176 48v297.4L59.31 228.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L180.7 395.3zM368 448h-352C7.156 448 0 455.2 0 464S7.156 480 16 480h352c8.844 0 16-7.156 16-16S376.8 448 368 448z"],
    "arrow-down-to-square": [512, 512, [], "e096", "M432 128h-64C359.2 128 352 135.2 352 144S359.2 160 368 160h64C440.8 160 448 167.2 448 176v288c0 8.812-7.188 16-16 16h-352C71.19 480 64 472.8 64 464v-288C64 167.2 71.19 160 80 160h64C152.8 160 160 152.8 160 144S152.8 128 144 128h-64C53.53 128 32 149.5 32 176v288C32 490.5 53.53 512 80 512h352c26.47 0 48-21.53 48-48v-288C480 149.5 458.5 128 432 128zM148.7 260.7c-6.25 6.25-6.25 16.38 0 22.62l96 96C247.8 382.4 251.9 384 256 384s8.188-1.562 11.31-4.688l96-96c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L272 329.4V16C272 7.156 264.8 0 256 0S240 7.156 240 16v313.4L171.3 260.7C165.1 254.4 154.9 254.4 148.7 260.7z"],
    "arrow-down-triangle-square": [512, 512, ["sort-shapes-down"], "f888", "M432 288l-96-.0107c-26.51 0-48 21.49-48 48v95.99c0 26.51 21.49 48 48 48l96 .0098c26.51 0 48-21.5 48-48.01v-95.99C480 309.5 458.5 288 432 288zM448 431.1c0 8.824-7.178 16-16 16h-96c-8.822 0-16-7.176-16-16v-95.99c0-8.824 7.178-16 16-16h96c8.822 0 16 7.176 16 16V431.1zM492.1 182.9l-83.13-137.1C403.4 36.58 393.7 31.99 384 31.99s-19.34 4.591-24.91 13.78l-83.25 137.1c-11 18.25 2.75 41.12 25 41.12h166.3C489.4 224 503.1 201.1 492.1 182.9zM307.8 192l76.29-125.6L460.2 192H307.8zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48c0-8.844-7.156-15.1-16-15.1S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-wide-short": [576, 512, ["sort-amount-asc", "sort-amount-down"], "f160", "M368 432h-64c-8.844 0-15.1 7.156-15.1 16S295.2 464 304 464h64c8.844 0 16-7.156 16-16S376.8 432 368 432zM432 304h-128c-8.844 0-15.1 7.156-15.1 16S295.2 336 304 336h128c8.844 0 16-7.156 16-16S440.8 304 432 304zM496 176h-192c-8.844 0-15.1 7.156-15.1 16S295.2 208 304 208h192C504.8 208 512 200.8 512 192S504.8 176 496 176zM560 48h-256c-8.844 0-15.1 7.156-15.1 16S295.2 80 304 80h256C568.8 80 576 72.84 576 64S568.8 48 560 48zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48C144 39.16 136.8 32 128 32S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-down-z-a": [512, 512, ["sort-alpha-desc", "sort-alpha-down-alt"], "f881", "M478.3 456.8l-79.99-159.1c-5.438-10.81-23.19-10.81-28.62 0l-79.99 159.1c-3.953 7.906-.75 17.5 7.156 21.47c7.906 4 17.51 .7187 21.47-7.156l11.58-23.16h108.2l11.58 23.16c3.094 6.156 12.08 11.88 21.47 7.156C479.1 474.3 482.3 464.7 478.3 456.8zM345.9 415.1L384 339.7l38.11 76.21H345.9zM320 63.1h94.7l-107.2 133.1c-3.842 4.812-4.576 11.38-1.92 16.94c2.67 5.531 8.261 9.078 14.42 9.078h127.1c8.844 0 15.1-7.172 15.1-16.02s-7.154-15.1-15.1-15.1h-94.7l107.2-133.1c3.842-4.812 4.576-11.37 1.92-16.93C459.7 35.53 454.2 32 447.1 32h-127.1c-8.844 0-15.1 7.156-15.1 16C304 56.84 311.2 63.1 320 63.1zM224 352c-4.094 0-8.188 1.562-11.31 4.688L144 425.4V48c0-8.844-7.156-16-16-16S112 39.16 112 48v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96c6.25-6.25 6.25-16.38 0-22.62C232.2 353.6 228.1 352 224 352z"],
    "arrow-left": [448, 512, [61536], "2190", "M447.1 256C447.1 264.8 440.8 272 432 272H68.17l135.7 149.3c5.938 6.531 5.453 16.66-1.078 22.59C199.7 446.6 195.8 448 192 448c-4.344 0-8.688-1.75-11.84-5.25l-160-176c-5.547-6.094-5.547-15.41 0-21.5l160-176c5.969-6.562 16.09-7 22.61-1.094c6.531 5.938 7.016 16.06 1.078 22.59L68.17 240H432C440.8 240 447.1 247.2 447.1 256z"],
    "arrow-left-from-line": [448, 512, [62276, "arrow-from-right"], "21a4", "M352 240H54.63l116.7-116.7c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-144 144C1.563 247.8 0 251.9 0 256s1.562 8.188 4.688 11.31l144 144c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L54.63 272H352c8.844 0 16-7.156 16-16S360.8 240 352 240zM432 64C423.2 64 416 71.16 416 80v352c0 8.844 7.156 16 16 16s16-7.156 16-16v-352C448 71.16 440.8 64 432 64z"],
    "arrow-left-long": [512, 512, ["long-arrow-left"], "f177", "M148.7 411.3l-144-144C1.563 264.2 0 260.1 0 256s1.562-8.188 4.688-11.31l144-144c6.25-6.25 16.38-6.25 22.62 0s6.25 16.38 0 22.62L54.63 240H496C504.8 240 512 247.2 512 256s-7.156 16-16 16H54.63l116.7 116.7c6.25 6.25 6.25 16.38 0 22.62S154.9 417.6 148.7 411.3z"],
    "arrow-left-to-line": [448, 512, [62270, "arrow-to-left"], "21e4", "M432 240H134.6l116.7-116.7c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-144 144C81.56 247.8 80 251.9 80 256s1.562 8.188 4.688 11.31l144 144c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L134.6 272H432C440.8 272 448 264.8 448 256S440.8 240 432 240zM16 64C7.156 64 0 71.16 0 80v352C0 440.8 7.156 448 16 448S32 440.8 32 432v-352C32 71.16 24.84 64 16 64z"],
    "arrow-pointer": [320, 512, ["mouse-pointer"], "f245", "M311.9 277.1L39.87 37.99C35.41 34.05 29.75 32 24.01 32C20.67 32 17.31 32.69 14.12 34.11C5.531 37.98 0 46.58 0 56.02v367.1c0 10.06 6.281 19.06 15.72 22.53c2.703 .9844 5.5 1.469 8.281 1.469c6.906 0 13.64-2.985 18.28-8.453l90.18-106.1l60.91 137.1C196 476.5 201.9 480 208 480c2.156 0 4.375-.4375 6.484-1.375c8.078-3.594 11.7-13.05 8.125-21.13l-61.11-137.5l134.5 0c9.984 0 18.92-6.172 22.45-15.52C321.1 295.1 319.4 284.6 311.9 277.1zM129.1 287.1L32 402.2V73.71l242.8 214.3H129.1z"],
    "arrow-right": [448, 512, [61537], "2192", "M427.8 266.8l-160 176C264.7 446.3 260.3 448 256 448c-3.844 0-7.703-1.375-10.77-4.156c-6.531-5.938-7.016-16.06-1.078-22.59L379.8 272H16c-8.844 0-15.1-7.155-15.1-15.1S7.156 240 16 240h363.8l-135.7-149.3c-5.938-6.531-5.453-16.66 1.078-22.59c6.547-5.906 16.66-5.469 22.61 1.094l160 176C433.4 251.3 433.4 260.7 427.8 266.8z"],
    "arrow-right-arrow-left": [512, 512, [61676, "exchange"], "21c4", "M16 160h441.4l-100.7 100.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l128-128C510.4 152.2 512 148.1 512 144s-1.562-8.188-4.688-11.31l-128-128c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L457.4 128H16C7.156 128 0 135.2 0 144S7.156 160 16 160zM496 352H54.63l100.7-100.7c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-128 128C1.563 359.8 0 363.9 0 368s1.562 8.188 4.688 11.31l128 128c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L54.63 384H496c8.844 0 16-7.156 16-16S504.8 352 496 352z"],
    "arrow-right-from-bracket": [512, 512, ["sign-out"], "f08b", "M507.3 244.7l-144-144c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L457.4 240H176C167.2 240 160 247.2 160 256s7.156 16 16 16h281.4l-116.7 116.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l144-144C510.4 264.2 512 260.1 512 256S510.4 247.8 507.3 244.7zM176 448h-96C53.53 448 32 426.5 32 400v-288C32 85.53 53.53 64 80 64h96C184.8 64 192 56.84 192 48S184.8 32 176 32h-96C35.88 32 0 67.88 0 112v288C0 444.1 35.88 480 80 480h96C184.8 480 192 472.8 192 464S184.8 448 176 448z"],
    "arrow-right-from-line": [448, 512, [62275, "arrow-from-left"], "21a6", "M443.3 244.7l-144-144c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L393.4 240H96C87.16 240 80 247.2 80 256S87.16 272 96 272h297.4l-116.7 116.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l144-144C446.4 264.2 448 260.1 448 256S446.4 247.8 443.3 244.7zM16 64C7.156 64 0 71.16 0 80v352C0 440.8 7.156 448 16 448S32 440.8 32 432v-352C32 71.16 24.84 64 16 64z"],
    "arrow-right-long": [512, 512, ["long-arrow-right"], "f178", "M363.3 100.7l144 144C510.4 247.8 512 251.9 512 255.1s-1.562 8.188-4.688 11.31l-144 144c-6.25 6.25-16.38 6.25-22.62 0s-6.25-16.38 0-22.62l116.7-116.7H16c-8.844 0-16-7.156-16-15.1c0-8.844 7.156-16 16-16h441.4l-116.7-116.7c-6.25-6.25-6.25-16.38 0-22.62S357.1 94.44 363.3 100.7z"],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", "M352 256c0-4.094-1.562-8.188-4.688-11.31l-144-144c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L297.4 240H16C7.156 240 0 247.2 0 256s7.156 16 16 16h281.4l-116.7 116.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l144-144C350.4 264.2 352 260.1 352 256zM432 32h-96C327.2 32 320 39.16 320 48S327.2 64 336 64h96C458.5 64 480 85.53 480 112v288c0 26.47-21.53 48-48 48h-96c-8.844 0-16 7.156-16 16s7.156 16 16 16h96c44.13 0 80-35.88 80-80v-288C512 67.88 476.1 32 432 32z"],
    "arrow-right-to-line": [448, 512, [62272, "arrow-to-right"], "21e5", "M432 64C423.2 64 416 71.16 416 80v352c0 8.844 7.156 16 16 16s16-7.156 16-16v-352C448 71.16 440.8 64 432 64zM219.3 100.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L313.4 240H16C7.156 240 0 247.2 0 256s7.156 16 16 16h297.4l-116.7 116.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l144-144C366.4 264.2 368 260.1 368 256s-1.562-8.188-4.688-11.31L219.3 100.7z"],
    "arrow-rotate-left": [512, 512, [61666, "arrow-left-rotate", "arrow-rotate-back", "arrow-rotate-backward", "undo"], "21ba", "M480 256c0 123.5-100.4 223.9-223.9 223.9c-69.41 0-133.9-31.3-176.7-86.05c-5.438-6.938-4.203-17 2.75-22.44c6.984-5.531 17.03-4.25 22.47 2.75C141.3 421.1 196.5 448 256 448c105.9 0 192-86.13 192-192s-86.13-192-192-192C187.1 64 124.5 100.7 90.15 160H176C184.8 160 192 167.2 192 176S184.8 192 176 192h-128C39.16 192 32 184.8 32 176v-128C32 39.16 39.16 32 48 32S64 39.16 64 48v93.56C104.4 73.87 176.6 32.11 256.1 32.11C379.6 32.11 480 132.5 480 256z"],
    "arrow-rotate-right": [512, 512, [61470, "arrow-right-rotate", "arrow-rotate-forward", "redo"], "21bb", "M255.9 32.11c79.47 0 151.8 41.76 192.1 109.4V48C448 39.16 455.2 32 464 32S480 39.16 480 48v128C480 184.8 472.8 192 464 192h-128C327.2 192 320 184.8 320 176S327.2 160 336 160h85.85C387.5 100.7 324.9 64 256 64C150.1 64 64 150.1 64 256s86.13 192 192 192c59.48 0 114.7-26.91 151.3-73.84c5.438-7 15.48-8.281 22.47-2.75c6.953 5.438 8.187 15.5 2.75 22.44c-42.8 54.75-107.3 86.05-176.7 86.05C132.4 479.9 32 379.5 32 256S132.4 32.11 255.9 32.11z"],
    "arrow-trend-down": [576, 512, [], "e097", "M576 224v176c0 8.844-7.156 16-16 16H384c-8.844 0-16-7.156-16-16S375.2 384 384 384h137.4L320 182.6L203.3 299.3C200.2 302.4 196.1 304 192 304S183.8 302.4 180.7 299.3l-176-176C1.563 120.2 0 116.1 0 112C0 102.9 7.473 96 16 96c4.094 0 8.188 1.562 11.31 4.688L192 265.4l116.7-116.7C311.8 145.6 315.9 144 320 144s8.188 1.562 11.31 4.688L544 361.4V224c0-8.844 7.156-16 16-16S576 215.2 576 224z"],
    "arrow-trend-up": [576, 512, [], "e098", "M576 112V288c0 8.844-7.156 16-16 16S544 296.8 544 288V150.6l-212.7 212.7C328.2 366.4 324.1 368 320 368s-8.188-1.562-11.31-4.688L192 246.6l-164.7 164.7C24.19 414.4 20.09 416 16 416C6.861 416 0 408.5 0 400c0-4.094 1.562-8.188 4.688-11.31l176-176C183.8 209.6 187.9 208 192 208s8.188 1.562 11.31 4.688L320 329.4L521.4 128H384c-8.844 0-16-7.156-16-16S375.2 96 384 96h176C568.8 96 576 103.2 576 112z"],
    "arrow-turn-down": [384, 512, ["level-down"], "f149", "M347.3 363.3l-144 144C200.2 510.4 196.1 512 191.1 512s-8.187-1.562-11.31-4.688l-144-144c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0L176 457.4V80C176 53.53 154.5 32 128 32H16C7.156 32 0 24.84 0 16S7.156 0 16 0l112 0C172.1 0 208 35.88 208 80v377.4l116.7-116.7c6.25-6.25 16.38-6.25 22.62 0S353.6 357.1 347.3 363.3z"],
    "arrow-turn-down-left": [512, 512, [], "e2e1", "M148.7 443.3l-144-144C1.563 296.2 0 292.1 0 288s1.562-8.188 4.688-11.31l144-144c6.25-6.25 16.38-6.25 22.62 0s6.25 16.38 0 22.62L54.63 272H432C458.5 272 480 250.5 480 224V48C480 39.16 487.2 32 496 32S512 39.16 512 48v175.1C512 268.1 476.1 304 432 304H54.63l116.7 116.7c6.25 6.25 6.25 16.38 0 22.62S154.9 449.6 148.7 443.3z"],
    "arrow-turn-up": [384, 512, ["level-up"], "f148", "M347.3 171.3c-6.25 6.25-16.38 6.25-22.62 0L208 54.63V432c0 44.13-35.89 80-80 80H16C7.156 512 0 504.8 0 496S7.156 480 16 480H128c26.47 0 48-21.53 48-48V54.63L59.31 171.3c-6.25 6.25-16.38 6.25-22.62 0s-6.25-16.38 0-22.62l144-144C183.8 1.562 187.9 0 192 0c4.094 0 8.188 1.562 11.31 4.688l144 144C353.6 154.9 353.6 165.1 347.3 171.3z"],
    "arrow-up": [384, 512, [61538], "2191", "M379.8 234.8C376.7 238.3 372.3 240 368 240c-3.844 0-7.703-1.375-10.77-4.156L208 100.2V464c0 8.844-7.156 15.1-15.1 15.1S176 472.8 176 464V100.2L26.77 235.8c-6.516 5.938-16.62 5.531-22.61-1.094C-1.781 228.2-1.297 218.1 5.234 212.2l176-160c6.094-5.562 15.44-5.562 21.53 0l176 160C385.3 218.1 385.8 228.2 379.8 234.8z"],
    "arrow-up-1-9": [512, 512, ["sort-numeric-up"], "f163", "M384 256c-44.13 0-80 35.88-80 80S339.9 416 384 416c16.73 0 32.25-5.199 45.11-14.01C421.3 428.5 396.1 448 368 448c-8.844 0-16 7.156-16 16s7.156 16 16 16c52.94 0 96-43.06 96-96v-48C464 291.9 428.1 256 384 256zM384 384c-26.47 0-48-21.53-48-48S357.5 288 384 288s48 21.53 48 48S410.5 384 384 384zM336 224l96-.0039c8.844 0 16-7.152 16-15.1S440.8 192 432 192h-32V48C400 39.16 392.8 32 384 32h-32c-8.844 0-16 7.156-16 16S343.2 64 352 64h16v128h-32C327.2 192 320 199.2 320 208S327.2 224 336 224zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.157 15.1 16 15.1S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-9-1": [512, 512, ["sort-numeric-up-alt"], "f887", "M432 448h-32V304C400 295.2 392.8 288 384 288h-32c-8.844 0-16 7.156-16 16S343.2 320 352 320h16v128h-32c-8.844 0-16 7.156-16 16s7.156 16 16 16h96c8.844 0 16-7.156 16-16S440.8 448 432 448zM384 32c-44.13 0-80 35.88-80 80S339.9 192 384 192c16.73 0 32.25-5.199 45.11-14.01C421.3 204.5 396.1 224 368 224C359.2 224 352 231.2 352 240S359.2 256 368 256c52.94 0 96-43.06 96-96V112C464 67.88 428.1 32 384 32zM384 160c-26.47 0-48-21.53-48-48S357.5 64 384 64s48 21.53 48 48S410.5 160 384 160zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.157 15.1 16 15.1S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-a-z": [512, 512, ["sort-alpha-up"], "f15e", "M478.3 200.4l-79.1-160.3c-5.438-10.84-23.19-10.84-28.62 0l-79.1 160.3c-3.953 7.922-.75 17.53 7.156 21.51c7.906 4.004 17.52 .7187 21.47-7.172l11.58-23.19h108.2l11.58 23.19c3.096 6.168 12.08 11.91 21.47 7.172C479.1 217.9 482.3 208.3 478.3 200.4zM345.9 159.5l38.11-76.34l38.11 76.34H345.9zM447.1 447.9h-94.7l107.2-134.2c3.844-4.82 4.578-11.39 1.922-16.96c-2.672-5.543-8.262-8.867-14.42-8.867H319.1c-8.844 0-16 6.957-16 15.82s7.156 16.02 16 16.02h94.7l-107.2 134.2c-3.844 4.82-4.578 11.39-1.922 16.96C308.2 476.5 313.8 480 319.1 480h127.1c8.844 0 15.1-7.168 15.1-16.03C463.1 455.1 456.8 447.9 447.1 447.9zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.156 16 16 16S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-arrow-down": [448, 512, ["sort-up-down"], "e099", "M224 160c4.094 0 8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-96-96c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464C112 472.8 119.2 480 128 480s16-7.156 16-16V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160zM427.3 356.7C424.2 353.6 420.1 352 416 352s-8.188 1.562-11.31 4.688L336 425.4V48C336 39.16 328.8 32 320 32s-16 7.156-16 16v377.4l-68.69-68.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96c6.25 6.25 16.38 6.25 22.62 0l96-96C433.6 373.1 433.6 362.9 427.3 356.7z"],
    "arrow-up-big-small": [512, 512, ["sort-size-up"], "f88e", "M399.1 320H336c-26.4 0-48 21.6-48 48v64c0 26.4 21.6 48 48 48h63.1c26.4 0 48-21.6 48-48v-64C447.1 341.6 426.4 320 399.1 320zM415.1 432c0 8.672-7.326 16-16 16H336c-8.672 0-16-7.328-16-16v-64c0-8.672 7.328-16 16-16h63.1c8.674 0 16 7.328 16 16V432zM464 32h-128C309.5 32 288 53.49 288 80v128C288 234.5 309.5 256 336 256h128C490.5 256 512 234.5 512 208v-128C512 53.49 490.5 32 464 32zM480 208C480 216.8 472.8 224 464 224h-128C327.2 224 320 216.8 320 208v-128C320 71.18 327.2 64 336 64h128C472.8 64 480 71.18 480 80V208zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464C112 472.8 119.2 480 128 480s16-7.156 16-16V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-from-bracket": [448, 512, [], "e09a", "M212.7 4.688l-144 144c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L208 54.63V336c0 8.844 7.156 16 16 16s16-7.156 16-16V54.63l116.7 116.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62l-144-144C232.2 1.562 228.1 0 224 0S215.8 1.562 212.7 4.688zM416 336v96c0 26.47-21.53 48-48 48h-288C53.53 480 32 458.5 32 432v-96C32 327.2 24.84 320 16 320S0 327.2 0 336v96C0 476.1 35.88 512 80 512h288c44.13 0 80-35.88 80-80v-96c0-8.844-7.156-16-16-16S416 327.2 416 336z"],
    "arrow-up-from-dotted-line": [448, 512, [], "e09b", "M128 424c-13.26 0-24 10.75-24 24S114.7 472 128 472S152 461.3 152 448S141.3 424 128 424zM224 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S237.3 424 224 424zM32 424c-13.26 0-24 10.75-24 24S18.74 472 32 472S56 461.3 56 448S45.26 424 32 424zM320 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S333.3 424 320 424zM416 424c-13.26 0-24 10.75-24 24s10.74 24 24 24s24-10.75 24-24S429.3 424 416 424zM235.3 36.69C232.2 33.56 228.1 32 224 32S215.8 33.56 212.7 36.69l-144 144c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L208 86.63V352c0 8.844 7.156 16 16 16s16-7.156 16-16V86.63l116.7 116.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L235.3 36.69z"],
    "arrow-up-from-line": [384, 512, [62274, "arrow-from-bottom"], "21a5", "M59.31 203.3L176 86.63V384c0 8.844 7.156 16 16 16s16-7.156 16-16V86.63l116.7 116.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62l-144-144C200.2 33.56 196.1 32 192 32S183.8 33.56 180.7 36.69l-144 144c-6.25 6.25-6.25 16.38 0 22.62S53.06 209.6 59.31 203.3zM368 448h-352C7.156 448 0 455.2 0 464S7.156 480 16 480h352c8.844 0 16-7.156 16-16S376.8 448 368 448z"],
    "arrow-up-from-square": [512, 512, [], "e09c", "M432 160h-32C391.2 160 384 167.2 384 176S391.2 192 400 192h32C440.8 192 448 199.2 448 208v256c0 8.812-7.188 16-16 16h-352C71.19 480 64 472.8 64 464v-256C64 199.2 71.19 192 80 192h32C120.8 192 128 184.8 128 176S120.8 160 112 160h-32C53.53 160 32 181.5 32 208v256C32 490.5 53.53 512 80 512h352c26.47 0 48-21.53 48-48v-256C480 181.5 458.5 160 432 160zM160 128c4.094 0 8.188-1.562 11.31-4.688L240 54.63V336c0 8.844 7.156 16.02 16 16.02S272 344.8 272 336V54.63l68.69 68.69C343.8 126.4 347.9 128 352 128c9.139 0 16-7.473 16-16c0-4.094-1.562-8.188-4.688-11.31l-96-96C264.2 1.562 260.1-.0002 256-.0002S247.8 1.562 244.7 4.688l-96 96C145.6 103.8 144 107.9 144 112C144 120.5 150.9 128 160 128z"],
    "arrow-up-left": [320, 512, [], "e09d", "M315.3 411.3C312.2 414.4 308.1 416 304 416s-8.188-1.562-11.31-4.688L32 150.6v184.6c0 8.844-7.156 16-16 16s-16-7.156-16-16V111.9c0-8.812 7.141-15.97 15.95-16c0 0 224-.6562 224-.6562c8.812 0 15.97 7.125 16 15.97c.0313 8.812-7.109 16-15.95 16.03l-185.6 .5547l260.9 260.9C321.6 394.9 321.6 405.1 315.3 411.3z"],
    "arrow-up-left-from-circle": [512, 512, [], "e09e", "M320 336c4.094 0 8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L54.63 32H176C184.8 32 192 24.84 192 16S184.8 0 176 0h-160C7.156 0 0 7.156 0 16v160C0 184.8 7.156 192 16 192S32 184.8 32 176V54.63l276.7 276.7C311.8 334.4 315.9 336 320 336zM288 64c-23.5 0-46.69 3.625-68.91 10.81C210.7 77.5 206.1 86.53 208.8 94.94S220.5 108 228.9 105.3C247.1 99.13 267.8 96 288 96c105.9 0 192 86.13 192 192s-86.13 192-192 192s-192-86.13-192-192c0-20.16 3.125-40.03 9.25-59.09C107.1 220.5 103.3 211.5 94.94 208.8C86.63 206.1 77.53 210.7 74.81 219.1C67.63 241.3 64 264.5 64 288c0 123.5 100.5 224 224 224s224-100.5 224-224S411.5 64 288 64z"],
    "arrow-up-long": [320, 512, ["long-arrow-up"], "f176", "M4.688 148.7l144-144C151.8 1.562 155.9 0 160 0s8.188 1.562 11.31 4.688l144 144c6.25 6.25 6.25 16.38 0 22.62s-16.38 6.25-22.62 0L176 54.63V496c0 8.844-7.156 16-16 16s-16-7.156-16-16V54.63L27.31 171.3c-6.25 6.25-16.38 6.25-22.62 0S-1.563 154.9 4.688 148.7z"],
    "arrow-up-right": [320, 512, [], "e09f", "M320 111.9v223.3c0 8.844-7.156 16-16 16s-16-7.156-16-16V150.6l-260.7 260.7C24.19 414.4 20.09 416 16 416s-8.188-1.562-11.31-4.688c-6.25-6.25-6.25-16.38 0-22.62l260.9-260.9l-185.6-.5547C71.11 127.2 63.97 120 64 111.2c.0313-8.844 7.188-15.97 16-15.97l224 .6562C312.9 95.94 320 103.1 320 111.9z"],
    "arrow-up-right-and-arrow-down-left-from-center": [512, 512, [], "e0a0", "M496 0h-160C327.2 0 320 7.156 320 16S327.2 32 336 32h121.4l-164.7 164.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L480 54.63V176C480 184.8 487.2 192 496 192S512 184.8 512 176v-160C512 7.156 504.8 0 496 0zM196.7 292.7L32 457.4V336C32 327.2 24.84 320 16 320S0 327.2 0 336v160C0 504.8 7.156 512 16 512h160C184.8 512 192 504.8 192 496S184.8 480 176 480H54.63l164.7-164.7c6.25-6.25 6.25-16.38 0-22.62S202.9 286.4 196.7 292.7z"],
    "arrow-up-right-from-square": [512, 512, ["external-link"], "f08e", "M400 288C391.2 288 384 295.2 384 304V448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V160c0-17.67 14.33-32 32-32h112C184.8 128 192 120.8 192 112S184.8 96 176 96L64 96c-35.35 0-64 28.65-64 64V448c0 35.35 28.65 64 64 64h288c35.35 0 64-28.65 64-64V304C416 295.2 408.8 288 400 288zM496 0h-160C327.2 0 320 7.156 320 16S327.2 32 336 32h121.4L180.7 308.7c-6.25 6.25-6.25 16.38 0 22.62C183.8 334.4 187.9 336 192 336s8.188-1.562 11.31-4.688L480 54.63V176C480 184.8 487.2 192 496 192S512 184.8 512 176v-160C512 7.156 504.8 0 496 0z"],
    "arrow-up-short-wide": [576, 512, ["sort-amount-up-alt"], "f885", "M304 336h192c8.844 0 16-7.156 16-16s-7.156-16-16-16h-192c-8.844 0-15.1 7.156-15.1 16S295.2 336 304 336zM304 208h128C440.8 208 448 200.8 448 192s-7.156-16-16-16h-128c-8.844 0-15.1 7.156-15.1 16S295.2 208 304 208zM304 80h64c8.844 0 16-7.156 16-16S376.8 48 368 48h-64c-8.844 0-15.1 7.156-15.1 16S295.2 80 304 80zM560 432h-256c-8.844 0-15.1 7.156-15.1 16S295.2 464 304 464h256c8.844 0 16-7.156 16-16S568.8 432 560 432zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.157 16 16 16S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-small-big": [512, 512, ["sort-size-up-alt"], "f88f", "M336 192h63.1c26.4 0 48-21.6 48-48v-64c0-26.4-21.6-48-48-48H336C309.6 32 288 53.6 288 80v64C288 170.4 309.6 192 336 192zM320 80C320 71.33 327.3 64 336 64h63.1c8.674 0 16 7.328 16 16v64c0 8.672-7.326 16-16 16H336C327.3 160 320 152.7 320 144V80zM464 256h-128C309.5 256 288 277.5 288 304v128c0 26.51 21.49 48 48 48h128c26.51 0 48-21.49 48-48v-128C512 277.5 490.5 256 464 256zM480 432c0 8.824-7.178 16-16 16h-128c-8.822 0-16-7.176-16-16v-128C320 295.2 327.2 288 336 288h128C472.8 288 480 295.2 480 304V432zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464C112 472.8 119.2 480 128 480s16-7.156 16-16V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-square-triangle": [512, 512, ["sort-shapes-up-alt"], "f88b", "M336 223.1l96 .0059c26.51 0 48-21.49 48-48.01V80c0-26.51-21.49-48-48-48h-96c-26.51 0-48 21.49-48 48v95.99C288 202.5 309.5 223.1 336 223.1zM320 80c0-8.824 7.178-16 16-16h96c8.822 0 16 7.176 16 16v95.99c0 8.824-7.178 16-16 16h-96c-8.822 0-16-7.176-16-16V80zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464C112 472.8 119.2 480 128 480s16-7.156 16-16V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69zM492.1 438.9l-83.13-137.1c-5.562-9.188-15.28-13.76-24.97-13.76s-19.34 4.573-24.91 13.76l-83.25 137.1c-11 18.25 2.75 41.13 25 41.13h166.3C489.4 480 503.1 457.1 492.1 438.9zM307.8 448l76.29-125.6l76.18 125.6H307.8z"],
    "arrow-up-to-dotted-line": [448, 512, [], "e0a1", "M320 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S306.7 87.1 320 87.1zM224 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S210.7 87.1 224 87.1zM416 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S402.7 87.1 416 87.1zM128 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S114.7 87.1 128 87.1zM32 87.1c13.26 0 24-10.75 24-24s-10.74-24-24-24s-24 10.75-24 24S18.74 87.1 32 87.1zM235.3 148.7C232.2 145.6 228.1 144 224 144S215.8 145.6 212.7 148.7l-144 144c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L208 198.6V464c0 8.844 7.156 16 16 16s16-7.156 16-16V198.6l116.7 116.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L235.3 148.7z"],
    "arrow-up-to-line": [384, 512, ["arrow-to-top"], "f341", "M203.3 116.7C200.2 113.6 196.1 112 192 112S183.8 113.6 180.7 116.7l-144 144c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L176 166.6V464c0 8.844 7.156 16 16 16s16-7.156 16-16V166.6l116.7 116.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L203.3 116.7zM368 32h-352C7.156 32 0 39.16 0 48S7.156 64 16 64h352C376.8 64 384 56.84 384 48S376.8 32 368 32z"],
    "arrow-up-triangle-square": [512, 512, ["sort-shapes-up"], "f88a", "M492.1 182.9l-83.13-137.1C403.4 36.58 393.7 31.99 384 31.99s-19.34 4.591-24.91 13.78l-83.25 137.1c-11 18.25 2.75 41.12 25 41.12h166.3C489.4 224 503.1 201.1 492.1 182.9zM307.8 192l76.29-125.6L460.2 192H307.8zM432 288l-96-.0107c-26.51 0-48 21.49-48 48v95.99c0 26.51 21.49 48 48 48l96 .0098c26.51 0 48-21.5 48-48.01v-95.99C480 309.5 458.5 288 432 288zM448 431.1c0 8.824-7.178 16-16 16h-96c-8.822 0-16-7.176-16-16v-95.99c0-8.824 7.178-16 16-16h96c8.822 0 16 7.176 16 16V431.1zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464C112 472.8 119.2 480 128 480s16-7.156 16-16V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-wide-short": [576, 512, ["sort-amount-up"], "f161", "M368 432h-64c-8.844 0-15.1 7.156-15.1 16S295.2 464 304 464h64c8.844 0 16-7.156 16-16S376.8 432 368 432zM432 304h-128c-8.844 0-15.1 7.156-15.1 16S295.2 336 304 336h128c8.844 0 16-7.156 16-16S440.8 304 432 304zM560 48h-256c-8.844 0-15.1 7.156-15.1 16S295.2 80 304 80h256C568.8 80 576 72.84 576 64S568.8 48 560 48zM496 176h-192c-8.844 0-15.1 7.156-15.1 16S295.2 208 304 208h192C504.8 208 512 200.8 512 192S504.8 176 496 176zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.157 16 16 16S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrow-up-z-a": [512, 512, ["sort-alpha-up-alt"], "f882", "M478.3 456.8l-79.99-159.1c-5.438-10.81-23.19-10.81-28.62 0l-79.99 159.1c-3.953 7.902-.75 17.5 7.156 21.46c7.906 4 17.51 .7187 21.47-7.152l11.58-23.15h108.2l11.58 23.15c3.094 6.152 12.08 11.88 21.47 7.152C479.1 474.3 482.3 464.7 478.3 456.8zM345.9 415.9L384 339.7l38.11 76.21H345.9zM320 63.1h94.7l-107.2 133.1c-3.842 4.812-4.576 11.38-1.92 16.94c2.67 5.531 8.261 9.078 14.42 9.078h127.1c8.844 0 15.1-7.172 15.1-16.02s-7.154-16-15.1-16h-94.7l107.2-133.1c3.842-4.812 4.576-11.37 1.92-16.93C459.7 35.53 454.2 32 447.1 32h-127.1c-8.844 0-15.1 7.156-15.1 16C304 56.84 311.2 63.1 320 63.1zM139.3 36.69c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 86.63V464c0 8.844 7.157 16 16 16S144 472.8 144 464V86.63l68.69 68.69C215.8 158.4 219.9 160 224 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L139.3 36.69z"],
    "arrows-cross": [448, 512, [], "e0a2", "M429.3 288.4C421.5 289.7 416 297.1 416 305v120.5L291.9 301.4c-6.248-6.25-16.38-6.352-22.63-.1016s-6.246 16.48 .002 22.73l124.1 124.1H272.8c-7.969 0-15.35 5.453-16.62 13.32C254.6 471.5 262.3 480.2 272 480.2h160c8.836 0 16-7.164 16-16v-160C448 294.5 439.4 286.8 429.3 288.4zM156.1 210.9C162.4 217.2 172.5 217.1 178.8 210.8s6.247-16.28-.001-22.53L27.91 37.48c-5.635-5.637-14.71-7-21.17-2.34C-1.5 41.08-2.184 52.64 4.688 59.51L156.1 210.9zM432 32h-160C263.2 32 256 39.16 256 48S263.2 64 272 64h121.4L4.688 452.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L416 86.63V208C416 216.8 423.2 224 432 224S448 216.8 448 208v-160C448 39.16 440.8 32 432 32z"],
    "arrows-from-dotted-line": [448, 512, [], "e0a3", "M32 231.1c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C56 242.7 45.26 231.1 32 231.1zM200 255.1c0 13.25 10.74 24 24 24s24-10.75 24-24c0-13.26-10.74-24-24-24S200 242.7 200 255.1zM152 255.1c0-13.26-10.74-24-24-24S104 242.7 104 255.1c0 13.25 10.74 24 24 24S152 269.2 152 255.1zM416 231.1c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C440 242.7 429.3 231.1 416 231.1zM320 231.1c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C344 242.7 333.3 231.1 320 231.1zM144 111.1c4.094 0 8.188-1.563 11.31-4.688L208 54.61v121.4c0 8.844 7.156 15.1 16 15.1s16-7.151 16-15.1V54.61l52.69 52.69C295.8 110.4 299.9 111.1 304 111.1c9.139 0 16-7.48 16-16.01c0-4.094-1.562-8.181-4.688-11.31L235.3 4.69C231.3 .6451 226.5 0 223.1 0S216.7 .6451 212.7 4.69L132.7 84.67C129.6 87.8 128 91.89 128 95.98C128 104.5 134.9 111.1 144 111.1zM304 399.1c-4.094 0-8.188 1.563-11.31 4.688L240 457.4v-121.4c0-8.844-7.156-16-16-16s-16 7.16-16 16v121.4L155.3 404.7C152.2 401.6 148.1 399.1 144 399.1c-9.139 0-16 7.471-16 15.1c0 4.094 1.562 8.19 4.688 11.31l79.98 79.98C214.4 509 218.3 512 224 512s9.609-2.98 11.33-4.707l79.98-79.98C318.4 424.2 320 420.1 320 415.1C320 407.5 313.1 399.1 304 399.1z"],
    "arrows-from-line": [448, 512, [], "e0a4", "M144 111.1c4.094 0 8.188-1.562 11.31-4.688L208 54.61v121.4c0 8.844 7.156 15.1 16 15.1s16-7.152 16-15.1V54.61l52.69 52.69C295.8 110.4 299.9 111.1 304 111.1c9.139 0 16-7.478 16-16.01c0-4.094-1.562-8.182-4.688-11.31L235.3 4.688C231.3 .6445 226.5 0 223.1 0S216.7 .6445 212.7 4.688L132.7 84.67C129.6 87.8 128 91.89 128 95.98C128 104.5 134.9 111.1 144 111.1zM304 399.1c-4.094 0-8.188 1.562-11.31 4.688L240 457.4v-121.4c0-8.844-7.156-16-16-16s-16 7.159-16 16v121.4l-52.69-52.69C152.2 401.6 148.1 399.1 144 399.1c-9.139 0-16 7.471-16 15.1c0 4.094 1.562 8.189 4.688 11.31l79.98 79.98C214.4 509 218.3 512 224 512s9.609-2.98 11.33-4.707l79.98-79.98C318.4 424.2 320 420.1 320 415.1C320 407.5 313.1 399.1 304 399.1zM432 240h-416C7.156 240 0 247.1 0 255.1S7.156 272 16 272h416c8.844 0 16-7.165 16-16.01S440.8 240 432 240z"],
    "arrows-left-right": [512, 512, ["arrows-h"], "f07e", "M507.3 267.3l-112 112C392.2 382.4 388.1 384 384 384s-8.188-1.562-11.31-4.688c-6.25-6.25-6.25-16.38 0-22.62L457.4 272H54.63l84.69 84.69c6.25 6.25 6.25 16.38 0 22.62C136.2 382.4 132.1 384 128 384s-8.188-1.562-11.31-4.688l-112-112c-6.25-6.25-6.25-16.38 0-22.62l112-112c6.25-6.25 16.38-6.25 22.62 0s6.25 16.38 0 22.62L54.63 240h402.8l-84.69-84.69c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0l112 112C513.6 250.9 513.6 261.1 507.3 267.3z"],
    "arrows-maximize": [448, 512, ["expand-arrows"], "f31d", "M416 176V86.63L246.6 256L416 425.4V336c0-8.844 7.156-16 16-16s16 7.156 16 16v128c0 8.844-7.156 16-16 16h-128c-8.844 0-16-7.156-16-16s7.156-16 16-16h89.38L224 278.6L54.63 448H144C152.8 448 160 455.2 160 464S152.8 480 144 480h-128C7.156 480 0 472.8 0 464v-128C0 327.2 7.156 320 16 320S32 327.2 32 336v89.38L201.4 256L32 86.63V176C32 184.8 24.84 192 16 192S0 184.8 0 176v-128C0 39.16 7.156 32 16 32h128C152.8 32 160 39.16 160 48S152.8 64 144 64H54.63L224 233.4L393.4 64H304C295.2 64 288 56.84 288 48S295.2 32 304 32h128C440.8 32 448 39.16 448 48v128C448 184.8 440.8 192 432 192S416 184.8 416 176z"],
    "arrows-minimize": [512, 512, ["compress-arrows"], "e0a5", "M208 288h-160C39.16 288 32 295.2 32 304S39.16 320 48 320h121.4l-148.7 148.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L192 342.6V464C192 472.8 199.2 480 208 480S224 472.8 224 464v-160C224 295.2 216.8 288 208 288zM304 224h160C472.8 224 480 216.8 480 208S472.8 192 464 192h-121.4l148.7-148.7c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L320 169.4V48C320 39.16 312.8 32 304 32S288 39.16 288 48v160C288 216.8 295.2 224 304 224zM342.6 320H464c8.844 0 16-7.156 16-16S472.8 288 464 288h-160C295.2 288 288 295.2 288 304v160c0 8.844 7.156 16 16 16s16-7.156 16-16v-121.4l148.7 148.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L342.6 320zM208 32C199.2 32 192 39.16 192 48v121.4L43.31 20.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L169.4 192H48C39.16 192 32 199.2 32 208S39.16 224 48 224h160C216.8 224 224 216.8 224 208v-160C224 39.16 216.8 32 208 32z"],
    "arrows-repeat": [512, 512, ["repeat-alt"], "f364", "M176 112h211.8l-62.05 51.72c-6.781 5.656-7.703 15.75-2.047 22.53C326.9 190 331.4 192 336 192c3.609 0 7.234-1.219 10.23-3.719l96-80C445.9 105.3 448 100.7 448 95.1s-2.109-9.248-5.75-12.28l-96-80c-6.797-5.688-16.89-4.719-22.55 2.031c-5.656 6.781-4.734 16.88 2.047 22.53L387.8 80H176C78.95 80 0 158.1 0 255.1C0 264.8 7.156 272 16 272S32.01 264.8 32.01 256C32.01 176.6 96.59 112 176 112zM496 240c-8.844 0-16.01 7.156-16.01 16c0 79.41-64.59 144-143.1 144H124.2l62.05-51.72c6.781-5.656 7.703-15.75 2.047-22.53C182.7 319 172.6 318.1 165.8 323.7l-96 80C66.11 406.8 64 411.2 64 415.1s2.109 9.25 5.75 12.28l96 80C168.8 510.8 172.4 512 175.1 512c4.594 0 9.141-1.969 12.31-5.75c5.656-6.781 4.734-16.88-2.047-22.53L124.2 432H336c97.05 0 176-78.97 176-176C512 247.2 504.8 240 496 240z"],
    "arrows-repeat-1": [512, 512, ["repeat-1-alt"], "f366", "M176 112h211.8l-62.05 51.72c-3.794 3.164-5.754 7.718-5.754 12.3C319.1 186.8 329.3 192 336 192c3.609 0 7.234-1.219 10.23-3.719l96-80C445.9 105.3 448 100.7 448 95.1s-2.109-9.248-5.75-12.28l-96-80c-2.99-2.502-6.619-3.716-10.23-3.716c-6.754 0-16.03 5.286-16.03 15.98c0 4.585 1.96 9.139 5.754 12.3L387.8 80H176C78.95 80 0 158.1 0 255.1C0 264.8 7.156 272 16 272S32.01 264.8 32.01 256C32.01 176.6 96.59 112 176 112zM272 320c8.844 0 16-7.156 16-16v-96C288 199.2 280.8 192 272 192h-32C231.2 192 224 199.2 224 208S231.2 224 240 224H256v80C256 312.8 263.2 320 272 320zM496 240c-8.844 0-16.01 7.156-16.01 16c0 79.41-64.59 144-143.1 144H124.2l62.05-51.72c3.794-3.164 5.754-7.718 5.754-12.3c0-10.72-9.208-15.96-15.1-15.96c-3.611 0-7.249 1.212-10.26 3.703l-96 80C66.11 406.8 64 411.3 64 416s2.109 9.25 5.75 12.28l96 80C168.8 510.8 172.4 512 175.1 512c6.715 0 16.02-5.265 16.02-15.98c0-4.585-1.96-9.139-5.754-12.3L124.2 432H336c97.05 0 176-78.97 176-176C512 247.2 504.8 240 496 240z"],
    "arrows-retweet": [640, 512, ["retweet-alt"], "f361", "M336 368h-192V118.6l84.69 84.69C231.8 206.4 235.9 208 240 208s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-112-112c-6.25-6.25-16.38-6.25-22.62 0l-112 112c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L112 118.6V384c0 8.844 7.156 16 16 16h208c8.844 0 16-7.156 16-16S344.8 368 336 368zM635.3 308.7c-6.25-6.25-16.38-6.25-22.62 0L528 393.4V128c0-8.844-7.156-16-16-16H304C295.2 112 288 119.2 288 128s7.156 16 16 16h192v249.4l-84.69-84.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l112 112C503.8 446.4 507.9 448 512 448s8.187-1.562 11.31-4.688l112-112C641.6 325.1 641.6 314.9 635.3 308.7z"],
    "arrows-rotate": [512, 512, [61473, "refresh", "sync"], "1f5d8", "M464 32C455.2 32 448 39.16 448 48v129.3C416.2 99.72 340.6 48 256 48c-102 0-188.3 72.91-205.1 173.3C49.42 230.1 55.3 238.3 64.02 239.8C64.91 239.9 65.8 240 66.67 240c7.672 0 14.45-5.531 15.77-13.34C96.69 141.7 169.7 80 256 80c72.49 0 137.3 44.88 163.6 112H304C295.2 192 288 199.2 288 208S295.2 224 304 224h160C472.8 224 480 216.8 480 208v-160C480 39.16 472.8 32 464 32zM447.1 272.2c-8.766-1.562-16.97 4.406-18.42 13.12C415.3 370.3 342.3 432 255.1 432c-72.49 0-137.3-44.88-163.6-112H208C216.8 320 224 312.8 224 304S216.8 288 208 288h-160C39.16 288 32 295.2 32 304v160C32 472.8 39.16 480 48 480S64 472.8 64 464v-129.3C95.84 412.3 171.4 464 256 464c101.1 0 188.3-72.91 205.1-173.3C462.6 281.9 456.7 273.7 447.1 272.2z"],
    "arrows-to-dotted-line": [448, 512, [], "e0a6", "M200 256c0 13.25 10.74 24 24 24S248 269.3 248 256c0-13.26-10.74-24-24-24S200 242.7 200 256zM152 256c0-13.26-10.74-24-24-24S104 242.7 104 256c0 13.25 10.74 24 24 24S152 269.3 152 256zM32 232C18.74 232 8 242.7 8 256c0 13.25 10.74 24 24 24S56 269.3 56 256C56 242.7 45.26 232 32 232zM416 232c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24S440 269.3 440 256C440 242.7 429.3 232 416 232zM320 232c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24S344 269.3 344 256C344 242.7 333.3 232 320 232zM212.7 187.3C214.4 189 218.3 192 224 192s9.609-2.98 11.33-4.707l79.98-79.98C318.4 104.2 320 100.1 320 96c0-8.527-6.865-16-16-16c-4.094 0-8.188 1.562-11.31 4.688L240 137.4V16C240 7.156 232.8 0 224 0S208 7.156 208 16v121.4L155.3 84.69C152.2 81.56 148.1 80 144 80C134.9 80 128 87.47 128 96c0 4.094 1.562 8.188 4.688 11.31L212.7 187.3zM235.3 324.7C231.3 320.7 226.5 320 224 320s-7.298 .6529-11.33 4.697l-79.98 79.98C129.6 407.8 128 411.9 128 416c0 8.527 6.865 16 16 16c4.094 0 8.188-1.562 11.31-4.688L208 374.6V496c0 8.844 7.156 16 16 16s16-7.156 16-16v-121.4l52.69 52.69C295.8 430.4 299.9 432 304 432c9.139 0 16-7.473 16-16c0-4.094-1.562-8.188-4.688-11.31L235.3 324.7z"],
    "arrows-to-line": [448, 512, [], "e0a7", "M235.3 324.7C231.3 320.7 226.5 320 224 320s-7.299 .6547-11.33 4.698l-79.98 79.98C129.6 407.8 128 411.9 128 416c0 8.523 6.865 16 16 16c4.094 0 8.188-1.562 11.31-4.688L208 374.6V496c0 8.844 7.156 16 16 16s16-7.156 16-16v-121.4l52.69 52.69C295.8 430.4 299.9 432 304 432c9.139 0 16-7.477 16-16c0-4.094-1.562-8.188-4.688-11.31L235.3 324.7zM212.7 187.3C214.4 189 218.3 192 224 192s9.609-2.98 11.33-4.707l79.98-79.98C318.4 104.2 320 100.1 320 96c0-8.527-6.865-16-16-16c-4.094 0-8.188 1.562-11.31 4.688L240 137.4V16C240 7.156 232.8 0 224 0S208 7.156 208 16v121.4L155.3 84.69C152.2 81.56 148.1 80 144 80C134.9 80 128 87.47 128 96c0 4.094 1.562 8.188 4.688 11.31L212.7 187.3zM432 240h-416C7.156 240 0 247.1 0 255.1S7.156 272 16 272h416c8.844 0 16-7.165 16-16.01S440.8 240 432 240z"],
    "arrows-up-down": [256, 512, ["arrows-v"], "f07d", "M139.3 4.688l112 112C254.4 119.8 256 123.9 256 128s-1.562 8.188-4.688 11.31c-6.25 6.25-16.38 6.25-22.62 0L144 54.63v402.8l84.69-84.69c6.25-6.25 16.38-6.25 22.62 0C254.4 375.8 256 379.9 256 384s-1.562 8.188-4.688 11.31l-112 112c-6.25 6.25-16.38 6.25-22.62 0l-112-112c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0L112 457.4V54.63L27.31 139.3c-6.25 6.25-16.38 6.25-22.62 0s-6.25-16.38 0-22.62l112-112C122.9-1.562 133.1-1.562 139.3 4.688z"],
    "arrows-up-down-left-right": [512, 512, ["arrows"], "f047", "M512 255.1c0 4.094-1.562 8.222-4.688 11.35l-80 80C424.2 350.4 420.1 352 416 352c-9.139 0-16-7.473-16-16c0-4.094 1.562-8.188 4.688-11.31L457.4 272H272v185.4l52.69-52.69C327.8 401.6 331.9 400 336 400c9.139 0 16 7.473 16 16c0 4.094-1.562 8.188-4.688 11.31l-80 80C264.2 510.4 260.1 512 256 512s-8.188-1.562-11.31-4.688l-80-80C161.6 424.2 160 420.1 160 416c0-8.527 6.865-16 16-16c4.094 0 8.188 1.562 11.31 4.688L240 457.4V272H54.63l52.69 52.69C110.4 327.8 112 331.9 112 336C112 344.5 105.1 352 96 352c-4.094 0-8.188-1.562-11.31-4.688l-80-80C1.563 264.2 0 260.1 0 255.1s1.562-8.153 4.688-11.28l80-80C87.81 161.6 91.91 160 96 160c9.139 0 16 7.473 16 16c0 4.094-1.562 8.188-4.688 11.31L54.63 240H240V54.63L187.3 107.3C184.2 110.4 180.1 112 176 112C166.9 112 160 104.5 160 96c0-4.094 1.562-8.188 4.688-11.31l80-80C247.8 1.562 251.9 0 256 0s8.188 1.562 11.31 4.688l80 80C350.4 87.81 352 91.91 352 96c0 8.527-6.865 16-16 16c-4.094 0-8.188-1.562-11.31-4.688L272 54.63V240h185.4l-52.69-52.69C401.6 184.2 400 180.1 400 176C400 167.5 406.9 160 416 160c4.094 0 8.188 1.562 11.31 4.688l80 80C510.4 247.8 512 251.9 512 255.1z"],
    "asterisk": [448, 512, [10033, 61545], "2a", "M413.8 368.1C410.8 373.2 405.5 376 399.1 376c-2.766 0-5.562-.7187-8.125-2.219L240 284V464c0 8.844-7.156 16-15.1 16S208 472.8 208 464V284l-151.9 89.73C53.58 375.3 50.79 376 48.02 376c-5.469 0-10.8-2.812-13.8-7.859c-4.484-7.609-1.969-17.42 5.641-21.92L192.5 256L39.86 165.8c-7.609-4.5-10.12-14.31-5.641-21.92c4.531-7.578 14.31-10.06 21.92-5.641L208 227.1V48C208 39.16 215.2 32 224 32S240 39.16 240 48v179.1l151.9-89.73c7.641-4.422 17.42-1.938 21.92 5.641c4.484 7.609 1.969 17.42-5.641 21.92L255.5 256l152.7 90.22C415.7 350.7 418.3 360.5 413.8 368.1z"],
    "at": [512, 512, [129664, 61946], "40", "M259.7 16.03C116.5 13.94 2.766 140.5 17.25 283.1c11.96 117.8 102.2 205.2 221.5 212.8c9.275 .5957 17.18-6.739 17.18-16.04c0-8.395-6.552-15.39-14.92-15.92c-106.1-6.828-185.7-86.38-192.7-192.5c-7.852-119.6 82.95-220.8 202.6-223.4c118.1-2.607 212.1 89.77 212.1 208.2V278.7c0 26.43-17.55 50.57-43.34 56.27c-36.37 8.039-68.67-19.59-68.67-54.64v-120.1c0-8.846-7.168-16.02-16.01-16.02c-8.838 0-16.02 7.165-16.02 16.01v17.88c-24.95-25.56-61.83-39.39-101.6-31.85C173.5 154.7 137.8 190.7 129.8 235.6c-12.72 70.86 41.68 132.8 110.2 132.8c37.39 0 70.32-18.63 90.68-46.9c16.48 30.84 50.34 51.03 88.7 46.15c44.44-5.656 76.63-45.58 76.63-90.42V256.3C495.1 122.8 392.5 17.96 259.7 16.03zM239.9 336.3c-44.13 0-80.02-35.93-80.02-80.09S195.8 176.2 239.9 176.2s80.02 35.93 80.02 80.09S284.1 336.3 239.9 336.3z"],
    "atom": [512, 512, [62930], "269b", "M444.9 256c15.5-20.25 26.56-40.63 31.68-60c6-22.62 4-43.38-6-60.25c-18.25-30.5-60.38-42.88-113.5-38.38C333.9 37.75 297.6 0 256 0S178.1 37.75 155 97.38c-53.25-4.5-95.38 7.875-113.5 38.38C31.38 152.6 29.38 173.4 35.38 196C40.5 215.4 51.56 235.8 67.06 256C51.56 276.3 40.5 296.6 35.38 316c-6 22.62-4 43.38 6 60.25c15.88 26.5 49.63 39.5 93.13 39.5c6.375 0 13.5-1.25 20.25-1.75C177.1 473.9 214.3 512 256 512s77.1-38.13 101.3-97.1c6.75 .4997 13.88 1.75 20.25 1.75c43.5 0 77.25-13 93-39.5c10.12-16.88 12.12-37.63 6.125-60.25C471.5 296.6 460.4 276.3 444.9 256zM68.88 359.8c-5.5-9.25-6.375-21.25-2.625-35.5C69.1 310.5 77.88 295.9 88.63 281c13.5 13.88 28 26.62 43.25 38.38c2.625 21.62 6.875 43 12.62 64C106.8 385.3 79.13 376.9 68.88 359.8zM128.4 274.8C121.6 268.5 115.3 262.3 109.3 256c6-6.25 12.38-12.5 19.12-18.75C128.3 243.5 128 249.6 128 256S128.3 268.5 128.4 274.8zM131.9 192.5C116.6 204.3 102.1 217.1 88.63 231C77.88 216.1 69.1 201.4 66.25 187.8C62.5 173.5 63.38 161.5 68.88 152.3c9.25-15.5 32.75-24 65.25-24c3.25 0 6.875 .25 10.38 .375C138.8 149.6 134.5 171 131.9 192.5zM343.8 167c-8.375-5.25-16.88-10.5-25.88-15.5C311.5 147.9 305 144.6 298.6 141.4c12-3.625 24.25-6.5 36.5-8.875C337.1 142 341.9 157.4 343.8 167zM256 32c24.12 0 49.5 26 68.25 70C300.9 106.8 278.1 113.5 256 122.3C233.9 113.5 211.1 106.8 187.8 102C206.5 58 231.9 32 256 32zM176.9 132.5c12.25 2.375 24.5 5.25 36.5 8.875C207 144.6 200.5 148 194.1 151.5c-9 5-17.5 10.25-25.88 15.5C170.1 157.4 173.1 142 176.9 132.5zM168.3 345c8.375 5.25 16.88 10.5 25.88 15.5c6.75 3.75 13.38 6.5 20.12 9.875c-12.25 3.75-24.75 6.75-37.38 9.125C173.4 368.1 170.6 356.6 168.3 345zM256 480c-24.12 0-49.75-26.25-68.38-70.5C211 404.8 233.9 398 256 389.3c22.12 8.75 45 15.5 68.38 20.25C305.8 453.8 280.1 480 256 480zM335.1 379.5c-12.62-2.375-25-5.375-37.25-9.125c6.625-3.375 13.38-6.125 20-9.875c9-5 17.5-10.25 25.88-15.5C341.4 357.1 338.4 368.6 335.1 379.5zM349.9 302c-15.25 11.12-31.12 21.37-47.5 30.5c-15.12 8.375-30.5 16-46.38 22.62c-15.88-6.625-31.25-14.25-46.38-22.62c-16.38-9.125-32.25-19.38-47.5-30.38C160.8 287.4 160 272 160 256s.7443-31.38 2.119-45.1c15.25-11.13 31.12-21.38 47.5-30.5C224.8 171 240.1 163.5 256 156.8C271.9 163.5 287.3 171 302.4 179.5c16.38 9.125 32.25 19.38 47.5 30.38C351.3 224.6 351.1 240 351.1 256S351.3 287.4 349.9 302zM377.1 128.3c32.38 0 55.88 8.5 65.13 24c5.5 9.25 6.375 21.25 2.625 35.5c-3.75 13.62-11.62 28.38-22.38 43.25c-13.5-13.88-28-26.75-43.25-38.38c-2.625-21.62-6.875-43-12.62-63.88C371 128.5 374.6 128.3 377.1 128.3zM383.6 237.3C390.4 243.5 396.8 249.8 402.8 256c-6 6.25-12.38 12.5-19.12 18.75C383.8 268.5 384 262.4 384 256S383.8 243.5 383.6 237.3zM443.1 359.8c-10.25 17.12-37.88 25.5-75.63 23.62c5.75-21 10-42.38 12.62-64c15.25-11.62 29.75-24.5 43.25-38.38c10.75 14.88 18.62 29.5 22.38 43.25C449.5 338.5 448.6 350.5 443.1 359.8zM256 232C242.8 232 232 242.8 232 256S242.8 280 256 280S280 269.3 280 256S269.3 232 256 232z"],
    "atom-simple": [448, 512, ["atom-alt"], "f5d3", "M426.9 53.49c-26.75-26.63-73.37-28.63-131.4-5.377c-23.25 9.252-47.37 22.63-71.5 38.5c-24.12-15.88-48.25-29.25-71.37-38.5C94.51 24.87 47.88 26.87 21.13 53.49c-38.37 38.25-22.75 118 32.75 202.5c-55.5 84.5-71.12 164.3-32.75 202.5C35.51 472.9 55.63 480 80.13 480c21.12 0 45.62-5.375 72.5-16c23.12-9.25 47.25-22.75 71.37-38.63C248.1 441.3 272.3 454.8 295.5 464c26.75 10.62 51.13 16 72.37 16c24.5 0 44.62-7.125 58.1-21.5c38.38-38.25 22.75-118-32.87-202.5C449.6 171.5 465.2 91.74 426.9 53.49zM307.4 77.74c44.75-17.75 79.1-18.38 96.87-1.625c22.87 22.88 12.87 82.38-30 151.6c-17.38-23-36.37-44.63-56.87-65c-20.38-20.12-42.12-38.88-65.12-56C271 95.12 289.5 84.87 307.4 77.74zM43.76 76.12c8.25-8.125 20.62-12.12 36.5-12.12c16.75 0 37.37 4.625 60.37 13.75c17.88 7.125 36.5 17.38 55.12 29c-46.25 34.38-87.25 75.13-121.1 121C30.88 158.5 20.88 99.12 43.76 76.12zM140.6 434.3c-44.62 17.88-79.87 18.38-96.87 1.625c-22.88-22.88-12.88-82.38 29.1-151.6c17.38 23 36.38 44.63 56.87 65c20.38 20.12 42.13 38.88 65.12 56.13C177.1 416.9 158.5 427.1 140.6 434.3zM153.3 326.6c-22-21.88-42.25-45.5-60.37-70.63c18.12-25.12 38.37-48.75 60.37-70.63c21.88-21.88 45.62-42 70.75-60.13c25.12 18.12 48.75 38.25 70.75 60.13c22 21.88 42.25 45.5 60.37 70.63c-18.12 25.12-38.37 48.75-60.37 70.63c-21.1 21.88-45.62 42-70.75 60.13C198.9 368.6 175.3 348.5 153.3 326.6zM404.2 435.9c-16.88 16.75-52.25 16.25-96.87-1.625c-17.87-7.125-36.5-17.38-55.12-28.88c23-17.25 44.75-36 65.12-56.13c20.5-20.38 39.5-42 56.87-65C417.1 353.5 427.1 412.1 404.2 435.9zM224 232c-13.25 0-24 10.72-24 24.06C199.9 269.3 210.8 280 224 280c6.375 0 12.5-2.494 17-6.982S248 262.4 248 256.1C248 242.8 237.3 232 224 232z"],
    "audio-description": [576, 512, [], "f29e", "M206.3 168.8c-5.438-10.84-23.19-10.84-28.62 0l-80 160c-3.953 7.906-.75 17.52 7.156 21.47c7.922 3.906 17.5 .7344 21.47-7.156L145.9 304H238.1l19.58 39.16C260.5 348.8 266.1 352 272 352c2.406 0 4.844-.5469 7.141-1.688c7.906-3.953 11.11-13.56 7.156-21.47L206.3 168.8zM161.9 272L192 211.8L222.1 272H161.9zM384 160h-64c-8.844 0-16 7.156-16 16v160c0 8.844 7.156 16 16 16h64c52.94 0 96-43.06 96-96S436.9 160 384 160zM384 320h-48V192H384c35.3 0 64 28.7 64 64S419.3 320 384 320zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V416z"],
    "audio-description-slash": [640, 512, [], "e0a8", "M493.9 311.7c11.3-15.74 18.13-34.89 18.13-55.71c0-52.94-43.06-96-96-96L352 160c-8.844 0-16 7.156-16 16v11.07l32 25.26V192H416c35.3 0 64 28.7 64 64c0 13.34-4.119 25.71-11.12 35.98L493.9 311.7zM544 64c17.64 0 32 14.36 32 32v280.5l32 25.26l.0001-305.8c0-35.35-28.65-64-64-64L139.6 32l40.53 32H544zM180.4 227.4l-50.74 101.5c-3.953 7.906-.75 17.52 7.156 21.47c7.922 3.906 17.5 .7344 21.47-7.156L177.9 304H270.1l19.58 39.16C292.5 348.8 298.1 352 304 352c2.406 0 4.844-.5469 7.141-1.688c5.18-2.59 8.064-7.652 8.518-13.03L236.1 272H193.9l12.2-24.39L180.4 227.4zM96 448c-17.64 0-32-14.36-32-32V135.4L32 110.2l0 305.8c0 35.35 28.65 64 64 64L500.4 480l-40.53-32H96zM633.9 483.4l-608-480c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "austral-sign": [448, 512, [], "e0a9", "M432 320h-75.55l-27.08-64H432C440.8 256 448 248.8 448 240S440.8 224 432 224h-116.2l-77.1-182.2c-5-11.84-24.47-11.84-29.47 0L132.2 224H16C7.156 224 0 231.2 0 240S7.156 256 16 256h102.6l-27.08 64H16C7.156 320 0 327.2 0 336S7.156 352 16 352h62.01l-44.75 105.8c-3.438 8.141 .3594 17.53 8.5 20.97c8.047 3.406 17.52-.3438 20.97-8.5L112.8 352h222.5l50.02 118.2C387.8 476.3 393.8 480 400 480c2.078 0 4.203-.4062 6.234-1.266c8.141-3.438 11.94-12.83 8.5-20.97L369.1 352H432c8.844 0 16-7.156 16-16S440.8 320 432 320zM224 89.06L281.1 224H166.9L224 89.06zM126.3 320l27.08-64h141.3l27.08 64H126.3z"],
    "avocado": [512, 512, [], "e0aa", "M512 142.3c0-72.05-56.44-142.3-140.5-142.3c-39.21 0-78.71 15.73-108.1 45.17C232.4 76.31 192.1 97.3 150.6 108.9C115.4 118.6 .0005 170.8 .0005 306.7c0 113.8 92.76 205.3 205.1 205.3c52.37 0 104.7-20.04 144.7-60.13c67.65-67.87 42.56-130 115.1-203.7l4.357-4.371C498 215.8 512 179.1 512 142.3zM479.1 142.3c0 29.51-11.7 58.04-32.57 78.98l-4.357 4.371c-32.82 32.93-57.16 76.5-72.33 129.5C356.6 404.6 304.3 480 205.1 480c-75.36 0-173-60.5-173-173.3c0-80.95 55.22-147.2 127.1-166.9C287.8 104.5 283.4 32 371.5 32C439.4 32 479.1 89.86 479.1 142.3zM247 176c-68.1 0-134.9 65.3-134.9 135.4c0 59.15 44.98 88.59 88.34 88.59c.0313 0 0 0 0 0c69 0 134.9-65.3 134.9-135.4C335.3 205.4 290.4 176 247 176zM303.6 264.7c0 50.51-49.57 102.7-103.7 102.7c-43.79 0-56.09-33.89-56.09-56.1C143.8 260.2 194.8 208 247 208C281.5 208 303.6 231.7 303.6 264.7z"],
    "award": [384, 512, [], "f559", "M288 358.3c13.98-8.088 17.53-30.04 28.88-41.39c11.35-11.35 33.3-14.88 41.39-28.87c7.98-13.79 .1658-34.54 4.373-50.29C366.7 222.5 383.1 208.5 383.1 192c0-16.5-17.27-30.52-21.34-45.73c-4.207-15.75 3.612-36.5-4.365-50.29c-8.086-13.98-30.03-17.52-41.38-28.87c-11.35-11.35-14.89-33.3-28.87-41.39c-13.76-7.963-34.61-.1852-50.29-4.375C222.5 17.27 208.5 0 192 0C175.5 0 161.5 17.27 146.3 21.34C130.5 25.54 109.7 17.74 95.98 25.7C82 33.79 78.46 55.74 67.11 67.08C55.77 78.43 33.81 81.97 25.72 95.95C17.74 109.7 25.56 130.5 21.35 146.2C17.27 161.5 .0008 175.5 .0008 192c0 16.5 17.27 30.52 21.34 45.73c4.207 15.75-3.615 36.5 4.361 50.29C33.8 302 55.74 305.5 67.08 316.9c11.35 11.35 14.89 33.3 28.88 41.4c13.74 7.951 34.61 .1699 50.28 4.369C161.5 366.7 175.5 384 192 384c16.5 0 30.52-17.27 45.74-21.34C253.5 358.5 274.2 366.3 288 358.3zM191.1 351.5c-8.029-4.002-20.8-15.34-37.48-19.79c-16.71-4.477-33.04-1.301-42.29-1.717c-4.953-7.838-10.39-23.65-22.51-35.76c-12.11-12.12-27.85-17.5-35.77-22.52C53.59 262.5 56.7 246.1 52.26 229.5c-4.465-16.71-15.77-29.39-19.79-37.48c3.996-8.025 15.33-20.77 19.8-37.5c4.434-16.6 1.33-32.88 1.697-42.27c7.854-4.971 23.63-10.37 35.78-22.52C101.8 77.68 107.3 61.72 112.3 53.95C121.4 53.58 137.9 56.69 154.5 52.25c16.74-4.475 29.33-15.74 37.48-19.79c8.027 3.992 20.77 15.33 37.49 19.8c16.74 4.471 33.01 1.295 42.28 1.711c4.84 7.65 10.45 23.71 22.51 35.76c12.03 12.04 28 17.61 35.77 22.52c.3555 9.273-2.752 25.64 1.693 42.28c4.469 16.71 15.77 29.38 19.79 37.47c-3.977 8-15.32 20.78-19.8 37.5c-4.404 16.49-1.34 32.1-1.695 42.27c-7.857 4.969-23.64 10.38-35.78 22.52c-12.03 12.03-17.59 27.99-22.5 35.75c-9.195 .4141-25.54-2.775-42.28 1.703C212.8 336.2 200.1 347.5 191.1 351.5zM279.1 192c0-48.7-39.39-88-87.1-88S104 143.3 104 192c0 48.58 39.39 88 87.1 88S279.1 240.6 279.1 192zM192 248C161.1 248 136 222.9 136 192c0-30.88 25.12-56 55.1-56S247.1 161.1 247.1 192C247.1 222.9 222.9 248 192 248zM357.4 370.1c-3.25-8.219-12.58-12.2-20.76-8.984c-8.203 3.25-12.23 12.55-8.984 20.77l24.22 61.25l-47.48-6.562l-24.64 42.28l-24.92-61.2c-3.328-8.203-12.72-12.14-20.84-8.781c-8.188 3.328-12.12 12.66-8.781 20.84l24.9 61.19C255.2 503.4 266.6 511.4 281.4 512c12.83 0 24.38-7.125 30.12-18.59l10.42-20.64l21.51 4.312c12.12 2.547 24.69-1.906 32.67-11.5c7.953-9.547 10.03-22.66 5.453-34.22L357.4 370.1zM150 408.9c-8.139-3.375-17.53 .5938-20.84 8.781l-24.92 61.2l-24.64-42.28l-47.44 6.547l24.17-61.23c3.25-8.219-.7813-17.52-8.984-20.77C39.14 357.9 29.86 361.9 26.61 370.1l-24.22 61.25c-4.578 11.56-2.5 24.67 5.453 34.22c8.016 9.625 20.52 14 32.61 11.52l21.58-4.328l10.41 20.62c5.766 11.45 17.27 18.58 31.42 18.58c13.42-.5313 24.98-8.609 30.03-21.05l24.92-61.2C162.2 421.5 158.2 412.2 150 408.9z"],
    "award-simple": [384, 512, [], "e0ab", "M192 104C143.4 104 104 143.3 104 192c0 48.58 39.39 88 87.1 88S279.1 240.6 279.1 192C279.1 143.3 240.6 104 192 104zM192 248C161.1 248 136 222.9 136 192c0-30.88 25.12-56 55.1-56S247.1 161.1 247.1 192C247.1 222.9 222.9 248 192 248zM384 192c0-16.5-17.27-30.52-21.34-45.73c-4.207-15.75 3.608-36.5-4.369-50.29c-8.086-13.98-30.03-17.52-41.37-28.87c-11.35-11.35-14.88-33.29-28.87-41.39c-13.76-7.963-34.62-.1888-50.29-4.378C222.5 17.27 208.5 0 192 0C175.5 0 161.5 17.27 146.3 21.34C130.5 25.54 109.7 17.74 95.98 25.71C81.1 33.79 78.46 55.74 67.11 67.08C55.77 78.43 33.82 81.96 25.73 95.95C17.74 109.7 25.55 130.5 21.35 146.2C17.27 161.5 0 175.5 0 192c0 16.5 17.27 30.52 21.34 45.73c4.207 15.75-3.612 36.5 4.365 50.29C33.8 302 55.74 305.5 67.08 316.9c11.35 11.35 14.88 33.29 28.86 41.39c13.74 7.951 34.62 .1803 50.29 4.38C161.5 366.7 175.5 384 192 384c16.5 0 30.52-17.27 45.74-21.34c15.72-4.207 36.5 3.603 50.29-4.368c13.98-8.088 17.52-30.03 28.87-41.38c11.35-11.35 33.29-14.88 41.39-28.86c7.981-13.79 .1698-34.54 4.377-50.29C366.7 222.5 384 208.5 384 192zM331.7 229.5c-4.404 16.49-1.34 32.1-1.695 42.27c-7.858 4.969-23.64 10.38-35.78 22.52c-12.03 12.03-17.59 27.99-22.5 35.75c-9.195 .4141-25.54-2.775-42.28 1.703c-16.71 4.467-29.4 15.76-37.48 19.79c-8.029-4.002-20.8-15.34-37.48-19.79c-16.71-4.477-33.04-1.301-42.29-1.717C107.3 322.2 101.8 306.4 89.71 294.3C77.6 282.1 61.86 276.8 53.94 271.7C53.59 262.5 56.7 246.1 52.25 229.5c-4.465-16.71-15.77-29.39-19.8-37.48c3.996-8.025 15.33-20.77 19.8-37.5c4.434-16.6 1.33-32.88 1.697-42.27c7.854-4.971 23.64-10.37 35.78-22.52C101.8 77.68 107.3 61.72 112.2 53.95c9.194-.377 25.64 2.738 42.28-1.701c16.74-4.475 29.33-15.74 37.48-19.79c8.027 3.992 20.77 15.33 37.49 19.8c16.74 4.471 33.01 1.295 42.28 1.711c4.84 7.65 10.45 23.71 22.51 35.76c12.03 12.04 28 17.61 35.77 22.52c.3555 9.273-2.752 25.64 1.693 42.28c4.469 16.71 15.77 29.38 19.79 37.47C347.6 200 336.2 212.8 331.7 229.5zM303.7 399.7c-1.813-8.656-10.16-14.23-18.94-12.39c-8.625 1.797-14.19 10.27-12.38 18.92l17.47 73.84l-90.66-45.33c-4.5-2.25-9.813-2.25-14.31 0l-88.88 46.72l15.69-75.23c1.813-8.656-3.75-17.12-12.38-18.92c-8.688-1.844-17.16 3.734-18.94 12.39l-15.69 75.25c-2.438 11.64 1.938 23.38 11.34 30.62c9.438 7.234 21.84 8.438 32.5 3.125L192 466.1l83.5 41.75C279.9 510.9 284.6 512 289.3 512c6.625 0 13.16-2.172 18.69-6.406c9.406-7.25 13.78-18.98 11.34-30.64L303.7 399.7z"],
    "axe": [640, 512, [63154], "1fa93", "M65.1 480L32 446L255 223L232.4 200.4l-223 223c-12.5 12.5-12.5 32.88 0 45.38l33.88 33.88C49.5 508.9 57.75 512 65.1 512c8.125 0 16.38-3.125 22.63-9.375l223-223L289 257L65.1 480zM525.7 160L478.5 112.8l24.12-24.12c12.5-12.5 12.5-32.88 0-45.38l-33.88-33.88C462.5 3.125 454.3 0 445.1 0c-8.125 0-16.37 3.125-22.62 9.375L399.3 33.5l-24.13-24.12c-6.25-6.25-14.5-9.375-22.63-9.375c-8.25 0-16.38 3.125-22.63 9.375L233.4 105.9C220.9 118.4 220.9 138.6 233.4 151.1l150.6 150.6L384 416l31.1-.0032C539.7 416 640 315.8 640 192V160L525.7 160zM445.1 32L480 66l-24.12 24.12l-34-34L445.1 32zM416 384V288.5l-160-160L352.5 32l160 160H608C608 297.9 521.9 384 416 384z"],
    "axe-battle": [512, 512, [], "f6b3", "M101 13.61C99.03 5.105 92.19 0 85.06 0C81.31 0 77.38 1.479 74.25 4.729C28.63 50.85 0 117.6 0 192s28.62 141.1 74.25 187.3C77.38 382.5 81.31 384 85.06 384c7.125 0 13.97-5.105 15.97-13.61C114.4 314.8 156.3 272.9 208 265.5V233.3C117.1 246.1 85.63 318.5 78.63 335.5C48.75 295.9 32 244.9 32 192s16.75-103.9 46.63-143.5C85.63 65.5 117.1 137.9 208 150.8V118.5C156.3 111.1 114.4 69.23 101 13.61zM512 160.9c-6.75-61.75-35.13-116.6-74.25-156.1C434.6 1.5 430.8 0 427 0c-7.125 0-14 5.125-16 13.62C397.6 69.25 355.8 111.1 304 118.5v32.25c90.88-12.88 122.4-85.25 129.4-102.3c21.75 28.88 36.62 63.75 43 101.4L435.4 192l41 42.13c-6.375 37.63-21.25 72.5-43 101.5C426.4 318.5 394.9 246.1 304 233.3V265.5c51.75 7.375 93.63 49.25 107 104.9c2 8.5 8.727 13.63 15.85 13.63c3.75 0 7.773-1.502 10.9-4.752C476.9 339.8 505.3 284.9 512 223.1L480 192L512 160.9zM256 32c-8.836 0-16 7.161-16 15.1v448C240 504.8 247.2 512 256 512s16-7.164 16-15.1V48C272 39.16 264.8 32 256 32z"],
    "b": [320, 512, [98], "42", "M241.9 234.1C269.7 213.7 288 181.1 288 144C288 82.25 237.8 32 176 32h-160C7.156 32 0 39.16 0 48v416C0 472.8 7.156 480 16 480l176 .0098c70.58 0 128-57.42 128-128C320 299.1 287.7 253.6 241.9 234.1zM32 64h144C220.1 64 256 99.89 256 144S220.1 224 176 224H32V64zM192 448H32V256h160c52.94 0 96 43.06 96 96S244.9 448 192 448z"],
    "baby": [448, 512, [], "f77c", "M406.2 160.2c-17.5-25.25-52.13-32-77.88-14.5l-36.38 25c-32.88 22.66-87.05 33.63-135.8 0l-36.38-25c-25.75-17.5-60.38-10.75-77.88 14.5c-17.5 25.5-11 60.5 14.5 78l36.38 24.88c10.88 7.5 22.75 14.12 35.38 19.75v22.62l-54.25 56.25c-19.25 17.75-23.5 46.38-10 69.25l38.25 56.13C112.3 502.5 129.9 512 148.7 512c10 0 19.78-2.75 28.4-7.75c13-7.75 52.25-40.5 2-96.5l18.38-11.62c17.5 6.072 40.47 4.379 53.09 0l18.38 11.62c-50.25 56-11 88.75 2 96.5C279.5 509.3 289.3 512 299.3 512c18.75 0 36.33-9.5 46.58-24.88l38.25-56.13c13.5-22.88 9.25-51.5-10-69.25l-54.25-56.25V282.9c12.63-5.625 24.5-12.25 35.38-19.75l36.38-24.88C417.2 220.7 423.7 185.7 406.2 160.2zM169.3 443.7c6.625 11.5 2.875 26.13-8.5 33c-10.77 6.254-25.8 3.496-33-8.5l-36.5-53.5c-6-10.12-3.75-23.25 5.5-30.75l38.75-41.25c.75 .875 27.55 28.51 36.88 37.88l-29.38 27.62L169.3 443.7zM252 358.6c-13.07 13.07-43.34 12.75-56.09 0l-35.88-35.88V303.1h127.8v18.75L252 358.6zM351.2 383.1c9.25 7.5 11.5 20.62 5.5 30.75l-36.5 53.5c-7.262 12.1-22.32 14.7-33 8.5c-11.38-6.875-15.13-21.5-8.5-33l26.25-35.5l-29.38-27.62c9.328-9.361 36.13-37 36.88-37.88L351.2 383.1zM373.5 211.7l-36.38 25c-12.48 8.521-25.78 15.4-39.57 20.83c-5.889 2.318-9.678 8.094-9.678 14.42H160.1c0-6.33-3.789-12.11-9.68-14.42c-13.79-5.43-27.09-12.3-39.57-20.83l-36.38-25c-26.38-18.12 1.25-57.25 27.25-39.5l36.25 24.88c1.762 1.207 83.97 60.38 172.1 0l36.25-24.88C372.3 154.5 399.9 193.6 373.5 211.7zM224 159.1c44.21-.043 79.99-35.78 79.99-79.1c0-44.22-35.78-79.96-79.99-79.1C179.8 .043 144 35.77 144 79.1C144 124.2 179.8 159.1 224 159.1zM224 32c26.46 .043 47.92 21.52 47.92 47.99c0 26.47-21.46 47.95-47.92 47.99C197.5 127.9 176.1 106.5 176.1 79.99C176.1 53.52 197.5 32.04 224 32z"],
    "baby-carriage": [512, 512, ["carriage-baby"], "f77d", "M496 95.99l-32 .0196c-26.51 0-48 21.49-48 48v48h-135.3l-106.5-167.5c-8-12.62-21.12-21.25-36.25-23.75c-14.75-2.5-29.75 1.25-41.25 10.38C35.25 60.26 0 132 0 208V224c0 67.25 40.3 126.3 101.3 160.5C99.55 384.4 97.75 384 96 384c-40.18 0-71.91 37.36-62.25 79.11c5.338 23.07 24.08 41.81 47.15 47.15C122.6 519.9 160 488.2 160 448c0-18.12-7.625-34.24-19.62-45.99C166.3 410.9 194.4 415.1 224 415.1s57.74-4.975 83.62-13.98c-15.53 15.04-23.72 37.82-17.55 62.4c5.592 22.27 23.74 40.22 46.05 45.65C378.2 520.3 416 488.4 416 448c0-35.25-28.75-64-64-64c-1.75 0-3.528 .3935-5.278 .5185C407.7 350.3 448 291.2 448 223.1V144c0-8.801 7.199-16 16-16h32c8.801 0 16-7.22 16-16.02C512 103.2 504.8 95.99 496 95.99zM116.8 36.13c6-4.75 12.62-4.375 16-3.875c6.125 1 11.5 4.5 14.5 9.375l95.63 150.4H32.63C37.25 131.8 67.25 75.76 116.8 36.13zM96 480c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S113.6 480 96 480zM352 416c17.62 0 32 14.38 32 32s-14.38 32-32 32s-32-14.38-32-32S334.4 416 352 416zM224 384c-105.9 0-192-71.75-192-160h384C416 312.3 329.9 384 224 384z"],
    "backpack": [448, 512, [62932], "1f392", "M320 64h-16V48C304 21.5 282.5 0 256 0H192C165.5 0 144 21.5 144 48V64H128C57.25 64 0 121.2 0 192v256c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V192C448 121.2 390.8 64 320 64zM176 48C176 39.12 183.2 32 192 32h64c8.75 0 16 7.125 16 16V64h-96V48zM336 480h-224v-96h224V480zM336 352h-224v-32c0-17.62 14.38-32 32-32h160c17.62 0 32 14.38 32 32V352zM416 448c0 17.62-14.38 32-32 32h-16v-160c0-35.25-28.75-64-64-64h-160c-35.25 0-64 28.75-64 64v160H64c-17.62 0-32-14.38-32-32V192c0-53 43-96 96-96h192c53 0 96 43 96 96V448zM304 160H143.1C135.2 160 128 167.2 128 175.1C128 184.8 135.2 192 143.1 192h160C312.8 192 320 184.8 320 176C320 167.2 312.8 160 304 160z"],
    "backward": [512, 512, [61514], "23ea", "M481.4 64c-6.75 0-13.41 2.344-18.91 6.875l-152.6 125.3c-6.812 5.609-7.812 15.69-2.219 22.52c5.656 6.828 15.75 7.797 22.53 2.203L480 95.59v320.8l-149.8-125.3c-6.781-5.594-16.88-4.625-22.53 2.203c-5.594 6.828-4.594 16.91 2.219 22.52l152.6 125.3C467.1 445.7 474.6 448 481.4 448C497.5 448 512 434.6 512 415.1V96.03C512 77.44 497.5 64 481.4 64zM225.4 64C218.6 64 211.1 66.34 206.5 70.88L11.69 230.8C4.25 236.9 0 246.1 0 256s4.25 19.06 11.69 25.16l194.8 159.1C211.1 445.7 218.6 448 225.4 448c10.35 0 30.6-8.122 30.6-32.03v-319.9C255.1 72.12 235.7 64 225.4 64zM224 416.4L32.52 256L224 95.59V416.4z"],
    "backward-fast": [512, 512, [61513, "fast-backward"], "23ee", "M225.4 64C218.6 64 211.1 66.34 206.5 70.88L32 214.2V80C32 71.16 24.84 64 16 64S0 71.16 0 80v352C0 440.8 7.156 448 16 448S32 440.8 32 432V297.8l174.5 143.3C211.1 445.7 218.6 448 225.4 448C235.7 448 256 439.9 256 415.1V96.03C256 72.13 235.7 64 225.4 64zM224 416.4L32.52 256L224 95.59V416.4zM481.4 64c-6.75 0-13.41 2.344-18.91 6.875l-152.6 125.3c-6.812 5.609-7.812 15.69-2.219 22.52c5.656 6.828 15.75 7.797 22.53 2.203L480 95.59v320.8l-149.8-125.3c-6.781-5.594-16.88-4.625-22.53 2.203c-5.594 6.828-4.594 16.91 2.219 22.52l152.6 125.3C467.1 445.7 474.6 448 481.4 448C497.5 448 512 434.6 512 415.1V96.03C512 77.44 497.5 64 481.4 64z"],
    "backward-step": [320, 512, ["step-backward"], "f048", "M257.4 64c-6.75 0-13.41 2.344-18.91 6.875L64 214.2V80C64 71.16 56.84 64 48 64S32 71.16 32 80v352C32 440.8 39.16 448 48 448S64 440.8 64 432V297.8l174.5 143.3C243.1 445.7 250.6 448 257.4 448C267.7 448 288 439.9 288 415.1V96.03C288 72.13 267.7 64 257.4 64zM256 416.4L64.52 256L256 95.59V416.4z"],
    "bacon": [576, 512, [63461], "1f953", "M564.7 99.68l-77.83-86.8C479.4 4.459 469 0 458.5 0c-5.193 0-10.42 1.1-15.34 3.36l-92.75 42.99c-51.13 23.69-93.34 64.03-122.1 116.6L207.7 200.7c-27.11 49.56-66.8 87.5-114.8 109.8l-68.88 31.94c-11.86 5.486-20.28 16.52-23.09 30.23c-2.938 14.35 .9063 29.18 10.31 39.65l77.83 86.8C96.64 507.5 106.1 512 117.5 512c5.188 0 10.41-1.11 15.33-3.375l92.75-42.99c51.13-23.69 93.34-64.03 122.1-116.6l20.66-37.76c27.11-49.56 66.8-87.5 114.8-109.8l68.88-31.94c11.86-5.484 20.28-16.52 23.09-30.23C577.1 124.1 574.1 110.1 564.7 99.68zM35.08 390.9c-5.148-5.736-3.506-16.71 2.441-19.46l68.88-31.95c54.22-25.16 98.95-67.84 129.4-123.4l20.66-37.76c25.47-46.56 62.64-82.15 107.5-102.9l92.64-42.95c.1719-.0781 3.387-1.691 6.514 1.799l30.39 33.89L408.2 107.6c-52.66 24.41-96.13 65.91-125.7 119.1L261.9 265.4C235.6 313.4 197.2 350.2 150.7 371.7l-93.88 43.5L35.08 390.9zM538.5 140.5l-68.88 31.95c-54.22 25.16-98.95 67.84-129.4 123.4l-20.66 37.76c-25.47 46.56-62.64 82.15-107.5 102.9L119.4 479.6c-2.572 1.188-5.051-.2168-6.48-1.812l-33.74-37.62l84.99-39.39c52.7-24.42 96.19-65.92 125.8-120l20.66-37.75c26.28-48.03 64.7-84.8 111.1-106.3l94.08-43.63l25.12 28.02C546.1 126.8 544.4 137.8 538.5 140.5z"],
    "bacteria": [640, 512, [], "e059", "M208 128c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16s16-7.164 16-16C224 135.2 216.8 128 208 128zM128 200C114.7 200 104 210.7 104 224S114.7 248 128 248c13.25 0 24-10.75 24-24S141.3 200 128 200zM615.7 230.8l11.58-3.425c9.439-2.781 14.81-12.65 12-22.04c-3.041-10.21-13.57-14.52-22.14-11.95l-11.27 3.33c-8.088-15.15-20.68-27.55-36.4-35.43l2.888-11.06c2.469-9.477-3.248-19.15-12.77-21.62c-10.36-2.639-19.46 4.048-21.72 12.71l-2.865 10.97c-1.027-.0371-2.073-.2574-3.096-.2574c-16.64 0-32.32 5.173-45.66 13.89L477.6 157.1c-3.777-3.873-15.44-9.779-25.19-.3691c-7.062 6.822-7.225 18.04-.3711 25.07l9.14 9.373c-5.854 9.221-10.17 19.6-12.08 31.05c-.8887 5.328-2.244 10.49-3.801 15.56L436.2 233.5c-8.855-4.139-19.48-.4082-23.69 8.508c-4.186 8.854-.3599 19.42 8.546 23.58l8.797 4.115c-14.92 22.07-34.42 33.57-34.83 33.83l-3.922-8.855c-3.922-8.822-14.33-13.05-23.49-9.074c-9 3.959-13.08 14.42-9.115 23.39l4.041 9.127c-4.078 1.135-8.14 2.324-12.38 3.031c-12.6 2.098-23.91 7.092-33.76 13.9l-9.996-9.012C299.5 319.7 288.1 319.7 281.3 327.3c-6.611 7.262-6.055 18.47 1.24 25.04l9.713 8.756c-8.49 14.18-12.74 30.77-11.64 48.17l-11.86 3.512c-9.428 2.793-14.8 12.66-11.99 22.05c2.783 9.385 12.69 14.71 22.15 11.94l11.34-3.359c8.287 15.49 20.99 27.86 36.38 35.57l-2.839 10.85c-2.48 9.479 3.224 19.16 12.75 21.62c9.566 2.482 19.25-3.221 21.72-12.69l2.82-10.78c5.508 .1875 11.11-.1523 16.75-1.102c11.37-1.893 22.23-5.074 33.1-8.24l3.379 9.455c3.305 9.223 13.5 14.11 22.75 10.76c9.266-3.277 14.1-13.41 10.81-22.65l-3.498-9.792c15.41-6.654 30.08-14.46 43.95-23.57l6.321 8.429c5.891 7.838 17.05 9.443 24.93 3.602c7.885-5.863 9.496-16.97 3.617-24.82l-6.457-8.611c12.66-10.78 24.33-22.54 34.96-35.33l8.816 6.413c7.932 5.795 19.08 4.076 24.89-3.855c5.811-7.906 4.07-19-3.874-24.77l-8.885-6.465c8.893-13.88 16.54-28.52 22.99-43.91l10.47 3.59c9.334 3.188 19.44-1.719 22.64-10.99c3.213-9.258-1.739-19.35-11.04-22.53l-10.33-3.541c2.791-9.961 5.793-19.84 7.521-30.21C615.9 243.4 616.1 237 615.7 230.8zM583.3 244.5c-18 108-102.7 192.7-210.8 210.8c-2.855 .4805-5.754 .7246-8.617 .7246c-25.04 0-47.03-18.69-51.16-43.48c-2.285-13.7 .9043-27.47 8.977-38.77s20.06-18.78 33.77-21.06c64.21-10.71 114.5-61.04 125.3-125.3c4.195-25.18 25.72-43.46 51.18-43.46c25.96 0 39.44 17.62 42.42 21.79C582.4 217.1 585.6 230.8 583.3 244.5zM416 360c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24c13.25 0 24-10.75 24-24C440 370.7 429.3 360 416 360zM272.3 226.4c9-3.957 13.08-14.42 9.115-23.39L277.4 193.9c4.078-1.135 8.14-2.324 12.38-3.031c12.6-2.098 23.91-7.094 33.76-13.9l9.996 9.012c6.969 6.303 18.28 6.326 25.15-1.236c6.609-7.26 6.053-18.47-1.24-25.04l-9.713-8.756c8.49-14.18 12.74-30.77 11.64-48.18l11.86-3.511c9.428-2.793 14.8-12.66 11.99-22.05c-2.781-9.385-12.69-14.71-22.15-11.94l-11.34 3.357C341.5 53.13 328.8 40.76 313.4 33.05l2.838-10.85c2.482-9.477-3.223-19.16-12.74-21.62C293.9-1.901 284.2 3.801 281.8 13.27l-2.82 10.78C273.4 23.86 267.8 24.2 262.2 25.15C250.8 27.04 239.1 30.22 229.1 33.39L225.7 23.93c-3.305-9.225-13.5-14.11-22.75-10.76c-9.266 3.279-14.1 13.41-10.81 22.65l3.498 9.793C180.2 52.27 165.6 60.07 151.7 69.19L145.4 60.76C139.5 52.92 128.3 51.32 120.5 57.16C112.6 63.02 110.1 74.13 116.8 81.98l6.457 8.611c-12.66 10.78-24.33 22.54-34.96 35.33L79.52 119.5C71.59 113.7 60.44 115.4 54.63 123.4C48.82 131.3 50.56 142.4 58.51 148.1l8.885 6.465C58.5 168.5 50.86 183.1 44.41 198.5L33.93 194.9c-9.334-3.186-19.44 1.721-22.64 10.99C8.086 215.2 13.04 225.3 22.34 228.4l10.33 3.541C29.88 241.9 26.88 251.8 25.15 262.2C24.07 268.6 23.94 274.1 24.33 281.2L12.75 284.7C3.309 287.4-2.061 297.3 .7441 306.7c3.041 10.21 13.57 14.52 22.14 11.95l11.27-3.33c8.086 15.15 20.68 27.55 36.39 35.43l-2.887 11.06c-1.865 7.158 1.902 22.19 17.26 22.19c7.92 0 15.14-5.287 17.23-13.28l2.863-10.97c1.027 .0371 2.074 .2577 3.098 .2577c16.64 0 32.32-5.174 45.66-13.89l8.59 8.809c3.777 3.873 15.44 9.779 25.19 .3691c7.062-6.822 7.225-18.04 .3711-25.07l-9.14-9.373C184.6 311.6 188.9 301.3 190.9 289.8c.8887-5.332 2.244-10.5 3.801-15.56L203.8 278.5C212.6 282.6 223.2 278.9 227.4 269.1C231.6 261.1 227.8 250.6 218.9 246.4L210.1 242.3C225 220.2 244.5 208.7 244.9 208.5l3.922 8.856C252.8 226.2 263.3 230.3 272.3 226.4zM159.3 284.5c-4.193 25.19-25.72 43.46-51.18 43.46c-2.875 0-5.773-.2422-8.656-.7266c-13.7-2.279-25.69-9.758-33.76-21.06S54.43 281.2 56.71 267.5c18-108 102.7-192.7 210.8-210.7c42.96-7.229 58.13 32.87 59.78 42.75c2.283 13.7-.9043 27.47-8.977 38.77s-20.06 18.78-33.77 21.06C220.3 169.1 169.1 220.3 159.3 284.5z"],
    "bacterium": [576, 512, [], "e05a", "M544 100.3c-2.299-7.684-10.94-13.66-20.29-10.86l-22.39 6.625c-18.12-39.6-54.76-53.83-55.48-54.16l5.707-21.75C454.3 9.85 446.4 0 435.8 0c-7.27-.002-13.83 4.824-15.73 12.06l-5.557 21.27c-3.264-.3477-8.205-1.344-15.68-1.344c-4.568 0-10.08 .373-16.74 1.49c-16.67 2.773-32.86 6.854-48.72 11.67l-6.332-17.71c-3.062-8.504-12.45-12.84-20.75-9.809c-8.678 3.066-12.88 12.34-9.934 20.63l6.312 17.6C276.4 66.32 251.7 79.58 228.7 95.24L217.5 80.31C212.1 73.18 201.9 71.71 194.7 77.04c-7.273 5.369-8.58 15.5-3.295 22.57L202.6 114.6C180.9 132.2 161.3 152.2 143.9 174.1L128.5 162.9c-7.217-5.281-17.45-3.764-22.78 3.516C100.4 173.6 101.1 183.7 109.2 188.9l15.57 11.31C109.5 223.3 96.62 248 86.48 274.2L67.82 267.8C56.22 263.9 48.83 272.9 47.11 277.8c-2.908 8.404 1.539 17.56 10.08 20.5L76.11 304.8c-4.275 14.6-8.013 29.46-10.56 44.73c-2.016 12.07-1.476 23.87 .292 35.34l-22.21 6.566c-8.699 2.541-13.49 11.57-10.97 20.04c2.734 9.152 12.75 13.11 20.24 10.9l22.07-6.512c11.32 23.78 30.98 43.01 55.73 54.02l-5.752 21.92C122.2 502.3 130.4 512 140.5 512c7.201 0 14.11-4.916 16-12.06l5.527-21.12c4.791 .6152 9.479 1.193 14.21 1.193c23.07 0 44.85-7.467 63.08-19.93l14.1 14.45c3.426 3.514 14.51 8.586 23.05 .3242c6.441-6.199 6.602-16.41 .3242-22.81l-13.45-13.79c11.77-14.54 20.19-32.11 23.49-51.86c1.475-8.83 3.736-17.37 6.574-25.64l14.66 6.852c7.887 3.691 17.98 .0352 21.68-7.758c3.777-7.945 .3945-17.62-7.816-21.46l-14.67-6.855c14.55-24.65 35.3-45.05 60.4-58.95l6.613 14.95c3.521 7.869 13.35 11.71 21.53 8.26c8.316-3.695 11.87-13.25 8.301-21.29l-6.535-14.73c6.965-2.17 14.04-4.1 21.39-5.322c21.3-3.541 39.96-13.12 55.1-26.35l14.95 13.46c6.736 6.082 17.51 4.953 23.02-1.113c6.031-6.619 5.523-16.77-1.131-22.78l-15.83-14.26c13.91-22.06 20.46-48.82 16.17-76.54l21.85-6.455C541.7 117.9 546.6 108.1 544 100.3zM413.7 222.9c-80.29 13.36-145.1 78.13-158.5 158.3c-8.223 49.3-61.6 81.74-111.5 59.57c-17.58-7.82-31.73-21.5-39.83-38.52c-32.75-68.82 61.06-300.1 283.5-337.1c10.5-1.762 62.82-3.686 84.81 44.37C506.1 183.4 435.9 219.2 413.7 222.9zM192 272c-26.55 0-48.01 21.49-48.01 48s21.47 48 48.01 48s48.01-21.49 48.01-48S218.6 272 192 272zM192.2 336c-8.834 0-16.02-7.178-16.02-16S183.4 304 192.2 304S208.2 311.2 208.2 320S201.1 336 192.2 336zM272.3 184c-13.27 0-24.26 10.75-24.26 24S259.1 232 272.3 232c13.28 0 24.04-10.75 24.04-24S285.6 184 272.3 184z"],
    "badge": [512, 512, [], "f335", "M256 512c-35.5 0-68.12-19.38-85.5-49.63C138.4 471.1 101.5 463.5 75 437c-25.12-25.12-34.5-61.88-25.38-95.5C19.38 324.2 0 291.5 0 256s19.38-68.25 49.62-85.5C40.5 136.9 49.88 100.1 75 75s61.88-34.5 95.5-25.38C187.8 19.38 220.5 0 256 0s68.25 19.38 85.5 49.62c33.63-9.125 70.38 .25 95.5 25.38s34.5 61.88 25.38 95.5C492.6 187.8 512 220.5 512 256s-19.38 68.25-49.63 85.5c9.125 33.63-.25 70.38-25.38 95.5c-26.12 26.12-62.75 34.25-95.5 25.38C324.1 492.6 291.5 512 256 512zM187.8 420.9C191.2 430.5 203.9 480 256 480c51 0 63.75-47 68.25-59.13c32.63 14.88 61.25 22.37 90.13-6.5c36-36 11.87-78.25 6.5-90.13C430.5 320.8 480 308.1 480 256c0-51-47-63.75-59.13-68.25c4.375-9.625 30.38-53.5-6.5-90.13c-36-36-78.25-11.87-90.13-6.5C320.8 81.5 308.1 32 256 32C205 32 192.2 79 187.8 91.12C178.4 86.88 134.4 60.75 97.62 97.62C61.62 133.6 85.75 175.9 91.12 187.8C81.5 191.2 32 203.9 32 256c0 51 47 63.75 59.12 68.25c-4.375 9.625-30.37 53.5 6.5 90.13C126.4 443.1 155.1 435.8 187.8 420.9z"],
    "badge-check": [576, 512, [], "f336", "M543.8 256c0-35.5-19.21-68.25-49.46-85.5c9.125-33.63-.4117-70.38-25.54-95.5c-25.12-25.12-61.71-34.5-95.34-25.38C356.3 19.38 323.3 0 287.8 0S219.8 19.38 202.5 49.63C168.9 40.5 131.1 49.88 106.8 75S72.5 136.9 81.63 170.5C51.38 187.8 31.84 220.5 31.84 256s19.54 68.25 49.79 85.5C72.5 375.1 81.71 411.9 106.8 437c26.5 26.5 63.54 34.13 95.66 25.38C219.9 492.6 252.3 512 287.8 512s68.29-19.38 85.66-49.63c32.75 8.875 69.21 .75 95.34-25.38c25.12-25.12 34.66-61.88 25.54-95.5C524.6 324.3 543.8 291.5 543.8 256zM452.9 324.3c5.375 11.88 29.5 54.13-6.5 90.13c-28.88 28.88-57.5 21.38-90.13 6.5C351.8 433 339 480 288 480c-52.13 0-64.75-49.5-68.25-59.13c-32.63 14.88-61.38 22.25-90.13-6.5c-36.88-36.63-10.88-80.5-6.5-90.13C111 319.8 64 307 64 256c0-52.13 49.5-64.75 59.13-68.25c-5.375-11.88-29.5-54.13 6.5-90.13c36.75-36.88 80.75-10.75 90.13-6.5C224.3 79 237 32 288 32c52.13 0 64.75 49.5 68.25 59.13c11.88-5.375 54.13-29.5 90.13 6.5c36.88 36.63 10.88 80.5 6.5 90.13C465 192.3 512 205 512 256C512 308.1 462.5 320.8 452.9 324.3zM356.7 191.4L261.3 286.7L219.3 244.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l53.34 53.33c3.125 3.125 7.219 4.688 11.31 4.688s8.188-1.562 11.31-4.688l106.7-106.7c6.25-6.25 6.25-16.38 0-22.62S362.9 185.1 356.7 191.4z"],
    "badge-dollar": [576, 512, [], "f645", "M543.8 256c0-35.5-19.21-68.25-49.46-85.5c9.125-33.63-.4117-70.38-25.54-95.5c-25.12-25.12-61.71-34.5-95.34-25.38C356.3 19.38 323.3 0 287.8 0S219.8 19.38 202.5 49.63C168.9 40.5 131.1 49.88 106.8 75S72.5 136.9 81.63 170.5C51.38 187.8 31.84 220.5 31.84 256s19.54 68.25 49.79 85.5C72.5 375.1 81.71 411.9 106.8 437c26.5 26.5 63.54 34.13 95.66 25.38C219.9 492.6 252.3 512 287.8 512s68.29-19.38 85.66-49.63c32.75 8.875 69.21 .75 95.34-25.38c25.12-25.12 34.66-61.88 25.54-95.5C524.6 324.3 543.8 291.5 543.8 256zM452.9 324.3c5.375 11.88 29.5 54.13-6.5 90.13c-28.88 28.88-57.5 21.38-90.13 6.5C351.8 433 339 480 288 480c-52.13 0-64.75-49.5-68.25-59.13c-32.63 14.88-61.38 22.25-90.13-6.5c-36.88-36.63-10.88-80.5-6.5-90.13C111 319.8 64 307 64 256c0-52.13 49.5-64.75 59.13-68.25c-5.375-11.88-29.5-54.13 6.5-90.13c36.75-36.88 80.75-10.75 90.13-6.5C224.3 79 237 32 288 32c52.13 0 64.75 49.5 68.25 59.13c11.88-5.375 54.13-29.5 90.13 6.5c36.88 36.63 10.88 80.5 6.5 90.13C465 192.3 512 205 512 256C512 308.1 462.5 320.8 452.9 324.3zM292.1 240.5L284.9 238.5C250.8 228.1 246.3 222.4 248.5 210.2c3-16.64 28.03-20.52 51.47-17.05c6.562 .9687 14.53 3.047 25.06 6.516c8.375 2.766 17.47-1.812 20.19-10.2c2.781-8.391-1.781-17.44-10.19-20.2C322.7 165.3 312.4 162.7 304 161.5V144C304 135.2 296.8 128 288 128S272 135.2 272 144v16.8C242.3 164.3 221.4 180.1 216.1 204.5C208.6 250.4 254.3 263.2 276.3 269.3L283.7 271.4c38.22 10.41 46.41 16.08 43.81 30.38c-3 16.64-27.97 20.61-51.53 17.03c-7.811-1.118-13.43-2.699-38.91-11.28C228.8 304.6 219.7 309.2 216.8 317.6c-2.812 8.375 1.688 17.45 10.06 20.28C256.2 347.8 263.5 349.3 272 350.5V368c0 8.844 7.156 16 16 16s16-7.156 16-16v-16.8c29.72-3.51 50.59-19.29 55.03-43.72C367.5 261 322.1 248.7 292.1 240.5z"],
    "badge-percent": [576, 512, [], "f646", "M543.8 256c0-35.5-19.21-68.25-49.46-85.5c9.125-33.63-.4117-70.38-25.54-95.5c-25.12-25.12-61.71-34.5-95.34-25.38C356.3 19.38 323.3 0 287.8 0S219.8 19.38 202.5 49.63C168.9 40.5 131.1 49.88 106.8 75S72.5 136.9 81.63 170.5C51.38 187.8 31.84 220.5 31.84 256s19.54 68.25 49.79 85.5C72.5 375.1 81.71 411.9 106.8 437c26.5 26.5 63.54 34.13 95.66 25.38C219.9 492.6 252.3 512 287.8 512s68.29-19.38 85.66-49.63c32.75 8.875 69.21 .75 95.34-25.38c25.12-25.12 34.66-61.88 25.54-95.5C524.6 324.3 543.8 291.5 543.8 256zM452.9 324.3c5.375 11.88 29.5 54.13-6.5 90.13c-28.88 28.88-57.5 21.38-90.13 6.5C351.8 433 339 480 288 480c-52.13 0-64.75-49.5-68.25-59.13c-32.63 14.88-61.38 22.25-90.13-6.5c-36.88-36.63-10.88-80.5-6.5-90.13C111 319.8 64 307 64 256c0-52.13 49.5-64.75 59.13-68.25c-5.375-11.88-29.5-54.13 6.5-90.13c36.75-36.88 80.75-10.75 90.13-6.5C224.3 79 237 32 288 32c52.13 0 64.75 49.5 68.25 59.13c11.88-5.375 54.13-29.5 90.13 6.5c36.88 36.63 10.88 80.5 6.5 90.13C465 192.3 512 205 512 256C512 308.1 462.5 320.8 452.9 324.3zM356.7 164.7l-160 160c-6.25 6.25-6.25 16.38 0 22.62C199.8 350.4 203.9 352 208 352s8.188-1.562 11.31-4.688l160-160c6.25-6.25 6.25-16.38 0-22.62S362.9 158.4 356.7 164.7zM224 216c13.26 0 24-10.75 24-24S237.3 168 224 168C210.7 168 200 178.7 200 192S210.7 216 224 216zM352 296c-13.25 0-24 10.75-24 24s10.75 24 24 24c13.26 0 24-10.75 24-24S365.3 296 352 296z"],
    "badge-sheriff": [512, 512, [], "f8a2", "M420.3 283.7c-.748 0-1.5 .0176-2.256 .0488L401.3 256l16.67-27.78c.7559 .0332 1.508 .0488 2.256 .0488c34.11 0 61.87-27.75 61.87-61.87s-27.75-61.87-61.87-61.87c-21.78 0-41.71 11.61-52.76 29.87h-39.13l-22.08-36.79c7.451-10.39 11.56-22.86 11.56-35.74C317.9 27.75 290.1 0 256 0S194.1 27.75 194.1 61.87c0 12.88 4.109 25.35 11.56 35.74L183.6 134.4H144.5C133.4 116.1 113.5 104.5 91.73 104.5c-34.12 0-61.87 27.75-61.87 61.87s27.75 61.87 61.87 61.87c.7461 0 1.498-.0156 2.254-.0488L110.7 256L93.99 283.8C93.23 283.8 92.48 283.7 91.73 283.7c-34.12 0-61.87 27.75-61.87 61.87s27.75 61.87 61.87 61.87c21.78 0 41.71-11.62 52.76-29.87h39.13l22.08 36.79c-7.453 10.39-11.56 22.86-11.56 35.74C194.1 484.2 221.9 512 256 512s61.87-27.75 61.87-61.87c0-12.88-4.107-25.35-11.56-35.74l22.08-36.79h39.13c11.05 18.25 30.98 29.87 52.76 29.87c34.11 0 61.87-27.75 61.87-61.87S454.4 283.7 420.3 283.7zM420.3 375.5c-10.26 0-19.99-5.535-25.38-14.44l-9.34-15.42h-75.28l-42.21 70.36l12.25 17.09c3.639 5.074 5.562 10.98 5.562 17.09C285.9 466.6 272.5 480 256 480s-29.87-13.4-29.87-29.87c0-6.104 1.924-12.01 5.564-17.09l12.25-17.09l-42.22-70.36h-75.28l-9.34 15.43c-5.393 8.908-15.12 14.44-25.38 14.44c-16.47 0-29.87-13.4-29.87-29.87c0-16.46 13.38-29.85 30.77-29.85l19.02 .7793L147.1 256L121.4 211.8L110.8 195.4L91.73 196.3c-16.47 0-29.87-13.4-29.87-29.87c0-16.47 13.4-29.87 29.87-29.87c10.26 0 19.99 5.533 25.38 14.44l9.34 15.43h75.28l42.22-70.36L231.7 78.96C228.1 73.88 226.1 67.97 226.1 61.87C226.1 45.4 239.5 32 256 32s29.87 13.4 29.87 29.87c0 6.105-1.924 12.02-5.562 17.09l-12.25 17.08l42.21 70.36h75.28L394.9 150.1c5.391-8.906 15.12-14.44 25.38-14.44c16.47 0 29.87 13.4 29.87 29.87c0 16.46-13.38 29.85-30.68 29.85l-19.08-.8398L364 256l26.55 44.25l10.72 16.27l18.98-.7793c16.47 0 29.87 13.4 29.87 29.87S436.7 375.5 420.3 375.5zM256 184C216.3 184 184 216.3 184 256s32.3 72 72 72S328 295.7 328 256S295.7 184 256 184zM256 296C233.9 296 216 278.1 216 256c0-22.06 17.94-40 40-40S296 233.9 296 256C296 278.1 278.1 296 256 296z"],
    "badger-honey": [640, 512, [63156], "1f9a1", "M622.3 142.5L619.5 140.1c-20.62-11.25-40.59-24.05-59.56-37.9c-59.03-43.12-93.54-39.07-94.44-39.07c-19.12 0-38.13 5.255-55.5 15.26c-17.12 9.75-36 16.75-54.1 16.75H128c-70.69 0-128 57.32-128 128v15.95c0 8.875 7.125 16 16 16h20c2.625 11.25 9.875 46.61 54.13 79.74l-23.75 52.38c-3.125 7.625-3.125 16.13-.125 23.75l25.25 58.01C93.88 476 99.88 480 106.4 480H158.3c23.29 0 38.78-24.08 29.12-45.27l-12.18-26.74l33-56.01h73.63l20.55 102.3C305.4 469.2 318.6 480 333.8 480h46.63c20.19 0 35.33-18.46 31.38-38.26l-23.06-115.8c45.25-30.5 101.2-61.14 152.4-75.64L560 287.1l22.74-45.54C636.1 238.1 640 178.5 640 175.3C640 161.3 633.1 148.7 622.3 142.5zM128 128.1h227c22.75 0 46.63-7.125 70.1-21.12C438.4 99.86 452 96.11 465.5 96.11c3.875 0 26.38-1.627 70.5 29.25c4.875 3.375 10.12 7 15.62 10.75H460c-30.88 0-60.25 9.627-91.5 20.88L267.8 202.9C258.1 206.2 247.9 208.1 237.5 208.1H192c-45.13 0-78.88-41.13-79.88-78.38C117.4 128.9 122.6 128.1 128 128.1zM353.1 311.2l27.38 136.8h-46.75L308.1 319.1H189.9l-50.63 86.13l19 41.88h-41L96 400.2l33.13-75.38L109.3 310.1c-20.12-15.12-34.88-30.62-42-61.38L61.38 224.1H32c0-36 20.12-67 49.38-83.38C88.13 194.9 136.6 240.1 192 240.1l45.47-.0433c14.12 0 28.03-2.399 42.28-7.524L380.5 186.6c27.25-9.752 53.75-18.5 79.5-18.5h20.38C477.8 171.5 476 175.5 476 180.1c0 11 9 20 20 20s20-9 20-20c0-4.625-1.75-8.625-4.375-12h90.88C605.1 170.1 608 170.6 608 174.1C602.8 248.7 586.6 154.2 353.1 311.2z"],
    "badminton": [640, 512, [], "e33a", "M623.2 490.9l-8.979-26.94h-33.75l12.35 37.07c2.25 6.688 8.5 10.94 15.19 10.94c8.98 0 16-7.32 16-16.02C624 494.3 623.7 492.6 623.2 490.9zM511.1 399.1l-.0023 48.03h96l.0027-48.03c0-26.51-21.49-48.01-48-48.01S511.1 373.5 511.1 399.1zM575.1 399.1v16h-32v-16c0-8.822 7.178-16 16-16S575.1 391.2 575.1 399.1zM576 151.4C576 74.02 519.3 0 417.1 0c-92.11 0-225.1 81.34-225.1 217c0 33.22 9.797 64.11 28.62 89.83l-80.06 62.9l-2.926-3.66c-6.209-7.852-15.38-12.07-24.7-12.07c-7.26 0-14.46 2.328-20.27 6.941l-74.56 59.47C6.191 429.9 0 443.9 0 458c0 10.5 3.418 21.07 10.47 29.9l4.75 5.969c15.17 19.03 36.68 18.09 37.66 18.09c10.81 0 21.22-3.625 29.81-10.47l74.56-59.44c.5117-.4082 12.06-8.791 12.06-25.15c0-7.201-2.418-14.13-6.963-19.85l-1.842-2.305l81.77-64.24c42.87 37.45 93.6 38.24 107.7 38.24C445.6 368.8 576 285.3 576 151.4zM62.75 476.5c-2.967 2.363-6.803 3.469-10.34 3.469c-.3223 0-7.146 .2324-12.19-6.031l-4.752-5.969c-2.348-2.945-3.488-6.473-3.488-9.977c0-4.705 2.061-9.369 6.021-12.52l74.56-59.44l24.75 31L62.75 476.5zM350 336.8c-46.95 0-126.1-27.61-126.1-119.6C223.1 94.81 346.7 32 417.1 32h2.062c74.67 .9648 123.1 52.39 123.1 119.6C544 259.8 436.7 336.8 350 336.8zM544 495.1c0 8.844 7.153 16 15.1 16s16-7.159 16-16l-.0029-32h-32L544 495.1zM496.8 490.9c-.5547 1.672-.8185 3.371-.8185 5.043c0 8.688 7.01 16.02 16 16.02c6.688 0 12.94-4.251 15.19-10.94l12.35-37.07h-33.75L496.8 490.9z"],
    "bag-shopping": [448, 512, ["shopping-bag"], "f290", "M416 128h-96l.001-32c0-52.94-43.06-96-95.1-96C171.1 0 128 43.06 128 96v32H32C14.33 128 0 142.3 0 160v256c0 53.02 42.98 96 96 96h256c53.02 0 96-42.98 96-96V160C448 142.3 433.7 128 416 128zM160 96c0-35.3 28.7-64 64-64c35.29 0 63.1 28.7 63.1 64v32H160V96zM416 416c0 35.29-28.71 64-64 64H96c-35.29 0-64-28.71-64-64V160h96v80C128 248.8 135.2 256 144 256S160 248.8 160 240V160h127.1v80c0 8.844 7.156 16 16 16s16-7.156 16-16L319.1 160H416V416z"],
    "bags-shopping": [576, 512, [63559], "1f6cd", "M528 256h-288c-26.47 0-48 21.53-48 48v160C192 490.5 213.5 512 240 512h288c26.47 0 48-21.53 48-47.1v-160C576 277.5 554.5 256 528 256zM544 464c0 8.828-7.172 16-16 16h-288C231.2 480 224 472.8 224 464v-160C224 295.2 231.2 288 240 288h288C536.8 288 544 295.2 544 304V464zM144 448h-96C39.17 448 32 440.8 32 432v-224C32 199.2 39.17 192 48 192h352C408.8 192 416 199.2 416 208C416 216.8 423.2 224 432 224S448 216.8 448 208c0-26.47-21.53-48-48-48L320 160V96c0-52.94-43.06-96-96-96S128 43.06 128 96v64L48 160c-26.47 0-48 21.53-48 48v224c0 26.47 21.53 48 48 48L144 480C152.8 480 160 472.8 160 464S152.8 448 144 448zM160 96c0-35.3 28.7-64 64-64s64 28.7 64 64v64H160V96zM464 320c-8.844 0-16 7.155-16 15.1v15.1C448 387.3 419.3 416 384 416s-64-28.7-64-64v-16c0-8.844-7.156-16-16-16S288 327.2 288 336V352c0 52.94 43.06 96 96 96s96-43.07 96-96v-15.1C480 327.2 472.8 320 464 320z"],
    "bahai": [512, 512, [], "f666", "M511.5 217.2c-2.547-14.44-13.52-25.11-27.94-27.17l-82.93-11.59l31.65-78.91c5.422-13.59 1.5-28.97-9.75-38.28c-11.22-9.25-26.4-10.19-38.67-2.359l-70.61 44.98l-25.67-80.63C283 9.109 270.7 0 255.1 0S228.1 9.109 224.5 23.22L198.8 103.8l-70.65-45c-12.28-7.797-27.48-6.812-38.72 2.5C78.07 70.78 74.28 85.75 79.78 99.53l31.64 78.88L28.48 190C14.11 192.1 3.154 202.7 .5605 217.1c-2.609 14.5 4.031 28.39 17 35.44l74.09 39.73l-56.36 63.17c-8.875 10.02-10.98 23.81-5.5 35.98c5.375 11.97 17.16 19.69 30.02 19.69c2.125 0 4.484-.3125 7.139-.8281L148.7 392.5l-3.109 84.77c-.3906 9.219 2.828 17.88 9.076 24.41c13.31 13.91 37.95 13.09 50.2-2.734l51.19-66.78l51.19 66.64C313.5 507.2 322.1 512 333.2 512c9.062 0 17.86-3.766 24.14-10.33c6.25-6.531 9.467-15.19 9.078-24.28l-3.016-84.89l81.62 17.77c14.25 3.109 28.19-3.078 35.54-15.73c7.344-12.59 5.75-28.33-3.922-39.16l-56.34-63.14l74.09-39.83C507.3 245.5 514 231.7 511.5 217.2zM387.3 273.7c-9.211 4.973-11.16 17.14-4.359 24.75l68.9 80.58l-101.7-22.14c-10.22-2.23-19.78 5.824-19.39 16.2l1.953 106.4l-63.1-83.33c-6.43-8.352-19.01-8.307-25.39 .0156l-65.78 82.41l3.875-105.5c.377-9.986-8.607-18.42-19.39-16.23l-102.8 19.84L129.1 298.4c6.902-7.729 4.717-19.88-4.375-24.75L32.01 224l104.1-16.73c10.3-1.42 16.5-12.21 12.62-21.8l-37.73-99.61l88.14 56.14c8.695 5.58 20.61 1.472 23.84-8.641l34.08-100.4l31.98 100.4c3.254 10.16 15.19 14.19 23.84 8.641l89.67-54.38L363.3 185.5c-3.9 9.65 2.395 20.39 12.62 21.8L479.1 224L387.3 273.7z"],
    "baht-sign": [320, 512, [], "e0ac", "M252.9 233.6C274.2 215.9 288 189.7 288 160c0-52.94-43.06-96-96-96h-32V16C160 7.156 152.8 0 144 0S128 7.156 128 16V64H16C7.156 64 0 71.16 0 80v352C0 440.8 7.156 448 16 448H128v48C128 504.8 135.2 512 144 512s16-7.156 16-16V448h48c61.75 0 112-50.25 112-112C320 290.2 292.3 250.9 252.9 233.6zM192 96c35.28 0 64 28.72 64 64s-28.72 64-64 64h-32V96H192zM32 96h96v128H32V96zM32 416V256h96v160H32zM208 416H160V256h48c44.13 0 80 35.88 80 80S252.1 416 208 416z"],
    "ball-pile": [576, 512, [], "f77e", "M480 320c-10.41 0-20.3 2.081-29.68 5.174C468.5 307.7 480 283.3 480 256c0-53-43-96-96-96c-10.41 0-20.3 2.081-29.68 5.174C372.6 147.7 384 123.2 384 96c0-53-43-96-96-96S192 43 192 96c0 27.19 11.4 51.67 29.68 69.17C212.3 162.1 202.5 160 192 160C139 160 96 203 96 256c0 27.19 11.4 51.67 29.68 69.17C116.3 322.1 106.5 320 96 320c-53 0-96 43-96 96s43 96 96 96s96-43 96-96c0-27.19-11.4-51.67-29.68-69.17C171.7 349.9 181.5 352 192 352s20.3-2.081 29.68-5.174C203.4 364.3 192 388.8 192 416c0 53 43 96 96 96s96-43 96-96c0-27.19-11.4-51.67-29.68-69.17C363.7 349.9 373.5 352 384 352s20.3-2.081 29.68-5.174C395.4 364.3 384 388.8 384 416c0 53 43 96 96 96s96-43 96-96S533 320 480 320zM288 32c35.31 0 64 28.69 64 64s-28.69 64-64 64S224 131.3 224 96S252.7 32 288 32zM317.7 325.2C308.3 322.1 298.4 320 288 320s-20.3 2.081-29.68 5.174C276.5 307.7 288 283.3 288 256S276.6 204.3 258.3 186.8C267.7 189.9 277.5 192 288 192s20.3-2.081 29.68-5.174C299.4 204.3 288 228.8 288 256S299.4 307.7 317.7 325.2zM96 480c-35.31 0-64-28.69-64-64s28.69-64 64-64s64 28.69 64 64S131.3 480 96 480zM192 320c-35.31 0-64-28.69-64-64s28.69-64 64-64s64 28.69 64 64S227.3 320 192 320zM288 480c-35.31 0-64-28.69-64-64s28.69-64 64-64s64 28.69 64 64S323.3 480 288 480zM384 320c-35.31 0-64-28.69-64-64s28.69-64 64-64s64 28.69 64 64S419.3 320 384 320zM480 480c-35.31 0-64-28.69-64-64s28.69-64 64-64s64 28.69 64 64S515.3 480 480 480z"],
    "balloon": [384, 512, [], "e2e3", "M176 80c-52.94 0-96 43.06-96 96C80 184.8 87.16 192 96 192s16-7.156 16-16c0-35.28 28.72-64 64-64C184.8 112 192 104.8 192 96S184.8 80 176 80zM384 187.4C384 84.09 297.9 0 192 0S0 84.09 0 187.4c0 81.31 98.06 189.1 157.2 228.8l-42.9 71.49c-2.969 4.938-3.031 11.09-.2187 16.09C116.9 508.9 122.3 512 128 512h128c5.75 0 11.09-3.094 13.94-8.125c2.812-5 2.75-11.16-.2187-16.09l-42.9-71.49C285.9 376.5 384 268.7 384 187.4zM227.8 480h-71.5l28.8-48h13.9L227.8 480zM192.6 400C169.7 396.2 32 272.9 32 187.4C32 101.7 103.8 32 192 32s160 69.72 160 155.4C352 272.9 214.4 396.2 192.6 400z"],
    "balloons": [640, 512, [], "e2e4", "M160 80C115.9 80 80 115.9 80 160c0 8.844 7.156 16 16 16S112 168.8 112 160c0-26.47 21.53-48 48-48c8.844 0 16-7.156 16-16S168.8 80 160 80zM160 0C71.78 0 0 74.84 0 166.8c0 69.53 76.04 164.7 126.8 201.5l-35.69 54.92c-3.219 4.906-3.469 11.19-.6562 16.34S98.66 448 104.5 448h110.9c5.875 0 11.25-3.219 14.06-8.375s2.562-11.44-.6562-16.34l-35.69-54.92C243.1 331.5 320 236.4 320 166.8C320 74.84 248.2 0 160 0zM133.1 416l20.8-32h10.4l20.8 32H133.1zM161.4 352H161C139.3 346.2 32 239.5 32 166.8C32 92.5 89.41 32 160 32s128 60.5 128 134.8C288 239.5 180.7 346.2 161.4 352zM432 224c0-26.47 21.53-48 48-48c8.844 0 16-7.156 16-16S488.8 144 480 144c-44.13 0-80 35.88-80 80c0 8.844 7.156 16 16 16S432 232.8 432 224zM640 230.8C640 138.8 568.2 64 480 64c-39.56 0-77.53 15.19-106.9 42.72c-6.438 6.062-6.781 16.19-.75 22.62c6.094 6.531 16.19 6.75 22.62 .75C418.4 108.1 448.6 96 480 96c70.59 0 128 60.5 128 134.8C608 303.4 500.9 410 481.5 416h-.5098c-14.75-3.977-84.6-66.21-115.9-134.7c-3.688-8.062-13.28-11.5-21.22-7.906C335.9 277.1 332.3 286.6 336 294.7c23.8 52.07 74.26 109.1 111.1 137.3l-35.94 55.3c-3.219 4.906-3.469 11.19-.6562 16.34S418.7 512 424.5 512h110.9c5.875 0 11.25-3.219 14.06-8.375s2.562-11.44-.6562-16.34l-35.69-54.92C563.1 395.5 640 300.4 640 230.8zM453.1 480l20.8-32h10.4l20.8 32H453.1z"],
    "ballot": [448, 512, [], "f732", "M96 232C82.75 232 72 242.7 72 256c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 242.7 109.3 232 96 232zM96 360c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 370.7 109.3 360 96 360zM96 104C82.75 104 72 114.7 72 128c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 114.7 109.3 104 96 104zM384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM416 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V448zM352 368H176C167.2 368 160 375.2 160 384s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 368 352 368zM352 112H176C167.2 112 160 119.2 160 128s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 112 352 112zM352 240H176C167.2 240 160 247.2 160 256s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 240 352 240z"],
    "ballot-check": [448, 512, [], "f733", "M96 360c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 370.7 109.3 360 96 360zM352 368H176C167.2 368 160 375.2 160 384s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 368 352 368zM101.3 288c4.094 0 8.188-1.562 11.31-4.688l58.67-58.67c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L101.3 249.4L83.31 231.4c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l29.33 29.33C93.14 286.4 97.23 288 101.3 288zM96 152c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24C82.75 104 72 114.7 72 128C72 141.3 82.75 152 96 152zM352 240H208C199.2 240 192 247.2 192 256s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 240 352 240zM384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM416 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V448zM352 112H176C167.2 112 160 119.2 160 128s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 112 352 112z"],
    "ban": [512, 512, [61534, "cancel"], "1f6ab", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM32 256c0-56.01 20.81-107.2 54.91-146.5l315.6 315.6C363.2 459.2 312 480 256 480C132.5 480 32 379.5 32 256zM425.1 402.5L109.5 86.91C148.8 52.81 199.1 32 256 32c123.5 0 224 100.5 224 224C480 312 459.2 363.2 425.1 402.5z"],
    "ban-bug": [512, 512, ["debug"], "f7f9", "M130.3 311.9l45.88-6.625c.125 6.75 1.25 13.5 3.125 20l-44.13 29.5c-7.375 4.875-9.375 14.75-4.375 22.12C134.1 382 143.5 387.5 152.9 381.3l41.12-27.38C208.6 372.1 230.8 384 256 384c16.38 0 32.25-5.125 45.63-14.5l-23.25-23.25C271.5 350 263.8 352 256 352c-26.5 0-48-21.5-48-48V275.9l-32-32V273L125.8 280.1c-9.223 1.355-14.85 10.06-13.62 18.12C114.1 311.9 127.5 312.3 130.3 311.9zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224c0-55.98 20.78-107.1 54.85-146.4l315.6 315.6C363.1 459.2 311.1 480 256 480zM211.9 189.3c8.875-21 31.38-32.75 53.75-28.25C287.9 165.5 304 185.3 304 208v73.38L211.9 189.3zM425.1 402.4L335.1 312.5c.375-2.375 .625-4.75 .75-7.25l45.88 6.625c2.75 .375 16.12 0 18.12-13.62c1.246-8.219-4.514-16.79-13.62-18.12L336 273V246.8l50.25-6.909C392 239.1 396.9 235.4 399 230s1.25-11.5-2.25-16c-3.625-4.5-9.25-6.75-15-5.875L336 214.8c0-17.38-1.375-21.5-3.25-28l44.13-29.5c7.375-4.875 9.375-14.75 4.375-22.12c-4.875-7.375-14.75-9.375-22.12-4.5L317.1 158C303.4 139.9 281.3 128 256 128C227.4 128 202.6 143.3 188.5 165.9L109.6 86.86C148.9 52.79 200 32 256 32c123.5 0 224 100.5 224 224C480 311.1 459.2 363.1 425.1 402.4z"],
    "ban-parking": [512, 512, ["parking-circle-slash"], "f616", "M192 384c8.844 0 16-7.156 16-16V320h44.13l-32-32H208V275.9l-32-32V368C176 376.8 183.2 384 192 384zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224c0-56.01 20.81-107.2 54.91-146.5l315.6 315.6C363.2 459.2 312 480 256 480zM208 185.4V160H288c35.28 0 64 28.72 64 64c0 28.51-18.87 52.44-44.68 60.69L208 185.4zM425.1 402.5l-93.49-93.49C362.6 293.2 384 261.2 384 224c0-52.94-43.06-96-96-96H208C192.3 128 179.8 139.6 177.1 154.5L109.5 86.91C148.8 52.81 199.1 32 256 32c123.5 0 224 100.5 224 224C480 312 459.2 363.2 425.1 402.5z"],
    "ban-smoking": [512, 512, [62797, "smoking-ban"], "1f6ad", "M256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256S397.2 0 256 0zM256 480c-123.5 0-224-100.5-224-224c0-56 20.81-107.1 54.91-146.5L201.4 224H128C110.3 224 96 238.3 96 256v32c0 17.66 14.34 32 32 32h169.4l105.1 105.1C363.1 459.2 312 480 256 480zM233.4 256l32 32H128V256H233.4zM425.1 402.5L341.5 318.9C347.6 316.6 352 310.9 352 304C352 295.2 344.8 288 336 288h-25.38l-32-32H336C344.8 256 352 248.8 352 240S344.8 224 336 224H246.6L109.5 86.91C148.9 52.81 199.1 32 256 32c123.5 0 224 100.5 224 224C480 312 459.2 363.1 425.1 402.5zM400 224C391.2 224 384 231.2 384 240v64c0 8.844 7.156 16 16 16S416 312.8 416 304v-64C416 231.2 408.8 224 400 224zM398.9 193.1c8.844 0 16-7.156 16-16c0-35.28-31.44-64-70.06-64h-34.75c-11.41 0-22.16-4.281-29.44-11.78c-5.746-5.902-8.807-13.33-8.592-20.89l.0918-2.795l-.5859-.0195C270.4 70.14 264.3 64.22 256.5 64h-.4518C247.4 64 240.3 70.88 240 79.56c-.4375 16.31 5.844 31.97 17.66 44.09c13.28 13.66 32.38 21.47 52.38 21.47h34.75c21 0 38.06 14.34 38.06 32C382.9 185.1 390 193.1 398.9 193.1z"],
    "banana": [576, 512, [], "e2e5", "M294.3 250.7c0 6.924 5.461 15.93 15.98 15.93c6.325 0 12.32-3.75 14.84-9.933c13.12-32.17 17.34-58.39 18.59-68.4c1.713-13.05 2.567-26.03 2.567-38.91c0-57.82-15.57-86.7-15.57-96.62c0-15.91 15.81-20.93 21.96-20.93c23.52 0 95.3 86.48 95.3 192.5c0 17.94-1.663 27.62-1.663 30.59c0 2.745 2.245 15.94 16.03 15.94c16.44 0 17.64-15.75 17.64-46.62c0-116.7-78.95-224.3-127.5-224.3c-27.97 0-53.75 22.8-53.75 52.9c0 20.25 15.47 39.6 15.47 96.45c0 11.66-.7781 23.45-2.339 35.34C307.6 220.2 294.3 243.5 294.3 250.7zM576 398.5c0-2.57-.6256-5.176-1.944-7.593l-23.28-42.77c-19.29-35.48-54.23-55.88-90.83-55.88c-12.37 0-24.93 2.329-37.14 7.192l-81.59 32.45L299.2 288.4C279.3 267.7 252.5 256.8 225.5 256.8c-14.7 0-29.47 3.234-43.25 9.887L137 288.5c-5.718 2.759-9.038 8.442-9.038 14.36c0 8.409 6.817 15.95 16.02 15.95c2.34 0 4.714-.517 6.955-1.607l45.22-21.84c9.313-4.5 19.08-6.652 28.77-6.652c13.13 0 26.12 3.953 37.64 11.37C218.5 355.5 118.1 388.3 45.91 388.3C20.59 388.3 0 408.1 0 434.4v29.56c0 25.42 20.69 46.09 46.12 46.09h55.75c40.35 0 285.8 34.48 361.2-185.6c23.98 1.236 46.71 15.16 59.58 38.81l23.28 42.77c1.616 2.96 6.915 8.465 14.09 8.465C567.7 414.5 576 408.2 576 398.5zM91.03 478.2H46.12c-7.781 0-14.12-6.382-14.12-14.21v-29.56c0-7.845 6.25-14.23 13.91-14.23c82.34 0 190.5-36.75 240.7-98.92l39.06 40.46c3.068 3.184 7.256 4.877 11.53 4.877c1.995 0 4.009-.3685 5.937-1.126l82.47-32.81C352.3 506.5 154.3 478.1 91.03 478.2z"],
    "bandage": [640, 512, [62562, "band-aid"], "1fa79", "M560 96h-480c-44.12 0-80 35.88-80 80v160c0 44.13 35.88 80 80 80h480c44.13 0 80-35.88 80-80v-160C640 131.9 604.2 96 560 96zM160 384H80.03c-26.5 0-48-21.5-48-48v-160c0-26.5 21.5-48 48-48h79.1V384zM448 384h-256V128h256V384zM608 336c0 26.5-21.5 48-48 48h-80V128h80c26.5 0 48 21.5 48 48V336zM272 228c11 0 20-9 20-20s-9-20-20-20S252 197 252 208S261 228 272 228zM368 228c11 0 20-9 20-20s-9-20-20-20s-20 9-20 20S357 228 368 228zM272 324c11 0 20-9 20-20s-9-20-20-20S252 293 252 304S261 324 272 324zM368 324c11 0 20-9 20-20s-9-20-20-20s-20 9-20 20S357 324 368 324z"],
    "bangladeshi-taka-sign": [384, 512, [], "e2e6", "M384 272c0 114.7-93.31 208-208 208C131.9 480 96 444.1 96 400V224H48C39.16 224 32 216.8 32 208S39.16 192 48 192H96V112C96 85.53 74.47 64 48 64C39.16 64 32 56.84 32 48S39.16 32 48 32C92.13 32 128 67.88 128 112V192h48C184.8 192 192 199.2 192 208S184.8 224 176 224H128v176C128 426.5 149.5 448 176 448c97.03 0 176-78.97 176-176C352 245.5 330.5 224 304 224h-32C263.2 224 256 216.8 256 208S263.2 192 272 192h32C348.1 192 384 227.9 384 272z"],
    "banjo": [512, 512, [63651], "1fa95", "M147.3 316.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l48 48C175.8 390.4 179.9 392 184 392s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L147.3 316.7zM501.3 37.47l-26.71-26.7C467.7 3.871 458.3 0 448.5 0c-9.83 0-19.09 3.844-26.23 11l-41.08 44.2c-3.021 3.252-5.084 7.279-5.955 11.63l-11.82 59.09L298.3 191C273.2 170.3 242.2 156.9 208 153.6V144C208 135.2 200.8 128 192 128S176 135.2 176 144v9.619C141.8 156.9 110.8 170.3 85.67 191L78.88 184.2c-6.25-6.25-16.38-6.25-22.62 0c-6.25 6.25-6.25 16.38 0 22.62l6.789 6.789C42.27 238.8 28.91 269.8 25.62 304H16C7.156 304 0 311.2 0 320s7.156 16 16 16h9.617c3.297 34.22 16.66 65.22 37.42 90.35l-6.789 6.789c-6.25 6.25-6.25 16.38 0 22.62c6.246 6.246 16.37 6.254 22.62 0l6.791-6.791C110.8 469.7 141.8 483.1 176 486.4V496c0 8.844 7.161 16 16 16S208 504.8 208 496v-9.619c34.21-3.297 65.21-16.65 90.33-37.41l6.791 6.791c6.246 6.246 16.37 6.254 22.62 0c6.25-6.25 6.25-16.38 0-22.62l-6.789-6.789C341.7 401.2 355.1 370.2 358.4 336H368c8.844 0 16.01-7.156 16.01-16S376.8 304 368 304h-9.617c-3.297-34.22-16.66-65.22-37.42-90.35l65.16-65.15l59.04-11.8c4.354-.8711 8.381-2.934 11.63-5.957l44.47-41.33C515.6 75.09 515.6 51.78 501.3 37.47zM328 320c0 74.98-61 136-136 136S56 394.1 56 320S117 184 192 184S328 245 328 320zM479.5 65.97L436.7 105.8l-38.07 7.611l7.613-38.05l38.75-41.72c2.926-2.934 5.998-1.178 6.975-.2012l26.7 26.7C480.4 61.87 480.3 65.07 479.5 65.97z"],
    "bank": [512, 512, ["institution", "university"], "f19c", "M496 480h-480C7.164 480 0 487.2 0 496C0 504.8 7.164 512 16 512h480c8.836 0 16-7.164 16-16C512 487.2 504.8 480 496 480zM472 448c8.836 0 16-7.164 16-16c0-8.838-7.164-16-16-16H40c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16H472zM497.2 97.81l-232-96C262.2 .5938 259.1-.0039 256-.0039S249.8 .5938 246.8 1.812l-232 96C5.844 101.5 0 110.3 0 120v48C0 181.3 10.75 192 24 192H64v160c-8.836 0-16 7.162-16 16C48 376.8 55.16 384 64 384h384c8.836 0 16-7.164 16-16c0-8.838-7.164-16-16-16V192h40C501.3 192 512 181.3 512 168v-48C512 110.3 506.2 101.5 497.2 97.81zM176 352H96V192h80V352zM304 352h-96V192h96V352zM232 136C232 122.8 242.8 112 256 112s24 10.78 24 24S269.2 160 256 160S232 149.2 232 136zM416 352h-80V192H416V352zM480 160h-173.6C309.9 152.7 312 144.6 312 136c0-30.88-25.12-56-56-56S200 105.1 200 136c0 8.621 2.121 16.7 5.617 24H32V125.3l224-92.69l224 92.69V160z"],
    "barcode": [512, 512, [], "f02a", "M496 32C487.2 32 480 39.16 480 48v416c0 8.844 7.156 16 16 16s16-7.156 16-16v-416C512 39.16 504.8 32 496 32zM400 32C391.2 32 384 39.16 384 48v416c0 8.844 7.156 16 16 16s16-7.156 16-16v-416C416 39.16 408.8 32 400 32zM304 32C295.2 32 288 39.16 288 48v416c0 8.844 7.156 16 16 16s16-7.156 16-16v-416C320 39.16 312.8 32 304 32zM240 32C231.2 32 224 39.16 224 48v416C224 472.8 231.2 480 240 480s16-7.156 16-16v-416C256 39.16 248.8 32 240 32zM144 32C135.2 32 127.1 39.16 127.1 47.1v416C127.1 472.8 135.2 480 144 480S160 472.8 160 464v-416C160 39.16 152.8 32 144 32zM80 32C71.16 32 64 39.16 64 48v416C64 472.8 71.16 480 80 480s15.1-7.156 15.1-15.1V47.1C95.1 39.16 88.84 32 80 32zM16 32C7.156 32 0 39.16 0 48v416C0 472.8 7.156 480 16 480S32 472.8 32 464v-416C32 39.16 24.84 32 16 32z"],
    "barcode-read": [576, 512, [], "f464", "M208 128C199.2 128 192 135.2 192 144v224C192 376.8 199.2 384 208 384S224 376.8 224 368v-224C224 135.2 216.8 128 208 128zM432 384c8.844 0 16-7.155 16-15.1v-224C448 135.2 440.8 128 432 128S416 135.2 416 144v224C416 376.8 423.2 384 432 384zM272 128C263.2 128 256 135.2 256 144v224C256 376.8 263.2 384 272 384s16-7.156 16-16v-224C288 135.2 280.8 128 272 128zM352 128c-8.844 0-16 7.156-16 16v224c0 8.844 7.156 16 16 16s16-7.156 16-16v-224C368 135.2 360.8 128 352 128zM144 128C135.2 128 128 135.2 128 144v224C128 376.8 135.2 384 144 384S160 376.8 160 368v-224C160 135.2 152.8 128 144 128zM144 0h-128C7.156 0 0 7.156 0 16v128C0 152.8 7.156 160 16 160S32 152.8 32 144V32h112C152.8 32 160 24.84 160 16S152.8 0 144 0zM560 0h-128C423.2 0 416 7.156 416 16S423.2 32 432 32H544v112C544 152.8 551.2 160 560 160S576 152.8 576 144v-128C576 7.156 568.8 0 560 0zM560 352c-8.844 0-16 7.156-16 16V480h-112c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16v-128C576 359.2 568.8 352 560 352zM144 480H32v-112C32 359.2 24.84 352 16 352S0 359.2 0 368v128C0 504.8 7.156 512 16 512h128C152.8 512 160 504.8 160 496S152.8 480 144 480z"],
    "barcode-scan": [640, 512, [], "f465", "M624 240h-608C7.156 240 0 247.2 0 255.1C0 264.8 7.156 272 16 272h608C632.8 272 640 264.8 640 256C640 247.2 632.8 240 624 240zM96 48C96 39.16 88.84 32 80 32S64 39.16 64 48V192h32V48zM159.1 47.1C159.1 39.16 152.8 32 144 32S128 39.16 128 48V192h31.1V47.1zM320 48C320 39.16 312.8 32 304 32S288 39.16 288 48V192h32V48zM384 48C384 39.16 376.8 32 368 32S352 39.16 352 48V192h32V48zM576 48C576 39.16 568.8 32 560 32S544 39.16 544 48V192h32V48zM480 47.1C480 39.16 472.8 32 464 32S448 39.16 448 47.1V192h32V47.1zM224 48C224 39.16 216.8 32 208 32S191.1 39.16 191.1 47.1L191.1 192H224V48zM352 464c0 8.844 7.156 16 16 16s16-7.156 16-16V320h-32V464zM64 464C64 472.8 71.16 480 80 480S96 472.8 96 464V320H64V464zM544 464c0 8.844 7.156 16 16 16s16-7.156 16-16V320h-32V464zM448 464c0 8.844 7.156 16 16 16s16-7.156 16-16V320h-32V464zM128 464C128 472.8 135.2 480 144 480s15.1-7.156 15.1-15.1V320H128V464zM288 464C288 472.8 295.2 480 304 480s16-7.156 16-16V320H288V464zM191.1 464C191.1 472.8 199.2 480 208 480S224 472.8 224 464V320H191.1L191.1 464z"],
    "bars": [448, 512, ["navicon"], "f0c9", "M16 112h416c8.844 0 16-7.156 16-15.1S440.8 80 432 80h-416C7.156 80 0 87.16 0 95.1S7.156 112 16 112zM432 240h-416C7.156 240 0 247.2 0 256s7.156 16 16 16h416C440.8 272 448 264.8 448 256S440.8 240 432 240zM432 400h-416c-8.844 0-16 7.156-16 15.1S7.156 432 16 432h416c8.844 0 16-7.156 16-15.1S440.8 400 432 400z"],
    "bars-filter": [448, 512, [], "e0ad", "M16 112h416c8.844 0 16-7.156 16-15.1S440.8 80 432 80h-416C7.156 80 0 87.16 0 95.1S7.156 112 16 112zM368 240h-288C71.16 240 64 247.2 64 255.1C64 264.8 71.16 272 80 272h288c8.844 0 16-7.156 16-15.1C384 247.2 376.8 240 368 240zM272 400h-96c-8.844 0-16 7.156-16 15.1S167.2 432 176 432h96c8.844 0 16-7.156 16-15.1S280.8 400 272 400z"],
    "bars-progress": [512, 512, ["tasks-alt"], "f828", "M480 32H32C14.33 32 0 46.33 0 64v64c0 17.67 14.33 32 32 32h448c17.67 0 32-14.33 32-32V64C512 46.33 497.7 32 480 32zM352 128H32V64h320V128zM480 128h-96V64h96V128zM480 192H32C14.33 192 0 206.3 0 224v64c0 17.67 14.33 32 32 32h448c17.67 0 32-14.33 32-32V224C512 206.3 497.7 192 480 192zM128 288H32V224h96V288zM480 288H160V224h320V288zM480 352H32c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h448c17.67 0 32-14.33 32-32v-64C512 366.3 497.7 352 480 352zM256 448H32v-64h224V448zM480 448h-192v-64h192V448z"],
    "bars-sort": [448, 512, [], "e0ae", "M16 112h416c8.844 0 16-7.156 16-15.1S440.8 80 432 80h-416C7.156 80 0 87.16 0 95.1S7.156 112 16 112zM304 240h-288C7.156 240 0 247.2 0 255.1C0 264.8 7.156 272 16 272h288c8.844 0 16-7.156 16-15.1C320 247.2 312.8 240 304 240zM176 400h-160c-8.844 0-16 7.156-16 15.1S7.156 432 16 432h160c8.844 0 16-7.156 16-15.1S184.8 400 176 400z"],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", "M16 112h416c8.844 0 16-7.156 16-15.1S440.8 80 432 80h-416C7.156 80 0 87.16 0 95.1S7.156 112 16 112zM496 240h-416C71.16 240 64 247.2 64 256s7.156 16 16 16h416C504.8 272 512 264.8 512 256S504.8 240 496 240zM432 400h-416c-8.844 0-16 7.156-16 15.1S7.156 432 16 432h416c8.844 0 16-7.156 16-15.1S440.8 400 432 400z"],
    "baseball": [512, 512, [129358, 62515, "baseball-ball"], "26be", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM455.2 296.8c7.027-.7109 14.03-.7422 21.01-.4687c-16.68 91.2-88.66 163.2-179.9 179.8C296.3 474.8 296 473.5 296 472.2c0-4.812 .1875-9.562 .5938-14.34c.75-8.812-5.781-16.56-14.59-17.28c-8.687-.5938-16.53 5.781-17.28 14.59C264.3 460.8 264 466.5 264 472.2c0 2.488 .4121 4.914 .5645 7.379C261.7 479.7 258.9 480 256 480c-123.5 0-224-100.5-224-224c0-2.883 .3242-5.688 .4336-8.547c2.58 .1562 5.117 .5781 7.723 .5781c6.281 0 12.5-.2813 18.75-.8438c8.812-.8125 15.28-8.625 14.47-17.41C72.53 220.1 64.5 214.7 55.97 215.3C49.22 215.9 42.51 215.1 35.82 215.7C52.48 124.5 124.5 52.48 215.7 35.82c.0566 1.352 .3066 2.668 .3066 4.023c0 5.125-.2187 10.22-.6562 15.31C214.6 63.97 221.2 71.69 229.1 72.44C230.4 72.47 230.9 72.5 231.3 72.5c8.219 0 15.22-6.312 15.91-14.66c.5-5.969 .7813-12 .7813-18c0-2.5-.4121-4.938-.5645-7.414C250.3 32.32 253.1 32 256 32c123.5 0 224 100.5 224 224c0 2.93-.3281 5.777-.4395 8.68c-9.139-.4844-18.31-.6094-27.53 .2578c-8.781 .875-15.22 8.688-14.38 17.5C438.5 291.2 446.6 297.6 455.2 296.8zM220.9 106.3C212.9 102.7 203.4 106.1 199.7 114.1c-12.94 28-33.25 52.25-58.75 70.03C132.7 189.9 123.9 195 114.8 199.3C106.8 203.1 103.4 212.7 107.2 220.7c2.75 5.781 8.5 9.156 14.47 9.156c2.312 0 4.625-.5 6.844-1.531c10.72-5.062 21.09-11.09 30.78-17.88c30.12-21.06 54.13-49.69 69.47-82.84C232.4 119.5 228.1 110 220.9 106.3zM382.6 284.2c-10.34 4.906-20.38 10.78-29.91 17.47c-30.34 21.25-54.5 50.22-69.84 83.75c-3.656 8.031-.125 17.53 7.906 21.22c2.156 .9687 4.406 1.438 6.656 1.438c6.062 0 11.88-3.469 14.56-9.344c12.97-28.34 33.41-52.88 59.09-70.88c8.062-5.656 16.56-10.62 25.28-14.78c8-3.812 11.38-13.34 7.562-21.31C400.1 283.7 390.5 280.3 382.6 284.2z"],
    "baseball-bat-ball": [640, 512, [], "f432", "M627.3 60.18l-23.63-32.5c-22.63-31.12-64.75-35.87-93.63-14.87L307.8 159.7c-45.63 33.12-87.37 71.25-124.4 113.7c-29 33.37-72.53 78.59-130.3 120.6l-21.63 15.75c-.25-.375-11.25-17.5-25.5-6.248c-6.875 5.498-8 15.62-2.5 22.5l64 79.99c5.25 6.5 15.25 8.25 22.5 2.5c.5-.375 12.88-9.498 .125-25.5l18.12-13.25c66.01-47.87 122.4-72.46 155.2-86.46c51.88-21.1 101.2-49.88 146.9-82.1l202.3-146.7C642.3 131.8 648.9 90.05 627.3 60.18zM70.12 458l-18.62-23.25c28.88-20.87 71.75-50.62 125-106.2l32.25 44.37C140.6 405.8 99.25 436.8 70.12 458zM593.7 127.7c-247 179.1-243.1 182.5-359.9 233.7L195 308.3c84.88-94.99 86.51-90.12 333.8-269.5c14.88-10.75 37-8.75 49 7.623l23.5 32.5C612.8 94.54 609.3 116.3 593.7 127.7zM496.1 352C451.1 352 416 387.9 416 432c0 44.13 35.97 80 80.09 80s79.91-35.88 79.91-80C576 387.9 540.2 352 496.1 352zM496 480c-26.5 0-48-21.5-48-48c0-26.5 21.5-47.1 48-47.1c26.5 0 48 21.5 48 47.1C544 458.5 522.5 480 496 480z"],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", "M176 320C167.2 320 160 327.2 160 336v96c0 8.834 7.168 15.1 16 15.1c8.834 0 16-7.166 16-15.1V336C192 327.2 184.8 320 176 320zM288 319.1c-8.832 0-16 7.168-16 16v96c0 8.834 7.168 15.1 16 15.1c8.834 0 16-7.165 16-15.1V336C304 327.2 296.8 319.1 288 319.1zM400 320c-8.832 0-16 7.166-16 16v96c0 8.834 7.168 15.1 16 15.1c8.834 0 16-7.166 16-15.1V336C416 327.2 408.8 320 400 320zM560 192L419.1 192l-68.11-181.6c-3.109-8.297-12.31-12.42-20.61-9.359c-8.266 3.109-12.45 12.33-9.359 20.61L384.9 192H191.1l63.89-170.4c3.094-8.281-1.094-17.5-9.359-20.61C237.3-2.062 228.1 2.078 225 10.38L156.9 192L16 192c-8.836 0-16 7.162-16 15.1C0 216.8 7.164 224 16 224H32l52.86 237.9C91.37 491.2 117.3 512 147.3 512h281.3c29.1 0 55.97-20.83 62.48-50.12L544 224h16C568.8 224 576 216.8 576 208C576 199.2 568.8 192 560 192zM459.9 454.9C456.6 469.7 443.8 480 428.7 480H147.3c-15.11 0-27.96-10.3-31.24-25.06L64.78 224h80.13l-15.89 42.38c-3.094 8.281 1.094 17.5 9.359 20.61C140.2 287.7 142.1 288 144 288c6.469 0 12.58-3.953 14.98-10.38L179.1 224h217.8l20.11 53.63C419.4 284 425.5 288 432 288c1.875 0 3.766-.3281 5.625-1.016c8.266-3.109 12.45-12.33 9.359-20.61L431.1 224h80.13L459.9 454.9z"],
    "basket-shopping-simple": [576, 512, ["shopping-basket-alt"], "e0af", "M560 192L419.1 192l-68.11-181.6c-3.109-8.297-12.36-12.42-20.61-9.359c-8.266 3.109-12.45 12.33-9.359 20.61L384.9 192H191.1l63.89-170.4c3.094-8.281-1.094-17.5-9.359-20.61c-8.266-3.078-17.5 1.062-20.61 9.359L156.9 192L16 192c-8.836 0-16 7.162-16 15.1C0 216.8 7.164 224 16 224H32l52.86 237.9C91.37 491.2 117.3 512 147.3 512h281.3c29.1 0 55.97-20.83 62.48-50.12L544 224h16C568.8 224 576 216.8 576 208C576 199.2 568.8 192 560 192zM459.9 454.9C456.6 469.7 443.8 480 428.7 480H147.3c-15.11 0-27.96-10.3-31.24-25.06L64.78 224h80.13l-15.89 42.38c-3.094 8.281 1.094 17.5 9.359 20.61C140.2 287.7 142.1 288 144 288c6.469 0 12.58-3.953 14.98-10.38L179.1 224h217.8l20.11 53.63C419.4 284 425.5 288 432 288c1.875 0 3.766-.3281 5.625-1.016c8.266-3.109 12.45-12.33 9.359-20.61L431.1 224h80.13L459.9 454.9z"],
    "basketball": [512, 512, [62516, "basketball-ball"], "1f3c0", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM480 256c0 .9766-.1348 1.922-.1465 2.896C469.4 257.1 458.7 256 448 256c-47.19 0-90.39 17.18-123.9 45.52L278.6 256l146.5-146.5C459.2 148.8 480 199.1 480 256zM288 448c0-38.34 14.12-73.1 36.69-100.7l77.78 77.78c-31.03 26.91-69.46 45.33-111.8 51.95C288.9 467.5 288 457.7 288 448zM402.5 86.91L256 233.4L210.5 187.9C238.8 154.4 256 111.2 256 64c0-10.68-1.139-21.36-2.896-31.85C254.1 32.13 255 32 256 32C312 32 363.2 52.81 402.5 86.91zM109.5 86.91c31.03-26.91 69.46-45.33 111.8-51.95C223.1 44.49 224 54.26 224 64c0 38.34-14.12 73.1-36.69 100.7L109.5 86.91zM86.91 109.5l77.78 77.78C137.1 209.9 102.3 224 64 224C54.26 224 44.49 223.1 34.96 221.4C41.58 178.1 59.1 140.6 86.91 109.5zM32 256c0-.9766 .1348-1.922 .1465-2.896C42.64 254.9 53.32 256 64 256c47.19 0 90.39-17.18 123.9-45.52L233.4 256l-146.5 146.5C52.81 363.2 32 312 32 256zM109.5 425.1L256 278.6l45.52 45.52C273.2 357.6 256 400.8 256 448c0 10.68 1.139 21.36 2.896 31.85C257.9 479.9 256.1 480 256 480C199.1 480 148.8 459.2 109.5 425.1zM425.1 402.5l-77.78-77.78C374.9 302.1 409.7 288 448 288c9.742 0 19.51 .8926 29.04 2.635C470.4 333 452 371.4 425.1 402.5z"],
    "basketball-hoop": [640, 512, [], "f435", "M631.5 175.8C572.6 71.38 455.4 0 320 0S67.37 71.38 8.504 175.8C2.955 185.7 0 196.8 0 208.1v118c0 25.43 15.05 48.44 38.35 58.63l67.03 29.32c11.29 4.939 23.7-4.207 22.31-16.46c-.6406-5.674-4.256-10.58-9.486-12.86l-67.03-29.32C39.53 350.4 32 338.9 32 326.1V208.1c0-5.664 1.189-10.8 3.439-14.86C90.61 93.79 199.6 32 320 32s229.4 61.79 284.6 161.2C606.8 197.3 608 202.4 608 208.1v118c0 12.71-7.525 24.22-19.17 29.32l-67.03 29.32c-5.23 2.287-8.846 7.189-9.486 12.86c-1.383 12.25 11.02 21.39 22.31 16.46l67.03-29.32C624.9 374.6 640 351.6 640 326.1V208.1C640 196.8 637 185.7 631.5 175.8zM464 208C472.8 208 480 200.8 480 192V160c0-17.67-14.33-32-32-32H192C174.3 128 160 142.3 160 160v32c0 8.836 7.164 16 16 16C184.8 208 192 200.8 192 192V160h256v32C448 200.8 455.2 208 464 208zM528 256c0-8.836-7.162-16-16-16H128C119.2 240 112 247.2 112 256S119.2 272 128 272h18.6l25.49 225.8c.6562 5.875 4.531 10.86 10 13.04c1.9 .7441 3.914 1.121 5.902 1.121c3.732 0 7.412-1.301 10.35-3.809l55.11-46.8l56.29 46.91C312.7 510.8 316.4 512 320 512s7.281-1.234 10.25-3.703l56.29-46.91l55.11 46.8C444.6 510.7 448.3 512 452 512c1.999 0 4-.375 5.906-1.125c5.469-2.172 9.344-7.162 10-13.04L493.4 272H512C520.8 272 528 264.8 528 256zM439.5 464.4l-32.22-27.36c-5.971-5.07-13.34-7.607-20.71-7.607c-7.273 0-14.55 2.469-20.49 7.416L320 475.2l-46.06-38.38c-5.938-4.947-13.21-7.416-20.49-7.416c-7.371 0-14.74 2.539-20.71 7.607l-32.22 27.36L178.8 272h282.4L439.5 464.4zM240 344c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24c-13.25 0-24 10.74-24 24C216 333.3 226.7 344 240 344zM256 384c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24C266.7 360 256 370.7 256 384zM336 384c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24C346.7 360 336 370.7 336 384zM400 344c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24c-13.25 0-24 10.74-24 24C376 333.3 386.7 344 400 344zM320 344c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24c-13.25 0-24 10.74-24 24C296 333.3 306.7 344 320 344z"],
    "bat": [640, 512, [], "f6b5", "M638.6 287.2L568.2 129.8c-5.375-12.38-17.75-19.5-30.62-19.5c-5.75 0-11.75 1.5-17.12 4.625l-104.9 60.37L383.1 64L333.9 112H306.1L255.1 64L224.4 175.2L119.5 114.9c-5.375-3.125-11.37-4.625-17.12-4.625c-12.88 0-25.25 7.125-30.62 19.5L1.375 287.2C-4.25 300 8.375 313.1 22 308.8L38.5 303.5c6.75-2.25 13.87-3.375 20.1-3.375c21.88 0 42.87 10.38 55.5 28.5L153.4 384l12.37-11.88c13-12.5 30.12-18.75 46.1-18.75c20.12 0 40.25 8.75 53.37 25.62L319.1 448l53.87-69c13.25-16.88 33.25-25.62 53.37-25.62c16.88 0 33.1 6.25 46.1 18.75L486.6 384l38.37-55.38c12.62-18.12 33.62-28.5 55.5-28.5c7 0 14.12 1.125 20.1 3.375l16.5 5.25C631.6 313.1 644.2 300 638.6 287.2zM580.5 268.1c-33.5 0-64.63 16-83.25 42.75l-17.25 25c-15.75-9.375-33.88-14.38-52.75-14.38c-31.87 0-61 14-80 38.38l-27.25 34.75l-27.25-34.75c-19-24.38-48.13-38.38-80-38.38c-18.88 0-37 5-52.75 14.38l-17.25-25C124.1 284.1 92.1 268.1 59.5 268.1c-4.625 0-9.25 .375-13.75 1L102.4 142.2L245.7 225L271.9 124.9L292.9 144h54.25l21-19.12l26.12 100.1l143.4-82.75l56.63 126.9C589.7 268.5 585.1 268.1 580.5 268.1z"],
    "bath": [512, 512, [62157, "bathtub"], "1f6c1", "M464 320c-8.844 0-16 7.156-16 16v32c0 44.11-35.89 80-80 80h-224C99.89 448 64 412.1 64 368v-32C64 327.2 56.84 320 48 320S32 327.2 32 336v32c0 30.4 12.27 57.93 32 78.13V496C64 504.8 71.16 512 80 512C88.84 512 96 504.8 96 496v-27.23C110.6 475.8 126.8 480 144 480h224c17.24 0 33.39-4.242 48-11.23V496c0 8.836 7.164 16 16 16c8.838 0 16-7.164 16-16v-49.87c19.73-20.2 32-47.74 32-78.13v-32C480 327.2 472.8 320 464 320zM496 256H64V61.25C64 45.13 77.13 32 93.25 32C100.1 32 108.5 35.13 113.9 40.56l25.32 25.32C121.6 93.88 124.8 131.3 149.2 155.7l12.88 12.88C158.9 174.6 159.6 182.2 164.7 187.3C167.8 190.4 171.9 192 176 192s8.188-1.562 11.31-4.688l96-96c6.25-6.25 6.25-16.38 0-22.62c-5.104-5.104-12.69-5.811-18.74-2.582L251.7 53.22C237.5 39.07 218.1 32 200.5 32C187 32 173.6 35.83 161.9 43.26L136.6 17.94C125 6.375 109.6 0 93.25 0C59.48 0 32 27.47 32 61.25v194.8L16 256C7.164 256 0 263.2 0 272S7.164 288 16 288h480C504.8 288 512 280.8 512 272S504.8 256 496 256zM171.8 75.85C179.5 68.21 189.6 64 200.5 64s20.96 4.207 28.61 11.85l12.23 12.23L184.1 145.3L171.8 133.1C156.1 117.3 156.1 91.62 171.8 75.85z"],
    "battery-bolt": [576, 512, [], "f376", "M366.5 249.2C363.9 243.6 358.2 240 352 240H194.3l145.9-173.7c5.688-6.766 4.812-16.86-1.969-22.55c-6.75-5.688-16.88-4.859-22.53 1.953l-168 200c-4 4.766-4.875 11.42-2.25 17.06C148.1 268.4 153.8 272 160 272h157.7l-145.9 173.7c-5.688 6.766-4.812 16.86 1.969 22.55C176.7 470.8 180.3 472 184 472c4.562 0 9.094-1.938 12.25-5.703l168-200C368.3 261.5 369.1 254.9 366.5 249.2zM128 384H64c-17.67 0-32-14.33-32-32V160c0-17.67 14.33-32 32-32h128c8.836 0 16-7.164 16-16C208 103.2 200.8 96 192 96H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h64c8.836 0 16-7.164 16-16C144 391.2 136.8 384 128 384zM448 96h-64c-8.836 0-16 7.162-16 16C368 120.8 375.2 128 384 128h64c17.67 0 32 14.33 32 32v192c0 17.67-14.33 32-32 32h-128c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16h128c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM560 192C551.2 192 544 199.2 544 208v96c0 8.844 7.156 16 16 16S576 312.8 576 304v-96C576 199.2 568.8 192 560 192z"],
    "battery-empty": [576, 512, ["battery-0"], "f244", "M448 96H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM480 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V352zM560 192C551.2 192 544 199.2 544 208v96c0 8.844 7.156 16 16 16S576 312.8 576 304v-96C576 199.2 568.8 192 560 192z"],
    "battery-exclamation": [576, 512, [], "e0b0", "M272 336c8.838 0 16-7.164 16-16V80C288 71.16 280.8 64 272 64C263.2 64 256 71.16 256 80V320C256 328.8 263.2 336 272 336zM272 368c-17.64 0-32 14.35-32 32C240 417.6 254.4 432 272 432s32-14.36 32-31.1C304 382.4 289.6 368 272 368zM64 128h112C184.8 128 192 120.8 192 112C192 103.2 184.8 96 176 96H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h112C184.8 416 192 408.8 192 400C192 391.2 184.8 384 176 384H64c-17.67 0-32-14.33-32-32V160C32 142.3 46.33 128 64 128zM560 192C551.2 192 544 199.2 544 208v96c0 8.844 7.156 16 16 16S576 312.8 576 304v-96C576 199.2 568.8 192 560 192zM448 96h-80C359.2 96 352 103.2 352 112C352 120.8 359.2 128 368 128H448c17.67 0 32 14.33 32 32v192c0 17.67-14.33 32-32 32h-80c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16H448c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96z"],
    "battery-full": [576, 512, [62016, "battery", "battery-5"], "1f50b", "M448 96H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM480 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V352zM416 160H96C78.33 160 64 174.3 64 192v128c0 17.67 14.33 32 32 32h320c17.67 0 32-14.33 32-32V192C448 174.3 433.7 160 416 160zM416 320H96V192h320V320zM560 192C551.2 192 544 199.2 544 208v96c0 8.844 7.156 16 16 16S576 312.8 576 304v-96C576 199.2 568.8 192 560 192z"],
    "battery-half": [576, 512, ["battery-3"], "f242", "M560 192C551.2 192 544 199.2 544 208v96c0 8.844 7.156 16 16 16S576 312.8 576 304v-96C576 199.2 568.8 192 560 192zM448 96H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM480 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V352zM256 160H96C78.33 160 64 174.3 64 192v128c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32V192C288 174.3 273.7 160 256 160zM256 320H96V192h160V320z"],
    "battery-low": [576, 512, ["battery-1"], "e0b1", "M560 192C551.2 192 544 199.2 544 208v96c0 8.844 7.156 16 16 16S576 312.8 576 304v-96C576 199.2 568.8 192 560 192zM448 96H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM480 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V352zM112 160H96C78.33 160 64 174.3 64 192v128c0 17.67 14.33 32 32 32h16c17.67 0 32-14.33 32-32V192C144 174.3 129.7 160 112 160zM112 320H96V192h16V320z"],
    "battery-quarter": [576, 512, ["battery-2"], "f243", "M560 192C551.2 192 544 199.2 544 208v96c0 8.844 7.156 16 16 16S576 312.8 576 304v-96C576 199.2 568.8 192 560 192zM448 96H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM480 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V352zM160 160H96C78.33 160 64 174.3 64 192v128c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V192C192 174.3 177.7 160 160 160zM160 320H96V192h64V320z"],
    "battery-slash": [640, 512, [], "f377", "M592 320c8.844 0 16-7.156 16-16v-96C608 199.2 600.8 192 592 192s-15.95 7.157-15.95 16v96C576 312.8 583.2 320 592 320zM480 128c17.64 0 32 14.36 32 32v166l32 25.26l.0496-191.3C544 124.7 515.3 96 480 96H220.6L261.2 128H480zM96 384c-17.64 0-32-14.36-32-32V160c0-7.283 2.873-13.68 6.986-19.07L45.64 120.9C37.22 131.8 32.02 145.2 32.02 160v192c0 35.35 28.65 64 63.1 64L419.4 416l-40.53-32H96zM633.9 483.4L25.9 3.418C18.1-2.02 8.936-.8477 3.436 6.059c-5.469 6.939-4.281 17 2.656 22.49l608 480C617 510.9 620.5 512 624 512c4.719 0 9.406-2.094 12.56-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "battery-three-quarters": [576, 512, ["battery-4"], "f241", "M320 160H96C78.33 160 64 174.3 64 192v128c0 17.67 14.33 32 32 32h224c17.67 0 32-14.33 32-32V192C352 174.3 337.7 160 320 160zM320 320H96V192h224V320zM448 96H64C28.65 96 0 124.7 0 160v192c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM480 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V352zM560 192C551.2 192 544 199.2 544 208v96c0 8.844 7.156 16 16 16S576 312.8 576 304v-96C576 199.2 568.8 192 560 192z"],
    "bed": [640, 512, [62006], "1f6cc", "M528 128h-256C263.2 128 256 135.2 256 144V320H32V48C32 39.2 24.8 32 16 32S0 39.2 0 48v416C0 472.8 7.199 480 16 480S32 472.8 32 464V416h576v48c0 8.801 7.199 16 16 16s16-7.199 16-16v-224C640 178.1 589.9 128 528 128zM608 384H32v-32h576V384zM608 320H288V160h240C572.1 160 608 195.9 608 240V320zM144 288C188.1 288 224 252.1 224 208S188.1 128 144 128S64 163.9 64 208S99.88 288 144 288zM144 160C170.5 160 192 181.5 192 208S170.5 256 144 256S96 234.5 96 208S117.5 160 144 160z"],
    "bed-bunk": [576, 512, [], "f8f8", "M128 128c35.38 0 64-28.62 64-64S163.4 0 128 0S64 28.62 64 64S92.63 128 128 128zM128 32c17.62 0 32 14.38 32 32S145.6 96 128 96S96 81.63 96 64S110.4 32 128 32zM128 384c35.38 0 64-28.62 64-64S163.4 256 128 256s-64 28.62-64 64S92.63 384 128 384zM128 288c17.62 0 32 14.38 32 32s-14.38 32-32 32s-32-14.38-32-32S110.4 288 128 288zM464 0h-224C231.2 0 224 7.164 224 16V160H32V16C32 7.199 24.8 0 16 0S0 7.199 0 16v480C0 504.8 7.199 512 16 512S32 504.8 32 496V448h512v48c0 8.801 7.199 16 16 16s16-7.199 16-16v-384C576 50.14 525.9 0 464 0zM544 416H256V288h208c44.13 0 80 35.88 80 80V416zM544 289.8C523 268.1 494.1 256 464 256h-224C231.1 256 224 263.1 224 272V416H32V192h512V289.8zM544 160H256V32h208C508.1 32 544 67.88 544 112V160z"],
    "bed-empty": [640, 512, [63737], "1f6cf", "M528 192H32V48C32 39.2 24.8 32 16 32S0 39.2 0 48v416C0 472.8 7.199 480 16 480S32 472.8 32 464V416h576v48c0 8.801 7.199 16 16 16s16-7.199 16-16v-160C640 242.1 589.9 192 528 192zM608 384H32v-32h576V384zM608 320H32V224h496C572.1 224 608 259.9 608 304V320z"],
    "bed-front": [512, 512, ["bed-alt"], "f8f7", "M480 240.4V96c0-35.3-28.72-64-64-64H96C60.72 32 32 60.7 32 96v144.4C12.69 255 0 277.1 0 304v160C0 472.8 7.156 480 16 480S32 472.8 32 464V416h448v48c0 8.844 7.156 16 16 16s16-7.156 16-16v-160C512 277.1 499.3 255 480 240.4zM432 224h-160V192c0-17.64 14.34-32 32-32H416c17.66 0 32 14.36 32 32v33.62C442.8 224.6 437.5 224 432 224zM96 64h320c17.66 0 32 14.36 32 32v40.9C438.5 131.4 427.7 128 416 128h-112c-19.2 0-36.26 8.678-48 22.12C244.3 136.7 227.2 128 208 128H96C84.29 128 73.45 131.4 64 136.9V96C64 78.36 78.34 64 96 64zM64 192c0-17.64 14.34-32 32-32h112c17.66 0 32 14.36 32 32v32h-160C74.52 224 69.17 224.6 64 225.6V192zM480 384H32V304C32 277.5 53.53 256 80 256h352C458.5 256 480 277.5 480 304V384z"],
    "bed-pulse": [640, 512, ["procedures"], "f487", "M207.1 96.01l133.1 .0091l43.71 87.14C388.4 188.6 393.1 192 400 192h.6719c6.281-.2813 11.84-4.219 14.19-10.06l50.77-126.9l16.06 32.13C484.4 92.56 489.9 96.01 496 96.01h128c8.844 0 16-7.156 16-16S632.8 64 624 64h-118.1l-27.58-55.16C475.5 3.219 470.2-.5 463.3 0c-6.281 .2813-11.84 4.219-14.19 10.06l-50.77 126.9l-32.06-64.13C363.6 67.44 358.1 64 352 64L208 64C199.2 64 192 71.17 192 80.01S199.2 96.01 207.1 96.01zM144 320C188.1 320 224 284.1 224 240S188.1 160 144 160S64 195.9 64 240S99.88 320 144 320zM144 192C170.5 192 192 213.5 192 240S170.5 288 144 288S96 266.5 96 240S117.5 192 144 192zM528 160H480c-8.836 0-16 7.162-16 16C464 184.8 471.2 192 480 192h48C572.2 192 608 227.8 608 272V352L288 352V192h32c8.836 0 16-7.164 16-16C336 167.2 328.8 160 320 160H272C263.2 160 256 167.2 256 176V352H32V80.97c0-7.979-5.4-15.42-13.27-16.74C8.74 62.55 0 70.31 0 80v415c0 7.979 5.4 15.42 13.27 16.74C23.26 513.4 32 505.7 32 496V448h576v47.03c0 7.979 5.4 15.42 13.27 16.74C631.3 513.4 640 505.7 640 496v-224C640 210.1 589.9 160 528 160zM608 416H32v-32h576V416z"],
    "bee": [576, 512, [], "e0b2", "M448 95.1c-27.7 0-55.36 9.455-80.73 22.73C367.5 116.5 368 114.3 368 111.1c0-20.4-7.832-38.84-20.4-52.97l31.11-31.11c5.635-5.635 7.001-14.71 2.341-21.17c-5.94-8.239-17.5-8.923-24.37-2.051l-34.99 34.99C311.4 34.88 300.1 31.1 288 31.1S264.6 34.88 254.3 39.68L219.9 5.286C214.3-.349 205.2-1.715 198.7 2.945C190.5 8.884 189.8 20.44 196.7 27.31L228.4 58.99C215.8 73.12 208 91.6 208 111.1c0 2.293 .4883 4.483 .6777 6.727C183.3 105.5 155.7 95.1 128 95.1C57.34 95.1 0 146.1 0 207.1c0 50.96 39.05 93.63 92.31 107.1C102.3 317.6 112 309.9 112 299.6c0-7.354-5.111-13.57-12.23-15.39C60.6 274.2 32 243.9 32 207.1C32 163.9 75.04 128 127.1 128c34.99 0 72.8 20.26 104.4 43.5c-50.07 21.58-85.17 71.31-85.15 129.3C147.2 406.4 288 512 288 512s140.8-105.6 140.8-211.2c.0195-57.99-35.07-107.7-85.14-129.3C375.3 148.3 413 128 448 128c52.9 0 96 35.87 96 80.04c0 35.89-28.59 66.14-67.77 76.19C469.1 286.1 464 292.3 464 299.6c0 10.3 9.703 17.94 19.69 15.42C536.1 301.6 576 258.1 576 208C576 146.2 518.7 95.99 448 95.1zM336 112c0 26.47-21.51 47.99-47.97 47.99S240 138.5 240 112S261.5 64 288 64S336 85.53 336 112zM234.1 416c-8.516-10.15-16.43-20.95-23.77-32h155.4c-7.336 11.05-15.25 21.85-23.77 32H234.1zM192.1 352c-4.891-10.68-8.402-21.37-10.51-32h212.8c-2.105 10.63-5.617 21.32-10.51 32H192.1zM395.6 288H180.4c1.305-11.16 4.076-21.91 8.646-32h197.8C391.5 266.1 394.2 276.8 395.6 288zM263.7 448h48.52C303.8 456.4 295.4 464.3 288 470.7C280.6 464.3 272.2 456.4 263.7 448zM365 223.9H210.1c.041-.041-.041 .041 0 0C231.5 203.4 258.9 192 287.9 192S344.5 203.4 365 223.9C365.1 223.1 364.1 223.9 365 223.9z"],
    "beer-mug": [512, 512, ["beer-foam"], "e0b3", "M256 208v192c0 8.844 7.156 16 16 16s16-7.156 16-16v-192C288 199.2 280.8 192 272 192S256 199.2 256 208zM115.2 133.3c13.07-8.768 28.93-3.621 38.31 5.164C167.8 151.8 186.9 160 207.1 160s40.23-8.188 54.49-21.54c9.393-8.793 25.28-13.91 38.31-5.164C310.9 140 322.9 144 335.1 144c39.88 0 71.24-36.47 62.54-77.88c-4.861-23.15-23.39-42.46-46.36-48.12C346.7 16.64 341.3 16 335.1 16c-11.1 0-23.17 3.338-32.71 9.117c-13.17 7.979-29.32 7.166-40.82-3.598C248.2 8.178 229.1 0 207.1 0S167.8 8.178 153.5 21.52C142 32.29 125.9 33.09 112.7 25.12C103.2 19.34 91.1 16 80 16c-5.25 0-10.68 .6426-16.18 1.998c-22.96 5.658-41.5 24.97-46.36 48.12C8.761 107.5 40.12 144 79.1 144C93.06 144 105.1 140 115.2 133.3zM48.78 72.69C53.18 51.75 77.84 41.4 96.14 52.49C106.9 59 119 62.45 131.2 62.45c16.4 0 32.09-6.236 44.19-17.56c18.36-17.18 46.85-17.19 65.21-.002c12.1 11.32 27.79 17.56 44.19 17.56c12.19 0 24.32-3.443 35.07-9.959c18.27-11.06 42.95-.7773 47.36 20.21c2.85 13.56-2.758 23.01-6.354 27.44c-23.71 29.21-45.94-3.365-75.1-3.365c-16.26 0-32.71 6.678-45.15 18.33c-18.38 17.21-46.87 17.2-65.23-.002C162.9 103.5 146.5 96.77 130.2 96.77c-11.8 0-23.16 3.439-32.86 9.947C74.22 122.3 42.63 101.9 48.78 72.69zM192 208v192C192 408.8 199.2 416 208 416S224 408.8 224 400v-192C224 199.2 216.8 192 207.1 192S192 199.2 192 208zM432 160h-64C359.2 160 352 167.2 352 176V416c0 35.35-28.65 64-64 64H128c-35.35 0-64-28.65-64-64V176C64 167.2 56.84 160 48 160S32 167.2 32 176V416c0 53.02 42.98 96 96 96h160c43.12 0 79.16-28.62 91.29-67.75L467.8 400C494.9 386.4 512 358.8 512 328.5V240C512 195.8 476.2 160 432 160zM480 328.5c0 18.3-10.16 34.73-26.53 42.92L384 406.1V192h48C458.5 192 480 213.5 480 240V328.5zM128 208v192C128 408.8 135.2 416 144 416S160 408.8 160 400v-192C160 199.2 152.8 192 144 192S128 199.2 128 208z"],
    "beer-mug-empty": [512, 512, ["beer"], "f0fc", "M144 128C135.2 128 128 135.2 128 144v224C128 376.8 135.2 384 144 384S160 376.8 160 368v-224C160 135.2 152.8 128 144 128zM272 128C263.2 128 256 135.2 256 144v224c0 8.844 7.156 16 16 16s16-7.156 16-16v-224C288 135.2 280.8 128 272 128zM208 128C199.2 128 192 135.2 192 144v224C192 376.8 199.2 384 208 384S224 376.8 224 368v-224C224 135.2 216.8 128 208 128zM432 96H384V80C384 53.49 362.5 32 336 32h-256C53.49 32 32 53.49 32 80V384c0 53.02 42.98 96 96 96h160c53.02 0 96-43.06 96-96.08V377.9L467.8 336C495.1 322.4 512 294.1 512 264.5V176C512 131.9 476.1 96 432 96zM352 384c0 35.29-28.71 64-64 64H128c-35.29 0-64-28.71-64-64V80C64 71.18 71.18 64 80 64h256C344.8 64 352 71.18 352 80V384zM480 264.5c0 18.3-10.16 34.73-26.53 42.92L384 342.1V128h48C458.5 128 480 149.5 480 176V264.5z"],
    "bell": [448, 512, [61683, 61602], "1f514", "M433.4 334.8c-28-26.5-49.38-54.38-49.38-148.9c0-79.63-63.38-144.5-144-152.4V16C240 7.125 232.9 0 224 0S208 7.125 208 16v17.5C127.4 41.38 63.1 106.3 63.1 185.9c0 94.5-21.38 122.4-49.38 148.9c-14 13.38-18.38 33.5-11.25 51.25C10.62 404.3 28.12 416 47.99 416h352c19.88 0 37.38-11.75 44.63-29.1C451.8 368.3 447.4 348.1 433.4 334.8zM400 384H47.99c-14.25 0-21.38-16.5-11.38-25.1c34.88-33.25 59.38-70.38 59.38-172.1C95.1 118.5 153.2 64 224 64s128 54.5 128 121.9c0 101.4 24.25 138.8 59.38 172.1C421.4 367.6 414.1 384 400 384zM272.1 448c-7.438 0-14.36 4.146-16.9 10.88C250.6 471.2 238.3 480 223.1 480s-26.61-8.824-31.25-21.12C190.2 452.1 183.3 448 175.8 448c-10.61 0-18.37 9.998-15.08 19.72C169.4 493.4 194.5 512 223.1 512c29.47 0 54.56-18.63 63.22-44.28C290.5 457.1 282.8 448 272.1 448z"],
    "bell-concierge": [512, 512, [62818, "concierge-bell"], "1f6ce", "M48 384C56.84 384 64 376.8 64 368c0-105.9 86.13-192 192-192s192 86.13 192 192c0 8.844 7.156 16 16 16s16-7.156 16-16c0-118.1-91.97-214.9-208-223.2V96h32C312.8 96 320 88.84 320 80S312.8 64 304 64h-96C199.2 64 192 71.16 192 80S199.2 96 208 96h32v48.81C123.1 153.1 32 249.9 32 368C32 376.8 39.16 384 48 384zM496 416h-480C7.156 416 0 423.2 0 432S7.156 448 16 448h480c8.844 0 16-7.156 16-16S504.8 416 496 416z"],
    "bell-exclamation": [448, 512, [], "f848", "M272.1 448c-7.438 0-14.36 4.146-16.9 10.88C250.6 471.2 238.3 480 223.1 480s-26.61-8.824-31.25-21.12C190.2 452.1 183.3 448 175.8 448c-10.61 0-18.37 9.998-15.08 19.72C169.4 493.4 194.5 512 223.1 512c29.47 0 54.56-18.63 63.22-44.28C290.5 457.1 282.8 448 272.1 448zM433.4 334.8c-28-26.5-49.38-54.38-49.38-148.9c0-79.63-63.38-144.5-144-152.4V16C240 7.125 232.9 0 224 0S208 7.125 208 16v17.5C127.4 41.38 63.1 106.3 63.1 185.9c0 94.5-21.38 122.4-49.38 148.9c-14 13.38-18.38 33.5-11.25 51.25C10.62 404.3 28.12 416 47.99 416h352c19.88 0 37.38-11.75 44.63-29.1C451.8 368.3 447.4 348.1 433.4 334.8zM400 384H47.99c-14.25 0-21.38-16.5-11.38-25.1c34.88-33.25 59.38-70.38 59.38-172.1C95.1 118.5 153.2 64 224 64s128 54.5 128 121.9c0 101.4 24.25 138.8 59.38 172.1C421.4 367.6 414.1 384 400 384zM224 256c8.844 0 16-7.156 16-16V128c0-8.844-7.156-16-16-16S208 119.2 208 128v112C208 248.8 215.2 256 224 256zM224 280c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 290.7 237.3 280 224 280z"],
    "bell-on": [640, 512, [63738], "1f56d", "M40.88 30.25l64 32C107.1 63.38 109.5 64 112 64c7.375 0 13.88-5.125 15.62-12.38C129.3 44.5 125.8 37 119.1 33.75l-64-32c-7.875-4-17.5-.875-21.38 7.125C29.75 16.75 32.88 26.38 40.88 30.25zM528 64c2.5 0 4.875-.625 7.125-1.75l64-32c8-3.875 11.12-13.5 7.125-21.38c-3.875-8-13.5-11.12-21.38-7.125l-64 32c-6.625 3.25-10.12 10.75-8.5 17.88C514.1 58.88 520.6 64 528 64zM80 160h-64C7.125 160 0 167.1 0 176S7.125 192 16 192h64C88.88 192 96 184.9 96 176S88.88 160 80 160zM624 160h-64C551.1 160 544 167.1 544 176S551.1 192 560 192h64C632.9 192 640 184.9 640 176S632.9 160 624 160zM368.1 448c-7.438 0-14.36 4.146-16.9 10.88C346.6 471.2 334.3 480 319.1 480s-26.61-8.824-31.25-21.12C286.2 452.1 279.3 448 271.8 448c-10.61 0-18.37 9.998-15.08 19.72C265.4 493.4 290.5 512 319.1 512c29.47 0 54.56-18.63 63.22-44.28C386.5 457.1 378.8 448 368.1 448zM480 185.9c0-79.63-63.38-144.5-144-152.4V16C336 7.125 328.9 0 320 0S304 7.125 304 16v17.5C223.4 41.38 159.1 106.3 159.1 185.9c0 94.5-21.38 122.4-49.38 148.9c-14 13.38-18.38 33.5-11.25 51.25C106.6 404.3 124.1 416 143.1 416h352c19.88 0 37.38-11.75 44.63-29.1c7.125-17.75 2.75-37.88-11.25-51.25C501.4 308.3 480 280.4 480 185.9zM496 384H143.1c-14.25 0-21.38-16.5-11.38-25.1c34.88-33.25 59.38-70.38 59.38-172.1C191.1 118.5 249.2 64 320 64s128 54.5 128 121.9c0 101.4 24.25 138.8 59.38 172.1C517.4 367.6 510.1 384 496 384z"],
    "bell-plus": [448, 512, [], "f849", "M433.4 334.8c-28-26.5-49.38-54.38-49.38-148.9c0-79.63-63.38-144.5-144-152.4V16C240 7.125 232.9 0 224 0S208 7.125 208 16v17.5C127.4 41.38 63.1 106.3 63.1 185.9c0 94.5-21.38 122.4-49.38 148.9c-14 13.38-18.38 33.5-11.25 51.25C10.62 404.3 28.12 416 47.99 416h352c19.88 0 37.38-11.75 44.63-29.1C451.8 368.3 447.4 348.1 433.4 334.8zM400 384H47.99c-14.25 0-21.38-16.5-11.38-25.1c34.88-33.25 59.38-70.38 59.38-172.1C95.1 118.5 153.2 64 224 64s128 54.5 128 121.9c0 101.4 24.25 138.8 59.38 172.1C421.4 367.6 414.1 384 400 384zM272.1 448c-7.438 0-14.36 4.146-16.9 10.88C250.6 471.2 238.3 480 223.1 480s-26.61-8.824-31.25-21.12C190.2 452.1 183.3 448 175.8 448c-10.61 0-18.37 9.998-15.08 19.72C169.4 493.4 194.5 512 223.1 512c29.47 0 54.56-18.63 63.22-44.28C290.5 457.1 282.8 448 272.1 448zM288 224h-48V176c0-8.844-7.156-15.1-16-15.1S208 167.2 208 176V224H160C151.2 224 144 231.2 144 240S151.2 256 160 256h48v48c0 8.844 7.156 16 16 16S240 312.8 240 304V256H288c8.844 0 16-7.156 16-15.1S296.8 224 288 224z"],
    "bell-school": [512, 512, [], "f5d5", "M464 352c-26.5 0-48 21.5-48 48c0 20.12 12.5 37.38 30.12 44.5C440.6 464.9 422.1 480 400 480H352v-122.2c47.82-46 73.89-114.3 60.5-188.6c-14.8-82.13-80.19-148.9-162.1-165.1C116.1-22.18 0 79.25 0 208c0 58.88 24.62 111.1 64 149.8V448c0 35.2 28.8 64 64 64h272c39.5 0 72.25-28.88 78.63-66.5C497.9 439.3 512 421.4 512 400C512 373.5 490.5 352 464 352zM320 448c0 17.67-14.33 32-32 32H128c-17.67 0-32-14.33-32-32v-64.88C128.4 403.9 166.8 416 208 416s79.63-12.12 112-32.88V448zM208 384C111 384 32 305 32 208S111 32 208 32S384 111 384 208S305 384 208 384zM464 416c-8.75 0-16-7.125-16-16s7.25-16 16-16s16 7.125 16 16S472.8 416 464 416zM208 128C163.9 128 128 163.9 128 208S163.9 288 208 288S288 252.1 288 208S252.1 128 208 128zM208 256C181.5 256 160 234.5 160 208S181.5 160 208 160S256 181.5 256 208S234.5 256 208 256z"],
    "bell-school-slash": [640, 512, [], "f5d6", "M272 32C369 32 448 111 448 208c0 20.8-3.822 40.68-10.49 59.23l26.13 20.63c14.91-35.57 20.53-76.01 12.86-118.6c-14.8-82.13-80.19-148.9-162.1-165.1C252.6-8.018 194.5 7.416 149.8 40.05l26.19 20.68C203.6 42.63 236.6 32 272 32zM262.4 128.1l88.7 70.03c-4.537-39.84-38.05-70.1-79.09-70.1C268.7 128 265.6 128.6 262.4 128.1zM464 480H416v-66.68l-32-25.26V448c0 17.67-14.33 32-32 32H192c-17.67 0-32-14.33-32-32v-64.88c32.38 20.75 70.75 32.87 112 32.87c39.75 0 76.69-11.47 108.3-30.85l-26.93-21.26C329 376.7 301.4 384 272 384C175 384 96 305 96 208c0-14.84 2.051-29.17 5.529-42.95L74.38 143.6c-6.611 20.3-10.38 41.88-10.38 64.39c0 58.88 24.62 111.1 63.1 149.8L128 448c0 35.2 28.8 64 64 64l272-.002c19.98 0 38.19-7.418 52.18-19.59l-26.21-20.69C482.4 476.7 473.7 480 464 480zM633.9 483.4L25.9 3.418C18.1-2.02 8.936-.8477 3.436 6.059c-5.469 6.939-4.281 17 2.656 22.49l608 480C617 510.9 620.5 512 624 512c4.719 0 9.406-2.094 12.56-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "bell-slash": [640, 512, [61942, 61943], "1f515", "M638 488.3c-1.002-1.824-2.377-3.482-4.111-4.854L25.9 3.236C23.25 1.148 20.09 .3242 16.95 .1348C16.36 .1016 15.78-.0254 15.19 .0039C13.7 .084 12.27 .4883 10.85 .9727C10.17 1.207 9.457 1.295 8.811 1.621C6.801 2.633 4.928 4.004 3.436 5.877C2.068 7.613 1.117 9.545 .5684 11.55C.0195 13.56-.1289 15.63 .1113 17.67c.2402 2.035 .8691 4.027 1.869 5.852c1.002 1.822 2.377 3.48 4.111 4.852l608 480.2C617 510.9 620.5 512 624 512c4.719 0 9.406-2.094 12.56-6.08c2.734-3.471 3.805-7.723 3.324-11.79C639.6 492.1 639 490.1 638 488.3zM320 64c70.75 0 128 54.5 128 121.9c0 43.57 4.691 74.88 12.59 99.57c0 0 72.56 52.9 68.79 49.3c-28-26.5-49.38-54.38-49.38-148.9c0-79.63-63.38-144.5-144-152.4V16c0-8.875-7.125-15.1-15.1-15.1S304 7.125 304 16v17.5C264.2 37.39 228.6 55.28 202.8 81.9l24.1 19.73C251.1 78.52 283.7 64 320 64zM368.1 448c-7.438 0-14.36 4.146-16.9 10.88C346.6 471.2 334.3 480 319.1 480s-26.61-8.824-31.25-21.12C286.2 452.1 279.3 448 271.8 448c-10.61 0-18.37 9.998-15.08 19.72C265.4 493.4 290.5 512 319.1 512c29.47 0 54.56-18.63 63.22-44.28C386.5 457.1 378.8 448 368.1 448zM143.1 384c-14.25 0-21.38-16.5-11.38-25.1c28.57-27.24 49.93-57.7 56.81-123.6L159.3 210.6C155.7 285.2 135.9 310.8 110.6 334.8c-14 13.38-18.38 33.5-11.25 51.25C106.6 404.3 124.1 416 143.1 416h275.4l-40.53-32H143.1z"],
    "bells": [640, 512, [], "f77f", "M204.6 403.9c-7.391-4.877-17.3-2.812-22.16 4.562c-7.016 10.67-20.36 15.44-32.41 11.55c-12.02-3.906-20.02-15.58-19.47-28.38c.375-8.828-6.469-16.3-15.3-16.67c-8.719-.4844-16.3 6.469-16.67 15.3c-1.156 27.1 15.92 51.85 41.58 60.21c6.031 1.938 12.22 2.875 18.33 2.875c19.95 0 39.25-9.953 50.66-27.28C214 418.6 211.1 408.7 204.6 403.9zM260.1 365.7L37.42 293c-4.062-1.328-5.172-4.328-5.375-6.609c-.125-1.203-.1719-5.312 3.891-7.547l3.594-1.969C59.9 265.8 94.01 247.2 117.9 173.2c.75-2.484 11.47-35.92 12.22-38.16c8.391-26.08 26.45-47.3 50.84-59.77c24.5-12.52 52.44-14.67 78.66-6.156C266.8 71.45 273.6 74.5 279.9 78.19C287.6 82.67 297.4 80.06 301.8 72.44c4.453-7.625 1.891-17.42-5.75-21.88C287.8 45.72 278.8 41.73 269.5 38.7C235.2 27.53 198.6 30.39 166.4 46.8c-32.02 16.36-55.72 44.22-66.69 78.27C99.11 127 87.87 162.1 87.37 163.8C67.5 225.2 41.47 239.4 24.23 248.8L20.45 250.9C6.67 258.4-1.283 273.5 .1699 289.3c1.469 15.99 11.92 29.05 27.31 34.1l223.6 72.72c1.641 .5313 3.312 .7813 4.953 .7813c6.75 0 13.02-4.297 15.22-11.05C273.1 377.5 269.4 368.4 260.1 365.7zM618.5 275.4l-3.781-1.875c-17.69-8.688-44.41-21.81-66.78-83.39c-1.156-2.924-12.95-35.5-13.67-37.47c-25.56-69.8-103.3-105.8-173.3-80.46c-33.97 12.31-61.08 37.1-76.33 69.8C269.4 174.6 267.9 211.1 280.2 244.8C280.8 246.7 293.5 281.1 294.2 282.9c22.14 60.69 10.33 87.86 2.5 105.8l-1.703 3.984c-6.234 14.41-3.219 31.22 7.672 42.8c7.688 8.188 17.97 12.55 28.66 12.55c4.594 0 9.281-.8125 13.86-2.453l268.7-97.41c14.84-5.424 25.09-19.28 26.11-35.33C640.9 297.1 632.7 282.7 618.5 275.4zM602.9 318.1l-268.6 97.38c-4.047 1.5-6.766-.2187-8.312-1.891c-.8438-.8906-3.406-4.078-1.562-8.344l1.625-3.766c9.25-21.28 24.73-56.88-1.906-129.9c-.875-2.25-13.14-35.67-13.86-37.69C300.8 208.2 302 180.4 313.6 155.5c11.62-24.94 32.31-43.85 58.25-53.25c11.62-4.219 23.53-6.219 35.25-6.219c42.13 0 81.78 25.89 97.02 67.46c.6875 1.922 13.34 36.78 13.89 38.06c26.58 73.16 61.61 90.38 82.55 100.7l3.297 1.625c2.938 1.547 4.312 3.891 4.125 6.969C607.8 313.4 606.4 316.8 602.9 318.1zM534.3 400.1c-8.812 .7207-15.38 8.424-14.67 17.24c1.031 12.73-6.578 24.69-18.45 29.03c-11.81 4.344-25.34 .0313-32.81-10.41c-5.125-7.203-15.14-8.844-22.31-3.719c-7.188 5.141-8.859 15.12-3.719 22.31C453.9 470.8 472.6 480 491.7 480c6.812 0 13.7-1.156 20.34-3.562c25.38-9.297 41.56-34.66 39.41-61.67C550.8 405.1 543.4 399.3 534.3 400.1z"],
    "bench-tree": [640, 512, [], "e2e7", "M368 368H320V320c17.67 0 32-14.33 32-32V224c0-17.67-14.33-32-32-32H64C46.33 192 32 206.3 32 224v64c0 17.67 14.33 32 32 32v48H16C7.156 368 0 375.2 0 384s7.156 16 16 16H32v96C32 504.8 39.16 512 48 512S64 504.8 64 496v-96h256v96c0 8.844 7.156 16 16 16s16-7.156 16-16v-96h16c8.844 0 16-7.156 16-16S376.8 368 368 368zM288 368H96V320h192V368zM64 288V224h256v64H64zM606.5 111.1C607.3 106.2 608 101.2 608 96c0-53.02-42.98-96-96-96s-96 42.98-96 96c0 5.174 .7363 10.15 1.523 15.11C397.3 125.6 384 149.2 384 176C384 220.2 419.8 256 464 256h32v232c0 8.844 7.156 16 16 16s16-7.156 16-16V256h32C604.2 256 640 220.2 640 176C640 149.2 626.7 125.6 606.5 111.1zM560 224h-32V96c0-8.844-7.156-16-16-16S496 87.16 496 96v128h-32C437.5 224 416 202.5 416 176c0-15.52 7.355-29.69 20.18-38.9c9.836-7.059 14.85-19.06 12.95-31.02C448.5 102.2 448 98.77 448 96c0-35.29 28.71-64 64-64s64 28.71 64 64c0 2.766-.5098 6.203-1.127 10.08c-1.9 11.96 3.109 23.96 12.95 31.02C600.6 146.3 608 160.5 608 176C608 202.5 586.5 224 560 224z"],
    "bezier-curve": [640, 512, [], "f55b", "M576 208c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64c-29.79 0-54.6 20.45-61.74 48H400V112C400 85.49 378.5 64 352 64H288C261.5 64 240 85.49 240 112V128H125.7C118.6 100.4 93.79 80 64 80c-35.35 0-64 28.65-64 64c0 35.35 28.65 64 64 64c29.79 0 54.6-20.44 61.74-48h79.48c-47.47 28.49-83.61 73.9-99.78 128H80C53.49 288 32 309.5 32 336v64C32 426.5 53.49 448 80 448h64C170.5 448 192 426.5 192 400v-64C192 309.5 170.5 288 144 288H139.2c17.4-49 54.07-88.84 100.1-110.4C241 203.4 262 224 288 224h64c25.96 0 46.97-20.64 47.84-46.39C446.7 199.2 483.4 238.1 500.8 288H496C469.5 288 448 309.5 448 336v64c0 26.51 21.49 48 48 48h64c26.51 0 48-21.49 48-48v-64C608 309.5 586.5 288 560 288h-25.43c-16.17-54.1-52.31-99.51-99.78-128h79.48C521.4 187.6 546.2 208 576 208zM576 112c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S558.4 112 576 112zM64 176c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S81.64 176 64 176zM144 320C152.8 320 160 327.2 160 336v64C160 408.8 152.8 416 144 416h-64C71.18 416 64 408.8 64 400v-64C64 327.2 71.18 320 80 320H144zM368 176C368 184.8 360.8 192 352 192H288C279.2 192 272 184.8 272 176v-64C272 103.2 279.2 96 288 96h64c8.822 0 16 7.178 16 16V176zM560 320c8.822 0 16 7.178 16 16v64c0 8.822-7.178 16-16 16h-64c-8.822 0-16-7.178-16-16v-64c0-8.822 7.178-16 16-16H560z"],
    "bicycle": [640, 512, [61958], "1f6b2", "M512 224c-15.83 0-30.82 3.25-44.81 8.504l-101-191.1C363.4 35.3 357.9 32 352 32H304C295.2 32 288 39.16 288 48S295.2 64 304 64h38.34l50.53 96H225.9L189.5 103.3C186.5 98.77 181.4 96 176 96H112C103.2 96 96 103.2 96 112S103.2 128 112 128h55.27l34.1 54.44L174.6 233.1C160.2 227.4 144.5 224 128 224c-70.69 0-128 57.31-128 128c0 70.69 57.31 128 128 128c65.21 0 118.4-48.95 126.4-112H320c5.859 0 11.25-3.203 14.05-8.344l83.42-152.9l21.31 40.5C405.7 270.4 384 308.6 384 352c0 70.69 57.31 128 128 128c70.69 0 128-57.31 128-128C640 281.3 582.7 224 512 224zM128 448c-52.94 0-96-43.07-96-96c0-52.94 43.06-96 96-96c10.94 0 21.28 2.229 31.08 5.611l-45.13 82.73C108.1 355 115.9 368 128 368h94.38C214.7 413.3 175.5 448 128 448zM154.1 336l67.03-122.9L300.1 336H154.1zM323.6 312L246.4 192h142.6L323.6 312zM512 448c-52.94 0-96-43.07-96-96c0-31.03 15.04-58.38 37.95-75.94l43.89 83.39c9.699 18.45 38.34 4.129 28.31-14.91l-43.87-83.36C491.7 258.1 501.6 256 512 256c52.94 0 96 43.06 96 96C608 404.9 564.9 448 512 448z"],
    "binary": [384, 512, [], "e33b", "M304 288h-32c-44.13 0-80 35.89-80 80v63.1C192 476.1 227.9 512 272 512h32c44.13 0 80-35.89 80-79.1v-63.1C384 323.9 348.1 288 304 288zM352 432C352 458.5 330.5 480 304 480h-32c-26.47 0-48-21.53-48-47.1v-63.1c0-26.47 21.53-47.1 48-47.1h32c26.47 0 48 21.53 48 47.1V432zM144 480H96V304c0-5.141-2.469-9.969-6.656-12.98c-4.156-3-9.531-3.859-14.41-2.188l-48 16c-8.375 2.781-12.91 11.84-10.12 20.23c2.812 8.391 11.91 12.92 20.25 10.11L64 326.2V480H16C7.156 480 0 487.2 0 496S7.156 512 16 512h128C152.8 512 160 504.8 160 496S152.8 480 144 480zM240 224h128c8.844 0 16-7.156 16-16s-7.156-16-16-16H320V16.01c0-5.141-2.469-9.969-6.656-12.98c-4.188-3-9.5-3.859-14.41-2.188l-48 16c-8.375 2.781-12.91 11.84-10.12 20.23c2.812 8.391 11.88 12.91 20.25 10.11L288 38.22v153.8h-48c-8.844 0-16 7.156-16 16S231.2 224 240 224zM192 80.01c0-44.11-35.88-80-80-80h-32c-44.13 0-80 35.9-80 80v63.1c0 44.11 35.88 79.99 80 79.99h32c44.13 0 80-35.88 80-79.99V80.01zM160 144c0 26.47-21.53 47.1-48 47.1h-32c-26.47 0-48-21.53-48-47.1v-63.1c0-26.47 21.53-47.1 48-47.1h32c26.47 0 48 21.53 48 47.1V144z"],
    "binary-circle-check": [640, 512, [], "e33c", "M496 224C416.5 224 352 288.5 352 368S416.5 512 496 512C575.5 512 640 447.5 640 368S575.5 224 496 224zM496 480C434.2 480 384 429.8 384 368S434.2 256 496 256C557.8 256 608 306.2 608 368S557.8 480 496 480zM540.7 319.4l-63.34 63.34l-26.03-26.02c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.37 0 22.62l37.34 37.33c3.125 3.125 7.219 4.687 11.31 4.687s8.188-1.562 11.31-4.687l74.66-74.66c6.25-6.25 6.25-16.37 0-22.62S546.9 313.1 540.7 319.4zM144 480H96V304c0-5.141-2.469-9.969-6.656-12.98c-4.156-3-9.609-3.985-14.48-2.313L26.94 304.8c-8.375 2.781-12.91 11.84-10.12 20.23c2.812 8.391 11.91 12.92 20.25 10.11L64 326.2V480H16C7.156 480 0 487.2 0 496S7.156 512 16 512h128C152.8 512 160 504.8 160 496S152.8 480 144 480zM240 224h128c8.844 0 16-7.156 16-16s-7.156-16-16-16H320V16.01c0-5.141-2.469-9.969-6.656-12.98c-4.188-3-9.578-3.986-14.48-2.314L250.9 16.84C242.6 19.62 238 28.69 240.8 37.08c2.812 8.391 11.88 12.91 20.25 10.11L288 38.22v153.8H240c-8.844 0-16 7.156-16 16S231.2 224 240 224zM192 80.01c0-44.11-35.88-80-80-80h-32c-44.13 0-80 35.9-80 80v63.1c0 44.11 35.88 79.99 80 79.99h32c44.13 0 80-35.88 80-79.99V80.01zM160 144c0 26.47-21.53 47.1-48 47.1h-32c-26.47 0-48-21.53-48-47.1v-63.1c0-26.47 21.53-47.1 48-47.1h32c26.47 0 48 21.53 48 47.1V144zM355.6 473c-5.244-7.049-15.39-8.646-22.29-3.217C325.3 476.2 315.1 480 304 480h-32C245.5 480 224 458.5 224 432v-63.1c0-26.51 21.49-47.1 47.1-47.1H304c3.039 0 5.996 .3105 8.857 .8867c7.645 1.537 15.16-3.307 17.71-10.68c3.182-9.201-2.59-19.05-12.16-20.86C313.7 288.5 308.9 288 304 288h-32c-44.18 0-80 35.82-80 80v63.1C192 476.2 227.8 512 271.1 512H304c18.54 0 35.47-6.471 48.97-17.15C359.6 489.6 360.7 479.8 355.6 473z"],
    "binary-lock": [640, 512, [], "e33d", "M591.1 320L592 256c0-35.28-28.72-63.1-64-63.1S464 220.7 464 256l-.001 64c-26.51 0-48 21.49-48 47.1V464c0 26.51 21.49 48 48 48h128c26.51 0 48-21.49 48-48v-96C639.1 341.5 618.5 320 591.1 320zM496 256c0-17.66 14.34-32 31.1-32S560 238.3 560 256v64h-64V256zM608 464c0 8.822-7.178 16-16 16h-128c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16V464zM144 480H96V304c0-5.141-2.469-9.969-6.656-12.98c-4.156-3-9.609-3.985-14.48-2.313L26.94 304.8c-8.375 2.781-12.91 11.84-10.12 20.23c2.812 8.391 11.91 12.92 20.25 10.11L64 326.2V480H16C7.156 480 0 487.2 0 496S7.156 512 16 512h128C152.8 512 160 504.8 160 496S152.8 480 144 480zM368 192H320V16.01c0-5.141-2.469-9.969-6.656-12.98c-4.188-3-9.578-3.986-14.48-2.314L250.9 16.84C242.6 19.62 238 28.69 240.8 37.08c2.812 8.391 11.88 12.91 20.25 10.11L288 38.22v153.8H240c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16S376.8 192 368 192zM304 288h-32c-44.13 0-80 35.89-80 80v63.1C192 476.1 227.9 512 272 512h32c44.13 0 80-35.89 80-79.1v-63.1C384 323.9 348.1 288 304 288zM352 432C352 458.5 330.5 480 304 480h-32C245.5 480 224 458.5 224 432v-63.1c0-26.47 21.53-47.1 48-47.1h32c26.47 0 48 21.53 48 47.1V432zM192 80.01c0-44.11-35.88-80-80-80h-32c-44.13 0-80 35.9-80 80v63.1c0 44.11 35.88 79.99 80 79.99h32c44.13 0 80-35.88 80-79.99V80.01zM160 144c0 26.47-21.53 47.1-48 47.1h-32c-26.47 0-48-21.53-48-47.1v-63.1c0-26.47 21.53-47.1 48-47.1h32c26.47 0 48 21.53 48 47.1V144z"],
    "binary-slash": [640, 512, [], "e33e", "M496 224c8.844 0 16-7.156 16-16s-7.156-16-16-16H448V16.01c0-5.141-2.469-9.969-6.656-12.98c-4.188-3-9.578-3.986-14.48-2.314l-47.92 16.13c-8.375 2.781-12.91 11.84-10.12 20.23c2.812 8.391 11.88 12.91 20.25 10.11L416 38.22v153.8h-48c-6.326 0-11.67 3.742-14.27 9.064l29.21 22.97L496 224zM208 32.01h32c26.47 0 48 21.53 48 47.1v63.1c0 1.641-.3223 3.191-.4844 4.791L315.1 170.6C318.1 162.2 320 153.4 320 144v-63.1c0-44.11-35.88-80-80-80h-32c-27.11 0-51.03 13.63-65.5 34.31l25.17 19.87C176.2 40.89 191.1 32.01 208 32.01zM432 480h-32c-26.47 0-48-21.53-48-47.1v-63.1c0-1.648 .3242-3.207 .4863-4.812l-27.59-21.79C321.9 349.8 320 358.6 320 368v63.1C320 476.1 355.9 512 400 512h32c27.12 0 51.04-13.63 65.51-34.32l-25.17-19.87C463.8 471.1 448.1 480 432 480zM272 480H224V304c0-5.141-2.469-9.969-6.656-12.98c-4.156-3-9.609-3.985-14.48-2.313L154.9 304.8c-8.375 2.781-12.91 11.84-10.12 20.23c2.812 8.391 11.91 12.92 20.25 10.11L192 326.2V480H144C135.2 480 128 487.2 128 496S135.2 512 144 512h128C280.8 512 288 504.8 288 496S280.8 480 272 480zM633.9 483.4l-608-480c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "binoculars": [512, 512, [], "f1e5", "M112 64h96C216.8 64 224 56.84 224 48S216.8 32 208 32h-96C103.2 32 96 39.16 96 48S103.2 64 112 64zM304 64h96C408.8 64 416 56.84 416 48S408.8 32 400 32h-96C295.2 32 288 39.16 288 48S295.2 64 304 64zM511.6 404c-3.375-129.8-61-182.1-63.5-276c-.5-17.62-14.46-32-32.08-32H95.96c-17.62 0-31.58 14.38-32.08 32c-2.5 93.88-60.13 146.3-63.5 276L0 432C0 458.5 21.5 480 48 480h128C202.5 480 224 458.5 224 432V288h64v144c0 26.5 21.5 48 48 48h128c26.5 0 48-21.5 48-48L511.6 404zM192 432C192 440.8 184.8 448 176 448h-128c-8.822 0-16-7.178-16-15.57l.3672-27.6c1.686-64.81 17.99-108.7 33.76-151C80.11 216.2 94.57 177.3 95.88 128H192V432zM288 256H224V128h64V256zM464 448h-128c-8.822 0-16-7.178-16-16V128h96.13l.0098 .6924c1.291 48.45 15.76 87.49 29.74 125.1c15.77 42.39 32.07 86.23 33.75 150.6L480 432C480 440.8 472.8 448 464 448z"],
    "biohazard": [576, 512, [63360], "2623", "M288 248c-13.31 0-24 10.69-24 24c0 13.22 10.69 24 24 24s24-10.78 24-24C312 258.7 301.3 248 288 248zM288.2 95.99c17.62 0 34.75 2.75 50.87 7.623c6.5-8.498 11.12-18.37 13.12-29.37C331.9 67.75 310.3 63.94 288.1 63.94c-22.37 0-43.9 3.809-64.15 10.31c1.875 10.1 6.625 20.99 13.12 29.49C253.3 98.74 270.3 95.99 288.2 95.99zM407.4 401c5.5 9.123 12.88 17.12 22.5 22.74c32.75-30.49 55.37-71.36 63.12-117.3c-9.375-5.123-19.75-7.998-30.25-7.998c-.25 0-.5 .125-.875 .125C455.8 338.7 436 374.5 407.4 401zM574.8 276.6c-13.88-40.36-41.25-74.11-77.24-95.35c-12.25-7.123-25.62-12.75-40.12-16.62c3.5-13.87 5.25-27.37 5.25-40.86c0-42.11-15.12-83.1-42.37-115.5c-7.375-8.498-19.75-10.87-29.75-5.123c-9.748 5.623-14.12 17.37-10.62 27.87c3.748 11.25 5.498 21.49 5.498 31.12c0 54.61-43.62 99.22-97.24 99.22c-53.75 0-97.37-44.49-97.37-99.22c0-9.623 1.875-19.87 5.5-30.99c3.5-10.75-1-22.49-10.75-27.99c-9.748-5.623-22.25-3.5-29.62 5.123c-27.37 32.37-42.5 73.35-42.5 115.5c0 13.5 1.75 26.99 5.25 40.86C104.2 168.6 90.79 174.2 78.54 181.2c-35.1 21.12-63.37 54.98-77.24 95.35c-3.625 10.62 .5 22.12 10.25 28.12c9.75 5.75 22.25 3.75 29.75-4.873c7.625-8.748 15.37-15.5 23.5-20.24C87.17 266.4 113.2 262.9 138 269.7c25.25 6.748 46.37 23.12 59.5 46.11c26.87 47.49 10.87 108.3-35.75 135.8C153.7 456.4 144.2 459.9 132.8 462.3c-10.1 2.375-18.75 12.12-18.62 23.37s8.125 20.99 19.12 23.12C144.3 510.9 155.3 512 166.3 512c30.5 0 60.5-7.998 86.99-23.62c12.5-7.246 23.1-16.49 34.62-27.24c10.75 10.87 22.37 19.1 34.75 27.24c35.1 21.24 78.62 28.49 119.9 20.37c11.12-2.123 18.87-11.62 19.12-23.12c.125-11.25-7.873-20.99-18.75-23.37c-11.38-2.373-20.75-5.873-28.1-10.62c-46.62-27.49-62.62-88.35-35.62-135.8c12.1-22.99 34.12-39.36 59.49-46.11c24.87-6.748 50.87-3.25 73.12 9.871c8.25 4.748 15.88 11.37 23.62 20.24c7.5 8.623 20 10.5 29.75 4.748C574.3 298.7 578.3 287.2 574.8 276.6zM429.6 238.7c-33.75 8.998-61.75 30.87-78.99 61.36c-35.62 62.61-14.38 142.1 47.12 179.1c.25 0 .375 .125 .5 .125c-20.87-1.625-41.12-7.998-59.37-18.62c-14.12-8.373-26.1-19.75-38.37-33.87l-12.5-15.37l-12.5 15.49c-11.38 14.12-24.25 25.49-38.37 33.74c-18.25 10.75-38.5 16.99-59.37 18.74c.125-.125 .375-.25 .5-.25c61.49-36.12 82.74-116.5 47.25-178.9C208.3 269.7 180.2 247.8 146.4 238.8c-11-2.998-22.12-4.373-33.12-4.373c-22.37 0-44.37 5.873-64.12 17.37c11.87-17.49 27.37-32.12 45.62-42.86C108.7 200.8 123.9 195.3 141.7 192.2l18.5-3.125L154 171.2C148.3 154.6 145.4 139.1 145.4 123.7c0-20.99 4.625-41.86 13.37-60.86c.375 71.98 58.12 130.5 129.2 130.5c70.99 0 128.9-58.48 129.2-130.5c8.75 18.99 13.38 39.86 13.38 60.86c0 15.25-2.875 30.74-8.5 47.49l-6.125 17.74l18.5 3.25c17.75 3 32.1 8.498 46.87 16.62c18.25 10.75 33.75 25.37 45.62 42.86C497.3 234.6 462.8 229.8 429.6 238.7zM168.8 400.8c-28.5-26.37-48.25-62.11-54.5-102.3c-.375 0-.75-.25-1.125-.25c-10.37 0-20.75 3-29.1 7.998c7.625 45.99 30.37 86.85 62.1 117.3C155.8 417.9 163.3 409.9 168.8 400.8z"],
    "bitcoin-sign": [320, 512, [], "e0b4", "M252.9 233.6C274.2 215.9 288 189.7 288 160c0-52.94-43.06-96-96-96V16C192 7.156 184.8 0 176 0S160 7.156 160 16V64H96V16C96 7.156 88.84 0 80 0S64 7.156 64 16V64H16C7.156 64 0 71.16 0 80v352C0 440.8 7.156 448 16 448H64v48C64 504.8 71.16 512 80 512S96 504.8 96 496V448h64v48c0 8.844 7.156 16 16 16s16-7.156 16-16V448h16c61.75 0 112-50.25 112-112C320 290.2 292.3 250.9 252.9 233.6zM32 96h160c35.28 0 64 28.72 64 64s-28.72 64-64 64H32V96zM208 416H32V256h176c44.13 0 80 35.88 80 80S252.1 416 208 416z"],
    "blanket": [448, 512, [], "f498", "M392 368H96c-8.844 0-16 7.156-16 16s7.156 16 16 16h296c30.88 0 56-25.12 56-56V112C448 67.89 412.1 32 368 32h-288C35.88 32 0 67.89 0 112V384c0 52.94 43.06 96 96 96h336c8.844 0 16-7.156 16-16S440.8 448 432 448H96c-35.28 0-64-28.7-64-64s28.72-64 64-64h296c13.22 0 24 10.77 24 24S405.2 368 392 368zM392 288H96C71.32 288 49.02 297.6 32 312.1V112C32 85.53 53.53 64 80 64h288C394.5 64 416 85.53 416 112v181.6C408.7 290.1 400.6 288 392 288z"],
    "blender": [512, 512, [], "f517", "M288 400c-13.25 0-24 10.75-24 24S274.8 448 288 448s24-10.75 24-24S301.3 400 288 400zM470.6 0H48C21.49 0 0 21.49 0 48v160C0 234.5 21.49 256 48 256h102.3l7.5 86.5C121.8 356.4 96 391.1 96 432L96 480c0 17.6 14.4 32 32 32h320c17.6 0 32-14.4 32-32L480 432c0-39.38-23.75-73.13-57.75-88l79.29-303.9C506.8 19.8 491.5 0 470.6 0zM48 224C39.25 224 32 216.9 32 208v-160C32 39.13 39.25 32 48 32h82.75L147.5 224H48zM448 432V480H128v-48c0-35.25 28.75-64 64-64h192C419.3 368 448 396.8 448 432zM453.9 96H304C295.2 96 288 103.2 288 111.1S295.2 128 304 128h141.5l-16.62 64H304C295.2 192 288 199.2 288 207.1S295.2 224 304 224h116.5l-29.25 112H189.4L162.9 32h307.8L453.9 96z"],
    "blender-phone": [576, 512, [], "f6b6", "M534.6 0H226.9C208.1 0 193.4 16.07 195 34.77l26.73 307.7c-36 13.88-61.75 48.63-61.75 89.5l.0088 47.1c0 17.6 14.4 31.1 31.1 31.1L511.1 512c17.6 0 32-14.4 32-31.1L543.1 432c0-39.38-23.75-73.13-57.75-88l79.29-303.9C570.8 19.8 555.5 0 534.6 0zM511.1 432V480h-320v-48c0-35.25 28.75-63.1 64-63.1h192C483.2 368 511.1 396.8 511.1 432zM517.9 96l-149.9 .0049c-8.801 0-16 7.199-16 16s7.199 15.1 16 15.1L509.5 128l-16.62 64l-124.9 .0039c-8.801 0-16 7.198-16 15.1s7.199 16 16 16L484.5 224l-29.25 112H253.4L226.9 32h307.8L517.9 96zM176.4 317.1l-23.62-58c-5.125-12.75-18-20.88-32.13-19.38l-28.5 2.875C82.37 209.6 82.37 174.5 91.99 141.5l28.62 2.875c13.75 1.375 27-6.625 32.13-19.38l23.75-58c5.625-14.12 .375-30.12-12.62-38l-36-22.12c-19.5-11.88-45-8-60.63 9.5c-90.5 101.3-89.5 253.4 2.125 353.6C77.62 379.1 90.37 384 103.1 384c8.625 0 17.25-2.25 24.62-6.75l36.13-22.12C176.9 347.1 182.1 331.1 176.4 317.1zM110.1 350c-5.25 3.25-14.38 2.5-18-1.5C12.37 260.3 11.62 126.6 91.12 37.63C94.49 34 98.99 32 103.4 32c2.75 0 5.375 .75 7.75 2.125L146.7 55l-23 57.5L70.12 107.3L65.87 118.9c-17.38 47.13-17.38 99.13 0 146.4l4.25 11.62l53-5.75l23.38 57.13L110.1 350zM351.1 400c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S365.2 400 351.1 400z"],
    "blinds": [512, 512, [], "f8fb", "M495.1 0H16c-8.836 0-15.1 7.164-15.1 16l.0065 64c0 8.836 7.162 16 15.1 16h111.1v96H36.51l11.03-44.12C50.06 137.8 42.42 128 32.01 128C24.67 128 18.26 133 16.48 140.1l-15.97 63.1C-2.021 213.7 5.16 224 16.01 224h111.1v35C114.4 263.8 103.8 274.4 99.01 288h-62.5l3.029-12.12C42.06 265.8 34.42 256 24.01 256C16.66 256 10.26 261 8.484 268.1L.5098 300.1C-2.021 309.7 5.16 320 16.01 320h82.1c9.051 25.92 38.62 39.8 65.6 27.54c10.08-4.58 18.35-12.85 22.93-22.93c12.26-26.99-1.611-56.56-27.54-65.61V96h335.1c8.836 0 16-7.164 16-16l.0052-64C511.1 7.164 504.8 0 495.1 0zM144 320c-8.875 0-16-7.125-16-16s7.125-16 16-16s16 7.125 16 16S152.9 320 144 320zM479.1 64H32.01V32h447.1V64zM503.5 460.1C501.7 453 495.3 448 487.1 448c-10.41 0-18.05 9.783-15.52 19.88L475.5 480H36.51l3.029-12.12C42.06 457.8 34.42 448 24.01 448c-7.348 0-13.75 5.004-15.53 12.13l-7.975 31.99C-2.021 501.7 5.16 512 16.01 512h479.1c10.86 0 18.03-10.27 15.5-19.88L503.5 460.1zM503.5 364.1C501.7 357 495.3 352 487.1 352c-10.41 0-18.05 9.783-15.52 19.88L475.5 384H36.51l3.029-12.12C42.06 361.8 34.42 352 24.01 352c-7.348 0-13.75 5.004-15.53 12.13l-7.975 31.99C-2.021 405.7 5.155 416 16 416H495.1c10.86 0 18.02-10.27 15.49-19.88L503.5 364.1zM495.5 140.1C493.7 133 487.3 128 479.1 128c-10.41 0-18.05 9.783-15.53 19.88L475.5 192H192L192 224h303.1c10.86 0 18.03-10.27 15.5-19.88L495.5 140.1zM503.5 268.1C501.7 261 495.3 256 487.1 256c-10.41 0-18.05 9.783-15.53 19.88L475.5 288H222.4c2.125 10.5 2.125 21.5 0 32h273.6c10.86 0 18.03-10.27 15.5-19.88L503.5 268.1z"],
    "blinds-open": [512, 512, [], "f8fc", "M496 480h-480C7.125 480 0 487.1 0 496S7.125 512 16 512h480c8.875 0 16-7.125 16-16S504.9 480 496 480zM16 352h64.38c-7.25-9.375-12.25-20.38-14.75-32H16C7.125 320 0 327.1 0 336S7.125 352 16 352zM496 320H222.4c-2.5 11.62-7.5 22.62-14.75 32H496c8.875 0 16-7.125 16-16S504.9 320 496 320zM496 0h-480C7.125 0 0 7.125 0 16v64C0 88.88 7.125 96 16 96H128v64H16C7.125 160 0 167.1 0 176S7.125 192 16 192H128v67C105.1 266.8 92.75 289.2 96.75 312.2C100.6 335.4 120.6 352.1 144 352.1s43.38-16.75 47.25-39.88C195.2 289.2 181.1 266.8 160 259V96h336C504.9 96 512 88.88 512 80v-64C512 7.125 504.9 0 496 0zM144 320C135.1 320 128 312.9 128 304S135.1 288 144 288S160 295.1 160 304S152.9 320 144 320zM480 64H32V32h448V64zM496 160H192v32h304C504.9 192 512 184.9 512 176S504.9 160 496 160z"],
    "blinds-raised": [512, 512, [], "f8fd", "M495.1 0H16c-8.836 0-15.1 7.163-15.1 15.99l.0065 63.97c0 8.832 7.162 15.99 15.1 15.99h111.1L128 159.9l-91.49 .0573l3.029-12.11c2.525-10.1-5.118-19.84-15.53-19.84c-7.348 0-13.75 4.969-15.52 12.1L.5098 172c-2.531 9.615 4.65 19.87 15.5 19.87h111.1v63.97H36.51l3.029-12.11C42.06 233.7 34.42 223.9 24.01 223.9c-7.348 0-13.75 5-15.53 12.13L.5098 267.1C-2.021 277.6 5.16 287.9 16.01 287.9h111.1l-.0026 130.9c-21.1 7.746-35.25 30.25-31.25 53.24C100.6 495.1 120.6 512 144 512s43.38-16.87 47.25-39.98c4-22.99-9.25-45.48-31.25-53.22V95.95h335.1c8.836 0 16-7.16 16-15.99l.0052-63.97C511.1 7.163 504.8 0 495.1 0zM144 479.8c-8.875 0-16-7.121-16-15.99s7.125-15.99 16-15.99s16 7.121 16 15.99S152.9 479.8 144 479.8zM479.1 63.97H32.01V31.98h447.1V63.97zM503.5 236C501.7 228.9 495.3 223.9 487.1 223.9c-10.41 0-18.05 9.779-15.52 19.88l3.027 12.11H192l-.001 32.05l303.1-.0703c10.86 0 18.03-10.26 15.5-19.87L503.5 236zM503.5 140.1c-1.777-7.127-8.177-12.1-15.52-12.1c-10.41 0-18.05 9.748-15.53 19.84l3.027 12.11H192L192 191.1l303.1-.0469c10.86 0 18.03-10.26 15.5-19.87L503.5 140.1z"],
    "block-quote": [512, 512, [], "e0b5", "M512 96c0-8.801-7.199-16-16-16h-480C7.201 80 0 87.2 0 96c0 8.799 7.201 16 16 16h480C504.8 112 512 104.8 512 96zM16 224C7.201 224 0 231.2 0 240v192C0 440.8 7.201 448 16 448C24.8 448 32 440.8 32 432v-192C32 231.2 24.8 224 16 224zM496 400h-352C135.2 400 128 407.2 128 416c0 8.799 7.201 16 16 16h352c8.801 0 16-7.201 16-16C512 407.2 504.8 400 496 400zM496 240h-352C135.2 240 128 247.2 128 256c0 8.799 7.201 16 16 16h352C504.8 272 512 264.8 512 256C512 247.2 504.8 240 496 240z"],
    "blog": [512, 512, [], "f781", "M160 224C151.2 224 144 231.2 144 240S151.2 256 160 256c52.94 0 96 43.06 96 96s-43.06 96-96 96s-96-43.06-96-96V112C64 103.2 56.84 96 48 96S32 103.2 32 112V352c0 70.58 57.41 128 128 128s128-57.42 128-128S230.6 224 160 224zM208 32C199.2 32 192 39.16 192 48S199.2 64 208 64C340.3 64 448 171.7 448 304c0 8.844 7.156 16 16 16S480 312.8 480 304C480 154 357.1 32 208 32zM208 128C199.2 128 192 135.2 192 144S199.2 160 208 160C287.4 160 352 224.6 352 304c0 8.844 7.156 16 16 16S384 312.8 384 304C384 206.1 305 128 208 128z"],
    "blueberries": [512, 512, [], "e2e8", "M176 160C78.8 160 0 238.8 0 336C0 433.2 78.8 512 176 512s176-78.8 176-176C352 238.8 273.2 160 176 160zM176 480C96.6 480 32 415.4 32 336S96.6 192 176 192S320 256.6 320 336S255.4 480 176 480zM336 0c-67.97 0-128.7 38.02-158.4 99.2C173.8 107.1 177.1 116.7 185 120.6c7.969 3.844 17.53 .5469 21.41-7.406C230.7 63.11 280.4 32 336 32C415.4 32 480 96.59 480 176c0 54.78-31.88 105.7-81.19 129.6c-7.938 3.859-11.25 13.44-7.406 21.38C394.2 332.7 399.9 336 405.8 336c2.344 0 4.75-.5156 7-1.609C473.1 305.1 512 242.1 512 176C512 78.95 433 0 336 0zM208 272h-32v-32C176 231.2 168.8 224 160 224S144 231.2 144 240v32h-32C103.2 272 96 279.2 96 288s7.156 16 16 16h32v32C144 344.8 151.2 352 160 352s16-7.156 16-16v-32h32C216.8 304 224 296.8 224 288S216.8 272 208 272zM416 128c0-8.844-7.156-16-16-16h-32v-32C368 71.16 360.8 64 352 64s-16 7.156-16 16v32h-32C295.2 112 288 119.2 288 128s7.156 16 16 16h32v32C336 184.8 343.2 192 352 192s16-7.156 16-16v-32h32C408.8 144 416 136.8 416 128z"],
    "bluetooth": [320, 512, [], "f293", "M184.1 255.1l129.3-107.7C317.9 145.2 320 140.7 320 135.1s-2.094-9.25-5.75-12.28l-144-120c-4.781-4.008-11.44-4.789-17.03-2.219c-5.625 2.656-9.221 8.281-9.221 14.5V221.8L26.24 123.7C19.49 118.1 9.4 118.1 3.713 125.7C-1.943 132.5-1.037 142.6 5.744 148.3l129.3 107.7l-129.3 107.7c-6.781 5.656-7.688 15.75-2.031 22.53s15.75 7.656 22.53 2.031l117.8-98.13V496c0 6.219 3.596 11.84 9.221 14.5C155.4 511.5 157.7 512 160 512c3.688 0 7.31-1.25 10.25-3.719l144-120C317.9 385.2 320 380.7 320 375.1s-2.094-9.25-5.75-12.28L184.1 255.1zM175.1 50.14l103 85.84L175.1 221.8V50.14zM175.1 461.8V290.1l103 85.84L175.1 461.8z"],
    "bold": [384, 512, [], "f032", "M314.7 251.7C346.8 230.1 368 193.5 368 152C368 85.84 314.2 32 248 32H16C7.156 32 0 39.16 0 48S7.156 64 16 64H32v384H16C7.156 448 0 455.2 0 464S7.156 480 16 480h248c66.17 0 120-53.84 120-120C384 312 355.5 270.8 314.7 251.7zM64 64h184c48.53 0 88 39.47 88 88S296.5 240 248 240H64V64zM264 448H64V272h200c48.53 0 88 39.47 88 88S312.5 448 264 448z"],
    "bolt": [384, 512, [61671, "flash"], "26a1", "M381.1 244.8c-4.687-12.48-16.62-20.75-29.97-20.75l-124.2-.0114l88.84-177.7c6.843-13.69 3.031-30.28-9.062-39.64C301.8 2.209 294.9 0 287.1 0c-7.541 0-15.06 2.666-21.05 7.926L10.95 231.9c-10.03 8.782-13.59 22.86-8.906 35.33C6.728 279.7 18.66 288 32.01 288l124.2-.0089l-88.84 177.7c-6.843 13.69-3.031 30.28 9.062 39.64C82.22 509.8 89.13 512 96 512c7.531 0 15.06-2.656 21.06-7.922l255.1-223.1C383.1 271.3 386.6 257.2 381.1 244.8zM96 479.1l88.84-177.7c4.961-9.92 4.429-21.7-1.4-31.14c-5.83-9.434-16.13-15.18-27.22-15.18L32.02 255.1l255.1-223.1c.0039-.002-.0176 0 0 0c0 0-.002 0 0 0l-88.82 177.7c-4.961 9.918-4.429 21.7 1.4 31.13c5.83 9.436 16.13 15.18 27.22 15.18l124.2-.0059L96 479.1z"],
    "bolt-auto": [576, 512, [], "e0b6", "M381.1 244.8c-4.688-12.49-16.62-20.75-29.97-20.75L227.8 223.1l88.84-177.7c6.844-13.69 3.031-30.28-9.062-39.64C301.8 2.209 294.9 0 287.1 0C280.4 0 272.9 2.666 266.9 7.926L10.95 231.9C.9162 240.7-2.647 254.8 2.041 267.3c4.688 12.48 16.62 20.75 29.97 20.75L156.2 287.1l-88.84 177.7c-6.844 13.69-3.031 30.28 9.062 39.64C82.22 509.8 89.13 512 96 512c7.531 0 15.06-2.656 21.06-7.922l255.1-223.1C383.1 271.3 386.6 257.2 381.1 244.8zM96 479.1l88.84-177.7C189.8 292.4 189.3 280.6 183.4 271.2C177.6 261.7 167.3 255.1 156.2 255.1L32.02 255.1l255.1-223.1c.0039-.002-.0176 0 0 0c0 0-.002 0 0 0L199.2 209.7C194.2 219.6 194.7 231.4 200.6 240.8S216.7 255.1 227.8 255.1l124.2-.0059L96 479.1zM574.3 488.8l-96-192c-5.438-10.84-23.19-10.84-28.62 0l-96 192c-3.938 7.906-.75 17.52 7.156 21.47c7.938 3.953 17.5 .7656 21.47-7.156L401.9 464h124.2l19.58 39.16C548.5 508.8 554.2 512 560 512c2.406 0 4.844-.5469 7.156-1.688C575.1 506.4 578.3 496.8 574.3 488.8zM417.9 432L464 339.8L510.1 432H417.9z"],
    "bolt-lightning": [384, 512, [], "e0b7", "M379.8 197.6c5.031-7.344 5.563-16.88 1.406-24.75C377.1 164.9 368.9 160 360 160h-156.6l50.84-127.1c2.969-7.375 2.062-15.78-2.406-22.38S239.1 0 232 0h-176C43.97 0 33.81 8.906 32.22 20.84l-32 240C-.7179 267.7 1.376 274.6 5.938 279.8C10.5 285 17.09 288 24 288h146.3l-41.78 194.1c-2.406 11.22 3.469 22.56 14 27.09C145.6 511.4 148.8 512 152 512c7.719 0 15.22-3.75 19.81-10.44L379.8 197.6zM190.1 256H33.15l29.87-224h157.2L164.9 170.1C160.7 180.6 168.5 192 179.8 192h165l-176.5 257.1l37.43-174.6C207.9 265.4 200.3 256 190.1 256z"],
    "bolt-slash": [640, 512, [], "e0b8", "M415.1 31.1C415.1 31.99 415.1 31.1 415.1 31.1C415.1 31.1 415.1 31.1 415.1 31.1l-78.21 156.5l25.65 20.25l81.2-162.4c6.844-13.69 3.031-30.28-9.062-39.64C429.8 2.209 422.9 0 415.1 0c-7.541 0-15.06 2.666-21.05 7.926L259.4 126.5L284.9 146.7L415.1 31.1zM423.3 255.1l56.68-.002l-26.88 23.53l25.55 20.17L501.1 280.1c10.03-8.781 13.59-22.86 8.904-35.33C505.3 232.3 493.3 224 479.1 224l-97.22-.0117L423.3 255.1zM216.7 255.1l-56.7 .002l26.89-23.54l-25.54-20.17L138.9 231.9C128.9 240.7 125.4 254.8 130 267.3C134.7 279.7 146.7 288 160 288l97.24-.0094L216.7 255.1zM633.9 483.4L25.92 3.42c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4zM224 479.1l78.24-156.5L276.6 303.3l-81.21 162.4c-6.844 13.69-3.031 30.28 9.062 39.64C210.2 509.8 217.1 512 224 512c7.531 0 15.06-2.656 21.06-7.922l135.6-118.7l-25.54-20.17L224 479.1z"],
    "bomb": [512, 512, [61922], "1f4a3", "M208 160C128.6 160 64 224.6 64 304C64 312.8 71.16 320 80 320S96 312.8 96 304C96 242.3 146.3 192 208 192C216.8 192 224 184.8 224 176S216.8 160 208 160zM390.5 144.1l12.83-12.83c6.25-6.25 6.25-16.37 0-22.62c-6.246-6.246-16.37-6.254-22.62 0L367.9 121.5l-35.24-35.17c-4.215-4.215-9.736-6.322-15.26-6.322s-11.05 2.107-15.26 6.322l-22.58 22.58C257.2 100.7 233.2 96 208 96C93.13 96 0 189.1 0 304S93.13 512 208 512S416 418.9 416 304c0-25.18-4.703-49.21-12.9-71.55l22.58-22.58c8.428-8.428 8.428-22.09 0-30.52L390.5 144.1zM384 304c0 97.05-78.95 176-176 176S32 401 32 304S110.1 128 208 128c33.93 0 55.72 9.182 79.72 17.98l29.67-29.67l78.3 78.3l-29.67 29.67C375.4 249.9 384 270.4 384 304zM496 48h-32v-32c0-8.844-7.132-16-15.98-16S432 7.156 432 16v32h-32c-8.844 0-15.95 7.134-15.95 15.98S391.2 80 400 80h32v32c0 8.844 7.181 15.96 16.02 15.96S464 120.8 464 112v-32h32c8.844 0 16-7.179 16-16.02S504.8 48 496 48z"],
    "bone": [576, 512, [62935], "1f9b4", "M536.5 256C565.4 238.3 576 211.6 576 179C576 133.3 537.1 96 491.3 96c-36.5 0-68.88 22.75-80.5 56.63C403.3 175.3 403.6 176 392 176h-208c-11.62 0-11.25-.75-18.75-23.38C153.6 118.8 121.3 96 84.75 96C37.1 96 0 133.3 0 179C0 211.6 10.63 238.3 39.5 256C10.63 273.8 0 300.4 0 333C0 378.8 37.1 416 84.75 416c36.5 0 68.88-22.75 80.5-56.63C172.8 336.8 172.4 336 184 336h208c11.62 0 11.25 .75 18.75 23.38C422.4 393.3 454.8 416 491.3 416C537.1 416 576 378.8 576 333C576 300.4 565.4 273.8 536.5 256zM491.3 384c-22.88 0-43-13.1-50.25-35C432.1 322.4 424.5 304 392 304h-208c-32.5 0-40.13 18.38-49 45C127.8 370 107.6 384 84.75 384C55.75 384 32 361.1 32 333c0-23.38 6.875-41.5 29-52.25C70.63 276.1 76.5 266.5 76.5 256S70.63 236 61 231.4C38.88 220.6 32 202.4 32 179C32 150.9 55.75 128 84.75 128c22.88 0 43 14 50.25 35C143.9 189.6 151.5 208 184 208h208c32.5 0 40.13-18.38 49-45C448.3 142 468.4 128 491.3 128C520.3 128 544 150.9 544 179c0 23.38-6.875 41.5-29 52.25C505.4 235.9 499.5 245.5 499.5 256s5.875 20 15.5 24.62C537.1 291.4 544 309.6 544 333C544 361.1 520.3 384 491.3 384z"],
    "bone-break": [640, 512, [], "f5d8", "M278.3 358.6l-69.71 19.13c-31.73 7.084-35.22 26.88-38.14 55.1c-2.551 22.31-19.18 40.51-41.52 45.5c-28.32 6.32-56.44-11.08-62.51-38.84c-5.041-23.07-2.236-42.46 17.05-57.89c8.402-6.664 12.06-17.44 9.799-27.81c-2.264-10.36-10.05-18.46-20.45-20.93c-23.92-5.789-34.57-22.3-39.61-45.38C27.11 259.7 45.37 231.1 73.68 225.7c22.34-4.984 45.01 4.447 56.62 23.6C144.7 273.6 156.1 290.1 187.8 282.1L273.8 263.8c8.629-1.926 14.08-10.56 12.17-19.28c-1.904-8.723-10.45-14.23-19.07-12.31L180.9 251.4C169.6 253.9 169.8 253.1 157.6 232.4C138.9 201.5 102.4 186.1 66.78 194.1c-45.65 10.19-74.72 55.24-64.86 100.4c7.033 32.2 23.15 56.17 55.17 67.39c-24.37 23.81-29 52.41-21.97 84.61c9.865 45.16 55 73.64 100.7 63.46c35.64-7.955 62.35-37.47 66.4-73.44c2.443-23.97 1.916-24.62 13.27-27.16l69.85-19.16c8.686-1.939 14.17-10.53 12.27-19.23C295.7 362.2 286.1 356.7 278.3 358.6zM573.2 194.1c-35.64-7.953-72.16 7.443-90.82 38.35c-12.2 20.7-11.1 21.52-23.35 18.99L373.1 232.2c-8.629-1.926-17.17 3.584-19.07 12.3c-1.904 8.723 3.545 17.36 12.17 19.28l85.93 19.18c31.74 7.084 43.14-9.393 57.55-33.74c11.61-19.15 34.28-28.58 56.62-23.59c28.32 6.32 46.58 34.08 40.51 61.84c-5.039 23.07-15.66 39.46-39.58 45.25c-10.39 2.465-18.21 10.69-20.47 21.05c-2.264 10.36 1.426 21.02 9.826 27.69c19.29 15.43 22.06 34.94 17.03 58.02c-6.064 27.76-34.19 45.16-62.51 38.84c-22.34-4.986-38.97-23.19-41.52-45.5c-2.926-28.22-6.408-48.02-38.14-55.1l-69.71-19.13c-8.74-1.951-17.4 3.576-19.31 12.33c-1.898 8.693 3.586 17.29 12.27 19.23l69.85 19.16c11.35 2.533 10.82 3.191 13.27 27.16c4.047 35.97 30.75 65.48 66.4 73.44c45.65 10.19 90.79-18.3 100.7-63.46c7.035-32.2 2.4-60.8-21.97-84.61c32.02-11.23 48.14-35.19 55.17-67.39C647.9 249.3 618.9 204.3 573.2 194.1zM319.1 0C311.2 0 304 7.156 304 16v96c0 8.844 7.154 15.1 15.1 15.1S336 120.8 336 112v-96C336 7.156 328.8 0 319.1 0zM228.7 155.3C231.8 158.4 235.9 160 240 160s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-64-64c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L228.7 155.3zM400 160c4.094 0 8.188-1.562 11.31-4.688l64-64c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-64 64c-6.25 6.25-6.25 16.38 0 22.62C391.8 158.4 395.9 160 400 160z"],
    "bong": [512, 512, [], "f55c", "M475.3 228.7l-64-64c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L409.4 208L364 253.4c-12.88-13.88-27.49-26-43.99-35.5L320 80C320 71.16 312.8 64 304 64S288 71.16 288 80v156.4l16 9.25C333.9 262.9 356.8 289.3 370.3 320h-292.5C91.25 289.3 114.1 262.9 144 245.6L160 236.4V80C160 71.16 152.8 64 144 64S128 71.16 128 80l.0045 137.9C70.63 251.1 32 313 32 384c0 43.07 14.29 82.87 38.35 114.9C75.73 506 87.33 512 96.28 512h255.4c9.023 0 20.65-6.02 26.07-13.24C401.7 466.8 416 427 416 384c0-39-12.01-75.13-32.01-105.4l48-48l20.69 20.69c6.246 6.246 16.37 6.254 22.62 0C481.6 245.1 481.6 234.9 475.3 228.7zM351.8 480H96.88C75.38 451.9 64 419.3 64 384c0-10.88 1.5-21.5 3.625-32h312.8C382.5 362.5 384 373.1 384 384C384 419.3 372.6 452.8 351.8 480zM111.1 32h224.1c8.775 0 15.97-7.21 15.97-15.99S344.8 0 336 0L111.1 .1667c-8.775 0-15.99 7.21-15.99 15.99S103.2 32 111.1 32z"],
    "book": [448, 512, [61485], "1f4d4", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM32 80C32 53.49 53.49 32 80 32H96v352H64c-11.71 0-22.55 3.389-32 8.9V80zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H128V32h272C408.8 32 416 39.17 416 48v320C416 376.8 408.8 384 400 384zM352 128H192C183.2 128 176 135.2 176 144S183.2 160 192 160h160c8.844 0 16-7.156 16-16S360.8 128 352 128zM352 224H192C183.2 224 176 231.2 176 240S183.2 256 192 256h160c8.844 0 16-7.156 16-16S360.8 224 352 224z"],
    "book-arrow-right": [640, 512, [], "e0b9", "M432 272C423.2 272 416 279.2 416 288v80c0 8.836-7.164 16-16 16H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48V128c0 8.836 7.164 16 16 16S448 136.8 448 128V48C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h367.2c7.969 0 15.35-5.455 16.62-13.32C449.4 488.6 441.7 480 432 480H416v-66.95c18.59-6.627 32-24.22 32-45.05V288C448 279.2 440.8 272 432 272zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM635.3 196.7l-96-96c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L585.4 192H272C263.2 192 256 199.2 256 208S263.2 224 272 224h313.4l-68.69 68.69c-6.25 6.25-6.25 16.38 0 22.62C519.8 318.4 523.9 320 528 320s8.188-1.562 11.31-4.688l96-96C641.6 213.1 641.6 202.9 635.3 196.7z"],
    "book-arrow-up": [448, 512, [], "e0ba", "M347.3 251.3C350.4 248.2 352 244.1 352 240s-1.562-8.188-4.688-11.31l-96-96c-6.25-6.25-16.38-6.25-22.62 0l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L224 182.6V496c0 8.844 7.156 16 16 16s16-7.156 16-16V182.6l68.69 68.69C330.9 257.6 341.1 257.6 347.3 251.3zM448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h112C184.8 512 192 504.8 192 496C192 487.2 184.8 480 176 480H65.81c-15.95 0-30.77-10.85-33.37-26.59C29.14 433.4 44.59 416 64 416h112C184.8 416 192 408.8 192 400C192 391.2 184.8 384 176 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320c0 8.836-7.164 16-16 16h-96c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16H384v64h-80c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16h128c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368z"],
    "book-atlas": [448, 512, ["atlas"], "f558", "M224 80c-70.75 0-128 57.25-128 128s57.25 128 128 128s128-57.25 128-128S294.8 80 224 80zM129.6 224h39.13c1.5 27 6.5 51.38 14.12 70.38C155.3 281.1 134.9 255.3 129.6 224zM168.8 192H129.6c5.25-31.25 25.62-57.13 53.25-70.38C175.3 140.6 170.3 165 168.8 192zM224 302.8C216.3 295.3 203.3 268.3 200.6 224h46.75C244.8 268.3 231.8 295.3 224 302.8zM200.5 192C203.3 147.8 216.3 120.8 224 113.3C231.8 120.8 244.8 147.8 247.4 192H200.5zM265.1 294.4C272.8 275.4 277.8 251 279.3 224h39.13C313.1 255.3 292.8 281.1 265.1 294.4zM279.3 192c-1.5-27-6.5-51.38-14.12-70.38c27.62 13.25 48 39.13 53.25 70.38H279.3zM448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384z"],
    "book-bible": [448, 512, ["bible"], "f647", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM304 144h-64v-64c0-8.844-7.156-15.1-16-15.1S208 71.16 208 80v64h-64C135.2 144 128 151.2 128 160s7.156 16 16 16h64v128c0 8.844 7.156 16 16 16S240 312.8 240 304v-128h64C312.8 176 320 168.8 320 160S312.8 144 304 144z"],
    "book-blank": [448, 512, [128215, 128216, 128217, 62937, "book-alt"], "1f4d5", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM32 80C32 53.49 53.49 32 80 32H96v352H64c-11.71 0-22.55 3.389-32 8.9V80zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H128V32h272C408.8 32 416 39.17 416 48v320C416 376.8 408.8 384 400 384z"],
    "book-bookmark": [448, 512, [], "e0bb", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM320 32v174.7L265.1 163.5C263.1 161.2 259.5 160 256 160s-7.062 1.172-10 3.5L192 206.7V32H320zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32H160v208c0 6.156 3.531 11.75 9.062 14.42c5.562 2.672 12.09 1.891 16.94-1.922L256 196.5l69.1 56.02C328.9 254.8 332.4 256 336 256c2.344 0 4.719-.5156 6.938-1.578C348.5 251.8 352 246.2 352 240V32h48C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384z"],
    "book-circle-arrow-right": [640, 512, [], "e0bc", "M336 480H65.81c-15.95 0-30.77-10.85-33.37-26.59C29.14 433.4 44.59 416 64 416h240c8.836 0 16-7.164 16-16c0-8.838-7.164-16-16-16H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v128C416 184.8 423.2 192 432 192S448 184.8 448 176v-128C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h272c8.836 0 16-7.164 16-16C352 487.2 344.8 480 336 480zM496 224C416.5 224 352 288.5 352 368s64.46 144 144 144s144-64.46 144-144S575.5 224 496 224zM496 480c-61.76 0-112-50.24-112-112S434.2 256 496 256S608 306.2 608 368S557.8 480 496 480zM571.3 356.7l-56-56c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L521.4 352H432c-8.836 0-15.1 7.164-15.1 16S423.2 384 432 384h89.38l-28.69 28.69c-6.25 6.25-6.25 16.38 0 22.62C495.8 438.4 499.9 440 504 440s8.188-1.562 11.31-4.688l56-56C577.6 373.1 577.6 362.9 571.3 356.7z"],
    "book-circle-arrow-up": [640, 512, [], "e0bd", "M336 480H65.81c-15.95 0-30.77-10.85-33.37-26.59C29.14 433.4 44.59 416 64 416h240c8.836 0 16-7.164 16-16c0-8.838-7.164-16-16-16H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v128C416 184.8 423.2 192 432 192S448 184.8 448 176v-128C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h272c8.836 0 16-7.164 16-16C352 487.2 344.8 480 336 480zM496 224C416.5 224 352 288.5 352 367.1C352 447.5 416.5 512 496 512s144-64.46 144-144C640 288.5 575.5 224 496 224zM496 480c-61.76 0-112-50.24-112-112C384 306.2 434.2 256 496 256S608 306.2 608 367.1C608 429.8 557.8 480 496 480zM507.3 292.7c-6.25-6.25-16.38-6.25-22.62 0l-56 56c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L480 342.6V432c0 8.836 7.164 15.1 16 15.1S512 440.8 512 432v-89.38l28.69 28.69c6.25 6.25 16.38 6.25 22.62 0C566.4 368.2 568 364.1 568 360s-1.562-8.188-4.688-11.31L507.3 292.7z"],
    "book-copy": [576, 512, [], "e0be", "M576 272v-224C576 21.49 554.5 0 528 0h-256C227.8 0 192 35.82 192 80V352c0 35.35 28.66 64 64 64h304c8.844 0 16-7.156 16-16S568.8 384 560 384H544V317.1C562.6 310.4 576 292.8 576 272zM512 384H256c-17.64 0-32-14.36-32-32s14.36-32 32-32h256V384zM528 288H256C244.3 288 233.5 291.4 224 296.9V80C224 53.49 245.5 32 272 32h256C536.8 32 544 39.16 544 48v224C544 280.8 536.8 288 528 288zM368 480H352v-16c0-8.838-7.164-16-16-16S320 455.2 320 464V480H65.81c-15.95 0-30.77-10.85-33.37-26.59C29.14 433.4 44.59 416 64 416h80C152.8 416 160 408.8 160 400C160 391.2 152.8 384 144 384H64c-11.71 0-22.55 3.389-32 8.9V176C32 149.5 53.49 128 80 128h64C152.8 128 160 120.8 160 112C160 103.2 152.8 96 144 96h-64C35.82 96 0 131.8 0 176V448c0 35.35 28.66 64 64 64h304c8.844 0 16-7.156 16-16S376.8 480 368 480z"],
    "book-font": [448, 512, [], "e0bf", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM238.3 104.8c-5.438-10.84-23.19-10.84-28.62 0l-96 192C109.7 304.8 112.9 314.4 120.8 318.3c7.906 3.906 17.52 .75 21.47-7.156L169.9 256h108.2l27.58 55.16C308.5 316.8 314.1 320 320 320c2.406 0 4.844-.5469 7.141-1.688c7.906-3.953 11.11-13.56 7.156-21.47L238.3 104.8zM185.9 224L224 147.8L262.1 224H185.9z"],
    "book-heart": [448, 512, [], "f499", "M224.1 139.8c-42.63-43-76.38-26.12-90.25-14.5c-27.5 23-28.88 64.13-4.25 89l84.5 85.63c5.5 5.5 14.25 5.5 19.75 0l84.75-85.63c24.62-24.88 23.12-66-4.375-89C300.3 113.6 266.6 96.75 224.1 139.8zM295.1 191.8l-72 72.63L152.2 191.8c-10.38-10.38-12.38-30 2-42c13.75-11.5 31.25-3.375 38.5 3.75l31.38 31.75l31.38-31.75c7.125-7.25 24.62-15.25 38.38-3.75C308.2 161.8 306.2 181.4 295.1 191.8zM448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384z"],
    "book-journal-whills": [448, 512, ["journal-whills"], "f66a", "M308 85.25c-4.75-2.625-10.62-1.75-14.5 2.125c-3.75 4-4.375 10-1.5 14.63c16.25 25.87 10.38 59.87-13.5 78.87c-2.5 2.25-4 5.25-4.375 8.625c-.25 3.25 1 6.5 3.25 9c13 13.38 17.75 32.63 12.5 50.5S270.1 280.6 252 284.9V259.3l6.25 6.375c3.125 3.125 8.25 3.125 11.38 0s3.125-8.125 0-11.25L259.3 244H272c4.375 0 8-3.625 8-8s-3.625-8-8-8h-12.75l10.38-10.38c3.125-3.125 3.125-8.125 0-11.25s-8.125-3.125-11.25 0L252 212.8V84c0-6.625-5.375-12-12-12s-12 5.375-12 12v128.8L221.6 206.4c-3.125-3.125-8.125-3.125-11.25 0s-3.125 8.125 0 11.25L220.6 228H208c-4.375 0-8 3.625-8 8s3.625 8 8 8h12.62L210.4 254.4c-3.125 3.125-3.125 8.125 0 11.25s8.125 3.125 11.25 0L228 259.3v25.62C209.9 280.6 195.4 267 190.1 249.1S189.6 211.9 202.5 198.5C204.9 196 206.1 192.8 205.9 189.5C205.6 186.1 204.1 183 201.5 180.9c-24-19-29.75-53-13.5-78.87c1.125-1.875 1.75-4.125 1.75-6.25c-.125-3.125-1.25-6-3.375-8.375C182.6 83.5 176.8 82.63 171.9 85.25C127.5 110.1 100 156.8 100 207c0 77.13 62.88 140 140 140s140-62.88 140-140C380 156.8 352.4 110.1 308 85.25zM330.4 197.6c3.125 3.125 8.125 3.125 11.25 0l12.25-12.25C355.3 192.5 356 199.8 356 207c0 4.75-.875 9.375-1.5 14.12l-23.88 20.88c-2.125 1.875-3.125 4.75-2.5 7.625c.5 2.75 2.5 5 5.25 6c2.75 .875 5.75 .25 7.875-1.625L348.1 248C331.4 291.8 289.5 323 240 323S148.5 291.8 131.9 248l6.875 6c3.249 2.875 8.375 2.625 11.25-.7501C151.4 251.6 152.1 249.6 152 247.5S150.9 243.4 149.3 242L125.5 221.1C124.9 216.4 124 211.8 124 207c0-7.25 .625-14.5 1.999-21.62l12.38 12.25c3.125 3.125 8.125 3.125 11.25 0s3.125-8.25 0-11.38L131.3 167.9C136.5 153.4 144.5 140.1 155 128.8c-.125 1.625-.25 3.375-.25 5C154.9 155.1 163 175.6 177.5 191.3c-21.88 31.62-16.75 74.63 12 100.1c28.88 25.62 72.13 25.62 101 0c28.75-25.5 33.88-68.5 11.88-100.1c14.62-15.62 22.75-36.13 22.75-57.5c0-1.625 0-3.375-.125-5C335.4 140 343.5 153.4 348.8 167.9l-18.44 18.38C327.3 189.4 327.3 194.5 330.4 197.6zM448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384z"],
    "book-medical": [448, 512, [], "f7e6", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.34 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.391-32 8.898V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM320 159.1h-48V111.1c0-8.836-7.164-16-16-16L224 96C215.2 96 208 103.2 208 111.1V160H160C151.2 160 144 167.2 144 175.1V208c0 8.836 7.164 15.1 16 15.1l48-.002v48C208 280.8 215.2 288 224 288l32-.0031c8.836 0 16-7.163 16-15.1v-48l48-.002c8.836 0 16-7.16 16-15.1V175.1C336 167.2 328.8 159.1 320 159.1z"],
    "book-open": [576, 512, [128366, 62744], "1f4d6", "M540.9 56.77c-45.95-16.66-90.23-24.09-129.1-24.75C351.1 32.96 309.1 49.47 288 59.74C266.9 49.47 223.9 32.94 164.8 32C124.8 31.95 80.4 40.35 35.1 56.77C14.18 64.33 0 84.41 0 106.7v302.9c0 14.66 6.875 28.06 18.89 36.8c11.81 8.531 26.64 10.98 40.73 6.781c118.9-36.34 209.3 19.05 214.3 22.19C277.8 477.6 281.2 480 287.1 480c6.52 0 10.12-2.373 14.07-4.578c10.78-6.688 98.3-57.66 214.3-22.27c14.11 4.25 28.86 1.75 40.75-6.812C569.1 437.6 576 424.2 576 409.6V106.7C576 84.42 561.8 64.35 540.9 56.77zM272 438.1c-24.95-12.03-71.01-29.37-130.5-29.37c-27.83 0-58.5 3.812-91.19 13.77c-4.406 1.344-9 .5938-12.69-2.047C34.02 417.8 32 413.1 32 409.6V106.7c0-8.859 5.562-16.83 13.86-19.83C87.66 71.7 127.9 63.95 164.5 64C216.3 64.81 254.2 79.26 272 87.66V438.1zM544 409.6c0 4.375-2.016 8.234-5.594 10.84c-3.766 2.703-8.297 3.422-12.69 2.125C424.1 391.6 341.3 420.4 304 438.3V87.66C321.8 79.26 359.7 64.81 411.4 64c35.31-.0625 76.34 7.484 118.8 22.88C538.4 89.88 544 97.84 544 106.7V409.6z"],
    "book-open-cover": [640, 512, ["book-open-alt"], "e0c0", "M89.06 398.1l217.1 48.4C310.7 447.5 315.3 448 320 448s9.312-.5098 13.88-1.529l217.1-48.4C565.6 394.8 576 381.8 576 366.7V39.47c0-22.15-17.99-39.46-39.31-39.46C536.2 .0127 535.9 0 535.6 0C532.7 0 522.6 1.673 320 33.13C117.1 1.63 107.4 .002 104.4 .002c-.3574 0-.6172 .0107-1.105 .0107C81.99 .0107 64 17.32 64 39.47V366.7C64 381.8 74.42 394.8 89.06 398.1zM336 63.1c0 0 195.4-30.39 200.6-31.07C540.1 32.03 544 34.91 544 39.56l-.0234 327.3L336 413.2V63.1zM96 39.56c0-2.623 1.203-4.367 2.211-5.369c.7383-.7344 2.248-1.922 5.264-2.148C108.8 32.74 304 63.1 304 63.1v350.1L96 366.7V39.56zM624 32C615.2 32 608 39.16 608 48v335.6c0 22.88-16.3 42.69-38.73 47.09L320 479.7l-249.3-48.97C48.3 426.3 32 406.5 32 383.6V48C32 39.16 24.84 32 16 32S0 39.16 0 48v335.6c0 38.13 27.16 71.14 64.58 78.5l252.3 49.58C317.9 511.9 318.1 512 320 512s2.062-.0938 3.078-.2969l252.4-49.58C612.8 454.8 640 421.8 640 383.6V48C640 39.16 632.8 32 624 32z"],
    "book-open-reader": [512, 512, ["book-reader"], "f5da", "M459.9 192c-.625 0-1.375 0-2 .125C408 194.9 317.4 205.1 256 239.6c-61.38-34.5-152-44.75-201.9-47.5C53.5 192 52.75 192 52.12 192C31.75 192 0 206.4 0 242.2v177.1C0 447 21.25 469 48.38 470.4c34.38 1.875 120.5 9.125 177 37.5C229.1 510.2 235 511.5 240 511.9l32 .0208c5-.375 9.1-1.688 14.62-4.062c56.5-28.38 142.6-35.63 177-37.5C490.8 469 512 447 512 420.2V242.2C512 206.4 480.3 192 459.9 192zM239.9 479.3C239.8 479.2 240 479.4 239.9 479.3c-59.63-30-144.6-38.44-189.9-40.81C39.88 437.9 32 429.9 32 420.2V242.2c0-6.125 1.75-10 5.875-13.25C42.38 225.6 48.38 224 52.38 224C89.38 226.1 181.6 234.6 240 267.4L239.9 479.3zM480 420.2c0 9.625-7.875 17.63-18 18.25c-45.25 2.375-130.2 10.81-189.9 40.81c-.125 .125 .125 0 0 0L272 267.4C330.4 234.6 422.6 226.1 459.5 224h.375C460.1 224 480 224.5 480 242.2V420.2zM256 192c53 0 96-43 96-96s-43-96-96-96S160 43 160 96S203 192 256 192zM256 32c35.25 0 64 28.75 64 64s-28.75 64-64 64S192 131.2 192 96S220.8 32 256 32z"],
    "book-quran": [448, 512, ["quran"], "f687", "M368 0h-320C21.49 0 0 21.49 0 48v320c0 20.83 13.42 38.43 32 45.05V480H16C7.156 480 0 487.2 0 496S7.156 512 16 512H384c35.35 0 64-28.66 64-64V80C448 35.82 412.2 0 368 0zM384 480H64v-64h320c17.64 0 32 14.36 32 32S401.6 480 384 480zM416 392.9C406.5 387.4 395.7 384 384 384H48C39.16 384 32 376.8 32 368v-320C32 39.16 39.16 32 48 32h320C394.5 32 416 53.49 416 80V392.9zM354.3 179.1L331.5 175.9l-10.12-20.62c-5.375-10.88-23.25-10.88-28.62 0L282.5 175.9l-22.62 3.25C253.8 180 248.8 184.3 246.9 190C245 195.9 246.6 202.3 251 206.5l16.38 16L263.5 245.1c-1 6 1.5 12 6.375 15.62c5 3.625 11.5 4 16.88 1.25L307 251.3L327.4 262c5.375 2.75 11.88 2.375 16.88-1.25c4.875-3.625 7.375-9.625 6.375-15.62L346.8 222.5l16.38-16c4.375-4.25 6-10.62 4.125-16.5C365.4 184.3 360.3 180 354.3 179.1zM323 213.5l3.75 22L307 225.1L287.3 235.5l3.875-22L275 197.9l22.12-3.25l9.875-20l10 20l22 3.25L323 213.5zM284.3 293.9L280.1 294c-45.63 0-82.88-37.13-82.88-82.88c0-45.63 37.25-82.75 82.88-82.75l4.125 .125c9 0 16.62-6.375 18.38-15c1.875-9.125-3.125-18.12-11.75-21.38C276.4 86.75 261.4 84 246.3 84c-70.13 0-127.1 57-127.1 127.1s57 127.3 127.1 127.3c15 0 30-2.75 44-8c7.625-2.5 12.88-9.75 12.75-17.75C303 302.3 294.6 293.9 284.3 293.9zM143 211.3c0-57 46.38-103.3 103.3-103.3c1.875 0 3.625 0 5.5 .125c-45.25 12.5-78.5 54-78.5 103.1c0 49 33.25 90.5 78.5 103C193 317.9 143 269.9 143 211.3z"],
    "book-section": [448, 512, ["book-law"], "e0c1", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.66 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM298.5 254.3c10.71-7.951 17.9-18.6 20.41-31.65c9.469-49.48-39.33-62.25-74.95-71.47l-8.359-2.047C195.5 138.5 189.9 130.6 192.5 117.1c3.656-19.06 34.5-23.61 61.53-19.75c7.75 1.109 17.03 3.391 29.16 7.188c8.406 2.641 17.41-2.047 20.06-10.48c2.625-8.438-2.062-17.41-10.5-20.05c-13.81-4.328-24.69-6.984-34.22-8.344c-52.63-7.484-90.78 10.39-97.47 45.44C156.4 135.9 166.7 151.4 181.5 161.7c-10.73 7.955-17.92 18.61-20.43 31.68c-9.344 48.89 39.88 61.97 66.28 69L236 264.6c41.5 10.75 54.75 17.2 51.47 34.31c-3.656 19.06-34.38 23.66-61.63 19.75C213.1 317.1 199.9 312.5 187.5 308.4L180.9 306.3C172.5 303.6 163.5 308.2 160.8 316.7c-2.688 8.422 1.969 17.42 10.38 20.11l6.469 2.109c13.69 4.453 29.19 9.5 43.84 11.5c7.938 1.125 15.5 1.656 22.72 1.656c40.59 0 69.06-17.34 74.75-47.09C323.6 280.3 313.9 264.8 298.5 254.3zM287.5 216.6c-2.766 14.45-20.55 18.9-31.04 20.3c-4.223-1.166-20.84-5.506-20.84-5.506C195.5 220.8 189.9 212.9 192.5 199.4C195.3 184.9 213.2 180.4 223.7 179.1c1.215 .3281 12.25 3.105 12.25 3.105C277.5 192.9 290.8 199.5 287.5 216.6z"],
    "book-skull": [448, 512, ["book-dead"], "f6b7", "M248 160c8.75 0 16-7.25 16-16S256.8 128 248 128s-16 7.25-16 16S239.3 160 248 160zM200 160c8.75 0 16-7.25 16-16S208.8 128 200 128s-16 7.25-16 16S191.3 160 200 160zM160 203.4V216C160 229.3 170.8 240 184 240h80C277.3 240 288 229.3 288 216V203.4C308.4 188.3 319.1 167 319.1 144C319.1 99.88 276.9 64 224 64S128 99.88 128 144C128 167 139.6 188.3 160 203.4zM224 96c35.25 0 63.99 21.5 63.99 48c0 14.25-8.736 27.88-24.24 37.25L256 185.9V208H191.1L192 185.9L184.3 181.3C168.9 171.9 159.1 158.3 159.1 144C159.1 117.5 188.8 96 224 96zM448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM351.1 250.6c-2.953-8.328-12.19-12.72-20.44-9.688L224 279L117.4 240.9C109 237.9 99.89 242.3 96.94 250.6C93.95 258.9 98.3 268.1 106.6 271.1L176.4 296l-69.82 24.94c-8.328 2.969-12.67 12.12-9.688 20.44C99.27 347.9 105.4 352 112 352c1.781 0 3.609-.2969 5.375-.9375L224 312.1l106.6 38.08C332.4 351.7 334.2 352 336 352c6.578 0 12.73-4.078 15.06-10.62c2.984-8.312-1.359-17.47-9.688-20.44L271.6 296l69.82-24.94C349.7 268.1 354 258.9 351.1 250.6z"],
    "book-sparkles": [448, 512, ["book-spells"], "f6b8", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM352 224h-48V176c0-8.844-7.155-15.1-15.1-15.1S272 167.2 272 176V224H224C215.2 224 208 231.1 208 239.1S215.2 255.1 224 255.1L272 256v48c0 8.844 7.155 15.1 15.1 15.1S304 312.8 304 304V256L352 255.1c8.844 0 16-7.152 16-15.1S360.8 224 352 224zM223.1 128c0-8.844-7.148-16-15.99-16h-32l-.0039-32C175.1 71.16 168.8 64 160 64S144 71.16 144 80v32h-32C103.2 112 96 119.2 96 128s7.156 16 16 16h32v32C144 184.8 151.2 192 160 192s15.1-7.156 15.1-16L176 144h32C216.8 144 223.1 136.8 223.1 128z"],
    "book-tanakh": [448, 512, ["tanakh"], "f827", "M368 0h-320C21.49 0 0 21.49 0 48v320c0 20.83 13.42 38.43 32 45.05V480H16C7.156 480 0 487.2 0 496S7.156 512 16 512H384c35.35 0 64-28.66 64-64V80C448 35.82 412.2 0 368 0zM384 480H64v-64h320c17.64 0 32 14.36 32 32S401.6 480 384 480zM416 392.9C406.5 387.4 395.7 384 384 384H48C39.16 384 32 376.8 32 368v-320C32 39.16 39.16 32 48 32h320C394.5 32 416 53.49 416 80V392.9zM314.6 208l27.62-46.38c3.749-6.125 3.749-13.88 .25-20.12c-3.5-6.25-10.25-10.12-17.38-10.12h-56.38L241 85.13C237.4 79.13 231.1 74.75 224 75.5c-7.125 0-13.62 3.75-17.25 9.75L179.1 131.5H122.9C115.6 131.4 109 135.3 105.4 141.6c-3.625 6.125-3.5 13.88 .25 20L133.4 208L105.8 254.4C101.1 260.5 101.1 268.3 105.5 274.5C109 280.8 115.8 284.6 122.9 284.6h56.38L207 330.9c3.5 6 10 9.625 17 9.625c7.125 0 13.62-3.75 17.25-9.75l27.62-46.25h56.25c7.25 .125 13.88-3.75 17.5-10.12c3.625-6.125 3.5-13.88-.25-20L314.6 208zM317.1 155.4l-17.37 29.25l-17.5-29.12L317.1 155.4zM224 103.4l16.75 28.12H207.1L224 103.4zM129.1 155.5h34.88l-17.5 29.12L129.1 155.5zM129.1 260.5L147.5 231.4L165 260.5H129.1zM224 312.6L207.3 284.5h33.5L224 312.6zM255.1 260.5H192.9L161.4 208l31.5-52.5h62.25L286.6 208L255.1 260.5zM283.1 260.5l17.5-29.12l17.37 29.12H283.1z"],
    "book-user": [448, 512, [], "f7e7", "M448 368v-320C448 21.49 426.5 0 400 0h-320C35.82 0 0 35.82 0 80V448c0 35.35 28.65 64 64 64h368c8.844 0 16-7.156 16-16S440.8 480 432 480H416v-66.95C434.6 406.4 448 388.8 448 368zM384 480H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h320V480zM400 384H64c-11.71 0-22.55 3.389-32 8.9V80C32 53.49 53.49 32 80 32h320C408.8 32 416 39.16 416 48v320C416 376.8 408.8 384 400 384zM256 240H192c-44.18 0-80 35.82-80 80c0 8.836 7.164 16 16 16s16-7.164 16-16c0-26.51 21.49-48 48-48h64c26.51 0 48 21.49 48 48c0 8.836 7.164 16 16 16s16-7.164 16-16C336 275.8 300.2 240 256 240zM224 208c35.35 0 64-28.65 64-64s-28.65-64-64-64s-64 28.65-64 64S188.7 208 224 208zM224 112c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S206.4 112 224 112z"],
    "bookmark": [384, 512, [61486, 61591], "1f516", "M320 0H64C28.72 0 0 28.7 0 64v431.1c0 5.844 3.188 11.23 8.312 14.04c5.125 2.781 11.34 2.562 16.28-.5313L192 402.1l167.4 106.5C362 511.2 365 512 368 512c2.656 0 5.281-.6562 7.688-1.969C380.8 507.2 384 501.8 384 495.1V64C384 28.7 355.3 0 320 0zM352 466.9l-151.4-96.36C197.1 368.8 195 368 192 368s-5.969 .8281-8.594 2.5L32 466.9V64c0-17.64 14.34-32 32-32h256c17.66 0 32 14.36 32 32V466.9z"],
    "bookmark-slash": [640, 512, [], "e0c2", "M192 32h256c17.66 0 32 14.36 32 32v236.8l32 25.26V64c0-35.3-28.72-64-64-64H192C169 0 148.1 12.28 137.7 30.53l25.45 20.09C168.3 39.7 179.2 32 192 32zM320 368c-3 0-5.969 .8281-8.594 2.5L160 466.9V211.2L128 185.9v310c0 5.844 3.188 11.23 8.312 14.04c5.125 2.781 11.34 2.562 16.28-.5313L320 402.1l167.4 106.5C490 511.2 493 512 496 512c2.656 0 5.281-.6562 7.688-1.969C508.8 507.2 512 501.8 512 496v-3.877l-183.4-121.6C325.1 368.8 323 368 320 368zM633.9 483.4L25.9 3.418C18.1-2.02 8.936-.8477 3.436 6.059c-5.469 6.939-4.281 17 2.656 22.49l608 480C617 510.9 620.5 512 624 512c4.719 0 9.406-2.094 12.56-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "books": [512, 512, [62939], "1f4da", "M510.4 435.4l-107.7-399.9C396.9 14.07 377.5 0 356.4 0c-4.111 0-8.296 .5313-12.46 1.641l-61.82 16.48c-1.281 .3438-2.375 .9922-3.592 1.445C269.7 7.758 255.8 0 240 0h-64c-12.35 0-23.49 4.797-32 12.46C135.5 4.797 124.3 0 112 0h-64C21.49 0 0 21.49 0 48v416C0 490.5 21.49 512 48 512h64c12.35 0 23.49-4.797 32-12.46C152.5 507.2 163.7 512 176 512h64c26.51 0 48-21.49 48-48V224.7l67.8 251.9C361.6 497.9 380.9 512 402.1 512c4.111 0 8.293-.5313 12.46-1.641l61.82-16.48C502 487 517.2 460.8 510.4 435.4zM32 48C32 39.18 39.18 32 48 32h64C120.8 32 128 39.18 128 48l.0011 48L32 96V48zM32 128l96 .0014v255.1L32 384V128zM112 480h-64C39.18 480 32 472.8 32 464V416l96 0L128 464C128 472.8 120.8 480 112 480zM256 464c0 8.824-7.178 16-16 16h-64C167.2 480 160 472.8 160 464l.0011-47.1L256 416V464zM256 384l-95.1 .0002V128L256 128V384zM256 96L160 96L160 48C160 39.18 167.2 32 176 32h64C248.8 32 256 39.18 256 48V96zM288 101.6V50.29c.834-.3906 1.322-.9727 2.322-1.242l61.82-16.48C353.5 32.19 354.1 32 356.4 32c7.225 0 13.57 4.828 15.43 11.74l12.4 46.07l-92.71 24.73L288 101.6zM366 391.4l-66.26-246.1l92.71-24.73l66.26 246.1L366 391.4zM477.9 455.5c-1.23 2.133-4.133 5.934-9.729 7.43l-61.82 16.48C404.1 479.8 403.5 480 402.1 480c-7.227 0-13.57-4.828-15.43-11.74l-12.4-46.07l92.71-24.73l12.44 46.22C480.9 449.1 479.1 453.4 477.9 455.5z"],
    "books-medical": [576, 512, [], "f7e8", "M63.1 336c0 8.836 7.164 16 15.1 16h31.1c8.836 0 16-7.164 16-16L127.1 288h47.1c8.836 0 16-7.165 16-16v-32c0-8.836-7.165-15.1-16-15.1H127.1l.0006-47.1c0-8.836-7.165-15.1-16-15.1H79.1c-8.836 0-15.1 7.163-15.1 15.1L63.1 224H16c-8.836 0-16 7.163-16 15.1v32c0 8.836 7.164 16 16 16h47.1L63.1 336zM574.4 435.4l-107.7-399.9C460.9 14.07 441.5 0 420.4 0c-4.111 0-8.296 .5313-12.46 1.641l-61.82 16.48c-1.281 .3438-2.375 .9922-3.592 1.445C333.7 7.758 319.8 0 304 0h-64c-12.35 0-23.49 4.797-32 12.46C199.5 4.797 188.3 0 176 0h-64C85.49 0 64 21.49 64 48v64C64 120.8 71.16 128 80 128h112L192 176C192 184.8 199.2 192 208 192S224 184.8 224 176L224 128H320v256H224L224 336C224 327.2 216.8 320 208 320S192 327.2 192 336L192 384H80C71.16 384 64 391.2 64 400v64C64 490.5 85.49 512 112 512h64c12.35 0 23.49-4.797 32-12.46C216.5 507.2 227.7 512 240 512h64c26.51 0 48-21.49 48-48V224.7l67.8 251.9C425.6 497.9 444.9 512 466.1 512c4.111 0 8.293-.5313 12.46-1.641l61.91-16.51C566.1 487 581.2 460.8 574.4 435.4zM192 96H96V48C96 39.18 103.2 32 112 32h64C184.8 32 192 39.18 192 48L192 96zM192 464C192 472.8 184.8 480 176 480h-64C103.2 480 96 472.8 96 464V416h96L192 464zM320 464c0 8.824-7.178 16-16 16h-64C231.2 480 224 472.8 224 464L224 416H320V464zM320 96H224L224 48C224 39.18 231.2 32 240 32h64C312.8 32 320 39.18 320 48V96zM352 101.6V50.29c.834-.3906 1.322-.9727 2.322-1.242l61.82-16.48C417.5 32.19 418.1 32 420.4 32c7.225 0 13.57 4.828 15.43 11.74l12.4 46.07l-92.71 24.73L352 101.6zM430 391.4l-66.26-246.1l92.71-24.73l66.26 246.1L430 391.4zM541.9 455.5c-1.23 2.133-4.133 5.934-9.729 7.43l-61.82 16.48C468.1 479.8 467.5 480 466.1 480c-7.227 0-13.57-4.828-15.43-11.74l-12.4-46.07l92.71-24.73l12.44 46.22C544.9 449.1 543.1 453.4 541.9 455.5z"],
    "boombox": [640, 512, [63653], "1f4fe", "M576 160V80C576 35.89 540.1 0 496 0h-352C99.88 0 64 35.89 64 80V160C28.65 160 0 188.7 0 224v224c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V224C640 188.7 611.3 160 576 160zM96 80C96 53.53 117.5 32 144 32h352C522.5 32 544 53.53 544 80V160H96V80zM608 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V224c0-17.64 14.36-32 32-32h512c17.64 0 32 14.36 32 32V448zM176 224C114.1 224 64 274.1 64 336S114.1 448 176 448S288 397.9 288 336S237.9 224 176 224zM176 416C131.9 416 96 380.1 96 336S131.9 256 176 256S256 291.9 256 336S220.1 416 176 416zM464 224C402.1 224 352 274.1 352 336s50.14 112 112 112s112-50.14 112-112S525.9 224 464 224zM464 416c-44.11 0-80-35.89-80-80S419.9 256 464 256S544 291.9 544 336S508.1 416 464 416zM240 96h-32C199.2 96 192 103.2 192 112S199.2 128 208 128h32C248.8 128 256 120.8 256 112S248.8 96 240 96zM432 96h-32C391.2 96 384 103.2 384 112S391.2 128 400 128h32C440.8 128 448 120.8 448 112S440.8 96 432 96zM336 96h-32C295.2 96 288 103.2 288 112S295.2 128 304 128h32C344.8 128 352 120.8 352 112S344.8 96 336 96z"],
    "boot": [512, 512, [63362], "1f97e", "M415 247.8L352 232V192c0-17.67-14.33-32-32-32H240C231.2 160 224 167.2 224 176S231.2 192 240 192H320v32H240C231.2 224 224 231.2 224 240S231.2 256 240 256H320l87.25 22.75C450.1 289.5 480 327.8 480 371.9V384H32V128h320c17.67 0 32-14.33 32-32V32c0-17.67-14.33-32-32-32H32C14.33 0 0 14.33 0 32v434.7c0 8.5 3.322 16.49 9.322 22.49l13.43 13.39C28.75 508.6 36.75 512 45.25 512h37.49c8.488 0 16.63-3.373 22.63-9.375L128 480l22.62 22.62C156.6 508.6 164.8 512 173.3 512h37.49c8.373 0 16.41-3.314 22.34-9.219L256 480l22.62 22.62C284.6 508.6 292.8 512 301.3 512h37.27c8.516 0 16.69-3.371 22.72-9.375L384 480l22.62 22.62C412.6 508.6 420.8 512 429.3 512h37.49c8.5 0 16.5-3.375 22.5-9.375l13.38-13.29C508.6 483.3 512 475.2 512 466.7v-94.76C512 313.2 472 262 415 247.8zM32 32h320v64H32V32zM480 466.8L466.8 480h-37.5l-22.62-22.62C400.6 451.4 392.5 448 384 448s-16.62 3.375-22.62 9.375L338.8 480h-37.5l-22.62-22.62C272.6 451.4 264.5 448 256 448s-16.62 3.375-22.62 9.375L210.8 480h-37.5l-22.62-22.62C144.6 451.4 136.5 448 128 448s-16.62 3.375-22.62 9.375L82.75 480h-37.5L32 466.8V416h448V466.8z"],
    "boot-heeled": [512, 512, [], "e33f", "M480 480v-56.45c0-24.24-13.7-46.4-35.38-57.24l-121.2-60.62c-21.68-10.84-35.38-33-35.38-57.24V32c0-17.67-14.33-32-32-32h-192C44.76 0 29.86 16.87 32.25 35.97l24.44 161.5c4.816 38.53 .9414 77.66-11.34 114.5c-8.84 26.52-13.35 54.29-13.35 82.24V496c0 8.844 7.156 16 16 16h96c8.844 0 16-7.156 16-16v-39.5l109 48.56C279.3 509.7 290.3 512 301.6 512h178.4c8.844 0 16-7.156 16-16S488.8 480 480 480zM128 480h-64v-32h64V480zM301.6 480c-6.812 0-13.38-1.406-19.56-4.156l-125.9-56.09C150.3 417.3 143.1 416 137.5 416H64.01v-21.8c0-24.56 3.938-48.82 11.7-72.12c13.71-41.12 18.11-85.58 12.73-128.6L64.01 32h64v208c0 8.844 7.156 16 16 16s16-7.156 16-16V32h96v216.4c0 36.6 20.33 69.5 53.07 85.87l121.2 60.62c10.91 5.455 17.69 16.42 17.69 28.62V480H301.6z"],
    "booth-curtain": [512, 512, [], "f734", "M0 32v464C0 504.8 7.2 512 15.1 512S32 504.8 32 496V32h64L95.1 381.5c0 35.29 27.49 65.79 62.78 66.47C178.5 448.4 196 439.5 208 425.9C219.8 439.2 236.8 448 256 448s36.25-8.75 48-22.12C315.8 439.2 332.8 448 352 448s36.25-8.75 48-22.12C411.8 439.2 428.8 448 448 448c11.75 0 22.5-3.375 32-8.875v56.88C480 504.8 487.2 512 496 512s16-7.2 16-16V32c0-17.67-14.33-32-32-32H32C14.33 0 0 14.33 0 32zM416 32h64v352c0 17.75-14.25 32-32 32c-17.75 0-32-14.25-32-32V32zM320 32h64v352c0 17.75-14.25 32-32 32s-32-14.25-32-32V32zM224 32h64v352c0 17.75-14.25 32-32 32s-32-14.25-32-32V32zM128 32h64v352c0 17.75-14.25 32-32 32s-32-14.25-32-32V32z"],
    "border-all": [448, 512, [], "f84c", "M400 32h-352C21.49 32 0 53.49 0 80v352C0 458.5 21.49 480 48 480h352c26.51 0 48-21.49 48-48v-352C448 53.49 426.5 32 400 32zM32 80C32 71.18 39.18 64 48 64h160v176H32V80zM48 448C39.18 448 32 440.8 32 432v-160h176V448H48zM416 432c0 8.822-7.176 16-16 16h-160V272H416V432zM416 240h-176V64h160C408.8 64 416 71.18 416 80V240z"],
    "border-bottom": [448, 512, [], "f84d", "M224 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S200 50.74 200 64C200 77.25 210.7 88 224 88zM224 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S200 146.7 200 160C200 173.3 210.7 184 224 184zM320 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S296 50.74 296 64C296 77.25 306.7 88 320 88zM416 376c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24s-24 10.74-24 24C392 365.3 402.7 376 416 376zM320 280c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S296 242.7 296 256C296 269.3 306.7 280 320 280zM416 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S392 50.74 392 64C392 77.25 402.7 88 416 88zM416 280c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S392 242.7 392 256C392 269.3 402.7 280 416 280zM416 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S392 146.7 392 160C392 173.3 402.7 184 416 184zM32 376c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 338.7 8 352C8 365.3 18.75 376 32 376zM32 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 50.74 8 64C8 77.25 18.75 88 32 88zM32 280c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 242.7 8 256C8 269.3 18.75 280 32 280zM32 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 146.7 8 160C8 173.3 18.75 184 32 184zM432 448h-416C7.156 448 0 455.2 0 464S7.156 480 16 480h416c8.844 0 16-7.156 16-16S440.8 448 432 448zM128 280c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S104 242.7 104 256C104 269.3 114.7 280 128 280zM224 376c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S200 338.7 200 352C200 365.3 210.7 376 224 376zM224 280c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S200 242.7 200 256C200 269.3 210.7 280 224 280zM128 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S104 50.74 104 64C104 77.25 114.7 88 128 88z"],
    "border-bottom-right": [448, 512, ["border-style-alt"], "f854", "M128 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S104 50.74 104 64C104 77.25 114.7 88 128 88zM32 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 50.74 8 64C8 77.25 18.75 88 32 88zM224 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S200 50.74 200 64C200 77.25 210.7 88 224 88zM320 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S296 50.74 296 64C296 77.25 306.7 88 320 88zM32 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 146.7 8 160C8 173.3 18.75 184 32 184zM32 376c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 338.7 8 352C8 365.3 18.75 376 32 376zM32 280c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 242.7 8 256C8 269.3 18.75 280 32 280zM432 32C423.2 32 416 39.16 416 48v384c0 8.836-7.164 16-16 16h-384C7.164 448 0 455.2 0 464S7.164 480 16 480h384c26.51 0 48-21.49 48-48v-384C448 39.16 440.8 32 432 32z"],
    "border-center-h": [448, 512, [], "f89c", "M416 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S392 50.74 392 64C392 77.25 402.7 88 416 88zM128 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S104 50.74 104 64C104 77.25 114.7 88 128 88zM32 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 146.7 8 160C8 173.3 18.75 184 32 184zM32 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S56 461.3 56 448C56 434.7 45.25 424 32 424zM32 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 50.74 8 64C8 77.25 18.75 88 32 88zM224 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S200 50.74 200 64C200 77.25 210.7 88 224 88zM416 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S392 146.7 392 160C392 173.3 402.7 184 416 184zM320 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S296 50.74 296 64C296 77.25 306.7 88 320 88zM224 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S200 146.7 200 160C200 173.3 210.7 184 224 184zM416 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 434.7 429.3 424 416 424zM320 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 434.7 333.3 424 320 424zM416 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 338.7 429.3 328 416 328zM432 240h-416C7.156 240 0 247.2 0 256s7.156 16 16 16h416C440.8 272 448 264.8 448 256S440.8 240 432 240zM224 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 338.7 237.3 328 224 328zM32 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S56 365.3 56 352C56 338.7 45.25 328 32 328zM128 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 461.3 152 448C152 434.7 141.3 424 128 424zM224 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 434.7 237.3 424 224 424z"],
    "border-center-v": [448, 512, [], "f89d", "M128 232C114.7 232 104 242.7 104 256c0 13.25 10.75 24 24 24S152 269.3 152 256C152 242.7 141.3 232 128 232zM32 136C18.75 136 8 146.7 8 160c0 13.25 10.75 24 24 24S56 173.3 56 160C56 146.7 45.25 136 32 136zM32 40C18.75 40 8 50.74 8 64c0 13.25 10.75 24 24 24S56 77.25 56 64C56 50.74 45.25 40 32 40zM128 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 461.3 152 448C152 434.7 141.3 424 128 424zM32 232C18.75 232 8 242.7 8 256c0 13.25 10.75 24 24 24S56 269.3 56 256C56 242.7 45.25 232 32 232zM32 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S56 365.3 56 352C56 338.7 45.25 328 32 328zM416 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S392 50.74 392 64C392 77.25 402.7 88 416 88zM32 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S56 461.3 56 448C56 434.7 45.25 424 32 424zM416 136c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S440 173.3 440 160C440 146.7 429.3 136 416 136zM416 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 338.7 429.3 328 416 328zM320 40c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S344 77.25 344 64C344 50.74 333.3 40 320 40zM416 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 434.7 429.3 424 416 424zM128 40C114.7 40 104 50.74 104 64c0 13.25 10.75 24 24 24S152 77.25 152 64C152 50.74 141.3 40 128 40zM416 232c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S440 269.3 440 256C440 242.7 429.3 232 416 232zM320 232c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S344 269.3 344 256C344 242.7 333.3 232 320 232zM320 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 434.7 333.3 424 320 424zM224 32C215.2 32 208 39.16 208 48v416c0 8.844 7.156 16 16 16s16-7.156 16-16v-416C240 39.16 232.8 32 224 32z"],
    "border-inner": [448, 512, [], "f84e", "M128 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S104 50.74 104 64C104 77.25 114.7 88 128 88zM32 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 50.74 8 64C8 77.25 18.75 88 32 88zM32 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S8 146.7 8 160C8 173.3 18.75 184 32 184zM416 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S392 50.74 392 64C392 77.25 402.7 88 416 88zM416 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S392 146.7 392 160C392 173.3 402.7 184 416 184zM320 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S296 50.74 296 64C296 77.25 306.7 88 320 88zM32 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S56 461.3 56 448C56 434.7 45.25 424 32 424zM416 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 338.7 429.3 328 416 328zM416 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 434.7 429.3 424 416 424zM320 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 434.7 333.3 424 320 424zM128 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 461.3 152 448C152 434.7 141.3 424 128 424zM32 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S56 365.3 56 352C56 338.7 45.25 328 32 328zM432 240h-192v-192C240 39.16 232.8 32 224 32S208 39.16 208 48v192h-192C7.156 240 0 247.2 0 256s7.156 16 16 16h192v192c0 8.844 7.156 16 16 16s16-7.156 16-16v-192h192C440.8 272 448 264.8 448 256S440.8 240 432 240z"],
    "border-left": [448, 512, [], "f84f", "M128 40C114.7 40 104 50.74 104 64c0 13.25 10.75 24 24 24S152 77.25 152 64C152 50.74 141.3 40 128 40zM224 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 434.7 237.3 424 224 424zM224 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 338.7 237.3 328 224 328zM224 232C210.7 232 200 242.7 200 256c0 13.25 10.75 24 24 24S248 269.3 248 256C248 242.7 237.3 232 224 232zM416 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S392 50.74 392 64C392 77.25 402.7 88 416 88zM224 136C210.7 136 200 146.7 200 160c0 13.25 10.75 24 24 24S248 173.3 248 160C248 146.7 237.3 136 224 136zM128 232C114.7 232 104 242.7 104 256c0 13.25 10.75 24 24 24S152 269.3 152 256C152 242.7 141.3 232 128 232zM128 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 461.3 152 448C152 434.7 141.3 424 128 424zM416 136c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S440 173.3 440 160C440 146.7 429.3 136 416 136zM416 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 434.7 429.3 424 416 424zM416 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 338.7 429.3 328 416 328zM416 232c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S440 269.3 440 256C440 242.7 429.3 232 416 232zM320 232c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S344 269.3 344 256C344 242.7 333.3 232 320 232zM320 40c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S344 77.25 344 64C344 50.74 333.3 40 320 40zM320 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 434.7 333.3 424 320 424zM224 40C210.7 40 200 50.74 200 64c0 13.25 10.75 24 24 24S248 77.25 248 64C248 50.74 237.3 40 224 40zM16 32C7.156 32 0 39.16 0 48v416C0 472.8 7.156 480 16 480S32 472.8 32 464v-416C32 39.16 24.84 32 16 32z"],
    "border-none": [448, 512, [], "f850", "M128 232C114.7 232 104 242.7 104 256c0 13.25 10.75 24 24 24S152 269.3 152 256C152 242.7 141.3 232 128 232zM32 40C18.75 40 8 50.74 8 64c0 13.25 10.75 24 24 24S56 77.25 56 64C56 50.74 45.25 40 32 40zM128 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 461.3 152 448C152 434.7 141.3 424 128 424zM128 40C114.7 40 104 50.74 104 64c0 13.25 10.75 24 24 24S152 77.25 152 64C152 50.74 141.3 40 128 40zM224 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 338.7 237.3 328 224 328zM416 88c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S392 50.74 392 64C392 77.25 402.7 88 416 88zM32 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S56 461.3 56 448C56 434.7 45.25 424 32 424zM32 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S56 365.3 56 352C56 338.7 45.25 328 32 328zM32 136C18.75 136 8 146.7 8 160c0 13.25 10.75 24 24 24S56 173.3 56 160C56 146.7 45.25 136 32 136zM32 232C18.75 232 8 242.7 8 256c0 13.25 10.75 24 24 24S56 269.3 56 256C56 242.7 45.25 232 32 232zM224 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 434.7 237.3 424 224 424zM416 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 338.7 429.3 328 416 328zM416 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 434.7 429.3 424 416 424zM416 232c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S440 269.3 440 256C440 242.7 429.3 232 416 232zM320 40c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S344 77.25 344 64C344 50.74 333.3 40 320 40zM224 232C210.7 232 200 242.7 200 256c0 13.25 10.75 24 24 24S248 269.3 248 256C248 242.7 237.3 232 224 232zM416 136c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S440 173.3 440 160C440 146.7 429.3 136 416 136zM224 40C210.7 40 200 50.74 200 64c0 13.25 10.75 24 24 24S248 77.25 248 64C248 50.74 237.3 40 224 40zM320 232c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S344 269.3 344 256C344 242.7 333.3 232 320 232zM224 136C210.7 136 200 146.7 200 160c0 13.25 10.75 24 24 24S248 173.3 248 160C248 146.7 237.3 136 224 136zM320 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 434.7 333.3 424 320 424z"],
    "border-outer": [448, 512, [], "f851", "M224 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 338.7 237.3 328 224 328zM128 232C114.7 232 104 242.7 104 256c0 13.25 10.75 24 24 24S152 269.3 152 256C152 242.7 141.3 232 128 232zM224 232C210.7 232 200 242.7 200 256c0 13.25 10.75 24 24 24S248 269.3 248 256C248 242.7 237.3 232 224 232zM320 232c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S344 269.3 344 256C344 242.7 333.3 232 320 232zM224 136C210.7 136 200 146.7 200 160c0 13.25 10.75 24 24 24S248 173.3 248 160C248 146.7 237.3 136 224 136zM400 32h-352C21.49 32 0 53.49 0 80v352C0 458.5 21.49 480 48 480h352c26.51 0 48-21.49 48-48v-352C448 53.49 426.5 32 400 32zM416 432c0 8.822-7.176 16-16 16h-352C39.18 448 32 440.8 32 432v-352C32 71.18 39.18 64 48 64h352C408.8 64 416 71.18 416 80V432z"],
    "border-right": [448, 512, [], "f852", "M128 40C114.7 40 104 50.74 104 64c0 13.25 10.75 24 24 24S152 77.25 152 64C152 50.74 141.3 40 128 40zM32 136C18.75 136 8 146.7 8 160c0 13.25 10.75 24 24 24S56 173.3 56 160C56 146.7 45.25 136 32 136zM128 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 461.3 152 448C152 434.7 141.3 424 128 424zM128 232C114.7 232 104 242.7 104 256c0 13.25 10.75 24 24 24S152 269.3 152 256C152 242.7 141.3 232 128 232zM32 40C18.75 40 8 50.74 8 64c0 13.25 10.75 24 24 24S56 77.25 56 64C56 50.74 45.25 40 32 40zM32 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S56 461.3 56 448C56 434.7 45.25 424 32 424zM32 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S56 365.3 56 352C56 338.7 45.25 328 32 328zM32 232C18.75 232 8 242.7 8 256c0 13.25 10.75 24 24 24S56 269.3 56 256C56 242.7 45.25 232 32 232zM224 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 338.7 237.3 328 224 328zM224 40C210.7 40 200 50.74 200 64c0 13.25 10.75 24 24 24S248 77.25 248 64C248 50.74 237.3 40 224 40zM320 232c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S344 269.3 344 256C344 242.7 333.3 232 320 232zM224 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 434.7 237.3 424 224 424zM320 40c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S344 77.25 344 64C344 50.74 333.3 40 320 40zM320 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 434.7 333.3 424 320 424zM224 232C210.7 232 200 242.7 200 256c0 13.25 10.75 24 24 24S248 269.3 248 256C248 242.7 237.3 232 224 232zM224 136C210.7 136 200 146.7 200 160c0 13.25 10.75 24 24 24S248 173.3 248 160C248 146.7 237.3 136 224 136zM432 32C423.2 32 416 39.16 416 48v416c0 8.844 7.156 16 16 16s16-7.156 16-16v-416C448 39.16 440.8 32 432 32z"],
    "border-top": [448, 512, [], "f855", "M128 424c-13.26 0-24 10.75-24 24S114.7 472 128 472c13.25 0 24-10.75 24-24S141.3 424 128 424zM224 328c-13.26 0-24 10.75-24 24s10.74 24 24 24c13.25 0 24-10.75 24-24S237.3 328 224 328zM32 136C18.74 136 8 146.7 8 160S18.74 184 32 184c13.25 0 24-10.75 24-24S45.25 136 32 136zM224 424c-13.26 0-24 10.75-24 24s10.74 24 24 24c13.25 0 24-10.75 24-24S237.3 424 224 424zM128 232C114.7 232 104 242.7 104 256S114.7 280 128 280c13.25 0 24-10.75 24-24S141.3 232 128 232zM432 32h-416C7.156 32 0 39.16 0 48S7.156 64 16 64h416C440.8 64 448 56.84 448 48S440.8 32 432 32zM32 328c-13.26 0-24 10.75-24 24S18.74 376 32 376c13.25 0 24-10.75 24-24S45.25 328 32 328zM32 232C18.74 232 8 242.7 8 256S18.74 280 32 280c13.25 0 24-10.75 24-24S45.25 232 32 232zM32 424c-13.26 0-24 10.75-24 24S18.74 472 32 472c13.25 0 24-10.75 24-24S45.25 424 32 424zM416 328c-13.26 0-24 10.75-24 24s10.74 24 24 24c13.25 0 24-10.75 24-24S429.3 328 416 328zM416 232c-13.26 0-24 10.75-24 24S402.7 280 416 280c13.25 0 24-10.75 24-24S429.3 232 416 232zM416 424c-13.26 0-24 10.75-24 24s10.74 24 24 24c13.25 0 24-10.75 24-24S429.3 424 416 424zM416 136c-13.26 0-24 10.75-24 24S402.7 184 416 184c13.25 0 24-10.75 24-24S429.3 136 416 136zM320 424c-13.26 0-24 10.75-24 24s10.74 24 24 24c13.25 0 24-10.75 24-24S333.3 424 320 424zM224 136C210.7 136 200 146.7 200 160S210.7 184 224 184c13.25 0 24-10.75 24-24S237.3 136 224 136zM224 232C210.7 232 200 242.7 200 256S210.7 280 224 280c13.25 0 24-10.75 24-24S237.3 232 224 232zM320 232c-13.26 0-24 10.75-24 24S306.7 280 320 280c13.25 0 24-10.75 24-24S333.3 232 320 232z"],
    "border-top-left": [448, 512, ["border-style"], "f853", "M416 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 434.7 429.3 424 416 424zM224 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C248 434.7 237.3 424 224 424zM128 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 461.3 152 448C152 434.7 141.3 424 128 424zM320 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 434.7 333.3 424 320 424zM416 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C440 338.7 429.3 328 416 328zM416 136c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S440 173.3 440 160C440 146.7 429.3 136 416 136zM416 232c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S440 269.3 440 256C440 242.7 429.3 232 416 232zM432 32h-384C21.49 32 0 53.49 0 80v384C0 472.8 7.164 480 16 480S32 472.8 32 464v-384C32 71.16 39.16 64 48 64h384C440.8 64 448 56.84 448 48S440.8 32 432 32z"],
    "bow-arrow": [512, 512, [63161], "1f3f9", "M496.3-.0002c-1 0-2.053 .165-3.053 .29l-128.6 25.75c-12.25 2.5-16.88 17.59-8 26.47l40.12 40.12L144.3 345l-53.62-24.08C83.35 318.5 75.23 320.4 69.73 325.9l-63.75 63.82c-10.75 10.75-6.376 29.12 8.126 33.1l55.62 18.5L88.22 497.9c2.998 9 11.28 14.12 19.65 14.12c5.125 0 10.35-1.874 14.47-5.997l63.62-63.74c5.502-5.5 7.376-13.62 5.001-20.1l-23.1-53.62l252.4-252.4l40.13 40.09c3.125 3.125 7.129 4.639 11.01 4.639c6.998 0 13.87-4.764 15.49-12.64l25.72-128.6C513.6 8.913 505.9-.0002 496.3-.0002zM112.7 470.3L94.97 417l-53.25-17.75l44.87-45l49.13 22l21.1 48.1L112.7 470.3zM460.6 111.3L400.7 51.5l74.75-15L460.6 111.3zM148.7 267.3C151.8 270.4 155.9 272 160 272s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L63.58 136.1c73.23-51.43 171.8-54.54 247.9-6.502c7.375 4.688 17.38 2.516 22.06-4.984C338.3 118 336 108.1 328.5 103.4c-88.5-55.89-203.9-51.54-288.1 10.46L27.25 100.7c-6.25-6.25-16.31-6.302-22.56-.0524S-1.542 117 4.708 123.3L148.7 267.3zM408.6 183.5c-4.781-7.5-14.75-9.672-22.06-4.984c-7.5 4.719-9.719 14.61-5 22.08c48.06 76.04 44.97 174.6-6.494 247.9l-107.7-107.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l144 144C391.8 510.4 395.9 512 400 512s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-13.17-13.17C460.1 387.3 464.5 271.1 408.6 183.5z"],
    "bowl-chopsticks": [512, 512, [], "e2e9", "M479.1 223.1H32c-17.62 0-31.1 14.56-31.1 32.19c0 94.76 51.5 176.9 128 221.3l-.0033 2.501C128 497.7 142.3 512 160 512h191.1c17.67 0 31.1-14.33 31.1-32l-.0033-2.501c76.5-44.38 128-126.6 128-221.3C511.1 238.6 497.6 223.1 479.1 223.1zM367.9 449.8c-9.869 5.725-15.94 16.27-15.94 27.68v2.5H160v-2.5c0-11.41-6.074-21.96-15.94-27.68c-69.12-40.09-112.1-114.4-112.1-193.8h447.1C479.1 335.4 437.1 409.7 367.9 449.8zM15.97 128c1.062 0 2.125-.0938 3.156-.3125l479.1-96.01c8.687-1.734 14.31-10.16 12.56-18.83c-1.75-8.688-10.59-14.31-18.81-12.55L12.88 96.33C4.194 98.07-1.431 106.5 .319 115.2C1.85 122.8 8.506 128 15.97 128zM15.97 191.1c.375 0 .7187-.0156 1.094-.0313l479.1-32c8.812-.5938 15.5-8.219 14.91-17.03c-.5938-8.829-8.375-15.2-17.03-14.91L14.94 160C6.131 160.6-.5559 168.2 .0378 177C.6003 185.5 7.631 191.1 15.97 191.1z"],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", "M511.7 12.87c-1.75-8.688-10.59-14.31-18.81-12.55L208 57.3v32.63l291.1-58.23C507.8 29.97 513.4 21.54 511.7 12.87zM479.1 223.1L176 224V32c0-8.838-7.164-16-16-16S144 23.16 144 32v192h-32V48C112 39.16 104.8 32 96 32C87.16 32 80 39.16 80 48v34.9L12.88 96.33C4.193 98.06-1.432 106.5 .3184 115.2c1.531 7.609 8.188 12.86 15.66 12.86c1.062 0 2.125-.0938 3.156-.3125L80 115.5V155.7L14.94 160C6.131 160.6-.5566 168.2 .0371 177c.5625 8.455 7.594 14.94 15.94 14.94c.375 0 .7187-.0156 1.094-.0313L80 187.7v36.23L32 223.1c-17.62 0-31.1 14.56-31.1 32.19c0 94.76 51.5 176.9 128 221.3l-.0035 2.501C128 497.7 142.3 512 160 512h191.1c17.67 0 31.1-14.33 31.1-32l-.0035-2.501c76.5-44.38 128-126.6 128-221.3C511.1 238.6 497.6 223.1 479.1 223.1zM367.9 449.8c-9.869 5.725-15.94 16.27-15.94 27.68v2.5H160v-2.5c0-11.41-6.074-21.96-15.94-27.68c-69.12-40.1-112.1-114.4-112.1-193.8h447.1C479.1 335.4 437.1 409.7 367.9 449.8zM511.1 142.9c-.5938-8.828-8.375-15.2-17.03-14.91L208 147.1v32.08L497.1 159.9C505.9 159.3 512.6 151.7 511.1 142.9z"],
    "bowl-hot": [512, 512, ["soup"], "f823", "M168.8 94.31C183.1 101.5 192 115.8 192 131.8V144C192 152.8 199.2 160 208 160S224 152.8 224 144V131.8c0-28.16-15.66-53.48-40.84-66.09C168.9 58.55 160 44.19 160 28.22V16C160 7.156 152.8 0 144 0S128 7.156 128 16v12.22C128 56.38 143.7 81.7 168.8 94.31zM296.8 94.31C311.1 101.5 320 115.8 320 131.8V144C320 152.8 327.2 160 336 160S352 152.8 352 144V131.8c0-28.16-15.66-53.48-40.84-66.09C296.9 58.55 288 44.19 288 28.22V16C288 7.156 280.8 0 272 0S256 7.156 256 16v12.22C256 56.38 271.7 81.7 296.8 94.31zM480 192H32c-17.62 0-32 14.37-32 31.1c0 94.75 51.5 177.1 128 221.5v34.5c0 17.62 14.38 31.1 32 31.1h192c17.62 0 32-14.37 32-31.1v-34.5c76.5-44.38 128-126.7 128-221.5C512 206.4 497.6 192 480 192zM352 427v53H160v-53c-132.4-76.63-128-185.8-128-203h448C480 241.5 483.4 350.9 352 427z"],
    "bowl-rice": [512, 512, [], "e2eb", "M38.53 159.9c8.438 1.141 16.75-5.141 17.84-13.89c2.969-23.8 23.22-41.78 48.72-41.78h.4375C113.8 104.9 119.8 99.5 121.7 92.17c7.5-29.42 42.72-45.77 70.5-29.33C195.9 65.03 200.4 65.66 204.5 64.48c4.156-1.125 7.688-3.891 9.781-7.641C222.8 41.52 238.8 32 256 32s33.19 9.516 41.72 24.84c2.094 3.75 5.625 6.516 9.781 7.641c4.156 1.156 8.562 .5313 12.31-1.641c27.84-16.41 63-.0938 70.5 29.33C392.2 99.52 401.3 104.2 408 104c24.16 0 44.63 18.05 47.63 41.98C456.6 154.1 463.3 160 471.3 160c.6562 0 1.527-.0469 2.184-.125c8.781-1.094 15-9.094 13.91-17.86c-4.5-36-32.69-64.02-69.81-69c-15.81-37.69-61.31-58.72-100.4-44.2C302.1 10.75 279.8 0 256 0S209.9 10.75 194.9 28.81c-39-14.45-84.28 6.312-100.2 43.73C58.56 76.78 29.22 105.2 24.63 142C23.53 150.8 29.75 158.8 38.53 159.9zM480 192H32C14.38 192 0 206.4 0 224c0 94.75 51.5 177.1 128 221.5V480c0 17.62 14.38 32 32 32h192c17.62 0 32-14.38 32-32v-34.5C460.5 401.1 512 318.8 512 224C512 206.4 497.6 192 480 192zM367.9 417.8C358.1 423.5 352 434.1 352 445.5V480H160v-34.5c0-11.41-6.074-21.96-15.94-27.68C74.94 377.7 32 303.5 32 224h448C480 303.5 437.1 377.7 367.9 417.8z"],
    "bowling-ball": [512, 512, [], "f436", "M239.1 184c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C263.1 194.7 253.2 184 239.1 184zM239.1 88c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C263.1 98.74 253.2 88 239.1 88zM143.1 152c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C167.1 162.7 157.2 152 143.1 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "bowling-ball-pin": [576, 512, [], "e0c3", "M119.1 224C106.7 224 96 234.7 96 248S106.7 272 119.1 272C133.3 272 144 261.3 144 248S133.3 224 119.1 224zM200 240C186.7 240 176 250.7 176 264S186.7 288 200 288S224 277.3 224 264S213.3 240 200 240zM200 160C186.7 160 176 170.7 176 184S186.7 208 200 208S224 197.3 224 184S213.3 160 200 160zM208 96C93.13 96 0 189.1 0 304S93.13 512 208 512S416 418.9 416 304S322.9 96 208 96zM208 480C110.1 480 32 401 32 304S110.1 128 208 128S384 206.1 384 304S305 480 208 480zM549 264.7c-12.53-29.3-24.38-56.98-24.38-83.7c0-10.59 3.875-21 8.344-33.05c6.094-16.39 13.66-36.78 13.66-64.44c0-54.75-37.53-83.47-74.75-83.55c-37.06 0-74.56 28.7-74.56 83.55c0 27.66 7.562 48.05 13.66 64.44c4.469 12.05 8.344 22.45 8.344 33.05c0 2.57-.5781 5.188-.7871 7.773c8.775 16.01 15.58 33.2 20.54 51.17C444.6 224.3 448.9 208.3 450.3 192h43.4c2.551 29.34 14.14 57.78 25.93 85.33C532.2 306.6 544 334.3 544 361c0 45.33-18.06 81.2-33.38 111.6C508.3 477.2 503.8 480 498.8 480h-53.63c-4.938 0-9.438-2.828-12.34-8.562c-6.547-12.91-13.64-27.48-19.67-43.44c-6.564 10.84-13.82 21.2-21.97 30.83c4.604 10.18 9.348 19.65 13.73 28.3C412.8 502.5 428.2 512 445.2 512h53.63c17.06 0 32.53-9.562 41.16-26.56C555.2 455.3 576 413.1 576 361C576 327.8 562.3 295.7 549 264.7zM495.5 160h-46.97c-6.131-24.69-19.17-44.08-19.17-76.45C429.3 47.94 450.7 32 471.1 32c21.25 .0469 42.69 16 42.69 51.55C514.7 116.1 501.8 134.8 495.5 160z"],
    "bowling-pins": [512, 512, [], "f437", "M461 264.7c-12.53-29.3-24.38-56.98-24.38-83.7c0-10.59 3.875-21 8.344-33.05c6.094-16.39 13.66-36.78 13.66-64.44c0-54.75-37.49-83.47-74.71-83.55c-37.06 0-74.61 28.7-74.61 83.55c0 27.66 7.562 48.05 13.66 64.44c4.469 12.05 8.344 22.45 8.344 33.05c0 26.72-11.84 54.41-24.38 83.7C293.7 295.7 280 327.8 280 361c0 53.2 21 94.63 36.97 126.1C324.8 502.5 340.2 512 357.2 512h53.63c17.06 0 32.53-9.562 41.16-26.56c15.19-30.17 36-71.48 36-124.4C488 327.8 474.3 295.7 461 264.7zM383.1 32c21.25 .0469 42.69 16 42.69 51.55c0 32.52-12.91 51.22-19.17 76.45h-46.97c-6.13-24.69-19.17-44.08-19.17-76.45C341.3 47.94 362.7 32 383.1 32zM422.6 472.6C420.3 477.2 415.8 480 410.8 480h-53.63c-4.938 0-9.438-2.828-12.34-8.562C330.2 442.5 312 406.6 312 361c0-26.72 11.84-54.39 24.38-83.69C348.2 249.8 359.8 221.3 362.3 192h43.4c2.551 29.35 14.14 57.78 25.93 85.33C444.2 306.6 456 334.3 456 361C456 406.3 437.9 442.2 422.6 472.6zM180.7 181c0-10.59 3.875-21 8.344-33.05c6.094-16.39 13.66-36.78 13.66-64.44c0-54.75-37.49-83.47-74.71-83.55c-37.06 0-74.61 28.7-74.61 83.55c0 27.66 7.562 48.05 13.66 64.44c4.469 12.05 8.344 22.45 8.344 33.05c0 26.72-11.84 54.41-24.38 83.7C37.72 295.7 24 327.8 24 361c0 53.2 21 94.63 36.97 126.1C68.75 502.5 84.19 512 101.2 512h53.63C171.9 512 187.4 502.4 196 485.4c15.19-30.17 36-71.48 36-124.4c0-33.27-13.72-65.3-26.97-96.28C192.5 235.4 180.7 207.8 180.7 181zM127.1 32c21.25 .0469 42.69 16 42.69 51.55c0 32.52-12.91 51.22-19.17 76.45H104.5C98.39 135.3 85.34 115.9 85.34 83.55C85.34 47.94 106.7 32 127.1 32zM166.6 472.6C164.3 477.2 159.8 480 154.8 480H101.2c-4.938 0-9.438-2.828-12.34-8.562C74.22 442.5 56 406.6 56 361c0-26.72 11.84-54.39 24.38-83.69C92.16 249.8 103.8 221.3 106.3 192h43.4c2.551 29.35 14.14 57.78 25.93 85.33C188.2 306.6 200 334.3 200 361C200 406.3 181.9 442.2 166.6 472.6z"],
    "box": [448, 512, [62566], "1f4e6", "M442.9 162.1l-51.78-103.5C383 42.28 366.4 32 348.2 32H99.78C81.6 32 64.97 42.27 56.84 58.54L5.066 162.1C1.734 168.8 0 176.1 0 183.5V416c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V183.5C448 176.1 446.3 168.8 442.9 162.1zM240 64h108.2c6.125 0 11.59 3.375 14.31 8.844L406.1 160H240V64zM85.47 72.83C88.19 67.38 93.66 64 99.78 64H208v96H41.89L85.47 72.83zM416 416c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V416z"],
    "box-archive": [512, 512, ["archive"], "f187", "M464 32h-416C21.49 32 0 53.49 0 80v64C0 152.8 7.25 160 16 160H32v256c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V160h16C504.8 160 512 152.8 512 144V80C512 53.49 490.5 32 464 32zM448 416c0 17.6-14.4 32-32 32H96c-17.6 0-32-14.4-32-32V160h384V416zM480 128H32V80C32 71.25 39.25 64 48 64h416C472.8 64 480 71.25 480 80V128zM176 256h160C344.8 256 352 248.8 352 240S344.8 224 336 224h-160C167.2 224 160 231.2 160 240S167.2 256 176 256z"],
    "box-ballot": [576, 512, [63285], "1f5f3", "M528 160h-32C487.2 160 480 167.2 480 176S487.2 192 496 192h32C536.8 192 544 199.2 544 208V320H32V208C32 199.2 39.19 192 48 192h32C88.84 192 96 184.8 96 176S88.84 160 80 160h-32C21.53 160 0 181.5 0 208v256C0 490.5 21.53 512 48 512h480c26.47 0 48-21.53 48-48v-256C576 181.5 554.5 160 528 160zM544 464c0 8.828-7.188 16-16 16h-480C39.19 480 32 472.8 32 464V352h512V464zM144 256h288C440.8 256 448 248.8 448 240v-192C448 21.53 426.5 0 400 0h-224C149.5 0 128 21.53 128 48v192C128 248.8 135.2 256 144 256zM160 48C160 39.17 167.2 32 176 32h224C408.8 32 416 39.17 416 48V224H160V48z"],
    "box-check": [448, 512, [], "f467", "M442.9 162.1l-51.78-103.6C383 42.27 366.4 32 348.2 32H99.78C81.6 32 64.97 42.27 56.84 58.54L5.066 162.1C1.734 168.8 0 176.1 0 183.5V416c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V183.5C448 176.1 446.3 168.7 442.9 162.1zM240 64h108.2c6.125 0 11.59 3.375 14.31 8.844L406.1 160H240V64zM85.47 72.83C88.19 67.38 93.66 64 99.78 64H208v96H41.89L85.47 72.83zM416 416c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V416zM186 379.3C189.2 382.4 193.3 384 197.3 384s8.188-1.562 11.31-4.688l106.7-106.7c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-95.34 95.36L155.3 303.4c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L186 379.3z"],
    "box-circle-check": [576, 512, [], "e0c4", "M432 224C352.5 224 288 288.5 288 368s64.46 144 144 144C511.5 512 576 447.5 576 368S511.5 224 432 224zM432 480C370.2 480 320 429.8 320 368S370.2 256 432 256C493.8 256 544 306.2 544 368S493.8 480 432 480zM476.7 319.4l-63.34 63.34l-26.03-26.02c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l37.34 37.33c3.125 3.125 7.219 4.688 11.31 4.688s8.188-1.562 11.31-4.688l74.66-74.66c6.25-6.25 6.25-16.38 0-22.62S482.9 313.1 476.7 319.4zM256 448H64c-17.67 0-32-14.33-32-32V192h407.5C444.2 192 448 188.2 448 183.5c0-7.443-1.732-14.79-5.062-21.44l-51.78-103.5C383 42.28 366.4 32 348.2 32H99.78C81.6 32 64.97 42.27 56.84 58.54L5.066 162.1C1.734 168.8 0 176.1 0 183.5V416c0 35.35 28.65 64 64 64h192c8.836 0 16-7.164 16-16C272 455.2 264.8 448 256 448zM240 64h108.2c6.125 0 11.59 3.375 14.31 8.844L406.1 160H240V64zM85.47 72.83C88.19 67.38 93.66 64 99.78 64H208v96H41.89L85.47 72.83z"],
    "box-dollar": [448, 512, ["box-usd"], "f4a0", "M214.8 367.1c-7.828-1.109-17.45-4.422-25.92-7.328l-4.578-1.562c-8.391-2.859-17.45 1.656-20.28 10.03s1.656 17.45 10.03 20.28l4.422 1.516c9.258 3.18 19.68 6.621 29.84 8.309C208.3 398.9 208 399.4 208 400L208 408c0 8.844 7.156 16 16 16s16-7.156 16-16l.0208-8c0-.5781-.2904-1.066-.349-1.627c23.66-3.641 40.63-16.4 44.31-36.62c7.25-40.03-30.54-50.32-55.63-57.16L222.4 302.9C193.5 294.9 194.4 290.1 195.5 283.1c2.047-11.14 20.95-13.53 37.58-11.05c6.203 .9219 13.03 2.938 19.52 5.078c8.328 2.75 17.44-1.813 20.2-10.2c2.75-8.391-1.812-17.44-10.2-20.2C253.6 244.6 246.4 242.8 240 241.7V232c0-8.844-7.156-16-16-16s-16 7.156-16 16v9.143C184.3 244.8 167.7 258 164 278.3c-7.188 39.56 31.25 50.33 49.72 55.5l5.927 1.63c30.16 8.219 34.4 12.01 32.84 20.65C250.5 367.2 231.6 369.6 214.8 367.1zM442.9 162.1l-51.78-103.5C383 42.28 366.4 32 348.2 32H99.78C81.6 32 64.97 42.27 56.84 58.54L5.066 162.1C1.734 168.8 0 176.1 0 183.5V416c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V183.5C448 176.1 446.3 168.8 442.9 162.1zM240 64h108.2c6.125 0 11.59 3.375 14.31 8.844L406.1 160H240V64zM85.47 72.83C88.19 67.38 93.66 64 99.78 64H208v96H41.89L85.47 72.83zM416 416c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V416z"],
    "box-heart": [448, 512, [], "f49d", "M214.1 411.9c5.5 5.5 14.25 5.5 19.75 0l84.75-85.63c24.62-24.88 23.12-66-4.375-89c-13.88-11.62-47.63-28.5-90.13 14.5c-42.63-43-76.38-26.12-90.25-14.5c-27.5 23-28.88 64.13-4.25 89L214.1 411.9zM154.2 261.7c13.75-11.5 31.25-3.375 38.5 3.75l31.38 31.75l31.38-31.75c7.125-7.25 24.62-15.25 38.38-3.75c14.38 12 12.38 31.62 2.125 42l-72 72.63L152.2 303.7C141.8 293.4 139.8 273.7 154.2 261.7zM442.9 162.1l-51.78-103.6C383 42.27 366.4 32 348.2 32H99.78C81.6 32 64.97 42.27 56.84 58.54L5.066 162.1C1.734 168.8 0 176.1 0 183.5V416c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V183.5C448 176.1 446.3 168.7 442.9 162.1zM240 64h108.2c6.125 0 11.59 3.375 14.31 8.844L406.1 160H240V64zM85.47 72.83C88.19 67.38 93.66 64 99.78 64H208v96H41.89L85.47 72.83zM416 416c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V416z"],
    "box-open": [640, 512, [], "f49e", "M560 223.1c-8.844 0-16 7.156-16 16v137.7c0 7.234-4.891 13.59-11.88 15.47L336 445.4V223.1c0-8.844-7.156-16-16-16s-16 7.156-16 16v221.4l-196.1-52.3C100.9 391.2 96 384.9 96 377.7v-137.7c0-8.844-7.156-16-16-16s-16 7.156-16 16v137.7c0 21.69 14.64 40.77 35.63 46.38l199.8 53.28C306.1 479.1 313 480 319.1 480s13.89-.9062 20.64-2.703l199.8-53.27C561.4 418.4 576 399.3 576 377.7v-137.7C576 231.1 568.8 223.1 560 223.1zM638.7 153.7l-48-112c-2.812-6.547-9.531-10.38-16.69-9.58L320 64L65.98 32.1C58.83 31.31 52.11 35.14 49.3 41.68l-48 112c-1.875 4.344-1.703 9.314 .4375 13.53c2.141 4.234 6.047 7.297 10.67 8.359l208 48.01C221.6 223.9 222.8 224 224 224c4.969 0 9.734-2.312 12.8-6.406L320 106.6l83.2 110.1C406.3 221.7 411 224 416 224c1.188 0 2.406-.1406 3.594-.4062l208-48.01c4.625-1.062 8.531-4.125 10.67-8.359C640.4 163 640.6 158 638.7 153.7zM217.5 190.1L38.25 148.7l35.72-83.35l216.7 27.08L217.5 190.1zM422.5 190.1l-73.2-97.62l216.7-27.08l35.72 83.35L422.5 190.1z"],
    "box-open-full": [640, 512, ["box-full"], "f49c", "M559.1 351.1c-8.844 0-16 7.156-16 16v41.66c0 7.234-4.891 13.59-11.88 15.47l-196.1 52.29v-125.4c0-8.844-7.156-16-16-16s-16 7.156-16 16v125.4l-196.1-52.3c-7-1.875-11.89-8.234-11.89-15.47v-41.66c0-8.844-7.156-16-16-16s-16 7.156-16 16v41.66c0 21.69 14.64 40.77 35.63 46.38l199.8 53.28C306.1 511.1 313 512 319.1 512s13.88-.9062 20.63-2.703l199.8-53.27c20.97-5.609 35.61-24.69 35.61-46.38v-41.66C575.1 359.1 568.8 351.1 559.1 351.1zM638.7 281.7l-48-112c-2.812-6.547-9.531-10.38-16.69-9.58l-254 31.9L65.98 160.1C58.83 159.3 52.11 163.1 49.29 169.7l-48 112c-1.875 4.344-1.703 9.314 .4375 13.53C3.873 299.5 7.779 302.5 12.4 303.6l208 48.01C221.6 351.9 222.8 352 223.1 352c4.969 0 9.734-2.312 12.8-6.406L319.1 234.6l83.2 110.1C406.3 349.7 411 352 415.1 352c1.188 0 2.406-.1406 3.594-.4062l208-48.01c4.625-1.062 8.531-4.125 10.67-8.359C640.4 291 640.6 286 638.7 281.7zM217.5 318.1L38.25 276.7l35.72-83.35l216.7 27.08L217.5 318.1zM422.5 318.1l-73.2-97.62l216.7-27.08l35.72 83.35L422.5 318.1zM144 144C152.8 144 160 136.8 160 128c0-52.94 43.06-96 96-96s96 43.06 96 96c0 8.844 7.156 16 16 16S384 136.8 384 128c0-70.58-57.4-128-127.1-128S128 57.47 128 128C128 136.9 135.2 144 144 144zM442.9 143.2C444.6 143.7 446.3 144 448 144c6.688 0 12.94-4.234 15.19-10.94l32-96c2.781-8.391-1.75-17.45-10.12-20.23c-8.312-2.719-17.41 1.719-20.25 10.11l-32 96C430 131.3 434.6 140.4 442.9 143.2z"],
    "box-taped": [448, 512, ["box-alt"], "f49a", "M442.9 162.1l-51.78-103.5C383 42.28 366.4 32 348.2 32H99.78C81.6 32 64.97 42.27 56.84 58.54L5.066 162.1C1.734 168.8 0 176.1 0 183.5V416c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V183.5C448 176.1 446.3 168.8 442.9 162.1zM348.2 64c6.125 0 11.59 3.375 14.31 8.844L406.1 160h-118.1l-13.52-96H348.2zM192.2 160l13.71-96h36.26L256 160H192.2zM256 192v96H191.1l-.1113-96H256zM85.47 72.83C88.19 67.38 93.66 64 99.78 64h73.79L160 160H41.89L85.47 72.83zM416 416c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h128v112C160 312.8 167.2 320 176 320h96c8.844 0 16-7.156 16-16L287.9 192H416V416z"],
    "box-tissue": [512, 512, [], "e05b", "M144 320h224c10.33 0 19.48-6.578 22.84-16.62l55.94-175.8c2.422-7.297 1.188-15.38-3.312-21.61C438.1 99.72 431.7 96 424 96h-85.41c-19.92 0-37.53-12.69-43.83-31.59C281.9 25.89 246 0 205.4 0H88C80.67 0 73.84 3.281 69.28 8.984c-4.594 5.719-6.312 13.11-4.766 19.98l56.05 272.2C123 312.3 132.7 320 144 320zM205.4 32c26.81 0 50.53 17.09 59 42.52C275.1 106.5 304.9 128 338.6 128h74.47l-50.91 160H150.5L97.81 32H205.4zM464 224H448c-8.844 0-16 7.156-16 16S439.2 256 448 256h16C472.8 256 480 263.2 480 272V384H32V272C32 263.2 39.19 256 48 256H64c8.844 0 16-7.156 16-16S72.84 224 64 224H48C21.53 224 0 245.5 0 272v192C0 490.5 21.53 512 48 512h416c26.47 0 48-21.53 48-48v-192C512 245.5 490.5 224 464 224zM480 464c0 8.828-7.188 16-16 16h-416C39.19 480 32 472.8 32 464V416h448V464z"],
    "boxes-stacked": [576, 512, [62625, "boxes", "boxes-alt"], "f468", "M208 224h160C394.5 224 416 202.5 416 176v-128C416 21.49 394.5 0 368 0h-160C181.5 0 160 21.49 160 48v128C160 202.5 181.5 224 208 224zM272 32h32v54.11l-8.844-4.422c-4.5-2.25-9.812-2.25-14.31 0L272 86.11V32zM192 48C192 39.18 199.2 32 208 32h32v80c0 5.547 2.875 10.69 7.594 13.61s10.59 3.141 15.56 .7031L288 113.9l24.84 12.42C315.1 127.4 317.5 128 320 128c2.922 0 5.844-.7969 8.406-2.391C333.1 122.7 336 117.5 336 112V32h32C376.8 32 384 39.18 384 48v128C384 184.8 376.8 192 368 192h-160C199.2 192 192 184.8 192 176V48zM208 288h-160C21.49 288 0 309.5 0 336v128C0 490.5 21.49 512 48 512h160C234.5 512 256 490.5 256 464v-128C256 309.5 234.5 288 208 288zM112 320h32v54.11l-8.844-4.422c-4.5-2.25-9.812-2.25-14.31 0L112 374.1V320zM224 464C224 472.8 216.8 480 208 480h-160C39.18 480 32 472.8 32 464v-128C32 327.2 39.18 320 48 320h32v80c0 5.547 2.875 10.69 7.594 13.61s10.59 3.141 15.56 .7031L128 401.9l24.84 12.42C155.1 415.4 157.5 416 160 416c2.922 0 5.844-.7969 8.406-2.391C173.1 410.7 176 405.5 176 400V320h32C216.8 320 224 327.2 224 336V464zM528 288h-160C341.5 288 320 309.5 320 336v128c0 26.51 21.49 48 48 48h160c26.51 0 48-21.49 48-48v-128C576 309.5 554.5 288 528 288zM432 320h32v54.11l-8.844-4.422c-4.5-2.25-9.812-2.25-14.31 0L432 374.1V320zM544 464c0 8.822-7.178 16-16 16h-160c-8.822 0-16-7.178-16-16v-128c0-8.822 7.178-16 16-16h32v80c0 5.547 2.875 10.69 7.594 13.61s10.59 3.141 15.56 .7031L448 401.9l24.84 12.42C475.1 415.4 477.5 416 480 416c2.922 0 5.844-.7969 8.406-2.391C493.1 410.7 496 405.5 496 400V320h32c8.822 0 16 7.178 16 16V464z"],
    "boxing-glove": [512, 512, [62520, "glove-boxing"], "1f94a", "M416 129.6L415.1 96c0-52.94-43.06-96-95.1-96H127.1C75.06 0 32.01 43.06 32.01 96L32 288c0 27.41 11.56 52.87 31.1 71.14L64 448c0 35.3 28.7 64 64 64h192c35.3 0 64-28.7 64-64v-57.38l63.19-63.19C468.3 306.3 480 278.2 480 248.2V208C480 169.4 452.5 137.1 416 129.6zM448 248.2c0 21.38-8.328 41.47-23.44 56.58L352 377.4V448c0 17.64-14.36 32-32 32H128c-17.64 0-32-14.36-32-32v-104.3l-6.359-4.797C73.34 326.6 64 308 64 288V96c0-35.3 28.7-64 64-64h192c35.3 0 64 28.7 64 64v32h-16c-38.63 0-70.95 27.53-78.38 64H217.7C183.1 192 149.6 181.9 120.9 162.7C113.5 157.8 103.6 159.8 98.69 167.1C93.78 174.5 95.78 184.4 103.1 189.3C137.2 212 176.8 224 217.7 224h71.93C297.1 260.5 329.4 288 368 288C376.8 288 384 280.8 384 272S376.8 256 368 256C341.5 256 320 234.5 320 208S341.5 160 368 160h32C426.5 160 448 181.5 448 208V248.2zM285.3 343.1c-4.922-7.375-14.81-9.328-22.19-4.438L224 364.8l-39.13-26.08c-7.391-4.891-17.31-2.938-22.19 4.438c-4.906 7.359-2.922 17.28 4.438 22.19L195.2 384l-28.03 18.69c-7.359 4.906-9.344 14.83-4.438 22.19c3.356 5.043 12.79 10.66 22.19 4.438L224 403.2l39.13 26.08c9.385 6.221 18.78 .6881 22.19-4.438c4.906-7.359 2.922-17.28-4.438-22.19L252.8 384l28.03-18.69C288.2 360.4 290.2 350.5 285.3 343.1z"],
    "bracket-curly": [256, 512, ["bracket-curly-left"], "7b", "M96 152.5V112C96 85.53 117.5 64 144 64h64C216.8 64 224 56.82 224 48S216.8 32 208 32h-64C99.89 32 64 67.89 64 112v40.45c0 38.03-21.13 72.22-55.16 89.23C3.383 244.4 0 249.9 0 256s3.383 11.56 8.828 14.3C42.87 287.3 64 321.5 64 359.5V400c0 44.11 35.89 80 80 80h64c8.822 0 16-7.178 16-16S216.8 448 208 448h-64C117.5 448 96 426.5 96 400v-40.45C96 318.7 77.43 280.8 45.79 256C77.43 231.2 96 193.3 96 152.5z"],
    "bracket-curly-right": [256, 512, [], "7d", "M210.2 256C178.6 280.8 160 318.7 160 359.5V400c0 26.47-21.53 48-48 48h-64C39.18 448 32 455.2 32 464S39.18 480 48 480h64c44.11 0 80-35.89 80-80v-40.45c0-38.03 21.13-72.22 55.17-89.24C252.6 267.6 256 262.1 256 256s-3.383-11.56-8.844-14.31C213.1 224.7 192 190.5 192 152.5V112C192 67.89 156.1 32 112 32h-64C39.18 32 32 39.18 32 48S39.18 64 48 64h64C138.5 64 160 85.53 160 112v40.45C160 193.3 178.6 231.2 210.2 256z"],
    "bracket-round": [192, 512, ["parenthesis"], "28", "M121.4 451.1c7.126 5.188 8.72 15.19 3.532 22.31c-3.157 4.313-8.032 6.625-12.97 6.625c-3.25 0-6.501-1-9.345-3.031c-4.188-3.031-102.6-75.81-102.6-220.1s98.45-217.9 102.6-220.1c7.126-5.125 17.1-3.625 22.31 3.594c5.188 7.125 3.594 17.13-3.532 22.31c-3.657 2.688-89.42 66.78-89.42 195.1S117.8 448.4 121.4 451.1z"],
    "bracket-round-right": [192, 512, [], "29", "M159.1 255.1c0-128.3-85.76-192.4-89.42-195.1C63.46 55.75 61.86 45.75 67.05 38.62c5.219-7.219 15.19-8.719 22.31-3.594C93.55 38.06 192 110.8 192 256s-98.45 217.9-102.6 220.1C86.52 479 83.27 480 80.02 480c-4.938 0-9.813-2.313-12.97-6.625c-5.188-7.125-3.594-17.13 3.532-22.31C74.24 448.4 159.1 384.3 159.1 255.1z"],
    "bracket-square": [192, 512, ["bracket", "bracket-left"], "5b", "M48 64h96C152.8 64 160 56.82 160 48S152.8 32 144 32h-96C21.53 32 0 53.53 0 80v352C0 458.5 21.53 480 48 480h96c8.822 0 16-7.178 16-16S152.8 448 144 448h-96C39.18 448 32 440.8 32 432v-352C32 71.18 39.18 64 48 64z"],
    "bracket-square-right": [192, 512, [], "5d", "M160 80v352c0 8.822-7.178 16-16 16h-96C39.18 448 32 455.2 32 464S39.18 480 48 480h96c26.47 0 48-21.53 48-48v-352C192 53.53 170.5 32 144 32h-96C39.18 32 32 39.18 32 48S39.18 64 48 64h96C152.8 64 160 71.18 160 80z"],
    "brackets-curly": [576, 512, [], "f7ea", "M96 152.5V112C96 85.53 117.5 64 144 64h64C216.8 64 224 56.82 224 48S216.8 32 208 32h-64C99.89 32 64 67.89 64 112v40.45c0 38.03-21.13 72.22-55.16 89.23C3.383 244.4 0 249.9 0 256s3.383 11.56 8.828 14.3C42.87 287.3 64 321.5 64 359.5V400C64 444.1 99.89 480 144 480h64C216.8 480 224 472.8 224 464S216.8 448 208 448h-64C117.5 448 96 426.5 96 400v-40.45C96 318.7 77.43 280.8 45.79 256C77.43 231.2 96 193.3 96 152.5zM567.2 241.7C533.1 224.7 512 190.5 512 152.5V112C512 67.89 476.1 32 432 32h-64C359.2 32 352 39.18 352 48S359.2 64 368 64h64C458.5 64 480 85.53 480 112v40.45C480 193.3 498.6 231.2 530.2 256C498.6 280.8 480 318.7 480 359.5V400c0 26.47-21.53 48-48 48h-64c-8.822 0-16 7.178-16 16s7.178 16 16 16h64c44.11 0 80-35.89 80-80v-40.45c0-38.03 21.13-72.22 55.16-89.23C572.6 267.6 576 262.1 576 256S572.6 244.4 567.2 241.7z"],
    "brackets-round": [512, 512, ["parentheses"], "e0c5", "M121.4 60.93c7.125-5.188 8.719-15.19 3.531-22.31C119.7 31.4 109.8 29.9 102.6 35.03C98.44 38.06 0 110.8 0 256s98.44 217.9 102.6 220.1c2.844 2.031 6.094 3.031 9.344 3.031c4.938 0 9.812-2.313 12.97-6.625c5.188-7.125 3.594-17.13-3.531-22.31C117.8 448.4 32 384.3 32 255.1S117.8 63.62 121.4 60.93zM409.4 35.03c-7.156-5.094-17.06-3.563-22.31 3.594c-5.188 7.125-3.594 17.13 3.531 22.31C394.3 63.62 480 127.7 480 255.1s-85.75 192.4-89.41 195.1c-7.125 5.188-8.719 15.19-3.531 22.31c3.156 4.344 8.031 6.625 12.97 6.625c3.25 0 6.5-1 9.344-3.031C413.6 473.9 512 401.2 512 256S413.6 38.06 409.4 35.03z"],
    "brackets-square": [448, 512, ["brackets"], "f7e9", "M400 32h-96C295.2 32 288 39.18 288 48S295.2 64 304 64h96C408.8 64 416 71.18 416 80v352c0 8.822-7.178 16-16 16h-96c-8.822 0-16 7.178-16 16s7.178 16 16 16h96c26.47 0 48-21.53 48-48v-352C448 53.53 426.5 32 400 32zM48 64h96C152.8 64 160 56.82 160 48S152.8 32 144 32h-96C21.53 32 0 53.53 0 80v352C0 458.5 21.53 480 48 480h96C152.8 480 160 472.8 160 464S152.8 448 144 448h-96C39.18 448 32 440.8 32 432v-352C32 71.18 39.18 64 48 64z"],
    "braille": [640, 512, [], "f2a1", "M80 48c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S115.3 48 80 48zM80 144c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S97.64 144 80 144zM240 48c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S275.3 48 240 48zM240 144c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S257.6 144 240 144zM432 48c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S467.3 48 432 48zM432 144c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S449.6 144 432 144zM80 208c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S115.3 208 80 208zM80 304c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S97.64 304 80 304zM80 408c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C104 418.7 93.26 408 80 408zM240 408c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C264 418.7 253.3 408 240 408zM432 408c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C456 418.7 445.3 408 432 408zM592 408c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C616 418.7 605.3 408 592 408zM240 248c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24S264 285.3 264 272C264 258.7 253.3 248 240 248zM432 248c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C456 258.7 445.3 248 432 248zM592 248c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24s24-10.75 24-24C616 258.7 605.3 248 592 248zM592 136c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24s-24 10.74-24 24C568 125.3 578.7 136 592 136z"],
    "brain": [512, 512, [62940], "1f9e0", "M512 288c0-24.14-9.002-46.92-24.84-64.35C487.7 219.8 488 215.9 488 212c0-29.63-15.9-56.33-40.01-71.27C447.1 140.3 448 139.9 448 139.5c0-30.73-16.36-58.07-41.8-72.86C398.2 28.62 364.4 0 324 0C296.1 0 271.3 13.7 256 34.74C240.7 13.7 215.9 0 188 0C147.6 0 113.8 28.62 105.8 66.64c-23.44 13.63-39.17 37.9-41.5 65.66C39.9 147.2 24 174.1 24 204c0 6.295 .7051 12.52 2.086 18.58C9.588 240.1 0 263.5 0 288c0 28.6 12.5 54.88 33.38 72.75C32.47 365.8 32 370.9 32 376c0 48.08 38.76 87.27 86.68 87.98C131 492.2 159.3 512 192 512c26.14 0 49.39-12.6 64-32.05C270.6 499.4 293.9 512 320 512c32.75 0 60.96-19.78 73.32-48.01C441.2 463.3 480 424.1 480 376c0-5.115-.4648-10.23-1.381-15.26C499.5 342.9 512 316.6 512 288zM240 432C240 458.5 218.5 480 192 480s-48-21.49-48-48c0-2.027 .3516-3.959 .5957-5.92C137.1 429.8 128.9 432 120 432C89.07 432 64 406.9 64 376c0-10.54 3.088-20.28 8.148-28.7C48.64 337.8 32 314.9 32 288c0-23.87 13.22-44.45 32.6-55.45C59.19 224.4 56 214.6 56 204c0-25.29 18.06-46.31 41.98-50.99C96.82 148.7 96 144.2 96 139.5c0-24.83 17.29-45.52 40.46-50.98C136.3 87.01 136 85.55 136 84C136 55.28 159.3 32 188 32S240 55.28 240 84V432zM439.9 347.3C444.9 355.7 448 365.5 448 376c0 30.93-25.07 56-56 56c-8.869 0-17.14-2.25-24.6-5.92C367.6 428 368 429.1 368 432c0 26.51-21.49 48-48 48s-48-21.49-48-48V84C272 55.28 295.3 32 324 32s52 23.28 52 52c0 1.549-.3223 3.008-.4551 4.521C398.7 93.98 416 114.7 416 139.5c0 7.58-1.676 14.74-4.566 21.25C436.6 164.4 456 185.8 456 212c0 8.047-1.982 15.57-5.244 22.37C468.3 245.8 480 265.5 480 288C480 314.9 463.4 337.8 439.9 347.3z"],
    "brain-arrow-curved-right": [640, 512, ["mind-share"], "f677", "M223.5 32.2C251.8 33.68 272.9 59.02 272.9 87.29v201.8c0 8.873 7.191 16.06 16.06 16.06s16.06-7.191 16.06-16.06V87.29c0-28.27 21.17-53.61 49.4-55.09c30.11-1.576 55.01 22.37 55.01 52.13c0 1.555-.3242 3.02-.457 4.539c23.26 5.484 40.62 26.25 40.62 51.18c0 7.609-1.684 14.8-4.584 21.33c20.03 2.893 36.27 17.07 42.16 35.91c2.113 6.768 8.123 11.53 15.21 11.53c10.7 0 18.49-10.38 15.36-20.61c-5.963-19.5-18.78-36.24-36.03-46.92c.0059-.4082 .0078-.8203 .0078-1.232c0-30.85-16.42-58.3-41.97-73.15C431.7 28.73 397.8 0 357.3 0c-28.04 0-52.93 13.76-68.27 34.87C273.7 13.76 248.8 0 220.7 0C180.2 0 146.3 28.73 138.2 66.9c-23.53 13.68-39.32 38.05-41.67 65.92c-24.5 14.97-40.46 41.96-40.46 71.98c0 6.32 .709 12.57 2.096 18.66C41.63 241.1 32 264.5 32 289.1c0 28.71 12.55 55.09 33.51 73.03c-.918 5.057-1.385 10.18-1.385 15.31c0 48.27 38.91 87.63 87.02 88.34c9.809 22.39 29.54 39.48 53.6 45.68c10.12 2.605 20.01-5.16 20.01-15.61c0-7.609-5.473-13.69-12.81-15.71c-20.4-5.609-35.38-24.29-35.38-46.47c0-2.035 .3535-3.975 .5996-5.943c-12.89 6.348-28.23 8.463-44.86 2.086c-15.72-6.031-28.37-19.25-33.39-35.32c-5.348-17.1-2.199-33.02 5.518-45.86c-23.6-9.506-40.3-32.53-40.3-59.53c0-23.97 13.28-44.62 32.72-55.66C91.42 225.2 88.22 215.4 88.22 204.8c0-25.38 18.13-46.49 42.14-51.19c-1.166-4.354-1.984-8.844-1.984-13.56c0-24.93 17.36-45.7 40.61-51.18C168.9 87.35 168.5 85.88 168.5 84.33C168.5 54.57 193.4 30.62 223.5 32.2zM603.3 340.7l-96-96c-6.25-6.25-16.38-6.25-22.63 0s-6.25 16.38 0 22.62L553.4 336H352c-44.11 0-80 35.88-80 80l-.002 79.9C271.1 504.7 279.2 512 288 512s16-7.156 16-16V416c0-26.47 21.53-48 48-48h201.4l-68.69 68.69c-6.25 6.25-6.25 16.38 0 22.62C487.8 462.4 491.9 464 495.1 464s8.053-1.514 11.18-4.639l96.14-96.05C609.6 357.1 609.6 346.9 603.3 340.7z"],
    "brain-circuit": [512, 512, [], "e0c6", "M512 288c0-24.14-9.002-46.92-24.84-64.35C487.7 219.8 488 215.9 488 212c0-29.63-15.9-56.33-40.01-71.27C447.1 140.3 448 139.9 448 139.5c0-30.73-16.36-58.07-41.8-72.86C398.2 28.62 364.4 0 324 0C296.1 0 271.3 13.7 256 34.74C240.7 13.7 215.9 0 188 0C147.6 0 113.8 28.62 105.8 66.64c-23.44 13.63-39.17 37.9-41.5 65.66C39.9 147.2 24 174.1 24 204c0 6.295 .7051 12.52 2.086 18.58C9.588 240.1 0 263.5 0 288c0 28.6 12.5 54.88 33.38 72.75C32.47 365.8 32 370.9 32 376c0 48.08 38.76 87.27 86.68 87.98C131 492.2 159.3 512 192 512c26.14 0 49.39-12.6 64-32.05C270.6 499.4 293.9 512 320 512c32.75 0 60.96-19.78 73.32-48.01C441.2 463.3 480 424.1 480 376c0-5.115-.4648-10.23-1.381-15.26C499.5 342.9 512 316.6 512 288zM192 480c-26.51 0-48-21.49-48-48c0-2.027 .3516-3.959 .5957-5.92C137.1 429.8 128.9 432 120 432C89.07 432 64 406.9 64 376c0-10.54 3.088-20.28 8.148-28.7C48.64 337.8 32 314.9 32 288c0-23.87 13.22-44.45 32.6-55.45C59.19 224.4 56 214.6 56 204c0-25.29 18.06-46.31 41.98-50.99C96.82 148.7 96 144.2 96 139.5c0-24.83 17.29-45.52 40.46-50.98C136.3 87.01 136 85.55 136 84C136 55.28 159.3 32 188 32S240 55.28 240 84V128H212.6C206.4 113.9 192.3 104 176 104c-22.06 0-40 17.94-40 40c0 22.05 17.94 40 40 40c16.35 0 30.35-9.916 36.55-24H240v80H192C165.5 240 144 261.5 144 288v27.45C129.9 321.6 120 335.7 120 352c0 22.05 17.94 40 40 40S200 374.1 200 352c0-16.35-9.914-30.35-24-36.55V288c0-8.828 7.172-16 16-16h48v160C240 458.5 218.5 480 192 480zM176 160C167.2 160 160 152.8 160 144C160 135.2 167.2 128 176 128S192 135.2 192 144C192 152.8 184.8 160 176 160zM176 352c0 8.836-7.164 16-16 16S144 360.8 144 352c0-8.838 7.164-16 16-16S176 343.2 176 352zM439.9 347.3C444.9 355.7 448 365.5 448 376c0 30.93-25.07 56-56 56c-8.869 0-17.14-2.25-24.6-5.92C367.6 428 368 429.1 368 432c0 26.51-21.49 48-48 48s-48-21.49-48-48v-64h43.45C321.6 382.1 335.7 392 352 392c22.06 0 40-17.95 40-40c0-22.06-17.94-40-40-40c-16.35 0-30.35 9.914-36.55 24H272v-64h32C330.5 272 352 250.5 352 224V180.6C366.1 174.4 376 160.3 376 144c0-22.06-17.94-40-40-40s-40 17.94-40 40c0 16.35 9.914 30.35 24 36.55V224c0 8.828-7.172 16-16 16h-32V84C272 55.28 295.3 32 324 32s52 23.28 52 52c0 1.549-.3223 3.008-.4551 4.521C398.7 93.98 416 114.7 416 139.5c0 7.58-1.676 14.74-4.566 21.25C436.6 164.4 456 185.8 456 212c0 8.047-1.982 15.57-5.244 22.37C468.3 245.8 480 265.5 480 288C480 314.9 463.4 337.8 439.9 347.3zM336 352c0-8.838 7.164-16 16-16s16 7.162 16 16c0 8.836-7.164 16-16 16S336 360.8 336 352zM320 144C320 135.2 327.2 128 336 128S352 135.2 352 144C352 152.8 344.8 160 336 160S320 152.8 320 144z"],
    "brake-warning": [640, 512, [], "e0c7", "M320 32C196.3 32 96 132.3 96 256s100.3 224 224 224c123.7 0 224-100.3 224-224S443.7 32 320 32zM320 448c-105.9 0-192-86.13-192-192s86.13-192 192-192s192 86.13 192 192S425.9 448 320 448zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24c13.26 0 24-10.75 24-24S333.3 328 320 328zM319.1 288C328.8 288 336 280.8 336 272v-128c0-8.844-7.153-16-15.1-16S304 135.2 304 144v128C304 280.8 311.2 288 319.1 288zM90.25 67.7C83.5 62.09 73.41 62.95 67.72 69.75C24.03 122.1 0 188.3 0 256s24.03 133.9 67.72 186.3C70.88 446 75.44 448 80 448c3.625 0 7.25-1.219 10.25-3.703c6.781-5.672 7.688-15.75 2.031-22.55C53.41 375.1 32 316.3 32 256s21.41-119.1 60.28-165.8C97.94 83.45 97.03 73.38 90.25 67.7zM572.3 69.75c-5.656-6.828-15.78-7.656-22.53-2.047c-6.781 5.672-7.688 15.75-2.031 22.55C586.6 136.9 608 195.8 608 256s-21.41 119.1-60.28 165.8c-5.656 6.797-4.75 16.88 2.031 22.55C552.8 446.8 556.4 448 560 448c4.562 0 9.125-1.953 12.28-5.75C615.1 389.9 640 323.7 640 256S615.1 122.1 572.3 69.75z"],
    "bread-loaf": [640, 512, [63467], "1f35e", "M400 32h-160C107.5 32 0 103.6 0 192c0 35.38 30.88 64 64 64v192c0 17.62 14.38 32 32 32h448c17.62 0 32-14.38 32-32V256c33.13 0 64-28.62 64-64C640 103.6 532.5 32 400 32zM384 240V448H96V240C96 231.2 88.84 224 80 224H64C48.5 224 32 209.6 32 192c0-69.38 95.25-128 208-128S448 122.6 448 192c0 17.62-12.5 32-28 32H400C391.2 224 384 231.2 384 240zM544 448h-128V256h128V448zM580 224h-108.4C477.1 214.3 480 203.3 480 192c0-52.38-38-98.88-96.5-128H400C512.8 64 608 122.6 608 192C608 209.6 595.5 224 580 224z"],
    "bread-slice": [512, 512, [], "f7ec", "M256 32C102.9 32 0 115.2 0 192.1c0 34.84 26.67 60.29 64 62.59v178.4C64 459.4 84.63 480 109.1 480h292C427.4 480 448 459.4 448 434V255.6c37.33-2.293 64-27.75 64-62.59C512 115.2 409.1 32 256 32zM442.7 224C427.9 224 416 235.9 416 250.7v183.3C416 441.7 409.7 448 401.1 448h-292C102.3 448 96 441.7 96 434v-183.3C96 235.9 84.07 224 69.34 224C47 224 32 211.5 32 192.1C32 140.3 111.8 64 256 64s224 76.25 224 128.1C480 211.5 465 224 442.7 224z"],
    "briefcase": [512, 512, [61617], "1f4bc", "M448 96h-64V48C384 21.53 362.5 0 336 0h-160C149.5 0 128 21.53 128 48V96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM160 48C160 39.17 167.2 32 176 32h160C344.8 32 352 39.17 352 48V96H160V48zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V288h144v64c0 8.844 7.156 16 16 16h128c8.844 0 16-7.156 16-16V288H480V416zM208 336V288h96v48H208zM480 256H32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V256z"],
    "briefcase-arrow-right": [512, 512, [], "e2f2", "M448 96h-64V48C384 21.53 362.5 0 336 0h-160C149.5 0 128 21.53 128 48V96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM160 48C160 39.17 167.2 32 176 32h160C344.8 32 352 39.17 352 48V96H160V48zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V416zM379.3 276.7l-79.98-79.98c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L329.4 272H144C135.2 272 128 279.2 128 288s7.156 16 16 16h185.4l-52.69 52.69c-6.25 6.25-6.25 16.38 0 22.62C279.8 382.4 283.9 384 288 384s8.188-1.562 11.31-4.688l79.98-79.98c1.484-1.48 2.662-3.254 3.477-5.223c1.617-3.91 1.617-8.309 0-12.22C381.1 279.9 380.8 278.1 379.3 276.7z"],
    "briefcase-blank": [512, 512, [], "e0c8", "M448 96h-64V48C384 21.53 362.5 0 336 0h-160C149.5 0 128 21.53 128 48V96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM160 48C160 39.17 167.2 32 176 32h160C344.8 32 352 39.17 352 48V96H160V48zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V416z"],
    "briefcase-clock": [640, 512, ["business-time"], "f64a", "M496 224C416.4 224 352 288.4 352 368s64.38 144 144 144s144-64.38 144-144S575.6 224 496 224zM496 480c-61.75 0-112-50.25-112-112S434.3 256 496 256S608 306.3 608 368S557.8 480 496 480zM544 352h-32V304C512 295.2 504.8 288 496 288S480 295.2 480 304v64c0 8.836 7.164 16 16 16H544c8.836 0 16-7.164 16-16S552.8 352 544 352zM336 448H64c-17.67 0-32-14.33-32-32V288h144v64c0 8.836 7.164 16 16 16h112c8.836 0 16-7.164 16-16s-7.164-16-16-16h-96V288h128C344.8 288 352 280.8 352 272S344.8 256 336 256H32V160c0-17.67 14.33-32 32-32h384c17.67 0 32 14.33 32 32v16C480 184.8 487.2 192 496 192S512 184.8 512 176V160c0-35.35-28.65-64-64-64h-64V48C384 21.49 362.5 0 336 0h-160C149.5 0 128 21.49 128 48V96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h272c8.836 0 16-7.164 16-16S344.8 448 336 448zM160 48C160 39.17 167.2 32 176 32h160C344.8 32 352 39.17 352 48V96H160V48z"],
    "briefcase-medical": [512, 512, [], "f469", "M448 96h-64V48C384 21.53 362.5 0 336 0h-160C149.5 0 128 21.53 128 48V96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM160 48C160 39.17 167.2 32 176 32h160C344.8 32 352 39.17 352 48V96H160V48zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V416zM336 256H288V208C288 199.2 280.8 192 272 192h-32C231.2 192 224 199.2 224 208V256H176C167.2 256 160 263.2 160 272v32C160 312.8 167.2 320 176 320H224v48C224 376.8 231.2 384 240 384h32c8.836 0 16-7.164 16-16V320h48c8.836 0 16-7.164 16-16v-32C352 263.2 344.8 256 336 256z"],
    "brightness": [512, 512, [], "e0c9", "M131.6 357.8L74.97 414.4c-6.25 6.25-6.243 16.38 .007 22.63c3.125 3.125 7.212 4.685 11.31 4.685s8.188-1.562 11.31-4.688l56.59-56.56c6.25-6.25 6.243-16.38-.007-22.63S137.8 351.6 131.6 357.8zM97.59 74.98C91.34 68.73 81.23 68.73 74.98 74.98S68.72 91.36 74.97 97.61l56.59 56.56c3.125 3.125 7.219 4.688 11.31 4.688s8.18-1.56 11.31-4.685C160.4 147.9 160.4 137.8 154.2 131.5L97.59 74.98zM256 112c8.844 0 16-7.156 16-16V16C272 7.156 264.8 0 256 0S240 7.156 240 16V96C240 104.8 247.2 112 256 112zM369.1 158.9c4.094 0 8.188-1.562 11.31-4.688l56.59-56.56c6.25-6.25 6.243-16.38-.007-22.63s-16.37-6.248-22.62 .0023l-56.59 56.56C351.6 137.8 351.6 147.9 357.8 154.2C360.9 157.3 365 158.9 369.1 158.9zM112 256c0-8.844-7.156-16-16-16H16C7.156 240 0 247.2 0 256s7.156 16 16 16H96C104.8 272 112 264.8 112 256zM380.4 357.8c-6.25-6.25-16.37-6.254-22.62-.0035s-6.257 16.38-.007 22.63l56.59 56.56c3.125 3.125 7.219 4.688 11.31 4.688s8.18-1.56 11.31-4.685c6.25-6.25 6.257-16.38 .007-22.63L380.4 357.8zM496 240H416c-8.844 0-16 7.156-16 16s7.156 16 16 16h80C504.8 272 512 264.8 512 256S504.8 240 496 240zM256 160C202.1 160 160 202.1 160 256c0 53.02 42.98 96 96 96s96-42.98 96-96C352 202.1 309 160 256 160zM256 320c-35.29 0-64-28.71-64-64c0-35.29 28.71-64 64-64s64 28.71 64 64C320 291.3 291.3 320 256 320zM256 400c-8.844 0-16 7.156-16 16v80c0 8.844 7.156 16 16 16s16-7.156 16-16V416C272 407.2 264.8 400 256 400z"],
    "brightness-low": [448, 512, [], "e0ca", "M82.58 114.6c-9.371 9.371-9.379 24.56 0 33.94c9.381 9.381 24.57 9.371 33.94 0c9.373-9.373 9.381-24.56 0-33.94S91.95 105.2 82.58 114.6zM224 104c13.25 0 24-10.73 24-24S237.3 56 224 56S200 66.73 200 80S210.7 104 224 104zM48 232C34.73 232 24 242.7 24 256S34.73 280 48 280S72 269.3 72 256S61.27 232 48 232zM82.58 363.5c-9.379 9.379-9.371 24.57 0 33.94c9.373 9.373 24.56 9.381 33.94 0c9.381-9.379 9.373-24.57 0-33.94C107.1 354.1 91.96 354.1 82.58 363.5zM224 408c-13.25 0-24 10.73-24 24s10.75 24 24 24s24-10.73 24-24S237.3 408 224 408zM331.5 114.6c-9.381 9.381-9.373 24.57 0 33.94c9.371 9.371 24.56 9.381 33.94 0c9.379-9.381 9.371-24.57 0-33.94C356 105.2 340.9 105.2 331.5 114.6zM224 160C170.1 160 128 202.1 128 256c0 53.02 42.98 96 96 96s96-42.98 96-96C320 202.1 277 160 224 160zM224 320c-35.29 0-64-28.71-64-64c0-35.29 28.71-64 64-64s64 28.71 64 64C288 291.3 259.3 320 224 320zM400 232c-13.27 0-24 10.75-24 24s10.73 24 24 24S424 269.3 424 256S413.3 232 400 232zM331.5 363.5c-9.373 9.371-9.381 24.56 0 33.94c9.381 9.381 24.57 9.373 33.94 0c9.371-9.371 9.379-24.56 0-33.94C356 354.1 340.9 354.1 331.5 363.5z"],
    "bring-forward": [512, 512, [], "f856", "M416 416h-160v-16C256 391.2 248.8 384 240 384S224 391.2 224 399.1V432C224 440.8 231.2 448 240 448h192c8.837 0 16-7.163 16-16v-192C448 231.2 440.8 224 432 224h-32C391.2 224 384 231.2 384 239.1S391.2 256 399.1 256H416V416zM352 288V64c0-35.35-28.65-64-64-64H64C28.65 0 0 28.65 0 64v224c0 35.35 28.65 64 64 64h224C323.3 352 352 323.3 352 288zM32 288V64c0-17.67 14.33-32 32-32h224c17.67 0 32 14.33 32 32v224c0 17.67-14.33 32-32 32H64C46.33 320 32 305.7 32 288zM448 160h-48C391.2 160 384 167.2 384 175.1S391.2 192 399.1 192H448c17.67 0 32 14.33 32 32v224c0 17.67-14.33 32-32 32H224c-17.67 0-32-14.33-32-32v-48C192 391.2 184.8 384 176 384S160 391.2 160 399.1V448c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64V224C512 188.7 483.3 160 448 160z"],
    "bring-front": [640, 512, [], "f857", "M112 224H64C46.33 224 32 209.7 32 192V64c0-17.67 14.33-32 32-32h128c13.85 0 25.64 8.795 30.1 21.11C224.5 59.84 231.4 64 238.5 64c10.22 0 17.53-9.988 14.38-19.71C244.6 18.59 220.5 0 192 0H64C28.65 0 0 28.65 0 64v128c0 35.35 28.65 64 64 64h48C120.8 256 128 248.8 128 240S120.8 224 112 224zM480 352V160c0-35.35-28.65-64-64-64H224C188.7 96 160 124.7 160 160v192c0 35.35 28.65 64 64 64h192C451.3 416 480 387.3 480 352zM192 352V160c0-17.67 14.33-32 32-32h192c17.67 0 32 14.33 32 32v192c0 17.67-14.33 32-32 32H224C206.3 384 192 369.7 192 352zM160 79.06C160 70.74 153.3 64 144.9 64H80C71.16 64 64 71.16 64 80v96C64 184.8 71.16 192 80 192h32.94C121.3 192 128 185.3 128 176.9V175.1C128 166.7 121.3 160 112.9 160H96V96h48.94C153.3 96 160 89.26 160 80.94V79.06zM576 256h-48C519.2 256 512 263.2 512 272S519.2 288 528 288H576c17.67 0 32 14.33 32 32v128c0 17.67-14.33 32-32 32h-128c-13.85 0-25.64-8.795-30.1-21.11C415.5 452.2 408.6 448 401.5 448c-10.22 0-17.53 9.988-14.38 19.71C395.4 493.4 419.5 512 448 512h128c35.35 0 64-28.65 64-64v-128C640 284.7 611.3 256 576 256zM480 432.9C480 441.3 486.7 448 495.1 448H560c8.836 0 16-7.164 16-16v-96c0-8.836-7.164-16-16-16h-32.94C518.7 320 512 326.7 512 335.1v1.887C512 345.3 518.7 352 527.1 352H544v64h-48.94C486.7 416 480 422.7 480 431.1V432.9z"],
    "broom": [640, 512, [62746], "1f9f9", "M636.5 5.99c-5.531-6.857-15.53-8.014-22.5-2.5l-232.1 185.6l-40.4-51.22c0-.0156 .0313 .0156 0 0C329.7 123 305.7 124.1 297.1 143.2L273.5 194.5C270.1 199.1 271.7 206.4 275.5 211.1l80.99 102.7c1.143 1.451 6.902 7.791 15.91 5.732l54.71-11.71c18.95-3.887 27.43-26.48 15.31-42.03l-40.65-51.54l232.3-185.8C640.9 22.95 641.1 12.89 636.5 5.99zM411.6 278.4L375.4 286.2l-68.78-87.21l15.59-33.88L411.6 278.4zM304.2 332.1C304.1 332.1 289.8 415.1 242.3 452.1c-35.5 27.6-148.6 29.29-207.2 27.1c1.375-6.982 3.188-15.7 5.406-25.55l81.21-94.08c14.36-16.65-3.072-40.96-23.37-33.71L78.22 333c12.15-26.58 22.69-38.97 30.09-44.73c47.62-37.04 132.9-32.21 133.9-32.15c21.71 .5098 22.61-30.62 2.031-31.93C240.1 223.1 145.1 218.5 88.69 263c-19.65 15.24-37.15 45.22-53.53 91.61c-4.457 12.59 7.736 24.9 20.47 20.4l15.12-5.389l-57.09 66.1c-1.688 1.969-2.875 4.328-3.469 6.857c-6.562 28.51-9.938 49.05-9.938 49.05c-1.994 11.84 8.104 18.12 14.75 18.56C21.44 510.6 44.72 512 74.97 512c60.68 0 149.5-5.42 187-34.66c57.4-44.75 73.18-136.1 73.81-139.9C339.2 316.6 307.8 311.1 304.2 332.1z"],
    "browser": [512, 512, [62334], "1f5d4", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM32 96c0-17.6 14.4-32 32-32h64v64H32V96zM480 416c0 17.6-14.4 32-32 32H64c-17.6 0-32-14.4-32-32V160h448V416zM480 128H160V64h288c17.6 0 32 14.4 32 32V128z"],
    "browsers": [576, 512, [], "e0cb", "M464 480H96c-35.35 0-64-28.65-64-64V112C32 103.2 24.84 96 16 96S0 103.2 0 112V416c0 53.02 42.98 96 96 96h368c8.836 0 16-7.164 16-16S472.8 480 464 480zM512 0H160C124.7 0 96 28.65 96 64v288c0 35.35 28.65 64 64 64h352c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM128 64c0-17.67 14.33-32 32-32h64v64H128V64zM544 352c0 17.67-14.33 32-32 32H160c-17.67 0-32-14.33-32-32V128h416V352zM544 96H256V32h256c17.67 0 32 14.33 32 32V96z"],
    "brush": [384, 512, [], "f55d", "M320 0H64C28.8 0 0 28.8 0 64v224c0 53.02 42.98 96 96 96h32v60.66c0 31.88 21.82 61.38 53.29 66.47C221.4 517.6 256 486.9 256 448v-64h32c53.02 0 96-42.98 96-96V64C384 28.8 355.2 0 320 0zM288 352h-64v96c0 17.62-14.38 32-32 32s-32-14.38-32-32v-96H96c-35.2 0-64-28.8-64-64h320C352 323.2 323.2 352 288 352zM352 256H32V64c0-17.67 14.33-32 32-32h32v112C96 152.8 103.2 160 112 160S128 152.8 128 144V32h64v80C192 120.8 199.2 128 208 128S224 120.8 224 112V32h96c17.67 0 32 14.33 32 32V256z"],
    "bug": [512, 512, [], "f188", "M192 96c0-35.3 28.7-64 64-64s64 28.7 64 64v32h32V96c0-52.94-43.06-96-96-96S160 43.06 160 96v32h32V96zM496 272h-96V183.7l73.1-59.2C480.9 118.1 482 108.9 476.5 102c-5.516-6.875-15.58-8.016-22.5-2.5L378.4 160H133.6L57.1 99.5C51.11 94 41.03 95.16 35.5 102C29.98 108.9 31.11 118.1 37.1 124.5L112 183.7V272h-96C7.156 272 0 279.2 0 288s7.156 16 16 16h96V352c0 16.95 3.475 33.07 9.486 47.89l-84.8 84.8c-6.25 6.25-6.25 16.38 0 22.62C39.81 510.4 43.91 512 48 512s8.188-1.562 11.31-4.688l78.75-78.75C161.4 459.6 198.3 480 240.1 480H272c41.76 0 78.56-20.4 101.9-51.43l78.75 78.75C455.8 510.4 459.9 512 464 512s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-84.8-84.8C396.5 385.1 400 368.1 400 352V304h96C504.8 304 512 296.8 512 288S504.8 272 496 272zM368 352c0 52.94-43.06 96-96 96V239.9C272 231.1 264.9 224 256 224S240.1 231.1 240.1 239.9L240 448c-52.94 0-96-43.06-96-96V192h224V352z"],
    "building": [384, 512, [61869, 61687], "1f3e2", "M176 296v-48C176 234.7 165.3 224 152 224h-48C90.75 224 80 234.7 80 248v48C80 309.3 90.75 320 104 320h48C165.3 320 176 309.3 176 296zM144 288h-32V256h32V288zM104 192h48C165.3 192 176 181.3 176 168v-48C176 106.7 165.3 96 152 96h-48C90.75 96 80 106.7 80 120v48C80 181.3 90.75 192 104 192zM112 128h32v32h-32V128zM192 384c-35.28 .0508-64 28.47-64 63.85v48.09c0 8.824 7.199 16.05 16 16.05S160 504.8 160 495.1v-48.09c0-17.6 14.45-31.26 32-31.3c17.55 .043 32 13.7 32 31.3v48.09c0 8.824 7.199 16.05 16 16.05s16-7.23 16-16.05v-48.09C256 412.5 227.3 384.1 192 384zM280 96h-48c-13.25 0-24 10.74-24 24v48C208 181.3 218.7 192 232 192h48c13.25 0 24-10.75 24-24v-48C304 106.7 293.3 96 280 96zM272 160h-32v-32h32V160zM320 0H64C28.65 0 0 28.65 0 64v432C0 504.8 7.164 512 16 512S32 504.8 32 496V64c0-17.67 14.33-32 32-32h256c17.67 0 32 14.33 32 32v432c0 8.836 7.164 16 16 16s16-7.164 16-16V64C384 28.65 355.3 0 320 0zM280 224h-48c-13.25 0-24 10.74-24 24v48c0 13.25 10.75 24 24 24h48c13.25 0 24-10.75 24-24v-48C304 234.7 293.3 224 280 224zM272 288h-32V256h32V288z"],
    "buildings": [512, 512, [], "e0cc", "M408 80h-48c-13.25 0-24 10.74-24 24v48c0 13.25 10.75 24 24 24h48c13.25 0 24-10.75 24-24v-48C432 90.74 421.3 80 408 80zM400 144h-32v-32h32V144zM152 336h-48c-13.25 0-24 10.74-24 24v48c0 13.25 10.75 24 24 24h48c13.25 0 24-10.75 24-24v-48C176 346.7 165.3 336 152 336zM144 400h-32v-32h32V400zM448 0H192C156.7 0 128 28.65 128 64v16C128 88.84 135.2 96 144 96S160 88.84 160 80V64c0-17.67 14.33-32 32-32h256c17.67 0 32 14.33 32 32v432c0 8.836 7.164 16 16 16s16-7.164 16-16V64C512 28.65 483.3 0 448 0zM408 208h-48c-13.25 0-24 10.74-24 24v48c0 13.25 10.75 24 24 24h48c13.25 0 24-10.75 24-24v-48C432 218.7 421.3 208 408 208zM400 272h-32v-32h32V272zM408 336h-48c-13.25 0-24 10.74-24 24v48c0 13.25 10.75 24 24 24h48c13.25 0 24-10.75 24-24v-48C432 346.7 421.3 336 408 336zM400 400h-32v-32h32V400zM152 208h-48C90.75 208 80 218.7 80 232v48c0 13.25 10.75 24 24 24h48c13.25 0 24-10.75 24-24v-48C176 218.7 165.3 208 152 208zM144 272h-32v-32h32V272zM192 128L64 128C28.65 128 0 156.7 0 192v304C0 504.8 7.164 512 16 512S32 504.8 32 496V192c0-17.67 14.33-32 32-32h128c17.67 0 32 14.33 32 32v304C224 504.8 231.2 512 240 512s16-7.164 16-16V192C256 156.7 227.3 128 192 128z"],
    "bullhorn": [512, 512, [128363, 61601], "1f4e2", "M416 0c-7.125 0-14.19 2.375-19.97 7.031L311 75.06C268.3 109.2 214.7 128 160 128H64C28.66 128 0 156.7 0 192v96c0 35.34 28.66 64 64 64h96c54.66 0 108.3 18.81 150.1 52.94L396 472.1C400.8 476.8 409.8 480 416 480c24.91 0 32-22.78 32-32V32C448 23.25 441 0 416 0zM160 320H64c-17.64 0-32-14.36-32-32V192c0-17.64 14.36-32 32-32h96V320zM415.8 447.8L330.1 379.9C290.1 347.1 242.5 328.1 192 322.1V157.9c50.53-6.006 98.99-25.86 138.1-57.82l84.94-67.93c.0234 .0234-.0176 0 0 0c.0352 0-.0117 .0996 0 0l.1244 414.8C416 447.2 415.9 447.5 415.8 447.8zM191.7 383.5C191.4 374.7 184.3 368.2 175.2 368c-8.828 .2656-15.78 7.656-15.52 16.48c1.156 38 28.36 70.55 28.61 70.83c3.594 4.203 4.688 11.11 2.641 16.86C189.3 476.9 185.8 480 182.3 480H130.8C128.3 480 125.8 478.5 124 475.9c-1.188-1.672-29.05-41.7-27.97-91.58C96.22 375.5 89.22 368.2 80.38 368c-8.406-.25-16.16 6.828-16.34 15.66c-1.281 59.28 30.23 105.6 33.88 110.8C105.9 505.6 117.9 512 130.8 512h51.47c17.34 0 32.59-11.44 38.84-29.09c5.906-16.52 2.578-35.53-8.297-48.2C212.6 434.5 192.5 409.5 191.7 383.5zM496 192C487.2 192 480 199.2 480 208v64C480 280.8 487.2 288 496 288S512 280.8 512 272v-64C512 199.2 504.8 192 496 192z"],
    "bullseye": [512, 512, [], "f140", "M256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256S397.2 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 96C167.8 96 96 167.8 96 256s71.78 160 160 160s160-71.78 160-160S344.2 96 256 96zM256 384c-70.59 0-128-57.41-128-128s57.41-128 128-128s128 57.41 128 128S326.6 384 256 384zM256 192C220.7 192 192 220.7 192 256s28.72 64 64 64s64-28.72 64-64S291.3 192 256 192zM256 288C238.3 288 224 273.7 224 256s14.34-32 32-32s32 14.34 32 32S273.7 288 256 288z"],
    "bullseye-arrow": [512, 512, [63048], "1f3af", "M509.7 221.9c-1.156-8.781-9.5-15.31-17.97-13.72c-8.75 1.156-14.91 9.219-13.72 17.97C479.3 235.9 480 245.1 480 256c0 123.5-100.5 224-224 224s-224-100.5-224-224s100.5-224 224-224c10.03 0 20.06 .6562 29.88 1.969c8.5 1.5 16.81-4.969 17.97-13.72c1.188-8.75-4.969-16.81-13.72-17.97C278.9 .75 267.4 0 256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256C512 244.6 511.3 233.1 509.7 221.9zM256 128c8.844 0 16-7.156 16-16S264.8 96 256 96C167.8 96 96 167.8 96 256s71.78 160 160 160s160-71.78 160-160c0-8.844-7.156-16-16-16S384 247.2 384 256c0 70.59-57.41 128-128 128s-128-57.41-128-128S185.4 128 256 128zM244.7 244.7c-6.25 6.25-6.25 16.38 0 22.62c6.246 6.246 16.37 6.254 22.62 0l89.95-89.95l71.6 14.32c1.047 .2031 2.094 .3119 3.141 .3119c4.203 0 8.281-1.656 11.31-4.687l64-64c4.172-4.172 5.703-10.3 4-15.95c-1.703-5.641-6.391-9.891-12.17-11.05l-69.55-13.91l-13.91-69.55c-1.156-5.781-5.408-10.47-11.05-12.17c-5.672-1.719-11.77-.1719-15.95 4l-64 64c-3.781 3.781-5.422 9.203-4.375 14.45l14.32 71.6L244.7 244.7zM421.3 113.4l42.29 8.461l-36.81 36.8l-42.28-8.451L421.3 113.4zM390.2 48.46l8.461 42.29l-36.81 36.8l-8.451-42.28L390.2 48.46z"],
    "bullseye-pointer": [512, 512, [], "f649", "M267.3 244.7c-4.375-4.375-10.94-5.828-16.69-3.75l-224 80C20.31 323.2 16.08 329.1 16 335.8c-.0781 6.688 4.016 12.72 10.25 15.12l81.03 31.15l-102.6 102.6c-6.25 6.25-6.25 16.38 0 22.62C7.813 510.4 11.91 512 16 512s8.188-1.562 11.31-4.688l102.6-102.6l31.15 81.03C163.4 491.9 169.4 496 176 496c6.703-.0781 12.81-4.312 15.06-10.62l80-224C273.1 255.6 271.7 249.1 267.3 244.7zM175.4 433.1l-24.5-63.73c-1.625-4.219-4.969-7.562-9.188-9.188l-63.73-24.5l151.6-54.14L175.4 433.1zM256 0C114.8 0 0 114.8 0 256c0 8.844 7.156 16 16 16S32 264.8 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224s-100.5 224-224 224c-8.844 0-16 7.156-16 16S247.2 512 256 512c141.2 0 256-114.8 256-256S397.2 0 256 0zM284.5 380.8c-8.625 1.938-14.03 10.53-12.06 19.12C274.1 407.4 280.7 412.4 288 412.4c1.156 0 2.344-.125 3.531-.4062C364.8 395.4 416 331.2 416 256c0-88.22-71.78-160-160-160C180.8 96 116.6 147.2 99.97 220.5C97.1 229.1 103.4 237.7 112 239.6c8.656 2.031 17.16-3.438 19.12-12.06C144.5 168.9 195.8 128 256 128c70.59 0 128 57.41 128 128C384 316.2 343.1 367.5 284.5 380.8z"],
    "burger": [512, 512, ["hamburger"], "f805", "M351.1 176c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S343.1 176 351.1 176zM255.1 144c8.875 0 16-7.125 16-16s-7.125-16-15.1-16S239.1 119.1 239.1 128S247.1 144 255.1 144zM159.1 176c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S151.1 176 159.1 176zM512 304c0-22.83-12.1-42.75-30.13-54.08c1.57-2.082 3.316-3.926 4.676-6.275c12.55-21.7 12.56-49.77 .0313-71.52C443.1 96.84 352.6 48.13 255.1 48C159.5 48.13 68.91 96.84 25.3 172.1C12.78 193.8 12.81 221.9 25.36 243.6c1.371 2.373 3.131 4.236 4.717 6.336C12.07 261.3 0 281.2 0 304c0 18.85 8.342 35.65 21.35 47.37C18.26 356.3 16 361.8 16 368V384c0 44.11 35.89 80 80 80h320c44.11 0 80-35.89 80-80v-16c0-6.227-2.258-11.71-5.348-16.63C503.7 339.6 512 322.9 512 304zM53 188.1C90.41 123.6 172 80.11 256 80c84.06 .1094 165.6 43.56 202.9 108.1c7.859 13.66 5.656 29.69-.0156 39.52C456.2 232.3 450.2 240 440.2 240H71.72c-9.984 0-15.97-7.766-18.64-12.41C47.39 217.8 45.17 201.7 53 188.1zM464 384c0 26.47-21.53 48-48 48H96c-26.47 0-48-21.53-48-48v-16h416V384zM448 336H64c-17.64 0-32-14.36-32-32s14.36-32 32-32h384c17.64 0 32 14.36 32 32S465.6 336 448 336z"],
    "burger-cheese": [512, 512, [63473, "cheeseburger"], "1f354", "M255.1 144c8.875 0 16-7.125 16-16s-7.125-16-15.1-16S239.1 119.1 239.1 128S247.1 144 255.1 144zM351.1 176c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S343.1 176 351.1 176zM512 304c0-22.83-12.1-42.75-30.13-54.08c1.57-2.082 3.316-3.926 4.676-6.275c12.55-21.7 12.56-49.77 .0313-71.52C443.1 96.84 352.6 48.13 255.1 48C159.5 48.13 68.91 96.84 25.3 172.1C12.78 193.8 12.81 221.9 25.36 243.6c1.371 2.373 3.131 4.236 4.717 6.336C12.07 261.3 0 281.2 0 304c0 18.85 8.342 35.65 21.35 47.37C18.26 356.3 16 361.8 16 368V384c0 44.11 35.89 80 80 80h320c44.11 0 80-35.89 80-80v-16c0-6.227-2.258-11.71-5.348-16.63C503.7 339.6 512 322.9 512 304zM53 188.1C90.41 123.6 172 80.11 256 80c84.06 .1094 165.6 43.56 202.9 108.1c7.859 13.66 5.656 29.69-.0156 39.52C456.2 232.3 450.2 240 440.2 240H71.72c-9.984 0-15.97-7.766-18.64-12.41C47.39 217.8 45.17 201.7 53 188.1zM377.4 272L320 329.4L262.6 272H377.4zM32 304c0-17.64 14.36-32 32-32h153.4l64 64H64C46.36 336 32 321.6 32 304zM464 384c0 26.47-21.53 48-48 48H96c-26.47 0-48-21.53-48-48v-16h416V384zM448 336h-89.38l64-64H448c17.64 0 32 14.36 32 32S465.6 336 448 336zM159.1 176c8.875 0 16-7.125 16-16s-7.125-16-16-16s-16 7.125-16 16S151.1 176 159.1 176z"],
    "burger-fries": [640, 512, [], "e0cd", "M160 272c8.842 0 15.1-7.156 15.1-16L175.1 32.05L208 47.99v208c0 8.844 7.156 16 16 16s16-7.156 16-16V47.99c0-12.22-7.062-23.47-17.72-28.56L190.4 3.504C180.5-1.574 168.5-1.09 159.3 4.676C149.9 10.41 144 20.86 144 31.99v224C144 264.9 151.2 272 160 272zM95.99 208c.9219 0 1.859-.0781 2.797-.25c8.703-1.531 14.52-9.828 12.97-18.53L89.72 64.31L119.1 47c7.672-4.391 10.33-14.17 5.938-21.84C121.5 17.52 111.8 14.85 104.1 19.22l-40 22.9C58.19 45.49 55.08 52.16 56.25 58.8l24 135.1C81.61 202.6 88.36 208 95.99 208zM266.9 63.19l33.95 11.33L272.5 188.1C270.3 196.7 275.5 205.4 284.1 207.5c1.297 .3281 2.609 .4844 3.891 .4844c7.172 0 13.69-4.844 15.5-12.12l32-127.1c2.031-8.109-2.531-16.41-10.45-19.05l-48-16c-8.484-2.795-17.44 1.734-20.23 10.11C254 51.35 258.6 60.41 266.9 63.19zM365.3 159.8c.9219 .1562 1.828 .2344 2.719 .2344c7.656 0 14.42-5.5 15.75-13.3l7.75-45.28c1.5-8.719-4.359-16.98-13.06-18.47c-8.781-1.42-16.97 4.359-18.47 13.06l-7.75 45.28C350.7 150 356.6 158.3 365.3 159.8zM32.49 191.1c1.062 0 2.156-.1094 3.25-.3281C44.39 189.9 49.96 181.4 48.18 172.8l-16.5-79.98C29.89 84.14 21.5 78.64 12.77 80.35C4.113 82.13-1.449 90.59 .332 99.25l16.5 79.98C18.39 186.8 25.05 191.1 32.49 191.1zM640 376c0-15.32-6.18-29.17-16.14-39.28C623.9 336.5 624 336.3 624 336v-39.1c0-24.04-10.22-46.97-29.56-66.26c-32.72-32.67-90.03-53.73-146-53.73h-.75c-56.06 0-113.4 21.06-146.1 53.73C282.2 249 272 271.1 272 296v39.1c0 .2539 .1328 .4648 .1445 .7148C262.2 346.8 256 360.7 256 376c0 15.32 6.182 29.17 16.15 39.29c-.0117 .25-.1445 .4609-.1445 .7148v43.1c0 28.67 23.31 51.1 51.1 51.1H572c28.69 0 52-23.33 52-51.1v-43.1c0-.2539-.1328-.4629-.1445-.7129C633.8 405.2 640 391.3 640 376zM304 296c0-15.59 6.781-30.26 20.16-43.62c26.62-26.56 76.2-44.38 123.5-44.38c.1562 0 .3906-.0156 .6406 0c47.28 0 96.87 17.82 123.5 44.38C585.2 265.7 592 280.4 592 296v24.81c-2.633-.3809-5.258-.8066-8-.8066H312c-2.742 0-5.367 .4258-8 .8066V296zM592 460c0 11.03-8.969 20-20 20h-247.1c-11.03 0-20-8.969-20-20v-28.8c2.633 .3809 5.258 .8066 8 .8066H584c2.742 0 5.367-.4258 8-.8066V460zM584 400H312c-13.23 0-24-10.77-24-23.1c0-13.23 10.77-24 24-24H584c13.23 0 24 10.77 24 24C608 389.2 597.2 400 584 400zM367.9 288c8.875 0 16.08-7.131 16.08-16.01s-7.125-16-16-16s-16.08 7.133-16.08 16.01S358.1 288 367.9 288zM447.9 272c8.875 0 16.08-7.133 16.08-16.01s-7.115-16-15.99-16s-16.09 7.133-16.09 16.01S438.1 272 447.9 272zM527.9 288c8.875 0 16.09-7.131 16.09-16.01s-7.125-16-16-16s-16.09 7.133-16.09 16.01S518.1 288 527.9 288zM240 480H92.5l-56-224h4.875L64.1 279.6c25.58 25.58 57.86 42.86 93.91 50.08c30.1 6.002 54.3 3.275 68.19 .4199C234.6 328.6 240 322.1 240 314.5c0-10.07-9.117-17.51-19.01-15.62C208.9 301.2 192 302.6 171.3 299.4C143.2 294.1 104.1 273.4 83.98 253.4L61.9 231.3C56.25 225.6 52.24 224 47.1 224L15.1 223.1c-4.922 0-9.491 2.141-12.52 6.031C.4453 233.9-.7207 239.1 .4824 243.9l64 256C66.26 507 72.67 512 80.01 512H240C248.8 512 256 504.8 256 496C256 487.2 248.8 480 240 480z"],
    "burger-glass": [640, 512, [], "e0ce", "M224 480H82.65c-6.721 0-12.35-5.359-13.07-12.23L44.96 192h227.1c8.846 0 16-7.156 16-16S280.9 160 272 160H42.1L32.06 47.53C31.26 40.02 36.64 32 45.14 32h261.7C315.3 32 320.7 39.9 319.9 47.53l-9.891 94.81C309.1 151.1 315.5 159 324.3 159.9c8.83 .8125 16.66-5.469 17.57-14.25l9.893-94.81C354.2 27.2 337.1 0 306.8 0H45.14c-34.37 0-46.88 32.01-44.95 50.61l37.54 420.2C40.17 494.3 59.49 512 82.65 512h141.4c8.846 0 16-7.156 16-16S232.8 480 224 480zM527.9 288c8.875 0 16.09-7.126 16.09-16s-7.125-15.1-16-15.1S511.9 263.1 511.9 272S518.1 288 527.9 288zM367.9 288c8.875 0 16.09-7.126 16.09-16s-7.125-15.1-16-15.1S351.9 263.1 351.9 272S358.1 288 367.9 288zM447.9 272c8.875 0 16.09-7.126 16.09-16c0-8.875-7.115-15.1-15.99-15.1S431.9 247.1 431.9 256S438.1 272 447.9 272zM640 376c0-15.32-6.18-29.18-16.14-39.29C623.9 336.5 624 336.3 624 336V296c0-24.05-10.22-46.97-29.56-66.27c-71.43-71.33-221.2-71.55-292.9 0C282.2 249 272 271.1 272 296v40c0 .2539 .1328 .4648 .1445 .7148C262.2 346.8 255.1 360.7 255.1 376s6.181 29.17 16.15 39.29C272.1 415.5 272 415.7 272 416v44C272 488.7 295.3 512 324 512h248c28.69 0 52-23.33 52-52V416c0-.2539-.1328-.4629-.1445-.7129C633.8 405.2 640 391.3 640 376zM304 296c0-15.59 6.781-30.27 20.16-43.63c56.85-56.72 186.3-61.26 247.7 0C585.2 265.7 592 280.4 592 296v24.81C589.4 320.4 586.7 320 584 320h-272c-2.742 0-5.367 .4258-8 .8066V296zM592 460c0 11.03-8.969 20-20 20h-248C312.1 480 304 471 304 460v-28.81C306.6 431.6 309.3 432 312 432h272c2.742 0 5.367-.4258 8-.8066V460zM584 400h-272C298.8 400 288 389.2 288 376C288 362.8 298.8 352 312 352h272c13.23 0 24 10.77 24 24C608 389.2 597.2 400 584 400z"],
    "burger-soda": [640, 512, [], "f858", "M447.9 272c8.875 0 16.09-7.126 16.09-16s-7.114-15.1-15.99-15.1S431.9 247.1 431.9 256S438.1 272 447.9 272zM527.9 288c8.875 0 16.09-7.126 16.09-16s-7.125-16-16-16S511.9 263.1 511.9 272S518.1 288 527.9 288zM224.2 479.9l-128.3-.7773L63.86 160h272.1c8.799 0 16.04-7.202 16.04-16c0-8.801-7.201-16-15.1-16L212.5 128l23.1-96H271.9c8.799 0 16.04-7.2 16.04-16s-7.2-16-15.1-16L236.5 0C221.7 0 208.1 10 205.5 24.25L179.5 128L15.1 127.1C7.202 127.1 0 135.2 0 143.1C0 152.8 7.199 160 15.1 160h15.1l32 322.2c1.125 16.88 15.13 29.88 31.1 29.75L224.1 512c8.834 0 15.1-7.164 15.1-16C240.1 487.2 232.1 479.1 224.2 479.9zM367.9 288c8.875 0 16.09-7.126 16.09-16s-7.125-16-16-16S351.9 263.1 351.9 272S358.1 288 367.9 288zM640 376c0-15.32-6.18-29.18-16.14-39.29C623.9 336.5 624 336.3 624 336V296c0-24.05-10.22-46.97-29.56-66.27c-71.43-71.33-221.2-71.55-292.9 0C282.2 249 272 271.1 272 296v40c0 .2539 .1328 .4648 .1445 .7148C262.2 346.8 256 360.7 256 376s6.18 29.17 16.14 39.29C272.1 415.5 272 415.7 272 416v44C272 488.7 295.3 512 324 512h248c28.69 0 52-23.33 52-52V416c0-.2539-.1328-.4629-.1445-.7129C633.8 405.2 640 391.3 640 376zM304 296c0-15.59 6.781-30.27 20.16-43.63c56.85-56.72 186.3-61.26 247.7 0C585.2 265.7 592 280.4 592 296v24.81C589.4 320.4 586.7 320 584 320h-272c-2.742 0-5.367 .4258-8 .8066V296zM592 460c0 11.03-8.969 20-20 20h-248C312.1 480 304 471 304 460v-28.81C306.6 431.6 309.3 432 312 432h272c2.742 0 5.367-.4258 8-.8066V460zM584 400h-272C298.8 400 288 389.2 288 376C288 362.8 298.8 352 312 352h272c13.23 0 24 10.77 24 24C608 389.2 597.2 400 584 400z"],
    "burrito": [512, 512, [63469], "1f32f", "M511.1 123c0-32.5-21.25-61.13-52.25-70.76c-6.25-20.38-21.05-37-40.55-45.75c-19.5-8.75-41.75-8.625-61.13 .25c-40.75-17.88-88.22 .7671-105.1 41.52L33.94 266.6c-45.25 45.25-45.25 118.8 0 164l47.5 47.5c45.25 45.25 118.7 45.25 163.9-.0011l218.3-218.1c40.75-17.75 59.39-65.26 41.52-106C509.7 144.3 511.1 133.7 511.1 123zM267.4 78.17c13.5 25.25 20.36 53.36 20.36 81.86c0 97-78.87 176-175.9 176c-25.75-.125-51.25-5.875-74.5-16.88C41.56 307.9 48.06 297.7 56.56 289.2L267.4 78.17zM222.8 455.4c-32.75 32.88-86 32.88-118.8 0l-47.5-47.5c-14.88-14.88-23.5-34.75-24.25-55.75c25.25 10.5 52.25 15.88 79.63 15.88c90.13 0 166.9-57.75 195.6-138.1c42.5-10.88 87.5-5.625 126.4 14.5L222.8 455.4zM479.1 186.1c0 15.38-7.375 28.63-18.38 37.63c-43.13-26.75-95.38-36.5-144.9-28.25c2.125-11.63 3.125-23.5 3.25-35.38c0-39.13-11.25-76.5-31.75-109.4c9-11.75 23-18.5 37.75-18.63c12.13 0 23.88 4.625 32.88 12.88c11.88-12.38 30-16.25 45.88-9.875c15.88 6.5 26.25 21.88 26.25 39c0 2.625-.25 5.25-.7501 7.75c12.25-2.375 25 .875 34.63 8.875c9.625 8 15.25 19.88 15.13 32.38c0 11.38-4.625 22.25-12.88 30.13C475.3 162.2 479.1 173.9 479.1 186.1z"],
    "bus": [576, 512, [61959], "1f68d", "M416 376c13.25 0 24-10.75 24-24s-10.75-24-24-24s-24 10.75-24 24S402.7 376 416 376zM16 128C7.164 128 0 135.2 0 144v96C0 248.8 7.164 256 16 256S32 248.8 32 240v-96C32 135.2 24.84 128 16 128zM288 0C163.3 0 64 51.25 64 96v288c0 23.51 12.99 43.93 32 55.06V496C96 504.8 103.2 512 112 512S128 504.8 128 496V448h320v48c0 8.836 7.164 16 16 16s16-7.164 16-16v-56.94c19.01-11.13 32-31.55 32-55.06V96C512 51.25 412.8 0 288 0zM480 384c0 17.64-14.36 32-32 32H128c-17.64 0-32-14.36-32-32L95.1 288H480V384zM95.1 160H272v96H95.1L95.1 160zM480 256h-176V160H480V256zM480 128H95.1V96.11C97.75 80.15 168.7 32 288 32s190.2 48.15 192 64V128zM160 376c13.25 0 24-10.75 24-24S173.3 328 160 328S136 338.7 136 352S146.7 376 160 376zM560 128C551.2 128 544 135.2 544 144v96C544 248.8 551.2 256 560 256S576 248.8 576 240v-96C576 135.2 568.8 128 560 128zM336 64h-96C231.2 64 224 71.16 224 80S231.2 96 240 96h96C344.8 96 352 88.84 352 80S344.8 64 336 64z"],
    "bus-school": [576, 512, [], "f5dd", "M32 128C23.16 128 16 135.2 16 144v96C16 248.8 23.16 256 32 256s16-7.164 16-16v-96C48 135.2 40.84 128 32 128zM544 128c-8.836 0-16 7.164-16 16v96C528 248.8 535.2 256 544 256s16-7.164 16-16v-96C560 135.2 552.8 128 544 128zM160 328c-13.25 0-24 10.75-24 24S146.7 376 160 376S184 365.3 184 352S173.3 328 160 328zM416 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S429.3 328 416 328zM336 64h-96C231.2 64 224 71.16 224 80S231.2 96 240 96h96C344.8 96 352 88.84 352 80S344.8 64 336 64zM496 96c0-44.75-92.13-96-208-96S80 51.25 80 96v203.1C69.93 314.2 64 332.4 64 352v32c0 23.63 12.95 44.04 32 55.12V496C96 504.8 103.2 512 112 512S128 504.8 128 496V448h320v48c0 8.836 7.164 16 16 16s16-7.164 16-16v-56.88C499 428 512 407.6 512 384v-32c0-19.59-5.93-37.76-16-52.95V96zM112 96c0-15.43 64.36-64 176-64s176 48.57 176 64v32h-352V96zM464 160v109.3C449.8 261.1 433.6 256 416 256h-112V160H464zM112 160h160v96H160C142.4 256 126.2 261.1 112 269.3V160zM480 384c0 17.64-14.36 32-32 32H128c-17.64 0-32-14.36-32-32v-32c0-35.29 28.71-64 64-64h256c35.29 0 64 28.71 64 64V384z"],
    "bus-simple": [448, 512, ["bus-alt"], "f55e", "M96 376c13.25 0 24-10.75 24-24S109.3 328 96 328S72 338.7 72 352S82.75 376 96 376zM352 376c13.25 0 24-10.75 24-24s-10.75-24-24-24s-24 10.75-24 24S338.7 376 352 376zM224 0C99.25 0 0 51.25 0 96v288c0 23.51 12.99 43.93 32 55.06V496C32 504.8 39.16 512 48 512C56.84 512 64 504.8 64 496V448h320v48c0 8.836 7.164 16 16 16c8.838 0 16-7.164 16-16v-56.94c19.01-11.13 32-31.55 32-55.06V96C448 51.25 348.8 0 224 0zM416 384c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32L31.1 287.1L416 288V384zM416 256H31.1l-.002-128H416V256zM32.05 96C34.05 79.96 104.9 32 224 32c119.4 0 190.2 48.15 192 64H32.05z"],
    "c": [384, 512, [99], "43", "M222.1 480c-138.3 0-222.1-116.4-222.1-223.1C.096 149.6 83.17 32 222.1 32C309.5 32 384 89.73 384 108.9c0 4.39-3.476 15.1-15.98 15.1C350.2 124.9 318.5 64 222.1 64C103.8 64 31.96 163.6 31.96 256c0 92.74 72.66 192 190.2 192c96.54 0 128.2-60.89 145.9-60.89C380.4 387.1 384 398.4 384 403.1C384 422.1 310.3 480 222.1 480z"],
    "cabinet-filing": [448, 512, [63051], "1f5c4", "M384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V272h384V448zM416 240H32V64c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V240zM304 96h-160C135.2 96 128 103.2 128 112v32C128 152.8 135.2 160 144 160S160 152.8 160 144V128h128v16C288 152.8 295.2 160 304 160S320 152.8 320 144v-32C320 103.2 312.8 96 304 96zM144 416C152.8 416 160 408.8 160 400V384h128v16c0 8.844 7.156 16 16 16s16-7.156 16-16v-32c0-8.844-7.156-16-16-16h-160C135.2 352 128 359.2 128 368v32C128 408.8 135.2 416 144 416z"],
    "cable-car": [512, 512, [], "e0cf", "M511.5 51.88c-2.281-8.5-10.99-13.64-19.61-11.28l-479.1 128c-8.531 2.266-13.56 11.06-11.28 19.61c2.483 9.323 11.84 13.37 19.53 11.28l219.9-58.71V224H95.99C60.65 224 31.99 252.7 31.99 288v160c0 35.35 28.66 64 63.1 64h319.1c35.34 0 63.1-28.65 63.1-64V288c0-35.35-28.66-64-63.1-64h-144V132.3l228.1-60.78C508.6 69.22 513.7 60.42 511.5 51.88zM64.01 288c0-17.64 14.35-32 31.1-32h63.1l-.0025 96H64.01V288zM447.1 448c0 17.64-14.35 32-31.1 32H96.01c-17.64 0-31.1-14.36-31.1-32v-64h383.1V448zM351.1 256h63.1c17.64 0 31.1 14.36 31.1 32v64h-95.99L351.1 256zM319.1 256v96H192V256H319.1zM287.1 56c13.25 0 23.1-10.74 23.1-24s-10.75-24-23.1-24S263.1 18.74 263.1 32S274.7 56 287.1 56zM192 88c13.25 0 23.1-10.74 23.1-24S205.3 40 192 40S168 50.74 168 64S178.8 88 192 88z"],
    "cactus": [512, 512, [63655], "1f335", "M272 352c-8.875 0-16 7.125-16 16s7.125 15.1 16 15.1s16-7.125 16-15.1S280.9 352 272 352zM492.1 221.3c-12.62-10.62-29.38-15.25-45.63-12.5C419 213.4 400 239.3 400 267.1V296c0 4.375-3.625 8-8 8H352V101.4c0-51.1-38.88-98.5-90.88-101.2C234.9-1.245 209.1 8.256 189.1 26.38C170.9 44.51 160 69.63 160 96v96H120c-4.375 0-8-3.625-8-8V155.1c0-27.88-19-53.75-46.5-58.38c-16.25-2.75-33 1.875-45.63 12.5S0 135.5 0 152v32c0 66.25 53.75 119.1 120 119.1L160 304V496C160 504.9 167.1 512 176 512h160c8.875 0 16-7.125 16-16v-79.1l40 .0004c66.25 0 120-53.75 120-120v-32C512 247.5 504.8 231.9 492.1 221.3zM160 272H120c-48.63 0-88-39.37-88-87.1v-32c0-13.25 10.75-24 24-24s24 10.75 24 24v32c0 22.12 17.88 40 40 40L160 224V272zM320 480H192V96c0-35.37 28.62-63.1 64-63.1s64 28.62 64 63.1V480zM480 296c0 48.63-39.38 88-88 88H352v-47.1l40 0c22.12 0 40-17.88 40-40v-32c0-13.25 10.75-23.1 24-23.1S480 250.8 480 264V296zM240 128c-8.875 0-16 7.125-16 16s7.125 15.1 16 15.1S256 152.9 256 144S248.9 128 240 128z"],
    "cake-candles": [448, 512, [61949, "birthday-cake"], "1f382", "M352 127.9c26.47 0 48-21.54 48-48.02c0-24.21-37.48-71.69-41.75-77.03C356.7 .9458 354.4 0 352 0s-4.719 .9458-6.25 2.836C341.5 8.166 304 55.65 304 79.86C304 106.3 325.5 127.9 352 127.9zM352 48.7C361.4 63.14 367.4 75.11 368 79.86c0 8.83-7.178 16.02-16 16.02s-16-7.186-16.02-15.49C336.6 75.29 342.6 63.18 352 48.7zM224 127.9c26.47 0 48-21.54 48-48.02c0-24.21-37.48-71.69-41.75-77.03C228.7 .9458 226.4 0 224 0S219.3 .9458 217.8 2.836C213.5 8.166 176 55.65 176 79.86C176 106.3 197.5 127.9 224 127.9zM224 48.7C233.4 63.14 239.4 75.11 240 79.86c0 8.83-7.178 16.02-16 16.02S208 88.69 207.1 80.38C208.6 75.29 214.6 63.18 224 48.7zM96 127.9c26.47 0 48-21.54 48-48.02c0-24.21-37.48-71.69-41.75-77.03C100.7 .9458 98.36 0 96 0S91.28 .9458 89.75 2.836C85.48 8.166 48 55.65 48 79.86C48 106.3 69.53 127.9 96 127.9zM96.01 48.7C105.4 63.14 111.4 75.11 112 79.86c0 8.83-7.178 16.02-16 16.02S80 88.69 79.98 80.38C80.55 75.29 86.59 63.18 96.01 48.7zM383.1 223.1L368 223.9V176c0-8.844-7.156-16.06-16-16.06S336 167.2 336 176v47.91h-96V176c0-8.844-7.156-16.06-16-16.06S208 167.2 208 176v47.91h-96V176c0-8.844-7.156-16.06-16-16.06S80 167.2 80 176v47.91L64 223.1c-35.35 0-64 28.65-64 63.1V464C0 490.5 21.49 512 48 512h352c26.51 0 48-21.49 48-48V287.1C448 252.6 419.4 223.1 383.1 223.1zM416 464c0 8.822-7.178 16-16 16h-352C39.18 480 32 472.8 32 464v-64.01c25.97 0 50.25-15.7 64-26.66c13.75 10.95 38.03 26.66 64 26.66s50.25-15.7 64-26.66c13.75 10.95 38.03 26.66 64 26.66s50.25-15.7 64-26.66c13.75 10.95 38.03 26.66 64 26.66V464zM416 367.1c-20.64 0-45.05-19.73-52.7-27.33c-6.25-6.219-16.34-6.219-22.59 0C333 348.3 308.6 367.1 288 367.1s-45.05-19.73-52.7-27.33c-6.25-6.219-16.34-6.219-22.59 0C205 348.3 180.6 367.1 160 367.1s-45.05-19.73-52.7-27.33c-6.25-6.219-16.34-6.219-22.59 0C77.05 348.3 52.64 367.1 32 367.1V287.9c0-17.64 14.36-32 32-32h16V272c0 8.844 7.156 15.96 16 15.96S112 280.8 112 272V255.9h96V272c0 8.844 7.156 15.96 16 15.96S240 280.8 240 272V255.9h96V272c0 8.844 7.156 15.96 16 15.96S368 280.8 368 272V255.9h15.98C401.6 255.9 416 270.3 416 287.9V367.1z"],
    "calculator": [384, 512, [61932], "1f5a9", "M320 0H64C28.66 0 0 28.66 0 64v384c0 35.34 28.66 64 64 64h256c35.34 0 64-28.66 64-64V64C384 28.66 355.3 0 320 0zM352 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160h320V448zM352 128H32V64c0-17.64 14.36-32 32-32h256c17.64 0 32 14.36 32 32V128zM80 432h128c8.844 0 16-7.156 16-16s-7.156-16-16-16h-128C71.16 400 64 407.2 64 416S71.16 432 80 432zM288 440c13.25 0 24-10.75 24-24s-10.75-24-24-24s-24 10.75-24 24S274.7 440 288 440zM288 344c13.25 0 24-10.75 24-24S301.3 296 288 296S264 306.7 264 320S274.7 344 288 344zM288 248c13.25 0 24-10.75 24-24S301.3 200 288 200S264 210.7 264 224S274.7 248 288 248zM192 344c13.25 0 24-10.75 24-24S205.3 296 192 296S168 306.7 168 320S178.7 344 192 344zM192 248c13.25 0 24-10.75 24-24S205.3 200 192 200S168 210.7 168 224S178.7 248 192 248zM96 344c13.25 0 24-10.75 24-24S109.3 296 96 296S72 306.7 72 320S82.75 344 96 344zM96 248c13.25 0 24-10.75 24-24S109.3 200 96 200S72 210.7 72 224S82.75 248 96 248z"],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", "M336 128H384v48c0 8.844 7.156 16.04 16 16.04S416 184.8 416 176V128h48C472.8 128 480 120.9 480 112S472.8 96 464 96H416V48c0-8.844-7.156-15.96-16-15.96S384 39.16 384 48V96h-48C327.2 96 320 103.2 320 112S327.2 128 336 128zM168.6 343.4c-6.254-6.254-16.37-6.254-22.63 0L112 377.4l-33.94-33.94c-6.254-6.254-16.37-6.254-22.63 0s-6.254 16.37 0 22.63L89.37 400l-33.94 33.94c-6.254 6.254-6.254 16.37 0 22.63s16.37 6.254 22.63 0L112 422.6l33.94 33.94c6.254 6.254 16.37 6.254 22.63 0s6.254-16.37 0-22.63L134.6 400l33.94-33.94C174.8 359.8 174.8 349.7 168.6 343.4zM48 128h128C184.8 128 192 120.8 192 112S184.8 96 176 96h-128C39.16 96 32 103.2 32 112S39.16 128 48 128zM496 240h-224v-224C272 7.156 264.8 0 256 0S240 7.156 240 16v224h-224C7.156 240 0 247.2 0 256s7.156 16 16 16h224v224c0 8.844 7.156 16 16 16s16-7.156 16-16v-224h224C504.8 272 512 264.8 512 256S504.8 240 496 240zM464 416h-128c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16S472.8 416 464 416zM464 352h-128c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16S472.8 352 464 352z"],
    "calendar": [448, 512, [128198, 61747], "1f4c5", "M384 64h-32V15.1C352 7.163 344.8 0 336 0S320 7.163 320 15.1V64H128V15.1C128 7.163 120.8 0 112 0S96 7.163 96 15.1V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM64 96h320c17.67 0 32 14.33 32 32v32H32V128C32 110.3 46.33 96 64 96zM384 480H64c-17.67 0-32-14.33-32-32V192h384v256C416 465.7 401.7 480 384 480z"],
    "calendar-arrow-down": [448, 512, ["calendar-download"], "e0d0", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM285.4 324L240 364.4V256c0-8.844-7.156-16-16-16S208 247.2 208 256v108.4l-45.38-40.34C159.6 321.3 155.8 320 152 320c-4.406 0-8.812 1.812-11.97 5.375c-5.875 6.594-5.25 16.72 1.344 22.59l72 63.98c6.062 5.406 15.19 5.406 21.25 0l72-63.98c6.594-5.875 7.219-16 1.344-22.59C302.1 318.8 291.1 318.2 285.4 324z"],
    "calendar-arrow-up": [448, 512, ["calendar-upload"], "e0d1", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16L320 64h-192L128 16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM162.6 347.1L208 307.6V416c0 8.844 7.156 16 16 16s16-7.156 16-16V307.6l45.38 40.34C288.4 350.7 292.2 352 296 352c4.406 0 8.812-1.812 11.97-5.375c5.875-6.594 5.25-16.72-1.344-22.59l-72-63.98c-6.062-5.406-15.19-5.406-21.25 0l-72 63.98c-6.594 5.875-7.219 16-1.344 22.59C145.9 353.2 156 353.8 162.6 347.1z"],
    "calendar-check": [448, 512, [], "f274", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM180.7 411.3C183.8 414.4 187.9 416 192 416s8.188-1.562 11.31-4.688l128-128c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L192 377.4l-52.69-52.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L180.7 411.3z"],
    "calendar-clock": [576, 512, ["calendar-time"], "e0d2", "M432 224C352.4 224 288 288.4 288 368s64.38 144 144 144S576 447.6 576 368S511.6 224 432 224zM432 480c-61.75 0-112-50.25-112-112S370.3 256 432 256S544 306.3 544 368S493.8 480 432 480zM480 352h-32V304C448 295.2 440.8 288 432 288S416 295.2 416 304v64c0 8.836 7.164 16 16 16H480c8.836 0 16-7.164 16-16S488.8 352 480 352zM300.9 485.4C297.9 482 293.6 480 289.1 480H64c-17.67 0-32-14.33-32-32V192h400C440.8 192 448 184.8 448 176V128c0-35.35-28.65-64-64-64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h225.4c13.64 0 20.92-16.14 11.77-26.26C301.1 485.6 300.1 485.5 300.9 485.4zM32 128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32v32H32V128z"],
    "calendar-day": [448, 512, [], "f783", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM96 384h96c17.67 0 32-14.33 32-32V256c0-17.67-14.33-32-32-32H96C78.33 224 64 238.3 64 256v96C64 369.7 78.33 384 96 384zM96 256h96v96H96V256z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM32 224h96v64H32V224zM160 288V224h128v64H160zM288 320v64H160v-64H288zM32 320h96v64H32V320zM64 480c-17.67 0-32-14.33-32-32v-31.1h96V480H64zM160 480v-63.1h128V480H160zM416 448c0 17.67-14.33 32-32 32h-64v-63.1h96V448zM416 384h-96v-64h96V384zM416 288h-96V224h96V288zM416 192H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V192z"],
    "calendar-exclamation": [448, 512, [], "f334", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM224 368c8.844 0 16-7.156 16-16V256c0-8.844-7.156-16-16-16S208 247.2 208 256v96C208 360.8 215.2 368 224 368zM224 440c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S200 402.7 200 416C200 429.3 210.7 440 224 440z"],
    "calendar-heart": [448, 512, [], "e0d3", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16L320 64h-192L128 16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM214.1 427.9c5.5 5.5 14.25 5.5 19.75 0l84.75-85.63c24.62-24.88 23.12-66-4.375-89c-13.88-11.62-47.63-28.5-90.13 14.5c-42.63-43-76.38-26.12-90.25-14.5c-27.5 23-28.88 64.13-4.25 89L214.1 427.9zM154.2 277.7c13.75-11.5 31.25-3.375 38.5 3.75l31.38 31.75l31.38-31.75c7.125-7.25 24.62-15.25 38.38-3.75c14.38 12 12.38 31.62 2.125 42l-72 72.63L152.2 319.7C141.8 309.4 139.8 289.7 154.2 277.7z"],
    "calendar-image": [448, 512, [], "e0d4", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM96 280c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S72 242.7 72 256C72 269.3 82.75 280 96 280zM94.38 448h259.2c11 0 21.17-5.805 26.54-15.09c0-.0313-.0313 .0313 0 0c5.656-9.883 5.078-21.84-1.578-31.15l-95.96-133.8c-11.28-15.81-38.5-15.94-49.1-.0313l-44.03 61.43l-6.969-8.941c-11.44-14.46-36.97-14.56-48.4 .0313l-63.03 80.35c-7.123 9.131-8.154 21.55-2.623 31.56C72.78 441.1 83.06 448 94.38 448zM156.4 340.3l20.09 25.66c4.348 5.545 17.6 10.65 25.59-.5332l54.44-78.75l92.68 129.2H98.19L156.4 340.3z"],
    "calendar-lines": [448, 512, ["calendar-note"], "e0d5", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16L320 64h-192L128 16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM112 304h224C344.8 304 352 296.8 352 288s-7.156-16-16-16h-224C103.2 272 96 279.2 96 288S103.2 304 112 304zM112 400h128c8.844 0 16-7.156 16-16s-7.156-16-16-16h-128C103.2 368 96 375.2 96 384S103.2 400 112 400z"],
    "calendar-minus": [448, 512, [], "f272", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM143.1 351.1h160C312.8 351.1 320 344.8 320 336s-7.16-15.1-15.1-15.1H143.1C135.2 320 128 327.2 128 336C128 344.8 135.2 351.1 143.1 351.1z"],
    "calendar-pen": [448, 512, ["calendar-edit"], "f333", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM131 447.7l60.79-12.15c3.068-.6133 5.891-2.125 8.109-4.344l122.2-122.2c7.559-7.555 12.82-17.37 13.76-28.02c1.158-13.14-3.432-25.7-12.62-34.88l-8.172-8.176c-7.559-7.559-17.37-12.83-28.01-13.78c-13.14-1.172-25.7 3.414-34.89 12.59l-123.3 123.3c-2.217 2.215-3.725 5.039-4.342 8.113l-12.16 60.79C110.1 440.1 119.9 449.9 131 447.7zM274.6 259.2c4.652-4.645 12.19-4.652 16.84 .0039l9.338 9.336c4.641 4.641 4.668 12.18-.0039 16.84l-11.22 11.22l-26.18-26.18L274.6 259.2zM154.7 379.2l86.22-86.23l26.18 26.18l-86.23 86.23l-32.72 6.539L154.7 379.2z"],
    "calendar-plus": [448, 512, [], "f271", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM143.1 351.1H208v64C208 424.8 215.2 432 224 432c8.838 0 15.1-7.16 15.1-15.1V351.1h64C312.8 351.1 320 344.8 320 336s-7.16-15.1-15.1-15.1H239.1V255.1C239.1 247.2 232.8 240 224 240S208 247.2 208 255.1v64H143.1C135.2 320 128 327.2 128 336C128 344.8 135.2 351.1 143.1 351.1z"],
    "calendar-range": [448, 512, [], "e0d6", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16L320 64h-192L128 16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V128C448 92.66 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM96 320H128c17.67 0 32-14.33 32-32L160 256c0-17.67-14.33-32-32-32H96C78.33 224 64 238.3 64 256l.0003 32C64 305.7 78.33 320 96 320zM96 256H128l.0003 32H96L96 256zM352 352h-32c-17.67 0-32 14.33-32 32l.0001 32c0 17.67 14.33 32 31.1 32h32c17.67 0 32-14.33 32-32L384 384C384 366.3 369.7 352 352 352zM352 416h-31.1L320 384h32L352 416zM208 288h160C376.8 288 384 280.8 384 272S376.8 256 368 256h-160C199.2 256 192 263.2 192 272S199.2 288 208 288zM80 416h160c8.836 0 16-7.164 16-16S248.8 384 240 384h-160C71.16 384 64 391.2 64 400S71.16 416 80 416z"],
    "calendar-star": [448, 512, [], "f736", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16L320 64h-192L128 16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM149.9 368.1l-7.938 46.22c-1.89 10.53 2.328 21.06 11.03 27.41c8.688 6.375 20.05 7.25 29.58 2.156l41.41-21.91l41.5 21.94c4.156 2.188 8.656 3.281 13.12 3.281c5.781 0 11.55-1.844 16.47-5.438c8.672-6.312 12.89-16.81 11.03-27.34l-7.953-46.31l33.66-32.81c7.609-7.469 10.31-18.44 7.047-28.59c-3.297-10.16-11.89-17.5-22.58-19.16l-46.44-6.781l-20.78-41.95c-4.734-9.609-14.31-15.59-25.02-15.62c-10.67 0-20.34 5.953-25.17 15.61L178.1 281.6L131.8 288.4C121.1 290 112.4 297.4 109.1 307.7c-3.25 10.19-.4687 21.16 7.203 28.56L149.9 368.1zM199.4 310.9L224 261.1l24.64 49.78l55.05 8.031l-39.88 38.88l9.406 54.88l-49.23-26l-49.08 25.97l9.406-54.84L144.4 318.9L199.4 310.9z"],
    "calendar-week": [448, 512, [], "f784", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16L320 64h-192L128 16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.65 0 128v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V128C448 92.65 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM96 384h256c17.67 0 32-14.33 32-32L384 256c0-17.67-14.33-32-32-32H96C78.33 224 64 238.3 64 256l.0003 96C64 369.7 78.33 384 96 384zM96 256h256L352 352H96L96 256z"],
    "calendar-xmark": [448, 512, ["calendar-times"], "f273", "M384 64h-32V16C352 7.164 344.8 0 336 0S320 7.164 320 16V64H128V16C128 7.164 120.8 0 112 0S96 7.164 96 16V64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V128C448 92.66 419.3 64 384 64zM416 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192h384V448zM416 160H32V128c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V160zM148.7 411.3c6.246 6.246 16.37 6.254 22.62 0L224 358.6l52.69 52.69c6.246 6.246 16.37 6.254 22.62 0c6.25-6.25 6.25-16.38 0-22.62L246.6 336l52.69-52.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L224 313.4L171.3 260.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L201.4 336l-52.69 52.69C142.4 394.9 142.4 405.1 148.7 411.3z"],
    "calendars": [512, 512, [], "e0d7", "M448 64l-31.1 .0001L416 16C416 7.164 408.8 0 400 0S384 7.164 384 16L384 64h-160L224 16C224 7.164 216.8 0 208 0S192 7.164 192 16l.0001 48L160 64C124.7 64 96 92.65 96 128v224c0 35.35 28.65 64 64 64h288c35.35 0 64-28.65 64-64V128C512 92.65 483.3 64 448 64zM480 352c0 17.67-14.33 32-32 32H160c-17.67 0-32-14.33-32-32V192h352V352zM480 160H128V128c0-17.67 14.33-32 32-32h288c17.67 0 32 14.33 32 32V160zM400 480H96c-35.35 0-64-28.65-64-64V176C32 167.2 24.84 160 16 160S0 167.2 0 176V416c0 53.02 42.98 96 96 96h304c8.836 0 16-7.164 16-16S408.8 480 400 480z"],
    "camcorder": [576, 512, [63656, "video-handheld"], "1f4f9", "M304 223.1h-224c-8.844 0-16 7.156-16 16c0 8.842 7.156 15.1 16 15.1h224c8.844 0 16-7.158 16-15.1C320 231.2 312.8 223.1 304 223.1zM558.8 163.7c-10.59-5.484-23.35-4.74-33.13 2.12l-102.8 72.02c-7.25 5.062-9 15.05-3.938 22.28c5.062 7.25 15.02 8.984 22.28 3.938l102.8-71.97v255.9l-102.8-71.97c-7.266-5.047-17.22-3.312-22.28 3.938c-5.062 7.234-3.312 17.22 3.938 22.28l102.8 72C531.1 478.1 537.5 480 543.1 480c5.047 0 10.12-1.203 14.78-3.625c10.64-5.531 17.23-16.41 17.23-28.39V192C576 180.1 569.4 169.2 558.8 163.7zM320 159.1H96V111.1C96 85.53 117.5 63.1 144 63.1h160c8.844 0 16-7.156 16-16C320 39.16 312.8 32 304 32h-160C99.88 32 64 67.89 64 111.1l.0003 48c-35.35 0-64 28.66-64 64l-.0001 191.1c0 35.34 28.65 63.1 64 63.1l256-.0016c35.35 0 64-28.66 64-63.1V223.1C384 188.7 355.3 159.1 320 159.1zM352 415.1c0 17.64-14.36 31.1-32 31.1H64c-17.64 0-32-14.35-32-31.1V223.1c0-17.64 14.36-31.1 32-31.1h256c17.64 0 32 14.36 32 31.1V415.1z"],
    "camera": [512, 512, [62258, "camera-alt"], "f030", "M448 96h-72l-8.457-22.51C358.2 48.55 334.3 32 307.6 32H204.4C177.7 32 153.9 48.51 144.5 73.45L136 96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM480 416c0 17.6-14.4 32-32 32H64c-17.6 0-32-14.4-32-32V160c0-17.6 14.4-32 32-32h94.25l16.11-43.18C179 72.3 190.1 64 204.3 64h103.3c13.36 0 25.31 8.301 29.98 20.82L353.8 128H448c17.6 0 32 14.4 32 32V416zM256 168C189.8 168 136 221.8 136 288s53.75 120 120 120s120-53.75 120-120S322.3 168 256 168zM256 376c-48.5 0-88-39.5-88-88S207.5 200 256 200S344 239.5 344 288S304.5 376 256 376z"],
    "camera-cctv": [576, 512, ["cctv"], "f8ac", "M525.2 193.7c-1.238-16.59-12.17-31.34-28.48-37.77L150.3 3.617C143.9 1.076 138.4 0 132.8 0C113.7 0 99.74 12.27 93.61 22.78L6.082 176.1c-6.574 11.43-7.76 25.88-3.121 38.56c4.576 12.51 14.17 21.96 27.01 26.62l158.7 65.68l-39.77 109.1H32v-47.98c0-8.797-7.2-16.02-16-16.02C7.201 352 0 359.2 0 368v127.1C0 504.8 7.201 512 15.1 512C24.8 512 32 504.8 32 496v-47.98h128c6.625 0 12.62-4.123 15-10.37l43.23-118.4l71.9 29.76c4.391 1.822 10.23 3.072 16.21 3.072c8.779 0 17.31-2.543 24.67-7.354l173.2-108.1C518.1 227 526.9 210.7 525.2 193.7zM487.3 209.5L313.5 317.9c-2.426 1.586-6.576 3.016-11.12 1.5L40.88 211.2c-10-3.625-9.875-14.25-7-19.24l87.38-153.1c1.52-2.604 7.732-9.354 16.12-5.998L485 185.7C495.5 189.9 496.2 203.7 487.3 209.5zM566.6 274.9l-47.91-21.69c-8.1-3.688-17.54-.0625-21.2 7.969c-3.643 8.031-.0781 17.53 7.975 21.16l33.38 15.12l-28.74 64.09l-87.66-38.56c-8.131-3.5-17.54 .125-21.09 8.219c-3.564 8.094 .1113 17.53 8.209 21.09l102.1 44.92c2.094 .9062 4.403 1.364 6.546 1.364c6.129 0 11.96-3.531 14.62-9.469l41.79-93.14C578.2 287.1 574.6 278.6 566.6 274.9z"],
    "camera-movie": [576, 512, [127910, 63657], "1f3a5", "M320 255.1L127.1 255.1c-.0332 0 .0332 0 0 0L16 256C7.164 256 0 263.2 0 272C0 280.8 7.164 288 16 288h56.87C67.38 297.4 64 308.3 64 319.1l.0002 128c0 35.34 28.65 63.1 64 63.1L320 511.1c35.35 0 64-28.65 64-63.1V319.1C384 284.6 355.3 255.1 320 255.1zM352 447.1c0 17.64-14.36 31.1-32 31.1H128c-17.64 0-32-14.35-32-31.1V319.1C96 302.4 110.3 288 127.9 288l48.09-.0059c.0215 0-.0215 0 0 0L320 287.1c17.64 0 32 14.36 32 31.1V447.1zM336 0c-41 0-76.48 22.27-96 55.14C220.5 22.27 185 0 144 0C82.14 0 32 50.14 32 112S82.14 224 144 224h192C397.9 224 448 173.9 448 112S397.9 0 336 0zM336 192h-192C99.89 192 64 156.1 64 112C64 67.89 99.89 32 144 32c28.21 0 53.81 14.76 68.48 39.48C218.3 81.19 228.7 87.14 240 87.14s21.75-5.953 27.52-15.66C282.2 46.76 307.8 32 336 32C380.1 32 416 67.89 416 112C416 156.1 380.1 192 336 192zM553.3 266.1c-14.28-8.844-31.73-9.656-46.72-2.125l-81.69 40.84c-7.906 3.969-11.11 13.56-7.156 21.47c3.953 7.875 13.59 11.12 21.47 7.156l81.67-40.84c7.203-3.625 13.28-.6875 15.59 .7187C538.7 295.6 544 299.8 544 307.8v152.4c0 8.031-5.297 12.19-7.578 13.59c-2.312 1.406-8.406 4.312-15.58 .7187l-81.69-40.84c-7.875-3.969-17.52-.7187-21.47 7.156c-3.953 7.906-.75 17.5 7.156 21.47l81.7 40.84c6.828 3.406 14.16 5.094 21.47 5.094c8.75 0 17.47-2.406 25.23-7.219C567.5 492.2 576 476.1 576 460.2V307.8C576 291 567.5 275.8 553.3 266.1zM144 88c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C168 98.74 157.3 88 144 88zM336 88c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C360 98.74 349.3 88 336 88z"],
    "camera-polaroid": [576, 512, [], "f8aa", "M288 112c-44.11 0-80 35.88-80 80s35.89 80 80 80s80-35.88 80-80S332.1 112 288 112zM288 240C261.5 240 240 218.5 240 192S261.5 144 288 144s48 21.53 48 48S314.5 240 288 240zM561.1 318.5L512 256L512 96c0-35.35-28.65-64-64-64H128C92.65 32 64 60.65 64 96l.0001 160L14.03 318.5C4.947 329.8 0 343.9 0 358.5V416c0 35.2 28.8 64 64 64h448c35.2 0 64-28.8 64-64v-57.55C576 343.9 571.1 329.8 561.1 318.5zM96 267.2V96c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32v171.2L522.2 320H53.78L96 267.2zM544 416c0 17.6-14.4 32-32 32H64c-17.6 0-32-14.4-32-32v-63.86l511.9-.0713c.0566 .0547-.0547-.0566 0 0L544 416zM464 384h-352C103.2 384 96 391.2 96 400C96 408.8 103.2 416 112 416h352c8.838 0 16-7.164 16-16C480 391.2 472.8 384 464 384zM416 104c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C440 114.7 429.3 104 416 104z"],
    "camera-retro": [512, 512, [61571], "1f4f7", "M80 64h64C152.8 64 160 56.84 160 48C160 39.16 152.8 32 144 32h-64C71.16 32 64 39.16 64 48C64 56.84 71.16 64 80 64zM448 32h-144.9c-9.936 0-19.73 2.312-28.62 6.756L192 80H64c-35.35 0-64 28.65-64 64V416c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM480 416c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V288h96c0 70.59 57.42 128 128 128s128-57.41 128-128h96V416zM160 288c0-52.94 43.06-96 96-96s96 43.06 96 96s-43.06 96-96 96S160 340.9 160 288zM480 256h-100.5C365.1 200.9 315.5 160 256 160S146.9 200.9 132.5 256H32V144c0-17.67 14.33-32 32-32h120.4c9.938 0 19.74-2.314 28.62-6.758l75.73-37.86C293.2 65.16 298.1 64 303.1 64H448c17.67 0 32 14.33 32 32V256z"],
    "camera-rotate": [512, 512, [], "e0d8", "M352 176c-8.844 0-16 7.156-16 16v25.72C315.7 194.6 287.1 181 256 181c-33.16 0-63.91 15-84.34 41.14C166.2 229.1 167.5 239.2 174.4 244.6C181.4 250 191.4 248.8 196.9 241.9C224.1 205.9 283.9 205.4 313.3 240H288c-8.844 0-16 7.156-16 16s7.156 16 16 16h64c8.844 0 16-7.156 16-16V192C368 183.2 360.8 176 352 176zM315.1 334.1C287 370.1 228.1 370.6 198.8 336H224c8.844 0 16-7.156 16-16S232.8 304 224 304H160c-8.844 0-16 7.156-16 16v64c0 8.844 7.156 16 16 16s16-7.156 16-16v-25.72C196.3 381.4 224.9 395 256 395c33.16 0 63.91-15 84.34-41.14c5.438-6.969 4.203-17.03-2.75-22.47C330.6 325.9 320.6 327.2 315.1 334.1zM448 96h-72l-8.457-22.51C358.2 48.55 334.3 32 307.6 32H204.4C177.7 32 153.9 48.51 144.5 73.45L136 96H64C28.65 96 0 124.7 0 160v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM480 416c0 17.6-14.4 32-32 32H64c-17.6 0-32-14.4-32-32V160c0-17.6 14.4-32 32-32h94.25l16.11-43.18C179 72.3 190.1 64 204.3 64h103.3c13.36 0 25.31 8.301 29.98 20.82L353.8 128H448c17.6 0 32 14.4 32 32V416z"],
    "camera-security": [448, 512, ["camera-home"], "f8fe", "M384 0h-320c-35.35 0-64 28.65-64 64v288c0 35.35 28.65 64 64 64h43.7l-36.26 43.5c-8.031 9.656-9.719 22.72-4.391 34.09C72.38 504.9 83.48 512 96.03 512h255.9c12.55 0 23.66-7.062 28.98-18.41c5.328-11.38 3.641-24.44-4.391-34.09L340.3 416h43.7c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM351.1 480H96.03l53.35-64h149.2L351.1 480zM416 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V352zM224 80c-70.69 0-127.1 57.31-127.1 128c0 70.69 57.31 128 127.1 128c70.69 0 128-57.31 128-128C352 137.3 294.7 80 224 80zM224 304c-52.93 0-96-43.07-96-96c0-52.94 43.07-96 96-96c52.94 0 96 43.06 96 96C320 260.9 276.9 304 224 304z"],
    "camera-slash": [640, 512, [], "e0d9", "M320 168c-2.479 0-4.795 .582-7.236 .7305l125.2 98.82C428.2 211.1 379.2 168 320 168zM128 448c-17.6 0-32-14.4-32-32V160.7L67.95 138.6C65.54 145.3 64 152.4 64 160v256c0 35.35 28.65 64 64 64h372.4l-40.53-32H128zM238.4 84.82C243 72.3 254.1 64 268.3 64h103.3c13.36 0 25.31 8.301 29.98 20.82L417.8 128H512c17.6 0 32 14.4 32 32v191.3l32 25.26V160c0-35.35-28.65-64-64-64h-72l-8.457-22.51C422.2 48.55 398.3 32 371.6 32H268.4C241.7 32 217.9 48.51 208.5 73.45L204.7 83.44l26.38 20.82L238.4 84.82zM207.2 248.5C202.8 260.9 200 274.1 200 288c0 66.25 53.75 120 120 120c23.93 0 46.1-7.197 64.83-19.28l-27.23-21.5C346.2 372.7 333.5 376 320 376c-48.5 0-88-39.5-88-88c0-6.301 .7285-12.43 1.994-18.36L207.2 248.5zM633.9 483.4l-608-480c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "camera-viewfinder": [512, 512, [], "e0da", "M496 352c-8.844 0-16 7.156-16 16v96c0 8.812-7.172 16-16 16h-96c-8.844 0-16 7.156-16 16s7.156 16 16 16h96c26.47 0 48-21.53 48-48v-96C512 359.2 504.8 352 496 352zM144 480h-96C39.17 480 32 472.8 32 464v-96C32 359.2 24.84 352 16 352S0 359.2 0 368v96C0 490.5 21.53 512 48 512h96C152.8 512 160 504.8 160 496S152.8 480 144 480zM464 0h-96C359.2 0 352 7.156 352 16S359.2 32 368 32h96C472.8 32 480 39.19 480 48v96C480 152.8 487.2 160 496 160S512 152.8 512 144v-96C512 21.53 490.5 0 464 0zM16 160C24.84 160 32 152.8 32 144v-96C32 39.19 39.17 32 48 32h96C152.8 32 160 24.84 160 16S152.8 0 144 0h-96C21.53 0 0 21.53 0 48v96C0 152.8 7.156 160 16 160zM256 224C238.3 224 224 238.3 224 256s14.33 32 32 32s32-14.33 32-32S273.7 224 256 224zM384 304v-96C384 181.5 362.5 160 336 160h-20l-6.188-16.44C306.3 134.2 297.4 128 287.4 128H224.6c-10 0-19 6.188-22.5 15.56L196 160H176C149.5 160 128 181.5 128 208v96C128 330.5 149.5 352 176 352h160C362.5 352 384 330.5 384 304zM352 304c0 8.822-7.178 16-16 16h-160C167.2 320 160 312.8 160 304v-96C160 199.2 167.2 192 176 192h42.22l11.93-32h51.66l12.04 32H336C344.8 192 352 199.2 352 208V304z"],
    "camera-web": [448, 512, ["webcam"], "f832", "M390.7 437.8C387.6 434.1 383.1 432 378.4 432c-13.57 0-20.99 15.83-12.3 26.26L384.2 480h-319.9l18.12-21.74C91.13 447.8 83.72 432 70.14 432c-4.75 0-9.256 2.109-12.3 5.758l-17.14 20.56c-7.895 9.471-10.71 22.65-5.932 34.02c5.082 12.07 16.33 19.66 29.33 19.66L382.7 512c12.34 0 24.27-6.303 29.92-17.27c5.992-11.63 4.469-25.25-3.832-35.23L390.7 437.8zM224 448c123.7 0 224-100.3 224-223.1c0-123.7-100.3-224-224-224c-123.7 0-224 100.3-224 224C0 347.7 100.3 448 224 448zM224 32c105.9 0 192 86.13 192 192s-86.13 192-192 192s-192-86.13-192-192S118.1 32 224 32zM224 368c79.41 0 144-64.59 144-144S303.4 80 224 80S80 144.6 80 224S144.6 368 224 368zM224 112c61.75 0 112 50.25 112 112s-50.25 112-112 112S112 285.8 112 224S162.3 112 224 112z"],
    "camera-web-slash": [640, 512, ["webcam-slash"], "f833", "M452.9 279.3C460 262.3 464 243.6 464 224c0-79.41-64.59-144-144-144c-31.59 0-60.59 10.53-84.35 27.84L262 128.7C278.1 118.3 298.7 112 320 112c61.75 0 112 50.25 112 112c0 12-2.395 23.35-5.906 34.2L452.9 279.3zM103.7 166.8C98.83 185.1 95.1 204.2 95.1 223.1c0 123.7 100.3 224 224 224c38.39 0 74.5-9.686 106.1-26.7l-27.96-22.08C374.2 409.9 347.8 416 320 416c-105.9 0-192-86.13-192-192c0-12.09 1.256-23.88 3.404-35.35L103.7 166.8zM320 32c105.9 0 192 86.13 192 192c0 30.87-7.5 59.97-20.5 85.84l25.76 20.33c17.04-31.6 26.74-67.75 26.74-106.2c0-123.7-100.3-223.1-223.1-223.1c-57.21 0-109.2 21.63-148.8 56.93l25.5 20.13C230.1 48.99 273.1 32 320 32zM320 368c11.47 0 22.5-1.693 33.2-4.24l-35.45-27.98c-50.89-1.029-93.21-36.15-105.7-83.43L176 223.9c0 .0449 0-.0449 0 0C176 303.3 240.6 368 320 368zM495.1 480H160.3l18.12-21.74c8.691-10.43 1.277-26.26-12.3-26.26c-4.75 0-9.256 2.109-12.3 5.758l-17.14 20.56c-7.201 8.639-10.41 20.42-6.998 31.13c4.379 13.74 16.39 22.54 30.4 22.54l335.9 .0145C504.9 512 512 504.8 512 496C512 487.2 504.8 480 495.1 480zM633.9 483.4L25.92 3.424c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480c2.938 2.312 6.438 3.438 9.906 3.438c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "campfire": [512, 512, [], "f6ba", "M256 320c79.5 0 144-64.5 144-144c0-33.25-33.38-102-80-144c-13.38 12-25.5 24.75-36.13 37.5C266.4 46 244.6 22.25 220 0c-63.13 57-108 131.3-108 176C112 255.5 176.5 320 256 320zM220.2 44.38c14.12 14.38 27 29.38 38.13 44.25L282.4 121l26-31c3.5-4.25 7.25-8.375 11-12.38C350 114.5 368 159.3 368 176c0 61.75-50.25 112-112 112s-112-50.25-112-112C144 148.3 172 94.38 220.2 44.38zM501.5 480.1L302.5 408l199-72.97c8.281-3.062 12.55-12.25 9.5-20.53c-3.047-8.312-12.17-12.53-20.53-9.531L256 390.9L21.52 304.1c-8.297-3-17.48 1.219-20.53 9.531c-3.047 8.281 1.219 17.47 9.5 20.53L209.5 408l-199 72.97c-8.281 3.062-12.55 12.25-9.5 20.53C3.359 508 9.484 512 16 512c1.828 0 3.688-.3125 5.516-.9687L256 425.1l234.5 85.98C492.3 511.7 494.2 512 496 512c6.516 0 12.64-4 15.02-10.5C514.1 493.2 509.8 484 501.5 480.1z"],
    "campground": [576, 512, [63163], "26fa", "M548 396.4l-238.7-271.3l86.7-98.53C401.8 19.94 401.2 9.812 394.6 4c-6.594-5.844-16.7-5.219-22.58 1.438L288 100.9L204 5.438C198.1-1.219 188-1.844 181.4 4C174.8 9.812 174.2 19.94 179.1 26.56l86.7 98.53l-238.7 271.3C20.25 405.2 16 416.4 16 428.1V464C16 490.5 37.53 512 64 512h448c26.47 0 48-21.53 48-48v-35.94C560 416.4 555.8 405.2 548 396.4zM175.1 480L288 330.7L400 480H175.1zM528 464c0 8.812-7.172 16-16 16h-72.01l-139.2-185.6c-6.031-8.062-19.56-8.062-25.59 0L136 480H64c-8.828 0-16-7.188-16-16v-35.94c0-3.875 1.422-7.625 4-10.56L288 149.3l236 268.2c2.578 2.938 4 6.688 4 10.56V464z"],
    "candle-holder": [448, 512, [63164], "1f56f", "M160 191.1c45.88 0 77.1-32.62 77.1-79.25C237.1 82.75 205.4 37.88 160 0C114.4 38 81.1 82.88 81.1 112.8C81.1 159.4 114.1 191.1 160 191.1zM160 43.13c31.5 30.88 45.1 58.25 45.1 69.63C205.1 141.9 188.4 160 160 160S113.1 141.9 113.1 112.8C113.1 101.4 128.5 74 160 43.13zM371 385.3c-23.94 4.682-43.7 24.2-49.28 47.94C317.6 450.8 321.1 466.6 328.9 480H256V272C256 245.6 234.4 224 208 224h-96C85.6 224 64 245.6 64 272V480H16C7.199 480 0 487.2 0 496C0 504.8 7.182 512 15.98 512h364.5c32.18 0 61.96-22.19 66.76-54.01C453.9 413.8 415.5 376.6 371 385.3zM224 480H96V272C96 263.2 103.2 256 112 256H128v48C128 312.9 135.1 320 144 320S160 312.9 160 304V256h48C216.8 256 224 263.2 224 272V480zM384 480c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S401.6 480 384 480z"],
    "candy-cane": [512, 512, [], "f786", "M497.5 91.1C469.6 33.12 411.8 0 352.4 0c-27.88 0-56.14 7.25-81.77 22.62L243.1 38.1C227.9 48.12 223 67.75 232.1 82.87l32.76 54.87c9.375 15.75 29.38 19.94 43.88 11.06l27.51-16.37c36-21.5 69.6 33.02 32.85 54.9L15.6 397.6c-15.25 9.125-20.13 28.62-11 43.87l32.76 54.87C43.35 506.4 53.97 512 64.85 512c5.625 0 11.27-1.507 16.39-4.507l347.4-206.5C500.2 258.1 533.2 167.5 497.5 91.1zM292.2 121.4l-32.75-54.88C291.7 47.25 312.6 32.12 351.1 32v64C328.3 96.25 314.7 108.1 292.2 121.4zM383.2 104h.75V36.12c36.75 9.125 67.75 34 84.63 69.5c3.375 7.125 6 14.62 7.875 22.25h-68.5c-.25-.25-.25-.5643-.375-.8143C401.7 117.2 393.2 109.4 383.2 104zM256.7 291.4l82.38-48.1l64.25 36.25l-82.25 49L256.7 291.4zM289.3 346.5l-87.5 52l-64.25-36.25l87.5-52L289.3 346.5zM64.72 480l-32.88-54.88l73.88-43.88l64.38 36.13L64.72 480zM432.7 258.5l-62-34.88l14.63-8.75C405.4 203 416.2 181.8 416.2 160h63C478.4 196.5 462.1 232.8 432.7 258.5z"],
    "candy-corn": [640, 512, [], "f6bd", "M479.1 0c-165.8 1.625-164.5 39.5-157.9 72.5c30.38 151.5 94.01 343.5 157.8 343.5c63.75-.125 127.6-191.9 158-343.5C644.5 39.5 645.8 1.625 479.1 0zM479.9 384c-12.75 0-39.25-37.13-67.38-108.8c43.75-3.75 91.13-3.75 135 0C519.3 346.9 492.8 384 479.9 384zM559 244.3c-50.88-5-107.3-5-158 0c-9.502-27.12-19-58-28-92.63c66.63-9.75 147.4-9.875 214 0C577.9 186.3 568.5 217.1 559 244.3zM606.6 66.13c-3.75 19-7.875 36.88-11.88 54.25c-71.38-10.88-158.1-10.88-229.5 0c-4-17.38-8.125-35.25-11.88-54.25c-2-9.877-1.5-12.38-1.25-13C352.2 52.88 364.1 33.13 479.1 32c115 1.125 127.8 20.88 127.9 21.12C608.1 53.75 608.6 56.25 606.6 66.13zM84.97 205.8c-116.1 118.5-88.35 144.4-60.47 162.1c128.6 85.63 309.5 176.4 354.5 131.3c44.88-45.25-45.39-225.9-131.1-354.6C229.2 117.5 203.4 89.77 84.97 205.8zM356.4 477.4c-9.002 9-54 1.625-124.5-29.12c28.25-33.63 61.88-67.13 95.38-95.5C357.1 423.4 365.4 468.4 356.4 477.4zM313.5 322.6c-39.5 32.5-79.38 72.25-111.8 111.8c-25.88-12.5-54.38-27.62-85.25-45.75c40.13-54 97.25-111.1 151.3-151.3C285.9 268.3 300.1 296.8 313.5 322.6zM88.98 372c-15.25-9.375-30.75-19.13-46.88-29.88c-8.375-5.625-9.875-7.75-10.12-8.375c0-.125-5-23.12 75.63-105.3c82.13-80.63 105.1-75.63 105.3-75.63C213.5 153.1 215.6 154.6 221.2 163C231.1 179.1 241.7 194.6 251.1 209.9C193.1 252.6 131.7 314 88.98 372z"],
    "cannabis": [576, 512, [], "f55f", "M288 224C279.2 224 272 231.2 272 240v256c0 8.799 7.199 16 16 16s16-7.201 16-16v-256C304 231.2 296.8 224 288 224zM526.4 323.4c-1.125-.5-19.5-9.75-47.88-17.75c48.25-64.25 63.88-129.8 64.63-133.1c2.5-10.62-.625-21.75-8.25-29.5C528.9 136.8 520.6 133.4 512 133.4c-2.125 0-4.375 .125-6.625 .625c-3.25 .75-66.25 14.38-130.6 56c-8.625-97.75-57.88-172.4-60.13-175.8C308.6 5.375 298.6 0 288 0S267.4 5.375 261.4 14.25c-2.25 3.375-51.5 78-60.13 175.8c-64.38-41.63-127.3-55.25-130.6-56C68.38 133.5 66.25 133.4 64 133.4c-8.5 0-16.75 3.375-22.88 9.625C33.5 150.8 30.22 161.8 32.72 172.5C33.47 175.8 49.25 241.4 97.5 305.6c-28.25 8-46.75 17.25-47.88 17.75C38.88 328.9 32 339.9 32 352c0 12 6.75 23.12 17.5 28.5c2.375 1.25 54.5 27.25 121 30c-2.875 6.75-4.25 11-4.375 11.5c-3.887 11.66-.8008 24.57 8.402 33.39c5.787 5.545 13.74 8.561 21.76 8.607c3.064 .0195 6.268-.3496 9.34-1.373C206.7 462.3 220.6 458 240 448.1v-35.84C215.3 426.2 196.5 432 196.5 432c3.693-11.25 8.465-21.41 13-29.89c5.832-10.9-2.039-24.05-14.39-23.68c-4.252 .127-8.74 .1934-13.48 .1934C116.6 378.6 64 352 64 352s26.18-13.17 64.32-21.01c11.97-2.461 17.17-16.95 9.062-26.09C90.2 251.7 67.51 180.5 64 165.4c62.67 13.18 113.3 45.53 142.4 67.82C216.9 241.3 232 233.7 232 220.4C232 219.8 232 219.2 232 218.6C232 115.6 288 32 288 32s56 83.63 56 186.6c0 .5215 0 1.039-.002 1.557c-.0371 13.32 15.09 20.94 25.65 12.82C398.5 210.8 448.9 178.6 512 165.4c-3.48 15.02-26.44 86.49-73.45 139.6c-8.084 9.125-2.891 23.58 9.053 26.04C485.8 338.8 512 352 512 352s-52.63 26.62-117.6 26.62c-4.785 0-9.312-.0684-13.6-.1973c-12.33-.373-20.24 12.76-14.4 23.62C371 410.7 375.9 420.9 379.5 432c0 0-18.85-5.807-43.5-18.86V449c19.42 9.031 33.29 13.29 34.38 13.62C373.4 463.6 376.5 464 379.5 464c8.5 0 16.88-3.375 23-9.75c8.25-8.5 11.12-21 7.375-32.25c-.125-.5-1.5-4.75-4.375-11.5c66.5-2.75 118.6-28.75 121-30C537.3 375.1 544 364 544 352C544 339.9 537.3 328.9 526.4 323.4z"],
    "capsules": [576, 512, [], "f46b", "M554.6 302.2l-131.7-181.2c-21.01-28.91-54.9-46.17-90.67-46.17c-23.76 0-46.51 7.398-65.77 21.39C244.1 112.4 230 135.6 224 160.6L223.9 143.9C223.9 82.19 173.7 32 111.1 32S-.0021 82.2-.0021 143.1L-.0028 368c0 61.76 50.24 112 112 112s112-50.24 112-112L224 214.4C227.4 227.8 233.1 240.8 241.7 252.6l131.7 181.2C394.4 462.7 428.3 480 464.1 480c23.76 0 46.5-7.398 65.77-21.4C579.8 422.3 590.9 352.1 554.6 302.2zM191.1 368c0 44.18-35.81 80-79.1 80c-44.18 0-79.1-35.82-79.1-80L32 272h160L191.1 368zM192 240H32l-.0003-96c0-44.18 35.82-80 79.1-80c44.18 0 79.1 35.82 79.1 80L192 240zM285.3 122.1c14.2-10.32 30.65-15.28 46.96-15.29c24.74 0 49.13 11.44 64.79 32.98l71.7 98.68l-15.27-20.1l-129.4 94.03L267.6 233.8C241.6 198.1 249.6 148 285.3 122.1zM511 432.7C496.8 443 480.4 448 464.1 448c-24.74 0-49.13-11.44-64.79-32.98L339.1 332.1l3.787 5.209l129.5-94.03l56.42 77.66C554.7 356.7 546.8 406.7 511 432.7z"],
    "car": [512, 512, [61881, "automobile"], "1f698", "M461.1 203.8L428.6 90C418.8 55.84 387.2 32 351.7 32H160.3C124.8 32 93.15 55.84 83.4 90L50.9 203.8C20.77 219.1 .0408 251.4 .0408 288v176c0 8.836 7.163 16 15.1 16s15.1-7.164 15.1-16V416h447.9v48c0 8.836 7.163 16 15.1 16c8.835 0 15.1-7.164 15.1-16V288C511.1 251.4 491.2 219.1 461.1 203.8zM114.1 98.81C120 78.31 138.1 64 160.3 64h191.4c21.31 0 40.27 14.31 46.15 34.81l26.88 94.07C421.8 192.6 418.1 192 415.1 192H96.03C93.03 192 90.2 192.6 87.27 192.9L114.1 98.81zM479.1 352c0 17.64-14.35 32-31.99 32H64.03c-17.64 0-31.99-14.36-31.99-32V288c0-35.29 28.69-64 63.98-64h319.1c35.29 0 63.98 28.71 63.98 64V352zM104 272c-13.25 0-23.1 10.75-23.1 24S90.76 320 104 320c13.25 0 23.1-10.75 23.1-24S117.3 272 104 272zM407.1 272c-13.25 0-23.1 10.75-23.1 24S394.7 320 407.1 320s23.1-10.75 23.1-24S421.2 272 407.1 272z"],
    "car-battery": [512, 512, ["battery-car"], "f5df", "M448 128H64C28.65 128 0 156.7 0 191.1v192C0 419.3 28.65 448 63.1 448H448c35.35 0 64-28.65 64-63.1V191.1C512 156.7 483.3 128 448 128zM480 384c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V192c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V384zM336 96h96C440.8 96 448 88.84 448 80C448 71.16 440.8 64 432 64h-96C327.2 64 320 71.16 320 80C320 88.84 327.2 96 336 96zM80 96h96C184.8 96 192 88.84 192 80C192 71.16 184.8 64 176 64h-96C71.16 64 64 71.16 64 80C64 88.84 71.16 96 80 96zM416 240h-32v-32C384 199.2 376.8 192 368 192S352 199.2 352 208v32h-32c-8.844 0-16 7.156-16 16s7.156 16 16 16h32v32c0 8.844 7.156 16 16 16S384 312.8 384 304v-32h32c8.844 0 16-7.156 16-16S424.8 240 416 240zM192 240H96C87.16 240 80 247.2 80 256S87.16 272 96 272h96c8.844 0 16-7.156 16-16S200.8 240 192 240z"],
    "car-bolt": [512, 512, [], "e341", "M320 192L230.6 192l68.69-68.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-96 96C176.1 201.3 174.7 208.1 177.2 214.1C179.7 220.1 185.5 224 192 224L281.4 224L212.7 292.7c-6.25 6.25-6.25 16.38 0 22.62C215.8 318.4 219.9 320 224 320s8.188-1.562 11.31-4.688l96-96c4.578-4.578 5.953-11.45 3.469-17.44C332.3 195.9 326.5 192 320 192zM407.1 272c-13.25 0-23.1 10.75-23.1 24S394.7 320 407.1 320s23.1-10.75 23.1-24S421.2 272 407.1 272zM104 272c-13.25 0-23.1 10.75-23.1 24S90.76 320 104 320c13.25 0 23.1-10.75 23.1-24S117.3 272 104 272zM461.1 203.8L428.6 90C418.8 55.84 387.2 32 351.7 32H160.3C124.8 32 93.15 55.84 83.4 90L50.9 203.8C20.77 219.1 .041 251.4 .041 288v176c0 8.836 7.164 16 15.1 16s15.1-7.164 15.1-16V416h447.9v48c0 8.836 7.162 16 15.1 16c8.834 0 15.1-7.164 15.1-16V288C511.1 251.4 491.2 219.1 461.1 203.8zM479.1 352c0 17.64-14.35 32-31.99 32H64.03c-17.64 0-31.99-14.36-31.99-32V288c0-35.29 28.69-64 63.98-64H128V192H96.03c-2.998 0-5.828 .6133-8.758 .8828l26.88-94.07C120 78.31 138.1 64 160.3 64h191.4c21.31 0 40.28 14.31 46.15 34.81l26.88 94.07C421.8 192.6 418.1 192 415.1 192H384v32h31.99c35.29 0 63.98 28.71 63.98 64V352z"],
    "car-building": [640, 512, [], "f859", "M120 88h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C136 95.16 128.8 88 120 88zM320 48v64C320 120.8 327.2 128 336 128S352 120.8 352 112v-64C352 21.49 330.5 0 304 0h-256C21.49 0 0 21.49 0 48v416C0 472.8 7.199 480 16 480S32 472.8 32 464v-416C32 39.16 39.16 32 48 32h256C312.8 32 320 39.16 320 48zM120 216h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C136 223.2 128.8 216 120 216zM120 344h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16h16c8.836 0 16-7.164 16-16v-16C136 351.2 128.8 344 120 344zM544 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 24 24 24s24-10.8 24-24C568 362.8 557.2 352 544 352zM248 136c8.836 0 16-7.164 16-16v-16c0-8.838-7.164-16-16-16h-16c-8.836 0-16 7.162-16 16v16c0 8.836 7.164 16 16 16H248zM595.4 294.5L579.5 225.6C572.9 196.5 547 175.9 517.1 176h-173C314.3 175.9 288.3 196.5 281.8 225.6l-16.38 70.5C241 308.5 224 333.5 224 362.6v55.13c.125 20 13 37.63 32 43.75V496C256 504.9 263.1 512 272 512S288 504.9 288 496v-32h288v32c0 8.875 7.125 16 16 16s16-7.125 16-16v-34.5c19-6.125 31.88-23.75 32-43.75v-55.13C640 333.1 622.5 306.4 595.4 294.5zM312.9 232.8C316.3 218.3 329.1 208 344.1 208h173C532 208 545 218.3 548.4 232.8L561.1 288h-261L312.9 232.8zM608 417.8C608 425.6 601.6 432 593.8 432H270.3C262.4 432 256 425.6 256 417.8v-55.13C256 339.1 275.1 320 298.6 320h266.8C588.9 320 608 339.1 608 362.6V417.8zM320 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 24 24 24s24-10.8 24-24C344 362.8 333.2 352 320 352z"],
    "car-bump": [576, 512, [], "f5e0", "M96.65 297.1c-12.08 5.465-17.44 19.69-11.97 31.76c5.467 12.08 19.69 17.44 31.77 11.97c12.07-5.465 17.44-19.69 11.97-31.76C122.1 297.9 108.7 292.5 96.65 297.1zM373.6 172.6c-12.08 5.465-17.44 19.69-11.97 31.76c5.463 12.08 19.69 17.44 31.76 11.97s17.44-19.69 11.97-31.77C399.9 172.5 385.7 167.1 373.6 172.6zM575.6 492.7c-10.63-51.88-57.48-89.51-111.2-89.51c-53.88 0-100.6 37.63-111.4 89.51c-1.75 8.625 3.752 17.13 12.38 18.88c8.502 1.75 17.13-3.75 19-12.38c7.627-37 41.26-64.01 80.01-64.01c38.63 0 72.26 27 80.01 64.01C545.9 506.7 552.6 512 560 512c1.125 0 2.125-.125 3.25-.375C571.9 509.9 577.5 501.4 575.6 492.7zM119.6 445.7l349.9-158.3l19.79 43.73c2.678 5.91 8.496 9.406 14.59 9.406c2.207 0 4.449-.459 6.59-1.428c8.051-3.643 11.62-13.12 7.98-21.18l-23.46-51.82c12.78-17.96 16.17-41.89 6.426-63.42l-26.39-58.31c-16.05-35.46-50.98-56.45-87.53-56.45c-3.508 0-7.027 .7227-10.55 1.113l-51.49-60.73C302.4 1.105 263.8-7.613 231.4 7.076l-174.4 78.94C24.62 100.6 5.613 135.4 10.8 170.6l12.29 83.15c-23.32 27.42-30.43 66.71-14.61 101.7l26.39 58.31c9.711 21.46 29.89 34.37 51.73 36.69l23.61 52.16C112.9 508.5 118.7 512 124.8 512c2.205 0 4.447-.459 6.588-1.428c8.051-3.645 11.62-13.12 7.98-21.18L119.6 445.7zM70.15 115.1l174.4-78.95c19.44-8.781 42.66-3.594 56.45 12.72l42.13 49.66L56.38 228.4c-1.555 .7031-2.832 1.736-4.33 2.51L42.46 165.9C39.34 144.8 50.74 123.1 70.15 115.1zM106.4 416.5c-4.197 1.898-8.625 2.861-13.16 2.861c-12.56 0-24.02-7.387-29.2-18.82l-26.39-58.31c-7.049-15.57-7.609-32.96-1.582-48.96c6.031-15.1 17.93-28.69 33.5-35.74l291.6-131.1c8.381-3.793 17.24-5.717 26.33-5.717c25.11 0 48.02 14.78 58.37 37.64l26.39 58.31c3.525 7.787 3.807 16.48 .7891 24.48c-3.014 8-8.963 14.35-16.75 17.87L106.4 416.5z"],
    "car-bus": [640, 512, [], "f85a", "M595.4 294.5L579.5 225.6C572.9 196.5 547 175.9 517.1 176h-173C314.3 175.9 288.3 196.5 281.8 225.6l-16.38 70.5C241 308.5 224 333.5 224 362.6v55.13c.125 20 13 37.63 32 43.75V496C256 504.9 263.1 512 272 512S288 504.9 288 496v-32h288v32c0 8.875 7.125 16 16 16s16-7.125 16-16v-34.5c19-6.125 31.88-23.75 32-43.75v-55.13C640 333.1 622.5 306.4 595.4 294.5zM312.9 232.8C316.3 218.3 329.1 208 344.1 208h173C532 208 545 218.3 548.4 232.8L561.1 288h-261L312.9 232.8zM608 417.8C608 425.6 601.6 432 593.8 432H270.3C262.4 432 256 425.6 256 417.8v-55.13C256 339.1 275.1 320 298.6 320h266.8C588.9 320 608 339.1 608 362.6V417.8zM320 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 24 24 24s24-10.8 24-24C344 362.8 333.2 352 320 352zM544 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 24 24 24s24-10.8 24-24C568 362.8 557.2 352 544 352zM80 312c0 13.2 10.8 24 24 24S128 325.2 128 312C128 298.8 117.2 288 104 288S80 298.8 80 312zM176 384L64 384.1c-17.67 0-32-14.46-32-32.13V256h192c8.836 0 16-7.164 16-16C240 231.2 232.8 224 224 224H208V128H352c0 8.836 7.164 16 16 16S384 136.9 384 128V90C384 48.05 298.9 0 192 0S0 48.05 0 90V352c0 23.63 12.95 44.04 32 55.12V464C32 472.8 39.16 480 48 480S64 472.8 64 464v-47.93L176 416C184.8 416 192 408.8 192 400C192 391.2 184.8 384 176 384zM32 90.03C32.89 76.04 92.86 32 192 32s159.1 44.04 160 58V96H32V90.03zM32 128h144v96H32V128z"],
    "car-circle-bolt": [640, 512, [], "e342", "M303.9 384H63.99c-17.67 0-31.99-14.32-31.99-31.99V288c0-35.35 28.65-64 64-64h271.9c8.83 0 15.99-7.16 15.99-15.99C383.9 199.2 376.8 192 367.9 192h-271.9c-2.998 0-5.828 .6133-8.758 .8828l26.88-94.07C119.1 78.21 138.8 64 160.3 64h191.4c21.43 0 40.26 14.21 46.15 34.81l23.31 81.59C423.1 187.3 429.4 192 436.5 192c10.62 0 18.29-10.17 15.38-20.39L428.6 90C418.7 55.67 387.4 32 351.7 32H160.3C124.6 32 93.17 55.67 83.36 90L50.86 203.8C20.72 219.1 0 251.4 0 288v176C0 472.8 7.164 480 15.1 480s15.1-7.164 15.1-16V416h271.9c8.83 0 15.99-7.16 15.99-15.99C319.9 391.2 312.8 384 303.9 384zM79.97 296c0 13.25 10.75 24 23.1 24c13.25 0 23.1-10.75 23.1-24S117.2 272 103.1 272C90.72 272 79.97 282.7 79.97 296zM536 352h-40.23l37.98-36.45c6.375-6.125 6.578-16.25 .4687-22.62c-6.109-6.391-16.27-6.562-22.62-.4687l-66.67 64c-4.719 4.531-6.203 11.45-3.766 17.52S449.5 384 456 384h40.23l-37.98 36.45c-6.375 6.125-6.578 16.25-.4687 22.62C460.9 446.4 465.1 448 469.3 448c3.984 0 7.984-1.484 11.08-4.453l66.67-64c4.719-4.531 6.203-11.45 3.766-17.52S542.5 352 536 352zM496 224C416.5 224 352 288.5 352 368s64.46 144 144 144s144-64.46 144-144S575.5 224 496 224zM496 480c-61.76 0-112-50.24-112-112C384 306.2 434.2 256 496 256c61.76 0 112 50.24 112 112C608 429.8 557.8 480 496 480z"],
    "car-crash": [640, 512, [], "f5e1", "M179.3 94.1c6.393 1 13.41-.875 18.67-5.125l52.26-43c6.893-5.625 7.896-15.62 2.256-22.5S236.7 16.62 229.1 22.25L184.7 59.37L152.3 10.62c-5.764-8.5-15.66-12.37-25.82-9.875C116.6 3.248 109.5 11.37 108.5 21.5L102.9 79.75l-57.53-11.5C35.21 66.12 25.44 70.5 20.18 79.37c-5.264 8.75-4.385 19.5 2.131 27.38l37.22 45.13L10.65 184.2C2.129 189.9-1.756 199.1 .752 209.9C3.258 219.7 11.4 226.7 21.55 227.7l58.4 5.625L68.43 290.7C66.67 299.4 72.31 307.9 80.96 309.6c1.004 .25 2.131 .25 3.135 .25c7.52 0 14.16-5.25 15.79-12.75L113.2 230.9c1.379-6.625-.125-13.5-4.135-18.88C105 206.6 98.88 203.1 92.11 202.5L47.62 198.1l37.22-24.62c5.639-3.75 9.398-9.625 10.4-16.25C96.25 150.5 94.37 143.7 90.11 138.5L61.66 104.1l43.86 8.75c6.393 1.375 13.54-.125 18.92-4.25c5.391-4 8.898-10.12 9.525-16.75L138.2 47.5l24.69 37.13C166.7 90.25 172.7 93.1 179.3 94.1zM283.6 195.2C272 190.3 258.6 195.6 253.7 207.2C248.7 218.7 254.1 232.1 265.7 237.1S290.7 236.6 295.6 225.1C300.6 213.5 295.2 200.1 283.6 195.2zM621.7 272.3l14.55-114.6c4.293-33.78-14.63-66.72-46.06-80.13l-167.4-71.38c-31.3-13.31-68.33-4.281-89.86 22.12L260.2 117.6C227.8 122.1 198.5 142.8 184.8 174.1L164.1 223.1C152.6 249.9 161 279.8 182.4 297.4l-20.72 48.29c-3.479 8.125 .3125 17.5 8.459 21C172.2 367.6 174.4 368 176.5 368c6.234 0 12.16-3.625 14.76-9.719l19.57-45.62l293.9 125.4l-22.18 51.7c-3.477 8.125 .3145 17.5 8.461 21C493 511.6 495.2 512 497.3 512c6.234 0 12.16-3.625 14.76-9.719l22.46-52.37c6.006 1.777 12.07 2.963 18.11 2.963c24.91 0 48.62-14.56 59.03-38.85l20.66-48.19C646.1 333.8 640.7 298.6 621.7 272.3zM357.9 48.5c12.53-15.44 34.03-20.66 52.36-12.88L577.6 107c18.3 7.812 29.33 27 26.82 46.69l-11.71 92.22c-3.602-2.129-7.09-4.398-11.04-6.084L311.1 124.4C307.1 122.7 303.1 121.8 299 120.7L357.9 48.5zM602.8 353.3l-20.66 48.19c-5.061 11.81-16.65 19.43-29.53 19.43c-4.314 0-8.551-.873-12.58-2.594L210.5 277.7c-7.881-3.361-13.98-9.58-17.17-17.51C190.1 252.3 190.2 243.6 193.6 235.7l20.66-48.18c10.12-23.61 33.3-38.86 59.05-38.86c8.652 0 17.12 1.742 25.18 5.18l270.6 115.4C601.6 283.1 616.7 320.8 602.8 353.3zM549.3 308.5c-11.58-4.941-24.1 .4219-29.95 11.98c-4.955 11.56 .4219 24.93 12.01 29.87c11.58 4.941 24.99-.4199 29.95-11.98C566.3 326.9 560.9 313.5 549.3 308.5z"],
    "car-garage": [640, 512, [], "f5e2", "M208 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 23.1 24 23.1s24-10.8 24-23.1C232 362.8 221.2 352 208 352zM483.4 294.5L467.5 225.6c-6.605-29.04-32.34-49.62-62.1-49.62H231.9c-29.76 0-55.62 20.59-62.1 49.62l-16.38 70.5C129 308.5 112 333.5 112 362.6v55.12c.125 20 13 37.63 32 43.75V496C144 504.9 151.1 512 160 512s16-7.125 16-16v-32h288v32c0 8.875 7.125 16 16 16s16-7.125 16-16v-34.5c19-6.125 31.88-23.75 32-43.75v-55.12C528 333.1 510.5 306.4 483.4 294.5zM200.9 232.8c3.375-14.5 16.25-24.75 31.25-24.75h173c14.88 0 27.88 10.25 31.25 24.75l12.75 55.25h-261L200.9 232.8zM496 417.8c0 7.875-6.375 14.25-14.25 14.25H158.3C150.4 432 144 425.6 144 417.8v-55.12c0-23.5 19.12-42.62 42.63-42.62h266.8c23.5 0 42.63 19.12 42.63 42.62V417.8zM432 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 23.1 24 23.1s24-10.8 24-23.1C456 362.8 445.2 352 432 352zM640 208c0-5.31-2.647-10.51-7.469-13.55l-304-191.1c-2.594-1.656-5.562-2.483-8.53-2.483S314.1 .8281 311.5 2.484l-304 191.1c-4.822 3.047-7.469 8.242-7.469 13.55c0 8.628 6.97 15.95 16.02 15.95c2.928 0 5.881-.7949 8.508-2.443L320 34.95l295.5 186.6C618.1 223.2 621.1 224 624 224C632.9 224 640 216.8 640 208z"],
    "car-mirrors": [576, 512, [], "e343", "M136 272c-13.25 0-23.1 10.75-23.1 24S122.8 320 136 320c13.25 0 23.1-10.75 23.1-24S149.3 272 136 272zM439.1 272c-13.25 0-23.1 10.75-23.1 24S426.7 320 439.1 320s23.1-10.75 23.1-24S453.2 272 439.1 272zM544 192h-54.26l-29.15-102C450.8 55.84 419.2 32 383.7 32H192.3C156.8 32 125.2 55.84 115.4 90L86.26 192H32C23.16 192 16 199.2 16 208S23.16 224 32 224h25.19c-15.5 16.92-25.15 39.21-25.15 64v176c0 8.836 7.164 16 15.1 16s15.1-7.164 15.1-16V416h447.9v48c0 8.836 7.162 16 15.1 16c8.834 0 15.1-7.164 15.1-16V288c0-24.79-9.656-47.08-25.15-64H544c8.844 0 16-7.156 16-16S552.8 192 544 192zM146.1 98.81C152 78.31 170.1 64 192.3 64h191.4c21.31 0 40.28 14.31 46.15 34.81l26.88 94.07C453.8 192.6 450.1 192 447.1 192H128c-2.998 0-5.828 .6133-8.758 .8828L146.1 98.81zM511.1 352c0 17.64-14.35 32-31.99 32H96.03c-17.64 0-31.99-14.36-31.99-32V288c0-35.29 28.69-64 63.98-64h319.1c35.29 0 63.98 28.71 63.98 64V352z"],
    "car-rear": [512, 512, ["car-alt"], "f5de", "M461.1 203.8L428.6 90C418.9 55.84 387.3 32 351.7 32H160.3C124.8 32 93.13 55.84 83.38 90L50.86 203.8C20.73 219.1 0 251.4 0 288v64c0 23.63 12.95 44.04 32 55.12V464C32 472.8 39.16 480 48 480C56.84 480 64 472.8 64 464V416h384v48c0 8.836 7.164 16 16 16c8.838 0 16-7.164 16-16v-56.88C499 396 512 375.6 512 352V288C512 251.4 491.3 219.1 461.1 203.8zM114.1 98.81C120 78.31 138.1 64 160.3 64h191.4C373 64 392 78.31 397.9 98.81l26.88 94.07C421.8 192.6 419 192 416 192H96C93 192 90.17 192.6 87.24 192.9L114.1 98.81zM320 384H192v-32h128V384zM432 320H480v32c0 17.64-14.36 32-32 32h-96v-32c0-17.67-14.33-32-32-32H192c-17.67 0-32 14.33-32 32v32H64c-17.64 0-32-14.36-32-32v-32h48C88.84 320 96 312.8 96 304C96 295.2 88.84 288 80 288H32c0-35.29 28.71-64 64-64h320c35.29 0 64 28.71 64 64h-48C423.2 288 416 295.2 416 304C416 312.8 423.2 320 432 320z"],
    "car-side": [640, 512, [62948], "1f697", "M520 224l-108.7-135.9C399.1 72.85 380.7 64 361.3 64H155.4c-26.25 0-49.75 15.88-59.5 40.25L48 226.3C20.5 233.4 0 258.3 0 288v112c0 17.67 14.33 32 32 32h33.61C73.27 477.4 112.5 512 160 512s86.73-34.64 94.39-80h131.2C393.3 477.4 432.5 512 480 512s86.73-34.64 94.39-80H608c17.67 0 32-14.33 32-32v-56C640 277.7 586.3 224 520 224zM361.3 96c9.805 0 18.94 4.391 25.06 12.05L479 224H256V96H361.3zM125.6 116.1C130.5 103.9 142.2 96 155.4 96H224v128H83.26L125.6 116.1zM160 480c-35.29 0-64-28.71-64-64s28.71-64 64-64s64 28.71 64 64S195.3 480 160 480zM480 480c-35.29 0-64-28.71-64-64s28.71-64 64-64s64 28.71 64 64S515.3 480 480 480zM608 400h-33.61C566.7 354.6 527.5 320 480 320s-86.73 34.64-94.39 80H254.4C246.7 354.6 207.5 320 160 320s-86.73 34.64-94.39 80H32V288c0-17.67 14.33-32 32-32h456C568.6 256 608 295.4 608 344V400z"],
    "car-side-bolt": [640, 512, [], "e344", "M336 208H283.1l55.81-52.33c6.438-6.047 6.781-16.17 .75-22.61c-6.062-6.469-16.19-6.75-22.62-.7344l-85.34 80C226.9 216.8 225.4 223.8 227.8 229.9C230.2 235.1 236.1 240 242.7 240h51.97L237.3 292.2C230.7 298.1 230.2 308.2 236.2 314.8C239.3 318.2 243.7 320 248 320c3.844 0 7.688-1.375 10.75-4.156l88-80c4.906-4.453 6.562-11.45 4.188-17.61C348.5 212.1 342.6 208 336 208zM520 224l-108.7-135.9C399.1 72.85 380.7 64 361.3 64H155.4c-26.25 0-49.75 15.88-59.5 40.25L48 226.3C20.5 233.4 0 258.3 0 288v112c0 17.67 14.33 32 32 32h33.61C73.27 477.4 112.5 512 160 512s86.73-34.64 94.39-80h131.2C393.3 477.4 432.5 512 480 512s86.73-34.64 94.39-80H608c17.67 0 32-14.33 32-32v-56C640 277.7 586.3 224 520 224zM160 480c-35.29 0-64-28.71-64-64s28.71-64 64-64s64 28.71 64 64S195.3 480 160 480zM480 480c-35.29 0-64-28.71-64-64s28.71-64 64-64s64 28.71 64 64S515.3 480 480 480zM608 400h-33.61C566.7 354.6 527.5 320 480 320s-86.73 34.64-94.39 80H254.4C246.7 354.6 207.5 320 160 320s-86.73 34.64-94.39 80H32V288c0-17.67 14.33-32 32-32h80C152.8 256 160 248.8 160 240C160 231.2 152.8 224 144 224H83.26l42.33-107.9C130.5 103.9 142.2 96 155.4 96h205.9c9.75 0 18.97 4.432 25.06 12.05L479 224H432C423.2 224 416 231.2 416 240C416 248.8 423.2 256 432 256h88C568.6 256 608 295.4 608 344V400z"],
    "car-tilt": [640, 512, [], "f5e5", "M202.4 172.6C190.3 167.1 176.1 172.5 170.6 184.6C165.1 196.7 170.5 210.9 182.6 216.3s26.3 .1055 31.76-11.97C219.8 192.3 214.4 178.1 202.4 172.6zM491.3 329.7c5.465-12.08 .1055-26.3-11.97-31.76s-26.3-.1055-31.76 11.97c-5.467 12.08-.1055 26.3 11.97 31.76C471.6 347.2 485.9 341.8 491.3 329.7zM624 480h-148l13.38-29.57c21.84-2.314 42.02-15.23 51.73-36.69l26.39-58.31c15.83-34.97 8.717-74.26-14.61-101.7l12.29-83.15c5.189-35.16-13.81-69.95-46.16-84.57l-174.4-78.94C312.2-7.613 273.6 1.105 250.6 28.23L199.1 88.97c-3.52-.3906-7.039-1.113-10.55-1.113c-36.55 0-71.48 20.98-87.53 56.45L74.61 202.6C64.86 224.1 68.25 248.1 81.03 266L57.58 317.9c-3.645 8.051-.0703 17.53 7.98 21.18C67.7 340 69.94 340.5 72.15 340.5c6.092 0 11.91-3.496 14.59-9.406l19.79-43.73l349.9 158.3L440.9 480H16C7.164 480 0 487.2 0 495.1C0 504.8 7.164 512 16 512h608c8.838 0 16-7.164 16-16C640 487.2 632.8 480 624 480zM274.1 48.92c13.78-16.31 37.01-21.5 56.45-12.72l174.4 78.95c19.41 8.812 30.82 29.66 27.69 50.75l-9.582 64.98c-1.498-.7734-2.775-1.807-4.33-2.51L232.8 98.59L274.1 48.92zM119.7 258.2C111.9 254.6 105.1 248.3 102.1 240.3c-3.018-7.998-2.736-16.69 .7891-24.48l26.39-58.31C140.5 134.6 163.4 119.9 188.5 119.9c9.092 0 17.95 1.924 26.33 5.717l291.6 131.1c15.58 7.049 27.47 19.74 33.5 35.74c6.027 15.1 5.467 33.39-1.582 48.96l-26.39 58.31c-5.174 11.44-16.63 18.82-29.2 18.82c-4.533 0-8.961-.9629-13.16-2.861L119.7 258.2z"],
    "car-wash": [448, 512, [], "f5e6", "M224 127.1c26.5 0 48-21.59 48-48.09c0-20.5-24.38-58.13-34.88-73.38C234.2 2.188 229.1 .0062 224 .0062S213.8 2.188 210.9 6.5C200.4 21.75 176 59.38 176 79.88C176 106.4 197.5 127.1 224 127.1zM224 45.38c9.25 15.63 15.88 29.63 16 34.5c0 8.877-7.25 16-16 16s-16-7.25-16-16C208.1 75 214.8 61 224 45.38zM368 128c26.5 0 48-21.63 48-48.13c0-20.5-24.38-58.13-34.88-73.38C378.2 2.188 373.1 .0313 368 .0313s-10.19 2.156-13.12 6.469C344.4 21.75 320 59.38 320 79.88C320 106.4 341.5 128 368 128zM368 45.38c9.25 15.63 15.88 29.63 16 34.5c0 8.877-7.25 16-16 16S352 88.63 352 79.88C352.1 75 358.8 61 368 45.38zM80 128c26.5 0 48-21.63 48-48.13c0-20.5-24.38-58.13-34.88-73.38C90.19 2.188 85.09 .0313 80 .0313S69.81 2.188 66.88 6.5C56.38 21.75 32 59.38 32 79.88C32 106.4 53.5 128 80 128zM80 45.38C89.25 61 95.88 75 96 79.88c0 8.877-7.25 16-16 16S64 88.63 64 79.88C64.13 75 70.75 61 80 45.38zM336 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 24 24 24s24-10.8 24-24C360 362.8 349.2 352 336 352zM387.4 294.5L371.5 225.6c-6.605-29.04-32.34-49.63-62.1-49.63H135.9c-29.76 0-55.62 20.59-62.1 49.63L57.38 296.1C33 308.5 16 333.5 16 362.6v55.13c.125 20 13 37.63 32 43.75v34.5c0 8.875 7.125 16 16 16s16-7.127 16-16v-32h288v32c0 8.875 7.125 16 16 16s16-7.127 16-16v-34.5c19-6.125 31.88-23.75 32-43.75v-55.13C432 333.1 414.5 306.4 387.4 294.5zM104.9 232.8c3.375-14.5 16.25-24.75 31.25-24.75h173c14.88 0 27.88 10.25 31.25 24.75l12.75 55.25h-261L104.9 232.8zM400 417.8c0 7.877-6.375 14.25-14.25 14.25H62.25C54.38 432 48 425.7 48 417.8v-55.13c0-23.5 19.12-42.63 42.63-42.63h266.8c23.5 0 42.63 19.12 42.63 42.63V417.8zM112 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 24 24 24s24-10.8 24-24C136 362.8 125.2 352 112 352z"],
    "car-wrench": [512, 512, ["car-mechanic"], "f5e3", "M419.4 294.5L403.5 225.6C396.9 196.5 371 175.9 341.1 176h-173C138.3 175.9 112.3 196.5 105.8 225.6l-16.38 70.5C65 308.5 48 333.5 48 362.6v55.13c.125 20 13 37.63 32 43.75V496C80 504.9 87.13 512 96 512s16-7.125 16-16v-32h288v32c0 8.875 7.125 16 16 16s16-7.125 16-16v-34.5c19-6.125 31.88-23.75 32-43.75v-55.13C464 333.1 446.5 306.4 419.4 294.5zM136.9 232.8C140.3 218.3 153.1 208 168.1 208h173C356 208 369 218.3 372.4 232.8L385.1 288h-261L136.9 232.8zM432 417.8C432 425.6 425.6 432 417.8 432H94.25C86.38 432 80 425.6 80 417.8v-55.13C80 339.1 99.13 320 122.6 320h266.8C412.9 320 432 339.1 432 362.6V417.8zM368 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 24 24 24s24-10.8 24-24C392 362.8 381.2 352 368 352zM144 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 24 24 24s24-10.8 24-24C168 362.8 157.2 352 144 352zM112 160c26.08 0 49.02-12.67 63.63-31.98h160.8C350.1 147.3 373.9 160 400 160C444.2 160 480 124.2 480 80C480 35.82 444.2 0 400 0c-26.1 0-49.05 12.68-63.65 32.02H175.7C161 12.68 138.1 0 112 0C67.82 0 32 35.82 32 80C32 124.2 67.82 160 112 160zM66.95 64C73.57 45.42 91.17 32 112 32c14.96 0 28.85 7.035 38.12 19.3c6.047 8.006 15.5 12.71 25.53 12.71h160.7c10.03 0 19.49-4.707 25.53-12.71C371.2 39.04 385 32 400 32c20.83 0 38.43 13.42 45.05 32H400v32h45.05C438.4 114.6 420.8 128 400 128c-14.95 0-28.83-7.029-38.1-19.29c-6.049-7.998-15.5-12.7-25.53-12.7H175.6c-10.03 0-19.48 4.701-25.53 12.7C140.8 120.1 126.9 128 112 128C91.17 128 73.57 114.6 66.95 96H112V64H66.95z"],
    "caravan": [640, 512, [], "f8ff", "M240 128h-128c-17.62 0-32 14.38-32 32v64c0 17.62 14.38 32 32 32h128c17.62 0 32-14.38 32-32V160C272 142.4 257.6 128 240 128zM240 224h-128V160h128V224zM624 384H576V192c0-88.37-71.63-160-160-160H96C42.98 32 0 74.98 0 128v192c0 53 43 96 96 96c0 53 43 96 96 96s96-43 96-96h336c8.8 0 16-7.2 16-16S632.8 384 624 384zM192 480c-35.38 0-64-28.62-64-64s28.62-64 64-64s64 28.62 64 64S227.4 480 192 480zM448 224h-32c-8.836 0-16 7.162-16 16C400 248.8 407.2 256 416 256h32v128h-96V160h96V224zM544 384h-64V160c0-17.62-14.38-32-32-32h-96c-17.62 0-32 14.38-32 32v224H282.1C268.9 346.8 233.8 320 192 320s-76.88 26.75-90.13 64H96c-35.38 0-64-28.62-64-64V128c0-35.38 28.62-64 64-64h320c70.63 .125 127.9 57.38 128 128V384z"],
    "caravan-simple": [640, 512, ["caravan-alt"], "e000", "M432 128h-64c-17.62 0-32 14.38-32 32v64c0 17.62 14.38 32 32 32h64c17.62 0 32-14.38 32-32V160C464 142.4 449.6 128 432 128zM432 224h-64V160h64V224zM240 128h-128c-17.62 0-32 14.38-32 32v64c0 17.62 14.38 32 32 32h128c17.62 0 32-14.38 32-32V160C272 142.4 257.6 128 240 128zM240 224h-128V160h128V224zM624 384H576V192c0-88.37-71.63-160-160-160H96C42.98 32 0 74.98 0 128v192c0 53 43 96 96 96c0 53 43 96 96 96s96-43 96-96h336c8.801 0 16-7.201 16-16C640 391.2 632.8 384 624 384zM192 480c-35.38 0-64-28.62-64-64s28.62-64 64-64s64 28.62 64 64S227.4 480 192 480zM544 384H282.1C268.9 346.8 233.8 320 192 320s-76.88 26.75-90.13 64H96c-35.38 0-64-28.62-64-64V128c0-35.38 28.62-64 64-64h320c70.63 .125 127.9 57.38 128 128V384z"],
    "caret-down": [320, 512, [], "f0d7", "M287.1 192H32c-28.37 0-42.74 34.5-22.62 54.63l127.1 128c12.5 12.5 32.75 12.5 45.25 0l127.1-128C330.7 226.5 316.5 192 287.1 192zM159.1 352L32.01 224h255.9L159.1 352z"],
    "caret-left": [256, 512, [], "f0d9", "M192 383.1v-255.1c0-28.37-34.5-42.74-54.63-22.62l-128 127.1c-12.5 12.5-12.5 32.75 0 45.25l128 127.1C157.5 426.7 192 412.5 192 383.1zM32 255.1l128-127.1v255.9L32 255.1z"],
    "caret-right": [256, 512, [], "f0da", "M64 128v255.1c0 28.37 34.5 42.74 54.63 22.62l128-127.1c12.5-12.5 12.5-32.75 0-45.25l-128-127.1C98.5 85.27 64 99.52 64 128zM224 256l-128 127.1V128L224 256z"],
    "caret-up": [320, 512, [], "f0d8", "M32.01 320h255.1c28.37 0 42.74-34.5 22.62-54.63l-127.1-128c-12.5-12.5-32.75-12.5-45.25 0l-127.1 128C-10.73 285.5 3.519 320 32.01 320zM160 160l127.1 128H32.04L160 160z"],
    "carrot": [512, 512, [63367], "1f955", "M504.6 138.6c-22.87-27.63-53.37-43.38-86.36-44.75c-1.625-32.13-17.12-63.5-44.74-86.38c-16.33-13.55-34.16-5.465-40.74 0c-27.25 22.63-43.12 53-44.62 85.88c-.75 14.5 1.75 28.63 6.625 42.13c-13.37-4.377-26.85-7.327-40.35-7.327c-47.99 0-94.11 26.76-116.6 72.76l-135.4 277.5c-9.631 20.06 11.33 40.88 31.31 31.25l277.5-135.5c24.1-12.25 46.43-32.63 59.55-59.63c15.5-31.5 16.73-66.13 6.48-97.13c11.87 4.125 23.1 6.627 36.5 6.627c34.62 0 66.99-15.88 90.86-44.63C514.5 167.6 514.5 150.3 504.6 138.6zM342.1 300.6c-9.623 19.75-25.25 35.25-44.87 44.88l-124.6 60.75L139.2 372.8c-6.125-6.248-16.38-6.248-22.5 0c-6.248 6.125-6.248 16.38 0 22.5l25.54 25.67l-100.1 49l111.9-229.3l26.63 26.58c6.07 6.322 16.5 6.334 22.58 0c6.248-6.125 6.248-16.46 0-22.58l-34.18-34.08c17.19-31.22 49.39-50.54 85.32-50.54c14.87 0 29.25 3.25 42.74 9.875c23.37 11.38 40.99 31.38 49.49 56C355.1 250.7 353.5 277.1 342.1 300.6zM413.7 192.1c-21.5 0-42.99-8.875-60.49-26.5l-6.748-6.75c-37.24-37-35.37-92 6.623-126.8c33.12 27.5 41.49 67.63 25.25 101.6c11.25-5.373 22.1-8 34.87-8c24.12 0 48.37 11.13 66.74 33.25C461.7 181.1 437.7 192.1 413.7 192.1z"],
    "cars": [640, 512, [], "f85b", "M72 200C72 213.2 82.8 224 96 224s24-10.8 24-24C120 186.8 109.2 176 96 176S72 186.8 72 200zM241.9 256H46.25C38.38 256 32 249.6 32 241.8V186.6C32 163.1 51.13 144 74.63 144h266.8c.25 0 .5 .125 .75 .125c.625 0 1.25-.125 2-.125h58.13c-7.75-11.12-18.5-20-30.88-25.5L355.5 49.63C348.9 20.5 323-.125 293.1 0h-173C90.25-.125 64.25 20.5 57.75 49.63l-16.38 70.5C17 132.5 0 157.5 0 186.6v55.13c.125 20 13 37.63 32 43.75V320c0 8.875 7.125 16 16 16S64 328.9 64 320V288h159.6C228 283.8 232.3 279.4 237.3 275.8L241.9 256zM88.88 56.75C92.25 42.25 105.1 32 120.1 32h173C308 32 321 42.25 324.4 56.75L337.1 112h-261L88.88 56.75zM544 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 24 24 24s24-10.8 24-24C568 362.8 557.2 352 544 352zM320 352c-13.2 0-24 10.8-24 24c0 13.2 10.8 24 24 24s24-10.8 24-24C344 362.8 333.2 352 320 352zM595.4 294.5L579.5 225.6C572.9 196.5 547 175.9 517.1 176h-173C314.3 175.9 288.3 196.5 281.8 225.6l-16.38 70.5C241 308.5 224 333.5 224 362.6v55.13c.125 20 13 37.63 32 43.75V496C256 504.9 263.1 512 272 512S288 504.9 288 496v-32h288v32c0 8.875 7.125 16 16 16s16-7.125 16-16v-34.5c19-6.125 31.88-23.75 32-43.75v-55.13C640 333.1 622.5 306.4 595.4 294.5zM312.9 232.8C316.3 218.3 329.1 208 344.1 208h173C532 208 545 218.3 548.4 232.8L561.1 288h-261L312.9 232.8zM608 417.8C608 425.6 601.6 432 593.8 432H270.3C262.4 432 256 425.6 256 417.8v-55.13C256 339.1 275.1 320 298.6 320h266.8C588.9 320 608 339.1 608 362.6V417.8z"],
    "cart-arrow-down": [576, 512, [], "f218", "M184 400c-30.93 0-56 25.07-56 56S153.1 512 184 512s56-25.07 56-56S214.9 400 184 400zM184 480c-13.23 0-24-10.77-24-24c0-13.23 10.77-24 24-24s24 10.77 24 24C208 469.2 197.2 480 184 480zM569.9 76.72C563.9 68.75 554.2 64 544 64H107.3L95.6 12.47C93.94 5.156 87.47 0 80 0H16C7.156 0 0 7.156 0 16S7.156 32 16 32h51.22l77.19 339.5C146.1 378.8 152.5 384 160 384h336c8.844 0 16-7.156 16-16S504.9 352 496 352h-323.2L165.5 320h310.7c21.56 0 40.63-13.88 46.31-33.75l52.28-183.1C577.4 94.03 575.6 84.41 569.9 76.72zM491.8 277.4C490 283.7 483.6 288 476.2 288H160C159.4 288 158.9 288.3 158.3 288.3L114.6 95.93l189.4-.6875v106.1L267.3 164.7c-6.25-6.25-16.38-6.25-22.63 0c-6.25 6.25-6.25 16.38 0 22.62l64 64C311.8 254.4 315.9 256 320 256c4.094 0 8.188-1.562 11.31-4.688l64-64c6.25-6.25 6.25-16.38 0-22.62c-6.25-6.25-16.38-6.25-22.63 0l-36.69 36.69V95.13l208.1-.7539L491.8 277.4zM456 400c-30.93 0-56 25.07-56 56S425.1 512 456 512s56-25.07 56-56S486.9 400 456 400zM456 480c-13.23 0-24-10.77-24-24c0-13.23 10.77-24 24-24c13.23 0 24 10.77 24 24C480 469.2 469.2 480 456 480z"],
    "cart-flatbed": [640, 512, ["dolly-flatbed"], "f474", "M256 320h288c35.35 0 64-28.65 64-64V96c0-35.35-28.65-63.1-64-63.1H256c-35.35 0-64 28.65-64 63.1V256C192 291.3 220.7 320 256 320zM368 64h64v82.11l-23.12-15.42c-5.375-3.594-12.38-3.594-17.75 0L368 146.1V64zM224 96c0-17.64 14.36-32 32-32h80v112c0 5.906 3.25 11.33 8.453 14.11c5.188 2.781 11.52 2.469 16.42-.7969L400 163.2l39.13 26.08C441.8 191.1 444.9 192 448 192c2.594 0 5.188-.625 7.547-1.891C460.8 187.3 464 181.9 464 176V64H544c17.64 0 32 14.36 32 32v160c0 17.64-14.36 32-32 32H256C238.4 288 224 273.6 224 256V96zM624 384H128V48C128 21.49 106.5 0 80 0h-64C7.156 0 0 7.156 0 16S7.156 32 16 32h64C88.84 32 96 39.16 96 48V384c0 17.67 14.33 32 32 32h24.88c-8.404 14.44-11.86 32.12-5.859 51.24c7.027 22.4 26.86 40.01 50.02 43.85C237.2 517.8 272 486.9 272 448c0-11.72-3.379-22.55-8.877-32h177.8C435.4 425.4 432 436.3 432 448c0 38.91 34.79 69.71 74.93 63.1c23.17-3.816 43.01-21.44 50.04-43.84C562.1 448.1 559.5 430.4 551.1 416H624c8.844 0 16-7.156 16-16S632.8 384 624 384zM208 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 480 208 480zM496 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 480 496 480z"],
    "cart-flatbed-boxes": [640, 512, ["dolly-flatbed-alt"], "f475", "M448 160h64c17.67 0 32-14.33 32-32V64c0-17.67-14.33-32-32-32h-64c-17.67 0-32 14.33-32 32v64C416 145.7 430.3 160 448 160zM448 64h64v64h-64V64zM224 320h128c17.67 0 32-14.33 32-32V64c0-17.67-14.33-32-32-32H224C206.3 32 192 46.33 192 64v224C192 305.7 206.3 320 224 320zM224 64h128v224H224V64zM448 320h128c17.67 0 32-14.33 32-32V224c0-17.67-14.33-32-32-32h-128c-17.67 0-32 14.33-32 32v64C416 305.7 430.3 320 448 320zM448 224h128v64h-128V224zM624 384H128V48C128 21.49 106.5 0 80 0h-64C7.156 0 0 7.156 0 16S7.156 32 16 32h64C88.84 32 96 39.16 96 48V384c0 17.67 14.33 32 32 32h24.88c-8.404 14.44-11.86 32.12-5.859 51.24c7.027 22.4 26.86 40.01 50.02 43.85C237.2 517.8 272 486.9 272 448c0-11.72-3.379-22.55-8.877-32h177.8C435.4 425.4 432 436.3 432 448c0 38.91 34.79 69.71 74.93 63.1c23.17-3.816 43.01-21.44 50.04-43.84C562.1 448.1 559.5 430.4 551.1 416H624c8.844 0 16-7.156 16-16S632.8 384 624 384zM208 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 480 208 480zM496 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 480 496 480z"],
    "cart-flatbed-empty": [640, 512, ["dolly-flatbed-empty"], "f476", "M624 384H128V48C128 21.49 106.5 0 80 0h-64C7.156 0 0 7.156 0 16S7.156 32 16 32h64C88.84 32 96 39.16 96 48V384c0 17.67 14.33 32 32 32h24.88c-8.404 14.44-11.86 32.12-5.859 51.24c7.027 22.4 26.86 40.01 50.02 43.85C237.2 517.8 272 486.9 272 448c0-11.72-3.379-22.55-8.877-32h177.8C435.4 425.4 432 436.3 432 448c0 38.91 34.79 69.71 74.93 63.1c23.17-3.816 43.01-21.44 50.04-43.84C562.1 448.1 559.5 430.4 551.1 416H624c8.844 0 16-7.156 16-16S632.8 384 624 384zM208 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 480 208 480zM496 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 480 496 480z"],
    "cart-flatbed-suitcase": [640, 512, ["luggage-cart"], "f59d", "M624 384H128V48C128 21.49 106.5 0 80 0h-64C7.156 0 0 7.156 0 16S7.156 32 16 32h64C88.84 32 96 39.16 96 48V384c0 17.67 14.33 32 32 32h24.88c-8.404 14.44-11.86 32.12-5.86 51.24c7.027 22.4 26.86 40 50.02 43.85C237.2 517.8 272 486.9 272 448c0-11.72-3.379-22.55-8.877-32h177.8C435.4 425.4 432 436.3 432 448c0 38.91 34.79 69.72 74.93 63.1c23.17-3.818 43.01-21.44 50.04-43.85C562.1 448.1 559.5 430.4 551.1 416H624c8.844 0 16-7.156 16-16S632.8 384 624 384zM208 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 480 208 480zM496 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 480 496 480zM256 320h256c35.35 0 64-28.65 64-64V128c0-35.35-28.65-64-64-64h-32V48C480 21.53 458.5 0 432 0h-96C309.5 0 288 21.53 288 48V64H256C220.7 64 192 92.65 192 128v128C192 291.3 220.7 320 256 320zM512 96c17.64 0 32 14.36 32 32v128c0 17.64-14.36 32-32 32V96zM320 48C320 39.17 327.2 32 336 32h96C440.8 32 448 39.17 448 48V64h-128V48zM288 96h192v192H288V96zM224 128c0-17.64 14.36-32 32-32v192C238.4 288 224 273.6 224 256V128z"],
    "cart-minus": [576, 512, [], "e0db", "M184 400c-15.47 0-29.47 6.268-39.6 16.4C134.3 426.5 128 440.5 128 456c0 15.46 6.268 29.46 16.4 39.6C154.5 505.7 168.5 512 184 512s29.47-6.27 39.6-16.4C233.7 485.5 240 471.5 240 456c0-15.46-6.268-29.46-16.4-39.6C213.5 406.3 199.5 400 184 400zM200.1 472.1C196.4 477.5 190.4 480 184 480s-12.44-2.496-16.97-7.031C162.5 468.4 160 462.4 160 456c0-6.412 2.496-12.44 7.031-16.97C171.6 434.5 177.6 432 184 432s12.44 2.496 16.97 7.029S208 449.6 208 456C208 462.4 205.5 468.4 200.1 472.1zM456 400c-15.47 0-29.47 6.268-39.6 16.4c-10.14 10.13-16.4 24.13-16.4 39.6c0 15.46 6.268 29.46 16.4 39.6C426.5 505.7 440.5 512 456 512s29.47-6.27 39.6-16.4c10.14-10.13 16.4-24.13 16.4-39.6c0-15.46-6.268-29.46-16.4-39.6C485.5 406.3 471.5 400 456 400zM472.1 472.1C468.5 477.5 462.4 480 456 480c-6.41 0-12.44-2.496-16.97-7.031c-4.533-4.531-7.029-10.56-7.029-16.97c0-6.412 2.496-12.44 7.031-16.97C443.6 434.5 449.6 432 456 432c6.41 0 12.44 2.496 16.97 7.029S480 449.6 480 456C480 462.4 477.5 468.4 472.1 472.1zM569 75.69C562.1 68.25 553.8 64 544 64H107.3L95.6 12.47C93.94 5.156 87.47 0 80 0H16C7.156 0-.0001 7.156-.0001 16S7.156 32 16 32H67.22l77.19 339.5C146.1 378.8 152.5 384 160 384h336c8.844 0 16-7.156 16-16S504.9 352 496 352H172.8l-7.276-32h310.7c10.34 0 20.59-3.25 28.81-9.156c8.469-6.062 14.69-14.81 17.5-24.59l52.28-183C577.6 93.72 575.4 83.44 569 75.69zM491.8 277.4c-.8438 2.906-2.688 5.438-5.406 7.375C483.5 286.9 479.9 288 476.2 288H160C159.4 288 158.9 288.3 158.3 288.3L114.6 96l429.5-1.625L491.8 277.4zM272 176C263.2 176 256 183.2 256 192s7.16 16 16 16h96c8.844 0 16-7.156 16-16s-7.156-16-16-16H272z"],
    "cart-plus": [576, 512, [], "f217", "M184 400c-15.47 0-29.47 6.268-39.6 16.4C134.3 426.5 128 440.5 128 456c0 15.46 6.268 29.46 16.4 39.6C154.5 505.7 168.5 512 184 512s29.47-6.27 39.6-16.4C233.7 485.5 240 471.5 240 456c0-15.46-6.268-29.46-16.4-39.6C213.5 406.3 199.5 400 184 400zM200.1 472.1C196.4 477.5 190.4 480 184 480s-12.44-2.496-16.97-7.031C162.5 468.4 160 462.4 160 456c0-6.412 2.496-12.44 7.031-16.97C171.6 434.5 177.6 432 184 432s12.44 2.496 16.97 7.029S208 449.6 208 456C208 462.4 205.5 468.4 200.1 472.1zM456 400c-15.47 0-29.47 6.268-39.6 16.4c-10.14 10.13-16.4 24.13-16.4 39.6c0 15.46 6.268 29.46 16.4 39.6C426.5 505.7 440.5 512 456 512s29.47-6.27 39.6-16.4c10.14-10.13 16.4-24.13 16.4-39.6c0-15.46-6.268-29.46-16.4-39.6C485.5 406.3 471.5 400 456 400zM472.1 472.1C468.5 477.5 462.4 480 456 480c-6.41 0-12.44-2.496-16.97-7.031c-4.533-4.531-7.029-10.56-7.029-16.97c0-6.412 2.496-12.44 7.031-16.97C443.6 434.5 449.6 432 456 432c6.41 0 12.44 2.496 16.97 7.029S480 449.6 480 456C480 462.4 477.5 468.4 472.1 472.1zM569 75.69C562.1 68.25 553.8 64 544 64H107.3L95.6 12.47C93.94 5.156 87.47 0 80 0H16C7.156 0-.0001 7.156-.0001 16S7.156 32 16 32H67.22l77.19 339.5C146.1 378.8 152.5 384 160 384h336c8.844 0 16-7.156 16-16S504.9 352 496 352H172.8l-7.276-32h310.7c10.34 0 20.59-3.25 28.81-9.156c8.469-6.062 14.69-14.81 17.5-24.59l52.28-183C577.6 93.72 575.4 83.44 569 75.69zM491.8 277.4c-.8438 2.906-2.688 5.438-5.406 7.375C483.5 286.9 479.9 288 476.2 288H160C159.4 288 158.9 288.3 158.3 288.3L114.6 96l429.5-1.625L491.8 277.4zM304 144v32H272C263.2 176 256 183.2 256 192s7.16 16 16 16h32v32c0 8.844 7.152 16 15.1 16s15.1-7.156 15.1-16l.0067-32h32c8.844 0 16-7.156 16-16s-7.156-16-16-16H336v-32c0-8.844-7.161-16-16-16S304 135.2 304 144z"],
    "cart-shopping": [576, 512, [61562, "shopping-cart"], "1f6d2", "M184 400c-30.93 0-56 25.07-56 56S153.1 512 184 512s56-25.07 56-56S214.9 400 184 400zM184 480c-13.23 0-24-10.77-24-24c0-13.23 10.77-24 24-24s24 10.77 24 24C208 469.2 197.2 480 184 480zM569.9 76.72C563.9 68.75 554.2 64 544 64H107.3L95.6 12.47C93.94 5.156 87.47 0 80 0H16C7.156 0 0 7.156 0 16S7.156 32 16 32h51.22l77.19 339.5C146.1 378.8 152.5 384 160 384h336c8.844 0 16-7.156 16-16S504.9 352 496 352h-323.2L165.5 320h310.7c21.56 0 40.63-13.88 46.31-33.75l52.28-183.1C577.4 94.03 575.6 84.41 569.9 76.72zM491.8 277.4C490 283.7 483.6 288 476.2 288H160C159.4 288 158.9 288.3 158.3 288.3L114.6 95.93l429.5-1.559L491.8 277.4zM456 400c-30.93 0-56 25.07-56 56S425.1 512 456 512s56-25.07 56-56S486.9 400 456 400zM456 480c-13.23 0-24-10.77-24-24c0-13.23 10.77-24 24-24c13.23 0 24 10.77 24 24C480 469.2 469.2 480 456 480z"],
    "cart-shopping-fast": [640, 512, [], "e0dc", "M520 400c-30.93 0-56 25.07-56 56s25.07 56 56 56c30.93 0 56-25.07 56-56S550.9 400 520 400zM520 480c-13.23 0-24-10.77-24-24c0-13.23 10.77-24 24-24c13.24 0 24 10.77 24 24C544 469.2 533.2 480 520 480zM633.9 76.72C627.9 68.75 618.2 64 608 64H171.3L159.6 12.47C157.9 5.156 151.5 0 144 0H80C71.16 0 64 7.156 64 16S71.16 32 80 32h51.22l77.19 339.5C210.1 378.8 216.5 384 224 384h336c8.844 0 16-7.156 16-16s-7.156-16-16-16H236.8l-7.275-32h310.7c21.56 0 40.63-13.88 46.31-33.75l52.28-183.1C641.4 94.03 639.6 84.41 633.9 76.72zM555.8 277.4C554 283.7 547.6 288 540.2 288h-316.2c-.5996 0-1.109 .2754-1.691 .3398L178.6 95.93l429.5-1.559L555.8 277.4zM248 400c-30.93 0-56 25.07-56 56S217.1 512 248 512s56-25.07 56-56S278.9 400 248 400zM248 480c-13.23 0-24-10.77-24-24c0-13.23 10.77-24 24-24s24 10.77 24 24C272 469.2 261.2 480 248 480zM16 224H128c8.838 0 16-7.164 16-16C144 199.2 136.8 192 128 192H16C7.164 192 0 199.2 0 208C0 216.8 7.164 224 16 224zM16 160h96C120.8 160 128 152.8 128 144C128 135.2 120.8 128 112 128h-96C7.164 128 0 135.2 0 144C0 152.8 7.164 160 16 160zM144 256h-128C7.164 256 0 263.2 0 272C0 280.8 7.164 288 16 288h128C152.8 288 160 280.8 160 272C160 263.2 152.8 256 144 256z"],
    "cart-xmark": [576, 512, [], "e0dd", "M184 400c-15.47 0-29.47 6.268-39.6 16.4C134.3 426.5 128 440.5 128 456c0 15.46 6.268 29.46 16.4 39.6C154.5 505.7 168.5 512 184 512s29.47-6.27 39.6-16.4C233.7 485.5 240 471.5 240 456c0-15.46-6.268-29.46-16.4-39.6C213.5 406.3 199.5 400 184 400zM200.1 472.1C196.4 477.5 190.4 480 184 480s-12.44-2.496-16.97-7.031C162.5 468.4 160 462.4 160 456c0-6.412 2.496-12.44 7.031-16.97C171.6 434.5 177.6 432 184 432s12.44 2.496 16.97 7.029S208 449.6 208 456C208 462.4 205.5 468.4 200.1 472.1zM456 400c-15.47 0-29.47 6.268-39.6 16.4c-10.14 10.13-16.4 24.13-16.4 39.6c0 15.46 6.268 29.46 16.4 39.6C426.5 505.7 440.5 512 456 512s29.47-6.27 39.6-16.4c10.14-10.13 16.4-24.13 16.4-39.6c0-15.46-6.268-29.46-16.4-39.6C485.5 406.3 471.5 400 456 400zM472.1 472.1C468.5 477.5 462.4 480 456 480c-6.41 0-12.44-2.496-16.97-7.031c-4.533-4.531-7.029-10.56-7.029-16.97c0-6.412 2.496-12.44 7.031-16.97C443.6 434.5 449.6 432 456 432c6.41 0 12.44 2.496 16.97 7.029S480 449.6 480 456C480 462.4 477.5 468.4 472.1 472.1zM569 75.69C562.1 68.25 553.8 64 544 64H107.3L95.6 12.47C93.94 5.156 87.47 0 80 0H16C7.156 0-.0001 7.156-.0001 16S7.156 32 16 32H67.22l77.19 339.5C146.1 378.8 152.5 384 160 384h336c8.844 0 16-7.156 16-16S504.9 352 496 352H172.8l-7.276-32h310.7c10.34 0 20.59-3.25 28.81-9.156c8.469-6.062 14.69-14.81 17.5-24.59l52.28-183C577.6 93.72 575.4 83.44 569 75.69zM491.8 277.4c-.8438 2.906-2.688 5.438-5.406 7.375C483.5 286.9 479.9 288 476.2 288H160C159.4 288 158.9 288.3 158.3 288.3L114.6 96l429.5-1.625L491.8 277.4zM342.6 146.7l-22.63 22.63l-22.63-22.63C291.1 140.5 281 140.5 274.8 146.7S268.5 163.1 274.8 169.4L297.4 191.1L274.8 214.6C268.5 220.9 268.5 231 274.8 237.3c6.254 6.254 16.37 6.254 22.63 .0003l22.63-22.63l22.63 22.63c6.254 6.254 16.37 6.254 22.63 .0003c6.253-6.253 6.253-16.37-.0003-22.63L342.6 192l22.63-22.63c6.253-6.253 6.253-16.37-.0003-22.63C359 140.5 348.9 140.5 342.6 146.7z"],
    "cash-register": [512, 512, [], "f788", "M511.3 378.8L487.9 215c-4.51-31.51-31.51-54.92-63.34-54.93L192 160V127.9l96.11 .2083c17.6 0 32.01-14.39 32.01-32V32c0-17.6-14.4-32-32-32h-224c-17.6 0-32 14.4-32 32v63.96c0 17.6 14.4 32 32 32L160 127.9V160L87.61 159.1c-31.84 0-58.87 23.41-63.39 54.92c0 0-24.01 170.6-24.22 173.6V448c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64v-60.15C511.8 385.4 511.5 381.3 511.3 378.8zM64.13 95.88V32h224v64L64.13 95.88zM55.9 219.5C58.15 203.8 71.77 192 87.58 192l336.1 .1113c15.81 .0078 29.42 11.82 31.66 27.46L479.6 384H32.32L55.9 219.5zM480 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32v-32h448V448zM112 232C98.75 232 88.06 242.7 88.06 256c0 13.25 10.68 24 23.94 24S136.1 269.3 136.1 256C136.1 242.7 125.3 232 112 232zM208 232C194.7 232 184.1 242.7 184.1 256c0 13.25 10.68 24 23.94 24S232.1 269.3 232.1 256C232.1 242.7 221.3 232 208 232zM304 232c-13.25 0-23.94 10.74-23.94 24c0 13.25 10.68 24 23.94 24S328.1 269.3 328.1 256C328.1 242.7 317.3 232 304 232zM400 232c-13.25 0-23.94 10.74-23.94 24c0 13.25 10.68 24 23.94 24S424.1 269.3 424.1 256C424.1 242.7 413.3 232 400 232zM352 312c-13.25 0-23.94 10.74-23.94 24c0 13.25 10.68 24 23.94 24s24.06-10.75 24.06-24C376.1 322.7 365.3 312 352 312zM256 312c-13.25 0-23.94 10.74-23.94 24c0 13.25 10.68 24 23.94 24s24.06-10.75 24.06-24C280.1 322.7 269.3 312 256 312zM160 312c-13.25 0-23.94 10.74-23.94 24c0 13.25 10.68 24 23.94 24s24.06-10.75 24.06-24C184.1 322.7 173.3 312 160 312z"],
    "cassette-betamax": [576, 512, ["betamax"], "f8a4", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160h512V416zM544 128H32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V128zM352 384h96c17.67 0 32-14.33 32-32V256c0-17.67-14.33-32-32-32h-96c-17.67 0-32 14.33-32 32v96C320 369.7 334.3 384 352 384zM352 256h96v96h-96V256zM176 400c53.02 0 96-42.98 96-96s-42.98-96-96-96s-96 42.98-96 96S122.1 400 176 400zM176 240c35.29 0 64 28.71 64 64c0 35.29-28.71 64-64 64s-64-28.71-64-64C112 268.7 140.7 240 176 240zM176 328c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24c-13.25 0-24 10.74-24 24C152 317.3 162.7 328 176 328z"],
    "cassette-tape": [576, 512, [63659], "1f5ad", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM134.2 448l17.7-53.06C154.1 388.4 160.2 384 167.1 384h241.9c6.906 0 13 4.375 15.16 10.94L441.8 448H134.2zM544 416c0 17.64-14.36 32-32 32h-36.46l-21.07-63.19C447.9 365.2 429.6 352 408.9 352H167.1c-20.69 0-39 13.19-45.53 32.81L100.5 448H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V416zM416 160H160C124.7 160 96 188.7 96 224s28.65 64 64 64h256c35.35 0 64-28.65 64-64S451.3 160 416 160zM160 256C142.4 256 128 241.6 128 224s14.36-32 32-32s32 14.36 32 32S177.6 256 160 256zM360.9 256H215.1C220.6 246.6 224 235.7 224 224S220.6 201.4 215.1 192h145.8C355.4 201.4 352 212.3 352 224S355.4 246.6 360.9 256zM416 256c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S433.6 256 416 256z"],
    "cassette-vhs": [576, 512, [63724, "vhs"], "1f4fc", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V160h512V416zM544 128H32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V128zM124.8 400h326.4c4.828 0 9.406-2.188 12.45-5.938C484.8 367.8 496 336.7 496 304s-11.19-63.84-32.36-90.06C460.6 210.2 456 208 451.2 208H124.8c-4.828 0-9.406 2.188-12.45 5.938C91.19 240.2 80 271.3 80 304s11.19 63.84 32.36 90.06C115.4 397.8 119.1 400 124.8 400zM384 336c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32v-32h59.25C456.8 259.1 464 281.1 464 304s-7.156 44.88-20.75 64H384V336zM224 240h128v128H224V240zM132.8 240H192v32c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32v32H132.8C119.2 348.9 112 326.9 112 304S119.2 259.1 132.8 240z"],
    "castle": [640, 512, [], "e0de", "M608 160l-32 .0072c-17.67 0-32 14.32-32 31.99v32l-32 .0058V32c0-17.67-14.33-32-32-32h-40c-17.67 0-32 14.33-32 32v32h-32V32c0-17.67-14.33-32-32-32h-48c-17.67 0-32 14.33-32 32v32h-32V32c0-17.67-14.33-32-32-32H160C142.3 0 128 14.33 128 32v192L96 224V192c0-17.67-14.33-31.99-32-31.99L32 160C14.33 160 0 174.3 0 192v256c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V192C640 174.3 625.7 160 608 160zM160 32h40v64h96V32h48v64h96V32H480v192H160V32zM384 480H256v-95.99c0-35.29 28.71-64 64-64s64 28.71 64 64V480zM608 448c0 17.64-14.36 32-32 32h-160v-96c0-53.02-42.98-96-96-96s-96 42.98-96 96v96H64c-17.64 0-32-14.36-32-32V192h32v64h512V192h32V448z"],
    "cat": [576, 512, [63166], "1f408", "M544 0c-9.25 0-18.38 4.125-24.62 11.5L475.6 64h-23.25l-43.75-52.5c-9.119-10.79-24.61-14.94-38.63-8.309C358.6 8.584 352 20.88 352 33.5v126.5L336 160C232.1 160 141.9 218.5 96 304.3V176C96 131.9 60.13 96 16 96C7.125 96 0 103.1 0 112S7.125 128 16 128C42.5 128 64 149.5 64 176v256C64 476.2 99.82 512 144 512h207.3c18.32 0 33.12-15.11 32.71-33.43c-.7148-32.36-25.7-58.1-57.36-62.2L416 376.6V464c0 26.4 21.6 48 48 48s48-21.6 48-48V260.8c37.75-18 64-56.25 64-100.7V32C576 14.25 561.6 0 544 0zM480 464c0 8.836-7.164 16-16 16S448 472.8 448 464v-111.1c0-11.58-11.92-19.33-22.5-14.62l-122.2 54.37c-3.615-35.24-25.29-65.79-56.83-80.66c-9.281-4.377-20.28 .4883-22.77 10.45c-1.866 7.46 1.947 14.93 8.81 18.34c22.38 11.11 39.54 30.29 39.54 55.27L272 448H320c17.62 0 32 14.38 32 32l-208 0c-25.48 0-47.69-19.85-47.97-45.32C94.55 301.1 202.7 192 336 192l21.24 .0003C371.1 238.1 413.5 272 464 272c5.5 0 10.75-.8753 16-1.625V464zM544 160c0 44.13-35.88 80-80 80S384 204.1 384 160V32l53.38 64h53.25L544 32V160zM432 128C423.1 128 416 135.1 416 144S423.1 160 432 160S448 152.9 448 144S440.9 128 432 128zM480 144C480 152.9 487.1 160 496 160S512 152.9 512 144S504.9 128 496 128S480 135.1 480 144z"],
    "cat-space": [640, 512, [], "e001", "M576 32.75V32l-.5 .375C548.9 12.25 516 .0003 480 .0003s-68.88 12.25-95.5 32.37L384 32v.75c-38.63 29.12-64 75.13-64 127.3c0 .375 .125 .7498 .125 1.125C197.2 168.3 125.4 249.3 96 304.3V176C96 131.9 60.13 96 16 96C7.125 96 0 103.1 0 112S7.125 128 16 128C42.5 128 64 149.5 64 176v256C64 476.2 99.82 512 144 512h207.3c18.32 0 33.12-15.11 32.71-33.43c-.7148-32.36-25.7-58.1-57.36-62.2L416 376.6V464c0 26.4 21.6 48 48 48S512 490.4 512 464V316.8c74.5-15.25 128-80.75 128-156.7C640 107.9 614.6 61.88 576 32.75zM480 32c24.38 0 48.25 7.125 68.75 20.38L512 80h-64l-36.75-27.62C431.8 39.13 455.6 32 480 32zM544 96v64c0 35.38-28.62 64-64 64s-64-28.62-64-64V96l21.38 16h85.25L544 96zM479.1 464c0 8.836-7.149 16-15.99 16s-16.01-7.164-16.01-16L448 352c0-11.58-11.92-19.33-22.5-14.62l-122.2 54.37c-3.615-35.24-25.29-65.79-56.83-80.66c-9.281-4.377-20.28 .4883-22.77 10.45c-1.867 7.459 1.947 14.93 8.809 18.34C254.8 350.1 272 370.2 272 395.1V448H320c17.62 0 32 14.38 32 32H143.1c-25.48 0-47.69-19.85-47.96-45.32c-.7031-64.13 45.36-232.5 227.4-242.1C338.9 266.9 404.3 320 480 320L479.1 464zM480 288c-70.63-.125-127.9-57.38-128-128c0-32.13 12.38-61.25 32-83.75V160c0 53 43 96 96 96S576 213 576 160V76.25C595.6 98.75 608 127.9 608 160C607.9 230.6 550.6 287.9 480 288zM432 160c0 8.875 7.125 16 16 16s16-7.125 16-16S456.9 144 448 144c-4.25 0-8.375 1.625-11.38 4.625S432 155.8 432 160zM512 176c8.875 0 16-7.125 16-16S520.9 144 512 144S496 151.1 496 160c0 4.25 1.625 8.375 4.625 11.38S507.8 176 512 176zM176 80h32v32c0 8.844 7.149 16 15.99 16S240 120.8 240 112v-32h32c8.844 0 15.99-7.156 15.99-15.1S280.8 48 272 48h-32v-32c0-8.844-7.164-15.1-16.01-15.1S208 7.156 208 16v32h-32c-8.844 0-16.01 7.156-16.01 16S167.2 80 176 80z"],
    "cauldron": [448, 512, [], "f6bf", "M272 128C298.5 128 320 106.5 320 80S298.5 32 272 32S224 53.5 224 80S245.5 128 272 128zM272 64C280.9 64 288 71.12 288 80S280.9 96 272 96S256 88.88 256 80S263.1 64 272 64zM448 176C448 167.2 440.8 160 432 160h-416C7.2 160 0 167.2 0 175.1S7.2 192 15.1 192H54.75C20.75 237.8 0 293.6 0 345.6c0 39 11.88 70.62 32 95.5L31.1 495.3c0 7.964 5.493 15.3 13.36 16.53C55.42 513.4 64 505.7 64 496v-25.38C104.6 498.8 161.2 512 224 512s119.4-13.25 160-41.38L383.1 495.3c0 7.964 5.493 15.3 13.36 16.53C407.4 513.4 416 505.7 416 496v-54.88c20.12-24.88 32-56.5 32-95.5C448 293.6 427.3 237.8 393.2 192H432C440.8 192 448 184.8 448 176zM416 345.6C416 466.9 281.8 480 224 480s-192-13.12-192-134.4C32 293.4 56.12 235.6 95.62 192h256.8C391.9 235.6 416 293.4 416 345.6zM160 56c13.22 0 24-10.78 24-24S173.2 8 160 8C146.8 8 136 18.78 136 32S146.8 56 160 56z"],
    "cedi-sign": [320, 512, [], "e0df", "M293.8 380.1c-29.71 24.24-65.56 35.65-101.3 35.64V96.31c35.73-.0117 71.58 11.4 101.3 35.63c6.877 5.531 16.98 4.531 22.57-2.281c5.608-6.844 4.59-16.94-2.272-22.53c-35.68-29.03-78.71-42.74-121.6-42.74V16c0-8.844-7.175-16-16.04-16c-8.867 0-16.04 7.156-16.04 16v51.16C122.3 73.63 85.74 90.95 56.38 120.3C20.02 156.5-.0003 204.7-.0003 256s20.02 99.5 56.38 135.8c29.38 29.3 65.91 46.93 104 53.4V496c0 8.844 7.175 16 16.04 16c8.867 0 16.04-7.156 16.04-16l.0157-47.75c.0098 0-.0098 0 0 0c42.88 0 85.91-14.34 121.6-43.37c6.862-5.594 7.88-15.69 2.272-22.53C310.8 375.5 300.7 374.5 293.8 380.1zM79.07 369.1C48.77 338.9 32.08 298.8 32.08 256s16.68-82.91 46.98-113.1c23.1-23.04 51.53-37.37 81.35-43.48v313.2C130.6 406.5 102.2 392.2 79.07 369.1z"],
    "cent-sign": [320, 512, [], "a2", "M316.4 382.4c5.594 6.844 4.562 16.92-2.312 22.5c-35.65 29.03-78.69 43.36-121.6 43.36c-.1777 0-.3535-.0508-.5313-.0508V496c0 8.844-7.152 16-15.1 16s-16-7.156-16-16v-50.91c-37.97-6.52-74.33-24.13-103.6-53.31C20.03 355.5 0 307.3 0 256s20.03-99.52 56.37-135.8c29.25-29.16 65.66-46.46 103.6-52.99V16c0-8.844 7.158-16 16-16s15.1 7.156 15.1 16v48.36c43.06-.123 86.3 13.6 122.1 42.76c6.875 5.578 7.906 15.66 2.312 22.5c-5.594 6.891-15.66 7.859-22.5 2.312c-64.09-52.13-156.4-47.38-214.9 10.94C48.69 173.1 32 213.3 32 256s16.69 82.91 46.1 113.1c58.53 58.36 150.9 62.98 214.9 10.94C300.7 374.5 310.8 375.5 316.4 382.4z"],
    "certificate": [512, 512, [], "f0a3", "M495.8 272.3L479 255.9l16.75-16.25c30-28.88 16.25-79.63-23.88-89.38l-22.75-5.875l6.501-22.63c11.25-40-26.13-76.5-65.51-65.5l-22.63 6.5l-5.751-22.88c-9.876-39.88-60.88-53.63-89.51-23.75L256 32.88L239.7 16.13c-28.38-29.63-79.64-16.5-89.51 23.75l-5.751 22.88L121.9 56.26c-39.26-11-76.76 25.25-65.51 65.5l6.501 22.63L40.09 150.3C-.038 160-13.79 210.8 16.21 239.6L32.97 255.9L16.21 272.3C-13.79 301.1-.038 351.9 40.09 361.6l22.75 5.875l-6.501 22.63c-11.25 40.25 26.25 76.5 65.51 65.5l22.63-6.5l5.751 22.75c10 40.63 60.88 53.63 89.39 23.88L256 479l16.25 16.63c28.25 30 79.51 16.75 89.51-23.75l5.751-22.75l22.63 6.5c39.51 11.13 76.64-25.5 65.51-65.5l-6.501-22.63l22.75-5.875C512 351.9 525.8 301.1 495.8 272.3zM464.3 330.6l-54.88 14l15.5 54.25c4.376 15.63-10.38 30.38-26 26l-54.26-15.5l-14 54.88c-3.751 15.88-24.38 21.13-35.26 9.25L256 433.3l-39.38 40.25c-11 11.75-31.38 7-35.26-9.25L167.4 409.4L113.1 424.9c-15.63 4.375-30.38-10.38-26-26l15.5-54.25l-54.88-14C32.09 326.9 26.47 306.6 38.47 295.3L78.72 255.9L38.47 216.5C26.47 205.3 31.97 185 47.72 181.3L102.6 167.3l-15.5-54.25C82.72 97.38 97.48 82.63 113.1 87.01l54.26 15.5l14-54.88C185.1 32.01 205.6 26.63 216.6 38.38L256 78.88l39.38-40.5c11.13-11.88 31.63-6.25 35.26 9.25l14 54.88l54.26-15.5c15.63-4.375 30.38 10.38 26 26L409.4 167.3l54.88 14c15.63 3.75 21.25 24 9.251 35.25L433.3 255.9l40.26 39.38C485.5 306.6 480 326.9 464.3 330.6z"],
    "chair": [448, 512, [63168], "1fa91", "M443.6 315.9L428.8 283.9C420.1 266.9 403.9 256 385.2 256h-1.212L384 112C384 50.25 333.8 0 272 0h-96C114.3 0 64 50.25 64 112L63.1 256H62.79C44.13 256 27.02 266.9 19.2 283.9L4.436 315.9c-6.883 14.95-5.697 32.13 3.156 45.98C13.43 371 22.13 377.4 32 380.9L31.1 496c0 8.836 7.164 16 16 16S64 504.8 64 496L63.1 384h320L384 496c0 8.836 7.166 16 16 16s16-7.164 16-16L416 380.9c9.873-3.512 18.57-9.91 24.41-19.05C449.3 348 450.4 330.8 443.6 315.9zM288 33.62C324.5 41.05 352 73.36 352 112V256h-64V33.62zM192 32h64v224H192V32zM96 112c0-38.64 27.53-70.95 64-78.38V256H96V112zM399.1 352H48.02c-11.74 0-19.38-12.17-14.53-22.7l14.76-32C50.86 291.6 56.56 288 62.79 288h322.4c6.223 0 11.93 3.648 14.53 9.297l14.76 31.99C419.4 339.9 411.6 352 399.1 352z"],
    "chair-office": [448, 512, [], "f6c1", "M48.02 240c8.844 0 15.99-7.156 15.99-16l.0091-80c0-8.844-7.154-16-15.1-16s-15.1 7.156-15.1 16V224C32.02 232.8 39.17 240 48.02 240zM396.8 283.9C388.1 266.9 371.9 256 353.2 256h-1.217l-.0091-176c0-44.13-35.89-80-79.99-80H176C131.9 0 96.01 35.88 96.01 80L96.01 256H94.79C76.13 256 59.02 266.9 51.2 283.9L36.44 315.9c-6.883 14.95-5.697 32.13 3.156 45.98C48.45 375.7 63.56 384 80.02 384H208v49.04C162.1 438 128 463.8 128 496c0 8.844 7.156 16 15.1 16c8.844 0 16-7.156 16-16c0-12.78 19.74-26.76 47.99-30.77V496c0 8.844 7.157 16 15.1 16c8.844 0 15.1-7.156 15.1-16v-30.77c28.26 4.012 47.99 17.98 47.99 30.77c0 8.844 7.156 16 16 16c8.842 0 15.1-7.156 15.1-16c0-32.21-34.09-57.99-79.99-62.96V384h127.1c16.46 0 31.58-8.277 40.44-22.14c8.85-13.84 10.03-31.03 3.156-45.96L396.8 283.9zM176 32h95.99c26.47 0 47.1 21.53 47.1 48V256H128L128 80C128 53.53 149.5 32 176 32zM381.4 344.6C378.5 349.2 373.5 352 367.1 352H80.02c-5.484 0-10.52-2.756-13.47-7.369c-2.957-4.625-3.352-10.36-1.062-15.33l14.76-32C82.86 291.6 88.56 288 94.79 288h258.4c6.223 0 11.93 3.648 14.53 9.297l14.76 31.99C384.8 334.3 384.4 340 381.4 344.6zM399.1 128c-8.844 0-15.1 7.156-15.1 16L383.1 224c0 8.844 7.144 16 15.99 16s15.1-7.156 15.1-16V144C415.1 135.2 408.8 128 399.1 128z"],
    "chalkboard": [576, 512, ["blackboard"], "f51b", "M560 448H416v-48c0-26.47-21.53-48-48-48h-96C245.5 352 224 373.5 224 400V448H16C7.156 448 0 455.2 0 464S7.156 480 16 480h544c8.844 0 16-7.156 16-16S568.8 448 560 448zM384 448H256v-48C256 391.2 263.2 384 272 384h96c8.828 0 16 7.188 16 16V448zM45.32 383.8C55.35 385.4 64 377.7 64 368v-288C64 71.16 71.16 64 80 64h416C504.8 64 512 71.16 512 80v288c0 8.836 7.164 16 16 16s16-7.164 16-16v-288C544 53.49 522.5 32 496 32h-416C53.49 32 32 53.49 32 80v287.2C32 375.1 37.46 382.5 45.32 383.8z"],
    "chalkboard-user": [640, 512, ["chalkboard-teacher"], "f51c", "M160 320c53.02 0 96-42.98 96-96c0-53.02-42.98-96-96-96C106.1 128 64 170.1 64 224C64 277 106.1 320 160 320zM160 160c35.29 0 64 28.71 64 64S195.3 288 160 288S96 259.3 96 224S124.7 160 160 160zM192 352H128c-70.69 0-128 57.31-128 128c0 17.67 14.33 32 32 32h256c17.67 0 32-14.33 32-32C320 409.3 262.7 352 192 352zM32 480c0-52.94 43.07-96 96-96h64c52.94 0 96 43.06 96 96H32zM592 0h-384C181.5 0 160 21.53 160 48v32C160 88.84 167.2 96 176 96S192 88.84 192 80v-32C192 39.19 199.2 32 208 32h384C600.8 32 608 39.19 608 48v320c0 8.812-7.172 16-16 16H576v-48C576 309.5 554.5 288 528 288h-96C405.5 288 384 309.5 384 336V384h-32c-8.844 0-16 7.156-16 16S343.2 416 352 416h240C618.5 416 640 394.5 640 368v-320C640 21.53 618.5 0 592 0zM544 384h-128v-48c0-8.812 7.172-16 16-16h96c8.828 0 16 7.188 16 16V384z"],
    "champagne-glass": [256, 512, ["glass-champagne"], "f79e", "M208 480h-64v-130.1c62.91-8.131 112-61.9 112-128.1c0-35.09-13.27-130.1-33.02-215.6C222.1 2.562 218.9 0 215.2 0H40.81C37.09 0 33.86 2.562 33.02 6.188C13.27 91.69 0 186.7 0 221.8c0 66.16 49.09 119.9 112 128.1V480h-64C39.16 480 32 487.2 32 496C32 504.8 39.16 512 48 512h160c8.836 0 16-7.164 16-16C224 487.2 216.8 480 208 480zM195.1 32c7.057 32.58 13.06 65.88 17.75 96H42.29c4.688-30.13 10.69-63.42 17.75-96H195.1zM32 221.8C32 209.1 34.1 186.9 37.66 160h180.7C221.9 186.9 224 209.1 224 221.8c0 51.53-39.66 94.34-90.29 97.46c-7.01 .4316-4.297 .4375-11.41 0C71.66 316.2 32 273.3 32 221.8z"],
    "champagne-glasses": [640, 512, [63391, "glass-cheers"], "1f942", "M638.1 435.1c-3.135-8.381-12.65-12.7-21.26-9.652l-64.4 22.82l-37.47-96.24c58.29-29.48 86.96-97.36 63.52-160.1c-11.57-30.95-52.69-107.1-98.24-177.3c-8.084-12.47-23.7-17.72-37.7-12.75l-60.2 21.33c-9.654 3.421-13.78 14.81-8.551 23.62c3.827 6.451 11.86 9.586 18.93 7.08l59.98-21.25c18.42 28.47 36.08 57.98 51.33 84.94L379.4 162.1c-5.39 1.91-9.364 6.533-10.44 12.15l-.0722 .3756c-2.335 12.15 9.407 22.25 21.07 18.11l130.8-46.36c13 24.27 22.92 44.63 27.43 56.68c18.27 48.88-5.188 103.2-53.41 123.6c-6.781 2.873-4.137 1.93-11.12 3.938c-43.12 12.42-88.71-5.457-112.4-41.45c-5.915-8.969-18.73-9.828-25.76-1.708c-4.742 5.474-5.377 13.5-1.359 19.52c30.22 45.32 86.22 68.13 140.6 56.19l37.45 96.18l-60.28 21.36c-8.607 3.051-13.04 12.32-9.912 20.7c3.133 8.383 12.65 12.71 21.26 9.652l155.9-55.24C637.7 452.7 642.1 443.5 638.1 435.1zM330.5 49.32L196.6 1.861C182.6-3.078 167 2.045 158.9 14.47C113.4 84.76 72.19 160.1 60.61 191.1c-23.44 62.7 5.236 130.6 63.52 160.1L86.67 448.3l-64.4-22.82c-8.607-3.049-18.13 1.271-21.26 9.652c-3.133 8.385 1.307 17.65 9.914 20.7l155.9 55.24c8.607 3.053 18.13-1.27 21.26-9.652c3.133-8.381-1.305-17.65-9.912-20.7l-60.28-21.36l37.45-96.18c64.23 14.12 131.2-19.96 154.7-82.77c11.53-30.83 30.19-114.3 41.69-196.4C353.8 68.88 344.8 54.41 330.5 49.32zM278.8 269.3c-18.27 48.88-72.09 75.79-122.5 61.27C149.3 328.6 151.1 329.5 145.2 326.6C96.97 306.2 73.51 251.9 91.79 203c4.502-12.05 14.42-32.41 27.43-56.68l176 62.38C289.2 235.4 283.3 257.3 278.8 269.3zM302.1 176.8L135.1 117.6C150.3 90.62 167.1 61.11 186.4 32.64l132.4 46.93C314.1 112.9 308.2 146.6 302.1 176.8z"],
    "charging-station": [576, 512, [], "f5e7", "M560 128H544V80C544 71.13 536.9 64 528 64S512 71.13 512 80V128h-32V80C480 71.13 472.9 64 464 64S448 71.13 448 80V128h-16C423.2 128 416 135.2 416 144V192c0 38.75 27.5 71 64 78.38v111.8c0 15.95-10.83 30.8-26.57 33.41C433.4 418.9 416 403.4 416 384v-48C416 291.8 380.2 256 336 256H320V64c0-35.35-28.65-64-64-64H96C60.65 0 32 28.65 32 64v416H16C7.199 480 0 487.2 0 496C0 504.8 7.199 512 16 512h320c8.801 0 16-7.201 16-16c0-8.801-7.199-16-16-16H320V288h16c26.51 0 48 21.49 48 48v45.08c0 33.39 24.3 63.31 57.53 66.6C479.7 451.5 512 421.4 512 384V270.4C548.5 263 576 230.8 576 192V144C576 135.2 568.8 128 560 128zM288 480H64V64c0-17.62 14.38-32 32-32h160c17.62 0 32 14.38 32 32V480zM544 192c0 26.5-21.5 48-48 48S448 218.5 448 192V160h96V192zM224 191.1L150.2 192l24.97-74.94c2.797-8.375-1.734-17.44-10.11-20.25C156.6 94.03 147.6 98.59 144.8 106.9l-32 96C111.2 207.8 112 213.2 115 217.3C118 221.5 122.9 224 128 224h71.73L161.3 313.7c-3.484 8.125 .2813 17.53 8.406 21.03C171.8 335.6 173.9 336 176 336c6.203 0 12.11-3.625 14.7-9.688l48-112c2.125-4.969 1.609-10.62-1.344-15.12C234.4 194.7 229.4 191.1 224 191.1z"],
    "chart-area": [512, 512, ["area-chart"], "f1fe", "M496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.16 24.84 32 16 32S0 39.16 0 48v352C0 444.1 35.88 480 80 480h416c8.844 0 16-7.156 16-16S504.8 448 496 448zM144 384h288c26.47 0 48-21.53 48-48V253.3c0-12.62-5.125-25-14.06-33.94l-86.63-86.63c-6.25-6.25-16.38-6.25-22.62 0l-51.61 51.63L236.3 101.8C233.3 98.16 228.9 96.06 224.2 96C219.8 94.56 215 97.94 211.1 101.5L107.9 220.4C100.2 229.2 96 240.4 96 252V336C96 362.5 117.5 384 144 384zM128 252c0-3.875 1.406-7.625 3.969-10.56l91.73-104.8l68 81.63c2.891 3.438 7.078 5.531 11.58 5.719c4.5 .4687 8.875-1.5 12.03-4.656L368 166.6l75.31 75.31C446.3 244.9 448 249 448 253.3V336c0 8.812-7.172 16-16 16h-288C135.2 352 128 344.8 128 336V252z"],
    "chart-bar": [512, 512, ["bar-chart"], "f080", "M144 240h160C312.8 240 320 232.8 320 224s-7.172-16-16-16h-160C135.2 208 128 215.2 128 224S135.2 240 144 240zM144 144h224C376.8 144 384 136.8 384 128s-7.172-16-16-16h-224C135.2 112 128 119.2 128 128S135.2 144 144 144zM496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.17 24.83 32 16 32S0 39.17 0 48v352C0 444.1 35.88 480 80 480h416c8.828 0 16-7.172 16-16S504.8 448 496 448zM144 336h288c8.828 0 16-7.172 16-16s-7.172-16-16-16h-288C135.2 304 128 311.2 128 320S135.2 336 144 336z"],
    "chart-bullet": [512, 512, [], "e0e1", "M48 224H128V64H48C21.49 64 0 85.49 0 112v64C0 202.5 21.49 224 48 224zM32 112C32 103.2 39.18 96 48 96H96v96H48C39.18 192 32 184.8 32 176V112zM464 64H288c0-8.844-7.156-16-16-16S256 55.16 256 64H160v32h96v96H160v32h96c0 8.844 7.156 16 16 16S288 232.8 288 224h176C490.5 224 512 202.5 512 176v-64C512 85.49 490.5 64 464 64zM480 176C480 184.8 472.8 192 464 192H288V96h176C472.8 96 480 103.2 480 112V176zM0 336v64C0 426.5 21.49 448 48 448H224V288H48C21.49 288 0 309.5 0 336zM192 416H48C39.18 416 32 408.8 32 400v-64C32 327.2 39.18 320 48 320H192V416zM464 288H384c0-8.844-7.156-16-16-16S352 279.2 352 288h-96v32h96v96h-96v32h96c0 8.844 7.156 16 16 16S384 456.8 384 448h80c26.51 0 48-21.49 48-48v-64C512 309.5 490.5 288 464 288zM480 400c0 8.822-7.178 16-16 16H384v-96h80c8.822 0 16 7.178 16 16V400z"],
    "chart-candlestick": [512, 512, [], "e0e2", "M416 320v48c0 8.828 7.172 16 16 16s16-7.172 16-16V320c17.67 0 32-14.33 32-32V224c0-17.67-14.33-32-32-32V144C448 135.2 440.8 128 432 128S416 135.2 416 144V192c-17.67 0-32 14.33-32 32v64C384 305.7 398.3 320 416 320zM416 224h32v64h-32V224zM496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.17 24.83 32 16 32S0 39.17 0 48v352C0 444.1 35.88 480 80 480h416c8.828 0 16-7.172 16-16S504.8 448 496 448zM160 320v48C160 376.8 167.2 384 176 384S192 376.8 192 368V320c17.67 0 32-14.33 32-32V160c0-17.67-14.33-32-32-32V80C192 71.17 184.8 64 176 64S160 71.17 160 80V128C142.3 128 128 142.3 128 160v128C128 305.7 142.3 320 160 320zM160 160h32v128H160V160zM288 256v48c0 8.828 7.172 16 16 16S320 312.8 320 304V256c17.67 0 32-14.33 32-32V128c0-17.67-14.33-32-32-32V48C320 39.17 312.8 32 304 32S288 39.17 288 48V96c-17.67 0-32 14.33-32 32v96C256 241.7 270.3 256 288 256zM288 128h32v96h-32V128z"],
    "chart-column": [512, 512, [], "e0e3", "M496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.16 24.84 32 16 32S0 39.16 0 48v352C0 444.1 35.88 480 80 480h416c8.844 0 16-7.156 16-16S504.8 448 496 448zM159.1 368C168.8 368 176 360.8 176 352V256c0-8.844-7.156-16-16-16S143.1 247.2 143.1 256L144 352C144 360.8 151.1 368 159.1 368zM255.1 368C264.8 368 272 360.8 272 352V128c0-8.844-7.156-16-16-16S239.1 119.2 239.1 128L240 352C240 360.8 247.1 368 255.1 368zM351.1 368C360.8 368 368 360.8 368 352V192c0-8.844-7.156-16-16-16S335.1 183.2 335.1 192L336 352C336 360.8 343.1 368 351.1 368zM447.1 368C456.8 368 464 360.8 464 352V96c0-8.844-7.156-16-16-16S431.1 87.16 431.1 96L432 352C432 360.8 439.1 368 447.1 368z"],
    "chart-gantt": [512, 512, [], "e0e4", "M352 320c0 8.828 7.172 16 16 16h96c8.828 0 16-7.172 16-16s-7.172-16-16-16h-96C359.2 304 352 311.2 352 320zM192 224c0 8.828 7.172 16 16 16h160C376.8 240 384 232.8 384 224s-7.172-16-16-16h-160C199.2 208 192 215.2 192 224zM496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.17 24.83 32 16 32S0 39.17 0 48v352C0 444.1 35.88 480 80 480h416c8.828 0 16-7.172 16-16S504.8 448 496 448zM144 144h128C280.8 144 288 136.8 288 128s-7.172-16-16-16h-128C135.2 112 128 119.2 128 128S135.2 144 144 144z"],
    "chart-line": [512, 512, ["line-chart"], "f201", "M123.3 315.3L224 214.6l84.67 84.67c6.248 6.248 16.38 6.248 22.62 .002l144-143.1c6.25-6.248 6.25-16.38 .002-22.62s-16.38-6.248-22.62 0L320 265.4L235.3 180.7c-6.223-6.225-16.4-6.225-22.63-.002l-112 112c-6.234 6.234-6.234 16.39 0 22.62C106.9 321.6 117.1 321.6 123.3 315.3zM496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.17 24.83 32 16 32S0 39.17 0 48v352C0 444.1 35.88 480 80 480h416c8.828 0 16-7.172 16-16S504.8 448 496 448z"],
    "chart-line-down": [512, 512, [63053], "1f4c9", "M496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.16 24.84 32 16 32S0 39.16 0 48v352C0 444.1 35.88 480 80 480h416c8.844 0 16-7.156 16-16S504.8 448 496 448zM212.7 299.3c6.25 6.25 16.38 6.25 22.62 0L320 214.6L425.4 320h-89.37C327.2 320 320 327.2 320 336s7.157 16 16 16H464c8.844 0 16-7.156 16-16v-128C480 199.2 472.8 192 464 192S448 199.2 448 208v89.38l-116.7-116.7c-6.25-6.25-16.38-6.25-22.62 0L224 265.4L123.3 164.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L212.7 299.3z"],
    "chart-line-up": [512, 512, [], "e0e5", "M496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.16 24.84 32 16 32S0 39.16 0 48v352C0 444.1 35.88 480 80 480h416c8.844 0 16-7.156 16-16S504.8 448 496 448zM123.3 315.3L224 214.6l84.69 84.69c6.25 6.25 16.38 6.25 22.62 0L448 182.6V272C448 280.8 455.2 288 464 288S480 280.8 480 272v-128C480 135.2 472.8 128 464 128h-127.1C327.2 128 320 135.2 320 144S327.2 160 336 160h89.38L320 265.4L235.3 180.7c-6.25-6.25-16.38-6.25-22.62 0l-112 112c-6.25 6.25-6.25 16.38 0 22.62C106.9 321.6 117.1 321.6 123.3 315.3z"],
    "chart-mixed": [576, 512, ["analytics"], "f643", "M64 352H32c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-96C96 366.3 81.67 352 64 352zM64 480H32v-96h32V480zM544 192h-32c-17.67 0-32 14.33-32 32v256c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32V224C576 206.3 561.7 192 544 192zM544 480h-32V224h32V480zM384 320h-32c-17.67 0-32 14.33-32 32v128c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-128C416 334.3 401.7 320 384 320zM384 480h-32v-128h32V480zM224 192H192C174.3 192 160 206.3 160 224v256c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32V224C256 206.3 241.7 192 224 192zM224 480H192V224h32V480zM505.1 89.2C511.1 93.12 519.5 96 528 96C554.5 96 576 74.51 576 48S554.5 0 528 0S480 21.49 480 48c0 6.158 1.576 11.82 3.744 17.2L390.9 134.8C384 130.9 376.5 128 368 128s-16.05 2.877-22.94 6.801L252.3 65.2C254.4 59.82 256 54.16 256 48C256 21.49 234.5 0 208 0S160 21.49 160 48c0 7.355 2.154 14.03 5.133 20.24l-96.89 96.89C62.03 162.2 55.36 160 48 160C21.49 160 0 181.5 0 208S21.49 256 48 256S96 234.5 96 208c0-7.355-2.154-14.03-5.133-20.24l96.89-96.89C193.1 93.85 200.6 96 208 96c8.51 0 16.05-2.877 22.94-6.801l92.8 69.6C321.6 164.2 320 169.8 320 176C320 202.5 341.5 224 368 224S416 202.5 416 176c0-6.158-1.576-11.82-3.744-17.2L505.1 89.2zM528 32C536.8 32 544 39.18 544 48S536.8 64 528 64c-4.812 0-8.375-2.277-10.52-4.186l-1.934-1.725l-1.371-2.467C512.7 52.99 512 50.5 512 48C512 39.18 519.2 32 528 32zM48 224C39.18 224 32 216.8 32 208S39.18 192 48 192c3.287 0 6.379 1.014 9.188 3.014l2.219 1.58l1.58 2.219C62.99 201.6 64 204.7 64 208C64 216.8 56.82 224 48 224zM221.8 55.62L220.5 58.09L218.5 59.82C216.4 61.72 212.8 64 208 64C204.7 64 201.6 62.99 198.8 60.99L196.6 59.41L195 57.19C193 54.38 192 51.29 192 48C192 39.18 199.2 32 208 32S224 39.18 224 48C224 50.5 223.3 52.99 221.8 55.62zM368 192C359.2 192 352 184.8 352 176c0-2.496 .7129-4.99 2.178-7.623l1.371-2.467l1.934-1.725C359.6 162.3 363.2 160 368 160s8.375 2.277 10.52 4.186l1.934 1.725l1.371 2.467C383.3 171 384 173.5 384 176C384 184.8 376.8 192 368 192z"],
    "chart-network": [640, 512, [], "f78a", "M64 240c-28.28 0-64 21.84-64 64c0 35.25 28.75 64 64 64s64-28.75 64-64C128 262.1 92.68 240 64 240zM64 336c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S81.63 336 64 336zM184 288H167.1C159.2 288 152 295.2 152 303.1S159.2 320 167.1 320h16.05C192.8 320 200 312.8 200 304S192.8 288 184 288zM576 192c28.28 0 64-21.84 64-64c0-42.01-35.62-64-64-64c-28.28 0-64 21.84-64 64C512 163.3 540.8 192 576 192zM576 96c17.62 0 32 14.38 32 32s-14.38 32-32 32s-32-14.38-32-32S558.4 96 576 96zM576 384c-13.25 0-25.62 4-35.75 10.88c-3.375 2.25-6.375 4.75-9.125 7.5l-91.88-55.13C444.9 334 448 319.3 448 304C448 242.1 397.9 192 336 192c-11.25 0-21.88 2.25-32.25 5.25L264.5 113.1C278.8 101.4 288 83.88 288 64c0-41.93-35.32-64-64-64C182.1 0 160 35.31 160 64c0 35.25 28.75 64 64 64c4 0 7.875-.5 11.75-1.25l39 83.63C244.3 230.4 224 264.8 224 304c0 61.88 50.13 112 112 112c35 0 65.75-16.38 86.38-41.5l92.38 55.38C513.1 435.8 512 441.8 512 448c0 35.25 28.62 64 64 64C618.2 512 640 476.4 640 448C640 420.5 618.4 384 576 384zM224 96C206.4 96 192 81.63 192 64s14.38-32 32-32s32 14.38 32 32S241.6 96 224 96zM336 384C291.9 384 256 348.1 256 304S291.9 224 336 224S416 259.9 416 304S380.1 384 336 384zM576 480c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S593.6 480 576 480zM478.4 229.2l22.44-16.83c7.074-5.307 8.492-15.35 3.166-22.41c-5.305-7.025-15.29-8.436-22.34-3.154l-22.44 16.83c-7.074 5.305-8.492 15.35-3.166 22.4C461.3 233.1 471.3 234.5 478.4 229.2z"],
    "chart-pie": [576, 512, ["pie-chart"], "f200", "M559.7 288l-198.6 .0007c-14.25 0-21.39 17.23-11.31 27.31l130.7 130.7c4.601 4.602 14.48 7.847 22.24 .7343c38.61-36.49 65.24-85.63 73.12-140.9C577.2 296.4 569.3 288 559.7 288zM491.9 412.1L399.7 320h140.9C532.5 354.1 515.6 386 491.9 412.1zM256 288V50.75c0-8.875-7.12-16.25-15.74-16.25c-.6249 0-1.374 .019-2.124 .144c-119.1 16.88-210.2 120.1-205.1 245.7C36.52 407.5 145.1 512 272.1 512c.9999 0 1.876-.0074 2.876-.0074c50.5-.625 97-16.88 135.2-44c7.999-5.625 8.487-17.24 1.612-24.11L256 288zM274.6 480c-115.8 0-206.8-95.17-210.5-200.8C60.77 179.1 128.4 92.25 224 69.88v218.1c0 8.487 3.371 16.63 9.372 22.63l141.9 141.9C344.6 470.1 310.2 479.5 274.6 480zM543.1 223.2c-8.291-119.5-103.8-214.1-223.2-223.2c-10.61 0-16.76 8.179-16.76 16.24l.0023 207.7c0 8.837 7.163 16 16 16l207.7 .0017C536.9 240 544.6 232.4 543.1 223.2zM335.1 208V33.88C425.2 47.75 496.2 118.8 510.1 208H335.1z"],
    "chart-pie-simple": [512, 512, ["chart-pie-alt"], "f64e", "M464 256H256V48C256 39.16 248.8 32 240 32C107.7 32 0 139.7 0 272S107.6 512 239.1 512S480 404.3 480 272C480 263.2 472.8 256 464 256zM240 480C125.3 480 32 386.7 32 272c0-109.3 84.75-199.2 192-207.4V272C224 280.8 231.2 288 240 288h207.4C439.2 395.3 349.3 480 240 480zM304 0c-8.844 0-15.9 7.17-15.9 16.01L288 208C288 216.8 295.2 224 304 224l191.9 .0061C504.7 224 512 216.8 512 208C512 93.31 418.7 0 304 0zM320 192V32.72C404.3 40.34 471.7 107.7 479.3 192H320z"],
    "chart-pyramid": [512, 512, [], "e0e6", "M506.3 417l-213.3-364C284.8 39 270.4 32 255.1 32S227.2 39 218.1 53l-213.2 364C-10.59 444.9 9.852 480 42.74 480H469.3C502.1 480 522.6 445 506.3 417zM421.7 336H90.27l74.97-128h181.4L421.7 336zM246.5 69.21C249.2 64.68 253.6 64 255.1 64c2.363 0 6.715 .6641 9.348 5.18L327.9 176H183.1L246.5 69.21zM478.7 442.7C477.5 444.7 474.8 448 469.3 448H42.74c-5.531 0-8.258-3.318-9.393-5.295c-1.258-2.195-2.279-5.633 .0059-9.531L71.53 368h368.9l38.17 65.12C480.9 437.1 479.9 440.5 478.7 442.7z"],
    "chart-radar": [512, 512, [], "e0e7", "M320 272c-.6523 0-1.258 .168-1.904 .1934l-30.54-76.34C297.6 187 304 174.3 304 160c0-26.44-21.56-48-48-48S208 133.6 208 160c0 9.811 2.992 18.94 8.078 26.55L174.2 242.4C169.7 240.1 164.1 240 160 240C133.6 240 112 261.6 112 288s21.56 48 48 48c17.45 0 32.63-9.492 41.03-23.48l71.67 14.33C276.1 350 295.9 368 320 368c26.44 0 48-21.56 48-48S346.4 272 320 272zM160 304C151.2 304 144 296.8 144 288S151.2 272 160 272S176 279.2 176 288S168.8 304 160 304zM256 144c8.822 0 16 7.178 16 16S264.8 176 256 176S240 168.8 240 160S247.2 144 256 144zM278.1 295.5L207.3 281.2C206.3 273.1 203.8 267.2 199.9 261.4l41.88-55.84C246.3 207 251 208 256 208c.6484 0 1.252-.166 1.895-.1914l30.54 76.34C284.7 287.4 281.5 291.2 278.1 295.5zM320 336c-8.822 0-16-7.178-16-16s7.178-16 16-16s16 7.178 16 16S328.8 336 320 336zM505.8 233.4l-105.4-179.2C392.3 40.52 377.5 32 361.4 32H150.6C134.5 32 119.7 40.52 111.6 54.17l-105.4 179.2c-8.234 14-8.234 31.27 0 45.27l105.4 179.2C119.7 471.5 134.5 480 150.6 480h210.8c16.12 0 30.94-8.518 39.05-22.17l105.4-179.2C514.1 264.6 514.1 247.4 505.8 233.4zM478.2 262.4l-105.3 179.1C370.5 445.5 366.1 448 361.4 448H150.6c-4.729 0-9.152-2.498-11.47-6.391l-105.4-179.2c-2.361-4.016-2.361-8.809 0-12.82l105.3-179.1C141.5 66.5 145.9 64 150.6 64h210.8c4.73 0 9.154 2.498 11.47 6.387l105.4 179.2C480.6 253.6 480.6 258.4 478.2 262.4z"],
    "chart-scatter": [512, 512, [], "f7ee", "M288 280c13.25 0 24-10.75 24-24S301.3 232 288 232S264 242.8 264 256S274.8 280 288 280zM384 344c13.25 0 24-10.75 24-24S397.3 296 384 296S360 306.8 360 320S370.8 344 384 344zM416 152c13.25 0 24-10.75 24-24S429.3 104 416 104S392 114.8 392 128S402.8 152 416 152zM160 344c13.25 0 24-10.75 24-24S173.3 296 160 296S136 306.8 136 320S146.8 344 160 344zM192 184c13.25 0 24-10.75 24-24S205.3 136 192 136S168 146.8 168 160S178.8 184 192 184zM496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.16 24.84 32 16 32S0 39.16 0 48v352C0 444.1 35.88 480 80 480h416c8.844 0 16-7.156 16-16S504.8 448 496 448z"],
    "chart-scatter-3d": [512, 512, [], "e0e8", "M272 280.6V48C272 39.16 264.8 32 256 32S240 39.16 240 48v232.6l-202.3 171.2c-6.75 5.719-7.594 15.81-1.891 22.55c5.703 6.75 15.78 7.594 22.55 1.891L256 308.1l197.7 167.3C456.7 478.8 460.3 480 463.1 480c4.547 0 9.062-1.922 12.23-5.672c5.703-6.734 4.859-16.83-1.891-22.55L272 280.6zM32 96c17.67 0 32-14.33 32-32S49.67 32 32 32S0 46.33 0 64S14.33 96 32 96zM64 256c0-17.67-14.33-32-32-32S0 238.3 0 256s14.33 32 32 32S64 273.7 64 256zM128 192c17.67 0 32-14.33 32-32S145.7 128 128 128S96 142.3 96 160S110.3 192 128 192zM256 416c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S273.7 416 256 416zM384 288c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S366.3 288 384 288zM480 128c-17.67 0-32 14.33-32 32s14.33 32 32 32s32-14.33 32-32S497.7 128 480 128zM384 96c17.67 0 32-14.33 32-32s-14.33-32-32-32s-32 14.33-32 32S366.3 96 384 96z"],
    "chart-scatter-bubble": [512, 512, [], "e0e9", "M384 192c35.35 0 64-28.65 64-64s-28.65-64-64-64s-64 28.65-64 64S348.7 192 384 192zM384 96c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S366.4 96 384 96zM496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.17 24.83 32 16 32S0 39.17 0 48v352C0 444.1 35.88 480 80 480h416c8.828 0 16-7.172 16-16S504.8 448 496 448zM240 224C266.5 224 288 202.5 288 176S266.5 128 240 128S192 149.5 192 176S213.5 224 240 224zM240 160C248.8 160 256 167.2 256 176S248.8 192 240 192S224 184.8 224 176S231.2 160 240 160zM176 352C202.5 352 224 330.5 224 304S202.5 256 176 256S128 277.5 128 304S149.5 352 176 352zM176 288C184.8 288 192 295.2 192 304S184.8 320 176 320S160 312.8 160 304S167.2 288 176 288zM352 352c35.35 0 64-28.65 64-64s-28.65-64-64-64s-64 28.65-64 64S316.7 352 352 352zM352 256c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S334.4 256 352 256z"],
    "chart-tree-map": [512, 512, [], "e0ea", "M464 32h-160C277.5 32 256 53.49 256 80v32C256 138.5 277.5 160 304 160h160C490.5 160 512 138.5 512 112v-32C512 53.49 490.5 32 464 32zM480 112C480 120.8 472.8 128 464 128h-160C295.2 128 288 120.8 288 112v-32C288 71.18 295.2 64 304 64h160C472.8 64 480 71.18 480 80V112zM176 272h-128C21.49 272 0 293.5 0 320v112C0 458.5 21.49 480 48 480h128C202.5 480 224 458.5 224 432V320C224 293.5 202.5 272 176 272zM192 432C192 440.8 184.8 448 176 448h-128C39.18 448 32 440.8 32 432V320c0-8.822 7.178-16 16-16h128C184.8 304 192 311.2 192 320V432zM176 32h-128C21.49 32 0 53.49 0 80V192c0 26.51 21.49 48 48 48h128C202.5 240 224 218.5 224 192V80C224 53.49 202.5 32 176 32zM192 192c0 8.822-7.178 16-16 16h-128C39.18 208 32 200.8 32 192V80C32 71.18 39.18 64 48 64h128C184.8 64 192 71.18 192 80V192zM464 352h-160c-26.51 0-48 21.49-48 48v32c0 26.51 21.49 48 48 48h160c26.51 0 48-21.49 48-48v-32C512 373.5 490.5 352 464 352zM480 432c0 8.822-7.178 16-16 16h-160c-8.822 0-16-7.178-16-16v-32c0-8.822 7.178-16 16-16h160c8.822 0 16 7.178 16 16V432zM464 192h-160C277.5 192 256 213.5 256 240v32c0 26.51 21.49 48 48 48h160c26.51 0 48-21.49 48-48v-32C512 213.5 490.5 192 464 192zM480 272C480 280.8 472.8 288 464 288h-160C295.2 288 288 280.8 288 272v-32C288 231.2 295.2 224 304 224h160C472.8 224 480 231.2 480 240V272z"],
    "chart-user": [640, 512, ["user-chart"], "f6a3", "M160 320c53.02 0 96-42.98 96-96c0-53.02-42.98-96-96-96C106.1 128 64 170.1 64 224C64 277 106.1 320 160 320zM160 160c35.29 0 64 28.71 64 64S195.3 288 160 288S96 259.3 96 224S124.7 160 160 160zM592 0h-384C181.5 0 160 21.53 160 48v32C160 88.84 167.2 96 176 96S192 88.84 192 80v-32C192 39.19 199.2 32 208 32h384C600.8 32 608 39.19 608 48v320c0 8.812-7.172 16-16 16H352c-8.844 0-16 7.156-16 16S343.2 416 352 416h240C618.5 416 640 394.5 640 368v-320C640 21.53 618.5 0 592 0zM192 352H128c-70.69 0-128 57.31-128 128c0 17.67 14.33 32 32 32h256c17.67 0 32-14.33 32-32C320 409.3 262.7 352 192 352zM32 480c0-52.94 43.07-96 96-96h64c52.94 0 96 43.06 96 96H32zM315.3 164.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l80 80C375.8 270.4 379.9 272 384 272s8.188-1.562 11.31-4.688L496 166.6V224c0 8.844 7.156 16 16 16s16-7.156 16-16V128c0-8.844-7.156-16-16-16h-96c-8.844 0-16 7.156-16 16s7.156 16 16 16h57.38L384 233.4L315.3 164.7z"],
    "chart-waterfall": [512, 512, [], "e0eb", "M256 256c8.828 0 16-7.172 16-16v-96C272 135.2 264.8 128 256 128S240 135.2 240 144v96C240 248.8 247.2 256 256 256zM352 192c8.828 0 16-7.172 16-16v-96C368 71.17 360.8 64 352 64s-16 7.172-16 16v96C336 184.8 343.2 192 352 192zM160 352c8.828 0 16-7.172 16-16v-96C176 231.2 168.8 224 160 224S144 231.2 144 240v96C144 344.8 151.2 352 160 352zM496 448h-416C53.53 448 32 426.5 32 400v-352C32 39.17 24.83 32 16 32S0 39.17 0 48v352C0 444.1 35.88 480 80 480h416c8.828 0 16-7.172 16-16S504.8 448 496 448zM448 352c8.828 0 16-7.172 16-16v-256C464 71.17 456.8 64 448 64s-16 7.172-16 16v256C432 344.8 439.2 352 448 352z"],
    "check": [512, 512, [10004, 61452], "2713", "M475.3 123.3l-272 272C200.2 398.4 196.1 400 192 400s-8.188-1.562-11.31-4.688l-144-144c-6.25-6.25-6.25-16.38 0-22.62s16.38-6.25 22.62 0L192 361.4l260.7-260.7c6.25-6.25 16.38-6.25 22.62 0S481.6 117.1 475.3 123.3z"],
    "check-double": [512, 512, [], "f560", "M475.3 164.7c-6.25-6.25-16.38-6.25-22.62 0L192 425.4L59.31 292.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l144 144C183.8 462.4 187.9 464 192 464s8.188-1.562 11.31-4.688l272-272C481.6 181.1 481.6 170.9 475.3 164.7zM180.7 235.3C183.8 238.4 187.9 240 192 240s8.188-1.562 11.31-4.688l176-176c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L192 201.4L123.3 132.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L180.7 235.3z"],
    "check-to-slot": [576, 512, ["vote-yea"], "f772", "M355.3 134.3L267.9 248.7l-49.34-43.5C211.9 199.3 201.8 199.1 196 206.6C190.2 213.2 190.8 223.3 197.4 229.2L259.6 284C262.6 286.6 266.3 288 270.2 288c.5313 0 1.206 .0187 1.737-.0125c4.406-.4375 8.294-2.737 10.98-6.269l97.78-128c5.375-7.031 4.031-17.06-3-22.44C370.7 125.9 360.7 127.2 355.3 134.3zM528 320c-8.844 0-16 7.156-16 16s7.156 16 16 16c8.812 0 16 7.172 16 16v64c0 8.828-7.188 16-16 16h-480C39.19 448 32 440.8 32 432v-64C32 359.2 39.19 352 48 352C56.84 352 64 344.8 64 336S56.84 320 48 320C21.53 320 0 341.5 0 368v64C0 458.5 21.53 480 48 480h480c26.47 0 48-21.53 48-48v-64C576 341.5 554.5 320 528 320zM80 416h416c8.836 0 16-7.164 16-16S504.8 384 496 384H480V80C480 53.49 458.5 32 432 32h-288C117.5 32 96 53.49 96 80V384H80C71.16 384 64 391.2 64 400S71.16 416 80 416zM128 80C128 71.16 135.2 64 144 64h288C440.8 64 448 71.16 448 80V384H128V80z"],
    "cheese": [512, 512, [], "f7ef", "M299.9 32.01L298.4 32c-7.125 .125-14.13 2.508-19.62 7.008L12.3 246.3C4.505 252.4 0 261.7 0 271.5v176.5C0 465.6 14.4 480 32 480h448c17.6 0 32-14.4 32-31.1V255.1C512 136.1 417.1 38.26 299.9 32.01zM480 448H32V287.9h448V448zM52.12 255.9L298.8 64C400.4 69.62 480 153.8 480 255.9H52.12z"],
    "cheese-swiss": [512, 512, [63472], "1f9c0", "M176 319.9c-26.5 0-48 21.5-48 48s21.5 48 48 48s48-21.5 48-48S202.5 319.9 176 319.9zM187.4 379.3C184.4 382.3 180.3 384 176 384C167.1 384 160 376.8 160 367.9c0-8.75 7.125-16 16-16s16 7.25 16 16C192 372.1 190.4 376.3 187.4 379.3zM299.9 32.01L298.4 32c-7.125 .125-14.12 2.508-19.62 7.008L12.3 246.3C4.504 252.4 0 261.7 0 271.5v176.5C0 465.6 14.4 480 32 480h448c17.6 0 32-14.4 32-31.1V255.1C512 136.1 417.1 38.26 299.9 32.01zM240 127.8c8.875 0 16 7.25 16 16c0 8.875-7.125 16-16 16s-16-7.125-16-16C224 135 231.1 127.8 240 127.8zM480 448H32V287.9h291c6.625 19.12 24.75 32 45 32s38.38-12.88 45-32H480V448zM352 271.9c0-8.875 7.125-16 16-16s16 7.125 16 16s-7.125 16-16 16S352 280.8 352 271.9zM413 255.9C406.4 236.8 388.3 223.9 368 223.9s-38.38 12.87-45 31.1H52.13l140.1-109C193.8 171 213 190.3 237.1 191.8s45.63-15.25 50-39c4.5-23.75-9.375-47.13-32.5-54.5L298.6 64C400.4 69.63 480 153.8 480 255.9H413z"],
    "cherries": [640, 512, [], "e0ec", "M532.2 224.3c-19.52 0-42.82 3.748-70.4 13.42c-36.15-148.4-164.5-237.7-173.9-237.7c-33.7 0-7.135 110.2-108.2 238.2c-28.25-10.07-52.05-13.96-71.92-13.96c-101.3 0-107.8 92.77-107.8 109.8c0 25.75 24.51 177.1 191.1 177.1c166.5 0 192-149.8 192-177.1c0-60.31-37.04-109.8-107.1-109.8c-14.55 0-31.21 2.081-50.16 7.144c21-30.87 51.75-89.18 72.74-186.8c34.06 28.62 102.5 96.3 129.1 190.9c-4.815-1.562-7.542-3.2-11.74-3.2c-6.875 0-13.28 4.537-15.33 11.47c-.4472 1.515-.6604 3.044-.6604 4.547c0 15.88 13.45 14.29 41.72 26.34l6.281 2.672L454.3 274.6c29.25-12.46 55.35-18.72 77.51-18.72c1.816 0 76.22-3.583 76.22 78.16C607.1 355.9 586.6 480 447.1 480c-39.31 0-56.87-10.43-64-10.43c-8.905 0-15.1 7.252-15.1 16.05c0 6.604 4.133 12.78 10.72 15.07c21.53 7.5 44.79 11.31 69.23 11.31c166.5 0 192.1-149.8 192.1-177.1C640 316.8 633.4 224.3 532.2 224.3zM275.8 255.9c1.816 0 76.21-3.585 76.21 78.16C352 355.9 330.6 480 192 480c-139.2 0-160-123.7-160-145.9c0-69.41 53.07-78.16 76.23-78.16c22.16 0 48.25 6.25 77.5 18.72l6.281 2.672L198.3 274.6C227.5 262.1 253.6 255.9 275.8 255.9z"],
    "chess": [512, 512, [], "f439", "M498.6 428.4L480 419.1V408c0-13.23-10.77-24-24-24h-112C330.8 384 320 394.8 320 408v11.06l-18.58 9.344C293.3 432.3 288 440.7 288 449.9V488c0 13.23 10.77 24 24 24h176c13.23 0 24-10.77 24-24v-38.13C512 440.8 506.8 432.3 498.6 428.4zM480 480h-160v-25.12l32-16.09V416h96v22.79l32 16.09V480zM56.88 224H48.97C40.1 224 33.55 229.4 32.23 237.3C30.55 247.3 38.3 256 48 256h16.01L64 284.5c-.0625 16.62-1.307 33.16-3.266 49.62C59.6 343.6 67.06 352 76.65 352c8.205 0 15.02-6.195 15.97-14.35C94.69 320 96 302.3 96 284.5V256h64v28.5c0 17.82 1.312 35.53 3.377 53.15C164.3 345.8 171.1 352 179.3 352c9.592 0 17.05-8.355 15.92-17.88C193.3 317.7 192.1 301.1 192 284.5L192 256h15.02c7.979 0 15.42-5.4 16.74-13.27C225.4 232.7 217.7 224 208 224H199.1l31.75-84.75c5.197-13.69 .5488-29.54-12.61-38.22C212.1 97.53 206.6 96 200.2 96H144V64h15.02c7.979 0 15.42-5.4 16.74-13.27C177.4 40.74 169.7 32 160 32h-16L144 16.97c0-7.979-5.4-15.42-13.27-16.74C120.7-1.449 112 6.303 112 16V32H96.86C88.88 32 81.55 37.4 80.23 45.26C78.55 55.26 86.31 64 96.01 64h16v32H55.77C49.42 96 43.03 97.53 37.73 101c-13.16 8.689-17.81 24.54-12.61 38.22L56.88 224zM201 128l-36 96H91.13l-36-96H201zM242.6 428.4L224 419.1V408C224 394.8 213.2 384 200 384h-144C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h208C245.2 512 256 501.2 256 488v-38.13C256 440.8 250.8 432.3 242.6 428.4zM224 480H32v-25.12l32-16.09V416h128v22.79l32 16.09V480zM496 160h-192C295.2 160 288 167.2 288 176V256c0 5.344 2.672 10.34 7.125 13.31L336 296.6V352c0 8.844 7.156 16 16 16s16-7.156 16-16V288c0-5.344-2.672-10.34-7.125-13.31L320 247.4V192h32v16C352 216.8 359.2 224 368 224S384 216.8 384 208V192h32v16C416 216.8 423.2 224 432 224S448 216.8 448 208V192h32v55.44l-40.88 27.25C434.7 277.7 432 282.7 432 288v64c0 8.844 7.156 16 16 16s16-7.156 16-16V296.6l40.88-27.25C509.3 266.3 512 261.3 512 256V176C512 167.2 504.8 160 496 160z"],
    "chess-bishop": [320, 512, [62522], "265d", "M64 372V400C64 408.8 71.16 416 80 416S96 408.8 96 400v-40.01c0-7.115-4.699-13.38-11.53-15.36l-11.53-3.354C53.15 335.5 32 317.4 32 284C32 231.4 86.32 136.9 130.8 96h58.41c20.15 18.54 42.11 48.19 60.34 79.84l-84.85 84.85c-6.25 6.25-6.25 16.38 0 22.62C167.8 286.4 171.9 288 176 288s8.188-1.562 11.31-4.688l77.83-77.83C278.8 234.3 288 262.6 288 284c0 33.45-21.15 51.52-40.94 57.27l-11.53 3.354C228.7 346.6 224 352.9 224 359.1V400c0 8.836 7.164 16 16 16s16-7.164 16-16v-28c33.88-9.854 64-40.68 64-88C320 217.4 253.6 105.6 201 64h-82C66.38 105.6 0 217.4 0 284C0 331.3 30.13 362.1 64 372zM112 32h96C216.9 32 224 24.88 224 16S216.9 0 208 0h-96C103.1 0 96 7.125 96 16S103.1 32 112 32zM272 448h-224C21.53 448 0 469.5 0 496C0 504.8 7.156 512 16 512S32 504.8 32 496C32 487.2 39.17 480 48 480h224c8.828 0 16 7.188 16 16c0 8.844 7.156 16 16 16s16-7.156 16-16C320 469.5 298.5 448 272 448z"],
    "chess-bishop-piece": [256, 512, ["chess-bishop-alt"], "f43b", "M242.6 428.4L224 419.1V408c0-13.23-10.77-24-24-24h-144C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h208c13.23 0 24-10.77 24-24v-38.13C256 440.8 250.8 432.3 242.6 428.4zM224 480H32v-25.12l32-16.09V416h128v22.79l32 16.09V480zM48 240C48 248.8 55.16 256 64 256h15.69l-15.38 76.88c-1.734 8.656 3.891 17.09 12.55 18.81C77.92 351.9 78.98 352 80.02 352c7.469 0 14.16-5.25 15.67-12.88l16-80C111.9 258.1 111.7 257 111.7 256h32.64c-.002 1.047-.2187 2.061-.0059 3.125l16 80C161.8 346.8 168.5 352 175.1 352c1.031 0 2.094-.0938 3.156-.3125c8.656-1.719 14.28-10.16 12.55-18.81L176.3 256H192c8.836 0 16-7.164 16-16c0-8.627-6.865-15.55-15.41-15.88c9.326-14.97 14.84-31.32 15.36-49.28c1.273-43.54-24.55-85.35-44.97-111.4C170.3 61.96 176 55.78 176 48C176 39.16 168.8 32 160 32H96C87.16 32 80 39.16 80 48c0 7.779 5.662 13.96 13.02 15.4c-20.42 26.09-46.25 67.9-44.97 111.4c.5234 17.96 6.035 34.3 15.36 49.28C54.87 224.4 48 231.4 48 240zM128 71.38c7.826 8.93 18.48 22.46 27.81 38.19L124.7 140.7c-6.25 6.25-6.25 16.38 0 22.62C127.8 166.4 131.9 168 136 168s8.188-1.562 11.31-4.688l22.94-22.94c3.719 10.98 6.059 22.31 5.717 33.6C175.4 193.1 167.6 209.5 152.2 224H103.8C88.41 209.5 80.61 193.1 80.03 173.1C78.8 133.3 110.6 91.25 128 71.38z"],
    "chess-board": [448, 512, [], "f43c", "M352 112H96C87.16 112 80 119.2 80 128v256c0 8.836 7.164 16 16 16h256c8.836 0 16-7.164 16-16V128C368 119.2 360.8 112 352 112zM144 368h-32v-32h32V368zM144 304h-32v-32h32V304zM144 240h-32v-32h32V240zM144 176h-32v-32h32V176zM208 368h-32v-32h32V368zM208 304h-32v-32h32V304zM208 240h-32v-32h32V240zM208 176h-32v-32h32V176zM272 368h-32v-32h32V368zM272 304h-32v-32h32V304zM272 240h-32v-32h32V240zM272 176h-32v-32h32V176zM336 368h-32v-32h32V368zM336 304h-32v-32h32V304zM336 240h-32v-32h32V240zM336 176h-32v-32h32V176zM384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 60.65 419.3 32 384 32zM416 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V416z"],
    "chess-clock": [640, 512, [], "f43d", "M400 96h128C536.8 96 544 88.84 544 80S536.8 64 528 64h-128C391.2 64 384 71.16 384 80S391.2 96 400 96zM464 192C402.1 192 352 242.1 352 304s50.14 112 112 112S576 365.9 576 304S525.9 192 464 192zM520.6 360.6c-31.19 31.19-81.95 31.19-113.1 0s-31.19-81.95 0-113.1c27.32-27.32 69.63-30.7 100.7-10.17l-55.42 55.43c-6.252 6.254-6.253 16.37-.0013 22.63c6.254 6.254 16.37 6.254 22.63 0l55.43-55.42C551.3 290.9 547.9 333.3 520.6 360.6zM176 192C114.1 192 64 242.1 64 304S114.1 416 176 416S288 365.9 288 304S237.9 192 176 192zM176 384C131.9 384 96 348.1 96 304c0-38.63 27.53-70.95 64-78.38V304C160 312.8 167.2 320 176 320S192 312.8 192 304V225.6C228.5 233.1 256 265.4 256 304C256 348.1 220.1 384 176 384zM560 128H192V64h48c8.844 0 16.08-7.156 16.08-16S248.9 32 240.1 32H112.1c-8.844 0-16 7.156-16 16S103.2 64 112 64H160v64H80C35.82 128 0 163.8 0 208v192C0 444.2 35.82 480 80 480h480c44.18 0 80-35.82 80-80V207.1C640 163.8 604.2 128 560 128zM608 400c0 26.51-21.49 48-48 48h-480C53.49 448 32 426.5 32 400v-192C32 181.5 53.49 160 80 160h480C586.5 160 608 181.5 608 208V400z"],
    "chess-clock-flip": [640, 512, ["chess-clock-alt"], "f43e", "M256 80C256 71.16 248.8 64 240 64h-128C103.2 64 96 71.16 96 80S103.1 96 111.1 96h128C248.8 96 256 88.84 256 80zM463.9 192c-61.86 0-112 50.18-112 112S402.1 416 463.9 416s112-50.08 112-111.9S525.8 192 463.9 192zM464 384c-44.11 0-80-35.89-80-80c0-38.63 27.53-70.95 64-78.38V304c0 8.844 7.156 16 16 16S480 312.8 480 304V225.6C516.5 233.1 544 265.4 544 304C544 348.1 508.1 384 464 384zM0 207.1L0 400C0 444.2 35.82 480 80 480h480c44.18 0 80-35.82 80-80V207.1C640 163.8 604.2 128 560 128H480V64h48c8.844 0 15.96-7.156 15.96-16s-7.156-16-16-16h-127.1c-8.844 0-16 7.156-16 16S391.2 64 400 64H448v64H80C35.82 128 0 163.8 0 207.1zM32 208C32 181.5 53.49 160 80 160h480C586.5 160 608 181.5 608 208v192c0 26.51-21.49 48-48 48h-480C53.49 448 32 426.5 32 400V208zM176 192C114.1 192 63.94 242.1 63.94 304s50.14 112 112 112s112-50.12 112-111.1S237.9 192 176 192zM232.6 360.6c-31.19 31.19-81.95 31.19-113.1 0s-31.19-81.95 0-113.1C146.7 220.1 189.1 216.7 220.1 237.3L164.7 292.7C158.4 298.9 158.4 309.1 164.7 315.3c6.254 6.254 16.37 6.254 22.63 0L242.7 259.9C263.3 290.9 259.9 333.3 232.6 360.6z"],
    "chess-king": [448, 512, [62527], "265a", "M367.1 448H79.97c-26.47 0-48.01 21.53-48.01 47.1C31.96 504.8 39.12 512 47.96 512S64 504.8 64 496C64 487.2 71.17 480 80 480h288c8.828 0 16 7.188 16 16c0 8.844 7.171 16 16.01 16s16-7.156 16-16C416 469.5 394.5 448 367.1 448zM423.2 180.2C414.2 167.6 399.7 160 384.2 160H240V96H288c8.844 0 15.99-7.157 15.99-16S296.8 64 288 64h-48V16c0-8.844-7.172-16-16.02-16S208 7.156 208 16V64H160C151.2 64 143.1 71.16 143.1 80S151.2 96 160 96h48v64H63.81C48.34 160 33.78 167.6 24.83 180.2C15.83 193 13.58 209.4 18.73 223.9l61.72 181.3c2.859 8.375 11.94 12.75 20.3 10c8.359-2.844 12.84-11.94 9.984-20.31L48.95 213.4C45.13 202.6 53.27 192 63.81 192h320.4c10.6 0 18.66 10.66 14.86 21.41l-64.28 181.3c-2.953 8.312 1.406 17.47 9.734 20.44c11.23 3.977 18.65-4.749 20.42-9.75l64.28-181.3C434.4 209.4 432.2 193 423.2 180.2z"],
    "chess-king-piece": [256, 512, ["chess-king-alt"], "f440", "M56.88 224H48.97C40.1 224 33.55 229.4 32.23 237.3C30.55 247.3 38.3 256 48 256h16.01L64 284.5c-.0625 16.62-1.307 33.16-3.266 49.62C59.6 343.6 67.06 352 76.65 352c8.205 0 15.02-6.195 15.97-14.35C94.69 320 96 302.3 96 284.5V256h64v28.5c0 17.82 1.312 35.53 3.377 53.15C164.3 345.8 171.1 352 179.3 352c9.592 0 17.05-8.355 15.92-17.88C193.3 317.7 192.1 301.1 192 284.5L192 256h15.02c7.979 0 15.42-5.4 16.74-13.27C225.4 232.7 217.7 224 208 224h-8.882l31.75-84.75c5.197-13.69 .5488-29.54-12.61-38.22C212.1 97.53 206.6 96 200.2 96h-56.23V64h15.02c7.979 0 15.42-5.4 16.74-13.27C177.4 40.74 169.7 32 160 32h-16L144 16.97c0-7.979-5.4-15.42-13.27-16.74C120.7-1.449 112 6.303 112 16V32H96.86C88.88 32 81.55 37.4 80.23 45.26C78.55 55.26 86.31 64 96.01 64h16v32H55.77C49.42 96 43.03 97.53 37.73 101c-13.16 8.689-17.81 24.54-12.61 38.22L56.88 224zM201 128l-36 96H91.13l-36-96H201zM242.6 428.4L224 419.1V408c0-13.23-10.77-24-24-24h-144C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h208c13.23 0 24-10.77 24-24v-38.13C256 440.8 250.8 432.3 242.6 428.4zM224 480H32v-25.12l32-16.09V416h128v22.79l32 16.09V480z"],
    "chess-knight": [384, 512, [62529], "265e", "M64 164C64 175 73 184 84 184S104 175 104 164S95 144 84 144S64 153 64 164zM35.5 301.6c38 16.88 36.75 16.5 40.38 17.75C28.77 351.3 32.06 387.4 32.06 400c0 8.836 7.102 16 15.94 16S64 408.8 64 400c0-39.61 11.33-43.32 80.63-84c14.12-7 23-21.5 23-37.25V216.5L151.5 226.1C145.1 228.9 141.1 233.8 140.6 239.8l-8 26.5C130.2 274.4 124.1 280.1 116.2 284.1L105 288.5C98.11 291.2 90.4 291 83.63 288L48.5 272.4C38.5 268 32 258 32 247V128c0-10.38 6.5-15 13.88-22.5L33.5 81C28.88 71.63 35.13 64 42.38 64H128c106 0 192 85.96 192 192v144c0 8.836 7.164 16 16 16s16-7.164 16-16V256c0-123.7-100.3-224-224-224H44.34C22.92 32 3.344 47.03 .4199 68.24C-.8652 77.57 .8359 86.92 5 95.25l2.625 5.5C2.625 109 0 118.4 0 128.1v119C0 270.6 13.88 292 35.5 301.6zM336 448H47.1C21.53 448 0 469.5 0 495.1C0 504.8 7.156 512 16 512S32 504.8 32 496C32 487.2 39.19 480 48 480h288c8.812 0 16 7.188 16 16c0 8.844 7.156 16 16 16s16-7.156 16-16C384 469.5 362.5 448 336 448z"],
    "chess-knight-piece": [320, 512, ["chess-knight-alt"], "f442", "M31.63 277.3l26.62 12c-10.76 11.61-19.88 26.13-23.74 44.05C32.43 342.1 40.24 352 50.14 352c7.393 0 13.8-5.125 15.42-12.34c10.53-47.06 79.07-59.02 79.07-89.41V207.5l-21.25 5c-4.125 2.125-7.125 6-8.25 10.5L109 243.4C107.1 249.6 102.5 254.6 96.5 257L88 260.4c-5.25 2.125-11.25 2-16.5-.25l-26.88-12C37 244.6 32 237 32 228.6V145.3c0-4.322 1.717-8.467 4.773-11.52l5.852-5.852L33.25 109C32.38 107.5 32 105.8 32 104C32 99.63 35.63 96 40 96h86.13C197.6 96 256 154.4 256 225.9v110.3C256 344.9 263.2 352 271.1 352S288 344.9 288 336.1V225.9C288 136.5 215.5 64 126.1 64H41.8C19.85 64 .6172 80.9 .0156 102.8C-.1797 110 1.461 116.9 4.5 123.3L4.875 124C1.625 130.6 0 137.9 0 145.3v83.38C0 249.6 12.38 268.8 31.63 277.3zM61.1 170.8c0 8.25 6.625 14.88 14.88 14.88s14.88-6.75 14.88-15c0-8.125-6.75-14.75-14.88-14.75C68.63 155.9 61.1 162.5 61.1 170.8zM306.6 428.4L288 419.1V408c0-13.23-10.77-24-24-24h-208C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h272c13.23 0 24-10.77 24-24v-38.13C320 440.8 314.8 432.3 306.6 428.4zM288 480H32v-25.12l32-16.09V416h192v22.79l32 16.09V480z"],
    "chess-pawn": [320, 512, [62531], "265f", "M272 448H47.1C21.53 448 0 469.5 0 495.1C0 504.8 7.156 512 16 512S32 504.8 32 496C32 487.2 39.19 480 48 480h224c8.812 0 16 7.188 16 16c0 8.844 7.156 16 16 16s16-7.156 16-16C320 469.5 298.5 448 272 448zM80 208C71.16 208 64 215.2 64 224s7.156 16 16 16h19.97l-35.56 156.5C62.22 406 69.3 416 80 416c7.312 0 13.91-5.031 15.59-12.47L132.8 240h54.48l37.17 163.5C226.1 410.1 232.7 416 240 416c10.91 0 17.74-10.18 15.59-19.53L220 240H240C248.8 240 256 232.8 256 224s-7.156-16-16-16h-5.254C252.8 189.3 264 163.1 264 136C264 78.66 217.3 32 159.1 32S56 78.66 56 136c0 27.97 11.23 53.29 29.25 72H80zM160 64c39.69 0 72 32.31 72 72S199.7 208 160 208S88 175.7 88 136S120.3 64 160 64z"],
    "chess-pawn-piece": [256, 512, ["chess-pawn-alt"], "f444", "M242.6 428.4L224 419.1V408c0-13.23-10.77-24-24-24h-144C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h208c13.23 0 24-10.77 24-24v-38.13C256 440.8 250.8 432.3 242.6 428.4zM224 480H32v-25.12l32-16.09V416h128v22.79l32 16.09V480zM48 240C48 248.8 55.16 256 64 256h13.12l-12.9 77.38c-1.469 8.719 4.438 16.97 13.16 18.41C78.25 351.9 79.16 352 80.03 352c7.656 0 14.44-5.531 15.75-13.38L109.6 256h36.89l13.77 82.63C161.5 346.5 168.3 352 175.1 352c.875 0 1.781-.0625 2.656-.2187c8.719-1.438 14.62-9.688 13.16-18.41L178.9 256H192c8.838 0 16-7.164 16-16S200.8 224 192 224h-.3613c10.13-13.4 16.36-29.94 16.36-48.03C208 131.8 172.2 96 127.1 96C83.79 96 47.1 131.8 47.1 175.1c0 18.09 6.234 34.63 16.36 48.03H64C55.16 224 48 231.2 48 240zM128 128c26.47 0 48 21.53 48 48S154.5 224 128 224S80 202.5 80 176S101.5 128 128 128z"],
    "chess-queen": [512, 512, [62533], "265b", "M399.1 448H111.1c-26.47 0-48 21.53-48 47.1C63.98 504.8 71.14 512 79.98 512S96 504.8 96 496C96 487.2 103.2 480 112 480h288c8.812 0 16 7.188 16 16c0 8.844 7.153 16 15.1 16s16-7.156 16-16C447.1 469.5 426.5 448 399.1 448zM481.7 179.9l-23.84-13.41c-13.47-9.094-31.19-5.75-41.28 7.812c-5.938 7.969-15.84 11.94-25.56 10.06c-11.97-2.25-20.97-14.5-20.97-28.53C369.1 140.5 357.6 128 342.3 128h-33.91c-13 0-24.34 9.031-26.94 21.5C278.8 161.9 268.4 170.7 256 170.7S233.2 161.9 230.5 149.5C227.9 137 216.6 128 203.6 128H169.7C154.4 128 141.1 140.5 141.1 155.9c0 15.03-10.84 28.03-24.19 28.94C109.2 185.9 100.7 181.5 95.47 174.4C85.53 160.7 67.41 157.4 55.34 165.9L29.44 180.6C16.78 188.9 12.34 205.5 19.06 219l89.72 187.9c3.812 7.938 13.28 11.28 21.34 7.531c7.969-3.812 11.34-13.34 7.531-21.34L48.5 206.4l21.12-13.16c11.84 16.09 30.5 24.97 50.44 23.47C149 214.7 171.9 190.2 173.9 160h26.31C207.3 185.3 229.7 202.7 256 202.7c26.31 0 48.75-17.34 55.81-42.66h26.31c1.75 27.84 20.94 51 46.81 55.81c21.5 4.219 44.06-4.531 56.03-22.09l23.09 11.5l-89.72 187.9c-3.812 8-.4375 17.53 7.531 21.34C384.1 415.5 386.5 416 388.8 416c5.969 0 11.69-3.344 14.44-9.094l89.66-187.8C499.5 205.6 495.2 189 481.7 179.9zM256 112c30.93 0 56-25.07 56-56S286.9 0 256 0S199.1 25.07 199.1 56S225.1 112 256 112zM256 32c13.23 0 24 10.77 24 24c0 13.23-10.77 24-24 24S232 69.23 232 56C232 42.77 242.8 32 256 32z"],
    "chess-queen-piece": [256, 512, ["chess-queen-alt"], "f446", "M128 48c13.25 0 24-10.75 24-24S141.3 0 128 0S104 10.75 104 24S114.8 48 128 48zM242.6 428.4L224 419.1V408c0-13.23-10.77-24-24-24h-144C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h208c13.23 0 24-10.77 24-24v-38.13C256 440.8 250.8 432.3 242.6 428.4zM224 480H32v-25.12l32-16.09V416h128v22.79l32 16.09V480zM62.38 224H48C39.2 224 32 231.2 32 240C32 248.8 39.2 256 48 256H64v28.5c-.0625 16.64-1.307 33.17-3.266 49.62C59.6 343.6 67.06 352 76.65 352c8.207 0 15.02-6.195 15.97-14.35C94.69 320 96 302.3 96 284.5V256h64v28.5c0 17.82 1.312 35.53 3.377 53.15C164.3 345.8 171.1 352 179.4 352c9.592 0 17.05-8.359 15.91-17.88C193.3 317.7 192.1 301.1 192 284.5V256h16C216.8 256 224 248.8 224 240C224 231.2 216.8 224 208 224h-14.38l50.88-124.3c1.75-3.375 .625-7.5-2.5-9.5l-11.12-7.5C226.3 79.99 222.1 82.79 220.5 85c-12.76 16.89-40.25 8.504-40.25-14.75C180.3 66.34 176.8 64 173.1 64h-18.12c-2.75-.125-5.25 1.875-6 4.625C147.8 79 138.6 86.38 128 86.38S108.3 79 106.1 68.63C105.4 65.88 102.9 63.88 100.1 64H81.1C78.43 64 75.79 66.96 75.75 70.53C75.48 93.34 48.05 101.1 35.5 84.88c-1.057-1.41-5.088-5.299-10.38-2.125l-11.13 7.5c-3.125 2-4.25 6.125-2.5 9.5L62.38 224zM56.75 125.8c14.5-1 28.25-7.875 37.63-19c19.62 15.62 47.5 15.62 67.13 .125c12.19 14.47 28.33 18.48 37.75 19L159 224h-62L56.75 125.8z"],
    "chess-rook": [384, 512, [62535], "265c", "M336 32h-288C21.53 32 0 53.53 0 80V192c0 4.25 1.688 8.312 4.688 11.31l59.28 59.34c0 38.89 1.065 64.09-10.44 134.8c-1.438 8.719 4.5 16.94 13.22 18.34c8.5 1.469 16.94-4.469 18.34-13.22C96.1 329.5 96.05 303.5 95.94 256c0-4.25-1.688-8.312-4.688-11.31L32 185.4V80C32 71.19 39.19 64 48 64h64v64c0 8.836 7.164 16 16 16S144 136.8 144 128V64h96v64c0 8.836 7.164 16 16 16s16-7.164 16-16V64h64C344.8 64 352 71.19 352 80v105.4l-59.25 59.31C289.8 247.7 288.1 251.8 288.1 256c-.115 48.52-.9936 73.91 10.84 146.6c2.209 13.58 15.63 13.7 18.34 13.22c8.719-1.406 14.66-9.625 13.22-18.34c-11.47-70.51-10.44-96.19-10.44-134.8l59.28-59.34C382.3 200.3 384 196.3 384 192V80C384 53.53 362.5 32 336 32zM336 448H47.1C21.53 448 0 469.5 0 495.1C0 504.8 7.156 512 16 512S32 504.8 32 496C32 487.2 39.19 480 48 480h288c8.812 0 16 7.188 16 16c0 8.844 7.156 16 16 16s16-7.156 16-16C384 469.5 362.5 448 336 448zM224 320c8.844 0 16-7.156 16-16v-64C240 213.5 218.5 192 192 192S144 213.5 144 240v64C144 312.8 151.2 320 160 320H224zM176 240C176 231.2 183.2 224 192 224s16 7.188 16 16V288h-32V240z"],
    "chess-rook-piece": [320, 512, ["chess-rook-alt"], "f448", "M306.6 428.4L288 419.1V408c0-13.23-10.77-24-24-24h-208C42.77 384 32 394.8 32 408v11.06l-18.58 9.344C5.266 432.3 0 440.7 0 449.9V488C0 501.2 10.77 512 24 512h272c13.23 0 24-10.77 24-24v-38.13C320 440.8 314.8 432.3 306.6 428.4zM288 480H32v-25.12l32-16.09V416h192v22.79l32 16.09V480zM71.28 232.4l-7.25 102.4c-.625 8.812 6.031 16.47 14.84 17.09C79.25 352 79.63 352 80.03 352c8.312 0 15.34-6.438 15.94-14.88l8.25-116.8L68.56 183.9C65.63 181 64 177.1 64 172.9V96h48v32c0 8.836 7.164 16 16 16S144 136.8 144 128V96h32v32c0 8.836 7.164 16 16 16s16-7.164 16-16V96H256v76.75c0 4.281-1.625 8.25-4.656 11.28l-35.56 36.16l8.25 116.9c.625 8.844 9 15.62 17.09 14.84c8.812-.625 15.47-8.281 14.84-17.09l-7.25-102.6l25.34-25.75C283.1 197.6 288 185.6 288 172.8V88C288 74.78 277.2 64 264 64h-208C42.78 64 32 74.78 32 88v84.88c0 12.75 4.938 24.69 13.81 33.56L71.28 232.4zM144 224v32h32V224c0-8.838-7.164-16-16-16S144 215.2 144 224z"],
    "chevron-down": [448, 512, [], "f078", "M4.251 181.1C7.392 177.7 11.69 175.1 16 175.1c3.891 0 7.781 1.406 10.86 4.25l197.1 181.1l197.1-181.1c6.5-6 16.64-5.625 22.61 .9062c6 6.5 5.594 16.59-.8906 22.59l-208 192c-6.156 5.688-15.56 5.688-21.72 0l-208-192C-1.343 197.7-1.749 187.6 4.251 181.1z"],
    "chevron-left": [320, 512, [61523], "2329", "M234.8 36.25c3.438 3.141 5.156 7.438 5.156 11.75c0 3.891-1.406 7.781-4.25 10.86L53.77 256l181.1 197.1c6 6.5 5.625 16.64-.9062 22.61c-6.5 6-16.59 5.594-22.59-.8906l-192-208c-5.688-6.156-5.688-15.56 0-21.72l192-208C218.2 30.66 228.3 30.25 234.8 36.25z"],
    "chevron-right": [320, 512, [61524], "232a", "M85.14 475.8c-3.438-3.141-5.156-7.438-5.156-11.75c0-3.891 1.406-7.781 4.25-10.86l181.1-197.1L84.23 58.86c-6-6.5-5.625-16.64 .9062-22.61c6.5-6 16.59-5.594 22.59 .8906l192 208c5.688 6.156 5.688 15.56 0 21.72l-192 208C101.7 481.3 91.64 481.8 85.14 475.8z"],
    "chevron-up": [448, 512, [], "f077", "M443.8 330.8C440.6 334.3 436.3 336 432 336c-3.891 0-7.781-1.406-10.86-4.25L224 149.8l-197.1 181.1c-6.5 6-16.64 5.625-22.61-.9062c-6-6.5-5.594-16.59 .8906-22.59l208-192c6.156-5.688 15.56-5.688 21.72 0l208 192C449.3 314.3 449.8 324.3 443.8 330.8z"],
    "chevrons-down": [448, 512, ["chevron-double-down"], "f322", "M421.1 244.2L224 426.2l-197.1-181.1C23.78 241.4 19.89 239.1 16 239.1c-4.312 0-8.609 1.719-11.75 5.156c-6 6.5-5.594 16.59 .8906 22.59l208 192c6.156 5.688 15.56 5.688 21.72 0l208-192c6.484-6 6.891-16.09 .8906-22.59C437.8 238.6 427.6 238.2 421.1 244.2zM213.1 267.8c6.156 5.688 15.56 5.688 21.72 0l208-192c6.484-6 6.891-16.09 .8906-22.59c-5.969-6.531-16.11-6.906-22.61-.9062L224 234.2L26.86 52.26C23.78 49.41 19.89 48.01 16 48.01c-4.312 0-8.609 1.719-11.75 5.156c-6 6.5-5.594 16.59 .8906 22.59L213.1 267.8z"],
    "chevrons-left": [448, 512, ["chevron-double-left"], "f323", "M235.8 453.1L53.8 256l181.1-197.1c2.844-3.078 4.25-6.969 4.25-10.86c0-4.312-1.719-8.609-5.156-11.75c-6.5-6-16.59-5.594-22.59 .8906l-192 208c-5.688 6.156-5.688 15.56 0 21.72l192 208c6 6.484 16.09 6.891 22.59 .8906C241.4 469.8 241.8 459.6 235.8 453.1zM212.2 245.1c-5.688 6.156-5.688 15.56 0 21.72l192 208c6 6.484 16.09 6.891 22.59 .8906c6.531-5.969 6.906-16.11 .9062-22.61l-181.1-197.1l181.1-197.1c2.844-3.078 4.25-6.969 4.25-10.86c0-4.312-1.719-8.609-5.156-11.75c-6.5-6-16.59-5.594-22.59 .8906L212.2 245.1z"],
    "chevrons-right": [448, 512, ["chevron-double-right"], "f324", "M212.2 58.86l181.1 197.1L212.2 453.1c-2.844 3.078-4.25 6.969-4.25 10.86c0 4.312 1.719 8.609 5.156 11.75c6.5 6 16.59 5.594 22.59-.8906l192-208c5.688-6.156 5.688-15.56 0-21.72l-192-208c-6-6.484-16.09-6.891-22.59-.8906C206.6 42.22 206.2 52.36 212.2 58.86zM235.8 266.9c5.688-6.156 5.688-15.56 0-21.72l-192-208c-6-6.484-16.09-6.891-22.59-.8906c-6.531 5.969-6.906 16.11-.9062 22.61l181.1 197.1L20.26 453.1c-2.844 3.078-4.25 6.969-4.25 10.86c0 4.312 1.719 8.609 5.156 11.75c6.5 6 16.59 5.594 22.59-.8906L235.8 266.9z"],
    "chevrons-up": [448, 512, ["chevron-double-up"], "f325", "M26.86 267.8l197.1-181.1l197.1 181.1C424.2 270.6 428.1 272 432 272c4.312 0 8.609-1.719 11.75-5.156c6-6.5 5.594-16.59-.8906-22.59l-208-192c-6.156-5.688-15.56-5.688-21.72 0l-208 192c-6.484 6-6.891 16.09-.8906 22.59C10.22 273.4 20.36 273.8 26.86 267.8zM234.9 244.2c-6.156-5.688-15.56-5.688-21.72 0l-208 192c-6.484 6-6.891 16.09-.8906 22.59c5.969 6.531 16.11 6.906 22.61 .9062l197.1-181.1l197.1 181.1c3.078 2.844 6.969 4.25 10.86 4.25c4.312 0 8.609-1.719 11.75-5.156c6-6.5 5.594-16.59-.8906-22.59L234.9 244.2z"],
    "child": [448, 512, [], "f1ae", "M224 144c39.75 0 72-32.25 72-72S263.8-.0004 224-.0004S151.1 32.25 151.1 72S184.3 144 224 144zM224 32c22.06 0 40 17.94 40 40S246.1 112 224 112c-22.05 0-40-17.94-40-40S201.9 32 224 32zM408.3 114.4c-7.516-4.547-17.36-2.172-21.95 5.344C384.5 122.7 340.6 192 224 192C107.6 192 63.64 122.9 61.69 119.7C57.14 112.2 47.34 109.7 39.77 114.3S29.73 128.7 34.28 136.2C35.95 138.1 67.52 189.6 144 212.7V496c0 8.844 7.156 16 15.1 16C168.8 512 176 504.8 176 496v-128h96v128c0 8.844 7.156 16 16 16S304 504.8 304 496V212.7c76.48-23.04 108.1-73.66 109.7-76.42C418.3 128.7 415.8 118.9 408.3 114.4zM272 336h-96V220.2C190.7 222.6 206.6 224 224 224s33.31-1.416 48-3.834V336z"],
    "chimney": [448, 512, [], "f78b", "M416 32H32C14.33 32 0 46.33 0 64v64c0 17.67 14.33 32 32 32l0 303.1c0 7.971 5.448 15.36 13.32 16.64C55.34 481.4 64 473.7 64 464V416h224v48C288 472.8 295.2 480 303.1 480S320 472.8 320 464V416h64v47.15c0 7.971 5.448 15.36 13.32 16.64C407.3 481.4 416 473.7 416 464V160c17.67 0 32-14.33 32-32V64C448 46.33 433.7 32 416 32zM128 256H64V160h64V256zM64 384V288h128v96H64zM384 384h-160V288h160V384zM384 256H160V160h224V256zM416 128H32V64h384V128z"],
    "church": [640, 512, [62749], "26ea", "M105.1 314.2L17.38 356C7 361 0 373.9 0 388.4v106.7c0 7.979 5.4 15.42 13.27 16.74C23.26 513.4 32 505.7 32 496v-107.6c0-2 .5-3.5 .75-4.25l86.12-41.03C124.4 340.4 128 334.8 128 328.6C128 316.9 115.7 309.1 105.1 314.2zM313.8 320.3C280.4 323.5 256 353.4 256 386.8V496C256 504.8 263.2 512 272 512S288 504.8 288 496v-110.3c0-15.88 10.88-30.75 26.62-33.25C334.6 349.1 352 364.6 352 384v112c0 8.799 7.199 16 16 16s16-7.201 16-16V384C384 346.6 351.9 316.6 313.8 320.3zM464.5 246.6L336 169.6V112h64C408.8 112 416 104.8 416 96c0-8.801-7.199-16-16-16h-64v-64C336 7.199 328.8 0 320 0S304 7.199 304 16v64h-64C231.2 80 224 87.2 224 96c0 8.799 7.199 16 16 16h64v57.63L175.5 246.6C165.9 252.5 160 262.9 160 274.1V496C160 504.8 167.2 512 176 512S192 504.8 192 496V274.1l128-76.75l128 76.75V496c0 8.799 7.199 16 16 16s16-7.201 16-16V274.1C480 262.9 474.1 252.5 464.5 246.6zM622.6 356l-87.71-41.82C524.3 309.1 512 316.9 512 328.6c0 6.178 3.553 11.8 9.131 14.46l86.12 41.03C607.5 384.9 608 386.4 608 388.4v106.7c0 7.979 5.4 15.42 13.27 16.74C631.3 513.4 640 505.7 640 496v-107.6C640 373.9 633 361 622.6 356z"],
    "circle": [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9898, 9899, 11044, 61713, 61708, 61915], "25cf", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-0": [512, 512, [], "e0ed", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 128C203.1 128 160 171.1 160 224v64c0 52.94 43.06 96 96 96s96-43.06 96-96V224C352 171.1 308.9 128 256 128zM320 288c0 35.28-28.72 64-64 64s-64-28.72-64-64V224c0-35.28 28.72-64 64-64s64 28.72 64 64V288z"],
    "circle-1": [512, 512, [], "e0ee", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM320 352h-48V144c0-5.906-3.25-11.31-8.453-14.09c-5.172-2.812-11.5-2.5-16.42 .7813l-48 32C191.8 167.6 189.8 177.5 194.7 184.9c4.875 7.344 14.8 9.312 22.19 4.438L240 173.9V352H192c-8.844 0-16 7.156-16 16S183.2 384 192 384h128c8.844 0 16-7.156 16-16S328.8 352 320 352z"],
    "circle-2": [512, 512, [], "e0ef", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 352H218.5l87.27-76.5c34.63-30.38 38.64-81.88 9.172-117.2c-14.66-17.56-35.28-28.22-58.08-30c-22.95-2-44.84 5.5-62.02 20.56L177.6 163.9C170.1 169.8 170.3 179.8 176.1 186.5C181.9 193.2 192 193.8 198.7 188l17.27-15.09C226.6 163.6 240.2 159.3 254.4 160.2c14.12 1.125 26.91 7.719 36 18.62c18.27 21.91 15.77 53.81-5.688 72.66l-119.3 104.5c-5.016 4.406-6.781 11.44-4.422 17.66C163.4 379.9 169.3 384 176 384h160c8.844 0 16-7.156 16-16S344.8 352 336 352z"],
    "circle-3": [512, 512, [], "e0f0", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM272 224H251.3l79.16-67.84c5.094-4.375 6.922-11.44 4.594-17.72C332.7 132.2 326.7 128 320 128H176C167.2 128 160 135.2 160 144S167.2 160 176 160h100.8L197.6 227.8C192.5 232.2 190.7 239.3 193 245.6C195.3 251.8 201.3 256 208 256h64C298.5 256 320 277.5 320 304S298.5 352 272 352H217.5c-11.97 0-22.55-7.625-26.33-19c-2.797-8.344-11.8-12.94-20.25-10.12c-8.375 2.812-12.91 11.88-10.12 20.25C168.1 367.6 191.8 384 217.5 384H272c44.11 0 80-35.88 80-80S316.1 224 272 224z"],
    "circle-4": [512, 512, [], "e0f1", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 288H320V208C320 199.2 312.8 192 304 192S288 199.2 288 208V288H183.6l55.23-138.1c3.281-8.188-.7187-17.5-8.922-20.78C221.8 125.9 212.4 129.8 209.1 138.1l-64 160C143.2 303 143.8 308.6 146.8 312.1C149.7 317.4 154.7 320 160 320h128v48c0 8.844 7.156 16 16 16s16-7.156 16-16V320h16c8.844 0 16-7.156 16-16S344.8 288 336 288z"],
    "circle-5": [512, 512, [], "e0f2", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM285.9 233.5L204 223.6L220.4 160H320c8.844 0 16-7.156 16-16S328.8 128 320 128H208C200.7 128 194.3 132.9 192.5 140l-24 93.31C167.4 237.8 168.2 242.6 170.8 246.4C173.4 250.2 177.5 252.7 182.1 253.2l99.86 12C303.6 268 320 286.6 320 308.4C320 332.5 300.5 352 276.4 352H218.4c-12.36 0-23.28-7.875-27.2-19.59C188.4 324 179.3 319.4 170.9 322.3c-8.391 2.812-12.91 11.88-10.11 20.25C169.1 367.3 192.2 384 218.4 384h58.06C318.1 384 352 350.1 352 308.4C352 270.5 323.6 238.3 285.9 233.5z"],
    "circle-6": [512, 512, [], "e0f3", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM265.4 192.1l48.19-36.14c7.062-5.312 8.5-15.34 3.219-22.41C313.7 130.2 308.8 128 304 128c-3.344 0-6.719 1.031-9.594 3.188L204.8 198.4C163.2 229.6 160 277.7 160 288c0 52.94 43.06 96 96 96s96-43.06 96-96C352 238.3 313.9 197.8 265.4 192.1zM256 352c-35.35 0-64-28.65-64-64c0-35.35 28.65-64 64-64s64 28.65 64 64C320 323.3 291.3 352 256 352z"],
    "circle-7": [512, 512, [], "e0f4", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM335.9 128h-160c-8.844 0-16 7.156-16 16s7.156 16 16 16h132.4l-114.3 200.1c-4.375 7.688-1.688 17.44 5.969 21.84C202.6 383.3 205.3 384 208 384c5.531 0 10.94-2.906 13.91-8.062l127.9-224c2.812-4.969 2.781-11.03-.0625-15.97C346.9 131 341.6 128 335.9 128z"],
    "circle-8": [512, 512, [], "e0f5", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM315.7 249.9C328.2 236.9 336 219.4 336 200C336 160.3 303.7 128 264 128h-16C208.3 128 176 160.3 176 200c0 19.37 7.781 36.91 20.28 49.87C174.7 262.3 160 285.4 160 312C160 351.7 192.3 384 232 384h48C319.7 384 352 351.7 352 312C352 285.4 337.3 262.3 315.7 249.9zM248 160h16c22.06 0 40 17.94 40 40S286.1 240 264 240h-16C225.9 240 208 222.1 208 200S225.9 160 248 160zM280 352h-48C209.9 352 192 334.1 192 312S209.9 272 232 272h48C302.1 272 320 289.9 320 312S302.1 352 280 352z"],
    "circle-9": [512, 512, [], "e0f6", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 128C203.1 128 160 171.1 160 224c0 49.72 38.12 90.24 86.6 95.05l-48.19 36.14c-7.062 5.312-8.5 15.34-3.219 22.41C198.3 381.8 203.2 384 208 384c3.344 0 6.719-1.031 9.594-3.188l89.59-67.22C348.8 282.4 352 234.3 352 224C352 171.1 308.9 128 256 128zM256 288C220.7 288 192 259.3 192 224c0-35.35 28.65-64 64-64s64 28.65 64 64C320 259.3 291.3 288 256 288z"],
    "circle-a": [512, 512, [], "e0f7", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM270.3 120.8c-5.438-10.84-23.19-10.84-28.62 0l-112 224c-3.953 7.906-.75 17.52 7.156 21.47c7.906 3.922 17.52 .75 21.47-7.156l19.89-39.79C179.3 319.6 180.2 320 181.3 320h149.3c1.107 0 2.078-.4141 3.123-.6289l19.89 39.79C356.5 364.8 362.1 368 368 368c2.406 0 4.844-.5469 7.141-1.688c7.906-3.953 11.11-13.56 7.156-21.47L270.3 120.8zM193.9 288L256 163.8L318.1 288H193.9z"],
    "circle-ampersand": [512, 512, [], "e0f8", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM329.4 320.5l35.67-50.39c5.094-7.219 3.406-17.2-3.812-22.31c-7.188-5.062-17.16-3.375-22.31 3.812l-31.89 45.06l-50.36-53.7l27.19-21.91C296.7 211.1 304 196.2 304 180.3C304 151.4 279.9 128 250.4 128H229.6C200.1 128 176 151.4 176 180.3c0 15.3 5.875 29.91 16.47 41.05l17.25 18.41L167.1 273.4C152.7 285.2 144 302.9 144 321.9C144 356.1 172.7 384 207.9 384h36.28c25.28 0 48.88-12.06 63.16-32.28l3.217-4.545l29.81 31.78C343.5 382.3 347.8 384 352 384c3.938 0 7.844-1.438 10.94-4.328c6.469-6.047 6.781-16.17 .7187-22.62L329.4 320.5zM208 180.3C208 169.1 217.7 160 229.6 160h20.75C262.3 160 272 169.1 272 180.3c0 6.031-2.844 11.72-8 15.75L234.7 219.6l-19-20.25C210.8 194.1 208 187.3 208 180.3zM281.2 333.2C281.2 333.3 281.2 333.2 281.2 333.2C272.9 344.1 259.1 352 244.2 352H207.9C190.3 352 176 338.5 176 321.9c0-9.031 4.219-17.52 11.81-23.42L231.7 263.1l56.5 60.24L281.2 333.2z"],
    "circle-arrow-down": [512, 512, ["arrow-circle-down"], "f0ab", "M340.7 260.7L272 329.4V144C272 135.2 264.8 128 256 128S240 135.2 240 144v185.4L171.3 260.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l96 96C247.8 382.4 251.9 384 256 384s8.188-1.562 11.31-4.688l96-96c6.25-6.25 6.25-16.38 0-22.62S346.9 254.4 340.7 260.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-down-left": [512, 512, [], "e0f9", "M336 160c-4.094 0-8.188 1.562-11.31 4.688L192 297.4V208C192 199.2 184.8 192 176 192S160 199.2 160 208v127.6c0 8.812 7.141 15.97 15.95 16l128 .375C312.8 352 319.1 344.9 320 336c.0313-8.812-7.109-16-15.95-16.03L214.9 319.7l132.4-132.4c6.25-6.25 6.25-16.38 0-22.62C344.2 161.6 340.1 160 336 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-down-right": [512, 512, [], "e0fa", "M336 192C327.2 192 320 199.2 320 208v89.38L187.3 164.7C184.2 161.6 180.1 160 176 160S167.8 161.6 164.7 164.7c-6.25 6.25-6.25 16.38 0 22.62l132.4 132.4L207.1 320C199.1 320 191.1 327.2 192 336C192 344.9 199.2 352 208 352l128-.375C344.9 351.6 352 344.4 352 335.6V208C352 199.2 344.8 192 336 192zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-left": [512, 512, ["arrow-circle-left"], "f0a8", "M368 240H182.6l68.69-68.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-96 96C129.6 247.8 128 251.9 128 256s1.562 8.188 4.688 11.31l96 96c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L182.6 272H368C376.8 272 384 264.8 384 256S376.8 240 368 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-right": [512, 512, ["arrow-circle-right"], "f0a9", "M283.3 148.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L329.4 240H144C135.2 240 128 247.2 128 256s7.156 16 16 16h185.4l-68.69 68.69c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l96-96C382.4 264.2 384 260.1 384 256s-1.562-8.188-4.688-11.31L283.3 148.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-up": [512, 512, ["arrow-circle-up"], "f0aa", "M267.3 132.7C264.2 129.6 260.1 128 256 128S247.8 129.6 244.7 132.7l-96 96c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L240 182.6V368c0 8.844 7.156 16 16 16s16-7.156 16-16V182.6l68.69 68.69c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L267.3 132.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-up-left": [512, 512, [], "e0fb", "M214.9 192.3L304 192C312.9 191.1 320 184.8 320 175.1C319.1 167.1 312.8 160 304 160L175.1 160.4C167.1 160.4 160 167.6 160 176.4V304C160 312.8 167.2 320 176 320S192 312.8 192 304V214.6l132.7 132.7C327.8 350.4 331.9 352 336 352s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L214.9 192.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-arrow-up-right": [512, 512, [], "e0fc", "M336 160.4L208 160C199.2 160 192 167.1 192 175.1C191.1 184.8 199.1 191.1 207.1 192l89.15 .2734l-132.4 132.4c-6.25 6.25-6.25 16.38 0 22.62C167.8 350.4 171.9 352 176 352s8.188-1.562 11.31-4.688L320 214.6V304c0 8.844 7.156 16 16 16S352 312.8 352 304V176.4C352 167.6 344.9 160.4 336 160.4zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-b": [512, 512, [], "e0fd", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM331.8 249.9C344.2 236.9 352 219.4 352 200C352 160.2 319.8 128 280 128H192C174.3 128 160 142.3 160 160v192c0 17.67 14.33 32 32 32h104c39.77 0 72-32.24 72-72C368 285.3 353.3 262.3 331.8 249.9zM192 160h88C302.1 160 320 177.9 320 200S302.1 240 280 240H192V160zM296 352H192V272h104c22.06 0 40 17.94 40 40S318.1 352 296 352z"],
    "circle-bolt": [512, 512, [], "e0fe", "M336 240H215.8l104.7-100.5c6.375-6.125 6.562-16.25 .4375-22.62c-6.094-6.406-16.22-6.531-22.62-.4687l-133.3 128C160.2 248.1 158.7 255.9 161.2 261.1S169.5 272 176 272h120.2l-104.7 100.5c-6.375 6.125-6.562 16.25-.4375 22.62C194.3 398.4 198.5 400 202.7 400c4 0 7.969-1.484 11.09-4.453l133.3-128c4.688-4.531 6.188-11.45 3.75-17.52S342.5 240 336 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-book-open": [512, 512, ["book-circle"], "e0ff", "M383.5 156.8C360.2 148.2 337.7 144.3 317.5 144C288 144.5 266.5 152.8 256 157.9C245.4 152.8 223.9 144.5 194.4 144c-20.25 0-42.95 4.32-65.87 12.74C118.4 160.5 112 170.6 112 181.4v151.4c0 7.328 3.438 14.03 9.445 18.4c4.016 2.9 8.729 4.395 13.55 4.395c2.271 0 4.564-.332 6.82-1.004c15.36-4.695 29.74-6.674 42.76-6.674c23.09 0 41.91 6.217 54.43 14.53c5.121 3.398 11.09 5.1 17.05 5.1c5.947 0 11.89-1.688 17-5.064c12.57-8.305 31.47-14.51 54.56-14.51c12.99 0 27.31 1.963 42.58 6.621c2.258 .6797 4.549 1.014 6.814 1.014c4.814 0 9.518-1.51 13.56-4.42C396.6 346.8 400 340.1 400 332.8V181.4C400 170.6 393.6 160.5 383.5 156.8zM240 326.9C223.6 319.8 204.5 315.9 184.6 315.9c-13.34 0-26.98 1.662-40.57 4.92V185.2C161.7 179.2 178.9 176 193.9 175.1C215.9 176.3 231.6 181.9 240 185.8V326.9zM368 320.8c-13.58-3.24-27.12-4.877-40.38-4.877c-20.25 0-39.6 3.922-55.62 11.18v-141.3c8.352-3.83 23.85-9.365 45.51-9.793C333.8 176.3 351.2 179.5 368 185.2V320.8zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-bookmark": [512, 512, ["bookmark-circle"], "e100", "M320 128H192C174.3 128 160 142.4 160 160v208c0 6.156 3.531 11.75 9.062 14.42c5.562 2.672 12.09 1.891 16.94-1.922L256 324.5l69.1 56.02C328.9 382.8 332.4 384 336 384c2.344 0 4.719-.5156 6.938-1.578C348.5 379.8 352 374.2 352 368V160C352 142.4 337.7 128 320 128zM320 334.7L265.1 291.5C263.1 289.2 259.5 288 256 288S248.9 289.2 245.1 291.5L192 334.7V160h128V334.7zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-c": [512, 512, [], "e101", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM324.7 188.1c6.281 6.25 16.42 6.203 22.64-.0469c6.234-6.266 6.203-16.41-.0469-22.64C297.2 115.6 215.7 115.6 165.6 165.5C141.4 189.6 128 221.8 128 256s13.33 66.36 37.59 90.55c25.05 24.92 57.94 37.39 90.83 37.39s65.78-12.47 90.83-37.39c6.25-6.234 6.281-16.38 .0469-22.64c-6.25-6.234-16.39-6.312-22.64-.0469c-37.63 37.47-98.84 37.45-136.5 .0156C170 305.7 160 281.6 160 256s10.02-49.73 28.23-67.86C225.9 150.7 287.1 150.7 324.7 188.1z"],
    "circle-calendar": [512, 512, ["calendar-circle"], "e102", "M336 128H320V111.1C320 103.2 312.8 96 304 96S288 103.2 288 111.1V128H224V111.1C224 103.2 216.8 96 208 96S192 103.2 192 111.1V128H176C149.5 128 128 149.5 128 176v160C128 362.5 149.5 384 176 384h160c26.51 0 48-21.49 48-48v-160C384 149.5 362.5 128 336 128zM352 336c0 8.836-7.164 16-16 16h-160C167.2 352 160 344.8 160 336V224h192V336zM352 192H160V176C160 167.2 167.2 160 176 160h160C344.8 160 352 167.2 352 176V192zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-camera": [512, 512, ["camera-circle"], "e103", "M256 224C238.3 224 224 238.3 224 256s14.33 32 32 32s32-14.33 32-32S273.7 224 256 224zM336 160h-20l-6.188-16.44C306.3 134.2 297.4 128 287.4 128H224.6c-10 0-19 6.188-22.5 15.56L196 160H176C149.5 160 128 181.5 128 208v96C128 330.5 149.5 352 176 352h160c26.51 0 48-21.49 48-48v-96C384 181.5 362.5 160 336 160zM352 304c0 8.822-7.178 16-16 16h-160C167.2 320 160 312.8 160 304v-96C160 199.2 167.2 192 176 192h42.22l11.93-32h51.66l12.04 32H336C344.8 192 352 199.2 352 208V304zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", "M352 192H160C131.6 192 117.3 226.5 137.4 246.6l95.95 96c12.49 12.5 32.86 12.5 45.35 0l95.95-96C394.6 226.5 380.5 192 352 192zM256 320L160 224h192L256 320zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-caret-left": [512, 512, ["caret-circle-left"], "f32e", "M265.4 137.4l-96 95.95c-12.5 12.49-12.5 32.86 0 45.35l96 95.95C285.5 394.6 320 380.5 320 352V160C320 131.6 285.5 117.3 265.4 137.4zM288 352L192 256l96-96V352zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-caret-right": [512, 512, ["caret-circle-right"], "f330", "M246.6 137.4C226.5 117.4 192 131.5 192 159.1V352c0 28.36 34.5 42.73 54.63 22.61l96-95.95c12.5-12.49 12.5-32.86 0-45.35L246.6 137.4zM224 352V160l96 96L224 352zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", "M278.7 169.4c-12.49-12.5-32.86-12.5-45.35 0l-95.95 96C117.4 285.5 131.5 320 159.1 320h192c28.36 0 42.73-34.5 22.61-54.63L278.7 169.4zM160 288l96-96l96 96H160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", "M340.7 180.7L224 297.4L171.3 244.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l64 64C215.8 334.4 219.9 336 224 336s8.188-1.562 11.31-4.688l128-128c6.25-6.25 6.25-16.38 0-22.62S346.9 174.4 340.7 180.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-chevron-down": [512, 512, ["chevron-circle-down"], "f13a", "M356.7 212.7L256 313.4L155.3 212.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l112 112C247.8 350.4 251.9 352 256 352s8.188-1.562 11.31-4.688l112-112c6.25-6.25 6.25-16.38 0-22.62S362.9 206.4 356.7 212.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-chevron-left": [512, 512, ["chevron-circle-left"], "f137", "M299.3 132.7c-6.25-6.25-16.38-6.25-22.62 0l-112 112C161.6 247.8 160 251.9 160 256s1.562 8.188 4.688 11.31l112 112c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L198.6 256l100.7-100.7C305.6 149.1 305.6 138.9 299.3 132.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-chevron-right": [512, 512, ["chevron-circle-right"], "f138", "M235.3 132.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L313.4 256l-100.7 100.7c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l112-112C350.4 264.2 352 260.1 352 256s-1.562-8.188-4.688-11.31L235.3 132.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM267.3 164.7C264.2 161.6 260.1 160 256 160S247.8 161.6 244.7 164.7l-112 112c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L256 198.6l100.7 100.7c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L267.3 164.7z"],
    "circle-d": [512, 512, [], "e104", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 128H176C167.2 128 160 135.2 160 144v224C160 376.8 167.2 384 176 384H256c70.58 0 128-57.42 128-128S326.6 128 256 128zM256 352H192V160h64c52.94 0 96 43.06 96 96S308.9 352 256 352z"],
    "circle-dashed": [512, 512, [], "e105", "M34.25 285.8C33.2 277.9 26.47 272 18.51 272c-9.635 0-17.15 8.486-15.88 18.04c5.738 43.07 22.42 84.88 50.05 121c5.863 7.676 17.2 8.416 24.03 1.586c5.613-5.611 6.264-14.53 1.439-20.83C53.92 360.2 39.28 323.5 34.25 285.8zM76.71 99.35c-6.832-6.83-18.18-6.1-24.04 1.576C25.05 137.1 8.367 178.9 2.629 221.1C1.357 231.5 8.873 240 18.51 240c7.959 0 14.69-5.869 15.74-13.76c5.025-37.75 19.67-74.4 43.9-106.1C82.97 113.9 82.33 104.1 76.71 99.35zM226.2 477.7c-37.76-5.023-74.41-19.66-106.1-43.89c-6.305-4.822-15.21-4.18-20.82 1.434c-6.83 6.83-6.1 18.18 1.576 24.04c36.15 27.62 77.97 44.3 121 50.04C231.5 510.6 240 503.1 240 493.5C240 485.5 234.1 478.8 226.2 477.7zM477.8 226.2C478.8 234.1 485.5 240 493.5 240c9.635 0 17.15-8.488 15.88-18.04c-5.738-43.07-22.42-84.88-50.05-121c-5.863-7.676-17.2-8.414-24.03-1.584c-5.613 5.611-6.264 14.53-1.439 20.83C458.1 151.8 472.7 188.5 477.8 226.2zM493.5 272c-7.959 0-14.69 5.869-15.74 13.76c-5.025 37.75-19.67 74.39-43.9 106.1c-4.824 6.303-4.18 15.21 1.434 20.82c6.832 6.83 18.18 6.098 24.04-1.578c27.62-36.15 44.31-77.96 50.05-121C510.6 280.5 503.1 272 493.5 272zM290 2.645C280.5 1.373 272 8.889 272 18.52c0 7.959 5.869 14.7 13.76 15.75c37.76 5.025 74.41 19.67 106.1 43.89c6.303 4.82 15.21 4.178 20.82-1.434c6.83-6.832 6.102-18.18-1.576-24.04C374.9 25.07 333.1 8.383 290 2.645zM221.1 2.645C178.9 8.383 137.1 25.07 100.9 52.69C93.24 58.55 92.5 69.89 99.33 76.72C104.9 82.33 113.9 82.99 120.2 78.16c31.68-24.23 68.32-38.87 106.1-43.89C234.1 33.22 240 26.49 240 18.53C240 8.895 231.5 1.373 221.1 2.645zM412.7 435.3c-5.611-5.611-14.53-6.268-20.83-1.445c-31.68 24.23-68.32 38.87-106.1 43.89C277.9 478.8 272 485.5 272 493.5c0 9.635 8.488 17.16 18.04 15.89c43.08-5.738 84.89-22.42 121-50.04C418.8 453.4 419.5 442.1 412.7 435.3z"],
    "circle-divide": [512, 512, [], "e106", "M256 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S232 146.7 232 160C232 173.3 242.7 184 256 184zM256 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C280 338.7 269.3 328 256 328zM352 240H160C151.2 240 144 247.2 144 256S151.2 272 160 272h192c8.844 0 16-7.156 16-16S360.8 240 352 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256C397.4 512 512 397.4 512 256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-dollar": [512, 512, ["dollar-circle", "usd-circle"], "f2e8", "M260.4 240.6L252 238.2C214.7 227.2 205.3 219.1 208.6 200.4c4.062-23.38 35.58-27 61.27-22.95c7.547 1.172 17 3.766 28.92 7.891c8.344 2.859 17.45-1.562 20.36-9.891c2.891-8.344-1.547-17.47-9.891-20.36c-13.92-4.812-24.86-7.75-34.44-9.266C273.8 145.7 272.1 145.7 272 145.5V112C272 103.2 264.8 96 256 96S240 103.2 240 112v32.71C205.1 148.2 181.1 166.4 177 194.9C168.1 246.8 216.8 261.2 243 268.9l8.562 2.469c42.73 12.22 55.47 19.38 51.86 40.27c-4.062 23.41-35.64 26.97-61.36 22.94c-11.77-1.766-25.78-6.812-38.16-11.28l-6.562-2.344C189 317.9 179.9 322.3 176.9 330.7c-2.953 8.328 1.406 17.47 9.734 20.42l6.406 2.297c13.75 4.953 29.34 10.58 44.14 12.81C238.2 366.3 239 366.3 240 366.4V400c0 8.844 7.156 16 16 16s16-7.156 16-16v-32.74c34.03-3.531 58.02-21.67 62.95-50.2C344 264.5 295.7 250.7 260.4 240.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-dollar-to-slot": [512, 512, ["donate"], "f4b9", "M243.1 270.8C236.2 269.7 230.6 268.1 205.1 259.5C196.8 256.6 187.7 261.2 184.8 269.6C182 277.9 186.5 287 194.9 289.8c29.34 9.969 36.57 11.45 45.09 12.67V320c0 8.844 7.191 16 16.03 16s15.97-7.156 15.97-16V303.2c29.72-3.51 50.59-19.29 55.03-43.72C335.5 213 290.1 200.7 260.1 192.5L252.9 190.5C218.8 180.1 214.2 174.4 216.5 162.2c3-16.64 28.03-20.52 51.47-17.05c6.562 .9687 14.53 3.047 25.06 6.516c8.375 2.766 17.47-1.812 20.19-10.2c2.781-8.391-1.781-17.44-10.19-20.2c-12.31-4.047-22.59-6.57-31-7.82V96c0-8.844-7.122-16-15.97-16S239.1 87.16 239.1 96v16.8C210.2 116.3 189.4 132.1 184.1 156.5C176.6 202.4 222.3 215.2 244.2 221.3L251.7 223.4c38.22 10.41 46.41 16.08 43.81 30.38C292.5 270.4 267.6 274.4 243.1 270.8zM464 352c-8.844 0-16 7.156-16 16s7.156 16 16 16c8.812 0 16 7.172 16 16v64c0 8.828-7.188 16-16 16h-416C39.19 480 32 472.8 32 464v-64C32 391.2 39.19 384 48 384C56.84 384 64 376.8 64 368S56.84 352 48 352C21.53 352 0 373.5 0 400v64C0 490.5 21.53 512 48 512h416c26.47 0 48-21.53 48-48v-64C512 373.5 490.5 352 464 352zM256 416c114.9 0 208-93.13 208-208S370.9 0 256 0S48 93.13 48 208S141.1 416 256 416zM256 32c97.05 0 176 78.95 176 176S353 384 256 384S80 305 80 208S158.1 32 256 32z"],
    "circle-dot": [512, 512, [61842, "dot-circle"], "1f518", "M256 160C203.1 160 160 203 160 256c0 52.95 43.05 96 96 96s96-43.05 96-96C352 203 308.9 160 256 160zM256 320c-35.33 0-64-28.67-64-64c0-35.33 28.67-64 64-64s64 28.67 64 64C320 291.3 291.3 320 256 320zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-down": [512, 512, [61466, "arrow-alt-circle-down"], "f358", "M348.7 224H320V152c0-22.06-17.94-40-40-40h-48C209.9 112 192 129.9 192 152V224H163.3C147.1 224 132.6 233.7 126.3 248.7c-6.188 14.95-2.812 32 8.562 43.48l92.81 96.11c15.12 15.12 41.25 15.33 56.75-.2031l92.5-95.8c11.47-11.48 14.88-28.59 8.688-43.59C379.4 233.7 364.9 224 348.7 224zM354.2 269.9l-92.5 95.8c-4.162 4.203-9.533 1.797-11.12 .2031l-92.69-96C152.1 265 155.9 256 163.3 256H224L223.1 152c0-4.406 3.594-8 8.001-8h48c4.406 0 7.999 3.594 7.999 8L288 256h60.69C355.1 256 359.9 264 354.2 269.9zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-down-left": [512, 512, [], "e107", "M340.9 137.2c-15.6-15.6-40.97-15.6-56.57 0L233.4 188.1L213.1 167.8C201.6 156.3 184.5 152.9 169.5 159.1C154.5 165.4 144.8 179.9 144.8 196.1l-2.33 133.1c-.0215 21.94 18.59 40.27 39.98 40.27l133.6-2.332c16.16-.0781 30.6-9.742 36.8-24.7c6.209-15 2.807-32.11-8.684-43.59l-20.29-20.29l50.91-50.91c15.6-15.6 15.6-40.96 0-56.57L340.9 137.2zM352.2 205.1l-73.54 73.54l42.91 42.91c5.258 5.258 1.205 13.66-5.656 13.66l-133.7 2.352c-2.254 .0039-7.754-2.094-7.725-8.008l2.332-133.1c.0176-8.199 9.131-10.47 13.67-5.93l42.91 42.91l73.54-73.54c3.115-3.113 8.197-3.115 11.31-.002l33.94 33.94C355.3 196.9 355.3 201.1 352.2 205.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-down-right": [512, 512, [], "e108", "M342.5 159.1c-15-6.211-32.11-2.805-43.6 8.684l-20.29 20.29L227.7 137.2c-15.6-15.6-40.97-15.6-56.57 0l-33.94 33.95c-15.6 15.6-15.6 40.97 0 56.57l50.91 50.91L167.8 298.9c-11.49 11.49-14.89 28.59-8.684 43.59c6.199 14.95 20.64 24.62 36.8 24.7l133.6 2.332c21.39 0 40.01-18.33 39.98-40.27l-2.33-133.1C367.2 179.9 357.5 165.4 342.5 159.1zM329.8 337.5l-133.4-2.34c-6.861 0-11.19-8.41-5.932-13.67l42.91-42.91L159.8 205.1c-3.115-3.113-3.115-8.197 0-11.31L193.8 159.8c3.115-3.113 8.197-3.111 11.31 .002l73.54 73.54l42.91-42.91c4.537-4.539 13.65-2.27 13.67 5.93l2.332 133.1C337.6 335.5 332.1 337.6 329.8 337.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-e": [512, 512, [], "e109", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 160C344.8 160 352 152.8 352 144S344.8 128 336 128h-160C167.2 128 160 135.2 160 144v224C160 376.8 167.2 384 176 384h160c8.844 0 16-7.156 16-16S344.8 352 336 352H192V272h96c8.844 0 16-7.156 16-16S296.8 240 288 240H192V160H336z"],
    "circle-ellipsis": [512, 512, [], "e10a", "M256 232C242.7 232 232 242.7 232 256c0 13.25 10.74 24 24 24S280 269.3 280 256C280 242.7 269.3 232 256 232zM144 232C130.7 232 120 242.7 120 256c0 13.25 10.74 24 24 24S168 269.3 168 256C168 242.7 157.3 232 144 232zM368 232c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24S392 269.3 392 256C392 242.7 381.3 232 368 232zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256S512 397.4 512 256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-ellipsis-vertical": [512, 512, [], "e10b", "M256 232C242.7 232 232 242.7 232 256S242.7 280 256 280c13.26 0 24-10.74 24-24S269.3 232 256 232zM256 344c-13.25 0-24 10.74-24 24s10.75 24 24 24c13.26 0 24-10.74 24-24S269.3 344 256 344zM256 120c-13.25 0-24 10.74-24 24S242.7 168 256 168c13.26 0 24-10.74 24-24S269.3 120 256 120zM256 0c-141.4 0-255.1 114.6-255.1 256S114.6 511.1 256 511.1s256-114.6 256-255.1S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-envelope": [512, 512, ["envelope-circle"], "e10c", "M352 160H160C142.3 160 128 174.3 128 192v128c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32V192C384 174.3 369.7 160 352 160zM352 320H160V245.3l89.3 41.21C251.4 287.5 253.7 288 256 288s4.578-.5 6.703-1.469L352 245.3V320zM352 210.1l-96 44.31L160 210.1V192h192V210.1zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-exclamation": [512, 512, ["exclamation-circle"], "f06a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 304c8.844 0 16-7.156 16-16V128c0-8.844-7.156-16-16-16S240 119.2 240 128v160C240 296.8 247.2 304 256 304zM256 344c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S269.3 344 256 344z"],
    "circle-exclamation-check": [576, 512, [], "e10d", "M232 368c0 13.25 10.75 24 24 24s24-10.75 24-24S269.3 344 256 344S232 354.7 232 368zM272 288V128c0-8.844-7.156-16-16-16S240 119.2 240 128v160c0 8.844 7.156 16 16 16S272 296.8 272 288zM571.3 186c-6.25-6.25-16.38-6.25-22.62 0l-95.34 95.36l-42.03-42.02c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l53.34 53.33C445.2 318.4 449.3 320 453.3 320s8.188-1.562 11.31-4.688l106.7-106.7C577.6 202.4 577.6 192.3 571.3 186zM467.6 370.5c-7.406-4.594-17.31-2.5-22.09 4.969C404.1 440.8 333.3 479.9 256 479.9c-123.5 0-224-100.5-224-224s100.5-224 224-224c90.13 0 171.1 53.63 206.3 136.6c3.406 8.156 12.91 11.91 20.97 8.469c8.125-3.438 11.94-12.84 8.469-20.97C451.6 61.19 359-.0187 256-.0187c-141.2 0-256 114.8-256 256s114.8 256 256 256c88.31 0 169.3-44.7 216.5-119.4C477.3 385.1 475 375.2 467.6 370.5z"],
    "circle-f": [512, 512, [], "e10e", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 128h-160C167.2 128 160 135.2 160 144v224C160 376.8 167.2 384 176 384S192 376.8 192 368V288h112C312.8 288 320 280.8 320 272S312.8 256 304 256H192V160h144C344.8 160 352 152.8 352 144S344.8 128 336 128z"],
    "circle-g": [512, 512, [], "e10f", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM368 256h-74.66c-8.844 0-16 7.156-16 16s7.156 16 16 16h53.59c-5.344 13.41-13.59 26.42-23.06 35.89c-36.25 36.25-99.5 36.25-135.8 0C169.1 305.8 160 281.6 160 256s9.1-49.75 28.12-67.89c36-36.05 94-37.64 131.8-3.672c6.594 5.891 16.72 5.375 22.59-1.25c5.906-6.578 5.344-16.69-1.219-22.59c-50.59-45.3-127.8-43.13-175.8 4.891c-49.91 49.91-49.91 131.1 0 181C189.7 370.7 221.8 384 256 384s66.34-13.31 90.5-37.48c18.28-18.28 32.56-45.39 37.25-70.78C383.9 274.8 384 272.1 384 272C384 263.2 376.8 256 368 256z"],
    "circle-h": [512, 512, [62590, "hospital-symbol"], "24bd", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 128C327.2 128 320 135.2 320 144v96H192v-96C192 135.2 184.8 128 176 128S160 135.2 160 144v224C160 376.8 167.2 384 176 384S192 376.8 192 368v-96h128v96c0 8.844 7.156 16 16 16s16-7.156 16-16v-224C352 135.2 344.8 128 336 128z"],
    "circle-half": [512, 512, [], "e110", "M248.1 7.414C243.6 3.393 238 1.24 231.9 1.24c-.793 0-1.596 .0371-2.404 .1113C98.69 14.8 0 124.3 0 255.1s98.69 241.2 229.5 254.6C230.4 510.7 231.2 510.8 232 510.8c5.906 0 11.66-2.188 16.09-6.188C253.1 500 256 493.6 256 486.8V25.23C256 18.43 253.1 11.96 248.1 7.414zM224 477.7c-110.1-15.65-192-109.5-192-221.7c0-112.4 82.1-206.3 192-221.7V477.7z"],
    "circle-half-stroke": [512, 512, [61506, "adjust"], "25d0", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM32 256c0-118.1 91.96-214.9 208-223.2v446.4C123.1 470.9 32 374.1 32 256zM272 479.2V32.81C388 41.07 480 137.9 480 256S388 470.9 272 479.2z"],
    "circle-heart": [512, 512, ["heart-circle"], "f4c7", "M325.6 144c-22.88 0-44.36 10.72-58.36 25.22L256.1 180.8L244.8 169.2C231.2 154.1 209.3 144 186.3 144C170.5 144 154.4 149.1 139.9 161.6C104.6 192.3 102.8 247.3 134.3 280.3l109 114.1c7 7.375 18.51 7.455 25.63 .0797l108.7-114.2c31.62-33.13 29.75-88-5.625-118.6C357.6 149.1 341.4 144 325.6 144zM355 258.1l-99 103.8l-99-103.8C140.3 240.6 136.6 206.5 160.4 186c8.25-7.125 17.38-9.875 26.38-9.875c13.88 0 27.25 6.875 35.5 15.62L256 227l33.75-35.25c8.125-8.625 21.62-15.5 35.5-15.5c9 0 18.12 2.75 26.25 9.875C375.4 206.5 371.8 240.5 355 258.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-i": [512, 512, [], "e111", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 144C352 135.2 344.8 128 336 128h-160C167.2 128 160 135.2 160 144S167.2 160 176 160h64.88C240.5 161.4 240 162.8 240 164.4v183.3C240 349.2 240.5 350.6 240.9 352H176C167.2 352 160 359.2 160 368S167.2 384 176 384h160c8.844 0 16-7.156 16-16S344.8 352 336 352h-64.88C271.5 350.6 272 349.2 272 347.6V164.4C272 162.8 271.5 161.4 271.1 160H336C344.8 160 352 152.8 352 144z"],
    "circle-info": [512, 512, ["info-circle"], "f05a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 184c13.25 0 24-10.74 24-24c0-13.25-10.75-24-24-24S232 146.7 232 160C232 173.3 242.7 184 256 184zM304 352h-32V240C272 231.2 264.8 224 256 224H224C215.2 224 208 231.2 208 240S215.2 256 224 256h16v96h-32C199.2 352 192 359.2 192 368C192 376.8 199.2 384 208 384h96c8.836 0 16-7.164 16-16C320 359.2 312.8 352 304 352z"],
    "circle-j": [512, 512, [], "e112", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM320 128c-8.844 0-16 7.156-16 16v149.3C304 325.7 275.3 352 240 352s-64-26.31-64-58.67V272C176 263.2 168.8 256 160 256S144 263.2 144 272v21.33C144 343.3 187.1 384 240 384s96-40.67 96-90.67V144C336 135.2 328.8 128 320 128z"],
    "circle-k": [512, 512, [], "e113", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM347.9 133.3c-5.922-6.609-16.05-7.094-22.59-1.188L192 252.1V144C192 135.2 184.8 128 176 128S160 135.2 160 144v224C160 376.8 167.2 384 176 384S192 376.8 192 368V295.1l41.4-37.26l89.8 119.7C326.3 381.8 331.1 384 336 384c3.344 0 6.703-1.047 9.578-3.203c7.078-5.297 8.516-15.33 3.203-22.39L257.3 236.4l89.43-80.49C353.3 149.1 353.8 139.9 347.9 133.3z"],
    "circle-l": [512, 512, [], "e114", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 352H192V144C192 135.2 184.8 128 176 128S160 135.2 160 144v224C160 376.8 167.2 384 176 384h160c8.844 0 16-7.156 16-16S344.8 352 336 352z"],
    "circle-left": [512, 512, [61840, "arrow-alt-circle-left"], "f359", "M360 192H288V163.3c0-16.25-9.688-30.75-24.69-36.97c-14.95-6.188-32-2.812-43.48 8.562l-96.11 92.81C108.6 242.8 108.4 268.1 123.9 284.5l95.8 92.5c11.48 11.47 28.59 14.88 43.59 8.688C278.3 379.4 288 364.9 288 348.7V320h72c22.06 0 40-17.94 40-40v-48C400 209.9 382.1 192 360 192zM368 280C368 284.4 364.4 288 360 288H256v60.69c0 6.414-8.047 11.26-13.86 5.471l-95.8-92.5c-4.205-4.164-1.797-9.531-.2031-11.12l96-92.69C246.1 152.1 256 155.9 256 163.3V224h104c4.406 0 8 3.594 8 8V280zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-location-arrow": [576, 512, ["location-circle"], "f602", "M370.1 152c-2.918 0-5.881 .5723-8.725 1.75l-196 84c-9.562 4.094-14.98 14.47-12.89 24.62C154.5 272.6 163.6 280 173.1 280H264v90c0 10.41 7.391 19.5 17.62 21.59C283.1 391.9 284.6 392 285.1 392c8.797 0 16.73-5.219 20.23-13.31l84-196c3.562-8.344 1.719-17.86-4.656-24.2C381.4 154.3 375.8 152 370.1 152zM296 321.3V248H222.7l128.3-54.97L296 321.3zM289.2 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S430.6 0 289.2 0zM289.2 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S412.7 480 289.2 480z"],
    "circle-m": [512, 512, [], "e115", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM372.8 128.7c-6.609-2.047-13.91 .3594-17.92 6.094L256 276.1L157.1 134.8C153.1 129.1 145.8 126.6 139.2 128.7C132.5 130.8 128 137 128 144v224C128 376.8 135.2 384 144 384S160 376.8 160 368V194.8l82.89 118.4c6 8.562 20.22 8.562 26.22 0L352 194.8V368c0 8.844 7.156 16 16 16s16-7.156 16-16v-224C384 137 379.5 130.8 372.8 128.7z"],
    "circle-microphone": [512, 512, ["microphone-circle"], "e116", "M256 320c35.35 0 64-28.65 64-64V160c0-35.35-28.65-64-64-64S192 124.7 192 160v96C192 291.3 220.7 320 256 320zM224 160c0-17.64 14.36-32 32-32s32 14.36 32 32v96c0 17.64-14.36 32-32 32S224 273.6 224 256V160zM368 224C359.2 224 352 231.2 352 239.1V256c0 52.94-43.06 96-96 96S160 308.9 160 256L159.1 240c0-8.844-7.156-16-16-16S128 231.2 128 239.1V256c0 65.1 49.03 118.4 112 126.4V400c0 8.844 7.156 16 16 16s16-7.156 16-16v-17.62C334.1 374.4 384 321.1 384 256V239.1C384 231.2 376.8 224 368 224zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-microphone-lines": [512, 512, ["microphone-circle-alt"], "e117", "M256 320c35.35 0 64-28.65 64-64V160c0-35.35-28.65-64-64-64S192 124.7 192 160v96C192 291.3 220.7 320 256 320zM224 160c0-17.64 14.36-32 32-32s32 14.36 32 32h-16C263.2 160 256 167.2 256 176S263.2 192 272 192H288v32h-16C263.2 224 256 231.2 256 240S263.2 256 272 256H288c0 17.64-14.36 32-32 32S224 273.6 224 256V160zM368 224C359.2 224 352 231.2 352 239.1V256c0 52.94-43.06 96-96 96S160 308.9 160 256V240C160 231.2 152.8 224 144 224S128 231.2 128 239.1V256c0 65.1 49.03 118.4 112 126.4V400c0 8.844 7.156 16 16 16s16-7.156 16-16v-17.62C334.1 374.4 384 321.1 384 256V239.1C384 231.2 376.8 224 368 224zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-minus": [512, 512, ["minus-circle"], "f056", "M352 240H160C151.2 240 144 247.2 144 256S151.2 272 160 272h192c8.844 0 16-7.156 16-16S360.8 240 352 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256S512 397.4 512 256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-n": [512, 512, [], "e118", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 128c-8.844 0-16 7.156-16 16v180.8L172.1 133.6C167.8 128.5 160.7 126.6 154.5 129C148.2 131.3 144 137.3 144 144v224C144 376.8 151.2 384 160 384s16-7.156 16-16V187.3l163.9 191.2C342.1 382 347.4 384 352 384c1.859 0 3.734-.3281 5.547-1C363.8 380.7 368 374.7 368 368v-224C368 135.2 360.8 128 352 128z"],
    "circle-notch": [512, 512, [], "f1ce", "M512 256c0 141.2-114.8 256-256 256s-256-114.8-256-256c0-114.8 77.19-216.3 187.8-246.8c8.5-2.328 17.31 2.641 19.69 11.16C209.8 28.89 204.8 37.7 196.3 40.05C99.53 66.75 32 155.5 32 256c0 123.5 100.5 224 224 224s224-100.5 224-224c0-100.5-67.53-189.3-164.3-215.1c-8.531-2.344-13.53-11.16-11.19-19.69c2.344-8.484 11.28-13.52 19.69-11.16C434.8 39.72 512 141.2 512 256z"],
    "circle-o": [512, 512, [], "e119", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 128C185.4 128 128 185.4 128 256s57.42 128 128 128s128-57.42 128-128S326.6 128 256 128zM256 352c-52.94 0-96-43.06-96-96s43.06-96 96-96s96 43.06 96 96S308.9 352 256 352z"],
    "circle-p": [512, 512, [], "e11a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM272 128h-96C167.2 128 160 135.2 160 144v224C160 376.8 167.2 384 176 384S192 376.8 192 368V320h80c52.94 0 96-43.06 96-96S324.9 128 272 128zM272 288H192V160h80c35.28 0 64 28.7 64 64S307.3 288 272 288z"],
    "circle-parking": [512, 512, ["parking-circle"], "f615", "M288 128H208c-17.66 0-32 14.34-32 32v208C176 376.8 183.2 384 192 384s16-7.156 16-16V320H288c52.94 0 96-43.06 96-96S340.9 128 288 128zM288 288H208V160H288c35.28 0 64 28.72 64 64S323.3 288 288 288zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", "M208 160C199.2 160 192 167.2 192 176v160C192 344.8 199.2 352 208 352S224 344.8 224 336v-160C224 167.2 216.8 160 208 160zM304 160C295.2 160 288 167.2 288 176v160c0 8.844 7.156 16 16 16s16-7.156 16-16v-160C320 167.2 312.8 160 304 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-phone": [512, 512, ["phone-circle"], "e11b", "M369.5 276.3C369.5 276.3 369.5 276.3 369.5 276.3l-47.91-20.53c-15.17-6.328-32.97-1.859-43.25 10.75l-6.719 8.188C258.1 265.5 246.5 253.9 237.4 240.4l8.266-6.781c12.86-10.62 17.11-28.06 10.55-43.41L235.7 142.5c-7.141-16.52-25.06-25.5-42.58-21.52L148.9 131.2C131.9 135.1 120 149.1 120 167.5C120 291.3 220.7 392 344.5 392c17.45 0 32.39-11.88 36.31-28.88l10.2-44.28C395.1 301.3 385.1 283.5 369.5 276.3zM349.7 355.9C349.1 358.4 347 360 344.5 360C238.4 360 152 273.6 152 167.5c0-2.469 1.625-4.5 4.094-5.062l44.25-10.27C200.7 152 201.1 152 201.5 152c2.062 0 4.016 1.234 4.844 3.125l20.44 47.7c.9531 2.234 .3906 4.594-1.453 6.109L206.3 224.5C200.4 229.4 198.7 237.8 202.4 244.5c15 27.58 37.53 50.09 65.13 65.13c6.781 3.688 15.17 2 20.03-3.906l15.58-19.02c1.406-1.734 3.984-2.328 6.016-1.516l47.66 20.44c2.328 1.031 3.609 3.562 3.047 6L349.7 355.9zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-phone-flip": [512, 512, ["phone-circle-alt"], "e11c", "M363.1 131.2l-44.19-10.25c-17.52-3.984-35.44 5-42.58 21.52L255.8 190.3c-6.562 15.34-2.312 32.78 10.55 43.41l8.266 6.781C265.5 253.9 253.9 265.5 240.4 274.7L233.7 266.5C223.4 253.9 205.6 249.4 190.4 255.8L142.5 276.3c-.0156 .0156 .0313-.0156 0 0c-16.47 7.172-25.55 25.06-21.54 42.56l10.2 44.28C135.1 380.1 150 392 167.5 392C291.3 392 392 291.3 392 167.5C392 149.1 380.1 135.1 363.1 131.2zM167.5 360c-2.5 0-4.562-1.625-5.125-4.062L152.1 311.7c-.5625-2.438 .7187-4.969 3.047-6l47.66-20.44C204.9 284.4 207.5 285 208.9 286.7l15.58 19.02c4.859 5.906 13.25 7.594 20.03 3.906c27.59-15.03 50.13-37.55 65.13-65.13c3.672-6.75 2.031-15.16-3.906-20.03l-18.98-15.56c-1.844-1.516-2.406-3.875-1.453-6.109l20.44-47.7C306.5 153.2 308.5 152 310.5 152c.375 0 .75 .0469 1.125 .1406l44.25 10.27C358.4 162.1 360 165 360 167.5C360 273.6 273.6 360 167.5 360zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-phone-hangup": [512, 512, ["phone-circle-down"], "e11d", "M414.8 225.7c-87.55-87.55-229.1-87.55-317.5 0C84.89 238 82.73 256.1 91.97 271.8l24.1 38.53c9.535 15.21 28.61 21.44 45.33 14.87c.0332-.0137-.0234 0 0 0l48.4-19.36C224.1 299.5 234.4 283.8 232.8 267.6L231.7 257.1c16.03-3.039 32.43-3.039 48.45-.0137l-1.051 10.64c-1.578 16.61 7.746 31.94 23.24 38.15l48.26 19.31c16.73 6.631 35.75 .3125 45.32-14.89l23.1-38.49C429.3 256.1 427.1 238 414.8 225.7zM392.8 254.8l-24.03 38.55c-.1992 .3301-.4316 .6309-.6973 .8926c-1.457 1.459-3.711 1.969-5.635 1.219l-48.18-19.28c-2.254-.9062-3.525-2.971-3.293-5.35l2.42-24.43c.752-7.646-4.033-14.75-11.4-16.93c-30.11-8.893-61.96-8.881-92.1 0C202.5 231.6 197.8 238.8 198.5 246.4l2.43 24.46c.2324 2.221-1.17 4.465-3.182 5.324L149.6 295.4C147.2 296.3 144.5 295.4 143.2 293.3L119.1 254.8C117.8 252.7 118.1 250.1 119.9 248.3c75.06-75.06 197.2-75.06 272.3 0C393.9 250 394.2 252.6 392.8 254.8zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-play": [512, 512, [61469, "play-circle"], "f144", "M228.5 147.5C224.7 145.2 220.3 144 216 144C202.2 144 192 155.3 192 168v176c0 12.8 10.31 24 24 24c4.344 0 8.68-1.18 12.52-3.523l144-88C379.6 272.1 384 264.4 384 256c0-8.359-4.352-16.12-11.48-20.48L228.5 147.5zM224 329.7V182.3l120.7 73.73L224 329.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-plus": [512, 512, ["plus-circle"], "f055", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256S512 397.4 512 256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 240h-80V160c0-8.844-7.156-16-16-16S240 151.2 240 160v80H160C151.2 240 144 247.2 144 256S151.2 272 160 272h80V352c0 8.844 7.156 16 16 16s16-7.156 16-16V272H352c8.844 0 16-7.156 16-16S360.8 240 352 240z"],
    "circle-q": [512, 512, [], "e11e", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 128C185.4 128 128 185.4 128 256s57.41 128 128 128c29.52 0 56.4-10.45 78.08-27.3l22.61 22.61C359.8 382.4 363.9 384 368 384s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-22.61-22.61C373.6 312.4 384 285.5 384 256C384 185.4 326.6 128 256 128zM334.1 311.5l-34.77-34.77c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l34.77 34.77C295.8 345.3 276.7 352 256 352c-52.94 0-96-43.06-96-96s43.06-96 96-96s96 43.06 96 96C352 276.7 345.3 295.8 334.1 311.5z"],
    "circle-quarter": [512, 512, [], "e11f", "M248.1 7.422C243.6 3.4 238 1.248 231.9 1.248c-.7949 0-1.596 .0371-2.404 .1113C109.7 13.69 13.69 109.7 1.375 229.5c-.6875 6.766 1.5 13.48 6.062 18.53S18.47 256 25.25 256H232C245.3 256 256 245.3 256 232V25.23C256 18.44 253.1 11.97 248.1 7.422zM224 224H34.29C48.33 126.1 126.3 48.13 224 34.26V224z"],
    "circle-question": [512, 512, [62108, "question-circle"], "f059", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM240 344c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S253.3 344 240 344zM285.6 128H226.4C189.8 128 160 157.8 160 194.4V204c0 8.844 7.156 16 16 16S192 212.8 192 204V194.4C192 175.4 207.4 160 226.4 160h59.25C304.6 160 320 175.4 320 194.4c0 12.48-6.781 24-17.06 29.72L242.5 254.3C231.1 260.7 224 272.7 224 285.8V304C224 312.8 231.2 320 240 320S256 312.8 256 304V285.8c0-1.453 .7813-2.797 1.438-3.172l60.41-30.22C338.9 240.7 352 218.5 352 194.4C352 157.8 322.2 128 285.6 128z"],
    "circle-r": [512, 512, [], "e120", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM368 208C368 163.9 332.1 128 288 128H176C167.2 128 160 135.2 160 144v224C160 376.8 167.2 384 176 384S192 376.8 192 368V288h70.35l77.5 90.41C343 382.1 347.5 384 352 384c3.688 0 7.406-1.266 10.41-3.859c6.719-5.75 7.5-15.84 1.75-22.55l-60.97-71.13C340.1 279.3 368 246.9 368 208zM288 256H192V160h96c26.47 0 48 21.53 48 48S314.5 256 288 256z"],
    "circle-radiation": [512, 512, [63418, "radiation-alt"], "2622", "M306.3 295.6c-4.672-7.531-14.53-9.812-22.05-5.094c-7.484 4.688-9.766 14.53-5.078 22.03l41.83 66.97c1.234 2.031 .0156 3.312-.6875 3.781c-38.89 22.09-90.39 21.81-128.4 .1562c-.5625-.375-2.266-1.75-.9219-3.875l41.84-67.13c4.672-7.5 2.391-17.38-5.109-22.03c-7.516-4.719-17.39-2.406-22.05 5.094l-41.8 67.06c-5.094 8.062-6.688 17.44-4.516 26.34c2.25 9.188 8.359 17.47 16.48 22.22C199.9 424.9 227.6 432 256 432c28.19 0 55.88-7.167 80.14-20.92c7.891-4.5 14.02-12.62 16.36-21.72c2.297-8.906 .8125-18.31-4.281-26.66L306.3 295.6zM211.1 263.2C211.7 254.4 205.3 248.4 195.4 247.8L116.5 250.5c-2-.5625-2.859-1.656-2.938-2.469c.2031-22.31 6.297-44.47 17.62-64.09c11.39-19.72 27.52-36.09 46.38-47.13c.6406-.3438 2.719-1.094 3.891 1.125l37.22 69.78C222.9 215.5 232.5 218.5 240.3 214.3c7.797-4.156 10.75-13.84 6.594-21.66L209.7 122.1c-4.422-8.438-11.69-14.5-20.45-17.06C180.2 103.2 169.1 104.4 161.7 109C137.8 123.1 117.6 143.4 103.5 167.9c-14.08 24.41-21.66 52-21.91 79.91C81.55 256.1 85.53 266.3 92.23 272.9C98.58 279.1 107.1 282.5 116.5 282.5l80.03-2.75C205.4 279.4 212.3 272 211.1 263.2zM408.5 167.9c-14.09-24.41-34.2-44.75-58.27-58.94c-7.891-4.562-17.97-5.75-27.02-3.25c-8.828 2.469-16.22 8.438-20.91 17l-37.17 69.91c-4.156 7.781-1.188 17.47 6.609 21.62c7.812 4.188 17.5 1.188 21.64-6.625l37.08-69.72c1.188-2.125 3.078-1.531 3.625-1.312c19.22 11.34 35.36 27.69 46.69 47.31c11.39 19.75 17.48 41.91 17.62 63.75c-.0469 .6875 .6094 2.938-2.922 2.781l-79.06-2.656c-8 .75-16.22 6.625-16.52 15.47c-.2969 8.812 6.609 16.22 15.45 16.53c0 0 79.95 2.688 80.44 2.688c8.953 0 17.28-3.25 23.55-9.25c6.844-6.531 10.98-15.97 11.06-25.47C430.3 220.1 422.7 192.5 408.5 167.9zM256 16C123.5 16 16 123.4 16 256s107.5 240 240 240s240-107.4 240-240S388.5 16 256 16zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM232 256c0 13.25 10.75 24 24 24S280 269.3 280 256c0-13.26-10.75-24-24-24S232 242.7 232 256z"],
    "circle-right": [512, 512, [61838, "arrow-alt-circle-right"], "f35a", "M292.3 135c-11.48-11.47-28.59-14.88-43.59-8.688C233.7 132.6 224 147.1 224 163.3V192H152C129.9 192 112 209.9 112 232v48C112 302.1 129.9 320 152 320H224v28.69c0 16.25 9.688 30.75 24.69 36.97c14.95 6.188 32 2.812 43.48-8.562l96.11-92.81c15.12-15.12 15.33-41.25-.2031-56.75L292.3 135zM365.9 261.5l-96 92.69C265 359 256 356.1 256 348.7V288H152C147.6 288 144 284.4 144 280v-48C144 227.6 147.6 224 152 224H256V163.3c0-6.414 8.047-11.26 13.86-5.471l95.8 92.5C369.9 254.5 367.5 259.9 365.9 261.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-s": [512, 512, [], "e121", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM260.2 240.6C209.4 226.1 187.7 218.1 192.8 190.4c1.094-5.953 4.469-14.41 14.38-20.81c13.41-8.672 42.06-15.94 102.2-1.062c8.719 2.094 17.25-3.125 19.38-11.69c2.125-8.578-3.125-17.25-11.69-19.38c-57.16-14.11-99.94-12.39-127.2 5.25c-15.22 9.844-25.34 24.73-28.5 41.92C150.3 244.2 209 260 251.8 271.5c50.78 13.66 72.47 22.53 67.38 50.22c-1.938 10.55-6.969 17.78-15.81 22.77c-23.06 12.92-70.81 8.766-121.7-10.61c-8.188-3.094-17.5 .9844-20.62 9.266c-3.156 8.25 1 17.5 9.25 20.64c15.66 5.953 57.13 20.16 96.94 20.16c18.59 0 36.81-3.094 51.84-11.56c17.06-9.594 27.97-25.11 31.62-44.88C361.7 267.9 303 252.1 260.2 240.6z"],
    "circle-small": [320, 512, [], "e122", "M160 128c70.58 0 128 57.42 128 128s-57.42 128-128 128s-128-57.42-128-128S89.42 128 160 128zM160 96C71.63 96 0 167.6 0 256s71.63 160 160 160s160-71.64 160-160S248.4 96 160 96z"],
    "circle-sort": [512, 512, ["sort-circle"], "e030", "M347.1 288H164.6C148.2 288 140.1 307.9 151.8 319.4L243 410.6C246.4 414.1 251.1 416 256 416s9.594-2 13.09-5.375l91.03-91.25C371.8 307.9 363.5 288 347.1 288zM256 378.4L197.6 320h116.6L256 378.4zM269.1 101.4C265.6 97.1 260.9 95.1 256 95.1S246.4 97.87 243 101.4L151.8 192.6C140.1 204.1 148.2 224 164.6 224h182.6c16.38 0 24.62-19.88 13-31.38L269.1 101.4zM197.6 192L256 133.6L314.3 192H197.6zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-sort-down": [512, 512, ["sort-circle-down"], "e031", "M347.4 288H164.9c-16.38 0-24.62 19.88-13 31.38L243 410.6C246.5 414 251.1 416 256 416s9.719-1.875 13.09-5.375l91.16-91.25C371.9 307.9 363.8 288 347.4 288zM256 378.4L197.8 320h116.6L256 378.4zM267.3 100.8c-6.25-6.25-16.38-6.25-22.62 0l-96 96C142.6 203 142.8 212.9 148.9 219C155.1 225.1 165 225.3 171.3 219.3L256 134.6l84.75 84.63c6.25 6 16.12 5.875 22.25-.25s6.25-16 .25-22.25L267.3 100.8zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-sort-up": [512, 512, ["sort-circle-up"], "e032", "M164.6 223.1L347.1 224c16.38 0 24.62-19.88 13-31.38L269 101.4C265.5 97.1 260.9 95.1 256 95.1S246.3 97.87 242.9 101.4L151.8 192.6C140.1 204.1 148.2 223.1 164.6 223.1zM256 133.6L314.3 192H197.6L256 133.6zM340.8 292.8L256 377.4L171.3 292.8C165 286.8 155.1 286.9 149 293s-6.25 16-.25 22.25l96 96c6.25 6.25 16.25 6.25 22.5 0l96-96c6-6.25 5.875-16.12-.25-22.25S347 286.8 340.8 292.8zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-star": [512, 512, ["star-circle"], "e123", "M391.3 200.5l-82.33-11.98L272.2 114C268.9 107.4 262.4 103.1 255.1 104c-6.41 0-12.82 3.318-16.13 10.02L203 188.5L120.7 200.5C105.9 202.6 100 220.8 110.7 231.2l59.57 57.93l-14.09 81.83C154.2 382.6 163.5 392 173.1 392c2.773 0 5.629-.6602 8.371-2.109L256 351.2l73.65 38.64c2.736 1.436 5.582 2.088 8.352 2.088c10.46 0 19.8-9.34 17.8-21.04l-14.09-81.83l59.57-57.93C411.1 220.8 406.1 202.6 391.3 200.5zM313.4 272c-3.781 3.678-5.508 8.984-4.613 14.18l10.71 62.18l-56.01-29.39c-4.654-2.443-10.21-2.443-14.87 0l-56.01 29.39l10.71-62.18c.8945-5.199-.832-10.51-4.613-14.18L153.4 228l62.55-9.102c5.207-.7578 9.709-4.027 12.04-8.744L256 153.5l28.01 56.67c2.33 4.717 6.832 7.986 12.04 8.744l62.55 9.102L313.4 272zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M320 160H192C174.4 160 160 174.4 160 192v128c0 17.6 14.4 32 32 32h128c17.6 0 32-14.4 32-32V192C352 174.4 337.6 160 320 160zM320 320H192V192h128V320zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-t": [512, 512, [], "e124", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM368 160h-224C135.2 160 128 167.2 128 176S135.2 192 144 192h96v176c0 8.844 7.156 16 16 16s16-7.156 16-16V192h96C376.8 192 384 184.8 384 176S376.8 160 368 160z"],
    "circle-three-quarters": [512, 512, [], "e125", "M504.6 263.9C500 258.9 493.5 256 486.8 256H256V25.23c0-6.797-2.875-13.27-7.906-17.81C243.6 3.4 238 1.248 231.9 1.248c-.7969 0-1.602 .0371-2.414 .1113C98.69 14.81 0 124.3 0 256c0 141.2 114.8 256 256 256c131.7 0 241.2-98.69 254.6-229.5C511.3 275.7 509.1 268.1 504.6 263.9zM256 480c-123.5 0-224-100.5-224-224c0-112.4 82.1-206.3 192-221.7V256c0 17.67 14.33 32 32 32h221.7C462.1 398.1 368.3 480 256 480z"],
    "circle-trash": [512, 512, ["trash-circle"], "e126", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 144h-48l-5.789-11.58C296.9 129.7 294.1 128 291.1 128H220.9C217.9 128 215.1 129.7 213.8 132.4L208 144H160C151.2 144 144 151.2 144 160c0 8.836 7.164 16 16 16h.3672l8.492 174.3C170.1 369.2 185.8 384 204.8 384h102.4c18.94 0 34.72-14.81 35.94-33.97L351.6 176H352c8.838 0 16-7.164 16-16C368 151.2 360.8 144 352 144zM311.2 348.2C311.1 350.2 309.1 352 307.2 352H204.8c-1.922 0-3.859-1.828-3.969-3.531L192.4 176h127.2L311.2 348.2z"],
    "circle-u": [512, 512, [], "e127", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 144c-8.844 0-16 7.156-16 16v129.8C336 332.9 300.1 368 256 368s-80-35.09-80-78.25V160c0-8.844-7.156-16-16-16S144 151.2 144 160v129.8C144 350.5 194.3 400 256 400s112-49.47 112-110.3V160C368 151.2 360.8 144 352 144z"],
    "circle-up": [512, 512, [61467, "arrow-alt-circle-up"], "f35b", "M284.3 123.7C269.2 108.6 243 108.4 227.5 123.9l-92.5 95.8C123.6 231.2 120.2 248.3 126.3 263.3C132.6 278.3 147.1 288 163.3 288H192v72c0 22.06 17.94 40 40 40h48c22.06 0 40-17.94 40-40V288h28.69c16.25 0 30.75-9.688 36.97-24.69c6.188-14.95 2.812-32-8.562-43.48L284.3 123.7zM348.7 256H288l.0006 104c0 4.406-3.594 8-8.001 8h-48c-4.406 0-7.999-3.594-7.999-8L224 256H163.3C156.9 256 152.1 247.1 157.8 242.1l92.5-95.8c4.162-4.203 9.533-1.797 11.12-.2031l92.69 96C359 246.1 356.1 256 348.7 256zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-up-left": [512, 512, [], "e128", "M323.9 233.4l20.29-20.29c11.49-11.49 14.89-28.59 8.684-43.59c-6.199-14.95-20.64-24.62-36.8-24.7l-133.6-2.332c-21.39 0-40.01 18.33-39.98 40.27l2.33 133.1c.0117 16.23 9.701 30.73 24.68 36.97c15 6.211 32.11 2.805 43.6-8.688l20.29-20.28l50.91 50.91c15.6 15.6 40.97 15.6 56.57 0l33.94-33.94c15.6-15.6 15.6-40.97 0-56.57L323.9 233.4zM352.2 318.2L318.2 352.2c-3.115 3.117-8.197 3.117-11.31 0L233.4 278.6l-42.91 42.91c-4.537 4.535-13.65 2.27-13.67-5.934l-2.332-133.1c-.0293-5.918 5.471-8.012 7.725-8.008l133.4 2.34c6.861 0 11.19 8.41 5.932 13.67l-42.91 42.91l73.54 73.54C355.3 310 355.3 315.1 352.2 318.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-up-right": [512, 512, [], "e129", "M329.5 142.5l-133.6 2.332c-16.16 .0781-30.6 9.742-36.8 24.7c-6.209 15-2.807 32.1 8.684 43.59l20.29 20.29L137.2 284.3c-15.6 15.6-15.6 40.97 0 56.57l33.94 33.94c15.6 15.6 40.97 15.6 56.57 0l50.91-50.91l20.29 20.28c11.49 11.49 28.59 14.9 43.6 8.688c14.98-6.234 24.67-20.74 24.68-36.97l2.33-133.1C369.5 160.8 350.9 142.5 329.5 142.5zM335.2 315.6c-.0176 8.203-9.131 10.47-13.67 5.934l-42.91-42.91L205.1 352.2c-3.115 3.117-8.197 3.117-11.31 0L159.8 318.2c-3.115-3.117-3.115-8.201 0-11.31l73.54-73.54L190.5 190.5C185.2 185.2 189.3 176.8 196.1 176.8l133.7-2.352c2.254-.0039 7.754 2.09 7.725 8.008L335.2 315.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-user": [512, 512, [62142, "user-circle"], "f2bd", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-47.24 0-91.04-14.78-127.2-39.84C132.9 390.9 173.8 352 224 352h64c50.25 0 91.14 38.94 95.21 88.16C347 465.2 303.2 480 256 480zM411.7 416.7C397.6 361.3 347.7 320 288 320H224c-59.73 0-109.6 41.3-123.7 96.72C58.27 375.1 32 319 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224C480 319 453.7 375.1 411.7 416.7zM256 128C211.8 128 176 163.8 176 208C176 252.2 211.8 288 256 288s80-35.82 80-80C336 163.8 300.2 128 256 128zM256 256C229.5 256 208 234.5 208 208S229.5 160 256 160s48 21.53 48 48S282.5 256 256 256z"],
    "circle-v": [512, 512, [], "e12a", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM375.2 145.7c-7.938-3.969-17.5-.7187-21.47 7.156L256 348.2L158.3 152.8C154.3 144.1 144.8 141.7 136.8 145.7c-7.906 3.969-11.11 13.56-7.156 21.47l112 224C244.4 396.6 249.9 400 256 400s11.59-3.438 14.31-8.844l112-224C386.3 159.3 383.1 149.7 375.2 145.7z"],
    "circle-video": [512, 512, ["video-circle"], "e12b", "M409.2 178.9c-4.266-2.984-9.719-3.703-14.64-1.922L320 204.1V192c0-17.67-14.33-32-32-32H160C142.3 160 128 174.3 128 192v128c0 17.67 14.33 32 32 32h128c17.67 0 32-14.33 32-32V307.9l74.53 27.1C396.3 335.7 398.2 336 400 336c3.234 0 6.453-.9844 9.172-2.891C413.5 330.1 416 325.2 416 320V192C416 186.8 413.5 181.9 409.2 178.9zM288 320H160V192h128V320zM384 297.2L320 273.9V238.1l64-23.27V297.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-w": [512, 512, [], "e12c", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM388.4 144.6C380 142.1 371 147.1 368.6 155.6L320 325.8l-48.61-170.2c-3.938-13.69-26.84-13.69-30.78 0L192 325.8L143.4 155.6C140.1 147.1 132 142.1 123.6 144.6c-8.5 2.406-13.42 11.28-11 19.78l64 224c3.938 13.69 26.84 13.69 30.78 0L256 218.3l48.61 170.2C306.6 395.3 312.8 400 319.9 400s13.48-4.75 15.45-11.59l64-224C401.8 155.9 396.9 147 388.4 144.6z"],
    "circle-waveform-lines": [512, 512, ["waveform-circle"], "e12d", "M272 136c-8.836 0-16 7.162-16 16v208c0 8.836 7.164 16 16 16s16-7.164 16-16v-208C288 143.2 280.8 136 272 136zM208 200C199.2 200 192 207.2 192 216v80c0 8.836 7.164 16 16 16S224 304.8 224 296v-80C224 207.2 216.8 200 208 200zM144 160C135.2 160 128 167.2 128 176v160C128 344.8 135.2 352 144 352S160 344.8 160 336v-160C160 167.2 152.8 160 144 160zM400 224C391.2 224 384 231.2 384 240v32C384 280.8 391.2 288 400 288S416 280.8 416 272v-32C416 231.2 408.8 224 400 224zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM336 184c-8.836 0-16 7.162-16 16v112c0 8.836 7.164 16 16 16s16-7.164 16-16v-112C352 191.2 344.8 184 336 184z"],
    "circle-x": [512, 512, [], "e12e", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM362.4 131.8c-6.688-5.75-16.8-4.938-22.55 1.75L256 231.4l-83.86-97.84C166.4 126.9 156.3 126.2 149.6 131.8c-6.719 5.75-7.5 15.88-1.734 22.56L234.9 256l-87.08 101.6c-5.766 6.688-4.984 16.81 1.734 22.56C152.6 382.8 156.3 384 160 384c4.5 0 8.984-1.906 12.14-5.594L256 280.6l83.86 97.84C343 382.1 347.5 384 352 384c3.688 0 7.391-1.281 10.41-3.844c6.719-5.75 7.5-15.88 1.734-22.56L277.1 256l87.08-101.6C369.9 147.7 369.1 137.6 362.4 131.8z"],
    "circle-xmark": [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M331.3 180.7c-6.25-6.25-16.38-6.25-22.62 0L256 233.4L203.3 180.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L233.4 256L180.7 308.7c-6.25 6.25-6.25 16.38 0 22.62c6.246 6.246 16.37 6.254 22.62 0L256 278.6l52.69 52.69c6.246 6.246 16.37 6.254 22.62 0c6.25-6.25 6.25-16.38 0-22.62L278.6 256l52.69-52.69C337.6 197.1 337.6 186.9 331.3 180.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256S512 397.4 512 256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "circle-y": [512, 512, [], "e12f", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM355.9 149.6L256 266.1L156.1 149.6C150.4 142.9 140.3 142.2 133.6 147.8c-6.719 5.75-7.5 15.88-1.734 22.56L240 296.6V384c0 8.844 7.156 16 16 16s16-7.156 16-16V296.6l108.1-126.2c5.766-6.688 4.984-16.81-1.734-22.56C371.7 142.2 361.6 142.9 355.9 149.6z"],
    "circle-z": [512, 512, [], "e130", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 352H194.8l169.4-197.6c4.062-4.75 5-11.41 2.375-17.09C363.9 131.6 358.3 128 352 128H160C151.2 128 144 135.2 144 144S151.2 160 160 160h157.2l-169.4 197.6c-4.062 4.75-5 11.41-2.375 17.09C148.1 380.4 153.8 384 160 384h192c8.844 0 16-7.156 16-16S360.8 352 352 352z"],
    "citrus": [512, 512, [], "e2f4", "M463.9 151.1c-4.469-7.703-14.38-10.25-21.84-5.828c-7.656 4.422-10.28 14.2-5.844 21.86C454.4 199.5 464 235.4 464 272c0 114.7-93.31 208-208 208s-208-93.31-208-208S141.3 64 256 64c12.42 0 24.66 1.463 36.76 3.621C289.9 76.65 288 86.05 288 96v16C288 120.8 295.2 128 304 128H384c53.02 0 96-42.98 96-96V16c0-8.836-7.164-16-16-16H384c-31.23 0-58.71 15.16-76.25 38.26C290.8 34.52 273.6 31.1 256 31.1c-132.3 0-240 107.7-240 239.1S123.7 512 256 512s240-107.7 240-240C496 229.8 484.9 188.3 463.9 151.1zM384 32h64c0 35.29-28.71 64-64 64h-64C320 60.71 348.7 32 384 32z"],
    "citrus-slice": [512, 512, [], "e2f5", "M425.1 4.688C422.1 1.688 418 0 413.8 0c-4.25 0-8.314 1.688-11.31 4.688L4.689 402.4C1.688 405.4 0 409.5 0 413.8s1.688 8.314 4.689 11.32C62.64 483 138.8 512 214.9 512c76.15 0 152.3-28.98 210.2-86.93C540.1 309.2 540.1 120.6 425.1 4.688zM367.4 344.8l-83.94-83.94C293.8 244.1 297.4 226.1 294.9 208h120.1C416.7 256.7 400.9 305.5 367.4 344.8zM250.8 250.8C236.2 265.2 213 266.7 195.8 256.6l60.91-60.91C267.2 213.1 265.7 235.8 250.8 250.8zM218.8 296c15.18 0 29.66-4.42 42.09-12.54l84.48 84.48c-36.38 31.09-82.06 48.17-130.4 48.17c-2.342 0-4.578-.5313-6.906-.6113V294.1C211.6 295.4 215.1 296 218.8 296zM283.1 176c-.8594-1.293-2.045-2.414-2.99-3.666l87.87-87.86C390.9 111.4 404.1 143.1 411.4 176H283.1zM172.3 280.1C173.6 281.1 174.7 282.2 176 283.1v128.1c-33.71-6.623-65.12-21.55-91.55-44.14L172.3 280.1zM402.5 402.4c-99.56 99.62-259.4 103.3-363.5 10.97l22.84-22.84c42.48 37.1 96.16 57.55 153.1 57.55c62.27 0 120.8-24.26 164.9-68.32c87.11-87.11 90.54-226.4 10.74-317.1l22.86-22.86C505.7 143 502.1 302.8 402.5 402.4z"],
    "city": [640, 512, [63055], "1f3d9", "M128 416H96c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-32C160 430.3 145.7 416 128 416zM128 480H96v-32h32V480zM128 160H96C78.33 160 64 174.3 64 192v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32V192C160 174.3 145.7 160 128 160zM128 224H96V192h32V224zM128 288H96c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-32C160 302.3 145.7 288 128 288zM128 352H96v-32h32V352zM256 416H224c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-32C288 430.3 273.7 416 256 416zM256 480H224v-32h32V480zM544 288h-32c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-32C576 302.3 561.7 288 544 288zM544 352h-32v-32h32V352zM592 192L512 192V48C512 21.49 490.5 0 464 0l-128 .0098c-26.51 0-48 21.49-48 48v47.1H224V16C224 7.199 216.8 0 208 0S192 7.199 192 16V96H128V16C128 7.199 120.8 0 112 0S96 7.199 96 16V96L48 96.01c-26.51 0-48 21.49-48 48L0 496C0 504.8 7.199 512 16 512S32 504.8 32 496V152C32 138.7 42.75 128 56 128H320V56C320 42.74 330.7 32 344 32h112C469.3 32 480 42.74 480 56V224h104C597.3 224 608 234.7 608 248v248c0 8.799 7.199 16 16 16s16-7.201 16-16V240C640 213.5 618.5 192 592 192zM544 416h-32c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-32C576 430.3 561.7 416 544 416zM544 480h-32v-32h32V480zM416 192h-32c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32V224C448 206.3 433.7 192 416 192zM416 256h-32V224h32V256zM416 64h-32c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32V96C448 78.33 433.7 64 416 64zM416 128h-32V96h32V128zM256 160H224C206.3 160 192 174.3 192 192v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32V192C288 174.3 273.7 160 256 160zM256 224H224V192h32V224zM256 288H224c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-32C288 302.3 273.7 288 256 288zM256 352H224v-32h32V352z"],
    "clapperboard": [512, 512, [], "e131", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM433.4 64l-96 96H230.6l96-96H433.4zM281.4 64l-96 96H78.63l96-96H281.4zM32 96c0-17.64 14.36-32 32-32h65.38l-96 96H32V96zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V192h448V416zM480 160h-97.38l87.17-87.17C476 78.67 480 86.82 480 96V160z"],
    "clapperboard-play": [512, 512, [], "e132", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM433.4 64l-96 96H230.6l96-96H433.4zM281.4 64l-96 96H78.63l96-96H281.4zM32 96c0-17.64 14.36-32 32-32h65.38l-96 96H32V96zM480 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V192h448V416zM480 160h-97.38l87.17-87.17C476 78.67 480 86.82 480 96V160zM205.6 412.5C209.6 414.8 214.1 416 218.7 416c5.125 0 10.16-1.511 14.38-4.276l106.6-68.94C347.4 337.8 352 329.3 352 319.1c0-9.281-4.628-17.81-12.35-22.8L233 228.3c-8.312-5.422-18.75-5.763-27.47-.7783C197.2 232.3 192 241.3 192 251v137.9C192 398.7 197.2 407.7 205.6 412.5zM224 260.5L315.1 320L224 379.5V260.5z"],
    "clarinet": [640, 512, [], "f8ad", "M272 231.1c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1S296 269.2 296 255.1C296 242.7 285.3 231.1 272 231.1zM616 111.1c-4.75 0-9.375 1.375-13.25 3.1l-66 43.1L480 159.1V127.1h16c8.801 0 16-7.199 16-15.1C512 103.2 504.8 96 496 96h-256C231.2 96 224 103.2 224 111.1c0 8.801 7.199 15.1 16 15.1H256v31.1L101.3 159.1c-3.5 0-6.875 .5015-10.12 1.625L21.82 184.8C8.821 189.1 0 201.4 0 215.1v81.82c0 13.77 8.81 26 21.87 30.37l69.25 23.12c3.25 1.125 6.625 1.625 10.12 1.625l435.5 .0001l66 43.1c7.375 4.875 16.75 5.375 24.62 1.125C635.1 392.1 640 384.9 640 375.1V135.1C640 122.7 629.3 111.1 616 111.1zM384 127.1h64v31.1l-64 .0002V127.1zM288 127.1h64v31.1L288 159.1V127.1zM608 360.1l-61.63-41L101.3 319.1L32 296.1v-81.1l69.25-22.1h445.1L608 150.1V360.1zM368 231.1c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1s24-10.75 24-23.1C392 242.7 381.3 231.1 368 231.1zM464 231.1c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1s24-10.75 24-23.1C488 242.7 477.3 231.1 464 231.1z"],
    "claw-marks": [512, 512, [], "f6c2", "M427.3 404.7C424.3 401.7 420.3 400 416 400l-48 .0094L368 352c0-4.25-1.688-8.312-4.688-11.31l-96-96C264.3 241.7 260.3 240 256 240L208 240L208 192c0-4.25-1.688-8.312-4.688-11.31l-176-176C24.19 1.562 20.09 0 16 0C7.473 0 0 6.865 0 16c0 4.094 1.562 8.188 4.688 11.31L176 198.6V256c0 8.844 7.156 16 16 16h57.38L336 358.6V416c0 8.844 7.156 16 16 16h57.38l75.31 75.31C487.8 510.4 491.9 512 496 512c8.527 0 16-6.865 16-16c0-4.094-1.562-8.188-4.688-11.31L427.3 404.7zM240 38.63V96c0 8.844 7.156 16 16 16h57.38L368 166.6V224c0 8.844 7.156 16 16 16h57.38l43.31 43.31C487.8 286.4 491.9 288 496 288C504.5 288 512 281.1 512 272c0-4.094-1.562-8.188-4.688-11.31l-48-48C456.3 209.7 452.3 208 448 208l-48 .0122L400 160c0-4.25-1.688-8.312-4.688-11.31l-64-64C328.3 81.69 324.3 80 320 80l-48 .0141L272 32c0-4.25-1.688-8.312-4.688-11.31l-16-16C248.2 1.562 244.1 0 240 0C231.5 0 224 6.865 224 16c0 4.094 1.562 8.188 4.688 11.31L240 38.63zM171.3 372.7C168.3 369.7 164.3 368 160 368l-47.1 .0099L112 320c0-4.25-1.688-8.312-4.688-11.31l-80-80C24.19 225.6 20.09 224 16 224C7.473 224 0 230.9 0 240c0 4.094 1.562 8.188 4.688 11.31L80 326.6V384c0 8.844 7.156 16 16 16h57.38l107.3 107.3C263.8 510.4 267.9 512 272 512c8.527 0 16-6.865 16-16c0-4.094-1.562-8.188-4.688-11.31L171.3 372.7z"],
    "clipboard": [384, 512, [62248], "1f4cb", "M112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64z"],
    "clipboard-check": [384, 512, [], "f46c", "M320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM84.69 299.3l64 64C151.8 366.4 155.9 368 160 368s8.188-1.562 11.31-4.688l128-128c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L160 329.4L107.3 276.7c-6.25-6.25-16.38-6.25-22.62 0S78.44 293.1 84.69 299.3z"],
    "clipboard-list": [384, 512, [], "f46d", "M112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM72 256c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24C82.75 232 72 242.7 72 256zM96 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 338.7 109.3 328 96 328zM304 240h-128C167.2 240 160 247.2 160 256s7.156 16 16 16h128C312.8 272 320 264.8 320 256S312.8 240 304 240zM304 336h-128C167.2 336 160 343.2 160 352s7.156 16 16 16h128c8.844 0 16-7.156 16-16S312.8 336 304 336z"],
    "clipboard-list-check": [384, 512, [], "f737", "M304 336h-128C167.2 336 160 343.2 160 352s7.156 16 16 16h128c8.844 0 16-7.156 16-16S312.8 336 304 336zM304 240h-96C199.2 240 192 247.2 192 256s7.156 16 16 16h96C312.8 272 320 264.8 320 256S312.8 240 304 240zM96 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 338.7 109.3 328 96 328zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM68.25 229.2c-6 6.5-5.594 16.59 .9062 22.59l34.66 32C106.9 286.6 110.8 288 114.7 288c4.203 0 8.406-1.656 11.55-4.938l61.33-64c6.125-6.375 5.906-16.5-.4844-22.62c-6.359-6.094-16.48-5.906-22.61 .5L113.1 249.6L90.84 228.3C84.39 222.3 74.22 222.6 68.25 229.2z"],
    "clipboard-medical": [384, 512, [], "e133", "M112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.34-28.65-64-64-64S128 28.66 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM112 336H160V384c0 8.836 7.164 16 16 16h32c8.836 0 16-7.164 16-16v-48h48c8.836 0 16-7.164 16-16V288c0-8.836-7.164-16-16-16H224V224c0-8.836-7.164-16-16-16h-32C167.2 208 160 215.2 160 224v48H112C103.2 272 96 279.2 96 288v32C96 328.8 103.2 336 112 336z"],
    "clipboard-prescription": [384, 512, [], "f5e8", "M112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM80 352c0 8.844 7.156 16 16 16s16-7.156 16-16V304h41.38l64 64l-36.69 36.69c-6.25 6.25-6.25 16.38 0 22.62C183.8 430.4 187.9 432 192 432s8.188-1.562 11.31-4.688L240 390.6l36.69 36.69C279.8 430.4 283.9 432 288 432s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L262.6 368l36.69-36.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L240 345.4l-44.68-44.68C221.1 292.4 240 268.5 240 240c0-35.28-28.7-64-64-64H96C87.16 176 80 183.2 80 192V352zM112 208h64c17.64 0 32 14.34 32 32s-14.36 32-32 32h-64V208z"],
    "clipboard-user": [384, 512, [], "f7f3", "M320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM80 416c0 8.836 7.164 16 16 16s16-7.164 16-16c0-26.51 21.49-48 48-48h64c26.51 0 48 21.49 48 48c0 8.836 7.164 16 16 16s16-7.164 16-16c0-44.18-35.82-80-80-80H160C115.8 336 80 371.8 80 416zM256 240c0-35.35-28.65-64-64-64s-64 28.65-64 64s28.65 64 64 64S256 275.3 256 240zM160 240c0-17.64 14.36-32 32-32s32 14.36 32 32s-14.36 32-32 32S160 257.6 160 240z"],
    "clock": [512, 512, [61463, "clock-four"], "1f553", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM354.1 294.1L272 246.8V112C272 103.2 264.8 96 256 96S240 103.2 240 112V256c0 5.719 3.047 11 8 13.86l90.06 52C340.6 323.3 343.3 324 346 324c5.531 0 10.91-2.859 13.88-8C364.3 308.3 361.7 298.6 354.1 294.1z"],
    "clock-desk": [448, 512, [], "e134", "M224 0C100.3 0 0 100.3 0 224v208C0 476.1 35.88 512 80 512h288c44.13 0 80-35.88 80-80V224C448 100.3 347.7 0 224 0zM416 432c0 26.47-21.53 48-48 48h-288C53.53 480 32 458.5 32 432v-93.05C71.15 404.2 142.4 448 224 448s152.8-43.81 192-109.1V432zM224 416c-105.9 0-192-86.13-192-192s86.13-192 192-192s192 86.13 192 192S329.9 416 224 416zM240 232V112c0-8.844-7.149-16-15.99-16S208 103.2 208 112v128c0 5.031 2.375 9.781 6.406 12.81l64 48C281.3 302.1 284.6 304 287.1 304c4.875 0 9.672-2.219 12.81-6.406c5.312-7.062 3.875-17.09-3.203-22.41L240 232z"],
    "clock-eight": [512, 512, [], "e345", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 96C247.2 96 240 103.2 240 112v134.8L157.9 294.1C150.3 298.6 147.7 308.3 152.1 316c2.969 5.141 8.344 8 13.88 8c2.719 0 5.469-.6875 7.984-2.141l90.06-52C268.1 267 272 261.7 272 256V112C272 103.2 264.8 96 256 96z"],
    "clock-eight-thirty": [512, 512, [], "e346", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM248 242.1l-90.06 52C150.3 298.6 147.7 308.3 152.1 316s14.22 10.25 21.86 5.859L240 283.7V400c0 8.844 7.156 16 16 16s16-7.156 16-16V256c0-5.719-3.047-11-8-13.86C259.1 239.3 252.9 239.3 248 242.1z"],
    "clock-eleven": [512, 512, [], "e347", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 96C247.2 96 240 103.2 240 112v84.3L217.9 157.9C213.4 150.3 203.6 147.6 196 152.1C188.3 156.5 185.7 166.3 190.1 173.9L242.1 264C245 269 250.4 272 256 272c1.375 0 2.766-.1719 4.141-.5469C267.1 269.6 272 263.2 272 256V112C272 103.2 264.8 96 256 96z"],
    "clock-eleven-thirty": [512, 512, [], "e348", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM217.9 157.9C213.4 150.3 203.6 147.6 196 152.1C188.3 156.5 185.7 166.3 190.1 173.9L240 260.3V400c0 8.844 7.156 16 16 16s16-7.156 16-16V256c0-2.812-.7344-5.562-2.141-8L217.9 157.9z"],
    "clock-five": [512, 512, [], "e349", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM272 251.7V112C272 103.2 264.8 96 256 96S240 103.2 240 112V256c0 2.812 .7344 5.562 2.141 8l52 90.06c2.969 5.141 8.344 8 13.88 8c2.719 0 5.469-.6875 7.984-2.141c7.656-4.422 10.28-14.2 5.859-21.86L272 251.7z"],
    "clock-five-thirty": [512, 512, [], "e34a", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM269.9 248c-3.625-6.266-11.02-9.391-18-7.453C244.9 242.4 240 248.8 240 256v144c0 8.844 7.156 16 16 16s16-7.156 16-16V315.7l22.14 38.36c4.422 7.641 14.2 10.27 21.86 5.859c7.656-4.422 10.28-14.2 5.859-21.86L269.9 248z"],
    "clock-four-thirty": [512, 512, [], "e34b", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM354.1 294.1L264 242.1c-4.938-2.844-11.06-2.844-16 0C243 245 240 250.3 240 256v144c0 8.844 7.156 16 16 16s16-7.156 16-16V283.7l66.06 38.14c7.609 4.391 17.41 1.812 21.86-5.859C364.3 308.3 361.7 298.6 354.1 294.1z"],
    "clock-nine": [512, 512, [], "e34c", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 96C247.2 96 240 103.2 240 112v128H152c-8.844 0-16 7.156-16 16s7.156 16 16 16H256c8.844 0 16-7.156 16-16V112C272 103.2 264.8 96 256 96z"],
    "clock-nine-thirty": [512, 512, [], "e34d", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 240H152c-8.844 0-16 7.156-16 16s7.156 16 16 16H240v128c0 8.844 7.156 16 16 16s16-7.156 16-16V256C272 247.2 264.8 240 256 240z"],
    "clock-one": [512, 512, [], "e34e", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM316 152.1c-7.641-4.422-17.45-1.828-21.86 5.859L272 196.3V112C272 103.2 264.8 96 256 96S240 103.2 240 112V256c0 7.234 4.859 13.58 11.86 15.45C253.2 271.8 254.6 272 256 272c5.609 0 10.95-2.969 13.86-8l52-90.06C326.3 166.3 323.7 156.5 316 152.1z"],
    "clock-one-thirty": [512, 512, [], "e34f", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM316 152.1c-7.656-4.422-17.44-1.828-21.86 5.859L242.1 248C240.7 250.4 240 253.2 240 256v144c0 8.844 7.156 16 16 16s16-7.156 16-16V260.3l49.86-86.34C326.3 166.3 323.7 156.5 316 152.1z"],
    "clock-rotate-left": [512, 512, ["history"], "f1da", "M256 32C176.5 32 104.4 73.87 64 141.6V48C64 39.16 56.84 32 48 32S32 39.16 32 48v128C32 184.8 39.16 192 48 192h128C184.8 192 192 184.8 192 176S184.8 160 176 160H90.15C124.5 100.7 187.1 64 256 64c105.9 0 192 86.13 192 192s-86.13 192-192 192c-59.48 0-114.7-26.91-151.3-73.84c-5.438-7-15.48-8.281-22.47-2.75c-6.953 5.438-8.188 15.5-2.75 22.44C122.2 448.6 186.6 480 256 480c123.5 0 224-100.5 224-224S379.5 32 256 32zM256 128C247.2 128 240 135.2 240 144v128c0 5.031 2.375 9.781 6.406 12.81l64 48C313.3 334.1 316.6 336 319.1 336c4.875 0 9.672-2.219 12.81-6.406c5.312-7.062 3.875-17.09-3.203-22.41L272 264V144C272 135.2 264.8 128 256 128z"],
    "clock-seven": [512, 512, [], "e350", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 96C247.2 96 240 103.2 240 112v139.7l-49.86 86.34C185.7 345.7 188.3 355.5 196 359.9c2.516 1.453 5.266 2.141 7.984 2.141c5.531 0 10.91-2.859 13.88-8l52-90.06C271.3 261.6 272 258.8 272 256V112C272 103.2 264.8 96 256 96z"],
    "clock-seven-thirty": [512, 512, [], "e351", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM260.1 240.5C253.1 238.6 245.8 241.7 242.1 248l-52 90.06C185.7 345.7 188.3 355.5 196 359.9c7.609 4.406 17.41 1.812 21.86-5.859L240 315.7V400c0 8.844 7.156 16 16 16s16-7.156 16-16V256C272 248.8 267.1 242.4 260.1 240.5z"],
    "clock-six": [512, 512, [], "e352", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 96C247.2 96 240 103.2 240 112v248c0 8.844 7.156 16 16 16s16-7.156 16-16V112C272 103.2 264.8 96 256 96z"],
    "clock-six-thirty": [512, 512, [], "e353", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 240C247.2 240 240 247.2 240 256v144c0 8.844 7.156 16 16 16s16-7.156 16-16V256C272 247.2 264.8 240 256 240z"],
    "clock-ten": [512, 512, [], "e354", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 96C247.2 96 240 103.2 240 112v116.3L173.9 190.1C166.3 185.7 156.5 188.3 152.1 196C147.7 203.7 150.3 213.4 157.9 217.9L248 269.9C250.5 271.3 253.2 272 256 272s5.531-.7187 8-2.141C268.1 267 272 261.7 272 256V112C272 103.2 264.8 96 256 96z"],
    "clock-ten-thirty": [512, 512, [], "e355", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM173.9 190.1C166.3 185.7 156.5 188.3 152.1 196C147.7 203.7 150.3 213.4 157.9 217.9L240 265.2V400c0 8.844 7.156 16 16 16s16-7.156 16-16V256c0-5.719-3.047-11-8-13.86L173.9 190.1z"],
    "clock-three": [512, 512, [], "e356", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM360 240H272v-128C272 103.2 264.8 96 256 96S240 103.2 240 112V256c0 8.844 7.156 16 16 16h104c8.844 0 16-7.156 16-16S368.8 240 360 240z"],
    "clock-three-thirty": [512, 512, [], "e357", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM360 240H256C247.2 240 240 247.2 240 256v144c0 8.844 7.156 16 16 16s16-7.156 16-16v-128h88c8.844 0 16-7.156 16-16S368.8 240 360 240z"],
    "clock-twelve": [512, 512, [], "e358", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 96C247.2 96 240 103.2 240 112V256c0 8.844 7.156 16 16 16s16-7.156 16-16V112C272 103.2 264.8 96 256 96z"],
    "clock-twelve-thirty": [512, 512, [], "e359", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 136c-8.844 0-16 7.156-16 16v248c0 8.844 7.156 16 16 16s16-7.156 16-16V152C272 143.2 264.8 136 256 136z"],
    "clock-two": [512, 512, [], "e35a", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM338.1 190.1L272 228.3V112C272 103.2 264.8 96 256 96S240 103.2 240 112V256c0 5.719 3.047 11 8 13.86C250.5 271.3 253.2 272 256 272s5.531-.7187 8-2.141l90.06-52C361.7 213.4 364.3 203.7 359.9 196S345.7 185.7 338.1 190.1z"],
    "clock-two-thirty": [512, 512, [], "e35b", "M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256c141.4 0 256-114.6 256-256C512 114.6 397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM338.1 190.1L248 242.1C243 245 240 250.3 240 256v144c0 8.844 7.156 16 16 16s16-7.156 16-16V265.2l82.06-47.38C361.7 213.4 364.3 203.7 359.9 196C355.5 188.3 345.7 185.7 338.1 190.1z"],
    "clone": [512, 512, [], "f24d", "M336 384c-8.836 0-16 7.162-16 16V448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V224c0-17.67 14.33-32 32-32h48C120.8 192 128 184.8 128 176C128 167.2 120.8 160 112 160H64C28.65 160 0 188.7 0 224v224c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64v-48C352 391.2 344.8 384 336 384zM448 0H224C188.7 0 160 28.65 160 64v224c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64V64C512 28.65 483.3 0 448 0zM480 288c0 17.64-14.36 32-32 32H224c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h224c17.64 0 32 14.36 32 32V288z"],
    "closed-captioning": [576, 512, [], "f20a", "M248.9 210.7c6.25 6.25 16.37 6.25 22.62 0s6.25-16.38 0-22.62c-36.25-36.25-99.5-36.25-135.7 0c-37.42 37.44-37.42 98.31 0 135.8c18.12 18.13 42.23 28.12 67.87 28.12s49.75-9.1 67.87-28.12c6.25-6.25 6.25-16.38 0-22.62s-16.37-6.25-22.62 0c-24.19 24.19-66.31 24.19-90.5 0c-24.95-24.94-24.95-65.56 0-90.5C182.6 186.6 224.8 186.6 248.9 210.7zM440.9 210.7c6.25 6.25 16.37 6.25 22.62 0s6.25-16.38 0-22.62c-36.25-36.25-99.5-36.25-135.7 0c-37.42 37.44-37.42 98.31 0 135.8c18.12 18.13 42.23 28.12 67.87 28.12c25.64 0 49.75-9.1 67.87-28.12c6.25-6.25 6.25-16.38 0-22.62s-16.37-6.25-22.62 0c-24.19 24.19-66.31 24.19-90.5 0c-24.95-24.94-24.95-65.56 0-90.5C374.6 186.6 416.8 186.6 440.9 210.7zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V416z"],
    "closed-captioning-slash": [640, 512, [], "e135", "M495.6 188.1c-36.25-36.25-99.5-36.25-135.8 0c-3.355 3.357-6.055 7.094-8.809 10.79l24.99 19.73c1.973-2.729 3.99-5.439 6.447-7.895c24.19-24.19 66.31-24.19 90.5 0c6.25 6.25 16.38 6.25 22.62 0S501.8 194.4 495.6 188.1zM544 64c17.64 0 32 14.36 32 32v280.5l32 25.26V95.1c0-35.35-28.65-64-64-64L139.6 32l40.53 32H544zM96 448c-17.64 0-32-14.36-32-32V135.4L32 110.2v305.8c0 35.35 28.65 64 64 64L500.4 480l-40.53-32H96zM153.9 206.4c-22.36 36.92-17.89 85.64 13.96 117.5c18.12 18.12 42.23 28.12 67.88 28.12c25.45 0 49.37-9.898 67.45-27.77l-25.62-20.22c-24.56 21.13-63.94 20.38-87.08-2.758C170.2 281 166.7 250.6 179.3 226.4L153.9 206.4zM633.9 483.4l-608-480c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "clothes-hanger": [640, 512, [], "e136", "M608.5 387.3l-267.3-168.8l32.06-21.38C400 179.2 416 149.3 416 117.2V96c0-52.94-43.06-96-96-96S224 43.06 224 96c0 8.844 7.156 16 16 16S256 104.8 256 96c0-35.28 28.72-64 64-64s64 28.72 64 64v21.19c0 21.44-10.66 41.34-28.5 53.25L30.09 387.4C11.25 399.9 0 420.1 0 444.4C0 481.7 30.31 512 67.56 512h504.9C609.7 512 640 481.7 640 444.4C640 421.1 628.2 399.8 608.5 387.3zM572.4 480H67.56C47.97 480 32 464 32 443.6c0-11.91 5.938-22.97 15.84-29.59l264.2-176.1l279.4 176.5C601.8 420.9 608 432.2 608 444.4C608 464 592 480 572.4 480z"],
    "cloud": [640, 512, [61634], "2601", "M571.8 238.8C574.5 228.9 576 218.6 576 208C576 146.1 525.9 96 464 96c-16.75 0-32.88 3.625-48 10.75C384.4 61.75 331.8 32 272 32C177.6 32 100.2 106.4 96.2 200.1C39.2 220.1 0 274.2 0 336C0 415.6 64.38 480 144 480H512c70.75 0 128-57.25 128-128C640 305 614.3 261.2 571.8 238.8zM507.5 448H149.5c-58.31 0-110.9-42.16-116.9-100.2C26.8 291.2 63.27 241.9 114.3 227.1C122.6 225.7 128 217.7 128 209C128 208.7 128 208.4 127.1 208C127.1 147.3 165.1 91.38 222.7 72.19c71.47-23.82 139.2 6.728 172.3 60.89c5.985 9.802 18.35 11.99 28.22 6.112c16.88-10.06 37.78-14.07 59.94-8.988c26.85 6.154 49.45 26.1 57.26 53.41c5.798 19.61 4.306 38.74-2.508 55.16c-4.137 9.97 2.059 20.75 11.98 24.1c37.34 15.98 62.42 55.06 57.5 99.25C601.9 412.3 557.1 448 507.5 448z"],
    "cloud-arrow-down": [640, 512, [62337, "cloud-download", "cloud-download-alt"], "f0ed", "M571.8 238.8C574.5 228.9 576 218.6 576 208C576 146.1 525.9 96 464 96c-16.75 0-32.88 3.625-48 10.75C384.4 61.75 331.8 32 272 32C177.6 32 100.2 106.4 96.2 200.1C39.2 220.1 0 274.3 0 336C0 415.6 64.38 480 144 480H512c70.75 0 128-57.25 128-128C640 305 614.3 261.3 571.8 238.8zM507.5 448H149.5c-58.31 0-110.9-42.16-116.9-100.2C26.79 291.2 63.27 241.9 114.3 227.1c8.367-2.291 13.78-10.26 13.73-18.94C128 208.7 128 208.4 128 208C127.1 147.3 165.1 91.38 222.7 72.19c71.47-23.82 139.2 6.727 172.3 60.89c5.984 9.803 18.35 11.99 28.22 6.111c16.88-10.06 37.78-14.07 59.94-8.988c26.85 6.154 49.45 27 57.26 53.41c5.799 19.61 4.307 38.74-2.508 55.16c-4.137 9.969 2.061 20.75 11.98 24.1c37.34 15.97 62.42 55.06 57.5 99.25C601.9 412.3 557.1 448 507.5 448zM388.7 292.7L336 345.4V176C336 167.2 328.8 160 320 160S304 167.2 304 176v169.4L251.3 292.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l80 80C311.8 398.4 315.9 400 320 400s8.188-1.562 11.31-4.688l80-80c6.25-6.25 6.25-16.38 0-22.62S394.9 286.4 388.7 292.7z"],
    "cloud-arrow-up": [640, 512, ["cloud-upload", "cloud-upload-alt"], "f0ee", "M571.8 238.8C574.5 228.9 576 218.6 576 208C576 146.1 525.9 96 464 96c-16.75 0-32.88 3.625-48 10.75C384.4 61.75 331.8 32 272 32C177.6 32 100.2 106.4 96.2 200.1C39.2 220.1 0 274.3 0 336C0 415.6 64.38 480 144 480H512c70.75 0 128-57.25 128-128C640 305 614.3 261.3 571.8 238.8zM507.5 448H149.5c-58.31 0-110.9-42.16-116.9-100.2C26.79 291.2 63.27 241.9 114.3 227.1c8.367-2.291 13.78-10.26 13.73-18.94C128 208.7 128 208.4 128 208C127.1 147.3 165.1 91.38 222.7 72.19c71.47-23.82 139.2 6.727 172.3 60.89c5.984 9.803 18.35 11.99 28.22 6.111c16.88-10.06 37.78-14.07 59.94-8.988c26.85 6.154 49.45 27 57.26 53.41c5.799 19.61 4.307 38.74-2.508 55.16c-4.137 9.969 2.061 20.75 11.98 24.1c37.34 15.97 62.42 55.06 57.5 99.25C601.9 412.3 557.1 448 507.5 448zM251.3 267.3L304 214.6V384c0 8.844 7.156 16 16 16s16-7.156 16-16V214.6l52.69 52.69c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62l-80-80C328.2 161.6 324.1 160 320 160S311.8 161.6 308.7 164.7l-80 80c-6.25 6.25-6.25 16.38 0 22.62S245.1 273.6 251.3 267.3z"],
    "cloud-bolt": [512, 512, [63340, "thunderstorm"], "1f329", "M415.8 112.3C411.8 67.38 373.9 32 328 32c-17.75 0-34.75 5.25-49.25 15.25c-33.6-44.05-94.5-61.9-151.1-33.58C87.9 33.56 64 75.55 64 120v.375C20.27 138.7-7.123 185.1 1.625 234.3C10.58 284.8 56.91 320 108.2 320H144C152.8 320 160 312.8 160 304C160 295.2 152.8 288 144 288H106C75 288 46.09 269.2 36.04 239.9C21.95 198.8 46.26 157.3 85.25 146.8l13.38-3.5L96.63 126C96.25 124 96 122 96 120C96 71.5 135.5 32 184 32c32.25 0 61.75 17.88 77.25 46.75l10.5 19.88l15.25-16.5c14.78-15.97 36.25-22.01 58.14-15.62c21.26 6.211 35.74 26.08 38.37 48.07c.7266 6.084 .6387 5.52-.2637 12.29l-2.5 20l23.5-2.375C405.4 144.3 406.8 144.1 408 144.1c39.75 0 72 32.25 72 72c0 38-29.75 68.88-67 71.5l-77.1 .2773C327.3 287.1 320 294.9 320 304c0 8.836 7.164 16 16 16h67.9c55.77 0 104.6-42.09 107.9-97.76C515.2 164.7 471.4 116.4 415.8 112.3zM320 352H227.3l88.78-101.5c5.844-6.656 5.156-16.75-1.5-22.56c-6.625-5.781-16.72-5.188-22.56 1.5l-112 128c-4.156 4.719-5.125 11.44-2.531 17.16S185.7 384 192 384h92.75l-88.78 101.5c-5.844 6.656-5.156 16.75 1.5 22.56C200.5 510.7 204.3 512 208 512c4.438 0 8.875-1.844 12.03-5.469l112-128c4.156-4.719 5.125-11.44 2.531-17.16S326.3 352 320 352z"],
    "cloud-bolt-moon": [576, 512, ["thunderstorm-moon"], "f76d", "M272 352H179.3l88.78-101.5c5.844-6.656 5.156-16.75-1.5-22.56c-6.625-5.812-16.75-5.188-22.56 1.5l-112 128c-4.156 4.719-5.125 11.44-2.531 17.16S137.7 384 144 384h92.75l-88.78 101.5c-5.844 6.656-5.156 16.75 1.5 22.56C152.5 510.7 156.3 512 160 512c4.438 0 8.875-1.844 12.03-5.469l112-128c4.156-4.719 5.125-11.44 2.531-17.16S278.3 352 272 352zM573.9 237.5c-3.625-7.75-11.5-12.62-19.88-12.62c-5.189 0-10.05 2.25-23.12 2.25c-54.38 0-98.63-44-98.63-98.25c0-35.13 19.12-67.88 50-85.25c8.25-4.625 12.5-13.62 11-22.88c-1.625-9.25-8.5-16.25-17.88-18C465.8 .875 455.8 0 446 0c-67.13 0-123.6 41.38-147.8 99.5c10.25 2.5 20 6.25 29 11.38C346.4 65.25 391.3 32.88 443.8 32c-27.25 24.38-43.5 59.63-43.5 96.75c0 70.75 57 128.5 127.6 130.1c-22.25 18.25-50.25 28.38-79.75 28.88c0 11-1.5 21.88-4.125 32c18.44 0 80.19-1.766 127.1-59C576.4 254.3 577.5 245.3 573.9 237.5zM351.3 197.3C345.1 158.3 312.5 128 272 128C263.4 128 255 129.4 246.8 132.3C227.1 109.4 198.6 96 168 96C111.5 96 65.25 141.3 64 197.6C26.25 210.9 0 246.9 0 288c0 46.47 33.31 85.41 77.28 94.16C87.01 384.1 96 376.3 96 366.4v-.5469c0-7.334-4.93-13.97-12.1-15.51c-26.36-5.676-47.86-26.55-51.37-54C28.18 262.3 51.05 231.5 84 225.3l.5-.0996c7.918-1.576 13.31-8.977 12.42-17C96.4 203.5 96.57 205.7 96.16 197.7C97.35 159 129.1 128 168.1 128c24.25 0 46.75 12.25 60.13 32.75l.2676 .4102C232.1 167.1 241.9 170.2 249.1 166.3c32.75-17.88 71.07 7.951 71.19 40.2l-.0508 3.258c-.1152 7.521 5.17 14.04 12.55 15.49C362.6 231.3 384.1 257.6 384.1 288c-.1094 30.99-22.34 56.96-51.67 62.78C325.1 352.2 320 358.9 320 366.4c0 9.924 8.986 17.74 18.72 15.81C382.7 373.4 416 334.5 416 288C416 246.8 389.4 210.4 351.3 197.3z"],
    "cloud-bolt-sun": [640, 512, ["thunderstorm-sun"], "f76e", "M496 352h-92.73l88.78-101.5c5.812-6.656 5.141-16.75-1.516-22.56c-6.641-5.844-16.73-5.219-22.58 1.5l-112 128c-4.125 4.719-5.125 11.44-2.516 17.16C356 380.3 361.7 384 368 384h92.73l-88.78 101.5c-5.812 6.656-5.141 16.75 1.516 22.56C376.5 510.7 380.3 512 384 512c4.453 0 8.875-1.844 12.05-5.469l112-128c4.125-4.719 5.125-11.44 2.516-17.16C507.1 355.7 502.3 352 496 352zM575.3 197.3C569.1 158.3 536.5 128 496 128c-8.625 0-17 1.375-25.25 4.25C451.1 109.4 422.6 96 392 96C335.5 96 289.3 141.3 288 197.6C250.3 210.9 224 246.9 224 288c0 46.47 33.31 85.41 77.28 94.16C311 384.1 320 376.3 320 366.4v-.5469c0-7.334-4.928-13.97-12.1-15.51c-26.36-5.674-47.86-26.55-51.37-54C252.2 262.3 275 231.5 308 225.3l.5-.0996c7.918-1.578 13.31-8.979 12.42-17c-.5215-4.684-.3516-2.469-.7598-10.41C321.4 159 353.1 128 392.1 128c24.25 0 46.75 12.25 60.13 32.75l.291 .4473c4.438 6.799 13.36 9.033 20.48 5.123l.3555-.1953c32.75-17.88 70.75 8.125 70.88 40.38l-.0508 3.258c-.1152 7.521 5.17 14.04 12.55 15.49C586.6 231.3 608.1 257.6 608.1 288c-.1094 30.99-22.34 56.96-51.67 62.78C549.1 352.2 544 358.9 544 366.4c0 9.922 8.986 17.74 18.72 15.8C606.7 373.4 640 334.5 640 288C640 246.8 613.4 210.4 575.3 197.3zM160.3 291.8c-3.5-5.375-9.875-8.125-16.38-6.875L87.88 296L99 240c1.25-6.375-1.375-12.75-6.75-16.38l-47.5-31.88L92.25 160c5.375-3.625 8-10.12 6.75-16.38l-11.12-56l56 11.12C150.4 100 156.8 97.25 160.3 91.88L192 44.38l31.75 47.5c3.625 5.375 10 8.125 16.5 6.875L319.6 83c8.625-1.75 14.25-10.12 12.62-18.75c-1.75-8.75-10.38-14.5-18.88-12.62L244.5 65.25l-39.25-58.5c-5.875-9-20.5-9-26.5 0l-39.13 58.5l-69-13.75C65.25 50.38 59.88 52.13 56.25 55.88c-3.875 3.875-5.5 9.25-4.5 14.5l13.75 69L7.125 178.5C2.75 181.5 0 186.4 0 191.8s2.75 10.38 7.125 13.38L65.5 244.3l-13.75 69c-1 5.25 .625 10.62 4.5 14.5c3.75 3.75 9 5.5 14.38 4.375L139.5 318.4l39.13 58.5C181.8 381.5 186.8 384 191.9 384c3.125 0 6.25-.875 8.875-2.75c7.375-4.875 9.375-14.88 4.5-22.12L160.3 291.8zM192 140c26.38 0 48 20 51.13 45.63C247.9 182 252.9 178.8 258.3 175.8c1.5-8.5 3.875-16.5 6.75-24.38C250.8 125.8 223.5 108 192 108c-46.25 0-83.75 37.63-83.75 83.75C108.3 238 145.8 275.6 192 275.6c.25 0 .625-.125 .875-.125c1.125-11.38 3.75-22.38 7.75-32.75C197.8 243.3 195 243.6 192.1 243.6c-28.5 0-51.75-23.25-51.75-51.75C140.3 163.3 163.5 140 192 140z"],
    "cloud-check": [640, 512, [], "e35c", "M571.8 238.8C574.5 228.9 576 218.6 576 208C576 146.1 525.9 96 464 96c-16.75 0-32.88 3.625-48 10.75C384.4 61.75 331.8 32 272 32C177.6 32 100.2 106.4 96.2 200.1C39.2 220.1 0 274.3 0 336C0 415.6 64.38 480 144 480H512c70.75 0 128-57.25 128-128C640 305 614.3 261.3 571.8 238.8zM507.5 448H149.5c-58.31 0-110.9-42.16-116.9-100.2C26.8 291.2 63.27 241.9 114.3 227.1c8.369-2.291 13.78-10.26 13.73-18.94C128 208.7 128 208.4 128 208C127.1 147.3 165.1 91.38 222.7 72.19c71.47-23.82 139.2 6.727 172.3 60.89c5.984 9.803 18.35 11.99 28.22 6.111c16.88-10.06 37.78-14.07 59.94-8.988c26.85 6.154 49.45 27 57.26 53.41c5.799 19.61 4.307 38.74-2.508 55.16c-4.137 9.969 2.061 20.75 11.98 24.1c37.34 15.97 62.42 55.06 57.5 99.25C601.9 412.3 557.1 448 507.5 448zM388.7 228.7l-95.36 95.38L251.3 282c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L282 358c3 3 7.062 4.688 11.31 4.688S301.6 361 304.6 358l106.7-106.7c6.25-6.25 6.25-16.38 0-22.62S394.9 222.4 388.7 228.7z"],
    "cloud-drizzle": [512, 512, [], "f738", "M48 360c-8.75 0-16 7.25-16 16V416c0 8.75 7.25 16 16 16S64 424.8 64 416v-40C64 367.3 56.75 360 48 360zM240 360c-8.75 0-16 7.25-16 16V416c0 8.75 7.25 16 16 16S256 424.8 256 416v-40C256 367.3 248.8 360 240 360zM144 440c-8.75 0-16 7.25-16 16v40C128 504.8 135.3 512 144 512S160 504.8 160 496v-40C160 447.3 152.8 440 144 440zM432 360c-8.75 0-16 7.25-16 16V416c0 8.75 7.25 16 16 16S448 424.8 448 416v-40C448 367.3 440.8 360 432 360zM336 440c-8.75 0-16 7.25-16 16v40c0 8.75 7.25 16 16 16s16-7.25 16-16v-40C352 447.3 344.8 440 336 440zM414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288z"],
    "cloud-fog": [640, 512, [63310, "fog"], "1f32b", "M168 320h304C529.3 320 576 273.3 576 216c0-54.75-42.63-99.75-96.25-103.8C475.8 67.38 437.9 32 392 32c-17.75 0-34.75 5.25-49.25 15.25C320.3 17.75 285.5 0 248 0C181.8 0 128 53.75 128 120v.375c-38.25 16-64 53.5-64 95.63C64 273.3 110.8 320 168 320zM149.3 146.8c7.666-2.006 12.7-9.352 11.79-17.22C160.4 123.6 160 122.1 160 120C160 71.5 199.5 32 248 32c32.25 0 61.75 17.88 77.25 46.75c5.123 9.699 18.3 11.43 25.75 3.375c12.77-13.8 30.54-20.19 49.26-17.54c25.35 3.584 44.32 25.31 47.34 50.74c.6309 5.309 .5137 5.066-.3516 11.55c-1.268 10.14 7.193 19.02 17.36 17.99C470.2 144.3 469.8 144.1 472 144.1c39.75 0 72 32.25 72 72c0 39.63-32.25 72-72 72h-304c-39.75 0-72-32.38-72-72C96 183.8 117.9 155.3 149.3 146.8zM208 480h-128C71.2 480 64 487.2 64 496S71.2 512 80 512h128C216.8 512 224 504.8 224 496S216.8 480 208 480zM624 480h-320C295.2 480 288 487.2 288 496S295.2 512 304 512h320c8.801 0 16-7.199 16-16S632.8 480 624 480zM576 400C576 391.2 568.8 384 560 384h-544C7.201 384 0 391.2 0 399.1S7.201 416 16 416h544C568.8 416 576 408.8 576 400z"],
    "cloud-hail": [512, 512, [], "f739", "M56 464C42.75 464 32 474.8 32 488S42.75 512 56 512s24-10.75 24-24S69.25 464 56 464zM184 464C170.8 464 160 474.8 160 488S170.8 512 184 512s24-10.75 24-24S197.3 464 184 464zM248 368C234.8 368 224 378.8 224 392S234.8 416 248 416s24-10.75 24-24S261.3 368 248 368zM120 368C106.8 368 96 378.8 96 392S106.8 416 120 416s24-10.75 24-24S133.3 368 120 368zM376 368c-13.25 0-24 10.75-24 24S362.8 416 376 416s24-10.75 24-24S389.3 368 376 368zM312 464c-13.25 0-24 10.75-24 24S298.8 512 312 512s24-10.75 24-24S325.3 464 312 464zM414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288z"],
    "cloud-hail-mixed": [512, 512, [], "f73a", "M183.9 370.1c-7.625-4.375-17.38-1.875-21.75 6l-64 112c-4.375 7.625-1.75 17.5 6 21.75C106.6 511.3 109.3 512 112 512c5.5 0 10.88-2.875 13.88-8.125l64-112C194.3 384.3 191.6 374.5 183.9 370.1zM279.3 369.8c-8-4-17.5-.875-21.5 7.125l-16 32c-4 7.875-.875 17.5 7.125 21.5c2.375 1.125 4.875 1.75 7.25 1.75c5.75 0 11.5-3.25 14.25-8.875l16-32C290.3 383.3 287.1 373.6 279.3 369.8zM216 464C202.8 464 192 474.8 192 488S202.8 512 216 512s24-10.75 24-24S229.3 464 216 464zM87.25 369.8c-8-4-17.5-.875-21.5 7.125l-16 32c-4 7.875-.875 17.5 7.125 21.5c2.375 1.125 4.875 1.75 7.25 1.75c5.75 0 11.5-3.25 14.25-8.875l16-32C98.25 383.3 95.13 373.6 87.25 369.8zM24 464C10.75 464 0 474.8 0 488S10.75 512 24 512s24-10.75 24-24S37.25 464 24 464zM471.3 369.8c-8-4-17.5-.875-21.5 7.125l-16 32c-4 7.875-.875 17.5 7.125 21.5c2.375 1.125 4.875 1.75 7.25 1.75c5.75 0 11.5-3.25 14.25-8.875l16-32C482.3 383.3 479.1 373.6 471.3 369.8zM375.9 370.1c-7.625-4.375-17.38-1.875-21.75 6l-64 112c-4.375 7.625-1.75 17.5 6 21.75C298.6 511.3 301.3 512 304 512c5.5 0 10.88-2.875 13.88-8.125l64-112C386.3 384.3 383.6 374.5 375.9 370.1zM408 464c-13.25 0-24 10.75-24 24S394.8 512 408 512s24-10.75 24-24S421.3 464 408 464zM414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288z"],
    "cloud-meatball": [576, 512, [], "f73b", "M80 352C53.5 352 32 373.5 32 400S53.5 448 80 448S128 426.5 128 400S106.5 352 80 352zM80 416C71.25 416 64 408.8 64 400S71.25 384 80 384S96 391.3 96 400S88.75 416 80 416zM378.5 293.5c-12.25-12.25-29.25-17.88-46.25-16.25c-21.88-26.62-66.75-26.62-88.5 0c-16.88-1.625-34 4-46.25 16.25s-18 29.25-16.25 46.25C167.9 350.8 160 366.8 160 384s7.875 33.25 21.25 44.25c-1.75 17 4 34 16.25 46.25S228 493.5 244 491.1C254.9 504.3 270.8 512 288 512s33.13-7.75 44-20.88c16.25 2.375 34.25-4.375 46.5-16.62s18-29.25 16.25-46.25C408.1 417.3 416 401.3 416 384s-7.875-33.25-21.25-44.25C396.5 322.8 390.8 305.8 378.5 293.5zM369.8 406.8l-12 6.125l4.125 12.88c3 9.5 .875 19.5-5.875 26.12c-4.875 4.875-11.38 7.625-18.38 7.625c-2 0-4.5-.75-7.875-1.75l-12.75-4l-6.25 12c-9.125 17.62-36.13 17.62-45.38 0l-6.125-12l-12.88 4c-3.125 1-5.75 1.75-7.75 1.75c-6.875 0-13.5-2.75-18.38-7.625c-6.75-6.625-9-16.62-6-26.12l4.125-12.88L206.5 406.8C197.8 402.1 192.3 393.4 192.3 384s5.5-18.12 14.25-22.75l11.88-6.125l-4.125-12.88c-3-9.5-.75-19.5 6-26.12c6.625-6.75 16.62-8.875 26.12-5.875l12.88 4l6.125-11.88c9.25-17.62 36.25-17.62 45.38 0L317 314.3l12.75-4c9.5-3 19.5-.875 26.25 5.875c6.75 6.625 8.875 16.62 5.875 26.12l-4.125 12.88l12 6.125C378.5 365.9 384 374.6 384 384S378.5 402.1 369.8 406.8zM544 216c0-54.75-42.63-99.75-96.25-103.8c-4-44.88-41.88-80.25-87.75-80.25c-17.75 0-34.75 5.253-49.25 15.25C288.3 17.75 253.5 0 216 0C149.8 0 96 53.75 96 120v.375C52.32 138.6 24.94 184.1 33.6 234.2C42.44 284.5 88.13 320 139.2 320H144C152.8 320 160 312.8 160 304C160 295.2 152.8 288 144 288H138.4C105.4 288 75.05 266.8 66.51 234.9C55.95 195.4 79.85 156.9 117.3 146.8C124.9 144.7 129.9 137.4 129 129.5c-.2441-2.102-1.178-9.225-.9043-14.3C130.6 68.93 169.1 32 216 32c32.25 0 61.75 17.88 77.25 46.75c5.125 9.701 18.3 11.43 25.75 3.375c12.77-13.8 30.54-20.19 49.26-17.54c25.35 3.586 44.32 25.32 47.34 50.74c.6309 5.307 .5137 5.064-.3516 11.55c-1.281 10.25 7.332 19.01 17.61 17.97c4.783-.4844 4.979-.6797 6.598-.7129c28.72-.5684 55.48 15.53 66.44 42.09C527.3 238 489.4 288.1 440 288.1C440 288.1 434.1 288 432 288C423.2 288 416 295.2 416 304c0 8.836 7.164 16 16 16c2.979 0 8 .125 8 .125C497.3 320 544 273.3 544 216zM496 352c-26.5 0-48 21.5-48 48s21.5 48 48 48s48-21.5 48-48S522.5 352 496 352zM496 416c-8.75 0-16-7.25-16-16s7.25-16 16-16s16 7.25 16 16S504.8 416 496 416z"],
    "cloud-minus": [640, 512, [], "e35d", "M571.8 238.8C574.5 228.9 576 218.6 576 208C576 146.1 525.9 96 464 96c-16.75 0-32.88 3.625-48 10.75C384.4 61.75 331.8 32 272 32C177.6 32 100.2 106.4 96.2 200.1C39.2 220.1 0 274.3 0 336C0 415.6 64.38 480 144 480H512c70.75 0 128-57.25 128-128C640 305 614.3 261.3 571.8 238.8zM507.5 448H149.5c-58.31 0-110.9-42.16-116.9-100.2C26.8 291.2 63.27 241.9 114.3 227.1c8.369-2.291 13.78-10.26 13.73-18.94C128 208.7 128 208.4 128 208C127.1 147.3 165.1 91.38 222.7 72.19c71.47-23.82 139.2 6.727 172.3 60.89c5.984 9.803 18.35 11.99 28.22 6.111c16.88-10.06 37.78-14.07 59.94-8.988c26.85 6.154 49.45 27 57.26 53.41c5.799 19.61 4.307 38.74-2.508 55.16c-4.137 9.969 2.061 20.75 11.98 24.1c37.34 15.97 62.42 55.06 57.5 99.25C601.9 412.3 557.1 448 507.5 448zM399.1 272h-160C231.2 272 224 279.2 224 288c0 8.834 7.154 15.1 15.1 15.1h160C408.8 303.1 416 296.8 416 288S408.8 272 399.1 272z"],
    "cloud-moon": [576, 512, [], "f6c3", "M351.5 313.6C347 272.3 311.9 240 269.4 240c-13.87 0-27.24 3.5-39.49 10.25C211.7 233.5 188.1 224 163.2 224c-53.74 0-97.46 42.56-99.21 96.06c-38.24 14.25-63.99 50.81-63.99 92.81C.1253 467.5 44.61 512 99.35 512h249.4c54.73 0 99.22-44.5 99.22-99.25C447.1 359 405 315.1 351.5 313.6zM348.8 480l-246.1 .0001c-36.29 0-67.88-27.72-69.59-63.97C30.64 383.1 52.54 354.5 84.48 347.4c8.746-3.671 13.15-12.1 11.1-20.5c-.125-1.125-.375-2.5-.375-3.75c0-37.13 30.12-67.25 67.23-67.25c19.99 0 38.99 9.25 51.98 25.25C220.8 288 230.9 289.1 237.7 283.5c15.27-12.38 35.36-15.27 53.99-6.324c15.92 7.649 26.03 23.85 27.98 41.41c.5401 4.873 .3968 4.374-.4299 10.37c-.4545 3.867 1.645 20.56 19.63 17.58c3.813-.632 7.667-1.152 11.53-1.064c36.4 .8253 65.69 30.75 65.69 67.23C416.1 449.8 385.9 480 348.8 480zM573.6 287.3c-4.125-8.625-12.38-14-21.88-14c-1.5 0-3 .125-4.5 .5c-7.75 1.5-15.5 2.125-23.25 2.125c-66.1 0-121.5-54.63-121.5-121.9c0-43.75 23.62-84.25 61.62-106c8.875-5.125 13.62-15 11.88-25.12s-9.375-17.88-19.5-19.75C444.1 1.125 433.2 0 421.5 0c-105.7 0-191.7 86.13-191.7 192c0 6.5 .375 12.75 1 19.25c1.957 .4414 3.75 1.242 5.664 1.781C244.1 210.4 253.9 209 262.9 208.5C262.2 203.1 261.7 197.7 261.7 192.1c0-88.25 71.62-160 159.7-160c3 0 5.875 .125 8.875 .125c-37.37 29-59.87 74-59.87 122c0 84.75 68.87 153.8 153.5 153.8c2.625 0 5.25-.125 7.75-.25c-19.63 18.88-43.79 31.62-69.84 38.43c5.447 9.289 9.502 19.41 12.54 30c37.33-10.69 70.89-32.35 96.05-63.43C576.5 305.6 577.7 295.8 573.6 287.3z"],
    "cloud-moon-rain": [576, 512, [], "f73c", "M266.3 418.1c-7.625-4.375-17.5-1.875-21.88 6l-36.63 64c-4.375 7.625-1.625 17.38 6 21.75C216.3 511.3 219 512 221.8 512c5.5 0 10.88-2.875 13.88-8.125l36.63-64C276.6 432.3 273.9 422.5 266.3 418.1zM170.3 418.1c-7.625-4.375-17.5-1.875-21.88 6l-36.63 64c-4.375 7.625-1.625 17.38 6 21.75C120.3 511.3 123 512 125.8 512c5.5 0 10.88-2.875 13.88-8.125l36.63-64C180.6 432.3 177.9 422.5 170.3 418.1zM74.25 418.1c-7.625-4.375-17.5-1.875-21.88 6l-36.63 64c-4.375 7.625-1.625 17.38 6 21.75C24.25 511.3 27 512 29.75 512c5.5 0 10.88-2.875 13.88-8.125l36.63-64C84.63 432.3 81.88 422.5 74.25 418.1zM351.3 197.3C346 158.3 312.5 128 272 128c-8.625 0-17 1.375-25.25 4.25C227.1 109.3 198.6 96 168 96c-56.5 0-102.8 45.25-104 101.6C26.25 210.9 .0001 246.9 .0001 288c0 52.88 43.13 96 96 96h224c52.88 0 96-43.13 96-96c0-1.25-.25-2.625-.25-4C414 244.4 388.3 210 351.3 197.3zM320 352H98.29c-32.58 0-61.63-23.38-65.76-55.7C28.18 262.3 51.05 231.5 84 225.3L84.48 225.2C92.42 223.6 97.81 216.1 96.9 208.1C95.94 199.7 96.17 201.8 96.12 198.9C95.71 176.8 105.3 155.2 123.5 142.6c38.05-26.42 83.21-14.79 104.7 18.2l.2676 .4111c4.432 6.818 13.37 9.067 20.5 5.159l.3564-.1953c32.75-17.88 70.75 8.125 70.88 40.38l-.0503 3.258c-.1157 7.521 5.17 14.04 12.55 15.49C362.6 231.3 384.1 257.6 384.1 288C384 323.3 355.3 352 320 352zM362.3 418.1c-7.625-4.375-17.5-1.875-21.88 6l-36.63 64c-4.375 7.625-1.625 17.38 6 21.75C312.3 511.3 315 512 317.8 512c5.5 0 10.88-2.875 13.88-8.125l36.63-64C372.6 432.3 369.9 422.5 362.3 418.1zM573.9 237.5c-3.625-7.75-11.5-12.62-19.88-12.62c-5.19 0-10.05 2.25-23.12 2.25c-54.38 0-98.63-44-98.63-98.25c0-35.13 19.13-67.88 50-85.25C490.5 39 494.8 30 493.3 20.75c-1.625-9.25-8.5-16.25-17.88-18C465.8 .875 455.8 0 446 0c-67.13 0-123.6 41.38-147.8 99.5c10.25 2.5 20 6.25 29 11.38C346.4 65.25 391.3 32.88 443.8 32c-27.25 24.38-43.5 59.63-43.5 96.75c0 70.75 57 128.5 127.6 130.1c-22.25 18.25-50.25 28.38-79.75 28.88c0 11-1.5 21.88-4.125 32c18.44 0 80.19-1.766 127.1-59C576.4 254.3 577.5 245.3 573.9 237.5z"],
    "cloud-music": [640, 512, [], "f8ae", "M402.3 188.8c-8.625-6-19.62-7.438-29.5-3.688l-96 36C264.3 225.8 256 237.8 256 251.1v73.72C248.7 321.8 240.6 320 232 320c-30.88 0-56 21.53-56 48S201.1 416 232 416S288 394.5 288 368V251.1l96-35.97v77.72C376.7 289.8 368.6 288 360 288C329.1 288 304 309.5 304 336s25.12 48 56 48S416 362.5 416 336V215.1C416 204.6 410.8 194.8 402.3 188.8zM232 384c-12.78 0-24-7.474-24-16S219.2 352 232 352s24 7.453 24 15.98S244.8 384 232 384zM360 352c-12.78 0-24-7.474-24-16S347.2 320 360 320s24 7.453 24 15.98S372.8 352 360 352zM571.8 238.8C574.5 228.9 576 218.6 576 208C576 146.1 525.9 96 464 96c-16.75 0-32.88 3.625-48 10.75C384.4 61.75 331.8 32 272 32C177.6 32 100.2 106.4 96.2 200.1C39.2 220.1 0 274.3 0 336C0 415.6 64.38 480 144 480H512c70.75 0 128-57.25 128-128C640 305 614.3 261.3 571.8 238.8zM507.5 448H149.5c-58.31 0-110.9-42.16-116.9-100.2C26.79 291.2 63.27 241.9 114.3 227.1c8.367-2.291 13.78-10.26 13.73-18.94C128 208.7 128 208.4 128 208C127.1 147.3 165.1 91.38 222.7 72.19c71.47-23.82 139.2 6.727 172.3 60.89c5.984 9.803 18.35 11.99 28.22 6.111c16.88-10.06 37.78-14.07 59.94-8.988c26.85 6.154 49.45 27 57.26 53.41c5.799 19.61 4.307 38.74-2.508 55.16c-4.137 9.969 2.061 20.75 11.98 24.1c37.34 15.97 62.42 55.06 57.5 99.25C601.9 412.3 557.1 448 507.5 448z"],
    "cloud-plus": [640, 512, [], "e35e", "M571.8 238.8C574.5 228.9 576 218.6 576 208C576 146.1 525.9 96 464 96c-16.75 0-32.88 3.625-48 10.75C384.4 61.75 331.8 32 272 32C177.6 32 100.2 106.4 96.2 200.1C39.2 220.1 0 274.3 0 336C0 415.6 64.38 480 144 480H512c70.75 0 128-57.25 128-128C640 305 614.3 261.3 571.8 238.8zM507.5 448H149.5c-58.31 0-110.9-42.16-116.9-100.2C26.8 291.2 63.27 241.9 114.3 227.1c8.369-2.291 13.78-10.26 13.73-18.94C128 208.7 128 208.4 128 208C127.1 147.3 165.1 91.38 222.7 72.19c71.47-23.82 139.2 6.727 172.3 60.89c5.984 9.803 18.35 11.99 28.22 6.111c16.88-10.06 37.78-14.07 59.94-8.988c26.85 6.154 49.45 27 57.26 53.41c5.799 19.61 4.307 38.74-2.508 55.16c-4.137 9.969 2.061 20.75 11.98 24.1c37.34 15.97 62.42 55.06 57.5 99.25C601.9 412.3 557.1 448 507.5 448zM399.1 272h-64V207.1C335.1 199.2 328.8 192 320 192S303.1 199.2 303.1 207.1V272h-64C231.2 272 224 279.2 224 288c0 8.834 7.154 15.1 15.1 15.1h64v64C303.1 376.8 311.2 384 320 384c8.836 0 15.1-7.16 15.1-15.1V303.1h64C408.8 303.1 416 296.8 416 288S408.8 272 399.1 272z"],
    "cloud-rain": [512, 512, [127783, 63293], "26c6", "M414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288zM242.8 358.9c-10.69 15.47-45.5 67.94-45.5 94.44C197.3 485.7 223.7 512 256 512s58.66-26.31 58.66-58.66c0-26.5-34.81-78.97-45.5-94.44C263.2 350.3 248.8 350.3 242.8 358.9zM256 480c-14.69 0-26.66-11.97-26.66-26.66c0-8.562 12.25-32.69 26.66-56.06c14.41 23.38 26.66 47.5 26.66 56.06C282.7 468 270.7 480 256 480zM82.84 358.9c-10.69 15.47-45.5 67.94-45.5 94.44C37.34 485.7 63.66 512 96 512s58.66-26.31 58.66-58.66c0-26.5-34.81-78.97-45.5-94.44C103.2 350.3 88.78 350.3 82.84 358.9zM96 480c-14.69 0-26.66-11.97-26.66-26.66c0-8.562 12.25-32.69 26.66-56.06c14.41 23.38 26.66 47.5 26.66 56.06C122.7 468 110.7 480 96 480zM402.8 358.9c-10.69 15.47-45.5 67.94-45.5 94.44C357.3 485.7 383.7 512 416 512s58.66-26.31 58.66-58.66c0-26.5-34.81-78.97-45.5-94.44C423.2 350.3 408.8 350.3 402.8 358.9zM416 480c-14.69 0-26.66-11.97-26.66-26.66c0-8.562 12.25-32.69 26.66-56.06c14.41 23.38 26.66 47.5 26.66 56.06C442.7 468 430.7 480 416 480z"],
    "cloud-rainbow": [576, 512, [], "f73e", "M414.7 304.2C407.2 258.8 367.6 224 320 224c-18.97 0-37.09 5.469-52.59 15.69C246.7 210.2 212.6 192 176 192C114.3 192 64 242.3 64 304c0 2.719 .0938 5.438 .3125 8.188C25.84 328.1 0 365.7 0 408C0 465.3 46.66 512 104 512h304c57.34 0 104-46.66 104-104C512 352.9 468.9 307.7 414.7 304.2zM408 480h-304C64.31 480 32 447.7 32 408c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 314.8 96 309.5 96 304C96 259.9 131.9 224 176 224c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 262.8 302.8 256 320 256c35.28 0 63.94 28.82 63.94 64.11C383.9 328.9 391.2 336 400 336h8c39.69 0 72 32.31 72 72S447.7 480 408 480zM256 172c4.5 0 9-1.906 12.16-5.594C341.3 81 447.6 32 560 32C568.8 32 576 24.98 576 16.13S568.8 0 560 0c-121.7 0-236.1 53.09-316.2 145.6C238.1 152.3 238.9 162.4 245.6 168.2C248.6 170.8 252.3 172 256 172zM560 96c-80.38 0-157.2 29.91-216.3 84.22c-6.531 5.969-6.938 16.09-.9687 22.59C345.9 206.3 350.2 208 354.5 208c3.875 0 7.75-1.406 10.81-4.219C418.5 154.9 487.7 128 560 128C568.8 128 576 120.8 576 112S568.8 96 560 96zM560 192c-42.91 0-84.59 12.19-120.6 35.22c-7.438 4.75-9.625 14.66-4.844 22.09C437.6 254.1 442.8 256.7 448 256.7c2.969 0 5.938-.8125 8.625-2.531C487.5 234.4 523.2 224 560 224C568.8 224 576 216.8 576 208S568.8 192 560 192z"],
    "cloud-showers": [512, 512, [], "f73f", "M112 368C103.3 368 96 375.3 96 384v80C96 472.8 103.3 480 112 480S128 472.8 128 464V384C128 375.3 120.8 368 112 368zM304 368c-8.75 0-16 7.25-16 16v80c0 8.75 7.25 16 16 16s16-7.25 16-16V384C320 375.3 312.8 368 304 368zM208 400C199.3 400 192 407.3 192 416v80C192 504.8 199.3 512 208 512S224 504.8 224 496V416C224 407.3 216.8 400 208 400zM400 400c-8.75 0-16 7.25-16 16v80c0 8.75 7.25 16 16 16s16-7.25 16-16V416C416 407.3 408.8 400 400 400zM414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288z"],
    "cloud-showers-heavy": [512, 512, [], "f740", "M414.7 112.2C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0902 5.438 .309 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320h304C465.3 320 512 273.3 512 216C512 160.9 468.9 115.7 414.7 112.2zM408 288h-304C64.31 288 32 255.7 32 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288zM439.2 353.7c-7.922-3.969-17.5-.7187-21.47 7.156l-64 128c-3.953 7.906-.75 17.5 7.156 21.47C363.1 511.5 365.6 512 367.1 512c5.875 0 11.51-3.25 14.32-8.844l64-128C450.3 367.3 447.1 357.7 439.2 353.7zM321.8 353.7c-7.922-3.969-17.5-.7187-21.47 7.156l-64 128c-3.953 7.906-.75 17.5 7.156 21.47C245.8 511.5 248.3 512 250.7 512c5.875 0 11.52-3.25 14.33-8.844l64-128C332.9 367.3 329.7 357.7 321.8 353.7zM204.5 353.7c-7.922-3.969-17.5-.7187-21.47 7.156l-64 128c-3.953 7.906-.75 17.5 7.156 21.47C128.5 511.5 130.9 512 133.3 512c5.875 0 11.52-3.25 14.33-8.844l64-128C215.6 367.3 212.4 357.7 204.5 353.7zM87.16 353.7c-7.922-3.969-17.5-.7187-21.47 7.156l-64 128c-3.953 7.906-.75 17.5 7.156 21.47C11.14 511.5 13.58 512 15.98 512c5.875 0 11.52-3.25 14.33-8.844l64-128C98.27 367.3 95.06 357.7 87.16 353.7z"],
    "cloud-slash": [640, 512, [], "e137", "M222.7 72.19c71.47-23.82 139.2 6.727 172.3 60.89c5.984 9.803 18.35 11.99 28.22 6.111c16.88-10.06 37.78-14.07 59.94-8.988c26.85 6.154 49.45 27 57.26 53.41c5.799 19.61 4.307 38.74-2.508 55.16c-4.137 9.969 2.061 20.75 11.98 24.1c37.34 15.97 62.42 55.06 57.5 99.25c-1.232 11.09-4.695 21.35-9.508 30.8l25.5 20.13C633.6 395.5 640 374.6 640 352c0-47-25.75-90.75-68.25-113.3C574.5 228.9 576 218.6 576 208C576 146.1 525.9 96 464 96c-16.75 0-32.88 3.625-48 10.75C384.4 61.75 331.8 32 272 32C236.5 32 203.5 42.53 175.8 60.63l26.04 20.56C208.5 77.65 215.4 74.61 222.7 72.19zM149.5 448c-58.31 0-110.9-42.16-116.9-100.2C26.8 291.2 63.27 241.9 114.3 227.1c8.369-2.291 13.78-10.26 13.73-18.94C128 208.7 128 208.4 128 208C127.1 201 128.6 194.1 129.6 187.2L101.5 165C98.61 176.4 96.72 188 96.2 200.1C39.2 220.1 0 274.3 0 336C0 415.6 64.38 480 144 480h356.4l-40.53-32H149.5zM25.92 3.42c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078c5.469-6.938 4.281-17-2.641-22.49L25.92 3.42z"],
    "cloud-sleet": [576, 512, [], "f741", "M544 216c0-55.09-43.06-100.3-97.31-103.8C439.2 66.75 399.6 32 352 32c-18.97 0-37.09 5.469-52.59 15.69C278.7 18.22 244.6 0 208 0C146.3 0 96 50.25 96 112c0 2.719 .0902 5.438 .309 8.188C57.84 136.1 32 173.7 32 216C32 273.3 78.66 320 136 320h304C497.3 320 544 273.3 544 216zM64 216c0-32.59 22.19-61.13 53.97-69.38c8.219-2.156 13.34-10.34 11.66-18.66C128.6 122.8 128 117.5 128 112C128 67.88 163.9 32 208 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C318.6 70.81 334.8 64 352 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C479.7 144 512 176.3 512 216S479.7 288 440 288h-304C96.31 288 64 255.7 64 216zM119.2 353.7c-7.906-3.938-17.47-.7187-21.47 7.156l-64 128c-3.938 7.906-.75 17.5 7.156 21.47C43.16 511.5 45.59 512 48 512c5.844 0 11.5-3.25 14.31-8.844l64-128C130.3 367.3 127.1 357.7 119.2 353.7zM375.2 353.7c-7.875-3.938-17.5-.7187-21.47 7.156l-64 128c-3.938 7.906-.75 17.5 7.156 21.47C299.2 511.5 301.6 512 304 512c5.844 0 11.5-3.25 14.31-8.844l64-128C386.3 367.3 383.1 357.7 375.2 353.7zM519.4 384c-4.406-7.688-14.22-10.28-21.84-5.844L480 388.3V368c0-8.844-7.156-16-16-16S448 359.2 448 368v20.3l-17.56-10.14C422.8 373.8 413 376.3 408.6 384c-4.438 7.656-1.812 17.44 5.844 21.84L432 416l-17.59 10.16C406.8 430.6 404.2 440.3 408.6 448c2.938 5.125 8.344 8 13.84 8c2.719 0 5.469-.6875 8-2.156L448 443.7V464c0 8.844 7.156 16 16 16s16-7.156 16-16v-20.3l17.56 10.14c2.531 1.469 5.281 2.156 8 2.156c5.5 0 10.91-2.875 13.84-8c4.438-7.656 1.812-17.44-5.844-21.84L495.1 416l17.59-10.16C521.2 401.4 523.8 391.7 519.4 384zM263.4 384c-4.406-7.688-14.22-10.28-21.84-5.844L224 388.3V368C224 359.2 216.8 352 208 352S192 359.2 192 368v20.3l-17.56-10.14C166.8 373.8 157 376.3 152.6 384c-4.438 7.656-1.812 17.44 5.844 21.84L176 416l-17.59 10.16C150.8 430.6 148.2 440.3 152.6 448c2.938 5.125 8.344 8 13.84 8c2.719 0 5.469-.6875 8-2.156L192 443.7V464C192 472.8 199.2 480 208 480S224 472.8 224 464v-20.3l17.56 10.14C244.1 455.3 246.8 456 249.6 456c5.5 0 10.91-2.875 13.84-8c4.438-7.656 1.812-17.44-5.844-21.84L239.1 416l17.59-10.16C265.2 401.4 267.8 391.7 263.4 384z"],
    "cloud-snow": [512, 512, [63298], "1f328", "M104 320h304C465.3 320 512 273.3 512 216c0-55.09-43.06-100.3-97.31-103.8C407.2 66.75 367.6 32 320 32c-18.97 0-37.09 5.469-52.59 15.69C246.7 18.22 212.6 0 176 0C114.3 0 64 50.25 64 112c0 2.719 .0938 5.438 .3125 8.188C25.84 136.1 0 173.7 0 216C0 273.3 46.66 320 104 320zM85.97 146.6c8.219-2.156 13.34-10.34 11.66-18.66C96.56 122.8 96 117.5 96 112C96 67.88 131.9 32 176 32c30.97 0 59.41 18.31 72.47 46.63c2.188 4.781 6.594 8.188 11.78 9.062c5.188 1.094 10.47-.75 14.16-4.531C286.6 70.81 302.8 64 320 64c35.28 0 64 28.72 64 64c0 8.844 7.156 16 16 16h8C447.7 144 480 176.3 480 216S447.7 288 408 288h-304C64.31 288 32 255.7 32 216C32 183.4 54.19 154.9 85.97 146.6zM503.4 384c-4.406-7.688-14.22-10.28-21.84-5.844L464 388.3V368c0-8.844-7.156-16-16-16s-16 7.156-16 16v20.3l-17.56-10.14C406.8 373.8 397 376.3 392.6 384c-4.438 7.656-1.812 17.44 5.844 21.84L416 416l-17.59 10.16C390.8 430.6 388.2 440.3 392.6 448c2.938 5.125 8.344 8 13.84 8c2.719 0 5.469-.6875 8-2.156L432 443.7V464c0 8.844 7.156 16 16 16s16-7.156 16-16v-20.3l17.56 10.14c2.531 1.469 5.281 2.156 8 2.156c5.5 0 10.91-2.875 13.84-8c4.438-7.656 1.812-17.44-5.844-21.84L479.1 416l17.59-10.16C505.2 401.4 507.8 391.7 503.4 384zM119.4 384c-4.406-7.688-14.22-10.28-21.84-5.844L80 388.3V368C80 359.2 72.84 352 64 352s-16 7.156-16 16v20.3l-17.56-10.14C22.81 373.8 13 376.3 8.594 384c-4.438 7.656-1.812 17.44 5.844 21.84L32.03 416l-17.59 10.16C6.781 430.6 4.156 440.3 8.594 448c2.938 5.125 8.344 8 13.84 8c2.719 0 5.469-.6875 8-2.156L48 443.7V464C48 472.8 55.16 480 64 480s16-7.156 16-16v-20.3l17.56 10.14C100.1 455.3 102.8 456 105.6 456c5.5 0 10.91-2.875 13.84-8c4.438-7.656 1.812-17.44-5.844-21.84L95.97 416l17.59-10.16C121.2 401.4 123.8 391.7 119.4 384zM312.1 416c-4.406-7.688-14.22-10.28-21.84-5.844l-17.56 10.14V400c0-8.844-7.156-16-16-16s-16 7.156-16 16v20.3L224 410.2C216.4 405.8 206.6 408.3 202.2 416c-4.438 7.656-1.812 17.44 5.844 21.84L225.6 448L208 458.2C200.3 462.6 197.7 472.3 202.2 480c2.938 5.125 8.344 8 13.84 8c2.719 0 5.469-.6875 8-2.156l17.56-10.14V496c0 8.844 7.156 16 16 16s16-7.156 16-16v-20.3l17.56 10.14c2.531 1.469 5.281 2.156 8 2.156c5.5 0 10.91-2.875 13.84-8c4.438-7.656 1.812-17.44-5.844-21.84L289.5 448l17.59-10.16C314.8 433.4 317.4 423.7 312.1 416z"],
    "cloud-sun": [640, 512, [63172], "26c5", "M93.5 322.9L92.63 323l12.5-63.25C106.3 253.5 103.8 247 98.25 243.4l-53.5-35.75l53.5-35.88c5.5-3.5 8-10 6.875-16.38l-12.5-63.25l63.13 12.5c6.5 1.25 12.88-1.5 16.5-6.875L208 44.25l35.75 53.5c3.625 5.375 10 8.125 16.5 6.875l63.13-12.5L313.1 139.6c-1.715 8.658 3.906 17.07 12.56 18.79c8.674 1.729 17.1-3.91 18.81-12.59l14.02-71.03c1-5.125-.625-10.5-4.375-14.38C351.3 56.63 345.8 54.88 340.6 56L264.4 71.13L221.3 6.75c-6-9-20.5-9-26.5 0L151.5 71.25L75.38 56.13C70.13 55 64.75 56.75 61 60.5S55.63 69.75 56.63 74.88l15.12 76.25L7.125 194.3C2.75 197.3 0 202.3 0 207.5s2.75 10.25 7.125 13.25L71.63 264L56.5 340.3c-1 5.125 .625 10.5 4.375 14.38c3 3 7.125 4.625 11.38 4.625c1 0 2 0 3-.25l23.71-4.516C106.5 353 112 346.4 112 338.7C112 328.9 103.2 321.4 93.5 322.9zM543.8 304.3C539.8 259.4 501.1 224 456 224c-17.75 0-34.75 5.25-49.25 15.25C384.3 209.8 349.5 192 312 192C245.8 192 192 245.8 192 312v.375c-38.25 16-64 53.5-64 95.63C128 465.3 174.8 512 232 512h304c57.25 0 104-46.75 104-104C640 353.3 597.4 308.3 543.8 304.3zM536 480H234.4c-33.02 0-63.32-21.22-71.86-53.12c-10.56-39.45 13.34-78 50.74-88.13c7.666-2.006 12.7-9.352 11.78-17.22C224.4 315.6 224 314.1 224 312C224 263.5 263.5 224 312 224c32.25 0 61.75 17.88 77.25 46.75c5.125 9.701 18.3 11.43 25.75 3.375c12.65-13.83 30.66-20.21 49.36-17.52c26.78 3.848 46.38 27.58 47.62 54.6c.0938 2-.1504 3.324-.7305 7.672c-1.268 10.14 7.193 19.02 17.36 17.99c5.629-.5684 5.209-.7422 7.391-.7422c39.75 0 72 32.25 72 72C608 447.8 575.8 480 536 480zM163 284.8c2-11 5.25-21.62 9.625-31.88C159 242.3 150.3 226 150.3 207.5c0-31.75 25.88-57.75 57.75-57.75c18.5 0 34.75 8.875 45.38 22.38C263.6 167.8 274.3 164.5 285.3 162.5C269.8 135.9 241.1 117.8 208 117.8c-49.5 0-89.75 40.25-89.75 89.75C118.3 240.5 136.3 269.3 163 284.8z"],
    "cloud-sun-rain": [640, 512, [63299], "1f326", "M306.3 432.1c0-6.412-5.042-16.07-16.09-16.07c-5.538 0-10.94 2.863-13.87 8.139l-36.62 64c-1.416 2.467-2.085 5.157-2.085 7.814C237.7 502 242.4 512 253.8 512c5.5 0 10.87-2.875 13.87-8.125l36.62-64C305.7 437.4 306.3 434.7 306.3 432.1zM140.4 191.6C140.4 163.1 163.6 140 192 140c26.38 0 48 20 51.12 45.62C247.9 182 252.9 178.8 258.2 175.8C259.8 167.2 262.1 159.2 265 151.4C250.8 125.8 223.5 108 192 108c-46.25 0-83.75 37.62-83.75 83.75C108.2 238 145.8 275.6 192 275.6c.25 0 .625-.125 .875-.125c1.125-11.38 3.75-22.38 7.75-32.75C197.8 243.2 195 243.6 192.1 243.6C164 243.6 140.4 220.9 140.4 191.6zM160.2 291.8C157.3 287.2 152.3 284.6 146.1 284.6c-1.027 0-2.068 .0976-3.112 .2984L87.88 296L99 240c.2066-1.053 .3073-2.107 .3073-3.148c0-5.259-2.571-10.2-7.057-13.23L44.75 191.8L92.25 160c4.487-3.026 7.057-8.055 7.057-13.27c0-1.032-.1007-2.072-.3073-3.105L87.88 87.62l56 11.13c1.044 .2009 2.086 .2984 3.112 .2984c5.362 0 10.33-2.662 13.26-7.173L192 44.38l31.75 47.5c3.043 4.511 8.022 7.173 13.39 7.173c1.027 0 2.068-.0976 3.113-.2984L319.6 83c7.624-1.547 12.9-8.271 12.9-15.77c0-9.437-7.995-15.96-15.9-15.96c-1.077 0-2.166 .1151-3.253 .3549L244.5 65.25L205.2 6.75C202.3 2.25 197.2 0 192 0S181.8 2.25 178.8 6.75L139.6 65.25L70.62 51.5c-1.085-.2271-2.17-.337-3.24-.337c-4.233 0-8.241 1.719-11.13 4.712C53.12 59 51.46 63.1 51.46 67.33c0 1.012 .0952 2.03 .2884 3.044l13.75 69L7.125 178.5C2.75 181.5 0 186.4 0 191.8c0 5.375 2.75 10.37 7.125 13.37L65.5 244.2L51.75 313.2C51.56 314.3 51.46 315.3 51.46 316.3c0 8.95 7.405 16.17 15.94 16.17c1.063 0 2.143-.1099 3.228-.337l68.88-13.75l39.12 58.5C181.8 381.5 186.8 384 191.9 384c3.125 0 6.25-.875 8.875-2.75c4.65-3.074 7.164-8.186 7.164-13.36c0-3.032-.8627-6.086-2.664-8.764L160.2 291.8zM498.3 432.1c0-6.412-5.042-16.07-16.09-16.07c-5.538 0-10.94 2.863-13.87 8.139l-36.62 64c-1.416 2.467-2.085 5.157-2.085 7.815C429.7 502 434.4 512 445.8 512c5.5 0 10.87-2.875 13.87-8.125l36.62-64C497.7 437.4 498.3 434.7 498.3 432.1zM575.3 197.2C569.1 158.2 536.5 128 496 128c-8.625 0-17 1.375-25.25 4.25C451.1 109.4 422.6 96 392 96C335.5 96 289.2 141.2 288 197.6C250.2 210.9 224 246.9 224 288c0 52.88 43.13 96 96 96h224c52.88 0 96-43.13 96-96C640 246.8 613.4 210.4 575.3 197.2zM544 352l-221.7 .0001c-11.82 0-66.29-9.652-66.29-64c0-30.62 21.75-56.1 51.1-62.75l.4991-.099c7.344-1.456 12.52-7.902 12.52-15.23c0-2.294-.2823-.9048-.8597-12.18C321.4 159 353.1 128 392.1 128c24.25 0 46.75 12.25 60.12 32.75l.2673 .4112c2.963 4.558 7.939 7.074 13.04 7.074c2.531 0 5.094-.6189 7.459-1.915l.3563-.1953c7.385-4.031 15.04-5.831 22.46-5.831c25.5 0 48.32 21.23 48.41 46.21c0 0-.052 3.42-.052 3.501c0 7.418 5.251 13.82 12.55 15.25C586.6 231.2 608.1 257.6 608.1 288C608 323.2 579.3 352 544 352zM594.3 432.1c0-6.412-5.042-16.07-16.09-16.07c-5.538 0-10.94 2.863-13.87 8.139l-36.63 64c-1.416 2.467-2.085 5.157-2.085 7.815C525.7 502 530.4 512 541.8 512c5.5 0 10.88-2.875 13.88-8.125l36.63-64C593.7 437.4 594.3 434.7 594.3 432.1zM402.3 432.1c0-6.412-5.042-16.07-16.09-16.07c-5.538 0-10.94 2.863-13.87 8.139l-36.62 64c-1.416 2.467-2.085 5.157-2.085 7.815C333.7 502 338.4 512 349.8 512c5.5 0 10.87-2.875 13.87-8.125l36.62-64C401.7 437.4 402.3 434.7 402.3 432.1z"],
    "cloud-word": [640, 512, [], "e138", "M368 352h-96C263.2 352 256 359.2 256 368C256 376.8 263.2 384 272 384h96c8.836 0 16-7.164 16-16C384 359.2 376.8 352 368 352zM288 304C288 295.2 280.8 288 272 288h-128C135.2 288 128 295.2 128 304C128 312.8 135.2 320 144 320h128C280.8 320 288 312.8 288 304zM208 352h-32C167.2 352 160 359.2 160 368C160 376.8 167.2 384 176 384h32C216.8 384 224 376.8 224 368C224 359.2 216.8 352 208 352zM464 352h-32c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16h32c8.836 0 16-7.164 16-16C480 359.2 472.8 352 464 352zM571.8 238.8C574.5 228.9 576 218.6 576 208C576 146.1 525.9 96 464 96c-16.75 0-32.88 3.609-48 10.75C384.4 61.77 331.8 32 272 32C177.6 32 100.2 106.4 96.2 200.1C39.2 220.1 0 274.2 0 336C0 415.6 64.38 480 144 480H512c70.75 0 128-57.25 128-128C640 305 614.3 261.3 571.8 238.8zM507.6 448H149.5c-58.31 0-110.9-42.17-116.9-100.2c-5.812-56.64 30.66-105.9 81.69-119.9C122.6 225.7 128.1 217.7 128 209.1v-1C128 147.4 165.1 91.39 222.7 72.22c71.47-23.8 139.2 6.719 172.3 60.91c6 9.781 18.38 12 28.22 6.109c16.91-10.08 37.81-14.08 59.94-9c26.84 6.156 49.44 27.02 57.25 53.42c5.812 19.61 4.344 38.75-2.5 55.16c-4.125 9.984 2.062 20.73 11.97 25c37.34 15.97 62.44 55.06 57.53 99.23C601.9 412.3 557.2 448 507.6 448zM496 287.1h-160c-8.836 0-16 7.164-16 16c0 8.838 7.164 16 16 16h160c8.836 0 16-7.162 16-16C512 295.2 504.8 287.1 496 287.1z"],
    "cloud-xmark": [640, 512, [], "e35f", "M571.8 238.8C574.5 228.9 576 218.6 576 208C576 146.1 525.9 96 464 96c-16.75 0-32.88 3.625-48 10.75C384.4 61.75 331.8 32 272 32C177.6 32 100.2 106.4 96.2 200.1C39.2 220.1 0 274.3 0 336C0 415.6 64.38 480 144 480H512c70.75 0 128-57.25 128-128C640 305 614.3 261.3 571.8 238.8zM507.5 448H149.5c-58.31 0-110.9-42.16-116.9-100.2C26.8 291.2 63.27 241.9 114.3 227.1c8.369-2.291 13.78-10.26 13.73-18.94C128 208.7 128 208.4 128 208C127.1 147.3 165.1 91.38 222.7 72.19c71.47-23.82 139.2 6.727 172.3 60.89c5.984 9.803 18.35 11.99 28.22 6.111c16.88-10.06 37.78-14.07 59.94-8.988c26.85 6.154 49.45 27 57.26 53.41c5.799 19.61 4.307 38.74-2.508 55.16c-4.137 9.969 2.061 20.75 11.98 24.1c37.34 15.97 62.42 55.06 57.5 99.25C601.9 412.3 557.1 448 507.5 448zM395.3 212.7c-6.25-6.25-16.38-6.25-22.62 0L320 265.4L267.3 212.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L297.4 288l-52.69 52.69c-6.25 6.25-6.25 16.38 0 22.62c6.242 6.246 16.37 6.254 22.62 0L320 310.6l52.69 52.69c6.242 6.246 16.37 6.254 22.62 0c6.25-6.25 6.25-16.38 0-22.62L342.6 288l52.69-52.69C401.6 229.1 401.6 218.9 395.3 212.7z"],
    "clouds": [640, 512, [], "f744", "M543.7 304.4C539.8 259.4 501.1 224 456 224c-17.92 0-34.85 5.273-49.22 15.12C384.2 209.6 349.3 192 311.9 192C245.7 192 192 245.1 192 312.2c0 .1016-.002-.0977 0 0C153.6 328.2 128 365.9 128 408c0 57.35 46.65 104 104 104h303.1c57.35 0 104-46.6 104-103.9C640 353.4 597.5 308.3 543.7 304.4zM536 480H234.9c-33.32 0-64.09-21.36-72.5-53.6c-10.24-39.28 13.62-77.56 50.87-87.65c7.695-2.014 12.69-9.41 11.77-17.31c-.8887-7.646-1.211-6.404-.918-13.17c1.34-30.84 18.11-59.68 45.58-73.76c46.55-23.87 97.39-5.072 119.6 36.24c8.369 15.84 21.93 7.512 24.6 4.621c9.115-9.861 21.16-16.89 34.46-18.77c38.57-5.449 67.2 28.68 62.7 64.32l-.084 .668c-1.117 8.852 6.303 16.44 15.18 15.51c40.06-4.172 77.84 24.05 81.58 64.16C611.7 443.1 578 480 536 480zM168 272c0-8.837-7.163-16-16-16H97.22C65.61 256 36.87 233.7 32.59 202.4C27.96 168.5 50.92 138.2 83.75 132.8c7.088-1.182 12.51-6.955 13.25-14.1C101.1 69.27 142.8 32 192 32c39.5 0 75.5 25 89.63 62.25c3.232 8.621 13.11 12.79 21.5 9c11.03-4.934 22.47-7.439 34.18-7.239c20.63 .3545 39.9 10.86 53.92 25.1C409.9 142.2 415.9 159.9 415.9 176c0 8.837 7.312 16 16.15 16c8.837 0 16-7.163 16-16c0-61.75-50.25-112-112-112c-10.5 0-20.88 1.5-31 4.5C283 27 239.4 0 192 0C130.3 0 78.25 43.88 66.88 103.8C24.08 116.7-4.692 158.2 .6339 204.8C6.132 252.9 49.28 288 97.71 288h54.29C160.8 288 168 280.8 168 272z"],
    "clouds-moon": [640, 512, [], "f745", "M446.5 321.2c-6.99-37.04-39.49-65.16-78.53-65.16c-12.03 0-23.75 2.701-34.42 7.88C315.7 239.2 286.8 224 255.9 224c-52.95 0-96.02 43.08-96.02 96.04c0 1.809 .0645 3.641 .1934 5.508c-37.93 13.16-64.21 49.07-64.21 90.42C95.9 468.9 138.1 512 191.9 512h240.1c52.88 0 95.95-43.07 95.95-95.96C527.1 368.1 492.5 328.2 446.5 321.2zM432 480H194.2c-32.89 0-62.1-23.84-65.87-56.51c-3.941-34.19 19.38-64.5 52.33-70.31c8.951-1.629 14.92-10.37 13.01-19.26c-1.125-5.004-1.752-9.629-1.752-13.88C191.9 284.6 220.7 256 255.9 256c24.63 0 47.27 14.51 57.77 37.02c4.322 9.344 16.27 12.15 24.29 5.699c12.89-10.31 29.38-13.37 44.93-8.248c20.1 6.619 32.94 26.38 32.94 47.54c0 7.596 6.158 14.04 13.75 14.04c32.17 0 61.02 22.75 65.59 54.58C500.9 446.1 470.4 480 432 480zM95.1 320c-36.73 0-66.4-31.21-63.85-68.47C34.48 217.6 64.28 192 98.31 192h15.45c7.547 0 14.04-5.344 15.49-12.75C135.2 149.5 161.7 128 191.1 128c30.25 0 56.76 21.5 62.76 51.25C256.2 186.7 262.7 192 270.2 192H288c24.61 0 45.8 14.16 56.5 34.61c7.619-1.641 15.47-2.604 23.43-2.604c3.559 0 6.931 .4824 10.42 .8105C365.3 187.3 329.9 160 288 160H282.5c-13.25-37.75-49.5-64-90.49-64c-40.1 0-77.26 26.25-90.51 64H98.87c-50.79 0-94.94 38.26-98.61 88.92c-3.715 51.21 33.24 94.44 81.69 101.7C88.79 339.1 97.57 328.9 107.7 320H95.1zM636.6 248.1c-5.094-8.406-14.5-12.69-24.2-10.75c-31 5.812-62.52-2.281-86.56-22.25c-23.78-19.72-37.42-48.63-37.42-79.38c0-37.13 20.2-71.59 52.61-89.88c8.672-4.781 13.23-14.19 11.61-23.97c-1.625-9.812-9-17.25-18.56-18.97C524.1 .9687 513.7 0 503.1 0c-82.51 0-151.2 58.92-166.1 137.9c10.75 4.516 20.81 10.49 29.92 17.72C373.7 85.86 433.8 31.35 505.1 32c-30.45 25.5-48.63 63.41-48.63 103.7c0 40.28 17.86 78.22 49 104c24.98 20.69 55.66 32 88.2 31.44c-20.97 18.28-46.95 29.75-75.05 32.91l-21.61 2.352c12.4 7.453 23.36 16.88 32.58 27.89c41.26-6.492 78.48-27.14 105.1-59.71C640.1 266.9 641.7 256.5 636.6 248.1z"],
    "clouds-sun": [640, 512, [], "f746", "M138.3 314.2l-45.7 9.05L105.1 260c1.125-6.25-1.375-12.75-6.875-16.5l-53.5-35.75l53.5-35.88c5.5-3.625 8-10.12 6.875-16.5l-12.5-63.13l63.13 12.5c6.5 1.25 12.88-1.5 16.5-6.875L208 44.38L243.8 98c3.625 5.25 10 8.125 16.5 6.75l63.13-12.5L316.1 128.9c-2.22 11.21 8.23 20.79 19.21 17.61c5.348-1.551 9.426-5.895 10.64-11.33L359.4 75c1-5.25-.625-10.62-4.375-14.38c-3.75-3.875-9-5.5-14.38-4.375l-76.25 15l-43.13-64.5c-6-9-20.5-9-26.5 0L151.5 71.25L75.25 56.13C69.1 55 64.75 56.75 60.88 60.5C57.13 64.25 55.5 69.75 56.5 74.88l15.12 76.38l-64.5 43.13C2.75 197.4 0 202.4 0 207.8C0 213 2.75 218 7.125 221l64.5 43.25L56.5 340.4c-1 5.375 .625 10.75 4.375 14.38c3.875 3.75 9.25 5.5 14.38 4.5l69.24-12.46c8.692-1.564 14.63-9.665 13.51-18.43C156.8 318.8 147.8 312.3 138.3 314.2zM208 149.8c28.75 0 52.5 21.25 56.88 48.88c2.375-.875 4.875-1.875 7.375-2.375c5-9 11.12-17.12 18-24.5C276.3 140 244.8 117.8 208 117.8c-49.5 0-89.75 40.38-89.75 90c0 39.5 25.62 72.63 61 84.75c.0685-.3065 3.758-16.02 10.62-30.12c-23-7.625-39.75-29.12-39.75-54.63C150.3 175.8 176.1 149.8 208 149.8zM550.4 164.8h-.5c-16.62-40.63-55.25-69.13-99.38-69.13c-46.38 0-86.25 30.12-101.5 74.13c-13.47 4.734-25.26 12.88-34.94 23.21c14.01 1.117 27.62 4.273 40.35 9.789c2.13-1.027 4.307-1.964 6.538-2.772c8.45-3.06 14.97-9.89 17.85-18.41c10.6-31.45 38.53-53.95 71.58-53.95c31.98 0 59.02 20.86 70.37 50.54c4.546 11.89 16.65 18.66 29.37 18.59c.0861-.0005-.0862 0 0 0c31.88 0 57.75 27.5 57.75 61.5c.1094 29.77-19.62 54.55-45.93 60.26c8.922 7.551 16.84 16.14 23.44 25.78C617.4 330.1 640 296.9 640 258.3C640 206.8 599.8 164.8 550.4 164.8zM494.6 321.2c-6.99-37.04-39.58-65.14-78.61-65.14c-12.02 0-23.64 2.684-34.31 7.863C363.8 239.2 335 224 304.1 224c-52.93 0-95.1 43.08-95.1 96.04c0 1.809 .0645 3.645 .1934 5.512c-37.91 13.16-64.19 49.07-64.19 90.42C144.1 468.9 187.2 512 240.1 512h239.1C532.1 512 576 468.1 576 416.1C576 368.1 540.6 328.2 494.6 321.2zM480.1 480l-237.7 .0001c-32.89 0-62.1-23.84-65.86-56.51c-3.941-34.19 19.37-64.5 52.31-70.31c11.08-2.018 15.14-9.321 13.52-16.86c-1.15-5.342-2.267-10.24-2.267-16.29C240.1 284.6 268.9 256 304.1 256c24.62 0 47.25 14.51 57.75 37.02c5.332 11.53 14.39 13.65 24.37 5.629c12.89-10.32 29.3-13.3 44.84-8.172c20.08 6.627 32.91 26.39 32.91 47.54c0 7.581 6.146 14.04 13.73 14.04c32.16 0 61.02 22.75 65.59 54.59C548.1 446.1 518.5 480 480.1 480z"],
    "clover": [512, 512, [], "e139", "M497.6 255.7c9.156-13.56 14.09-29.75 14.09-46.78C511.7 164.3 477.2 128 434.9 128c-20.88 0-50.38 14.66-86.41 35.53C369.3 127.5 384 98 384 77.13C384 34.59 347.7 0 303.1 0c-17.06 0-33.69 5.156-47.34 14.44C242.2 5.281 225.1 .3438 208.9 .3438C164.3 .3438 128 34.78 128 77.13C128 98 142.7 127.5 163.5 163.5C127.5 142.7 97.1 128 77.13 128C34.59 128 0 164.3 0 208.9C0 226 5.156 242.6 14.44 256.3C5.281 269.8 .3438 286 .3438 303.1C.3438 347.7 34.78 384 77.13 384c20.87 0 50.38-14.66 86.41-35.53C142.7 384.5 128 414 128 434.9C128 477.4 164.3 512 208.9 512c17.06 0 33.69-5.156 47.34-14.44c13.56 9.156 29.75 14.09 46.78 14.09C347.7 511.7 384 477.2 384 434.9c0-20.88-14.66-50.38-35.53-86.41C384.5 369.3 413.1 384 434.9 384C477.4 384 512 347.7 512 303.1C512 286 506.8 269.4 497.6 255.7zM434.9 352c-18.34 0-65.03-27.88-92.94-44.53c-11.91-7.125-22.53-13.44-30.5-17.62c-6.219-3.312-13.84-2.094-18.75 2.844c-4.969 4.969-6.125 12.56-2.844 18.75c4.188 7.969 10.5 18.59 17.62 30.5C324.1 369.8 352 416.5 352 434.9c0 24.69-21.97 44.78-48.94 44.78c-13.66 0-26.31-5.031-35.63-14.12c-6.25-6.125-16.22-6.031-22.47 .0938C235.8 474.8 222.6 480 208.9 480C181.1 480 160 459.8 160 434.9c0-18.34 27.88-65.03 44.53-92.94c7.125-11.91 13.44-22.53 17.62-30.5c3.281-6.188 2.125-13.78-2.844-18.75C216.3 289.6 212.2 288 208 288C205.5 288 202.9 288.6 200.6 289.8c-7.969 4.188-18.59 10.5-30.5 17.62C142.2 324.1 95.47 352 77.13 352c-24.69 0-44.78-21.97-44.78-48.94c0-13.66 5.031-26.31 14.12-35.63c6.125-6.25 6.062-16.25-.0938-22.47C37.25 235.8 32 222.6 32 208.9C32 181.1 52.25 160 77.13 160c18.34 0 65.03 27.88 92.94 44.53c11.91 7.125 22.53 13.44 30.5 17.62c6.156 3.25 13.81 2.062 18.75-2.844c4.969-4.969 6.125-12.56 2.844-18.75c-4.188-7.969-10.5-18.59-17.62-30.5C187.9 142.2 160 95.47 160 77.13c0-24.69 21.97-44.78 48.94-44.78c13.66 0 26.31 5.031 35.63 14.12c6.281 6.188 16.25 6.094 22.47-.0938C276.3 37.25 289.4 32 303.1 32C330 32 352 52.25 352 77.13c0 18.34-27.88 65.03-44.53 92.94c-7.125 11.91-13.44 22.53-17.62 30.5c-.0918 .1719-.0098 .373-.0938 .5469c-1.301 2.689-1.736 5.568-1.441 8.479c.0625 .623 .207 1.139 .3418 1.75c.627 2.904 1.779 5.717 4.037 7.975c2.254 2.254 5.059 3.406 7.957 4.035c.6172 .1387 1.135 .2773 1.764 .3418C302.9 223.7 303.5 224 304 224c2.385 0 4.699-.6914 6.891-1.752c.1738-.084 .375 0 .5469-.0918c7.969-4.188 18.59-10.5 30.5-17.62C369.8 187.9 416.5 160 434.9 160c24.69 0 44.78 21.97 44.78 48.94c0 13.66-5.031 26.31-14.12 35.63c-6.125 6.25-6.062 16.25 .0938 22.47C474.8 276.3 480 289.4 480 303.1C480 330 459.8 352 434.9 352z"],
    "club": [512, 512, [62247], "2663", "M374.5 176.2C380.5 161.3 384 145.1 384 128c0-70.69-57.31-128-128-128S128 57.31 128 128c0 17.06 3.482 33.27 9.541 48.16C60.01 175.3 0 237.9 0 312C0 387.1 60.89 448 136 448c42.13 0 79.21-19.53 104-49.7V480h-64C167.2 480 160 487.2 160 496C160 504.8 167.2 512 176 512h160c8.836 0 16-7.164 16-16c0-8.838-7.164-16-16-16h-64v-81.7C296.8 428.5 333.9 448 376 448C451.1 448 512 387.1 512 312C512 237.8 451.9 175.3 374.5 176.2zM376 416c-38.39 0-73.51-21.51-91.66-56.13C278.8 349.3 267.9 342.8 256 342.8s-22.8 6.51-28.34 17.08C209.5 394.5 174.4 415.1 136 415.1c-60.68 0-100.4-49.02-103.7-96.48C27.88 257.3 77.95 208.4 134.2 208c1.293 .166 27.21 .4121 27.27 .4121c11.4 0 19.08-11.56 14.82-22.03C169.3 169.3 160 151.4 160 128c0-52.94 43.07-96 96-96c52.94 0 96 43.06 96 96c0 23.97-8.854 40.2-16.25 58.38C331.5 196.9 339.3 208.4 350.7 208.4c.0586 0-.0586 .002 0 0c27.1-.3223 26.92-.3994 26.97-.4033c51.35 .8027 106.9 44.3 102.1 111.5C476.4 367.1 436.4 416 376 416z"],
    "coconut": [512, 512, [], "e2f6", "M437.4 67.21l-39.86-39.89C379.1 8.799 353 0 322.9 0c-63.45 0-145.3 38.98-214.6 108.3c-102.2 102.2-138.5 231.8-80.99 289.3l39.89 39.89C116.9 487.2 182 512 247.2 512s130.2-24.85 179.9-74.54l10.36-10.36C536.8 327.7 536.8 166.6 437.4 67.21zM32.75 334.9C30.92 318.6 32.84 299.3 38.72 278.3c13.84-49.43 46.59-101.8 92.22-147.4C191.1 69.91 265.5 32 322.9 32c22.61 0 40.11 6.037 52.01 17.94c.002 .002-.002-.002 0 0c38.55 38.55 14.77 148.2-80.99 244c-61.03 61.03-134.6 98.94-191.1 98.94C61.86 392.9 37.81 374.6 32.75 334.9zM434.1 267.3l38.01 38.25c-9.361 34.62-27.04 66.47-52.07 93.25l-42.97-42.2c-6.312-6.172-16.44-6.109-22.62 .2187c-6.188 6.297-6.094 16.42 .1875 22.62l42.7 41.93c-27.41 25.16-60.01 42.7-95.39 51.62l-36.03-36.26c-6.219-6.234-16.34-6.328-22.62-.0625c-6.25 6.219-6.281 16.36-.0625 22.62l19.82 19.95C257.7 479.6 252.5 480 247.2 480c-54.44 0-105.8-19.62-146.3-55.19c.3887 .002 .7402 .0781 1.131 .0781c63.45 0 145.2-38.94 214.6-108.3c70.05-70.05 108.6-152.7 107.7-216.4C460.2 140.9 480 192.4 480 247.2c0 6.717-.3867 13.37-.9727 19.98l-22.28-22.42c-6.188-6.234-16.31-6.344-22.62-.0625C427.9 250.9 427.8 261 434.1 267.3zM257.3 257.1C310 204.3 344.1 147.3 344 111.9c-.0313-15.08-5.969-24.12-10.94-29.06c-33.78-33.67-114.1 15.83-174.4 76.11C105.1 211.7 71.94 268.7 72 304.1c.0313 15.08 5.969 24.12 10.94 29.06C90.53 340.8 100.5 344.1 112 344.1C151.8 344.1 210.6 303.8 257.3 257.1zM105.5 310.5C104.6 309.6 104 307.2 104 304.1C103.1 281.7 130.5 232.4 181.3 181.5c56.94-56.98 105.3-77.75 122.1-77.75c3 0 5.094 .5938 6.219 1.703C311.4 106.4 312 108.8 312 111.9c.0313 22.44-26.5 71.73-77.31 122.6C168.1 301.1 113.2 318.1 105.5 310.5z"],
    "code": [640, 512, [], "f121", "M171.1 117.4c-5.875-6.625-16-7.156-22.58-1.344l-144 127.1C1.953 247.1 0 251.4 0 256s1.953 8.938 5.375 11.97l144 127.1C152.4 398.7 156.2 400 160 400c4.406 0 8.797-1.812 11.95-5.375c5.875-6.594 5.281-16.72-1.328-22.59L40.08 256l130.5-116C177.2 134.1 177.8 123.1 171.1 117.4zM634.6 244l-144-127.1C484 110.2 473.9 110.8 468 117.4c-5.875 6.594-5.281 16.72 1.328 22.59l130.5 116l-130.5 116c-6.609 5.875-7.203 15.1-1.328 22.59C471.2 398.2 475.6 400 480 400c3.781 0 7.578-1.344 10.62-4.031l144-127.1C638 264.9 640 260.6 640 256S638 247.1 634.6 244zM405.1 .816c-8.438-2.781-17.44 1.781-20.23 10.12l-160 479.1c-2.797 8.375 1.734 17.44 10.11 20.25C236.6 511.8 238.3 512 240 512c6.703 0 12.94-4.25 15.17-10.94l160-479.1C417.1 12.69 413.4 3.628 405.1 .816z"],
    "code-branch": [448, 512, [], "f126", "M368 0C323.8 0 288 35.82 288 80c0 38.7 27.49 70.97 64 78.39V192c0 26.47-21.53 48-48 48h-160C125.9 240 109.4 246.3 96 256.4V158.4C132.5 150.1 160 118.7 160 80C160 35.82 124.2 0 80 0C35.82 0 0 35.82 0 80c0 38.7 27.49 70.97 64 78.39v195.2C27.49 361 0 393.3 0 432C0 476.2 35.82 512 80 512C124.2 512 160 476.2 160 432c0-38.7-27.48-70.97-64-78.39V320c0-26.47 21.53-48 48-48h160C348.1 272 384 236.1 384 192V158.4C420.5 150.1 448 118.7 448 80C448 35.82 412.2 0 368 0zM128 432C128 458.5 106.5 480 80 480S32 458.5 32 432S53.53 384 80 384S128 405.5 128 432zM80 128C53.53 128 32 106.5 32 80S53.53 32 80 32S128 53.53 128 80S106.5 128 80 128zM368 128C341.5 128 320 106.5 320 80S341.5 32 368 32S416 53.53 416 80S394.5 128 368 128z"],
    "code-commit": [640, 512, [], "f386", "M624 240h-177.6C438.4 176.9 385.2 128 320 128C254.8 128 201.6 176.9 193.6 240H16C7.156 240 0 247.2 0 256s7.156 16 16 16h177.6C201.6 335.1 254.8 384 320 384c65.21 0 118.4-48.95 126.4-112H624C632.8 272 640 264.8 640 256S632.8 240 624 240zM320 352c-52.93 0-96-43.07-96-96s43.07-96 96-96c52.94 0 96 43.07 96 96S372.9 352 320 352z"],
    "code-compare": [512, 512, [], "e13a", "M432 16C387.8 16 352 51.82 352 96c0 38.7 27.49 70.97 64 78.39V352c0 26.47-21.53 48-48 48h-83.8l62.05-51.72c6.781-5.656 7.703-15.75 2.047-22.53c-5.656-6.75-15.73-7.688-22.55-2.031l-96 80C226.1 406.8 224 411.3 224 416s2.109 9.25 5.75 12.28l96 80C328.8 510.8 332.4 512 335.1 512c4.594 0 9.141-1.969 12.31-5.75c5.656-6.781 4.734-16.88-2.047-22.53L284.2 432H368c44.11 0 80-35.88 80-80V174.4C484.5 166.1 512 134.7 512 96C512 51.82 476.2 16 432 16zM432 144C405.5 144 384 122.5 384 96s21.53-48 48-48S480 69.53 480 96S458.5 144 432 144zM288 96c0-4.75-2.109-9.25-5.75-12.28l-96-80C179.4-1.969 169.4-1 163.7 5.75C158 12.53 158.1 22.62 165.8 28.28L227.8 80H144C99.89 80 64 115.9 64 160v177.6C27.49 345 0 377.3 0 416c0 44.18 35.82 80 80 80C124.2 496 160 460.2 160 416c0-38.7-27.48-70.97-64-78.39V160c0-26.47 21.53-48 48-48h83.8L165.8 163.7C158.1 169.4 158 179.5 163.7 186.3C166.9 190 171.4 192 176 192c3.609 0 7.234-1.219 10.23-3.719l96-80C285.9 105.3 288 100.8 288 96zM128 416c0 26.47-21.53 48-48 48S32 442.5 32 416s21.53-48 48-48S128 389.5 128 416z"],
    "code-fork": [448, 512, [], "e13b", "M448 80C448 35.82 412.2 0 368 0S288 35.82 288 80c0 38.7 27.48 70.97 64 78.39V192c0 26.47-21.53 48-48 48h-160C117.5 240 96 218.5 96 192V158.4C132.5 150.1 160 118.7 160 80C160 35.82 124.2 0 80 0S0 35.82 0 80c0 38.7 27.48 70.97 64 78.39V192c0 44.13 35.88 80 80 80h64v81.61c-36.52 7.414-64 39.68-64 78.39c0 44.18 35.82 80 80 80s80-35.82 80-80c0-38.7-27.48-70.97-64-78.39V272h64C348.1 272 384 236.1 384 192V158.4C420.5 150.1 448 118.7 448 80zM32 80C32 53.53 53.53 32 80 32S128 53.53 128 80S106.5 128 80 128S32 106.5 32 80zM272 432c0 26.47-21.53 48-48 48s-48-21.53-48-48S197.5 384 224 384S272 405.5 272 432zM368 128C341.5 128 320 106.5 320 80S341.5 32 368 32S416 53.53 416 80S394.5 128 368 128z"],
    "code-merge": [448, 512, [], "f387", "M368 192c-38.7 0-70.97 27.48-78.39 64H224C163.5 256 113 213.7 99.69 157.3C134.3 148.5 160 117.3 160 80C160 35.82 124.2 0 80 0C35.82 0 0 35.82 0 80c0 38.7 27.49 70.97 64 78.39v195.2C27.49 361 0 393.3 0 432C0 476.2 35.82 512 80 512C124.2 512 160 476.2 160 432c0-38.7-27.48-70.97-64-78.39V223C125.2 262.2 171.5 288 224 288h65.61c7.414 36.52 39.69 64 78.39 64c44.18 0 80-35.82 80-80S412.2 192 368 192zM128 432C128 458.5 106.5 480 80 480S32 458.5 32 432S53.53 384 80 384S128 405.5 128 432zM80 128C53.53 128 32 106.5 32 80S53.53 32 80 32S128 53.53 128 80S106.5 128 80 128zM368 320C341.5 320 320 298.5 320 272S341.5 224 368 224S416 245.5 416 272S394.5 320 368 320z"],
    "code-pull-request": [512, 512, [], "e13c", "M160 95.1c0-44.18-35.82-80-80-80c-44.18 0-80 35.82-80 80C0 134.7 27.49 166.1 64 174.4v163.2c-36.51 7.414-64 39.68-64 78.39c0 44.18 35.82 80 80 80c44.18 0 80-35.82 80-80c0-38.7-27.48-70.97-64-78.39V174.4C132.5 166.1 160 134.7 160 95.1zM128 416c0 26.47-21.53 48-48 48S32 442.5 32 416s21.53-48 48-48S128 389.5 128 416zM80 144C53.53 144 32 122.5 32 96s21.53-48 48-48S128 69.53 128 96S106.5 144 80 144zM448 337.6V160c0-44.13-35.88-80-80-80h-83.8l62.05-51.72c6.781-5.656 7.688-15.75 2.031-22.53s-15.75-7.691-22.53-2.034l-96 80C226.1 86.75 224 91.25 224 95.1s2.094 9.25 5.75 12.28l96 80c3 2.5 6.625 3.719 10.25 3.719c4.562 0 9.125-1.967 12.28-5.748c5.656-6.781 4.75-16.88-2.031-22.53L284.2 112H368C394.5 112 416 133.5 416 160v177.6c-36.51 7.414-64 39.68-64 78.39c0 44.18 35.82 80 80 80c44.18 0 80-35.82 80-80C512 377.3 484.5 345 448 337.6zM432 464c-26.47 0-48-21.53-48-48s21.53-48 48-48S480 389.5 480 416S458.5 464 432 464z"],
    "code-simple": [576, 512, [], "e13d", "M186.8 68.16C180.3 62.25 170.1 62.66 164.2 69.25l-159.1 176c-5.547 6.094-5.547 15.41 0 21.5l159.1 176C167.3 446.3 171.7 448 176 448c3.844 0 7.703-1.375 10.77-4.156c6.531-5.938 7.016-16.06 1.078-22.59L37.63 256l150.2-165.3C193.8 84.22 193.3 74.09 186.8 68.16zM571.8 245.3l-159.1-176c-5.953-6.594-16.06-7-22.61-1.094c-6.531 5.938-7.016 16.06-1.078 22.59L538.4 256l-150.2 165.3c-5.937 6.531-5.453 16.66 1.078 22.59C392.3 446.6 396.2 448 399.1 448c4.344 0 8.687-1.75 11.84-5.25l159.1-176C577.4 260.7 577.4 251.3 571.8 245.3z"],
    "coffee-bean": [448, 512, [], "e13e", "M287.2 32c-67.49 0-138.6 37.66-193.7 92.7C-82.77 300.7 19.86 480 160.9 480c67.49 0 138.9-37.67 193.1-92.71C531.3 210.1 427.4 32 287.2 32zM115.9 147.3C168.2 95.15 232.2 64 287.3 64c.19 0 .3799 .0004 .5698 .0011c30.08 .1162 58.71 13.46 80.34 34.31l.7481 .7228c-18.84 61.79-60.51 131.5-153.8 149c-80.5 15.12-137.1 60.78-165.1 132.6C12.43 334.4 32.1 231.1 115.9 147.3zM332.2 364.7C279.9 416.9 215.9 448 160.8 448c-47.12 0-62.83-16.11-87.01-40.27C96.57 337.8 146.9 293.4 221.1 279.5c82.92-15.6 142.1-68.62 172.1-154C448.1 189.4 396.1 300.8 332.2 364.7z"],
    "coffee-beans": [512, 512, [], "e13f", "M0 351.6c.1465 214 256.2 213.4 256 .7194C255.9 138.3-.1504 139 0 351.6zM125.3 480l-.4609-.0059c-24.97-.3301-49.55-13.53-64.42-33.2C41.03 421.2 32.02 384.6 32 351.6C31.95 282.6 68.38 228.7 100.4 224c-19.94 49.28-15.71 100.8 13.63 142.9C139 402.7 142.8 442.5 125.3 480zM160.5 476.9c13.99-42.28 7.5-88.26-19.98-127.7C114.8 312.3 113.3 267.2 135.8 222.7C223.8 225.3 223.1 349.2 224 352.4C224 397.5 206.9 458.4 160.5 476.9zM452.5 59.92c-152.6-152.5-320.5 16.64-168.1 168.2C436.1 380.6 604 211.4 452.5 59.92zM304.6 206.1c-32.15-32.14-64.26-86.81-46.89-130.7c20.91 39.37 57.93 67.88 104.1 77.93c43.18 9.352 76.28 40.62 93.18 87.11C395.2 297.5 306.8 209.2 304.6 206.1zM477.3 217.1c-21.98-48.28-61.45-82.21-110.7-92.91c-41.98-9.113-72.73-34.96-87.99-73.23c.1035-.0996 .207-.2012 .3086-.3008c16.67-16.22 42.25-22.1 66.04-18.77c31.03 5.51 62.99 25.63 86.5 49.14C480.7 130.2 495 192.6 477.3 217.1z"],
    "coffee-pot": [512, 512, [], "e002", "M431.5 177.6l41.49-124.6C476.4 42.7 468.7 32 457.8 32H80C35.82 32 0 67.82 0 112v96C0 216.8 7.199 224 16 224S32 216.8 32 208v-96C32 85.49 53.49 64 80 64h26.62l38.13 114.1C95.38 217.9 64 277.8 64 344.6c0 51.48 18.64 84.76 49.62 117.7C124.3 473.8 139.5 480 155.1 480l265.8 0c15.53 0 30.66-6.274 41.32-17.57C493.3 429.5 512 396.2 512 344.6C512 278.4 481.4 217.9 431.5 177.6zM140.4 64h295.3l-32 96H172.4L140.4 64zM178.5 192h219.8c21 16.88 54.63 42.13 72.5 96H105.4C123.5 234 158.3 208.4 178.5 192zM439 440.5C434.3 445.4 427.6 448.1 420.9 448H155.1c-6.875 .125-13.38-2.625-18.12-7.625C107.1 408.8 96 382.8 96 344.6C96.13 336.4 96.75 328.1 97.88 320h380.3C479.4 328.1 480 336.4 480 344.6C480 382.8 468.9 408.8 439 440.5z"],
    "coffin": [448, 512, [63174], "26b0", "M402.7 112.8L303.9 13.5C295.1 4.75 283.6 0 271.4 0H176.6C164.4 0 152.9 4.75 144.1 13.5L45.35 112.8c-11.25 11.38-15.88 28-12 43.63l79.88 320.8C118.2 497.6 136.6 512 157.7 512h132.5c21.13 0 39.51-14.38 44.51-34.88l79.89-320.8C418.5 140.8 413.9 124.1 402.7 112.8zM303.8 469.4C302.3 475.6 296.6 480 290.3 480H157.7c-6.375 0-12-4.375-13.5-10.62L64.35 148.6C63.23 143.9 64.6 138.8 68.1 135.3l98.64-99.13C169.5 33.5 172.1 32 176.6 32h94.76c3.75 0 7.125 1.5 9.75 4l98.76 99.25c3.502 3.5 4.877 8.625 3.752 13.38L303.8 469.4z"],
    "coffin-cross": [384, 512, [], "e051", "M370.7 112.8L271.9 13.5C263.1 4.75 251.6 0 239.4 0H144.6C132.4 0 120.9 4.75 112.1 13.5L13.35 112.8c-11.25 11.38-15.88 28-12 43.63l79.88 320.8C86.24 497.6 104.6 512 125.7 512h132.5c21.13 0 39.51-14.38 44.51-34.88l79.89-320.8C386.5 140.8 381.9 124.1 370.7 112.8zM271.8 469.4C270.3 475.6 264.6 480 258.3 480H125.7c-6.375 0-12-4.375-13.5-10.62L32.35 148.6C31.23 143.9 32.6 138.8 36.1 135.3l98.64-99.13C137.5 33.5 140.1 32 144.6 32h94.76c3.75 0 7.125 1.5 9.75 4l98.76 99.25c3.502 3.5 4.877 8.625 3.752 13.38L271.8 469.4zM272 176h-64v-64c0-8.844-7.155-16-15.1-16S176 103.2 176 112v64h-64C103.2 176 96 183.2 96 192s7.156 16 16 16h64v128c0 8.844 7.155 16 15.1 16S208 344.8 208 336v-128h64C280.8 208 288 200.8 288 192S280.8 176 272 176z"],
    "coin": [512, 512, [63580], "1fa99", "M256 64C114.6 64 0 128.5 0 208V320c0 70.75 114.6 128 256 128s256-57.25 256-128V208C512 128.5 397.4 64 256 64zM64 366.6C43.75 352 32 335.6 32 320V277.6C41.75 287.2 52.38 295.8 64 303V366.6zM144 401.9C127.5 397.6 111.5 392 96 385v-64.75c15.5 7 31.62 12.63 48 17V401.9zM240 415.6c-21.5-.75-42.88-2.875-64-6.625v-64.25c21.12 3.75 42.5 5.875 64 6.5V415.6zM336 409c-21.12 3.75-42.5 6-64 6.625v-64.38c21.5-.625 42.88-2.75 64-6.5V409zM416 385c-15.5 7-31.5 12.62-48 16.88v-64.63c16.38-4.375 32.5-10 48-17V385zM480 320c0 15.62-11.75 32-32 46.63V303c11.62-7.25 22.25-15.75 32-25.38V320zM256 320c-132 0-224-59-224-112S124 96 256 96s224 59 224 112S388 320 256 320z"],
    "coins": [512, 512, [], "f51e", "M192 160C85.96 160 0 195.8 0 240v192C0 476.2 85.96 512 192 512s192-35.82 192-80v-192C384 195.8 298 160 192 160zM352 432c0 12.34-55.01 48-160 48s-160-35.66-160-48v-51.81C66.39 401.8 125.2 416 192 416s125.6-14.24 160-35.81V432zM352 336c0 12.34-55.01 48-160 48s-160-35.66-160-48V284.2C66.39 305.8 125.2 320 192 320s125.6-14.24 160-35.81V336zM192 288C87.01 288 32 252.3 32 240S87.01 192 192 192s160 35.66 160 48S296.1 288 192 288zM320 0C224 0 128 26.36 128 79.09v32.13c0 8.881 7.156 16.07 16 16.07S160 120.1 160 111.2V79.09c0-19.19 63.81-48.19 160-48.19s160 29.01 160 48.19c0 14.31-39.5 38.22-113.6 45.86c-8.252 .8523-14.37 7.826-14.37 15.96c0 13.83 13.2 16.09 15.96 16.09c5.268 0 71.08-6.493 112-31.8v34.22c0 8.816-16.47 23.28-52.59 34.18c-6.927 2.091-11.41 8.465-11.41 15.37c0 1.537 .2221 3.1 .6887 4.648C418.8 220.6 425.1 225.1 432 225.1c5.233 0 30.28-8.46 48-19.48v34.16c0 8.816-16.47 23.28-52.59 34.18c-6.927 2.091-11.41 8.465-11.41 15.37c0 1.537 .2221 3.1 .6887 4.648C418.8 300.9 425.1 305.4 432 305.4c1.882 0 80-18.58 80-65.64V79.09C512 26.36 416 0 320 0z"],
    "colon": [128, 512, [], "3a", "M64 192c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C.0008 163.3 28.66 192 64 192zM64 96c17.64 0 32 14.36 32 32s-14.36 32-32 32S32 145.6 32 128S46.36 96 64 96zM64 320c-35.35 0-64 28.65-64 64c0 35.35 28.65 64 64 64s64-28.65 64-64C128 348.7 99.35 320 64 320zM64 416c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S81.64 416 64 416z"],
    "colon-sign": [320, 512, [], "e140", "M293.8 380.1c-25.23 20.58-54.88 31.95-85.13 35.01l70.84-292.7c4.798 3.125 9.754 5.885 14.29 9.581c6.877 5.532 16.98 4.532 22.57-2.281c5.608-6.844 4.59-16.94-2.272-22.53c-8.44-6.87-17.43-12.58-26.6-17.81l16.84-69.57c2.084-8.594-3.212-17.22-11.83-19.31c-8.616-1.938-17.26 3.188-19.35 11.81l-15.37 63.5c-14.57-5.285-29.49-8.911-44.67-10.55l10.1-45.45c2.084-8.594-3.212-17.22-11.83-19.31c-8.538-1.938-17.26 3.188-19.35 11.81l-12.61 52.09c-45.22 2.869-89.51 21.51-123.1 55.91C20.02 156.5 0 204.7 0 255.1s20.02 99.49 56.38 135.7c11.53 11.5 24.41 20.65 37.8 28.66l-17.39 71.85c-2.084 8.594 3.212 17.22 11.83 19.31C89.88 511.8 91.15 512 92.4 512c7.238 0 13.8-4.907 15.57-12.25l15.64-64.63c14.45 5.559 29.42 8.838 44.61 10.78l-11.22 46.35c-2.084 8.594 3.212 17.22 11.83 19.31C170.1 511.8 171.4 512 172.6 512c7.238 0 13.8-4.907 15.57-12.25l12.63-52.2c40.1-1.733 79.92-15.52 113.3-42.68c6.862-5.594 7.88-15.69 2.272-22.53C310.8 375.5 300.7 374.5 293.8 380.1zM79.07 369.1C48.77 338.9 32.08 298.7 32.08 255.1s16.68-82.91 46.98-113.1c26.14-26.07 59.11-40.8 93.21-45.17l-70.27 290.4C93.93 382.6 86.23 376.3 79.07 369.1zM131.2 403.7l74.28-306.9C220.7 98.03 235.7 101.5 250.2 107.2l-74.45 307.6C160.5 413.2 145.5 409.7 131.2 403.7z"],
    "columns-3": [640, 512, [], "e361", "M576 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V96C640 60.65 611.3 32 576 32zM64 448c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h128v384H64zM224 448V64h192v384H224zM608 416c0 17.64-14.36 32-32 32h-128V64h128c17.64 0 32 14.36 32 32V416z"],
    "comet": [512, 512, [], "e003", "M504.8 7.279c-6.375-6.375-15.75-8.875-24.5-6.25c-32.25 9.875-108.9 33.63-167.4 58.88c-1.166-3.83-3.572-20.44-20.12-27.5c-8.5-3.625-18.25-3.125-26.38 1.25c-43.25 22.5-150 81.13-208.4 139.5c-77.38 77.38-77.38 203.4 0 280.8c77.63 77.5 203.4 77.5 281 0c58.25-58.25 116.9-165 139.5-208.3c4.25-8.125 4.625-17.75 1.125-26.38c-6.754-16.4-23.03-18.63-27.5-20.12c25-58.13 49-134.9 58.88-167.3C513.7 23.15 511.2 13.65 504.8 7.279zM407.7 219.4l42.38 11.38c0 0-78.63 145.4-133.8 200.5c-64.88 64.88-170.8 65-235.6 0s-64.88-170.8 0-235.6c55.13-55 199.3-134.1 199.3-134.1l12.62 43c0 0 61.45-30.92 183.6-68.63C441.3 149.6 407.7 219.4 407.7 219.4zM221.7 173.8c-2.5-5.125-7.875-8.502-13.75-8.502c-5.75 0-11.12 3.377-13.75 8.502l-31.25 63.5L93.09 247.6c-5.748 .875-10.5 4.875-12.37 10.38c-1.75 5.625-.25 11.62 4 15.75l50.5 49.38l-12 69.63c-.75 4.5 .5 9 3.5 12.5c2.875 3.5 7.125 5.5 11.62 5.5c2.5 0 5-.625 7.125-1.875l62.51-32.73l62.61 32.73c5.123 2.75 11.37 2.375 16.12-1.125c4.625-3.375 7-9.25 6-15l-11.88-69.63l50.5-49.38c4.25-4.125 5.75-10.12 3.875-15.75c-1.75-5.5-6.625-9.5-12.38-10.38L252.1 237.3L221.7 173.8zM246.5 311.8l9 53l-47.5-25l-47.37 25l9.125-53l-38.5-37.5l52.1-7.75l23.75-48.13l23.75 48.13l53.12 7.75L246.5 311.8z"],
    "comma": [192, 512, [], "2c", "M156.4 327.4c-8.773-24.27-33.94-39.39-58.1-39.39c-.002 0 .0039 0 0 0c-9.959 .002-19.91 2.39-28.8 7.544c-15.66 9.051-26.41 24.44-29.45 42.25l-22.57 131.7c-2.986 17.32 6.9 34.29 23.49 40.31C44.12 511.3 48.34 511.1 52.51 511.1c12.67 0 24.82-6.604 31.51-18.03l67.69-115.4C160.8 363 162.5 344.4 156.4 327.4zM124.1 362.4l-67.71 115.4c-.793 1.355-2.105 1.98-4.18 1.98c-.4004 0-.8262-.0234-1.283-.0684c-2.016-.7305-3.221-2.746-2.861-4.822l22.57-131.7c1.434-8.383 6.508-15.65 13.96-19.96C88.29 321.1 92.59 320 97.36 320c12.71 0 25.13 7.857 28.91 18.31C129.2 346.3 128.4 355.1 124.1 362.4z"],
    "command": [448, 512, [], "e142", "M368 320H320V192h48C412.2 192 448 156.2 448 112C448 67.82 412.2 32 368 32S288 67.82 288 112V160H160V112C160 67.82 124.2 32 80 32S0 67.82 0 112C0 156.2 35.82 192 80 192H128v128H80C35.82 320 0 355.8 0 400C0 444.2 35.82 480 80 480S160 444.2 160 400V352h128v48c0 44.18 35.82 80 80 80s80-35.82 80-80C448 355.8 412.2 320 368 320zM320 112C320 85.53 341.5 64 368 64S416 85.53 416 112S394.5 160 368 160H320V112zM128 400C128 426.5 106.5 448 80 448S32 426.5 32 400S53.53 352 80 352H128V400zM128 160H80C53.53 160 32 138.5 32 112S53.53 64 80 64S128 85.53 128 112V160zM288 320H160V192h128V320zM368 448c-26.47 0-48-21.53-48-48V352h48c26.47 0 48 21.53 48 48S394.5 448 368 448z"],
    "comment": [512, 512, [61557, 61669], "1f5e9", "M256 64c123.5 0 223.1 79 223.1 176S379.5 416 256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.459-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.62l.1287-.3388c4.283-11.27 1.79-23.1-6.429-32.82C47.51 313.1 32.06 277.6 32.06 240C32.06 143 132.6 64 256 64zM256 32C114.7 32 .0272 125.1 .0272 240c0 47.63 19.92 91.25 52.91 126.2c-14.87 39.5-45.87 72.88-46.37 73.25c-6.624 7-8.374 17.25-4.625 26C5.817 474.2 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32z"],
    "comment-arrow-down": [512, 512, [], "e143", "M324.7 228.7L272 281.4V144C272 135.2 264.8 128 256 128S240 135.2 240 144v137.4L187.3 228.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l80 80C247.8 334.4 251.9 336 256 336s8.188-1.562 11.31-4.688l80-80c6.25-6.25 6.25-16.38 0-22.62S330.9 222.4 324.7 228.7zM256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416z"],
    "comment-arrow-up": [512, 512, [], "e144", "M267.3 132.7C264.2 129.6 260.1 128 256 128S247.8 129.6 244.7 132.7l-80 80c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0L240 182.6V320c0 8.844 7.156 16 16 16s16-7.156 16-16V182.6l52.69 52.69c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L267.3 132.7zM256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416z"],
    "comment-arrow-up-right": [512, 512, [], "e145", "M256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.92 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.459-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3379c4.283-11.27 1.791-24-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM326.1 145.2C324.2 144.4 322.1 144 320 144H192C183.2 144 176 151.2 176 160S183.2 176 192 176h89.38L164.7 292.7c-6.25 6.25-6.25 16.38 0 22.62C167.8 318.4 171.9 320 176 320s8.188-1.562 11.31-4.688L304 198.6V288c0 8.844 7.156 16 16 16s16-7.156 16-16V160c0-2.082-.4219-4.154-1.23-6.109C333.1 149.1 330 146.9 326.1 145.2z"],
    "comment-captions": [512, 512, [], "e146", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.625 26C5.817 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.91 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.518-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c12-15.12 29.75-40.5 40.75-69.63l.1289-.3398c4.283-11.27 1.789-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176s223.1 79 223.1 176S379.5 416 256 416zM224 240C224 231.2 216.8 224 208 224h-128C71.16 224 64 231.2 64 240S71.16 256 80 256h128C216.8 256 224 248.8 224 240zM304 288h-96C199.2 288 192 295.2 192 304S199.2 320 208 320h96c8.844 0 16-7.156 16-16S312.8 288 304 288zM144 288h-32C103.2 288 96 295.2 96 304S103.2 320 112 320h32C152.8 320 160 312.8 160 304S152.8 288 144 288zM400 288h-32C359.2 288 352 295.2 352 304s7.156 16 16 16h32c8.844 0 16-7.156 16-16S408.8 288 400 288zM432 224h-160C263.2 224 256 231.2 256 240S263.2 256 272 256h160C440.8 256 448 248.8 448 240S440.8 224 432 224z"],
    "comment-check": [512, 512, [], "f4ac", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.372 17.25-4.624 26C5.817 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.518-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c12-15.12 29.75-40.5 40.75-69.63l.1289-.3398c4.283-11.27 1.789-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176s223.1 79 223.1 176S379.5 416 256 416zM324.7 175.3L229.3 270.7L187.3 228.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l53.33 53.34c3 3 7.062 4.688 11.31 4.688s8.312-1.688 11.31-4.688l106.7-106.7c6.25-6.25 6.25-16.38 0-22.62S330.9 169.1 324.7 175.3z"],
    "comment-code": [512, 512, [], "e147", "M256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.92 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.459-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3379c4.283-11.27 1.791-24-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM223.3 156.7c-6.25-6.25-16.38-6.25-22.62 0l-72 72c-6.25 6.25-6.25 16.38 0 22.62l72 72C203.8 326.4 207.9 328 212 328s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L162.6 240l60.69-60.69C229.6 173.1 229.6 162.9 223.3 156.7zM311.3 156.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L349.4 240l-60.69 60.69c-6.25 6.25-6.25 16.38 0 22.62C291.8 326.4 295.9 328 300 328s8.188-1.562 11.31-4.688l72-72c6.25-6.25 6.25-16.38 0-22.62L311.3 156.7z"],
    "comment-dollar": [512, 512, [], "f651", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.9 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.372 17.25-4.624 26C5.818 474.3 14.4 480 24.02 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.14 14.25 92.89 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.518-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c12-15.12 29.75-40.5 40.75-69.63l.1289-.3398c4.283-11.27 1.789-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176s223.1 79 223.1 176S379.5 416 256 416zM260.2 224.5L252.9 222.5C218.8 212.1 214.3 206.4 216.5 194.2c3-16.64 28.03-20.52 51.47-17.05c6.562 .9687 14.53 3.047 25.06 6.516c8.375 2.766 17.47-1.812 20.19-10.2c2.781-8.391-1.781-17.44-10.19-20.2c-12.31-4.047-22.59-6.57-31-7.82V128c0-8.844-7.156-16-16-16s-16 7.156-16 16v16.8c-29.75 3.514-50.58 19.29-55.03 43.71C176.7 234.4 222.3 247.2 244.3 253.3L251.8 255.4c38.22 10.41 46.41 16.08 43.81 30.38c-3 16.64-27.97 20.61-51.53 17.03C236.2 301.7 230.6 300.1 205.1 291.5C196.8 288.6 187.7 293.2 184.9 301.6c-2.812 8.375 1.688 17.45 10.06 20.28c29.34 9.969 36.57 11.45 45.09 12.67V352c0 8.844 7.156 16 16 16s16-7.156 16-16v-16.8c29.72-3.51 50.59-19.29 55.03-43.72C335.5 245 290.2 232.7 260.2 224.5z"],
    "comment-dots": [512, 512, [62637, 62075, "commenting"], "1f4ac", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM256 216c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C280 226.7 269.3 216 256 216zM384 216c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C408 226.7 397.3 216 384 216zM128 216c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 253.3 152 240C152 226.7 141.3 216 128 216z"],
    "comment-exclamation": [512, 512, [], "f4af", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM255.1 287.1C264.8 287.1 272 280.8 272 272V128c0-8.844-7.156-16-16-16S240 119.2 240 128v144C240 280.8 247.1 287.1 255.1 287.1zM256 312c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C280 322.7 269.3 312 256 312z"],
    "comment-image": [512, 512, [], "e148", "M160 184c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S136 146.7 136 160C136 173.3 146.7 184 160 184zM256 32C114.7 32 .0273 125.1 .0273 240c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM313.6 155.2c-11.61-14.22-36.39-14.25-47.97 0L207.1 227.1L199.2 218.8c-11.47-11.94-33.27-11.94-44.73 0L104 271.2c-8.453 8.844-10.44 21.5-5.047 32.28C103.1 313.5 114.8 320 126.4 320h259.2c11.3 0 21.59-5.906 26.86-15.44c5.609-10.16 4.469-22.53-2.875-31.53L313.6 155.2zM131.1 288L176.1 241l20.44 21.22c3.188 3.312 7.562 5 12.19 4.906c4.578-.2187 8.859-2.344 11.75-5.906l68.28-85.84l91.75 112.6L131.1 288z"],
    "comment-lines": [512, 512, [], "f4b0", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM272 272h-128c-8.801 0-16 7.199-16 15.1C127.1 296.8 135.2 304 144 304h128c8.801 0 15.1-7.204 15.1-16C287.1 279.2 280.8 272 272 272zM368 176h-224c-8.801 0-16 7.199-16 15.1C127.1 200.8 135.2 208 144 208h224c8.801 0 15.1-7.204 15.1-16C383.1 183.2 376.8 176 368 176z"],
    "comment-medical": [512, 512, [], "f7f5", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25C397.4 447.1 512 354.9 512 239.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM336 208H288V160c0-8.838-7.164-16-16-16h-32C231.2 144 224 151.2 224 160v48H176C167.2 208 160 215.2 160 223.1V256c0 8.836 7.164 15.1 16 15.1H224v48C224 328.8 231.2 336 240 336h32c8.836 0 16-7.166 16-16v-48h48C344.8 271.1 352 264.8 352 256V223.1C352 215.2 344.8 208 336 208z"],
    "comment-middle": [512, 512, [], "e149", "M256 0C114.6 0 0 93.09 0 208c0 95.99 80.08 176.5 188.8 200.5l48.89 93.39C241.2 508.6 248.6 512 256 512s14.76-3.361 18.28-10.08l48.89-93.39C431.9 384.5 512 303.1 512 208C512 93.09 397.4 0 256 0zM316.3 377.3l-14.55 3.209L256 467.8l-45.72-87.34L195.7 377.3C99.33 356 32 286.4 32 208C32 110.1 132.5 32 256 32s224 78.95 224 176C480 286.4 412.7 356 316.3 377.3z"],
    "comment-middle-top": [512, 512, [], "e14a", "M323.2 103.5l-48.89-93.39C270.8 3.361 263.4 0 256 0S241.2 3.361 237.7 10.08l-48.89 93.39C80.08 127.5 0 208 0 304c0 114.9 114.6 208 256 208s256-93.09 256-208C512 208 431.9 127.5 323.2 103.5zM256 480c-123.5 0-224-78.95-224-176c0-78.4 67.33-148 163.7-169.3L210.3 131.5L256 44.17l45.72 87.34l14.55 3.209C412.7 155.1 480 225.6 480 304C480 401 379.5 480 256 480z"],
    "comment-minus": [512, 512, [], "f4b1", "M256 32C114.7 32 .0281 125.1 .0281 240c0 47.63 19.92 91.25 52.91 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.621 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256 416c-28.24 0-56.24-4.25-83.23-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.99 16.25-58.55 35.29-102.7 39.66c12-15.12 29.75-40.5 40.74-69.63l.1328-.3398c4.281-11.27 1.789-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM336 224h-160C167.2 224 160 231.2 160 240c0 8.834 7.156 15.1 16 15.1h160c8.84 0 16-7.16 16-15.1S344.8 224 336 224z"],
    "comment-music": [512, 512, [], "f8b0", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.94 91.25 52.93 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.844 474.3 14.35 480 23.97 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.18 14.25 92.92 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM338.3 124.8c-8.625-6-19.62-7.438-29.5-3.688l-96 36C200.3 161.8 192 173.8 192 187.1v73.72C184.7 257.8 176.6 256 168 256C137.1 256 112 277.5 112 304S137.1 352 168 352S224 330.5 224 304V187.1l96-35.97v77.72C312.7 225.8 304.6 224 296 224C265.1 224 240 245.5 240 272s25.12 48 56 48S352 298.5 352 272V151.1C352 140.6 346.8 130.8 338.3 124.8zM168 320C155.2 320 144 312.5 144 304S155.2 288 168 288S192 295.5 192 304S180.8 320 168 320zM296 288c-12.78 0-24-7.469-24-16S283.2 256 296 256S320 263.5 320 272S308.8 288 296 288z"],
    "comment-pen": [512, 512, ["comment-edit"], "f4ae", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM345.5 141.1c-7.617-7.559-17.5-12.83-28.23-13.78c-13.24-1.172-25.9 3.414-35.16 12.59L157.9 264.1c-2.234 2.215-3.754 5.039-4.375 8.113l-12.25 60.79c-2.234 11.11 7.633 20.91 18.83 18.68l61.25-12.15c3.094-.6133 5.938-2.125 8.172-4.344l123.1-122.2c7.617-7.555 12.92-17.37 13.87-28.02c1.168-13.14-3.457-25.7-12.71-34.88L345.5 141.1zM210.3 309.3L177.3 315.9l6.594-32.71l86.88-86.23l26.38 26.18L210.3 309.3zM331.1 189.4l-11.3 11.22l-26.38-26.18l11.31-11.22c4.688-4.645 12.28-4.652 16.97 .0039l9.41 9.336C335.8 177.2 335.8 184.8 331.1 189.4z"],
    "comment-plus": [512, 512, [], "f4b2", "M256 32C114.7 32 .0281 125.1 .0281 240c0 47.63 19.92 91.25 52.91 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.621 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256 416c-28.24 0-56.24-4.25-83.23-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.99 16.25-58.55 35.29-102.7 39.66c12-15.12 29.75-40.5 40.74-69.63l.1328-.3398c4.281-11.27 1.789-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM336 224h-64V159.1C272 151.2 264.8 144 256 144S240 151.2 240 159.1V224h-64C167.2 224 160 231.2 160 240c0 8.834 7.156 15.1 16 15.1h64v64C240 328.8 247.2 336 256 336c8.836 0 16-7.16 16-15.1V255.1h64c8.84 0 16-7.16 16-15.1S344.8 224 336 224z"],
    "comment-question": [512, 512, [], "e14b", "M278.1 128H229.7C200.1 128 176 152.1 176 181.6c0 8.844 7.156 16 16 16s16-7.156 16-16C208 169.7 217.7 160 229.7 160h48.47C292.4 160 304 171.6 304 185.9c0 9.875-5.469 18.75-14.53 23.27L248.6 230.3C243.3 233.1 240 238.6 240 244.5V272C240 280.8 247.2 288 256 288s16-7.156 16-16V254.3l32-16.61c19.75-9.875 32-29.76 32-51.82C336 153.9 310 128 278.1 128zM256 312c-11.04 0-20 8.953-20 20C236 343 244.1 352 256 352s20-8.955 20-20C276 320.1 267 312 256 312zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-208S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416z"],
    "comment-quote": [512, 512, [], "e14c", "M183.1 143.1c-30.93 0-56 25.07-56 56s25.07 56 56 56c8.627 0 16.7-2.111 24-5.596V256c0 26.47-21.53 48-48 48c-8.844 0-16 7.156-16 16s7.156 15.1 15.1 15.1C204.1 335.1 240 300.1 240 256L239.1 199.1C239.1 169.1 214.9 143.1 183.1 143.1zM184 224C170.8 224 160 213.2 160 200C160 186.8 170.8 176 184 176c13.23 0 24 10.77 24 24C208 213.2 197.2 224 184 224zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM327.1 143.1c-30.93 0-56 25.07-56 56s25.07 56 56 56c8.627 0 16.7-2.111 24-5.596V256c0 26.47-21.53 48-48 48C295.2 304 288 311.2 288 320s7.156 15.1 15.1 15.1C348.1 335.1 384 300.1 384 256l-.0001-56C383.1 169.1 358.9 143.1 327.1 143.1zM328 224c-13.23 0-24-10.77-24-24c0-13.23 10.77-24 24-24C341.2 176 352 186.8 352 200C352 213.2 341.2 224 328 224z"],
    "comment-slash": [640, 512, [], "f4b3", "M320 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C111.5 313.1 96.06 277.6 96.06 240c0-23.41 5.969-45.72 16.58-66.18L87.29 153.8c-14.77 26.29-23.26 55.41-23.26 86.2c0 47.63 19.92 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C69.82 474.3 78.38 480 88 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c40.5 0 78.68-7.852 112.7-21.46l-29.49-23.28C377.5 411.4 349.5 416 320 416zM320 64c123.5 0 223.1 79 223.1 176c0 31.9-11.04 61.77-30.02 87.6l24.99 19.73C562.3 315.1 576 279.3 576 240c0-114.9-114.6-207.1-255.1-207.1c-51.04 0-98.47 12.28-138.4 33.2l27.81 21.96C242.1 72.5 279.8 64 320 64zM633.9 483.4L25.9 3.418C18.1-2.02 8.936-.8477 3.436 6.059c-5.469 6.938-4.281 17 2.656 22.49l608 480C617 510.9 620.5 512 624 512c4.719 0 9.406-2.094 12.56-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "comment-smile": [512, 512, [], "f4b4", "M192 216c13.25 0 24-10.75 24-24S205.3 168 192 168S168 178.8 168 192S178.8 216 192 216zM320 216c13.25 0 24-10.75 24-24S333.3 168 320 168S296 178.8 296 192S306.8 216 320 216zM331.8 285.3C313 307.4 285.4 320 256 320S199 307.4 180.3 285.4C174.5 278.8 164.4 278 157.8 283.6c-6.875 5.75-7.5 15.75-1.875 22.62c24.88 29 61.36 45.75 100.1 45.75s75.27-16.75 100.3-45.87c5.75-6.75 4.875-16.88-1.875-22.62C347.8 277.8 337.6 278.6 331.8 285.3zM256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416z"],
    "comment-sms": [512, 512, ["sms"], "f7cd", "M256 32C114.6 32 .0137 125.1 .0137 240c0 47.63 19.89 91.25 52.89 126.3c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.374 17.25-4.624 26C5.784 474.3 14.34 480 23.97 480c61.5 0 109.1-25.75 139.1-46.25C192.1 442.8 223.3 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 416c-28.25 0-56.25-4.25-83.25-12.75l-15.12-4.875l-13 9.25c-23 16.25-58.5 35.25-102.6 39.63c11.1-15.12 29.75-40.5 40.75-69.63l7.125-18.75l-13.62-14.62C47.38 313.8 32.13 277.6 32.13 240c0-97 100.5-176 224-176s224 79 224 176S379.5 416 256 416zM132.4 224.6l-4.109-1.188C111.3 218.4 111.7 216.3 112.2 213.5C112.1 209 122.4 206.9 133.7 208.6c4.172 .6719 8.766 2.109 13.14 3.609c8.359 2.891 17.47-1.578 20.33-9.922c2.875-8.344-1.562-17.45-9.922-20.33C151 179.8 144.5 177.9 138.6 177C108.1 172.3 84.69 184.7 80.64 208.1c-5.703 33 26.48 42.45 38.61 46.02l4.328 1.25c21.12 6.031 20.8 7.922 20.25 11.08c-.7813 4.516-10.2 6.688-21.61 4.906c-5.672-.8438-11.88-3.203-17.5-5.234L101.3 264.9c-8.391-3-17.48 1.422-20.42 9.734C77.97 283 82.33 292.1 90.66 295.1l3.203 1.156C101.1 298.8 109.3 301.8 117.4 303c4.359 .6719 8.578 1.016 12.61 1.016c24.28 0 41.91-12.06 45.38-32.11C181.1 238.5 149.4 229.5 132.4 224.6zM388.4 224.6l-4.109-1.188c-16.94-4.984-16.56-7.141-16.09-9.875c.7813-4.531 10.3-6.688 21.48-4.938c4.172 .6719 8.766 2.109 13.14 3.609c8.312 2.891 17.45-1.578 20.33-9.922c2.875-8.344-1.562-17.45-9.922-20.33c-6.156-2.125-12.66-4.031-18.58-4.969C364 172.3 340.7 184.7 336.6 208.1c-5.703 33 26.48 42.45 38.61 46.02l4.328 1.25c21.12 6.031 20.8 7.922 20.25 11.08c-.7656 4.516-10.23 6.688-21.61 4.906c-5.672-.8438-11.88-3.203-17.5-5.234l-3.375-1.203c-8.359-3-17.5 1.422-20.42 9.734c-2.953 8.344 1.406 17.48 9.734 20.42l3.203 1.156c7.219 2.594 15.39 5.531 23.52 6.766c4.359 .6719 8.578 1.016 12.61 1.016c24.28 0 41.91-12.06 45.38-32.11C437.1 238.5 405.4 229.5 388.4 224.6zM309.1 176.8C302.5 174.6 295.3 176.9 291.2 182.4L256 229.3L220.8 182.4C216.7 176.9 209.5 174.6 202.9 176.8C196.4 178.1 192 185.1 192 192v96c0 8.844 7.156 16 16 16S224 296.8 224 288V240l19.19 25.59c6.031 8.062 19.59 8.062 25.62 0L288 240V288c0 8.844 7.156 16 16 16S320 296.8 320 288V192C320 185.1 315.6 178.1 309.1 176.8z"],
    "comment-text": [512, 512, [], "e14d", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.62 19.92 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.374 17.25-4.624 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM320 160H192C183.2 160 176 167.2 176 176S183.2 192 192 192h48v112C240 312.8 247.2 320 256 320s16-7.156 16-16V192H320c8.844 0 16-7.156 16-16S328.8 160 320 160z"],
    "comment-xmark": [512, 512, ["comment-times"], "f4b5", "M256 31.1c-141.4 0-255.1 93.13-255.1 208c0 47.63 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.623 7-8.373 17.25-4.623 26C5.816 474.3 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.1 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-208S397.4 31.1 256 31.1zM256 416c-28.25 0-56.24-4.25-83.24-12.75c-9.516-3.068-19.92-1.461-28.07 4.338c-22.1 16.25-58.54 35.29-102.7 39.66c11.1-15.12 29.75-40.5 40.74-69.63l.1289-.3398c4.283-11.27 1.791-23.1-6.43-32.82C47.51 313.1 32.06 277.6 32.06 240c0-97 100.5-176 223.1-176c123.5 0 223.1 79 223.1 176S379.5 416 256 416zM331.3 164.7c-6.25-6.25-16.38-6.25-22.62 0L256 217.4L203.3 164.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L233.4 240L180.7 292.7c-6.25 6.25-6.25 16.38 0 22.62c6.242 6.246 16.37 6.254 22.62 0L256 262.6l52.69 52.69c6.242 6.246 16.37 6.254 22.62 0c6.25-6.25 6.25-16.38 0-22.62L278.6 240l52.69-52.69C337.6 181.1 337.6 170.9 331.3 164.7z"],
    "comments": [640, 512, [61574, 61670], "1f5ea", "M416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.48 17.07 79.54 45.44 109.6c-15.17 32.34-38.65 58.07-38.95 58.38c-6.514 6.836-8.309 16.91-4.568 25.67C5.754 378.4 14.26 384 23.66 384c54.19 0 97.76-20.73 125.9-39.17C168.1 349.4 187.7 352 208 352C322.9 352 416 273.2 416 176zM208 320c-16.96 0-34.04-2.098-50.75-6.232L143.7 310.4L132 318.1c-20.43 13.38-51.58 28.99-89.85 32.97c9.377-12.11 22.3-30.63 32.24-51.82l9.242-19.71L68.72 263.7C44.7 238.2 32 207.9 32 176C32 96.6 110.1 32 208 32S384 96.6 384 176S305 320 208 320zM606.4 435.4C627.6 407.1 640 372.9 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 5.43-.4668 10.76-.9414 16.09C447.4 192.1 447.7 192 448 192c88.22 0 160 64.6 160 144c0 28.69-9.424 56.45-27.25 80.26l-13.08 17.47l11.49 18.55c6.568 10.61 13.18 19.74 18.61 26.74c-18.26-1.91-36.45-6.625-54.3-14.09l-12.69-5.305l-12.58 5.557C495.9 475 472.3 480 448 480c-75.05 0-137.7-46.91-154.9-109.7c-10.1 3.336-20.5 6.132-31.2 8.271C282.7 455.1 357.1 512 448 512c29.82 0 57.94-6.414 83.12-17.54C555 504.5 583.7 512 616.3 512c9.398 0 17.91-5.57 21.73-14.32c3.74-8.758 1.945-18.84-4.568-25.67C633.3 471.8 619.6 456.8 606.4 435.4z"],
    "comments-dollar": [640, 512, [], "f653", "M212.4 160.6L206.8 159C179.7 151 180.5 146.3 181.6 139.8c1.891-10.91 19.22-13.41 34.81-10.91c5.812 .9062 12.22 2.906 18.3 5.031c8.375 2.875 17.47-1.531 20.36-9.875c2.906-8.344-1.516-17.47-9.859-20.38c-8.471-2.934-15.2-4.709-21.25-5.832V88c0-8.838-7.138-16-15.98-16c-8.836 0-16.02 7.162-16.02 16v9.275C169.4 101 153.6 114.2 150.1 134.4C143.3 173.7 181.5 184.9 197.8 189.7l5.781 1.688c28.67 8.188 32.33 11.81 30.77 20.81c-1.891 10.94-19.31 13.34-34.84 10.91C192.2 221.1 183.1 218.7 175.1 215.8L170.6 214.3C162.3 211.3 153.2 215.7 150.2 224C147.3 232.3 151.7 241.5 159.1 244.4l4.279 1.531c8.588 3.086 18.22 6.355 27.72 8.119V264c0 8.836 7.188 16 16.02 16c8.838 0 15.98-7.164 15.98-16V254.3c22.4-3.824 38.41-16.58 41.89-36.66C272.7 177.9 234.1 167.1 212.4 160.6zM606.4 435.4C627.6 407.1 640 372.9 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 5.43-.4668 10.76-.9414 16.09C447.4 192.1 447.7 192 448 192c88.22 0 160 64.6 160 144c0 28.69-9.424 56.45-27.25 80.26l-13.08 17.47l11.49 18.55c6.568 10.61 13.18 19.74 18.61 26.74c-18.26-1.91-36.45-6.625-54.3-14.09l-12.69-5.305l-12.58 5.557C495.9 475 472.3 480 448 480c-75.05 0-137.7-46.91-154.9-109.7c-10.1 3.336-20.5 6.132-31.2 8.271C282.7 455.1 357.1 512 448 512c29.82 0 57.94-6.414 83.12-17.54C555 504.5 583.7 512 616.3 512c9.398 0 17.91-5.57 21.73-14.32c3.74-8.758 1.945-18.84-4.568-25.67C633.3 471.8 619.6 456.8 606.4 435.4zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.48 17.07 79.54 45.44 109.6c-15.17 32.34-38.65 58.07-38.95 58.38c-6.514 6.836-8.309 16.91-4.568 25.67C5.754 378.4 14.26 384 23.66 384c54.19 0 97.76-20.73 125.9-39.17C168.1 349.4 187.7 352 208 352C322.9 352 416 273.2 416 176zM208 320c-16.96 0-34.04-2.098-50.75-6.232L143.7 310.4L132 318.1c-20.43 13.38-51.58 28.99-89.85 32.97c9.377-12.11 22.3-30.63 32.24-51.82l9.242-19.71L68.72 263.7C44.7 238.2 32 207.9 32 176C32 96.6 110.1 32 208 32S384 96.6 384 176S305 320 208 320z"],
    "comments-question": [640, 512, [], "e14e", "M208 224C196.1 224 188 232.1 188 244c0 11.04 8.955 20 20 20s20-8.955 20-20C228 232.1 219 224 208 224zM224.6 80H188.2C163.8 80 144 99.84 144 124.2c0 8.844 7.156 16 16 16s16-7.156 16-16C176 117.5 181.5 112 188.2 112h36.36C233.1 112 240 118.9 240 127.4c0 5.875-3.266 11.16-8.734 13.89L200.6 157.2C195.3 159.1 192 165.4 192 171.4V192c0 8.844 7.156 16 16 16S224 200.8 224 192V181.1l21.78-11.31C261.1 161.8 272 145.5 272 127.4C272 101.3 250.7 80 224.6 80zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.48 17.07 79.54 45.44 109.6c-15.17 32.34-38.65 58.07-38.95 58.38c-6.514 6.836-8.309 16.91-4.568 25.67C5.754 378.4 14.26 384 23.66 384c54.19 0 97.76-20.73 125.9-39.17C168.1 349.4 187.7 352 208 352C322.9 352 416 273.2 416 176zM208 320c-16.96 0-34.04-2.098-50.75-6.232L143.7 310.4L132 318.1c-20.43 13.38-51.58 28.99-89.85 32.97c9.377-12.11 22.3-30.63 32.24-51.82l9.242-19.71L68.72 263.7C44.7 238.2 32 207.9 32 176C32 96.6 110.1 32 208 32S384 96.6 384 176S305 320 208 320zM606.4 435.4C627.6 407.1 640 372.9 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 5.43-.4668 10.76-.9414 16.09C447.4 192.1 447.7 192 448 192c88.22 0 160 64.6 160 144c0 28.69-9.424 56.45-27.25 80.26l-13.08 17.47l11.49 18.55c6.568 10.61 13.18 19.74 18.61 26.74c-18.26-1.91-36.45-6.625-54.3-14.09l-12.69-5.305l-12.58 5.557C495.9 475 472.3 480 448 480c-75.05 0-137.7-46.91-154.9-109.7c-10.1 3.336-20.5 6.132-31.2 8.271C282.7 455.1 357.1 512 448 512c29.82 0 57.94-6.414 83.12-17.54C555 504.5 583.7 512 616.3 512c9.398 0 17.91-5.57 21.73-14.32c3.74-8.758 1.945-18.84-4.568-25.67C633.3 471.8 619.6 456.8 606.4 435.4z"],
    "comments-question-check": [640, 512, [], "e14f", "M208 224C196.1 224 188 232.1 188 244c0 11.04 8.955 20 20 20s20-8.955 20-20C228 232.1 219 224 208 224zM224.6 80H188.2C163.8 80 144 99.84 144 124.2c0 8.844 7.156 16 16 16s16-7.156 16-16C176 117.5 181.5 112 188.2 112h36.36C233.1 112 240 118.9 240 127.4c0 5.875-3.266 11.16-8.734 13.89L200.6 157.2C195.3 159.1 192 165.4 192 171.4V192c0 8.844 7.156 16 16 16S224 200.8 224 192V181.1l21.78-11.31C261.1 161.8 272 145.5 272 127.4C272 101.3 250.7 80 224.6 80zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 41.48 17.07 79.54 45.44 109.6c-15.17 32.34-38.65 58.07-38.95 58.38c-6.514 6.836-8.309 16.91-4.568 25.67C5.754 378.4 14.26 384 23.66 384c54.19 0 97.76-20.73 125.9-39.17C168.1 349.4 187.7 352 208 352C322.9 352 416 273.2 416 176zM208 320c-16.96 0-34.04-2.098-50.75-6.232L143.7 310.4L132 318.1c-20.43 13.38-51.58 28.99-89.85 32.97c9.377-12.11 22.3-30.63 32.24-51.82l9.242-19.71L68.72 263.7C44.7 238.2 32 207.9 32 176C32 96.6 110.1 32 208 32S384 96.6 384 176S305 320 208 320zM606.4 435.4C627.6 407.1 640 372.9 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 5.43-.4668 10.76-.9414 16.09C447.4 192.1 447.7 192 448 192c88.22 0 160 64.6 160 144c0 28.69-9.424 56.45-27.25 80.26l-13.08 17.47l11.49 18.55c6.568 10.61 13.18 19.74 18.61 26.74c-18.26-1.91-36.45-6.625-54.3-14.09l-12.69-5.305l-12.58 5.557C495.9 475 472.3 480 448 480c-75.05 0-137.7-46.91-154.9-109.7c-10.1 3.336-20.5 6.132-31.2 8.271C282.7 455.1 357.1 512 448 512c29.82 0 57.94-6.414 83.12-17.54C555 504.5 583.7 512 616.3 512c9.398 0 17.91-5.57 21.73-14.32c3.74-8.758 1.945-18.84-4.568-25.67C633.3 471.8 619.6 456.8 606.4 435.4zM388.7 338c-6.25 6.25-6.25 16.38 0 22.62L426 398c3 3 7.062 4.688 11.31 4.688S445.6 401 448.6 398l82.67-82.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-71.36 71.38l-26.02-26.03C405.1 331.8 394.9 331.8 388.7 338z"],
    "compact-disc": [512, 512, [128192, 128440, 62751], "1f4bf", "M256 232C242.8 232 232 242.8 232 256S242.8 280 256 280S280 269.3 280 256S269.2 232 256 232zM272 96c0-8.844-7.156-15.91-16-15.91c-97.05 0-176 78.88-176 175.9c0 8.844 7.156 16 16 16S112 264.8 112 256c0-79.41 64.59-144 144-144C264.8 112 272 104.8 272 96zM256 159.1c-53.02 0-96 43-96 96s42.98 95.1 96 95.1s96-43 96-95.1S309 159.1 256 159.1zM256 320c-35.33 0-64-28.75-64-64s28.67-64 64-64s64 28.75 64 64S291.3 320 256 320zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "compass": [576, 512, [61774], "1f9ed", "M304.9 272.1c9.43-9.361 9.43-24.59 0-33.96c-9.311-9.363-24.54-9.363-33.85 0c-9.432 9.363-9.432 24.59 0 33.96C280.4 282.3 295.6 282.3 304.9 272.1zM389.1 128c-2.131 0-4.379 .3652-6.51 1.1L231.2 183.7c-7.336 2.688-12.9 8.184-15.5 15.39l-54.55 151.4C155.6 365.8 171.2 384 186.9 384c2.248 0 4.379-.3672 6.508-1.1l151.5-54.6c7.219-2.688 12.78-8.184 15.38-15.51l54.55-151.3C420.4 146.2 404.8 128 389.1 128zM331.2 299.2l-135.1 48.69l48.67-135.1l135.1-48.75L331.2 299.2zM289.2 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S430.6 0 289.2 0zM289.2 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S412.7 480 289.2 480z"],
    "compass-drafting": [512, 512, ["drafting-compass"], "f568", "M509.9 488l-64.61-112c-4.438-7.656-14.27-10.3-21.86-5.859c-7.656 4.422-10.28 14.2-5.859 21.86l64.61 112c2.969 5.125 8.344 8 13.88 8c2.719 0 5.469-.6875 7.984-2.141C511.7 505.4 514.3 495.7 509.9 488zM491.6 232c4.438-7.656 1.812-17.44-5.828-21.86c-7.703-4.469-17.45-1.828-21.86 5.828C421.1 290 341.4 336 256 336c-39.93 0-78.43-10.39-112.7-28.67l87.55-151.8C238.8 158.2 247.2 160 256 160s17.18-1.775 25.13-4.42L343.7 264c2.969 5.125 8.344 8 13.88 8c2.719 0 5.469-.6875 7.984-2.141C373.2 265.4 375.8 255.7 371.4 248l-62.52-108.4C325.4 124.1 335.1 103.8 335.1 80C335.1 35.82 300.2 0 256 0C211.8 0 176 35.82 176 80c0 23.82 10.62 44.96 27.13 59.62L116.1 290.4C88.87 270.9 65.39 245.9 48.1 215.1C43.69 208.3 33.9 205.7 26.24 210.2C18.6 214.6 15.98 224.4 20.41 232c20.13 34.8 47.72 63.72 79.72 86.14L2.148 488c-4.422 7.656-1.797 17.44 5.859 21.86C10.54 511.3 13.27 512 15.99 512c5.531 0 10.91-2.875 13.88-8l97.47-168.1C166.4 356.1 210.4 368 256 368C352.8 368 443.1 315.9 491.6 232zM256 32c26.47 0 48 21.53 48 48S282.5 127.1 256 127.1c-26.46 0-47.1-21.53-47.1-47.1S229.5 32 256 32z"],
    "compass-slash": [640, 512, [], "f5e9", "M415.1 249.5l31.75-88.07C452.4 146.2 436.8 128 421.1 128c-2.131 0-4.379 .3652-6.51 1.1L310.2 166.7l29.57 23.35l72.1-26.01l-23.27 64.56L415.1 249.5zM321.2 32c123.5 0 224 100.5 224 224c0 29.49-5.871 57.6-16.27 83.41l26.07 20.58C569.2 328.2 577.2 293.1 577.2 256c0-141.4-114.6-256-256-256C262.8 0 209 19.82 165.9 52.82l26.04 20.56C228.5 47.42 273.1 32 321.2 32zM321.2 480c-123.5 0-224-100.5-224-224c0-28.92 5.693-56.49 15.72-81.89L86.76 153.4C72.99 184.9 65.23 219.5 65.23 256c0 141.4 114.6 256 256 256c57.9 0 111.1-19.45 154-51.87l-26.04-20.56C412.9 464.1 368.8 480 321.2 480zM224.9 262.5l-31.73 88.08C187.6 365.8 203.2 384 218.9 384c2.248 0 4.379-.3672 6.508-1.1l104.3-37.61L300.2 321.9l-72.13 26l23.26-64.58L224.9 262.5zM633.9 483.4l-608-480C19-2.033 8.922-.8457 3.438 6.092c-5.469 6.938-4.281 17 2.641 22.47l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.094C642 498.1 640.8 488.9 633.9 483.4z"],
    "compress": [448, 512, [], "f066", "M144 320h-128C7.156 320 0 327.2 0 336S7.156 352 16 352H128v112C128 472.8 135.2 480 144 480S160 472.8 160 464v-128C160 327.2 152.8 320 144 320zM304 192h128C440.8 192 448 184.8 448 176S440.8 160 432 160H320V48C320 39.16 312.8 32 304 32S288 39.16 288 48v128C288 184.8 295.2 192 304 192zM432 320h-128c-8.844 0-16 7.156-16 16v128c0 8.844 7.156 16 16 16s16-7.156 16-16V352h112c8.844 0 16-7.156 16-16S440.8 320 432 320zM144 32C135.2 32 128 39.16 128 48V160H16C7.156 160 0 167.2 0 176S7.156 192 16 192h128C152.8 192 160 184.8 160 176v-128C160 39.16 152.8 32 144 32z"],
    "compress-wide": [512, 512, [], "f326", "M368 224h128C504.8 224 512 216.8 512 208S504.8 192 496 192H384V80C384 71.16 376.8 64 368 64S352 71.16 352 80v128C352 216.8 359.2 224 368 224zM144 288h-128C7.156 288 0 295.2 0 304S7.156 320 16 320H128v112C128 440.8 135.2 448 144 448S160 440.8 160 432v-128C160 295.2 152.8 288 144 288zM496 288h-128C359.2 288 352 295.2 352 304v128c0 8.844 7.156 16 16 16s16-7.156 16-16V320h112c8.844 0 16-7.156 16-16S504.8 288 496 288zM144 64C135.2 64 128 71.16 128 80V192H16C7.156 192 0 199.2 0 208S7.156 224 16 224h128C152.8 224 160 216.8 160 208v-128C160 71.16 152.8 64 144 64z"],
    "computer-classic": [448, 512, [], "f8b1", "M384 0H64C28.8 0 0 28.8 0 64v320c0 23.63 12.95 44.04 32 55.12V480c0 17.66 14.34 32 32 32h320c17.66 0 32-14.34 32-32v-40.88C435 428 448 407.6 448 384V64C448 28.8 419.2 0 384 0zM384 480H64v-32h320V480zM416 384c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V64c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32V384zM319.1 64h-192c-35.35 0-64 28.65-64 64L64 192c0 35.35 28.65 64 63.1 64h192C355.3 256 384 227.3 384 192l0-64C383.1 92.65 355.3 64 319.1 64zM352 192c0 17.64-14.36 32-32 32H128C110.4 224 96 209.6 96 192V128c0-17.64 14.36-32 32-32h192c17.64 0 32 14.36 32 32V192zM96 312c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C120 322.7 109.3 312 96 312zM368 320h-128c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16S376.8 320 368 320z"],
    "computer-mouse": [384, 512, [63692, "mouse"], "1f5b1", "M224 0H160C71.63 0 0 71.62 0 160v192c0 88.38 71.63 160 160 160h64c88.38 0 160-71.63 160-160V160C384 71.62 312.4 0 224 0zM32 160c.125-70.62 57.38-127.9 128-128h16v160H32V160zM352 352c-.125 70.63-57.38 127.9-128 128H160c-70.63-.125-127.9-57.38-128-128V224h320V352zM352 192h-144V32H224c70.63 .125 127.9 57.38 128 128V192z"],
    "computer-mouse-scrollwheel": [384, 512, ["mouse-alt"], "f8cd", "M224 0H160c-88.38 0-160 71.63-160 160v192c0 88.38 71.63 160 160 160h64c88.38 0 160-71.63 160-160V160C384 71.62 312.4 0 224 0zM352 352c-.125 70.63-57.38 127.9-128 128H160c-70.63-.125-127.9-57.38-128-128V160c.125-70.63 57.38-127.9 128-128h64c70.63 .125 127.9 57.38 128 128V352zM192 95.1c-8.844 0-16 7.156-16 16v64C176 184.8 183.2 192 192 192s16-7.156 16-16v-64C208 103.2 200.8 95.1 192 95.1z"],
    "computer-speaker": [640, 512, [], "f8b2", "M480 192c26.5 0 48-21.5 48-48S506.5 96 480 96s-48 21.5-48 48S453.5 192 480 192zM480 128c8.875 0 16 7.125 16 16S488.9 160 480 160s-16-7.125-16-16S471.1 128 480 128zM480 224c-53 0-96 43-96 96s43 96 96 96s96-43 96-96S533 224 480 224zM480 384c-35.38 0-64-28.62-64-64s28.62-64 64-64s64 28.62 64 64S515.4 384 480 384zM480 296c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S493.3 296 480 296zM576 32h-192c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h192c35.35 0 64-28.65 64-64V96C640 60.65 611.3 32 576 32zM608 416c0 17.67-14.33 32-32 32h-192c-17.67 0-32-14.33-32-32V96c0-17.67 14.33-32 32-32h192c17.67 0 32 14.33 32 32V416zM48 64h224C280.8 64 288 56.84 288 48S280.8 32 272 32H47.1c-26.47 0-48 21.53-48 48L0 336C0 362.5 21.53 384 48 384h224C280.8 384 288 376.8 288 368S280.8 352 272 352h-224C39.17 352 32 344.8 32 336v-256C32 71.19 39.17 64 48 64zM272 448h-160C103.2 448 96 455.2 96 464S103.2 480 112 480h160C280.8 480 288 472.8 288 464S280.8 448 272 448z"],
    "container-storage": [640, 512, [], "f4b7", "M368 416c8.844 0 16-7.156 16-16v-288C384 103.2 376.8 96 368 96S352 103.2 352 112v288C352 408.8 359.2 416 368 416zM464 416c8.844 0 16-7.156 16-16v-288C480 103.2 472.8 96 464 96S448 103.2 448 112v288C448 408.8 455.2 416 464 416zM272 416C280.8 416 288 408.8 288 400v-288C288 103.2 280.8 96 272 96S256 103.2 256 112v288C256 408.8 263.2 416 272 416zM624 448H608V64h16C632.8 64 640 56.84 640 48S632.8 32 624 32h-608C7.156 32 0 39.16 0 48S7.156 64 16 64H32v384H16C7.156 448 0 455.2 0 464S7.156 480 16 480h608c8.844 0 16-7.156 16-16S632.8 448 624 448zM576 448H64V64h512V448zM176 416C184.8 416 192 408.8 192 400v-288C192 103.2 184.8 96 176 96S160 103.2 160 112v288C160 408.8 167.2 416 176 416z"],
    "conveyor-belt": [640, 512, [], "f46e", "M544 320h-448c-53 0-96 43-96 96s43 96 96 96h448c53 0 96-43 96-96S597 320 544 320zM544 480H96c-35.25 0-64-28.75-64-64s28.75-64 64-64h448c35.25 0 64 28.75 64 64S579.3 480 544 480zM192 288h256c35.35 0 64-28.65 64-64V64c0-35.35-28.65-64-64-64H192C156.7 0 128 28.65 128 64v160C128 259.3 156.7 288 192 288zM272 32h96v70.13l-40.84-20.44c-4.5-2.25-9.812-2.25-14.31 0L272 102.1V32zM160 64c0-17.64 14.36-32 32-32h48v96c0 5.531 2.875 10.69 7.594 13.62c4.656 2.812 10.59 3.156 15.56 .6875L320 113.9l56.84 28.44C379.1 143.4 381.6 144 384 144c2.938 0 5.844-.8125 8.406-2.375C397.1 138.7 400 133.5 400 128V32H448c17.64 0 32 14.36 32 32v160c0 17.64-14.36 32-32 32H192C174.4 256 160 241.6 160 224V64zM128 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 429.3 152 416C152 402.7 141.3 392 128 392zM320 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 402.7 333.3 392 320 392zM512 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C536 402.7 525.3 392 512 392z"],
    "conveyor-belt-boxes": [640, 512, ["conveyor-belt-alt"], "f46f", "M128 288h160c35.35 0 64-28.65 64-64V64c0-35.35-28.65-64-64-64H128C92.65 0 64 28.65 64 64v160C64 259.3 92.65 288 128 288zM96 64c0-17.64 14.36-32 32-32h160c17.64 0 32 14.36 32 32v160c0 17.64-14.36 32-32 32H128C110.4 256 96 241.6 96 224V64zM448 288h64c35.35 0 64-28.65 64-64V128c0-35.35-28.65-64-64-64h-64c-35.35 0-64 28.65-64 64v96C384 259.3 412.7 288 448 288zM416 128c0-17.64 14.36-32 32-32h64c17.64 0 32 14.36 32 32v96c0 17.64-14.36 32-32 32h-64c-17.64 0-32-14.36-32-32V128zM544 320H96c-53 0-96 43-96 96s43 96 96 96h448c53 0 96-43 96-96S597 320 544 320zM544 480H96c-35.25 0-64-28.75-64-64s28.75-64 64-64h448c35.25 0 64 28.75 64 64S579.3 480 544 480zM128 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 429.3 152 416C152 402.7 141.3 392 128 392zM320 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 402.7 333.3 392 320 392zM512 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C536 402.7 525.3 392 512 392z"],
    "conveyor-belt-empty": [640, 512, [], "e150", "M544 320H96c-53 0-96 43-96 96s43 96 96 96h448c53 0 96-43 96-96S597 320 544 320zM544 480H96c-35.25 0-64-28.75-64-64s28.75-64 64-64h448c35.25 0 64 28.75 64 64S579.3 480 544 480zM128 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S152 429.3 152 416C152 402.7 141.3 392 128 392zM320 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C344 402.7 333.3 392 320 392zM512 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C536 402.7 525.3 392 512 392z"],
    "cookie": [512, 512, [62819], "1f36a", "M191.1 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S205.2 328 191.1 328zM183.1 192c0-13.25-10.75-24-24-24s-24 10.75-24 24s10.75 24 24 24S183.1 205.3 183.1 192zM287.1 232c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S301.2 232 287.1 232zM343.1 128c0-13.25-10.75-24-24-24s-24 10.75-24 24s10.75 24 24 24S343.1 141.3 343.1 128zM351.1 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S365.2 328 351.1 328zM494.5 254.8l-11.37-71.48c-4.102-25.9-16.29-49.8-34.8-68.32l-51.33-51.33c-18.51-18.52-42.3-30.7-68.2-34.8L256.9 17.53C250.5 16.47 244 16 237.6 16c-19.45 0-38.67 4.573-56.13 13.48L116.7 62.53c-23.32 11.84-42.3 30.82-54.26 54.14L29.51 181.2C17.56 204.7 13.43 231.2 17.53 257.2l11.37 71.48C32.1 354.6 45.18 378.5 63.7 397.1l51.33 51.33c18.51 18.52 42.3 30.61 68.2 34.72l71.84 11.37C261.5 495.5 267.1 496 274.4 496c19.45 0 38.67-4.573 56.13-13.48l64.8-33.05c23.32-11.84 42.3-30.82 54.26-54.14l32.81-64.57C494.4 307.3 498.6 280.8 494.5 254.8zM453.9 316.3l-32.76 64.47c-8.959 17.48-22.88 31.38-40.32 40.23l-64.81 33.05C303.2 460.5 288.8 464 274.4 464c-4.996 0-9.631-.3613-14.33-1.131l-71.83-11.37c-19.24-3.047-36.73-11.98-50.58-25.83l-51.33-51.33c-13.83-13.83-22.76-31.37-25.83-50.72l-11.36-71.44C46.08 232.8 49.18 213.3 58.12 195.7l32.76-64.47c8.959-17.48 22.88-31.38 40.32-40.23l64.81-33.05C208.8 51.45 223.2 48 237.6 48c4.996 0 9.631 .3613 14.33 1.129l71.83 11.37c19.24 3.047 36.73 11.98 50.58 25.83l51.33 51.33c13.83 13.83 22.76 31.37 25.83 50.72l11.36 71.44C465.9 279.2 462.8 298.7 453.9 316.3z"],
    "cookie-bite": [512, 512, [], "f564", "M184 192c0-13.25-10.75-24-24-24s-24 10.75-24 24s10.75 24 24 24S184 205.3 184 192zM288 232c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S301.3 232 288 232zM192 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S205.3 328 192 328zM352 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S365.3 328 352 328zM494.6 255.9c-65.63-.8203-118.6-54.14-118.6-119.9c-65.74 0-119.1-52.97-119.8-118.6C250 16.47 243.7 16 237.5 16c-19.34 0-38.54 4.573-56 13.48L116.7 62.41C93.35 74.36 74.36 93.35 62.41 116.7L29.6 181.2C17.64 204.7 13.42 231.2 17.53 257.2l11.37 71.48c4.102 25.9 16.29 49.8 34.81 68.32l51.36 51.39c18.52 18.4 42.27 30.64 68.18 34.75l71.84 11.37C261.5 495.5 268 496 274.5 496c19.34 0 38.71-4.573 56.17-13.48l64.81-33.05c23.32-11.84 42.31-30.82 54.14-54.14l32.93-64.57C494.3 307.7 498.5 281.4 494.6 255.9zM454 316.2l-32.96 64.63c-8.703 17.15-22.94 31.38-40.14 40.12l-64.81 33.05C303.3 460.5 288.9 464 274.5 464c-5.004 0-9.811-.3711-14.45-1.131l-71.83-11.37c-19.23-3.045-36.75-11.96-50.56-25.68l-51.36-51.47c-13.83-13.83-22.76-31.36-25.83-50.72l-11.36-71.44C46.08 232.8 49.18 213.3 58.12 195.7l32.76-64.47C99.84 113.8 113.8 99.83 131.2 90.93l64.85-32.95c9.895-5.047 20.71-8.256 31.72-9.453c12.9 58.74 60.05 104.1 119.1 116.6c11.65 59 57.88 106.2 116.6 119.2C462.2 295.4 459.1 306.3 454 316.2z"],
    "copy": [512, 512, [], "f0c5", "M272 416C263.2 416 256 423.2 256 432V448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V192c0-17.67 14.33-32 32-32h112C184.8 160 192 152.8 192 144C192 135.2 184.8 128 176 128H63.99c-35.35 0-64 28.65-64 64l.0098 256C0 483.3 28.65 512 64 512h160c35.35 0 64-28.65 64-64v-16C288 423.2 280.8 416 272 416zM502.6 86.63l-77.25-77.25C419.4 3.371 411.2 0 402.7 0H288C252.7 0 224 28.65 224 64v256c0 35.35 28.65 64 64 64h160c35.35 0 64-28.65 64-64V109.3C512 100.8 508.6 92.63 502.6 86.63zM416 45.25L466.7 96H416V45.25zM480 320c0 17.67-14.33 32-32 32h-160c-17.67 0-32-14.33-32-32V64c0-17.67 14.33-32 32-32h96l.0026 64c0 17.67 14.33 32 32 32H480V320z"],
    "copyright": [512, 512, [61945], "a9", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM323.9 188.1c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62c-48.31-48.38-132.7-48.38-181 0C141.3 189.7 128 221.8 128 256s13.31 66.34 37.5 90.5C189.7 370.7 221.8 384 256 384s66.34-13.31 90.5-37.5c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0c-36.25 36.25-99.5 36.25-135.8 0C169.1 305.8 160 281.7 160 256s9.1-49.75 28.12-67.88C224.4 151.9 287.6 151.9 323.9 188.1z"],
    "corn": [512, 512, [63175], "1f33d", "M446 0c-12.88 0-25.25 3.75-35.63 10.62c-15.38-4.123-28.13-1.498-34.88 .5c-10.38 3-19.88 8.375-27.63 15.88c-6.25-.375-17.62-.375-30.5 5.125c-10 4.5-18.5 11.12-25 19.25c-10.5 .5-20.75 3.625-29.75 9C254.4 64.96 247.5 71.64 242.1 79.28c8.021 11.7 14.73 23.34 20.2 34.82c.0234 .0098-.0234-.0078 0 0c.875-10.5 6.801-20.61 16.68-26.24c15.88-9.373 30.88-1.498 31.38-1.373c1.875-10.38 8.752-20.12 19.5-24.88c13.5-5.75 25.5-1.375 31.62 2.625c3.252-10.62 11.75-19.25 23-22.5c3-.875 18.62-5 32.13 8.123C422.4 38.1 433.5 31.1 446 31.1c.5 0 33.88-1 33.88 37.87c-.5 12.88-8 23.62-18.5 28.1c7.5 8.25 11 20.38 7.5 32.12c-3.5 11.25-12.38 19.5-22.75 22.75c5.875 9.125 7.25 20.87 2.375 31.62c-4.75 10.75-14.38 17.38-25.12 19.25c4.875 9.625 4.5 21.5-1.375 31.38c-4.5 7.898-11.92 13.09-20.19 15.36c10.52 5.207 21.08 11.43 31.7 18.79c6.52-5.135 12.24-11.16 16.37-18.4c5.25-8.873 8.252-18.75 8.877-28.87c8-6.375 14.62-14.75 19-24.37c4.375-9.875 6.25-20.62 5.625-31c7.375-7.623 13-16.87 16.12-26.1c3.252-11.25 3.502-23.12 .75-34.5C528.3 65.25 504.6 0 446 0zM446.9 322.5c-69.92-70.92-158.4-66.87-161.3-66.87c-10.75 0-21.38 1.125-31.88 2.5c1.5-10.5 2.5-20.1 2.5-31.87c0-2.887 4.672-89.69-66.75-161.1L168.4 43.1c-9-9.125-24.5-4.375-27 8.123L117.6 170.9L36.99 251.5c-20 20.12-34 46.12-36.5 74.5c-3.125 34.87 9 68.25 33.5 92.62L96.11 480.8l.375-.25c27.38 25.5 64.75 36.87 103.3 28.88c22.88-4.75 43.5-17.25 60-33.75l81.25-81.37l118.9-23.75c12.5-2.5 17.12-17.1 8.125-26.1L446.9 322.5zM56.61 277.2l90.5-90.5l19.75-98.99c48.38 48.25 65.38 115.4 52.5 177.6c-35.5 10.75-68 30.12-94.88 57.12l-70.5 70.37C24.11 359.9 24.73 308.1 56.61 277.2zM325.2 364.9l-90.5 90.5c-16.38 16.38-37.88 24.62-59.38 24.62c-21.5 0-43-8.248-59.38-24.62l-39.63-39.62l70.75-70.62c38.25-38.25 88.38-57.5 138.5-57.5s100.4 19.25 138.6 57.5L325.2 364.9z"],
    "corner": [448, 512, [], "ac", "M432 384c-8.844 0-16-7.156-16-16V192H16C7.156 192 0 184.8 0 176S7.156 160 16 160h416C440.8 160 448 167.2 448 176v192C448 376.8 440.8 384 432 384z"],
    "couch": [640, 512, [], "f4b8", "M576 224c-35.35 0-64 28.65-64 64h-384c0-35.35-28.65-64-64-64s-64 28.65-64 64v160c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32h384c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V288C640 252.7 611.3 224 576 224zM96 448H32V288c0-17.64 14.36-32 32-32s32 14.36 32 32V448zM511.1 416h-384L128 320h384L511.1 416zM608 448h-64V288c0-17.64 14.36-32 32-32s32 14.36 32 32V448zM80 192C88.84 192 96 184.8 96 176v-32C96 99.88 131.9 64 176 64h288C508.1 64 544 99.88 544 144v32C544 184.8 551.2 192 560 192S576 184.8 576 176v-32C576 82.25 525.8 32 464 32h-288C114.3 32 64 82.25 64 144v32C64 184.8 71.16 192 80 192z"],
    "cow": [640, 512, [63176], "1f404", "M633.1 279.6L624 265.5V210.6c0-19.38-15.75-35.12-35.13-35.12c-9 0-14.25 2.875-23.62 7.625l-56.5-79.42C490.6 78.83 461.8 64 431 64H112C67.88 64 32 99.88 32 144v88.88C13 244 0 264.4 0 288v32c35.38 0 64-28.62 64-64V144c0-23.88 17.62-43.62 40.5-47.25C99.25 106 96 116.6 96 128L96 416c0 17.62 14.38 32 32 32h48C193.6 448 208 433.6 208 416v-51.63c7.25 3 15.62 5 24 6.875L232.1 392c0 8.875 7.25 16 16 16c8.875 0 16-7.125 16-16L264 375.2C266.8 375.4 269.2 376 272 376s5.25-.625 8-.75L280.1 392c0 8.875 7.25 16 16 16c8.875 0 16-7.125 16-16L312 371.2c8.375-1.875 16.75-3.875 24-6.875V416c0 17.62 14.38 32 32 32h48C433.6 448 448 433.6 448 416V272L480 288L480 330c0 12.25 3.5 24.38 10.25 34.75l35.38 54.87C537.1 437.2 556.8 448 577.8 448C612.1 448 640 420.2 640 385.9V298.2C640 291.6 637.9 285.1 633.1 279.6zM212.8 96h118.5c17.5 0 27.13 19.75 15.88 32.75C307 175.2 289.2 176 272 176H271c-17.25 0-33.88-.375-74.12-47.25C185.6 115.8 195.2 96 212.8 96zM208.6 330.2C211.6 297.6 238.8 272 272 272s60.38 25.62 63.38 58.25C321.2 335.9 277.1 357.9 208.6 330.2zM608 385.9C608 402.5 594.5 416 577.8 416c-10.25 0-19.62-5.125-25.25-13.75l-35.38-54.87C513.8 342.2 512 336.2 512 329.1v-51.84c0-6.06-3.424-11.6-8.845-14.31l-64-31.1C428.5 226.5 416 234.2 416 246.1V416h-48v-80c0-30.88-25.5-96-96-96c-70.88 0-95.1 64.5-95.1 96L176 416H128V128c0-17.62 14.38-32 32-32h4.25C156.6 114.1 159.6 134.6 172.6 149.8C214.9 198.8 239.8 208 271 208c32.88 0 58.13-9.25 100.4-58.25c13-15.13 16-35.63 8.375-53.75H431c20.38 0 39.75 9.875 51.63 26.25l78.63 110.4C565.8 215.5 580.3 208 584 208c4.25 0 8 3.375 8 8.125v59.63L608 298.2V385.9zM568 304c-8.875 0-16 7.125-16 16s7.125 16 16 16s16-7.125 16-16S576.9 304 568 304z"],
    "cowbell": [448, 512, [], "f8b3", "M447.3 456.1l-53.34-320C390.1 112.9 370.2 96 346.6 96h-26.65l.0011-48c0-26.47-21.53-48-48-48H176.1C149.7 0 128.1 21.53 128.1 48L128.1 96H101.3C77.77 96 57.87 112.9 54.01 136.1l-53.34 320C-4.211 485.3 18.31 512 48.02 512h351.9C429.4 512 452.3 485.6 447.3 456.1zM160 48c0-8.812 7.168-16 15.1-16h96c8.828 0 16.01 7.188 16.01 16V96H160V48zM399.1 480H48.02c-12.59 0-16.92-11.82-15.79-18.62l53.34-320C86.85 133.6 93.49 128 101.3 128h245.3c7.859 0 14.5 5.625 15.78 13.38l53.34 320C416.9 468.2 412.7 480 399.1 480z"],
    "cowbell-circle-plus": [576, 512, ["cowbell-more"], "f8b4", "M432 224C352.5 224 288 288.5 288 368s64.46 144 144 144C511.5 512 576 447.5 576 368S511.5 224 432 224zM432 480C370.2 480 320 429.8 320 368S370.2 256 432 256C493.8 256 544 306.2 544 368S493.8 480 432 480zM496 352H448V304C448 295.2 440.8 288 432 288S416 295.2 416 304V352h-48c-8.836 0-15.1 7.164-15.1 16S359.2 384 368 384H416v48c0 8.836 7.165 16 16 16S448 440.8 448 432V384h48c8.836 0 16-7.164 16-16S504.8 352 496 352zM288 480H48.02c-12.59 0-16.92-11.82-15.79-18.62l53.34-320C86.85 133.6 93.49 128 101.3 128h245.3c7.82 0 14.49 5.652 15.78 13.37l6.213 37.27C369.9 186.3 376.6 192 384.4 192c9.885 0 17.4-8.877 15.78-18.63l-6.213-37.27C390.1 112.1 370.1 96 346.6 96h-26.65L320 48C320 21.49 298.5 0 272 0H176.1c-26.51 0-48 21.49-48 48L128.1 96h-26.72C77.77 96 57.87 112.9 54.01 136.1l-53.34 320C-4.211 485.3 18.31 512 48.02 512h239.1C296.8 512 304 504.8 304 496S296.8 480 288 480zM160 48C160 39.19 167.2 32 176 32h96c8.828 0 16.01 7.188 16.01 16V96H160V48z"],
    "crate-apple": [512, 512, ["apple-crate"], "f6b1", "M336.4 126.4l15.58 8.703l15.63-8.701c54.78-30.58 67.04-3.746 67.66-2.871C446.8 140.4 449.8 171.4 446.2 192h32.15C488.6 121.3 449.7 43.84 352 98.39c-24.04-13.42-44.48-18.79-61.55-18.29c8.387 9.725 14.44 21.88 19.34 34.9C317.4 117.2 325.9 120.5 336.4 126.4zM432 287.1c-8.875 0-16 7.123-16 15.1s7.125 16 16 16S448 312.9 448 303.1S440.9 287.1 432 287.1zM65.82 192C62.16 171.4 65.17 140.4 76.73 123.5c.625-.873 12.88-27.7 67.66 2.871l15.58 8.703l15.63-8.701c54.78-30.58 67.04-3.746 67.66-2.871C254.8 140.4 257.8 171.4 254.2 192l32.11 .0003C296.6 121.3 257.7 43.75 160 98.3C62.29 43.75 23.43 121.3 33.71 192L65.82 192zM368 64c4.094 0 8.188-1.562 11.31-4.688l32-32c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-32 32c-6.25 6.25-6.25 16.38 0 22.62C359.8 62.44 363.9 64 368 64zM176 64c4.094 0 8.188-1.562 11.31-4.688l32-32c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-32 32c-6.25 6.25-6.25 16.38 0 22.62C167.8 62.44 171.9 64 176 64zM80 287.1c-8.875 0-16 7.125-16 16s7.125 15.1 16 15.1S96 312.9 96 303.1S88.88 287.1 80 287.1zM432 447.1c8.875 0 16-7.125 16-16s-7.125-16-16-16S416 423.1 416 431.1S423.1 447.1 432 447.1zM472 224H40C17.91 224 0 241.9 0 264v208C0 494.1 17.91 512 40 512h432c22.09 0 40-17.91 40-40v-208C512 241.9 494.1 224 472 224zM480 464c0 8.836-7.164 16-16 16h-416C39.16 480 32 472.8 32 464V384h448V464zM480 352H32V272C32 263.2 39.16 256 48 256h416C472.8 256 480 263.2 480 272V352zM80 447.1c8.875 0 16-7.126 16-16s-7.125-16-16-16S64 423.1 64 431.1S71.13 447.1 80 447.1z"],
    "crate-empty": [512, 512, [], "e151", "M432 287.1c-8.875 0-16 7.123-16 15.1s7.125 16 16 16S448 312.9 448 303.1S440.9 287.1 432 287.1zM80 287.1c-8.875 0-16 7.125-16 16s7.125 15.1 16 15.1S96 312.9 96 303.1S88.88 287.1 80 287.1zM432 447.1c8.875 0 16-7.125 16-16s-7.125-16-16-16S416 423.1 416 431.1S423.1 447.1 432 447.1zM472 224H40C17.91 224 0 241.9 0 264v208C0 494.1 17.91 512 40 512h432c22.09 0 40-17.91 40-40v-208C512 241.9 494.1 224 472 224zM480 464c0 8.836-7.164 16-16 16h-416C39.16 480 32 472.8 32 464V384h448V464zM480 352H32V272C32 263.2 39.16 256 48 256h416C472.8 256 480 263.2 480 272V352zM80 447.1c8.875 0 16-7.126 16-16s-7.125-16-16-16S64 423.1 64 431.1S71.13 447.1 80 447.1z"],
    "credit-card": [576, 512, [61597, 62083, "credit-card-alt"], "1f4b3", "M240 384h128c8.836 0 16-7.164 16-16c0-8.838-7.164-16-16-16h-128C231.2 352 224 359.2 224 368C224 376.8 231.2 384 240 384zM112 384h64C184.8 384 192 376.8 192 368C192 359.2 184.8 352 176 352h-64C103.2 352 96 359.2 96 368C96 376.8 103.2 384 112 384zM512 32h-448c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V256h512V416zM544 224H32V160h512V224zM544 128H32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V128z"],
    "credit-card-blank": [576, 512, [], "f389", "M176 352h-64C103.2 352 96 359.2 96 368C96 376.8 103.2 384 112 384h64C184.8 384 192 376.8 192 368C192 359.2 184.8 352 176 352zM512 32h-448c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V416zM368 352h-128C231.2 352 224 359.2 224 368C224 376.8 231.2 384 240 384h128c8.836 0 16-7.164 16-16C384 359.2 376.8 352 368 352z"],
    "credit-card-front": [576, 512, [], "f38a", "M176 352h-64C103.2 352 96 359.2 96 368C96 376.8 103.2 384 112 384h64C184.8 384 192 376.8 192 368C192 359.2 184.8 352 176 352zM176 288h-64C103.2 288 96 295.2 96 304C96 312.8 103.2 320 112 320h63.1c8.836 0 16-7.164 16-16C191.1 295.2 184.8 288 176 288zM368 352h-128C231.2 352 224 359.2 224 368C224 376.8 231.2 384 240 384h128c8.836 0 16-7.164 16-16C384 359.2 376.8 352 368 352zM512 32h-448c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM544 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V416zM496 96h-128C359.2 96 352 103.2 352 112v96C352 216.8 359.2 224 368 224h128C504.8 224 512 216.8 512 208v-96C512 103.2 504.8 96 496 96zM480 192h-96V128h96V192zM464 288h-32C423.2 288 416 295.2 416 304c0 8.836 7.164 16 16 16h32c8.836 0 16-7.164 16-16C480 295.2 472.8 288 464 288zM368 288h-128C231.2 288 223.1 295.2 223.1 304C223.1 312.8 231.2 320 240 320h128c8.836 0 16-7.164 16-16C384 295.2 376.8 288 368 288z"],
    "cricket-bat-ball": [512, 512, [62537, "cricket"], "1f3cf", "M416 236.5c0-12.35-4.711-24.7-14.13-34.12l-34.82-34.83l140.3-140.3C510.4 24.18 512 20.09 512 16C512 7.473 505.1 0 496 0c-4.094 0-8.185 1.561-11.31 4.686l-140.3 140.3L309.6 110.2c-9.439-9.441-21.81-14.17-34.17-14.17c-12.34 0-24.67 4.705-34.09 14.12c-246.7 246.7-241.4 235.5-241.4 256.7C-.0004 473.9 112.2 512 145.1 512c9.84 0 19.59-4.166 27.13-11.71l229.7-229.6C411.3 261.2 416 248.9 416 236.5zM149.6 477.7c-1.627 1.627-3.252 2.273-3.252 2.369c0 .0059-.0126-.0019 0 0c-41.13-2.845-114.3-40.23-114.3-113.2c0-1.085 .7056-2.82 2.32-4.438L192 204.7V288c0 17.67 14.33 32 32 32h83.25L149.6 477.7zM379.2 248L339.3 288L224 287.1L224 172.7l40-39.99c3.062-3.064 7.135-4.752 11.46-4.752c4.354 0 8.453 1.703 11.54 4.793l92.23 92.24C383.4 229.2 384 234 384 236.5C384 240.9 382.3 244.9 379.2 248zM431.1 352c-44.25 0-80 35.75-80 79.1S387.7 512 431.1 512c44.25 0 80-35.75 80-79.1S476.2 352 431.1 352zM431.1 480c-26.47 0-48-21.53-48-48s21.53-48 48-48s48 21.53 48 48S458.4 480 431.1 480z"],
    "croissant": [512, 512, [63478], "1f950", "M508.1 175.6c-11.5-30.25-29.88-56.49-52.38-78.12c.375-3.999 .25-8.124-.25-12.12c-2.125-15.87-10.38-30.37-23.13-40.12c-38.63-29.25-85.63-45.12-134-45.24c-19.75 .125-39.38 2.1-58.25 8.374C229.9 2.656 215.2-2.968 196.2 1.781c-95.88 23.87-170.6 98.61-194.5 194.4c-3.75 15.37-1.375 31.5 6.625 44.99c-17.75 65.62-5.125 135.1 36.88 191.1c9.75 12.75 24.25 21.12 40.13 23.25c9.125 1.125 9.125 0 11.38-.25c21.75 22.75 48.25 41.24 78.88 52.87c42.5 16.12 87-19.1 79.5-65.24l-14.5-87.24c8.875-8.374 15-19.37 17.5-31.37c9.875-2.625 19-7.874 26.25-15.12l24.75-24.75c7.25-7.374 12.5-16.37 15.25-26.37c12-2.375 22.88-8.499 31.25-17.37l87.25 14.5C488.4 262.7 524.1 218 508.1 175.6zM298.4 32.03c41.38 .125 81.63 13.62 114.6 38.75c13.88 10.62 13.38 28.75 5 39.5l-84 106.1c-1.625 1.1-9.25 9.374-10 6.999l-56-181.1c-.75-2.375-2.25-4.374-3.375-6.749C275.7 33.28 286.1 32.15 298.4 32.03zM35.24 265.1C37.49 266.2 39.86 267.2 42.36 268.1l182 55.99c2.25 .625-5.125 8.374-7.125 9.874l-107 83.99c-14 10.1-31.5 5.374-39.5-4.999C38.61 370.9 25.74 317.2 35.24 265.1zM186.1 478.1c-21-7.999-40.38-19.87-57-34.1l82-64.37l11.63 69.37C226.1 468.1 206.5 485.6 186.1 478.1zM286.5 261.7l-24.75 24.75C257.7 290.5 247.4 297.6 233.7 293.5L51.74 237.5C37.61 233.1 29.24 218.4 32.86 204c21-84.36 86.75-150.2 171.1-171.1C218.4 29.28 233.1 37.65 237.5 51.77l56 181.1C296.5 243.6 293.9 254.4 286.5 261.7zM448.1 223.6l-69.38-11.62l64.38-81.99c15.13 16.62 27 35.1 35 56.99C485.6 206.8 468.9 227 448.1 223.6z"],
    "crop": [512, 512, [], "f125", "M512 400c0 8.844-7.156 16-16 16h-80L416 496c0 8.844-7.156 16-16 16S384 504.8 384 496V150.6L150.6 384H336c8.844 0 16 7.156 16 16S344.8 416 336 416h-224C103.2 416 96 408.8 96 400V128H16C7.156 128 0 120.8 0 112S7.156 96 16 96h79.1L96 16C96 7.156 103.2 0 112 0S128 7.156 128 16v345.4L361.4 128H176C167.2 128 160 120.8 160 112S167.2 96 176 96h217.4l91.31-91.31c6.25-6.25 16.38-6.25 22.62 0s6.25 16.38 0 22.62L416 118.6V384h80C504.8 384 512 391.2 512 400z"],
    "crop-simple": [512, 512, ["crop-alt"], "f565", "M496 384H416V112C416 103.2 408.8 96 400 96h-224C167.2 96 160 103.2 160 112S167.2 128 176 128H384v368c0 8.844 7.156 16 16 16s16-7.156 16-16L415.1 416H496c8.844 0 16-7.156 16-16S504.8 384 496 384zM336 384H128V16C128 7.156 120.8 0 112 0S96 7.156 96 16L95.1 96H16C7.156 96 0 103.2 0 112S7.156 128 16 128H96v272C96 408.8 103.2 416 112 416h224c8.844 0 16-7.156 16-16S344.8 384 336 384z"],
    "cross": [384, 512, [128327, 63060], "271d", "M351.1 128h-96V32c0-17.62-14.37-32-31.1-32H160C142.4 0 127.1 14.38 127.1 32v96h-96C14.37 128-.0008 142.4-.0008 160v64c0 17.62 14.38 32 32 32h96v224c0 17.62 14.38 32 32 32h64c17.62 0 31.1-14.38 31.1-32V256h96c17.62 0 31.1-14.38 31.1-32V160C383.1 142.4 369.6 128 351.1 128zM352 224h-112C231.2 224 224 231.2 224 240V480H160V240C160 231.2 152.8 224 144 224H32V160h112C152.8 160 160 152.8 160 144V32h64v112C224 152.8 231.2 160 240 160H352V224z"],
    "crosshairs": [512, 512, [], "f05b", "M496 240h-32.81C455.4 137.9 374.1 56.6 272 48.81V16C272 7.156 264.8 0 256 0S240 7.156 240 16v32.81C137.9 56.6 56.6 137.9 48.81 240H16C7.156 240 0 247.2 0 256S7.156 272 16 272h32.81C56.6 374.1 137.9 455.4 240 463.2V496c0 8.844 7.156 16 15.1 16S272 504.8 272 496v-32.81C374.1 455.4 455.4 374.1 463.2 272H496C504.8 272 512 264.8 512 256S504.8 240 496 240zM400 272h31.19C423.5 356.3 356.3 423.5 272 431.2V400c0-8.844-7.156-16-16-16s-16 7.156-16 16v31.19C155.7 423.5 88.45 356.3 80.81 272H112C120.8 272 128 264.8 128 256S120.8 240 112 240H80.81C88.45 155.7 155.7 88.45 240 80.81V112C240 120.8 247.2 128 256 128s16-7.156 16-16V80.81C356.3 88.45 423.5 155.7 431.2 240H400C391.2 240 384 247.2 384 256S391.2 272 400 272zM255.1 232c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S269.2 232 255.1 232z"],
    "crow": [640, 512, [], "f520", "M416 72c-13.25 0-24 10.75-24 24S402.8 120 416 120S440 109.3 440 96S429.3 72 416 72zM520 64l-13.87 .0137c-13.64-38.34-50.45-65.57-93.8-63.95C360.3 2.016 320 46.89 320 99v36.63l-308.6 258c-7.125 5.625-11.38 14.64-11.38 24.14C0 435.3 13.5 448 28.5 448c4.125 0 8.5-1 12.62-3.25L168 384h109.5l44.18 117.8c2.986 8.084 11.95 12.23 20.04 9.268c8.127-2.975 12.3-11.99 9.303-20.1L310.9 384h20.38c13.88 0 27.38-1.875 40.38-5l46.06 122.8c2.986 8.082 11.95 12.22 20.04 9.264c8.129-2.977 12.29-11.99 9.293-20.11l-45.78-121.9c65.13-29 110.7-97.37 110.7-176.1L512 161.1L640 144C640 99.88 586.3 64 520 64zM480 192c0 88.25-66.75 160-148.8 160h-57l45.38-13c48-13.62 88.38-47.13 110.6-91.88c4-7.875 .75-17.5-7.125-21.38c-7.875-4-17.5-.875-21.5 7.125C383.4 269.5 350.3 297 310.8 308.3C118.6 363.1 195 335.5 44.13 407.9L352 150.5V96c0-35.25 28.75-64 64-64s64 28.75 64 64V192zM512 128.8l0-32.75L520 96c30.88 0 56.88 9.5 72.5 22L512 128.8z"],
    "crown": [576, 512, [62753], "1f451", "M544 96c-17.67 0-32 14.33-32 32c0 7.559 3.008 14.21 7.391 19.69l-104.5 83.58c-5.955 4.764-12.99 7.019-19.94 7.019c-11.61 0-22.98-6.296-28.68-17.7L302.2 92.33C312.6 87.07 320 76.51 320 64c0-17.67-14.33-32-32-32S256 46.33 256 64c0 12.51 7.367 23.07 17.83 28.33L209.7 220.6C204 231.1 192.6 238.3 181 238.3c-6.945 0-13.98-2.255-19.94-7.019L56.61 147.7C60.99 142.2 64 135.6 64 128c0-17.67-14.33-32-32-32S0 110.3 0 128c0 17.67 14.33 32 32 32c1.99 0 3.721-.7852 5.611-1.133l48.83 268.6C91.98 457.9 118.5 480 149.4 480h277.2c30.93 0 57.43-22.12 62.97-52.55l48.83-268.6C540.3 159.2 542 160 544 160c17.67 0 32-14.33 32-32C576 110.3 561.7 96 544 96zM458.1 421.7C455.3 436.9 442.1 448 426.6 448H149.4c-15.47 0-28.71-11.05-31.48-26.28L78.78 206.4l62.32 49.86c11.31 9.049 25.49 14.03 39.93 14.03c24.43 0 46.39-13.56 57.3-35.39L288 135.6l49.67 99.35c10.91 21.83 32.87 35.39 57.3 35.39c14.44 0 28.62-4.984 39.93-14.03l62.32-49.86L458.1 421.7z"],
    "crutch": [512, 512, [], "f7f7", "M507.3 196.7l-192-192c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l192 192C487.8 222.4 491.9 224 496 224s8.188-1.562 11.31-4.688C513.6 213.1 513.6 202.9 507.3 196.7zM404.7 212.7L336 281.4L230.6 176l68.69-68.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L162.4 199C151.2 210.2 143.7 224.3 140.5 239.9l-27.25 136.3l-108.6 108.6c-6.25 6.25-6.25 16.37 0 22.62C7.813 510.4 11.91 512 16 512s8.188-1.562 11.31-4.687l108.6-108.6l136.3-27.25c15.56-3.156 29.69-10.72 40.84-21.88l114.3-114.3c6.25-6.25 6.25-16.38 0-22.62S410.9 206.4 404.7 212.7zM290.4 327c-6.688 6.688-15.19 11.25-24.5 13.12l-117.5 23.47l23.47-117.4C173.8 236.8 178.3 228.3 185 221.6L208 198.6L313.4 304L290.4 327z"],
    "crutches": [640, 512, [], "f7f8", "M224 16C224 6.861 216.5 0 208 0C203.9 0 199.8 1.562 196.7 4.688l-192 192C1.562 199.8 0 203.9 0 208C0 217.1 7.473 224 16 224c4.094 0 8.188-1.562 11.31-4.688l192-192C222.4 24.19 224 20.09 224 16zM224 80C214.9 80 208 87.47 208 96c0 4.094 1.562 8.188 4.688 11.31l48 48C263.8 158.4 267.9 160 272 160C281.1 160 288 152.5 288 144c0-4.094-1.562-8.188-4.688-11.31l-48-48C232.2 81.56 228.1 80 224 80zM208 352C217.1 352 224 344.5 224 336c0-4.094-1.562-8.188-4.688-11.31l-112-112C104.2 209.6 100.1 208 96 208C86.86 208 80 215.5 80 224c0 4.094 1.562 8.188 4.688 11.31l112 112C199.8 350.4 203.9 352 208 352zM427.3 404.7C424.2 401.6 420.1 400 416 400c-9.139 0-16 7.473-16 16c0 4.094 1.562 8.188 4.688 11.31l79.1 80C487.8 510.4 491.9 512 496 512c9.139 0 16-7.473 16-16c0-4.094-1.563-8.187-4.688-11.31L427.3 404.7zM640 208c0-4.094-1.562-8.188-4.688-11.31l-192-192C440.2 1.562 436.1 0 432 0C422.9 0 416 7.473 416 16c0 4.094 1.562 8.188 4.688 11.31l192 192C615.8 222.4 619.9 224 624 224C633.1 224 640 216.5 640 208zM544 208c-4.094 0-8.188 1.562-11.31 4.688L464 281.4L358.6 176l68.69-68.69C430.4 104.2 432 100.1 432 96c0-9.139-7.473-16-16-16c-4.094 0-8.188 1.562-11.31 4.688L290.4 199C279.2 210.2 271.7 224.3 268.5 239.9l-27.25 136.3L132.7 484.7C129.6 487.8 128 491.9 128 496C128 505.1 135.5 512 144 512c4.094 0 8.184-1.562 11.31-4.687l108.6-108.6l136.3-27.25c15.56-3.156 29.69-10.72 40.84-21.88l114.3-114.3C558.4 232.2 560 228.1 560 224C560 214.9 552.5 208 544 208zM418.4 327c-6.688 6.688-15.19 11.25-24.5 13.12l-117.5 23.47l23.47-117.4C301.8 236.8 306.3 228.3 313 221.6L336 198.6L441.4 304L418.4 327z"],
    "cruzeiro-sign": [384, 512, [], "e152", "M379.2 391.7c6.283 6.219 6.346 16.34 .125 22.62C337.4 456.7 281.5 480 222.1 480c0 0 .0313 0 0 0c-59.36 0-115.2-23.33-157.2-65.66c-86.56-87.31-86.56-229.4 0-316.7c41.98-42.33 97.82-65.66 157.2-65.66c59.43-.0156 115.3 23.31 157.3 65.66c6.221 6.281 6.158 16.41-.125 22.62c-6.252 6.25-16.38 6.156-22.63-.0938c-35.92-36.23-83.69-56.2-134.5-56.19c-50.8 0-98.53 19.95-134.5 56.19c-74.28 74.89-74.28 196.7 0 271.6c20.69 20.87 45.38 36.14 72.24 45.5V240c0-8.844 7.159-16 16.01-16S191.9 231.2 191.9 240v16.4C205.3 246.3 221.9 240 239.1 240c32.23 0 61.18 19.17 73.74 48.86c3.439 8.141-.3751 17.53-8.503 20.97c-8.222 3.375-17.54-.3281-21.01-8.5C276.7 283.5 259.3 272 239.1 272C213.5 272 191.9 293.5 191.9 320v125.4C201.8 446.1 211.9 448 222.1 448c50.8 0 98.57-19.95 134.5-56.19C362.8 385.6 372.1 385.5 379.2 391.7z"],
    "crystal-ball": [448, 512, [], "e362", "M288 304c8.844 0 16-7.156 16-16V240H352c8.844 0 16-7.156 16-16S360.8 208 352 208h-48V160c0-8.844-7.156-16-16-16S272 151.2 272 160v48H224C215.2 208 208 215.2 208 224S215.2 240 224 240h48V288C272 296.8 279.2 304 288 304zM70.01 364.3c6.982-5.447 8.234-15.53 2.756-22.48C46.15 307.8 32.06 266.9 32.06 223.5c0-106.1 86.29-192.4 192.4-192.4c106.1 0 192.4 86.28 192.4 192.4c0 43.39-14.09 84.31-40.71 118.4c-5.479 6.951-4.227 17.03 2.756 22.48c2.881 2.285 6.387 3.383 8.986 3.383c4.76 0 9.455-2.098 12.62-6.168C431.6 321.8 448 274.1 448 223.5C448 99.78 347.3 0 223.6 0C99.82 0 0 99.74 0 223.5c0 50.59 16.44 98.37 47.53 138.1C53.01 368.6 63.09 369.8 70.01 364.3zM144 192C152.8 192 160 184.8 160 176V160h16C184.8 160 192 152.8 192 144S184.8 128 176 128H160V112C160 103.2 152.8 96 144 96S128 103.2 128 112V128H112C103.2 128 96 135.2 96 144S103.2 160 112 160H128v16C128 184.8 135.2 192 144 192zM374 390.9c-3.006-4.414-8.016-7.105-13.34-7.105H88.17c-5.354 0-10.36 2.691-13.34 7.137l-64.13 96.18c-3.289 4.916-3.602 11.24-.7832 16.47C12.71 508.8 18.13 512 24.05 512h400.8c5.918 0 11.33-3.256 14.12-8.453c2.818-5.229 2.504-11.55-.7832-16.47L374 390.9zM54.01 479.9l42.74-64.12h255.4l42.74 64.12H54.01z"],
    "cube": [512, 512, [], "f1b2", "M491.2 85.31l-212.8-81.17C271.2 1.383 263.6 0 256 0S240.8 1.383 233.5 4.145l-212.8 81.17C8.273 90.08 0 102.2 0 115.8v280.4c0 13.57 8.273 25.72 20.76 30.48l212.8 81.17C240.8 510.6 248.4 512 256 512s15.23-1.383 22.47-4.145l212.8-81.17C503.7 421.9 512 409.8 512 396.2V115.8C512 102.2 503.7 90.08 491.2 85.31zM244.9 34.04C248.5 32.69 252.2 32 256 32s7.514 .6875 11.07 2.043l198.9 76.35L256 190.9L45.44 110.1L244.9 34.04zM32 396.2l.1562-256.9L240 219v257.1L32 396.2zM272 476.1V219l207.1-79.73l-.1562 257.5L272 476.1z"],
    "cubes": [576, 512, [], "f1b3", "M556.2 258.2L440 213V78.04c0-12.82-7.868-24.32-19.81-28.97l-120.6-46.9C295.9 .7252 291.9 0 288 0C284.1 0 280.1 .7252 276.4 2.176L155.8 49.06C143.9 53.71 136 65.23 136 78.06v134.9L19.84 258.2C7.878 262.8 0 274.2 0 287v146.9c0 12.83 7.876 24.35 19.83 28.1l120.9 47.03C144.4 511.3 148.2 512 152 512s7.625-.7032 11.28-2.125L288 461.4l124.8 48.53C416.4 511.3 420.2 512 424 512s7.625-.7032 11.28-2.125l120.9-47.01C568.1 458.2 576 446.7 576 433.9V287C576 274.2 568.1 262.8 556.2 258.2zM152 241.1l92.45 35.48L152 312.6l-91.84-35.72L152 241.1zM168 340.7L272 300.2v133l-104 40.67V340.7zM304 300.2l104 40.45v133L304 433.3V300.2zM424 312.6l-91.84-35.72L424 241.1l92.45 35.48L424 312.6zM408.5 212.8L304 253.5v-121.9l104.1-40.47L408.5 212.8zM288 32.01l92.45 35.48L288 103.4L196.2 67.72L288 32.01zM272 131.6v121.9L167.1 212.1L167.5 90.91L272 131.6zM31.48 300L136 340.7v133.1L32 433.9L31.48 300zM440 473.9v-133.2l104.1-40.47l.5117 132.8L440 473.9z"],
    "cup-straw": [384, 512, [], "e363", "M367.1 127.1L212.5 128l23.1-96h35.49c8.799 0 16.04-7.199 16.04-16S280.8 0 271.1 0l-35.5-.0003c-14.75 0-27.53 10-31.03 24.25L179.5 128L15.1 127.1C7.201 127.1 0 135.2 0 143.1C0 152.8 7.199 160 15.1 160h16.24c0 .5195-.209 .9883-.1582 1.516l29.23 307C63.69 493.3 84.23 512 109.1 512h165.8c24.86 0 45.41-18.67 47.78-43.45l29.23-307C351.1 160.1 351.8 160.5 351.8 160h16.19c8.799 0 16.03-7.201 16.03-16C383.1 135.2 376.8 127.1 367.1 127.1zM290.8 465.5C290 473.8 283.2 480 274.9 480H109.1c-8.281 0-15.14-6.234-15.94-14.48L64.07 160h255.9L290.8 465.5z"],
    "cup-straw-swoosh": [384, 512, [], "e364", "M367.1 127.1L212.5 128l23.1-96h35.49c8.799 0 16.04-7.199 16.04-16S280.8 0 271.1 0l-35.5-.0003c-14.75 0-27.53 10-31.03 24.25L179.5 128L15.1 127.1C7.201 127.1 0 135.2 0 143.1C0 152.8 7.199 160 15.1 160h16.24c0 .5195-.209 .9883-.1582 1.516l29.23 307C63.69 493.3 84.23 512 109.1 512h165.8c24.86 0 45.41-18.67 47.78-43.45l29.23-307C351.1 160.1 351.8 160.5 351.8 160h16.19c8.799 0 16.03-7.201 16.03-16C383.1 135.2 376.8 127.1 367.1 127.1zM319.9 160l-7.641 80.24c-46.95 1.242-92.38 26.53-125.1 70.17C159.3 347.5 122.7 368 84.13 368L64.07 160H319.9zM290.8 465.5C290 473.8 283.2 480 274.9 480H109.1c-8.281 0-15.14-6.234-15.94-14.48l-6.256-65.7c47.23-.9668 92.1-26.34 125.9-70.22c26.25-34.99 60.29-54.94 96.43-57.15L290.8 465.5z"],
    "cup-togo": [448, 512, ["coffee-togo"], "f6c5", "M432 96h-17.79l-21.08-63.22C386.6 13.19 368.3 0 347.6 0H100.4C79.72 0 61.44 13.19 54.84 32.81L33.79 96H16C7.156 96 0 103.2 0 112S7.156 128 16 128h416C440.8 128 448 120.8 448 112S440.8 96 432 96zM67.54 96l17.65-53.03C87.41 36.41 93.5 32 100.4 32h247.2c6.906 0 13 4.406 15.19 10.94L380.5 96H67.54zM385.6 160.1c-8.625-1.156-16.62 5.531-17.5 14.31L363.1 224H84.87L79.91 174.4C79.03 165.6 71 158.9 62.41 160.1c-8.781 .875-15.22 8.719-14.31 17.5l29.12 291.2C79.66 493.4 100.2 512 124.1 512h198.1c24.78 0 45.31-18.59 47.75-43.22l29.12-291.2C400.8 168.8 394.4 160.1 385.6 160.1zM338.1 465.6C338.1 473.8 331.3 480 323 480H124.1c-8.25 0-15.09-6.188-15.94-14.41L104.1 416h239.9L338.1 465.6zM347.1 384H100.9L88.07 256h271.9L347.1 384z"],
    "curling-stone": [576, 512, [62538, "curling"], "1f94c", "M480 224V208C480 181.5 458.5 160 432 160H191.1L192 112C192 85.53 213.5 64 240 64h160C408.8 64 416 56.84 416 48S408.8 32 400 32h-160C195.9 32 160 67.88 160 112V160H144C117.5 160 96 181.5 96 208L95.1 224c-53.02 0-96 42.98-96 96v64c0 53.02 42.98 96 96 96h384c53.02 0 96-42.98 96-96v-64C576 266.1 533 224 480 224zM128 208C128 199.2 135.2 192 144 192h288C440.8 192 448 199.2 448 208V224H128V208zM96 256h384c35.29 0 64 28.71 64 64v16H32V320C32 284.7 60.71 256 96 256zM480 448H96c-35.29 0-64-28.71-64-64v-16h512V384C544 419.3 515.3 448 480 448z"],
    "d": [384, 512, [100], "44", "M160 480L16 480C7.156 480 0 472.8 0 464v-416C0 39.16 7.156 32 16 32L160 32.01c123.5 0 224 100.5 224 223.1S283.5 480 160 480zM32 448h128c105.9 0 192-86.13 192-192s-86.13-192-192-192H32V448z"],
    "dagger": [384, 512, [], "f6cb", "M320 128h-112V16C208 7.156 200.8 0 192 0S176 7.156 176 16V128H64C28.7 128 0 156.7 0 192L0 208C0 216.8 7.156 224 16 224S32 216.8 32 208V192c0-17.66 14.36-32 32-32h48v240c0 3.156 .9375 6.25 2.688 8.875l64.04 96C181.7 509.3 186.7 512 191.1 512s10.39-2.688 13.35-7.125l63.96-96C271.1 406.3 272 403.2 272 400V160H320c17.64 0 32 14.34 32 32v16C352 216.8 359.2 224 368 224S384 216.8 384 208L383.1 192C383.1 156.7 355.3 128 320 128zM240 395.2l-48 72l-48-72V160h96V395.2z"],
    "dash": [512, 512, [], "2014", "M512 256c0 8.832-7.166 16-16 16h-480C7.166 272 0 264.8 0 256c0-8.834 7.166-16 16-16h480C504.8 240 512 247.2 512 256z"],
    "database": [448, 512, [], "f1c0", "M224 0c-123.7 0-224 35.82-224 80v352c0 44.18 100.3 80 224 80s224-35.82 224-80v-352C448 35.82 347.7 0 224 0zM224 32c123 0 188.1 35.2 192 48l.0156 80.08C364.9 180.2 296.8 192 224 192C151.2 192 83.1 180.2 31.95 160.1L31.94 80.57C35.91 67.2 100.1 32 224 32zM416 193.5l.0234 126.6C364.9 340.2 296.8 352 224 352c-72.81 0-140.9-11.84-192-31.93L31.96 193.4C85.68 212.5 152.7 224 223.1 224C295.3 224 362.3 212.5 416 193.5zM224 480c-123 0-188.1-35.2-192-48l-.0137-78.55C85.7 372.5 152.7 384 223.1 384c71.31 0 138.3-11.48 192.1-30.56l.0137 77.98C412.1 444.8 347 480 224 480z"],
    "deer": [512, 512, [63374], "1f98c", "M399.1 159.1C391.2 159.1 384 167.3 384 176S391.3 192 400 192s15.1-7.25 15.1-16S408.7 159.1 399.1 159.1zM488.8 133.2l-92-25.75l11.12-5.624c12.5-6.321 23.16-15.76 30.94-27.41l13.57-20.31C457.3 46.83 455.3 36.91 448 32c-7.371-4.949-17.36-2.945-22.26 4.463l-13.34 20.12c-4.719 7.117-11.17 12.85-18.8 16.68L351 94.63l-33.75-9.5l8.266-10.39C332.3 66.22 336 55.63 336 44.75V16C336 7.199 328.8 0 320 0s-15.94 7.197-15.94 15.1L304 44.75c0 3.633-1.234 7.159-3.5 9.1l-16.75 21l-16.12-4.498c-6.958-1.942-11.76-8.278-11.76-15.5L256 15.1C256 7.197 248.7 0 239.9 0s-16 7.199-16 16v39.75c0 21.51 14.3 40.41 35 46.25l78.88 22.25L304 192H96C42.98 192 0 234.1 0 288c0 17.67 14.33 32 31.1 32L32 347.6l-11.88 31.75c-4.625 12.25-5.375 25.5-2.25 38l19.44 61.2C43.64 498.5 62.15 512 83.06 512h15.68c31.19 0 54.1-29.29 46.59-59.56l-12.08-48.69L152.6 352H256v112c0 26.51 21.49 47.1 47.1 47.1L336 512c26.51 0 48-21.49 48-48V320l32-64h48C490.5 256 512 234.5 512 208V164.1C512 149.7 502.4 137.2 488.8 133.2zM480.1 208c0 8.75-7.375 16-16.12 16h-67.75L352 312.4V464c0 8.836-7.164 16-16 16h-32c-8.836 0-16-7.221-16-16.06V320H130.4l-30.62 81.75l12.51 56.82C116 468.1 108.3 480 97.21 480H83.08c-6.971 0-13.14-4.514-15.25-11.16l-19.08-60.09c-1.375-6-.875-12.25 1.375-18.12l14-37.25V288H32c0-35.25 28.75-64 64-64h227.8l33.75-67.38c6.869-13.71 22.5-20.63 37.27-16.49l73.6 20.62c6.951 1.947 11.76 8.283 11.76 15.5V208z"],
    "deer-rudolph": [576, 512, [], "f78f", "M431.1 159.1C423.2 159.1 416 167.2 416 175.1S423.3 192 432 192s15.1-7.25 15.1-16S440.7 159.1 431.1 159.1zM544 96c-17.67 0-32 14.33-32 32c0 1.053 .5127 1.957 .6123 2.984l-83.86-23.48l11.12-5.624c12.5-6.32 23.16-15.76 30.94-27.41l13.57-20.31C489.3 46.83 487.3 36.91 480 32c-7.371-4.949-17.36-2.945-22.26 4.463l-13.34 20.12c-4.719 7.117-11.17 12.85-18.8 16.68L383 94.63l-33.75-9.5l8.266-10.39C364.3 66.22 368 55.63 368 44.75V16C368 7.199 360.8 0 352 0s-16 7.199-16 16v28.75c0 3.633-1.234 7.16-3.5 9.999l-16.75 21l-16.12-4.498c-6.959-1.941-11.76-8.277-11.76-15.5V16c0-8.801-7.199-16-16-16s-16 7.199-16 16v39.75c0 21.51 14.3 40.41 35 46.25l78.88 22.25L336 192H128C74.98 192 32 234.1 32 288c0 17.67 14.33 32 32 32v27.56l-11.88 31.75c-4.625 12.25-5.375 25.5-2.25 38l19.44 61.2C75.64 498.5 94.15 512 115.1 512h15.68c31.2 0 54.1-29.29 46.59-59.56l-12.08-48.69L184.6 352H288v112c0 26.51 21.49 47.1 47.1 47.1L368 512c26.51 0 48-21.49 48-48V320l32-64h48C522.5 256 544 234.5 544 208V164.1c0-1.486-.4863-2.817-.6855-4.255C543.6 159.9 543.7 160 544 160c17.67 0 32-14.33 32-32C576 110.3 561.7 96 544 96zM512.1 208c0 8.75-7.375 16-16.12 16h-67.75L384 312.4V464c0 8.836-7.164 16-16 16h-32c-8.836 0-16-7.164-16-16V320H162.4l-30.62 81.75l12.51 56.82C148 468.1 140.3 480 129.2 480H115.1c-6.971 0-13.14-4.514-15.25-11.16l-19.08-60.09c-1.375-6-.875-12.25 1.375-18.12l14-37.25V288H64c0-35.25 28.75-64 64-64h227.8l33.75-67.38c6.869-13.71 22.5-20.63 37.27-16.49l73.6 20.62c6.951 1.947 11.76 8.283 11.76 15.5V208z"],
    "delete-left": [576, 512, [62810, "backspace"], "232b", "M512 64H205.3C188.3 64 172 70.75 160 82.75L9.375 233.4c-12.5 12.5-12.5 32.75 0 45.25L160 429.3C172 441.3 188.3 448 205.3 448H512c35.38 0 64-28.62 64-64V128C576 92.63 547.4 64 512 64zM544 384c0 17.64-14.36 32-32 32H205.3c-8.541 0-16.57-3.33-22.62-9.379L32 256l150.6-150.6C188.7 99.33 196.7 96 205.3 96H512c17.64 0 32 14.36 32 32V384zM427.3 180.7c-6.25-6.25-16.38-6.25-22.62 0L352 233.4l-52.69-52.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L329.4 256L276.7 308.7c-6.25 6.25-6.25 16.38 0 22.62c6.246 6.246 16.37 6.254 22.62 0L352 278.6l52.69 52.69c6.246 6.246 16.37 6.254 22.62 0c6.25-6.25 6.25-16.38 0-22.62L374.6 256l52.69-52.69C433.6 197.1 433.6 186.9 427.3 180.7z"],
    "delete-right": [576, 512, [], "e154", "M0 128v256c0 35.38 28.62 64 64 64h306.8C387.8 448 404 441.3 416 429.3l150.6-150.6c12.5-12.5 12.5-32.75 0-45.25L416 82.75C404 70.75 387.8 64 370.8 64H64C28.63 64 0 92.63 0 128zM32 128c0-17.64 14.36-32 32-32h306.8c8.541 0 16.57 3.33 22.62 9.377l150.6 150.6l-150.6 150.6C387.3 412.7 379.3 416 370.8 416H64c-17.64 0-32-14.36-32-32V128zM148.7 203.3L201.4 256L148.7 308.7c-6.25 6.25-6.25 16.38 0 22.62c6.254 6.254 16.38 6.246 22.62 0L224 278.6l52.69 52.69c6.254 6.254 16.38 6.246 22.62 0c6.25-6.25 6.25-16.38 0-22.62L246.6 256l52.69-52.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L224 233.4L171.3 180.7c-6.25-6.25-16.38-6.25-22.62 0S142.4 197.1 148.7 203.3z"],
    "democrat": [640, 512, [], "f747", "M639.2 250.9C617.9 186.1 558.3 144 490.8 144H269.8L225.4 97.09C235.1 71.99 233.9 42.4 218.2 18.61C210.7 7.254 198.1 .4453 184.4 .4453c-10.84 0-21.03 4.215-28.69 11.88L141.7 26.34L126.8 11.45C119.4 4.066 109.6 0 99.17 0c-13.27 0-25.5 6.648-32.7 17.78c-15.75 23.95-15.79 54.78-1.439 78.7l-52.98 70.55c-13.76 18.33-15.9 42.44-5.578 62.9l12.71 25.2c10.22 20.27 30.67 32.86 53.37 32.86h27.12c14.92 0 29-5.41 40.02-15.31l20.38 53.23V452c0 33.09 26.91 60 59.99 60h23.1C277.1 512 304.1 485.1 304.1 452V416h127.1v36c0 33.09 26.91 60 59.99 60h23.99c33.08 0 59.99-26.91 59.99-60l.002-211.1c0-12.55-2.461-24.7-7.021-35.98c17.97 14.58 32.15 33.95 39.85 57.04C611.1 267.8 617.3 272 624 272c1.672 0 3.375-.25 5.062-.8125C637.4 268.4 641.1 259.3 639.2 250.9zM544 452c0 15.4-12.6 28-27.1 28h-23.99c-15.4 0-27.1-12.6-27.1-28V384H272.1v68c0 15.4-12.6 28-27.1 28H220.1c-15.4 0-27.1-12.6-27.1-28l-.0433-100h351.1L544 452zM544 312l-.0102 7.999H192L152.8 217.5L119.5 247.8C114.2 253 107.1 255.1 99.67 255.1H72.55c-10.49 0-20.08-5.906-24.8-15.27L35.04 215.5C30.27 206.1 31.28 194.7 37.64 186.3l65.32-86.99C104.5 97.29 106.7 96.09 108.5 94.55c-3.502-1.969-6.998-3.719-9.842-6.562C84.36 73.66 82.61 51.46 93.33 35.17C94.67 33.09 96.91 32 99.17 32c1.783 0 3.586 .6758 4.984 2.074L141.7 71.59l36.63-36.64C179.1 33.26 182.2 32.45 184.4 32.45c2.768 0 5.51 1.312 7.16 3.816c13.23 20.01 11.04 47.14-6.561 64.64L256.1 176h223.1c35.34 0 63.99 28.66 63.99 64L544 312zM288.1 232H272.1L272 215.1C272 207.2 264.9 200 256.1 200s-15.1 7.156-15.1 16v16H224.1c-8.844 0-15.1 7.156-15.1 16s7.154 16 15.1 16l15.96-.0001L240.1 280c0 8.844 7.156 16 15.1 16s15.1-7.156 15.1-16v-16h15.1c8.842 0 15.97-7.156 15.97-16S296.9 232 288.1 232zM400 232h-15.1v-16c0-8.844-7.154-16-15.1-16c-8.842 0-15.1 7.156-15.1 16v16h-15.1c-8.842 0-15.1 7.156-15.1 16s7.129 15.1 15.97 15.1L352 264v16c0 8.844 7.132 15.1 15.97 15.1c8.844 0 16.02-7.156 16.02-15.1v-16l15.98-.0001c8.842 0 16.02-7.156 16.02-15.1S408.9 232 400 232zM512 232h-15.1v-16c0-8.844-7.156-16-15.1-16s-16.01 7.156-16.01 15.1L464 232h-15.1c-8.842 0-16.02 7.156-16.02 15.1S439.2 264 448 264h15.1v16c0 8.844 7.156 16 15.1 16s15.1-7.156 15.1-16l-.0127-16L512 264c8.844 0 15.1-7.156 15.1-16S520.9 232 512 232z"],
    "desktop": [576, 512, [62352, 61704, "desktop-alt"], "1f5a5", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM227.9 480l19.2-64h81.79l19.2 64H227.9zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V288h512V352zM544 256H32V64c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V256z"],
    "desktop-arrow-down": [576, 512, [], "e155", "M208 112c-4.094 0-8.188 1.562-11.31 4.688c-6.25 6.25-6.25 16.38 0 22.62l80 80c6.25 6.25 16.38 6.25 22.62 0l80-80c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L304 169.4V16C304 7.156 296.8 0 288 0S272 7.156 272 16v153.4L219.3 116.7C216.2 113.6 212.1 112 208 112zM512 0h-144C359.2 0 352 7.162 352 16C352 24.84 359.2 32 368 32H512c17.67 0 32 14.33 32 32v192H32V64c0-17.67 14.33-32 32-32h144C216.8 32 224 24.84 224 16C224 7.162 216.8 0 208 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM227.9 480l19.2-64h81.79l19.2 64H227.9zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V288h512V352z"],
    "dharmachakra": [512, 512, [63061], "2638", "M496 240h-32.81c-3.477-45.32-21.46-86.58-49.41-119.2l23.24-23.24c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-23.24 23.24C358.6 70.26 317.3 52.29 272 48.81V16C272 7.156 264.8 0 256 0S240 7.156 240 16v32.81C194.7 52.29 153.4 70.26 120.9 98.21L97.61 74.97c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L98.22 120.8C70.27 153.4 52.29 194.7 48.81 240H16C7.156 240 0 247.2 0 256s7.156 16 16 16h32.81c3.477 45.32 21.46 86.58 49.41 119.2l-23.24 23.24c-6.25 6.25-6.25 16.38 0 22.62c3.125 3.125 7.219 4.688 11.31 4.688s8.188-1.562 11.31-4.688l23.24-23.24C153.4 441.7 194.7 459.7 240 463.2V496c0 8.844 7.156 16 16 16s16-7.156 16-16v-32.81c45.32-3.473 86.56-21.45 119.1-49.4l23.24 23.24c3.125 3.125 7.219 4.688 11.31 4.688s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L413.8 391.2C441.7 358.6 459.7 317.3 463.2 272H496C504.8 272 512 264.8 512 256S504.8 240 496 240zM431.2 240h-80.81c-2.459-14.53-8.078-27.91-16.3-39.46l57.08-57.09C413.4 170.1 427.9 203.5 431.2 240zM256 320c-35.3 0-64-28.72-64-64s28.7-64 64-64s64 28.72 64 64S291.3 320 256 320zM368.5 120.8l-57.08 57.09C299.9 169.7 286.5 164.1 272 161.6V80.81C308.5 84.13 341.9 98.58 368.5 120.8zM240 80.81v80.8C225.5 164.1 212.1 169.7 200.5 177.9L143.5 120.8C170.1 98.58 203.5 84.13 240 80.81zM120.8 143.5l57.08 57.09C169.7 212.1 164.1 225.5 161.6 240H80.81C84.12 203.5 98.59 170.1 120.8 143.5zM80.81 272h80.81c2.459 14.53 8.078 27.91 16.3 39.46l-57.08 57.09C98.59 341.9 84.12 308.5 80.81 272zM143.5 391.2l57.08-57.09C212.1 342.3 225.5 347.9 240 350.4v80.8C203.5 427.9 170.1 413.4 143.5 391.2zM272 431.2v-80.8c14.53-2.461 27.92-8.078 39.46-16.3l57.08 57.09C341.9 413.4 308.5 427.9 272 431.2zM391.2 368.5l-57.08-57.09C342.3 299.9 347.9 286.5 350.4 272h80.81C427.9 308.5 413.4 341.9 391.2 368.5z"],
    "diagram-lean-canvas": [640, 512, [], "e156", "M576 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V96C640 60.65 611.3 32 576 32zM576 64c17.64 0 32 14.36 32 32v240h-96V64H576zM400 224H480v112h-80V224zM480 64v128h-80V64H480zM368 64v272h-96V64H368zM240 336H160V224h80V336zM240 64v128H160V64H240zM64 64h64v272H32V96C32 78.36 46.36 64 64 64zM64 448c-17.64 0-32-14.36-32-32v-48h272V448H64zM576 448h-240v-80H608V416C608 433.6 593.6 448 576 448z"],
    "diagram-nested": [512, 512, [], "e157", "M464 288h-128C309.5 288 288 309.5 288 336v128c0 26.51 21.49 48 48 48h128c26.51 0 48-21.49 48-48v-128C512 309.5 490.5 288 464 288zM480 464c0 8.822-7.178 16-16 16h-128c-8.822 0-16-7.178-16-16v-128c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16V464zM240 384h-64C149.5 384 128 362.5 128 336V224h48C202.5 224 224 202.5 224 176v-128C224 21.49 202.5 0 176 0h-128C21.49 0 0 21.49 0 48v128C0 202.5 21.49 224 48 224H96v112C96 380.1 131.9 416 176 416h64c8.844 0 16-7.156 16-16S248.8 384 240 384zM48 192C39.18 192 32 184.8 32 176v-128C32 39.18 39.18 32 48 32h128C184.8 32 192 39.18 192 48v128C192 184.8 184.8 192 176 192H48z"],
    "diagram-project": [640, 512, ["project-diagram"], "f542", "M591.1 0h-96c-26.51 0-48 21.49-48 48v96c0 26.51 21.49 48 48 48h96c26.51 0 48-21.49 48-48v-96C639.1 21.49 618.5 0 591.1 0zM608 144C608 152.8 600.8 160 592 160h-96C487.2 160 480 152.8 480 144v-96C480 39.18 487.2 32 496 32h96C600.8 32 608 39.18 608 48V144zM368 320h-96C245.5 320 224 341.5 224 368v96C224 490.5 245.5 512 272 512h96c26.51 0 48-21.49 48-48v-96C416 341.5 394.5 320 368 320zM384 464c0 8.822-7.178 16-16 16h-96C263.2 480 256 472.8 256 464v-96C256 359.2 263.2 352 272 352h96c8.822 0 16 7.178 16 16V464zM400 80H192v-32C192 21.49 170.5 0 144 0h-96C21.49 0 0 21.49 0 48v96C0 170.5 21.49 192 48 192h96c2.17 0 4.242-.3594 6.336-.6387l59.76 104.6C213.1 301.1 218.5 304 224 304c2.719 0 5.438-.6719 7.938-2.109c7.688-4.375 10.34-14.16 5.969-21.83L178.9 176.8C186.1 168.2 192 156.7 192 144v-32h208C408.8 112 416 104.8 416 96S408.8 80 400 80zM160 144C160 152.8 152.8 160 144 160h-96C39.18 160 32 152.8 32 144v-96C32 39.18 39.18 32 48 32h96C152.8 32 160 39.18 160 48V144z"],
    "diagram-sankey": [640, 512, [], "e158", "M48 224H288c5.625 0 10.81-2.953 13.72-7.766l86.69-144.5C391.3 66.97 396.5 64 402.1 64H592C600.8 64 608 56.84 608 48S600.8 32 592 32h-189.9c-16.78 0-32.53 8.922-41.16 23.3L278.9 192H48C39.16 192 32 199.2 32 208S39.16 224 48 224zM608 304C608 295.2 600.8 288 592 288h-544C39.16 288 32 295.2 32 304S39.16 320 48 320h150.9l82.03 136.7C289.6 471.1 305.3 480 322.1 480H592c8.844 0 16-7.156 16-16S600.8 448 592 448h-269.9c-5.594 0-10.84-2.969-13.72-7.766L236.3 320H592C600.8 320 608 312.8 608 304z"],
    "diagram-venn": [640, 512, [], "e15a", "M416 32c-34.38 0-66.86 7.956-96 21.86C290.9 39.96 258.4 32 224 32C100.5 32 0 132.5 0 256s100.5 224 224 224c34.38 0 66.86-7.956 96-21.86C349.1 472 381.6 480 416 480c123.5 0 224-100.5 224-224S539.5 32 416 32zM390.1 160H249.9C266.8 131 290.1 106.8 320 89.98C349 106.8 373.2 131 390.1 160zM404.6 320H235.4C230 304.8 226.5 288.7 225.1 272h189.8C413.5 288.7 409.1 304.8 404.6 320zM414.9 240H225.1C226.5 223.3 230 207.2 235.4 192h169.1C409.1 207.2 413.5 223.3 414.9 240zM224 448c-105.9 0-192-86.13-192-192s86.13-192 192-192c21.54 0 42.18 3.723 61.52 10.29C229 114.1 192 181.2 192 256s37 141 93.52 181.7C266.2 444.3 245.5 448 224 448zM249.9 352h140.1C373.2 380.1 349 405.2 320 422C290.1 405.2 266.8 380.1 249.9 352zM416 448c-21.54 0-42.18-3.723-61.52-10.29C411 397 448 330.8 448 256s-37-141-93.52-181.7C373.8 67.72 394.5 64 416 64c105.9 0 192 86.13 192 192S521.9 448 416 448z"],
    "dial": [576, 512, ["dial-med-high"], "e15b", "M32 256C14.33 256 0 270.3 0 288c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32C270.3 0 256 14.33 256 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM174.9 401.1c62.48 62.48 163.8 62.48 226.3-.002s62.48-163.8 0-226.3c-62.48-62.49-163.8-62.49-226.3-.002S112.4 338.7 174.9 401.1zM197.5 197.5c46.03-46.03 118.4-49.05 168.6-10.17L276.7 276.7c-6.254 6.254-6.254 16.37 0 22.63c6.252 6.254 16.37 6.254 22.63 0l89.37-89.36c38.89 50.17 35.86 122.5-10.17 168.6c-49.91 49.91-131.1 49.91-181 0C147.6 328.6 147.6 247.4 197.5 197.5zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35z"],
    "dial-high": [576, 512, [], "e15c", "M32 256C14.33 256 0 270.3 0 288c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32C270.3 0 256 14.33 256 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM127.1 288c.0014 88.36 71.64 159.1 160 159.1s160-71.63 159.1-159.1c.0014-88.37-71.63-160-159.1-160S127.1 199.6 127.1 288zM288 160c65.1 0 118.4 49.03 126.4 112l-126.4 0c-8.844 0-16 7.156-15.1 15.1c-.0014 8.843 7.154 15.1 15.1 15.1l126.4 .002c-7.977 62.97-61.28 111.1-126.4 112c-70.58-.0014-128-57.42-128-128C159.1 217.4 217.4 160 288 160zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35z"],
    "dial-low": [576, 512, [], "e15d", "M32 256C14.33 256 0 270.3 0 288c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32C270.3 0 256 14.33 256 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM448 287.1c-.0014-88.36-71.65-159.1-160-159.1s-159.1 71.63-159.1 159.1c-.0014 88.37 71.63 160 159.1 160S447.1 376.3 448 287.1zM287.1 416c-65.1 0-118.4-49.03-126.4-112l126.4-.0004c8.844 0 16-7.156 15.1-15.1c.0014-8.843-7.154-15.1-15.1-15.1L161.6 271.1C169.6 209 222.9 160 287.1 159.1c70.58 .0014 128 57.42 128 128C416 358.6 358.6 416 287.1 416zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35z"],
    "dial-max": [576, 512, [], "e15e", "M32 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32c-17.67 0-32 14.33-32 32C256 49.67 270.3 64 288 64zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.25 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.25 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM401.1 174.9c-62.48-62.48-163.8-62.48-226.3 0s-62.48 163.8 0 226.3s163.8 62.48 226.3 0S463.6 237.3 401.1 174.9zM388.7 366.1l-89.37-89.37c-6.254-6.252-16.37-6.252-22.63 0c-6.254 6.254-6.254 16.37 0 22.63l89.36 89.37c-50.17 38.89-122.5 35.86-168.6-10.17c-49.91-49.91-49.91-131.1-.002-181c49.91-49.91 131.1-49.91 181 0C424.5 243.5 427.6 315.9 388.7 366.1z"],
    "dial-med": [576, 512, [], "e15f", "M32 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32c-17.67 0-32 14.33-32 32C256 49.67 270.3 64 288 64zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM446.4 84.36c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.36zM288 128c-88.37 0-160 71.63-160 159.1c0 88.37 71.63 160 160 160c88.37 0 160-71.63 160-160C448 199.6 376.4 128 288 128zM288 416c-70.58 0-128-57.42-128-128c0-65.1 49.03-118.4 112-126.4V288c0 8.844 7.156 16 16 16s16-7.156 16-16V161.6C366.1 169.6 416 222.9 416 288C416 358.6 358.6 416 288 416zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4z"],
    "dial-med-low": [576, 512, [], "e160", "M32 256C14.33 256 0 270.3 0 288c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32C270.3 0 256 14.33 256 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM401.1 401.1c62.48-62.48 62.48-163.8-.002-226.3s-163.8-62.48-226.3 0c-62.49 62.48-62.49 163.8-.002 226.3S338.7 463.6 401.1 401.1zM197.5 378.5c-46.03-46.03-49.05-118.4-10.17-168.6l89.37 89.37c6.254 6.254 16.37 6.254 22.63 0c6.254-6.252 6.254-16.37 0-22.63L209.9 187.3c50.17-38.89 122.5-35.86 168.6 10.17c49.91 49.91 49.91 131.1 0 181C328.6 428.4 247.4 428.4 197.5 378.5zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35z"],
    "dial-min": [576, 512, [], "e161", "M32 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32c-17.67 0-32 14.33-32 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM401.1 174.9c-62.48-62.48-163.8-62.48-226.3 .002s-62.48 163.8 0 226.3c62.48 62.49 163.8 62.49 226.3 .002S463.6 237.3 401.1 174.9zM378.5 378.5c-46.03 46.03-118.4 49.05-168.6 10.17l89.37-89.37c6.254-6.254 6.254-16.37 0-22.63c-6.252-6.254-16.37-6.254-22.63 0L187.3 366.1c-38.89-50.17-35.86-122.5 10.17-168.6c49.91-49.91 131.1-49.91 181 0C428.4 247.4 428.4 328.6 378.5 378.5zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35z"],
    "dial-off": [576, 512, [], "e162", "M32 256C14.33 256 0 270.3 0 288c0 17.67 14.33 32 32 32s32-14.33 32-32C64 270.3 49.67 256 32 256zM84.35 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26C117.1 433.9 96.85 433.9 84.35 446.4zM129.6 129.6c12.5-12.5 12.5-32.76 0-45.25c-12.5-12.5-32.76-12.5-45.26 0c-12.5 12.5-12.5 32.76 0 45.25C96.85 142.1 117.1 142.1 129.6 129.6zM288 64c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32C270.3 0 256 14.33 256 32C256 49.67 270.3 64 288 64zM446.4 446.4c-12.5 12.5-12.5 32.76 0 45.26c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.26S458.9 433.9 446.4 446.4zM287.1 127.1C199.6 128 127.1 199.6 127.1 288s71.63 160 159.1 159.1c88.37 .0014 160-71.63 160-159.1S376.4 128 287.1 127.1zM415.1 288c0 65.1-49.03 118.4-112 126.4l.0009-126.4c0-8.844-7.156-16-15.1-15.1C279.2 272 272 279.2 272 288l-.0023 126.4c-62.97-7.977-111.1-61.28-112-126.4C159.1 217.4 217.4 159.1 287.1 160C358.6 159.1 415.1 217.4 415.1 288zM544 256c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C576 270.3 561.7 256 544 256zM446.4 84.35c-12.5 12.5-12.5 32.76 0 45.25c12.5 12.5 32.76 12.5 45.26 0c12.5-12.5 12.5-32.76 0-45.25C479.2 71.86 458.9 71.86 446.4 84.35z"],
    "diamond": [512, 512, [61977], "2666", "M497.1 222.1l-208.1-208.1C280.5 4.676 268.3 0 256 0C243.7 0 231.5 4.676 222.1 14.03L14.03 222.1c-18.71 18.71-18.71 49.04 0 67.74l208.1 208.1C231.5 507.3 243.7 512 256 512c12.26 0 24.52-4.677 33.87-14.03l208.1-208.1C516.7 271.2 516.7 240.8 497.1 222.1zM475.3 267.2l-208.1 208.1C263.2 479.4 258.5 480 256 480c-2.459 0-7.191-.6055-11.24-4.658L36.66 267.2c-6.199-6.201-6.201-16.29 0-22.49l208.1-208.1C248.8 32.61 253.5 32 256 32c2.461 0 7.191 .6055 11.24 4.658l208.1 208.1C481.5 250.1 481.5 261 475.3 267.2z"],
    "diamond-turn-right": [512, 512, ["directions"], "f5eb", "M497.1 222.1l-208.1-208.1c-9.354-9.355-21.63-14.03-33.89-14.03S231.5 4.674 222.1 14.03L14.03 222.1C4.677 231.5 .0006 243.7 .0004 255.1C.0001 268.3 4.676 280.5 14.03 289.9l208.1 208.1C231.5 507.3 243.7 511.1 256 511.1s24.52-4.679 33.87-14.03l208.1-208.1c9.353-9.356 14.03-21.61 14.03-33.87C511.1 243.7 507.3 231.5 497.1 222.1zM475.3 267.2l-208.1 208.1C263.2 479.4 258.5 480 256 480s-7.191-.6055-11.24-4.66L36.66 267.3c-6.201-6.203-6.201-16.29-.002-22.49l208.1-208.1C248.8 32.61 253.5 32 256 32s7.191 .6055 11.24 4.66l208.1 208.1C481.5 250.1 481.5 261 475.3 267.2zM315.3 148.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L345.4 224H240C213.5 224 192 245.5 192 272v64C192 344.8 199.2 352 208 352S224 344.8 224 336l-.0002-64C223.1 263.2 231.2 256 240 256h105.4l-52.69 52.69c-6.25 6.25-6.25 16.38 0 22.62C295.8 334.4 299.9 336 304 336s8.188-1.562 11.31-4.688l80-80c6.25-6.25 6.25-16.38 0-22.62L315.3 148.7z"],
    "dice": [640, 512, [62754], "1f3b2", "M224 296c-13.25 0-23.1 10.75-23.1 23.1s10.75 23.1 23.1 23.1s23.1-10.75 23.1-23.1S237.3 296 224 296zM128 200c-13.25 0-23.1 10.75-23.1 23.1s10.75 23.1 23.1 23.1S152 237.3 152 224S141.3 200 128 200zM224 200c-13.25 0-23.1 10.75-23.1 23.1s10.75 23.1 23.1 23.1s23.1-10.75 23.1-23.1S237.3 200 224 200zM479.1 376c13.25 0 23.1-10.75 23.1-23.1s-10.75-23.1-23.1-23.1s-23.1 10.75-23.1 23.1S466.7 376 479.1 376zM224 104c-13.25 0-23.1 10.75-23.1 23.1s10.75 23.1 23.1 23.1s23.1-10.75 23.1-23.1S237.3 104 224 104zM575.1 192l-102.7-.0001c3.59 10.21 5.848 20.92 5.848 31.1h96.87c17.62 0 31.1 14.37 31.1 31.1v191.1c0 17.62-14.37 31.1-31.1 31.1h-191.1c-17.62 0-31.1-14.37-31.1-31.1v-56.74L320 423.2v24.84C320 483.4 348.6 512 383.1 512h191.1c35.37 0 63.1-28.62 63.1-63.1v-191.1C639.1 220.6 611.4 192 575.1 192zM320 200c-13.25 0-23.1 10.75-23.1 23.1S306.8 248 320 248s23.1-10.75 23.1-23.1S333.2 200 320 200zM447.1 224c0-17.15-6.691-33.43-18.84-45.83L270.1 19.08C257.4 6.695 241.1 0 223.1 0S190.6 6.695 178.2 18.85L19.07 177.9C6.695 190.6-.0011 206.8-.0011 223.1c0 17.15 6.696 33.48 18.85 45.87l159.1 159.1c12.63 12.38 28.9 19.07 46.06 19.07s33.43-6.693 45.83-18.85l159.1-159.1C441.3 257.4 447.1 241.2 447.1 224zM406.2 247.3l-158.9 158.9c-6.275 6.148-14.56 9.662-23.34 9.662c-8.785 0-17.07-3.514-23.34-9.662L41.79 247.3C35.64 241.1 32.13 232.8 32.13 224c0-8.785 3.516-17.07 9.664-23.34L200.7 41.79c6.275-6.148 14.56-9.662 23.34-9.662c8.785 0 17.07 3.514 23.34 9.662l158.9 158.9c6.15 6.275 9.664 14.56 9.664 23.34C415.9 232.8 412.4 241.1 406.2 247.3z"],
    "dice-d10": [512, 512, [], "f6cd", "M512 282.6c0-7.59-2.683-15.19-8.118-21.32l-224.1-250.6C273.5 3.5 264.8 0 256 0S238.5 3.5 232.2 10.62L8.151 261.3C2.671 267.4 0 274.1 0 282.5C0 291.4 3.662 300.2 10.8 306.5l224.1 197.5C240.9 509.4 248.5 512 256 512c7.5 0 15.12-2.615 21.12-7.99l224.1-197.5C508.4 300.2 512 291.4 512 282.6zM256 298L180.2 247.4l75.87-177l75.87 177L256 298zM148.8 239.8L47.79 265L221 71.12L148.8 239.8zM363.3 239.8L291 71.12L464.5 265L363.3 239.8zM49.04 297.6L157.3 270.5l82.75 55.25v140.3L49.04 297.6zM272 465.9v-140.1l82.75-55.25l108.1 27.12L272 465.9z"],
    "dice-d12": [512, 512, [], "f6ce", "M505.3 178.5l-47.73-95.39c-6.125-12.37-16.25-22.5-28.62-28.62l-95.39-47.73C324.6 2.25 314.9 0 304.9 0H207.1c-10 0-19.75 2.25-28.62 6.75L83.11 54.48C70.73 60.61 60.61 70.73 54.48 83.11l-47.73 95.39C2.25 187.4 0 197.1 0 207.1v97.77c0 10 2.25 19.75 6.75 28.62l47.73 95.4c6.125 12.37 16.25 22.5 28.62 28.62l95.4 47.73C187.4 509.6 197.1 512 207.1 512h97.75c10 0 19.75-2.25 28.62-6.75l95.4-47.73c12.37-6.125 22.5-16.25 28.62-28.62l47.73-95.38C509.6 324.6 512 314.9 512 304.9V207.1C512 197.1 509.8 187.4 505.3 178.5zM475.8 190.9l-95.63 109.2L272 246.1V140.2l157-42.87L475.8 190.9zM308.8 480h-105.5l-55.37-152L256 273.9L364.1 328L308.8 480zM199.5 32h113l82.75 41.38L256 111.4l-139.2-38L199.5 32zM83 97.38L240 140.2v105.9l-108.1 54L36.25 190.9L83 97.38zM32 312.5V234.6l81.96 93.83l48.42 132.9l-74.5-37.25L32 312.5zM424.1 424.1l-74.5 37.25l48.42-132.9L480 234.6V312.5L424.1 424.1z"],
    "dice-d20": [512, 512, [], "f6cf", "M463.9 116.1l-192-111.9C267 1.438 261.5 0 255.1 0S245 1.438 240.1 4.25l-192 111.9C38.12 121.1 32 132.7 32 144.5v223c0 11.75 6.125 22.48 16.12 28.36l192 111.9C245 510.6 250.5 512 256 512s11-1.438 15.88-4.25l192-111.9C473.9 390 480 379.3 480 367.5V144.5C480 132.7 473.9 121.1 463.9 116.1zM256 57.6l94.75 118.4H161.2L256 57.6zM156.6 207.1h198.8L256 369.5L156.6 207.1zM224.9 380l-137-17.13l44.5-133.3L224.9 380zM379.6 229.6l44.5 133.3l-137 17.13L379.6 229.6zM386.9 169.9l-92.25-115.1l138 80.76L386.9 169.9zM125.1 169.9L79 135.2l138.5-80.76L125.1 169.9zM109.1 197.9L64 333.3l.25-169.1L109.1 197.9zM240 414.1v56.38L117.4 398.8L240 414.1zM395.6 398.6L272 470.9v-56.76L395.6 398.6zM402.9 197.9L448 163.1l-.25 168.8L402.9 197.9zM256.2 480L256.2 480L256.2 480z"],
    "dice-d4": [512, 512, [], "f6d0", "M512 309.1c0-7.05-2.318-14.15-7.127-20.07l-224-277.1C274.5 3.1 265.2 0 256 0C246.8 0 237.5 3.1 231.1 11.88l-224 277.1C2.318 294.9 0 302 0 309.1c0 9.625 4.319 19.15 12.62 25.43l224 170.1C242.4 509.9 249.1 512 256 512c6.875 0 13.62-2.135 19.37-6.51l224-170.1C507.7 328.2 512 318.7 512 309.1zM32.01 309.1L240 51.75v416L32.01 309.1zM271.1 467.9v-416l207.1 257.3L271.1 467.9z"],
    "dice-d6": [448, 512, [], "f6d1", "M431.9 116.1l-192-111.9C235 1.438 229.5 0 224 0S213 1.438 208.1 4.25l-192 111.9C6.125 121.1 0 132.7 0 144.5v223c0 11.75 6.125 22.48 16.12 28.36l192 111.9C213 510.6 218.5 512 224 512s11-1.438 15.88-4.25l192-111.9C441.9 390 448 379.3 448 367.5V144.5C448 132.7 441.9 121.1 431.9 116.1zM224 32.1l175.8 102.9L224 237.5l-176.1-102.8L224 32.1zM32.25 162.6L208 265.1v205.4L32 367.5L32.25 162.6zM240 470.9V265.1L416 162.5l-.25 205.8L240 470.9z"],
    "dice-d8": [512, 512, [], "f6d2", "M512 256c0-8.643-3.305-17.32-9.868-23.88l-222.2-222.3C273.3 3.26 264.6 0 256 0S238.7 3.26 232.1 9.887L9.868 232.1C3.305 238.7 0 247.4 0 256s3.305 17.27 9.868 23.84l222.2 222.3C238.7 508.7 247.2 512 256 512s17.26-3.26 23.89-9.887l222.2-222.3C508.7 273.4 512 264.7 512 256zM239.1 464.9L61.23 285.9l178.8 76.64V464.9zM239.1 327.8L43.72 243.7L239.1 47.26V327.8zM272 464.9v-102.3l178.8-76.64L272 464.9zM272 327.8v-280.6L468.3 243.7L272 327.8z"],
    "dice-five": [448, 512, [62755], "2684", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM128 136C114.8 136 104 146.8 104 160S114.8 184 128 184S152 173.2 152 160S141.2 136 128 136zM224 232C210.8 232 200 242.8 200 256c0 13.25 10.75 24 24 24S248 269.2 248 256C248 242.8 237.2 232 224 232zM128 328c-13.25 0-24 10.75-24 24S114.8 376 128 376S152 365.2 152 352S141.2 328 128 328zM320 136c-13.25 0-24 10.75-24 24S306.8 184 320 184S344 173.2 344 160S333.2 136 320 136zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S333.2 328 320 328z"],
    "dice-four": [448, 512, [62756], "2683", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM128 136C114.8 136 104 146.8 104 160S114.8 184 128 184S152 173.2 152 160S141.2 136 128 136zM128 328c-13.25 0-24 10.75-24 24S114.8 376 128 376S152 365.2 152 352S141.2 328 128 328zM320 136c-13.25 0-24 10.75-24 24S306.8 184 320 184S344 173.2 344 160S333.2 136 320 136zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S333.2 328 320 328z"],
    "dice-one": [448, 512, [62757], "2680", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM224 232C210.8 232 200 242.8 200 256c0 13.25 10.75 24 24 24S248 269.2 248 256C248 242.8 237.2 232 224 232z"],
    "dice-six": [448, 512, [62758], "2685", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM128 136C114.8 136 104 146.8 104 160S114.8 184 128 184S152 173.2 152 160S141.2 136 128 136zM128 232C114.8 232 104 242.8 104 256c0 13.25 10.75 24 24 24S152 269.2 152 256C152 242.8 141.2 232 128 232zM320 232c-13.25 0-24 10.75-24 24c0 13.25 10.75 24 24 24S344 269.2 344 256C344 242.8 333.2 232 320 232zM128 328c-13.25 0-24 10.75-24 24S114.8 376 128 376S152 365.2 152 352S141.2 328 128 328zM320 136c-13.25 0-24 10.75-24 24S306.8 184 320 184S344 173.2 344 160S333.2 136 320 136zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S333.2 328 320 328z"],
    "dice-three": [448, 512, [62759], "2682", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM128 136C114.8 136 104 146.8 104 160S114.8 184 128 184S152 173.2 152 160S141.2 136 128 136zM224 232C210.8 232 200 242.8 200 256c0 13.25 10.75 24 24 24S248 269.2 248 256C248 242.8 237.2 232 224 232zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S333.2 328 320 328z"],
    "dice-two": [448, 512, [62760], "2681", "M384 32H64C28.62 32 0 60.62 0 96v320c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V96C448 60.62 419.4 32 384 32zM416 416c0 17.62-14.38 32-32 32H64c-17.62 0-32-14.38-32-32V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V416zM128 136C114.8 136 104 146.8 104 160S114.8 184 128 184S152 173.2 152 160S141.2 136 128 136zM320 328c-13.25 0-24 10.75-24 24s10.75 24 24 24s24-10.75 24-24S333.2 328 320 328z"],
    "diploma": [640, 512, ["scroll-ribbon"], "f5ea", "M539.3 144h-62.42C483.9 132.2 488 118.3 488 104c0-39.7-28.42-72-63.36-72C394.1 32 373.2 41.84 320 128.9C266.8 41.84 245.9 32 215.4 32C180.4 32 152 64.3 152 104c0 14.34 4.072 28.19 11.16 40H96c-53.02 0-96 48.47-96 128S42.98 416 96 416l144-30.86V464c0 5.531 2.875 10.69 7.594 13.62c4.688 2.844 10.59 3.156 15.56 .6875L320 449.9l56.84 28.44C379.1 479.4 381.6 480 384 480c2.938 0 5.844-.8125 8.406-2.375C397.1 474.7 400 469.5 400 464v-78.48L539.3 416C594.9 416 640 351.5 640 272C640 192.5 594.9 144 539.3 144zM240 352.4l-146.8 31.46C63.7 381.2 32 335.1 32 272c0-56.52 26.32-96 64-96h144V352.4zM215.4 144C198.1 144 184 126.1 184 104S198.1 64 215.4 64c14.05 0 27.44 .1953 76.38 80H215.4zM368 438.1l-40.84-20.44c-4.5-2.25-9.812-2.25-14.31 0L272 438.1V176h96V438.1zM348.3 144c48.95-79.8 62.34-80 76.38-80C441.9 64 456 81.95 456 104S441.9 144 424.6 144H348.3zM542.2 383.9L400 352.8V176h139.3C580.4 176 608 214.6 608 272C608 331.1 578.2 381.3 542.2 383.9z"],
    "disc-drive": [512, 512, [], "f8b5", "M256 224C238.4 224 224 238.4 224 256s14.38 32 32 32c17.62 0 32-14.38 32-32S273.6 224 256 224zM496 448H480V96c0-35.35-28.65-64-64-64H96C60.65 32 32 60.65 32 96v352H15.1C7.2 448 0 455.2 0 464S7.2 480 15.1 480h480c8.8 0 16-7.2 16-16S504.8 448 496 448zM448 448H64V96c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V448zM256 96C167.6 96 96 167.6 96 256s71.62 160 160 160s160-71.63 160-160S344.4 96 256 96zM256 384c-70.75 0-128-57.25-128-128s57.25-128 128-128s128 57.25 128 128C383.9 326.6 326.6 383.9 256 384z"],
    "disease": [512, 512, [], "f7fa", "M159.1 200c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C183.1 210.8 173.2 200 159.1 200zM287.1 296c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C311.1 306.8 301.2 296 287.1 296zM463.9 184.1l-62.88-21.25c-13-4.375-22.5-13.63-25.38-24.5l-15-56.26c-6.25-23.38-25.62-41.38-51.63-48.13C280.2 27.31 250.1 34.94 230.6 54.94L187.4 99.19C178.1 108.6 163.9 113.7 149.2 112.4L81.86 107.2c-31.38-2.5-60.5 12.13-74.25 37C-4.012 165.3-2.262 189.8 12.36 209.6L48.49 258.3c6.875 9.127 7.875 20 3 29.88l-26.75 52.88c-10.62 21.25-8.25 45.25 6.5 64.38c17.88 23 49.25 33.63 80.13 27l65.63-14.12c14.5-3.127 29.62-.125 40.63 8l50.88 38c14 10.25 31 15.75 48.38 15.62c12 0 23.75-2.5 34.75-7.5c23.38-10.62 38.5-31 40.25-54.38l4.375-57.38c.875-10.88 8.375-21 20-26.88l58.13-29.5c24.88-12.62 39.23-36.23 37.48-61.61C509.1 216.6 491.6 194.5 463.9 184.1zM459.9 275.8l-58.13 29.5c-21.75 11-35.75 30.75-37.38 53.01l-4.375 57.38c-1.25 16.63-15.5 24.88-21.62 27.63c-16.75 7.625-36.63 5.875-50.75-4.627l-51-38c-13.62-10.13-31-15.63-48.5-15.63c-6 0-12 .625-17.88 2L104.6 401.2c-23 5-40.13-5.125-48-15.38c-4.125-5.375-10.12-16.5-3.125-30.38l26.5-52.88c10.5-20.63 8.25-44.38-5.75-63.38L38.11 190.5c-9.75-13-5.75-24.88-2.5-30.75c7.75-14 25.38-21.88 43.75-20.63l67.38 5.25c24.25 1.875 47.75-6.625 63.5-22.75l43.25-44.25c11.38-11.63 30-16.13 47.5-11.63c14.75 3.875 25.5 13.5 28.75 25.63l15 56.13c5.75 21.25 23 38.75 46.13 46.5l62.75 21.38c15.62 5.25 25.38 16.38 26.38 29.75C480.9 257.5 473.4 268.1 459.9 275.8zM303.1 192c-8.875 0-15.1 7.122-15.1 15.1c0 8.875 7.125 15.1 15.1 15.1s15.1-7.124 15.1-15.1C319.1 199.1 312.9 192 303.1 192z"],
    "display": [576, 512, [], "e163", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM348.1 480H227.9l19.2-64h81.79L348.1 480zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V352z"],
    "display-arrow-down": [576, 512, [], "e164", "M208 176c-4.094 0-8.188 1.562-11.31 4.688c-6.25 6.25-6.25 16.38 0 22.62l80 80c6.25 6.25 16.38 6.25 22.62 0l80-80c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L304 233.4V16C304 7.156 296.8 0 288 0S272 7.156 272 16v217.4L219.3 180.7C216.2 177.6 212.1 176 208 176zM512 0h-144C359.2 0 352 7.162 352 16C352 24.84 359.2 32 368 32H512c17.67 0 32 14.33 32 32v288c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V64c0-17.67 14.33-32 32-32h144C216.8 32 224 24.84 224 16C224 7.162 216.8 0 208 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM227.9 480l19.2-64h81.79l19.2 64H227.9z"],
    "display-code": [576, 512, ["desktop-code"], "e165", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM227.9 480l19.2-64h81.79l19.2 64H227.9zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V352zM235.3 132.7c-6.25-6.25-16.38-6.25-22.62 0l-64 64c-6.25 6.25-6.25 16.38 0 22.62l64 64C215.8 286.4 219.9 288 224 288s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L182.6 208l52.69-52.69C241.6 149.1 241.6 138.9 235.3 132.7zM363.3 132.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L393.4 208l-52.69 52.69c-6.25 6.25-6.25 16.38 0 22.62C343.8 286.4 347.9 288 352 288s8.188-1.562 11.31-4.688l64-64c6.25-6.25 6.25-16.38 0-22.62L363.3 132.7z"],
    "display-medical": [576, 512, ["desktop-medical"], "e166", "M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM227.9 480l19.2-64h81.79l19.2 64H227.9zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V352zM368 176H320V128c0-8.838-7.164-16-16-16h-32C263.2 112 256 119.2 256 128v48H208C199.2 176 192 183.2 192 191.1V224c0 8.836 7.164 15.1 16 15.1H256v48C256 296.8 263.2 304 272 304h32c8.836 0 16-7.165 16-16v-48h48C376.8 239.1 384 232.8 384 224V191.1C384 183.2 376.8 176 368 176z"],
    "display-slash": [640, 512, ["desktop-slash"], "e2fa", "M544 32c17.64 0 32 14.36 32 32v288c0 1.273-.582 2.357-.7266 3.592l27.49 21.7C606.1 369.5 608 360.1 608 352V64c0-35.35-28.65-64-64-64H124.9l40.53 32H544zM464 480h-50.49l-18.96-63.22L353 384H96c-17.64 0-32-14.36-32-32V155.8L32 130.6V352c0 35.35 28.65 64 64 64h149.7l-19.2 64H176C167.2 480 160 487.2 160 496S167.2 512 176 512h288c8.836 0 16-7.164 16-16S472.8 480 464 480zM259.9 480l19.2-64h81.79l19.2 64H259.9zM633.9 483.4L25.92 3.42c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "distribute-spacing-horizontal": [448, 512, [], "e365", "M16 0C7.164 0 0 7.162 0 16v480C0 504.8 7.164 512 16 512S32 504.8 32 496v-480C32 7.162 24.84 0 16 0zM272 96h-96C149.5 96 128 117.5 128 144v224C128 394.5 149.5 416 176 416h96c26.51 0 48-21.49 48-48v-224C320 117.5 298.5 96 272 96zM288 368c0 8.822-7.178 16-16 16h-96C167.2 384 160 376.8 160 368v-224C160 135.2 167.2 128 176 128h96C280.8 128 288 135.2 288 144V368zM432 0C423.2 0 416 7.162 416 16v480c0 8.836 7.164 16 16 16s16-7.164 16-16v-480C448 7.162 440.8 0 432 0z"],
    "distribute-spacing-vertical": [512, 512, [], "e366", "M16 64h480C504.8 64 512 56.84 512 48C512 39.16 504.8 32 496 32h-480C7.164 32 0 39.16 0 48C0 56.84 7.164 64 16 64zM496 448h-480C7.164 448 0 455.2 0 464C0 472.8 7.164 480 16 480h480c8.836 0 16-7.164 16-16C512 455.2 504.8 448 496 448zM144 160C117.5 160 96 181.5 96 208v96C96 330.5 117.5 352 144 352h224c26.51 0 48-21.49 48-48v-96C416 181.5 394.5 160 368 160H144zM384 208v96c0 8.822-7.178 16-16 16h-224C135.2 320 128 312.8 128 304v-96C128 199.2 135.2 192 144 192h224C376.8 192 384 199.2 384 208z"],
    "ditto": [320, 512, [], "22", "M63.99 32C45.53 32 27.06 39.64 14.89 54.93C2.692 70.21-2.372 90.22 1.044 109.9l25.21 145.2C29.55 274.1 45.44 288 63.99 288S98.43 274.1 101.7 255l25.24-145.2c3.389-19.6-1.678-39.61-13.88-54.9C100.9 39.64 82.46 32 63.99 32zM70.2 249.6C69.57 253.2 66.9 256 63.99 256S58.42 253.2 57.78 249.5l-25.21-145.2c-1.844-10.59 .8301-21.33 7.357-29.51C45.42 67.96 54.19 64 63.99 64s18.57 3.957 24.09 10.89C94.59 83.04 97.27 93.79 95.44 104.3L70.2 249.6zM305.1 54.93C292.9 39.64 274.5 32 255.1 32s-36.93 7.643-49.1 22.93c-12.2 15.29-17.27 35.3-13.85 54.93l25.21 145.2C221.6 274.1 237.4 288 255.1 288s34.44-13.89 37.74-32.99l25.24-145.2C322.4 90.22 317.3 70.21 305.1 54.93zM262.2 249.6C261.6 253.2 258.9 256 255.1 256s-5.572-2.766-6.211-6.465l-25.21-145.2c-1.844-10.59 .8301-21.33 7.357-29.51C237.4 67.96 246.2 64 255.1 64s18.57 3.957 24.09 10.89c6.506 8.152 9.188 18.9 7.361 29.46L262.2 249.6z"],
    "divide": [448, 512, [10135, 62761], "f7", "M432 240h-416C7.156 240 0 247.2 0 256s7.156 16 16 16h416C440.8 272 448 264.8 448 256S440.8 240 432 240zM224 192c35.35 0 64-28.65 64-64s-28.65-64-64-64S160 92.65 160 128S188.7 192 224 192zM224 96c17.64 0 32 14.36 32 32s-14.36 32-32 32S192 145.6 192 128S206.4 96 224 96zM224 320c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S259.3 320 224 320zM224 416c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S241.6 416 224 416z"],
    "dna": [448, 512, [62577], "1f9ec", "M318.8 305.2L297.4 289.6c-7.188-5.219-17.19-3.625-22.34 3.531c-5.203 7.141-3.625 17.16 3.531 22.34l21.42 15.58C308.7 337.4 316.5 344.5 324 352H123.1c7.473-7.488 15.33-14.63 24-20.94l170.8-124.3C379.7 162.6 416 91.23 416 16C416 7.156 408.8 0 400 0S384 7.156 384 16c0 5.375-.5352 10.68-.959 16H64.96C64.54 26.68 64 21.38 64 16C64 7.156 56.84 0 48 0S32 7.156 32 16c0 75.23 36.33 146.6 97.17 190.8L196.8 256L129.2 305.2C68.33 349.4 32 420.8 32 496c0 8.844 7.277 15.1 16.12 15.1S64 504.8 64 496c0-5.375 .5352-10.68 .959-16h318.1C383.5 485.3 384 490.6 384 496c0 8.844 7.156 16 16 16s16-7.156 16-16C416 420.8 379.7 349.4 318.8 305.2zM378.2 64c-5.553 22.81-15.05 44.45-27.88 64H97.66C84.83 108.5 75.33 86.81 69.78 64H378.2zM147.1 180.9C139.3 174.6 131.5 167.5 123.1 160h200c-7.473 7.488-15.33 14.63-24 20.94L224 236.2L147.1 180.9zM69.78 448c5.553-22.81 15.05-44.45 27.88-64h252.7c12.83 19.55 22.33 41.19 27.88 64H69.78z"],
    "do-not-enter": [512, 512, [], "f5ec", "M384 208H128C101.5 208 80 229.5 80 256S101.5 304 128 304h256c26.47 0 48-21.53 48-48S410.5 208 384 208zM384 272H128C119.2 272 112 264.8 112 256S119.2 240 128 240h256c8.812 0 16 7.172 16 16S392.8 272 384 272zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "dog": [576, 512, [63187], "1f415", "M512 96L464 96l-7.125-14.25C452 71.88 439.1 64 428.3 64L336 64l-.0501-15.96C335.9 39.2 328.8 32 320 32s-16 7.162-16 16V224H192C173.1 224 154.8 229.6 139 240H112C85.5 240 64 218.5 64 192c0-8.875-7.125-16-16-16S32 183.1 32 192c.125 43.13 34.38 78.37 77.5 79.75C100.8 286.4 96.13 303 96 320v144C96 490.4 117.6 512 144 512h32C202.4 512 224 490.4 224 464V384h96v80c0 26.4 21.6 48 48 48h32c26.4 0 48-21.6 48-48v-224l32 .001c35.35 0 64-28.66 64-64V128C544 110.3 529.7 96 512 96zM416 464c0 8.836-7.164 16-16 16l-32 .0001c-8.836 0-16-7.164-16-16v-96c0-8.838-7.164-16-16-16h-128C199.2 352 192 359.2 192 368v96c0 8.836-7.164 16-16 16L144 480C135.2 480 128 472.8 128 464V320c0-35.35 28.65-64 64-64h125.4L416 288.9V464zM512 176c0 17.6-14.4 32-32 32L416 208v47.13l-80-26.67V96h92.25l16 32H512V176zM400 112C391.1 112 384 119.1 384 128s7.125 16 16 16S416 136.9 416 128S408.9 112 400 112z"],
    "dog-leashed": [576, 512, [63188], "1f9ae", "M400 111.1c-8.875 0-15.1 7.15-15.1 16.02s7.125 15.1 15.1 15.1s15.1-7.146 15.1-16.02S408.9 111.1 400 111.1zM512 96.01l-48-.0207l-7.125-14.25c-4.875-9.875-17.75-17.75-28.62-17.75l-92.25 .0256l-.0506-15.97c0-8.838-7.113-16.03-15.95-16.03s-15.1 7.162-15.1 15.1v158.1L58.17 3.67C51.33-1.986 41.24-.9865 35.66 5.857C30.03 12.67 31 22.73 37.83 28.36L275.4 224H192c-18.87 0-37.25 5.625-52.1 15.1H112c-26.5 0-47.1-21.5-47.1-47.1c0-8.875-7.125-15.1-15.1-15.1S32 183.1 32 192c.125 43.12 34.38 78.38 77.5 79.75c-8.75 14.62-13.37 31.25-13.5 48.25v143.1C96 490.4 117.6 512 144 512h31.1c26.4 0 48-21.6 48-47.1v-79.1l95.1-.0285l.0006 80.03c0 26.4 21.6 47.98 47.1 47.98L400 512c26.4 0 48-21.6 48-47.1v-223.1l31.1-.0026C515.3 240 544 211.4 544 176V128C544 110.3 529.7 96.01 512 96.01zM288 352H208c-8.836 0-15.1 7.162-15.1 15.1v95.1c0 8.836-7.165 15.1-16 15.1l-31.1 .0003c-8.836 0-16-7.165-16-16l.0007-143.1c0-35.35 28.65-63.1 63.1-63.1h95.1V352zM416 464c0 8.836-7.164 16-15.1 16l-32-.0003c-8.836 0-15.1-7.164-15.1-15.1v-95.1c0-8.838-7.164-15.1-15.1-15.1h-15.1v-95.12l95.1 32.01L416 464zM512 176c0 17.6-14.4 31.98-32 31.98l-63.1 .0229v47.13l-79.1-26.67V96.01h92.25l15.1 31.1h67.75V176z"],
    "dollar-sign": [320, 512, [128178, "dollar", "usd"], "24", "M302 365.9c-9.438 50.08-57.21 79.63-126.1 81.73V496c0 8.844-7.104 16-15.95 16c-8.842 0-16.05-7.156-16.05-16v-49.73c-6.345-.5234-12.3-.4609-18.9-1.406c-27.98-3.875-58.29-13.88-85.02-22.7L27.07 417.9c-8.405-2.719-13.01-11.75-10.28-20.16c2.718-8.375 11.75-13 20.15-10.28l13.15 4.312c25.43 8.406 54.27 17.92 79.44 21.41c63.6 9.062 131.7-3.812 141.1-53.17c9.811-51.98-36.81-68.16-114.7-88.59l-17.04-4.5C87.68 253.1 2.06 230.1 17.93 146.1c9.43-50.05 57.26-79.34 126.1-81.5V16c0-8.844 7.188-16 16.03-16c8.842 0 15.96 7.156 15.96 16v49.47c6.282 .5195 12.36 .7383 18.9 1.668c18.07 2.609 39.02 7.781 65.91 16.31c8.436 2.672 13.09 11.66 10.42 20.08c-2.656 8.438-11.58 13.14-20.07 10.42c-25.18-7.984-44.51-12.8-60.8-15.12C126.9 89.73 58.69 102.6 49.36 152C40.62 198.4 75.42 216.7 147.1 236l16.84 4.453C232.6 258.5 318.1 280.9 302 365.9z"],
    "dolly": [576, 512, ["dolly-box"], "f472", "M575 330.5c-3.078-8.312-12.25-12.52-20.55-9.484l-223.9 82.5C319 373.4 290.1 352 256 352c-5.018 0-9.889 .5918-14.65 1.477L141.8 54.7C130.9 21.98 100.4 0 65.88 0H15.1C7.155 0 0 7.157 0 16S7.156 32 16 32h49.88c20.69 0 38.98 13.19 45.55 32.83l100.2 300.6C190.2 379.8 176 404.2 176 432C176 476.2 211.8 512 256 512c42.91 0 77.64-33.87 79.63-76.29l229.9-84.7C573.8 347.1 578.1 338.8 575 330.5zM256 480c-26.47 0-48-21.53-48-48s21.54-47.1 48-47.1S304 405.5 304 432S282.5 480 256 480zM286.7 302.7c6.545 19.64 24.84 32.83 45.53 32.83c5.154 0 10.26-.832 15.18-2.471l131.3-43.76c12.16-4.055 22.02-12.6 27.75-24.07c5.734-11.47 6.658-24.48 2.605-36.64l-43.76-131.3c-6.545-19.64-24.84-32.83-45.53-32.83c-5.154 0-10.26 .832-15.18 2.471L273.3 110.7c-12.16 4.055-22.02 12.6-27.75 24.07C239.8 146.2 238.9 159.3 242.9 171.4L286.7 302.7zM274.2 149.1c1.939-3.879 5.139-6.654 9.252-8.025l131.3-43.76c1.654-.5508 3.359-.8301 5.068-.8301c6.895 0 12.99 4.4 15.18 10.95l43.76 131.3c1.371 4.115 1.072 8.34-.8672 12.22c-1.939 3.879-5.139 6.654-9.252 8.025l-131.3 43.76c-1.656 .5527-3.361 .832-5.07 .832c-6.895 0-12.99-4.4-15.18-10.95L273.3 161.3C271.9 157.2 272.2 152.1 274.2 149.1z"],
    "dolly-empty": [576, 512, [], "f473", "M575 330.5c-3.078-8.312-12.25-12.52-20.55-9.484l-223.9 82.5C319 373.4 290.1 352 256 352c-5.018 0-9.889 .5918-14.65 1.477L141.8 54.7C130.9 21.98 100.4 0 65.88 0H15.1C7.155 0 0 7.157 0 16S7.156 32 16 32h49.88c20.69 0 38.98 13.19 45.55 32.83l100.2 300.6C190.2 379.8 176 404.2 176 432C176 476.2 211.8 512 256 512c42.91 0 77.64-33.87 79.63-76.29l229.9-84.7C573.8 347.1 578.1 338.8 575 330.5zM256 480c-26.47 0-48-21.53-48-48s21.53-47.1 47.1-47.1S304 405.5 304 432S282.5 480 256 480z"],
    "dolphin": [512, 512, [], "e168", "M436.9 136.9l-9.347-7.969c9.409-21.31 24.88-46.75 46.14-75.87c8.659-11.97 8.347-27.28-.719-38.97c-8.409-10.84-21.38-15.81-35.51-13.62c-41.95 6.594-82.28 19.12-120 37.31c-35.86-25.09-63.78-37.82-107.5-37.82L201.6 .0062c-82.1 0-153.4 55.94-167.3 132.1C29.9 157.1 31.4 181.5 38.75 205.5L21.21 217.2C3.673 228.9-4.048 250.3 2.079 270.4c6.158 20.41 24.13 33.59 45.77 33.59H399.1c8.847 0 16.01-7.156 16.01-15.1c0-8.844-7.159-15.1-16.01-15.1H47.84c-11 0-14.38-8.312-15.13-10.84C31.09 255.8 31.9 248.5 38.97 243.8l38.54-25.66L72.82 206.2C64.1 183.8 61.72 161.1 65.79 138.7c11.03-60.81 69.43-106.7 135.8-106.7h8.315c38.58 0 60.99 11.53 96.72 37.37l7.94 5.75l8.722-4.469c37.2-18.1 77.31-31.97 119.1-38.53c3.783-.5937 4.72 .875 5.408 2.156c-26.45 36.25-44.77 67.78-54.39 93.75L389.6 138.5l26.79 22.94c22.26 18.72 63.65 53.53 63.65 126.6c0 70.59-57.43 127.1-128 127.1H296.6l-31.17-48.06c-7.44-9.969-19.69-15.94-32.79-15.94H171.9c-10.91 0-20.6 5.812-25.29 15.19c-4.376 8.75-3.407 19.09 2.501 26.94l28.38 37.87l-28.35 37.81c-5.908 7.906-6.877 18.25-2.47 26.1C151.3 506.2 161.1 512 172 512H232.7c13.1 0 25.29-5.969 33.35-16.81l30.56-47.19h55.31C440.2 448 512 376.2 512 288C512 200 461.3 157.4 436.9 136.9zM239.8 476.9c-1.407 1.844-4.22 3.062-7.159 3.062H181.5l35.98-47.1l-35.98-47.1l51.19-.0008c2.938 0 5.707 1.22 6.489 2.188l29.67 45.81L239.8 476.9zM127.9 152c0 13.26 10.75 24 24.01 24c13.26 0 24.01-10.75 24.01-24c0-13.26-10.75-23.1-24.01-23.1C138.6 128 127.9 138.7 127.9 152z"],
    "dong-sign": [448, 512, [], "e169", "M400 448h-352C39.16 448 32 455.2 32 464S39.16 480 48 480h352c8.844 0 16-7.156 16-16S408.8 448 400 448zM224 400c38.41 0 72.52-17.35 96-44.23V384c0 8.844 7.156 16 16 16S352 392.8 352 384V112h16C376.8 112 384 104.8 384 96s-7.156-16-16-16H352v-32C352 39.16 344.8 32 336 32S320 39.16 320 48v32h-80C231.2 80 224 87.16 224 96s7.156 16 16 16H320v76.23C296.5 161.4 262.4 144 224 144c-70.58 0-128 57.41-128 128S153.4 400 224 400zM224 176c52.94 0 96 43.06 96 96s-43.06 96-96 96s-96-43.06-96-96S171.1 176 224 176z"],
    "door-closed": [576, 512, [62762], "1f6aa", "M560 480H480V80C480 35.88 444.1 0 400 0h-224C131.9 0 96 35.88 96 80V480H16C7.164 480 0 487.2 0 496C0 504.8 7.164 512 16 512h544c8.836 0 16-7.164 16-16C576 487.2 568.8 480 560 480zM448 480H128V80C128 53.53 149.5 32 176 32h224C426.5 32 448 53.53 448 80V480zM384 232c-13.25 0-24 10.75-24 24S370.7 280 384 280S408 269.3 408 256S397.3 232 384 232z"],
    "door-open": [576, 512, [], "f52b", "M232 224c-13.25 0-24 14.33-24 31.1S218.7 288 232 288S256 273.7 256 256S245.3 224 232 224zM260.4 1.443l-160 40C78.1 46.79 64 65.1 64 88.03V480H16C7.164 480 0 487.2 0 496C0 504.8 7.164 512 16 512H288c17.67 0 32-14.33 32-32V49.15c0-10.14-2.611-20.34-8.523-28.59C299.4 3.707 279.3-3.279 260.4 1.443zM288 480H96V88.04c0-7.373 5-13.75 12.12-15.53l160-40C272.9 31.22 277.9 32.38 281.8 35.41C285.8 38.47 288 43.07 288 48.04V480zM560 480H512V144c0-44.18-35.82-79.1-79.1-79.1H368c-8.836 0-16 7.162-16 15.1s7.164 16 16 16h64c26.51 0 48 21.49 48 48V480c0 17.67 14.33 32 32 32h48c8.836 0 16-7.164 16-15.1C576 487.2 568.8 480 560 480z"],
    "dove": [512, 512, [62650], "1f54a", "M248 159.3c-4.97 0-9.862-2.313-12.99-6.626C220.6 132.6 208.5 111.2 199.2 88.71c-3.001 6.907-5.798 13.94-7.986 20.41C188.3 117.5 179.2 121.9 170.9 119.1C162.5 116.3 158 107.2 160.8 98.81c7.377-21.69 19.65-46.75 27.44-59.29C191.7 34.14 197.1 31.39 204.1 32.11c6.283 .9063 11.44 5.407 13.16 11.53c9.08 32.35 23.79 62.72 43.7 90.32c5.173 7.188 3.563 17.19-3.61 22.35C254.6 158.4 251.3 159.3 248 159.3zM359.1 159.1c0 13.13 10.88 24 24.01 24s24.01-10.88 24.01-24c0-13.31-10.88-24-24.01-24S359.1 146.7 359.1 159.1zM512 63.97l-32 95.95l.002 128.2c0 88.37-71.62 159.9-160 159.9l-53.17 .1683l-63.89 54.75C200.4 505.2 191.2 512.6 177.7 511.1c-105.5-4.358-154.6-55.85-174.6-86.64c-7.013-10.78-1.653-25.19 10.83-28.31l128.6-32.18C41.64 283.2 31.32 195.1 31.94 153.1C32.45 112.1 41.76 75.1 57.76 41.09c5.826-12.38 23.7-11.86 29.21 .6633c57.44 130.6 185.3 155.4 200.1 158.2v-40.39c0-52.79 42.8-95.59 95.6-95.59c.1426 0 .2924 .0163 .435 .0163L512 63.97zM467.6 95.93h-83.64l-.3653 .0371c-35.09 .2031-63.65 28.84-63.65 64.09v78.13C299.1 235.8 156.3 226.2 74.15 87.05C67.65 108.6 64.15 130.7 63.9 153.4c-1.625 122.9 100.9 188.3 148.5 227l-170.8 42.75c21.51 24.5 62.76 53.75 137.4 56.88c.7502 0 76.02-63.88 76.02-63.88h64.89c70.64 0 128-57.51 128-128V154.7L467.6 95.93z"],
    "down": [384, 512, ["arrow-alt-down"], "f354", "M112 64v176H32c-17.69 0-32 14.36-32 31.1C0 280.3 3.252 288.5 9.375 294.6l160 176C175.6 476.9 183.8 480 192 480s16.38-3.125 22.62-9.375l160-176C380.7 288.5 384 280.3 384 271.1C384 254.4 369.7 240 352 240h-80V64c0-17.67-14.33-32-32-32h-96C126.3 32 112 46.33 112 64zM240 64v208l110.9 1.1L192 447.9L32 272H144V64H240z"],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", "M314.4 272H256V156.8C256 132.1 235.9 112 211.2 112H172.8C148.1 112 128 132.1 128 156.8V272H69.59c-15 0-28.53 8.906-34.53 22.75c-5.938 13.8-3.125 29.78 7.062 40.55l122.5 133.2C171.5 475.8 181.5 480 192 480s20.47-4.188 27.5-11.66l122.2-132.9c10.34-10.92 13.16-26.91 7.219-40.77C342.9 280.9 329.4 272 314.4 272zM318.3 313.6l-122.2 132.9c-1.75 1.812-6.594 1.656-8.031 .1562L65.53 313.5C64 311.8 63.56 309.5 64.44 307.4C65.34 305.3 67.38 304 69.59 304H160V156.8C160 149.8 165.8 144 172.8 144h38.38C218.3 144 224 149.8 224 156.8V304h90.41c2.219 0 4.25 1.344 5.156 3.375C320.4 309.5 320 311.8 318.3 313.6zM368 32h-352C7.156 32 0 39.16 0 48S7.156 64 16 64h352C376.8 64 384 56.84 384 48S376.8 32 368 32z"],
    "down-left": [384, 512, [], "e16a", "M358.6 157.3l-67.88-67.88C284.5 83.13 276.3 80 268.1 80s-16.38 3.125-22.63 9.375L119.1 215.7L57.21 153.8C50.8 147.4 42.22 144 33.5 144c-4.316 0-8.668 .8359-12.81 2.551C8.158 151.7 0 163.9 0 177.5v236.1c0 9.254 3.75 17.63 9.812 23.7C15.88 444.3 24.25 448 33.51 448h236.1c13.56 0 25.77-8.156 30.96-20.69c5.184-12.52 2.314-26.94-7.268-36.52l-61.92-61.92l126.4-126.4C371.1 190 371.1 169.8 358.6 157.3zM335.1 179.9l-148.1 148.1l84.54 84.55c.4297 .4297 .5605 1.09 .3281 1.648C271.7 415.6 271.1 416 270.5 416H33.51L32 414.5V177.5C32 176.9 32.36 176.4 32.94 176.1l1.645 .332l84.54 84.54l148.1-148.1L335.1 179.9z"],
    "down-left-and-up-right-to-center": [512, 512, ["compress-alt"], "f422", "M304 240h111.1c13 0 24.59-7.766 29.56-19.77s2.25-25.69-6.938-34.86l-44.67-44.67l97.39-97.39c6.248-6.25 6.248-16.38 0-22.62c-6.248-6.25-16.38-6.25-22.62 0l-97.38 97.38L326.6 73.39c-6.156-6.125-14.28-9.375-22.59-9.375c-4.125 0-8.312 .8125-12.28 2.453C279.8 71.45 272 83.05 272 96.03V208C272 225.7 286.3 240 304 240zM304 96.03l112 111.1c0 0 .0938 0 0 0L304 208V96.03zM208 272H96.03c-13 0-24.59 7.766-29.56 19.77s-2.25 25.69 6.938 34.86l44.67 44.67l-97.39 97.39c-6.248 6.25-6.248 16.38 0 22.62c6.248 6.25 16.38 6.25 22.62 0l97.38-97.38l44.68 44.68c6.156 6.125 14.28 9.375 22.59 9.375c4.125 0 8.312-.8125 12.28-2.453C232.3 440.5 240 428.1 240 415.1V304C240 286.3 225.7 272 208 272zM208 415.1L95.95 304c0 0-.0938 0 0 0L208 304V415.1z"],
    "down-long": [320, 512, ["long-arrow-alt-down"], "f309", "M136 0h47.1c22.06 0 39.1 17.97 39.1 40.03l.0012 280.3l39.1 .1514c15.91 0 30.31 9.438 36.65 24c6.375 14.62 3.5 31.56-7.343 43.22l-103.1 112.1c-7.533 8.158-18.42 12.24-29.31 12.23c-10.89-.002-21.78-4.08-29.34-12.23l-103.1-112.1c-10.84-11.66-13.72-28.59-7.343-43.22c6.343-14.56 20.75-24 36.65-24l39.1-.1514l.0008-280.3C96 17.97 113.9 0 136 0zM160 480.6c1.312 0 3.781-.3438 5.844-2.562l104-112.1c4.7-5.109 1.142-13.47-5.875-13.47h-71.1l-.0002-312.5C191.1 35.59 188.4 32 183.1 32H136C131.6 32 128 35.59 128 40.03l.0002 312.5H56c-7.022 0-10.57 8.363-5.875 13.47l103.1 112.1C156.2 480.2 158.7 480.6 160 480.6z"],
    "down-right": [384, 512, [], "e16b", "M25.37 202.5l126.4 126.4l-61.92 61.92c-9.582 9.578-12.45 24-7.268 36.52C87.74 439.8 99.95 448 113.5 448h236.1c9.258 0 17.63-3.75 23.7-9.812c6.062-6.066 9.812-14.44 9.812-23.7V177.5c0-13.57-8.158-25.77-20.69-30.96C359.2 144.8 354.8 144 350.5 144c-8.723 0-17.3 3.406-23.71 9.816l-61.92 61.92L138.5 89.38C132.3 83.13 124.1 80 115.9 80S99.5 83.13 93.25 89.38L25.37 157.3C12.88 169.8 12.87 190 25.37 202.5zM115.9 112l148.1 148.1l84.54-84.54l1.645-.332c.5781 .2422 .9375 .7773 .9375 1.402v236.1L350.5 416H113.5c-.625 0-1.164-.3594-1.398-.9297c-.2324-.5586-.1016-1.219 .3281-1.648l84.54-84.55L48 179.9L115.9 112z"],
    "down-to-line": [384, 512, ["arrow-alt-to-bottom"], "f34a", "M164.7 388.5C171.5 395.8 181.5 400 192 400s20.47-4.188 27.5-11.66l122.2-132.9c10.34-10.92 13.16-26.91 7.219-40.77C342.9 200.9 329.4 192 314.4 192L256 192.1V76.83C256 52.11 235.9 32 211.2 32H172.8C148.1 32 128 52.11 128 76.83v115.3L69.59 192c-15 0-28.53 8.906-34.53 22.75C29.13 228.5 31.94 244.5 42.13 255.3L164.7 388.5zM64.44 227.4C65.34 225.3 67.38 224 69.59 224H160V76.83C160 69.75 165.8 64 172.8 64h38.38C218.3 64 224 69.75 224 76.83V224h90.41c2.219 0 4.25 1.344 5.156 3.375C320.4 229.5 320 231.8 318.3 233.6l-122.2 132.9c-1.75 1.812-6.594 1.656-8.031 .1562L65.53 233.5C64 231.8 63.56 229.5 64.44 227.4zM368 448h-352C7.156 448 0 455.2 0 464S7.156 480 16 480h352c8.844 0 16-7.156 16-16S376.8 448 368 448z"],
    "download": [512, 512, [], "f019", "M245.4 379.1C248.4 382.7 252.2 384 256 384s7.594-1.344 10.62-4.047l144-128c6.594-5.859 7.219-15.98 1.344-22.58c-5.875-6.625-16.06-7.234-22.59-1.328L272 332.4V16C272 7.156 264.8 0 256 0S240 7.156 240 16v316.4L122.6 228C116.1 222.1 105.9 222.8 100 229.4C94.16 235.1 94.78 246.1 101.4 251.1L245.4 379.1zM448 320h-48c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16H448c17.67 0 32 14.33 32 32v64c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32v-64c0-17.67 14.33-32 32-32h48C120.8 352 128 344.8 128 336C128 327.2 120.8 320 112 320H64c-35.35 0-64 28.65-64 64v64c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64v-64C512 348.7 483.3 320 448 320zM440 416c0-13.25-10.75-24-24-24s-24 10.75-24 24s10.75 24 24 24S440 429.3 440 416z"],
    "dragon": [640, 512, [63189], "1f409", "M535.6 251.8c-37.84-21.48-55.67-33.55-55.67-51.42L479.1 192h16.95l28.6 21.99C533.8 220.5 543.1 224 554.8 224h29.25c21.04 0 39.93-14.15 45.93-34.41l7.398-25.2c5.859-19.78 1.898-41.45-10.62-57.89l-56.86-74.85C554.9 11.84 531 0 506.1 0h-168.8C323.7 0 311.6 8.572 307.1 21.38C302.6 34.2 306.7 48.46 317.3 56.96l18.1 14.53l-11.66 4.814C311.7 81.27 303.8 93.03 303.9 106.1S311.9 130.8 324 135.6l28.01 11.2v90.96c0 16.77 .5098 33.65 2.17 50.25H172.2l62.05-51.72C239.7 231.8 241.5 224.3 238.8 217.9S229.6 207.6 222.6 208.1L94.99 219.7l99.1-88.06l102 58.31C303.8 194.2 313.5 191.6 317.9 183.9c4.391-7.656 1.719-17.44-5.953-21.84l-112-64C194 94.69 186.5 95.47 181.4 100l-144 128c-5.172 4.594-6.797 12-4.062 18.31c2.75 6.344 9.109 9.906 16.14 9.594l124.9-11.34L117.8 291.7C112.6 296 110.7 303.1 113 309.4C115.3 315.8 121.3 320 128.1 320h231.3c5.566 23.76 15.17 46.25 32.17 65.92c-62.21 4.053-179.7 16.83-367.2 63.01c-15.71 3.869-26.07 18.86-24.12 34.93C2.184 499.9 15.82 512 32 512H506.9c42.06 0 83.75-20.48 108.8-53.44c23.08-30.36 29.97-68.09 19.39-106.2C620.5 299.1 573.4 273.3 535.6 251.8zM506.9 480H32c230.5-56.75 352.6-62.38 400.5-64c15.5-.5 21.25-20.88 8.25-29.38c-49-32.25-56.72-80.88-56.72-148.9V136c0-6.625-3.875-12.5-10-14.88l-38.13-15.25l36.63-15.12c5.25-2.125 9-6.875 9.75-12.5c.875-5.5-1.375-11.12-5.75-14.75L337.3 32h168.8c14.88 0 29.25 7.125 38.25 19l56.88 74.88c6.377 8.375 8.377 19.38 5.377 29.5L599.3 180.5C597.3 187.3 591 192 584 192h-29.25c-3.5 0-6.875-1.125-9.75-3.375l-33-25.38C509.3 161.1 505.9 160 502.3 160H470.7l-27.31-27.31c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l27.15 27.15v17.91c0 38.38 34.88 58.25 71.88 79.25c36.13 20.5 73.5 41.88 84.5 81.25C623.6 430.8 563.1 480 506.9 480zM480.9 86.31l32 16C515.2 103.5 517.6 104 520 104c5.875 0 11.52-3.25 14.33-8.844c3.953-7.906 .75-17.5-7.156-21.47l-32-16c-7.891-3.969-17.5-.7187-21.47 7.156C469.8 72.75 472.1 82.34 480.9 86.31z"],
    "draw-circle": [512, 512, [], "f5ed", "M512 256c0-33.5-25.88-60.75-58.63-63.5C432.9 129 383 79.12 319.5 58.62C316.8 25.88 289.5 0 256 0S195.2 25.88 192.5 58.62C129 79.12 79.12 129 58.62 192.5C25.88 195.2 0 222.5 0 256s25.88 60.75 58.62 63.5c20.5 63.5 70.38 113.4 133.9 133.9C195.2 486.1 222.5 512 256 512s60.75-25.88 63.5-58.63c63.5-20.5 113.4-70.38 133.9-133.9C486.1 316.8 512 289.5 512 256zM256 32c17.62 0 32 14.38 32 32s-14.38 32-32 32C238.4 96 224 81.62 224 64S238.4 32 256 32zM32 256c0-17.62 14.38-32 32-32s32 14.38 32 32S81.62 288 64 288S32 273.6 32 256zM256 480c-17.62 0-32-14.38-32-32s14.38-32 32-32c17.62 0 32 14.38 32 32S273.6 480 256 480zM314.1 421.5C304 399.4 281.9 384 256 384c-25.88 0-48 15.38-58.12 37.5C147.8 403.9 108.1 364.2 90.5 314.1C112.6 304 128 281.9 128 256S112.6 208 90.5 197.9C108.1 147.8 147.8 108.1 197.9 90.5C208 112.6 230.1 128 256 128c25.88 0 48-15.38 58.13-37.5c50.12 17.62 89.75 57.25 107.4 107.4C399.4 208 384 230.1 384 256s15.38 48 37.5 58.13C403.9 364.2 364.2 403.9 314.1 421.5zM448 288c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S465.6 288 448 288z"],
    "draw-polygon": [448, 512, [], "f5ee", "M384 352c-6.25 0-12.25 1.25-18 2.875l-32.37-54C345 289.2 352 273.5 352 256s-7-33.25-18.38-44.88l32.37-54C371.8 158.8 377.8 160 384 160c35.38 0 64-28.62 64-64s-28.62-64-64-64c-29.75 0-54.63 20.5-61.75 48H125.8C118.6 52.5 93.75 32 64 32C28.62 32 0 60.62 0 96c0 29.75 20.5 54.62 48 61.75v196.5C20.5 361.4 0 386.2 0 416c0 35.38 28.62 64 64 64c29.75 0 54.62-20.5 61.75-48h196.5c7.125 27.5 32 48 61.75 48c35.38 0 64-28.62 64-64S419.4 352 384 352zM80 354.2V157.8C102.4 152 119.9 134.4 125.8 112h196.5c2.875 11 8.375 21 16.13 28.88l-32.38 54C300.2 193.2 294.2 192 288 192c-35.38 0-64 28.62-64 64s28.62 64 64 64c6.25 0 12.25-1.25 17.1-2.875l32.38 54C330.6 379 325.1 389 322.2 400H125.8C119.9 377.6 102.4 360.1 80 354.2zM288 288c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S305.6 288 288 288zM384 64c17.62 0 32 14.38 32 32s-14.38 32-32 32s-32-14.38-32-32S366.4 64 384 64zM32 96c0-17.62 14.38-32 32-32s32 14.38 32 32S81.62 128 64 128S32 113.6 32 96zM64 448c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S81.62 448 64 448zM384 448c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S401.6 448 384 448z"],
    "draw-square": [448, 512, [], "f5ef", "M400 354.2V157.8C427.5 150.6 448 125.8 448 96c0-35.38-28.62-64-64-64c-29.75 0-54.63 20.5-61.75 48H125.8C118.6 52.5 93.75 32 64 32C28.62 32 0 60.62 0 96c0 29.75 20.5 54.62 48 61.75v196.5C20.5 361.4 0 386.2 0 416c0 35.38 28.62 64 64 64c29.75 0 54.62-20.5 61.75-48h196.5c7.125 27.5 32 48 61.75 48c35.38 0 64-28.62 64-64C448 386.2 427.5 361.4 400 354.2zM322.2 400H125.8C120 377.6 102.4 360.1 80 354.2V157.8C102.4 152 119.9 134.4 125.8 112h196.5C328.1 134.4 345.6 151.9 368 157.8v196.5C345.6 360.1 328.1 377.6 322.2 400zM384 64c17.62 0 32 14.38 32 32s-14.38 32-32 32s-32-14.38-32-32S366.4 64 384 64zM32 96c0-17.62 14.38-32 32-32s32 14.38 32 32S81.62 128 64 128S32 113.6 32 96zM64 448c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S81.62 448 64 448zM384 448c-17.62 0-32-14.38-32-32s14.38-32 32-32s32 14.38 32 32S401.6 448 384 448z"],
    "dreidel": [448, 512, [], "f792", "M443.3 36.69c-6.25-6.25-16.35-6.25-22.6 .0002l-119.9 119.9l-83.31-83.2C210.1 66.88 202.4 63.63 193.9 63.63c-8.5 0-17.12 3.25-23.62 9.75L19.62 223.1C6.999 236.5 0 253.5 0 271.3v141.9C0 450.1 29.87 480 66.87 480h141.9c17.62 0 34.63-7.002 47.26-19.63l150.7-150.6c12.1-13.12 12.1-34.25 0-47.38l-83.29-83.19l119.8-119.1C449.5 52.98 449.6 42.94 443.3 36.69zM233.4 437.8C226.7 444.4 218.1 448 208.7 448H66.87c-19.25 0-34.87-15.62-34.87-34.88V271.3c0-9.25 3.625-18 10.25-24.62l59.37-59.38l191.1 191.1L233.4 437.8zM383.1 287.1l-68.75 68.63L124.2 164.6L192.9 96C192.1 95.88 193.2 95.63 193.9 95.63L194.9 96l189.1 189.1C384.6 285.6 384.6 286.6 383.1 287.1z"],
    "drone": [512, 512, [], "f85f", "M370.8 163.9l21.5-21.5C394.8 143.1 397.3 144 400 144c17.62 0 32-14.38 32-32s-14.38-32-32-32s-32 14.38-32 32c0 2.75 .875 5.25 1.625 7.75l-21.5 21.5C336.1 153.3 319.9 160 302.9 160H209.1c-17 0-33.25-6.75-45.25-18.75l-21.5-21.5C143.1 117.3 144 114.8 144 112c0-17.62-14.38-32-32-32s-32 14.38-32 32s14.38 32 32 32c2.75 0 5.25-.875 7.75-1.625l21.5 21.5C153.3 175.9 160 192.1 160 209.1v93.75c0 17-6.75 33.25-18.75 45.25l-21.5 21.5C117.3 368.9 114.8 368 112 368c-17.62 0-32 14.38-32 32s14.38 32 32 32s32-14.38 32-32c0-2.75-.875-5.25-1.625-7.75l21.5-21.5C175.9 358.8 192.1 352 209.1 352h93.75c17 0 33.25 6.75 45.25 18.75l21.5 21.5C368.9 394.8 368 397.3 368 400c0 17.62 14.38 32 32 32s32-14.38 32-32s-14.38-32-32-32c-2.75 0-5.25 .875-7.75 1.625l-21.5-21.5C358.8 336.1 352 319.9 352 302.9V209.1C352 192.1 358.8 175.9 370.8 163.9zM320 320H192V192h128V320zM93.34 222.5C94.25 222.6 95.16 222.7 96.03 222.7c7.656 0 14.44-5.531 15.75-13.36C113.3 200.6 107.4 192.4 98.66 190.9C60.03 184.4 32 151.2 32 112C32 67.89 67.88 32 112 32c39.25 0 72.44 28.03 78.91 66.66c1.469 8.75 9.875 14.42 18.44 13.12c8.719-1.469 14.59-9.719 13.12-18.44C213.4 39.27 166.9 0 112 0C50.25 0 0 50.25 0 112C0 166.9 39.25 213.4 93.34 222.5zM302.7 111.8c8.594 1.328 16.97-4.375 18.44-13.12C327.6 60.03 360.8 32 400 32C444.1 32 480 67.89 480 112c0 39.23-28.03 72.41-66.66 78.89c-8.719 1.469-14.59 9.719-13.12 18.44c1.312 7.812 8.094 13.34 15.75 13.34c.9062 0 1.781-.0781 2.688-.2187C472.8 213.4 512 166.9 512 112C512 50.25 461.8 0 400 0c-54.94 0-101.4 39.27-110.5 93.34C288.1 102.1 293.9 110.3 302.7 111.8zM418.7 289.5c-8.812-1.562-16.97 4.406-18.44 13.14c-1.469 8.719 4.406 16.95 13.12 18.42C451.1 327.6 480 360.8 480 400c0 44.11-35.88 80-80 80c-39.25 0-72.44-28.03-78.91-66.66c-1.469-8.734-9.875-14.45-18.44-13.12c-8.719 1.469-14.59 9.719-13.12 18.44C298.6 472.7 345.1 512 400 512c61.75 0 112-50.25 112-112C512 345.1 472.8 298.6 418.7 289.5zM209.3 400.2c-8.5-1.297-16.97 4.391-18.44 13.12C184.4 451.1 151.3 480 112 480C67.88 480 32 444.1 32 400c0-39.23 28.03-72.41 66.66-78.89C107.4 319.6 113.3 311.4 111.8 302.7C110.3 293.9 101.9 288.3 93.34 289.5C39.25 298.6 0 345.1 0 400C0 461.8 50.25 512 112 512c54.94 0 101.4-39.27 110.5-93.34C223.9 409.9 218.1 401.7 209.3 400.2z"],
    "drone-front": [640, 512, ["drone-alt"], "f860", "M624 128H512V112C512 103.2 504.8 96 496 96S480 103.2 480 112V128h-112C359.2 128 352 135.2 352 144C352 152.8 359.2 160 368 160H480v78.67C446.5 220.5 383.9 192 320 192S193.5 220.5 160 238.7V160h112C280.8 160 288 152.8 288 144C288 135.2 280.8 128 272 128H160V112c0-8.844-7.156-15.94-16-15.94S128 103.2 128 112V128H16C7.164 128 0 135.2 0 144C0 152.8 7.164 160 16 160H128v112c0 17.64 14.34 32 32 32h9.402C152.1 333.2 144 366.3 144 400c0 8.844 7.231 16 16.07 16S176 408.8 176 400c0-34.49 11.46-68.14 31.73-96h18.36l51.5 44.14C280.5 350.6 284.2 352 288 352h64c3.812 0 7.5-1.359 10.41-3.859L413.9 304h18.36C452.5 331.9 464 365.5 464 400c0 8.844 7.056 16 15.9 16S496 408.8 496 400c0-33.68-8.963-66.82-25.4-96H480c17.66 0 32-14.36 32-32V160h112C632.8 160 640 152.8 640 144C640 135.2 632.8 128 624 128zM408 272c-3.812 0-7.5 1.359-10.41 3.859L346.1 320H293.9l-51.5-44.14C239.5 273.4 235.8 272 232 272H166.1C192.1 256.6 257.1 224 320 224s127 32.56 153.9 48H408z"],
    "droplet": [384, 512, [61507, "tint"], "1f4a7", "M192 416c-44.13 0-80-35.87-80-79.1c0-8.875-7.125-16-16-16s-16 7.125-16 16c0 61.75 50.25 111.1 112 111.1c8.875 0 16-7.125 16-16S200.9 416 192 416zM221.3 22.13C217.3 7.501 204.6 0 191.1 0C179.6 0 167.3 7.251 162.8 22.13C116 179.9 16 222.8 16 333.9c0 98.5 78.75 178.1 176 178.1s176-79.62 176-178.1C368 222.1 268.3 180.6 221.3 22.13zM192 480c-79.38 0-144-65.5-144-146.1C48 285.5 71 252.6 102.9 207C132 165.1 168.1 113.4 192 36c23.88 77.63 60.13 129.4 89.38 171.1C313 252.5 336 285.3 336 333.9C336 414.5 271.4 480 192 480z"],
    "droplet-degree": [448, 512, ["dewpoint"], "f748", "M191.1 32C180.7 32 169.5 38.32 165.4 51.36C122.9 189.3 32 226.9 32 324.1C32 410.2 103.6 480 192 480s160-69.78 160-155.9c0-97.78-90.73-134.1-133.4-272.8C214.9 38.6 203.5 32 191.1 32zM319.1 324.1C319.1 392.4 262.6 448 192 448s-128-55.56-128-123.9c0-40.71 20.56-69.07 49.01-108.3C138.7 180.4 170.3 136.9 191.1 73.17c21.85 64.08 53.46 107.5 79.16 142.9C299.5 255 319.1 283.2 319.1 324.1zM352 32c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S387.3 32 352 32zM352 128c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S369.6 128 352 128z"],
    "droplet-percent": [320, 512, ["humidity"], "f750", "M186.6 51.36c-3.631-12.77-15.08-19.36-26.57-19.36c-11.25 0-22.53 6.32-26.55 19.36C90.94 189.3 0 226.9 0 324.1c0 86.08 71.56 155.9 160 155.9s160-69.78 160-155.9C320 226.4 229.3 190 186.6 51.36zM160 448c-70.58 0-128-55.56-128-123.9c0-40.71 20.56-69.07 49.01-108.3C106.7 180.4 138.3 136.9 159.1 73.17c21.85 64.09 53.46 107.5 79.16 142.9C267.5 255 288 283.2 288 324.1C288 392.4 230.6 448 160 448zM128 264C128 250.7 117.3 240 104 240S80 250.7 80 264s10.69 23.1 24 23.1S128 277.3 128 264zM219.3 260.7c-6.25-6.25-16.38-6.25-22.62 0l-96 95.1c-6.25 6.25-6.25 16.37 0 22.62C103.8 382.4 107.9 383.1 112 383.1s8.188-1.562 11.31-4.688l96-95.1C225.6 277.1 225.6 266.9 219.3 260.7zM216 351.1c-13.31 0-24 10.69-24 23.1s10.69 23.1 24 23.1s24-10.69 24-23.1S229.3 351.1 216 351.1z"],
    "droplet-slash": [640, 512, ["tint-slash"], "f5c7", "M633.9 483.4l-608-480c-6.938-5.453-17-4.25-22.48 2.641c-5.469 6.938-4.281 17 2.641 22.48l608 480C617 510.9 620.5 512 623.1 512c4.734 0 9.422-2.094 12.58-6.078C642 498.1 640.8 488.9 633.9 483.4zM320 448c8.875 0 16-7.125 16-16S328.9 416 320 416c-44.13 0-80-35.88-80-80C240 327.1 232.9 320 224 320s-16 7.125-16 16C208 397.8 258.3 448 320 448zM320 36c23.88 77.63 60.13 129.4 89.38 171.1c18.45 26.48 33.79 48.69 43.52 72.23l41.73 32.95c-11.85-96.24-101.5-142.3-145.4-290.2C345.3 7.503 332.6 0 319.1 0c-12.38 0-24.74 7.253-29.24 22.13c-11.3 38.14-25.74 69.47-41.11 96.76l25.35 20.01C291.5 110.1 307.5 76.66 320 36zM320 480c-79.38 0-144-65.5-144-146.1c0-33.46 11.16-59.55 28.49-87.53L179.2 226.4c-20.59 32.68-35.17 65.14-35.17 107.5C144 432.4 222.8 512 320 512c55.39 0 104.7-25.88 136.1-66.32l-25.65-20.25C404.9 458.4 365.1 480 320 480z"],
    "drum": [512, 512, [62825], "1f941", "M414.5 117.5l90-56.28c7.25-4.753 9.25-14.38 4.75-21.76c-4.625-7.254-14.25-9.631-21.62-5.378l-116 72.54c-36.38-7.379-76.5-10.65-115.6-10.65C132.7 96 0 130.9 0 207.1v159.1C0 429.9 114.6 480 255.1 480s256-50.11 256-112V207.1C511.1 165.5 471.5 135.7 414.5 117.5zM96 421.5c-40.88-16.13-64-36.77-64-53.53V265.7c16.5 13.01 38.5 23.64 64 31.89V421.5zM240 447.6c-43.12-1.126-80.88-7.004-112-15.63V306.3c34.88 8.005 73.5 12.38 112 13.38V447.6zM384 431.1c-31.12 8.63-68.88 14.51-112 15.63V319.7c38.5-1.001 77.13-5.378 112-13.38V431.1zM480 367.9c0 16.76-23.12 37.4-64 53.53V297.6c25.5-8.255 47.5-18.89 64-31.89V367.9zM255.1 287.9C132.2 287.9 32 251.1 32 207.8s100.2-80.05 224-80.05c24.88 0 49.75 1.501 74.5 4.628l-99 61.79C224.4 199.1 222.2 208.7 226.9 216.1C231.4 223.3 241 225.7 248.5 221.3l129.1-80.67C439.1 154.9 480 179.7 480 207.8C480 251.1 379.7 287.9 255.1 287.9z"],
    "drum-steelpan": [576, 512, [], "f56a", "M288 32C129 32 0 89.25 0 160v192c0 70.75 129 128 288 128s288-57.25 288-128V160C576 89.25 447 32 288 32zM288 64c25.62 0 50.38 1.5 73.88 4.125l-15.5 59.1C341.9 145.8 315.6 160 288 160S234.1 145.8 229.6 128.1L214.1 68.12C237.6 65.5 262.4 64 288 64zM382.9 249.1C353.5 253.5 321.5 256 288 256C254.2 256 221.1 253.5 192.5 249c20.12-19.62 33.38-45.38 37.12-73.5C245.1 185.9 266.6 192 288 192c21 0 41.5-5.875 57.63-16C349.4 204.1 362.8 229.8 382.9 249.1zM178.2 73.38l17 60c12 42.75-7.625 86.75-44.75 107.5C79.38 223.9 32 194 32 160C32 121.8 91.88 88.75 178.2 73.38zM544 352c0 39.13-99.75 96-256 96s-256-56.88-256-96V218.5C79.75 259.8 176.4 288 288 288s208.3-28.25 256-69.5V352zM425.6 240.9c-36-18.75-56.63-59.88-47-101.1l15.62-67C482.5 87.88 544 121.2 544 160C544 194 496.8 223.8 425.6 240.9z"],
    "drumstick": [512, 512, [63190], "1f357", "M511.1 165.4c0-40.03-14.22-77.75-40.87-107.8C423.2 3.172 361.1 0 343.9 0c-45.28 0-89.37 17.88-121.4 49.81c-26.87 26.62-62.5 70.24-62.5 140.7v69.37L116.6 303.3c-2.022 2.021-5.246 3.624-9.437 3.624c-8.164 0-14.46-6.755-34.54-6.755C32.58 300.1 0 332.6 0 372.6c0 21.62 15.62 69.12 67.75 71.74C69.75 483.8 101.1 512 139.4 512c42.05 0 72.61-34.34 72.61-72.45c0-20.04-6.806-25.98-6.806-34.83c0-3.119 .8494-6.551 3.695-9.337l43.25-43.37h70.12c38.87 0 72.1-10.25 104.4-31.12C480.8 284.7 511.1 225.2 511.1 165.4zM186.2 372.8c-8.55 8.468-13.02 19.85-13.02 31.98c0 17.23 7.499 22.03 7.499 37.15c0 23.57-21.85 37.59-42.85 37.59c-18.76 0-36.86-11.18-38.12-36.73L98.24 413.9l-28.87-1.5c-24.73-1.221-36.99-20.39-36.99-39.69c0-20.37 13.32-40.56 40.97-40.56c4.838 0 9.657 .9968 14.14 2.885c6.376 2.559 13.07 3.877 19.68 3.877c11.79 0 23.3-4.191 32.19-13l25.1-25.1c8.124 21.62 25.25 38.75 46.87 46.87L186.2 372.8zM480 165.4c0 35.31-31.08 154.7-157.8 154.7l-82.1 .0006c-26.52 0-48.02-21.45-48.14-47.99V190.5c0-45.24 16.37-81.62 52.1-118.1c25.89-25.89 60.94-40.37 97.52-40.37l.4712 .0008c14.88 0 65.07 2.077 104.2 46.87C468.7 102.1 480 133.2 480 165.4z"],
    "drumstick-bite": [512, 512, [], "f6d7", "M471.2 57.62C423.6 3.25 362.3 0 344.3 0C222.9 0 160 114.7 160 190.5v69.37L116.6 303.3c-2.022 2.022-5.247 3.625-9.438 3.625c-8.165 0-14.46-6.756-34.55-6.756C32.58 300.1 0 332.6 0 372.6c0 21.62 15.62 69.12 67.75 71.74C69.75 483.8 101.1 512 139.4 512c42.06 0 72.61-34.34 72.61-72.45c0-20.04-6.807-25.98-6.807-34.83c0-3.119 .8494-6.551 3.695-9.337l43.37-43.37h70.13c17 0 34-2.25 50.38-6.874c5.335-1.368 11.82-6.483 11.82-15.35c0-2.897-.7654-5.8-2.322-8.394C373 306.6 368.1 289.5 368.1 272c0-52.99 43-95.87 96-95.99c16.61 0 26.61 5.189 31.84 5.189C503.5 181.2 512 175.5 512 165.2C512 124.7 497.7 87.5 471.2 57.62zM186.2 372.8c-8.551 8.469-13.02 19.86-13.02 31.98c0 17.23 7.499 22.03 7.499 37.15c0 23.57-21.85 37.59-42.88 37.59c-18.78 0-36.91-11.18-38.23-36.73l-1.375-28.87l-29-1.5c-24.67-1.221-36.93-20.39-36.93-39.69c0-20.31 13.27-40.56 41.03-40.56c4.838 0 9.658 .9968 14.14 2.885c6.376 2.559 13.08 3.877 19.69 3.877c11.79 0 23.3-4.191 32.19-13l26-25.1c8.125 21.62 25.25 38.75 47 46.87L186.2 372.8zM464.1 144c-70.63 .125-127.9 57.37-128 127.1c0 15.87 3.125 31.62 9 46.37c-7.5 1.125-15.13 1.625-22.75 1.625l-82.11 .0006c-26.52 0-48.02-21.45-48.27-47.1V190.5C192 145.3 208.4 108.9 245 72.42c25.89-25.89 60.95-40.37 97.53-40.37l.4713 .0008c14.79 0 65.2 2.077 104.4 46.87C464 97.42 474.8 120.4 478.4 145C473.8 144.4 468.9 144 464.1 144z"],
    "dryer": [448, 512, [], "f861", "M352 0H96C42.98 0 0 42.98 0 96v352c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 42.98 405 0 352 0zM416 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-35.29 28.71-64 64-64h256c35.29 0 64 28.71 64 64V448zM192.1 120C205.3 120 216 109.3 216 96S205.3 72 192.1 72C178.7 72 168 82.75 168 96S178.7 120 192.1 120zM120 96c0-13.25-10.69-24-24-24C82.82 72 72 82.75 72 96S82.82 120 96 120C109.3 120 120 109.3 120 96zM224 160C144.5 160 80.01 224.5 80.01 304S144.5 448 224 448s143.1-64.5 143.1-144S303.5 160 224 160zM224 416c-56.27 0-102.5-41.86-110.4-96H176C184.8 320 192 312.8 192 304S184.8 288 176 288H113.6C121.5 233.9 167.7 192 224 192c61.75 0 111.1 50.24 111.1 112S285.7 416 224 416z"],
    "dryer-heat": [448, 512, ["dryer-alt"], "f862", "M352 0H96C42.98 0 0 42.98 0 96v352c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 42.98 405 0 352 0zM416 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-35.29 28.71-64 64-64h256c35.29 0 64 28.71 64 64V448zM192.1 120C205.3 120 216 109.3 216 96S205.3 72 192.1 72C178.7 72 168 82.75 168 96S178.7 120 192.1 120zM120 96c0-13.25-10.69-24-24-24C82.82 72 72 82.75 72 96S82.82 120 96 120C109.3 120 120 109.3 120 96zM224 160C144.5 160 80.01 224.5 80.01 304S144.5 448 224 448s143.1-64.5 143.1-144S303.5 160 224 160zM224 416c-61.75 0-111.1-50.24-111.1-112S162.3 192 224 192c61.75 0 111.1 50.24 111.1 112S285.7 416 224 416zM212.6 350c-10.25-10.25-12.78-25.88-6.297-38.84c12.66-25.31 7.719-55.75-12.31-75.78L187.3 228.7c-6.25-6.25-16.38-6.25-22.62 0C158.4 234.1 158.4 245.1 164.7 251.3L171.4 258c10.25 10.25 12.78 25.88 6.297 38.84c-12.66 25.31-7.719 55.75 12.31 75.78l6.703 6.688C199.8 382.4 203.9 384 208 384s8.203-1.562 11.33-4.688c6.234-6.281 6.234-16.41-.0313-22.62L212.6 350zM276.6 350c-10.25-10.25-12.78-25.88-6.297-38.84c12.66-25.31 7.719-55.75-12.31-75.78l-6.703-6.688c-6.25-6.25-16.38-6.25-22.62 0c-6.234 6.281-6.234 16.41 .0313 22.62L235.4 258c10.25 10.25 12.78 25.88 6.297 38.84c-12.66 25.31-7.719 55.75 12.31 75.78l6.703 6.688C263.8 382.4 267.9 384 272 384s8.203-1.562 11.33-4.688c6.234-6.281 6.234-16.41-.0313-22.62L276.6 350z"],
    "duck": [640, 512, [63192], "1f986", "M576 128C576 119.2 568.8 112 560 112h-42.77C506.4 65.5 465.2 32 416 32C358.7 32 312 78.66 312 136c0 20.19 8.078 40.88 24 61.59V224c0 8.812-7.172 16-16 16h-14.61c-29.52 0-72.86-11.66-90.3-28.97C205.7 201.7 191.8 198.9 179.4 204.1C167.5 209 160 219.9 160 232.4c0 87.34 75.97 158.4 169.4 158.4c8.844 0 16-7.156 16-16s-7.156-16-16-16c-75.73 0-137.4-56.72-136.9-125.2C219.1 260.1 274.5 272 305.4 272h14.61c26.47 0 48-21.53 48-48V192c0-3.719-1.297-7.312-3.656-10.19C350.8 165.5 344 150.1 344 136c0-39.69 32.3-72 72-72c37.51 0 68.34 28.12 71.7 65.44C488.5 137.7 495.4 144 503.6 144h38.59c-7.859 35.56-41.06 64-78.23 64h-10.61c-5.594 0-10.78 2.906-13.67 7.688c-4.75 7.844-7.703 18.91-7.703 28.94c0 17.66 9.094 34.31 24.36 44.53c28.11 18.72 42.72 48.78 39.11 80.38C490.6 411.3 443.5 448 394.6 448H303.4c-108.3 0-199.4-78.06-207.2-176H120c8.844 0 16-7.156 16-16s-7.156-16-16-16H96.16c-9.188 0-17.97 3.781-24.09 10.38C66.3 256.6 63.44 264.5 64.05 272.8C73.36 388.9 178.5 480 303.4 480h91.25c65.12 0 125.9-48.91 132.6-106.8c5.016-43.78-14.86-85.16-53.11-110.6c-6.344-4.25-10.14-10.97-10.14-17.94c0-1.406 .1719-3.031 .4687-4.625C523.9 239.7 576 187.5 576 128zM432 128c0-8.875-7.126-16-15.1-16c-8.875 0-16 7.125-16 16S407.1 144 416 144C424.9 144 432 136.9 432 128z"],
    "dumbbell": [640, 512, [], "f44b", "M624 240H608V160c0-26.51-21.49-48-48-48h-32c-5.625 0-11 1.25-16 2.875V96c0-26.51-21.49-48-48-48h-32C405.5 48 384 69.49 384 96v144H256V96c0-26.51-21.49-48-48-48h-32C149.5 48 128 69.49 128 96v18.88C123 113.1 117.6 112 112 112h-32C53.49 112 32 133.5 32 160v80H16C7.199 240 0 247.2 0 256c0 8.797 7.199 16 16 16H32V352c0 26.51 21.49 48 48 48h32c5.625 0 11-1.25 16-2.875V416c0 26.51 21.49 48 48 48h32C234.5 464 256 442.5 256 416V272h128V416c0 26.51 21.49 48 48 48h32c26.51 0 48-21.49 48-48v-18.88C517 398.9 522.4 400 528 400h32c26.51 0 48-21.49 48-48V272h16C632.8 272 640 264.8 640 256C640 247.2 632.8 240 624 240zM128 352c0 8.75-7.25 16-16 16h-32C71.25 368 64 360.8 64 352V160c0-8.75 7.25-16 16-16h32C120.8 144 128 151.3 128 160V352zM224 416c0 8.75-7.25 16-16 16h-32C167.3 432 160 424.8 160 416V96c0-8.75 7.25-16 16-16h32C216.8 80 224 87.25 224 96V416zM480 416c0 8.75-7.25 16-16 16h-32c-8.75 0-16-7.25-16-16V96c0-8.75 7.25-16 16-16h32C472.8 80 480 87.25 480 96V416zM576 352c0 8.75-7.25 16-16 16h-32c-8.75 0-16-7.25-16-16V160c0-8.75 7.25-16 16-16h32C568.8 144 576 151.3 576 160V352z"],
    "dumpster": [576, 512, [], "f793", "M560 256h-26.75l3.562-32h-32.09l-21.19 192H92.47L71.28 224H39.06l3.562 32H16C7.199 256 0 263.2 0 272C0 280.8 7.199 288 16 288h30.25L64 448v16C64 472.8 71.16 480 80 480S96 472.8 96 464V448h384v16c0 8.836 7.164 16 16 16s16-7.164 16-16V448l17.75-160H560C568.8 288 576 280.8 576 272C576 263.2 568.8 256 560 256zM16 192h544c10.38 0 17.1-12.25 15.5-24.88l-32-120C541.8 38.25 535.3 32 528 32h-480C40.75 32 34.25 38.25 32.5 47.13l-32 120C-2 179.8 5.625 192 16 192zM514.3 64l27.12 96h-78.63L443.5 64H514.3zM304 64h106.9l19.25 96H304V64zM165.1 64H272v96H145.9L165.1 64zM61.75 64H132.5L113.2 160H34.63L61.75 64z"],
    "dumpster-fire": [640, 512, [], "f794", "M16 192l324.6 .0602c7.492-10.73 15.39-21.52 24.17-32.09H304L304 64h106.9l7.992 39.86l20.96-18.75l9.637 8.52L443.5 64h70.75l20.14 71.3l16.72-14.94l15.64 13.95L543.5 47.13C541.8 38.25 535.3 32 528 32h-480C40.75 32 34.25 38.25 32.5 47.13l-32 120C-2 179.8 5.625 192 16 192zM165.1 64H272l.0398 96.07H145.9L165.1 64zM61.75 64H132.5L113.3 160.1L34.63 160L61.75 64zM92.47 416L71.28 224H39.06l3.562 32H16C7.199 256 0 263.2 0 272c0 8.799 7.202 15.1 16 15.1L46.25 288l17.76 160L64.01 464C64.01 472.8 71.17 480 80.01 480S96 472.8 96 464V448l240.8 .0064C327.9 438.2 320 427.5 313.4 416H92.47zM551.2 163.3c-14.88 13.25-28.38 27.12-40.26 41.12c-19.5-25.75-43.64-51.98-71.01-76.36c-70.13 62.75-120 144.2-120 193.6C319.1 409.2 391.6 480 479.1 480s160-70.84 160-158.3C640.1 285 602.1 209.4 551.2 163.3zM494.3 446.6C489.5 447.1 485 448 480.1 448s-9.375-.875-14.13-1.375c-31.75-6.375-55.75-34.25-55.75-67.38c0-14 15.38-46.13 44.5-78.38c7.125 7.625 13.62 15.38 19.38 23l24.12 31.88l26-30.56c.125 0-.125 0 0 0c16.12 22.12 25.62 46.06 25.62 54.06C549.9 412.4 525.9 440.3 494.3 446.6zM579.8 400c1.375-6.75 2.125-13.75 2.125-20.75c0-23.38-23.5-71.5-56.5-100.9c-9.5 8.375-18 17.38-25.62 26.25C487.4 288.3 471.9 271.5 454.5 256c-44.63 39.88-76.38 91.88-76.38 123.3c0 7 .75 14 2.25 20.75c-17.5-21.62-28.5-48.75-28.5-78.38c0-31.62 32.5-93.25 88.13-149.5c16.88 16.62 32.25 34.25 45.38 51.63l24 31.88l26-30.5c4.875-5.875 9.875-11.38 15-16.88c34.38 40 57.5 91.5 57.5 113.4C608.1 351.4 597.3 378.4 579.8 400z"],
    "dungeon": [512, 512, [], "f6d9", "M512 296c0-9.125-3-17.5-8.125-24.25c5.375-7.25 8.188-16.31 7.938-25.44c-1.375-35.25-9.813-69.25-25.06-101c-4.5-9.375-12.5-16.31-22-19.94c.875-10.12-2.125-20.31-8.5-28.31c-21.25-26.88-47.31-48.81-77.31-65.31c-5.875-3.25-12.44-4.875-19.19-4.875c-3.5 0-6.875 .375-10.12 1.25C344.5 19.38 336.1 12.75 326.3 10C303.3 3.375 279.6 0 256 0S208.8 3.375 185.8 10C175.9 12.75 167.5 19.38 162.4 28.12C159.1 27.25 155.8 26.88 152.3 26.88c-6.625 0-13.31 1.625-19.19 4.875c-30 16.5-56.06 38.5-77.31 65.37c-6.375 8-9.375 18.12-8.5 28.25C37.75 129 29.75 135.9 25.25 145.3c-15.25 31.75-23.75 65.81-25.12 101.1c-.25 9.125 2.625 18.12 8 25.38C2.875 278.8 0 287.3 0 296v64c0 9 3 17.25 8 24C3 390.8 0 399 0 408v64C0 494 17.1 512 40 512h64c21.1 0 40-18 40-40v-64c0-9-3-17.25-8-24c5-6.75 8-15 8-24v-64c0-8.875-2.875-17.12-7.875-23.88c4.75-6.25 7.625-14 8-21.88c.75-12.62 3.75-25.12 9-37.38c2.75-6.25 3.75-12.75 3.25-19c6-2.375 11.5-6.125 15.75-11.12C179.5 174.5 188 167.3 197.4 161.4c5.75-3.5 10.25-8.25 13.38-13.75c3.25 .75 6.5 1.125 9.875 1.125s6.75-.375 10-1.25C240 145.1 248.1 144 256 144s16 1.125 25.38 3.5C284.6 148.4 288 148.8 291.4 148.8s6.625-.375 9.875-1.125c3.125 5.5 7.625 10.25 13.38 13.75c9.5 5.875 17.88 13.12 25.25 21.38c4.375 5 9.75 8.75 15.75 11.12c-.5 6.25 .5 12.75 3.25 18.88c5.25 12.38 8.25 24.88 9 37.5c.5 8.25 3.375 15.75 8 21.88C370.8 279 368 287.4 368 296v64c0 9 3 17.25 8 24c-5 6.625-8 15-8 24v64c0 22 17.1 40 40 40h64c22.12 0 40-18 40-40v-64c0-9-3-17.38-8-24c5-6.75 8-15 8-24V296zM112 472C112 476.4 108.4 480 104 480h-64C35.63 480 32 476.4 32 472v-64c0-4.375 3.625-8 8-8h64c4.375 0 8 3.625 8 8V472zM112 360c0 4.375-3.625 8-8 8h-64C35.63 368 32 364.4 32 360V295.1C32 291.6 35.63 288 40 288h64C108.4 288 112 291.6 112 296V360zM123.8 200.1c-6.375 15-10.62 31.25-11.5 48.25C112 252.6 108.8 256 104.5 256H40.38C35.88 256 32 252.1 32.13 247.5c1.25-31.5 9-61.38 22-88.25c1.375-2.875 4.25-4.5 7.25-4.5c1.5 0 3 .375 4.375 1.25l55.13 34.38C124.1 192.5 125.4 196.6 123.8 200.1zM180.5 134.3c-12.12 7.5-23 16.75-32.38 27.5C146.5 163.5 144.3 164.5 141.1 164.5c-1.375 0-2.75-.375-4-1.125L83 129c-4.125-2.625-5.25-8.25-2.25-12C99.38 93.63 122.4 74.13 148.5 59.75C149.8 59.13 151 58.88 152.3 58.88C155.5 58.88 158.8 60.75 160 64l23.75 60.63C185.3 128.3 183.8 132.1 180.5 134.3zM298.9 111.9c-1.25 3.125-4.25 4.875-7.5 4.875c-.625 0-1.375 0-2-.25C277.5 113.5 266.8 112 256 112S234.5 113.5 222.8 116.5c-.7505 .25-1.5 .25-2.125 .25c-3.25 0-6.25-1.75-7.5-4.875L189.4 51.5C187.8 47.13 190.1 42 194.6 40.75C214.1 35.13 234.8 32 256 32s41.88 3.125 61.38 8.75c4.625 1.25 7 6.375 5.25 10.75L298.9 111.9zM373.1 163.4c-1.25 .75-2.625 1.125-4 1.125c-2.25 0-4.5-1-6.125-2.75c-9.375-10.75-20.25-20-32.38-27.5c-3.25-2.125-4.75-6-3.25-9.625L352 64.13c1.25-3.25 4.5-5.25 7.75-5.25c1.25 0 2.5 .25 3.75 .875c26.12 14.5 49.13 33.88 67.75 57.25c3 3.75 1.875 9.5-2.25 12L373.1 163.4zM388.3 200.1c-1.625-3.5-.375-7.625 2.875-9.75L446.3 156c1.25-.875 2.75-1.25 4.375-1.25c3 0 5.875 1.625 7.25 4.5c13 26.88 20.75 56.75 22 88.25C480 252.1 476.1 256 471.6 256H407.5C403.3 256 400 252.6 399.8 248.4C398.9 231.4 394.6 215.1 388.3 200.1zM480 472c0 4.375-3.625 8-8 8h-64c-4.375 0-8-3.625-8-8v-64c0-4.375 3.625-8 8-8h64c4.375 0 8 3.625 8 8V472zM480 360c0 4.375-3.625 8-8 8h-64c-4.375 0-8-3.625-8-8v-64C400 291.6 403.6 288 408 288h64C476.4 288 480 291.6 480 295.1V360zM256 192C247.2 192 240 199.2 240 208v256c0 8.844 7.156 15.1 16 15.1S272 472.8 272 464v-256C272 199.2 264.8 192 256 192zM320 224c-8.844 0-16 7.156-16 16v224c0 8.844 7.156 15.1 16 15.1S336 472.8 336 464v-224C336 231.2 328.8 224 320 224zM192 224C183.2 224 176 231.2 176 240v224c0 8.844 7.156 15.1 16 15.1S208 472.8 208 464v-224C208 231.2 200.8 224 192 224z"],
    "e": [320, 512, [101], "45", "M320 464c0 8.844-7.156 16-16 16h-288C7.156 480 0 472.8 0 464v-416C0 39.16 7.156 32 16 32h288C312.8 32 320 39.16 320 48S312.8 64 304 64H32v176h208c8.844 0 16 7.162 16 16.01C256 264.8 248.8 272 240 272H32V448h272C312.8 448 320 455.2 320 464z"],
    "ear": [384, 512, [62960], "1f442", "M192 0C86 0 0 86 0 192v176C0 447.5 64.5 512 144 512s144-64.5 144-144v-9.875C345.4 324.9 384 263 384 192C384 86 298 0 192 0zM271.1 330.4C262.1 336.2 256 346.7 256 358.1V368c0 61.76-50.24 112-112 112S32 429.8 32 368V192c0-88.22 71.78-160 160-160s160 71.78 160 160C352 248.8 321.3 301.8 271.1 330.4zM280.1 99.11c-26.05-24.69-59.87-37.34-94.96-34.94C118.3 67.67 64 128.1 64 198.8V240C64 248.8 71.16 256 80 256h6.062C100.4 256 112 267.6 112 281.9c0 6.906-2.703 13.44-7.594 18.34l-38.06 38.06c-6.25 6.25-6.25 16.38 0 22.62c3.125 3.125 7.219 4.688 11.31 4.688s8.188-1.562 11.31-4.688l38.08-38.06C137.1 311.9 144 297.4 144 281.9c0-28.56-20.77-52.38-48-57.09V198.8c0-53.97 40.73-100 90.95-102.7c26.47-1.531 51.58 7.656 71.11 26.19C277.4 140.7 288 165.4 288 192c0 8.844 7.156 16 16 16S320 200.8 320 192C320 156.5 305.8 123.5 280.1 99.11z"],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", "M240 63.1C141.3 63.1 64 141.3 64 240C64 248.8 71.16 256 80 256S96 248.8 96 240C96 159.3 159.3 96 240 96C319.4 96 384 162.1 384 243.4c0 49.19-17.8 91.53-54.39 129.4l-3.812 3.969l-.5781 5.469C319.5 436.2 274 480 224 480c-8.844 0-16 7.156-16 16S215.2 512 224 512c64.16 0 122.4-53.69 132.3-120.8C396.5 348 416 299.6 416 243.4C416 144.5 337 63.1 240 63.1zM160 240C160 195.9 195.9 160 240 160S320 195.9 320 240C320 248.8 327.2 256 336 256S352 248.8 352 240c0-61.75-50.25-112-111.1-112S128 178.3 128 240C128 248.8 135.2 256 144 256S160 248.8 160 240zM176 320c-4.094 0-8.188 1.562-11.31 4.688l-160 160C1.563 487.8 0 491.9 0 496C0 504.5 6.865 512 16 512c4.094 0 8.188-1.562 11.31-4.688l160-160C190.4 344.2 192 340.1 192 336C192 327.5 185.1 320 176 320zM512 16C512 7.473 505.1 0 496 0c-4.094 0-8.188 1.562-11.31 4.688l-64 64C417.6 71.81 416 75.91 416 80C416 88.53 422.9 96 432 96c4.094 0 8.188-1.562 11.31-4.688l64-64C510.4 24.19 512 20.09 512 16z"],
    "ear-listen": [512, 512, ["assistive-listening-systems"], "f2a2", "M240 63.1c-98.69 0-176 77.32-176 176C64 248.8 71.16 256 80 256S96 248.8 96 240C96 159.3 159.3 96.01 240 96.01c79.41 0 144 66.14 144 147.4c0 49.2-17.8 91.56-54.39 129.5l-3.812 3.953l-.5781 5.453C319.5 436.2 274 480 224 480c-8.844 0-16 7.156-16 15.1S215.2 512 224 512c64.16 0 122.4-53.69 132.3-120.8C396.5 348 416 299.6 416 243.4C416 144.5 337 63.1 240 63.1zM160 240C160 195.9 195.9 160 240 160S320 195.9 320 240c0 8.844 7.156 15.1 16 15.1S352 248.8 352 240c0-61.75-50.25-111.1-112-111.1S128 178.3 128 240C128 248.8 135.2 256 144 256S160 248.8 160 240zM32 456c-13.25 0-24 10.75-24 23.1c0 13.25 10.75 23.1 24 23.1c13.26 0 24-10.75 24-23.1C56 466.7 45.26 456 32 456zM160 328c-13.25 0-24 10.75-24 23.1S146.7 376 160 376c13.26 0 24-10.75 24-23.1S173.3 328 160 328zM75.31 372.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.37 0 22.62l64 63.1C119.8 462.4 123.9 464 128 464s8.188-1.562 11.31-4.687c6.25-6.25 6.25-16.37 0-22.62L75.31 372.7zM357.1 .8386c-8.469-2.828-17.45 1.734-20.23 10.11c-2.797 8.39 1.734 17.45 10.11 20.23C426.5 57.73 480 131.9 480 215.8v8.199c0 8.844 7.156 16 16 16S512 232.8 512 224V215.8C512 118.1 449.7 31.73 357.1 .8386z"],
    "ear-muffs": [640, 512, [], "f795", "M147.3 223.1c-10.36 0-20.14 3.672-28.24 10.55C107.6 229.3 93.76 228.7 84.53 233.3C73.06 237.8 64.27 246.5 59.66 257.8C48.3 259.2 37.54 264.1 29.82 274.3C22.62 283.5 19.09 295.1 19.91 306.8C10.72 313.1 4.024 322.8 1.274 334.5c-2.609 11.34-.72 23.25 5.077 33.19c-5.703 9.656-7.787 21.52-5.412 33.23c2.703 11.66 9.341 21.37 18.75 27.72c-1.031 11.84 2.428 23.53 9.68 32.5c7.33 9.375 17.86 15.25 29.6 16.72c4.58 11.16 13.19 19.92 24.22 24.45c11.44 4.781 24.03 4.094 35.39-1.594C126.7 508 136.7 512 147.3 512c24.62 0 44.64-20.56 44.64-45.81c0-10.31-3.517-18.58-7.423-24.58c4.877-7.531 7.423-15.98 7.423-24.7c0-8.938-2.397-17.28-6.931-24.44c4.549-7.25 6.92-15.53 6.92-24.41s-2.364-17.28-6.913-24.53c4.549-7.219 6.923-15.59 6.923-24.56c0-8.656-2.546-17.03-7.438-24.59C189.4 286.9 191.1 278.4 191.1 269.8C191.1 244.6 171.1 223.1 147.3 223.1zM156.2 309.8c2.484 2.938 3.734 6 3.734 9.125c0 3.562-1.047 6.594-3.156 9.062c-7.611 9.031-7.596 22.06 0 31C158.9 361.5 159.1 364.5 159.1 368s-1.062 6.5-3.109 8.938c-7.643 8.969-7.658 22 .0156 31.09c2.047 2.406 3.094 5.406 3.094 8.875c0 3.188-1.25 6.312-3.672 9.188c-7.643 8.969-7.658 22 .0313 31.12c1.656 1.938 3.641 5.062 3.641 8.969C159.1 473.8 154.3 480 147.3 480c-4.111 0-7.158-2.594-8.986-4.781c-4.689-5.594-11.46-8.562-18.35-8.562c-4.643 0-9.346 1.344-13.52 4.125c-3.938 2.719-7.688 3.312-11.13 1.938c-3.625-1.5-6.266-4.656-7.424-8.875c-2.844-10.38-12.36-17.62-23.14-17.62c-4.158 0-7.814-1.719-10.41-5.062c-2.518-3.094-3.439-7.406-2.533-11.75c2.236-10.59-2.953-21.44-12.72-26.41c-4.484-2.25-6.252-6.25-6.846-8.812c-.8438-4.125 .1094-8.5 2.424-11.41c6.953-8.656 7.094-20.81 .3125-29.66c-2.502-3.281-3.424-7.406-2.549-11.25c1.047-4.375 3.564-7.844 6.83-9.531c9.486-4.75 14.74-15.38 12.77-25.88c-.8281-4.406 .2187-9.031 2.58-12c2.469-3 6.359-4.906 10.28-4.906C76.51 290.8 85.98 282.1 88.67 271.7c1.08-4.062 3.768-7.125 8.58-9.062c1.549-.5 6.455-.4687 10.13 1.969c10.13 6.5 23.18 4.688 30.91-4.156C140.1 258.4 143.1 256 147.3 256c6.971 0 12.64 6.188 12.64 13.81c0 3-1.328 6.281-3.719 9.062C148.6 287.9 148.7 300.9 156.2 309.8zM639 335.1c-2.703-11.66-9.315-21.38-18.72-27.72c1.031-11.84-2.428-23.53-9.68-32.5c-7.33-9.375-17.86-15.25-29.6-16.72c-4.58-11.16-13.19-19.92-24.22-24.45c-11.39-4.75-24-4.063-35.39 1.594c-8.096-7.312-18.12-11.3-28.77-11.3c-24.62 0-44.64 20.56-44.64 45.81c0 10.31 3.517 18.58 7.423 24.58c-4.877 7.531-7.423 15.98-7.423 24.7c0 8.938 2.397 17.28 6.931 24.44c-4.549 7.25-7.015 15.53-7.015 24.41s2.458 17.28 7.007 24.53c-4.549 7.219-6.923 15.59-6.923 24.56c0 8.656 2.546 17.03 7.438 24.59c-4.83 7.469-7.438 15.1-7.438 24.56c0 25.25 20.03 45.81 44.64 45.81c10.36 0 20.14-3.672 28.24-10.55c11.52 5.25 25.3 5.799 34.58 1.268c11.47-4.5 20.26-13.25 24.87-24.53c11.36-1.344 22.12-7.141 29.84-16.48c7.205-9.156 10.73-20.8 9.914-32.48c9.189-6.344 15.85-16.17 18.6-27.83c2.609-11.34 .752-23.13-5.045-33.06C639.4 358.7 641.4 346.8 639 335.1zM604.1 382.9c2.502 3.281 3.424 7.406 2.549 11.25c-1.047 4.375-3.564 7.844-6.83 9.531c-9.486 4.75-14.74 15.38-12.77 25.88c.8281 4.406-.2187 9.031-2.58 12c-2.531 3.094-6.688 5.031-10.55 4.906c-10.92 0-20.82 7.562-23.49 17.91c-1.08 4.062-3.768 7.125-8.58 9.062c-1.533 .5313-6.439 .4375-10.13-1.969c-10.16-6.5-23.22-4.719-30.91 4.156C499.9 477.6 496.9 480 492.7 480c-6.971 0-12.64-6.188-12.64-13.81c0-3 1.328-6.281 3.719-9.062c7.611-9.031 7.596-22.06 .0156-30.97c-2.484-2.938-3.734-6-3.734-9.125c0-3.562 1.047-6.594 3.156-9.062c7.611-9.031 7.596-22.06 0-31C481.1 374.5 480 371.5 480 368s1.062-6.5 3.109-8.938c7.643-8.969 7.658-22-.0156-31.09c-2.047-2.406-3.094-5.406-3.094-8.875c0-3.188 1.25-6.312 3.672-9.188c7.643-8.969 7.658-22-.0313-31.12c-1.656-1.938-3.641-5.062-3.641-8.969C480 262.2 485.7 256 492.7 256c4.111 0 7.158 2.594 8.986 4.781c7.861 9.375 21.52 11.34 31.87 4.438c3.953-2.688 7.719-3.281 11.13-1.938c3.625 1.5 6.266 4.656 7.424 8.875c2.844 10.38 12.36 17.62 23.14 17.62c4.158 0 7.814 1.719 10.41 5.062c2.518 3.094 3.439 7.406 2.533 11.75c-2.236 10.59 2.953 21.44 12.72 26.41c4.484 2.25 6.252 6.25 6.846 8.812c.8438 4.094-.0938 8.469-2.439 11.44C598.4 361.9 598.2 374.1 604.1 382.9zM506.9 179.7C508.6 187 515.2 192 522.4 192c1.219 0 2.453-.125 3.688-.4375c8.609-2.031 13.94-10.62 11.91-19.25C514 70.88 424.4 0 320 0S125.1 70.88 101.1 172.3C99.95 180.9 105.3 189.5 113.9 191.6c8.516 2.156 17.2-3.312 19.25-11.88C153.7 92.72 230.5 32 320 32S486.3 92.72 506.9 179.7z"],
    "earth-africa": [576, 512, [62844, "globe-africa"], "1f30d", "M288 0C146.6 0 32 114.6 32 256s114.6 256 256 256s256-114.6 256-256S429.4 0 288 0zM490.1 160h-27.85c-17.32 0-30.85 14.62-30.85 32v8l-12.99 4.625c-2.664 .5-8.355 .75-15.02 1c-32.33 1.5-46.86 2.625-52.92 14.62c-2.504 6.342-1.742 13.51 2.039 19.18L364.9 258C370.7 266.8 380.5 272 391 272h8.355v8l-19.38 27.62c-2.785 3.875-4.723 8.25-5.57 13l-4.238 22.5c-10.41 9.5-19.62 20.38-27.49 32.13l-12.96 19.5c-4.721 7-16.59 6.377-20.34-1.25c-4.359-8.75-6.66-18.38-6.66-28.12V335.5c0-17.4-14.1-31.5-31.5-31.5H245.4c-10.29 0-19.98-4-27.25-11.25C210.8 285.4 206.7 275.8 206.7 265.4V251.3c0-12.18 5.744-23.64 15.5-30.93l27.61-20.62c5.051-3.824 22.48-13.16 41.29-3.625l14.77 7.375c12.07 5.826 22.17 2.248 23.98 1.625l47.35-15.75c12.84-4.25 21.55-16.38 21.55-29.88C398.8 142.1 384.6 128 367.3 128l-9.809 .125l-6.902-6.875C344.6 115.3 335.9 112 327.4 112h-88C238.1 101.1 258.3 111.4 271.4 91.88L279 80h40.37V34.46C394.9 45.13 458.4 93.5 490.1 160zM288 480c-123.5 0-224-100.5-224-224c0-123.3 100.2-223.6 223.4-223.1V48C271.9 47.39 256.7 55.61 252.1 62.7L244.5 74.58l-13.88 2.998C215.8 81.28 204.3 94.3 207.1 116.5C209.1 132.5 223.3 144 239.4 144h89.1l6.422 6.797c6.002 5.979 14.12 9.328 22.58 9.328c.1367 0 10.22-.127 10.22-.127L319.8 174.8l-14.36-7.266C295.9 162.7 284.8 160.1 273.7 160.1c-15.74 0-31.06 5.037-43.14 14.18l-27.45 20.5C185.3 208 174.7 229.2 174.7 251.4v14c0 18.66 7.311 36.36 20.59 49.83C208.8 328.7 226.5 336 245.4 336h25.91l-.5156 29.38c0 14.58 3.465 29.24 10.02 42.39C287.1 422.4 302.4 432 319.4 432c14.7 0 28.88-7.465 36.9-19.35l13.08-19.69c6.559-9.789 14.12-18.64 22.4-26.19c5.129-4.678 8.596-10.9 9.881-17.72l4.238-22.5l18.59-24.82c4.24-5.641 6.498-12.53 6.42-19.58l-.1211-11c-.0977-8.783-3.799-17.14-10.24-23.11c-5.934-5.502-21.71-8.535-29.76-8.535c-4.768 0 33.05-3.336 33.52-3.424c3.137-.5879 6.17-1.645 8.996-3.131L445.9 226.3c10.9-5.732 18.13-17.21 17.68-29.51L463.4 192l39.19 .0371C508.6 212.3 512 233.8 512 256C512 379.5 411.5 480 288 480z"],
    "earth-americas": [576, 512, [62845, "earth", "globe-americas"], "1f30e", "M288 0C146.6 0 32 114.6 32 256s114.6 256 256 256s256-114.6 256-256S429.4 0 288 0zM511.6 263.9l-51.91-13.15c-1.938-.5-3.633-1.625-4.723-3.375L436.9 220.5c-1.816-2.75-1.816-6.25 0-9l19.62-29.38c.7266-1.125 1.816-2 3.027-2.625l30.74-19.03C504.1 189.5 512 221.8 512 256C512 258.7 511.7 261.3 511.6 263.9zM64 256c0-12.45 1.279-24.58 3.242-36.48c12.02 13.67 23.89 27.29 26.5 30.94C99.67 259.2 106.7 267.3 114.6 274.2C125.7 284.3 137.4 292.4 150.2 298.9c13.65 6.863 33.87 17.84 48.29 25.85c5.205 2.857 8.355 8.201 8.355 14.02v32c0 12.74 5.139 25.14 14.1 34c12.56 12.53 18.83 31.66 18.02 37.87c-.1777 1.369-.2676 2.748-.2676 4.127v27.6C138.8 451.8 64 362.5 64 256zM270.7 479.1v-32.37c2.422-18.62-9.445-47-27.25-64.75c-2.906-2.875-4.602-7-4.602-11.25v-32c0-17.5-9.566-33.63-24.82-42c-14.41-8-35.12-19.25-49.29-26.38C154.7 265.3 145.2 258.8 135.8 250.3C129.8 245 124.6 239 120.1 232.4C116.2 226.6 96.72 204.5 76.83 181.1c24.75-70.38 83.58-124.6 156.7-143L296.1 96L281.1 111C272.1 120 271.8 134.5 280.2 144H274.4c-6.176 0-12.11 2.375-16.71 6.75L247.8 160.5c-7.508 7.25-9.445 18.5-4.723 27.88l3.996 8c-3.777-1.506-7.848-2.299-11.95-2.299c-3.391 0-6.803 .543-10.09 1.674L193.9 206.1c-11.38 3.75-19.13 14.5-19.13 26.5c0 10.62 5.934 20.25 15.5 25l11.02 5.5C212.1 268.5 223.9 271.5 235.9 272c2.422 2.25 6.297 7.5 8.719 10.88C256.1 298.4 258.5 299.6 267 304h70.48c4.238 0 8.355 1.75 11.26 4.75l13.8 13.62c2.664 2.75 4.238 6.375 4.238 10.25c0 8.125-3.27 16-9.082 21.62l-11.38 11.38c-11.1 11.46-9.967 20.83-14.53 33.25l-24.88 80.17C300.7 479.6 294.4 480 288 480C282.1 480 276.4 479.6 270.7 479.1zM342.3 473.1l19.87-64.01c1.611-4.527 2.709-8.74 3.727-12.81c1.615-6.473 1.754-6.615 3.443-8.361l11.02-11c11.6-11.22 18.46-27.48 18.46-44.26c0-12.14-4.707-23.69-13.25-32.52l-14.31-14.13C362.8 277.3 350.3 272 337.5 272h-60.83C275.5 270.6 273.5 268.1 270.3 263.8C265.1 256.6 261.3 251.9 257.7 248.6c-5.582-5.186-12.83-8.209-20.45-8.527C229.7 239.7 222.2 237.8 215.6 234.5l-2.23-1.113l21.8-7.268c3.842 1.531 7.861 2.273 11.84 2.273c8.795 0 17.41-3.619 23.6-10.35c8.984-9.773 11.04-24.08 5.105-35.96L274.3 179.3L277.7 176h2.564c12.61 0 24.05-7.408 29.21-18.92c4.105-9.168 3.617-19.58-.9922-28.19l10.27-10.26c6.189-6.182 9.576-14.63 9.377-23.37c-.2012-8.744-3.971-17.03-10.44-22.92l-43.5-39.65C278.8 32.42 283.3 32 288 32c77.89 0 146.5 40.01 186.7 100.5l-31.29 19.37c-5.615 3.195-10.35 7.627-13.75 12.9l-19.35 28.96c-8.973 13.58-8.971 30.96-.0898 44.41l18.18 27.07c4.797 7.744 13.28 13.94 23.29 16.52l56.52 14.31C492.5 382.7 426.9 451.9 342.3 473.1z"],
    "earth-asia": [576, 512, [62846, "globe-asia"], "1f30f", "M289.2 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S430.6 0 289.2 0zM289.2 32c22.47 0 44.15 3.41 64.63 9.596L290.7 91C283.5 95.75 279.4 104 279.9 112.5c.6055 8.5 5.691 16.12 13.32 20l10.78 5.375v64.25c-1.695-.625-3.512-.875-5.449-1c-7.145 0-14.41 3.625-18.29 9.875L262.6 240c-8.477 0-16.59 3.375-22.52 9.375L234.4 255C229.8 259.6 227.3 265.6 227.3 272s2.422 12.5 7.023 17l5.691 5.625V304H217.9L195.2 258.8C191.9 251.9 185.3 247 177.7 245.9C176.4 245.7 175.2 245.6 173.9 245.6c-6.227 0-12.5 2.48-17.02 6.941L137.4 272H66.04C65.67 266.7 65.23 261.4 65.23 256C65.23 132.5 165.7 32 289.2 32zM70.54 304h66.82c8.488 0 16.63-3.373 22.63-9.375l11.61-11.61l17.67 35.31C194.7 329.2 205.8 336 217.9 336h22.16c17.67 0 32-14.33 32-32V294.6c0-8.426-3.322-16.51-9.238-22.49c11.06-.0938 21.32-6.023 27.09-15.47l13.74-22.54c.1172 .002 .2344 .002 .3516 .002c6.459 0 12.86-1.955 18.3-5.75c8.584-5.982 13.7-15.79 13.7-26.25V137.9c0-11.9-6.6-22.8-17.1-28.32l69.33-54.2C462.2 91.99 513.2 168 513.2 256c0 26.31-4.797 51.47-13.17 74.94c-2.016-4.812-5.033-9.844-9.74-14.7l-5.275-5.229V308c0-19.85-16.15-36-35.1-36H443c-5.518 0-10.84 1.287-15.62 3.605C422.3 273.3 416.7 272 410.9 272h-12.11c-8.686 0-17 2.78-23.89 7.954l-22.36 15.9l-38.9 15.56c-15.43 6.369-25.2 20.92-25.2 37.21v10.12c0 10.9 4.502 21.44 12.35 28.92l11.31 11.33c9.154 9.072 21.15 14.01 33.9 14.01h10.41c6.611 0 9.584-.7617 22.1-3.967l7.92-2.021l11 10.93c8.311 8.236 19 12.88 30.36 13.71C389.6 461.8 341.6 480 289.2 480C182.2 480 92.59 404.5 70.54 304zM431.3 400c-4.238 0-8.234-1.75-11.26-4.75l-13.08-13c-5.09-5.062-11.88-7.789-18.9-7.789c-2.168-.002-4.357 .2578-6.527 .7891c-21.92 5.561-21.83 5.75-25.07 5.75h-10.41c-4.238 0-8.234-1.625-11.26-4.625l-11.87-11.88c-1.574-1.5-2.422-3.625-2.422-5.75v-10.12c0-3.25 2.059-6.25 5.086-7.5l39.36-15.75c1.938-.75 3.875-1.75 5.57-3l23.73-16.88C395.5 304.5 397.1 304 398.8 304h12.11c3.148 0 6.176 2 7.387 5l5.328 12.75c.6055 1.5 2.059 2.5 3.633 2.5h3.875c1.816 0 3.27-1.125 3.875-2.875l4.117-14.5C439.6 305.3 441.2 304 443 304h6.055c2.18 0 3.996 1.75 3.996 4v13c0 2.125 .8477 4.125 2.301 5.625l11.99 11.88c4.668 4.818 4.602 9.816 4.602 14.32c1.518 5.873 6.01 10.43 11.4 14.5C476.7 378.9 469.1 389.8 460.6 400H431.3z"],
    "earth-europa": [576, 512, ["globe-europe"], "f7a2", "M289.2 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S430.6 0 289.2 0zM335.1 475V432c0-26.5-21.43-48-47.95-48H267.8c-3.875 0-13.08-3.125-16.23-5.375L229.4 361.9c-3.391-2.5-5.449-6.625-5.449-10.75v-23.88c0-4.75 2.543-9.125 6.539-11.62l42.87-25.75C275.5 288.6 277.9 288 280.3 288h31.24c3.148 0 6.297 1.25 8.84 3.25L372.5 336h30.15l17.32 17.25C429.6 362.8 442.2 368 455.5 368h27.45C451.6 421.9 398.7 461.7 335.1 475zM498.2 336h-42.62c-4.844 0-9.445-1.875-12.84-5.25l-17.32-17.38C419.4 307.4 411.3 304 402.8 304h-18.29l-43.23-37.13C333 259.8 322.6 256 311.7 256H280.5C272.3 256 264.1 258.3 257.1 262.5L214.3 288.3c-13.8 8.125-22.16 23-22.16 39v23.88c0 14.25 6.66 27.75 18.16 36.38l22.28 16.75C241.1 410.8 257.1 416 267.9 416h20.22c8.719 0 15.98 7.25 15.98 16v47.25C299.2 479.6 294.3 480 289.2 480c-123.5 0-224-100.5-224-224s100.5-224 224-224c1.59 0 3.129 .2051 4.711 .2383l-21.93 18.89C261.8 58.75 256 70.25 256 82.5v23.25c0 6.375 3.027 17 5.812 22.25C261.1 130.1 240.8 143 237.3 146.5c-8.598 8.625-13.32 20-13.32 32.13V195c0 25 20.46 45.38 45.41 45.38h25.31c11.02 0 21.19-3.875 29.18-10.62c3.996 1.5 8.234 2.125 12.71 2.125h13.32c25.67 0 32.21-20.12 36.09-21.5c5.086 9.125 13.56 16.25 23.49 19.5c-4.238 14.25-.8477 30.38 10.17 41.63l18.16 19.12c8.719 8.875 20.59 13.88 32.7 13.88h37.31C505.4 315.3 502.1 325.8 498.2 336zM470.7 272.4c-3.633 0-7.145-1.5-9.688-4L442.6 249c-3.875-3.875-3.754-10.12 .1211-14c12.59-12.62 10.41-8.625 10.41-17.75c0-2.5-.9687-5-2.785-6.75l-7.871-7.875c-1.816-1.875-4.238-2.875-6.66-2.875h-13.44c-8.477 0-12.59-10.25-6.66-16.12l7.871-7.375c1.816-1.75 4.117-2.75 6.66-2.75h8.355c5.207 0 9.445-4.25 9.445-9.5V153.8c0-5.125-4.238-9.5-9.445-9.5h-28.21c-7.387 0-13.44 6-13.44 13.5v5.5c0 5.875-3.633 11-9.203 12.75l-26.52 8.75c-4.238 1.5-4.602 5-4.602 8.25c0 3.75-2.906 6.75-6.66 6.75h-13.44c-3.633 0-6.66-3-6.66-6.75c0-4.678-3.893-6.82-7.812-6.82c-3.1-.002-6.215 1.338-7.445 3.82c-9.082 12.38-11.5 18.25-19.98 18.25H269.4c-7.387 0-13.32-6-13.32-13.5V178.4c0-3.625 1.332-7 3.875-9.5c19.5-14 29.55-17.62 29.55-31.5c0-2.875 1.816-5.5 4.602-6.375l33.66-11.25c1.332-.5 2.664-1.125 3.633-2.25l22.52-22.5c4.965-5 3.512-14.88-6.66-14.88H329.8L316.5 99v6.75c0 3.625-3.027 6.625-6.781 6.625h-15.02C291 112.4 288 109.4 288 105.8V82.5c0-2.125 .9687-4.125 2.664-5.375l45.92-39.98C437.4 58.95 513.2 148.7 513.2 256c0 5.527-.4336 10.95-.8301 16.38H470.7zM223.9 119.3c0-7-5.691-12.75-12.59-12.75c-3.391 0-6.781 1.25-9.082 3.75l-28.46 28.5C171.4 141.1 170.1 144.3 170.1 147.6c0 7 5.643 12.75 12.67 12.75h18.09c3.391 0 6.539-1.25 8.84-3.625l10.54-10.5c2.422-2.5 3.754-5.625 3.754-9V119.3z"],
    "eclipse": [640, 512, [], "f749", "M256 467.5l-48.38-71.64c-3-4.376-8-7.002-13.25-7.002c-1 0-2 .125-3 .3751L106.6 405.6l16.38-84.77c1.25-6.377-1.375-12.75-6.75-16.38L44.62 256.1l71.62-48.39c5.25-3.626 8-10 6.75-16.38L106.6 106.5l84.75 16.38C197.6 124 204.1 121.4 207.8 116.2L256 44.64L280.1 81.54c5.257 7.766 15.99 9.178 23.21 3.195l.329-.2721C310.8 79.32 312 70.25 307.5 63.55L269.2 7.002C266.2 2.626 261.3 0 256 0C250.8 0 245.8 2.626 242.8 7.002L187 89.4l-97.75-18.75c-5.125-1-10.51 .616-14.26 4.367S69.62 84.15 70.62 89.27l18.75 97.77L7 242.8C2.625 245.8 0 250.8 0 256c0 5.251 2.625 10.28 7 13.28l82.38 55.76l-18.88 97.77c-1 5.126 .8437 10.36 4.469 14.11c3.75 3.751 9.156 5.519 14.28 4.519l97.63-18.88l55.88 82.4C245.8 509.4 250.7 512 255.9 512c5.375 0 10.33-2.626 13.21-7.002l38.08-56.36c4.605-6.816 3.143-15.94-3.215-21.16c-7.141-5.878-18.07-4.397-23.24 3.274L256 467.5zM241.1 170.1l.2634-.6427c5.026-12.21-6.691-24.86-19.3-20.94C205.5 154.5 189.1 163.6 176.8 176.8C139 214.7 133.2 270.8 162.2 320.1C169.5 332.3 179.8 342.5 192 349.8c10.08 5.947 20.46 10.39 30.93 13.39c12.41 3.557 23.5-9.272 18.53-21.19l-.2609-.6277c-1.823-4.404-5.382-7.879-9.958-9.207c-7.413-2.152-15.13-5.358-22.1-10c-7.5-4.376-14-10.88-18.37-18.38C164 259.8 178.8 220.2 199.5 199.4c8.045-7.939 19.03-15.14 32.1-19.32C235.1 178.7 239.4 175.2 241.1 170.1zM448 64.02c-106 0-191.1 85.97-191.1 191.1c0 106 85.99 192 191.1 192c105.1 0 192-86.01 192-192C640 149.1 553.1 64.02 448 64.02zM448 416.1c-88.25 0-159.1-71.81-159.1-160.1S359.8 96.02 448 96.02s160 71.77 160 160S536.3 416.1 448 416.1z"],
    "egg": [384, 512, [63483], "1f95a", "M192 16c-106 0-192 200.6-192 300S85.1 496 192 496c105.1 0 192-80.63 192-180S297.1 16 192 16zM192 464c-88.22 0-160-66.39-160-148C32 222.3 114.2 48 192 48s160 174.3 160 268C352 397.6 280.2 464 192 464zM135.2 117.1C100.7 160.7 64 240.4 64 304C64 312.8 71.16 320 80 320S96 312.8 96 304c0-54.19 32.59-126.9 64.13-165.1c5.547-6.875 4.469-16.94-2.406-22.5C150.9 109.1 140.8 111 135.2 117.1z"],
    "egg-fried": [512, 512, [], "f7fc", "M223.1 168.1c-39.75 .125-72 32.32-72 72.01c0 8.861 7.126 15.99 16 15.99S183.1 248.1 183.1 240.1c0-22.09 17.88-40.03 40-40.03c8.875 0 16-7.251 16-15.99C239.1 175.3 232.9 168.1 223.1 168.1zM478.4 150.5c-39.5-40.75-100.8-46.38-144.5-82.25C290.2 32.24 255.6 0 200.5 0C192.1 0 183.7 .7387 175.3 2.114c-86.76 14-111.8 80.01-125 157.1c-11.12 64.38-54.38 127-50 192.9c4.375 65.88 52.88 128.5 115 150.8C132.9 509.3 149.2 512 164.2 512c64.76 0 109-51.12 155.8-95.49c43.63-41.5 93.38-37.75 140.9-74C517.2 299.8 532.6 201.1 478.4 150.5zM479.9 239.8c-1.75 31-16.38 60.63-38.25 77.25c-18.13 13.88-37.63 20.88-58.13 28.5c-26.88 9.75-57.26 20.88-85.51 47.75c-5.5 5.125-10.88 10.38-16.38 15.75C243.1 445.5 208.5 480 164.2 480c-12 0-24.5-2.375-38.13-7.25c-50.88-18.25-90.38-69.88-93.88-122.7C30.06 317.5 42.81 283.5 56.44 247.6c10-26.62 20.38-54.13 25.38-83C96.95 77.25 122.7 43 180.5 33.75C187.1 32.63 193.8 32 200.5 32c39.63 0 66.51 22.25 103.8 53.25L313.6 93c23.63 19.5 50.01 30.62 75.38 41.5c25.5 10.75 49.5 21 67.26 39.25C478.7 195 480.7 224.3 479.9 239.8zM224 112c-70.5 0-128 57.44-128 128c0 70.68 57.38 128 128 128s128-57.44 128-128S294.6 112 224 112zM224 336c-53-.125-96.03-42.94-96.03-95.88s43.13-96.07 96-96.07s96 43.13 96 96.07S277 335.9 224 336z"],
    "eggplant": [512, 512, [], "e16c", "M512 16C512 7.473 505.1 0 496 0c-4.094 0-8.188 1.562-11.31 4.688l-26.1 26.1C444.9 21.47 428.4 16 410.7 16h-106.7c-17.67 0-32 14.33-32 32c0 9.361 1.516 18.38 4.312 26.81C185.7 146.5 123.8 177.1 100.8 186.1C31.93 214.6 .0005 275.1 .0005 337.4c0 141.1 129.2 174.7 172.6 174.7c57.68 0 108.2-13.32 213.2-172.9c21.93-33.59 41.11-67.46 59.27-101.5C451.2 239 457.5 240 464 240c17.67 0 32-14.33 32-32V101.3c0-17.76-5.477-34.25-14.79-47.92l26.1-26.1C510.4 24.19 512 20.09 512 16zM359.1 321.5C267.6 460.5 226.8 480 172.6 480c-49.81 0-94.85-25.7-120.5-68.75C17.63 353.4 22.56 253.2 112.4 215.9c18.08-7.078 81.9-36.09 179.9-113c9.904 11.72 22.72 20.91 37.54 25.96c8.52 25 28.33 44.81 53.33 53.33c5.996 17.6 17.68 32.5 32.73 42.83C397.8 258.7 379.1 290.9 359.1 321.5zM464 208c-29.45 0-53.33-23.88-53.33-53.33c-29.46 0-53.33-23.88-53.33-53.33c-29.46 0-53.33-23.88-53.33-53.33h106.7c29.46 0 53.33 23.88 53.33 53.33V208z"],
    "eject": [448, 512, [61522], "23cf", "M48.01 351.1h351.1c41.62 0 63.49-49.63 35.37-80.38l-175.1-192.1C249.9 69.16 236.9 64.01 224 64.01c-12.94 0-25.87 5.156-35.37 15.47L12.64 271.6C-15.48 302.2 6.393 351.1 48.01 351.1zM36.24 293.2l175.9-192.1C216.3 96.67 221.4 96 224 96c2.65 0 7.711 .668 11.78 5.082l175.1 192.1c6.328 6.92 4.062 14.36 2.795 17.24c-1.266 2.871-5.217 9.551-14.55 9.551H48.01c-9.326 0-13.28-6.713-14.55-9.598C32.2 307.5 29.94 300.1 36.24 293.2zM432 416h-416c-8.844 0-15.99 7.164-15.99 16.01S7.156 448 16 448h416c8.844 0 15.99-7.148 15.99-15.99S440.8 416 432 416z"],
    "elephant": [640, 512, [63194], "1f418", "M528 32h-72.94C437.5 12.5 412.3 0 384 0s-53.45 12.5-71.03 32H176C78.97 32 0 110.1 0 208V352c0 8.844 7.156 16 16 16S32 360.9 32 352V208C32 128.6 96.59 64 176 64h117.9C290.3 74.06 288 84.72 288 96c0 41.47 26.81 78 65.28 90.97C358.3 208.2 377.3 224 400 224h32C440.8 224 448 216.8 448 208S440.8 192 432 192h-32C391.2 192 384 184.8 384 174.4c0-7.625-5.375-14.16-12.81-15.69C341.5 152.7 320 126.3 320 96c0-35.28 28.72-64 64-64s64 28.72 64 64c0 8.844 7.156 16 16 16S480 104.8 480 96c0-11.28-2.311-21.94-5.896-32H528C572.1 64 608 99.88 608 144v224c0 26.47-21.53 48-48 48S512 394.5 512 368c0-8.844-7.156-15.98-16-15.98S480 359.2 480 368c0 44.13 35.94 80 80.07 80S640 412.1 640 368v-224C640 82.25 589.8 32 528 32zM544 144c0-8.837-7.164-15.1-16-15.1S512 135.2 512 144c0 8.836 7.164 15.99 16 15.99S544 152.9 544 144zM576 288c0-8.844-7.156-16-16-16h-128C423.2 272 416 279.2 416 288v176c0 8.812-7.188 16-16 16h-32c-8.812 0-16-7.188-16-16v-74.73c12.24-8.643 21.76-18.95 27.06-30.71c3.625-8.031 .0313-17.53-8.031-21.16c-7.969-3.625-17.5-.0625-21.16 8.031C341.4 364.1 305.7 384 256 384s-85.44-19.88-93.88-38.56c-3.656-8.094-13.19-11.66-21.16-8.031c-8.062 3.625-11.66 13.12-8.031 21.16C138.2 370.3 147.8 380.6 160 389.3V464C160 472.8 152.8 480 144 480h-32C103.2 480 96 472.8 96 464v-224C96 231.2 88.84 224 80 224S64 231.2 64 240v224C64 490.5 85.53 512 112 512h32C170.5 512 192 490.5 192 464v-58.52C210.9 412.1 232.7 416 256 416s45.1-3.854 64-10.52V464c0 26.47 21.53 48 48 48h32c26.47 0 48-21.53 48-48v-160h112C568.8 304 576 296.8 576 288z"],
    "elevator": [512, 512, [], "e16d", "M448 128H64c-35.35 0-64 28.65-64 63.1v255.1C0 483.3 28.65 512 64 512h384c35.35 0 64-28.65 64-63.1V192C512 156.7 483.3 128 448 128zM206.2 480H113.8v-64c0-17.64 14.36-32 32-32h28.45c17.64 0 32 14.36 32 32V480zM398.2 480h-92.45v-64c0-17.64 14.36-32 32-32h28.45c17.64 0 32 14.36 32 32V480zM480 448c0 17.64-14.36 32-32 32h-17.78v-64c0-35.35-28.65-64-64-64h-28.45c-35.35 0-64 28.65-64 64v64H238.2v-64c0-35.35-28.65-64-64-64H145.8c-35.35 0-64 28.65-64 64v64H64c-17.64 0-32-14.36-32-32V192c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V448zM160 208C129.1 208.1 104 233.1 104 264S129.1 319.9 160 320c30.95-.1172 56-25.13 56-55.1S190.9 208.1 160 208zM160.1 288C146.8 287.9 136 277.2 136 264C136 250.9 146.8 240.1 160 240c13.25 .1133 24 10.86 24 24C184 277.2 173.2 287.9 160.1 288zM352 208c-30.95 .1152-56 25.13-56 55.1s25.05 55.88 56 55.1c30.95-.1172 56-25.13 56-55.1S382.9 208.1 352 208zM352.1 288C338.8 287.9 328 277.2 328 264c0-13.14 10.76-23.89 24-24c13.25 .1133 24 10.86 24 24C376 277.2 365.2 287.9 352.1 288zM91.31 91.31L144 38.63l52.69 52.69C199.8 94.44 203.9 96 208 96s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62l-64-64c-6.25-6.25-16.38-6.25-22.62 0l-64 64c-6.25 6.25-6.25 16.38 0 22.62S85.06 97.56 91.31 91.31zM356.7 91.31c3.125 3.125 7.219 4.692 11.31 4.692s8.188-1.567 11.31-4.692l64-64c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L368 57.38l-52.69-52.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L356.7 91.31z"],
    "ellipsis": [512, 512, ["ellipsis-h"], "f141", "M256 224C238.3 224 224 238.3 224 256c0 17.67 14.33 32 32 32s32-14.33 32-32C288 238.3 273.7 224 256 224zM96 224C78.33 224 64 238.3 64 256c0 17.67 14.33 32 32 32s32-14.33 32-32C128 238.3 113.7 224 96 224zM416 224c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C448 238.3 433.7 224 416 224z"],
    "ellipsis-stroke": [512, 512, ["ellipsis-h-alt"], "f39b", "M256 192C220.7 192 192 220.7 192 256s28.65 64 64 64s64-28.65 64-64S291.3 192 256 192zM256 288C238.4 288 224 273.6 224 256s14.36-32 32-32s32 14.36 32 32S273.6 288 256 288zM448 192c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S483.3 192 448 192zM448 288c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S465.6 288 448 288zM64 192C28.65 192 0 220.7 0 256s28.65 64 64 64s64-28.65 64-64S99.35 192 64 192zM64 288C46.36 288 32 273.6 32 256s14.36-32 32-32s32 14.36 32 32S81.64 288 64 288z"],
    "ellipsis-stroke-vertical": [192, 512, ["ellipsis-v-alt"], "f39c", "M96 384c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S131.3 384 96 384zM96 480c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S113.6 480 96 480zM96 128c35.35 0 64-28.65 64-64s-28.65-64-64-64S32 28.65 32 64S60.65 128 96 128zM96 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S64 81.64 64 64S78.36 32 96 32zM96 192C60.65 192 32 220.7 32 256s28.65 64 64 64s64-28.65 64-64S131.3 192 96 192zM96 288C78.36 288 64 273.6 64 256s14.36-32 32-32s32 14.36 32 32S113.6 288 96 288z"],
    "ellipsis-vertical": [128, 512, ["ellipsis-v"], "f142", "M64 128c17.67 0 32-14.33 32-32s-14.33-32-32-32C46.33 64 32 78.33 32 96S46.33 128 64 128zM64 224C46.33 224 32 238.3 32 256s14.33 32 32 32c17.67 0 32-14.33 32-32S81.67 224 64 224zM64 384c-17.67 0-32 14.33-32 32s14.33 32 32 32c17.67 0 32-14.33 32-32S81.67 384 64 384z"],
    "empty-set": [512, 512, [8709, 63062], "d8", "M491.3 20.69c-6.25-6.25-16.38-6.25-22.62 0L391.2 98.15C354.8 66.96 307.7 48 256 48C141.1 48 48 141.1 48 256c0 51.68 18.96 98.85 50.15 135.2l-77.46 77.46c-6.25 6.25-6.25 16.38 0 22.62C23.81 494.4 27.91 496 32 496s8.188-1.562 11.31-4.688l77.46-77.46C157.2 445 204.3 464 256 464c114.9 0 208-93.13 208-208c0-51.68-18.96-98.85-50.15-135.2l77.46-77.46C497.6 37.06 497.6 26.94 491.3 20.69zM80 256c0-97.05 78.95-176 176-176c42.78 0 82.01 15.37 112.5 40.83L120.8 368.5C95.37 338 80 298.8 80 256zM432 256c0 97.05-78.95 176-176 176c-42.78 0-82.01-15.37-112.5-40.83l247.7-247.7C416.6 173.1 432 213.2 432 256z"],
    "engine": [640, 512, [], "e16e", "M608 192h-32c-17.66 0-32 14.36-32 32v32h-32V208c0-4.859-2.219-9.453-6.001-12.5l-71.22-56.95C426.3 131.8 415.7 128 404.8 128H304V96H384c8.836 0 16-7.164 16-16C400 71.16 392.8 64 384 64H192C183.2 64 176 71.16 176 80C176 88.84 183.2 96 192 96h80v32h-160C85.53 128 64 149.5 64 176v64H32v-96C32 135.2 24.84 128 16 128S0 135.2 0 144v224C0 376.8 7.164 384 16 384S32 376.8 32 368v-96h32v64C64 362.5 85.53 384 112 384h41.38l49.94 49.94C212.3 442.9 224.6 448 237.3 448H464c26.47 0 48-21.53 48-48V384h32v32c0 17.64 14.34 32 32 32h32c17.66 0 32-14.36 32-32V224C640 206.4 625.7 192 608 192zM480 400c0 8.828-7.188 16-16 16H237.3c-4.219 0-8.344-1.703-11.31-4.688l-54.63-54.63C168.3 353.7 164.3 352 160 352H112C103.2 352 96 344.8 96 336v-160C96 167.2 103.2 160 112 160h292.8c3.625 0 7.156 1.234 9.969 3.516L480 215.7V400zM608 416h-32v-48c0-8.844-7.156-16-16-16H512V288h48C568.8 288 576 280.8 576 272V224h32V416zM192 232C178.7 232 168 242.7 168 256c0 13.25 10.75 24 24 24S216 269.3 216 256C216 242.7 205.3 232 192 232zM288 232C274.7 232 264 242.7 264 256c0 13.25 10.75 24 24 24S312 269.3 312 256C312 242.7 301.3 232 288 232zM384 232c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S408 269.3 408 256C408 242.7 397.3 232 384 232z"],
    "engine-warning": [640, 512, ["engine-exclamation"], "f5f2", "M287.1 304C296.8 304 304 296.8 304 288V192c0-8.844-7.188-16-16.03-16S272 183.2 272 192v96C272 296.8 279.1 304 287.1 304zM288 328c-13.25 0-24 10.75-24 24S274.7 376 288 376c13.26 0 24-10.75 24-24S301.3 328 288 328zM608 192h-32c-17.66 0-32 14.36-32 32v32h-32V208c0-4.859-2.219-9.453-6.001-12.5l-71.22-56.95C426.3 131.8 415.7 128 404.8 128H304V96H384c8.836 0 16-7.164 16-16C400 71.16 392.8 64 384 64H192C183.2 64 176 71.16 176 80C176 88.84 183.2 96 192 96h80v32h-160C85.53 128 64 149.5 64 176v64H32v-96C32 135.2 24.84 128 16 128S0 135.2 0 144v224C0 376.8 7.164 384 16 384S32 376.8 32 368v-96h32v64C64 362.5 85.53 384 112 384h41.38l49.94 49.94C212.3 442.9 224.6 448 237.3 448H464c26.47 0 48-21.53 48-48V384h32v32c0 17.64 14.34 32 32 32h32c17.66 0 32-14.36 32-32V224C640 206.4 625.7 192 608 192zM480 400c0 8.828-7.188 16-16 16H237.3c-4.219 0-8.344-1.703-11.31-4.688l-54.63-54.63C168.3 353.7 164.3 352 160 352H112C103.2 352 96 344.8 96 336v-160C96 167.2 103.2 160 112 160h292.8c3.625 0 7.156 1.234 9.969 3.516L480 215.7V400zM608 416h-32v-48c0-8.844-7.156-16-16-16H512V288h48C568.8 288 576 280.8 576 272V224h32V416z"],
    "envelope": [512, 512, [128386, 61664, 61443], "2709", "M448 64H64C28.65 64 0 92.65 0 128v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V128C512 92.65 483.3 64 448 64zM64 96h384c17.64 0 32 14.36 32 32v36.01l-195.2 146.4c-17 12.72-40.63 12.72-57.63 0L32 164V128C32 110.4 46.36 96 64 96zM480 384c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V203.1L208 336c14.12 10.61 31.06 16.02 48 16.02S289.9 346.6 304 336L480 203.1V384z"],
    "envelope-dot": [576, 512, ["envelope-badge"], "e16f", "M512 0c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S547.3 0 512 0zM512 96c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S529.6 96 512 96zM528 164h-10.67c-3.463 0-6.832 1.123-9.602 3.199l-190.9 143.2c-17 12.72-40.63 12.72-57.63 0L64 164V128c0-17.67 14.33-32 32-32h304C408.8 96 416 88.84 416 80C416 71.16 408.8 64 400 64H96C60.65 64 32 92.65 32 128v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V180C544 171.2 536.8 164 528 164zM512 384c0 17.64-14.36 32-32 32H96c-17.64 0-32-14.36-32-32V203.1L240 336c14.12 10.61 31.06 16.01 48 16.01S321.9 346.6 336 336L512 203.1V384z"],
    "envelope-open": [512, 512, [62135], "f2b6", "M493.6 163c-24.88-19.62-45.5-35.37-164.3-121.6C312.7 29.21 279.7 0 256.4 0H255.6C232.3 0 199.3 29.21 182.6 41.38C63.88 127.6 43.25 143.4 18.38 163C6.75 172 0 186 0 200.8v263.2C0 490.5 21.49 512 48 512h416c26.51 0 48-21.49 48-47.1V200.8C512 186 505.3 172 493.6 163zM480 464c0 8.822-7.178 16-16 16h-416C39.18 480 32 472.8 32 464V200.8c0-4.902 2.23-9.555 6.195-12.63C61.59 169.7 80.71 154.1 201.5 67.21c2.98-2.178 6.451-4.861 10.28-7.826c9.365-7.254 34.18-26.48 44.62-27.37c9.686 .9551 34.44 20.13 43.79 27.37c3.828 2.965 7.299 5.648 10.36 7.887c120.7 87.68 139.8 102.4 163.5 121C477.8 191.2 480 195.8 480 200.8V464zM422.5 259.1l-132.8 97.72c-19.78 14.62-47.64 14.62-67.45 0L89.48 259.1C82.38 253.8 72.33 255.4 67.11 262.5C61.88 269.6 63.41 279.7 70.52 284.9l132.8 97.72C218.7 393.1 236.9 399.1 256 399.1s37.3-6.023 52.7-17.4l132.8-97.72c7.109-5.219 8.641-15.25 3.406-22.34C439.6 255.4 429.7 253.8 422.5 259.1z"],
    "envelope-open-dollar": [512, 512, [], "f657", "M496 192C487.2 192 480 199.2 480 208v256c0 8.836-7.164 16-16 16h-416C39.16 480 32 472.8 32 464v-256C32 199.2 24.84 192 16 192S0 199.2 0 208v256C0 490.5 21.49 512 48 512h416c26.51 0 48-21.49 48-48v-256C512 199.2 504.8 192 496 192zM64.88 276.3C65.16 277.3 65.43 278.3 65.88 279.2c.4355 .8633 1.012 1.605 1.607 2.385c.6953 .9102 1.393 1.75 2.264 2.49c.2949 .25 .4434 .6035 .7598 .8359l132.8 97.72C218.7 393.1 236.9 399.1 256 399.1s37.3-6.023 52.7-17.4l132.8-97.72c.3164-.2324 .4648-.5859 .7598-.8359c.8711-.7402 1.568-1.58 2.264-2.49c.5957-.7793 1.172-1.521 1.607-2.385c.457-.8984 .7266-1.84 1.01-2.826c.3027-1.061 .5586-2.078 .6406-3.176C447.8 272.8 448 272.4 448 272v-224C448 21.53 426.5 0 400 0h-288C85.53 0 64 21.53 64 48v224c0 .4121 .2031 .7578 .2344 1.162C64.32 274.3 64.57 275.3 64.88 276.3zM96 48C96 39.19 103.2 32 112 32h288C408.8 32 416 39.19 416 48v215.9l-126.3 92.92c-19.78 14.62-47.64 14.62-67.45 0L96 263.9V48zM239.1 272V288c0 8.844 7.156 16 16 16s16-7.156 16-16V272c0-.5938-.2734-1.094-.3359-1.672c22.57-3.75 38.73-16.53 42.23-36.7c6.859-39.75-30.91-50.56-53.48-57.03L254.8 175C227.7 167 228.5 162.3 229.6 155.8c1.875-10.94 19.25-13.38 34.81-10.91c5.812 .9062 12.22 2.906 18.3 5.031c8.359 2.844 17.44-1.531 20.36-9.875c2.906-8.344-1.516-17.47-9.859-20.38C284.6 116.7 277.8 114.9 271.6 113.8C271.7 113.2 271.1 112.6 271.1 112V96c0-8.844-7.156-16-16-16s-16 7.156-16 16v16c0 .4336 .2129 .7969 .2461 1.219C217.5 116.9 201.6 130.1 198.1 150.4C191.3 189.7 229.5 200.9 245.8 205.7l5.781 1.688c28.67 8.188 32.33 11.81 30.77 20.81c-1.875 10.94-19.3 13.34-34.84 10.91C240.2 237.1 231.1 234.7 223.1 231.8L218.6 230.3C210.3 227.3 201.2 231.7 198.2 240C195.3 248.3 199.7 257.5 207.1 260.4l4.279 1.531c8.699 3.125 18.47 6.465 28.09 8.203C240.3 270.8 239.1 271.4 239.1 272z"],
    "envelope-open-text": [512, 512, [], "f658", "M496 192C487.2 192 480 199.2 480 208v256c0 8.836-7.164 16-16 16h-416C39.16 480 32 472.8 32 464v-256C32 199.2 24.84 192 16 192S0 199.2 0 208v256C0 490.5 21.49 512 48 512h416c26.51 0 48-21.49 48-47.1V208C512 199.2 504.8 192 496 192zM64.88 276.3C65.16 277.3 65.43 278.3 65.88 279.2c.4355 .8633 1.012 1.605 1.607 2.385c.6953 .9102 1.393 1.75 2.264 2.49c.2949 .25 .4434 .6035 .7598 .8359l132.8 97.72C218.7 393.1 236.9 399.1 256 399.1s37.3-6.023 52.7-17.4l132.8-97.72c.3164-.2324 .4648-.5859 .7598-.8359c.8711-.7402 1.568-1.58 2.264-2.49c.5957-.7793 1.172-1.521 1.607-2.385c.457-.8984 .7266-1.84 1.01-2.826c.3027-1.061 .5586-2.078 .6406-3.176C447.8 272.8 448 272.4 448 272v-224C448 21.53 426.5 0 400 0h-288C85.53 0 64 21.53 64 48v224c0 .4121 .2031 .7578 .2344 1.162C64.32 274.3 64.57 275.3 64.88 276.3zM96 48C96 39.19 103.2 32 112 32h288C408.8 32 416 39.19 416 48v215.9l-126.3 92.92c-19.78 14.62-47.64 14.62-67.45 0L96 263.9V48zM352 239.1c0-8.838-7.164-16-16-16h-160c-8.836 0-16 7.162-16 16c0 8.836 7.164 15.1 16 15.1h160C344.8 255.1 352 248.8 352 239.1zM176 159.1h160c8.836 0 16-7.164 16-15.1c0-8.838-7.164-15.1-16-15.1h-160c-8.836 0-16 7.162-16 15.1C160 152.8 167.2 159.1 176 159.1z"],
    "envelopes": [640, 512, [], "e170", "M496 448H128c-35.35 0-64-28.65-64-64V112C64 103.2 56.84 96 48 96S32 103.2 32 112V384c0 53.02 42.98 96 96 96h368c8.836 0 16-7.164 16-16S504.8 448 496 448zM576 32H192C156.7 32 128 60.65 128 96v224c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C640 60.65 611.3 32 576 32zM608 320c0 17.64-14.36 32-32 32H192c-17.64 0-32-14.36-32-32V139.1L336 272c14.12 10.61 31.06 15.91 48 15.91S417.9 282.6 432 272L608 139.1V320zM608 100l-195.2 146.4c-17 12.72-40.63 12.72-57.63 0L160 100V96c0-17.64 14.36-32 32-32h384c17.64 0 32 14.36 32 32V100z"],
    "envelopes-bulk": [640, 512, ["mail-bulk"], "f674", "M80 160C88.84 160 96 152.8 96 144V64c0-17.67 14.33-32 32-32h256c17.67 0 32 14.33 32 32h32c0-35.35-28.65-64-64-64H128C92.65 0 64 28.65 64 64v80C64 152.8 71.16 160 80 160zM576 96H256C220.7 96 192 124.7 192 160h32c0-17.67 14.33-32 32-32h320c17.67 0 32 14.33 32 32v192c0 17.67-14.33 32-32 32h-144c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16H576c35.35 0 64-28.65 64-64V160C640 124.7 611.3 96 576 96zM560 256C568.9 256 576 248.9 576 240v-64C576 167.1 568.9 160 560 160h-64C487.1 160 480 167.1 480 176v64C480 248.9 487.1 256 496 256H560zM512 192h32v32h-32V192zM320 192H64C28.65 192 0 220.7 0 256v192c0 35.35 28.65 64 64 64h256c35.35 0 64-28.65 64-64V256C384 220.7 355.3 192 320 192zM352 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V313.6C44.75 323.3 64 339.3 128 384c12.75 9.625 38.38 32 64 32s51.25-22.38 64-32c64-44.75 83.25-60.75 96-70.38V448zM352 275.3c-25.62 19.12-22.38 19.12-115.3 86.38C227.3 364.8 208 384 192 384s-35.25-19.25-44.75-25.62C54.38 291.3 57.63 291.3 32 272V256c0-17.67 14.33-32 32-32h256c17.67 0 32 14.33 32 32V275.3z"],
    "equals": [448, 512, [62764], "3d", "M16 176h416C440.8 176 448 168.8 448 160s-7.156-16-16-16h-416C7.156 144 0 151.2 0 160S7.156 176 16 176zM432 336h-416C7.156 336 0 343.2 0 352s7.156 16 16 16h416c8.844 0 16-7.156 16-16S440.8 336 432 336z"],
    "eraser": [512, 512, [], "f12d", "M496 448l-172.3-.0313l174.2-173.1c9.31-9.375 13.97-21.69 13.97-34s-4.658-24.63-13.97-34l-159.1-160C328.6 36.66 316.3 32 303.1 32c-12.31 0-24.63 4.656-33.1 13.97L13.97 301.1C4.658 311.4 0 323.7 0 335.1s4.658 24.63 13.97 34l95.1 96c8.997 9 21.1 14 33.85 14h352.1c.0547 0-.0546 0 0 0C504.8 479.1 512 472.8 512 464C512 455.2 504.8 448 496 448zM292.6 68.72c3.124-3.125 7.185-4.688 11.25-4.688s8.123 1.562 11.25 4.688l159.1 160c3.124 3.125 4.686 7.188 4.686 11.25s-1.562 8.125-4.686 11.25l-116.6 116.8L175.9 185.3L292.6 68.72zM271.9 447.1h-127.1c-4.249 0-8.372-1.625-11.25-4.75l-95.97-96c-3.124-3.125-4.686-7.188-4.686-11.25s1.562-8.125 4.686-11.25l116.6-116.8l182.6 182.6l-52.73 52.63C280.3 446.3 276.1 447.1 271.9 447.1z"],
    "escalator": [640, 512, [], "e171", "M240 112c30.95-.1172 56-25.14 56-56C296 25.13 270.9 .1152 240 0C209.1 .1152 184 25.13 184 56C184 86.86 209.1 111.9 240 112zM240 32c13.25 .1133 24 10.86 24 24c0 13.18-10.82 23.95-23.88 24C226.8 79.95 216 69.18 216 56C216 42.86 226.8 32.11 240 32zM186.5 288C189.9 284.1 192 280.5 192 275.9V225.9c0-25.63 19.27-48.16 44.85-49.81c14.97-.9668 28.52 5.021 37.9 15.01C280.5 197.2 290.2 197.3 296.5 191.8c6.781-5.932 7.418-16.4 1.213-22.93C281.7 152 258.5 142.1 232.9 144.3C191.2 147.9 160 184.5 160 226.4v49.63C160 289.7 176.2 297 186.5 288zM560 128H448c-19.38 0-38.09 7.031-52.69 19.8L161.9 352H80C35.81 352 0 387.8 0 432S35.81 512 80 512H192c19.38 0 38.09-7.031 52.69-19.8L478.1 288H560C604.2 288 640 252.2 640 208S604.2 128 560 128zM560 256h-93.96l-242.4 212.1C214.9 475.8 203.6 480 192 480H80C53.53 480 32 458.5 32 432S53.53 384 80 384h93.96l242.4-212.1C425.1 164.2 436.4 160 448 160h112C586.5 160 608 181.5 608 208S586.5 256 560 256z"],
    "ethernet": [512, 512, [], "f796", "M480 192h-32V160c0-17.67-14.33-32-32-32h-32V96c0-17.67-14.33-32-32-32H160C142.3 64 128 78.33 128 96v32H96C78.33 128 64 142.3 64 160v32H32C14.33 192 0 206.3 0 224v192c0 17.67 14.33 32 32 32h448c17.67 0 32-14.33 32-32V224C512 206.3 497.7 192 480 192zM480 416h-64v-80c0-8.844-7.156-16-16-16S384 327.2 384 336V416h-64v-80c0-8.844-7.156-16-16-16S288 327.2 288 336V416H224v-80C224 327.2 216.8 320 208 320S192 327.2 192 336V416H128v-80C128 327.2 120.8 320 112 320S96 327.2 96 336V416H32V224h64V160h64V96h192v64h64v64h64V416z"],
    "euro-sign": [384, 512, [61779, "eur", "euro"], "20ac", "M335.6 455.6c1.891 8.653-3.562 17.18-12.2 19.06C306.1 478.3 290.4 480 273.9 480c-59.28 0-116.5-23.02-159.6-65.57c-27.06-26.76-46.27-59.13-56.85-94.44L32 319.1C23.16 319.1 16 312.8 16 303.1c0-8.84 7.156-15.99 16-15.99h18.55C49.03 277.5 47.1 266.8 47.1 256c0-10.82 1.033-21.46 2.549-31.98H32C23.16 224 16 216.8 16 208c0-8.84 7.156-15.96 16-15.96l25.49-.009c10.58-35.31 29.79-67.67 56.85-94.42c54.97-54.35 133.1-76.94 209.1-60.2c8.641 1.874 14.09 10.4 12.2 19.06c-1.906 8.622-10.45 13.96-19.05 12.18c-65.38-14.24-132.5 4.998-179.7 51.7C116 140.9 100.8 165.4 91.25 192h180.8c8.844 0 15.1 7.129 15.1 15.97c0 8.84-7.155 16.02-15.1 16.02H82.87c-1.773 10.49-2.871 21.14-2.871 31.99c0 10.84 1.098 21.5 2.871 31.99h189.1c8.844 0 15.1 7.143 15.1 15.98s-7.155 16-15.1 16H91.25c9.514 26.62 24.79 51.11 45.59 71.69c47.22 46.67 114.4 65.94 179.7 51.7C325.2 441.5 333.7 446.1 335.6 455.6z"],
    "exclamation": [128, 512, [10069, 10071, 61738], "21", "M64 400c-17.67 0-32 14.32-32 31.99s14.33 32 32 32s32-14.33 32-32S81.67 400 64 400zM64 352c8.844 0 16-7.166 16-16.01v-288c0-8.844-7.156-15.99-16-15.99S48 39.16 48 48v288C48 344.8 55.16 352 64 352z"],
    "expand": [448, 512, [], "f065", "M144 32h-128C7.156 32 0 39.16 0 48v128C0 184.8 7.156 192 16 192S32 184.8 32 176V64h112C152.8 64 160 56.84 160 48S152.8 32 144 32zM144 448H32v-112C32 327.2 24.84 320 16 320S0 327.2 0 336v128C0 472.8 7.156 480 16 480h128C152.8 480 160 472.8 160 464S152.8 448 144 448zM432 320c-8.844 0-16 7.156-16 16V448h-112c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16v-128C448 327.2 440.8 320 432 320zM432 32h-128C295.2 32 288 39.16 288 48S295.2 64 304 64H416v112C416 184.8 423.2 192 432 192S448 184.8 448 176v-128C448 39.16 440.8 32 432 32z"],
    "expand-wide": [512, 512, [], "f320", "M144 64h-128C7.156 64 0 71.16 0 80v128C0 216.8 7.156 224 16 224S32 216.8 32 208V96h112C152.8 96 160 88.84 160 80S152.8 64 144 64zM144 416H32V304C32 295.2 24.84 288 16 288S0 295.2 0 304v128C0 440.8 7.156 448 16 448h128C152.8 448 160 440.8 160 432S152.8 416 144 416zM496 288C487.2 288 480 295.2 480 304V416h-112c-8.844 0-16 7.156-16 16s7.156 16 16 16h128c8.844 0 16-7.156 16-16v-128C512 295.2 504.8 288 496 288zM496 64h-128C359.2 64 352 71.16 352 80S359.2 96 368 96H480v112C480 216.8 487.2 224 496 224S512 216.8 512 208v-128C512 71.16 504.8 64 496 64z"],
    "eye": [576, 512, [61550], "1f441", "M288 128C217.3 128 160 185.3 160 256s57.33 128 128 128c70.64 0 128-57.32 128-127.9C416 185.4 358.7 128 288 128zM288 352c-52.93 0-96-43.06-96-96s43.07-96 96-96c52.94 0 96 43.02 96 96.01C384 308.9 340.1 352 288 352zM572.5 238.1C518.3 115.5 410.9 32 288 32S57.69 115.6 3.469 238.1C1.563 243.4 0 251 0 256c0 4.977 1.562 12.6 3.469 17.03C57.72 396.5 165.1 480 288 480s230.3-83.58 284.5-206.1C574.4 268.6 576 260.1 576 256C576 251 574.4 243.4 572.5 238.1zM543.2 260.2C492.3 376 394.5 448 288 448c-106.5 0-204.3-71.98-255-187.3C32.58 259.6 32.05 256.9 31.1 256.2c.0547-1.146 .5859-3.783 .7695-4.363C83.68 135.1 181.5 64 288 64c106.5 0 204.3 71.98 255 187.3c.3945 1.08 .9238 3.713 .9785 4.443C543.9 256.9 543.4 259.6 543.2 260.2z"],
    "eye-dropper": [512, 512, ["eye-dropper-empty", "eyedropper"], "f1fb", "M481 30.11c-40.01-40.14-109.9-40.14-149.9 0L216.4 145l-13.06-13.08c-6.252-6.264-16.38-6.264-22.63 0c-6.252 6.262-6.252 16.41 0 22.67l176 176.3c3.125 3.131 7.221 4.697 11.31 4.697s8.189-1.566 11.31-4.697c6.25-6.262 6.25-16.41 0-22.67l-13.06-13.09l114.7-114.9C522.3 138.9 522.3 71.5 481 30.11zM458.4 157.6l-114.7 114.9L239 167.7l114.7-114.9c27.94-28.02 76.7-28.02 104.6 0C487.2 81.68 487.2 128.7 458.4 157.6zM284.7 324.3l-110.7 110.9c-8.312 8.312-19.35 12.9-31.1 12.9H100.2c-2.906 0-5.783 .7988-8.283 2.316L50.17 475.8l-13.97-14.03l25.22-41.85c1.5-2.504 2.312-5.369 2.312-8.297v-42.74c0-11.77 4.562-22.84 12.88-31.15l110.7-110.9c6.252-6.262 6.252-16.41 0-22.67c-6.25-6.262-16.38-6.262-22.63 0L53.98 315c-14.35 14.37-22.25 33.49-22.25 53.82v38.28L2.314 455.9c-3.812 6.324-2.844 14.42 2.377 19.63l31.72 31.78C39.51 510.4 43.6 512 47.73 512c2.844 0 5.719-.752 8.281-2.318l48.7-29.46h38.19c20.29 0 39.38-7.922 53.73-22.29l110.7-110.9c6.252-6.262 6.252-16.41 0-22.67C301.1 318.1 290.1 318.1 284.7 324.3z"],
    "eye-dropper-full": [512, 512, [], "e172", "M187.3 204.1c-6.25-6.262-16.38-6.262-22.63 0L53.98 315c-14.35 14.37-22.25 33.49-22.25 53.82v38.28L2.314 455.9c-3.812 6.324-2.844 14.42 2.377 19.63l31.72 31.78C39.51 510.4 43.6 512 47.73 512c2.844 0 5.719-.752 8.281-2.318l48.7-29.46h38.19c20.29 0 39.38-7.922 53.73-22.29l110.7-110.9c6.252-6.262 6.252-16.41 0-22.67L187.3 204.1zM173.1 435.3c-8.312 8.312-19.35 12.9-31.1 12.9H100.2c-2.906 0-5.783 .7988-8.283 2.316L50.17 475.8l-13.97-14.03l25.22-41.85c1.5-2.504 2.312-5.369 2.312-8.297v-42.74c0-11.77 4.562-22.84 12.88-31.15l99.34-99.53l97.48 97.48L173.1 435.3zM481 30.11c-40.01-40.14-109.9-40.14-149.9 0L216.4 145l-13.06-13.08c-6.252-6.264-16.38-6.264-22.63 0c-6.252 6.262-6.252 16.41 0 22.67l176 176.3c3.125 3.131 7.221 4.697 11.31 4.697s8.189-1.566 11.31-4.697c6.25-6.262 6.25-16.41 0-22.67l-13.06-13.09l114.7-114.9C522.3 138.9 522.3 71.5 481 30.11zM458.4 157.6l-114.7 114.9L239 167.7l114.7-114.9c27.94-28.02 76.7-28.02 104.6 0C487.2 81.68 487.2 128.7 458.4 157.6z"],
    "eye-dropper-half": [512, 512, [], "e173", "M481 30.11c-40.01-40.14-109.9-40.14-149.9 0L216.4 145l-13.06-13.08c-6.252-6.264-16.38-6.264-22.63 0c-6.252 6.262-6.252 16.41 0 22.67l176 176.3c3.125 3.131 7.221 4.697 11.31 4.697s8.189-1.566 11.31-4.697c6.25-6.262 6.25-16.41 0-22.67l-13.06-13.09l114.7-114.9C522.3 138.9 522.3 71.5 481 30.11zM458.4 157.6l-114.7 114.9L239 167.7l114.7-114.9c27.94-28.02 76.7-28.02 104.6 0C487.2 81.68 487.2 128.7 458.4 157.6zM294.1 320H94.26l93.08-93.25c6.252-6.262 6.252-16.41 0-22.67c-6.25-6.262-16.38-6.262-22.63 0L53.98 315c-14.35 14.37-22.25 33.49-22.25 53.82v38.28L2.314 455.9c-3.812 6.324-2.844 14.42 2.377 19.63l31.72 31.78C39.51 510.4 43.6 512 47.73 512c2.844 0 5.719-.752 8.281-2.318l48.7-29.46h38.19c20.29 0 39.38-7.922 53.73-22.29l110.7-110.9c6.252-6.262 6.252-16.41 0-22.67C303.7 320.7 298.8 319.4 294.1 320zM173.1 435.3c-8.312 8.312-19.35 12.9-31.1 12.9H100.2c-2.906 0-5.783 .7988-8.283 2.316L50.17 475.8l-13.97-14.03l25.22-41.85c1.5-2.504 2.312-5.369 2.312-8.297v-42.74c0-5.875 1.141-11.57 3.312-16.84h190.1L173.1 435.3z"],
    "eye-evil": [640, 512, [], "f6db", "M640 256c0-7.281-4.334-14.58-13.02-16.89l-111.1-30.35c-4.75-6.5-10.17-13.48-16.04-20.36c1.375-2.125 55.22-88.04 55.22-88.04c1.827-2.933 2.658-6.033 2.658-8.984c0-9.4-8.222-17.68-18.43-17.68c-2.155 0-4.433 .3833-6.702 1.197l-119.7 43.37c-9.748-4.875-19.84-8.846-30.71-12.35l-44.45-95.17C333.5 3.629 326.7 0 319.1 0S306.5 3.629 303.1 10.75L258.7 105.9c-10.87 3.5-20.97 7.471-30.72 12.35c-117.4-42.48-121.9-44.54-125.3-44.54L101.5 73.73c-10.17 0-18.4 8.264-18.4 17.65c0 2.957 .8237 6.031 2.65 8.994c0 0 53.85 85.91 55.22 88.04C135.1 195.3 129.7 202.3 124.1 208.8L13.01 239.1C4.323 241.4-.0001 248.7-.0001 256c0 7.281 4.323 14.58 13.01 16.89l111.1 30.35c4.75 6.5 10.11 13.33 15.98 20.33c-1.375 2.125-55.16 88.06-55.16 88.06c-1.827 2.959-2.656 6.044-2.656 9.003c0 9.415 8.228 17.67 18.42 17.67c2.166 0 4.433-.3812 6.712-1.199l119.7-43.37c9.748 4.875 19.85 8.846 30.72 12.35l44.45 95.16C306.5 508.4 313.2 512 319.1 512s13.5-3.629 16.87-10.75l44.45-95.16c10.87-3.5 20.96-7.471 30.71-12.35l119.7 43.37c2.285 .8138 4.544 1.195 6.709 1.195c10.23 0 18.43-8.3 18.43-17.68c0-2.964-.8206-6.041-2.656-8.987c0 0-53.79-85.93-55.16-88.06c5.875-7 11.23-13.83 15.98-20.33l111.1-30.35C635.7 270.6 640 263.3 640 256zM495.6 275.4c-14.1 20.5-12.62 17.5-36.25 45.5l45.75 72.5L410.1 359c-24.75 12.38-24.12 12.12-51.87 21L320 461.8L281.8 380c-27.75-8.875-26.1-8.625-51.87-21l-94.99 34.38l45.75-72.5c-23.62-28-21.25-25-36.25-45.5L72.9 256l71.49-19.38c14.87-20.5 12.5-17.38 36.5-45.75L134.9 118.6L229.9 153C254.6 140.6 253.9 140.9 281.8 132L320 50.25L358.2 132c27.75 8.875 26.1 8.625 51.87 21l94.99-34.38L459.1 191c23.87 28.12 21.5 25 36.5 45.63L567.1 256L495.6 275.4zM390.7 200.9c-11.89 0-29.03 12.51-70.69 12.51c-41.58 0-58.71-12.57-70.98-12.57c-28.76 0-33.01 28-33.01 47.19c0 6.472 .5959 13.08 1.843 19.78c3.021 16.22 26.01 84.23 102.1 84.23c57.49 0 103.1-46.51 103.1-104C423.1 201.1 395.8 200.9 390.7 200.9zM319.1 320c-39.34 0-72.04-31.86-72.04-72.95c0-4.939 .4531-9.681 1.281-14.05C266.7 239.4 285.1 242.6 304 244V272C304 280.8 311.2 288 320 288s16-7.156 16-16V244c19.09-1.414 37.7-4.547 54.56-10.35C391.5 238.4 391.1 243.2 391.1 248C391.1 287.7 359.7 320 319.1 320z"],
    "eye-low-vision": [640, 512, ["low-vision"], "f2a8", "M633.9 483.4L25.9 3.42C18.1-2.033 8.936-.8301 3.436 6.061c-5.469 6.938-4.281 17 2.656 22.49l608 480C617 510.9 620.5 512 624 512c4.719 0 9.406-2.094 12.56-6.078C642 498.1 640.8 488.9 633.9 483.4zM272.9 137.2l30.91 24.41C309.1 160.7 314.4 160 320 160c50.78 0 92.04 39.74 95.36 89.74l30.82 24.33C447 268.1 448 262.2 448 256.1C448 185.4 390.7 128 320 128C303.3 128 287.5 131.4 272.9 137.2zM320 64c106.5 0 204.3 71.98 255 187.3c.3945 1.08 .9238 3.713 .9785 4.443c-.0547 1.145-.5859 3.783-.7695 4.361c-12.84 29.22-28.69 55.61-46.88 78.79l25.05 19.78c20.06-25.52 37.33-54.3 51.13-85.7c1.906-4.43 3.469-12.07 3.469-17.02c0-4.977-1.562-12.6-3.469-17.03C550.3 115.5 442.9 32 320 32c-48.13 0-93.8 12.96-134.9 35.95l27.74 21.9C246.4 73.33 282.6 64 320 64zM105.1 163.5C99.09 158 89.05 159.2 83.5 166C77.98 172.9 79.11 182.1 85.1 188.5l320 256C408.1 446.9 412.5 448 415.1 448c4.703 0 9.344-2.062 12.52-6c5.516-6.906 4.391-16.97-2.5-22.5L105.1 163.5zM65.1 216.3C59.11 210.8 49.05 211.9 43.5 218.8c-5.516 6.906-4.391 16.97 2.5 22.5l288 230.4c2.953 2.359 6.485 3.5 9.985 3.5c4.703 0 9.344-2.062 12.52-6c5.516-6.906 4.391-16.97-2.5-22.5L65.1 216.3zM57.1 297.9c-6.906-5.5-16.95-4.344-22.5 2.5c-5.516 6.906-4.391 16.97 2.5 22.5l192 153.6C232.1 478.9 236.5 480 239.1 480c4.703 0 9.344-2.062 12.52-6c5.516-6.906 4.391-16.97-2.5-22.5L57.1 297.9z"],
    "eye-slash": [640, 512, [], "f070", "M272.9 137.2l30.91 24.41c5.301-.9102 10.67-1.638 16.23-1.638c50.78 0 92.05 39.74 95.36 89.74l30.82 24.33C447 268.1 448 262.2 448 256.1C448 185.4 390.7 128 320 128C303.3 128 287.5 131.4 272.9 137.2zM320 448c-106.5 0-204.3-71.98-255-187.3C64.58 259.6 64.05 256.9 63.1 256.2c.0547-1.146 .5859-3.783 .7695-4.363c12.84-29.22 28.7-55.61 46.89-78.8l-25.05-19.78c-20.06 25.52-37.34 54.31-51.13 85.71C33.56 243.4 31.1 251 31.1 256c0 4.977 1.562 12.6 3.469 17.03c54.25 123.4 161.6 206.1 284.5 206.1c48.13 0 93.81-12.96 134.9-35.96l-27.74-21.9C393.6 438.7 357.4 448 320 448zM320 64c106.5 0 204.3 71.98 255 187.3c.3945 1.08 .9238 3.713 .9785 4.443c-.0547 1.145-.5859 3.783-.7695 4.361c-12.84 29.22-28.69 55.61-46.88 78.79l25.05 19.78c20.06-25.52 37.33-54.3 51.13-85.7c1.906-4.43 3.469-12.07 3.469-17.03c0-4.977-1.562-12.6-3.469-17.03c-54.25-123.4-161.6-206.1-284.5-206.1c-48.13 0-93.8 12.96-134.9 35.95l27.74 21.9C246.4 73.33 282.6 64 320 64zM320 384c16.68 0 32.56-3.42 47.17-9.229l-30.92-24.41c-5.307 .9121-10.68 1.644-16.25 1.644c-50.8 0-92.09-39.78-95.37-89.76L193.8 237.9C192.1 243.9 192 249.8 192 256C192 326.7 249.3 384 320 384zM633.9 483.4L25.9 3.42C18.1-2.033 8.936-.8301 3.436 6.061c-5.469 6.938-4.281 17 2.656 22.49l608 480C617 510.9 620.5 512 624 512c4.719 0 9.406-2.094 12.56-6.078C642 498.1 640.8 488.9 633.9 483.4z"],
    "eyes": [640, 512, [], "e367", "M574.7 78.44C545.2 48.06 509.6 32 472 32c-67.08 0-124.9 52.84-151.9 128.8C308.1 128.1 292.3 100.7 270.7 78.44C241.2 48.06 205.6 32 168 32C75.38 32 0 132.5 0 256s75.38 224 168 224c67.2 0 125.2-53.02 152-129.2C346.8 426.1 404.8 480 472 480C564.6 480 640 379.5 640 256C640 185.8 616.2 121.1 574.7 78.44zM32 288c0-26.47 21.53-48 48-48S128 261.5 128 288s-21.53 48-48 48S32 314.5 32 288zM168 448c-46.61 0-87.78-33.29-112.3-83.88C63.38 366.6 71.52 368 80 368C124.1 368 160 332.1 160 288S124.1 208 80 208c-18.64 0-34.14 6.664-46.1 17.38C44.33 134 100.4 64 168 64c28.78 0 56.38 12.72 79.75 36.75C282.1 136.1 304 195 304 256C304 361.9 243 448 168 448zM336 288c0-26.47 21.53-48 48-48s48 21.53 48 48s-21.53 48-48 48S336 314.5 336 288zM472 448c-46.72 0-87.99-33.44-112.5-84.23C367.3 366.3 375.4 368 384 368c44.13 0 80-35.88 80-80S428.1 208 384 208c-17.06 0-32.8 5.457-45.8 14.58C349.5 132.6 405.1 64 472 64c28.78 0 56.38 12.72 79.75 36.75C586.1 136.1 608 195 608 256C608 361.9 547 448 472 448z"],
    "f": [320, 512, [102], "46", "M320 48C320 56.84 312.8 64 304 64H32v192h208C248.8 256 256 263.2 256 272S248.8 288 240 288H32v176C32 472.8 24.84 480 16 480S0 472.8 0 464v-416C0 39.16 7.156 32 16 32h288C312.8 32 320 39.16 320 48z"],
    "face-angry": [512, 512, [62806, "angry"], "1f620", "M255.9 335.9c-31.24 0-60.47 13.83-80.57 37.83c-5.691 6.875-4.723 17 2.059 22.5c6.781 5.625 16.83 4.875 22.52-2c27.85-33.38 84.16-33.38 112 0c5.328 6.5 15.5 8 22.52 2c6.781-5.625 7.75-15.75 2.059-22.5C316.5 349.8 287.2 335.9 255.9 335.9zM200 240c0-3.812-1.08-7.289-2.662-10.49C202.9 231.2 204.8 232 208 232c6.875 0 13.3-4.445 15.36-11.38c2.562-8.453-2.294-17.34-10.76-19.89l-79.94-24C124.3 174.3 115.3 178.9 112.7 187.4C110.2 195.8 115 204.7 123.5 207.3l40.68 12.29C157 223.7 152 231.1 152 240c0 13.25 10.75 24 24 24S200 253.3 200 240zM379.5 176.7l-80.03 24c-8.469 2.547-13.23 11.43-10.67 19.89C290.8 227.6 297.2 232 304.1 232c3.23 0 5.2-.8711 10.61-2.492C313.1 232.7 312 236.2 312 240c0 13.25 10.75 24 24 24s24-10.75 24-24c0-8.863-5.029-16.29-12.18-20.44l40.77-12.29c8.469-2.547 13.33-11.43 10.76-19.89C396.8 178.9 387.9 174.3 379.5 176.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-angry-horns": [640, 512, [], "e368", "M319.9 351.1c-51.58 0-84.31 37.03-84.31 48.07c0 11.05 9.725 15.96 16.1 15.96c16.85 0 20.82-30.78 68.19-30.78c47.54 0 51.24 30.81 68.32 30.81c3.556 0 7.166-1.193 10.19-3.779c3.8-3.152 5.774-7.718 5.774-12.31C404.2 389.1 371.5 351.1 319.9 351.1zM263.9 272c0-3.812-1.08-7.289-2.661-10.49c5.534 1.66 7.492 2.492 10.69 2.492c6.873 0 13.3-4.445 15.36-11.38c.4639-1.531 .6846-3.076 .6846-4.595c0-6.869-4.512-13.21-11.45-15.29L196.7 208.7c-1.513-.4388-3.046-.6489-4.558-.6489c-6.885 0-13.32 4.357-15.4 11.3c-.4641 1.531-.6848 3.077-.6848 4.596c0 6.869 4.511 13.21 11.44 15.29l40.67 12.29C220.1 255.7 215.1 263.1 215.1 272c0 13.25 10.74 23.1 23.99 23.1S263.9 285.3 263.9 272zM447.1 208.1c-1.515 0-3.056 .2123-4.581 .6558l-80.01 23.1c-6.916 2.08-11.36 8.391-11.36 15.24c0 1.536 .2235 3.098 .6926 4.646c2.062 6.937 8.395 11.38 15.27 11.38c3.23 0 5.198-.8711 10.6-2.492c-1.582 3.203-2.661 6.68-2.661 10.49c0 13.25 10.74 23.1 23.99 23.1s23.99-10.75 23.99-23.1c0-8.863-5.028-16.29-12.17-20.44l40.77-12.29c6.933-2.086 11.44-8.422 11.44-15.29c0-1.519-.2207-3.065-.6848-4.596C461.2 212.4 454.8 208.1 447.1 208.1zM640 16.25C640 2.253 626.8 0 623.1 0c-9.427 0-46.61 26.29-143.7 56.69c-45.49-36.62-102.1-56.69-160.4-56.69c-58.24 0-114.7 20.03-160.2 56.62C64.6 26.81 25.49 .2961 16.93 .2961C7.985 .2961 0 7.275 0 17.29c0 1.992 10.43 84.53 72.17 174.1c-5.436 21.06-8.248 42.47-8.248 63.72C63.93 397.2 178.7 512 319.9 512s255.9-114.8 255.9-255.1c0-21.12-2.656-42.41-8.029-63.37C630.5 100.9 640 18.27 640 16.25zM554.5 153.7c-16.05-36.76-22.47-41.71-31.63-41.71c-8.763 0-15.96 7.146-15.96 16.02c0 2.914 .7969 5.863 2.469 8.509c18.4 29.15 25.59 57.47 25.59 57.47l-.0034-.0135c0 0 .0018 .0073 .0081 .0324c-.0063-.0251-.0081-.0324-.0081-.0324s8.877 27.72 8.877 62.01c0 123.5-100.5 223.1-223.9 223.1s-223.9-100.5-223.9-223.1c0-20.75 3.031-41.69 8.967-62.29c.0004-.0008 .0006-.0011 .0006-.0011s-.0011 .0023-.0011 .0023S104.9 193.7 104.9 193.7C104.9 193.7 104.9 193.7 104.9 193.7s.0001-.0003 .0006-.0011c13.28-45.94 27.96-54.4 27.96-65.69c0-8.794-7.067-15.98-15.94-15.98c-9.443 0-15.77 5.405-31.52 41.33C64.06 118.1 48.06 81.57 38.28 44.53c53.43 24.45 118.6 45.96 125 45.96c17.47 0 55.31-58.49 156.6-58.49c98.57 0 142.3 58.55 156.8 58.55c6.439 0 71.47-21.4 125.1-45.96C591.8 82.23 575.8 118.7 554.5 153.7z"],
    "face-anguished": [512, 512, [], "e369", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM208 112C208 103.2 200.8 96 192 96C138 96 102.2 131.2 100.7 132.7C94.45 138.9 94.45 148.1 100.7 155.3C103.8 158.4 107.9 159.1 112 159.1c4.062 0 8.128-1.536 11.25-4.599C123.5 155.1 151.6 128 192 128C200.8 128 208 120.8 208 112zM411.3 132.7C409.8 131.2 374 96 320 96c-8.844 0-16 7.156-16 16S311.2 128 320 128c40.42 0 68.45 27.09 68.73 27.38C391.9 158.5 395.9 160 400 160c4.094 0 8.188-1.562 11.31-4.688C417.6 149.1 417.6 138.9 411.3 132.7zM256 304c-52.94 0-96 43.06-96 96C160 408.8 167.2 416 176 416h160c8.844 0 16-7.156 16-16C352 347.1 308.9 304 256 304zM194 384C201.1 356.4 226.2 336 256 336s54.86 20.44 61.97 48H194zM336 200C322.7 200 312 210.7 312 224s10.71 24 24.04 24C349.3 248 360 237.3 360 224S349.3 200 336 200zM200 224c0-13.31-10.71-24-24.04-24C162.7 200 152 210.7 152 224s10.71 24 23.96 24C189.3 248 200 237.3 200 224z"],
    "face-anxious-sweat": [576, 512, [], "e36a", "M44.84 281.6C24.38 308.6 0 345.7 0 369c0 34.75 28.72 62.1 64 62.1s64-28.25 64-63c0-18.31-15.06-47.69-44.72-87.19C74.28 269.5 53.59 269.7 44.84 281.6zM64 400c-17.66 0-32-13.9-32-30.1c0-7.875 10.91-30.28 31.97-59.44C86.03 340.2 96 361.3 96 369C96 386.1 81.66 400 64 400zM344 272c0 13.31 10.71 24 24.04 24c13.25 0 23.96-10.69 23.96-24s-10.71-24-23.96-24C354.7 248 344 258.7 344 272zM288 0C160.2 0 51.13 95.38 34.25 221.9C33.08 230.7 39.23 238.7 48 239.9c8.766 1.094 16.8-5 17.97-13.75C80.72 115.4 176.2 32 288 32c123.5 0 224 100.5 224 224s-100.5 224-224 224c-48.95 0-95.42-15.5-134.4-44.78c-7.062-5.375-17.11-3.844-22.39 3.156c-5.312 7.062-3.891 17.09 3.172 22.41C178.9 494.3 232 512 288 512c141.2 0 256-114.8 256-256S429.2 0 288 0zM192 128.7c-4.844 0-9.656 2.219-12.78 6.375C160.1 160.5 134.6 180.7 105.6 193.4C97.5 196.9 93.82 206.4 97.35 214.5C100.9 222.5 110.4 226.1 118.4 222.7c34.06-14.88 63.94-38.53 86.38-68.38C210.1 147.3 208.7 137.2 201.6 131.9C198.7 129.7 195.3 128.7 192 128.7zM208 400C208 408.8 215.2 416 224 416h128c8.844 0 16-7.156 16-16c0-44.13-35.89-80-80-80S208 355.9 208 400zM333.3 384H242.7C249.3 365.4 267.1 352 288 352S326.7 365.4 333.3 384zM457.6 222.7c8.125 3.438 17.53-.1562 21.06-8.25s-.1562-17.53-8.25-21.06c-29.06-12.69-54.5-32.84-73.63-58.28c-3.125-4.188-7.938-6.406-12.78-6.406c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38C393.6 184.2 423.5 207.8 457.6 222.7zM208 248c-13.34 0-24.04 10.69-24.04 24s10.71 24 24.04 24c13.25 0 23.96-10.69 23.96-24S221.3 248 208 248z"],
    "face-astonished": [512, 512, [], "e36b", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM208 112C208 103.2 200.8 96 192 96C138 96 102.2 131.2 100.7 132.7C94.47 138.9 94.47 148.1 100.7 155.3C103.8 158.4 107.9 159.1 112 159.1c4.062 0 8.156-1.538 11.25-4.6C123.5 155.1 151.6 128 192 128C200.8 128 208 120.8 208 112zM411.3 132.7C409.8 131.2 374 96 320 96c-8.844 0-16 7.156-16 16S311.2 128 320 128c40.41 0 68.47 27.09 68.75 27.38C391.8 158.5 395.9 160 400 160c4.094 0 8.188-1.562 11.31-4.688C417.6 149.1 417.6 138.9 411.3 132.7zM256 288c-35.28 0-64 28.72-64 64v32c0 35.28 28.72 64 64 64s64-28.72 64-64v-32C320 316.7 291.3 288 256 288zM288 384c0 17.66-14.34 32-32 32s-32-14.34-32-32v-32c0-17.66 14.34-32 32-32s32 14.34 32 32V384zM200 224c0-13.31-10.71-24-24.04-24C162.7 200 152 210.7 152 224s10.71 24 23.96 24C189.3 248 200 237.3 200 224zM336 200C322.7 200 312 210.7 312 224s10.71 24 24.04 24C349.3 248 360 237.3 360 224S349.3 200 336 200z"],
    "face-confounded": [512, 512, [], "e36c", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM376.8 369.7l-23.38 11.69l-36.97-26.41c-5.312-3.75-12.34-3.938-17.78-.5313L256 381.1l-42.72-26.69c-5.438-3.406-12.5-3.219-17.78 .5313l-36.97 26.41l-23.38-11.69c-7.906-3.938-17.47-.7187-21.47 7.156c-3.938 7.906-.75 17.5 7.156 21.47l32 16c5.281 2.656 11.62 2.156 16.47-1.281l36.09-25.78l42.13 26.31c5.188 3.25 11.75 3.25 16.94 0l42.13-26.31l36.09 25.78C345.5 415 348.7 416 352 416c2.438 0 4.906-.5625 7.156-1.688l32-16c7.906-3.969 11.09-13.56 7.156-21.47C394.3 368.9 384.8 365.7 376.8 369.7zM296.8 270.3l64 32c2.297 1.141 4.734 1.688 7.141 1.688c5.875 0 11.52-3.234 14.33-8.844c3.953-7.906 .75-17.52-7.156-21.47L339.8 255.1l35.38-17.69c7.906-3.953 11.11-13.56 7.156-21.47c-3.969-7.906-13.56-11.08-21.47-7.156l-64 32c-5.422 2.719-8.843 8.254-8.843 14.32S291.4 267.6 296.8 270.3zM129.7 295.1c2.812 5.609 8.453 8.844 14.33 8.844c2.406 0 4.844-.5469 7.141-1.688l64-32c5.422-2.719 8.845-8.246 8.845-14.31S220.6 244.4 215.2 241.7l-64-32C143.3 205.8 133.6 208.9 129.7 216.8S128.9 234.4 136.8 238.3l35.38 17.69L136.8 273.7C128.9 277.6 125.7 287.2 129.7 295.1z"],
    "face-confused": [512, 512, [], "e36d", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM336 232C349.3 232 360 221.3 360 208s-10.71-24-23.96-24C322.7 184 312 194.7 312 208S322.7 232 336 232zM352 304c-133.1 0-200.5 65.88-203.3 68.69c-6.219 6.219-6.219 16.31-.0313 22.56C151.8 398.4 155.9 399.1 160 399.1s8.156-1.531 11.28-4.625C171.9 394.8 232.9 336 352 336c8.844 0 16-7.156 16-16S360.8 304 352 304z"],
    "face-cowboy-hat": [512, 512, [], "e36e", "M423.9 209.5c-8.031 3.688-11.56 13.19-7.875 21.22C426.6 253.7 432 278.4 432 304c0 97.03-78.95 176-176 176s-176-78.97-176-176c0-25.59 5.359-50.28 15.95-73.31C99.64 222.7 96.11 213.2 88.08 209.5C80.03 205.7 70.55 209.3 66.86 217.3C54.34 244.6 48 273.8 48 304c0 114.7 93.31 208 207.1 208s207.1-93.31 207.1-208c0-30.25-6.343-59.41-18.86-86.69C441.4 209.3 431.1 205.8 423.9 209.5zM175.1 296C189.3 296 200 285.3 200 272S189.3 248 175.1 248C162.7 248 152 258.7 152 272S162.7 296 175.1 296zM360 272c0-13.31-10.71-24-24.04-24C322.7 248 312 258.7 312 272s10.71 24 23.96 24C349.3 296 360 285.3 360 272zM128.4 361.4C137.1 413.2 201.4 448 256 448s118.9-34.81 127.6-86.84c1.531-10-2.156-19.88-9.859-26.41c-7.547-6.375-17.62-8.406-27-5.375c-43.81 14.25-137.7 14.25-181.6 0c-9.375-3.094-19.59-.9687-27.16 5.5C130.4 341.5 126.8 351.3 128.4 361.4zM350.8 361.6C340.9 393.1 294.4 416 256 416s-84.91-22.91-94.74-54.38C210.6 375.6 301.4 375.7 350.8 361.6zM256 224c190.1 0 231-146.4 231.4-147.9c1.797-6.812-1.094-14-7.109-17.69c-6-3.719-13.75-3-19.03 1.656c-.4395 .4082-30.39 25.73-88.78 43.34C356.1 35.08 332.9 0 303.2 0c-11.84 0-23.36 4.406-34.27 13.09c-7.578 6.156-18.22 6.125-25.89-.0313C232.2 4.406 220.8 0 208.9 0C179 0 156.3 34.19 139.6 103.4C81.11 85.83 51.11 60.47 50.67 60.06C45.39 55.41 37.64 54.69 31.64 58.41C25.62 62.09 22.73 69.28 24.53 76.09C24.92 77.56 65.89 224 256 224zM208.9 32c4.375 0 9.141 2.031 14.12 6.031c19.41 15.59 46.56 15.62 65.94 .0313C294 34.03 298.8 32 303.2 32c7.818 0 24.54 22.15 38.35 79.35C316.8 116.5 288.5 120 256 120c-32.42 0-60.72-3.5-85.46-8.625C185.5 49.44 201.1 32 208.9 32zM256 152c79.03 0 137-18.28 174.6-35.91C403.8 150.1 351.8 192 256 192c-97 0-148.9-41.28-175.4-76.25C118.2 133.5 176.4 152 256 152z"],
    "face-disappointed": [512, 512, [], "e36f", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM212.3 242.7c-2.533-2.609-5.709-4.15-9.012-4.666C198.5 237.2 193.4 238.7 189.7 242.3C166.8 264.5 138.6 280.5 107.9 288.6C99.39 290.8 94.29 299.6 96.53 308.1c2.27 8.547 11.1 13.56 19.54 11.4c35.95-9.438 69.12-28.2 95.89-54.22C218.3 259.1 218.5 248.1 212.3 242.7zM404.1 288.6c-30.67-8.049-58.92-24.04-81.74-46.22c-3.732-3.656-8.83-5.105-13.62-4.357c-3.303 .5176-6.479 2.057-8.98 4.662c-6.193 6.312-6.035 16.44 .3047 22.6c26.75 26.06 59.92 44.82 95.9 54.25c8.559 2.141 17.3-2.861 19.54-11.4C417.7 299.6 412.6 290.8 404.1 288.6zM256 352c-50.63 0-76.25 37.53-77.31 39.13c-4.906 7.344-2.906 17.28 4.438 22.19c7.312 4.875 17.25 2.938 22.19-4.438C205.5 408.6 222.3 384 256 384c33.13 0 50.06 23.97 50.69 24.88C309.8 413.5 314.9 416 320 416c3.062 0 6.148-.875 8.867-2.688c7.344-4.906 9.344-14.84 4.438-22.19C332.3 389.5 306.6 352 256 352z"],
    "face-disguise": [576, 512, [], "e370", "M200 192C186.7 192 176 202.7 176 216c0 13.25 10.75 24 24 24S224 229.3 224 216C224 202.7 213.3 192 200 192zM544 176h-12.93C497.5 73.83 401.4 0 288 0S78.54 73.83 44.93 176H32C23.16 176 16 183.2 16 192S23.16 208 32 208h4.652C33.7 223.6 32 239.6 32 256c0 141.4 114.6 256 256 256s256-114.6 256-256c0-16.42-1.697-32.44-4.652-48H544c8.844 0 16-7.156 16-16S552.8 176 544 176zM288 32c95.3 0 176.7 59.93 208.1 144h-22.87c-5.428-15.22-14.47-28.58-26.27-39.17C447.8 136.5 448 136.3 448 136v-16c0-8.844-7.156-16-16-16c-8.141 0-14.59 6.156-15.6 14.02C411.1 116.1 405.7 114.6 400 113.6V96c0-8.844-7.156-16-16-16S368 87.16 368 96v17.62c-5.533 .9355-10.83 2.436-16 4.279V112C352 103.2 344.8 96 336 96S320 103.2 320 112v24c0 .2949 .1523 .5391 .168 .8301C300.6 154.4 288 179.7 288 208v.5039c-.0176 0 .0176 0 0 0s.0176 0 0 0V208c0-28.34-12.58-53.58-32.17-71.17C255.8 136.5 256 136.3 256 136V112C256 103.2 248.8 96 240 96S224 103.2 224 112v5.896c-5.17-1.844-10.47-3.344-16-4.279V96c0-8.844-7.156-16-16-16S176 87.16 176 96v17.62C170.3 114.6 164.9 116.1 159.6 118C158.6 110.2 152.1 104 144 104C135.2 104 128 111.2 128 120v16c0 .2949 .1523 .5391 .168 .8301C116.4 147.4 107.3 160.8 101.9 176H79.03C111.3 91.93 192.7 32 288 32zM213.5 327.2l17.69-8.844C233.1 316.9 236.3 314.7 237.9 311.9L274.1 248.6C278.3 241.3 285.2 240.5 288 240.5s9.734 .7813 13.89 8.062l36.22 63.38c1.562 2.75 3.906 4.969 6.734 6.375l17.7 8.844C365.9 328.8 368 332.2 368 336s-2.094 7.156-5.469 8.844l-53.06 26.53c-13.44 6.688-29.5 6.688-42.94 0l-53.08-26.53C210.1 343.2 208 339.8 208 336S210.1 328.8 213.5 327.2zM192 272c-35.3 0-64-28.72-64-64s28.7-64 64-64s64 28.72 64 64c0 4.955-.6934 9.727-1.764 14.36C251.2 225.4 248.5 228.8 246.3 232.7l-14.11 24.69C221.2 266.4 207.3 272 192 272zM343.8 257.4l-14.11-24.69c-2.207-3.865-4.885-7.307-7.908-10.33C320.7 217.7 320 212.1 320 208c0-35.28 28.7-64 64-64s64 28.72 64 64s-28.7 64-64 64C368.7 272 354.8 266.4 343.8 257.4zM288 480c-123.5 0-224-100.5-224-224c0-16.49 1.912-32.52 5.309-48H96c0 52.7 42.69 95.54 95.3 95.93C181.8 311.8 176 323.3 176 336c0 15.96 8.871 30.33 23.14 37.46L179.5 398c-5.516 6.906-4.391 16.97 2.5 22.5C184.1 422.8 188.5 424 191.1 424c4.703 0 9.344-2.062 12.52-6l23.92-29.9l7.254 3.629l-10.53 26.33c-3.281 8.188 .7187 17.5 8.922 20.78C236 439.6 238 440 240 440c6.344 0 12.36-3.812 14.86-10.06l10.13-25.33C267.3 405.3 269.6 406.1 272 406.6V432c0 8.844 7.156 16 16 16s16-7.156 16-16v-25.44c2.385-.4844 4.664-1.26 7.006-1.961l10.13 25.33C323.6 436.2 329.7 440 336 440c1.984 0 4-.375 5.938-1.156c8.203-3.281 12.2-12.59 8.922-20.78l-10.54-26.34l7.254-3.629L371.5 418c3.172 3.938 7.812 6 12.52 6c3.5 0 7.031-1.156 9.984-3.5c6.891-5.531 8.016-15.59 2.5-22.5l-19.64-24.55C391.1 366.3 400 351.1 400 336c0-12.71-5.789-24.23-15.29-32.07C437.3 303.5 480 260.7 480 208h26.69C510.1 223.5 512 239.5 512 256C512 379.5 411.5 480 288 480zM400 216C400 202.7 389.3 192 376 192S352 202.7 352 216c0 13.25 10.75 24 24 24S400 229.3 400 216z"],
    "face-dizzy": [512, 512, ["dizzy"], "f567", "M227.3 243.3c6.176-6.125 6.176-16.38 0-22.5L198.6 192l28.7-28.75c6.176-6.125 6.176-16.38 0-22.5c-6.176-6.25-16.35-6.25-22.64 0L175.1 169.4L147.3 140.8c-6.176-6.25-16.35-6.25-22.52 0c-6.176 6.125-6.176 16.38 0 22.5L153.4 192L124.7 220.8c-6.176 6.125-6.176 16.38 0 22.5c6.176 6.25 16.35 6.375 22.52 0l28.7-28.62l28.7 28.62C210.1 249.6 221.1 249.6 227.3 243.3zM256 288c-35.36 0-64.04 28.75-64.04 64S220.6 416 256 416s64.04-28.75 64.04-64S291.4 288 256 288zM256 384c-17.56 0-31.97-14.38-31.97-32S238.4 320 256 320s31.97 14.38 31.97 32S273.6 384 256 384zM387.3 140.8c-6.176-6.25-16.35-6.25-22.52 0l-28.7 28.62l-28.7-28.62c-6.297-6.25-16.47-6.25-22.64 0c-6.176 6.125-6.176 16.38 0 22.5L313.4 192l-28.7 28.75c-6.176 6.125-6.176 16.38 0 22.5c6.176 6.25 16.35 6.375 22.64 0l28.7-28.62l28.7 28.62c6.176 6.25 16.35 6.375 22.52 0c6.176-6.125 6.176-16.38 0-22.5L358.6 192l28.7-28.75C393.6 157.1 393.6 146.9 387.3 140.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-downcast-sweat": [512, 512, [], "e371", "M178.7 391.1c-4.906 7.344-2.906 17.28 4.438 22.19c7.281 4.875 17.28 2.938 22.19-4.438C205.5 408.6 222.3 384 256 384c33.13 0 50.06 23.97 50.69 24.88C309.8 413.5 314.9 416 320 416c3.062 0 6.148-.875 8.867-2.688c7.344-4.906 9.344-14.84 4.438-22.19C332.3 389.5 306.6 352 256 352S179.8 389.5 178.7 391.1zM208 256h-96C103.2 256 96 263.2 96 272S103.2 288 112 288h96C216.8 288 224 280.8 224 272S216.8 256 208 256zM400 288C408.8 288 416 280.8 416 272S408.8 256 400 256h-96C295.2 256 288 263.2 288 272S295.2 288 304 288H400zM56 160C86.88 160 112 132.8 112 99.38c0-23.11-26.69-67.63-42.58-92.09C66.47 2.734 61.41 0 55.98 0S45.52 2.75 42.56 7.297C26.67 31.86 0 76.48 0 99.38C0 132.8 25.13 160 56 160zM56.02 46.38C73.27 75.67 80 94 80 99.38C80 115.2 69.23 128 56 128C42.98 128 32 114.9 32 99.38C32 94.06 38.75 75.78 56.02 46.38zM256 0C214.4 0 173.1 10.22 136.5 29.55C128.7 33.67 125.7 43.36 129.9 51.17C133.1 58.98 143.6 62 151.5 57.83C183.4 40.94 219.6 32 256 32c123.5 0 224 100.5 224 224s-100.5 224-224 224s-224-100.5-224-224c0-20.3 2.703-40.39 8.047-59.73C42.41 187.7 37.41 178.9 28.89 176.6C20.34 174.3 11.55 179.2 9.203 187.7C3.094 209.9 0 232.8 0 256c0 141.2 114.8 256 256 256s256-114.8 256-256S397.2 0 256 0z"],
    "face-drooling": [512, 512, [], "e372", "M511.6 241.2c-8.172-140.9-129.5-248.1-270.4-240.8C172.9 4.375 110.3 34.69 64.83 85.75c-45.48 51.06-68.34 116.8-64.39 185c7.359 126.1 108.4 230.4 234.1 240.4c.4219 .0313 .8516 .0469 1.273 .0469c8.266 0 15.27-6.344 15.94-14.72C253.3 487.7 246.8 480 237.1 479.3c-110.8-8.812-199.1-99.25-205.6-210.4C28.92 209.2 48.94 151.7 88.72 107c39.8-44.69 94.59-71.19 154.3-74.66c123.5-7.156 229.4 87.38 236.6 210.7c3.328 57.69-15.41 113.8-52.77 157.8c-5.719 6.719-4.891 16.81 1.859 22.53c6.719 5.75 16.83 4.953 22.55-1.828C493.1 371.2 515.4 307.2 511.6 241.2zM122.9 223.1C124.6 223.7 126.3 223.1 128 223.1c6.625 0 12.84-4.188 15.16-10.81C143.7 211.6 156.4 176 192 176c8.844 0 16-7.156 16-16S200.8 144 192 144c-58.84 0-78.38 56.53-79.19 58.94C110 211.3 114.5 220.3 122.9 223.1zM368.8 213.2C371.1 219.8 377.3 224 384 224c1.688 0 3.375-.25 5.062-.8125c8.375-2.812 12.91-11.88 10.12-20.25C398.4 200.5 378.8 144 320 144c-8.844 0-16 7.156-16 16s7.156 16 16 16C355.6 176 368.3 211.6 368.8 213.2zM391.2 305.8c-7.812-3.906-17.44-.8438-21.5 6.969C368.6 315 340.1 368 256 368c-83.97 0-112.5-52.78-113.7-55.25C138.3 304.9 128.7 301.7 120.8 305.7c-7.906 3.969-11.11 13.56-7.156 21.47C115.2 330.1 151.3 400 256 400c11.6 0 22.04-1.137 32-2.666V464c0 8.836 7.164 16 16 16s16-7.164 16-16v-74.38c12.44-4.348 22.84-9.721 32-15.52V496c0 8.836 7.164 16 16 16s16-7.164 16-16v-148.9c9.119-10.53 13.83-18.94 14.31-19.91C402.3 319.3 399.1 309.8 391.2 305.8z"],
    "face-explode": [512, 512, ["exploding-head"], "e2fe", "M200 335.2c0-13.28-10.71-23.94-24.04-23.94c-13.25 0-23.96 10.66-23.96 23.94s10.71 23.94 23.96 23.94C189.3 359.1 200 348.5 200 335.2zM128 175.9h31.62C159.8 175.9 159.9 176 160 176h15.69c8.523 .209 16.31 6.839 16.31 15.55c0 5.203-2.34 6.475-2.34 12.04c0 9.498 7.977 14.63 15.67 14.63C222.4 218.2 224 198.6 224 191.5C224 185.7 222.8 180.7 221.2 176H240C248.8 176 256 168.8 256 160S248.8 144 240 144H129.4C116.1 144 95.1 134.3 95.1 111.7c0-17.6 14.36-31.93 32-31.93c18.68 0 19.43 11.79 30.18 11.79c2.16 0 17.88-1.064 17.88-18.31c0-.4941-.0195-.9824-.0605-1.463c0-22.01 17.94-39.91 40-39.91c24.38 0 26.21 16.66 40 16.66c13.74 0 15.63-16.66 40-16.66c15.42 0 39.94 11.17 39.94 41.37c0 17.24 15.72 18.31 17.88 18.31c10.75 0 11.51-11.79 30.18-11.79c17.64 0 32 14.33 32 31.93C416 134.4 395.1 144 382.6 144H338.3C319.4 144 288 157.4 288 191.5c0 7.031 1.643 26.67 18.67 26.67c7.707 0 15.67-5.146 15.67-14.63c0-5.578-2.339-6.741-2.339-12.04c0-8.842 8.019-15.62 16.71-15.62H384c35.3 0 64-28.98 64-64.19c0-44.94-39.12-63.85-64-63.85c-6.547 0-13 1.014-19.14 2.963C355.8 21.45 328.4 0 296 0C281.5 0 267.8 4.24 256 12.13C244.3 4.24 230.5 0 216 0C183.6 0 156.2 21.45 147.1 50.85C141 48.9 134.5 47.88 128 47.88c-9.766 0-19.74 2.254-29.19 7.021C92.26 58.21 64 74.8 64 111.7C64 146.9 92.7 175.9 128 175.9zM256 351.2c-35.3 0-64 28.63-64 63.85c0 17.6 14.36 31.93 32 31.93h64c17.64 0 32-14.33 32-31.93C320 379.8 291.3 351.2 256 351.2zM288 430.1l.0104-15.96H224c0-17.6 14.36-31.92 32-31.92s32.01 14.31 32.01 31.92c0 0-.0156 0 0 0L288 430.1zM511.9 254.4C511.9 254.4 511.1 254.5 511.9 254.4l-16.06 9.098c-4.92 2.805-10.4 4.205-15.88 4.205s-10.96-1.401-15.87-4.205l-32.19-18.35c-2.459-1.402-5.198-2.102-7.939-2.102c-2.738 0-5.478 .6999-7.937 2.102l-32.19 18.35c-4.92 2.805-10.4 4.207-15.88 4.207s-10.96-1.402-15.88-4.207l-32.19-18.35c-2.459-1.402-5.198-2.102-7.939-2.102c-2.738 0-5.478 .6999-7.937 2.102l-32.19 18.35c-4.92 2.805-10.4 4.207-15.88 4.207S245 266.3 240.1 263.5L207.9 245.2C205.5 243.8 202.7 243.1 200 243.1c-2.738 0-5.478 .6999-7.937 2.102L159.9 263.5C154.1 266.3 149.5 267.7 144 267.7S133 266.3 128.1 263.5L95.94 245.2c-2.459-1.402-5.198-2.102-7.939-2.102c-2.738 0-5.478 .6999-7.937 2.102L47.88 263.5C42.96 266.3 37.48 267.7 31.1 267.7S21.04 266.3 16.12 263.5L.0605 254.4c-.0547 .0313 .0547-.0332 0 0C.0547 255.1 .0003 255.9 .0003 256.6c0 141 114.6 255.4 256 255.4c141.4 0 255.1-114.3 255.1-255.4C512 255.9 511.9 255.1 511.9 254.4zM256 480.1c-110.1 0-200.2-78.75-219.9-180.6c9.703-.623 19.19-3.453 27.66-8.279L88 277.4l24.25 13.82C121.9 296.7 132.9 299.6 144 299.6s22.1-2.908 31.75-8.41L200 277.4l24.25 13.82C233.9 296.7 244.9 299.6 256 299.6s22.1-2.908 31.75-8.41L312 277.4l24.25 13.82C345.9 296.7 356.9 299.6 368 299.6s22.1-2.908 31.75-8.41L424 277.4l24.25 13.83c8.465 4.824 17.95 7.654 27.65 8.277C456.2 401.2 366.2 480.1 256 480.1zM336 311.3c-13.34 0-24.04 10.66-24.04 23.94s10.71 23.94 24.04 23.94c13.25 0 23.96-10.66 23.96-23.94S349.3 311.3 336 311.3z"],
    "face-expressionless": [512, 512, [], "e373", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM352 336H160c-8.844 0-16 7.156-16 16s7.156 16 16 16h192c8.844 0 16-7.156 16-16S360.8 336 352 336zM368 192h-64C295.2 192 288 199.2 288 208S295.2 224 304 224h64C376.8 224 384 216.8 384 208S376.8 192 368 192zM208 224C216.8 224 224 216.8 224 208S216.8 192 208 192h-64C135.2 192 128 199.2 128 208S135.2 224 144 224H208z"],
    "face-eyes-xmarks": [512, 512, [], "e374", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM403.3 156.7c-6.25-6.25-16.38-6.25-22.62 0L352 185.4l-28.69-28.69c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L329.4 208l-28.69 28.69c-6.25 6.25-6.25 16.38 0 22.62C303.8 262.4 307.9 264 312 264s8.188-1.562 11.31-4.688L352 230.6l28.69 28.69C383.8 262.4 387.9 264 392 264s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L374.6 208l28.69-28.69C409.6 173.1 409.6 162.9 403.3 156.7zM188.7 259.3C191.8 262.4 195.9 264 200 264s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62L182.6 208l28.69-28.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L160 185.4L131.3 156.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L137.4 208L108.7 236.7c-6.25 6.25-6.25 16.38 0 22.62C111.8 262.4 115.9 264 120 264s8.188-1.562 11.31-4.688L160 230.6L188.7 259.3zM261.1 288H250.9c-54.19 0-100.1 42.19-106.7 98.09c-.9219 7.688 1.484 15.41 6.562 21.12C155.7 412.8 162.8 416 170.2 416h171.7c7.375 0 14.45-3.219 19.41-8.812c5.109-5.75 7.5-13.44 6.578-21.06C361.2 330.2 315.3 288 261.1 288zM176.9 384c7.047-36.88 37.81-64 73.91-64h10.43c36.08 0 66.85 27.12 73.91 64H176.9z"],
    "face-fearful": [512, 512, [], "e375", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 304c-52.94 0-96 43.06-96 96C160 408.8 167.2 416 176 416h160c8.844 0 16-7.156 16-16C352 347.1 308.9 304 256 304zM194 384C201.1 356.4 226.2 336 256 336s54.86 20.44 61.97 48H194zM240 224c0-44.13-35.84-80-80.05-80c-44.08 0-80.08 35.88-80.08 80s36 80 80.08 80C204.2 304 240 268.1 240 224zM159.1 272C133.5 272 111.9 250.5 111.9 224s21.6-48 48.04-48c26.58 0 48.07 21.53 48.07 48S186.5 272 159.1 272zM352.1 144c-44.22 0-80.21 35.88-80.21 80s35.99 80 80.21 80c44.08 0 79.93-35.88 79.93-80S396.2 144 352.1 144zM352.1 272c-26.58 0-48.16-21.53-48.16-48s21.58-48 48.16-48c26.44 0 47.95 21.53 47.95 48S378.5 272 352.1 272zM96.02 159.1c4.062 0 8.125-1.531 11.25-4.594C107.5 155.1 135.6 128 176 128C184.8 128 192 120.8 192 112S184.8 96 176 96C122 96 86.19 131.2 84.69 132.7C78.45 138.9 78.45 148.1 84.66 155.3C87.78 158.4 91.89 159.1 96.02 159.1zM336 128c40.42 0 68.45 27.09 68.73 27.38C407.9 158.5 411.9 160 416 160c4.094 0 8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62C425.8 131.2 390 96 336 96C327.2 96 320 103.2 320 112S327.2 128 336 128zM159.9 200C146.7 200 135.1 210.7 135.1 224s10.71 24 23.96 24C173.3 248 183.1 237.3 183.1 224S173.3 200 159.9 200zM352 200c-13.34 0-24 10.69-24 24S338.7 248 352 248c13.25 0 24-10.69 24-24S365.2 200 352 200z"],
    "face-flushed": [512, 512, [62841, "flushed"], "1f633", "M320.1 368H191.9c-8.719 0-15.99 7.25-15.99 16s7.266 16 15.98 16h128.1c8.719 0 15.98-7.25 15.98-16S328.8 368 320.1 368zM159.1 200C146.7 200 136 210.8 136 224s10.66 24 23.98 24S183.1 237.3 183.1 224S173.3 200 159.1 200zM240 224c0-44.25-35.86-80-80.05-80S80.03 179.8 80.03 224s35.73 80 79.93 80S240 268.3 240 224zM159.1 272C133.5 272 112 250.5 112 224s21.43-48 47.95-48S208 197.5 208 224S186.5 272 159.1 272zM352 144c-44.2 0-80.06 35.75-80.06 80s35.86 80 80.06 80s79.93-35.75 79.93-80S396.2 144 352 144zM352 272c-26.52 0-48.07-21.5-48.07-48s21.55-48 48.07-48s47.95 21.5 47.95 48S378.5 272 352 272zM352 200c-13.32 0-23.98 10.75-23.98 24s10.66 24 23.98 24S375.1 237.3 375.1 224S365.3 200 352 200zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-frown": [512, 512, [61721, "frown"], "2639", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 288c-86.31 0-121.3 60.75-127.7 92.88c-1.719 8.625 3.844 16.97 12.47 18.75c8.844 1.75 17.06-3.781 18.88-12.41C160.3 384.5 174.9 320 256 320s95.75 64.47 96.31 67.13C353.8 394.8 360.5 400 367.1 400c1.062 0 2.125-.0938 3.156-.3125c8.688-1.719 14.31-10.16 12.56-18.81C377.3 348.8 342.3 288 256 288zM336 232C349.3 232 360 221.3 360 208s-10.71-24-23.96-24C322.7 184 312 194.7 312 208S322.7 232 336 232zM175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232z"],
    "face-frown-open": [512, 512, [62842, "frown-open"], "1f626", "M175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM335.1 232C349.3 232 360 221.3 360 208s-10.71-24-24.04-24C322.7 184 312 194.7 312 208S322.7 232 335.1 232zM256 288c-39.72 0-102.6 23.75-111.5 74.5C142.7 373.4 146.5 384.8 154.8 392s19.98 9.875 30.64 6.625C214.7 389.6 241.8 384 256 384s41.29 5.625 70.6 14.62C334.3 401 346.7 401.3 357.2 392c8.113-7.25 12.11-18.62 10.29-29.5C358.6 311.8 295.7 288 256 288zM256 352c-17.68 0-46.86 5.75-80.04 16C181.2 338.3 226.1 320 256 320s74.84 18.25 80.04 48C302.9 357.8 273.7 352 256 352zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-frown-slight": [512, 512, [], "e376", "M175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM256 320c-44.44 0-86.23 19.59-114.8 53.72c-5.691 6.875-4.833 17.03 1.948 22.53C150 402 160.2 401.1 165.8 394.2C188.2 367.5 221.1 352 255.1 352s67.78 15.47 90.19 42.22c5.328 6.5 15.32 8.031 22.46 2.031c6.781-5.625 7.717-15.72 2.026-22.47C342.3 339.7 300.4 320 256 320zM335.1 232C349.3 232 360 221.3 360 208s-10.71-24-24.04-24C322.7 184 312 194.7 312 208S322.7 232 335.1 232zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-glasses": [576, 512, [], "e377", "M376 200C362.7 200 352 210.7 352 224c0 13.25 10.75 24 24 24S400 237.3 400 224C400 210.7 389.3 200 376 200zM378.2 341.7C355.8 368.5 323 383.9 288 383.9s-67.82-15.33-90.2-42.22c-13.62-16.2-38.16 4.203-24.57 20.5C201.7 396.4 243.5 415.1 288 415.1s86.31-19.56 114.8-53.76C416.3 345.9 391.6 325.5 378.2 341.7zM200 200C186.7 200 176 210.7 176 224c0 13.25 10.75 24 24 24S224 237.3 224 224C224 210.7 213.3 200 200 200zM544 176C544 167.2 536.8 160 528 160h-2.783C487.2 66.22 395.4 0 288 0S88.78 66.22 50.78 160H48C39.16 160 32 167.2 32 176c0 6.242 3.664 11.5 8.871 14.14C35.27 211.2 32 233.2 32 256c0 141.4 114.6 256 256 256s256-114.6 256-256c0-22.81-3.273-44.81-8.871-65.86C540.3 187.5 544 182.2 544 176zM288 32c89.13 0 166 52.45 202.1 128h-6.562C474.7 150.3 462.1 144 448 144h-96c-14.13 0-26.72 6.252-35.52 16H259.5C250.7 150.3 238.1 144 224 144H128C113.9 144 101.3 150.3 92.48 160H85.92C121.1 84.45 198.9 32 288 32zM464 192v64c0 8.812-7.172 16-16 16h-96c-8.828 0-16-7.188-16-16V192c0-8.812 7.172-16 16-16h96C456.8 176 464 183.2 464 192zM240 192v64c0 8.812-7.172 16-16 16H128C119.2 272 112 264.8 112 256V192c0-8.812 7.172-16 16-16h96C232.8 176 240 183.2 240 192zM288 480c-123.5 0-224-100.5-224-224c0-22.25 3.367-43.7 9.434-64H80v64c0 26.47 21.53 48 48 48h96c26.47 0 48-21.53 48-48V192h32v64c0 26.47 21.53 48 48 48h96c26.47 0 48-21.53 48-48V192h6.566C508.6 212.3 512 233.8 512 256C512 379.5 411.5 480 288 480z"],
    "face-grimace": [512, 512, [62847, "grimace"], "1f62c", "M368 288h-224c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h224c17.67 0 32-14.33 32-32v-32C400 302.3 385.7 288 368 288zM176 352H144v-32h32L176 352zM240 352h-32v-32h32V352zM304 352h-32v-32h32V352zM368 352h-32.02L336 320h32V352zM335.1 232C349.3 232 360 221.3 360 208s-10.71-24-24.04-24C322.7 184 312 194.7 312 208S322.7 232 335.1 232zM175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-grin": [512, 512, [62848, "grin"], "1f600", "M175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM335.1 232C349.3 232 360 221.3 360 208s-10.71-24-24.04-24C322.7 184 312 194.7 312 208S322.7 232 335.1 232zM379.2 304.8C348.9 314.5 303.1 320 256 320s-92.88-5.5-123.2-15.25c-5.207-1.625-11.02-.5-15.26 3.125c-4.238 3.75-6.176 9.25-5.328 14.88c9.203 55 83.13 93.23 143.8 93.23c60.55 0 134.6-38.23 143.8-93.23c.9687-5.5-1.09-11.12-5.207-14.88C390.3 304.3 384.4 303 379.2 304.8zM256 384c-34.1 0-77.02-16.25-98.45-40.25c57.4 10.75 139.5 10.75 197 0C333 367.8 290.1 384 256 384zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-grin-beam": [512, 512, [62850, "grin-beam"], "1f604", "M125.7 231.8c3.391 1 7.459-.575 9.397-3.825l9.445-17c7.75-13.75 19.25-21.62 31.48-21.62c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 231.7 223.2 232.8 226.3 231.8c3.512-1.125 5.934-4.5 5.691-8.375C228.8 181.3 199.8 152 175.1 152c-23.73 0-52.54 29.25-55.81 71.38C119.8 227.1 122.1 230.6 125.7 231.8zM285.7 231.8c3.391 1 7.459-.575 9.397-3.825l9.494-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.81 7.875 31.56 21.62l9.445 17c2.18 3.75 6.103 4.825 9.252 3.825c3.633-1.125 6.055-4.5 5.691-8.375C388.7 181.3 359.8 152 336 152c-23.86 0-52.64 29.25-55.91 71.38C279.9 227.1 282.2 230.6 285.7 231.8zM379.2 304.8C348.9 314.5 303.1 320 256 320S163.1 314.5 132.8 304.8c-5.207-1.625-11.02-.5-15.26 3.125c-4.238 3.75-6.176 9.25-5.328 14.88c9.203 55 83.14 93.26 143.8 93.26c60.55 0 134.6-38.26 143.8-93.26c.9687-5.5-1.09-11.12-5.207-14.88C390.3 304.3 384.4 303 379.2 304.8zM256 384c-34.1 0-77.02-16.25-98.45-40.25c57.4 10.75 139.5 10.75 197 0C333 367.8 290.1 384 256 384zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-grin-beam-sweat": [512, 512, [62851, "grin-beam-sweat"], "1f605", "M456 160C486.9 160 512 132.8 512 99.38c0-22.89-26.67-67.52-42.56-92.08C466.5 2.75 461.4 0 456 0s-10.48 2.734-13.44 7.281C426.7 31.75 400 76.27 400 99.38C400 132.8 425.1 160 456 160zM455.1 46.38C473.3 75.78 480 94.06 480 99.38C480 114.9 469 128 456 128c-13.23 0-24-12.84-24-28.62C432 94 438.7 75.67 455.1 46.38zM336 152c-23.86 0-52.64 29.25-55.91 71.37c-.2422 3.75 2.034 7.25 5.546 8.375c3.391 1 7.459-.575 9.397-3.825l9.494-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.81 7.875 31.56 21.62l9.446 17c2.18 3.75 6.103 4.825 9.252 3.825c3.633-1.125 6.055-4.5 5.691-8.375C388.7 181.3 359.8 152 336 152zM135.1 227.9l9.445-17c7.75-13.75 19.25-21.62 31.48-21.62c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 231.7 223.2 232.8 226.3 231.8c3.512-1.125 5.934-4.5 5.691-8.375C228.8 181.3 199.8 152 175.1 152c-23.73 0-52.54 29.25-55.81 71.38C119.8 227.1 122.1 230.6 125.7 231.8C129.1 232.8 133.2 231.2 135.1 227.9zM379.2 304.8C348.9 314.5 303.1 320 256 320S163.1 314.5 132.8 304.8c-5.207-1.625-11.02-.5-15.26 3.125c-4.238 3.75-6.176 9.25-5.328 14.88c9.203 55 83.13 93.26 143.8 93.26c60.55 0 134.6-38.26 143.8-93.26c.9687-5.5-1.09-11.12-5.207-14.88C390.3 304.3 384.4 303 379.2 304.8zM256 384c-34.1 0-77.02-16.25-98.45-40.25c57.4 10.75 139.5 10.75 197 0C333 367.8 290.1 384 256 384zM483.1 176.6c-8.516 2.344-13.52 11.16-11.16 19.69C477.3 215.6 480 235.7 480 256c0 123.5-100.5 224-224 224s-224-100.5-224-224s100.5-224 224-224c36.44 0 72.58 8.938 104.5 25.83c7.859 4.172 17.5 1.156 21.62-6.656c4.141-7.812 1.156-17.5-6.656-21.62C338.9 10.22 297.6 .0002 256 .0002c-141.2 0-256 114.8-256 255.1s114.8 255.1 256 255.1S512 397.2 512 256c0-23.17-3.094-46.14-9.203-68.27C500.5 179.2 491.7 174.3 483.1 176.6z"],
    "face-grin-hearts": [512, 512, [62852, "grin-hearts"], "1f60d", "M428.4 196.9c-8.961-23.25-34.15-37.25-59.09-34.25c-9.809-23.38-34.63-38.25-59.21-34c-15.26 2.375-28.58 11-36.81 23.88c-8.234 12.75-10.66 28.5-6.539 43.13l20.46 73.88c3.391 12.25 16.47 21.25 30.52 17.62l74.11-19.25c14.77-3.75 27.25-13.62 34.27-27.25C433 227.2 433.9 211.2 428.4 196.9zM383.9 236.9l-67.69 17.5l-18.65-67.25c-3.391-12.38 4.359-25 17.44-27c13.68-2.25 23.37 9 25.79 17.88l6.176 22.62l23.01-5.75c12.11-3.125 24.58 2.75 28.58 13.38C403.3 221.1 395.1 233.8 383.9 236.9zM194.2 287.2c14.29 3.625 27.12-5.5 30.52-17.62L245.2 195.7c4.117-14.75 1.695-30.5-6.539-43.25s-21.55-21.5-36.81-23.88c-25.19-4.125-49.41 10.62-59.21 34c-25.31-3-50.25 11-59.21 34.25C77.99 211.2 78.84 227.2 85.74 240.7s19.5 23.38 34.27 27.12L194.2 287.2zM113.5 208.3c5.207-13.75 20.46-15.5 28.58-13.38l22.77 5.875l6.176-22.62c3.27-12 14.65-19.75 25.91-18c13.08 2 20.95 14.5 17.44 27L195.7 254.4l-67.57-17.5C116 233.8 108.8 221.1 113.5 208.3zM379.2 304.8C348.9 314.5 303.1 320 256 320S163.1 314.5 132.8 304.8c-11.5-3.625-22.52 6.375-20.71 18C121.3 377.8 195.5 416 256 416s134.5-38.25 143.9-93.25C401.7 311.1 390.8 301.1 379.2 304.8zM256 384c-34.1 0-77.02-16.25-98.45-40.25c57.4 10.75 139.5 10.75 197 0C333 367.8 290.1 384 256 384zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-grin-squint": [512, 512, [62853, "grin-squint"], "1f606", "M379.2 304.8C348.9 314.5 303.1 320 256 320S163.1 314.5 132.8 304.8c-5.207-1.625-11.14-.5-15.26 3.125c-4.238 3.75-6.176 9.25-5.328 14.88C121.5 377.8 195.4 416 256.1 416c60.55 0 134.6-38.25 143.8-93.25c.9687-5.5-1.09-11.12-5.207-14.88C390.3 304.3 384.4 303 379.2 304.8zM256 384c-34.1 0-77.02-16.25-98.45-40.25c57.4 10.75 139.5 10.75 197 0C333 367.8 290.1 384 256 384zM129.7 247.2C132.5 252.8 138.1 256 144 256c2.406 0 4.844-.5469 7.141-1.688l64-32C220.6 219.6 223.1 214.1 223.1 207.1S220.6 196.4 215.2 193.7l-64-32C143.3 157.8 133.6 160.9 129.7 168.8S128.9 186.4 136.8 190.3L172.2 208L136.8 225.7C128.9 229.6 125.7 239.3 129.7 247.2zM296.8 222.3l64 32C363.1 255.5 365.6 256 367.1 256c5.875 0 11.52-3.234 14.33-8.844c3.953-7.906 .75-17.52-7.156-21.47L339.8 208l35.38-17.69c7.906-3.953 11.11-13.56 7.156-21.47c-3.969-7.906-13.56-11.08-21.47-7.156l-64 32c-5.422 2.719-8.846 8.238-8.846 14.3S291.4 219.6 296.8 222.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-grin-squint-tears": [512, 512, [62854, "grin-squint-tears"], "1f923", "M160.4 339.1c5.955 1.979 12.23 .2754 16.38-3.879c1.701-1.701 3.039-3.811 3.857-6.242l22.62-67.88c1.91-5.758 .3906-12.1-3.896-16.39S188.8 238.9 183.1 240.8L115.2 263.4C106.8 266.2 102.3 275.3 105.1 283.7c2.795 8.385 11.85 12.92 20.24 10.12l37.52-12.51L150.3 318.8C147.5 327.2 152.1 336.3 160.4 339.1zM383.1 144c.8125 0 1.656-.0625 2.469-.1875c32.56-5.109 89.78-16.27 107.3-33.75c24.75-24.73 24.28-65.45-1.031-90.75C480.5 7.047 464.2 .1875 446.4 0c-16.87 0-32.65 6.492-44.44 18.29c0 0 0-.0156 0 0c-17.44 17.47-28.62 74.68-33.75 107.2c-.7813 5.047 .875 10.19 4.5 13.8C375.7 142.3 379.8 144 383.1 144zM424.6 40.89C430.3 35.16 438.1 32 446.6 32c8.812 .0938 17.16 3.625 23.47 9.938c12.81 12.83 13.28 33.23 1.062 45.47c-3.312 3.125-21.59 12.22-67.53 20.97C412.4 62.5 421.5 44.2 424.6 40.89zM125.5 368.2c-32.56 5.109-89.78 16.27-107.3 33.75c-24.75 24.73-24.28 65.45 1.031 90.75C31.54 504.1 47.79 511.8 65.63 512c16.87 0 32.65-6.492 44.44-18.29c0 0 0 .0156 0 0c17.44-17.47 28.62-74.68 33.75-107.2c.7813-5.047-.875-10.19-4.5-13.8S130.6 367.4 125.5 368.2zM87.41 471.1C81.66 476.8 73.95 480 65.38 480c-8.812-.0938-17.16-3.625-23.47-9.938c-12.81-12.83-13.28-33.23-1.062-45.47c3.312-3.125 21.59-12.22 67.53-20.97C99.6 449.5 90.54 467.8 87.41 471.1zM369.2 369.1c42.81-42.81 68.08-122.3 35.7-167.7c-3.205-4.574-8.637-7.096-14.2-6.836c-5.645 .5195-10.72 3.832-13.17 8.75c-14.51 28.3-42.39 63.96-76.29 97.87c-33.9 33.91-69.56 61.79-97.86 76.3c-4.83 2.533-8.23 7.523-8.578 12.1c-.3457 5.648 2.174 10.91 6.75 14.29C246.1 437.2 326.3 412 369.2 369.1zM387.7 248.3c1.729 32.21-16.49 73.42-41.24 98.16c-24.75 24.75-65.95 42.97-98.07 41.15C296.6 354.7 354.7 296.6 387.7 248.3zM283.7 105.1c-8.395-2.785-17.42 1.756-20.24 10.12L240.8 183.1C238.9 188.8 240.4 195.1 244.7 199.4c4.287 4.287 10.63 5.802 16.39 3.892l67.88-22.63c2.43-.8164 4.541-2.154 6.242-3.855c4.154-4.154 5.855-10.43 3.877-16.38c-2.795-8.387-11.86-12.92-20.24-10.12l-37.52 12.51l12.51-37.52C296.6 116.9 292.1 107.8 283.7 105.1zM35.97 368c2.156 0 4.312-.4219 6.406-1.344c8.094-3.531 11.78-12.97 8.25-21.06C38.28 317.3 32 287.2 32 256c0-123.5 100.5-224 224-224c31.16 0 61.28 6.266 89.59 18.62c8.094 3.594 17.53-.1094 21.06-8.25c3.531-8.094-.1562-17.53-8.25-21.06C326 7.172 291.6 0 256 0C114.8 0 0 114.8 0 256c0 35.59 7.156 70.05 21.31 102.4C23.94 364.4 29.81 368 35.97 368zM490.7 153.6c-3.531-8.094-12.97-11.78-21.06-8.25s-11.78 12.97-8.25 21.06C473.7 194.7 480 224.8 480 256c0 123.5-100.5 224-224 224c-31.16 0-61.28-6.266-89.59-18.62c-8.062-3.516-17.5 .125-21.06 8.25c-3.531 8.094 .1562 17.53 8.25 21.06C185.1 504.8 220.4 512 256 512c141.2 0 256-114.8 256-256C512 220.4 504.8 185.1 490.7 153.6z"],
    "face-grin-stars": [512, 512, [62855, "grin-stars"], "1f929", "M418.1 148l-35.36-5.125l-15.74-32.13c-9.566-18.75-36.33-18.88-45.89 0l-15.86 32.13L269.8 148C264.4 148.8 259.8 151.6 256 155.4C252.2 151.6 247.6 148.8 242.1 148L206.8 142.9L190.1 110.8c-9.445-18.75-36.33-18.88-45.89 0L129.3 142.9L93.86 148c-20.22 3-29.67 28.25-14.17 43.75l25.67 24.88l-6.055 35.63c-3.391 21.38 19.25 36.25 36.93 26.5l31.73-16.5L199.4 278.5c18.53 10.25 40.69-5.25 37.3-26.62L230.6 216.5L256 192l25.43 24.62l-6.176 35.63c-3.391 21.38 19.25 36.25 36.93 26.5l31.85-16.5l31.48 16.25c18.53 10.25 40.57-5.25 37.18-26.62l-6.055-35.38l25.91-25.12C447.4 176.5 438.9 151.1 418.1 148zM196.2 205.5l6.66 38.88L167.1 226.3l-34.88 18l6.66-38.88L111.3 177.8l39.23-5.625l17.44-35.5l17.56 35.5l39.23 5.625L196.2 205.5zM372.3 205.5l6.66 38.88l-34.88-18.12l-34.88 18l6.66-38.88l-28.58-27.62l39.23-5.625l17.56-35.5l17.44 35.5l39.23 5.625L372.3 205.5zM379.1 320.8C348.9 330.5 303.1 336 256 336s-92.86-5.499-123.1-15.25c-11.5-3.625-22.52 6.374-20.7 17.1C121.4 393.8 195.5 432 256 432s134.5-38.25 143.8-93.25C401.7 327.1 390.8 317.1 379.1 320.8zM256 399.9c-34.1 0-77.02-16.19-98.45-40.19c57.4 10.75 139.5 10.75 197 0C333 383.8 290.1 399.9 256 399.9zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-grin-tears": [640, 512, [62856, "grin-tears"], "1f602", "M176.2 322.8c9.207 55 83.16 93.26 143.8 93.26c60.56 0 134.6-38.26 143.8-93.26c.9687-5.5-1.09-11.12-5.209-14.88C454.3 304.3 448.4 303 443.2 304.8C412.9 314.5 367.1 320 320 320c-47.96 0-92.9-5.5-123.2-15.25C191.6 303.1 185.8 304.3 181.6 307.9C177.3 311.6 175.4 317.1 176.2 322.8zM418.6 343.8C397 367.8 355 384 320 384s-77.04-16.25-98.47-40.25C278.9 354.5 361.1 354.5 418.6 343.8zM199.1 227.9l9.457-17C216.3 197.2 227.8 189.3 240 189.3c12.36 0 23.86 7.875 31.49 21.62l9.554 17C283.1 231.7 287 232.8 290.2 231.8c3.514-1.125 6.091-4.5 5.848-8.375C292.7 181.3 263.8 152 239.1 152c-23.74 0-52.55 29.25-55.82 71.38C183.8 227.1 186.1 230.6 189.7 231.8C193.1 232.8 197.1 231.2 199.1 227.9zM359.1 227.9l9.481-17c7.631-13.75 19.13-21.62 31.49-21.62c12.23 0 23.81 7.875 31.56 21.62l9.457 17c2.18 3.75 6.089 4.825 9.237 3.825c3.635-1.125 6.067-4.5 5.704-8.375C452.7 181.3 423.8 152 400 152c-23.86 0-52.63 29.25-55.91 71.38c-.2422 3.75 2.19 7.25 5.702 8.375C353.2 232.8 357.1 231.2 359.1 227.9zM127.8 242.5c.7813-5.062-.875-10.19-4.502-13.8c-3.625-3.609-8.783-5.312-13.79-4.5C81.25 228.6 31.58 238.3 16.17 253.8c-21.82 22.14-21.47 58.56 .9082 81.08C28.14 345.9 42.74 352 58.25 352c15.16-.0313 29.38-5.875 39.82-16.39C113.6 320.1 123.4 270.6 127.8 242.5zM75.41 313C70.94 317.5 64.84 319.1 58.28 320c-6.939 0-13.54-2.766-18.54-7.766C29.77 302.2 29.33 286.2 38.77 276.4C41.74 273.9 56.62 266.8 92.22 259.7C85.13 295.3 77.91 310.2 75.41 313zM623.8 253.8c-15.41-15.42-65.08-25.14-93.31-29.56c-5.033-.8125-10.16 .8906-13.79 4.5c-3.625 3.609-5.283 8.734-4.5 13.8c4.406 28.11 14.13 77.59 29.66 93.06C552.4 346.1 566.5 351.1 581.7 352c15.5 0 30.21-6.109 41.28-17.19c.0313-.0156 0 0 0 0C645.3 312.3 645.7 275.1 623.8 253.8zM600.3 312.2C595.2 317.3 588.7 320 581.8 320c-6.564-.0156-12.69-2.5-17.13-6.953c-2.533-2.875-9.754-17.69-16.85-53.33c35.82 7.062 50.61 14.2 53.33 16.56C610.7 286 610.3 302.1 600.3 312.2zM536 361.1c-7.625-4.359-17.44-1.781-21.84 5.859C474.2 437 399.8 480 320 480s-154.2-42.98-194.2-112.2C121.4 360.2 111.6 357.5 104 361.1c-7.656 4.422-10.28 14.2-5.844 21.86C143.8 462.9 228.8 512 320 512s176.2-49.13 221.8-128.2C546.3 376.2 543.7 366.4 536 361.1zM88.31 191.1c8.375 2.875 17.47-1.406 20.44-9.766C140.3 92.02 225.2 32 320 32s179.7 60.02 211.3 149.3C533.6 187.9 539.8 192 546.3 192c1.781 0 3.562-.2969 5.344-.9062C560 188.1 564.4 179 561.4 170.7C525.4 68.59 428.3 0 320 0S114.6 68.59 78.56 170.7C75.63 179 80 188.1 88.31 191.1z"],
    "face-grin-tongue": [512, 512, [62857, "grin-tongue"], "1f61b", "M306.2 369.9c-2.418 0-4.883 .293-7.361 .9102l-42.86 10.68l-42.3-10.61c-2.49-.625-4.975-.9219-7.406-.9219C190.1 369.1 176.2 383 176.2 400v32.26C176.2 476.3 211.9 512 256.1 512c44.18 0 80.14-35.7 80.14-79.74v-32.32C336.2 382.1 322.3 369.9 306.2 369.9zM304.2 432.3C304.2 458.6 282.7 480 256.2 480s-48-21.42-48-47.74v-29.73L240 410.5V424c0 8.844 7.156 16 16 16s16-7.156 16-16v-13.51l32.21-8.025V432.3zM362.9 383.2C364.6 383.7 366.3 384 368 384c6.688 0 12.94-4.234 15.19-10.94l16-48c1.844-5.547 .5313-11.66-3.438-15.94c-3.938-4.266-9.906-6.094-15.62-4.641c-81.19 20.28-167.1 20.28-248.3 0C126.2 303 120.2 304.9 116.3 309.1c-3.969 4.281-5.281 10.39-3.438 15.94l16 48c2.844 8.406 11.91 12.91 20.25 10.11c8.375-2.781 12.91-11.84 10.12-20.23l-7.062-21.2c68.44 13.28 139.3 13.28 207.8 0l-7.062 21.2C350 371.3 354.6 380.4 362.9 383.2zM360 208c0-13.31-10.71-24-24.04-24C322.7 184 312 194.7 312 208s10.71 24 23.96 24C349.3 232 360 221.3 360 208zM200 208c0-13.31-10.71-24-24.04-24C162.7 184 152 194.7 152 208s10.71 24 23.96 24C189.3 232 200 221.3 200 208zM256 0C114.8 0 0 114.8 0 256c0 95.17 52.31 181.1 136.5 226.5c7.75 4.141 17.47 1.156 21.62-6.672c4.125-7.812 1.125-17.48-6.688-21.61C77.78 415.2 32 339.3 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 83.28-45.78 159.2-119.5 198.2c-7.812 4.125-10.81 13.8-6.688 21.61c2.875 5.438 8.438 8.531 14.16 8.531c2.531 0 5.094-.5938 7.469-1.859C459.7 437.1 512 351.2 512 256C512 114.8 397.2 0 256 0z"],
    "face-grin-tongue-squint": [512, 512, [62858, "grin-tongue-squint"], "1f61d", "M306.2 369.9c-2.418 0-4.883 .293-7.361 .9102l-42.86 10.68l-42.3-10.61c-2.49-.625-4.975-.9219-7.406-.9219C190.1 369.1 176.2 383 176.2 400v32.26C176.2 476.3 211.9 512 256.1 512c44.18 0 80.14-35.7 80.14-79.74v-32.32C336.2 382.1 322.3 369.9 306.2 369.9zM304.2 432.3C304.2 458.6 282.7 480 256.2 480s-48-21.42-48-47.74v-29.73L240 410.5V424c0 8.844 7.156 16 16 16s16-7.156 16-16v-13.51l32.21-8.025V432.3zM362.9 383.2C364.6 383.7 366.3 384 368 384c6.688 0 12.94-4.234 15.19-10.94l16-48c1.844-5.547 .5313-11.66-3.438-15.94c-3.969-4.266-9.938-6.094-15.62-4.641c-81.19 20.28-167.1 20.28-248.3 0C126.2 303 120.2 304.9 116.3 309.1c-3.969 4.281-5.281 10.39-3.438 15.94l16 48c2.812 8.406 11.88 12.91 20.25 10.11c8.375-2.781 12.91-11.84 10.12-20.23l-7.062-21.2c68.44 13.28 139.3 13.28 207.8 0l-7.062 21.2C350 371.3 354.6 380.4 362.9 383.2zM129.7 247.2C132.5 252.8 138.1 256 144 256c2.406 0 4.844-.5469 7.141-1.688l64-32C220.6 219.6 224 214.1 224 207.1S220.6 196.4 215.2 193.7l-64-32C143.3 157.8 133.6 160.9 129.7 168.8S128.9 186.4 136.8 190.3L172.2 207.1L136.8 225.7C128.9 229.6 125.7 239.3 129.7 247.2zM382.3 168.8c-3.969-7.906-13.56-11.08-21.47-7.156l-64 32C291.4 196.4 288 201.9 288 207.1s3.422 11.6 8.844 14.31l64 32C363.1 255.5 365.6 256 367.1 256c5.875 0 11.52-3.234 14.33-8.844c3.953-7.906 .75-17.52-7.156-21.47L339.8 207.1l35.38-17.69C383.1 186.4 386.3 176.7 382.3 168.8zM256 0C114.8 0 0 114.8 0 256c0 95.17 52.31 181.1 136.5 226.5c7.719 4.141 17.47 1.156 21.62-6.672c4.125-7.812 1.125-17.48-6.688-21.61C77.78 415.2 32 339.3 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 83.28-45.78 159.2-119.5 198.2c-7.812 4.125-10.81 13.8-6.688 21.61c2.875 5.438 8.438 8.531 14.16 8.531c2.531 0 5.094-.5938 7.469-1.859C459.7 437.1 512 351.2 512 256C512 114.8 397.2 0 256 0z"],
    "face-grin-tongue-wink": [512, 512, [62859, "grin-tongue-wink"], "1f61c", "M306.2 369.9c-2.418 0-4.883 .293-7.361 .9102l-42.86 10.68l-42.3-10.61c-2.49-.625-4.975-.9219-7.406-.9219C190.1 369.1 176.2 383 176.2 400v32.26C176.2 476.3 211.9 512 256.1 512c44.18 0 80.14-35.7 80.14-79.74v-32.32C336.2 382.1 322.3 369.9 306.2 369.9zM304.2 432.3C304.2 458.6 282.7 480 256.2 480s-48-21.42-48-47.74v-29.73L240 410.5V424c0 8.844 7.156 16 16 16s16-7.156 16-16v-13.51l32.21-8.025V432.3zM362.9 383.2C364.6 383.7 366.3 384 368 384c6.688 0 12.94-4.234 15.19-10.94l16-48c1.844-5.547 .5313-11.66-3.438-15.94c-3.969-4.266-9.938-6.094-15.62-4.641c-81.19 20.28-167.1 20.28-248.3 0C126.2 303 120.2 304.9 116.3 309.1c-3.969 4.281-5.281 10.39-3.438 15.94l16 48c2.812 8.406 11.88 12.91 20.25 10.11c8.375-2.781 12.91-11.84 10.12-20.23l-7.062-21.2c68.44 13.28 139.3 13.28 207.8 0l-7.062 21.2C350 371.3 354.6 380.4 362.9 383.2zM128.5 229.3C133.2 216.6 145.8 207.1 160 207.1s26.82 8.578 31.52 21.33c2.447 6.578 8.875 10.67 15.76 10.67c1.861 0 3.721-.2969 5.58-.9219C221.5 236.1 226.1 226.1 223 218.7C213.6 193.1 188.3 175.1 160 175.1S106.4 193.1 96.96 218.7C93.89 226.1 98.46 236.1 107.1 239.1C115.9 242 125.4 237.7 128.5 229.3zM360 208c0-13.25-10.65-24-23.97-24s-24.04 10.75-24.04 24s10.72 24 24.04 24S360 221.3 360 208zM415.1 208c0-44.25-35.72-80-79.92-80S256 163.8 256 208s35.84 80 80.04 80S415.1 252.3 415.1 208zM287.1 208c0-26.5 21.55-48 48.07-48s47.95 21.5 47.95 48s-21.43 48-47.95 48S287.1 234.5 287.1 208zM256 0C114.8 0 0 114.8 0 256c0 95.17 52.31 181.1 136.5 226.5c7.75 4.141 17.47 1.156 21.62-6.672c4.125-7.812 1.125-17.48-6.688-21.61C77.78 415.2 32 339.3 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 83.28-45.78 159.2-119.5 198.2c-7.812 4.125-10.81 13.8-6.688 21.61c2.875 5.438 8.438 8.531 14.16 8.531c2.531 0 5.094-.5938 7.469-1.859C459.7 437.1 512 351.2 512 256C512 114.8 397.2 0 256 0z"],
    "face-grin-wide": [512, 512, [62849, "grin-alt"], "1f603", "M379.2 304.8C348.9 314.5 303.1 320 256 320S163.1 314.5 132.8 304.8c-5.207-1.625-11.14-.5-15.26 3.125c-4.238 3.75-6.176 9.25-5.328 14.88c9.203 55 83.2 93.26 143.9 93.26c60.55 0 134.5-38.26 143.7-93.26c.9687-5.5-1.09-11.12-5.207-14.88C390.3 304.3 384.4 303 379.2 304.8zM256 384c-34.1 0-77.02-16.25-98.45-40.25c57.4 10.75 139.5 10.75 197 0C333 367.8 290.1 384 256 384zM176 256C184.8 256 192 248.8 192 240v-96C192 135.2 184.8 128 176 128S160 135.2 160 144v96C160 248.8 167.2 256 176 256zM336 256C344.8 256 352 248.8 352 240v-96C352 135.2 344.8 128 336 128S320 135.2 320 144v96C320 248.8 327.2 256 336 256zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-grin-wink": [512, 512, ["grin-wink"], "f58c", "M285.4 239.1c8.406 2.953 17.47-1.375 20.44-9.75C310.3 216.6 322.4 207.1 336 207.1s25.69 8.578 30.19 21.33c2.344 6.578 8.5 10.67 15.09 10.67c1.781 0 3.562-.2969 5.344-.9219c8.312-2.938 12.69-12.08 9.75-20.41C387.3 193.1 363.1 175.1 336 175.1s-51.34 17.14-60.38 42.67C272.7 226.1 277.1 236.1 285.4 239.1zM175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM384.1 304c-1.574 0-3.27 .25-4.965 .75C348.9 314.5 303.1 320 256 320S163.1 314.5 132.8 304.8C131.2 304.3 129.6 304 128 304c-9.445 0-17.44 8.625-15.74 18.75C121.5 377.8 195.4 416 256.1 416c60.55 0 134.6-38.25 143.8-93.25C401.6 312.5 393.4 304 384.1 304zM330.6 362.6C308.4 376 280.5 384 256 384s-52.43-8-74.59-21.38c-9.445-5.75-17.32-12.12-23.49-18.88C186.5 349.1 220.7 352 255.9 352c35.48 0 69.33-2.875 97.9-8.25C347.9 350.5 340 356.9 330.6 362.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-hand-over-mouth": [512, 512, [], "e378", "M389.3 350.9c15.16-18.4 14.14-45.75-3.057-62.94c-1.92-1.918-3.975-3.65-6.146-5.188c.0137-.457 .0215-.9141 .0215-1.375c0-12.52-4.879-24.3-13.74-33.16c-8.855-8.855-20.63-13.73-33.16-13.73c-.459 0-.918 .0059-1.375 .0195c-1.535-2.17-3.268-4.225-5.186-6.143C317.8 219.5 306.1 214.7 293.5 214.7c-12.53 0-24.3 4.879-33.16 13.74L216.1 271.8C209 260.3 196.5 252 181.6 249.9C179.2 249.6 176.7 249.4 174.3 249.4c-25.62 .002-47.65 19.18-51.25 44.61l-9.943 70.33c-4.135 30.43 2.652 62.69 19.42 89.93C154.8 490.4 193.4 512 235.8 512c33.73 0 65.45-13.14 89.29-36.1l61.14-61.14C403.5 396.7 404.5 369.3 389.3 350.9zM313.4 399.4l29.19-29.19c2.908-2.908 6.719-4.363 10.53-4.363c3.811 0 7.621 1.455 10.53 4.363c5.818 5.818 5.818 15.24 0 21.06l-61.15 61.15C284.7 470.2 261 480 235.8 480c-31.24 0-59.69-15.89-76.08-42.51c-13.44-21.83-18.51-47.93-14.3-73.23c.002-.0176-.0039 .0156 0 0c.0117-.0977-.0137 .0977 0 0l9.261-65.77C156.1 288.6 164.5 281.4 174.3 281.4c.9473 0 1.906 .0684 2.875 .209c10.86 1.541 18.42 11.59 16.89 22.45l-5.914 41.84L283 251c2.908-2.908 6.719-4.363 10.53-4.363s7.623 1.455 10.53 4.363c5.818 5.818 5.818 15.24 0 21.06l-58.98 58.98l8.729 8.727l68.9-68.9c2.91-2.91 6.721-4.363 10.53-4.363s7.621 1.453 10.53 4.363c5.818 5.818 5.818 15.24 0 21.06l-68.9 68.9l8.727 8.729l58.98-58.98c2.908-2.908 6.719-4.363 10.53-4.363c3.811 0 7.621 1.455 10.53 4.363c5.818 5.818 5.818 15.24 0 21.06l-58.97 58.97L313.4 399.4zM200 176c0-13.31-10.72-24-24.07-24c-13.26 0-23.98 10.69-23.98 24s10.72 24 23.98 24C189.3 200 200 189.3 200 176zM256 0C114.8 0 0 114.8 0 256c0 63.13 23.16 123.8 65.2 170.7c5.922 6.594 16.03 7.125 22.59 1.219c6.578-5.875 7.141-16 1.25-22.59C52.27 364.3 32 311.2 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 71.13-32.66 136.4-89.59 179.2c-7.062 5.281-8.484 15.31-3.188 22.41C390.4 461.8 395.2 464 400 464c3.344 0 6.719-1.031 9.594-3.219C474.7 411.9 512 337.3 512 256C512 114.8 397.2 0 256 0zM360 176c0-13.31-10.72-24-23.98-24c-13.35 0-24.07 10.69-24.07 24s10.72 24 24.07 24C349.3 200 360 189.3 360 176z"],
    "face-hand-yawn": [512, 512, [], "e379", "M198.4 126.7C206.5 123.1 210.2 113.7 206.7 105.6S193.7 93.91 185.6 97.34C151.5 112.2 121.6 135.9 99.22 165.8C93.91 172.8 95.31 182.8 102.4 188.1C105.3 190.3 108.7 191.3 112 191.3c4.844 0 9.656-2.219 12.78-6.406C143.9 159.5 169.3 139.3 198.4 126.7zM387.2 184.1C390.3 189.1 395.2 191.3 400 191.3c3.344 0 6.719-1.031 9.625-3.219c7.062-5.312 8.469-15.34 3.156-22.41c-22.44-29.84-52.31-53.5-86.38-68.38c-8-3.438-17.5 .1562-21.06 8.25c-3.531 8.094 .1562 17.53 8.25 21.06C342.6 139.3 368.1 159.5 387.2 184.1zM389.3 350.9c15.16-18.4 14.13-45.75-3.061-62.95c-1.92-1.918-3.984-3.657-6.156-5.194c.0137-.457 .0332-.9053 .0332-1.366c0-12.52-4.879-24.3-13.74-33.16c-8.855-8.855-20.63-13.74-33.16-13.74c-.459 0-.918 .0059-1.375 .0195c-1.535-2.17-3.267-4.225-5.185-6.143c-8.855-8.857-20.63-13.74-33.16-13.74c-12.53 0-24.3 4.88-33.16 13.74L216.1 271.8c-7.949-11.48-20.47-19.74-35.34-21.85C179.2 249.6 176.7 249.4 174.3 249.4c-25.62 .002-47.66 19.18-51.25 44.61l-9.944 70.33c-4.135 30.43 2.653 62.69 19.42 89.93C154.8 490.4 193.4 512 235.8 512c33.73 0 65.45-13.14 89.29-36.1l61.14-61.14C403.5 396.7 404.5 369.3 389.3 350.9zM313.4 399.4l29.19-29.19c2.908-2.908 6.719-4.363 10.53-4.363c3.811 0 7.621 1.455 10.53 4.363c5.818 5.818 5.818 15.24 0 21.06l-61.15 61.15C284.7 470.2 261 480 235.8 480c-31.24 0-59.69-15.89-76.08-42.51c-13.44-21.83-18.51-47.89-14.3-73.2c.002-.0176-.0039 .0156 0 0c.0117-.0977-.0137 .0977 0 0l9.261-65.81C156.1 288.6 164.5 281.4 174.3 281.4c.9473 0 1.906 .0684 2.875 .209c10.86 1.541 18.42 11.59 16.89 22.45l-5.914 41.84L283 251c2.908-2.908 6.719-4.363 10.53-4.363s7.623 1.455 10.53 4.363c5.818 5.818 5.818 15.24 0 21.06l-58.98 58.98l8.729 8.727l68.9-68.9c2.91-2.91 6.721-4.364 10.53-4.364s7.621 1.454 10.53 4.364c5.818 5.818 5.818 15.24 0 21.06l-68.9 68.9l8.727 8.729l58.98-58.98c2.908-2.908 6.719-4.364 10.53-4.364c3.811 0 7.621 1.456 10.53 4.364c5.818 5.818 5.818 15.24 0 21.06l-58.97 58.97L313.4 399.4zM256 0C114.8 0 0 114.8 0 255.1c0 63.09 23.16 123.7 65.22 170.7c5.875 6.531 16 7.094 22.59 1.219c6.562-5.875 7.125-16 1.219-22.59C52.25 364.3 32 311.2 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 71.13-32.66 136.4-89.59 179.2c-7.062 5.281-8.469 15.31-3.156 22.41C390.4 461.8 395.2 464 400 464c3.344 0 6.719-1.031 9.625-3.219C474.7 411.9 512 337.3 512 255.1C512 114.8 397.2 0 256 0z"],
    "face-head-bandage": [576, 512, [], "e37a", "M528 240C519.2 240 512 247.2 512 256c0 123.5-100.5 224-224 224c-77.33 0-148.2-39.09-189.5-104.5c-4.719-7.5-14.58-9.656-22.08-5c-7.469 4.719-9.703 14.59-4.984 22.06C118.7 467.3 199.6 512 288 512c141.2 0 256-114.8 256-256C544 247.2 536.8 240 528 240zM253.1 339.1c-8.688 1.594-14.42 9.938-12.81 18.62c1.625 8.688 10 14.38 18.66 12.81C268.1 368.9 277.9 368 288 368c55.86 0 83.63 26.28 84.69 27.31C375.8 398.4 379.9 400 384 400s8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62C393.8 371.2 357.8 336 288 336C275.1 336 264.2 337.1 253.1 339.1zM392 240c0-13.26-10.75-24-24-24s-24 10.74-24 24c0 13.25 10.75 24 24 24S392 253.3 392 240zM574.7 175.9c-8.697-29.1-21.78-56.3-38.88-80.83c-4.912-7.045-12.45-11.82-20.92-13.25c-11.92-2.016-23.86-3.623-35.8-5.299c.1641-.7539 .5059-1.443 .6152-2.215c1.584-11.08-2.738-22.18-11.39-29.28c-21.39-17.53-45.23-31.85-70.85-42.56C393.5 .8242 389.3 0 385.1 0c-4.268 0-8.535 .8535-12.54 2.559l-15.96 6.797c-.123-.0371-.1973 .0942-.3203 .0591C334.1 3.321 311.2 0 288 0C217.3 0 149.8 29.57 101.5 81.04c-14.51 2.393-29.04 4.725-43.43 7.625c-8.412 1.695-15.79 6.699-20.48 13.89C21.03 127.9 8.742 155.6 1.055 184.8C-1.818 195.7 1.27 207.3 9.18 215.4C10.22 216.4 11.62 216.9 12.78 217.8C11.3 219.2 9.789 220.6 8.406 222.2C3.211 227.9 .2871 235.4 .1758 243.1C.0762 243.1 0 245.4 0 246.8c0 29.66 5.369 59.25 15.96 87.93c4.084 11.06 13.92 18.98 25.6 20.61c1.48 .207 2.961 .3086 4.43 .3086c10.12 0 19.76-4.809 25.83-13.12C103.2 299.6 142.1 262.8 185.7 231.5C184.7 234.1 184 236.1 184 240c0 13.25 10.75 24 24 24S232 253.3 232 240c0-13.26-10.75-24-24-24c-.1699 0-.3105 .0938-.4805 .0977c12.61-8.105 25.85-15.27 39.2-22.33C266.3 192.7 285.1 192 305.6 192c77.3 0 155.3 8.201 231.7 24.38c2.203 .4648 4.422 .6934 6.625 .6934c8.842 0 17.41-3.67 23.53-10.32C575.2 198.4 577.9 186.7 574.7 175.9zM385.1 32C408.1 41.63 429.3 54.43 448 69.79l-5.158 2.197c-44.64-4.98-89.24-7.713-133.2-7.865L385.1 32zM288 32c4.477 0 8.881 .6309 13.33 .8945L235.8 60.81C231.2 62.75 226.9 65.06 222.5 67.11C201.3 68.52 180.3 70.46 159.3 72.93C196.7 46.64 241.6 32 288 32zM45.98 323.6C37.08 299.5 32 273.7 32 246.8c0-1.08 .1582-2.123 .1719-3.201c7.252-8.045 15.4-15.25 23.09-22.89C94.52 211.7 134.2 204.5 174.3 199.8C124.7 234.1 81.16 275.5 45.98 323.6zM305.6 160C211.2 160 119.6 171.5 32 192.9c6.883-26.15 17.87-50.66 32.37-72.9C142.3 104.3 222.1 96 305.6 96c69.56 0 137.6 6.178 203.9 17.38C524.7 135.1 536.3 159.3 544 185.1C467.2 168.8 387.5 160 305.6 160z"],
    "face-hushed": [512, 512, [], "e37b", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM200 256c0-13.31-10.71-24-24.04-24C162.7 232 152 242.7 152 256s10.71 24 23.96 24C189.3 280 200 269.3 200 256zM336 232C322.7 232 312 242.7 312 256s10.71 24 24.04 24C349.3 280 360 269.3 360 256S349.3 232 336 232zM208 144C208 135.2 200.8 128 192 128C138 128 102.2 163.2 100.7 164.7C94.47 170.9 94.47 180.1 100.7 187.3C103.8 190.4 107.9 191.1 112 191.1c4.062 0 8.156-1.531 11.25-4.594C123.5 187.1 151.6 160 192 160C200.8 160 208 152.8 208 144zM411.3 164.7C409.8 163.2 374 128 320 128c-8.844 0-16 7.156-16 16S311.2 160 320 160c40.41 0 68.47 27.09 68.75 27.38C391.8 190.5 395.9 192 400 192c4.094 0 8.188-1.562 11.31-4.688C417.6 181.1 417.6 170.9 411.3 164.7zM256 320c-35.28 0-64 28.72-64 64s28.72 64 64 64s64-28.72 64-64S291.3 320 256 320zM256 416c-17.66 0-32-14.34-32-32s14.34-32 32-32s32 14.34 32 32S273.7 416 256 416z"],
    "face-icicles": [576, 512, [], "e37c", "M288 0C146.9 0 32.02 114.8 32.02 256c0 .6074-.0574 3.4-.0008 4.311l9.176 213.3c.2051 3.396 2.916 6.184 6.398 6.398c3.764 .2324 7.004-2.633 7.236-6.398c0 0 9.203-217.1 9.203-217.6c0-123.5 100.5-224 223.1-224c123.5 0 223.1 100.5 223.1 224c0 55.22-20.25 108.3-57.03 149.3c-5.906 6.594-5.344 16.72 1.219 22.59C459.3 430.7 463.1 432 466.9 432c4.375 0 8.748-1.812 11.9-5.312c15.23-17 27.88-35.84 37.96-55.89l4.422 102.8c.2051 3.396 2.916 6.184 6.396 6.398c3.766 .2324 7.006-2.633 7.238-6.398c0 0 9.21-216.9 9.21-217.6C544 114.8 429.2 0 288 0zM317.9 478c-63.78 8.531-130.6-11.59-179.2-55.09c-6.219-5.531-12.06-11.38-17.59-17.59c-5.875-6.562-15.97-7.188-22.59-1.281c-6.594 5.875-7.156 16-1.281 22.59c6.342 7.094 13.06 13.81 20.12 20.12C164.3 488.8 224.9 512 288 512c11.44 0 22.94-.75 34.13-2.281c8.75-1.156 14.91-9.219 13.72-17.97C334.7 482.1 326.5 476.5 317.9 478zM239.1 208c0-17.75-14.28-32-32.07-32c-17.66 0-31.94 14.25-31.94 32s14.28 32 31.94 32C225.7 240 239.1 225.8 239.1 208zM367.9 272H207.9c-26.48 0-47.95 21.47-47.95 47.95L159.1 336c0 26.51 21.49 48 47.1 48h96.03l9.174 64c.2051 3.396 2.916 6.184 6.398 6.398C323.3 454.6 326.6 451.8 326.8 448l9.176-64h31.88c6.355 0 12.41-1.299 17.96-3.541L393.2 480c.2051 3.396 2.916 6.184 6.398 6.398C403.4 486.6 406.6 483.8 406.9 480l9.158-123.7C416 355.7 415.9 320 415.9 320C415.9 293.5 394.4 272 367.9 272zM215.9 352H207.1c-8.82 0-15.98-7.178-15.98-16V319.1C191.1 311.2 199.1 304 207.9 304h7.999V352zM271.9 352h-23.1l.0571-48h23.94V352zM303.9 352V304h24.02L327.9 352H303.9zM383.9 336c0 8.822-7.154 16-15.98 16h-7.975V304h7.951c8.822 0 16.05 7.178 16.05 16L383.9 336zM399.1 208c0-17.75-14.28-32-31.95-32c-17.78 0-32.07 14.25-32.07 32s14.28 32 32.07 32C385.7 240 399.1 225.8 399.1 208z"],
    "face-kiss": [512, 512, [62870, "kiss"], "1f617", "M276.9 344.4C298.6 335.3 311.9 321 311.9 308c0-19.25-28.7-41.5-71.45-44C236.7 263.6 233.1 266.4 232.3 270.3C231.4 274 233.4 277.9 236.1 279.4l16.95 7.25c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5l-16.95 7.125c-5.691 2.5-5.934 12.25 0 14.88l16.95 7.125c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5L236.1 409c-3.633 1.5-5.57 5.375-4.723 9.25c.8477 3.5 4.117 6.125 7.871 6.125h.4844c42.75-2.5 71.45-24.75 71.45-44C312.1 367.4 298.7 353.1 276.9 344.4zM335.1 184C322.7 184 312 194.7 312 208s10.71 24 23.96 24C349.3 232 360 221.3 360 208S349.3 184 335.1 184zM175.1 184C162.7 184 152 194.7 152 208s10.71 24 23.96 24C189.3 232 200 221.3 200 208S189.3 184 175.1 184zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-kiss-beam": [512, 512, [62871, "kiss-beam"], "1f619", "M276.9 344.4C298.6 335.3 311.9 321 311.9 308c0-19.25-28.7-41.5-71.45-44C236.7 263.6 233.1 266.4 232.3 270.3C231.4 274 233.4 277.9 236.1 279.4l16.95 7.25c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5l-16.95 7.125c-5.691 2.5-5.934 12.25 0 14.88l16.95 7.125c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5L236.1 409c-3.633 1.5-5.57 5.375-4.723 9.25c.8477 3.5 4.117 6.125 7.871 6.125h.4844c42.75-2.5 71.45-24.75 71.45-44C312.1 367.4 298.7 353.1 276.9 344.4zM176 152c-23.73 0-52.67 29.25-55.94 71.38C119.7 227.1 121.9 230.6 125.6 231.8c3.512 1 7.58-.575 9.397-3.825l9.445-17c7.75-13.75 19.18-21.62 31.53-21.62c12.23 0 23.73 7.875 31.48 21.62l9.518 17c2.059 3.75 6.103 4.825 9.252 3.825c3.633-1.125 5.934-4.5 5.57-8.375C228.8 181.3 199.9 152 176 152zM336 152c-23.86 0-52.72 29.25-55.99 71.38c-.2422 3.75 1.986 7.25 5.498 8.375c3.512 1 7.58-.575 9.397-3.825l9.566-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.73 7.875 31.48 21.62l9.445 17c2.18 3.75 6.224 4.825 9.252 3.825c3.633-1.125 5.934-4.5 5.57-8.375C388.7 181.3 359.8 152 336 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-kiss-closed-eyes": [512, 512, [], "e37d", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM311.9 315.9c0-19.19-28.7-41.38-71.45-43.87C232.1 270.9 228.3 283.8 236.9 287.4l17.07 7.227c12.96 5.484 20.71 13.46 20.71 21.44s-7.75 15.95-20.71 21.44l-17.07 7.102c-6.055 2.617-5.934 12.34 0 14.83l17.07 7.105c12.96 5.484 20.71 13.46 20.71 21.43c0 7.977-7.75 15.95-20.71 21.44l-17.07 7.23c-8.477 3.609-4.844 16.07 3.633 15.33c42.75-2.492 71.45-24.68 71.45-43.87c0-12.96-13.32-27.17-35.12-36.27C298.6 343.1 311.9 328.9 311.9 315.9zM338.7 176c-27.09 0-51.34 17.14-60.38 42.67c-2.938 8.328 1.438 17.47 9.75 20.41c8.406 2.953 17.47-1.375 20.44-9.75c4.5-12.75 16.62-21.33 30.19-21.33s25.69 8.578 30.19 21.33c2.344 6.578 8.5 10.67 15.09 10.67c1.781 0 3.562-.2969 5.344-.9219c8.312-2.938 12.69-12.08 9.75-20.41C390.1 193.1 365.8 176 338.7 176zM236.4 218.7C227.3 193.1 203.1 176 176 176S124.7 193.1 115.6 218.7C112.7 227 117.1 236.1 125.4 239.1c8.406 2.953 17.47-1.375 20.44-9.75C150.3 216.6 162.4 208 176 208s25.69 8.578 30.19 21.33C208.5 235.9 214.7 240 221.3 240c1.781 0 3.562-.2969 5.344-.9219C234.9 236.1 239.3 227 236.4 218.7z"],
    "face-kiss-wink-heart": [512, 512, [62872, "kiss-wink-heart"], "1f618", "M311.9 308c0-19.25-28.7-41.5-71.45-44C236.7 263.6 233.1 266.4 232.3 270.3C231.4 274 233.4 277.9 236.1 279.4l16.95 7.25c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5l-16.95 7.125c-5.691 2.5-5.934 12.25 0 14.88l16.95 7.125c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5L236.1 409c-3.633 1.5-5.57 5.375-4.723 9.25c.8477 3.5 4.117 6.125 7.871 6.125h.4844c42.75-2.5 71.45-24.75 71.45-44c0-13-13.32-27.25-35.12-36C298.6 335.3 311.9 321 311.9 308zM152 208c0 13.31 10.71 24 23.96 24C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208zM448.9 370.7c-9.875-23.58-34.17-37.89-59.42-34.06c-15.25 2.375-28.73 11.06-36.98 23.84c-8.234 12.73-10.64 28.47-6.594 43.2l20.7 74.52c3.484 10.91 13.42 17.88 24.02 17.88c2.125 0 4.297-.2813 6.438-.875l74.58-19.14c14.94-3.891 27.53-13.92 34.48-27.5c6.906-13.45 7.688-29.39 2.203-43.59C498.6 379.2 471.9 368.1 448.9 370.7zM477.7 433.1c-2.844 5.531-7.828 9.469-14.03 11.09l-68.16 17.5l-18.72-67.42c-1.641-5.984-.7187-12.14 2.625-17.3c3.359-5.203 8.703-8.609 15.02-9.594C395.5 368.1 396.7 368 397.8 368c11.16 0 20.16 8.781 22.78 18.28l6.344 22.58l22.84-5.859c8.969-2.344 23.83 .3438 28.75 13.38C480.8 422.3 480.5 428.5 477.7 433.1zM366.2 229.3c2.344 6.578 8.5 10.67 15.09 10.67c1.781 0 3.562-.2969 5.344-.9219c8.312-2.938 12.69-12.08 9.75-20.41C387.3 193.1 363.1 175.1 336 175.1s-51.34 17.14-60.38 42.67c-2.938 8.328 1.438 17.47 9.75 20.41c8.406 2.953 17.47-1.375 20.44-9.75C310.3 216.6 322.4 207.1 336 207.1S361.7 216.6 366.2 229.3zM315.7 471.1C296.4 477.3 276.3 480 256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224c0 24.77-4 49.08-11.91 72.27c-2.859 8.359 1.609 17.45 9.984 20.3c8.359 2.922 17.48-1.625 20.3-9.984C507.4 312.1 512 284.3 512 256c0-141.2-114.8-256-256-256S0 114.8 0 256s114.8 256 256 256c23.17 0 46.14-3.094 68.27-9.203c8.516-2.344 13.52-11.16 11.16-19.69C333.1 474.6 324.3 469.7 315.7 471.1z"],
    "face-laugh": [512, 512, ["laugh"], "f599", "M175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM335.1 232C349.3 232 360 221.3 360 208s-10.71-24-24.04-24C322.7 184 312 194.7 312 208S322.7 232 335.1 232zM391 272H120.1c-9.566 0-17.07 8.375-15.86 18C113.1 361 174.5 416 247.1 416h16.04c73.38 0 134-55 142.9-126C408.1 280.4 400.6 272 391 272zM263.1 384H248c-50.25 0-93.48-33.25-107.4-80h230.8C357.5 350.8 314.2 384 263.1 384zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-laugh-beam": [512, 512, [62874, "laugh-beam"], "1f601", "M135.1 211.9l9.445-17c7.75-13.62 19.25-21.62 31.48-21.62c12.35 0 23.86 8 31.48 21.62l9.566 17c4.117 7.375 15.62 4 14.89-4.5C228.7 165.3 199.7 136 175.1 136c-23.86 0-52.71 29.25-55.98 71.38C119.4 215.9 130.9 219.3 135.1 211.9zM295.1 211.9l9.476-17c7.629-13.62 19.13-21.62 31.48-21.62c12.23 0 23.83 8 31.58 21.62l9.445 17c4.117 7.375 15.62 4 14.89-4.5C388.7 165.3 359.7 136 336 136c-23.86 0-52.67 29.25-56.06 71.38C279.3 216 290.1 219.3 295.1 211.9zM391 272H120.1c-9.566 0-17.07 8.375-15.86 18C113.1 361 174.5 416 247.1 416h16.04c73.38 0 134-55 142.9-126C408.1 280.4 400.6 272 391 272zM263.1 384H248c-50.25 0-93.48-33.25-107.4-80h230.8C357.5 350.8 314.2 384 263.1 384zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-laugh-squint": [512, 512, ["laugh-squint"], "f59b", "M391 272H120.1c-9.566 0-17.07 8.375-15.86 18C113.1 361 174.5 416 247.1 416h16.04c73.38 0 134-55 142.9-126C408.1 280.4 400.6 272 391 272zM263.1 384H248c-50.25 0-93.48-33.25-107.4-80h230.8C357.5 350.8 314.2 384 263.1 384zM296.8 190.3l64 32C363.1 223.5 365.6 224 367.1 224c5.875 0 11.52-3.234 14.33-8.844c3.953-7.906 .75-17.52-7.156-21.47L339.8 176l35.38-17.69c7.906-3.953 11.11-13.56 7.156-21.47c-3.969-7.906-13.56-11.08-21.47-7.156l-64 32c-5.422 2.719-8.842 8.242-8.842 14.3S291.4 187.6 296.8 190.3zM129.7 215.2C132.5 220.8 138.1 224 144 224c2.406 0 4.844-.5469 7.141-1.688l64-32C220.6 187.6 224 182.1 224 175.1S220.6 164.4 215.2 161.7l-64-32C143.3 125.8 133.6 128.9 129.7 136.8S128.9 154.4 136.8 158.3L172.2 176L136.8 193.7C128.9 197.6 125.7 207.3 129.7 215.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", "M285.4 207.1c8.406 2.953 17.47-1.375 20.44-9.75C310.3 184.6 322.4 175.1 336 175.1s25.69 8.578 30.19 21.33c2.344 6.578 8.5 10.67 15.09 10.67c1.781 0 3.562-.2969 5.344-.9219c8.312-2.938 12.69-12.08 9.75-20.41C387.3 161.1 363.1 143.1 336 143.1s-51.34 17.14-60.38 42.67C272.7 194.1 277.1 204.1 285.4 207.1zM391 272H120.1c-9.566 0-17.07 8.375-15.86 18C113.1 361 174.5 416 247.1 416h16.04c73.38 0 134-55 142.9-126C408.1 280.4 400.6 272 391 272zM263.1 384H248c-50.25 0-93.48-33.25-107.4-80h230.8C357.5 350.8 314.2 384 263.1 384zM175.1 200C189.3 200 200 189.3 200 176S189.3 152 175.1 152C162.7 152 152 162.7 152 176S162.7 200 175.1 200zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-lying": [512, 512, [], "e37e", "M435.2 389.6C392.4 446.5 327.1 479.2 256 479.2c-123.5 0-224-100.5-224-224s100.5-224 224-224c100.8 0 189.7 67.88 216.2 165c2.312 8.531 11.06 13.62 19.62 11.25c8.531-2.312 13.64-11.14 11.33-19.64c-30.22-111.1-131.8-188.6-247.1-188.6c-141.2 0-256 114.8-256 256s114.8 256 256 256c81.28 0 155.1-37.33 204.8-102.4c5.312-7.094 3.828-17.11-3.234-22.39C450.5 381.1 440.5 382.6 435.2 389.6zM312 176c0 13.25 10.75 24 24 24s24-10.75 24-24c0-13.26-10.75-24-24-24S312 162.7 312 176zM200 176c0-13.26-10.75-24-24-24S152 162.7 152 176c0 13.25 10.75 24 24 24S200 189.3 200 176zM448 224h-160c-8.844 0-16 7.156-16 16S279.2 256 288 256h160c17.66 0 32 14.34 32 32s-14.34 32-32 32h-96c-8.844 0-16 7.156-16 16S343.2 352 352 352h96c35.28 0 64-28.72 64-64S483.3 224 448 224zM167.3 413.5C170 415.2 173 416 176 416c5.25 0 10.41-2.594 13.47-7.344c8-12.44 20.16-20.84 34.19-23.66c13.59-2.812 27.62 .1875 39.25 8.219c7.219 5.031 17.19 3.25 22.25-4.062c5.031-7.25 3.219-17.22-4.062-22.25c-18.78-13-41.41-17.78-63.69-13.28c-22.66 4.5-42.13 17.91-54.88 37.72C157.8 398.8 159.9 408.7 167.3 413.5z"],
    "face-mask": [576, 512, [], "e37f", "M336 176c55.86 0 83.63 26.28 84.78 27.41C423.9 206.5 427.9 208 432 208c4.094 0 8.188-1.562 11.31-4.688c6.25-6.25 6.25-16.38 0-22.62C441.8 179.2 405.8 144 336 144C327.2 144 320 151.2 320 160S327.2 176 336 176zM557.1 216.2C554.3 209.6 546.5 206.9 539.5 208.1C517.4 90.07 413.3 0 288 0S58.61 90.07 36.5 208.1C29.47 206.9 21.72 209.6 18.02 216.2C13.72 223.1 16.5 233.7 24.23 238l8.438 4.688C32.44 247.1 32 251.5 32 256c0 40.65 9.729 78.95 26.59 113.1C52.44 371.3 48 377.1 48 384c0 8.844 7.156 16 16 16h12.37C122.5 467.6 200 512 288 512s165.5-44.41 211.6-112H512c8.844 0 16-7.156 16-16c0-6.926-4.443-12.68-10.59-14.91C534.3 334.1 544 296.7 544 256c0-4.494-.4434-8.875-.6719-13.31L551.8 238C559.5 233.7 562.3 223.1 557.1 216.2zM288 32c112.9 0 206.3 84.05 221.6 192.8l-105.3 58.48C392.7 266.8 373.7 256 352 256H224C202.3 256 183.3 266.8 171.7 283.3L66.43 224.8C81.69 116 175.1 32 288 32zM384 320v64c0 17.64-14.36 32-32 32H224c-17.64 0-32-14.36-32-32v-64c0-17.65 14.36-32 32-32h128C369.6 288 384 302.4 384 320zM94.31 368c-18.49-31.85-29.36-68.56-30.1-107.8l96.41 53.56c-.2031 2.08-.6322 4.095-.6322 6.228L160 368H94.31zM288 480c-68.7 0-130.2-31.15-171.3-80h45.6C169.4 427.6 194.2 448 224 448h128c29.79 0 54.6-20.44 61.74-48h45.6C418.2 448.8 356.7 480 288 480zM481.7 368H416l.0052-47.1c0-2.133-.429-4.147-.6322-6.228l96.41-53.56C511.1 299.4 500.2 336.2 481.7 368zM256 160c0-8.844-7.156-16-16-16c-69.83 0-105.8 35.19-107.3 36.69c-6.219 6.219-6.203 16.22-.0469 22.5c3.125 3.156 7.25 4.75 11.39 4.75c4.031 0 8.078-1.531 11.19-4.531C156.4 202.3 184.1 176 240 176C248.8 176 256 168.8 256 160z"],
    "face-meh": [512, 512, [61722, "meh"], "1f610", "M335.1 232C349.3 232 360 221.3 360 208s-10.71-24-24.04-24C322.7 184 312 194.7 312 208S322.7 232 335.1 232zM175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM352 336H159.1c-8.719 0-16 7.25-16 16s7.284 16 16 16h192c8.719 0 16-7.25 16-16S360.7 336 352 336zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-meh-blank": [512, 512, [62884, "meh-blank"], "1f636", "M335.1 184C322.7 184 312 194.7 312 208s10.71 24 23.96 24C349.3 232 360 221.3 360 208S349.3 184 335.1 184zM175.1 184C162.7 184 152 194.7 152 208s10.71 24 23.96 24C189.3 232 200 221.3 200 208S189.3 184 175.1 184zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-monocle": [512, 512, [], "e380", "M328 192C314.8 192 304 202.7 304 216s10.75 24 24.01 24C341.3 240 352 229.3 352 216S341.3 192 328 192zM176 184C176 170.7 165.3 160 152 160S128 170.7 128 184S138.7 208 152 208C165.3 208 176 197.3 176 184zM160 351.1c0 8.844 7.156 16 15.97 16.03c.875 0 86.59 .9062 113.7 55.16C292.5 428.8 298.2 432 304 432c2.406 0 4.844-.5313 7.156-1.688c7.906-3.969 11.09-13.56 7.156-21.47C282.3 336.8 180.3 336 176 336C167.2 336 160 343.2 160 351.1zM287.1 80.03l-25.56 19.16c-7.062 5.312-8.5 15.34-3.219 22.41C262.3 125.8 267.2 128 271.1 128c3.344 0 6.719-1.031 9.594-3.188l25.59-19.19c17-12.75 40.66-12.72 57.59-.0313c7.125 5.344 17.12 3.875 22.41-3.156c5.312-7.094 3.906-17.09-3.156-22.41C355.7 58.78 316.3 58.78 287.1 80.03zM503.2 481.7c-25.36-12.69-43.52-34.93-51.15-61.16C489.4 376 512 318.7 512 256c0-141.4-114.6-256-256-256S0 114.6 0 256s114.6 256 256 256c65.93 0 125.8-25.14 171.2-66.08c12.13 27.45 33.55 50.34 61.62 64.39C491.1 511.5 493.6 512 496 512c5.844 0 11.5-3.25 14.31-8.844C514.3 495.3 511.1 485.7 503.2 481.7zM432 208c-.5605 0-1.035 .2617-1.582 .3184C422.9 162.8 383.6 128 336 128c-53.02 0-96 42.98-96 96s42.98 96 96 96c33.43 0 62.81-17.13 80-43.05v115.5c0 6.293 .4414 12.51 1.297 18.61C376.5 453.5 319.3 480 256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224c0 41.98-11.82 81.16-32 114.8V224C448 215.2 440.8 208 432 208zM400 224c0 35.29-28.71 64-64 64c-35.29 0-64-28.71-64-64s28.71-64 64-64C371.3 160 400 188.7 400 224z"],
    "face-nauseated": [512, 512, [], "e381", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224c0-123.5 100.5-224 224-224s224 100.5 224 224C480 379.5 379.5 480 256 480zM204.8 122.3c5.312-7.062 3.906-17.09-3.156-22.41C198.7 97.73 195.3 96.7 191.1 96.7c-4.844 0-9.656 2.219-12.78 6.375C160.1 128.5 134.6 148.7 105.6 161.4C97.5 164.9 93.81 174.4 97.34 182.4c3.562 8.094 13.06 11.69 21.06 8.25C152.5 175.8 182.3 152.2 204.8 122.3zM152 208c0 13.25 10.74 24 24 24S200 221.3 200 208c0-13.26-10.74-24-24-24S152 194.7 152 208zM360 294.4c7.656-4.406 10.28-14.22 5.844-21.84C361.4 264.9 351.5 262.3 344 266.7C324.1 278.2 310.7 297.9 306.1 320H205.9C201.3 297.9 187.9 278.2 168 266.7C160.5 262.3 150.6 264.9 146.2 272.6C141.7 280.2 144.3 290 152 294.4C166.8 302.1 176 318.9 176 336s-9.188 33.03-24 41.59C144.3 382 141.7 391.8 146.2 399.4c2.969 5.125 8.344 8 13.84 8c2.719 0 5.5-.6875 8-2.156C187.9 393.8 201.3 374.1 205.9 352h100.3c4.574 22.1 17.92 41.77 37.87 53.28c2.5 1.469 5.281 2.156 8 2.156c5.5 0 10.88-2.875 13.84-8C370.3 391.8 367.7 382 360 377.6C345.2 369 336 353.1 336 336S345.2 302.1 360 294.4zM360 208c0-13.26-10.74-24-24-24s-24 10.74-24 24c0 13.25 10.74 24 24 24S360 221.3 360 208zM406.4 160.7C377.4 148 351.9 127.8 332.8 102.4C329.7 98.22 324.9 96 320 96c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38c22.41 29.88 52.28 53.53 86.38 68.41c8.125 3.438 17.53-.1562 21.06-8.25S414.5 164.2 406.4 160.7z"],
    "face-nose-steam": [512, 512, [], "e382", "M20.25 303.8C29 302.7 35.16 294.6 33.97 285.9C32.66 276.1 32 266 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 10.03-.6562 20.06-1.969 29.88c-1.188 8.75 4.969 16.81 13.72 17.97C492.5 303.1 493.2 304 493.9 304c7.875 0 14.75-5.844 15.81-13.88C511.3 278.9 512 267.4 512 256c0-141.2-114.8-256-256-256S0 114.8 0 256c0 11.44 .75 22.94 2.281 34.13C3.438 298.9 11.59 305.3 20.25 303.8zM304 256h96C408.8 256 416 248.8 416 240S408.8 224 400 224h-96C295.2 224 288 231.2 288 240S295.2 256 304 256zM96 240C96 248.8 103.2 256 112 256h96C216.8 256 224 248.8 224 240S216.8 224 208 224h-96C103.2 224 96 231.2 96 240zM448 320c-18.97 0-36.66 8.5-48.66 22.56l-87.13-52.28c-6.219-3.75-14.31-2.812-19.53 2.406c-5.188 5.188-6.188 13.25-2.406 19.53l52.28 87.13C328.5 411.3 320 429 320 448c0 7.529 1.545 14.65 3.945 21.37C302.3 476.2 279.5 480 256 480s-46.3-3.777-67.95-10.63C190.5 462.7 192 455.5 192 448c0-18.97-8.5-36.66-22.56-48.66l52.28-87.13C225.5 305.9 224.5 297.9 219.3 292.7c-5.219-5.219-13.31-6.156-19.53-2.406l-87.13 52.28C100.7 328.5 82.97 320 64 320c-35.28 0-64 28.72-64 64c0 11.28 3.031 22.31 8.719 32C3.031 425.7 0 436.7 0 448c0 35.28 28.72 64 64 64c11.28 0 22.31-3.031 32-8.719C105.7 508.1 116.7 512 128 512c15.88 0 30.24-6.027 41.44-15.64C196.8 506.3 225.8 512 256 512s59.22-5.717 86.56-15.64C353.8 505.1 368.1 512 384 512c11.28 0 22.31-3.031 32-8.719C425.7 508.1 436.7 512 448 512c35.28 0 64-28.72 64-64c0-11.28-3.031-22.31-8.719-32C508.1 406.3 512 395.3 512 384C512 348.7 483.3 320 448 320zM132.5 409.2c1.375 4.344 4.531 7.906 8.688 9.781C152.6 424.1 160 435.5 160 448c0 17.66-14.34 32-32 32c-7.781 0-15.31-2.969-21.28-8.344C103.7 468.9 99.84 467.5 96 467.5s-7.688 1.375-10.72 4.125C79.31 477 71.78 480 64 480c-17.66 0-32-14.34-32-32c0-7.781 2.969-15.31 8.344-21.28c5.5-6.094 5.5-15.34 0-21.44C34.97 399.3 32 391.8 32 384c0-17.66 14.34-32 32-32c12.47 0 23.88 7.375 29.06 18.81c1.875 4.156 5.438 7.312 9.781 8.688c4.406 1.312 9.125 .7813 13-1.562l45.53-27.31l-27.31 45.53C131.7 400.1 131.2 404.8 132.5 409.2zM471.7 426.7C477 432.7 480 440.2 480 448c0 17.66-14.34 32-32 32c-7.781 0-15.31-2.969-21.28-8.344C423.7 468.9 419.8 467.5 416 467.5s-7.688 1.375-10.72 4.125C399.3 477 391.8 480 384 480c-17.66 0-32-14.34-32-32c0-12.47 7.375-23.88 18.81-29.06c4.156-1.875 7.312-5.438 8.688-9.781c1.344-4.375 .7813-9.094-1.562-13l-27.31-45.53l45.53 27.31c3.906 2.344 8.625 2.875 13 1.562c4.344-1.375 7.906-4.531 9.781-8.688C424.1 359.4 435.5 352 448 352c17.66 0 32 14.34 32 32c0 7.781-2.969 15.31-8.344 21.28C466.2 411.4 466.2 420.6 471.7 426.7zM315.1 187.3c22.86-22.21 51.1-38.19 81.74-46.25c8.541-2.24 13.64-10.99 11.4-19.54c-2.27-8.545-11.1-13.56-19.54-11.4c-35.95 9.439-69.12 28.2-95.89 54.22c-6.338 6.156-6.498 16.29-.3398 22.62c2.533 2.611 5.709 4.15 9.012 4.666C306.3 192.4 311.4 190.9 315.1 187.3zM196.9 187.5C200.6 191.1 205.7 192.6 210.5 191.8c3.303-.5156 6.479-2.057 8.98-4.66C225.6 180.8 225.5 170.7 219.1 164.5C192.4 138.5 159.2 119.7 123.2 110.3C114.7 108.2 105.1 113.2 103.7 121.7S106.6 138.1 115.1 141.2C145.8 149.3 174 165.3 196.9 187.5z"],
    "face-party": [640, 512, [], "e383", "M402.7 176c-27.09 0-51.34 17.14-60.38 42.67c-2.938 8.328 1.438 17.47 9.75 20.41c8.406 2.953 17.47-1.375 20.44-9.75c4.5-12.75 16.62-21.33 30.19-21.33s25.69 8.578 30.19 21.33c2.344 6.578 8.5 10.67 15.09 10.67c1.781 0 3.562-.2969 5.344-.9219c8.312-2.938 12.69-12.08 9.75-20.41C454.1 193.1 429.8 176 402.7 176zM240 176c-27.09 0-51.34 17.14-60.38 42.67C176.7 227 181.1 236.1 189.4 239.1c8.406 2.953 17.47-1.375 20.44-9.75C214.3 216.6 226.4 208 240 208s25.69 8.578 30.19 21.33C272.5 235.9 278.7 240 285.3 240c1.781 0 3.562-.2969 5.344-.9219C298.9 236.1 303.3 227 300.4 218.7C291.3 193.1 267.1 176 240 176zM486.1 405.3C444.5 452.8 383.6 480 320 480c-123.5 0-224-100.5-224-224s100.5-224 224-224c89.08 0 169.7 52.75 205.4 134.4c3.531 8.062 12.95 11.81 21.06 8.25c8.094-3.531 11.8-12.97 8.25-21.06C513.9 60.28 421.8 0 320 0C264.4 0 213.1 17.1 171.1 48.2L20.81 .75C15-1.062 8.562 .5625 4.344 5.031C.1406 9.5-1.141 15.1 1.062 21.75l67.69 176c.3398 .8789 1.188 1.299 1.658 2.08C66.33 217.9 64 236.7 64 256c0 141.2 114.8 256 256 256c72.72 0 142.3-31.09 190.8-85.34c5.891-6.562 5.328-16.69-1.25-22.59C502.9 398.2 492.8 398.8 486.1 405.3zM61.32 89.24L42.86 41.25l44.4 14.02C77.67 65.88 69.14 77.31 61.32 89.24zM75.96 127.3C87.9 104.6 103.2 84.1 121.5 66.08l20.37 6.434C118.4 95.35 99.24 122.6 85.83 152.1L75.96 127.3zM592 208h-32C533.5 208 512 229.5 512 256s21.53 48 48 48H576c8.844 0 16-7.156 16-16S584.8 272 576 272h-16C551.2 272 544 264.8 544 256s7.172-16 16-16h32C600.8 240 608 247.2 608 256v64c0 8.812-7.172 16-16 16h-186.1c6.398-6.416 10.04-13.39 10.04-20.06c0-19.19-28.72-41.38-71.47-43.87c-8.355-1.125-12.23 11.71-3.633 15.33l17.07 7.227c12.96 5.484 20.71 13.46 20.71 21.44s-7.75 15.95-20.71 21.44l-17.07 7.102c-6.055 2.617-5.934 12.34 0 14.83l17.07 7.105c12.96 5.484 20.71 13.46 20.71 21.43c0 7.977-7.75 15.95-20.71 21.44l-17.07 7.23c-8.477 3.609-4.844 16.07 3.633 15.33c42.75-2.492 71.47-24.68 71.47-43.87c0-6.666-3.629-13.64-10.02-20.1H592c26.47 0 48-21.53 48-48V256C640 229.5 618.5 208 592 208z"],
    "face-pensive": [512, 512, [], "e384", "M219.4 276.1C213.3 270.7 203.2 270.5 196.9 276.5C196.4 276.1 184.3 288 160 288C136 288 123.9 277.2 123.2 276.5C116.9 270.4 106.9 270.5 100.7 276.7c-6.25 6.25-6.25 16.38 0 22.62C102.8 301.4 122.5 320 160 320s57.19-18.56 59.31-20.69C225.5 293.1 225.5 283.3 219.4 276.1zM304 384h-96C199.2 384 192 391.2 192 400S199.2 416 208 416h96c8.844 0 16-7.156 16-16S312.8 384 304 384zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224c0-123.5 100.5-224 224-224s224 100.5 224 224C480 379.5 379.5 480 256 480zM172.8 154.3c5.312-7.062 3.906-17.09-3.156-22.41C166.7 129.7 163.3 128.7 160 128.7c-4.844 0-9.656 2.219-12.78 6.375C128.1 160.5 102.6 180.7 73.6 193.4C65.5 196.9 61.82 206.4 65.35 214.4c3.562 8.094 13.06 11.69 21.06 8.25C120.5 207.8 150.3 184.2 172.8 154.3zM388.9 276.5C388.4 276.1 376.3 288 352 288c-24 0-36.09-10.78-36.84-11.47c-6.219-6.094-16.25-6.062-22.47 .1562c-6.25 6.25-6.25 16.38 0 22.62C294.8 301.4 314.5 320 352 320s57.19-18.56 59.31-20.69c6.188-6.188 6.156-16.06 .0938-22.34C405.3 270.7 395.2 270.5 388.9 276.5zM438.4 193.4c-29.06-12.69-54.5-32.84-73.63-58.28c-3.125-4.188-7.938-6.406-12.78-6.406c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38c22.41 29.88 52.28 53.53 86.38 68.41c8.125 3.438 17.53-.1562 21.06-8.25S446.5 196.9 438.4 193.4z"],
    "face-persevering": [512, 512, [], "e385", "M382.3 232.8c-3.969-7.906-13.56-11.08-21.47-7.156l-64 32c-5.422 2.719-8.842 8.242-8.842 14.3s3.42 11.6 8.842 14.32l64 32c2.297 1.141 4.734 1.688 7.141 1.688c5.875 0 11.52-3.234 14.33-8.844c3.953-7.906 .75-17.52-7.156-21.47l-35.38-17.69l35.38-17.69C383.1 250.4 386.3 240.7 382.3 232.8zM224 271.1c0-6.062-3.424-11.59-8.846-14.3l-64-32C143.3 221.8 133.6 224.9 129.7 232.8S128.9 250.4 136.8 254.3L172.2 271.1L136.8 289.7C128.9 293.6 125.7 303.2 129.7 311.1c2.812 5.609 8.453 8.844 14.33 8.844c2.406 0 4.844-.5469 7.141-1.688l64-32C220.6 283.6 224 278 224 271.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 352c-50.63 0-76.25 37.53-77.31 39.13c-4.906 7.344-2.906 17.28 4.438 22.19c7.312 4.875 17.25 2.938 22.19-4.438C205.5 408.6 222.3 384 256 384c33.13 0 50.06 23.97 50.69 24.88C309.8 413.5 314.9 416 320 416c3.062 0 6.148-.875 8.867-2.688c7.344-4.906 9.344-14.84 4.438-22.19C332.3 389.5 306.6 352 256 352zM212.3 98.65c-2.533-2.609-5.709-4.15-9.012-4.666C198.5 93.24 193.4 94.69 189.7 98.31C166.8 120.5 138.6 136.5 107.9 144.6C99.39 146.8 94.29 155.6 96.53 164.1C98.8 172.6 107.6 177.7 116.1 175.5c35.95-9.438 69.12-28.2 95.89-54.22C218.3 115.1 218.5 104.1 212.3 98.65zM404.1 144.6c-30.67-8.049-58.92-24.04-81.74-46.22c-3.732-3.656-8.83-5.105-13.62-4.357c-3.303 .5176-6.479 2.057-8.98 4.662c-6.193 6.312-6.035 16.44 .3047 22.6c26.75 26.06 59.92 44.82 95.9 54.25c8.559 2.141 17.3-2.861 19.54-11.4C417.7 155.6 412.6 146.8 404.1 144.6z"],
    "face-pleading": [512, 512, [], "e386", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM415.5 191.6c6.238 .0605 12.19-3.479 14.84-9.549c3.531-8.094-.1562-17.53-8.25-21.06c-29.06-12.69-54.5-32.84-73.63-58.28c-3.125-4.188-7.938-6.406-12.78-6.406c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38c10.93 14.57 23.69 27.6 37.79 38.91C357.8 160.6 355.1 160 352.1 160c-44.46 0-80.17 35.63-80.17 80s35.7 80 80.17 80c44.16 0 79.87-35.63 79.87-80C432 221.7 425.7 205.1 415.5 191.6zM352.1 288c-26.68 0-48.1-21.38-48.1-48S325.4 192 352.1 192c26.5 0 47.92 21.38 47.92 48S378.6 288 352.1 288zM240 240c0-44.38-35.71-80-79.87-80C157.1 160 154.3 160.6 151.3 160.9c13.95-11.24 26.6-24.13 37.45-38.55c5.312-7.062 3.906-17.09-3.156-22.41C182.7 97.73 179.3 96.7 176 96.7c-4.844 0-9.656 2.219-12.78 6.375C144.1 128.5 118.6 148.7 89.6 161.4C81.5 164.9 77.81 174.4 81.35 182.5C84.02 188.5 90.05 192.1 96.28 191.1C86.19 205.4 79.99 221.9 79.99 240c0 44.38 35.7 80 80.17 80C204.3 320 240 284.4 240 240zM160.1 288C133.4 288 111.1 266.6 111.1 240S133.4 192 160.1 192c26.5 0 47.92 21.38 47.92 48S186.6 288 160.1 288zM256 384c-23.59 0-39.58 14.53-45.31 23.12c-4.906 7.344-2.922 17.28 4.438 22.19c7.328 4.875 17.28 2.906 22.19-4.438C237.4 424.8 243.8 416 256 416c12.14 0 18.58 8.719 18.69 8.875C277.8 429.5 282.8 432 288 432c3.047 0 6.141-.875 8.859-2.688c7.359-4.906 9.344-14.84 4.438-22.19C295.6 398.5 279.6 384 256 384z"],
    "face-pouting": [512, 512, [], "e387", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM379.5 176.7l-80.03 24c-8.469 2.547-13.23 11.43-10.67 19.89C290.8 227.6 297.2 232 304.1 232c3.23 0 5.2-.8711 10.61-2.492C313.1 232.7 312 236.2 312 240c0 13.25 10.75 24 24 24s24-10.75 24-24c0-8.863-5.029-16.29-12.18-20.44l40.77-12.29c8.469-2.547 13.32-11.43 10.76-19.89C396.8 178.9 387.9 174.3 379.5 176.7zM152 240c0 13.25 10.75 24 24 24S200 253.3 200 240c0-3.812-1.08-7.289-2.662-10.49C202.9 231.2 204.8 232 208 232c6.875 0 13.3-4.445 15.36-11.38c2.562-8.453-2.294-17.34-10.76-19.89l-79.94-24c-8.406-2.438-17.43 2.184-19.96 10.65c-2.562 8.453 2.293 17.34 10.76 19.89l40.68 12.29C157 223.7 152 231.1 152 240zM256 303.1c-39.72 0-102.6 23.75-111.5 74.5c-1.816 10.88 2.059 22.25 10.29 29.5s19.98 9.875 30.64 6.625C214.7 405.6 241.8 399.1 256 399.1s41.29 5.614 70.6 14.61c7.75 2.375 20.1 2.625 30.64-6.625c8.113-7.25 12.11-18.62 10.29-29.5C358.6 327.7 295.7 303.1 256 303.1zM256 367.1c-17.68 0-46.86 5.75-80.04 16C181.2 354.2 226.1 335.1 256 335.1s74.84 18.24 80.04 47.99C302.9 373.7 273.7 367.1 256 367.1z"],
    "face-raised-eyebrow": [512, 512, [], "e388", "M179.2 216.7C178.1 216.5 177.1 216 175.1 216c-.0039 0 .0039 0 0 0c-.0117 0 .0117 0 0 0C162.7 216 152 226.7 152 240s10.73 23.1 23.98 23.1c.0117 0-.0117 0 0 0c.002 0-.002 0 0 0c.666 0 1.24-.3255 1.891-.3783c9.555-.7832 17.38-6.859 20.5-15.5C199.3 245.6 200 242.9 200 240c0-2.762-.7148-5.312-1.57-7.779C195.5 223.8 188.3 217.9 179.2 216.7zM352 336H159.1c-8.719 0-16 7.25-16 16s7.285 16 16 16h192c8.719 0 16-7.25 16-16S360.7 336 352 336zM208 160c0-8.844-7.156-16-16-16H128C119.2 144 112 151.2 112 160S119.2 176 128 176h64C200.8 176 208 168.8 208 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM374.6 80c-12.06-12.06-33.19-12.06-45.25 0l-52.69 52.69c-6.25 6.25-6.25 16.38 0 22.62C279.8 158.4 283.9 160 288 160s8.188-1.562 11.31-4.688L352 102.6l20.69 20.69c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L374.6 80zM335.1 263.1C336 263.1 335.1 263.1 335.1 263.1C335.1 263.1 335.1 263.1 335.1 263.1c1.285 0 2.414-.5384 3.645-.7318C351.1 261.4 360 252 360 240c0-12.19-9.125-21.77-20.88-23.37c-1.064-.1445-2.031-.6282-3.137-.6282c-.0039 0 .0039 0 0 0c-.0137 0 .0137 0 0 0c-11.87 0-21.29 8.742-23.21 20.1C312.6 237.4 311.1 238.6 311.1 240c0 1.441 .5762 2.689 .8184 4.059C314.8 255.3 324.2 263.1 335.1 263.1z"],
    "face-relieved": [512, 512, [], "e389", "M313.6 103.3C342.6 116 368.1 136.2 387.2 161.6C390.3 165.8 395.2 168 399.1 168c3.344 0 6.719-1.031 9.625-3.219c7.062-5.312 8.469-15.34 3.156-22.41c-22.44-29.84-52.31-53.5-86.38-68.38c-8-3.438-17.5 .1562-21.06 8.25C301.8 90.34 305.5 99.78 313.6 103.3zM219.4 244.1C213.3 238.7 203.2 238.5 196.9 244.5C196.4 244.1 184.3 256 160 256C136 256 123.9 245.2 123.2 244.5C116.9 238.4 106.9 238.5 100.7 244.7c-6.25 6.25-6.25 16.38 0 22.62C102.8 269.4 122.5 288 160 288s57.19-18.56 59.31-20.69C225.5 261.1 225.5 251.3 219.4 244.1zM111.1 168c4.844 0 9.656-2.219 12.78-6.406C143.9 136.2 169.3 116 198.4 103.3C206.5 99.78 210.2 90.34 206.7 82.25S193.7 70.56 185.6 74C151.5 88.88 121.6 112.5 99.22 142.4C93.9 149.5 95.31 159.5 102.4 164.8C105.3 166.1 108.7 168 111.1 168zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224c0-123.5 100.5-224 224-224s224 100.5 224 224C480 379.5 379.5 480 256 480zM411.4 244.1c-6.125-6.281-16.19-6.438-22.53-.4687C388.4 244.1 376.3 256 352 256c-24 0-36.09-10.78-36.84-11.47c-6.219-6.094-16.25-6.031-22.47 .1562c-6.25 6.25-6.25 16.38 0 22.62C294.8 269.4 314.5 288 352 288s57.19-18.56 59.31-20.69C417.5 261.1 417.5 251.3 411.4 244.1zM325.3 356.2c-40.44 36.44-98.13 36.44-138.6 0c-6.562-5.969-16.69-5.375-22.59 1.156c-5.938 6.562-5.406 16.69 1.156 22.59C191.5 403.5 222.8 416 256 416s64.5-12.49 90.72-36.11c6.562-5.906 7.094-16.03 1.156-22.59S331.8 350.2 325.3 356.2z"],
    "face-rolling-eyes": [512, 512, [62885, "meh-rolling-eyes"], "1f644", "M232 224c0-39.75-32.21-72-72.05-72C120.3 152 88.04 184.3 88.04 224s32.21 72 71.93 72C199.8 296 232 263.8 232 224zM159.1 264C137.9 264 120 246.1 120 224c0-13.62 7.266-25.12 17.68-32.25C136.7 194.3 135.1 197 135.1 200c0 13.25 10.67 24 23.99 24s23.96-10.75 23.96-24c0-2.875-.6055-5.75-1.695-8.25C192.7 198.9 200.1 210.4 200.1 224C200.1 246.1 182.1 264 159.1 264zM352 152c-39.84 0-72.05 32.25-72.05 72s32.21 72 72.05 72c39.72 0 71.93-32.25 71.93-72S391.7 152 352 152zM352 264c-22.16 0-40.08-17.88-40.08-40c0-13.62 7.387-25.12 17.8-32.25C328.7 194.3 328.1 197 328.1 200c0 13.25 10.64 24 23.96 24s23.99-10.75 23.99-24c0-2.875-.7266-5.75-1.695-8.25C384.7 198.9 391.1 210.4 391.1 224C391.1 246.1 374.1 264 352 264zM320.1 368H191.9c-8.719 0-15.98 7.25-15.98 16s7.266 16 15.98 16h128.1c8.719 0 15.98-7.25 15.98-16S328.8 368 320.1 368zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-sad-cry": [512, 512, [62899, "sad-cry"], "1f62d", "M255.1 288c-26.89 0-47.97 28.11-47.97 64s21.08 64 47.97 64s47.97-28.11 47.97-64S282.9 288 255.1 288zM255.9 384c-6.359 0-15.97-12.77-15.97-32s9.609-32 15.97-32s15.97 12.77 15.97 32S262.3 384 255.9 384zM213.3 223.1C221.6 220.1 226 211 223.1 202.7C214.1 177.1 189.8 160 162.7 160S111.4 177.1 102.3 202.7C99.4 211 103.8 220.1 112.1 223.1C120.5 226 129.6 221.7 132.5 213.3C137 200.6 149.1 192 162.7 192s25.69 8.578 30.19 21.33C195.2 219.9 201.4 224 207.1 224C209.8 224 211.6 223.7 213.3 223.1zM415.1 202.7C406.1 177.1 381.8 160 354.7 160s-51.34 17.14-60.38 42.67c-2.938 8.328 1.438 17.47 9.75 20.41c8.406 2.953 17.47-1.375 20.44-9.75c4.5-12.75 16.62-21.33 30.19-21.33s25.69 8.578 30.19 21.33c2.344 6.578 8.5 10.67 15.09 10.67c1.781 0 3.562-.2969 5.344-.9219C413.6 220.1 418 211 415.1 202.7zM256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256S397.2 0 256 0zM368 449.7V256c0-8.844-7.156-16-16-16S336 247.2 336 256v208.1C311.1 474.5 284.2 480 256 480s-55.11-5.465-80-15.03V256c0-8.844-7.156-16-16-16S144 247.2 144 256v193.7C77.16 410.9 32 338.7 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224C480 338.7 434.8 410.9 368 449.7z"],
    "face-sad-sweat": [576, 512, [], "e38a", "M210.7 391.1c-4.875 7.312-2.906 17.12 4.375 22.06c7.281 4.906 17.22 3.062 22.19-4.219C237.1 407.1 254.9 384 288 384s50.05 23.97 50.69 24.88c3.078 4.625 8.156 7.119 13.33 7.119c3.047 0 6.125-.8687 8.859-2.681c7.344-4.906 9.344-14.84 4.438-22.19C364.3 389.5 338.7 352 288 352S211.8 389.5 210.7 391.1zM288 0C160.2 0 51.13 95.38 34.25 221.9C33.08 230.7 39.23 238.7 48 239.9c8.875 1.094 16.8-5 17.97-13.75C80.72 115.4 176.2 32 288 32c123.5 0 224 100.5 224 224s-100.5 224-224 224c-48.95 0-95.42-15.5-134.4-44.78c-7.047-5.375-17.09-3.844-22.39 3.156c-5.312 7.062-3.891 17.09 3.172 22.41C178.9 494.3 232 512 288 512c141.2 0 256-114.8 256-256S429.2 0 288 0zM44.84 281.6C24.38 308.6 0 345.7 0 369c0 34.75 28.72 62.1 64 62.1s64-28.25 64-63c0-18.31-15.06-47.69-44.72-87.19C74.28 269.5 53.59 269.7 44.84 281.6zM64 400c-17.66 0-32-13.9-32-30.1c0-7.875 10.91-30.28 31.97-59.44C86.03 340.2 96 361.3 96 369C96 386.1 81.66 400 64 400zM344 272c0 13.31 10.71 24 24.04 24c13.25 0 23.96-10.69 23.96-24s-10.71-24-23.96-24C354.7 248 344 258.7 344 272zM457.6 222.7c8.125 3.438 17.53-.1562 21.06-8.25s-.1562-17.53-8.25-21.06c-29.06-12.69-54.5-32.84-73.63-58.28c-3.125-4.188-7.938-6.406-12.78-6.406c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38C393.6 184.2 423.5 207.8 457.6 222.7zM192 128.7c-4.844 0-9.656 2.219-12.78 6.375C160.1 160.5 134.6 180.7 105.6 193.4C97.5 196.9 93.82 206.4 97.35 214.5C100.9 222.5 110.4 226.1 118.4 222.7c34.06-14.88 63.94-38.53 86.38-68.38C210.1 147.3 208.7 137.2 201.6 131.9C198.7 129.7 195.3 128.7 192 128.7zM208 248c-13.34 0-24.04 10.69-24.04 24s10.71 24 24.04 24c13.25 0 23.96-10.69 23.96-24S221.3 248 208 248z"],
    "face-sad-tear": [512, 512, [62900, "sad-tear"], "1f622", "M175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM290.3 320H272c-8.844 0-16 7.156-16 16s7.156 16 16 16h18.33c27.75 0 53.22 10.05 64.88 25.59C358.3 381.8 363.1 384 368 384c3.344 0 6.703-1.047 9.578-3.203c7.078-5.297 8.516-15.33 3.203-22.39C363 334.7 328.4 320 290.3 320zM184 256C178.6 256 173.5 258.7 170.6 263.3C154.7 287.8 128 332.3 128 355.4C128 388.8 153.1 416 184 416s56-27.2 56-60.63c0-22.89-26.67-67.52-42.56-92.08C194.5 258.8 189.4 256 184 256zM184 384C170.8 384 160 371.2 160 355.4c0-5.375 6.734-23.7 23.98-53C201.3 331.8 208 350.1 208 355.4C208 370.9 197 384 184 384zM335.1 232C349.3 232 360 221.3 360 208s-10.71-24-24.04-24C322.7 184 312 194.7 312 208S322.7 232 335.1 232zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-scream": [640, 512, [], "e38b", "M80 272C88.84 272 96 264.8 96 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 8.844 7.156 16 16 16s16.01-7.156 16.01-16c0-141.2-114.9-256-256-256S63.99 114.8 63.99 256C63.99 264.8 71.16 272 80 272zM379.7 471.9c-38.69 10.69-80.78 10.69-119.5 0c-8.469-2.188-17.33 2.656-19.69 11.19c-2.359 8.5 2.641 17.31 11.16 19.69C273.9 508.9 296.8 512 320 512s46.14-3.094 68.27-9.188c8.516-2.375 13.52-11.19 11.16-19.69C397.1 474.6 388.3 469.8 379.7 471.9zM288.9 252.2C303.2 227.6 307.6 199.8 301 176.1C296.1 158.3 285.1 144 270.1 135.8C233.8 115.7 185.1 135.2 159.1 179.9C144.8 204.5 140.4 232.2 146.1 256c4.906 17.69 15.83 31.97 30.75 40.22c9.719 5.344 20.31 7.875 31.12 7.875C238.5 304.1 269.9 284.1 288.9 252.2zM261.2 236.1c-16.89 29.03-47.41 43.41-68.08 32.06C183.8 263 179.6 254.1 177.8 247.4c-4.234-15.28-.8906-34.53 8.969-51.5C199.6 173.8 221.1 160 239.5 160c5.406 0 10.56 1.219 15.16 3.719C264.2 169 268.3 178 270.2 184.6C274.4 199.9 271.1 219.2 261.2 236.1zM493 256c6.578-23.78 2.156-51.53-12.16-76.13c-25.97-44.72-74.73-64.19-110.1-44.13C354.9 144 343.9 158.3 338.1 176.1c-6.578 23.75-2.156 51.47 12.14 76.09c19.05 32.78 50.36 51.91 80.05 51.91c10.81 0 21.42-2.531 31.12-7.906C477.2 287.1 488.1 273.7 493 256zM446.8 268.2c-20.64 11.41-51.19-3-68.06-32.03c-9.859-16.97-13.2-36.22-8.969-51.5C371.7 178 375.8 169 385.3 163.8c4.594-2.5 9.734-3.719 15.16-3.719c18.42 0 39.91 13.84 52.73 35.91c9.859 16.97 13.2 36.22 8.969 51.5C460.4 254.1 456.2 263 446.8 268.2zM271.1 368v32c0 26.51 21.49 48 48 48s48-21.49 48-48v-32c0-26.51-21.49-48-48-48S271.1 341.5 271.1 368zM304 368c0-8.822 7.178-16 16-16s16 7.178 16 16v32c0 8.822-7.178 16-16 16s-16-7.178-16-16V368zM167.6 385.1c-5.828-10.66-13.11-21.53-23.22-34.59c-8.312-10.09-16.17-19.62-31.62-32.69C93.02 301.2 64.17 299.4 42.58 313.6c-13.14 8.594-22.14 21.78-25.34 37.19c-3.203 15.38-.2187 31.06 8.406 44.22l9.891 14.75c2.328 3.219 5.828 7.938 8.047 11.94c3.562 6.25 7.062 12.69 9.797 20.03c5.312 13.12 9.078 27.97 11.16 43.59c.3594 3.812 .6562 7.688 .8594 11.53c.4844 8.812 8.215 15.77 16.86 15.11c8.828-.4687 15.58-8.021 15.11-16.86c-.2344-4.281-.5625-8.594-1.047-13.41c-2.484-18.84-6.953-36.34-13.11-51.56c-3.188-8.562-7.406-16.5-11.73-24.16c-2.766-4.938-7.109-10.97-10.05-15.03l-9.031-13.5c-3.922-5.969-5.281-13.16-3.828-20.16c1.469-7 5.562-13 11.56-16.94c9.797-6.469 22.95-5.625 31.97 1.938c13.23 11.19 19.56 18.88 27.27 28.19c8.75 11.31 15.14 20.81 20.27 30.22c11.38 19.91 20.42 42.41 26.81 66.44c2.484 10.31 4.562 20.72 6.109 31.19C173.7 506.3 180.6 512 188.4 512c.7813 0 1.578-.0625 2.359-.1875c8.75-1.281 14.78-9.438 13.48-18.16c-1.703-11.41-3.938-22.75-6.734-34.38C190.3 432.2 180.2 407.2 167.6 385.1zM621.9 350.5c-3.281-15.38-12.36-28.53-25.53-37.06c-21.66-13.97-50.48-12.09-70.16 4.625c-15.47 13.22-23.23 22.75-31.73 33.22c-9.734 12.69-16.95 23.59-22.59 34.06c-12.62 22.41-22.59 47.5-29.75 74.94c-2.594 11.06-4.75 22.22-6.375 33.41c-1.281 8.75 4.781 16.88 13.53 18.16C450 511.9 450.8 512 451.6 512c7.828 0 14.66-5.719 15.81-13.69C468.9 488 470.9 477.8 473.2 468c6.359-24.41 15.3-46.94 26.7-67.22c4.953-9.188 11.3-18.72 19.67-29.66c8.781-10.78 14.8-17.94 27.42-28.69c8.969-7.656 22.11-8.531 31.98-2.125c6 3.875 10.12 9.875 11.62 16.88s.1719 14.16-3.734 20.19l-8.562 13c-2.938 4.031-7.516 10.44-10.3 15.53c-3.891 6.938-8.312 15.09-11.53 23.91c-6.219 15.66-10.59 33.16-13.06 52.63c-.375 4.219-.6719 8.5-.8906 12.75c-.4375 8.844 6.359 16.34 15.19 16.78c8.828 .8125 16.33-6.375 16.78-15.16c.1875-3.875 .4531-7.719 .7344-10.94c2.062-16.19 5.766-31.09 11.16-44.66c2.547-6.969 6.016-13.38 9.594-19.78c2.25-4.094 5.938-9.125 8.25-12.31l9.5-14.38C622.3 381.6 625.2 365.9 621.9 350.5z"],
    "face-shush": [512, 512, [], "e38c", "M256 0C114.8 0 0 114.8 0 256c0 70.72 28.22 136.6 79.44 185.4c6.406 6.094 16.5 5.875 22.62-.5625c6.094-6.375 5.844-16.53-.5625-22.62C56.69 375.5 32 317.9 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 75.31-37.53 145.2-100.4 186.8c-7.375 4.875-9.375 14.81-4.5 22.19c3.094 4.656 8.188 7.156 13.34 7.156c3.062 0 6.125-.875 8.844-2.656C469.1 421.9 512 342.1 512 256C512 114.8 397.2 0 256 0zM200 144c0-13.28-10.75-24-24.01-24c-13.26 0-23.99 10.72-23.99 24s10.73 24 23.99 24C189.3 168 200 157.3 200 144zM336 120C322.8 120 312 130.7 312 144s10.75 24 24.01 24C349.3 168 360 157.3 360 144S349.3 120 336 120zM326.4 227.2C319.4 232.5 311.8 236.6 304 239.1V232c0-30.88-25.12-56-56-56c-30.57 0-55.42 24.65-55.91 55.11c-2.123-1.363-4.432-2.359-6.465-3.889C178.5 221.9 168.5 223.3 163.2 230.4C157.9 237.4 159.3 247.5 166.4 252.8C174.4 258.8 183.1 263.8 192 267.9v48.3c-3.609 2.988-6.998 6.281-10.12 9.859l-16.13 18.41C151.7 360.6 144 381.1 144 402.4V424C144 472.5 183.5 512 232 512h48c26.3 0 49.34-18.68 54.78-44.42c3.678-17.12-1.137-34.63-11.93-47.56C331.1 410.3 336 397.7 336 384v-32c0-22.3-13.1-41.59-32-50.59V274.2c14.79-4.898 28.87-11.83 41.63-21.43c7.062-5.312 8.469-15.34 3.156-22.41C343.5 223.3 333.5 221.9 326.4 227.2zM224 232C224 218.7 234.7 208 248 208c13.26 0 24 10.74 24 24v64H248.1C239.8 296 231.8 297.6 224 299.9V232zM304 384c0 13.25-10.75 24-24 24S256 397.3 256 384v-8H248.1c-2.312 0-4.5 1-6.031 2.75l-16.12 18.41C224.7 398.6 224 400.5 224 402.4v2.406l65.75 29.22c10.34 4.625 16.09 15.84 13.72 26.91C301.1 472.1 291.3 480 280 480h-48c-30.88 0-56-25.12-56-56v-21.56c0-13.56 4.906-26.66 13.81-36.88l16.16-18.44C216.6 334.1 231.1 328 248.1 328H280c13.25 0 24 10.75 24 24V384z"],
    "face-sleeping": [512, 512, [], "e38d", "M469.6 145.3c-8.094 3.531-11.78 12.97-8.25 21.06C473.7 194.7 480 224.8 480 256c0 123.5-100.5 224-224 224s-224-100.5-224-224s100.5-224 224-224c31.16 0 61.28 6.281 89.59 18.62c8.125 3.531 17.53-.125 21.06-8.25c3.531-8.094-.1562-17.55-8.25-21.08C326 7.141 291.6 0 256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256c0-35.59-7.141-70.02-21.3-102.4C487.2 145.5 477.8 141.8 469.6 145.3zM256 440c30.88 0 56-25.12 56-56s-25.12-56-56-56S200 353.1 200 384S225.1 440 256 440zM256 360c13.22 0 24 10.78 24 24s-10.78 24-24 24S232 397.2 232 384S242.8 360 256 360zM288 112C288 120.8 295.2 128 304 128h25.38l-36.69 36.69c-4.562 4.562-5.938 11.47-3.469 17.44S297.5 192 304 192h64C376.8 192 384 184.8 384 176S376.8 160 368 160h-25.38l36.69-36.69c4.562-4.562 5.938-11.47 3.469-17.44S374.5 96 368 96h-64C295.2 96 288 103.2 288 112zM219.5 247.7c-6.096-5.889-16.19-6.035-22.54-.4395C196.4 247.7 184.3 258 160 258c-24.01 0-36.11-10.11-36.86-10.75C116.9 241.5 106.9 241.6 100.7 247.4c-6.252 5.859-6.252 15.35 0 21.21C102.8 270.6 122.5 288 160 288s57.23-17.4 59.35-19.39C225.5 262.8 225.5 253.5 219.5 247.7zM315.2 247.2c-6.221-5.713-16.26-5.654-22.48 .1465c-6.252 5.859-6.252 15.35 0 21.21C294.8 270.6 314.5 288 352 288s57.23-17.4 59.35-19.39c6.189-5.801 6.158-15.06 .0938-20.95c-6.127-5.889-16.19-6.035-22.54-.4395C388.4 247.7 376.3 258 352 258C328 258 315.9 247.9 315.2 247.2zM432 32h25.38l-36.69 36.69c-4.562 4.562-5.938 11.47-3.469 17.44S425.5 96 432 96h64C504.8 96 512 88.84 512 80S504.8 64 496 64h-25.38l36.69-36.69c4.562-4.562 5.938-11.47 3.469-17.44S502.5 0 496 0h-64C423.2 0 416 7.156 416 16S423.2 32 432 32z"],
    "face-sleepy": [512, 512, [], "e38e", "M336.6 465.1C310.9 474.1 283.8 480 256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224c0 20.31-2.719 40.41-8.062 59.75c-2.344 8.5 2.656 17.31 11.19 19.69c8.406 2.25 17.34-2.688 19.69-11.19C508.9 302.2 512 279.2 512 256c0-141.2-114.8-256-256-256S0 114.8 0 256s114.8 256 256 256c31.75 0 62.75-5.75 92.06-17.06c8.25-3.188 12.34-12.47 9.188-20.69C354.1 466 344.8 461.9 336.6 465.1zM200.4 438.7c27.91-8.469 47.03-11.5 55.63-11.5s27.72 3.031 55.63 11.5C314.5 439.6 317.3 440 320.2 440c6.875 0 13.59-2.469 18.94-7.188c7.562-6.656 11.06-16.59 9.312-26.59C340.1 363.8 288.9 344 256 344s-84.94 19.78-92.44 62.28c-1.688 9.938 1.781 19.84 9.344 26.5C180.5 439.4 190.7 441.7 200.4 438.7zM256 376c22.09 0 54.94 12.78 61.44 31.06c-25.5-7.562-47.75-11.84-61.44-11.84c-13.31 0-34.72 4.062-59.31 11.22C204.6 387.4 235.1 376 256 376zM347.8 304c-13.22 0-24.69 9.781-27.28 23.25c-2.531 13.19 3.844 26.34 15.44 31.97c40.16 19.62 39 42.41 37.78 66.53c-.2187 4.062-.4062 7.938-.4062 11.59C373.3 478.5 404.5 512 442.9 512C481 512 512 478.5 512 437.3C512 344.3 403.3 304 347.8 304zM442.9 480c-20.34 0-37.53-19.53-37.53-42.66c0-3.125 .1875-6.469 .3438-9.969c1.219-23.62 3.188-62-43.91-90.5C410.2 342.5 480 376.1 480 437.3C480 460.9 463.3 480 442.9 480zM219.4 244.1C213.3 238.7 203.2 238.5 196.9 244.5C196.4 244.1 184.3 256 160 256C136 256 123.9 245.2 123.2 244.5C116.9 238.4 106.9 238.5 100.7 244.7c-6.25 6.25-6.25 16.38 0 22.62C102.8 269.4 122.5 288 160 288s57.19-18.56 59.31-20.69C225.5 261.1 225.5 251.3 219.4 244.1zM411.3 267.3c6.188-6.188 6.156-16.06 .0938-22.34c-6.094-6.281-16.19-6.438-22.53-.4687C388.4 244.1 376.3 256 352 256c-24 0-36.09-10.78-36.84-11.47c-6.219-6.094-16.25-6.031-22.47 .1562c-6.25 6.25-6.25 16.38 0 22.62C294.8 269.4 314.5 288 352 288S409.2 269.4 411.3 267.3z"],
    "face-smile": [512, 512, [61720, "smile"], "1f642", "M335.1 232C349.3 232 360 221.3 360 208s-10.71-24-24.04-24C322.7 184 312 194.7 312 208S322.7 232 335.1 232zM175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM346.2 325.7C323.8 352.6 290.9 367.9 256 367.9s-67.79-15.34-90.2-42.22c-5.691-6.75-15.76-7.594-22.54-1.969c-6.781 5.75-7.72 15.72-2.029 22.47C169.6 380.3 211.6 399.1 256 399.1s86.35-19.63 114.8-53.76c5.691-6.875 4.833-16.97-1.948-22.47C361.1 318.1 351.9 318.1 346.2 325.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-smile-beam": [512, 512, [62904, "smile-beam"], "1f60a", "M346.2 325.8C323.8 352.6 290.9 367.9 256 367.9s-67.81-15.29-90.21-42.17c-5.691-6.75-15.74-7.625-22.52-2c-6.781 5.75-7.71 15.75-2.018 22.5C169.6 380.4 211.6 399.1 256 399.1s86.34-19.6 114.8-53.73c5.691-6.875 4.844-17-1.938-22.5C361.1 318.1 351.9 319 346.2 325.8zM176 189.3c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 231.7 223.2 232.8 226.3 231.8c3.512-1.125 5.934-4.5 5.691-8.375C228.8 181.3 199.8 152 175.1 152c-23.73 0-52.68 29.25-55.95 71.38C119.6 227.1 122.1 230.6 125.7 231.8c3.391 1 7.459-.575 9.397-3.825l9.445-17C152.3 197.2 163.8 189.3 176 189.3zM336 152c-23.86 0-52.72 29.25-55.99 71.38c-.2422 3.75 2.107 7.25 5.619 8.375c3.391 1 7.387-.575 9.324-3.825l9.566-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.73 7.875 31.48 21.62l9.445 17c2.18 3.75 6.176 4.825 9.324 3.825c3.633-1.125 6.127-4.5 5.764-8.375C388.8 181.3 359.8 152 336 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-smile-halo": [512, 512, [], "e38f", "M294.1 267.9l9.566-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.73 7.875 31.48 21.62l9.445 17c2.18 3.75 6.176 4.826 9.324 3.826c3.633-1.125 6.127-4.5 5.764-8.375c-3.27-42.13-32.29-71.36-56.03-71.36c-23.86 0-52.72 29.23-55.99 71.36c-.2422 3.75 2.107 7.25 5.619 8.375C289.1 272.7 293.1 271.1 294.1 267.9zM175.1 191.1c-23.73 0-52.68 29.23-55.95 71.36C119.6 267.1 122.1 270.6 125.7 271.7c3.391 1 7.459-.5762 9.396-3.826l9.445-17c7.75-13.75 19.25-21.62 31.48-21.62c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 271.6 223.2 272.7 226.3 271.7c3.512-1.125 5.934-4.5 5.691-8.375C228.8 221.2 199.8 191.1 175.1 191.1zM165.8 341.8c-5.691-6.75-15.74-7.625-22.52-2c-6.781 5.75-7.709 15.75-2.018 22.5C169.6 396.4 211.6 415.1 256 415.1s86.34-19.61 114.8-53.73c5.691-6.875 4.844-17-1.938-22.5c-6.902-5.625-16.95-4.75-22.64 2C323.8 368.6 290.9 383.9 256 383.9S188.2 368.6 165.8 341.8zM447.9 156.2c-7.875 4.031-11 13.66-6.969 21.53C456.3 207.7 464 239.4 464 272c0 114.7-93.31 208-208 208s-208-93.31-208-208c0-32.63 7.75-64.34 23.03-94.25c4.031-7.875 .9062-17.5-6.969-21.53c-7.844-4-17.47-.9062-21.53 6.969C24.94 197.7 16 234.3 16 272c0 132.3 107.7 240 240 240s240-107.7 240-240c0-37.72-8.938-74.34-26.53-108.8C465.4 155.3 455.8 152.3 447.9 156.2zM256 0C160.9 0 0 15.16 0 72S160.9 144 256 144s256-15.16 256-72S351.1 0 256 0zM256 112c-136.8 0-218.6-26.47-224.1-39.34C37.41 58.47 119.2 32 256 32c134.7 0 216.1 25.66 223.8 40C472.1 86.34 390.7 112 256 112z"],
    "face-smile-hearts": [640, 512, [], "e390", "M80.4 286.4c.2813 0 .5625 0 .8438-.0313C90.06 285.9 96.84 278.3 96.37 269.5C96.15 265.1 95.1 260.6 95.1 256.1c0-123.5 100.5-223.1 224-223.1c27.56 0 54.5 4.968 80.06 14.72c8.219 3.124 17.5-.9685 20.66-9.217c3.156-8.248-.9687-17.5-9.219-20.65C382.3 5.769 351.5 .0228 320 .0228c-141.2 0-256 114.9-256 255.1c0 5.093 .1546 10.17 .4359 15.2C64.87 279.7 71.94 286.4 80.4 286.4zM551 323.2c1.156 .2499 2.313 .3749 3.438 .3749c7.375 0 13.97-5.093 15.63-12.56c3.938-17.87 5.936-36.41 5.936-55.03c0-17.15-1.717-34.23-5.061-50.85c-1.75-8.654-10.19-14.22-18.88-12.5c-8.656 1.75-14.25 10.19-12.5 18.87c2.938 14.5 4.438 29.49 4.438 44.52c0 16.31-1.75 32.49-5.188 48.11C536.9 312.8 542.4 321.3 551 323.2zM422.5 455.2c-68.91 35.52-156.4 31.81-221.1-9.685c-7.406-4.593-17.31-2.499-22.09 4.968c-4.719 7.467-2.5 17.37 4.969 22.09C224.2 498.4 271.5 512 320 512c40.72 0 81.25-9.81 117.2-28.34c7.844-4.062 10.94-13.68 6.875-21.56C440 454.3 430.4 451.2 422.5 455.2zM320 400c33.16 0 64.5-12.5 90.72-36.12c6.563-5.905 7.094-16.03 1.156-22.59c-5.906-6.561-16.03-7.155-22.59-1.156c-40.44 36.43-98.13 36.43-138.6 0c-6.563-5.967-16.69-5.374-22.59 1.156c-5.938 6.561-5.406 16.69 1.156 22.59C255.5 387.5 286.8 400 320 400zM619.2 365.4c-21.16-16.93-52.03-16.62-74.25-.125c-21.5-16.1-52.28-18.03-74.16-1.656c-13.31 9.967-21.56 24.87-22.66 40.93c-1.063 15.78 4.875 31.27 16.34 42.55l59.31 57.83c5.031 4.686 11.53 7.03 18.03 7.03c6.375 0 12.75-2.249 17.78-6.78l62.06-56.3c12.19-11.15 18.84-26.71 18.31-42.71C639.4 390.4 631.9 375.6 619.2 365.4zM600.1 425.3l-58.13 52.74l-55.09-53.74c-4.844-4.749-7.25-10.1-6.813-17.56c.4687-6.842 3.969-13.03 9.906-17.46c4.625-3.499 10.44-5.186 16.34-5.186c7.625 0 15.47 2.874 21.13 8.404l16.72 16.18l17.44-15.65c10.53-9.592 27.41-10.75 37.59-2.593c5.469 4.343 8.594 10.34 8.813 16.84C608.2 413.1 605.4 420.4 600.1 425.3zM171.2 333.4c-21.16-16.9-52.03-16.62-74.25-.125C75.47 316.3 44.69 315.3 22.78 331.6c-13.31 9.967-21.56 24.87-22.66 40.93c-1.063 15.78 4.875 31.27 16.34 42.55l59.31 57.83c5.031 4.686 11.53 7.03 18.03 7.03c6.375 0 12.75-2.25 17.78-6.78l62.06-56.3c12.19-11.15 18.84-26.71 18.31-42.71C191.4 358.4 183.9 343.6 171.2 333.4zM152.1 393.3l-58.13 52.74L38.87 392.3c-4.844-4.749-7.25-10.1-6.813-17.56c.4688-6.842 3.969-13.03 9.906-17.46c4.625-3.499 10.44-5.186 16.34-5.186c7.625 0 15.47 2.874 21.13 8.404l16.72 16.18l17.44-15.65c10.53-9.592 27.41-10.75 37.59-2.593c5.469 4.343 8.594 10.34 8.813 16.84C160.2 381.1 157.4 388.4 152.1 393.3zM523.8 153c5.031 4.686 11.53 7.03 18.03 7.03c6.375 0 12.75-2.249 17.78-6.78l62.06-56.3c12.19-11.15 18.84-26.71 18.31-42.71c-.5313-15.78-8.094-30.62-20.78-40.77c-21.16-16.9-52.03-16.59-74.25-.125c-21.5-16.1-52.28-18.03-74.16-1.656c-13.31 9.967-21.56 24.87-22.66 40.93c-1.063 15.78 4.875 31.27 16.34 42.55L523.8 153zM489.1 37.32c4.625-3.499 10.44-5.186 16.34-5.186c7.625 0 15.47 2.874 21.13 8.404l16.72 16.18l17.44-15.65c10.53-9.592 27.41-10.75 37.59-2.593c5.469 4.343 8.594 10.34 8.813 16.84c.2187 6.748-2.594 13.15-7.906 18.03l-58.13 52.74l-55.09-53.74c-4.844-4.749-7.25-10.1-6.813-17.56C480.5 47.95 484 41.76 489.1 37.32zM338.9 224.4c-1.703 10.43 10.78 16.99 18.5 10.08l8.969-7.967c13.85-12.42 43.25-12.42 57.22 0l9.109 7.996c7.834 7.03 20.04 .205 18.45-10.11c-3.746-23.67-31.96-39.48-56.14-39.48C370.1 184.9 342.7 200.7 338.9 224.4zM269.8 226.5l9.111 7.996C286.7 241.5 298.9 234.7 297.4 224.4C293.6 200.7 265.4 184.9 241.2 184.9c-24.07 0-52.36 15.82-56.11 39.48C183.4 234.8 195.9 241.4 203.6 234.5l8.969-7.967C226.4 214.1 255.8 214.1 269.8 226.5z"],
    "face-smile-horns": [640, 512, [], "e391", "M640 16.25C640 2.252 626.8 0 623.1 0c-9.426 0-46.61 26.29-143.7 56.69c-45.49-36.62-102.2-56.69-160.5-56.69c-58.24 0-114.7 20.03-160.1 56.62C64.26 26.7 25.59 .2961 16.92 .2961C8.009 .2961 0 7.259 0 17.29c0 1.992 10.43 84.53 72.17 174.1c-5.436 21.06-8.313 42.47-8.313 63.72C63.86 397.2 178.7 512 319.8 512s255.9-114.8 255.9-255.1c0-21.12-2.591-42.41-7.965-63.37C630.5 100.9 640 18.27 640 16.25zM554.5 153.7c-16.05-36.76-22.47-41.71-31.63-41.71c-8.771 0-15.96 7.156-15.96 16.02c0 2.914 .7969 5.863 2.469 8.509c18.4 29.15 25.59 57.47 25.59 57.47s-.0034-.0135-.0034-.0135s.0018 .0073 .0081 .0324c-.0063-.0251-.0081-.0324-.0081-.0324s8.877 27.72 8.877 62.01c0 123.5-100.5 223.1-223.9 223.1s-223.9-100.5-223.9-223.1c0-20.75 3.031-41.69 8.967-62.29c.0004-.0008 .0006-.0011 .0006-.0011l-.0011 .0023c0 0 .0006-.0012 .0027-.0054C104.9 193.7 104.9 193.7 104.9 193.7s.0001-.0003 .0006-.0011C118.2 147.8 132.9 139.3 132.9 128c0-8.705-6.978-15.98-15.95-15.98c-9.425 0-15.74 5.389-31.5 41.33C64.06 118.1 48.06 81.57 38.28 44.53c52.56 24.05 118.3 45.96 125 45.96c17.39 0 55.31-58.49 156.6-58.49c98.64 0 142.3 58.55 156.8 58.55c6.439 0 71.48-21.4 125.1-45.96C591.8 82.23 575.8 118.7 554.5 153.7zM215.1 271.9c0 13.25 10.74 23.1 23.99 23.1s23.99-10.75 23.99-23.1c0-3.812-1.08-7.289-2.661-10.49c5.534 1.66 7.492 2.548 10.69 2.548c6.873 0 13.3-4.445 15.36-11.38c.4639-1.531 .6846-3.076 .6846-4.595c0-6.869-4.512-13.21-11.45-15.29L196.7 208.7c-1.513-.4388-3.046-.6489-4.558-.6489c-6.885 0-13.32 4.357-15.4 11.3c-.4641 1.531-.6848 3.077-.6848 4.596c0 6.869 4.511 13.21 11.44 15.29l40.67 12.23C220.1 255.6 215.1 263.1 215.1 271.9zM422.4 351.1c-17.92 0-33.25 47.94-102.5 47.94c-69.16 0-84.65-47.94-102.5-47.94c-10.77 0-15.99 9.248-15.99 16.03c0 16.22 51.38 63.95 118.5 63.95c67.46 0 118.5-48.12 118.5-64.16C438.5 356.8 428.9 351.1 422.4 351.1zM447.1 208.1c-1.515 0-3.056 .2123-4.581 .6558l-80.01 23.1c-6.916 2.08-11.36 8.391-11.36 15.24c0 1.536 .2235 3.098 .6926 4.646c2.062 6.937 8.395 11.38 15.27 11.38c3.23 0 5.198-.9268 10.6-2.548c-1.582 3.203-2.661 6.68-2.661 10.49c0 13.25 10.74 23.1 23.99 23.1s23.99-10.75 23.99-23.1c0-8.863-5.028-16.29-12.17-20.44l40.77-12.23c6.933-2.086 11.44-8.422 11.44-15.29c0-1.519-.2207-3.065-.6848-4.596C461.2 212.4 454.8 208.1 447.1 208.1z"],
    "face-smile-plus": [640, 512, ["smile-plus"], "f5b9", "M624 80h-64v-64C560 7.156 552.8 0 544 0s-16 7.156-16 16v64h-64c-8.844 0-16 7.156-16 15.1S455.2 112 464 112h64v64C528 184.8 535.2 192 544 192s16-7.156 16-16v-64h64c8.844 0 16-7.156 16-15.1S632.8 80 624 80zM224 64C100.3 64 0 164.3 0 288c0 123.7 100.3 224 224 224s224-100.3 224-224C448 164.3 347.7 64 224 64zM224 480c-105.9 0-192-86.13-192-192s86.13-192 192-192s192 86.13 192 192S329.9 480 224 480zM144 264c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S120 226.7 120 240C120 253.3 130.7 264 144 264zM304 264c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S280 226.7 280 240C280 253.3 290.7 264 304 264zM341.7 321c-8.188-3.156-17.5 .9844-20.66 9.25C304.9 372.6 266.8 400 224 400s-80.88-27.36-97.06-69.7c-3.156-8.266-12.41-12.42-20.66-9.25c-8.25 3.156-12.38 12.41-9.219 20.66C117.1 396.6 167.8 432 224 432s105.1-35.44 126.9-90.3C354.1 333.5 349.1 324.2 341.7 321z"],
    "face-smile-relaxed": [512, 512, [], "e392", "M256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256S397.2 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM325.3 340.1c-40.44 36.44-98.13 36.44-138.6 0c-6.562-5.969-16.69-5.375-22.59 1.156c-5.938 6.562-5.406 16.69 1.156 22.59C191.5 387.5 222.8 400 256 400s64.5-12.5 90.72-36.13c6.562-5.906 7.094-16.03 1.156-22.59S331.8 334.1 325.3 340.1zM331 184.8c-24.07 0-52.36 15.82-56.11 39.49c-1.703 10.43 10.78 16.99 18.5 10.08l8.969-7.969c13.85-12.42 43.25-12.42 57.22 0l9.109 7.998c7.834 7.031 20.04 .2051 18.45-10.11C383.4 200.7 355.2 184.8 331 184.8zM205.8 226.4l9.111 7.998c7.832 7.031 20.04 .2051 18.45-10.11C229.6 200.7 201.4 184.8 177.2 184.8c-24.07 0-52.36 15.82-56.11 39.49C119.4 234.8 131.9 241.3 139.6 234.4l8.969-7.969C162.4 214 191.8 214 205.8 226.4z"],
    "face-smile-tear": [512, 512, [], "e393", "M256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM351.1 256c-3.008 0-5.998 1.367-7.965 4.1c-16.34 21.71-52.05 72.17-52.05 97.16C291.1 389.8 318.9 416 352 416c33.14 0 59.94-26.24 59.94-58.74c0-24.99-35.56-75.45-51.91-97.16C358 257.4 354.1 256 351.1 256zM352 384c-15.48 0-28.07-11.99-28.08-26.53c.4082-5.9 8.529-24.53 28.08-53.55c19.39 28.82 27.52 47.54 27.92 53.34C379.1 372 367.4 384 352 384zM336 232C349.3 232 360 221.3 360 208s-10.71-24-23.96-24C322.7 184 312 194.7 312 208S322.7 232 336 232zM256 368c-35.13 0-68.59-15.47-91.88-42.47c-5.844-6.719-15.94-7.344-22.59-1.656c-6.688 5.781-7.406 15.88-1.656 22.59C169.3 380.5 211.6 400 256 400c8.844 0 16-7.156 16-16S264.8 368 256 368z"],
    "face-smile-tongue": [576, 512, [], "e394", "M316.1 216.7c-.4687 4.812 2.469 9.094 7.25 10.66c4.969 1.656 10.34-.2187 12.97-4.562l8.125-13.59C350.4 199.4 358.1 193.8 368 193.8c9.062 0 17.69 5.594 23.62 15.31l8.094 13.66c2 3.312 5.426 5.125 9.238 5.125c1.188 0 2.543-.125 3.762-.5313c4.75-1.562 7.656-5.844 7.25-10.66c-3-35.78-29.81-60.75-52-60.75C345.6 156 318.8 180.1 316.1 216.7zM377.6 461.4C349.3 473.7 319.2 480 288 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224c0 8.844 7.156 16 16 16S544 264.8 544 256c0-141.2-114.8-256-256-256S32 114.8 32 256s114.8 256 256 256c35.59 0 70.03-7.156 102.4-21.31c8.094-3.531 11.78-12.97 8.25-21.06C395.1 461.6 385.7 457.9 377.6 461.4zM515.3 311l-59.86-34.54C453.4 274.5 450.1 272.9 448 272.3c-8.5-1.812-17.09 3.844-18.88 12.5C415.6 351.6 356.2 400 288 400s-127.6-48.44-141.1-115.2C145.1 276.2 136.5 270.5 128 272.3C119.3 274.1 113.8 282.5 115.5 291.2C132.1 372.8 204.6 432 288 432c30.65 0 59.77-8.123 85.24-22.3l-.9316 1.611l63.81 36.84c12.44 7.188 26.03 10.59 39.47 10.59c27.38 0 54.06-14.19 68.72-39.56C566.2 381.4 553.2 332.8 515.3 311zM516.6 403.2c-13.06 22.56-42.06 30.28-64.5 17.28l-51.39-29.67c24.32-20.31 42.83-47.25 53.4-78.2l45.21 26.09C521.9 351.7 529.6 380.7 516.6 403.2zM156.1 216.7C155.6 221.5 158.5 225.8 163.2 227.4c5 1.656 10.38-.2187 13.06-4.594l8.062-13.56c5.969-9.781 14.59-15.38 23.59-15.38c9.125 0 17.72 5.594 23.56 15.34l8.219 13.62c2 3.312 5.504 5.125 9.316 5.125c1.188 0 2.465-.125 3.684-.5313c4.75-1.562 7.656-5.844 7.25-10.66C256.1 180.1 230.1 156 207.9 156C185.6 156 158.8 180.1 156.1 216.7z"],
    "face-smile-upside-down": [512, 512, [], "e395", "M176 280C162.7 280 152 290.7 152 304s10.71 24 24.04 24C189.3 328 200 317.3 200 304S189.3 280 176 280zM336 280C322.7 280 312 290.7 312 304s10.71 24 24.04 24C349.3 328 360 317.3 360 304S349.3 280 336 280zM165.8 186.3C188.2 159.4 221.1 144.1 256 144.1s67.79 15.34 90.2 42.22c5.691 6.75 15.76 7.594 22.54 1.969c6.781-5.75 7.72-15.72 2.029-22.47C342.4 131.7 300.4 112 256 112S169.6 131.7 141.2 165.8C135.5 172.7 136.4 182.8 143.1 188.3C150 193.9 160.1 193 165.8 186.3zM256 512c141.4 0 256-114.6 256-256s-114.6-256-256-256S0 114.6 0 256S114.6 512 256 512zM256 32c123.5 0 224 100.5 224 224s-100.5 224-224 224s-224-100.5-224-224S132.5 32 256 32z"],
    "face-smile-wink": [512, 512, [62682, "smile-wink"], "1f609", "M175.1 232C189.3 232 200 221.3 200 208S189.3 184 175.1 184C162.7 184 152 194.7 152 208S162.7 232 175.1 232zM346.2 325.8C323.8 352.6 290.9 368 256 368s-67.81-15.38-90.21-42.25C152.3 309.6 127.6 330 141.2 346.3C169.7 380.4 211.6 400 256 400s86.34-19.62 114.8-53.75C384.4 330 359.7 309.5 346.2 325.8zM336 176c-27.09 0-51.34 17.14-60.38 42.67c-2.938 8.328 1.438 17.47 9.75 20.41c8.406 2.953 17.47-1.375 20.44-9.75C310.3 216.6 322.4 208 336 208s25.69 8.578 30.19 21.33C368.5 235.9 374.7 240 381.3 240c1.781 0 3.562-.2969 5.344-.9219c8.312-2.938 12.69-12.08 9.75-20.41C387.3 193.1 363.1 176 336 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-smiling-hands": [640, 512, [], "e396", "M184 207.4c-.7266 8.5 10.73 11.92 15.09 4.549l9.445-17c7.75-13.62 19.25-21.62 31.48-21.62c12.35 0 23.86 8 31.48 21.62l9.566 17C285.2 219.3 296.8 216 296 207.4C292.8 165.3 263.8 136 239.1 136C216.2 136 187.3 165.3 184 207.4zM344 207.4c-.7266 8.5 10.83 11.92 14.94 4.549l9.566-17c7.629-13.62 19.13-21.62 31.48-21.62c12.23 0 23.73 8 31.48 21.62l9.445 17C445.1 219.3 456.7 216 456.1 207.4C452.8 165.3 423.9 136 400 136C376.3 136 347.3 165.3 344 207.4zM640 343.8c0-11.96-4.656-23.2-13.11-31.65c-1.256-1.256-2.572-2.428-3.945-3.514c-.2754-11.08-4.635-22.09-13.07-30.53c-8.197-8.195-19.01-12.82-30.55-13.1c-1.072-1.357-2.236-2.668-3.488-3.92c-8.457-8.457-19.7-13.12-31.66-13.12c-11.96 0-23.2 4.656-31.65 13.11l-33.53 33.53c-7.473-8.596-17.95-14.65-30.07-16.37c-2.295-.332-4.645-.4961-6.961-.4961c-24.23 0-45.06 18.13-48.46 42.17l-3.459 24.47C370 359.4 345.7 367.9 320 367.9c-25.66 0-50.01-8.406-70.03-23.46L246.5 319.9c-3.398-24.04-24.23-42.17-48.45-42.17c-2.318 0-4.668 .1641-7.035 .5059C178.9 279.1 168.5 286 161 294.6L127.5 261.1c-8.457-8.457-19.7-13.11-31.65-13.11s-23.2 4.656-31.65 13.11C62.93 262.4 61.76 263.7 60.69 265C49.15 265.3 38.33 269.9 30.14 278.1c-8.441 8.443-12.8 19.45-13.08 30.53C15.69 309.7 14.37 310.9 13.11 312.2C4.658 320.6 0 331.9 0 343.8c0 9.26 2.795 18.09 7.982 25.53C2.793 376.8 0 385.6 0 394.9c0 11.96 4.658 23.2 13.11 31.65l52.41 52.41C86.82 500.3 115.1 512 145.3 512c37.98 0 72.55-19.31 92.46-51.66c13.96-22.67 19.72-49.18 17.34-75.55c20 9.725 42.05 15.2 64.91 15.2c22.79 0 44.77-5.448 64.72-15.11c-2.494 25.62 3.389 52.5 17.53 75.47C422.2 492.7 456.7 512 494.7 512c30.14 0 58.47-11.74 79.77-33.05l52.41-52.41C635.3 418.1 640 406.8 640 394.9c0-9.262-2.793-18.09-7.982-25.53C637.2 361.9 640 353.1 640 343.8zM210.5 443.6C196.5 466.4 172.1 480 145.3 480c-21.58 0-41.87-8.404-57.13-23.67l-52.41-52.41c-4.986-4.986-4.986-13.06 0-18.05c2.494-2.492 5.76-3.74 9.027-3.74c3.266 0 6.531 1.248 9.025 3.74l25.02 25.02l7.48-7.48l-50.55-50.55c-4.986-4.988-4.986-13.07 0-18.05c2.494-2.494 5.76-3.74 9.027-3.74c3.266 0 6.531 1.246 9.025 3.74l50.55 50.55l7.48-7.48L52.76 318.8c-4.986-4.986-4.986-13.06 0-18.05c2.494-2.492 5.762-3.74 9.027-3.74s6.533 1.248 9.025 3.74l59.06 59.06l7.48-7.48L86.81 301.8c-4.986-4.986-4.986-13.07 0-18.05C89.3 281.2 92.57 279.1 95.83 279.1c3.268 0 6.533 1.246 9.027 3.74l81.32 81.32l-5.07-35.87C179.8 319.9 186.3 311.3 195.6 309.9c.8281-.1191 1.65-.1777 2.463-.1777c8.365 0 15.57 6.178 16.77 14.65l7.94 56.38c.0117 .084-.0098-.084 0 0c.0039 .0117-.002-.0137 0 0C226.4 402.5 222 424.9 210.5 443.6zM561.2 410.9l25.02-25.02c2.494-2.492 5.76-3.74 9.027-3.74c3.266 0 6.533 1.248 9.025 3.74c4.988 4.988 4.988 13.07 0 18.05l-52.41 52.41C536.6 471.6 516.3 480 494.7 480c-26.78 0-51.17-13.62-65.21-36.44c-11.52-18.71-15.87-41.08-12.26-62.77c.002-.0137-.002 .0117 0 0c.0098-.084-.0117 .084 0 0l7.941-56.38c1.197-8.471 8.402-14.65 16.77-14.65c.8105 0 1.633 .0586 2.463 .1777c9.309 1.322 15.79 9.932 14.48 19.24l-5.07 35.87l81.32-81.32c2.494-2.494 5.76-3.74 9.025-3.74c3.268 0 6.533 1.246 9.027 3.74c4.986 4.986 4.986 13.07 0 18.05l-50.55 50.55l7.48 7.48l59.06-59.06c2.494-2.492 5.76-3.74 9.027-3.74c3.266 0 6.531 1.248 9.025 3.74c4.986 4.988 4.986 13.07 0 18.05l-59.06 59.06l7.48 7.48l50.55-50.55c2.494-2.494 5.76-3.74 9.027-3.74c3.266 0 6.533 1.246 9.025 3.74c4.988 4.986 4.988 13.06 0 18.05l-50.55 50.55L561.2 410.9zM82.78 216.3C91.36 218.5 100 213 102 204.4C125.1 102.9 215.6 32 320 32s194 70.91 217.1 172.4c1.734 7.375 8.312 12.34 15.56 12.34c1.219 0 2.453-.125 3.688-.4375c8.594-2 13.92-10.62 11.91-19.22C541.8 81.06 439.3 0 319.1 0S98.22 81.06 70.88 197.1C68.86 205.7 74.19 214.3 82.78 216.3zM362.4 475.5C346.4 478.6 332.9 480 320 480s-26.36-1.438-42.36-4.531c-8.766-1.531-17.06 4.031-18.73 12.69c-1.688 8.688 4 17.06 12.67 18.75C289.6 510.4 305 512 319.1 512s30.36-1.625 48.42-5.094c8.672-1.688 14.36-10.06 12.67-18.75C379.4 479.5 371.1 473.8 362.4 475.5z"],
    "face-smirking": [512, 512, [], "e397", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM384 192c-1.418 0-2.629 .627-3.998 .8066C378.7 192.5 377.4 192 376 192H320c-8.844 0-16 7.156-16 16S311.2 224 320 224h32c0 17.67 14.33 32 32 32c17.67 0 32-14.33 32-32C416 206.3 401.7 192 384 192zM192 224c0-17.67-14.33-32-32-32C158.6 192 157.4 192.6 156 192.8C154.7 192.5 153.4 192 152 192H96C87.16 192 80 199.2 80 208S87.16 224 96 224h32c0 17.67 14.33 32 32 32C177.7 256 192 241.7 192 224zM371.9 320.5c-8.719-2.094-17.28 3.062-19.41 11.66C344.8 362.7 317.5 384 286 384H176C167.2 384 160 391.2 160 400S167.2 416 176 416h110c46.19 0 86.28-31.31 97.5-76.13C385.7 331.3 380.5 322.6 371.9 320.5z"],
    "face-sunglasses": [512, 512, [], "e398", "M346.2 341.7C323.8 368.5 291 383.9 256 383.9s-67.82-15.33-90.2-42.22c-13.62-16.2-38.16 4.203-24.57 20.5C169.7 396.4 211.5 415.1 256 415.1s86.31-19.56 114.8-53.76C384.3 345.9 359.6 325.5 346.2 341.7zM496 160C504.8 160 512 152.8 512 144S504.8 128 496 128h-18.64C433 51.61 350.5 0 256 0C167.6 0 86.67 44.66 39.42 119.4C37.68 122.2 36.45 125.2 34.82 128H16C7.156 128 0 135.2 0 144S7.156 160 16 160h3.148C6.852 190.4 0 222.8 0 256c0 141.2 114.8 256 256 256s256-114.8 256-256c0-33.96-6.757-66.32-18.82-96H496zM436.9 155.5c5.863 6.988 8.553 16.1 7.232 25.16l-7 48C434.9 244.2 421.2 256 405.5 256h-46.84l52.69-52.69c4.578-4.562 5.953-11.47 3.469-17.44C412.3 179.9 406.5 176 400 176h-25.38l32-32h5.859c9.146 0 17.79 3.975 23.85 10.8C436.5 155 436.7 155.3 436.9 155.5zM321.2 198.1C323.7 204.1 329.5 208 336 208h25.38l-44.69 44.69c-.1289 .1289-.168 .3047-.291 .4375c-10-4.387-17.57-13.57-19.07-24.94l-6.328-48c-1.203-9.125 1.594-18.34 7.688-25.28C304.8 147.1 313.5 144 322.7 144h38.64l-36.69 36.69C320.1 185.3 318.7 192.2 321.2 198.1zM256 32c69.92 0 132.4 32.24 173.5 82.6C424 113.1 418.3 112 412.5 112h-89.75c-18.42 0-35.95 7.938-48.11 21.81C271.9 136.1 269.5 140.4 267.5 144H244.5C242.5 140.4 240.1 136.1 237.4 133.8C225.2 119.9 207.7 112 189.3 112H99.52C93.61 112 87.89 113.1 82.31 114.7C124.6 62.52 187.8 32 256 32zM190.8 185.9C188.3 179.9 182.5 176 176 176H150.6l32-32h6.641c9.203 0 17.98 3.969 24.05 10.91C219.4 161.8 222.2 171.1 221 180.2l-6.328 48C212.6 244 198.9 256 182.9 256H134.6l52.69-52.69C191.9 198.8 193.3 191.8 190.8 185.9zM75.09 155.5C75.31 155.3 75.46 155 75.67 154.8C81.73 147.1 90.37 144 99.52 144h37.86L100.7 180.7C96.11 185.3 94.73 192.2 97.22 198.1C99.69 204.1 105.5 208 112 208h25.38L92.88 252.5C83.56 247.1 76.43 239.4 74.86 228.6l-7-48C66.54 171.6 69.23 162.5 75.09 155.5zM256 480c-123.5 0-224-100.5-224-224c0-18.02 2.6-35.72 6.795-52.98l4.408 30.23C47.77 264.5 75 288 106.5 288h76.41c32 0 59.28-23.91 63.45-55.63l6.328-48C253.1 181.6 252.9 178.8 252.9 176h6.162c-.002 2.791-.1699 5.574 .1992 8.375l6.328 48C269.8 264.1 297.1 288 329.1 288h76.41c31.53 0 58.77-23.53 63.33-54.75l4.48-30.73C477.5 219.7 480 237.5 480 256C480 379.5 379.5 480 256 480z"],
    "face-surprise": [512, 512, [62914, "surprise"], "1f62e", "M200 208c0-13.31-10.71-24-24.04-24C162.7 184 152 194.7 152 208s10.71 24 23.96 24C189.3 232 200 221.3 200 208zM256 288c-35.36 0-64.01 28.75-64.01 64S220.6 416 256 416s64.01-28.75 64.01-64S291.4 288 256 288zM256 384c-17.56 0-31.97-14.38-31.97-32S238.4 320 256 320s31.97 14.38 31.97 32S273.6 384 256 384zM335.1 184C322.7 184 312 194.7 312 208s10.71 24 23.96 24C349.3 232 360 221.3 360 208S349.3 184 335.1 184zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-swear": [640, 512, [], "e399", "M208 400c-13.25 0-24 10.74-24 24C184 437.3 194.7 448 208 448s24-10.75 24-24C232 410.7 221.3 400 208 400zM208 384C216.8 384 224 376.8 224 368v-64C224 295.2 216.8 288 208 288S192 295.2 192 304v64C192 376.8 199.2 384 208 384zM116.4 352.6l-4.156-1.188c-16.91-4.969-16.56-7.125-16.06-9.875c.7813-4.5 10.28-6.594 21.5-4.906c4.156 .6562 8.75 2.094 13.09 3.594c8.375 2.938 17.47-1.562 20.34-9.906c2.875-8.344-1.562-17.47-9.906-20.34C136.8 308.5 132.4 307.5 128 306.4V304C128 295.2 120.8 288 112 288S96 295.2 96 304v2.166c-16.66 3.875-28.63 14.1-31.38 29.93c-5.656 33.03 26.5 42.47 38.63 46l4.344 1.25c21.09 6.062 20.78 7.938 20.22 11.09c-.7813 4.562-10.16 6.656-21.56 4.938C100.4 398.5 94.09 396.1 88.34 394l-2.969-1.062c-8.438-2.938-16 1.906-18.97 10.19c-2.969 8.312 2.781 17.97 11.09 20.97C83.21 426.2 89.57 428.2 96 429.7V432C96 440.8 103.2 448 112 448S128 440.8 128 432v-1.826c16.78-3.83 28.62-14.39 31.34-30.3C165.1 366.5 133.4 357.5 116.4 352.6zM463.1 122.6c-3.031-8.312-12.16-12.53-20.5-9.625l-79.41 28.62c-8.312 3-12.62 12.19-9.625 20.5c2.375 6.5 8.5 10.56 15.06 10.56c1.812 0 3.625-.3125 5.438-.9375l3.062-1.104C376.7 172.4 376 174.1 376 176c0 13.25 10.75 24 24 24s24-10.75 24-24c0-7.812-3.977-14.43-9.756-18.81l39.19-14.13C461.8 140.1 466.1 130.9 463.1 122.6zM271.4 172.6c6.562 0 12.69-4.062 15.06-10.56c3-8.312-1.312-17.5-9.625-20.5L197.4 112.9c-8.375-2.875-17.47 1.344-20.5 9.625c-3 8.312 1.312 17.5 9.625 20.5l39.19 14.13C219.1 161.6 216 168.2 216 176c0 13.25 10.75 24 24 24S264 189.3 264 176c0-1.922-.668-3.625-1.094-5.416l3.062 1.104C267.8 172.3 269.6 172.6 271.4 172.6zM563.6 299.2c-7.031-5.25-17.06-3.844-22.41 3.219l-84 112c-5.281 7.062-3.844 17.09 3.219 22.41C463.3 438.1 466.7 440 469.1 440c4.844 0 9.657-2.219 12.81-6.406l84-112C572.1 314.5 570.7 304.5 563.6 299.2zM552 392c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24S576 429.3 576 416C576 402.7 565.3 392 552 392zM400 352c8.844 0 16-7.156 16-16S408.8 320 400 320H384V304C384 295.2 376.8 288 368 288S352 295.2 352 304V320h-32V304C320 295.2 312.8 288 304 288S288 295.2 288 304V320H272C263.2 320 256 327.2 256 336S263.2 352 272 352H288v32H272C263.2 384 256 391.2 256 400S263.2 416 272 416H288v16C288 440.8 295.2 448 304 448s16-7.156 16-16V416h32v16c0 8.844 7.156 16 16 16s16-7.156 16-16V416h16c8.844 0 16-7.156 16-16S408.8 384 400 384H384v-32H400zM352 384h-32v-32h32V384zM576 224H64C28.71 224 0 252.7 0 288v160c0 35.29 28.71 64 64 64h512c35.29 0 64-28.71 64-64V288C640 252.7 611.3 224 576 224zM608 448c0 17.67-14.33 32-32 32H64c-17.67 0-32-14.33-32-32V288c0-17.67 14.33-32 32-32h512c17.67 0 32 14.33 32 32V448zM472 344c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24S448 306.7 448 320C448 333.3 458.7 344 472 344zM320 32c101.3 0 186.9 67.59 214.6 160h33.04C539.2 81.64 439.2 0 320 0S100.8 81.64 72.39 192h33.04C133.1 99.59 218.7 32 320 32z"],
    "face-thermometer": [576, 512, [], "e39a", "M545.9 174.1C536.6 164.7 524.3 160 512 160s-24.56 4.688-33.94 14.06l-163.8 163.8C306.1 336.7 297.4 336 288 336c-69.83 0-105.8 35.19-107.3 36.69c-6.219 6.219-6.203 16.22-.0469 22.5c6.172 6.25 16.28 6.281 22.58 .2187C204.4 394.3 232.1 368 288 368s83.63 26.28 84.69 27.31C375.8 398.4 379.9 400 384 400s8.188-1.562 11.31-4.688c1.877-1.877 3-4.135 3.75-6.5l146.9-146.9C564.7 223.2 564.7 192.8 545.9 174.1zM523.3 219.3l-15.51 15.51L504.5 231.5c-4.688-4.688-12.28-4.688-16.97 0s-4.688 12.31 0 17l3.303 3.301l-15.02 15.02L472.5 263.5c-4.688-4.688-12.28-4.688-16.97 0s-4.688 12.31 0 17l3.303 3.301l-15.02 15.02L440.5 295.5c-4.688-4.688-12.28-4.688-16.97 0s-4.688 12.31 0 17l3.303 3.301l-15.02 15.02l-3.318-3.316c-4.688-4.688-12.28-4.688-16.97 0s-4.688 12.31 0 17l3.303 3.301L380.9 361.7c-7.316-4.775-17.32-10.21-30.28-14.96l150-150c6.768-6.766 16.89-5.73 22.62 0C529.5 202.9 529.5 213.1 523.3 219.3zM344 208c0 13.25 10.75 24 24 24s24-10.75 24-24c0-13.26-10.75-24-24-24S344 194.7 344 208zM523.6 304.6c-8.531-2.188-17.34 2.656-19.69 11.19C477.3 412.5 388.5 480 288 480c-123.5 0-224-100.5-224-224s100.5-224 224-224c71.13 0 136.4 32.66 179.2 89.59c5.312 7.031 15.38 8.531 22.41 3.156c7.062-5.281 8.484-15.31 3.188-22.41C443.9 37.31 369.3 0 288 0C146.8 0 32 114.8 32 256s114.8 256 256 256c114.8 0 216.3-77.19 246.8-187.8C537.2 315.8 532.2 306.9 523.6 304.6zM184 208c0 13.25 10.75 24 24 24S232 221.3 232 208c0-13.26-10.75-24-24-24S184 194.7 184 208z"],
    "face-thinking": [512, 512, [], "e39b", "M256 0C114.8 0 0 114.8 0 256c0 31.75 5.75 62.75 17.06 92.06c3.219 8.281 12.56 12.38 20.69 9.188c8.25-3.188 12.34-12.47 9.188-20.69C37.03 310.9 32 283.8 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 111.8-83.44 207.3-194.1 222c-8.75 1.188-14.91 9.219-13.75 18c1.094 8.031 7.969 13.88 15.84 13.88c.7187 0 1.438-.0313 2.156-.125C416.6 492.9 512 383.8 512 256C512 114.8 397.2 0 256 0zM319.2 381.5c12.16-4.031 22.03-12.56 27.75-24.03c5.75-11.47 6.688-24.5 2.625-36.69C340.8 294.7 276.5 256 209.2 256H192C183.2 256 176 263.2 176 272S183.2 288 192 288h17.16c19.3 0 38.35 3.781 56.28 10.26L160 333.4V320c0-26.47-21.53-48-48-48S64 293.5 64 320v112C64 476.1 99.88 512 144 512h40.94c34.5 0 65-22 75.88-54.69l21.12-63.38L319.2 381.5zM256.6 368.6l-26.19 78.59C223.9 466.8 205.6 480 184.9 480H144C117.5 480 96 458.5 96 432V320c0-8.812 7.188-16 16-16S128 311.2 128 320v57.78l170.9-56.94c8.562-2.938 17.44 1.625 20.25 10.09c1.375 4.062 1.062 8.406-.875 12.25c-1.906 3.781-5.156 6.625-9.219 7.969L256.6 368.6zM152 192c0 13.28 10.73 24 23.99 24C189.3 216 200 205.3 200 192S189.3 168 175.1 168C162.7 168 152 178.7 152 192zM230.4 156.8C233.3 158.1 236.7 160 240 160c4.844 0 9.656-2.219 12.81-6.406c5.281-7.062 3.844-17.09-3.219-22.41L224 112c-28.31-21.25-67.75-21.25-96.06 0C120.9 117.3 119.5 127.3 124.8 134.4c5.281 7.031 15.28 8.5 22.41 3.156c16.94-12.69 40.59-12.72 57.59 .0313L230.4 156.8zM360 208c0-13.28-10.72-24-23.99-24C322.8 184 312 194.7 312 208s10.75 24 24.01 24C349.3 232 360 221.3 360 208z"],
    "face-tired": [512, 512, [62920, "tired"], "1f62b", "M296.8 222.3l64 32C363.1 255.5 365.6 256 367.1 256c5.875 0 11.52-3.234 14.33-8.844c3.953-7.906 .75-17.52-7.156-21.47L339.8 208l35.38-17.69c7.906-3.953 11.11-13.56 7.156-21.47c-3.969-7.906-13.56-11.08-21.47-7.156l-64 32C291.4 196.4 288 201.9 288 208S291.4 219.6 296.8 222.3zM129.7 247.2C132.5 252.8 138.1 256 144 256c2.406 0 4.844-.5469 7.141-1.688l64-32C220.6 219.6 224 214.1 224 208S220.6 196.4 215.2 193.7l-64-32C143.3 157.8 133.6 160.9 129.7 168.8S128.9 186.4 136.8 190.3L172.2 208L136.8 225.7C128.9 229.6 125.7 239.3 129.7 247.2zM256 288C209.8 288 159.2 317.3 132.9 359.2c-6.984 11.15-6.438 25.43 1.379 36.01c6.129 8.293 15.75 12.99 25.74 12.99c2.752 0 5.533-.3574 8.277-1.092c24.49-6.559 55.66-10.17 87.77-10.17c32.1 0 63.23 3.611 87.66 10.17c2.748 .7363 5.537 1.096 8.295 1.096c9.975 0 19.58-4.676 25.71-12.95c7.826-10.56 8.402-24.83 1.453-35.98C353 317.3 302.3 288 256 288zM256 364.1c-34 0-68.02 3.754-96.04 11.26C181 342.7 221.1 320 256.1 320c34.11 0 75.05 22.7 95.94 56.22C324 368.7 290 364.1 256 364.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480z"],
    "face-tissue": [512, 512, [], "e39c", "M256 0C114.8 0 .002 114.8 .002 256c0 8.844 7.154 16 15.1 16S32 264.8 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224s-100.5 224-224 224c-8.844 0-16 7.156-16 16S247.2 512 256 512C397.2 512 512 397.2 512 256S397.2 0 256 0zM242.7 392.9C245.8 397.5 250.8 400 256 400c3.062 0 6.156-.875 8.875-2.688L304 371.2l39.13 26.09c5.375 3.562 12.38 3.562 17.75 0l48-32c7.344-4.906 9.344-14.84 4.438-22.19c-4.938-7.375-14.94-9.312-22.19-4.438L352 364.8l-39.13-26.09c-5.375-3.562-12.38-3.562-17.75 0l-48 32C239.8 375.6 237.8 385.5 242.7 392.9zM190.3 288.3L25.53 311.8c-13 1.844-23.09 11.78-25.12 24.62c-2.125 12.88 4.312 25.5 16 31.38l25.69 12.84l-17.72 70.94c-2.469 10.06 .4457 20.96 7.758 28.27c7.312 7.344 18.27 10.19 28.3 7.756l70.91-17.75l12.88 25.78C149.3 505.8 159.5 512 170.8 512l4.688-.375c12.94-2.062 22.88-12.16 24.72-25.16l23.53-164.5c1.344-9.125-1.781-18.56-8.469-25.31C208.8 290.2 199.6 287.1 190.3 288.3zM170.2 475.1l-12.41-24.88c-4.438-8.906-13.59-14.28-23.03-14.28c-2.094 0-4.219 .25-6.312 .8125l-72.06 18.03l18.03-72.06c2.969-11.81-2.562-23.88-13.47-29.31l-23.66-11.81l154.4-22.06L170.2 475.1zM382.3 168.8c-3.969-7.906-13.56-11.08-21.47-7.156l-64 32c-5.422 2.719-8.847 8.242-8.847 14.3s3.425 11.6 8.847 14.32l64 32c2.297 1.141 4.734 1.688 7.141 1.688c5.875 0 11.52-3.234 14.33-8.844c3.953-7.906 .75-17.52-7.156-21.47l-35.38-17.69l35.38-17.69C383.1 186.4 386.3 176.7 382.3 168.8zM215.2 193.7l-64-32C143.3 157.8 133.6 160.9 129.7 168.8S128.9 186.4 136.8 190.3L172.2 207.1L136.8 225.7C128.9 229.6 125.7 239.2 129.7 247.1c2.812 5.609 8.453 8.844 14.33 8.844c2.406 0 4.844-.5469 7.141-1.688l64-32c5.422-2.719 8.842-8.258 8.842-14.32S220.6 196.4 215.2 193.7z"],
    "face-tongue-money": [512, 512, [], "e39d", "M241.3 412.8c-6.156-2.469-13.16 .4375-15.64 6.594c-2.5 6.125 .4375 13.12 6.578 15.66c2.725 1.102 6.895 2.598 11.73 3.799V448c0 6.625 5.375 12 12 12s12-5.375 12-12v-8.451c2.301-.5879 4.572-1.299 6.672-2.455c6.5-3.625 10.81-9.812 12.11-17.41c3.812-22.19-17.3-28.28-27.45-31.22l-2.945-.8594c-.0313 0 .0156 .0313 0 0c-5.859-1.719-7.523-2.797-7.477-3.328c.5469-.625 5.359-2.438 17.73 .8125c6.469 1.812 12.98-2.125 14.67-8.531c1.703-6.406-2.109-12.97-8.516-14.66C271.1 361.5 269.6 361.3 268 360.9V352c0-6.625-5.375-12-12-12S244 345.4 244 352v8.541c-2.871 .7969-5.543 1.889-7.922 3.428c-5.844 3.75-9.703 9.594-10.86 16.38c-3.75 21.94 17.45 28.23 24.4 30.3c.0469 0-.0469 0 0 0l3.055 .8906c3.594 1.031 9.594 2.781 10.44 4.5C261.5 417.3 253.2 417.7 241.3 412.8zM352 391.8v.4062c0 14.78 18.31 21.42 28.02 10.27c18.99-21.83 31.92-49.04 35.73-79.46c1.125-8.844-1.625-17.78-7.516-24.47C402.3 291.9 393.7 288 384.8 288h-257.5C118.3 288 109.7 291.9 103.8 298.6c-5.922 6.719-8.656 15.66-7.531 24.44c3.811 30.42 16.74 57.63 35.73 79.46C141.7 413.7 160 407 160 392.2c0-3.936-1.539-7.66-4.125-10.62C140.1 364.5 130.5 343.5 127.3 320L176 319.8V432c0 44.11 35.89 80 80 80c44.11 0 80-35.89 80-80V319.2L384 319.1c-2.979 23.82-13.2 45.04-27.96 62.26C353.5 384.3 352 387.1 352 391.8zM304 432c0 26.47-21.53 48-48 48s-48-21.53-48-48V320h96V432zM349.7 206.3c-5.547 3.156-20.94 2.25-39.61-5.344c-8.156-3.312-17.52 .5625-20.86 8.781c-3.344 8.156 .5938 17.5 8.766 20.84C302.9 232.6 310.9 235.4 320 237.4V248c0 8.844 7.156 16 16 16S352 256.8 352 248V238.8c4.604-.8809 9.076-2.246 13.19-4.525c9.891-5.469 16.19-14.53 18.17-26.16c5.75-33.47-25.94-42.56-42.95-47.47l-4.891-1.438c-.0156 0 0 0 0 0c-16.19-4.875-15.84-6.969-15.33-9.875c.2969-1.75 1.266-2.594 2.094-3.125c1.953-1.25 10.08-4.812 32.48 1.094c8.516 2.312 17.3-2.812 19.56-11.38c2.266-8.531-2.828-17.31-11.38-19.56C359.1 115.3 355.6 114.8 352 114.2V104c0-8.844-7.156-16-16-16S320 95.16 320 104v9.666c-5.564 1.189-10.74 2.877-15.03 5.646c-8.797 5.656-14.59 14.41-16.33 24.62c-5.656 32.84 25.84 42.38 37.77 45.97c.0313 0-.0313-.0313 0 0c.0469 0-.0625 0 0 0l5.156 1.5c21.16 6.094 20.84 7.938 20.27 11.28C351.4 205.4 350.5 205.9 349.7 206.3zM189.7 206.3c-5.562 3.156-20.94 2.25-39.61-5.344C141.9 197.7 132.5 201.5 129.2 209.8c-3.344 8.156 .5938 17.5 8.766 20.84C142.9 232.6 150.9 235.4 160 237.4V248c0 8.844 7.156 16 16 16S192 256.8 192 248V238.8c4.604-.8809 9.076-2.246 13.19-4.525c9.891-5.469 16.19-14.53 18.17-26.16C229.1 174.7 197.4 165.6 180.4 160.7l-4.891-1.438c-.0156 0 0 0 0 0C159.3 154.3 159.7 152.3 160.2 149.3c.2969-1.75 1.266-2.594 2.094-3.125c1.953-1.25 10.05-4.812 32.48 1.094C203.4 149.6 212.1 144.5 214.3 135.9C216.6 127.4 211.5 118.6 202.1 116.4C199.1 115.3 195.6 114.8 192 114.2V104c0-8.844-7.156-16-16-16S160 95.16 160 104v9.666C154.4 114.9 149.3 116.5 144.1 119.3C136.2 124.1 130.4 133.7 128.6 143.9C122.1 176.8 154.5 186.3 166.4 189.9c.0313 0-.0313-.0313 0 0c.0469 0-.0625 0 0 0l5.156 1.5C192.7 197.5 192.4 199.3 191.8 202.7C191.4 205.4 190.5 205.9 189.7 206.3zM256 0C114.8 0 0 114.8 0 256c0 95.17 52.31 181.1 136.5 226.5C144.3 486.6 154 483.6 158.2 475.8c4.125-7.812 1.125-17.48-6.688-21.61C77.78 415.2 32 339.3 32 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 83.28-45.78 159.2-119.5 198.2c-7.812 4.125-10.81 13.8-6.688 21.61c2.875 5.438 8.438 8.531 14.16 8.531c2.531 0 5.094-.5938 7.469-1.859C459.7 437.1 512 351.2 512 256C512 114.8 397.2 0 256 0z"],
    "face-tongue-sweat": [576, 512, [], "e39e", "M184 272c0 13.31 10.71 24 24.04 24C221.3 296 232 285.3 232 272S221.3 248 208 248C194.7 248 184 258.7 184 272zM44.84 281.6C24.38 308.6 0 345.7 0 369C0 403.8 28.72 432 64 432s64-28.24 64-62.99c0-18.31-15.06-47.7-44.72-87.2C74.28 269.5 53.59 269.7 44.84 281.6zM64 400c-17.66 0-32-13.91-32-31c0-7.875 10.91-30.28 31.97-59.44C86.03 340.2 96 361.3 96 369C96 386.1 81.66 400 64 400zM192 128.7c-4.844 0-9.656 2.219-12.78 6.375C160.1 160.5 134.6 180.7 105.6 193.4C97.5 196.9 93.82 206.4 97.35 214.4c3.562 8.094 13.06 11.69 21.06 8.25C152.5 207.8 182.3 184.2 204.8 154.3c5.312-7.062 3.906-17.09-3.156-22.41C198.7 129.7 195.3 128.7 192 128.7zM288 344c-61.86 0-112 21.49-112 48c0 8.938 6.074 17.2 16 24.37v.7969c0 51.75 42.49 94.29 94.71 94.83C340.9 512 384 469.8 384 418v-1.645c9.926-7.164 16-15.43 16-24.37C400 365.5 349.9 344 288 344zM352 418c0 34.51-29.24 62.47-64.96 61.99C252 479.6 224 451.3 224 417.2v-2.473c0-12.06 7.045-23.05 17.97-28.17c.5898-.2734 .6484-.293 .9199-.4062c14.41-6.297 31.12 2.055 34.63 17.07l1.816 7.508c2.059 8.961 15.26 8.961 17.32 0l1.816-7.508c3.512-15.02 20.22-23.37 34.51-17.07c.2109 .0859 .2871 .1094 .5859 .2422C344.8 391.2 352 402.5 352 414.7V418zM344 272c0 13.31 10.71 24 24.04 24C381.3 296 392 285.3 392 272s-10.71-24-23.96-24C354.7 248 344 258.7 344 272zM288 0C160.2 0 51.09 95.41 34.25 221.9C33.09 230.7 39.25 238.7 48 239.9c8.5 1.094 16.81-5 17.1-13.75C80.72 115.4 176.2 32 288 32c123.5 0 224 100.5 224 224c0 63.63-27.22 124.5-74.66 166.9c-6.594 5.906-7.156 16.03-1.281 22.59C439.3 449.1 443.6 450.9 448 450.9c3.812 0 7.625-1.344 10.66-4.062C512.9 398.3 544 328.7 544 256C544 114.8 429.2 0 288 0zM457.6 222.7c8.125 3.438 17.53-.1562 21.06-8.25s-.1562-17.53-8.25-21.06c-29.06-12.69-54.5-32.84-73.63-58.28c-3.125-4.188-7.938-6.406-12.78-6.406c-3.344 0-6.719 1.031-9.594 3.219c-7.094 5.281-8.5 15.31-3.188 22.38C393.6 184.2 423.5 207.8 457.6 222.7z"],
    "face-unamused": [512, 512, [], "e39f", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM384 192c-1.418 0-2.629 .627-3.998 .8066C378.7 192.5 377.4 192 376 192H320c-8.844 0-16 7.156-16 16S311.2 224 320 224h32c0 17.67 14.33 32 32 32s32-14.33 32-32C416 206.3 401.7 192 384 192zM192 224c0-17.67-14.33-32-32-32C158.6 192 157.4 192.6 156 192.8C154.7 192.5 153.4 192 152 192H96C87.16 192 80 199.2 80 208S87.16 224 96 224h32c0 17.67 14.33 32 32 32S192 241.7 192 224zM255.1 327.7c-31.12 0-60.59 13.83-80.57 37.83c-13.68 16.25 11.02 36.75 24.58 20.5c27.85-33.5 84.28-33.5 112 0c13.44 16 38.39-4 24.58-20.5C316.6 341.6 287.2 327.7 255.1 327.7z"],
    "face-viewfinder": [512, 512, [], "e2ff", "M144 480h-96C39.17 480 32 472.8 32 464v-96C32 359.2 24.84 352 16 352S0 359.2 0 368v96C0 490.5 21.53 512 48 512h96C152.8 512 160 504.8 160 496S152.8 480 144 480zM16 160C24.84 160 32 152.8 32 144v-96C32 39.19 39.17 32 48 32h96C152.8 32 160 24.84 160 16S152.8 0 144 0h-96C21.53 0 0 21.53 0 48v96C0 152.8 7.156 160 16 160zM496 352c-8.844 0-16 7.156-16 16v96c0 8.812-7.172 16-16 16h-96c-8.844 0-16 7.156-16 16s7.156 16 16 16h96c26.47 0 48-21.53 48-48v-96C512 359.2 504.8 352 496 352zM464 0h-96C359.2 0 352 7.156 352 16S359.2 32 368 32h96C472.8 32 480 39.19 480 48v96C480 152.8 487.2 160 496 160S512 152.8 512 144v-96C512 21.53 490.5 0 464 0zM256 96C167.6 96 96 167.6 96 256s71.63 160 160 160s160-71.63 160-160S344.4 96 256 96zM256 384c-70.58 0-128-57.42-128-128s57.42-128 128-128c70.58 0 128 57.42 128 128S326.6 384 256 384zM296 240C309.3 240 320 229.3 320 216S309.3 192 296 192S272 202.7 272 216S282.7 240 296 240zM216 240c13.25 0 24-10.75 24-24S229.3 192 216 192S192 202.7 192 216S202.7 240 216 240zM328 277.2c-7.625-4.422-17.44-1.875-21.88 5.828C295.8 300.9 276.6 312 256 312S216.2 300.9 205.8 283C201.4 275.3 191.6 272.8 183.1 277.2C176.3 281.6 173.7 291.4 178.2 299.1C194.2 326.8 224 344 256 344s61.81-17.22 77.84-44.92C338.3 291.4 335.7 281.6 328 277.2z"],
    "face-vomit": [576, 512, [], "e3a0", "M119.8 427.9c6.562-5.875 7.125-16 1.219-22.59C84.25 364.3 64 311.2 64 256c0-123.5 100.5-224 224-224s224 100.5 224 224c0 55.22-20.25 108.3-57.03 149.3c-5.906 6.594-5.344 16.72 1.219 22.59C459.3 430.7 463.1 432 466.9 432c4.375 0 8.766-1.812 11.92-5.312C520.9 379.7 544 319.1 544 256c0-141.2-114.8-256-256-256S32 114.8 32 256c0 63.09 23.14 123.7 65.2 170.7C103.1 433.2 113.2 433.8 119.8 427.9zM400 368c0 8.844 7.156 16 16 16s16-7.156 16-16c0-45.59-61.91-80-144-80s-144 34.41-144 80C144 376.8 151.2 384 160 384s16-7.156 16-16c0-22.66 47.91-48 112-48S400 345.3 400 368zM256 432C256 440.8 263.2 448 272 448s16-7.164 16-16c0-8.838-7.164-16-16-16S256 423.2 256 432zM288 368c0 8.836 7.164 16 16 16s16-7.164 16-16c0-8.838-7.164-16-16-16S288 359.2 288 368zM528 424c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24s24-10.75 24-24C552 434.7 541.3 424 528 424zM48 456c-13.26 0-24 10.74-24 24c0 13.25 10.74 24 24 24c13.25 0 24-10.75 24-24C72 466.7 61.25 456 48 456zM414.3 168.8c-3.969-7.906-13.56-11.08-21.47-7.156l-64 32c-5.422 2.719-8.843 8.242-8.843 14.3s3.421 11.6 8.843 14.32l64 32c2.297 1.141 4.734 1.688 7.141 1.688c5.875 0 11.52-3.234 14.33-8.844c3.953-7.906 .75-17.52-7.156-21.47L371.8 207.1l35.38-17.69C415.1 186.4 418.3 176.7 414.3 168.8zM161.7 247.1c2.812 5.609 8.453 8.844 14.33 8.844c2.406 0 4.844-.5469 7.141-1.688l64-32c5.422-2.719 8.845-8.258 8.845-14.32S252.6 196.4 247.2 193.7l-64-32C175.3 157.8 165.6 160.9 161.7 168.8S160.9 186.4 168.8 190.3l35.38 17.69L168.8 225.7C160.9 229.6 157.7 239.2 161.7 247.1zM467.3 475.8l-39.54-13.18C401.6 453.9 384 429.4 384 401.9V400c0-8.838-7.164-16-16-16S352 391.2 352 400v1.871C352 433.5 367.4 462.3 392.2 480H183.6C208.5 462.3 224 433.5 224 401.7V400C224 391.2 216.8 384 208 384S192 391.2 192 400v1.742c0 27.61-17.71 52.11-43.92 60.77l-39.51 13.06c-6.352 2.098-11.56 7.186-12.97 13.72C92.98 501.4 102.1 512 113.7 512h347.7C471.7 512 480 503.7 480 493.4C480 485.4 474.9 478.3 467.3 475.8z"],
    "face-weary": [512, 512, [], "e3a1", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 288c-51.95 0-115.3 43.75-123.2 106.8c-1.451 11.45 5.348 21.25 13.49 21.25c1.369 0 2.779-.2773 4.191-.8711C176.4 404 214.9 397.8 256 397.8s79.56 6.25 105.5 17.38c1.406 .5977 2.812 .8789 4.184 .8789c8.076 0 14.95-9.715 13.5-21.25C371.3 331.8 307.1 288 256 288zM256 365.8c-30.71 0-59.55 3.139-84.19 9.006C187.6 342.2 224.7 320 256 320c31.29 0 68.37 22.24 84.18 54.77C315.5 368.9 286.7 365.8 256 365.8zM212.3 164.9c-2.533-2.611-5.709-4.15-9.012-4.666C198.5 159.4 193.4 160.9 189.7 164.5C166.8 186.7 138.6 202.7 107.9 210.8C99.39 213 94.29 221.8 96.53 230.3c2.27 8.545 11.1 13.56 19.54 11.4c35.95-9.439 69.12-28.2 95.89-54.22C218.3 181.3 218.5 171.2 212.3 164.9zM404.1 210.8c-30.67-8.049-58.92-24.04-81.74-46.22c-3.732-3.654-8.83-5.104-13.62-4.355c-3.303 .5156-6.479 2.057-8.98 4.66c-6.193 6.314-6.035 16.44 .3047 22.6c26.75 26.06 59.92 44.82 95.9 54.25c8.559 2.143 17.3-2.861 19.54-11.4S412.6 213 404.1 210.8z"],
    "face-woozy": [512, 512, [], "e3a2", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM118.4 190c34.06-14.88 63.94-38.53 86.38-68.38c5.312-7.062 3.906-17.09-3.156-22.41C198.7 97.03 195.3 96 192 96C187.2 96 182.3 98.22 179.2 102.4C160.1 127.8 134.6 148 105.6 160.7C97.5 164.2 93.81 173.7 97.34 181.8C100.9 189.8 110.4 193.4 118.4 190zM410.8 324.3c-6.438-6-16.56-5.594-22.59 .9062l-30.91 33.5c-17.12 20.12-45.44 23.16-65.84 7.094l-7.875-6.125c-20.19-15.84-46.81-21.09-71.03-13.88l-38.75 11.38c-17.94 5.344-37.03-.625-49.66-15.5c-5.688-6.688-15.75-7.531-22.56-1.812c-6.719 5.719-7.531 15.81-1.812 22.56c20.62 24.25 53.25 34.22 83.06 25.44l38.75-11.38c14.62-4.312 30-1.25 42.28 8.406l7.875 6.125c14.81 11.62 32.09 17.28 49.19 17.28c22.38 0 44.44-9.688 60.31-28.38l30.47-33.03C417.8 340.3 417.3 330.2 410.8 324.3zM335.9 287.9c11.88-.0625 23.09-6 29.59-15.78C380.1 249.1 383.5 226 384 207.4c-.625-18.78-3.281-41.03-18.53-63.72C358.8 133.9 347.7 128 335.9 128c-11.84 .0625-23.03 5.969-29.59 15.81c-15.12 22.5-17.81 44.78-18.47 64.69c.6562 18.84 3.344 41.13 18.53 63.72C313 282.1 324.1 287.9 335.9 287.9zM332.8 161.7C333.7 160.4 334.1 160 335.9 160c0 0-.0313 0 0 0c.9062 0 2.203 .3125 3.109 1.656C349.6 177.5 351.5 193.5 352 207.5c-.4062 14.81-2.25 30.72-13.09 46.84c-.8438 1.281-2.062 1.562-2.938 1.562C336.3 256 333.8 255.7 332.8 254.3c-10.59-15.75-12.53-31.84-13.03-45.78C320.3 193.5 322.3 177.4 332.8 161.7zM140.1 224.5C131.5 226.6 126.3 235.3 128.5 243.9C130.3 251.2 136.8 256 144 256c1.281 0 2.594-.1562 3.875-.4687l64-16c8.594-2.156 13.78-10.84 11.66-19.41c-2.125-8.594-11-13.78-19.41-11.66L140.1 224.5z"],
    "face-worried": [512, 512, [], "e3a3", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-2